// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20827 = arguments.length;
var i__7212__auto___20828 = (0);
while(true){
if((i__7212__auto___20828 < len__7211__auto___20827)){
args__7218__auto__.push((arguments[i__7212__auto___20828]));

var G__20829 = (i__7212__auto___20828 + (1));
i__7212__auto___20828 = G__20829;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((3) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((3)),(0))):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7219__auto__);
});

milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__20825){
var vec__20826 = p__20825;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20826,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0)),cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});

milia.api.rest_services.create.cljs$lang$maxFixedArity = (3);

milia.api.rest_services.create.cljs$lang$applyTo = (function (seq20821){
var G__20822 = cljs.core.first(seq20821);
var seq20821__$1 = cljs.core.next(seq20821);
var G__20823 = cljs.core.first(seq20821__$1);
var seq20821__$2 = cljs.core.next(seq20821__$1);
var G__20824 = cljs.core.first(seq20821__$2);
var seq20821__$3 = cljs.core.next(seq20821__$2);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic(G__20822,G__20823,G__20824,seq20821__$3);
});
/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
