// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17386 = [];
var len__7211__auto___17392 = arguments.length;
var i__7212__auto___17393 = (0);
while(true){
if((i__7212__auto___17393 < len__7211__auto___17392)){
args17386.push((arguments[i__7212__auto___17393]));

var G__17394 = (i__7212__auto___17393 + (1));
i__7212__auto___17393 = G__17394;
continue;
} else {
}
break;
}

var G__17388 = args17386.length;
switch (G__17388) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17386.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17389 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17389 = (function (f,blockable,meta17390){
this.f = f;
this.blockable = blockable;
this.meta17390 = meta17390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17391,meta17390__$1){
var self__ = this;
var _17391__$1 = this;
return (new cljs.core.async.t_cljs$core$async17389(self__.f,self__.blockable,meta17390__$1));
});

cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17391){
var self__ = this;
var _17391__$1 = this;
return self__.meta17390;
});

cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17389.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta17390], null);
});

cljs.core.async.t_cljs$core$async17389.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17389.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17389";

cljs.core.async.t_cljs$core$async17389.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async17389");
});

cljs.core.async.__GT_t_cljs$core$async17389 = (function cljs$core$async$__GT_t_cljs$core$async17389(f__$1,blockable__$1,meta17390){
return (new cljs.core.async.t_cljs$core$async17389(f__$1,blockable__$1,meta17390));
});

}

return (new cljs.core.async.t_cljs$core$async17389(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17398 = [];
var len__7211__auto___17401 = arguments.length;
var i__7212__auto___17402 = (0);
while(true){
if((i__7212__auto___17402 < len__7211__auto___17401)){
args17398.push((arguments[i__7212__auto___17402]));

var G__17403 = (i__7212__auto___17402 + (1));
i__7212__auto___17402 = G__17403;
continue;
} else {
}
break;
}

var G__17400 = args17398.length;
switch (G__17400) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17398.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$buf_DASH_or_DASH_n], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17405 = [];
var len__7211__auto___17408 = arguments.length;
var i__7212__auto___17409 = (0);
while(true){
if((i__7212__auto___17409 < len__7211__auto___17408)){
args17405.push((arguments[i__7212__auto___17409]));

var G__17410 = (i__7212__auto___17409 + (1));
i__7212__auto___17409 = G__17410;
continue;
} else {
}
break;
}

var G__17407 = args17405.length;
switch (G__17407) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17405.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17412 = [];
var len__7211__auto___17415 = arguments.length;
var i__7212__auto___17416 = (0);
while(true){
if((i__7212__auto___17416 < len__7211__auto___17415)){
args17412.push((arguments[i__7212__auto___17416]));

var G__17417 = (i__7212__auto___17416 + (1));
i__7212__auto___17416 = G__17417;
continue;
} else {
}
break;
}

var G__17414 = args17412.length;
switch (G__17414) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17412.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17419 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17419) : fn1.call(null,val_17419));
} else {
cljs.core.async.impl.dispatch.run(((function (val_17419,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17419) : fn1.call(null,val_17419));
});})(val_17419,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17420 = [];
var len__7211__auto___17423 = arguments.length;
var i__7212__auto___17424 = (0);
while(true){
if((i__7212__auto___17424 < len__7211__auto___17423)){
args17420.push((arguments[i__7212__auto___17424]));

var G__17425 = (i__7212__auto___17424 + (1));
i__7212__auto___17424 = G__17425;
continue;
} else {
}
break;
}

var G__17422 = args17420.length;
switch (G__17422) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17420.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7056__auto___17427 = n;
var x_17428 = (0);
while(true){
if((x_17428 < n__7056__auto___17427)){
(a[x_17428] = (0));

var G__17429 = (x_17428 + (1));
x_17428 = G__17429;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__17430 = (i + (1));
i = G__17430;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async17434 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17434 = (function (alt_flag,flag,meta17435){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17435 = meta17435;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17434.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17436,meta17435__$1){
var self__ = this;
var _17436__$1 = this;
return (new cljs.core.async.t_cljs$core$async17434(self__.alt_flag,self__.flag,meta17435__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17434.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17436){
var self__ = this;
var _17436__$1 = this;
return self__.meta17435;
});})(flag))
;

cljs.core.async.t_cljs$core$async17434.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17434.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async17434.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17434.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17434.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta17435], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17434.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17434.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17434";

cljs.core.async.t_cljs$core$async17434.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async17434");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17434 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17434(alt_flag__$1,flag__$1,meta17435){
return (new cljs.core.async.t_cljs$core$async17434(alt_flag__$1,flag__$1,meta17435));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17434(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17440 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17440 = (function (alt_handler,flag,cb,meta17441){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17441 = meta17441;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17440.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17442,meta17441__$1){
var self__ = this;
var _17442__$1 = this;
return (new cljs.core.async.t_cljs$core$async17440(self__.alt_handler,self__.flag,self__.cb,meta17441__$1));
});

cljs.core.async.t_cljs$core$async17440.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17442){
var self__ = this;
var _17442__$1 = this;
return self__.meta17441;
});

cljs.core.async.t_cljs$core$async17440.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17440.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async17440.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17440.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17440.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta17441], null);
});

cljs.core.async.t_cljs$core$async17440.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17440.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17440";

cljs.core.async.t_cljs$core$async17440.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async17440");
});

cljs.core.async.__GT_t_cljs$core$async17440 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17440(alt_handler__$1,flag__$1,cb__$1,meta17441){
return (new cljs.core.async.t_cljs$core$async17440(alt_handler__$1,flag__$1,cb__$1,meta17441));
});

}

return (new cljs.core.async.t_cljs$core$async17440(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17443_SHARP_){
var G__17447 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17443_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17447) : fret.call(null,G__17447));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17444_SHARP_){
var G__17448 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17444_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17448) : fret.call(null,G__17448));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6153__auto__ = wport;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17449 = (i + (1));
i = G__17449;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6153__auto__ = ret;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6141__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6141__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6141__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7218__auto__ = [];
var len__7211__auto___17455 = arguments.length;
var i__7212__auto___17456 = (0);
while(true){
if((i__7212__auto___17456 < len__7211__auto___17455)){
args__7218__auto__.push((arguments[i__7212__auto___17456]));

var G__17457 = (i__7212__auto___17456 + (1));
i__7212__auto___17456 = G__17457;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((1) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7219__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17452){
var map__17453 = p__17452;
var map__17453__$1 = ((((!((map__17453 == null)))?((((map__17453.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17453.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17453):map__17453);
var opts = map__17453__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17450){
var G__17451 = cljs.core.first(seq17450);
var seq17450__$1 = cljs.core.next(seq17450);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17451,seq17450__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17458 = [];
var len__7211__auto___17508 = arguments.length;
var i__7212__auto___17509 = (0);
while(true){
if((i__7212__auto___17509 < len__7211__auto___17508)){
args17458.push((arguments[i__7212__auto___17509]));

var G__17510 = (i__7212__auto___17509 + (1));
i__7212__auto___17509 = G__17510;
continue;
} else {
}
break;
}

var G__17460 = args17458.length;
switch (G__17460) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17458.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__17341__auto___17512 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___17512){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___17512){
return (function (state_17484){
var state_val_17485 = (state_17484[(1)]);
if((state_val_17485 === (7))){
var inst_17480 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
var statearr_17486_17513 = state_17484__$1;
(statearr_17486_17513[(2)] = inst_17480);

(statearr_17486_17513[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (1))){
var state_17484__$1 = state_17484;
var statearr_17487_17514 = state_17484__$1;
(statearr_17487_17514[(2)] = null);

(statearr_17487_17514[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (4))){
var inst_17463 = (state_17484[(7)]);
var inst_17463__$1 = (state_17484[(2)]);
var inst_17464 = (inst_17463__$1 == null);
var state_17484__$1 = (function (){var statearr_17488 = state_17484;
(statearr_17488[(7)] = inst_17463__$1);

return statearr_17488;
})();
if(cljs.core.truth_(inst_17464)){
var statearr_17489_17515 = state_17484__$1;
(statearr_17489_17515[(1)] = (5));

} else {
var statearr_17490_17516 = state_17484__$1;
(statearr_17490_17516[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (13))){
var state_17484__$1 = state_17484;
var statearr_17491_17517 = state_17484__$1;
(statearr_17491_17517[(2)] = null);

(statearr_17491_17517[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (6))){
var inst_17463 = (state_17484[(7)]);
var state_17484__$1 = state_17484;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17484__$1,(11),to,inst_17463);
} else {
if((state_val_17485 === (3))){
var inst_17482 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17484__$1,inst_17482);
} else {
if((state_val_17485 === (12))){
var state_17484__$1 = state_17484;
var statearr_17492_17518 = state_17484__$1;
(statearr_17492_17518[(2)] = null);

(statearr_17492_17518[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (2))){
var state_17484__$1 = state_17484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17484__$1,(4),from);
} else {
if((state_val_17485 === (11))){
var inst_17473 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
if(cljs.core.truth_(inst_17473)){
var statearr_17493_17519 = state_17484__$1;
(statearr_17493_17519[(1)] = (12));

} else {
var statearr_17494_17520 = state_17484__$1;
(statearr_17494_17520[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (9))){
var state_17484__$1 = state_17484;
var statearr_17495_17521 = state_17484__$1;
(statearr_17495_17521[(2)] = null);

(statearr_17495_17521[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (5))){
var state_17484__$1 = state_17484;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17496_17522 = state_17484__$1;
(statearr_17496_17522[(1)] = (8));

} else {
var statearr_17497_17523 = state_17484__$1;
(statearr_17497_17523[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (14))){
var inst_17478 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
var statearr_17498_17524 = state_17484__$1;
(statearr_17498_17524[(2)] = inst_17478);

(statearr_17498_17524[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (10))){
var inst_17470 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
var statearr_17499_17525 = state_17484__$1;
(statearr_17499_17525[(2)] = inst_17470);

(statearr_17499_17525[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17485 === (8))){
var inst_17467 = cljs.core.async.close_BANG_(to);
var state_17484__$1 = state_17484;
var statearr_17500_17526 = state_17484__$1;
(statearr_17500_17526[(2)] = inst_17467);

(statearr_17500_17526[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___17512))
;
return ((function (switch__17227__auto__,c__17341__auto___17512){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_17504 = [null,null,null,null,null,null,null,null];
(statearr_17504[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_17504[(1)] = (1));

return statearr_17504;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_17484){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_17484);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e17505){if((e17505 instanceof Object)){
var ex__17231__auto__ = e17505;
var statearr_17506_17527 = state_17484;
(statearr_17506_17527[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17484);

return cljs.core.cst$kw$recur;
} else {
throw e17505;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__17528 = state_17484;
state_17484 = G__17528;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_17484){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_17484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___17512))
})();
var state__17343__auto__ = (function (){var statearr_17507 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_17507[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___17512);

return statearr_17507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___17512))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$n)], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__17712){
var vec__17713 = p__17712;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17713,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17713,(1),null);
var job = vec__17713;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__17341__auto___17895 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___17895,res,vec__17713,v,p,job,jobs,results){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___17895,res,vec__17713,v,p,job,jobs,results){
return (function (state_17718){
var state_val_17719 = (state_17718[(1)]);
if((state_val_17719 === (1))){
var state_17718__$1 = state_17718;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17718__$1,(2),res,v);
} else {
if((state_val_17719 === (2))){
var inst_17715 = (state_17718[(2)]);
var inst_17716 = cljs.core.async.close_BANG_(res);
var state_17718__$1 = (function (){var statearr_17720 = state_17718;
(statearr_17720[(7)] = inst_17715);

return statearr_17720;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17718__$1,inst_17716);
} else {
return null;
}
}
});})(c__17341__auto___17895,res,vec__17713,v,p,job,jobs,results))
;
return ((function (switch__17227__auto__,c__17341__auto___17895,res,vec__17713,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0 = (function (){
var statearr_17724 = [null,null,null,null,null,null,null,null];
(statearr_17724[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__);

(statearr_17724[(1)] = (1));

return statearr_17724;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1 = (function (state_17718){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_17718);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e17725){if((e17725 instanceof Object)){
var ex__17231__auto__ = e17725;
var statearr_17726_17896 = state_17718;
(statearr_17726_17896[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17718);

return cljs.core.cst$kw$recur;
} else {
throw e17725;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__17897 = state_17718;
state_17718 = G__17897;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = function(state_17718){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1.call(this,state_17718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___17895,res,vec__17713,v,p,job,jobs,results))
})();
var state__17343__auto__ = (function (){var statearr_17727 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_17727[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___17895);

return statearr_17727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___17895,res,vec__17713,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17728){
var vec__17729 = p__17728;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17729,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17729,(1),null);
var job = vec__17729;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7056__auto___17898 = n;
var __17899 = (0);
while(true){
if((__17899 < n__7056__auto___17898)){
var G__17730_17900 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17730_17900) {
case "compute":
var c__17341__auto___17902 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17899,c__17341__auto___17902,G__17730_17900,n__7056__auto___17898,jobs,results,process,async){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (__17899,c__17341__auto___17902,G__17730_17900,n__7056__auto___17898,jobs,results,process,async){
return (function (state_17743){
var state_val_17744 = (state_17743[(1)]);
if((state_val_17744 === (1))){
var state_17743__$1 = state_17743;
var statearr_17745_17903 = state_17743__$1;
(statearr_17745_17903[(2)] = null);

(statearr_17745_17903[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17744 === (2))){
var state_17743__$1 = state_17743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17743__$1,(4),jobs);
} else {
if((state_val_17744 === (3))){
var inst_17741 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17743__$1,inst_17741);
} else {
if((state_val_17744 === (4))){
var inst_17733 = (state_17743[(2)]);
var inst_17734 = process(inst_17733);
var state_17743__$1 = state_17743;
if(cljs.core.truth_(inst_17734)){
var statearr_17746_17904 = state_17743__$1;
(statearr_17746_17904[(1)] = (5));

} else {
var statearr_17747_17905 = state_17743__$1;
(statearr_17747_17905[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17744 === (5))){
var state_17743__$1 = state_17743;
var statearr_17748_17906 = state_17743__$1;
(statearr_17748_17906[(2)] = null);

(statearr_17748_17906[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17744 === (6))){
var state_17743__$1 = state_17743;
var statearr_17749_17907 = state_17743__$1;
(statearr_17749_17907[(2)] = null);

(statearr_17749_17907[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17744 === (7))){
var inst_17739 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
var statearr_17750_17908 = state_17743__$1;
(statearr_17750_17908[(2)] = inst_17739);

(statearr_17750_17908[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17899,c__17341__auto___17902,G__17730_17900,n__7056__auto___17898,jobs,results,process,async))
;
return ((function (__17899,switch__17227__auto__,c__17341__auto___17902,G__17730_17900,n__7056__auto___17898,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0 = (function (){
var statearr_17754 = [null,null,null,null,null,null,null];
(statearr_17754[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__);

(statearr_17754[(1)] = (1));

return statearr_17754;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1 = (function (state_17743){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_17743);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e17755){if((e17755 instanceof Object)){
var ex__17231__auto__ = e17755;
var statearr_17756_17909 = state_17743;
(statearr_17756_17909[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17743);

return cljs.core.cst$kw$recur;
} else {
throw e17755;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__17910 = state_17743;
state_17743 = G__17910;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = function(state_17743){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1.call(this,state_17743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__;
})()
;})(__17899,switch__17227__auto__,c__17341__auto___17902,G__17730_17900,n__7056__auto___17898,jobs,results,process,async))
})();
var state__17343__auto__ = (function (){var statearr_17757 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_17757[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___17902);

return statearr_17757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(__17899,c__17341__auto___17902,G__17730_17900,n__7056__auto___17898,jobs,results,process,async))
);


break;
case "async":
var c__17341__auto___17911 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17899,c__17341__auto___17911,G__17730_17900,n__7056__auto___17898,jobs,results,process,async){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (__17899,c__17341__auto___17911,G__17730_17900,n__7056__auto___17898,jobs,results,process,async){
return (function (state_17770){
var state_val_17771 = (state_17770[(1)]);
if((state_val_17771 === (1))){
var state_17770__$1 = state_17770;
var statearr_17772_17912 = state_17770__$1;
(statearr_17772_17912[(2)] = null);

(statearr_17772_17912[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17771 === (2))){
var state_17770__$1 = state_17770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17770__$1,(4),jobs);
} else {
if((state_val_17771 === (3))){
var inst_17768 = (state_17770[(2)]);
var state_17770__$1 = state_17770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17770__$1,inst_17768);
} else {
if((state_val_17771 === (4))){
var inst_17760 = (state_17770[(2)]);
var inst_17761 = async(inst_17760);
var state_17770__$1 = state_17770;
if(cljs.core.truth_(inst_17761)){
var statearr_17773_17913 = state_17770__$1;
(statearr_17773_17913[(1)] = (5));

} else {
var statearr_17774_17914 = state_17770__$1;
(statearr_17774_17914[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17771 === (5))){
var state_17770__$1 = state_17770;
var statearr_17775_17915 = state_17770__$1;
(statearr_17775_17915[(2)] = null);

(statearr_17775_17915[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17771 === (6))){
var state_17770__$1 = state_17770;
var statearr_17776_17916 = state_17770__$1;
(statearr_17776_17916[(2)] = null);

(statearr_17776_17916[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17771 === (7))){
var inst_17766 = (state_17770[(2)]);
var state_17770__$1 = state_17770;
var statearr_17777_17917 = state_17770__$1;
(statearr_17777_17917[(2)] = inst_17766);

(statearr_17777_17917[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17899,c__17341__auto___17911,G__17730_17900,n__7056__auto___17898,jobs,results,process,async))
;
return ((function (__17899,switch__17227__auto__,c__17341__auto___17911,G__17730_17900,n__7056__auto___17898,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0 = (function (){
var statearr_17781 = [null,null,null,null,null,null,null];
(statearr_17781[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__);

(statearr_17781[(1)] = (1));

return statearr_17781;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1 = (function (state_17770){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_17770);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e17782){if((e17782 instanceof Object)){
var ex__17231__auto__ = e17782;
var statearr_17783_17918 = state_17770;
(statearr_17783_17918[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17770);

return cljs.core.cst$kw$recur;
} else {
throw e17782;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__17919 = state_17770;
state_17770 = G__17919;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = function(state_17770){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1.call(this,state_17770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__;
})()
;})(__17899,switch__17227__auto__,c__17341__auto___17911,G__17730_17900,n__7056__auto___17898,jobs,results,process,async))
})();
var state__17343__auto__ = (function (){var statearr_17784 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_17784[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___17911);

return statearr_17784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(__17899,c__17341__auto___17911,G__17730_17900,n__7056__auto___17898,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17920 = (__17899 + (1));
__17899 = G__17920;
continue;
} else {
}
break;
}

var c__17341__auto___17921 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___17921,jobs,results,process,async){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___17921,jobs,results,process,async){
return (function (state_17806){
var state_val_17807 = (state_17806[(1)]);
if((state_val_17807 === (1))){
var state_17806__$1 = state_17806;
var statearr_17808_17922 = state_17806__$1;
(statearr_17808_17922[(2)] = null);

(statearr_17808_17922[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17807 === (2))){
var state_17806__$1 = state_17806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17806__$1,(4),from);
} else {
if((state_val_17807 === (3))){
var inst_17804 = (state_17806[(2)]);
var state_17806__$1 = state_17806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17806__$1,inst_17804);
} else {
if((state_val_17807 === (4))){
var inst_17787 = (state_17806[(7)]);
var inst_17787__$1 = (state_17806[(2)]);
var inst_17788 = (inst_17787__$1 == null);
var state_17806__$1 = (function (){var statearr_17809 = state_17806;
(statearr_17809[(7)] = inst_17787__$1);

return statearr_17809;
})();
if(cljs.core.truth_(inst_17788)){
var statearr_17810_17923 = state_17806__$1;
(statearr_17810_17923[(1)] = (5));

} else {
var statearr_17811_17924 = state_17806__$1;
(statearr_17811_17924[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17807 === (5))){
var inst_17790 = cljs.core.async.close_BANG_(jobs);
var state_17806__$1 = state_17806;
var statearr_17812_17925 = state_17806__$1;
(statearr_17812_17925[(2)] = inst_17790);

(statearr_17812_17925[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17807 === (6))){
var inst_17787 = (state_17806[(7)]);
var inst_17792 = (state_17806[(8)]);
var inst_17792__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17794 = [inst_17787,inst_17792__$1];
var inst_17795 = (new cljs.core.PersistentVector(null,2,(5),inst_17793,inst_17794,null));
var state_17806__$1 = (function (){var statearr_17813 = state_17806;
(statearr_17813[(8)] = inst_17792__$1);

return statearr_17813;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17806__$1,(8),jobs,inst_17795);
} else {
if((state_val_17807 === (7))){
var inst_17802 = (state_17806[(2)]);
var state_17806__$1 = state_17806;
var statearr_17814_17926 = state_17806__$1;
(statearr_17814_17926[(2)] = inst_17802);

(statearr_17814_17926[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17807 === (8))){
var inst_17792 = (state_17806[(8)]);
var inst_17797 = (state_17806[(2)]);
var state_17806__$1 = (function (){var statearr_17815 = state_17806;
(statearr_17815[(9)] = inst_17797);

return statearr_17815;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17806__$1,(9),results,inst_17792);
} else {
if((state_val_17807 === (9))){
var inst_17799 = (state_17806[(2)]);
var state_17806__$1 = (function (){var statearr_17816 = state_17806;
(statearr_17816[(10)] = inst_17799);

return statearr_17816;
})();
var statearr_17817_17927 = state_17806__$1;
(statearr_17817_17927[(2)] = null);

(statearr_17817_17927[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___17921,jobs,results,process,async))
;
return ((function (switch__17227__auto__,c__17341__auto___17921,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0 = (function (){
var statearr_17821 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17821[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__);

(statearr_17821[(1)] = (1));

return statearr_17821;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1 = (function (state_17806){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_17806);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e17822){if((e17822 instanceof Object)){
var ex__17231__auto__ = e17822;
var statearr_17823_17928 = state_17806;
(statearr_17823_17928[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17806);

return cljs.core.cst$kw$recur;
} else {
throw e17822;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__17929 = state_17806;
state_17806 = G__17929;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = function(state_17806){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1.call(this,state_17806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___17921,jobs,results,process,async))
})();
var state__17343__auto__ = (function (){var statearr_17824 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_17824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___17921);

return statearr_17824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___17921,jobs,results,process,async))
);


var c__17341__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto__,jobs,results,process,async){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto__,jobs,results,process,async){
return (function (state_17862){
var state_val_17863 = (state_17862[(1)]);
if((state_val_17863 === (7))){
var inst_17858 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
var statearr_17864_17930 = state_17862__$1;
(statearr_17864_17930[(2)] = inst_17858);

(statearr_17864_17930[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (20))){
var state_17862__$1 = state_17862;
var statearr_17865_17931 = state_17862__$1;
(statearr_17865_17931[(2)] = null);

(statearr_17865_17931[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (1))){
var state_17862__$1 = state_17862;
var statearr_17866_17932 = state_17862__$1;
(statearr_17866_17932[(2)] = null);

(statearr_17866_17932[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (4))){
var inst_17827 = (state_17862[(7)]);
var inst_17827__$1 = (state_17862[(2)]);
var inst_17828 = (inst_17827__$1 == null);
var state_17862__$1 = (function (){var statearr_17867 = state_17862;
(statearr_17867[(7)] = inst_17827__$1);

return statearr_17867;
})();
if(cljs.core.truth_(inst_17828)){
var statearr_17868_17933 = state_17862__$1;
(statearr_17868_17933[(1)] = (5));

} else {
var statearr_17869_17934 = state_17862__$1;
(statearr_17869_17934[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (15))){
var inst_17840 = (state_17862[(8)]);
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17862__$1,(18),to,inst_17840);
} else {
if((state_val_17863 === (21))){
var inst_17853 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
var statearr_17870_17935 = state_17862__$1;
(statearr_17870_17935[(2)] = inst_17853);

(statearr_17870_17935[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (13))){
var inst_17855 = (state_17862[(2)]);
var state_17862__$1 = (function (){var statearr_17871 = state_17862;
(statearr_17871[(9)] = inst_17855);

return statearr_17871;
})();
var statearr_17872_17936 = state_17862__$1;
(statearr_17872_17936[(2)] = null);

(statearr_17872_17936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (6))){
var inst_17827 = (state_17862[(7)]);
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17862__$1,(11),inst_17827);
} else {
if((state_val_17863 === (17))){
var inst_17848 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
if(cljs.core.truth_(inst_17848)){
var statearr_17873_17937 = state_17862__$1;
(statearr_17873_17937[(1)] = (19));

} else {
var statearr_17874_17938 = state_17862__$1;
(statearr_17874_17938[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (3))){
var inst_17860 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17862__$1,inst_17860);
} else {
if((state_val_17863 === (12))){
var inst_17837 = (state_17862[(10)]);
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17862__$1,(14),inst_17837);
} else {
if((state_val_17863 === (2))){
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17862__$1,(4),results);
} else {
if((state_val_17863 === (19))){
var state_17862__$1 = state_17862;
var statearr_17875_17939 = state_17862__$1;
(statearr_17875_17939[(2)] = null);

(statearr_17875_17939[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (11))){
var inst_17837 = (state_17862[(2)]);
var state_17862__$1 = (function (){var statearr_17876 = state_17862;
(statearr_17876[(10)] = inst_17837);

return statearr_17876;
})();
var statearr_17877_17940 = state_17862__$1;
(statearr_17877_17940[(2)] = null);

(statearr_17877_17940[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (9))){
var state_17862__$1 = state_17862;
var statearr_17878_17941 = state_17862__$1;
(statearr_17878_17941[(2)] = null);

(statearr_17878_17941[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (5))){
var state_17862__$1 = state_17862;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17879_17942 = state_17862__$1;
(statearr_17879_17942[(1)] = (8));

} else {
var statearr_17880_17943 = state_17862__$1;
(statearr_17880_17943[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (14))){
var inst_17842 = (state_17862[(11)]);
var inst_17840 = (state_17862[(8)]);
var inst_17840__$1 = (state_17862[(2)]);
var inst_17841 = (inst_17840__$1 == null);
var inst_17842__$1 = cljs.core.not(inst_17841);
var state_17862__$1 = (function (){var statearr_17881 = state_17862;
(statearr_17881[(11)] = inst_17842__$1);

(statearr_17881[(8)] = inst_17840__$1);

return statearr_17881;
})();
if(inst_17842__$1){
var statearr_17882_17944 = state_17862__$1;
(statearr_17882_17944[(1)] = (15));

} else {
var statearr_17883_17945 = state_17862__$1;
(statearr_17883_17945[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (16))){
var inst_17842 = (state_17862[(11)]);
var state_17862__$1 = state_17862;
var statearr_17884_17946 = state_17862__$1;
(statearr_17884_17946[(2)] = inst_17842);

(statearr_17884_17946[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (10))){
var inst_17834 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
var statearr_17885_17947 = state_17862__$1;
(statearr_17885_17947[(2)] = inst_17834);

(statearr_17885_17947[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (18))){
var inst_17845 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
var statearr_17886_17948 = state_17862__$1;
(statearr_17886_17948[(2)] = inst_17845);

(statearr_17886_17948[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17863 === (8))){
var inst_17831 = cljs.core.async.close_BANG_(to);
var state_17862__$1 = state_17862;
var statearr_17887_17949 = state_17862__$1;
(statearr_17887_17949[(2)] = inst_17831);

(statearr_17887_17949[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto__,jobs,results,process,async))
;
return ((function (switch__17227__auto__,c__17341__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0 = (function (){
var statearr_17891 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17891[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__);

(statearr_17891[(1)] = (1));

return statearr_17891;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1 = (function (state_17862){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_17862);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e17892){if((e17892 instanceof Object)){
var ex__17231__auto__ = e17892;
var statearr_17893_17950 = state_17862;
(statearr_17893_17950[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17862);

return cljs.core.cst$kw$recur;
} else {
throw e17892;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__17951 = state_17862;
state_17862 = G__17951;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__ = function(state_17862){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1.call(this,state_17862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17228__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto__,jobs,results,process,async))
})();
var state__17343__auto__ = (function (){var statearr_17894 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_17894[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto__);

return statearr_17894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto__,jobs,results,process,async))
);

return c__17341__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17952 = [];
var len__7211__auto___17955 = arguments.length;
var i__7212__auto___17956 = (0);
while(true){
if((i__7212__auto___17956 < len__7211__auto___17955)){
args17952.push((arguments[i__7212__auto___17956]));

var G__17957 = (i__7212__auto___17956 + (1));
i__7212__auto___17956 = G__17957;
continue;
} else {
}
break;
}

var G__17954 = args17952.length;
switch (G__17954) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17952.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17959 = [];
var len__7211__auto___17962 = arguments.length;
var i__7212__auto___17963 = (0);
while(true){
if((i__7212__auto___17963 < len__7211__auto___17962)){
args17959.push((arguments[i__7212__auto___17963]));

var G__17964 = (i__7212__auto___17963 + (1));
i__7212__auto___17963 = G__17964;
continue;
} else {
}
break;
}

var G__17961 = args17959.length;
switch (G__17961) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17959.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17966 = [];
var len__7211__auto___18019 = arguments.length;
var i__7212__auto___18020 = (0);
while(true){
if((i__7212__auto___18020 < len__7211__auto___18019)){
args17966.push((arguments[i__7212__auto___18020]));

var G__18021 = (i__7212__auto___18020 + (1));
i__7212__auto___18020 = G__18021;
continue;
} else {
}
break;
}

var G__17968 = args17966.length;
switch (G__17968) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17966.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__17341__auto___18023 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___18023,tc,fc){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___18023,tc,fc){
return (function (state_17994){
var state_val_17995 = (state_17994[(1)]);
if((state_val_17995 === (7))){
var inst_17990 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
var statearr_17996_18024 = state_17994__$1;
(statearr_17996_18024[(2)] = inst_17990);

(statearr_17996_18024[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (1))){
var state_17994__$1 = state_17994;
var statearr_17997_18025 = state_17994__$1;
(statearr_17997_18025[(2)] = null);

(statearr_17997_18025[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (4))){
var inst_17971 = (state_17994[(7)]);
var inst_17971__$1 = (state_17994[(2)]);
var inst_17972 = (inst_17971__$1 == null);
var state_17994__$1 = (function (){var statearr_17998 = state_17994;
(statearr_17998[(7)] = inst_17971__$1);

return statearr_17998;
})();
if(cljs.core.truth_(inst_17972)){
var statearr_17999_18026 = state_17994__$1;
(statearr_17999_18026[(1)] = (5));

} else {
var statearr_18000_18027 = state_17994__$1;
(statearr_18000_18027[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (13))){
var state_17994__$1 = state_17994;
var statearr_18001_18028 = state_17994__$1;
(statearr_18001_18028[(2)] = null);

(statearr_18001_18028[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (6))){
var inst_17971 = (state_17994[(7)]);
var inst_17977 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17971) : p.call(null,inst_17971));
var state_17994__$1 = state_17994;
if(cljs.core.truth_(inst_17977)){
var statearr_18002_18029 = state_17994__$1;
(statearr_18002_18029[(1)] = (9));

} else {
var statearr_18003_18030 = state_17994__$1;
(statearr_18003_18030[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (3))){
var inst_17992 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17994__$1,inst_17992);
} else {
if((state_val_17995 === (12))){
var state_17994__$1 = state_17994;
var statearr_18004_18031 = state_17994__$1;
(statearr_18004_18031[(2)] = null);

(statearr_18004_18031[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (2))){
var state_17994__$1 = state_17994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17994__$1,(4),ch);
} else {
if((state_val_17995 === (11))){
var inst_17971 = (state_17994[(7)]);
var inst_17981 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17994__$1,(8),inst_17981,inst_17971);
} else {
if((state_val_17995 === (9))){
var state_17994__$1 = state_17994;
var statearr_18005_18032 = state_17994__$1;
(statearr_18005_18032[(2)] = tc);

(statearr_18005_18032[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (5))){
var inst_17974 = cljs.core.async.close_BANG_(tc);
var inst_17975 = cljs.core.async.close_BANG_(fc);
var state_17994__$1 = (function (){var statearr_18006 = state_17994;
(statearr_18006[(8)] = inst_17974);

return statearr_18006;
})();
var statearr_18007_18033 = state_17994__$1;
(statearr_18007_18033[(2)] = inst_17975);

(statearr_18007_18033[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (14))){
var inst_17988 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
var statearr_18008_18034 = state_17994__$1;
(statearr_18008_18034[(2)] = inst_17988);

(statearr_18008_18034[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (10))){
var state_17994__$1 = state_17994;
var statearr_18009_18035 = state_17994__$1;
(statearr_18009_18035[(2)] = fc);

(statearr_18009_18035[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17995 === (8))){
var inst_17983 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
if(cljs.core.truth_(inst_17983)){
var statearr_18010_18036 = state_17994__$1;
(statearr_18010_18036[(1)] = (12));

} else {
var statearr_18011_18037 = state_17994__$1;
(statearr_18011_18037[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___18023,tc,fc))
;
return ((function (switch__17227__auto__,c__17341__auto___18023,tc,fc){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_18015 = [null,null,null,null,null,null,null,null,null];
(statearr_18015[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_18015[(1)] = (1));

return statearr_18015;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_17994){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_17994);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e18016){if((e18016 instanceof Object)){
var ex__17231__auto__ = e18016;
var statearr_18017_18038 = state_17994;
(statearr_18017_18038[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17994);

return cljs.core.cst$kw$recur;
} else {
throw e18016;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__18039 = state_17994;
state_17994 = G__18039;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_17994){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_17994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___18023,tc,fc))
})();
var state__17343__auto__ = (function (){var statearr_18018 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_18018[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___18023);

return statearr_18018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___18023,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__17341__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto__){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto__){
return (function (state_18103){
var state_val_18104 = (state_18103[(1)]);
if((state_val_18104 === (7))){
var inst_18099 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
var statearr_18105_18126 = state_18103__$1;
(statearr_18105_18126[(2)] = inst_18099);

(statearr_18105_18126[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18104 === (1))){
var inst_18083 = init;
var state_18103__$1 = (function (){var statearr_18106 = state_18103;
(statearr_18106[(7)] = inst_18083);

return statearr_18106;
})();
var statearr_18107_18127 = state_18103__$1;
(statearr_18107_18127[(2)] = null);

(statearr_18107_18127[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18104 === (4))){
var inst_18086 = (state_18103[(8)]);
var inst_18086__$1 = (state_18103[(2)]);
var inst_18087 = (inst_18086__$1 == null);
var state_18103__$1 = (function (){var statearr_18108 = state_18103;
(statearr_18108[(8)] = inst_18086__$1);

return statearr_18108;
})();
if(cljs.core.truth_(inst_18087)){
var statearr_18109_18128 = state_18103__$1;
(statearr_18109_18128[(1)] = (5));

} else {
var statearr_18110_18129 = state_18103__$1;
(statearr_18110_18129[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18104 === (6))){
var inst_18090 = (state_18103[(9)]);
var inst_18083 = (state_18103[(7)]);
var inst_18086 = (state_18103[(8)]);
var inst_18090__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_18083,inst_18086) : f.call(null,inst_18083,inst_18086));
var inst_18091 = cljs.core.reduced_QMARK_(inst_18090__$1);
var state_18103__$1 = (function (){var statearr_18111 = state_18103;
(statearr_18111[(9)] = inst_18090__$1);

return statearr_18111;
})();
if(inst_18091){
var statearr_18112_18130 = state_18103__$1;
(statearr_18112_18130[(1)] = (8));

} else {
var statearr_18113_18131 = state_18103__$1;
(statearr_18113_18131[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18104 === (3))){
var inst_18101 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18103__$1,inst_18101);
} else {
if((state_val_18104 === (2))){
var state_18103__$1 = state_18103;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18103__$1,(4),ch);
} else {
if((state_val_18104 === (9))){
var inst_18090 = (state_18103[(9)]);
var inst_18083 = inst_18090;
var state_18103__$1 = (function (){var statearr_18114 = state_18103;
(statearr_18114[(7)] = inst_18083);

return statearr_18114;
})();
var statearr_18115_18132 = state_18103__$1;
(statearr_18115_18132[(2)] = null);

(statearr_18115_18132[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18104 === (5))){
var inst_18083 = (state_18103[(7)]);
var state_18103__$1 = state_18103;
var statearr_18116_18133 = state_18103__$1;
(statearr_18116_18133[(2)] = inst_18083);

(statearr_18116_18133[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18104 === (10))){
var inst_18097 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
var statearr_18117_18134 = state_18103__$1;
(statearr_18117_18134[(2)] = inst_18097);

(statearr_18117_18134[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18104 === (8))){
var inst_18090 = (state_18103[(9)]);
var inst_18093 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_18090) : cljs.core.deref.call(null,inst_18090));
var state_18103__$1 = state_18103;
var statearr_18118_18135 = state_18103__$1;
(statearr_18118_18135[(2)] = inst_18093);

(statearr_18118_18135[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto__))
;
return ((function (switch__17227__auto__,c__17341__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__17228__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17228__auto____0 = (function (){
var statearr_18122 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18122[(0)] = cljs$core$async$reduce_$_state_machine__17228__auto__);

(statearr_18122[(1)] = (1));

return statearr_18122;
});
var cljs$core$async$reduce_$_state_machine__17228__auto____1 = (function (state_18103){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_18103);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e18123){if((e18123 instanceof Object)){
var ex__17231__auto__ = e18123;
var statearr_18124_18136 = state_18103;
(statearr_18124_18136[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18103);

return cljs.core.cst$kw$recur;
} else {
throw e18123;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__18137 = state_18103;
state_18103 = G__18137;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17228__auto__ = function(state_18103){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17228__auto____1.call(this,state_18103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17228__auto____0;
cljs$core$async$reduce_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17228__auto____1;
return cljs$core$async$reduce_$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto__))
})();
var state__17343__auto__ = (function (){var statearr_18125 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_18125[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto__);

return statearr_18125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto__))
);

return c__17341__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18138 = [];
var len__7211__auto___18190 = arguments.length;
var i__7212__auto___18191 = (0);
while(true){
if((i__7212__auto___18191 < len__7211__auto___18190)){
args18138.push((arguments[i__7212__auto___18191]));

var G__18192 = (i__7212__auto___18191 + (1));
i__7212__auto___18191 = G__18192;
continue;
} else {
}
break;
}

var G__18140 = args18138.length;
switch (G__18140) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18138.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__17341__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto__){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto__){
return (function (state_18165){
var state_val_18166 = (state_18165[(1)]);
if((state_val_18166 === (7))){
var inst_18147 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
var statearr_18167_18194 = state_18165__$1;
(statearr_18167_18194[(2)] = inst_18147);

(statearr_18167_18194[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (1))){
var inst_18141 = cljs.core.seq(coll);
var inst_18142 = inst_18141;
var state_18165__$1 = (function (){var statearr_18168 = state_18165;
(statearr_18168[(7)] = inst_18142);

return statearr_18168;
})();
var statearr_18169_18195 = state_18165__$1;
(statearr_18169_18195[(2)] = null);

(statearr_18169_18195[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (4))){
var inst_18142 = (state_18165[(7)]);
var inst_18145 = cljs.core.first(inst_18142);
var state_18165__$1 = state_18165;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18165__$1,(7),ch,inst_18145);
} else {
if((state_val_18166 === (13))){
var inst_18159 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
var statearr_18170_18196 = state_18165__$1;
(statearr_18170_18196[(2)] = inst_18159);

(statearr_18170_18196[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (6))){
var inst_18150 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
if(cljs.core.truth_(inst_18150)){
var statearr_18171_18197 = state_18165__$1;
(statearr_18171_18197[(1)] = (8));

} else {
var statearr_18172_18198 = state_18165__$1;
(statearr_18172_18198[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (3))){
var inst_18163 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18165__$1,inst_18163);
} else {
if((state_val_18166 === (12))){
var state_18165__$1 = state_18165;
var statearr_18173_18199 = state_18165__$1;
(statearr_18173_18199[(2)] = null);

(statearr_18173_18199[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (2))){
var inst_18142 = (state_18165[(7)]);
var state_18165__$1 = state_18165;
if(cljs.core.truth_(inst_18142)){
var statearr_18174_18200 = state_18165__$1;
(statearr_18174_18200[(1)] = (4));

} else {
var statearr_18175_18201 = state_18165__$1;
(statearr_18175_18201[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (11))){
var inst_18156 = cljs.core.async.close_BANG_(ch);
var state_18165__$1 = state_18165;
var statearr_18176_18202 = state_18165__$1;
(statearr_18176_18202[(2)] = inst_18156);

(statearr_18176_18202[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (9))){
var state_18165__$1 = state_18165;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18177_18203 = state_18165__$1;
(statearr_18177_18203[(1)] = (11));

} else {
var statearr_18178_18204 = state_18165__$1;
(statearr_18178_18204[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (5))){
var inst_18142 = (state_18165[(7)]);
var state_18165__$1 = state_18165;
var statearr_18179_18205 = state_18165__$1;
(statearr_18179_18205[(2)] = inst_18142);

(statearr_18179_18205[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (10))){
var inst_18161 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
var statearr_18180_18206 = state_18165__$1;
(statearr_18180_18206[(2)] = inst_18161);

(statearr_18180_18206[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18166 === (8))){
var inst_18142 = (state_18165[(7)]);
var inst_18152 = cljs.core.next(inst_18142);
var inst_18142__$1 = inst_18152;
var state_18165__$1 = (function (){var statearr_18181 = state_18165;
(statearr_18181[(7)] = inst_18142__$1);

return statearr_18181;
})();
var statearr_18182_18207 = state_18165__$1;
(statearr_18182_18207[(2)] = null);

(statearr_18182_18207[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto__))
;
return ((function (switch__17227__auto__,c__17341__auto__){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_18186 = [null,null,null,null,null,null,null,null];
(statearr_18186[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_18186[(1)] = (1));

return statearr_18186;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_18165){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_18165);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e18187){if((e18187 instanceof Object)){
var ex__17231__auto__ = e18187;
var statearr_18188_18208 = state_18165;
(statearr_18188_18208[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18165);

return cljs.core.cst$kw$recur;
} else {
throw e18187;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__18209 = state_18165;
state_18165 = G__18209;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_18165){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_18165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto__))
})();
var state__17343__auto__ = (function (){var statearr_18189 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_18189[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto__);

return statearr_18189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto__))
);

return c__17341__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6808__auto__ = (((_ == null))?null:_);
var m__6809__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__6809__auto__.call(null,_));
} else {
var m__6809__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__6809__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6809__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__6809__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6809__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto__.call(null,m,ch));
} else {
var m__6809__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6809__auto__.call(null,m));
} else {
var m__6809__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6809__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__18434 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__18434) : cljs.core.atom.call(null,G__18434));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18435 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18435 = (function (mult,ch,cs,meta18436){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18436 = meta18436;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18435.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18437,meta18436__$1){
var self__ = this;
var _18437__$1 = this;
return (new cljs.core.async.t_cljs$core$async18435(self__.mult,self__.ch,self__.cs,meta18436__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18435.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18437){
var self__ = this;
var _18437__$1 = this;
return self__.meta18436;
});})(cs))
;

cljs.core.async.t_cljs$core$async18435.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18435.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18435.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18435.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18435.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18435.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__18438_18658 = self__.cs;
var G__18439_18659 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__18438_18658,G__18439_18659) : cljs.core.reset_BANG_.call(null,G__18438_18658,G__18439_18659));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18435.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta18436], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18435.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18435.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18435";

cljs.core.async.t_cljs$core$async18435.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async18435");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18435 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18435(mult__$1,ch__$1,cs__$1,meta18436){
return (new cljs.core.async.t_cljs$core$async18435(mult__$1,ch__$1,cs__$1,meta18436));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18435(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__17341__auto___18660 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___18660,cs,m,dchan,dctr,done){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___18660,cs,m,dchan,dctr,done){
return (function (state_18570){
var state_val_18571 = (state_18570[(1)]);
if((state_val_18571 === (7))){
var inst_18566 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18572_18661 = state_18570__$1;
(statearr_18572_18661[(2)] = inst_18566);

(statearr_18572_18661[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (20))){
var inst_18471 = (state_18570[(7)]);
var inst_18481 = cljs.core.first(inst_18471);
var inst_18482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18481,(0),null);
var inst_18483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18481,(1),null);
var state_18570__$1 = (function (){var statearr_18573 = state_18570;
(statearr_18573[(8)] = inst_18482);

return statearr_18573;
})();
if(cljs.core.truth_(inst_18483)){
var statearr_18574_18662 = state_18570__$1;
(statearr_18574_18662[(1)] = (22));

} else {
var statearr_18575_18663 = state_18570__$1;
(statearr_18575_18663[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (27))){
var inst_18511 = (state_18570[(9)]);
var inst_18442 = (state_18570[(10)]);
var inst_18513 = (state_18570[(11)]);
var inst_18518 = (state_18570[(12)]);
var inst_18518__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18511,inst_18513);
var inst_18519 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18518__$1,inst_18442,done);
var state_18570__$1 = (function (){var statearr_18576 = state_18570;
(statearr_18576[(12)] = inst_18518__$1);

return statearr_18576;
})();
if(cljs.core.truth_(inst_18519)){
var statearr_18577_18664 = state_18570__$1;
(statearr_18577_18664[(1)] = (30));

} else {
var statearr_18578_18665 = state_18570__$1;
(statearr_18578_18665[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (1))){
var state_18570__$1 = state_18570;
var statearr_18579_18666 = state_18570__$1;
(statearr_18579_18666[(2)] = null);

(statearr_18579_18666[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (24))){
var inst_18471 = (state_18570[(7)]);
var inst_18488 = (state_18570[(2)]);
var inst_18489 = cljs.core.next(inst_18471);
var inst_18451 = inst_18489;
var inst_18452 = null;
var inst_18453 = (0);
var inst_18454 = (0);
var state_18570__$1 = (function (){var statearr_18580 = state_18570;
(statearr_18580[(13)] = inst_18452);

(statearr_18580[(14)] = inst_18453);

(statearr_18580[(15)] = inst_18451);

(statearr_18580[(16)] = inst_18488);

(statearr_18580[(17)] = inst_18454);

return statearr_18580;
})();
var statearr_18581_18667 = state_18570__$1;
(statearr_18581_18667[(2)] = null);

(statearr_18581_18667[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (39))){
var state_18570__$1 = state_18570;
var statearr_18585_18668 = state_18570__$1;
(statearr_18585_18668[(2)] = null);

(statearr_18585_18668[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (4))){
var inst_18442 = (state_18570[(10)]);
var inst_18442__$1 = (state_18570[(2)]);
var inst_18443 = (inst_18442__$1 == null);
var state_18570__$1 = (function (){var statearr_18586 = state_18570;
(statearr_18586[(10)] = inst_18442__$1);

return statearr_18586;
})();
if(cljs.core.truth_(inst_18443)){
var statearr_18587_18669 = state_18570__$1;
(statearr_18587_18669[(1)] = (5));

} else {
var statearr_18588_18670 = state_18570__$1;
(statearr_18588_18670[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (15))){
var inst_18452 = (state_18570[(13)]);
var inst_18453 = (state_18570[(14)]);
var inst_18451 = (state_18570[(15)]);
var inst_18454 = (state_18570[(17)]);
var inst_18467 = (state_18570[(2)]);
var inst_18468 = (inst_18454 + (1));
var tmp18582 = inst_18452;
var tmp18583 = inst_18453;
var tmp18584 = inst_18451;
var inst_18451__$1 = tmp18584;
var inst_18452__$1 = tmp18582;
var inst_18453__$1 = tmp18583;
var inst_18454__$1 = inst_18468;
var state_18570__$1 = (function (){var statearr_18589 = state_18570;
(statearr_18589[(13)] = inst_18452__$1);

(statearr_18589[(14)] = inst_18453__$1);

(statearr_18589[(15)] = inst_18451__$1);

(statearr_18589[(18)] = inst_18467);

(statearr_18589[(17)] = inst_18454__$1);

return statearr_18589;
})();
var statearr_18590_18671 = state_18570__$1;
(statearr_18590_18671[(2)] = null);

(statearr_18590_18671[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (21))){
var inst_18492 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18594_18672 = state_18570__$1;
(statearr_18594_18672[(2)] = inst_18492);

(statearr_18594_18672[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (31))){
var inst_18518 = (state_18570[(12)]);
var inst_18522 = done(null);
var inst_18523 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18518);
var state_18570__$1 = (function (){var statearr_18595 = state_18570;
(statearr_18595[(19)] = inst_18522);

return statearr_18595;
})();
var statearr_18596_18673 = state_18570__$1;
(statearr_18596_18673[(2)] = inst_18523);

(statearr_18596_18673[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (32))){
var inst_18511 = (state_18570[(9)]);
var inst_18513 = (state_18570[(11)]);
var inst_18510 = (state_18570[(20)]);
var inst_18512 = (state_18570[(21)]);
var inst_18525 = (state_18570[(2)]);
var inst_18526 = (inst_18513 + (1));
var tmp18591 = inst_18511;
var tmp18592 = inst_18510;
var tmp18593 = inst_18512;
var inst_18510__$1 = tmp18592;
var inst_18511__$1 = tmp18591;
var inst_18512__$1 = tmp18593;
var inst_18513__$1 = inst_18526;
var state_18570__$1 = (function (){var statearr_18597 = state_18570;
(statearr_18597[(22)] = inst_18525);

(statearr_18597[(9)] = inst_18511__$1);

(statearr_18597[(11)] = inst_18513__$1);

(statearr_18597[(20)] = inst_18510__$1);

(statearr_18597[(21)] = inst_18512__$1);

return statearr_18597;
})();
var statearr_18598_18674 = state_18570__$1;
(statearr_18598_18674[(2)] = null);

(statearr_18598_18674[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (40))){
var inst_18538 = (state_18570[(23)]);
var inst_18542 = done(null);
var inst_18543 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18538);
var state_18570__$1 = (function (){var statearr_18599 = state_18570;
(statearr_18599[(24)] = inst_18542);

return statearr_18599;
})();
var statearr_18600_18675 = state_18570__$1;
(statearr_18600_18675[(2)] = inst_18543);

(statearr_18600_18675[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (33))){
var inst_18529 = (state_18570[(25)]);
var inst_18531 = cljs.core.chunked_seq_QMARK_(inst_18529);
var state_18570__$1 = state_18570;
if(inst_18531){
var statearr_18601_18676 = state_18570__$1;
(statearr_18601_18676[(1)] = (36));

} else {
var statearr_18602_18677 = state_18570__$1;
(statearr_18602_18677[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (13))){
var inst_18461 = (state_18570[(26)]);
var inst_18464 = cljs.core.async.close_BANG_(inst_18461);
var state_18570__$1 = state_18570;
var statearr_18603_18678 = state_18570__$1;
(statearr_18603_18678[(2)] = inst_18464);

(statearr_18603_18678[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (22))){
var inst_18482 = (state_18570[(8)]);
var inst_18485 = cljs.core.async.close_BANG_(inst_18482);
var state_18570__$1 = state_18570;
var statearr_18604_18679 = state_18570__$1;
(statearr_18604_18679[(2)] = inst_18485);

(statearr_18604_18679[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (36))){
var inst_18529 = (state_18570[(25)]);
var inst_18533 = cljs.core.chunk_first(inst_18529);
var inst_18534 = cljs.core.chunk_rest(inst_18529);
var inst_18535 = cljs.core.count(inst_18533);
var inst_18510 = inst_18534;
var inst_18511 = inst_18533;
var inst_18512 = inst_18535;
var inst_18513 = (0);
var state_18570__$1 = (function (){var statearr_18605 = state_18570;
(statearr_18605[(9)] = inst_18511);

(statearr_18605[(11)] = inst_18513);

(statearr_18605[(20)] = inst_18510);

(statearr_18605[(21)] = inst_18512);

return statearr_18605;
})();
var statearr_18606_18680 = state_18570__$1;
(statearr_18606_18680[(2)] = null);

(statearr_18606_18680[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (41))){
var inst_18529 = (state_18570[(25)]);
var inst_18545 = (state_18570[(2)]);
var inst_18546 = cljs.core.next(inst_18529);
var inst_18510 = inst_18546;
var inst_18511 = null;
var inst_18512 = (0);
var inst_18513 = (0);
var state_18570__$1 = (function (){var statearr_18607 = state_18570;
(statearr_18607[(27)] = inst_18545);

(statearr_18607[(9)] = inst_18511);

(statearr_18607[(11)] = inst_18513);

(statearr_18607[(20)] = inst_18510);

(statearr_18607[(21)] = inst_18512);

return statearr_18607;
})();
var statearr_18608_18681 = state_18570__$1;
(statearr_18608_18681[(2)] = null);

(statearr_18608_18681[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (43))){
var state_18570__$1 = state_18570;
var statearr_18609_18682 = state_18570__$1;
(statearr_18609_18682[(2)] = null);

(statearr_18609_18682[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (29))){
var inst_18554 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18610_18683 = state_18570__$1;
(statearr_18610_18683[(2)] = inst_18554);

(statearr_18610_18683[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (44))){
var inst_18563 = (state_18570[(2)]);
var state_18570__$1 = (function (){var statearr_18611 = state_18570;
(statearr_18611[(28)] = inst_18563);

return statearr_18611;
})();
var statearr_18612_18684 = state_18570__$1;
(statearr_18612_18684[(2)] = null);

(statearr_18612_18684[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (6))){
var inst_18502 = (state_18570[(29)]);
var inst_18501 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_18502__$1 = cljs.core.keys(inst_18501);
var inst_18503 = cljs.core.count(inst_18502__$1);
var inst_18504 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_18503) : cljs.core.reset_BANG_.call(null,dctr,inst_18503));
var inst_18509 = cljs.core.seq(inst_18502__$1);
var inst_18510 = inst_18509;
var inst_18511 = null;
var inst_18512 = (0);
var inst_18513 = (0);
var state_18570__$1 = (function (){var statearr_18613 = state_18570;
(statearr_18613[(29)] = inst_18502__$1);

(statearr_18613[(9)] = inst_18511);

(statearr_18613[(11)] = inst_18513);

(statearr_18613[(20)] = inst_18510);

(statearr_18613[(30)] = inst_18504);

(statearr_18613[(21)] = inst_18512);

return statearr_18613;
})();
var statearr_18614_18685 = state_18570__$1;
(statearr_18614_18685[(2)] = null);

(statearr_18614_18685[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (28))){
var inst_18529 = (state_18570[(25)]);
var inst_18510 = (state_18570[(20)]);
var inst_18529__$1 = cljs.core.seq(inst_18510);
var state_18570__$1 = (function (){var statearr_18615 = state_18570;
(statearr_18615[(25)] = inst_18529__$1);

return statearr_18615;
})();
if(inst_18529__$1){
var statearr_18616_18686 = state_18570__$1;
(statearr_18616_18686[(1)] = (33));

} else {
var statearr_18617_18687 = state_18570__$1;
(statearr_18617_18687[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (25))){
var inst_18513 = (state_18570[(11)]);
var inst_18512 = (state_18570[(21)]);
var inst_18515 = (inst_18513 < inst_18512);
var inst_18516 = inst_18515;
var state_18570__$1 = state_18570;
if(cljs.core.truth_(inst_18516)){
var statearr_18618_18688 = state_18570__$1;
(statearr_18618_18688[(1)] = (27));

} else {
var statearr_18619_18689 = state_18570__$1;
(statearr_18619_18689[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (34))){
var state_18570__$1 = state_18570;
var statearr_18620_18690 = state_18570__$1;
(statearr_18620_18690[(2)] = null);

(statearr_18620_18690[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (17))){
var state_18570__$1 = state_18570;
var statearr_18621_18691 = state_18570__$1;
(statearr_18621_18691[(2)] = null);

(statearr_18621_18691[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (3))){
var inst_18568 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18570__$1,inst_18568);
} else {
if((state_val_18571 === (12))){
var inst_18497 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18622_18692 = state_18570__$1;
(statearr_18622_18692[(2)] = inst_18497);

(statearr_18622_18692[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (2))){
var state_18570__$1 = state_18570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18570__$1,(4),ch);
} else {
if((state_val_18571 === (23))){
var state_18570__$1 = state_18570;
var statearr_18623_18693 = state_18570__$1;
(statearr_18623_18693[(2)] = null);

(statearr_18623_18693[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (35))){
var inst_18552 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18624_18694 = state_18570__$1;
(statearr_18624_18694[(2)] = inst_18552);

(statearr_18624_18694[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (19))){
var inst_18471 = (state_18570[(7)]);
var inst_18475 = cljs.core.chunk_first(inst_18471);
var inst_18476 = cljs.core.chunk_rest(inst_18471);
var inst_18477 = cljs.core.count(inst_18475);
var inst_18451 = inst_18476;
var inst_18452 = inst_18475;
var inst_18453 = inst_18477;
var inst_18454 = (0);
var state_18570__$1 = (function (){var statearr_18625 = state_18570;
(statearr_18625[(13)] = inst_18452);

(statearr_18625[(14)] = inst_18453);

(statearr_18625[(15)] = inst_18451);

(statearr_18625[(17)] = inst_18454);

return statearr_18625;
})();
var statearr_18626_18695 = state_18570__$1;
(statearr_18626_18695[(2)] = null);

(statearr_18626_18695[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (11))){
var inst_18471 = (state_18570[(7)]);
var inst_18451 = (state_18570[(15)]);
var inst_18471__$1 = cljs.core.seq(inst_18451);
var state_18570__$1 = (function (){var statearr_18627 = state_18570;
(statearr_18627[(7)] = inst_18471__$1);

return statearr_18627;
})();
if(inst_18471__$1){
var statearr_18628_18696 = state_18570__$1;
(statearr_18628_18696[(1)] = (16));

} else {
var statearr_18629_18697 = state_18570__$1;
(statearr_18629_18697[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (9))){
var inst_18499 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18630_18698 = state_18570__$1;
(statearr_18630_18698[(2)] = inst_18499);

(statearr_18630_18698[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (5))){
var inst_18449 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_18450 = cljs.core.seq(inst_18449);
var inst_18451 = inst_18450;
var inst_18452 = null;
var inst_18453 = (0);
var inst_18454 = (0);
var state_18570__$1 = (function (){var statearr_18631 = state_18570;
(statearr_18631[(13)] = inst_18452);

(statearr_18631[(14)] = inst_18453);

(statearr_18631[(15)] = inst_18451);

(statearr_18631[(17)] = inst_18454);

return statearr_18631;
})();
var statearr_18632_18699 = state_18570__$1;
(statearr_18632_18699[(2)] = null);

(statearr_18632_18699[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (14))){
var state_18570__$1 = state_18570;
var statearr_18633_18700 = state_18570__$1;
(statearr_18633_18700[(2)] = null);

(statearr_18633_18700[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (45))){
var inst_18560 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18634_18701 = state_18570__$1;
(statearr_18634_18701[(2)] = inst_18560);

(statearr_18634_18701[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (26))){
var inst_18502 = (state_18570[(29)]);
var inst_18556 = (state_18570[(2)]);
var inst_18557 = cljs.core.seq(inst_18502);
var state_18570__$1 = (function (){var statearr_18635 = state_18570;
(statearr_18635[(31)] = inst_18556);

return statearr_18635;
})();
if(inst_18557){
var statearr_18636_18702 = state_18570__$1;
(statearr_18636_18702[(1)] = (42));

} else {
var statearr_18637_18703 = state_18570__$1;
(statearr_18637_18703[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (16))){
var inst_18471 = (state_18570[(7)]);
var inst_18473 = cljs.core.chunked_seq_QMARK_(inst_18471);
var state_18570__$1 = state_18570;
if(inst_18473){
var statearr_18638_18704 = state_18570__$1;
(statearr_18638_18704[(1)] = (19));

} else {
var statearr_18639_18705 = state_18570__$1;
(statearr_18639_18705[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (38))){
var inst_18549 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18640_18706 = state_18570__$1;
(statearr_18640_18706[(2)] = inst_18549);

(statearr_18640_18706[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (30))){
var state_18570__$1 = state_18570;
var statearr_18641_18707 = state_18570__$1;
(statearr_18641_18707[(2)] = null);

(statearr_18641_18707[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (10))){
var inst_18452 = (state_18570[(13)]);
var inst_18454 = (state_18570[(17)]);
var inst_18460 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18452,inst_18454);
var inst_18461 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18460,(0),null);
var inst_18462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18460,(1),null);
var state_18570__$1 = (function (){var statearr_18642 = state_18570;
(statearr_18642[(26)] = inst_18461);

return statearr_18642;
})();
if(cljs.core.truth_(inst_18462)){
var statearr_18643_18708 = state_18570__$1;
(statearr_18643_18708[(1)] = (13));

} else {
var statearr_18644_18709 = state_18570__$1;
(statearr_18644_18709[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (18))){
var inst_18495 = (state_18570[(2)]);
var state_18570__$1 = state_18570;
var statearr_18645_18710 = state_18570__$1;
(statearr_18645_18710[(2)] = inst_18495);

(statearr_18645_18710[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (42))){
var state_18570__$1 = state_18570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18570__$1,(45),dchan);
} else {
if((state_val_18571 === (37))){
var inst_18538 = (state_18570[(23)]);
var inst_18442 = (state_18570[(10)]);
var inst_18529 = (state_18570[(25)]);
var inst_18538__$1 = cljs.core.first(inst_18529);
var inst_18539 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18538__$1,inst_18442,done);
var state_18570__$1 = (function (){var statearr_18646 = state_18570;
(statearr_18646[(23)] = inst_18538__$1);

return statearr_18646;
})();
if(cljs.core.truth_(inst_18539)){
var statearr_18647_18711 = state_18570__$1;
(statearr_18647_18711[(1)] = (39));

} else {
var statearr_18648_18712 = state_18570__$1;
(statearr_18648_18712[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18571 === (8))){
var inst_18453 = (state_18570[(14)]);
var inst_18454 = (state_18570[(17)]);
var inst_18456 = (inst_18454 < inst_18453);
var inst_18457 = inst_18456;
var state_18570__$1 = state_18570;
if(cljs.core.truth_(inst_18457)){
var statearr_18649_18713 = state_18570__$1;
(statearr_18649_18713[(1)] = (10));

} else {
var statearr_18650_18714 = state_18570__$1;
(statearr_18650_18714[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___18660,cs,m,dchan,dctr,done))
;
return ((function (switch__17227__auto__,c__17341__auto___18660,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__17228__auto__ = null;
var cljs$core$async$mult_$_state_machine__17228__auto____0 = (function (){
var statearr_18654 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18654[(0)] = cljs$core$async$mult_$_state_machine__17228__auto__);

(statearr_18654[(1)] = (1));

return statearr_18654;
});
var cljs$core$async$mult_$_state_machine__17228__auto____1 = (function (state_18570){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_18570);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e18655){if((e18655 instanceof Object)){
var ex__17231__auto__ = e18655;
var statearr_18656_18715 = state_18570;
(statearr_18656_18715[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18570);

return cljs.core.cst$kw$recur;
} else {
throw e18655;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__18716 = state_18570;
state_18570 = G__18716;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17228__auto__ = function(state_18570){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17228__auto____1.call(this,state_18570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17228__auto____0;
cljs$core$async$mult_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17228__auto____1;
return cljs$core$async$mult_$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___18660,cs,m,dchan,dctr,done))
})();
var state__17343__auto__ = (function (){var statearr_18657 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_18657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___18660);

return statearr_18657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___18660,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18717 = [];
var len__7211__auto___18720 = arguments.length;
var i__7212__auto___18721 = (0);
while(true){
if((i__7212__auto___18721 < len__7211__auto___18720)){
args18717.push((arguments[i__7212__auto___18721]));

var G__18722 = (i__7212__auto___18721 + (1));
i__7212__auto___18721 = G__18722;
continue;
} else {
}
break;
}

var G__18719 = args18717.length;
switch (G__18719) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18717.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto__.call(null,m,ch));
} else {
var m__6809__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto__.call(null,m,ch));
} else {
var m__6809__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6809__auto__.call(null,m));
} else {
var m__6809__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6809__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6809__auto__.call(null,m,state_map));
} else {
var m__6809__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6809__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6809__auto__.call(null,m,mode));
} else {
var m__6809__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6809__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7218__auto__ = [];
var len__7211__auto___18734 = arguments.length;
var i__7212__auto___18735 = (0);
while(true){
if((i__7212__auto___18735 < len__7211__auto___18734)){
args__7218__auto__.push((arguments[i__7212__auto___18735]));

var G__18736 = (i__7212__auto___18735 + (1));
i__7212__auto___18735 = G__18736;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((3) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7219__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18728){
var map__18729 = p__18728;
var map__18729__$1 = ((((!((map__18729 == null)))?((((map__18729.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18729.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18729):map__18729);
var opts = map__18729__$1;
var statearr_18731_18737 = state;
(statearr_18731_18737[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__18729,map__18729__$1,opts){
return (function (val){
var statearr_18732_18738 = state;
(statearr_18732_18738[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__18729,map__18729__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_18733_18739 = state;
(statearr_18733_18739[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18724){
var G__18725 = cljs.core.first(seq18724);
var seq18724__$1 = cljs.core.next(seq18724);
var G__18726 = cljs.core.first(seq18724__$1);
var seq18724__$2 = cljs.core.next(seq18724__$1);
var G__18727 = cljs.core.first(seq18724__$2);
var seq18724__$3 = cljs.core.next(seq18724__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18725,G__18726,G__18727,seq18724__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__18906 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__18906) : cljs.core.atom.call(null,G__18906));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18907 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18907 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18908){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18908 = meta18908;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18909,meta18908__$1){
var self__ = this;
var _18909__$1 = this;
return (new cljs.core.async.t_cljs$core$async18907(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18908__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18909){
var self__ = this;
var _18909__$1 = this;
return self__.meta18908;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__18910_19072 = self__.cs;
var G__18911_19073 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__18910_19072,G__18911_19073) : cljs.core.reset_BANG_.call(null,G__18910_19072,G__18911_19073));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$mode)], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta18908], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18907.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18907.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18907";

cljs.core.async.t_cljs$core$async18907.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async18907");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18907 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18907(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18908){
return (new cljs.core.async.t_cljs$core$async18907(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18908));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18907(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17341__auto___19074 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___19074,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___19074,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19009){
var state_val_19010 = (state_19009[(1)]);
if((state_val_19010 === (7))){
var inst_18927 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
var statearr_19011_19075 = state_19009__$1;
(statearr_19011_19075[(2)] = inst_18927);

(statearr_19011_19075[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (20))){
var inst_18939 = (state_19009[(7)]);
var state_19009__$1 = state_19009;
var statearr_19012_19076 = state_19009__$1;
(statearr_19012_19076[(2)] = inst_18939);

(statearr_19012_19076[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (27))){
var state_19009__$1 = state_19009;
var statearr_19013_19077 = state_19009__$1;
(statearr_19013_19077[(2)] = null);

(statearr_19013_19077[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (1))){
var inst_18915 = (state_19009[(8)]);
var inst_18915__$1 = calc_state();
var inst_18917 = (inst_18915__$1 == null);
var inst_18918 = cljs.core.not(inst_18917);
var state_19009__$1 = (function (){var statearr_19014 = state_19009;
(statearr_19014[(8)] = inst_18915__$1);

return statearr_19014;
})();
if(inst_18918){
var statearr_19015_19078 = state_19009__$1;
(statearr_19015_19078[(1)] = (2));

} else {
var statearr_19016_19079 = state_19009__$1;
(statearr_19016_19079[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (24))){
var inst_18969 = (state_19009[(9)]);
var inst_18962 = (state_19009[(10)]);
var inst_18983 = (state_19009[(11)]);
var inst_18983__$1 = (inst_18962.cljs$core$IFn$_invoke$arity$1 ? inst_18962.cljs$core$IFn$_invoke$arity$1(inst_18969) : inst_18962.call(null,inst_18969));
var state_19009__$1 = (function (){var statearr_19017 = state_19009;
(statearr_19017[(11)] = inst_18983__$1);

return statearr_19017;
})();
if(cljs.core.truth_(inst_18983__$1)){
var statearr_19018_19080 = state_19009__$1;
(statearr_19018_19080[(1)] = (29));

} else {
var statearr_19019_19081 = state_19009__$1;
(statearr_19019_19081[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (4))){
var inst_18930 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
if(cljs.core.truth_(inst_18930)){
var statearr_19020_19082 = state_19009__$1;
(statearr_19020_19082[(1)] = (8));

} else {
var statearr_19021_19083 = state_19009__$1;
(statearr_19021_19083[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (15))){
var inst_18956 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
if(cljs.core.truth_(inst_18956)){
var statearr_19022_19084 = state_19009__$1;
(statearr_19022_19084[(1)] = (19));

} else {
var statearr_19023_19085 = state_19009__$1;
(statearr_19023_19085[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (21))){
var inst_18961 = (state_19009[(12)]);
var inst_18961__$1 = (state_19009[(2)]);
var inst_18962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18961__$1,cljs.core.cst$kw$solos);
var inst_18963 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18961__$1,cljs.core.cst$kw$mutes);
var inst_18964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18961__$1,cljs.core.cst$kw$reads);
var state_19009__$1 = (function (){var statearr_19024 = state_19009;
(statearr_19024[(13)] = inst_18963);

(statearr_19024[(12)] = inst_18961__$1);

(statearr_19024[(10)] = inst_18962);

return statearr_19024;
})();
return cljs.core.async.ioc_alts_BANG_(state_19009__$1,(22),inst_18964);
} else {
if((state_val_19010 === (31))){
var inst_18991 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
if(cljs.core.truth_(inst_18991)){
var statearr_19025_19086 = state_19009__$1;
(statearr_19025_19086[(1)] = (32));

} else {
var statearr_19026_19087 = state_19009__$1;
(statearr_19026_19087[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (32))){
var inst_18968 = (state_19009[(14)]);
var state_19009__$1 = state_19009;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19009__$1,(35),out,inst_18968);
} else {
if((state_val_19010 === (33))){
var inst_18961 = (state_19009[(12)]);
var inst_18939 = inst_18961;
var state_19009__$1 = (function (){var statearr_19027 = state_19009;
(statearr_19027[(7)] = inst_18939);

return statearr_19027;
})();
var statearr_19028_19088 = state_19009__$1;
(statearr_19028_19088[(2)] = null);

(statearr_19028_19088[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (13))){
var inst_18939 = (state_19009[(7)]);
var inst_18946 = inst_18939.cljs$lang$protocol_mask$partition0$;
var inst_18947 = (inst_18946 & (64));
var inst_18948 = inst_18939.cljs$core$ISeq$;
var inst_18949 = (inst_18947) || (inst_18948);
var state_19009__$1 = state_19009;
if(cljs.core.truth_(inst_18949)){
var statearr_19029_19089 = state_19009__$1;
(statearr_19029_19089[(1)] = (16));

} else {
var statearr_19030_19090 = state_19009__$1;
(statearr_19030_19090[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (22))){
var inst_18969 = (state_19009[(9)]);
var inst_18968 = (state_19009[(14)]);
var inst_18967 = (state_19009[(2)]);
var inst_18968__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18967,(0),null);
var inst_18969__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18967,(1),null);
var inst_18970 = (inst_18968__$1 == null);
var inst_18971 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18969__$1,change);
var inst_18972 = (inst_18970) || (inst_18971);
var state_19009__$1 = (function (){var statearr_19031 = state_19009;
(statearr_19031[(9)] = inst_18969__$1);

(statearr_19031[(14)] = inst_18968__$1);

return statearr_19031;
})();
if(cljs.core.truth_(inst_18972)){
var statearr_19032_19091 = state_19009__$1;
(statearr_19032_19091[(1)] = (23));

} else {
var statearr_19033_19092 = state_19009__$1;
(statearr_19033_19092[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (36))){
var inst_18961 = (state_19009[(12)]);
var inst_18939 = inst_18961;
var state_19009__$1 = (function (){var statearr_19034 = state_19009;
(statearr_19034[(7)] = inst_18939);

return statearr_19034;
})();
var statearr_19035_19093 = state_19009__$1;
(statearr_19035_19093[(2)] = null);

(statearr_19035_19093[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (29))){
var inst_18983 = (state_19009[(11)]);
var state_19009__$1 = state_19009;
var statearr_19036_19094 = state_19009__$1;
(statearr_19036_19094[(2)] = inst_18983);

(statearr_19036_19094[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (6))){
var state_19009__$1 = state_19009;
var statearr_19037_19095 = state_19009__$1;
(statearr_19037_19095[(2)] = false);

(statearr_19037_19095[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (28))){
var inst_18979 = (state_19009[(2)]);
var inst_18980 = calc_state();
var inst_18939 = inst_18980;
var state_19009__$1 = (function (){var statearr_19038 = state_19009;
(statearr_19038[(7)] = inst_18939);

(statearr_19038[(15)] = inst_18979);

return statearr_19038;
})();
var statearr_19039_19096 = state_19009__$1;
(statearr_19039_19096[(2)] = null);

(statearr_19039_19096[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (25))){
var inst_19005 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
var statearr_19040_19097 = state_19009__$1;
(statearr_19040_19097[(2)] = inst_19005);

(statearr_19040_19097[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (34))){
var inst_19003 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
var statearr_19041_19098 = state_19009__$1;
(statearr_19041_19098[(2)] = inst_19003);

(statearr_19041_19098[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (17))){
var state_19009__$1 = state_19009;
var statearr_19042_19099 = state_19009__$1;
(statearr_19042_19099[(2)] = false);

(statearr_19042_19099[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (3))){
var state_19009__$1 = state_19009;
var statearr_19043_19100 = state_19009__$1;
(statearr_19043_19100[(2)] = false);

(statearr_19043_19100[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (12))){
var inst_19007 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19009__$1,inst_19007);
} else {
if((state_val_19010 === (2))){
var inst_18915 = (state_19009[(8)]);
var inst_18920 = inst_18915.cljs$lang$protocol_mask$partition0$;
var inst_18921 = (inst_18920 & (64));
var inst_18922 = inst_18915.cljs$core$ISeq$;
var inst_18923 = (inst_18921) || (inst_18922);
var state_19009__$1 = state_19009;
if(cljs.core.truth_(inst_18923)){
var statearr_19044_19101 = state_19009__$1;
(statearr_19044_19101[(1)] = (5));

} else {
var statearr_19045_19102 = state_19009__$1;
(statearr_19045_19102[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (23))){
var inst_18968 = (state_19009[(14)]);
var inst_18974 = (inst_18968 == null);
var state_19009__$1 = state_19009;
if(cljs.core.truth_(inst_18974)){
var statearr_19046_19103 = state_19009__$1;
(statearr_19046_19103[(1)] = (26));

} else {
var statearr_19047_19104 = state_19009__$1;
(statearr_19047_19104[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (35))){
var inst_18994 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
if(cljs.core.truth_(inst_18994)){
var statearr_19048_19105 = state_19009__$1;
(statearr_19048_19105[(1)] = (36));

} else {
var statearr_19049_19106 = state_19009__$1;
(statearr_19049_19106[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (19))){
var inst_18939 = (state_19009[(7)]);
var inst_18958 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18939);
var state_19009__$1 = state_19009;
var statearr_19050_19107 = state_19009__$1;
(statearr_19050_19107[(2)] = inst_18958);

(statearr_19050_19107[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (11))){
var inst_18939 = (state_19009[(7)]);
var inst_18943 = (inst_18939 == null);
var inst_18944 = cljs.core.not(inst_18943);
var state_19009__$1 = state_19009;
if(inst_18944){
var statearr_19051_19108 = state_19009__$1;
(statearr_19051_19108[(1)] = (13));

} else {
var statearr_19052_19109 = state_19009__$1;
(statearr_19052_19109[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (9))){
var inst_18915 = (state_19009[(8)]);
var state_19009__$1 = state_19009;
var statearr_19053_19110 = state_19009__$1;
(statearr_19053_19110[(2)] = inst_18915);

(statearr_19053_19110[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (5))){
var state_19009__$1 = state_19009;
var statearr_19054_19111 = state_19009__$1;
(statearr_19054_19111[(2)] = true);

(statearr_19054_19111[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (14))){
var state_19009__$1 = state_19009;
var statearr_19055_19112 = state_19009__$1;
(statearr_19055_19112[(2)] = false);

(statearr_19055_19112[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (26))){
var inst_18969 = (state_19009[(9)]);
var inst_18976 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_18969);
var state_19009__$1 = state_19009;
var statearr_19056_19113 = state_19009__$1;
(statearr_19056_19113[(2)] = inst_18976);

(statearr_19056_19113[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (16))){
var state_19009__$1 = state_19009;
var statearr_19057_19114 = state_19009__$1;
(statearr_19057_19114[(2)] = true);

(statearr_19057_19114[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (38))){
var inst_18999 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
var statearr_19058_19115 = state_19009__$1;
(statearr_19058_19115[(2)] = inst_18999);

(statearr_19058_19115[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (30))){
var inst_18969 = (state_19009[(9)]);
var inst_18963 = (state_19009[(13)]);
var inst_18962 = (state_19009[(10)]);
var inst_18986 = cljs.core.empty_QMARK_(inst_18962);
var inst_18987 = (inst_18963.cljs$core$IFn$_invoke$arity$1 ? inst_18963.cljs$core$IFn$_invoke$arity$1(inst_18969) : inst_18963.call(null,inst_18969));
var inst_18988 = cljs.core.not(inst_18987);
var inst_18989 = (inst_18986) && (inst_18988);
var state_19009__$1 = state_19009;
var statearr_19059_19116 = state_19009__$1;
(statearr_19059_19116[(2)] = inst_18989);

(statearr_19059_19116[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (10))){
var inst_18915 = (state_19009[(8)]);
var inst_18935 = (state_19009[(2)]);
var inst_18936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18935,cljs.core.cst$kw$solos);
var inst_18937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18935,cljs.core.cst$kw$mutes);
var inst_18938 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18935,cljs.core.cst$kw$reads);
var inst_18939 = inst_18915;
var state_19009__$1 = (function (){var statearr_19060 = state_19009;
(statearr_19060[(7)] = inst_18939);

(statearr_19060[(16)] = inst_18936);

(statearr_19060[(17)] = inst_18937);

(statearr_19060[(18)] = inst_18938);

return statearr_19060;
})();
var statearr_19061_19117 = state_19009__$1;
(statearr_19061_19117[(2)] = null);

(statearr_19061_19117[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (18))){
var inst_18953 = (state_19009[(2)]);
var state_19009__$1 = state_19009;
var statearr_19062_19118 = state_19009__$1;
(statearr_19062_19118[(2)] = inst_18953);

(statearr_19062_19118[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (37))){
var state_19009__$1 = state_19009;
var statearr_19063_19119 = state_19009__$1;
(statearr_19063_19119[(2)] = null);

(statearr_19063_19119[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19010 === (8))){
var inst_18915 = (state_19009[(8)]);
var inst_18932 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18915);
var state_19009__$1 = state_19009;
var statearr_19064_19120 = state_19009__$1;
(statearr_19064_19120[(2)] = inst_18932);

(statearr_19064_19120[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___19074,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__17227__auto__,c__17341__auto___19074,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__17228__auto__ = null;
var cljs$core$async$mix_$_state_machine__17228__auto____0 = (function (){
var statearr_19068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19068[(0)] = cljs$core$async$mix_$_state_machine__17228__auto__);

(statearr_19068[(1)] = (1));

return statearr_19068;
});
var cljs$core$async$mix_$_state_machine__17228__auto____1 = (function (state_19009){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19009);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e19069){if((e19069 instanceof Object)){
var ex__17231__auto__ = e19069;
var statearr_19070_19121 = state_19009;
(statearr_19070_19121[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19009);

return cljs.core.cst$kw$recur;
} else {
throw e19069;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__19122 = state_19009;
state_19009 = G__19122;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17228__auto__ = function(state_19009){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17228__auto____1.call(this,state_19009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17228__auto____0;
cljs$core$async$mix_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17228__auto____1;
return cljs$core$async$mix_$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___19074,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__17343__auto__ = (function (){var statearr_19071 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_19071[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___19074);

return statearr_19071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___19074,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6808__auto__ = (((p == null))?null:p);
var m__6809__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6809__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__6809__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6809__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6808__auto__ = (((p == null))?null:p);
var m__6809__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6809__auto__.call(null,p,v,ch));
} else {
var m__6809__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6809__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19123 = [];
var len__7211__auto___19126 = arguments.length;
var i__7212__auto___19127 = (0);
while(true){
if((i__7212__auto___19127 < len__7211__auto___19126)){
args19123.push((arguments[i__7212__auto___19127]));

var G__19128 = (i__7212__auto___19127 + (1));
i__7212__auto___19127 = G__19128;
continue;
} else {
}
break;
}

var G__19125 = args19123.length;
switch (G__19125) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19123.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6808__auto__ = (((p == null))?null:p);
var m__6809__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__6809__auto__.call(null,p));
} else {
var m__6809__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__6809__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6808__auto__ = (((p == null))?null:p);
var m__6809__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__6809__auto__.call(null,p,v));
} else {
var m__6809__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__6809__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19131 = [];
var len__7211__auto___19259 = arguments.length;
var i__7212__auto___19260 = (0);
while(true){
if((i__7212__auto___19260 < len__7211__auto___19259)){
args19131.push((arguments[i__7212__auto___19260]));

var G__19261 = (i__7212__auto___19260 + (1));
i__7212__auto___19260 = G__19261;
continue;
} else {
}
break;
}

var G__19133 = args19131.length;
switch (G__19133) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19131.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__19134 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19134) : cljs.core.atom.call(null,G__19134));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6153__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6153__auto__,mults){
return (function (p1__19130_SHARP_){
if(cljs.core.truth_((p1__19130_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__19130_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__19130_SHARP_.call(null,topic)))){
return p1__19130_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__19130_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6153__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19135 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19135 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19136){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19136 = meta19136;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19137,meta19136__$1){
var self__ = this;
var _19137__$1 = this;
return (new cljs.core.async.t_cljs$core$async19135(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19136__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19137){
var self__ = this;
var _19137__$1 = this;
return self__.meta19136;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__19138 = self__.mults;
var G__19139 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__19138,G__19139) : cljs.core.reset_BANG_.call(null,G__19138,G__19139));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19135.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19135.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta19136], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19135.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19135.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19135";

cljs.core.async.t_cljs$core$async19135.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async19135");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19135 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19135(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19136){
return (new cljs.core.async.t_cljs$core$async19135(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19136));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19135(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17341__auto___19263 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___19263,mults,ensure_mult,p){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___19263,mults,ensure_mult,p){
return (function (state_19211){
var state_val_19212 = (state_19211[(1)]);
if((state_val_19212 === (7))){
var inst_19207 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19213_19264 = state_19211__$1;
(statearr_19213_19264[(2)] = inst_19207);

(statearr_19213_19264[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (20))){
var state_19211__$1 = state_19211;
var statearr_19214_19265 = state_19211__$1;
(statearr_19214_19265[(2)] = null);

(statearr_19214_19265[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (1))){
var state_19211__$1 = state_19211;
var statearr_19215_19266 = state_19211__$1;
(statearr_19215_19266[(2)] = null);

(statearr_19215_19266[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (24))){
var inst_19190 = (state_19211[(7)]);
var inst_19199 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_19190);
var state_19211__$1 = state_19211;
var statearr_19216_19267 = state_19211__$1;
(statearr_19216_19267[(2)] = inst_19199);

(statearr_19216_19267[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (4))){
var inst_19142 = (state_19211[(8)]);
var inst_19142__$1 = (state_19211[(2)]);
var inst_19143 = (inst_19142__$1 == null);
var state_19211__$1 = (function (){var statearr_19217 = state_19211;
(statearr_19217[(8)] = inst_19142__$1);

return statearr_19217;
})();
if(cljs.core.truth_(inst_19143)){
var statearr_19218_19268 = state_19211__$1;
(statearr_19218_19268[(1)] = (5));

} else {
var statearr_19219_19269 = state_19211__$1;
(statearr_19219_19269[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (15))){
var inst_19184 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19220_19270 = state_19211__$1;
(statearr_19220_19270[(2)] = inst_19184);

(statearr_19220_19270[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (21))){
var inst_19204 = (state_19211[(2)]);
var state_19211__$1 = (function (){var statearr_19221 = state_19211;
(statearr_19221[(9)] = inst_19204);

return statearr_19221;
})();
var statearr_19222_19271 = state_19211__$1;
(statearr_19222_19271[(2)] = null);

(statearr_19222_19271[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (13))){
var inst_19166 = (state_19211[(10)]);
var inst_19168 = cljs.core.chunked_seq_QMARK_(inst_19166);
var state_19211__$1 = state_19211;
if(inst_19168){
var statearr_19223_19272 = state_19211__$1;
(statearr_19223_19272[(1)] = (16));

} else {
var statearr_19224_19273 = state_19211__$1;
(statearr_19224_19273[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (22))){
var inst_19196 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
if(cljs.core.truth_(inst_19196)){
var statearr_19225_19274 = state_19211__$1;
(statearr_19225_19274[(1)] = (23));

} else {
var statearr_19226_19275 = state_19211__$1;
(statearr_19226_19275[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (6))){
var inst_19190 = (state_19211[(7)]);
var inst_19192 = (state_19211[(11)]);
var inst_19142 = (state_19211[(8)]);
var inst_19190__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_19142) : topic_fn.call(null,inst_19142));
var inst_19191 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_19192__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19191,inst_19190__$1);
var state_19211__$1 = (function (){var statearr_19227 = state_19211;
(statearr_19227[(7)] = inst_19190__$1);

(statearr_19227[(11)] = inst_19192__$1);

return statearr_19227;
})();
if(cljs.core.truth_(inst_19192__$1)){
var statearr_19228_19276 = state_19211__$1;
(statearr_19228_19276[(1)] = (19));

} else {
var statearr_19229_19277 = state_19211__$1;
(statearr_19229_19277[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (25))){
var inst_19201 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19230_19278 = state_19211__$1;
(statearr_19230_19278[(2)] = inst_19201);

(statearr_19230_19278[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (17))){
var inst_19166 = (state_19211[(10)]);
var inst_19175 = cljs.core.first(inst_19166);
var inst_19176 = cljs.core.async.muxch_STAR_(inst_19175);
var inst_19177 = cljs.core.async.close_BANG_(inst_19176);
var inst_19178 = cljs.core.next(inst_19166);
var inst_19152 = inst_19178;
var inst_19153 = null;
var inst_19154 = (0);
var inst_19155 = (0);
var state_19211__$1 = (function (){var statearr_19231 = state_19211;
(statearr_19231[(12)] = inst_19153);

(statearr_19231[(13)] = inst_19177);

(statearr_19231[(14)] = inst_19154);

(statearr_19231[(15)] = inst_19155);

(statearr_19231[(16)] = inst_19152);

return statearr_19231;
})();
var statearr_19232_19279 = state_19211__$1;
(statearr_19232_19279[(2)] = null);

(statearr_19232_19279[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (3))){
var inst_19209 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19211__$1,inst_19209);
} else {
if((state_val_19212 === (12))){
var inst_19186 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19233_19280 = state_19211__$1;
(statearr_19233_19280[(2)] = inst_19186);

(statearr_19233_19280[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (2))){
var state_19211__$1 = state_19211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19211__$1,(4),ch);
} else {
if((state_val_19212 === (23))){
var state_19211__$1 = state_19211;
var statearr_19234_19281 = state_19211__$1;
(statearr_19234_19281[(2)] = null);

(statearr_19234_19281[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (19))){
var inst_19192 = (state_19211[(11)]);
var inst_19142 = (state_19211[(8)]);
var inst_19194 = cljs.core.async.muxch_STAR_(inst_19192);
var state_19211__$1 = state_19211;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19211__$1,(22),inst_19194,inst_19142);
} else {
if((state_val_19212 === (11))){
var inst_19166 = (state_19211[(10)]);
var inst_19152 = (state_19211[(16)]);
var inst_19166__$1 = cljs.core.seq(inst_19152);
var state_19211__$1 = (function (){var statearr_19235 = state_19211;
(statearr_19235[(10)] = inst_19166__$1);

return statearr_19235;
})();
if(inst_19166__$1){
var statearr_19236_19282 = state_19211__$1;
(statearr_19236_19282[(1)] = (13));

} else {
var statearr_19237_19283 = state_19211__$1;
(statearr_19237_19283[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (9))){
var inst_19188 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19238_19284 = state_19211__$1;
(statearr_19238_19284[(2)] = inst_19188);

(statearr_19238_19284[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (5))){
var inst_19149 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_19150 = cljs.core.vals(inst_19149);
var inst_19151 = cljs.core.seq(inst_19150);
var inst_19152 = inst_19151;
var inst_19153 = null;
var inst_19154 = (0);
var inst_19155 = (0);
var state_19211__$1 = (function (){var statearr_19239 = state_19211;
(statearr_19239[(12)] = inst_19153);

(statearr_19239[(14)] = inst_19154);

(statearr_19239[(15)] = inst_19155);

(statearr_19239[(16)] = inst_19152);

return statearr_19239;
})();
var statearr_19240_19285 = state_19211__$1;
(statearr_19240_19285[(2)] = null);

(statearr_19240_19285[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (14))){
var state_19211__$1 = state_19211;
var statearr_19244_19286 = state_19211__$1;
(statearr_19244_19286[(2)] = null);

(statearr_19244_19286[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (16))){
var inst_19166 = (state_19211[(10)]);
var inst_19170 = cljs.core.chunk_first(inst_19166);
var inst_19171 = cljs.core.chunk_rest(inst_19166);
var inst_19172 = cljs.core.count(inst_19170);
var inst_19152 = inst_19171;
var inst_19153 = inst_19170;
var inst_19154 = inst_19172;
var inst_19155 = (0);
var state_19211__$1 = (function (){var statearr_19245 = state_19211;
(statearr_19245[(12)] = inst_19153);

(statearr_19245[(14)] = inst_19154);

(statearr_19245[(15)] = inst_19155);

(statearr_19245[(16)] = inst_19152);

return statearr_19245;
})();
var statearr_19246_19287 = state_19211__$1;
(statearr_19246_19287[(2)] = null);

(statearr_19246_19287[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (10))){
var inst_19153 = (state_19211[(12)]);
var inst_19154 = (state_19211[(14)]);
var inst_19155 = (state_19211[(15)]);
var inst_19152 = (state_19211[(16)]);
var inst_19160 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19153,inst_19155);
var inst_19161 = cljs.core.async.muxch_STAR_(inst_19160);
var inst_19162 = cljs.core.async.close_BANG_(inst_19161);
var inst_19163 = (inst_19155 + (1));
var tmp19241 = inst_19153;
var tmp19242 = inst_19154;
var tmp19243 = inst_19152;
var inst_19152__$1 = tmp19243;
var inst_19153__$1 = tmp19241;
var inst_19154__$1 = tmp19242;
var inst_19155__$1 = inst_19163;
var state_19211__$1 = (function (){var statearr_19247 = state_19211;
(statearr_19247[(17)] = inst_19162);

(statearr_19247[(12)] = inst_19153__$1);

(statearr_19247[(14)] = inst_19154__$1);

(statearr_19247[(15)] = inst_19155__$1);

(statearr_19247[(16)] = inst_19152__$1);

return statearr_19247;
})();
var statearr_19248_19288 = state_19211__$1;
(statearr_19248_19288[(2)] = null);

(statearr_19248_19288[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (18))){
var inst_19181 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19249_19289 = state_19211__$1;
(statearr_19249_19289[(2)] = inst_19181);

(statearr_19249_19289[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19212 === (8))){
var inst_19154 = (state_19211[(14)]);
var inst_19155 = (state_19211[(15)]);
var inst_19157 = (inst_19155 < inst_19154);
var inst_19158 = inst_19157;
var state_19211__$1 = state_19211;
if(cljs.core.truth_(inst_19158)){
var statearr_19250_19290 = state_19211__$1;
(statearr_19250_19290[(1)] = (10));

} else {
var statearr_19251_19291 = state_19211__$1;
(statearr_19251_19291[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___19263,mults,ensure_mult,p))
;
return ((function (switch__17227__auto__,c__17341__auto___19263,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_19255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19255[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_19255[(1)] = (1));

return statearr_19255;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_19211){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19211);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e19256){if((e19256 instanceof Object)){
var ex__17231__auto__ = e19256;
var statearr_19257_19292 = state_19211;
(statearr_19257_19292[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19211);

return cljs.core.cst$kw$recur;
} else {
throw e19256;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__19293 = state_19211;
state_19211 = G__19293;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_19211){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_19211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___19263,mults,ensure_mult,p))
})();
var state__17343__auto__ = (function (){var statearr_19258 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_19258[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___19263);

return statearr_19258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___19263,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19294 = [];
var len__7211__auto___19297 = arguments.length;
var i__7212__auto___19298 = (0);
while(true){
if((i__7212__auto___19298 < len__7211__auto___19297)){
args19294.push((arguments[i__7212__auto___19298]));

var G__19299 = (i__7212__auto___19298 + (1));
i__7212__auto___19298 = G__19299;
continue;
} else {
}
break;
}

var G__19296 = args19294.length;
switch (G__19296) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19294.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19301 = [];
var len__7211__auto___19304 = arguments.length;
var i__7212__auto___19305 = (0);
while(true){
if((i__7212__auto___19305 < len__7211__auto___19304)){
args19301.push((arguments[i__7212__auto___19305]));

var G__19306 = (i__7212__auto___19305 + (1));
i__7212__auto___19305 = G__19306;
continue;
} else {
}
break;
}

var G__19303 = args19301.length;
switch (G__19303) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19301.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19308 = [];
var len__7211__auto___19379 = arguments.length;
var i__7212__auto___19380 = (0);
while(true){
if((i__7212__auto___19380 < len__7211__auto___19379)){
args19308.push((arguments[i__7212__auto___19380]));

var G__19381 = (i__7212__auto___19380 + (1));
i__7212__auto___19380 = G__19381;
continue;
} else {
}
break;
}

var G__19310 = args19308.length;
switch (G__19310) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19308.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__17341__auto___19383 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___19383,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___19383,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19349){
var state_val_19350 = (state_19349[(1)]);
if((state_val_19350 === (7))){
var state_19349__$1 = state_19349;
var statearr_19351_19384 = state_19349__$1;
(statearr_19351_19384[(2)] = null);

(statearr_19351_19384[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (1))){
var state_19349__$1 = state_19349;
var statearr_19352_19385 = state_19349__$1;
(statearr_19352_19385[(2)] = null);

(statearr_19352_19385[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (4))){
var inst_19313 = (state_19349[(7)]);
var inst_19315 = (inst_19313 < cnt);
var state_19349__$1 = state_19349;
if(cljs.core.truth_(inst_19315)){
var statearr_19353_19386 = state_19349__$1;
(statearr_19353_19386[(1)] = (6));

} else {
var statearr_19354_19387 = state_19349__$1;
(statearr_19354_19387[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (15))){
var inst_19345 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
var statearr_19355_19388 = state_19349__$1;
(statearr_19355_19388[(2)] = inst_19345);

(statearr_19355_19388[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (13))){
var inst_19338 = cljs.core.async.close_BANG_(out);
var state_19349__$1 = state_19349;
var statearr_19356_19389 = state_19349__$1;
(statearr_19356_19389[(2)] = inst_19338);

(statearr_19356_19389[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (6))){
var state_19349__$1 = state_19349;
var statearr_19357_19390 = state_19349__$1;
(statearr_19357_19390[(2)] = null);

(statearr_19357_19390[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (3))){
var inst_19347 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19349__$1,inst_19347);
} else {
if((state_val_19350 === (12))){
var inst_19335 = (state_19349[(8)]);
var inst_19335__$1 = (state_19349[(2)]);
var inst_19336 = cljs.core.some(cljs.core.nil_QMARK_,inst_19335__$1);
var state_19349__$1 = (function (){var statearr_19358 = state_19349;
(statearr_19358[(8)] = inst_19335__$1);

return statearr_19358;
})();
if(cljs.core.truth_(inst_19336)){
var statearr_19359_19391 = state_19349__$1;
(statearr_19359_19391[(1)] = (13));

} else {
var statearr_19360_19392 = state_19349__$1;
(statearr_19360_19392[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (2))){
var inst_19312 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_19313 = (0);
var state_19349__$1 = (function (){var statearr_19361 = state_19349;
(statearr_19361[(7)] = inst_19313);

(statearr_19361[(9)] = inst_19312);

return statearr_19361;
})();
var statearr_19362_19393 = state_19349__$1;
(statearr_19362_19393[(2)] = null);

(statearr_19362_19393[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (11))){
var inst_19313 = (state_19349[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_19349,(10),Object,null,(9));
var inst_19322 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_19313) : chs__$1.call(null,inst_19313));
var inst_19323 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_19313) : done.call(null,inst_19313));
var inst_19324 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19322,inst_19323);
var state_19349__$1 = state_19349;
var statearr_19363_19394 = state_19349__$1;
(statearr_19363_19394[(2)] = inst_19324);


cljs.core.async.impl.ioc_helpers.process_exception(state_19349__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (9))){
var inst_19313 = (state_19349[(7)]);
var inst_19326 = (state_19349[(2)]);
var inst_19327 = (inst_19313 + (1));
var inst_19313__$1 = inst_19327;
var state_19349__$1 = (function (){var statearr_19364 = state_19349;
(statearr_19364[(7)] = inst_19313__$1);

(statearr_19364[(10)] = inst_19326);

return statearr_19364;
})();
var statearr_19365_19395 = state_19349__$1;
(statearr_19365_19395[(2)] = null);

(statearr_19365_19395[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (5))){
var inst_19333 = (state_19349[(2)]);
var state_19349__$1 = (function (){var statearr_19366 = state_19349;
(statearr_19366[(11)] = inst_19333);

return statearr_19366;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19349__$1,(12),dchan);
} else {
if((state_val_19350 === (14))){
var inst_19335 = (state_19349[(8)]);
var inst_19340 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_19335);
var state_19349__$1 = state_19349;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19349__$1,(16),out,inst_19340);
} else {
if((state_val_19350 === (16))){
var inst_19342 = (state_19349[(2)]);
var state_19349__$1 = (function (){var statearr_19367 = state_19349;
(statearr_19367[(12)] = inst_19342);

return statearr_19367;
})();
var statearr_19368_19396 = state_19349__$1;
(statearr_19368_19396[(2)] = null);

(statearr_19368_19396[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (10))){
var inst_19317 = (state_19349[(2)]);
var inst_19318 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_19349__$1 = (function (){var statearr_19369 = state_19349;
(statearr_19369[(13)] = inst_19317);

return statearr_19369;
})();
var statearr_19370_19397 = state_19349__$1;
(statearr_19370_19397[(2)] = inst_19318);


cljs.core.async.impl.ioc_helpers.process_exception(state_19349__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_19350 === (8))){
var inst_19331 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
var statearr_19371_19398 = state_19349__$1;
(statearr_19371_19398[(2)] = inst_19331);

(statearr_19371_19398[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___19383,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__17227__auto__,c__17341__auto___19383,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_19375 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19375[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_19375[(1)] = (1));

return statearr_19375;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_19349){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19349);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e19376){if((e19376 instanceof Object)){
var ex__17231__auto__ = e19376;
var statearr_19377_19399 = state_19349;
(statearr_19377_19399[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19349);

return cljs.core.cst$kw$recur;
} else {
throw e19376;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__19400 = state_19349;
state_19349 = G__19400;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_19349){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_19349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___19383,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__17343__auto__ = (function (){var statearr_19378 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_19378[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___19383);

return statearr_19378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___19383,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19402 = [];
var len__7211__auto___19458 = arguments.length;
var i__7212__auto___19459 = (0);
while(true){
if((i__7212__auto___19459 < len__7211__auto___19458)){
args19402.push((arguments[i__7212__auto___19459]));

var G__19460 = (i__7212__auto___19459 + (1));
i__7212__auto___19459 = G__19460;
continue;
} else {
}
break;
}

var G__19404 = args19402.length;
switch (G__19404) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19402.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17341__auto___19462 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___19462,out){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___19462,out){
return (function (state_19434){
var state_val_19435 = (state_19434[(1)]);
if((state_val_19435 === (7))){
var inst_19413 = (state_19434[(7)]);
var inst_19414 = (state_19434[(8)]);
var inst_19413__$1 = (state_19434[(2)]);
var inst_19414__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19413__$1,(0),null);
var inst_19415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19413__$1,(1),null);
var inst_19416 = (inst_19414__$1 == null);
var state_19434__$1 = (function (){var statearr_19436 = state_19434;
(statearr_19436[(7)] = inst_19413__$1);

(statearr_19436[(9)] = inst_19415);

(statearr_19436[(8)] = inst_19414__$1);

return statearr_19436;
})();
if(cljs.core.truth_(inst_19416)){
var statearr_19437_19463 = state_19434__$1;
(statearr_19437_19463[(1)] = (8));

} else {
var statearr_19438_19464 = state_19434__$1;
(statearr_19438_19464[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19435 === (1))){
var inst_19405 = cljs.core.vec(chs);
var inst_19406 = inst_19405;
var state_19434__$1 = (function (){var statearr_19439 = state_19434;
(statearr_19439[(10)] = inst_19406);

return statearr_19439;
})();
var statearr_19440_19465 = state_19434__$1;
(statearr_19440_19465[(2)] = null);

(statearr_19440_19465[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19435 === (4))){
var inst_19406 = (state_19434[(10)]);
var state_19434__$1 = state_19434;
return cljs.core.async.ioc_alts_BANG_(state_19434__$1,(7),inst_19406);
} else {
if((state_val_19435 === (6))){
var inst_19430 = (state_19434[(2)]);
var state_19434__$1 = state_19434;
var statearr_19441_19466 = state_19434__$1;
(statearr_19441_19466[(2)] = inst_19430);

(statearr_19441_19466[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19435 === (3))){
var inst_19432 = (state_19434[(2)]);
var state_19434__$1 = state_19434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19434__$1,inst_19432);
} else {
if((state_val_19435 === (2))){
var inst_19406 = (state_19434[(10)]);
var inst_19408 = cljs.core.count(inst_19406);
var inst_19409 = (inst_19408 > (0));
var state_19434__$1 = state_19434;
if(cljs.core.truth_(inst_19409)){
var statearr_19443_19467 = state_19434__$1;
(statearr_19443_19467[(1)] = (4));

} else {
var statearr_19444_19468 = state_19434__$1;
(statearr_19444_19468[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19435 === (11))){
var inst_19406 = (state_19434[(10)]);
var inst_19423 = (state_19434[(2)]);
var tmp19442 = inst_19406;
var inst_19406__$1 = tmp19442;
var state_19434__$1 = (function (){var statearr_19445 = state_19434;
(statearr_19445[(10)] = inst_19406__$1);

(statearr_19445[(11)] = inst_19423);

return statearr_19445;
})();
var statearr_19446_19469 = state_19434__$1;
(statearr_19446_19469[(2)] = null);

(statearr_19446_19469[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19435 === (9))){
var inst_19414 = (state_19434[(8)]);
var state_19434__$1 = state_19434;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19434__$1,(11),out,inst_19414);
} else {
if((state_val_19435 === (5))){
var inst_19428 = cljs.core.async.close_BANG_(out);
var state_19434__$1 = state_19434;
var statearr_19447_19470 = state_19434__$1;
(statearr_19447_19470[(2)] = inst_19428);

(statearr_19447_19470[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19435 === (10))){
var inst_19426 = (state_19434[(2)]);
var state_19434__$1 = state_19434;
var statearr_19448_19471 = state_19434__$1;
(statearr_19448_19471[(2)] = inst_19426);

(statearr_19448_19471[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19435 === (8))){
var inst_19406 = (state_19434[(10)]);
var inst_19413 = (state_19434[(7)]);
var inst_19415 = (state_19434[(9)]);
var inst_19414 = (state_19434[(8)]);
var inst_19418 = (function (){var cs = inst_19406;
var vec__19411 = inst_19413;
var v = inst_19414;
var c = inst_19415;
return ((function (cs,vec__19411,v,c,inst_19406,inst_19413,inst_19415,inst_19414,state_val_19435,c__17341__auto___19462,out){
return (function (p1__19401_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__19401_SHARP_);
});
;})(cs,vec__19411,v,c,inst_19406,inst_19413,inst_19415,inst_19414,state_val_19435,c__17341__auto___19462,out))
})();
var inst_19419 = cljs.core.filterv(inst_19418,inst_19406);
var inst_19406__$1 = inst_19419;
var state_19434__$1 = (function (){var statearr_19449 = state_19434;
(statearr_19449[(10)] = inst_19406__$1);

return statearr_19449;
})();
var statearr_19450_19472 = state_19434__$1;
(statearr_19450_19472[(2)] = null);

(statearr_19450_19472[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___19462,out))
;
return ((function (switch__17227__auto__,c__17341__auto___19462,out){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_19454 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19454[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_19454[(1)] = (1));

return statearr_19454;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_19434){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19434);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e19455){if((e19455 instanceof Object)){
var ex__17231__auto__ = e19455;
var statearr_19456_19473 = state_19434;
(statearr_19456_19473[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19434);

return cljs.core.cst$kw$recur;
} else {
throw e19455;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__19474 = state_19434;
state_19434 = G__19474;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_19434){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_19434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___19462,out))
})();
var state__17343__auto__ = (function (){var statearr_19457 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_19457[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___19462);

return statearr_19457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___19462,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19475 = [];
var len__7211__auto___19524 = arguments.length;
var i__7212__auto___19525 = (0);
while(true){
if((i__7212__auto___19525 < len__7211__auto___19524)){
args19475.push((arguments[i__7212__auto___19525]));

var G__19526 = (i__7212__auto___19525 + (1));
i__7212__auto___19525 = G__19526;
continue;
} else {
}
break;
}

var G__19477 = args19475.length;
switch (G__19477) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19475.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17341__auto___19528 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___19528,out){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___19528,out){
return (function (state_19501){
var state_val_19502 = (state_19501[(1)]);
if((state_val_19502 === (7))){
var inst_19483 = (state_19501[(7)]);
var inst_19483__$1 = (state_19501[(2)]);
var inst_19484 = (inst_19483__$1 == null);
var inst_19485 = cljs.core.not(inst_19484);
var state_19501__$1 = (function (){var statearr_19503 = state_19501;
(statearr_19503[(7)] = inst_19483__$1);

return statearr_19503;
})();
if(inst_19485){
var statearr_19504_19529 = state_19501__$1;
(statearr_19504_19529[(1)] = (8));

} else {
var statearr_19505_19530 = state_19501__$1;
(statearr_19505_19530[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19502 === (1))){
var inst_19478 = (0);
var state_19501__$1 = (function (){var statearr_19506 = state_19501;
(statearr_19506[(8)] = inst_19478);

return statearr_19506;
})();
var statearr_19507_19531 = state_19501__$1;
(statearr_19507_19531[(2)] = null);

(statearr_19507_19531[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19502 === (4))){
var state_19501__$1 = state_19501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19501__$1,(7),ch);
} else {
if((state_val_19502 === (6))){
var inst_19496 = (state_19501[(2)]);
var state_19501__$1 = state_19501;
var statearr_19508_19532 = state_19501__$1;
(statearr_19508_19532[(2)] = inst_19496);

(statearr_19508_19532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19502 === (3))){
var inst_19498 = (state_19501[(2)]);
var inst_19499 = cljs.core.async.close_BANG_(out);
var state_19501__$1 = (function (){var statearr_19509 = state_19501;
(statearr_19509[(9)] = inst_19498);

return statearr_19509;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19501__$1,inst_19499);
} else {
if((state_val_19502 === (2))){
var inst_19478 = (state_19501[(8)]);
var inst_19480 = (inst_19478 < n);
var state_19501__$1 = state_19501;
if(cljs.core.truth_(inst_19480)){
var statearr_19510_19533 = state_19501__$1;
(statearr_19510_19533[(1)] = (4));

} else {
var statearr_19511_19534 = state_19501__$1;
(statearr_19511_19534[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19502 === (11))){
var inst_19478 = (state_19501[(8)]);
var inst_19488 = (state_19501[(2)]);
var inst_19489 = (inst_19478 + (1));
var inst_19478__$1 = inst_19489;
var state_19501__$1 = (function (){var statearr_19512 = state_19501;
(statearr_19512[(8)] = inst_19478__$1);

(statearr_19512[(10)] = inst_19488);

return statearr_19512;
})();
var statearr_19513_19535 = state_19501__$1;
(statearr_19513_19535[(2)] = null);

(statearr_19513_19535[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19502 === (9))){
var state_19501__$1 = state_19501;
var statearr_19514_19536 = state_19501__$1;
(statearr_19514_19536[(2)] = null);

(statearr_19514_19536[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19502 === (5))){
var state_19501__$1 = state_19501;
var statearr_19515_19537 = state_19501__$1;
(statearr_19515_19537[(2)] = null);

(statearr_19515_19537[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19502 === (10))){
var inst_19493 = (state_19501[(2)]);
var state_19501__$1 = state_19501;
var statearr_19516_19538 = state_19501__$1;
(statearr_19516_19538[(2)] = inst_19493);

(statearr_19516_19538[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19502 === (8))){
var inst_19483 = (state_19501[(7)]);
var state_19501__$1 = state_19501;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19501__$1,(11),out,inst_19483);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___19528,out))
;
return ((function (switch__17227__auto__,c__17341__auto___19528,out){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_19520 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19520[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_19520[(1)] = (1));

return statearr_19520;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_19501){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19501);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e19521){if((e19521 instanceof Object)){
var ex__17231__auto__ = e19521;
var statearr_19522_19539 = state_19501;
(statearr_19522_19539[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19501);

return cljs.core.cst$kw$recur;
} else {
throw e19521;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__19540 = state_19501;
state_19501 = G__19540;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_19501){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_19501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___19528,out))
})();
var state__17343__auto__ = (function (){var statearr_19523 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_19523[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___19528);

return statearr_19523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___19528,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19550 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19550 = (function (map_LT_,f,ch,meta19551){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19551 = meta19551;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19552,meta19551__$1){
var self__ = this;
var _19552__$1 = this;
return (new cljs.core.async.t_cljs$core$async19550(self__.map_LT_,self__.f,self__.ch,meta19551__$1));
});

cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19552){
var self__ = this;
var _19552__$1 = this;
return self__.meta19551;
});

cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19553 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19553 = (function (map_LT_,f,ch,meta19551,_,fn1,meta19554){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19551 = meta19551;
this._ = _;
this.fn1 = fn1;
this.meta19554 = meta19554;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19553.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19555,meta19554__$1){
var self__ = this;
var _19555__$1 = this;
return (new cljs.core.async.t_cljs$core$async19553(self__.map_LT_,self__.f,self__.ch,self__.meta19551,self__._,self__.fn1,meta19554__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19553.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19555){
var self__ = this;
var _19555__$1 = this;
return self__.meta19554;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19553.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19553.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19553.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19553.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19541_SHARP_){
var G__19556 = (((p1__19541_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__19541_SHARP_) : self__.f.call(null,p1__19541_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__19556) : f1.call(null,G__19556));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19553.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19551,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async19550], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta19554], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19553.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19553.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19553";

cljs.core.async.t_cljs$core$async19553.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async19553");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19553 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19553(map_LT___$1,f__$1,ch__$1,meta19551__$1,___$2,fn1__$1,meta19554){
return (new cljs.core.async.t_cljs$core$async19553(map_LT___$1,f__$1,ch__$1,meta19551__$1,___$2,fn1__$1,meta19554));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19553(self__.map_LT_,self__.f,self__.ch,self__.meta19551,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6141__auto__ = ret;
if(cljs.core.truth_(and__6141__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6141__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__19557 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__19557) : self__.f.call(null,G__19557));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19550.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19550.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19551], null);
});

cljs.core.async.t_cljs$core$async19550.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19550.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19550";

cljs.core.async.t_cljs$core$async19550.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async19550");
});

cljs.core.async.__GT_t_cljs$core$async19550 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19550(map_LT___$1,f__$1,ch__$1,meta19551){
return (new cljs.core.async.t_cljs$core$async19550(map_LT___$1,f__$1,ch__$1,meta19551));
});

}

return (new cljs.core.async.t_cljs$core$async19550(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19561 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19561 = (function (map_GT_,f,ch,meta19562){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19562 = meta19562;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19561.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19563,meta19562__$1){
var self__ = this;
var _19563__$1 = this;
return (new cljs.core.async.t_cljs$core$async19561(self__.map_GT_,self__.f,self__.ch,meta19562__$1));
});

cljs.core.async.t_cljs$core$async19561.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19563){
var self__ = this;
var _19563__$1 = this;
return self__.meta19562;
});

cljs.core.async.t_cljs$core$async19561.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19561.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19561.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19561.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19561.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19561.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async19561.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19562], null);
});

cljs.core.async.t_cljs$core$async19561.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19561.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19561";

cljs.core.async.t_cljs$core$async19561.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async19561");
});

cljs.core.async.__GT_t_cljs$core$async19561 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19561(map_GT___$1,f__$1,ch__$1,meta19562){
return (new cljs.core.async.t_cljs$core$async19561(map_GT___$1,f__$1,ch__$1,meta19562));
});

}

return (new cljs.core.async.t_cljs$core$async19561(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19567 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19567 = (function (filter_GT_,p,ch,meta19568){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19568 = meta19568;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19569,meta19568__$1){
var self__ = this;
var _19569__$1 = this;
return (new cljs.core.async.t_cljs$core$async19567(self__.filter_GT_,self__.p,self__.ch,meta19568__$1));
});

cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19569){
var self__ = this;
var _19569__$1 = this;
return self__.meta19568;
});

cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19567.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19567.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19568], null);
});

cljs.core.async.t_cljs$core$async19567.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19567.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19567";

cljs.core.async.t_cljs$core$async19567.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async19567");
});

cljs.core.async.__GT_t_cljs$core$async19567 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19567(filter_GT___$1,p__$1,ch__$1,meta19568){
return (new cljs.core.async.t_cljs$core$async19567(filter_GT___$1,p__$1,ch__$1,meta19568));
});

}

return (new cljs.core.async.t_cljs$core$async19567(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19570 = [];
var len__7211__auto___19614 = arguments.length;
var i__7212__auto___19615 = (0);
while(true){
if((i__7212__auto___19615 < len__7211__auto___19614)){
args19570.push((arguments[i__7212__auto___19615]));

var G__19616 = (i__7212__auto___19615 + (1));
i__7212__auto___19615 = G__19616;
continue;
} else {
}
break;
}

var G__19572 = args19570.length;
switch (G__19572) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19570.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17341__auto___19618 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___19618,out){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___19618,out){
return (function (state_19593){
var state_val_19594 = (state_19593[(1)]);
if((state_val_19594 === (7))){
var inst_19589 = (state_19593[(2)]);
var state_19593__$1 = state_19593;
var statearr_19595_19619 = state_19593__$1;
(statearr_19595_19619[(2)] = inst_19589);

(statearr_19595_19619[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19594 === (1))){
var state_19593__$1 = state_19593;
var statearr_19596_19620 = state_19593__$1;
(statearr_19596_19620[(2)] = null);

(statearr_19596_19620[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19594 === (4))){
var inst_19575 = (state_19593[(7)]);
var inst_19575__$1 = (state_19593[(2)]);
var inst_19576 = (inst_19575__$1 == null);
var state_19593__$1 = (function (){var statearr_19597 = state_19593;
(statearr_19597[(7)] = inst_19575__$1);

return statearr_19597;
})();
if(cljs.core.truth_(inst_19576)){
var statearr_19598_19621 = state_19593__$1;
(statearr_19598_19621[(1)] = (5));

} else {
var statearr_19599_19622 = state_19593__$1;
(statearr_19599_19622[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19594 === (6))){
var inst_19575 = (state_19593[(7)]);
var inst_19580 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_19575) : p.call(null,inst_19575));
var state_19593__$1 = state_19593;
if(cljs.core.truth_(inst_19580)){
var statearr_19600_19623 = state_19593__$1;
(statearr_19600_19623[(1)] = (8));

} else {
var statearr_19601_19624 = state_19593__$1;
(statearr_19601_19624[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19594 === (3))){
var inst_19591 = (state_19593[(2)]);
var state_19593__$1 = state_19593;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19593__$1,inst_19591);
} else {
if((state_val_19594 === (2))){
var state_19593__$1 = state_19593;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19593__$1,(4),ch);
} else {
if((state_val_19594 === (11))){
var inst_19583 = (state_19593[(2)]);
var state_19593__$1 = state_19593;
var statearr_19602_19625 = state_19593__$1;
(statearr_19602_19625[(2)] = inst_19583);

(statearr_19602_19625[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19594 === (9))){
var state_19593__$1 = state_19593;
var statearr_19603_19626 = state_19593__$1;
(statearr_19603_19626[(2)] = null);

(statearr_19603_19626[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19594 === (5))){
var inst_19578 = cljs.core.async.close_BANG_(out);
var state_19593__$1 = state_19593;
var statearr_19604_19627 = state_19593__$1;
(statearr_19604_19627[(2)] = inst_19578);

(statearr_19604_19627[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19594 === (10))){
var inst_19586 = (state_19593[(2)]);
var state_19593__$1 = (function (){var statearr_19605 = state_19593;
(statearr_19605[(8)] = inst_19586);

return statearr_19605;
})();
var statearr_19606_19628 = state_19593__$1;
(statearr_19606_19628[(2)] = null);

(statearr_19606_19628[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19594 === (8))){
var inst_19575 = (state_19593[(7)]);
var state_19593__$1 = state_19593;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19593__$1,(11),out,inst_19575);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___19618,out))
;
return ((function (switch__17227__auto__,c__17341__auto___19618,out){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_19610 = [null,null,null,null,null,null,null,null,null];
(statearr_19610[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_19610[(1)] = (1));

return statearr_19610;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_19593){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19593);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e19611){if((e19611 instanceof Object)){
var ex__17231__auto__ = e19611;
var statearr_19612_19629 = state_19593;
(statearr_19612_19629[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19593);

return cljs.core.cst$kw$recur;
} else {
throw e19611;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__19630 = state_19593;
state_19593 = G__19630;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_19593){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_19593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___19618,out))
})();
var state__17343__auto__ = (function (){var statearr_19613 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_19613[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___19618);

return statearr_19613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___19618,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19631 = [];
var len__7211__auto___19634 = arguments.length;
var i__7212__auto___19635 = (0);
while(true){
if((i__7212__auto___19635 < len__7211__auto___19634)){
args19631.push((arguments[i__7212__auto___19635]));

var G__19636 = (i__7212__auto___19635 + (1));
i__7212__auto___19635 = G__19636;
continue;
} else {
}
break;
}

var G__19633 = args19631.length;
switch (G__19633) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19631.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__17341__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto__){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto__){
return (function (state_19803){
var state_val_19804 = (state_19803[(1)]);
if((state_val_19804 === (7))){
var inst_19799 = (state_19803[(2)]);
var state_19803__$1 = state_19803;
var statearr_19805_19846 = state_19803__$1;
(statearr_19805_19846[(2)] = inst_19799);

(statearr_19805_19846[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (20))){
var inst_19769 = (state_19803[(7)]);
var inst_19780 = (state_19803[(2)]);
var inst_19781 = cljs.core.next(inst_19769);
var inst_19755 = inst_19781;
var inst_19756 = null;
var inst_19757 = (0);
var inst_19758 = (0);
var state_19803__$1 = (function (){var statearr_19806 = state_19803;
(statearr_19806[(8)] = inst_19755);

(statearr_19806[(9)] = inst_19757);

(statearr_19806[(10)] = inst_19780);

(statearr_19806[(11)] = inst_19758);

(statearr_19806[(12)] = inst_19756);

return statearr_19806;
})();
var statearr_19807_19847 = state_19803__$1;
(statearr_19807_19847[(2)] = null);

(statearr_19807_19847[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (1))){
var state_19803__$1 = state_19803;
var statearr_19808_19848 = state_19803__$1;
(statearr_19808_19848[(2)] = null);

(statearr_19808_19848[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (4))){
var inst_19744 = (state_19803[(13)]);
var inst_19744__$1 = (state_19803[(2)]);
var inst_19745 = (inst_19744__$1 == null);
var state_19803__$1 = (function (){var statearr_19809 = state_19803;
(statearr_19809[(13)] = inst_19744__$1);

return statearr_19809;
})();
if(cljs.core.truth_(inst_19745)){
var statearr_19810_19849 = state_19803__$1;
(statearr_19810_19849[(1)] = (5));

} else {
var statearr_19811_19850 = state_19803__$1;
(statearr_19811_19850[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (15))){
var state_19803__$1 = state_19803;
var statearr_19815_19851 = state_19803__$1;
(statearr_19815_19851[(2)] = null);

(statearr_19815_19851[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (21))){
var state_19803__$1 = state_19803;
var statearr_19816_19852 = state_19803__$1;
(statearr_19816_19852[(2)] = null);

(statearr_19816_19852[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (13))){
var inst_19755 = (state_19803[(8)]);
var inst_19757 = (state_19803[(9)]);
var inst_19758 = (state_19803[(11)]);
var inst_19756 = (state_19803[(12)]);
var inst_19765 = (state_19803[(2)]);
var inst_19766 = (inst_19758 + (1));
var tmp19812 = inst_19755;
var tmp19813 = inst_19757;
var tmp19814 = inst_19756;
var inst_19755__$1 = tmp19812;
var inst_19756__$1 = tmp19814;
var inst_19757__$1 = tmp19813;
var inst_19758__$1 = inst_19766;
var state_19803__$1 = (function (){var statearr_19817 = state_19803;
(statearr_19817[(8)] = inst_19755__$1);

(statearr_19817[(9)] = inst_19757__$1);

(statearr_19817[(14)] = inst_19765);

(statearr_19817[(11)] = inst_19758__$1);

(statearr_19817[(12)] = inst_19756__$1);

return statearr_19817;
})();
var statearr_19818_19853 = state_19803__$1;
(statearr_19818_19853[(2)] = null);

(statearr_19818_19853[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (22))){
var state_19803__$1 = state_19803;
var statearr_19819_19854 = state_19803__$1;
(statearr_19819_19854[(2)] = null);

(statearr_19819_19854[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (6))){
var inst_19744 = (state_19803[(13)]);
var inst_19753 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_19744) : f.call(null,inst_19744));
var inst_19754 = cljs.core.seq(inst_19753);
var inst_19755 = inst_19754;
var inst_19756 = null;
var inst_19757 = (0);
var inst_19758 = (0);
var state_19803__$1 = (function (){var statearr_19820 = state_19803;
(statearr_19820[(8)] = inst_19755);

(statearr_19820[(9)] = inst_19757);

(statearr_19820[(11)] = inst_19758);

(statearr_19820[(12)] = inst_19756);

return statearr_19820;
})();
var statearr_19821_19855 = state_19803__$1;
(statearr_19821_19855[(2)] = null);

(statearr_19821_19855[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (17))){
var inst_19769 = (state_19803[(7)]);
var inst_19773 = cljs.core.chunk_first(inst_19769);
var inst_19774 = cljs.core.chunk_rest(inst_19769);
var inst_19775 = cljs.core.count(inst_19773);
var inst_19755 = inst_19774;
var inst_19756 = inst_19773;
var inst_19757 = inst_19775;
var inst_19758 = (0);
var state_19803__$1 = (function (){var statearr_19822 = state_19803;
(statearr_19822[(8)] = inst_19755);

(statearr_19822[(9)] = inst_19757);

(statearr_19822[(11)] = inst_19758);

(statearr_19822[(12)] = inst_19756);

return statearr_19822;
})();
var statearr_19823_19856 = state_19803__$1;
(statearr_19823_19856[(2)] = null);

(statearr_19823_19856[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (3))){
var inst_19801 = (state_19803[(2)]);
var state_19803__$1 = state_19803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19803__$1,inst_19801);
} else {
if((state_val_19804 === (12))){
var inst_19789 = (state_19803[(2)]);
var state_19803__$1 = state_19803;
var statearr_19824_19857 = state_19803__$1;
(statearr_19824_19857[(2)] = inst_19789);

(statearr_19824_19857[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (2))){
var state_19803__$1 = state_19803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19803__$1,(4),in$);
} else {
if((state_val_19804 === (23))){
var inst_19797 = (state_19803[(2)]);
var state_19803__$1 = state_19803;
var statearr_19825_19858 = state_19803__$1;
(statearr_19825_19858[(2)] = inst_19797);

(statearr_19825_19858[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (19))){
var inst_19784 = (state_19803[(2)]);
var state_19803__$1 = state_19803;
var statearr_19826_19859 = state_19803__$1;
(statearr_19826_19859[(2)] = inst_19784);

(statearr_19826_19859[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (11))){
var inst_19755 = (state_19803[(8)]);
var inst_19769 = (state_19803[(7)]);
var inst_19769__$1 = cljs.core.seq(inst_19755);
var state_19803__$1 = (function (){var statearr_19827 = state_19803;
(statearr_19827[(7)] = inst_19769__$1);

return statearr_19827;
})();
if(inst_19769__$1){
var statearr_19828_19860 = state_19803__$1;
(statearr_19828_19860[(1)] = (14));

} else {
var statearr_19829_19861 = state_19803__$1;
(statearr_19829_19861[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (9))){
var inst_19791 = (state_19803[(2)]);
var inst_19792 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_19803__$1 = (function (){var statearr_19830 = state_19803;
(statearr_19830[(15)] = inst_19791);

return statearr_19830;
})();
if(cljs.core.truth_(inst_19792)){
var statearr_19831_19862 = state_19803__$1;
(statearr_19831_19862[(1)] = (21));

} else {
var statearr_19832_19863 = state_19803__$1;
(statearr_19832_19863[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (5))){
var inst_19747 = cljs.core.async.close_BANG_(out);
var state_19803__$1 = state_19803;
var statearr_19833_19864 = state_19803__$1;
(statearr_19833_19864[(2)] = inst_19747);

(statearr_19833_19864[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (14))){
var inst_19769 = (state_19803[(7)]);
var inst_19771 = cljs.core.chunked_seq_QMARK_(inst_19769);
var state_19803__$1 = state_19803;
if(inst_19771){
var statearr_19834_19865 = state_19803__$1;
(statearr_19834_19865[(1)] = (17));

} else {
var statearr_19835_19866 = state_19803__$1;
(statearr_19835_19866[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (16))){
var inst_19787 = (state_19803[(2)]);
var state_19803__$1 = state_19803;
var statearr_19836_19867 = state_19803__$1;
(statearr_19836_19867[(2)] = inst_19787);

(statearr_19836_19867[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19804 === (10))){
var inst_19758 = (state_19803[(11)]);
var inst_19756 = (state_19803[(12)]);
var inst_19763 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19756,inst_19758);
var state_19803__$1 = state_19803;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19803__$1,(13),out,inst_19763);
} else {
if((state_val_19804 === (18))){
var inst_19769 = (state_19803[(7)]);
var inst_19778 = cljs.core.first(inst_19769);
var state_19803__$1 = state_19803;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19803__$1,(20),out,inst_19778);
} else {
if((state_val_19804 === (8))){
var inst_19757 = (state_19803[(9)]);
var inst_19758 = (state_19803[(11)]);
var inst_19760 = (inst_19758 < inst_19757);
var inst_19761 = inst_19760;
var state_19803__$1 = state_19803;
if(cljs.core.truth_(inst_19761)){
var statearr_19837_19868 = state_19803__$1;
(statearr_19837_19868[(1)] = (10));

} else {
var statearr_19838_19869 = state_19803__$1;
(statearr_19838_19869[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto__))
;
return ((function (switch__17227__auto__,c__17341__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17228__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17228__auto____0 = (function (){
var statearr_19842 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19842[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17228__auto__);

(statearr_19842[(1)] = (1));

return statearr_19842;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17228__auto____1 = (function (state_19803){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19803);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e19843){if((e19843 instanceof Object)){
var ex__17231__auto__ = e19843;
var statearr_19844_19870 = state_19803;
(statearr_19844_19870[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19803);

return cljs.core.cst$kw$recur;
} else {
throw e19843;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__19871 = state_19803;
state_19803 = G__19871;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17228__auto__ = function(state_19803){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17228__auto____1.call(this,state_19803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17228__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17228__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto__))
})();
var state__17343__auto__ = (function (){var statearr_19845 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_19845[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto__);

return statearr_19845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto__))
);

return c__17341__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19872 = [];
var len__7211__auto___19875 = arguments.length;
var i__7212__auto___19876 = (0);
while(true){
if((i__7212__auto___19876 < len__7211__auto___19875)){
args19872.push((arguments[i__7212__auto___19876]));

var G__19877 = (i__7212__auto___19876 + (1));
i__7212__auto___19876 = G__19877;
continue;
} else {
}
break;
}

var G__19874 = args19872.length;
switch (G__19874) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19872.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19879 = [];
var len__7211__auto___19882 = arguments.length;
var i__7212__auto___19883 = (0);
while(true){
if((i__7212__auto___19883 < len__7211__auto___19882)){
args19879.push((arguments[i__7212__auto___19883]));

var G__19884 = (i__7212__auto___19883 + (1));
i__7212__auto___19883 = G__19884;
continue;
} else {
}
break;
}

var G__19881 = args19879.length;
switch (G__19881) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19879.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19886 = [];
var len__7211__auto___19937 = arguments.length;
var i__7212__auto___19938 = (0);
while(true){
if((i__7212__auto___19938 < len__7211__auto___19937)){
args19886.push((arguments[i__7212__auto___19938]));

var G__19939 = (i__7212__auto___19938 + (1));
i__7212__auto___19938 = G__19939;
continue;
} else {
}
break;
}

var G__19888 = args19886.length;
switch (G__19888) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19886.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17341__auto___19941 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___19941,out){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___19941,out){
return (function (state_19912){
var state_val_19913 = (state_19912[(1)]);
if((state_val_19913 === (7))){
var inst_19907 = (state_19912[(2)]);
var state_19912__$1 = state_19912;
var statearr_19914_19942 = state_19912__$1;
(statearr_19914_19942[(2)] = inst_19907);

(statearr_19914_19942[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19913 === (1))){
var inst_19889 = null;
var state_19912__$1 = (function (){var statearr_19915 = state_19912;
(statearr_19915[(7)] = inst_19889);

return statearr_19915;
})();
var statearr_19916_19943 = state_19912__$1;
(statearr_19916_19943[(2)] = null);

(statearr_19916_19943[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19913 === (4))){
var inst_19892 = (state_19912[(8)]);
var inst_19892__$1 = (state_19912[(2)]);
var inst_19893 = (inst_19892__$1 == null);
var inst_19894 = cljs.core.not(inst_19893);
var state_19912__$1 = (function (){var statearr_19917 = state_19912;
(statearr_19917[(8)] = inst_19892__$1);

return statearr_19917;
})();
if(inst_19894){
var statearr_19918_19944 = state_19912__$1;
(statearr_19918_19944[(1)] = (5));

} else {
var statearr_19919_19945 = state_19912__$1;
(statearr_19919_19945[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19913 === (6))){
var state_19912__$1 = state_19912;
var statearr_19920_19946 = state_19912__$1;
(statearr_19920_19946[(2)] = null);

(statearr_19920_19946[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19913 === (3))){
var inst_19909 = (state_19912[(2)]);
var inst_19910 = cljs.core.async.close_BANG_(out);
var state_19912__$1 = (function (){var statearr_19921 = state_19912;
(statearr_19921[(9)] = inst_19909);

return statearr_19921;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19912__$1,inst_19910);
} else {
if((state_val_19913 === (2))){
var state_19912__$1 = state_19912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19912__$1,(4),ch);
} else {
if((state_val_19913 === (11))){
var inst_19892 = (state_19912[(8)]);
var inst_19901 = (state_19912[(2)]);
var inst_19889 = inst_19892;
var state_19912__$1 = (function (){var statearr_19922 = state_19912;
(statearr_19922[(7)] = inst_19889);

(statearr_19922[(10)] = inst_19901);

return statearr_19922;
})();
var statearr_19923_19947 = state_19912__$1;
(statearr_19923_19947[(2)] = null);

(statearr_19923_19947[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19913 === (9))){
var inst_19892 = (state_19912[(8)]);
var state_19912__$1 = state_19912;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19912__$1,(11),out,inst_19892);
} else {
if((state_val_19913 === (5))){
var inst_19889 = (state_19912[(7)]);
var inst_19892 = (state_19912[(8)]);
var inst_19896 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19892,inst_19889);
var state_19912__$1 = state_19912;
if(inst_19896){
var statearr_19925_19948 = state_19912__$1;
(statearr_19925_19948[(1)] = (8));

} else {
var statearr_19926_19949 = state_19912__$1;
(statearr_19926_19949[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19913 === (10))){
var inst_19904 = (state_19912[(2)]);
var state_19912__$1 = state_19912;
var statearr_19927_19950 = state_19912__$1;
(statearr_19927_19950[(2)] = inst_19904);

(statearr_19927_19950[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19913 === (8))){
var inst_19889 = (state_19912[(7)]);
var tmp19924 = inst_19889;
var inst_19889__$1 = tmp19924;
var state_19912__$1 = (function (){var statearr_19928 = state_19912;
(statearr_19928[(7)] = inst_19889__$1);

return statearr_19928;
})();
var statearr_19929_19951 = state_19912__$1;
(statearr_19929_19951[(2)] = null);

(statearr_19929_19951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___19941,out))
;
return ((function (switch__17227__auto__,c__17341__auto___19941,out){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_19933 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19933[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_19933[(1)] = (1));

return statearr_19933;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_19912){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19912);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e19934){if((e19934 instanceof Object)){
var ex__17231__auto__ = e19934;
var statearr_19935_19952 = state_19912;
(statearr_19935_19952[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19912);

return cljs.core.cst$kw$recur;
} else {
throw e19934;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__19953 = state_19912;
state_19912 = G__19953;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_19912){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_19912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___19941,out))
})();
var state__17343__auto__ = (function (){var statearr_19936 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_19936[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___19941);

return statearr_19936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___19941,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19954 = [];
var len__7211__auto___20024 = arguments.length;
var i__7212__auto___20025 = (0);
while(true){
if((i__7212__auto___20025 < len__7211__auto___20024)){
args19954.push((arguments[i__7212__auto___20025]));

var G__20026 = (i__7212__auto___20025 + (1));
i__7212__auto___20025 = G__20026;
continue;
} else {
}
break;
}

var G__19956 = args19954.length;
switch (G__19956) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19954.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17341__auto___20028 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___20028,out){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___20028,out){
return (function (state_19994){
var state_val_19995 = (state_19994[(1)]);
if((state_val_19995 === (7))){
var inst_19990 = (state_19994[(2)]);
var state_19994__$1 = state_19994;
var statearr_19996_20029 = state_19994__$1;
(statearr_19996_20029[(2)] = inst_19990);

(statearr_19996_20029[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (1))){
var inst_19957 = (new Array(n));
var inst_19958 = inst_19957;
var inst_19959 = (0);
var state_19994__$1 = (function (){var statearr_19997 = state_19994;
(statearr_19997[(7)] = inst_19958);

(statearr_19997[(8)] = inst_19959);

return statearr_19997;
})();
var statearr_19998_20030 = state_19994__$1;
(statearr_19998_20030[(2)] = null);

(statearr_19998_20030[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (4))){
var inst_19962 = (state_19994[(9)]);
var inst_19962__$1 = (state_19994[(2)]);
var inst_19963 = (inst_19962__$1 == null);
var inst_19964 = cljs.core.not(inst_19963);
var state_19994__$1 = (function (){var statearr_19999 = state_19994;
(statearr_19999[(9)] = inst_19962__$1);

return statearr_19999;
})();
if(inst_19964){
var statearr_20000_20031 = state_19994__$1;
(statearr_20000_20031[(1)] = (5));

} else {
var statearr_20001_20032 = state_19994__$1;
(statearr_20001_20032[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (15))){
var inst_19984 = (state_19994[(2)]);
var state_19994__$1 = state_19994;
var statearr_20002_20033 = state_19994__$1;
(statearr_20002_20033[(2)] = inst_19984);

(statearr_20002_20033[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (13))){
var state_19994__$1 = state_19994;
var statearr_20003_20034 = state_19994__$1;
(statearr_20003_20034[(2)] = null);

(statearr_20003_20034[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (6))){
var inst_19959 = (state_19994[(8)]);
var inst_19980 = (inst_19959 > (0));
var state_19994__$1 = state_19994;
if(cljs.core.truth_(inst_19980)){
var statearr_20004_20035 = state_19994__$1;
(statearr_20004_20035[(1)] = (12));

} else {
var statearr_20005_20036 = state_19994__$1;
(statearr_20005_20036[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (3))){
var inst_19992 = (state_19994[(2)]);
var state_19994__$1 = state_19994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19994__$1,inst_19992);
} else {
if((state_val_19995 === (12))){
var inst_19958 = (state_19994[(7)]);
var inst_19982 = cljs.core.vec(inst_19958);
var state_19994__$1 = state_19994;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19994__$1,(15),out,inst_19982);
} else {
if((state_val_19995 === (2))){
var state_19994__$1 = state_19994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19994__$1,(4),ch);
} else {
if((state_val_19995 === (11))){
var inst_19974 = (state_19994[(2)]);
var inst_19975 = (new Array(n));
var inst_19958 = inst_19975;
var inst_19959 = (0);
var state_19994__$1 = (function (){var statearr_20006 = state_19994;
(statearr_20006[(7)] = inst_19958);

(statearr_20006[(10)] = inst_19974);

(statearr_20006[(8)] = inst_19959);

return statearr_20006;
})();
var statearr_20007_20037 = state_19994__$1;
(statearr_20007_20037[(2)] = null);

(statearr_20007_20037[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (9))){
var inst_19958 = (state_19994[(7)]);
var inst_19972 = cljs.core.vec(inst_19958);
var state_19994__$1 = state_19994;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19994__$1,(11),out,inst_19972);
} else {
if((state_val_19995 === (5))){
var inst_19967 = (state_19994[(11)]);
var inst_19958 = (state_19994[(7)]);
var inst_19962 = (state_19994[(9)]);
var inst_19959 = (state_19994[(8)]);
var inst_19966 = (inst_19958[inst_19959] = inst_19962);
var inst_19967__$1 = (inst_19959 + (1));
var inst_19968 = (inst_19967__$1 < n);
var state_19994__$1 = (function (){var statearr_20008 = state_19994;
(statearr_20008[(12)] = inst_19966);

(statearr_20008[(11)] = inst_19967__$1);

return statearr_20008;
})();
if(cljs.core.truth_(inst_19968)){
var statearr_20009_20038 = state_19994__$1;
(statearr_20009_20038[(1)] = (8));

} else {
var statearr_20010_20039 = state_19994__$1;
(statearr_20010_20039[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (14))){
var inst_19987 = (state_19994[(2)]);
var inst_19988 = cljs.core.async.close_BANG_(out);
var state_19994__$1 = (function (){var statearr_20012 = state_19994;
(statearr_20012[(13)] = inst_19987);

return statearr_20012;
})();
var statearr_20013_20040 = state_19994__$1;
(statearr_20013_20040[(2)] = inst_19988);

(statearr_20013_20040[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (10))){
var inst_19978 = (state_19994[(2)]);
var state_19994__$1 = state_19994;
var statearr_20014_20041 = state_19994__$1;
(statearr_20014_20041[(2)] = inst_19978);

(statearr_20014_20041[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19995 === (8))){
var inst_19967 = (state_19994[(11)]);
var inst_19958 = (state_19994[(7)]);
var tmp20011 = inst_19958;
var inst_19958__$1 = tmp20011;
var inst_19959 = inst_19967;
var state_19994__$1 = (function (){var statearr_20015 = state_19994;
(statearr_20015[(7)] = inst_19958__$1);

(statearr_20015[(8)] = inst_19959);

return statearr_20015;
})();
var statearr_20016_20042 = state_19994__$1;
(statearr_20016_20042[(2)] = null);

(statearr_20016_20042[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___20028,out))
;
return ((function (switch__17227__auto__,c__17341__auto___20028,out){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_20020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20020[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_20020[(1)] = (1));

return statearr_20020;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_19994){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_19994);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20021){if((e20021 instanceof Object)){
var ex__17231__auto__ = e20021;
var statearr_20022_20043 = state_19994;
(statearr_20022_20043[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19994);

return cljs.core.cst$kw$recur;
} else {
throw e20021;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__20044 = state_19994;
state_19994 = G__20044;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_19994){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_19994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___20028,out))
})();
var state__17343__auto__ = (function (){var statearr_20023 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20023[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___20028);

return statearr_20023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___20028,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args20045 = [];
var len__7211__auto___20119 = arguments.length;
var i__7212__auto___20120 = (0);
while(true){
if((i__7212__auto___20120 < len__7211__auto___20119)){
args20045.push((arguments[i__7212__auto___20120]));

var G__20121 = (i__7212__auto___20120 + (1));
i__7212__auto___20120 = G__20121;
continue;
} else {
}
break;
}

var G__20047 = args20045.length;
switch (G__20047) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20045.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17341__auto___20123 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___20123,out){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___20123,out){
return (function (state_20089){
var state_val_20090 = (state_20089[(1)]);
if((state_val_20090 === (7))){
var inst_20085 = (state_20089[(2)]);
var state_20089__$1 = state_20089;
var statearr_20091_20124 = state_20089__$1;
(statearr_20091_20124[(2)] = inst_20085);

(statearr_20091_20124[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (1))){
var inst_20048 = [];
var inst_20049 = inst_20048;
var inst_20050 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_20089__$1 = (function (){var statearr_20092 = state_20089;
(statearr_20092[(7)] = inst_20049);

(statearr_20092[(8)] = inst_20050);

return statearr_20092;
})();
var statearr_20093_20125 = state_20089__$1;
(statearr_20093_20125[(2)] = null);

(statearr_20093_20125[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (4))){
var inst_20053 = (state_20089[(9)]);
var inst_20053__$1 = (state_20089[(2)]);
var inst_20054 = (inst_20053__$1 == null);
var inst_20055 = cljs.core.not(inst_20054);
var state_20089__$1 = (function (){var statearr_20094 = state_20089;
(statearr_20094[(9)] = inst_20053__$1);

return statearr_20094;
})();
if(inst_20055){
var statearr_20095_20126 = state_20089__$1;
(statearr_20095_20126[(1)] = (5));

} else {
var statearr_20096_20127 = state_20089__$1;
(statearr_20096_20127[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (15))){
var inst_20079 = (state_20089[(2)]);
var state_20089__$1 = state_20089;
var statearr_20097_20128 = state_20089__$1;
(statearr_20097_20128[(2)] = inst_20079);

(statearr_20097_20128[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (13))){
var state_20089__$1 = state_20089;
var statearr_20098_20129 = state_20089__$1;
(statearr_20098_20129[(2)] = null);

(statearr_20098_20129[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (6))){
var inst_20049 = (state_20089[(7)]);
var inst_20074 = inst_20049.length;
var inst_20075 = (inst_20074 > (0));
var state_20089__$1 = state_20089;
if(cljs.core.truth_(inst_20075)){
var statearr_20099_20130 = state_20089__$1;
(statearr_20099_20130[(1)] = (12));

} else {
var statearr_20100_20131 = state_20089__$1;
(statearr_20100_20131[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (3))){
var inst_20087 = (state_20089[(2)]);
var state_20089__$1 = state_20089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20089__$1,inst_20087);
} else {
if((state_val_20090 === (12))){
var inst_20049 = (state_20089[(7)]);
var inst_20077 = cljs.core.vec(inst_20049);
var state_20089__$1 = state_20089;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20089__$1,(15),out,inst_20077);
} else {
if((state_val_20090 === (2))){
var state_20089__$1 = state_20089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20089__$1,(4),ch);
} else {
if((state_val_20090 === (11))){
var inst_20057 = (state_20089[(10)]);
var inst_20053 = (state_20089[(9)]);
var inst_20067 = (state_20089[(2)]);
var inst_20068 = [];
var inst_20069 = inst_20068.push(inst_20053);
var inst_20049 = inst_20068;
var inst_20050 = inst_20057;
var state_20089__$1 = (function (){var statearr_20101 = state_20089;
(statearr_20101[(11)] = inst_20067);

(statearr_20101[(7)] = inst_20049);

(statearr_20101[(12)] = inst_20069);

(statearr_20101[(8)] = inst_20050);

return statearr_20101;
})();
var statearr_20102_20132 = state_20089__$1;
(statearr_20102_20132[(2)] = null);

(statearr_20102_20132[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (9))){
var inst_20049 = (state_20089[(7)]);
var inst_20065 = cljs.core.vec(inst_20049);
var state_20089__$1 = state_20089;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20089__$1,(11),out,inst_20065);
} else {
if((state_val_20090 === (5))){
var inst_20057 = (state_20089[(10)]);
var inst_20053 = (state_20089[(9)]);
var inst_20050 = (state_20089[(8)]);
var inst_20057__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_20053) : f.call(null,inst_20053));
var inst_20058 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20057__$1,inst_20050);
var inst_20059 = cljs.core.keyword_identical_QMARK_(inst_20050,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_20060 = (inst_20058) || (inst_20059);
var state_20089__$1 = (function (){var statearr_20103 = state_20089;
(statearr_20103[(10)] = inst_20057__$1);

return statearr_20103;
})();
if(cljs.core.truth_(inst_20060)){
var statearr_20104_20133 = state_20089__$1;
(statearr_20104_20133[(1)] = (8));

} else {
var statearr_20105_20134 = state_20089__$1;
(statearr_20105_20134[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (14))){
var inst_20082 = (state_20089[(2)]);
var inst_20083 = cljs.core.async.close_BANG_(out);
var state_20089__$1 = (function (){var statearr_20107 = state_20089;
(statearr_20107[(13)] = inst_20082);

return statearr_20107;
})();
var statearr_20108_20135 = state_20089__$1;
(statearr_20108_20135[(2)] = inst_20083);

(statearr_20108_20135[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (10))){
var inst_20072 = (state_20089[(2)]);
var state_20089__$1 = state_20089;
var statearr_20109_20136 = state_20089__$1;
(statearr_20109_20136[(2)] = inst_20072);

(statearr_20109_20136[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20090 === (8))){
var inst_20049 = (state_20089[(7)]);
var inst_20057 = (state_20089[(10)]);
var inst_20053 = (state_20089[(9)]);
var inst_20062 = inst_20049.push(inst_20053);
var tmp20106 = inst_20049;
var inst_20049__$1 = tmp20106;
var inst_20050 = inst_20057;
var state_20089__$1 = (function (){var statearr_20110 = state_20089;
(statearr_20110[(7)] = inst_20049__$1);

(statearr_20110[(14)] = inst_20062);

(statearr_20110[(8)] = inst_20050);

return statearr_20110;
})();
var statearr_20111_20137 = state_20089__$1;
(statearr_20111_20137[(2)] = null);

(statearr_20111_20137[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___20123,out))
;
return ((function (switch__17227__auto__,c__17341__auto___20123,out){
return (function() {
var cljs$core$async$state_machine__17228__auto__ = null;
var cljs$core$async$state_machine__17228__auto____0 = (function (){
var statearr_20115 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20115[(0)] = cljs$core$async$state_machine__17228__auto__);

(statearr_20115[(1)] = (1));

return statearr_20115;
});
var cljs$core$async$state_machine__17228__auto____1 = (function (state_20089){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_20089);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20116){if((e20116 instanceof Object)){
var ex__17231__auto__ = e20116;
var statearr_20117_20138 = state_20089;
(statearr_20117_20138[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20089);

return cljs.core.cst$kw$recur;
} else {
throw e20116;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__20139 = state_20089;
state_20089 = G__20139;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs$core$async$state_machine__17228__auto__ = function(state_20089){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17228__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17228__auto____1.call(this,state_20089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17228__auto____0;
cljs$core$async$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17228__auto____1;
return cljs$core$async$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___20123,out))
})();
var state__17343__auto__ = (function (){var statearr_20118 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20118[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___20123);

return statearr_20118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___20123,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
