// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.polling_interval = (5000);
/**
 * Handles API server's response and acts according to given
 *   callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__20834,p__20835){
var map__20842 = p__20834;
var map__20842__$1 = ((((!((map__20842 == null)))?((((map__20842.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20842.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20842):map__20842);
var response = map__20842__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20842__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20842__$1,cljs.core.cst$kw$body);
var map__20843 = p__20835;
var map__20843__$1 = ((((!((map__20843 == null)))?((((map__20843.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20843.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20843):map__20843);
var callbacks = map__20843__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20843__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20843__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20843__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20843__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__20846 = body;
var map__20846__$1 = ((((!((map__20846 == null)))?((((map__20846.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20846.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20846):map__20846);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20846__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20846__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20846__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__20846,map__20846__$1,export_url,job_status,job_id,map__20842,map__20842__$1,response,status,body,map__20843,map__20843__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__20846,map__20846__$1,export_url,job_status,job_id,map__20842,map__20842__$1,response,status,body,map__20843,map__20843__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6153__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}
} else {
}

if(cljs.core.truth_((function (){var or__6153__auto__ = (status >= (400));
if(or__6153__auto__){
return or__6153__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20905 = arguments.length;
var i__7212__auto___20906 = (0);
while(true){
if((i__7212__auto___20906 < len__7211__auto___20905)){
args__7218__auto__.push((arguments[i__7212__auto___20906]));

var G__20907 = (i__7212__auto___20906 + (1));
i__7212__auto___20906 = G__20907;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((2) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((2)),(0))):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7219__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__20851){
var map__20852 = p__20851;
var map__20852__$1 = ((((!((map__20852 == null)))?((((map__20852.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20852.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20852):map__20852);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20852__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20852__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20852__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var done_polling_QMARK_ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var c__17341__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto__,done_polling_QMARK_,map__20852,map__20852__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto__,done_polling_QMARK_,map__20852,map__20852__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (state_20882){
var state_val_20883 = (state_20882[(1)]);
if((state_val_20883 === (7))){
var state_20882__$1 = state_20882;
var statearr_20884_20908 = state_20882__$1;
(statearr_20884_20908[(2)] = "dataviews");

(statearr_20884_20908[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (1))){
var state_20882__$1 = state_20882;
var statearr_20885_20909 = state_20882__$1;
(statearr_20885_20909[(2)] = null);

(statearr_20885_20909[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (4))){
var inst_20858 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_20882__$1 = (function (){var statearr_20886 = state_20882;
(statearr_20886[(7)] = inst_20858);

return statearr_20886;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_20887_20910 = state_20882__$1;
(statearr_20887_20910[(1)] = (7));

} else {
var statearr_20888_20911 = state_20882__$1;
(statearr_20888_20911[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (6))){
var inst_20878 = (state_20882[(2)]);
var state_20882__$1 = state_20882;
var statearr_20889_20912 = state_20882__$1;
(statearr_20889_20912[(2)] = inst_20878);

(statearr_20889_20912[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (3))){
var inst_20880 = (state_20882[(2)]);
var state_20882__$1 = state_20882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20882__$1,inst_20880);
} else {
if((state_val_20883 === (2))){
var inst_20855 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(done_polling_QMARK_) : cljs.core.deref.call(null,done_polling_QMARK_));
var inst_20856 = cljs.core.not(inst_20855);
var state_20882__$1 = state_20882;
if(inst_20856){
var statearr_20890_20913 = state_20882__$1;
(statearr_20890_20913[(1)] = (4));

} else {
var statearr_20891_20914 = state_20882__$1;
(statearr_20891_20914[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (11))){
var inst_20874 = (state_20882[(2)]);
var state_20882__$1 = (function (){var statearr_20892 = state_20882;
(statearr_20892[(8)] = inst_20874);

return statearr_20892;
})();
var statearr_20893_20915 = state_20882__$1;
(statearr_20893_20915[(2)] = null);

(statearr_20893_20915[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (9))){
var inst_20858 = (state_20882[(7)]);
var inst_20863 = (state_20882[(9)]);
var inst_20862 = (state_20882[(2)]);
var inst_20863__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_20862,dataset_id,inst_20858], 0));
var inst_20864 = milia.api.http.parse_http(cljs.core.cst$kw$get,inst_20863__$1);
var state_20882__$1 = (function (){var statearr_20894 = state_20882;
(statearr_20894[(9)] = inst_20863__$1);

return statearr_20894;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20882__$1,(10),inst_20864);
} else {
if((state_val_20883 === (5))){
var state_20882__$1 = state_20882;
var statearr_20895_20916 = state_20882__$1;
(statearr_20895_20916[(2)] = null);

(statearr_20895_20916[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (10))){
var inst_20858 = (state_20882[(7)]);
var inst_20863 = (state_20882[(9)]);
var inst_20866 = (state_20882[(2)]);
var inst_20867 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_20868 = (function (){var job_suffix = inst_20858;
var job_url = inst_20863;
var response = inst_20866;
return ((function (job_suffix,job_url,response,inst_20858,inst_20863,inst_20866,inst_20867,state_val_20883,c__17341__auto__,done_polling_QMARK_,map__20852,map__20852__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(done_polling_QMARK_,true) : cljs.core.reset_BANG_.call(null,done_polling_QMARK_,true));
});
;})(job_suffix,job_url,response,inst_20858,inst_20863,inst_20866,inst_20867,state_val_20883,c__17341__auto__,done_polling_QMARK_,map__20852,map__20852__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
})();
var inst_20869 = [inst_20868,on_error,on_export_url];
var inst_20870 = cljs.core.PersistentHashMap.fromArrays(inst_20867,inst_20869);
var inst_20871 = milia.api.async_export.handle_response(inst_20866,inst_20870);
var inst_20872 = cljs.core.async.timeout(milia.api.async_export.polling_interval);
var state_20882__$1 = (function (){var statearr_20896 = state_20882;
(statearr_20896[(10)] = inst_20871);

return statearr_20896;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20882__$1,(11),inst_20872);
} else {
if((state_val_20883 === (8))){
var state_20882__$1 = state_20882;
var statearr_20897_20917 = state_20882__$1;
(statearr_20897_20917[(2)] = "forms");

(statearr_20897_20917[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto__,done_polling_QMARK_,map__20852,map__20852__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
;
return ((function (switch__17227__auto__,c__17341__auto__,done_polling_QMARK_,map__20852,map__20852__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function() {
var milia$api$async_export$state_machine__17228__auto__ = null;
var milia$api$async_export$state_machine__17228__auto____0 = (function (){
var statearr_20901 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20901[(0)] = milia$api$async_export$state_machine__17228__auto__);

(statearr_20901[(1)] = (1));

return statearr_20901;
});
var milia$api$async_export$state_machine__17228__auto____1 = (function (state_20882){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_20882);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20902){if((e20902 instanceof Object)){
var ex__17231__auto__ = e20902;
var statearr_20903_20918 = state_20882;
(statearr_20903_20918[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20882);

return cljs.core.cst$kw$recur;
} else {
throw e20902;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__20919 = state_20882;
state_20882 = G__20919;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
milia$api$async_export$state_machine__17228__auto__ = function(state_20882){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__17228__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__17228__auto____1.call(this,state_20882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__17228__auto____0;
milia$api$async_export$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__17228__auto____1;
return milia$api$async_export$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto__,done_polling_QMARK_,map__20852,map__20852__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
})();
var state__17343__auto__ = (function (){var statearr_20904 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20904[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto__);

return statearr_20904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto__,done_polling_QMARK_,map__20852,map__20852__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
);

return c__17341__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq20848){
var G__20849 = cljs.core.first(seq20848);
var seq20848__$1 = cljs.core.next(seq20848);
var G__20850 = cljs.core.first(seq20848__$1);
var seq20848__$2 = cljs.core.next(seq20848__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20849,G__20850,seq20848__$2);
});
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_images","remove_group_name","_version","query","export_id"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id], null);
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6153__auto__ = value;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20925 = arguments.length;
var i__7212__auto___20926 = (0);
while(true){
if((i__7212__auto___20926 < len__7211__auto___20925)){
args__7218__auto__.push((arguments[i__7212__auto___20926]));

var G__20927 = (i__7212__auto___20926 + (1));
i__7212__auto___20926 = G__20927;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((2) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((2)),(0))):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7219__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__20923){
var vec__20924 = p__20923;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20924,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq20920){
var G__20921 = cljs.core.first(seq20920);
var seq20920__$1 = cljs.core.next(seq20920);
var G__20922 = cljs.core.first(seq20920__$1);
var seq20920__$2 = cljs.core.next(seq20920__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__20921,G__20922,seq20920__$2);
});
/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20964 = arguments.length;
var i__7212__auto___20965 = (0);
while(true){
if((i__7212__auto___20965 < len__7211__auto___20964)){
args__7218__auto__.push((arguments[i__7212__auto___20965]));

var G__20966 = (i__7212__auto___20965 + (1));
i__7212__auto___20965 = G__20966;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((1) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((1)),(0))):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7219__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__20930){
var vec__20931 = p__20930;
var map__20932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20931,(0),null);
var map__20932__$1 = ((((!((map__20932 == null)))?((((map__20932.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20932.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20932):map__20932);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20932__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20932__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20932__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20932__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20932__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20932__$1,cljs.core.cst$kw$on_DASH_error);
var c__17341__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto__,vec__20931,map__20932,map__20932__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto__,vec__20931,map__20932,map__20932__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_20949){
var state_val_20950 = (state_20949[(1)]);
if((state_val_20950 === (1))){
var inst_20934 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var state_20949__$1 = (function (){var statearr_20951 = state_20949;
(statearr_20951[(7)] = inst_20934);

return statearr_20951;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_20952_20967 = state_20949__$1;
(statearr_20952_20967[(1)] = (2));

} else {
var statearr_20953_20968 = state_20949__$1;
(statearr_20953_20968[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20950 === (2))){
var state_20949__$1 = state_20949;
var statearr_20954_20969 = state_20949__$1;
(statearr_20954_20969[(2)] = "dataviews");

(statearr_20954_20969[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20950 === (3))){
var state_20949__$1 = state_20949;
var statearr_20955_20970 = state_20949__$1;
(statearr_20955_20970[(2)] = "forms");

(statearr_20955_20970[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20950 === (4))){
var inst_20939 = (state_20949[(8)]);
var inst_20938 = (state_20949[(9)]);
var inst_20934 = (state_20949[(7)]);
var inst_20938__$1 = (state_20949[(2)]);
var inst_20939__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_20938__$1,dataset_id,inst_20934], 0));
var inst_20940 = milia.api.http.parse_http(cljs.core.cst$kw$get,inst_20939__$1);
var state_20949__$1 = (function (){var statearr_20956 = state_20949;
(statearr_20956[(8)] = inst_20939__$1);

(statearr_20956[(9)] = inst_20938__$1);

return statearr_20956;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20949__$1,(5),inst_20940);
} else {
if((state_val_20950 === (5))){
var inst_20939 = (state_20949[(8)]);
var inst_20938 = (state_20949[(9)]);
var inst_20934 = (state_20949[(7)]);
var inst_20942 = (state_20949[(2)]);
var inst_20943 = (function (){var export_suffix = inst_20934;
var export_endpoint = inst_20938;
var export_url = inst_20939;
var response = inst_20942;
return ((function (export_suffix,export_endpoint,export_url,response,inst_20939,inst_20938,inst_20934,inst_20942,state_val_20950,c__17341__auto__,vec__20931,map__20932,map__20932__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
});
;})(export_suffix,export_endpoint,export_url,response,inst_20939,inst_20938,inst_20934,inst_20942,state_val_20950,c__17341__auto__,vec__20931,map__20932,map__20932__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var inst_20944 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_20945 = [on_error,inst_20943,on_export_url];
var inst_20946 = cljs.core.PersistentHashMap.fromArrays(inst_20944,inst_20945);
var inst_20947 = milia.api.async_export.handle_response(inst_20942,inst_20946);
var state_20949__$1 = state_20949;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20949__$1,inst_20947);
} else {
return null;
}
}
}
}
}
});})(c__17341__auto__,vec__20931,map__20932,map__20932__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__17227__auto__,c__17341__auto__,vec__20931,map__20932,map__20932__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__17228__auto__ = null;
var milia$api$async_export$state_machine__17228__auto____0 = (function (){
var statearr_20960 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20960[(0)] = milia$api$async_export$state_machine__17228__auto__);

(statearr_20960[(1)] = (1));

return statearr_20960;
});
var milia$api$async_export$state_machine__17228__auto____1 = (function (state_20949){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_20949);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20961){if((e20961 instanceof Object)){
var ex__17231__auto__ = e20961;
var statearr_20962_20971 = state_20949;
(statearr_20962_20971[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20949);

return cljs.core.cst$kw$recur;
} else {
throw e20961;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__20972 = state_20949;
state_20949 = G__20972;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
milia$api$async_export$state_machine__17228__auto__ = function(state_20949){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__17228__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__17228__auto____1.call(this,state_20949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__17228__auto____0;
milia$api$async_export$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__17228__auto____1;
return milia$api$async_export$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto__,vec__20931,map__20932,map__20932__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__17343__auto__ = (function (){var statearr_20963 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20963[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto__);

return statearr_20963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto__,vec__20931,map__20932,map__20932__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__17341__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq20928){
var G__20929 = cljs.core.first(seq20928);
var seq20928__$1 = cljs.core.next(seq20928);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20929,seq20928__$1);
});
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){

var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__20973_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__20973_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20998 = arguments.length;
var i__7212__auto___20999 = (0);
while(true){
if((i__7212__auto___20999 < len__7211__auto___20998)){
args__7218__auto__.push((arguments[i__7212__auto___20999]));

var G__21000 = (i__7212__auto___20999 + (1));
i__7212__auto___20999 = G__21000;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((3) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((3)),(0))):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7219__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){

var c__17341__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto__){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto__){
return (function (state_20989){
var state_val_20990 = (state_20989[(1)]);
if((state_val_20990 === (1))){
var inst_20978 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_20989__$1 = state_20989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20989__$1,(2),inst_20978);
} else {
if((state_val_20990 === (2))){
var inst_20980 = (state_20989[(2)]);
var inst_20981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20982 = [http_method,inst_20980];
var inst_20983 = (new cljs.core.PersistentVector(null,2,(5),inst_20981,inst_20982,null));
var inst_20984 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20983,args);
var inst_20985 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_20984);
var state_20989__$1 = state_20989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20989__$1,(3),inst_20985);
} else {
if((state_val_20990 === (3))){
var inst_20987 = (state_20989[(2)]);
var state_20989__$1 = state_20989;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20989__$1,inst_20987);
} else {
return null;
}
}
}
});})(c__17341__auto__))
;
return ((function (switch__17227__auto__,c__17341__auto__){
return (function() {
var milia$api$async_export$state_machine__17228__auto__ = null;
var milia$api$async_export$state_machine__17228__auto____0 = (function (){
var statearr_20994 = [null,null,null,null,null,null,null];
(statearr_20994[(0)] = milia$api$async_export$state_machine__17228__auto__);

(statearr_20994[(1)] = (1));

return statearr_20994;
});
var milia$api$async_export$state_machine__17228__auto____1 = (function (state_20989){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_20989);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20995){if((e20995 instanceof Object)){
var ex__17231__auto__ = e20995;
var statearr_20996_21001 = state_20989;
(statearr_20996_21001[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20989);

return cljs.core.cst$kw$recur;
} else {
throw e20995;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__21002 = state_20989;
state_20989 = G__21002;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
milia$api$async_export$state_machine__17228__auto__ = function(state_20989){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__17228__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__17228__auto____1.call(this,state_20989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__17228__auto____0;
milia$api$async_export$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__17228__auto____1;
return milia$api$async_export$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto__))
})();
var state__17343__auto__ = (function (){var statearr_20997 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20997[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto__);

return statearr_20997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto__))
);

return c__17341__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq20974){
var G__20975 = cljs.core.first(seq20974);
var seq20974__$1 = cljs.core.next(seq20974);
var G__20976 = cljs.core.first(seq20974__$1);
var seq20974__$2 = cljs.core.next(seq20974__$1);
var G__20977 = cljs.core.first(seq20974__$2);
var seq20974__$3 = cljs.core.next(seq20974__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__20975,G__20976,G__20977,seq20974__$3);
});
