// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('milia.api.io');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `accept-header` `callback`, `no-cache?`.
 * When a request fails for one of the following reasons, an exception is thrown
 * with a map containing a `:reason` key, and an optional `:detail` key
 *  1. No response: {:reason :no-http-response}
 *  2. 4xx response: {:reason :http-client-error
 *                    :detail {:status-code <status-code>
 *                             :response <parsed-json-from-server>}
 *  3. 5xx response: {:reason :http-server-error
 *                    :detail {:response <raw-response>
 *                             :status-code <status-code>}
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20705 = arguments.length;
var i__7212__auto___20706 = (0);
while(true){
if((i__7212__auto___20706 < len__7211__auto___20705)){
args__7218__auto__.push((arguments[i__7212__auto___20706]));

var G__20707 = (i__7212__auto___20706 + (1));
i__7212__auto___20706 = G__20707;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((2) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((2)),(0))):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7219__auto__);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__20689){
var map__20690 = p__20689;
var map__20690__$1 = ((((!((map__20690 == null)))?((((map__20690.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20690.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20690):map__20690);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$accept_DASH_header);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$callback);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$filename);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$http_DASH_options);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$raw_DASH_response_QMARK_);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$as_DASH_map_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20690__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.cst$kw$delete),cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.array_seq([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$method,method,cljs.core.cst$kw$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__17341__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto__,request_fn,headers,ch,map__20690,map__20690__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto__,request_fn,headers,ch,map__20690,map__20690__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (state_20696){
var state_val_20697 = (state_20696[(1)]);
if((state_val_20697 === (1))){
var state_20696__$1 = state_20696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20696__$1,(2),ch);
} else {
if((state_val_20697 === (2))){
var inst_20693 = (state_20696[(2)]);
var inst_20694 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_20693) : callback.call(null,inst_20693));
var state_20696__$1 = state_20696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20696__$1,inst_20694);
} else {
return null;
}
}
});})(c__17341__auto__,request_fn,headers,ch,map__20690,map__20690__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
;
return ((function (switch__17227__auto__,c__17341__auto__,request_fn,headers,ch,map__20690,map__20690__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function() {
var milia$api$http$state_machine__17228__auto__ = null;
var milia$api$http$state_machine__17228__auto____0 = (function (){
var statearr_20701 = [null,null,null,null,null,null,null];
(statearr_20701[(0)] = milia$api$http$state_machine__17228__auto__);

(statearr_20701[(1)] = (1));

return statearr_20701;
});
var milia$api$http$state_machine__17228__auto____1 = (function (state_20696){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_20696);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20702){if((e20702 instanceof Object)){
var ex__17231__auto__ = e20702;
var statearr_20703_20708 = state_20696;
(statearr_20703_20708[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20696);

return cljs.core.cst$kw$recur;
} else {
throw e20702;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__20709 = state_20696;
state_20696 = G__20709;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
milia$api$http$state_machine__17228__auto__ = function(state_20696){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__17228__auto____0.call(this);
case 1:
return milia$api$http$state_machine__17228__auto____1.call(this,state_20696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__17228__auto____0;
milia$api$http$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__17228__auto____1;
return milia$api$http$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto__,request_fn,headers,ch,map__20690,map__20690__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
})();
var state__17343__auto__ = (function (){var statearr_20704 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20704[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto__);

return statearr_20704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto__,request_fn,headers,ch,map__20690,map__20690__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
);

return c__17341__auto__;
} else {
return ch;
}
}
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = (2);

milia.api.http.parse_http.cljs$lang$applyTo = (function (seq20686){
var G__20687 = cljs.core.first(seq20686);
var seq20686__$1 = cljs.core.next(seq20686);
var G__20688 = cljs.core.first(seq20686__$1);
var seq20686__$2 = cljs.core.next(seq20686__$1);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(G__20687,G__20688,seq20686__$2);
});
