// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.dataview');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create new dataview from existing dataset
 */
milia.api.dataview.create = (function milia$api$dataview$create(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves dataview object using dataview id
 */
milia.api.dataview.get = (function milia$api$dataview$get(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32548 = arguments.length;
var i__7652__auto___32549 = (0);
while(true){
if((i__7652__auto___32549 < len__7651__auto___32548)){
args__7658__auto__.push((arguments[i__7652__auto___32549]));

var G__32550 = (i__7652__auto___32549 + (1));
i__7652__auto___32549 = G__32550;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataview.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.dataview.get.cljs$core$IFn$_invoke$arity$variadic = (function (dataview_id,p__32545){
var map__32546 = p__32545;
var map__32546__$1 = ((((!((map__32546 == null)))?((((map__32546.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32546.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32546):map__32546);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32546__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",[cljs.core.str(dataview_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});

milia.api.dataview.get.cljs$lang$maxFixedArity = (1);

milia.api.dataview.get.cljs$lang$applyTo = (function (seq32543){
var G__32544 = cljs.core.first(seq32543);
var seq32543__$1 = cljs.core.next(seq32543);
return milia.api.dataview.get.cljs$core$IFn$_invoke$arity$variadic(G__32544,seq32543__$1);
});

/**
 * Retrieves dataview data by ID and with the optional parameters.
 */
milia.api.dataview.data = (function milia$api$dataview$data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32556 = arguments.length;
var i__7652__auto___32557 = (0);
while(true){
if((i__7652__auto___32557 < len__7651__auto___32556)){
args__7658__auto__.push((arguments[i__7652__auto___32557]));

var G__32558 = (i__7652__auto___32557 + (1));
i__7652__auto___32557 = G__32558;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataview.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.dataview.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataview_id,p__32553){
var map__32554 = p__32553;
var map__32554__$1 = ((((!((map__32554 == null)))?((((map__32554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32554.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32554):map__32554);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32554__$1,cljs.core.cst$kw$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32554__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32554__$1,cljs.core.cst$kw$query_DASH_params);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"data.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,query_params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});

milia.api.dataview.data.cljs$lang$maxFixedArity = (1);

milia.api.dataview.data.cljs$lang$applyTo = (function (seq32551){
var G__32552 = cljs.core.first(seq32551);
var seq32551__$1 = cljs.core.next(seq32551);
return milia.api.dataview.data.cljs$core$IFn$_invoke$arity$variadic(G__32552,seq32551__$1);
});

/**
 * Retrieves form used to create dataview
 */
milia.api.dataview.form = (function milia$api$dataview$form(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"form.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves details of form used to create dataview
 */
milia.api.dataview.form_details = (function milia$api$dataview$form_details(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"form_details.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Counts data instances returned by dataview object
 */
milia.api.dataview.count_data = (function milia$api$dataview$count_data(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"data.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$count,true], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves all dataview objects
 */
milia.api.dataview.all = (function milia$api$dataview$all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Updates dataview object
 */
milia.api.dataview.update = (function milia$api$dataview$update(dataview_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",[cljs.core.str(dataview_id),cljs.core.str(".json")].join('')], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Deletes dataview object
 */
milia.api.dataview.delete$ = (function milia$api$dataview$delete(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",[cljs.core.str(dataview_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataview.download_xls_report = (function milia$api$dataview$download_xls_report(dataset_id,meta_id,filename,data_id){
var suffix = [cljs.core.str(dataset_id),cljs.core.str("/xls_export.json?"),cljs.core.str("meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join('');
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$filename,filename], 0));
});
