// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args34001 = [];
var len__7651__auto___34007 = arguments.length;
var i__7652__auto___34008 = (0);
while(true){
if((i__7652__auto___34008 < len__7651__auto___34007)){
args34001.push((arguments[i__7652__auto___34008]));

var G__34009 = (i__7652__auto___34008 + (1));
i__7652__auto___34008 = G__34009;
continue;
} else {
}
break;
}

var G__34003 = args34001.length;
switch (G__34003) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34001.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async34004 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34004 = (function (f,blockable,meta34005){
this.f = f;
this.blockable = blockable;
this.meta34005 = meta34005;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34004.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34006,meta34005__$1){
var self__ = this;
var _34006__$1 = this;
return (new cljs.core.async.t_cljs$core$async34004(self__.f,self__.blockable,meta34005__$1));
});

cljs.core.async.t_cljs$core$async34004.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34006){
var self__ = this;
var _34006__$1 = this;
return self__.meta34005;
});

cljs.core.async.t_cljs$core$async34004.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34004.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async34004.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async34004.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async34004.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta34005], null);
});

cljs.core.async.t_cljs$core$async34004.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34004.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34004";

cljs.core.async.t_cljs$core$async34004.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34004");
});

cljs.core.async.__GT_t_cljs$core$async34004 = (function cljs$core$async$__GT_t_cljs$core$async34004(f__$1,blockable__$1,meta34005){
return (new cljs.core.async.t_cljs$core$async34004(f__$1,blockable__$1,meta34005));
});

}

return (new cljs.core.async.t_cljs$core$async34004(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args34013 = [];
var len__7651__auto___34016 = arguments.length;
var i__7652__auto___34017 = (0);
while(true){
if((i__7652__auto___34017 < len__7651__auto___34016)){
args34013.push((arguments[i__7652__auto___34017]));

var G__34018 = (i__7652__auto___34017 + (1));
i__7652__auto___34017 = G__34018;
continue;
} else {
}
break;
}

var G__34015 = args34013.length;
switch (G__34015) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34013.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args34020 = [];
var len__7651__auto___34023 = arguments.length;
var i__7652__auto___34024 = (0);
while(true){
if((i__7652__auto___34024 < len__7651__auto___34023)){
args34020.push((arguments[i__7652__auto___34024]));

var G__34025 = (i__7652__auto___34024 + (1));
i__7652__auto___34024 = G__34025;
continue;
} else {
}
break;
}

var G__34022 = args34020.length;
switch (G__34022) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34020.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args34027 = [];
var len__7651__auto___34030 = arguments.length;
var i__7652__auto___34031 = (0);
while(true){
if((i__7652__auto___34031 < len__7651__auto___34030)){
args34027.push((arguments[i__7652__auto___34031]));

var G__34032 = (i__7652__auto___34031 + (1));
i__7652__auto___34031 = G__34032;
continue;
} else {
}
break;
}

var G__34029 = args34027.length;
switch (G__34029) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34027.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_34034 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34034) : fn1.call(null,val_34034));
} else {
cljs.core.async.impl.dispatch.run(((function (val_34034,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34034) : fn1.call(null,val_34034));
});})(val_34034,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args34035 = [];
var len__7651__auto___34038 = arguments.length;
var i__7652__auto___34039 = (0);
while(true){
if((i__7652__auto___34039 < len__7651__auto___34038)){
args34035.push((arguments[i__7652__auto___34039]));

var G__34040 = (i__7652__auto___34039 + (1));
i__7652__auto___34039 = G__34040;
continue;
} else {
}
break;
}

var G__34037 = args34035.length;
switch (G__34037) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34035.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7461__auto___34042 = n;
var x_34043 = (0);
while(true){
if((x_34043 < n__7461__auto___34042)){
(a[x_34043] = (0));

var G__34044 = (x_34043 + (1));
x_34043 = G__34044;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__34045 = (i + (1));
i = G__34045;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async34049 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34049 = (function (flag,meta34050){
this.flag = flag;
this.meta34050 = meta34050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_34051,meta34050__$1){
var self__ = this;
var _34051__$1 = this;
return (new cljs.core.async.t_cljs$core$async34049(self__.flag,meta34050__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async34049.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_34051){
var self__ = this;
var _34051__$1 = this;
return self__.meta34050;
});})(flag))
;

cljs.core.async.t_cljs$core$async34049.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34049.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async34049.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async34049.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async34049.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta34050], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async34049.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34049.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34049";

cljs.core.async.t_cljs$core$async34049.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34049");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async34049 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async34049(flag__$1,meta34050){
return (new cljs.core.async.t_cljs$core$async34049(flag__$1,meta34050));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async34049(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async34055 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34055 = (function (flag,cb,meta34056){
this.flag = flag;
this.cb = cb;
this.meta34056 = meta34056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34057,meta34056__$1){
var self__ = this;
var _34057__$1 = this;
return (new cljs.core.async.t_cljs$core$async34055(self__.flag,self__.cb,meta34056__$1));
});

cljs.core.async.t_cljs$core$async34055.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34057){
var self__ = this;
var _34057__$1 = this;
return self__.meta34056;
});

cljs.core.async.t_cljs$core$async34055.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34055.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async34055.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async34055.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async34055.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta34056], null);
});

cljs.core.async.t_cljs$core$async34055.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34055.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34055";

cljs.core.async.t_cljs$core$async34055.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34055");
});

cljs.core.async.__GT_t_cljs$core$async34055 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async34055(flag__$1,cb__$1,meta34056){
return (new cljs.core.async.t_cljs$core$async34055(flag__$1,cb__$1,meta34056));
});

}

return (new cljs.core.async.t_cljs$core$async34055(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__34058_SHARP_){
var G__34062 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34058_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__34062) : fret.call(null,G__34062));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__34059_SHARP_){
var G__34063 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34059_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__34063) : fret.call(null,G__34063));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6543__auto__ = wport;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return port;
}
})()], null));
} else {
var G__34064 = (i + (1));
i = G__34064;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6543__auto__ = ret;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6531__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34070 = arguments.length;
var i__7652__auto___34071 = (0);
while(true){
if((i__7652__auto___34071 < len__7651__auto___34070)){
args__7658__auto__.push((arguments[i__7652__auto___34071]));

var G__34072 = (i__7652__auto___34071 + (1));
i__7652__auto___34071 = G__34072;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__34067){
var map__34068 = p__34067;
var map__34068__$1 = ((((!((map__34068 == null)))?((((map__34068.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34068.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34068):map__34068);
var opts = map__34068__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq34065){
var G__34066 = cljs.core.first(seq34065);
var seq34065__$1 = cljs.core.next(seq34065);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34066,seq34065__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args34073 = [];
var len__7651__auto___34123 = arguments.length;
var i__7652__auto___34124 = (0);
while(true){
if((i__7652__auto___34124 < len__7651__auto___34123)){
args34073.push((arguments[i__7652__auto___34124]));

var G__34125 = (i__7652__auto___34124 + (1));
i__7652__auto___34124 = G__34125;
continue;
} else {
}
break;
}

var G__34075 = args34073.length;
switch (G__34075) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34073.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__19252__auto___34127 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___34127){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___34127){
return (function (state_34099){
var state_val_34100 = (state_34099[(1)]);
if((state_val_34100 === (7))){
var inst_34095 = (state_34099[(2)]);
var state_34099__$1 = state_34099;
var statearr_34101_34128 = state_34099__$1;
(statearr_34101_34128[(2)] = inst_34095);

(statearr_34101_34128[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (1))){
var state_34099__$1 = state_34099;
var statearr_34102_34129 = state_34099__$1;
(statearr_34102_34129[(2)] = null);

(statearr_34102_34129[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (4))){
var inst_34078 = (state_34099[(7)]);
var inst_34078__$1 = (state_34099[(2)]);
var inst_34079 = (inst_34078__$1 == null);
var state_34099__$1 = (function (){var statearr_34103 = state_34099;
(statearr_34103[(7)] = inst_34078__$1);

return statearr_34103;
})();
if(cljs.core.truth_(inst_34079)){
var statearr_34104_34130 = state_34099__$1;
(statearr_34104_34130[(1)] = (5));

} else {
var statearr_34105_34131 = state_34099__$1;
(statearr_34105_34131[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (13))){
var state_34099__$1 = state_34099;
var statearr_34106_34132 = state_34099__$1;
(statearr_34106_34132[(2)] = null);

(statearr_34106_34132[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (6))){
var inst_34078 = (state_34099[(7)]);
var state_34099__$1 = state_34099;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34099__$1,(11),to,inst_34078);
} else {
if((state_val_34100 === (3))){
var inst_34097 = (state_34099[(2)]);
var state_34099__$1 = state_34099;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34099__$1,inst_34097);
} else {
if((state_val_34100 === (12))){
var state_34099__$1 = state_34099;
var statearr_34107_34133 = state_34099__$1;
(statearr_34107_34133[(2)] = null);

(statearr_34107_34133[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (2))){
var state_34099__$1 = state_34099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34099__$1,(4),from);
} else {
if((state_val_34100 === (11))){
var inst_34088 = (state_34099[(2)]);
var state_34099__$1 = state_34099;
if(cljs.core.truth_(inst_34088)){
var statearr_34108_34134 = state_34099__$1;
(statearr_34108_34134[(1)] = (12));

} else {
var statearr_34109_34135 = state_34099__$1;
(statearr_34109_34135[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (9))){
var state_34099__$1 = state_34099;
var statearr_34110_34136 = state_34099__$1;
(statearr_34110_34136[(2)] = null);

(statearr_34110_34136[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (5))){
var state_34099__$1 = state_34099;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34111_34137 = state_34099__$1;
(statearr_34111_34137[(1)] = (8));

} else {
var statearr_34112_34138 = state_34099__$1;
(statearr_34112_34138[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (14))){
var inst_34093 = (state_34099[(2)]);
var state_34099__$1 = state_34099;
var statearr_34113_34139 = state_34099__$1;
(statearr_34113_34139[(2)] = inst_34093);

(statearr_34113_34139[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (10))){
var inst_34085 = (state_34099[(2)]);
var state_34099__$1 = state_34099;
var statearr_34114_34140 = state_34099__$1;
(statearr_34114_34140[(2)] = inst_34085);

(statearr_34114_34140[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34100 === (8))){
var inst_34082 = cljs.core.async.close_BANG_(to);
var state_34099__$1 = state_34099;
var statearr_34115_34141 = state_34099__$1;
(statearr_34115_34141[(2)] = inst_34082);

(statearr_34115_34141[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___34127))
;
return ((function (switch__19140__auto__,c__19252__auto___34127){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_34119 = [null,null,null,null,null,null,null,null];
(statearr_34119[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_34119[(1)] = (1));

return statearr_34119;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_34099){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34099);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34120){if((e34120 instanceof Object)){
var ex__19144__auto__ = e34120;
var statearr_34121_34142 = state_34099;
(statearr_34121_34142[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34099);

return cljs.core.cst$kw$recur;
} else {
throw e34120;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34143 = state_34099;
state_34099 = G__34143;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_34099){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_34099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___34127))
})();
var state__19254__auto__ = (function (){var statearr_34122 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___34127);

return statearr_34122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___34127))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__34331){
var vec__34332 = p__34331;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34332,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34332,(1),null);
var job = vec__34332;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__19252__auto___34518 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___34518,res,vec__34332,v,p,job,jobs,results){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___34518,res,vec__34332,v,p,job,jobs,results){
return (function (state_34339){
var state_val_34340 = (state_34339[(1)]);
if((state_val_34340 === (1))){
var state_34339__$1 = state_34339;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34339__$1,(2),res,v);
} else {
if((state_val_34340 === (2))){
var inst_34336 = (state_34339[(2)]);
var inst_34337 = cljs.core.async.close_BANG_(res);
var state_34339__$1 = (function (){var statearr_34341 = state_34339;
(statearr_34341[(7)] = inst_34336);

return statearr_34341;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34339__$1,inst_34337);
} else {
return null;
}
}
});})(c__19252__auto___34518,res,vec__34332,v,p,job,jobs,results))
;
return ((function (switch__19140__auto__,c__19252__auto___34518,res,vec__34332,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0 = (function (){
var statearr_34345 = [null,null,null,null,null,null,null,null];
(statearr_34345[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__);

(statearr_34345[(1)] = (1));

return statearr_34345;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1 = (function (state_34339){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34339);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34346){if((e34346 instanceof Object)){
var ex__19144__auto__ = e34346;
var statearr_34347_34519 = state_34339;
(statearr_34347_34519[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34339);

return cljs.core.cst$kw$recur;
} else {
throw e34346;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34520 = state_34339;
state_34339 = G__34520;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = function(state_34339){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1.call(this,state_34339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___34518,res,vec__34332,v,p,job,jobs,results))
})();
var state__19254__auto__ = (function (){var statearr_34348 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34348[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___34518);

return statearr_34348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___34518,res,vec__34332,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__34349){
var vec__34350 = p__34349;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34350,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34350,(1),null);
var job = vec__34350;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7461__auto___34521 = n;
var __34522 = (0);
while(true){
if((__34522 < n__7461__auto___34521)){
var G__34353_34523 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__34353_34523) {
case "compute":
var c__19252__auto___34525 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34522,c__19252__auto___34525,G__34353_34523,n__7461__auto___34521,jobs,results,process,async){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (__34522,c__19252__auto___34525,G__34353_34523,n__7461__auto___34521,jobs,results,process,async){
return (function (state_34366){
var state_val_34367 = (state_34366[(1)]);
if((state_val_34367 === (1))){
var state_34366__$1 = state_34366;
var statearr_34368_34526 = state_34366__$1;
(statearr_34368_34526[(2)] = null);

(statearr_34368_34526[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (2))){
var state_34366__$1 = state_34366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34366__$1,(4),jobs);
} else {
if((state_val_34367 === (3))){
var inst_34364 = (state_34366[(2)]);
var state_34366__$1 = state_34366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34366__$1,inst_34364);
} else {
if((state_val_34367 === (4))){
var inst_34356 = (state_34366[(2)]);
var inst_34357 = process(inst_34356);
var state_34366__$1 = state_34366;
if(cljs.core.truth_(inst_34357)){
var statearr_34369_34527 = state_34366__$1;
(statearr_34369_34527[(1)] = (5));

} else {
var statearr_34370_34528 = state_34366__$1;
(statearr_34370_34528[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (5))){
var state_34366__$1 = state_34366;
var statearr_34371_34529 = state_34366__$1;
(statearr_34371_34529[(2)] = null);

(statearr_34371_34529[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (6))){
var state_34366__$1 = state_34366;
var statearr_34372_34530 = state_34366__$1;
(statearr_34372_34530[(2)] = null);

(statearr_34372_34530[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (7))){
var inst_34362 = (state_34366[(2)]);
var state_34366__$1 = state_34366;
var statearr_34373_34531 = state_34366__$1;
(statearr_34373_34531[(2)] = inst_34362);

(statearr_34373_34531[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__34522,c__19252__auto___34525,G__34353_34523,n__7461__auto___34521,jobs,results,process,async))
;
return ((function (__34522,switch__19140__auto__,c__19252__auto___34525,G__34353_34523,n__7461__auto___34521,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0 = (function (){
var statearr_34377 = [null,null,null,null,null,null,null];
(statearr_34377[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__);

(statearr_34377[(1)] = (1));

return statearr_34377;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1 = (function (state_34366){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34366);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34378){if((e34378 instanceof Object)){
var ex__19144__auto__ = e34378;
var statearr_34379_34532 = state_34366;
(statearr_34379_34532[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34366);

return cljs.core.cst$kw$recur;
} else {
throw e34378;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34533 = state_34366;
state_34366 = G__34533;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = function(state_34366){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1.call(this,state_34366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__;
})()
;})(__34522,switch__19140__auto__,c__19252__auto___34525,G__34353_34523,n__7461__auto___34521,jobs,results,process,async))
})();
var state__19254__auto__ = (function (){var statearr_34380 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34380[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___34525);

return statearr_34380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(__34522,c__19252__auto___34525,G__34353_34523,n__7461__auto___34521,jobs,results,process,async))
);


break;
case "async":
var c__19252__auto___34534 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34522,c__19252__auto___34534,G__34353_34523,n__7461__auto___34521,jobs,results,process,async){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (__34522,c__19252__auto___34534,G__34353_34523,n__7461__auto___34521,jobs,results,process,async){
return (function (state_34393){
var state_val_34394 = (state_34393[(1)]);
if((state_val_34394 === (1))){
var state_34393__$1 = state_34393;
var statearr_34395_34535 = state_34393__$1;
(statearr_34395_34535[(2)] = null);

(statearr_34395_34535[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (2))){
var state_34393__$1 = state_34393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34393__$1,(4),jobs);
} else {
if((state_val_34394 === (3))){
var inst_34391 = (state_34393[(2)]);
var state_34393__$1 = state_34393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34393__$1,inst_34391);
} else {
if((state_val_34394 === (4))){
var inst_34383 = (state_34393[(2)]);
var inst_34384 = async(inst_34383);
var state_34393__$1 = state_34393;
if(cljs.core.truth_(inst_34384)){
var statearr_34396_34536 = state_34393__$1;
(statearr_34396_34536[(1)] = (5));

} else {
var statearr_34397_34537 = state_34393__$1;
(statearr_34397_34537[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (5))){
var state_34393__$1 = state_34393;
var statearr_34398_34538 = state_34393__$1;
(statearr_34398_34538[(2)] = null);

(statearr_34398_34538[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (6))){
var state_34393__$1 = state_34393;
var statearr_34399_34539 = state_34393__$1;
(statearr_34399_34539[(2)] = null);

(statearr_34399_34539[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (7))){
var inst_34389 = (state_34393[(2)]);
var state_34393__$1 = state_34393;
var statearr_34400_34540 = state_34393__$1;
(statearr_34400_34540[(2)] = inst_34389);

(statearr_34400_34540[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__34522,c__19252__auto___34534,G__34353_34523,n__7461__auto___34521,jobs,results,process,async))
;
return ((function (__34522,switch__19140__auto__,c__19252__auto___34534,G__34353_34523,n__7461__auto___34521,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0 = (function (){
var statearr_34404 = [null,null,null,null,null,null,null];
(statearr_34404[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__);

(statearr_34404[(1)] = (1));

return statearr_34404;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1 = (function (state_34393){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34393);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34405){if((e34405 instanceof Object)){
var ex__19144__auto__ = e34405;
var statearr_34406_34541 = state_34393;
(statearr_34406_34541[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34393);

return cljs.core.cst$kw$recur;
} else {
throw e34405;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34542 = state_34393;
state_34393 = G__34542;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = function(state_34393){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1.call(this,state_34393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__;
})()
;})(__34522,switch__19140__auto__,c__19252__auto___34534,G__34353_34523,n__7461__auto___34521,jobs,results,process,async))
})();
var state__19254__auto__ = (function (){var statearr_34407 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34407[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___34534);

return statearr_34407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(__34522,c__19252__auto___34534,G__34353_34523,n__7461__auto___34521,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__34543 = (__34522 + (1));
__34522 = G__34543;
continue;
} else {
}
break;
}

var c__19252__auto___34544 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___34544,jobs,results,process,async){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___34544,jobs,results,process,async){
return (function (state_34429){
var state_val_34430 = (state_34429[(1)]);
if((state_val_34430 === (1))){
var state_34429__$1 = state_34429;
var statearr_34431_34545 = state_34429__$1;
(statearr_34431_34545[(2)] = null);

(statearr_34431_34545[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (2))){
var state_34429__$1 = state_34429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34429__$1,(4),from);
} else {
if((state_val_34430 === (3))){
var inst_34427 = (state_34429[(2)]);
var state_34429__$1 = state_34429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34429__$1,inst_34427);
} else {
if((state_val_34430 === (4))){
var inst_34410 = (state_34429[(7)]);
var inst_34410__$1 = (state_34429[(2)]);
var inst_34411 = (inst_34410__$1 == null);
var state_34429__$1 = (function (){var statearr_34432 = state_34429;
(statearr_34432[(7)] = inst_34410__$1);

return statearr_34432;
})();
if(cljs.core.truth_(inst_34411)){
var statearr_34433_34546 = state_34429__$1;
(statearr_34433_34546[(1)] = (5));

} else {
var statearr_34434_34547 = state_34429__$1;
(statearr_34434_34547[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (5))){
var inst_34413 = cljs.core.async.close_BANG_(jobs);
var state_34429__$1 = state_34429;
var statearr_34435_34548 = state_34429__$1;
(statearr_34435_34548[(2)] = inst_34413);

(statearr_34435_34548[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (6))){
var inst_34410 = (state_34429[(7)]);
var inst_34415 = (state_34429[(8)]);
var inst_34415__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_34416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34417 = [inst_34410,inst_34415__$1];
var inst_34418 = (new cljs.core.PersistentVector(null,2,(5),inst_34416,inst_34417,null));
var state_34429__$1 = (function (){var statearr_34436 = state_34429;
(statearr_34436[(8)] = inst_34415__$1);

return statearr_34436;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34429__$1,(8),jobs,inst_34418);
} else {
if((state_val_34430 === (7))){
var inst_34425 = (state_34429[(2)]);
var state_34429__$1 = state_34429;
var statearr_34437_34549 = state_34429__$1;
(statearr_34437_34549[(2)] = inst_34425);

(statearr_34437_34549[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (8))){
var inst_34415 = (state_34429[(8)]);
var inst_34420 = (state_34429[(2)]);
var state_34429__$1 = (function (){var statearr_34438 = state_34429;
(statearr_34438[(9)] = inst_34420);

return statearr_34438;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34429__$1,(9),results,inst_34415);
} else {
if((state_val_34430 === (9))){
var inst_34422 = (state_34429[(2)]);
var state_34429__$1 = (function (){var statearr_34439 = state_34429;
(statearr_34439[(10)] = inst_34422);

return statearr_34439;
})();
var statearr_34440_34550 = state_34429__$1;
(statearr_34440_34550[(2)] = null);

(statearr_34440_34550[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___34544,jobs,results,process,async))
;
return ((function (switch__19140__auto__,c__19252__auto___34544,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0 = (function (){
var statearr_34444 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34444[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__);

(statearr_34444[(1)] = (1));

return statearr_34444;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1 = (function (state_34429){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34429);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34445){if((e34445 instanceof Object)){
var ex__19144__auto__ = e34445;
var statearr_34446_34551 = state_34429;
(statearr_34446_34551[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34429);

return cljs.core.cst$kw$recur;
} else {
throw e34445;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34552 = state_34429;
state_34429 = G__34552;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = function(state_34429){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1.call(this,state_34429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___34544,jobs,results,process,async))
})();
var state__19254__auto__ = (function (){var statearr_34447 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34447[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___34544);

return statearr_34447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___34544,jobs,results,process,async))
);


var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__,jobs,results,process,async){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__,jobs,results,process,async){
return (function (state_34485){
var state_val_34486 = (state_34485[(1)]);
if((state_val_34486 === (7))){
var inst_34481 = (state_34485[(2)]);
var state_34485__$1 = state_34485;
var statearr_34487_34553 = state_34485__$1;
(statearr_34487_34553[(2)] = inst_34481);

(statearr_34487_34553[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (20))){
var state_34485__$1 = state_34485;
var statearr_34488_34554 = state_34485__$1;
(statearr_34488_34554[(2)] = null);

(statearr_34488_34554[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (1))){
var state_34485__$1 = state_34485;
var statearr_34489_34555 = state_34485__$1;
(statearr_34489_34555[(2)] = null);

(statearr_34489_34555[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (4))){
var inst_34450 = (state_34485[(7)]);
var inst_34450__$1 = (state_34485[(2)]);
var inst_34451 = (inst_34450__$1 == null);
var state_34485__$1 = (function (){var statearr_34490 = state_34485;
(statearr_34490[(7)] = inst_34450__$1);

return statearr_34490;
})();
if(cljs.core.truth_(inst_34451)){
var statearr_34491_34556 = state_34485__$1;
(statearr_34491_34556[(1)] = (5));

} else {
var statearr_34492_34557 = state_34485__$1;
(statearr_34492_34557[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (15))){
var inst_34463 = (state_34485[(8)]);
var state_34485__$1 = state_34485;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34485__$1,(18),to,inst_34463);
} else {
if((state_val_34486 === (21))){
var inst_34476 = (state_34485[(2)]);
var state_34485__$1 = state_34485;
var statearr_34493_34558 = state_34485__$1;
(statearr_34493_34558[(2)] = inst_34476);

(statearr_34493_34558[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (13))){
var inst_34478 = (state_34485[(2)]);
var state_34485__$1 = (function (){var statearr_34494 = state_34485;
(statearr_34494[(9)] = inst_34478);

return statearr_34494;
})();
var statearr_34495_34559 = state_34485__$1;
(statearr_34495_34559[(2)] = null);

(statearr_34495_34559[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (6))){
var inst_34450 = (state_34485[(7)]);
var state_34485__$1 = state_34485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34485__$1,(11),inst_34450);
} else {
if((state_val_34486 === (17))){
var inst_34471 = (state_34485[(2)]);
var state_34485__$1 = state_34485;
if(cljs.core.truth_(inst_34471)){
var statearr_34496_34560 = state_34485__$1;
(statearr_34496_34560[(1)] = (19));

} else {
var statearr_34497_34561 = state_34485__$1;
(statearr_34497_34561[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (3))){
var inst_34483 = (state_34485[(2)]);
var state_34485__$1 = state_34485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34485__$1,inst_34483);
} else {
if((state_val_34486 === (12))){
var inst_34460 = (state_34485[(10)]);
var state_34485__$1 = state_34485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34485__$1,(14),inst_34460);
} else {
if((state_val_34486 === (2))){
var state_34485__$1 = state_34485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34485__$1,(4),results);
} else {
if((state_val_34486 === (19))){
var state_34485__$1 = state_34485;
var statearr_34498_34562 = state_34485__$1;
(statearr_34498_34562[(2)] = null);

(statearr_34498_34562[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (11))){
var inst_34460 = (state_34485[(2)]);
var state_34485__$1 = (function (){var statearr_34499 = state_34485;
(statearr_34499[(10)] = inst_34460);

return statearr_34499;
})();
var statearr_34500_34563 = state_34485__$1;
(statearr_34500_34563[(2)] = null);

(statearr_34500_34563[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (9))){
var state_34485__$1 = state_34485;
var statearr_34501_34564 = state_34485__$1;
(statearr_34501_34564[(2)] = null);

(statearr_34501_34564[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (5))){
var state_34485__$1 = state_34485;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34502_34565 = state_34485__$1;
(statearr_34502_34565[(1)] = (8));

} else {
var statearr_34503_34566 = state_34485__$1;
(statearr_34503_34566[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (14))){
var inst_34463 = (state_34485[(8)]);
var inst_34465 = (state_34485[(11)]);
var inst_34463__$1 = (state_34485[(2)]);
var inst_34464 = (inst_34463__$1 == null);
var inst_34465__$1 = cljs.core.not(inst_34464);
var state_34485__$1 = (function (){var statearr_34504 = state_34485;
(statearr_34504[(8)] = inst_34463__$1);

(statearr_34504[(11)] = inst_34465__$1);

return statearr_34504;
})();
if(inst_34465__$1){
var statearr_34505_34567 = state_34485__$1;
(statearr_34505_34567[(1)] = (15));

} else {
var statearr_34506_34568 = state_34485__$1;
(statearr_34506_34568[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (16))){
var inst_34465 = (state_34485[(11)]);
var state_34485__$1 = state_34485;
var statearr_34507_34569 = state_34485__$1;
(statearr_34507_34569[(2)] = inst_34465);

(statearr_34507_34569[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (10))){
var inst_34457 = (state_34485[(2)]);
var state_34485__$1 = state_34485;
var statearr_34508_34570 = state_34485__$1;
(statearr_34508_34570[(2)] = inst_34457);

(statearr_34508_34570[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (18))){
var inst_34468 = (state_34485[(2)]);
var state_34485__$1 = state_34485;
var statearr_34509_34571 = state_34485__$1;
(statearr_34509_34571[(2)] = inst_34468);

(statearr_34509_34571[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34486 === (8))){
var inst_34454 = cljs.core.async.close_BANG_(to);
var state_34485__$1 = state_34485;
var statearr_34510_34572 = state_34485__$1;
(statearr_34510_34572[(2)] = inst_34454);

(statearr_34510_34572[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto__,jobs,results,process,async))
;
return ((function (switch__19140__auto__,c__19252__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0 = (function (){
var statearr_34514 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34514[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__);

(statearr_34514[(1)] = (1));

return statearr_34514;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1 = (function (state_34485){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34485);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34515){if((e34515 instanceof Object)){
var ex__19144__auto__ = e34515;
var statearr_34516_34573 = state_34485;
(statearr_34516_34573[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34485);

return cljs.core.cst$kw$recur;
} else {
throw e34515;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34574 = state_34485;
state_34485 = G__34574;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__ = function(state_34485){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1.call(this,state_34485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19141__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__,jobs,results,process,async))
})();
var state__19254__auto__ = (function (){var statearr_34517 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34517[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_34517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__,jobs,results,process,async))
);

return c__19252__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args34575 = [];
var len__7651__auto___34578 = arguments.length;
var i__7652__auto___34579 = (0);
while(true){
if((i__7652__auto___34579 < len__7651__auto___34578)){
args34575.push((arguments[i__7652__auto___34579]));

var G__34580 = (i__7652__auto___34579 + (1));
i__7652__auto___34579 = G__34580;
continue;
} else {
}
break;
}

var G__34577 = args34575.length;
switch (G__34577) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34575.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args34582 = [];
var len__7651__auto___34585 = arguments.length;
var i__7652__auto___34586 = (0);
while(true){
if((i__7652__auto___34586 < len__7651__auto___34585)){
args34582.push((arguments[i__7652__auto___34586]));

var G__34587 = (i__7652__auto___34586 + (1));
i__7652__auto___34586 = G__34587;
continue;
} else {
}
break;
}

var G__34584 = args34582.length;
switch (G__34584) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34582.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args34589 = [];
var len__7651__auto___34642 = arguments.length;
var i__7652__auto___34643 = (0);
while(true){
if((i__7652__auto___34643 < len__7651__auto___34642)){
args34589.push((arguments[i__7652__auto___34643]));

var G__34644 = (i__7652__auto___34643 + (1));
i__7652__auto___34643 = G__34644;
continue;
} else {
}
break;
}

var G__34591 = args34589.length;
switch (G__34591) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34589.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__19252__auto___34646 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___34646,tc,fc){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___34646,tc,fc){
return (function (state_34617){
var state_val_34618 = (state_34617[(1)]);
if((state_val_34618 === (7))){
var inst_34613 = (state_34617[(2)]);
var state_34617__$1 = state_34617;
var statearr_34619_34647 = state_34617__$1;
(statearr_34619_34647[(2)] = inst_34613);

(statearr_34619_34647[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (1))){
var state_34617__$1 = state_34617;
var statearr_34620_34648 = state_34617__$1;
(statearr_34620_34648[(2)] = null);

(statearr_34620_34648[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (4))){
var inst_34594 = (state_34617[(7)]);
var inst_34594__$1 = (state_34617[(2)]);
var inst_34595 = (inst_34594__$1 == null);
var state_34617__$1 = (function (){var statearr_34621 = state_34617;
(statearr_34621[(7)] = inst_34594__$1);

return statearr_34621;
})();
if(cljs.core.truth_(inst_34595)){
var statearr_34622_34649 = state_34617__$1;
(statearr_34622_34649[(1)] = (5));

} else {
var statearr_34623_34650 = state_34617__$1;
(statearr_34623_34650[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (13))){
var state_34617__$1 = state_34617;
var statearr_34624_34651 = state_34617__$1;
(statearr_34624_34651[(2)] = null);

(statearr_34624_34651[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (6))){
var inst_34594 = (state_34617[(7)]);
var inst_34600 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_34594) : p.call(null,inst_34594));
var state_34617__$1 = state_34617;
if(cljs.core.truth_(inst_34600)){
var statearr_34625_34652 = state_34617__$1;
(statearr_34625_34652[(1)] = (9));

} else {
var statearr_34626_34653 = state_34617__$1;
(statearr_34626_34653[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (3))){
var inst_34615 = (state_34617[(2)]);
var state_34617__$1 = state_34617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34617__$1,inst_34615);
} else {
if((state_val_34618 === (12))){
var state_34617__$1 = state_34617;
var statearr_34627_34654 = state_34617__$1;
(statearr_34627_34654[(2)] = null);

(statearr_34627_34654[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (2))){
var state_34617__$1 = state_34617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34617__$1,(4),ch);
} else {
if((state_val_34618 === (11))){
var inst_34594 = (state_34617[(7)]);
var inst_34604 = (state_34617[(2)]);
var state_34617__$1 = state_34617;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34617__$1,(8),inst_34604,inst_34594);
} else {
if((state_val_34618 === (9))){
var state_34617__$1 = state_34617;
var statearr_34628_34655 = state_34617__$1;
(statearr_34628_34655[(2)] = tc);

(statearr_34628_34655[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (5))){
var inst_34597 = cljs.core.async.close_BANG_(tc);
var inst_34598 = cljs.core.async.close_BANG_(fc);
var state_34617__$1 = (function (){var statearr_34629 = state_34617;
(statearr_34629[(8)] = inst_34597);

return statearr_34629;
})();
var statearr_34630_34656 = state_34617__$1;
(statearr_34630_34656[(2)] = inst_34598);

(statearr_34630_34656[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (14))){
var inst_34611 = (state_34617[(2)]);
var state_34617__$1 = state_34617;
var statearr_34631_34657 = state_34617__$1;
(statearr_34631_34657[(2)] = inst_34611);

(statearr_34631_34657[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (10))){
var state_34617__$1 = state_34617;
var statearr_34632_34658 = state_34617__$1;
(statearr_34632_34658[(2)] = fc);

(statearr_34632_34658[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34618 === (8))){
var inst_34606 = (state_34617[(2)]);
var state_34617__$1 = state_34617;
if(cljs.core.truth_(inst_34606)){
var statearr_34633_34659 = state_34617__$1;
(statearr_34633_34659[(1)] = (12));

} else {
var statearr_34634_34660 = state_34617__$1;
(statearr_34634_34660[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___34646,tc,fc))
;
return ((function (switch__19140__auto__,c__19252__auto___34646,tc,fc){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_34638 = [null,null,null,null,null,null,null,null,null];
(statearr_34638[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_34638[(1)] = (1));

return statearr_34638;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_34617){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34617);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34639){if((e34639 instanceof Object)){
var ex__19144__auto__ = e34639;
var statearr_34640_34661 = state_34617;
(statearr_34640_34661[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34617);

return cljs.core.cst$kw$recur;
} else {
throw e34639;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34662 = state_34617;
state_34617 = G__34662;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_34617){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_34617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___34646,tc,fc))
})();
var state__19254__auto__ = (function (){var statearr_34641 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34641[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___34646);

return statearr_34641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___34646,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__){
return (function (state_34726){
var state_val_34727 = (state_34726[(1)]);
if((state_val_34727 === (7))){
var inst_34722 = (state_34726[(2)]);
var state_34726__$1 = state_34726;
var statearr_34728_34749 = state_34726__$1;
(statearr_34728_34749[(2)] = inst_34722);

(statearr_34728_34749[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34727 === (1))){
var inst_34706 = init;
var state_34726__$1 = (function (){var statearr_34729 = state_34726;
(statearr_34729[(7)] = inst_34706);

return statearr_34729;
})();
var statearr_34730_34750 = state_34726__$1;
(statearr_34730_34750[(2)] = null);

(statearr_34730_34750[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34727 === (4))){
var inst_34709 = (state_34726[(8)]);
var inst_34709__$1 = (state_34726[(2)]);
var inst_34710 = (inst_34709__$1 == null);
var state_34726__$1 = (function (){var statearr_34731 = state_34726;
(statearr_34731[(8)] = inst_34709__$1);

return statearr_34731;
})();
if(cljs.core.truth_(inst_34710)){
var statearr_34732_34751 = state_34726__$1;
(statearr_34732_34751[(1)] = (5));

} else {
var statearr_34733_34752 = state_34726__$1;
(statearr_34733_34752[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34727 === (6))){
var inst_34713 = (state_34726[(9)]);
var inst_34706 = (state_34726[(7)]);
var inst_34709 = (state_34726[(8)]);
var inst_34713__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_34706,inst_34709) : f.call(null,inst_34706,inst_34709));
var inst_34714 = cljs.core.reduced_QMARK_(inst_34713__$1);
var state_34726__$1 = (function (){var statearr_34734 = state_34726;
(statearr_34734[(9)] = inst_34713__$1);

return statearr_34734;
})();
if(inst_34714){
var statearr_34735_34753 = state_34726__$1;
(statearr_34735_34753[(1)] = (8));

} else {
var statearr_34736_34754 = state_34726__$1;
(statearr_34736_34754[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34727 === (3))){
var inst_34724 = (state_34726[(2)]);
var state_34726__$1 = state_34726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34726__$1,inst_34724);
} else {
if((state_val_34727 === (2))){
var state_34726__$1 = state_34726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34726__$1,(4),ch);
} else {
if((state_val_34727 === (9))){
var inst_34713 = (state_34726[(9)]);
var inst_34706 = inst_34713;
var state_34726__$1 = (function (){var statearr_34737 = state_34726;
(statearr_34737[(7)] = inst_34706);

return statearr_34737;
})();
var statearr_34738_34755 = state_34726__$1;
(statearr_34738_34755[(2)] = null);

(statearr_34738_34755[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34727 === (5))){
var inst_34706 = (state_34726[(7)]);
var state_34726__$1 = state_34726;
var statearr_34739_34756 = state_34726__$1;
(statearr_34739_34756[(2)] = inst_34706);

(statearr_34739_34756[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34727 === (10))){
var inst_34720 = (state_34726[(2)]);
var state_34726__$1 = state_34726;
var statearr_34740_34757 = state_34726__$1;
(statearr_34740_34757[(2)] = inst_34720);

(statearr_34740_34757[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34727 === (8))){
var inst_34713 = (state_34726[(9)]);
var inst_34716 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_34713) : cljs.core.deref.call(null,inst_34713));
var state_34726__$1 = state_34726;
var statearr_34741_34758 = state_34726__$1;
(statearr_34741_34758[(2)] = inst_34716);

(statearr_34741_34758[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto__))
;
return ((function (switch__19140__auto__,c__19252__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__19141__auto__ = null;
var cljs$core$async$reduce_$_state_machine__19141__auto____0 = (function (){
var statearr_34745 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34745[(0)] = cljs$core$async$reduce_$_state_machine__19141__auto__);

(statearr_34745[(1)] = (1));

return statearr_34745;
});
var cljs$core$async$reduce_$_state_machine__19141__auto____1 = (function (state_34726){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34726);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34746){if((e34746 instanceof Object)){
var ex__19144__auto__ = e34746;
var statearr_34747_34759 = state_34726;
(statearr_34747_34759[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34726);

return cljs.core.cst$kw$recur;
} else {
throw e34746;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34760 = state_34726;
state_34726 = G__34760;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__19141__auto__ = function(state_34726){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__19141__auto____1.call(this,state_34726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__19141__auto____0;
cljs$core$async$reduce_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__19141__auto____1;
return cljs$core$async$reduce_$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__))
})();
var state__19254__auto__ = (function (){var statearr_34748 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34748[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_34748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__))
);

return c__19252__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__,f__$1){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__,f__$1){
return (function (state_34780){
var state_val_34781 = (state_34780[(1)]);
if((state_val_34781 === (1))){
var inst_34775 = cljs.core.async.reduce(f__$1,init,ch);
var state_34780__$1 = state_34780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34780__$1,(2),inst_34775);
} else {
if((state_val_34781 === (2))){
var inst_34777 = (state_34780[(2)]);
var inst_34778 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_34777) : f__$1.call(null,inst_34777));
var state_34780__$1 = state_34780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34780__$1,inst_34778);
} else {
return null;
}
}
});})(c__19252__auto__,f__$1))
;
return ((function (switch__19140__auto__,c__19252__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__19141__auto__ = null;
var cljs$core$async$transduce_$_state_machine__19141__auto____0 = (function (){
var statearr_34785 = [null,null,null,null,null,null,null];
(statearr_34785[(0)] = cljs$core$async$transduce_$_state_machine__19141__auto__);

(statearr_34785[(1)] = (1));

return statearr_34785;
});
var cljs$core$async$transduce_$_state_machine__19141__auto____1 = (function (state_34780){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34780);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34786){if((e34786 instanceof Object)){
var ex__19144__auto__ = e34786;
var statearr_34787_34789 = state_34780;
(statearr_34787_34789[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34780);

return cljs.core.cst$kw$recur;
} else {
throw e34786;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34790 = state_34780;
state_34780 = G__34790;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__19141__auto__ = function(state_34780){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__19141__auto____1.call(this,state_34780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__19141__auto____0;
cljs$core$async$transduce_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__19141__auto____1;
return cljs$core$async$transduce_$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__,f__$1))
})();
var state__19254__auto__ = (function (){var statearr_34788 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34788[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_34788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__,f__$1))
);

return c__19252__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args34791 = [];
var len__7651__auto___34843 = arguments.length;
var i__7652__auto___34844 = (0);
while(true){
if((i__7652__auto___34844 < len__7651__auto___34843)){
args34791.push((arguments[i__7652__auto___34844]));

var G__34845 = (i__7652__auto___34844 + (1));
i__7652__auto___34844 = G__34845;
continue;
} else {
}
break;
}

var G__34793 = args34791.length;
switch (G__34793) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34791.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__){
return (function (state_34818){
var state_val_34819 = (state_34818[(1)]);
if((state_val_34819 === (7))){
var inst_34800 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
var statearr_34820_34847 = state_34818__$1;
(statearr_34820_34847[(2)] = inst_34800);

(statearr_34820_34847[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (1))){
var inst_34794 = cljs.core.seq(coll);
var inst_34795 = inst_34794;
var state_34818__$1 = (function (){var statearr_34821 = state_34818;
(statearr_34821[(7)] = inst_34795);

return statearr_34821;
})();
var statearr_34822_34848 = state_34818__$1;
(statearr_34822_34848[(2)] = null);

(statearr_34822_34848[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (4))){
var inst_34795 = (state_34818[(7)]);
var inst_34798 = cljs.core.first(inst_34795);
var state_34818__$1 = state_34818;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34818__$1,(7),ch,inst_34798);
} else {
if((state_val_34819 === (13))){
var inst_34812 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
var statearr_34823_34849 = state_34818__$1;
(statearr_34823_34849[(2)] = inst_34812);

(statearr_34823_34849[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (6))){
var inst_34803 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
if(cljs.core.truth_(inst_34803)){
var statearr_34824_34850 = state_34818__$1;
(statearr_34824_34850[(1)] = (8));

} else {
var statearr_34825_34851 = state_34818__$1;
(statearr_34825_34851[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (3))){
var inst_34816 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34818__$1,inst_34816);
} else {
if((state_val_34819 === (12))){
var state_34818__$1 = state_34818;
var statearr_34826_34852 = state_34818__$1;
(statearr_34826_34852[(2)] = null);

(statearr_34826_34852[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (2))){
var inst_34795 = (state_34818[(7)]);
var state_34818__$1 = state_34818;
if(cljs.core.truth_(inst_34795)){
var statearr_34827_34853 = state_34818__$1;
(statearr_34827_34853[(1)] = (4));

} else {
var statearr_34828_34854 = state_34818__$1;
(statearr_34828_34854[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (11))){
var inst_34809 = cljs.core.async.close_BANG_(ch);
var state_34818__$1 = state_34818;
var statearr_34829_34855 = state_34818__$1;
(statearr_34829_34855[(2)] = inst_34809);

(statearr_34829_34855[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (9))){
var state_34818__$1 = state_34818;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34830_34856 = state_34818__$1;
(statearr_34830_34856[(1)] = (11));

} else {
var statearr_34831_34857 = state_34818__$1;
(statearr_34831_34857[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (5))){
var inst_34795 = (state_34818[(7)]);
var state_34818__$1 = state_34818;
var statearr_34832_34858 = state_34818__$1;
(statearr_34832_34858[(2)] = inst_34795);

(statearr_34832_34858[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (10))){
var inst_34814 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
var statearr_34833_34859 = state_34818__$1;
(statearr_34833_34859[(2)] = inst_34814);

(statearr_34833_34859[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34819 === (8))){
var inst_34795 = (state_34818[(7)]);
var inst_34805 = cljs.core.next(inst_34795);
var inst_34795__$1 = inst_34805;
var state_34818__$1 = (function (){var statearr_34834 = state_34818;
(statearr_34834[(7)] = inst_34795__$1);

return statearr_34834;
})();
var statearr_34835_34860 = state_34818__$1;
(statearr_34835_34860[(2)] = null);

(statearr_34835_34860[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto__))
;
return ((function (switch__19140__auto__,c__19252__auto__){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_34839 = [null,null,null,null,null,null,null,null];
(statearr_34839[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_34839[(1)] = (1));

return statearr_34839;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_34818){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_34818);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e34840){if((e34840 instanceof Object)){
var ex__19144__auto__ = e34840;
var statearr_34841_34861 = state_34818;
(statearr_34841_34861[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34818);

return cljs.core.cst$kw$recur;
} else {
throw e34840;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__34862 = state_34818;
state_34818 = G__34862;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_34818){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_34818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__))
})();
var state__19254__auto__ = (function (){var statearr_34842 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_34842[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_34842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__))
);

return c__19252__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7206__auto__ = (((_ == null))?null:_);
var m__7207__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto__.call(null,_));
} else {
var m__7207__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__35091 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__35091) : cljs.core.atom.call(null,G__35091));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async35092 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35092 = (function (ch,cs,meta35093){
this.ch = ch;
this.cs = cs;
this.meta35093 = meta35093;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_35094,meta35093__$1){
var self__ = this;
var _35094__$1 = this;
return (new cljs.core.async.t_cljs$core$async35092(self__.ch,self__.cs,meta35093__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_35094){
var self__ = this;
var _35094__$1 = this;
return self__.meta35093;
});})(cs))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__35095_35319 = self__.cs;
var G__35096_35320 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__35095_35319,G__35096_35320) : cljs.core.reset_BANG_.call(null,G__35095_35319,G__35096_35320));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async35092.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta35093], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async35092.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35092.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35092";

cljs.core.async.t_cljs$core$async35092.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async35092");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async35092 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async35092(ch__$1,cs__$1,meta35093){
return (new cljs.core.async.t_cljs$core$async35092(ch__$1,cs__$1,meta35093));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async35092(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__19252__auto___35321 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___35321,cs,m,dchan,dctr,done){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___35321,cs,m,dchan,dctr,done){
return (function (state_35231){
var state_val_35232 = (state_35231[(1)]);
if((state_val_35232 === (7))){
var inst_35227 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35233_35322 = state_35231__$1;
(statearr_35233_35322[(2)] = inst_35227);

(statearr_35233_35322[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (20))){
var inst_35130 = (state_35231[(7)]);
var inst_35142 = cljs.core.first(inst_35130);
var inst_35143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35142,(0),null);
var inst_35144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35142,(1),null);
var state_35231__$1 = (function (){var statearr_35234 = state_35231;
(statearr_35234[(8)] = inst_35143);

return statearr_35234;
})();
if(cljs.core.truth_(inst_35144)){
var statearr_35235_35323 = state_35231__$1;
(statearr_35235_35323[(1)] = (22));

} else {
var statearr_35236_35324 = state_35231__$1;
(statearr_35236_35324[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (27))){
var inst_35172 = (state_35231[(9)]);
var inst_35179 = (state_35231[(10)]);
var inst_35174 = (state_35231[(11)]);
var inst_35099 = (state_35231[(12)]);
var inst_35179__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_35172,inst_35174);
var inst_35180 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_35179__$1,inst_35099,done);
var state_35231__$1 = (function (){var statearr_35237 = state_35231;
(statearr_35237[(10)] = inst_35179__$1);

return statearr_35237;
})();
if(cljs.core.truth_(inst_35180)){
var statearr_35238_35325 = state_35231__$1;
(statearr_35238_35325[(1)] = (30));

} else {
var statearr_35239_35326 = state_35231__$1;
(statearr_35239_35326[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (1))){
var state_35231__$1 = state_35231;
var statearr_35240_35327 = state_35231__$1;
(statearr_35240_35327[(2)] = null);

(statearr_35240_35327[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (24))){
var inst_35130 = (state_35231[(7)]);
var inst_35149 = (state_35231[(2)]);
var inst_35150 = cljs.core.next(inst_35130);
var inst_35108 = inst_35150;
var inst_35109 = null;
var inst_35110 = (0);
var inst_35111 = (0);
var state_35231__$1 = (function (){var statearr_35241 = state_35231;
(statearr_35241[(13)] = inst_35109);

(statearr_35241[(14)] = inst_35108);

(statearr_35241[(15)] = inst_35149);

(statearr_35241[(16)] = inst_35110);

(statearr_35241[(17)] = inst_35111);

return statearr_35241;
})();
var statearr_35242_35328 = state_35231__$1;
(statearr_35242_35328[(2)] = null);

(statearr_35242_35328[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (39))){
var state_35231__$1 = state_35231;
var statearr_35246_35329 = state_35231__$1;
(statearr_35246_35329[(2)] = null);

(statearr_35246_35329[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (4))){
var inst_35099 = (state_35231[(12)]);
var inst_35099__$1 = (state_35231[(2)]);
var inst_35100 = (inst_35099__$1 == null);
var state_35231__$1 = (function (){var statearr_35247 = state_35231;
(statearr_35247[(12)] = inst_35099__$1);

return statearr_35247;
})();
if(cljs.core.truth_(inst_35100)){
var statearr_35248_35330 = state_35231__$1;
(statearr_35248_35330[(1)] = (5));

} else {
var statearr_35249_35331 = state_35231__$1;
(statearr_35249_35331[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (15))){
var inst_35109 = (state_35231[(13)]);
var inst_35108 = (state_35231[(14)]);
var inst_35110 = (state_35231[(16)]);
var inst_35111 = (state_35231[(17)]);
var inst_35126 = (state_35231[(2)]);
var inst_35127 = (inst_35111 + (1));
var tmp35243 = inst_35109;
var tmp35244 = inst_35108;
var tmp35245 = inst_35110;
var inst_35108__$1 = tmp35244;
var inst_35109__$1 = tmp35243;
var inst_35110__$1 = tmp35245;
var inst_35111__$1 = inst_35127;
var state_35231__$1 = (function (){var statearr_35250 = state_35231;
(statearr_35250[(13)] = inst_35109__$1);

(statearr_35250[(14)] = inst_35108__$1);

(statearr_35250[(16)] = inst_35110__$1);

(statearr_35250[(17)] = inst_35111__$1);

(statearr_35250[(18)] = inst_35126);

return statearr_35250;
})();
var statearr_35251_35332 = state_35231__$1;
(statearr_35251_35332[(2)] = null);

(statearr_35251_35332[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (21))){
var inst_35153 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35255_35333 = state_35231__$1;
(statearr_35255_35333[(2)] = inst_35153);

(statearr_35255_35333[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (31))){
var inst_35179 = (state_35231[(10)]);
var inst_35183 = done(null);
var inst_35184 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_35179);
var state_35231__$1 = (function (){var statearr_35256 = state_35231;
(statearr_35256[(19)] = inst_35183);

return statearr_35256;
})();
var statearr_35257_35334 = state_35231__$1;
(statearr_35257_35334[(2)] = inst_35184);

(statearr_35257_35334[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (32))){
var inst_35172 = (state_35231[(9)]);
var inst_35171 = (state_35231[(20)]);
var inst_35174 = (state_35231[(11)]);
var inst_35173 = (state_35231[(21)]);
var inst_35186 = (state_35231[(2)]);
var inst_35187 = (inst_35174 + (1));
var tmp35252 = inst_35172;
var tmp35253 = inst_35171;
var tmp35254 = inst_35173;
var inst_35171__$1 = tmp35253;
var inst_35172__$1 = tmp35252;
var inst_35173__$1 = tmp35254;
var inst_35174__$1 = inst_35187;
var state_35231__$1 = (function (){var statearr_35258 = state_35231;
(statearr_35258[(9)] = inst_35172__$1);

(statearr_35258[(22)] = inst_35186);

(statearr_35258[(20)] = inst_35171__$1);

(statearr_35258[(11)] = inst_35174__$1);

(statearr_35258[(21)] = inst_35173__$1);

return statearr_35258;
})();
var statearr_35259_35335 = state_35231__$1;
(statearr_35259_35335[(2)] = null);

(statearr_35259_35335[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (40))){
var inst_35199 = (state_35231[(23)]);
var inst_35203 = done(null);
var inst_35204 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_35199);
var state_35231__$1 = (function (){var statearr_35260 = state_35231;
(statearr_35260[(24)] = inst_35203);

return statearr_35260;
})();
var statearr_35261_35336 = state_35231__$1;
(statearr_35261_35336[(2)] = inst_35204);

(statearr_35261_35336[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (33))){
var inst_35190 = (state_35231[(25)]);
var inst_35192 = cljs.core.chunked_seq_QMARK_(inst_35190);
var state_35231__$1 = state_35231;
if(inst_35192){
var statearr_35262_35337 = state_35231__$1;
(statearr_35262_35337[(1)] = (36));

} else {
var statearr_35263_35338 = state_35231__$1;
(statearr_35263_35338[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (13))){
var inst_35120 = (state_35231[(26)]);
var inst_35123 = cljs.core.async.close_BANG_(inst_35120);
var state_35231__$1 = state_35231;
var statearr_35264_35339 = state_35231__$1;
(statearr_35264_35339[(2)] = inst_35123);

(statearr_35264_35339[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (22))){
var inst_35143 = (state_35231[(8)]);
var inst_35146 = cljs.core.async.close_BANG_(inst_35143);
var state_35231__$1 = state_35231;
var statearr_35265_35340 = state_35231__$1;
(statearr_35265_35340[(2)] = inst_35146);

(statearr_35265_35340[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (36))){
var inst_35190 = (state_35231[(25)]);
var inst_35194 = cljs.core.chunk_first(inst_35190);
var inst_35195 = cljs.core.chunk_rest(inst_35190);
var inst_35196 = cljs.core.count(inst_35194);
var inst_35171 = inst_35195;
var inst_35172 = inst_35194;
var inst_35173 = inst_35196;
var inst_35174 = (0);
var state_35231__$1 = (function (){var statearr_35266 = state_35231;
(statearr_35266[(9)] = inst_35172);

(statearr_35266[(20)] = inst_35171);

(statearr_35266[(11)] = inst_35174);

(statearr_35266[(21)] = inst_35173);

return statearr_35266;
})();
var statearr_35267_35341 = state_35231__$1;
(statearr_35267_35341[(2)] = null);

(statearr_35267_35341[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (41))){
var inst_35190 = (state_35231[(25)]);
var inst_35206 = (state_35231[(2)]);
var inst_35207 = cljs.core.next(inst_35190);
var inst_35171 = inst_35207;
var inst_35172 = null;
var inst_35173 = (0);
var inst_35174 = (0);
var state_35231__$1 = (function (){var statearr_35268 = state_35231;
(statearr_35268[(9)] = inst_35172);

(statearr_35268[(20)] = inst_35171);

(statearr_35268[(27)] = inst_35206);

(statearr_35268[(11)] = inst_35174);

(statearr_35268[(21)] = inst_35173);

return statearr_35268;
})();
var statearr_35269_35342 = state_35231__$1;
(statearr_35269_35342[(2)] = null);

(statearr_35269_35342[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (43))){
var state_35231__$1 = state_35231;
var statearr_35270_35343 = state_35231__$1;
(statearr_35270_35343[(2)] = null);

(statearr_35270_35343[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (29))){
var inst_35215 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35271_35344 = state_35231__$1;
(statearr_35271_35344[(2)] = inst_35215);

(statearr_35271_35344[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (44))){
var inst_35224 = (state_35231[(2)]);
var state_35231__$1 = (function (){var statearr_35272 = state_35231;
(statearr_35272[(28)] = inst_35224);

return statearr_35272;
})();
var statearr_35273_35345 = state_35231__$1;
(statearr_35273_35345[(2)] = null);

(statearr_35273_35345[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (6))){
var inst_35163 = (state_35231[(29)]);
var inst_35162 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_35163__$1 = cljs.core.keys(inst_35162);
var inst_35164 = cljs.core.count(inst_35163__$1);
var inst_35165 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_35164) : cljs.core.reset_BANG_.call(null,dctr,inst_35164));
var inst_35170 = cljs.core.seq(inst_35163__$1);
var inst_35171 = inst_35170;
var inst_35172 = null;
var inst_35173 = (0);
var inst_35174 = (0);
var state_35231__$1 = (function (){var statearr_35274 = state_35231;
(statearr_35274[(9)] = inst_35172);

(statearr_35274[(29)] = inst_35163__$1);

(statearr_35274[(20)] = inst_35171);

(statearr_35274[(11)] = inst_35174);

(statearr_35274[(30)] = inst_35165);

(statearr_35274[(21)] = inst_35173);

return statearr_35274;
})();
var statearr_35275_35346 = state_35231__$1;
(statearr_35275_35346[(2)] = null);

(statearr_35275_35346[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (28))){
var inst_35190 = (state_35231[(25)]);
var inst_35171 = (state_35231[(20)]);
var inst_35190__$1 = cljs.core.seq(inst_35171);
var state_35231__$1 = (function (){var statearr_35276 = state_35231;
(statearr_35276[(25)] = inst_35190__$1);

return statearr_35276;
})();
if(inst_35190__$1){
var statearr_35277_35347 = state_35231__$1;
(statearr_35277_35347[(1)] = (33));

} else {
var statearr_35278_35348 = state_35231__$1;
(statearr_35278_35348[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (25))){
var inst_35174 = (state_35231[(11)]);
var inst_35173 = (state_35231[(21)]);
var inst_35176 = (inst_35174 < inst_35173);
var inst_35177 = inst_35176;
var state_35231__$1 = state_35231;
if(cljs.core.truth_(inst_35177)){
var statearr_35279_35349 = state_35231__$1;
(statearr_35279_35349[(1)] = (27));

} else {
var statearr_35280_35350 = state_35231__$1;
(statearr_35280_35350[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (34))){
var state_35231__$1 = state_35231;
var statearr_35281_35351 = state_35231__$1;
(statearr_35281_35351[(2)] = null);

(statearr_35281_35351[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (17))){
var state_35231__$1 = state_35231;
var statearr_35282_35352 = state_35231__$1;
(statearr_35282_35352[(2)] = null);

(statearr_35282_35352[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (3))){
var inst_35229 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35231__$1,inst_35229);
} else {
if((state_val_35232 === (12))){
var inst_35158 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35283_35353 = state_35231__$1;
(statearr_35283_35353[(2)] = inst_35158);

(statearr_35283_35353[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (2))){
var state_35231__$1 = state_35231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35231__$1,(4),ch);
} else {
if((state_val_35232 === (23))){
var state_35231__$1 = state_35231;
var statearr_35284_35354 = state_35231__$1;
(statearr_35284_35354[(2)] = null);

(statearr_35284_35354[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (35))){
var inst_35213 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35285_35355 = state_35231__$1;
(statearr_35285_35355[(2)] = inst_35213);

(statearr_35285_35355[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (19))){
var inst_35130 = (state_35231[(7)]);
var inst_35134 = cljs.core.chunk_first(inst_35130);
var inst_35135 = cljs.core.chunk_rest(inst_35130);
var inst_35136 = cljs.core.count(inst_35134);
var inst_35108 = inst_35135;
var inst_35109 = inst_35134;
var inst_35110 = inst_35136;
var inst_35111 = (0);
var state_35231__$1 = (function (){var statearr_35286 = state_35231;
(statearr_35286[(13)] = inst_35109);

(statearr_35286[(14)] = inst_35108);

(statearr_35286[(16)] = inst_35110);

(statearr_35286[(17)] = inst_35111);

return statearr_35286;
})();
var statearr_35287_35356 = state_35231__$1;
(statearr_35287_35356[(2)] = null);

(statearr_35287_35356[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (11))){
var inst_35130 = (state_35231[(7)]);
var inst_35108 = (state_35231[(14)]);
var inst_35130__$1 = cljs.core.seq(inst_35108);
var state_35231__$1 = (function (){var statearr_35288 = state_35231;
(statearr_35288[(7)] = inst_35130__$1);

return statearr_35288;
})();
if(inst_35130__$1){
var statearr_35289_35357 = state_35231__$1;
(statearr_35289_35357[(1)] = (16));

} else {
var statearr_35290_35358 = state_35231__$1;
(statearr_35290_35358[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (9))){
var inst_35160 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35291_35359 = state_35231__$1;
(statearr_35291_35359[(2)] = inst_35160);

(statearr_35291_35359[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (5))){
var inst_35106 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_35107 = cljs.core.seq(inst_35106);
var inst_35108 = inst_35107;
var inst_35109 = null;
var inst_35110 = (0);
var inst_35111 = (0);
var state_35231__$1 = (function (){var statearr_35292 = state_35231;
(statearr_35292[(13)] = inst_35109);

(statearr_35292[(14)] = inst_35108);

(statearr_35292[(16)] = inst_35110);

(statearr_35292[(17)] = inst_35111);

return statearr_35292;
})();
var statearr_35293_35360 = state_35231__$1;
(statearr_35293_35360[(2)] = null);

(statearr_35293_35360[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (14))){
var state_35231__$1 = state_35231;
var statearr_35294_35361 = state_35231__$1;
(statearr_35294_35361[(2)] = null);

(statearr_35294_35361[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (45))){
var inst_35221 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35295_35362 = state_35231__$1;
(statearr_35295_35362[(2)] = inst_35221);

(statearr_35295_35362[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (26))){
var inst_35163 = (state_35231[(29)]);
var inst_35217 = (state_35231[(2)]);
var inst_35218 = cljs.core.seq(inst_35163);
var state_35231__$1 = (function (){var statearr_35296 = state_35231;
(statearr_35296[(31)] = inst_35217);

return statearr_35296;
})();
if(inst_35218){
var statearr_35297_35363 = state_35231__$1;
(statearr_35297_35363[(1)] = (42));

} else {
var statearr_35298_35364 = state_35231__$1;
(statearr_35298_35364[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (16))){
var inst_35130 = (state_35231[(7)]);
var inst_35132 = cljs.core.chunked_seq_QMARK_(inst_35130);
var state_35231__$1 = state_35231;
if(inst_35132){
var statearr_35299_35365 = state_35231__$1;
(statearr_35299_35365[(1)] = (19));

} else {
var statearr_35300_35366 = state_35231__$1;
(statearr_35300_35366[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (38))){
var inst_35210 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35301_35367 = state_35231__$1;
(statearr_35301_35367[(2)] = inst_35210);

(statearr_35301_35367[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (30))){
var state_35231__$1 = state_35231;
var statearr_35302_35368 = state_35231__$1;
(statearr_35302_35368[(2)] = null);

(statearr_35302_35368[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (10))){
var inst_35109 = (state_35231[(13)]);
var inst_35111 = (state_35231[(17)]);
var inst_35119 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_35109,inst_35111);
var inst_35120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35119,(0),null);
var inst_35121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35119,(1),null);
var state_35231__$1 = (function (){var statearr_35303 = state_35231;
(statearr_35303[(26)] = inst_35120);

return statearr_35303;
})();
if(cljs.core.truth_(inst_35121)){
var statearr_35304_35369 = state_35231__$1;
(statearr_35304_35369[(1)] = (13));

} else {
var statearr_35305_35370 = state_35231__$1;
(statearr_35305_35370[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (18))){
var inst_35156 = (state_35231[(2)]);
var state_35231__$1 = state_35231;
var statearr_35306_35371 = state_35231__$1;
(statearr_35306_35371[(2)] = inst_35156);

(statearr_35306_35371[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (42))){
var state_35231__$1 = state_35231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35231__$1,(45),dchan);
} else {
if((state_val_35232 === (37))){
var inst_35190 = (state_35231[(25)]);
var inst_35199 = (state_35231[(23)]);
var inst_35099 = (state_35231[(12)]);
var inst_35199__$1 = cljs.core.first(inst_35190);
var inst_35200 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_35199__$1,inst_35099,done);
var state_35231__$1 = (function (){var statearr_35307 = state_35231;
(statearr_35307[(23)] = inst_35199__$1);

return statearr_35307;
})();
if(cljs.core.truth_(inst_35200)){
var statearr_35308_35372 = state_35231__$1;
(statearr_35308_35372[(1)] = (39));

} else {
var statearr_35309_35373 = state_35231__$1;
(statearr_35309_35373[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35232 === (8))){
var inst_35110 = (state_35231[(16)]);
var inst_35111 = (state_35231[(17)]);
var inst_35113 = (inst_35111 < inst_35110);
var inst_35114 = inst_35113;
var state_35231__$1 = state_35231;
if(cljs.core.truth_(inst_35114)){
var statearr_35310_35374 = state_35231__$1;
(statearr_35310_35374[(1)] = (10));

} else {
var statearr_35311_35375 = state_35231__$1;
(statearr_35311_35375[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___35321,cs,m,dchan,dctr,done))
;
return ((function (switch__19140__auto__,c__19252__auto___35321,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__19141__auto__ = null;
var cljs$core$async$mult_$_state_machine__19141__auto____0 = (function (){
var statearr_35315 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35315[(0)] = cljs$core$async$mult_$_state_machine__19141__auto__);

(statearr_35315[(1)] = (1));

return statearr_35315;
});
var cljs$core$async$mult_$_state_machine__19141__auto____1 = (function (state_35231){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_35231);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e35316){if((e35316 instanceof Object)){
var ex__19144__auto__ = e35316;
var statearr_35317_35376 = state_35231;
(statearr_35317_35376[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35231);

return cljs.core.cst$kw$recur;
} else {
throw e35316;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__35377 = state_35231;
state_35231 = G__35377;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__19141__auto__ = function(state_35231){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__19141__auto____1.call(this,state_35231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__19141__auto____0;
cljs$core$async$mult_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__19141__auto____1;
return cljs$core$async$mult_$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___35321,cs,m,dchan,dctr,done))
})();
var state__19254__auto__ = (function (){var statearr_35318 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_35318[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___35321);

return statearr_35318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___35321,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args35378 = [];
var len__7651__auto___35381 = arguments.length;
var i__7652__auto___35382 = (0);
while(true){
if((i__7652__auto___35382 < len__7651__auto___35381)){
args35378.push((arguments[i__7652__auto___35382]));

var G__35383 = (i__7652__auto___35382 + (1));
i__7652__auto___35382 = G__35383;
continue;
} else {
}
break;
}

var G__35380 = args35378.length;
switch (G__35380) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35378.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto__.call(null,m,state_map));
} else {
var m__7207__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto__.call(null,m,mode));
} else {
var m__7207__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35395 = arguments.length;
var i__7652__auto___35396 = (0);
while(true){
if((i__7652__auto___35396 < len__7651__auto___35395)){
args__7658__auto__.push((arguments[i__7652__auto___35396]));

var G__35397 = (i__7652__auto___35396 + (1));
i__7652__auto___35396 = G__35397;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__35389){
var map__35390 = p__35389;
var map__35390__$1 = ((((!((map__35390 == null)))?((((map__35390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35390.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35390):map__35390);
var opts = map__35390__$1;
var statearr_35392_35398 = state;
(statearr_35392_35398[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__35390,map__35390__$1,opts){
return (function (val){
var statearr_35393_35399 = state;
(statearr_35393_35399[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__35390,map__35390__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_35394_35400 = state;
(statearr_35394_35400[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq35385){
var G__35386 = cljs.core.first(seq35385);
var seq35385__$1 = cljs.core.next(seq35385);
var G__35387 = cljs.core.first(seq35385__$1);
var seq35385__$2 = cljs.core.next(seq35385__$1);
var G__35388 = cljs.core.first(seq35385__$2);
var seq35385__$3 = cljs.core.next(seq35385__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35386,G__35387,G__35388,seq35385__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__35572 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__35572) : cljs.core.atom.call(null,G__35572));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__35573 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__35573) : cljs.core.atom.call(null,G__35573));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async35574 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35574 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta35575){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta35575 = meta35575;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_35576,meta35575__$1){
var self__ = this;
var _35576__$1 = this;
return (new cljs.core.async.t_cljs$core$async35574(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta35575__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_35576){
var self__ = this;
var _35576__$1 = this;
return self__.meta35575;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__35577_35743 = self__.cs;
var G__35578_35744 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__35577_35743,G__35578_35744) : cljs.core.reset_BANG_.call(null,G__35577_35743,G__35578_35744));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta35575], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35574.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35574.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35574";

cljs.core.async.t_cljs$core$async35574.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async35574");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async35574 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async35574(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta35575){
return (new cljs.core.async.t_cljs$core$async35574(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta35575));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async35574(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19252__auto___35745 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___35745,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___35745,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_35680){
var state_val_35681 = (state_35680[(1)]);
if((state_val_35681 === (7))){
var inst_35595 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
var statearr_35682_35746 = state_35680__$1;
(statearr_35682_35746[(2)] = inst_35595);

(statearr_35682_35746[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (20))){
var inst_35607 = (state_35680[(7)]);
var state_35680__$1 = state_35680;
var statearr_35683_35747 = state_35680__$1;
(statearr_35683_35747[(2)] = inst_35607);

(statearr_35683_35747[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (27))){
var state_35680__$1 = state_35680;
var statearr_35684_35748 = state_35680__$1;
(statearr_35684_35748[(2)] = null);

(statearr_35684_35748[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (1))){
var inst_35582 = (state_35680[(8)]);
var inst_35582__$1 = calc_state();
var inst_35584 = (inst_35582__$1 == null);
var inst_35585 = cljs.core.not(inst_35584);
var state_35680__$1 = (function (){var statearr_35685 = state_35680;
(statearr_35685[(8)] = inst_35582__$1);

return statearr_35685;
})();
if(inst_35585){
var statearr_35686_35749 = state_35680__$1;
(statearr_35686_35749[(1)] = (2));

} else {
var statearr_35687_35750 = state_35680__$1;
(statearr_35687_35750[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (24))){
var inst_35654 = (state_35680[(9)]);
var inst_35631 = (state_35680[(10)]);
var inst_35640 = (state_35680[(11)]);
var inst_35654__$1 = (inst_35631.cljs$core$IFn$_invoke$arity$1 ? inst_35631.cljs$core$IFn$_invoke$arity$1(inst_35640) : inst_35631.call(null,inst_35640));
var state_35680__$1 = (function (){var statearr_35688 = state_35680;
(statearr_35688[(9)] = inst_35654__$1);

return statearr_35688;
})();
if(cljs.core.truth_(inst_35654__$1)){
var statearr_35689_35751 = state_35680__$1;
(statearr_35689_35751[(1)] = (29));

} else {
var statearr_35690_35752 = state_35680__$1;
(statearr_35690_35752[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (4))){
var inst_35598 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
if(cljs.core.truth_(inst_35598)){
var statearr_35691_35753 = state_35680__$1;
(statearr_35691_35753[(1)] = (8));

} else {
var statearr_35692_35754 = state_35680__$1;
(statearr_35692_35754[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (15))){
var inst_35625 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
if(cljs.core.truth_(inst_35625)){
var statearr_35693_35755 = state_35680__$1;
(statearr_35693_35755[(1)] = (19));

} else {
var statearr_35694_35756 = state_35680__$1;
(statearr_35694_35756[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (21))){
var inst_35630 = (state_35680[(12)]);
var inst_35630__$1 = (state_35680[(2)]);
var inst_35631 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35630__$1,cljs.core.cst$kw$solos);
var inst_35632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35630__$1,cljs.core.cst$kw$mutes);
var inst_35633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35630__$1,cljs.core.cst$kw$reads);
var state_35680__$1 = (function (){var statearr_35695 = state_35680;
(statearr_35695[(12)] = inst_35630__$1);

(statearr_35695[(10)] = inst_35631);

(statearr_35695[(13)] = inst_35632);

return statearr_35695;
})();
return cljs.core.async.ioc_alts_BANG_(state_35680__$1,(22),inst_35633);
} else {
if((state_val_35681 === (31))){
var inst_35662 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
if(cljs.core.truth_(inst_35662)){
var statearr_35696_35757 = state_35680__$1;
(statearr_35696_35757[(1)] = (32));

} else {
var statearr_35697_35758 = state_35680__$1;
(statearr_35697_35758[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (32))){
var inst_35639 = (state_35680[(14)]);
var state_35680__$1 = state_35680;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35680__$1,(35),out,inst_35639);
} else {
if((state_val_35681 === (33))){
var inst_35630 = (state_35680[(12)]);
var inst_35607 = inst_35630;
var state_35680__$1 = (function (){var statearr_35698 = state_35680;
(statearr_35698[(7)] = inst_35607);

return statearr_35698;
})();
var statearr_35699_35759 = state_35680__$1;
(statearr_35699_35759[(2)] = null);

(statearr_35699_35759[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (13))){
var inst_35607 = (state_35680[(7)]);
var inst_35614 = inst_35607.cljs$lang$protocol_mask$partition0$;
var inst_35615 = (inst_35614 & (64));
var inst_35616 = inst_35607.cljs$core$ISeq$;
var inst_35617 = (cljs.core.PROTOCOL_SENTINEL === inst_35616);
var inst_35618 = (inst_35615) || (inst_35617);
var state_35680__$1 = state_35680;
if(cljs.core.truth_(inst_35618)){
var statearr_35700_35760 = state_35680__$1;
(statearr_35700_35760[(1)] = (16));

} else {
var statearr_35701_35761 = state_35680__$1;
(statearr_35701_35761[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (22))){
var inst_35639 = (state_35680[(14)]);
var inst_35640 = (state_35680[(11)]);
var inst_35638 = (state_35680[(2)]);
var inst_35639__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35638,(0),null);
var inst_35640__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35638,(1),null);
var inst_35641 = (inst_35639__$1 == null);
var inst_35642 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35640__$1,change);
var inst_35643 = (inst_35641) || (inst_35642);
var state_35680__$1 = (function (){var statearr_35702 = state_35680;
(statearr_35702[(14)] = inst_35639__$1);

(statearr_35702[(11)] = inst_35640__$1);

return statearr_35702;
})();
if(cljs.core.truth_(inst_35643)){
var statearr_35703_35762 = state_35680__$1;
(statearr_35703_35762[(1)] = (23));

} else {
var statearr_35704_35763 = state_35680__$1;
(statearr_35704_35763[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (36))){
var inst_35630 = (state_35680[(12)]);
var inst_35607 = inst_35630;
var state_35680__$1 = (function (){var statearr_35705 = state_35680;
(statearr_35705[(7)] = inst_35607);

return statearr_35705;
})();
var statearr_35706_35764 = state_35680__$1;
(statearr_35706_35764[(2)] = null);

(statearr_35706_35764[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (29))){
var inst_35654 = (state_35680[(9)]);
var state_35680__$1 = state_35680;
var statearr_35707_35765 = state_35680__$1;
(statearr_35707_35765[(2)] = inst_35654);

(statearr_35707_35765[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (6))){
var state_35680__$1 = state_35680;
var statearr_35708_35766 = state_35680__$1;
(statearr_35708_35766[(2)] = false);

(statearr_35708_35766[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (28))){
var inst_35650 = (state_35680[(2)]);
var inst_35651 = calc_state();
var inst_35607 = inst_35651;
var state_35680__$1 = (function (){var statearr_35709 = state_35680;
(statearr_35709[(15)] = inst_35650);

(statearr_35709[(7)] = inst_35607);

return statearr_35709;
})();
var statearr_35710_35767 = state_35680__$1;
(statearr_35710_35767[(2)] = null);

(statearr_35710_35767[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (25))){
var inst_35676 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
var statearr_35711_35768 = state_35680__$1;
(statearr_35711_35768[(2)] = inst_35676);

(statearr_35711_35768[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (34))){
var inst_35674 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
var statearr_35712_35769 = state_35680__$1;
(statearr_35712_35769[(2)] = inst_35674);

(statearr_35712_35769[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (17))){
var state_35680__$1 = state_35680;
var statearr_35713_35770 = state_35680__$1;
(statearr_35713_35770[(2)] = false);

(statearr_35713_35770[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (3))){
var state_35680__$1 = state_35680;
var statearr_35714_35771 = state_35680__$1;
(statearr_35714_35771[(2)] = false);

(statearr_35714_35771[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (12))){
var inst_35678 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35680__$1,inst_35678);
} else {
if((state_val_35681 === (2))){
var inst_35582 = (state_35680[(8)]);
var inst_35587 = inst_35582.cljs$lang$protocol_mask$partition0$;
var inst_35588 = (inst_35587 & (64));
var inst_35589 = inst_35582.cljs$core$ISeq$;
var inst_35590 = (cljs.core.PROTOCOL_SENTINEL === inst_35589);
var inst_35591 = (inst_35588) || (inst_35590);
var state_35680__$1 = state_35680;
if(cljs.core.truth_(inst_35591)){
var statearr_35715_35772 = state_35680__$1;
(statearr_35715_35772[(1)] = (5));

} else {
var statearr_35716_35773 = state_35680__$1;
(statearr_35716_35773[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (23))){
var inst_35639 = (state_35680[(14)]);
var inst_35645 = (inst_35639 == null);
var state_35680__$1 = state_35680;
if(cljs.core.truth_(inst_35645)){
var statearr_35717_35774 = state_35680__$1;
(statearr_35717_35774[(1)] = (26));

} else {
var statearr_35718_35775 = state_35680__$1;
(statearr_35718_35775[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (35))){
var inst_35665 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
if(cljs.core.truth_(inst_35665)){
var statearr_35719_35776 = state_35680__$1;
(statearr_35719_35776[(1)] = (36));

} else {
var statearr_35720_35777 = state_35680__$1;
(statearr_35720_35777[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (19))){
var inst_35607 = (state_35680[(7)]);
var inst_35627 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35607);
var state_35680__$1 = state_35680;
var statearr_35721_35778 = state_35680__$1;
(statearr_35721_35778[(2)] = inst_35627);

(statearr_35721_35778[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (11))){
var inst_35607 = (state_35680[(7)]);
var inst_35611 = (inst_35607 == null);
var inst_35612 = cljs.core.not(inst_35611);
var state_35680__$1 = state_35680;
if(inst_35612){
var statearr_35722_35779 = state_35680__$1;
(statearr_35722_35779[(1)] = (13));

} else {
var statearr_35723_35780 = state_35680__$1;
(statearr_35723_35780[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (9))){
var inst_35582 = (state_35680[(8)]);
var state_35680__$1 = state_35680;
var statearr_35724_35781 = state_35680__$1;
(statearr_35724_35781[(2)] = inst_35582);

(statearr_35724_35781[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (5))){
var state_35680__$1 = state_35680;
var statearr_35725_35782 = state_35680__$1;
(statearr_35725_35782[(2)] = true);

(statearr_35725_35782[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (14))){
var state_35680__$1 = state_35680;
var statearr_35726_35783 = state_35680__$1;
(statearr_35726_35783[(2)] = false);

(statearr_35726_35783[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (26))){
var inst_35640 = (state_35680[(11)]);
var inst_35647 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_35640);
var state_35680__$1 = state_35680;
var statearr_35727_35784 = state_35680__$1;
(statearr_35727_35784[(2)] = inst_35647);

(statearr_35727_35784[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (16))){
var state_35680__$1 = state_35680;
var statearr_35728_35785 = state_35680__$1;
(statearr_35728_35785[(2)] = true);

(statearr_35728_35785[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (38))){
var inst_35670 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
var statearr_35729_35786 = state_35680__$1;
(statearr_35729_35786[(2)] = inst_35670);

(statearr_35729_35786[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (30))){
var inst_35631 = (state_35680[(10)]);
var inst_35640 = (state_35680[(11)]);
var inst_35632 = (state_35680[(13)]);
var inst_35657 = cljs.core.empty_QMARK_(inst_35631);
var inst_35658 = (inst_35632.cljs$core$IFn$_invoke$arity$1 ? inst_35632.cljs$core$IFn$_invoke$arity$1(inst_35640) : inst_35632.call(null,inst_35640));
var inst_35659 = cljs.core.not(inst_35658);
var inst_35660 = (inst_35657) && (inst_35659);
var state_35680__$1 = state_35680;
var statearr_35730_35787 = state_35680__$1;
(statearr_35730_35787[(2)] = inst_35660);

(statearr_35730_35787[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (10))){
var inst_35582 = (state_35680[(8)]);
var inst_35603 = (state_35680[(2)]);
var inst_35604 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35603,cljs.core.cst$kw$solos);
var inst_35605 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35603,cljs.core.cst$kw$mutes);
var inst_35606 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35603,cljs.core.cst$kw$reads);
var inst_35607 = inst_35582;
var state_35680__$1 = (function (){var statearr_35731 = state_35680;
(statearr_35731[(16)] = inst_35605);

(statearr_35731[(17)] = inst_35606);

(statearr_35731[(18)] = inst_35604);

(statearr_35731[(7)] = inst_35607);

return statearr_35731;
})();
var statearr_35732_35788 = state_35680__$1;
(statearr_35732_35788[(2)] = null);

(statearr_35732_35788[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (18))){
var inst_35622 = (state_35680[(2)]);
var state_35680__$1 = state_35680;
var statearr_35733_35789 = state_35680__$1;
(statearr_35733_35789[(2)] = inst_35622);

(statearr_35733_35789[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (37))){
var state_35680__$1 = state_35680;
var statearr_35734_35790 = state_35680__$1;
(statearr_35734_35790[(2)] = null);

(statearr_35734_35790[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35681 === (8))){
var inst_35582 = (state_35680[(8)]);
var inst_35600 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35582);
var state_35680__$1 = state_35680;
var statearr_35735_35791 = state_35680__$1;
(statearr_35735_35791[(2)] = inst_35600);

(statearr_35735_35791[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___35745,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__19140__auto__,c__19252__auto___35745,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__19141__auto__ = null;
var cljs$core$async$mix_$_state_machine__19141__auto____0 = (function (){
var statearr_35739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35739[(0)] = cljs$core$async$mix_$_state_machine__19141__auto__);

(statearr_35739[(1)] = (1));

return statearr_35739;
});
var cljs$core$async$mix_$_state_machine__19141__auto____1 = (function (state_35680){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_35680);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e35740){if((e35740 instanceof Object)){
var ex__19144__auto__ = e35740;
var statearr_35741_35792 = state_35680;
(statearr_35741_35792[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35680);

return cljs.core.cst$kw$recur;
} else {
throw e35740;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__35793 = state_35680;
state_35680 = G__35793;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__19141__auto__ = function(state_35680){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__19141__auto____1.call(this,state_35680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__19141__auto____0;
cljs$core$async$mix_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__19141__auto____1;
return cljs$core$async$mix_$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___35745,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__19254__auto__ = (function (){var statearr_35742 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_35742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___35745);

return statearr_35742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___35745,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto__.call(null,p,v,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args35794 = [];
var len__7651__auto___35797 = arguments.length;
var i__7652__auto___35798 = (0);
while(true){
if((i__7652__auto___35798 < len__7651__auto___35797)){
args35794.push((arguments[i__7652__auto___35798]));

var G__35799 = (i__7652__auto___35798 + (1));
i__7652__auto___35798 = G__35799;
continue;
} else {
}
break;
}

var G__35796 = args35794.length;
switch (G__35796) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35794.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto__.call(null,p));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto__.call(null,p,v));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args35802 = [];
var len__7651__auto___35930 = arguments.length;
var i__7652__auto___35931 = (0);
while(true){
if((i__7652__auto___35931 < len__7651__auto___35930)){
args35802.push((arguments[i__7652__auto___35931]));

var G__35932 = (i__7652__auto___35931 + (1));
i__7652__auto___35931 = G__35932;
continue;
} else {
}
break;
}

var G__35804 = args35802.length;
switch (G__35804) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35802.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__35805 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__35805) : cljs.core.atom.call(null,G__35805));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6543__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6543__auto__,mults){
return (function (p1__35801_SHARP_){
if(cljs.core.truth_((p1__35801_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__35801_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__35801_SHARP_.call(null,topic)))){
return p1__35801_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__35801_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6543__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async35806 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35806 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta35807){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta35807 = meta35807;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_35808,meta35807__$1){
var self__ = this;
var _35808__$1 = this;
return (new cljs.core.async.t_cljs$core$async35806(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta35807__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_35808){
var self__ = this;
var _35808__$1 = this;
return self__.meta35807;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__35809 = self__.mults;
var G__35810 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__35809,G__35810) : cljs.core.reset_BANG_.call(null,G__35809,G__35810));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35806.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35806.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta35807], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35806.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35806.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35806";

cljs.core.async.t_cljs$core$async35806.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async35806");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async35806 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async35806(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta35807){
return (new cljs.core.async.t_cljs$core$async35806(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta35807));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async35806(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19252__auto___35934 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___35934,mults,ensure_mult,p){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___35934,mults,ensure_mult,p){
return (function (state_35882){
var state_val_35883 = (state_35882[(1)]);
if((state_val_35883 === (7))){
var inst_35878 = (state_35882[(2)]);
var state_35882__$1 = state_35882;
var statearr_35884_35935 = state_35882__$1;
(statearr_35884_35935[(2)] = inst_35878);

(statearr_35884_35935[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (20))){
var state_35882__$1 = state_35882;
var statearr_35885_35936 = state_35882__$1;
(statearr_35885_35936[(2)] = null);

(statearr_35885_35936[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (1))){
var state_35882__$1 = state_35882;
var statearr_35886_35937 = state_35882__$1;
(statearr_35886_35937[(2)] = null);

(statearr_35886_35937[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (24))){
var inst_35861 = (state_35882[(7)]);
var inst_35870 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_35861);
var state_35882__$1 = state_35882;
var statearr_35887_35938 = state_35882__$1;
(statearr_35887_35938[(2)] = inst_35870);

(statearr_35887_35938[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (4))){
var inst_35813 = (state_35882[(8)]);
var inst_35813__$1 = (state_35882[(2)]);
var inst_35814 = (inst_35813__$1 == null);
var state_35882__$1 = (function (){var statearr_35888 = state_35882;
(statearr_35888[(8)] = inst_35813__$1);

return statearr_35888;
})();
if(cljs.core.truth_(inst_35814)){
var statearr_35889_35939 = state_35882__$1;
(statearr_35889_35939[(1)] = (5));

} else {
var statearr_35890_35940 = state_35882__$1;
(statearr_35890_35940[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (15))){
var inst_35855 = (state_35882[(2)]);
var state_35882__$1 = state_35882;
var statearr_35891_35941 = state_35882__$1;
(statearr_35891_35941[(2)] = inst_35855);

(statearr_35891_35941[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (21))){
var inst_35875 = (state_35882[(2)]);
var state_35882__$1 = (function (){var statearr_35892 = state_35882;
(statearr_35892[(9)] = inst_35875);

return statearr_35892;
})();
var statearr_35893_35942 = state_35882__$1;
(statearr_35893_35942[(2)] = null);

(statearr_35893_35942[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (13))){
var inst_35837 = (state_35882[(10)]);
var inst_35839 = cljs.core.chunked_seq_QMARK_(inst_35837);
var state_35882__$1 = state_35882;
if(inst_35839){
var statearr_35894_35943 = state_35882__$1;
(statearr_35894_35943[(1)] = (16));

} else {
var statearr_35895_35944 = state_35882__$1;
(statearr_35895_35944[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (22))){
var inst_35867 = (state_35882[(2)]);
var state_35882__$1 = state_35882;
if(cljs.core.truth_(inst_35867)){
var statearr_35896_35945 = state_35882__$1;
(statearr_35896_35945[(1)] = (23));

} else {
var statearr_35897_35946 = state_35882__$1;
(statearr_35897_35946[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (6))){
var inst_35813 = (state_35882[(8)]);
var inst_35861 = (state_35882[(7)]);
var inst_35863 = (state_35882[(11)]);
var inst_35861__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_35813) : topic_fn.call(null,inst_35813));
var inst_35862 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_35863__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35862,inst_35861__$1);
var state_35882__$1 = (function (){var statearr_35898 = state_35882;
(statearr_35898[(7)] = inst_35861__$1);

(statearr_35898[(11)] = inst_35863__$1);

return statearr_35898;
})();
if(cljs.core.truth_(inst_35863__$1)){
var statearr_35899_35947 = state_35882__$1;
(statearr_35899_35947[(1)] = (19));

} else {
var statearr_35900_35948 = state_35882__$1;
(statearr_35900_35948[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (25))){
var inst_35872 = (state_35882[(2)]);
var state_35882__$1 = state_35882;
var statearr_35901_35949 = state_35882__$1;
(statearr_35901_35949[(2)] = inst_35872);

(statearr_35901_35949[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (17))){
var inst_35837 = (state_35882[(10)]);
var inst_35846 = cljs.core.first(inst_35837);
var inst_35847 = cljs.core.async.muxch_STAR_(inst_35846);
var inst_35848 = cljs.core.async.close_BANG_(inst_35847);
var inst_35849 = cljs.core.next(inst_35837);
var inst_35823 = inst_35849;
var inst_35824 = null;
var inst_35825 = (0);
var inst_35826 = (0);
var state_35882__$1 = (function (){var statearr_35902 = state_35882;
(statearr_35902[(12)] = inst_35823);

(statearr_35902[(13)] = inst_35826);

(statearr_35902[(14)] = inst_35825);

(statearr_35902[(15)] = inst_35824);

(statearr_35902[(16)] = inst_35848);

return statearr_35902;
})();
var statearr_35903_35950 = state_35882__$1;
(statearr_35903_35950[(2)] = null);

(statearr_35903_35950[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (3))){
var inst_35880 = (state_35882[(2)]);
var state_35882__$1 = state_35882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35882__$1,inst_35880);
} else {
if((state_val_35883 === (12))){
var inst_35857 = (state_35882[(2)]);
var state_35882__$1 = state_35882;
var statearr_35904_35951 = state_35882__$1;
(statearr_35904_35951[(2)] = inst_35857);

(statearr_35904_35951[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (2))){
var state_35882__$1 = state_35882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35882__$1,(4),ch);
} else {
if((state_val_35883 === (23))){
var state_35882__$1 = state_35882;
var statearr_35905_35952 = state_35882__$1;
(statearr_35905_35952[(2)] = null);

(statearr_35905_35952[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (19))){
var inst_35813 = (state_35882[(8)]);
var inst_35863 = (state_35882[(11)]);
var inst_35865 = cljs.core.async.muxch_STAR_(inst_35863);
var state_35882__$1 = state_35882;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35882__$1,(22),inst_35865,inst_35813);
} else {
if((state_val_35883 === (11))){
var inst_35823 = (state_35882[(12)]);
var inst_35837 = (state_35882[(10)]);
var inst_35837__$1 = cljs.core.seq(inst_35823);
var state_35882__$1 = (function (){var statearr_35906 = state_35882;
(statearr_35906[(10)] = inst_35837__$1);

return statearr_35906;
})();
if(inst_35837__$1){
var statearr_35907_35953 = state_35882__$1;
(statearr_35907_35953[(1)] = (13));

} else {
var statearr_35908_35954 = state_35882__$1;
(statearr_35908_35954[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (9))){
var inst_35859 = (state_35882[(2)]);
var state_35882__$1 = state_35882;
var statearr_35909_35955 = state_35882__$1;
(statearr_35909_35955[(2)] = inst_35859);

(statearr_35909_35955[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (5))){
var inst_35820 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_35821 = cljs.core.vals(inst_35820);
var inst_35822 = cljs.core.seq(inst_35821);
var inst_35823 = inst_35822;
var inst_35824 = null;
var inst_35825 = (0);
var inst_35826 = (0);
var state_35882__$1 = (function (){var statearr_35910 = state_35882;
(statearr_35910[(12)] = inst_35823);

(statearr_35910[(13)] = inst_35826);

(statearr_35910[(14)] = inst_35825);

(statearr_35910[(15)] = inst_35824);

return statearr_35910;
})();
var statearr_35911_35956 = state_35882__$1;
(statearr_35911_35956[(2)] = null);

(statearr_35911_35956[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (14))){
var state_35882__$1 = state_35882;
var statearr_35915_35957 = state_35882__$1;
(statearr_35915_35957[(2)] = null);

(statearr_35915_35957[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (16))){
var inst_35837 = (state_35882[(10)]);
var inst_35841 = cljs.core.chunk_first(inst_35837);
var inst_35842 = cljs.core.chunk_rest(inst_35837);
var inst_35843 = cljs.core.count(inst_35841);
var inst_35823 = inst_35842;
var inst_35824 = inst_35841;
var inst_35825 = inst_35843;
var inst_35826 = (0);
var state_35882__$1 = (function (){var statearr_35916 = state_35882;
(statearr_35916[(12)] = inst_35823);

(statearr_35916[(13)] = inst_35826);

(statearr_35916[(14)] = inst_35825);

(statearr_35916[(15)] = inst_35824);

return statearr_35916;
})();
var statearr_35917_35958 = state_35882__$1;
(statearr_35917_35958[(2)] = null);

(statearr_35917_35958[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (10))){
var inst_35823 = (state_35882[(12)]);
var inst_35826 = (state_35882[(13)]);
var inst_35825 = (state_35882[(14)]);
var inst_35824 = (state_35882[(15)]);
var inst_35831 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_35824,inst_35826);
var inst_35832 = cljs.core.async.muxch_STAR_(inst_35831);
var inst_35833 = cljs.core.async.close_BANG_(inst_35832);
var inst_35834 = (inst_35826 + (1));
var tmp35912 = inst_35823;
var tmp35913 = inst_35825;
var tmp35914 = inst_35824;
var inst_35823__$1 = tmp35912;
var inst_35824__$1 = tmp35914;
var inst_35825__$1 = tmp35913;
var inst_35826__$1 = inst_35834;
var state_35882__$1 = (function (){var statearr_35918 = state_35882;
(statearr_35918[(12)] = inst_35823__$1);

(statearr_35918[(13)] = inst_35826__$1);

(statearr_35918[(14)] = inst_35825__$1);

(statearr_35918[(17)] = inst_35833);

(statearr_35918[(15)] = inst_35824__$1);

return statearr_35918;
})();
var statearr_35919_35959 = state_35882__$1;
(statearr_35919_35959[(2)] = null);

(statearr_35919_35959[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (18))){
var inst_35852 = (state_35882[(2)]);
var state_35882__$1 = state_35882;
var statearr_35920_35960 = state_35882__$1;
(statearr_35920_35960[(2)] = inst_35852);

(statearr_35920_35960[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35883 === (8))){
var inst_35826 = (state_35882[(13)]);
var inst_35825 = (state_35882[(14)]);
var inst_35828 = (inst_35826 < inst_35825);
var inst_35829 = inst_35828;
var state_35882__$1 = state_35882;
if(cljs.core.truth_(inst_35829)){
var statearr_35921_35961 = state_35882__$1;
(statearr_35921_35961[(1)] = (10));

} else {
var statearr_35922_35962 = state_35882__$1;
(statearr_35922_35962[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___35934,mults,ensure_mult,p))
;
return ((function (switch__19140__auto__,c__19252__auto___35934,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_35926 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35926[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_35926[(1)] = (1));

return statearr_35926;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_35882){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_35882);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e35927){if((e35927 instanceof Object)){
var ex__19144__auto__ = e35927;
var statearr_35928_35963 = state_35882;
(statearr_35928_35963[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35882);

return cljs.core.cst$kw$recur;
} else {
throw e35927;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__35964 = state_35882;
state_35882 = G__35964;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_35882){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_35882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___35934,mults,ensure_mult,p))
})();
var state__19254__auto__ = (function (){var statearr_35929 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_35929[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___35934);

return statearr_35929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___35934,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args35965 = [];
var len__7651__auto___35968 = arguments.length;
var i__7652__auto___35969 = (0);
while(true){
if((i__7652__auto___35969 < len__7651__auto___35968)){
args35965.push((arguments[i__7652__auto___35969]));

var G__35970 = (i__7652__auto___35969 + (1));
i__7652__auto___35969 = G__35970;
continue;
} else {
}
break;
}

var G__35967 = args35965.length;
switch (G__35967) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35965.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args35972 = [];
var len__7651__auto___35975 = arguments.length;
var i__7652__auto___35976 = (0);
while(true){
if((i__7652__auto___35976 < len__7651__auto___35975)){
args35972.push((arguments[i__7652__auto___35976]));

var G__35977 = (i__7652__auto___35976 + (1));
i__7652__auto___35976 = G__35977;
continue;
} else {
}
break;
}

var G__35974 = args35972.length;
switch (G__35974) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35972.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args35979 = [];
var len__7651__auto___36050 = arguments.length;
var i__7652__auto___36051 = (0);
while(true){
if((i__7652__auto___36051 < len__7651__auto___36050)){
args35979.push((arguments[i__7652__auto___36051]));

var G__36052 = (i__7652__auto___36051 + (1));
i__7652__auto___36051 = G__36052;
continue;
} else {
}
break;
}

var G__35981 = args35979.length;
switch (G__35981) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35979.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__19252__auto___36054 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36054,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36054,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_36020){
var state_val_36021 = (state_36020[(1)]);
if((state_val_36021 === (7))){
var state_36020__$1 = state_36020;
var statearr_36022_36055 = state_36020__$1;
(statearr_36022_36055[(2)] = null);

(statearr_36022_36055[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (1))){
var state_36020__$1 = state_36020;
var statearr_36023_36056 = state_36020__$1;
(statearr_36023_36056[(2)] = null);

(statearr_36023_36056[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (4))){
var inst_35984 = (state_36020[(7)]);
var inst_35986 = (inst_35984 < cnt);
var state_36020__$1 = state_36020;
if(cljs.core.truth_(inst_35986)){
var statearr_36024_36057 = state_36020__$1;
(statearr_36024_36057[(1)] = (6));

} else {
var statearr_36025_36058 = state_36020__$1;
(statearr_36025_36058[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (15))){
var inst_36016 = (state_36020[(2)]);
var state_36020__$1 = state_36020;
var statearr_36026_36059 = state_36020__$1;
(statearr_36026_36059[(2)] = inst_36016);

(statearr_36026_36059[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (13))){
var inst_36009 = cljs.core.async.close_BANG_(out);
var state_36020__$1 = state_36020;
var statearr_36027_36060 = state_36020__$1;
(statearr_36027_36060[(2)] = inst_36009);

(statearr_36027_36060[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (6))){
var state_36020__$1 = state_36020;
var statearr_36028_36061 = state_36020__$1;
(statearr_36028_36061[(2)] = null);

(statearr_36028_36061[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (3))){
var inst_36018 = (state_36020[(2)]);
var state_36020__$1 = state_36020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36020__$1,inst_36018);
} else {
if((state_val_36021 === (12))){
var inst_36006 = (state_36020[(8)]);
var inst_36006__$1 = (state_36020[(2)]);
var inst_36007 = cljs.core.some(cljs.core.nil_QMARK_,inst_36006__$1);
var state_36020__$1 = (function (){var statearr_36029 = state_36020;
(statearr_36029[(8)] = inst_36006__$1);

return statearr_36029;
})();
if(cljs.core.truth_(inst_36007)){
var statearr_36030_36062 = state_36020__$1;
(statearr_36030_36062[(1)] = (13));

} else {
var statearr_36031_36063 = state_36020__$1;
(statearr_36031_36063[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (2))){
var inst_35983 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_35984 = (0);
var state_36020__$1 = (function (){var statearr_36032 = state_36020;
(statearr_36032[(7)] = inst_35984);

(statearr_36032[(9)] = inst_35983);

return statearr_36032;
})();
var statearr_36033_36064 = state_36020__$1;
(statearr_36033_36064[(2)] = null);

(statearr_36033_36064[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (11))){
var inst_35984 = (state_36020[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_36020,(10),Object,null,(9));
var inst_35993 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_35984) : chs__$1.call(null,inst_35984));
var inst_35994 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_35984) : done.call(null,inst_35984));
var inst_35995 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35993,inst_35994);
var state_36020__$1 = state_36020;
var statearr_36034_36065 = state_36020__$1;
(statearr_36034_36065[(2)] = inst_35995);


cljs.core.async.impl.ioc_helpers.process_exception(state_36020__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (9))){
var inst_35984 = (state_36020[(7)]);
var inst_35997 = (state_36020[(2)]);
var inst_35998 = (inst_35984 + (1));
var inst_35984__$1 = inst_35998;
var state_36020__$1 = (function (){var statearr_36035 = state_36020;
(statearr_36035[(7)] = inst_35984__$1);

(statearr_36035[(10)] = inst_35997);

return statearr_36035;
})();
var statearr_36036_36066 = state_36020__$1;
(statearr_36036_36066[(2)] = null);

(statearr_36036_36066[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (5))){
var inst_36004 = (state_36020[(2)]);
var state_36020__$1 = (function (){var statearr_36037 = state_36020;
(statearr_36037[(11)] = inst_36004);

return statearr_36037;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36020__$1,(12),dchan);
} else {
if((state_val_36021 === (14))){
var inst_36006 = (state_36020[(8)]);
var inst_36011 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_36006);
var state_36020__$1 = state_36020;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36020__$1,(16),out,inst_36011);
} else {
if((state_val_36021 === (16))){
var inst_36013 = (state_36020[(2)]);
var state_36020__$1 = (function (){var statearr_36038 = state_36020;
(statearr_36038[(12)] = inst_36013);

return statearr_36038;
})();
var statearr_36039_36067 = state_36020__$1;
(statearr_36039_36067[(2)] = null);

(statearr_36039_36067[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (10))){
var inst_35988 = (state_36020[(2)]);
var inst_35989 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_36020__$1 = (function (){var statearr_36040 = state_36020;
(statearr_36040[(13)] = inst_35988);

return statearr_36040;
})();
var statearr_36041_36068 = state_36020__$1;
(statearr_36041_36068[(2)] = inst_35989);


cljs.core.async.impl.ioc_helpers.process_exception(state_36020__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_36021 === (8))){
var inst_36002 = (state_36020[(2)]);
var state_36020__$1 = state_36020;
var statearr_36042_36069 = state_36020__$1;
(statearr_36042_36069[(2)] = inst_36002);

(statearr_36042_36069[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___36054,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__19140__auto__,c__19252__auto___36054,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_36046 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36046[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_36046[(1)] = (1));

return statearr_36046;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_36020){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36020);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36047){if((e36047 instanceof Object)){
var ex__19144__auto__ = e36047;
var statearr_36048_36070 = state_36020;
(statearr_36048_36070[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36020);

return cljs.core.cst$kw$recur;
} else {
throw e36047;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36071 = state_36020;
state_36020 = G__36071;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_36020){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_36020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36054,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__19254__auto__ = (function (){var statearr_36049 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36049[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36054);

return statearr_36049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36054,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args36073 = [];
var len__7651__auto___36131 = arguments.length;
var i__7652__auto___36132 = (0);
while(true){
if((i__7652__auto___36132 < len__7651__auto___36131)){
args36073.push((arguments[i__7652__auto___36132]));

var G__36133 = (i__7652__auto___36132 + (1));
i__7652__auto___36132 = G__36133;
continue;
} else {
}
break;
}

var G__36075 = args36073.length;
switch (G__36075) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36073.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19252__auto___36135 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36135,out){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36135,out){
return (function (state_36107){
var state_val_36108 = (state_36107[(1)]);
if((state_val_36108 === (7))){
var inst_36086 = (state_36107[(7)]);
var inst_36087 = (state_36107[(8)]);
var inst_36086__$1 = (state_36107[(2)]);
var inst_36087__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36086__$1,(0),null);
var inst_36088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36086__$1,(1),null);
var inst_36089 = (inst_36087__$1 == null);
var state_36107__$1 = (function (){var statearr_36109 = state_36107;
(statearr_36109[(7)] = inst_36086__$1);

(statearr_36109[(8)] = inst_36087__$1);

(statearr_36109[(9)] = inst_36088);

return statearr_36109;
})();
if(cljs.core.truth_(inst_36089)){
var statearr_36110_36136 = state_36107__$1;
(statearr_36110_36136[(1)] = (8));

} else {
var statearr_36111_36137 = state_36107__$1;
(statearr_36111_36137[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36108 === (1))){
var inst_36076 = cljs.core.vec(chs);
var inst_36077 = inst_36076;
var state_36107__$1 = (function (){var statearr_36112 = state_36107;
(statearr_36112[(10)] = inst_36077);

return statearr_36112;
})();
var statearr_36113_36138 = state_36107__$1;
(statearr_36113_36138[(2)] = null);

(statearr_36113_36138[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36108 === (4))){
var inst_36077 = (state_36107[(10)]);
var state_36107__$1 = state_36107;
return cljs.core.async.ioc_alts_BANG_(state_36107__$1,(7),inst_36077);
} else {
if((state_val_36108 === (6))){
var inst_36103 = (state_36107[(2)]);
var state_36107__$1 = state_36107;
var statearr_36114_36139 = state_36107__$1;
(statearr_36114_36139[(2)] = inst_36103);

(statearr_36114_36139[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36108 === (3))){
var inst_36105 = (state_36107[(2)]);
var state_36107__$1 = state_36107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36107__$1,inst_36105);
} else {
if((state_val_36108 === (2))){
var inst_36077 = (state_36107[(10)]);
var inst_36079 = cljs.core.count(inst_36077);
var inst_36080 = (inst_36079 > (0));
var state_36107__$1 = state_36107;
if(cljs.core.truth_(inst_36080)){
var statearr_36116_36140 = state_36107__$1;
(statearr_36116_36140[(1)] = (4));

} else {
var statearr_36117_36141 = state_36107__$1;
(statearr_36117_36141[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36108 === (11))){
var inst_36077 = (state_36107[(10)]);
var inst_36096 = (state_36107[(2)]);
var tmp36115 = inst_36077;
var inst_36077__$1 = tmp36115;
var state_36107__$1 = (function (){var statearr_36118 = state_36107;
(statearr_36118[(10)] = inst_36077__$1);

(statearr_36118[(11)] = inst_36096);

return statearr_36118;
})();
var statearr_36119_36142 = state_36107__$1;
(statearr_36119_36142[(2)] = null);

(statearr_36119_36142[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36108 === (9))){
var inst_36087 = (state_36107[(8)]);
var state_36107__$1 = state_36107;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36107__$1,(11),out,inst_36087);
} else {
if((state_val_36108 === (5))){
var inst_36101 = cljs.core.async.close_BANG_(out);
var state_36107__$1 = state_36107;
var statearr_36120_36143 = state_36107__$1;
(statearr_36120_36143[(2)] = inst_36101);

(statearr_36120_36143[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36108 === (10))){
var inst_36099 = (state_36107[(2)]);
var state_36107__$1 = state_36107;
var statearr_36121_36144 = state_36107__$1;
(statearr_36121_36144[(2)] = inst_36099);

(statearr_36121_36144[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36108 === (8))){
var inst_36086 = (state_36107[(7)]);
var inst_36087 = (state_36107[(8)]);
var inst_36077 = (state_36107[(10)]);
var inst_36088 = (state_36107[(9)]);
var inst_36091 = (function (){var cs = inst_36077;
var vec__36082 = inst_36086;
var v = inst_36087;
var c = inst_36088;
return ((function (cs,vec__36082,v,c,inst_36086,inst_36087,inst_36077,inst_36088,state_val_36108,c__19252__auto___36135,out){
return (function (p1__36072_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__36072_SHARP_);
});
;})(cs,vec__36082,v,c,inst_36086,inst_36087,inst_36077,inst_36088,state_val_36108,c__19252__auto___36135,out))
})();
var inst_36092 = cljs.core.filterv(inst_36091,inst_36077);
var inst_36077__$1 = inst_36092;
var state_36107__$1 = (function (){var statearr_36122 = state_36107;
(statearr_36122[(10)] = inst_36077__$1);

return statearr_36122;
})();
var statearr_36123_36145 = state_36107__$1;
(statearr_36123_36145[(2)] = null);

(statearr_36123_36145[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___36135,out))
;
return ((function (switch__19140__auto__,c__19252__auto___36135,out){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_36127 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36127[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_36127[(1)] = (1));

return statearr_36127;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_36107){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36107);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36128){if((e36128 instanceof Object)){
var ex__19144__auto__ = e36128;
var statearr_36129_36146 = state_36107;
(statearr_36129_36146[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36107);

return cljs.core.cst$kw$recur;
} else {
throw e36128;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36147 = state_36107;
state_36107 = G__36147;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_36107){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_36107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36135,out))
})();
var state__19254__auto__ = (function (){var statearr_36130 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36130[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36135);

return statearr_36130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36135,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args36148 = [];
var len__7651__auto___36197 = arguments.length;
var i__7652__auto___36198 = (0);
while(true){
if((i__7652__auto___36198 < len__7651__auto___36197)){
args36148.push((arguments[i__7652__auto___36198]));

var G__36199 = (i__7652__auto___36198 + (1));
i__7652__auto___36198 = G__36199;
continue;
} else {
}
break;
}

var G__36150 = args36148.length;
switch (G__36150) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36148.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19252__auto___36201 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36201,out){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36201,out){
return (function (state_36174){
var state_val_36175 = (state_36174[(1)]);
if((state_val_36175 === (7))){
var inst_36156 = (state_36174[(7)]);
var inst_36156__$1 = (state_36174[(2)]);
var inst_36157 = (inst_36156__$1 == null);
var inst_36158 = cljs.core.not(inst_36157);
var state_36174__$1 = (function (){var statearr_36176 = state_36174;
(statearr_36176[(7)] = inst_36156__$1);

return statearr_36176;
})();
if(inst_36158){
var statearr_36177_36202 = state_36174__$1;
(statearr_36177_36202[(1)] = (8));

} else {
var statearr_36178_36203 = state_36174__$1;
(statearr_36178_36203[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36175 === (1))){
var inst_36151 = (0);
var state_36174__$1 = (function (){var statearr_36179 = state_36174;
(statearr_36179[(8)] = inst_36151);

return statearr_36179;
})();
var statearr_36180_36204 = state_36174__$1;
(statearr_36180_36204[(2)] = null);

(statearr_36180_36204[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36175 === (4))){
var state_36174__$1 = state_36174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36174__$1,(7),ch);
} else {
if((state_val_36175 === (6))){
var inst_36169 = (state_36174[(2)]);
var state_36174__$1 = state_36174;
var statearr_36181_36205 = state_36174__$1;
(statearr_36181_36205[(2)] = inst_36169);

(statearr_36181_36205[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36175 === (3))){
var inst_36171 = (state_36174[(2)]);
var inst_36172 = cljs.core.async.close_BANG_(out);
var state_36174__$1 = (function (){var statearr_36182 = state_36174;
(statearr_36182[(9)] = inst_36171);

return statearr_36182;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36174__$1,inst_36172);
} else {
if((state_val_36175 === (2))){
var inst_36151 = (state_36174[(8)]);
var inst_36153 = (inst_36151 < n);
var state_36174__$1 = state_36174;
if(cljs.core.truth_(inst_36153)){
var statearr_36183_36206 = state_36174__$1;
(statearr_36183_36206[(1)] = (4));

} else {
var statearr_36184_36207 = state_36174__$1;
(statearr_36184_36207[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36175 === (11))){
var inst_36151 = (state_36174[(8)]);
var inst_36161 = (state_36174[(2)]);
var inst_36162 = (inst_36151 + (1));
var inst_36151__$1 = inst_36162;
var state_36174__$1 = (function (){var statearr_36185 = state_36174;
(statearr_36185[(10)] = inst_36161);

(statearr_36185[(8)] = inst_36151__$1);

return statearr_36185;
})();
var statearr_36186_36208 = state_36174__$1;
(statearr_36186_36208[(2)] = null);

(statearr_36186_36208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36175 === (9))){
var state_36174__$1 = state_36174;
var statearr_36187_36209 = state_36174__$1;
(statearr_36187_36209[(2)] = null);

(statearr_36187_36209[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36175 === (5))){
var state_36174__$1 = state_36174;
var statearr_36188_36210 = state_36174__$1;
(statearr_36188_36210[(2)] = null);

(statearr_36188_36210[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36175 === (10))){
var inst_36166 = (state_36174[(2)]);
var state_36174__$1 = state_36174;
var statearr_36189_36211 = state_36174__$1;
(statearr_36189_36211[(2)] = inst_36166);

(statearr_36189_36211[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36175 === (8))){
var inst_36156 = (state_36174[(7)]);
var state_36174__$1 = state_36174;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36174__$1,(11),out,inst_36156);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___36201,out))
;
return ((function (switch__19140__auto__,c__19252__auto___36201,out){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_36193 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36193[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_36193[(1)] = (1));

return statearr_36193;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_36174){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36174);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36194){if((e36194 instanceof Object)){
var ex__19144__auto__ = e36194;
var statearr_36195_36212 = state_36174;
(statearr_36195_36212[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36174);

return cljs.core.cst$kw$recur;
} else {
throw e36194;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36213 = state_36174;
state_36174 = G__36213;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_36174){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_36174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36201,out))
})();
var state__19254__auto__ = (function (){var statearr_36196 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36196[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36201);

return statearr_36196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36201,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async36223 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36223 = (function (f,ch,meta36224){
this.f = f;
this.ch = ch;
this.meta36224 = meta36224;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36225,meta36224__$1){
var self__ = this;
var _36225__$1 = this;
return (new cljs.core.async.t_cljs$core$async36223(self__.f,self__.ch,meta36224__$1));
});

cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36225){
var self__ = this;
var _36225__$1 = this;
return self__.meta36224;
});

cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async36226 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36226 = (function (f,ch,meta36224,_,fn1,meta36227){
this.f = f;
this.ch = ch;
this.meta36224 = meta36224;
this._ = _;
this.fn1 = fn1;
this.meta36227 = meta36227;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36226.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_36228,meta36227__$1){
var self__ = this;
var _36228__$1 = this;
return (new cljs.core.async.t_cljs$core$async36226(self__.f,self__.ch,self__.meta36224,self__._,self__.fn1,meta36227__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async36226.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_36228){
var self__ = this;
var _36228__$1 = this;
return self__.meta36227;
});})(___$1))
;

cljs.core.async.t_cljs$core$async36226.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36226.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async36226.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async36226.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__36214_SHARP_){
var G__36229 = (((p1__36214_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__36214_SHARP_) : self__.f.call(null,p1__36214_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__36229) : f1.call(null,G__36229));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async36226.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta36224,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async36223], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta36227], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async36226.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36226.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36226";

cljs.core.async.t_cljs$core$async36226.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async36226");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async36226 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async36226(f__$1,ch__$1,meta36224__$1,___$2,fn1__$1,meta36227){
return (new cljs.core.async.t_cljs$core$async36226(f__$1,ch__$1,meta36224__$1,___$2,fn1__$1,meta36227));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async36226(self__.f,self__.ch,self__.meta36224,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6531__auto__ = ret;
if(cljs.core.truth_(and__6531__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__36230 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__36230) : self__.f.call(null,G__36230));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36223.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async36223.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta36224], null);
});

cljs.core.async.t_cljs$core$async36223.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36223.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36223";

cljs.core.async.t_cljs$core$async36223.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async36223");
});

cljs.core.async.__GT_t_cljs$core$async36223 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async36223(f__$1,ch__$1,meta36224){
return (new cljs.core.async.t_cljs$core$async36223(f__$1,ch__$1,meta36224));
});

}

return (new cljs.core.async.t_cljs$core$async36223(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async36234 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36234 = (function (f,ch,meta36235){
this.f = f;
this.ch = ch;
this.meta36235 = meta36235;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36234.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36236,meta36235__$1){
var self__ = this;
var _36236__$1 = this;
return (new cljs.core.async.t_cljs$core$async36234(self__.f,self__.ch,meta36235__$1));
});

cljs.core.async.t_cljs$core$async36234.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36236){
var self__ = this;
var _36236__$1 = this;
return self__.meta36235;
});

cljs.core.async.t_cljs$core$async36234.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36234.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async36234.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36234.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async36234.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36234.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async36234.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta36235], null);
});

cljs.core.async.t_cljs$core$async36234.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36234.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36234";

cljs.core.async.t_cljs$core$async36234.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async36234");
});

cljs.core.async.__GT_t_cljs$core$async36234 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async36234(f__$1,ch__$1,meta36235){
return (new cljs.core.async.t_cljs$core$async36234(f__$1,ch__$1,meta36235));
});

}

return (new cljs.core.async.t_cljs$core$async36234(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async36240 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36240 = (function (p,ch,meta36241){
this.p = p;
this.ch = ch;
this.meta36241 = meta36241;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36242,meta36241__$1){
var self__ = this;
var _36242__$1 = this;
return (new cljs.core.async.t_cljs$core$async36240(self__.p,self__.ch,meta36241__$1));
});

cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36242){
var self__ = this;
var _36242__$1 = this;
return self__.meta36241;
});

cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36240.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async36240.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta36241], null);
});

cljs.core.async.t_cljs$core$async36240.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36240.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36240";

cljs.core.async.t_cljs$core$async36240.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async36240");
});

cljs.core.async.__GT_t_cljs$core$async36240 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async36240(p__$1,ch__$1,meta36241){
return (new cljs.core.async.t_cljs$core$async36240(p__$1,ch__$1,meta36241));
});

}

return (new cljs.core.async.t_cljs$core$async36240(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args36243 = [];
var len__7651__auto___36287 = arguments.length;
var i__7652__auto___36288 = (0);
while(true){
if((i__7652__auto___36288 < len__7651__auto___36287)){
args36243.push((arguments[i__7652__auto___36288]));

var G__36289 = (i__7652__auto___36288 + (1));
i__7652__auto___36288 = G__36289;
continue;
} else {
}
break;
}

var G__36245 = args36243.length;
switch (G__36245) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36243.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19252__auto___36291 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36291,out){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36291,out){
return (function (state_36266){
var state_val_36267 = (state_36266[(1)]);
if((state_val_36267 === (7))){
var inst_36262 = (state_36266[(2)]);
var state_36266__$1 = state_36266;
var statearr_36268_36292 = state_36266__$1;
(statearr_36268_36292[(2)] = inst_36262);

(statearr_36268_36292[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36267 === (1))){
var state_36266__$1 = state_36266;
var statearr_36269_36293 = state_36266__$1;
(statearr_36269_36293[(2)] = null);

(statearr_36269_36293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36267 === (4))){
var inst_36248 = (state_36266[(7)]);
var inst_36248__$1 = (state_36266[(2)]);
var inst_36249 = (inst_36248__$1 == null);
var state_36266__$1 = (function (){var statearr_36270 = state_36266;
(statearr_36270[(7)] = inst_36248__$1);

return statearr_36270;
})();
if(cljs.core.truth_(inst_36249)){
var statearr_36271_36294 = state_36266__$1;
(statearr_36271_36294[(1)] = (5));

} else {
var statearr_36272_36295 = state_36266__$1;
(statearr_36272_36295[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36267 === (6))){
var inst_36248 = (state_36266[(7)]);
var inst_36253 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_36248) : p.call(null,inst_36248));
var state_36266__$1 = state_36266;
if(cljs.core.truth_(inst_36253)){
var statearr_36273_36296 = state_36266__$1;
(statearr_36273_36296[(1)] = (8));

} else {
var statearr_36274_36297 = state_36266__$1;
(statearr_36274_36297[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36267 === (3))){
var inst_36264 = (state_36266[(2)]);
var state_36266__$1 = state_36266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36266__$1,inst_36264);
} else {
if((state_val_36267 === (2))){
var state_36266__$1 = state_36266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36266__$1,(4),ch);
} else {
if((state_val_36267 === (11))){
var inst_36256 = (state_36266[(2)]);
var state_36266__$1 = state_36266;
var statearr_36275_36298 = state_36266__$1;
(statearr_36275_36298[(2)] = inst_36256);

(statearr_36275_36298[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36267 === (9))){
var state_36266__$1 = state_36266;
var statearr_36276_36299 = state_36266__$1;
(statearr_36276_36299[(2)] = null);

(statearr_36276_36299[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36267 === (5))){
var inst_36251 = cljs.core.async.close_BANG_(out);
var state_36266__$1 = state_36266;
var statearr_36277_36300 = state_36266__$1;
(statearr_36277_36300[(2)] = inst_36251);

(statearr_36277_36300[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36267 === (10))){
var inst_36259 = (state_36266[(2)]);
var state_36266__$1 = (function (){var statearr_36278 = state_36266;
(statearr_36278[(8)] = inst_36259);

return statearr_36278;
})();
var statearr_36279_36301 = state_36266__$1;
(statearr_36279_36301[(2)] = null);

(statearr_36279_36301[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36267 === (8))){
var inst_36248 = (state_36266[(7)]);
var state_36266__$1 = state_36266;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36266__$1,(11),out,inst_36248);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___36291,out))
;
return ((function (switch__19140__auto__,c__19252__auto___36291,out){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_36283 = [null,null,null,null,null,null,null,null,null];
(statearr_36283[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_36283[(1)] = (1));

return statearr_36283;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_36266){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36266);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36284){if((e36284 instanceof Object)){
var ex__19144__auto__ = e36284;
var statearr_36285_36302 = state_36266;
(statearr_36285_36302[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36266);

return cljs.core.cst$kw$recur;
} else {
throw e36284;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36303 = state_36266;
state_36266 = G__36303;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_36266){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_36266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36291,out))
})();
var state__19254__auto__ = (function (){var statearr_36286 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36286[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36291);

return statearr_36286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36291,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args36304 = [];
var len__7651__auto___36307 = arguments.length;
var i__7652__auto___36308 = (0);
while(true){
if((i__7652__auto___36308 < len__7651__auto___36307)){
args36304.push((arguments[i__7652__auto___36308]));

var G__36309 = (i__7652__auto___36308 + (1));
i__7652__auto___36308 = G__36309;
continue;
} else {
}
break;
}

var G__36306 = args36304.length;
switch (G__36306) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36304.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__){
return (function (state_36476){
var state_val_36477 = (state_36476[(1)]);
if((state_val_36477 === (7))){
var inst_36472 = (state_36476[(2)]);
var state_36476__$1 = state_36476;
var statearr_36478_36519 = state_36476__$1;
(statearr_36478_36519[(2)] = inst_36472);

(statearr_36478_36519[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (20))){
var inst_36442 = (state_36476[(7)]);
var inst_36453 = (state_36476[(2)]);
var inst_36454 = cljs.core.next(inst_36442);
var inst_36428 = inst_36454;
var inst_36429 = null;
var inst_36430 = (0);
var inst_36431 = (0);
var state_36476__$1 = (function (){var statearr_36479 = state_36476;
(statearr_36479[(8)] = inst_36431);

(statearr_36479[(9)] = inst_36453);

(statearr_36479[(10)] = inst_36430);

(statearr_36479[(11)] = inst_36428);

(statearr_36479[(12)] = inst_36429);

return statearr_36479;
})();
var statearr_36480_36520 = state_36476__$1;
(statearr_36480_36520[(2)] = null);

(statearr_36480_36520[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (1))){
var state_36476__$1 = state_36476;
var statearr_36481_36521 = state_36476__$1;
(statearr_36481_36521[(2)] = null);

(statearr_36481_36521[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (4))){
var inst_36417 = (state_36476[(13)]);
var inst_36417__$1 = (state_36476[(2)]);
var inst_36418 = (inst_36417__$1 == null);
var state_36476__$1 = (function (){var statearr_36482 = state_36476;
(statearr_36482[(13)] = inst_36417__$1);

return statearr_36482;
})();
if(cljs.core.truth_(inst_36418)){
var statearr_36483_36522 = state_36476__$1;
(statearr_36483_36522[(1)] = (5));

} else {
var statearr_36484_36523 = state_36476__$1;
(statearr_36484_36523[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (15))){
var state_36476__$1 = state_36476;
var statearr_36488_36524 = state_36476__$1;
(statearr_36488_36524[(2)] = null);

(statearr_36488_36524[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (21))){
var state_36476__$1 = state_36476;
var statearr_36489_36525 = state_36476__$1;
(statearr_36489_36525[(2)] = null);

(statearr_36489_36525[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (13))){
var inst_36431 = (state_36476[(8)]);
var inst_36430 = (state_36476[(10)]);
var inst_36428 = (state_36476[(11)]);
var inst_36429 = (state_36476[(12)]);
var inst_36438 = (state_36476[(2)]);
var inst_36439 = (inst_36431 + (1));
var tmp36485 = inst_36430;
var tmp36486 = inst_36428;
var tmp36487 = inst_36429;
var inst_36428__$1 = tmp36486;
var inst_36429__$1 = tmp36487;
var inst_36430__$1 = tmp36485;
var inst_36431__$1 = inst_36439;
var state_36476__$1 = (function (){var statearr_36490 = state_36476;
(statearr_36490[(14)] = inst_36438);

(statearr_36490[(8)] = inst_36431__$1);

(statearr_36490[(10)] = inst_36430__$1);

(statearr_36490[(11)] = inst_36428__$1);

(statearr_36490[(12)] = inst_36429__$1);

return statearr_36490;
})();
var statearr_36491_36526 = state_36476__$1;
(statearr_36491_36526[(2)] = null);

(statearr_36491_36526[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (22))){
var state_36476__$1 = state_36476;
var statearr_36492_36527 = state_36476__$1;
(statearr_36492_36527[(2)] = null);

(statearr_36492_36527[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (6))){
var inst_36417 = (state_36476[(13)]);
var inst_36426 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_36417) : f.call(null,inst_36417));
var inst_36427 = cljs.core.seq(inst_36426);
var inst_36428 = inst_36427;
var inst_36429 = null;
var inst_36430 = (0);
var inst_36431 = (0);
var state_36476__$1 = (function (){var statearr_36493 = state_36476;
(statearr_36493[(8)] = inst_36431);

(statearr_36493[(10)] = inst_36430);

(statearr_36493[(11)] = inst_36428);

(statearr_36493[(12)] = inst_36429);

return statearr_36493;
})();
var statearr_36494_36528 = state_36476__$1;
(statearr_36494_36528[(2)] = null);

(statearr_36494_36528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (17))){
var inst_36442 = (state_36476[(7)]);
var inst_36446 = cljs.core.chunk_first(inst_36442);
var inst_36447 = cljs.core.chunk_rest(inst_36442);
var inst_36448 = cljs.core.count(inst_36446);
var inst_36428 = inst_36447;
var inst_36429 = inst_36446;
var inst_36430 = inst_36448;
var inst_36431 = (0);
var state_36476__$1 = (function (){var statearr_36495 = state_36476;
(statearr_36495[(8)] = inst_36431);

(statearr_36495[(10)] = inst_36430);

(statearr_36495[(11)] = inst_36428);

(statearr_36495[(12)] = inst_36429);

return statearr_36495;
})();
var statearr_36496_36529 = state_36476__$1;
(statearr_36496_36529[(2)] = null);

(statearr_36496_36529[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (3))){
var inst_36474 = (state_36476[(2)]);
var state_36476__$1 = state_36476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36476__$1,inst_36474);
} else {
if((state_val_36477 === (12))){
var inst_36462 = (state_36476[(2)]);
var state_36476__$1 = state_36476;
var statearr_36497_36530 = state_36476__$1;
(statearr_36497_36530[(2)] = inst_36462);

(statearr_36497_36530[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (2))){
var state_36476__$1 = state_36476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36476__$1,(4),in$);
} else {
if((state_val_36477 === (23))){
var inst_36470 = (state_36476[(2)]);
var state_36476__$1 = state_36476;
var statearr_36498_36531 = state_36476__$1;
(statearr_36498_36531[(2)] = inst_36470);

(statearr_36498_36531[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (19))){
var inst_36457 = (state_36476[(2)]);
var state_36476__$1 = state_36476;
var statearr_36499_36532 = state_36476__$1;
(statearr_36499_36532[(2)] = inst_36457);

(statearr_36499_36532[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (11))){
var inst_36442 = (state_36476[(7)]);
var inst_36428 = (state_36476[(11)]);
var inst_36442__$1 = cljs.core.seq(inst_36428);
var state_36476__$1 = (function (){var statearr_36500 = state_36476;
(statearr_36500[(7)] = inst_36442__$1);

return statearr_36500;
})();
if(inst_36442__$1){
var statearr_36501_36533 = state_36476__$1;
(statearr_36501_36533[(1)] = (14));

} else {
var statearr_36502_36534 = state_36476__$1;
(statearr_36502_36534[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (9))){
var inst_36464 = (state_36476[(2)]);
var inst_36465 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_36476__$1 = (function (){var statearr_36503 = state_36476;
(statearr_36503[(15)] = inst_36464);

return statearr_36503;
})();
if(cljs.core.truth_(inst_36465)){
var statearr_36504_36535 = state_36476__$1;
(statearr_36504_36535[(1)] = (21));

} else {
var statearr_36505_36536 = state_36476__$1;
(statearr_36505_36536[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (5))){
var inst_36420 = cljs.core.async.close_BANG_(out);
var state_36476__$1 = state_36476;
var statearr_36506_36537 = state_36476__$1;
(statearr_36506_36537[(2)] = inst_36420);

(statearr_36506_36537[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (14))){
var inst_36442 = (state_36476[(7)]);
var inst_36444 = cljs.core.chunked_seq_QMARK_(inst_36442);
var state_36476__$1 = state_36476;
if(inst_36444){
var statearr_36507_36538 = state_36476__$1;
(statearr_36507_36538[(1)] = (17));

} else {
var statearr_36508_36539 = state_36476__$1;
(statearr_36508_36539[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (16))){
var inst_36460 = (state_36476[(2)]);
var state_36476__$1 = state_36476;
var statearr_36509_36540 = state_36476__$1;
(statearr_36509_36540[(2)] = inst_36460);

(statearr_36509_36540[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36477 === (10))){
var inst_36431 = (state_36476[(8)]);
var inst_36429 = (state_36476[(12)]);
var inst_36436 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_36429,inst_36431);
var state_36476__$1 = state_36476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36476__$1,(13),out,inst_36436);
} else {
if((state_val_36477 === (18))){
var inst_36442 = (state_36476[(7)]);
var inst_36451 = cljs.core.first(inst_36442);
var state_36476__$1 = state_36476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36476__$1,(20),out,inst_36451);
} else {
if((state_val_36477 === (8))){
var inst_36431 = (state_36476[(8)]);
var inst_36430 = (state_36476[(10)]);
var inst_36433 = (inst_36431 < inst_36430);
var inst_36434 = inst_36433;
var state_36476__$1 = state_36476;
if(cljs.core.truth_(inst_36434)){
var statearr_36510_36541 = state_36476__$1;
(statearr_36510_36541[(1)] = (10));

} else {
var statearr_36511_36542 = state_36476__$1;
(statearr_36511_36542[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto__))
;
return ((function (switch__19140__auto__,c__19252__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__19141__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__19141__auto____0 = (function (){
var statearr_36515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36515[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__19141__auto__);

(statearr_36515[(1)] = (1));

return statearr_36515;
});
var cljs$core$async$mapcat_STAR__$_state_machine__19141__auto____1 = (function (state_36476){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36476);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36516){if((e36516 instanceof Object)){
var ex__19144__auto__ = e36516;
var statearr_36517_36543 = state_36476;
(statearr_36517_36543[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36476);

return cljs.core.cst$kw$recur;
} else {
throw e36516;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36544 = state_36476;
state_36476 = G__36544;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__19141__auto__ = function(state_36476){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__19141__auto____1.call(this,state_36476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__19141__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__19141__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__))
})();
var state__19254__auto__ = (function (){var statearr_36518 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36518[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_36518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__))
);

return c__19252__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args36545 = [];
var len__7651__auto___36548 = arguments.length;
var i__7652__auto___36549 = (0);
while(true){
if((i__7652__auto___36549 < len__7651__auto___36548)){
args36545.push((arguments[i__7652__auto___36549]));

var G__36550 = (i__7652__auto___36549 + (1));
i__7652__auto___36549 = G__36550;
continue;
} else {
}
break;
}

var G__36547 = args36545.length;
switch (G__36547) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36545.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args36552 = [];
var len__7651__auto___36555 = arguments.length;
var i__7652__auto___36556 = (0);
while(true){
if((i__7652__auto___36556 < len__7651__auto___36555)){
args36552.push((arguments[i__7652__auto___36556]));

var G__36557 = (i__7652__auto___36556 + (1));
i__7652__auto___36556 = G__36557;
continue;
} else {
}
break;
}

var G__36554 = args36552.length;
switch (G__36554) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36552.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args36559 = [];
var len__7651__auto___36610 = arguments.length;
var i__7652__auto___36611 = (0);
while(true){
if((i__7652__auto___36611 < len__7651__auto___36610)){
args36559.push((arguments[i__7652__auto___36611]));

var G__36612 = (i__7652__auto___36611 + (1));
i__7652__auto___36611 = G__36612;
continue;
} else {
}
break;
}

var G__36561 = args36559.length;
switch (G__36561) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36559.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19252__auto___36614 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36614,out){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36614,out){
return (function (state_36585){
var state_val_36586 = (state_36585[(1)]);
if((state_val_36586 === (7))){
var inst_36580 = (state_36585[(2)]);
var state_36585__$1 = state_36585;
var statearr_36587_36615 = state_36585__$1;
(statearr_36587_36615[(2)] = inst_36580);

(statearr_36587_36615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36586 === (1))){
var inst_36562 = null;
var state_36585__$1 = (function (){var statearr_36588 = state_36585;
(statearr_36588[(7)] = inst_36562);

return statearr_36588;
})();
var statearr_36589_36616 = state_36585__$1;
(statearr_36589_36616[(2)] = null);

(statearr_36589_36616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36586 === (4))){
var inst_36565 = (state_36585[(8)]);
var inst_36565__$1 = (state_36585[(2)]);
var inst_36566 = (inst_36565__$1 == null);
var inst_36567 = cljs.core.not(inst_36566);
var state_36585__$1 = (function (){var statearr_36590 = state_36585;
(statearr_36590[(8)] = inst_36565__$1);

return statearr_36590;
})();
if(inst_36567){
var statearr_36591_36617 = state_36585__$1;
(statearr_36591_36617[(1)] = (5));

} else {
var statearr_36592_36618 = state_36585__$1;
(statearr_36592_36618[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36586 === (6))){
var state_36585__$1 = state_36585;
var statearr_36593_36619 = state_36585__$1;
(statearr_36593_36619[(2)] = null);

(statearr_36593_36619[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36586 === (3))){
var inst_36582 = (state_36585[(2)]);
var inst_36583 = cljs.core.async.close_BANG_(out);
var state_36585__$1 = (function (){var statearr_36594 = state_36585;
(statearr_36594[(9)] = inst_36582);

return statearr_36594;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36585__$1,inst_36583);
} else {
if((state_val_36586 === (2))){
var state_36585__$1 = state_36585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36585__$1,(4),ch);
} else {
if((state_val_36586 === (11))){
var inst_36565 = (state_36585[(8)]);
var inst_36574 = (state_36585[(2)]);
var inst_36562 = inst_36565;
var state_36585__$1 = (function (){var statearr_36595 = state_36585;
(statearr_36595[(10)] = inst_36574);

(statearr_36595[(7)] = inst_36562);

return statearr_36595;
})();
var statearr_36596_36620 = state_36585__$1;
(statearr_36596_36620[(2)] = null);

(statearr_36596_36620[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36586 === (9))){
var inst_36565 = (state_36585[(8)]);
var state_36585__$1 = state_36585;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36585__$1,(11),out,inst_36565);
} else {
if((state_val_36586 === (5))){
var inst_36562 = (state_36585[(7)]);
var inst_36565 = (state_36585[(8)]);
var inst_36569 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36565,inst_36562);
var state_36585__$1 = state_36585;
if(inst_36569){
var statearr_36598_36621 = state_36585__$1;
(statearr_36598_36621[(1)] = (8));

} else {
var statearr_36599_36622 = state_36585__$1;
(statearr_36599_36622[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36586 === (10))){
var inst_36577 = (state_36585[(2)]);
var state_36585__$1 = state_36585;
var statearr_36600_36623 = state_36585__$1;
(statearr_36600_36623[(2)] = inst_36577);

(statearr_36600_36623[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36586 === (8))){
var inst_36562 = (state_36585[(7)]);
var tmp36597 = inst_36562;
var inst_36562__$1 = tmp36597;
var state_36585__$1 = (function (){var statearr_36601 = state_36585;
(statearr_36601[(7)] = inst_36562__$1);

return statearr_36601;
})();
var statearr_36602_36624 = state_36585__$1;
(statearr_36602_36624[(2)] = null);

(statearr_36602_36624[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___36614,out))
;
return ((function (switch__19140__auto__,c__19252__auto___36614,out){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_36606 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36606[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_36606[(1)] = (1));

return statearr_36606;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_36585){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36585);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36607){if((e36607 instanceof Object)){
var ex__19144__auto__ = e36607;
var statearr_36608_36625 = state_36585;
(statearr_36608_36625[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36585);

return cljs.core.cst$kw$recur;
} else {
throw e36607;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36626 = state_36585;
state_36585 = G__36626;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_36585){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_36585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36614,out))
})();
var state__19254__auto__ = (function (){var statearr_36609 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36609[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36614);

return statearr_36609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36614,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args36627 = [];
var len__7651__auto___36697 = arguments.length;
var i__7652__auto___36698 = (0);
while(true){
if((i__7652__auto___36698 < len__7651__auto___36697)){
args36627.push((arguments[i__7652__auto___36698]));

var G__36699 = (i__7652__auto___36698 + (1));
i__7652__auto___36698 = G__36699;
continue;
} else {
}
break;
}

var G__36629 = args36627.length;
switch (G__36629) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36627.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19252__auto___36701 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36701,out){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36701,out){
return (function (state_36667){
var state_val_36668 = (state_36667[(1)]);
if((state_val_36668 === (7))){
var inst_36663 = (state_36667[(2)]);
var state_36667__$1 = state_36667;
var statearr_36669_36702 = state_36667__$1;
(statearr_36669_36702[(2)] = inst_36663);

(statearr_36669_36702[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (1))){
var inst_36630 = (new Array(n));
var inst_36631 = inst_36630;
var inst_36632 = (0);
var state_36667__$1 = (function (){var statearr_36670 = state_36667;
(statearr_36670[(7)] = inst_36632);

(statearr_36670[(8)] = inst_36631);

return statearr_36670;
})();
var statearr_36671_36703 = state_36667__$1;
(statearr_36671_36703[(2)] = null);

(statearr_36671_36703[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (4))){
var inst_36635 = (state_36667[(9)]);
var inst_36635__$1 = (state_36667[(2)]);
var inst_36636 = (inst_36635__$1 == null);
var inst_36637 = cljs.core.not(inst_36636);
var state_36667__$1 = (function (){var statearr_36672 = state_36667;
(statearr_36672[(9)] = inst_36635__$1);

return statearr_36672;
})();
if(inst_36637){
var statearr_36673_36704 = state_36667__$1;
(statearr_36673_36704[(1)] = (5));

} else {
var statearr_36674_36705 = state_36667__$1;
(statearr_36674_36705[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (15))){
var inst_36657 = (state_36667[(2)]);
var state_36667__$1 = state_36667;
var statearr_36675_36706 = state_36667__$1;
(statearr_36675_36706[(2)] = inst_36657);

(statearr_36675_36706[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (13))){
var state_36667__$1 = state_36667;
var statearr_36676_36707 = state_36667__$1;
(statearr_36676_36707[(2)] = null);

(statearr_36676_36707[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (6))){
var inst_36632 = (state_36667[(7)]);
var inst_36653 = (inst_36632 > (0));
var state_36667__$1 = state_36667;
if(cljs.core.truth_(inst_36653)){
var statearr_36677_36708 = state_36667__$1;
(statearr_36677_36708[(1)] = (12));

} else {
var statearr_36678_36709 = state_36667__$1;
(statearr_36678_36709[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (3))){
var inst_36665 = (state_36667[(2)]);
var state_36667__$1 = state_36667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36667__$1,inst_36665);
} else {
if((state_val_36668 === (12))){
var inst_36631 = (state_36667[(8)]);
var inst_36655 = cljs.core.vec(inst_36631);
var state_36667__$1 = state_36667;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36667__$1,(15),out,inst_36655);
} else {
if((state_val_36668 === (2))){
var state_36667__$1 = state_36667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36667__$1,(4),ch);
} else {
if((state_val_36668 === (11))){
var inst_36647 = (state_36667[(2)]);
var inst_36648 = (new Array(n));
var inst_36631 = inst_36648;
var inst_36632 = (0);
var state_36667__$1 = (function (){var statearr_36679 = state_36667;
(statearr_36679[(7)] = inst_36632);

(statearr_36679[(8)] = inst_36631);

(statearr_36679[(10)] = inst_36647);

return statearr_36679;
})();
var statearr_36680_36710 = state_36667__$1;
(statearr_36680_36710[(2)] = null);

(statearr_36680_36710[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (9))){
var inst_36631 = (state_36667[(8)]);
var inst_36645 = cljs.core.vec(inst_36631);
var state_36667__$1 = state_36667;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36667__$1,(11),out,inst_36645);
} else {
if((state_val_36668 === (5))){
var inst_36640 = (state_36667[(11)]);
var inst_36632 = (state_36667[(7)]);
var inst_36635 = (state_36667[(9)]);
var inst_36631 = (state_36667[(8)]);
var inst_36639 = (inst_36631[inst_36632] = inst_36635);
var inst_36640__$1 = (inst_36632 + (1));
var inst_36641 = (inst_36640__$1 < n);
var state_36667__$1 = (function (){var statearr_36681 = state_36667;
(statearr_36681[(12)] = inst_36639);

(statearr_36681[(11)] = inst_36640__$1);

return statearr_36681;
})();
if(cljs.core.truth_(inst_36641)){
var statearr_36682_36711 = state_36667__$1;
(statearr_36682_36711[(1)] = (8));

} else {
var statearr_36683_36712 = state_36667__$1;
(statearr_36683_36712[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (14))){
var inst_36660 = (state_36667[(2)]);
var inst_36661 = cljs.core.async.close_BANG_(out);
var state_36667__$1 = (function (){var statearr_36685 = state_36667;
(statearr_36685[(13)] = inst_36660);

return statearr_36685;
})();
var statearr_36686_36713 = state_36667__$1;
(statearr_36686_36713[(2)] = inst_36661);

(statearr_36686_36713[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (10))){
var inst_36651 = (state_36667[(2)]);
var state_36667__$1 = state_36667;
var statearr_36687_36714 = state_36667__$1;
(statearr_36687_36714[(2)] = inst_36651);

(statearr_36687_36714[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36668 === (8))){
var inst_36640 = (state_36667[(11)]);
var inst_36631 = (state_36667[(8)]);
var tmp36684 = inst_36631;
var inst_36631__$1 = tmp36684;
var inst_36632 = inst_36640;
var state_36667__$1 = (function (){var statearr_36688 = state_36667;
(statearr_36688[(7)] = inst_36632);

(statearr_36688[(8)] = inst_36631__$1);

return statearr_36688;
})();
var statearr_36689_36715 = state_36667__$1;
(statearr_36689_36715[(2)] = null);

(statearr_36689_36715[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___36701,out))
;
return ((function (switch__19140__auto__,c__19252__auto___36701,out){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_36693 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36693[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_36693[(1)] = (1));

return statearr_36693;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_36667){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36667);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36694){if((e36694 instanceof Object)){
var ex__19144__auto__ = e36694;
var statearr_36695_36716 = state_36667;
(statearr_36695_36716[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36667);

return cljs.core.cst$kw$recur;
} else {
throw e36694;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36717 = state_36667;
state_36667 = G__36717;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_36667){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_36667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36701,out))
})();
var state__19254__auto__ = (function (){var statearr_36696 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36696[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36701);

return statearr_36696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36701,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args36718 = [];
var len__7651__auto___36792 = arguments.length;
var i__7652__auto___36793 = (0);
while(true){
if((i__7652__auto___36793 < len__7651__auto___36792)){
args36718.push((arguments[i__7652__auto___36793]));

var G__36794 = (i__7652__auto___36793 + (1));
i__7652__auto___36793 = G__36794;
continue;
} else {
}
break;
}

var G__36720 = args36718.length;
switch (G__36720) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36718.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19252__auto___36796 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36796,out){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36796,out){
return (function (state_36762){
var state_val_36763 = (state_36762[(1)]);
if((state_val_36763 === (7))){
var inst_36758 = (state_36762[(2)]);
var state_36762__$1 = state_36762;
var statearr_36764_36797 = state_36762__$1;
(statearr_36764_36797[(2)] = inst_36758);

(statearr_36764_36797[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (1))){
var inst_36721 = [];
var inst_36722 = inst_36721;
var inst_36723 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_36762__$1 = (function (){var statearr_36765 = state_36762;
(statearr_36765[(7)] = inst_36722);

(statearr_36765[(8)] = inst_36723);

return statearr_36765;
})();
var statearr_36766_36798 = state_36762__$1;
(statearr_36766_36798[(2)] = null);

(statearr_36766_36798[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (4))){
var inst_36726 = (state_36762[(9)]);
var inst_36726__$1 = (state_36762[(2)]);
var inst_36727 = (inst_36726__$1 == null);
var inst_36728 = cljs.core.not(inst_36727);
var state_36762__$1 = (function (){var statearr_36767 = state_36762;
(statearr_36767[(9)] = inst_36726__$1);

return statearr_36767;
})();
if(inst_36728){
var statearr_36768_36799 = state_36762__$1;
(statearr_36768_36799[(1)] = (5));

} else {
var statearr_36769_36800 = state_36762__$1;
(statearr_36769_36800[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (15))){
var inst_36752 = (state_36762[(2)]);
var state_36762__$1 = state_36762;
var statearr_36770_36801 = state_36762__$1;
(statearr_36770_36801[(2)] = inst_36752);

(statearr_36770_36801[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (13))){
var state_36762__$1 = state_36762;
var statearr_36771_36802 = state_36762__$1;
(statearr_36771_36802[(2)] = null);

(statearr_36771_36802[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (6))){
var inst_36722 = (state_36762[(7)]);
var inst_36747 = inst_36722.length;
var inst_36748 = (inst_36747 > (0));
var state_36762__$1 = state_36762;
if(cljs.core.truth_(inst_36748)){
var statearr_36772_36803 = state_36762__$1;
(statearr_36772_36803[(1)] = (12));

} else {
var statearr_36773_36804 = state_36762__$1;
(statearr_36773_36804[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (3))){
var inst_36760 = (state_36762[(2)]);
var state_36762__$1 = state_36762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36762__$1,inst_36760);
} else {
if((state_val_36763 === (12))){
var inst_36722 = (state_36762[(7)]);
var inst_36750 = cljs.core.vec(inst_36722);
var state_36762__$1 = state_36762;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36762__$1,(15),out,inst_36750);
} else {
if((state_val_36763 === (2))){
var state_36762__$1 = state_36762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36762__$1,(4),ch);
} else {
if((state_val_36763 === (11))){
var inst_36730 = (state_36762[(10)]);
var inst_36726 = (state_36762[(9)]);
var inst_36740 = (state_36762[(2)]);
var inst_36741 = [];
var inst_36742 = inst_36741.push(inst_36726);
var inst_36722 = inst_36741;
var inst_36723 = inst_36730;
var state_36762__$1 = (function (){var statearr_36774 = state_36762;
(statearr_36774[(11)] = inst_36740);

(statearr_36774[(7)] = inst_36722);

(statearr_36774[(8)] = inst_36723);

(statearr_36774[(12)] = inst_36742);

return statearr_36774;
})();
var statearr_36775_36805 = state_36762__$1;
(statearr_36775_36805[(2)] = null);

(statearr_36775_36805[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (9))){
var inst_36722 = (state_36762[(7)]);
var inst_36738 = cljs.core.vec(inst_36722);
var state_36762__$1 = state_36762;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36762__$1,(11),out,inst_36738);
} else {
if((state_val_36763 === (5))){
var inst_36730 = (state_36762[(10)]);
var inst_36726 = (state_36762[(9)]);
var inst_36723 = (state_36762[(8)]);
var inst_36730__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_36726) : f.call(null,inst_36726));
var inst_36731 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36730__$1,inst_36723);
var inst_36732 = cljs.core.keyword_identical_QMARK_(inst_36723,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_36733 = (inst_36731) || (inst_36732);
var state_36762__$1 = (function (){var statearr_36776 = state_36762;
(statearr_36776[(10)] = inst_36730__$1);

return statearr_36776;
})();
if(cljs.core.truth_(inst_36733)){
var statearr_36777_36806 = state_36762__$1;
(statearr_36777_36806[(1)] = (8));

} else {
var statearr_36778_36807 = state_36762__$1;
(statearr_36778_36807[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (14))){
var inst_36755 = (state_36762[(2)]);
var inst_36756 = cljs.core.async.close_BANG_(out);
var state_36762__$1 = (function (){var statearr_36780 = state_36762;
(statearr_36780[(13)] = inst_36755);

return statearr_36780;
})();
var statearr_36781_36808 = state_36762__$1;
(statearr_36781_36808[(2)] = inst_36756);

(statearr_36781_36808[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (10))){
var inst_36745 = (state_36762[(2)]);
var state_36762__$1 = state_36762;
var statearr_36782_36809 = state_36762__$1;
(statearr_36782_36809[(2)] = inst_36745);

(statearr_36782_36809[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36763 === (8))){
var inst_36730 = (state_36762[(10)]);
var inst_36722 = (state_36762[(7)]);
var inst_36726 = (state_36762[(9)]);
var inst_36735 = inst_36722.push(inst_36726);
var tmp36779 = inst_36722;
var inst_36722__$1 = tmp36779;
var inst_36723 = inst_36730;
var state_36762__$1 = (function (){var statearr_36783 = state_36762;
(statearr_36783[(7)] = inst_36722__$1);

(statearr_36783[(8)] = inst_36723);

(statearr_36783[(14)] = inst_36735);

return statearr_36783;
})();
var statearr_36784_36810 = state_36762__$1;
(statearr_36784_36810[(2)] = null);

(statearr_36784_36810[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___36796,out))
;
return ((function (switch__19140__auto__,c__19252__auto___36796,out){
return (function() {
var cljs$core$async$state_machine__19141__auto__ = null;
var cljs$core$async$state_machine__19141__auto____0 = (function (){
var statearr_36788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36788[(0)] = cljs$core$async$state_machine__19141__auto__);

(statearr_36788[(1)] = (1));

return statearr_36788;
});
var cljs$core$async$state_machine__19141__auto____1 = (function (state_36762){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36762);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36789){if((e36789 instanceof Object)){
var ex__19144__auto__ = e36789;
var statearr_36790_36811 = state_36762;
(statearr_36790_36811[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36762);

return cljs.core.cst$kw$recur;
} else {
throw e36789;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36812 = state_36762;
state_36762 = G__36812;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs$core$async$state_machine__19141__auto__ = function(state_36762){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19141__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19141__auto____1.call(this,state_36762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19141__auto____0;
cljs$core$async$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19141__auto____1;
return cljs$core$async$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36796,out))
})();
var state__19254__auto__ = (function (){var statearr_36791 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36791[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36796);

return statearr_36791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36796,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

