// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37902 = arguments.length;
var i__7652__auto___37903 = (0);
while(true){
if((i__7652__auto___37903 < len__7651__auto___37902)){
args__7658__auto__.push((arguments[i__7652__auto___37903]));

var G__37904 = (i__7652__auto___37903 + (1));
i__7652__auto___37903 = G__37904;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__37815){
var map__37816 = p__37815;
var map__37816__$1 = ((((!((map__37816 == null)))?((((map__37816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37816.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37816):map__37816);
var options = map__37816__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__37816__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__37816__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__,map__37816,map__37816__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__,map__37816,map__37816__$1,options,max_retries,retry_for_statuses){
return (function (state_37867){
var state_val_37868 = (state_37867[(1)]);
if((state_val_37868 === (7))){
var inst_37841 = (state_37867[(2)]);
var state_37867__$1 = state_37867;
if(cljs.core.truth_(inst_37841)){
var statearr_37869_37905 = state_37867__$1;
(statearr_37869_37905[(1)] = (11));

} else {
var statearr_37870_37906 = state_37867__$1;
(statearr_37870_37906[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (20))){
var inst_37819 = (state_37867[(7)]);
var inst_37818 = (state_37867[(8)]);
var inst_37857 = (state_37867[(2)]);
var inst_37858 = (inst_37818 * (2));
var inst_37859 = (inst_37819 + (1));
var inst_37818__$1 = inst_37858;
var inst_37819__$1 = inst_37859;
var state_37867__$1 = (function (){var statearr_37871 = state_37867;
(statearr_37871[(7)] = inst_37819__$1);

(statearr_37871[(9)] = inst_37857);

(statearr_37871[(8)] = inst_37818__$1);

return statearr_37871;
})();
var statearr_37872_37907 = state_37867__$1;
(statearr_37872_37907[(2)] = null);

(statearr_37872_37907[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (1))){
var inst_37818 = milia.utils.retry.initial_polling_interval;
var inst_37819 = (0);
var state_37867__$1 = (function (){var statearr_37873 = state_37867;
(statearr_37873[(7)] = inst_37819);

(statearr_37873[(8)] = inst_37818);

return statearr_37873;
})();
var statearr_37874_37908 = state_37867__$1;
(statearr_37874_37908[(2)] = null);

(statearr_37874_37908[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (4))){
var inst_37825 = (state_37867[(10)]);
var inst_37825__$1 = (state_37867[(2)]);
var inst_37827 = (inst_37825__$1 == null);
var inst_37828 = cljs.core.not(inst_37827);
var state_37867__$1 = (function (){var statearr_37875 = state_37867;
(statearr_37875[(10)] = inst_37825__$1);

return statearr_37875;
})();
if(inst_37828){
var statearr_37876_37909 = state_37867__$1;
(statearr_37876_37909[(1)] = (5));

} else {
var statearr_37877_37910 = state_37867__$1;
(statearr_37877_37910[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (15))){
var inst_37848 = (state_37867[(11)]);
var state_37867__$1 = state_37867;
var statearr_37878_37911 = state_37867__$1;
(statearr_37878_37911[(2)] = inst_37848);

(statearr_37878_37911[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (13))){
var inst_37846 = (state_37867[(12)]);
var inst_37848 = (state_37867[(11)]);
var inst_37846__$1 = (state_37867[(2)]);
var inst_37847 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37846__$1,cljs.core.cst$kw$status);
var inst_37848__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_37847);
var state_37867__$1 = (function (){var statearr_37879 = state_37867;
(statearr_37879[(12)] = inst_37846__$1);

(statearr_37879[(11)] = inst_37848__$1);

return statearr_37879;
})();
if(cljs.core.truth_(inst_37848__$1)){
var statearr_37880_37912 = state_37867__$1;
(statearr_37880_37912[(1)] = (14));

} else {
var statearr_37881_37913 = state_37867__$1;
(statearr_37881_37913[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (6))){
var state_37867__$1 = state_37867;
var statearr_37882_37914 = state_37867__$1;
(statearr_37882_37914[(2)] = false);

(statearr_37882_37914[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (17))){
var inst_37818 = (state_37867[(8)]);
var inst_37855 = cljs.core.async.timeout(inst_37818);
var state_37867__$1 = state_37867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37867__$1,(20),inst_37855);
} else {
if((state_val_37868 === (3))){
var inst_37865 = (state_37867[(2)]);
var state_37867__$1 = state_37867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37867__$1,inst_37865);
} else {
if((state_val_37868 === (12))){
var inst_37825 = (state_37867[(10)]);
var state_37867__$1 = state_37867;
var statearr_37883_37915 = state_37867__$1;
(statearr_37883_37915[(2)] = inst_37825);

(statearr_37883_37915[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (2))){
var inst_37822 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_37823 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_37822], 0));
var state_37867__$1 = state_37867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37867__$1,(4),inst_37823);
} else {
if((state_val_37868 === (19))){
var inst_37863 = (state_37867[(2)]);
var state_37867__$1 = state_37867;
var statearr_37884_37916 = state_37867__$1;
(statearr_37884_37916[(2)] = inst_37863);

(statearr_37884_37916[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (11))){
var inst_37825 = (state_37867[(10)]);
var inst_37843 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37825);
var state_37867__$1 = state_37867;
var statearr_37885_37917 = state_37867__$1;
(statearr_37885_37917[(2)] = inst_37843);

(statearr_37885_37917[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (9))){
var state_37867__$1 = state_37867;
var statearr_37886_37918 = state_37867__$1;
(statearr_37886_37918[(2)] = false);

(statearr_37886_37918[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (5))){
var inst_37825 = (state_37867[(10)]);
var inst_37830 = inst_37825.cljs$lang$protocol_mask$partition0$;
var inst_37831 = (inst_37830 & (64));
var inst_37832 = inst_37825.cljs$core$ISeq$;
var inst_37833 = (cljs.core.PROTOCOL_SENTINEL === inst_37832);
var inst_37834 = (inst_37831) || (inst_37833);
var state_37867__$1 = state_37867;
if(cljs.core.truth_(inst_37834)){
var statearr_37887_37919 = state_37867__$1;
(statearr_37887_37919[(1)] = (8));

} else {
var statearr_37888_37920 = state_37867__$1;
(statearr_37888_37920[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (14))){
var inst_37819 = (state_37867[(7)]);
var inst_37850 = (inst_37819 < max_retries);
var state_37867__$1 = state_37867;
var statearr_37889_37921 = state_37867__$1;
(statearr_37889_37921[(2)] = inst_37850);

(statearr_37889_37921[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (16))){
var inst_37853 = (state_37867[(2)]);
var state_37867__$1 = state_37867;
if(cljs.core.truth_(inst_37853)){
var statearr_37890_37922 = state_37867__$1;
(statearr_37890_37922[(1)] = (17));

} else {
var statearr_37891_37923 = state_37867__$1;
(statearr_37891_37923[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (10))){
var inst_37838 = (state_37867[(2)]);
var state_37867__$1 = state_37867;
var statearr_37892_37924 = state_37867__$1;
(statearr_37892_37924[(2)] = inst_37838);

(statearr_37892_37924[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (18))){
var inst_37846 = (state_37867[(12)]);
var state_37867__$1 = state_37867;
var statearr_37893_37925 = state_37867__$1;
(statearr_37893_37925[(2)] = inst_37846);

(statearr_37893_37925[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37868 === (8))){
var state_37867__$1 = state_37867;
var statearr_37894_37926 = state_37867__$1;
(statearr_37894_37926[(2)] = true);

(statearr_37894_37926[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto__,map__37816,map__37816__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__19140__auto__,c__19252__auto__,map__37816,map__37816__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__19141__auto__ = null;
var milia$utils$retry$state_machine__19141__auto____0 = (function (){
var statearr_37898 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37898[(0)] = milia$utils$retry$state_machine__19141__auto__);

(statearr_37898[(1)] = (1));

return statearr_37898;
});
var milia$utils$retry$state_machine__19141__auto____1 = (function (state_37867){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_37867);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e37899){if((e37899 instanceof Object)){
var ex__19144__auto__ = e37899;
var statearr_37900_37927 = state_37867;
(statearr_37900_37927[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37867);

return cljs.core.cst$kw$recur;
} else {
throw e37899;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__37928 = state_37867;
state_37867 = G__37928;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$utils$retry$state_machine__19141__auto__ = function(state_37867){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__19141__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__19141__auto____1.call(this,state_37867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__19141__auto____0;
milia$utils$retry$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__19141__auto____1;
return milia$utils$retry$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__,map__37816,map__37816__$1,options,max_retries,retry_for_statuses))
})();
var state__19254__auto__ = (function (){var statearr_37901 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_37901[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_37901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__,map__37816,map__37816__$1,options,max_retries,retry_for_statuses))
);

return c__19252__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq37812){
var G__37813 = cljs.core.first(seq37812);
var seq37812__$1 = cljs.core.next(seq37812);
var G__37814 = cljs.core.first(seq37812__$1);
var seq37812__$2 = cljs.core.next(seq37812__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__37813,G__37814,seq37812__$2);
});

