// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.user');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
milia.api.user.patch = (function milia$api$user$patch(){
var args__8965__auto__ = [];
var len__8958__auto___15169 = arguments.length;
var i__8959__auto___15170 = (0);
while(true){
if((i__8959__auto___15170 < len__8958__auto___15169)){
args__8965__auto__.push((arguments[i__8959__auto___15170]));

var G__15171 = (i__8959__auto___15170 + (1));
i__8959__auto___15170 = G__15171;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((2) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((2)),(0))):null);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8966__auto__);
});

milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic = (function (username,params,p__15166){
var map__15167 = p__15166;
var map__15167__$1 = ((((!((map__15167 == null)))?((((map__15167.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15167.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15167):map__15167);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15167__$1,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",username], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$json_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$patch,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$as_DASH_map_QMARK_,true,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
});

milia.api.user.patch.cljs$lang$maxFixedArity = (2);

milia.api.user.patch.cljs$lang$applyTo = (function (seq15163){
var G__15164 = cljs.core.first(seq15163);
var seq15163__$1 = cljs.core.next(seq15163);
var G__15165 = cljs.core.first(seq15163__$1);
var seq15163__$2 = cljs.core.next(seq15163__$1);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(G__15164,G__15165,seq15163__$2);
});
/**
 * Return the profile for the account username or the passed username.
 */
milia.api.user.profile = (function milia$api$user$profile(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",username], 0));
var response = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
var temp__4423__auto__ = cljs.core.constant$keyword$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__4423__auto__)){
var error = temp__4423__auto__;
return null;
} else {
return response;
}
});
/**
 * Return the user profile with authentication details.
 */
milia.api.user.user = (function milia$api$user$user(){
var args15172 = [];
var len__8958__auto___15175 = arguments.length;
var i__8959__auto___15176 = (0);
while(true){
if((i__8959__auto___15176 < len__8958__auto___15175)){
args15172.push((arguments[i__8959__auto___15176]));

var G__15177 = (i__8959__auto___15176 + (1));
i__8959__auto___15176 = G__15177;
continue;
} else {
}
break;
}

var G__15174 = args15172.length;
switch (G__15174) {
case 0:
return milia.api.user.user.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return milia.api.user.user.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15172.length)].join('')));

}
});

milia.api.user.user.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.user.user.cljs$core$IFn$_invoke$arity$1(false);
});

milia.api.user.user.cljs$core$IFn$_invoke$arity$1 = (function (suppress_4xx_exceptions_QMARK_){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
});

milia.api.user.user.cljs$lang$maxFixedArity = 1;
/**
 * Create a new user.
 */
milia.api.user.create = (function milia$api$user$create(params){
var profile = cljs.core.select_keys(params,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$first_name,cljs.core.constant$keyword$last_name,cljs.core.constant$keyword$username,cljs.core.constant$keyword$email,cljs.core.constant$keyword$password], null));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,profile], null)], 0));
});
/**
 * return all users
 */
milia.api.user.all = (function milia$api$user$all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * update user profile
 */
milia.api.user.update = (function milia$api$user$update(username,params){
if(cljs.core.truth_(milia.utils.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$city,cljs.core.constant$keyword$country,cljs.core.constant$keyword$email,cljs.core.constant$keyword$gravatar,cljs.core.constant$keyword$last_name,cljs.core.constant$keyword$first_name,cljs.core.constant$keyword$is_org,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$require_auth,cljs.core.constant$keyword$twitter,cljs.core.constant$keyword$url,cljs.core.constant$keyword$user,cljs.core.constant$keyword$username,cljs.core.constant$keyword$website,cljs.core.constant$keyword$organization], null)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"has-keys?","has-keys?",-2012545374,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$city,cljs.core.constant$keyword$country,cljs.core.constant$keyword$email,cljs.core.constant$keyword$gravatar,cljs.core.constant$keyword$last_name,cljs.core.constant$keyword$first_name,cljs.core.constant$keyword$is_org,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$require_auth,cljs.core.constant$keyword$twitter,cljs.core.constant$keyword$url,cljs.core.constant$keyword$user,cljs.core.constant$keyword$username,cljs.core.constant$keyword$website,cljs.core.constant$keyword$organization], null))], 0)))].join('')));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",username], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$put,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,params,cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null),cljs.core.constant$keyword$as_DASH_map_QMARK_,true], 0));
});
/**
 * Change user password
 */
milia.api.user.change_password = (function milia$api$user$change_password(username,current_password,new_password){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",username,"change_password"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$current_password,current_password,cljs.core.constant$keyword$new_password,new_password], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$raw_DASH_response_QMARK_,true,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$as_DASH_map_QMARK_,true], 0));
});
milia.api.user.retrieve_metadata = (function milia$api$user$retrieve_metadata(username){
return cljs.core.constant$keyword$metadata.cljs$core$IFn$_invoke$arity$1(milia.api.user.profile(username));
});
milia.api.user.update_user_metadata = (function milia$api$user$update_user_metadata(username,metadata){
var current_metadata = milia.api.user.retrieve_metadata(username);
var updated_metadata = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([current_metadata,metadata], 0));
return milia.api.user.patch(username,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$metadata,updated_metadata], null));
});
/**
 * Return the users that match this email address
 */
milia.api.user.get_by_email = (function milia$api$user$get_by_email(email){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$search,email], null)], null),cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Trigger a password reset email to the given email and given return URL.
 * Also takes an optional subject for the email message.
 */
milia.api.user.trigger_password_reset_email = (function milia$api$user$trigger_password_reset_email(){
var args15179 = [];
var len__8958__auto___15182 = arguments.length;
var i__8959__auto___15183 = (0);
while(true){
if((i__8959__auto___15183 < len__8958__auto___15182)){
args15179.push((arguments[i__8959__auto___15183]));

var G__15184 = (i__8959__auto___15183 + (1));
i__8959__auto___15183 = G__15184;
continue;
} else {
}
break;
}

var G__15181 = args15179.length;
switch (G__15181) {
case 2:
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15179.length)].join('')));

}
});

milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$2 = (function (email,reset_url){
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3(email,reset_url,null);
});

milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3 = (function (email,reset_url,reset_subject){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user","reset"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$email,email,cljs.core.constant$keyword$reset_url,reset_url], null),(cljs.core.truth_(reset_subject)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$email_subject,reset_subject], null):null)], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,form_params], null)], 0));
});

milia.api.user.trigger_password_reset_email.cljs$lang$maxFixedArity = 3;
milia.api.user.reset_password = (function milia$api$user$reset_password(new_password,token,uid){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user","reset"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$new_password,new_password,cljs.core.constant$keyword$token,token,cljs.core.constant$keyword$uid,uid], null)], null)], 0));
});
/**
 * Change the user's email address
 */
milia.api.user.change_email_address = (function milia$api$user$change_email_address(username,email_address){
var params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$email,email_address], null);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(username,params,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Expire the user's temporary token.
 */
milia.api.user.expire_temp_token = (function milia$api$user$expire_temp_token(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user","expire"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$delete,url);
});
