// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('milia.utils.retry');
goog.require('milia.api.dataset');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28730 = arguments.length;
var i__4865__auto___28731 = (0);
while(true){
if((i__4865__auto___28731 < len__4864__auto___28730)){
args__4870__auto__.push((arguments[i__4865__auto___28731]));

var G__28732 = (i__4865__auto___28731 + (1));
i__4865__auto___28731 = G__28732;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"temp_token=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([temp_token], 0)):s));
}));

(milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq28729){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28729));
}));

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__28733,p__28734){
var map__28735 = p__28733;
var map__28735__$1 = cljs.core.__destructure_map(map__28735);
var response = map__28735__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28735__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28735__$1,cljs.core.cst$kw$body);
var map__28736 = p__28734;
var map__28736__$1 = cljs.core.__destructure_map(map__28736);
var callbacks = map__28736__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28736__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28736__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28736__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28736__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__28737 = body;
var map__28737__$1 = cljs.core.__destructure_map(map__28737);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28737__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28737__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28737__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});
var error_detail = (function (){var or__4253__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
if(is_failed_status_QMARK_()){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if((((status >= (400))) || (is_failed_status_QMARK_()))){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__28738_28740 = error_detail;
var G__28739_28741 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__28738_28740,G__28739_28741) : on_error.call(null,G__28738_28740,G__28739_28741));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28790 = arguments.length;
var i__4865__auto___28791 = (0);
while(true){
if((i__4865__auto___28791 < len__4864__auto___28790)){
args__4870__auto__.push((arguments[i__4865__auto___28791]));

var G__28792 = (i__4865__auto___28791 + (1));
i__4865__auto___28791 = G__28792;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__28745){
var map__28746 = p__28745;
var map__28746__$1 = cljs.core.__destructure_map(map__28746);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28746__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28746__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28746__$1,cljs.core.cst$kw$data_DASH_type);
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_28774){
var state_val_28775 = (state_28774[(1)]);
if((state_val_28775 === (1))){
var inst_28747 = milia.api.async_export.initial_polling_interval;
var inst_28748 = inst_28747;
var state_28774__$1 = (function (){var statearr_28776 = state_28774;
(statearr_28776[(7)] = inst_28748);

return statearr_28776;
})();
var statearr_28777_28793 = state_28774__$1;
(statearr_28777_28793[(2)] = null);

(statearr_28777_28793[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28775 === (2))){
var inst_28750 = (state_28774[(8)]);
var inst_28752 = (state_28774[(9)]);
var inst_28750__$1 = ["export_async.json?job_uuid=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(job_id)].join('');
var inst_28751 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_28752__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28751,dataset_id,inst_28750__$1], 0));
var inst_28753 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_28752__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_28774__$1 = (function (){var statearr_28778 = state_28774;
(statearr_28778[(8)] = inst_28750__$1);

(statearr_28778[(9)] = inst_28752__$1);

return statearr_28778;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28774__$1,(4),inst_28753);
} else {
if((state_val_28775 === (3))){
var inst_28772 = (state_28774[(2)]);
var state_28774__$1 = state_28774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28774__$1,inst_28772);
} else {
if((state_val_28775 === (4))){
var inst_28748 = (state_28774[(7)]);
var inst_28750 = (state_28774[(8)]);
var inst_28752 = (state_28774[(9)]);
var inst_28755 = (state_28774[(2)]);
var inst_28756 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_28757 = (function (){var polling_interval = inst_28748;
var job_suffix = inst_28750;
var job_url = inst_28752;
var response = inst_28755;
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
})();
var inst_28758 = [inst_28757,on_error,on_export_url];
var inst_28759 = cljs.core.PersistentHashMap.fromArrays(inst_28756,inst_28758);
var inst_28760 = milia.api.async_export.handle_response(inst_28755,inst_28759);
var inst_28761 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_28760,cljs.core.cst$kw$stop);
var state_28774__$1 = state_28774;
if(inst_28761){
var statearr_28779_28794 = state_28774__$1;
(statearr_28779_28794[(1)] = (5));

} else {
var statearr_28780_28795 = state_28774__$1;
(statearr_28780_28795[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28775 === (5))){
var inst_28748 = (state_28774[(7)]);
var inst_28763 = cljs.core.async.timeout(inst_28748);
var state_28774__$1 = state_28774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28774__$1,(8),inst_28763);
} else {
if((state_val_28775 === (6))){
var state_28774__$1 = state_28774;
var statearr_28781_28796 = state_28774__$1;
(statearr_28781_28796[(2)] = null);

(statearr_28781_28796[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28775 === (7))){
var inst_28770 = (state_28774[(2)]);
var state_28774__$1 = state_28774;
var statearr_28782_28797 = state_28774__$1;
(statearr_28782_28797[(2)] = inst_28770);

(statearr_28782_28797[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28775 === (8))){
var inst_28748 = (state_28774[(7)]);
var inst_28765 = (state_28774[(2)]);
var inst_28766 = (inst_28748 * (2));
var inst_28748__$1 = inst_28766;
var state_28774__$1 = (function (){var statearr_28783 = state_28774;
(statearr_28783[(10)] = inst_28765);

(statearr_28783[(7)] = inst_28748__$1);

return statearr_28783;
})();
var statearr_28784_28798 = state_28774__$1;
(statearr_28784_28798[(2)] = null);

(statearr_28784_28798[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var milia$api$async_export$state_machine__24176__auto__ = null;
var milia$api$async_export$state_machine__24176__auto____0 = (function (){
var statearr_28785 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28785[(0)] = milia$api$async_export$state_machine__24176__auto__);

(statearr_28785[(1)] = (1));

return statearr_28785;
});
var milia$api$async_export$state_machine__24176__auto____1 = (function (state_28774){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_28774);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e28786){var ex__24179__auto__ = e28786;
var statearr_28787_28799 = state_28774;
(statearr_28787_28799[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_28774[(4)]))){
var statearr_28788_28800 = state_28774;
(statearr_28788_28800[(1)] = cljs.core.first((state_28774[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__28801 = state_28774;
state_28774 = G__28801;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
milia$api$async_export$state_machine__24176__auto__ = function(state_28774){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__24176__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__24176__auto____1.call(this,state_28774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__24176__auto____0;
milia$api$async_export$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__24176__auto____1;
return milia$api$async_export$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_28789 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_28789[(6)] = c__24250__auto__);

return statearr_28789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
}));

(milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq28742){
var G__28743 = cljs.core.first(seq28742);
var seq28742__$1 = cljs.core.next(seq28742);
var G__28744 = cljs.core.first(seq28742__$1);
var seq28742__$2 = cljs.core.next(seq28742__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28743,G__28744,seq28742__$2);
}));

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_28832){
var state_val_28833 = (state_28832[(1)]);
if((state_val_28833 === (1))){
var inst_28803 = milia.api.async_export.initial_polling_interval;
var inst_28804 = inst_28803;
var state_28832__$1 = (function (){var statearr_28834 = state_28832;
(statearr_28834[(7)] = inst_28804);

return statearr_28834;
})();
var statearr_28835_28849 = state_28832__$1;
(statearr_28835_28849[(2)] = null);

(statearr_28835_28849[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28833 === (2))){
var inst_28808 = (state_28832[(8)]);
var inst_28807 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["export.json?xform=",dataset_id,"&"], 0));
var inst_28808__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28807], 0));
var inst_28809 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_28808__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_28832__$1 = (function (){var statearr_28836 = state_28832;
(statearr_28836[(8)] = inst_28808__$1);

return statearr_28836;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28832__$1,(4),inst_28809);
} else {
if((state_val_28833 === (3))){
var inst_28830 = (state_28832[(2)]);
var state_28832__$1 = state_28832;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28832__$1,inst_28830);
} else {
if((state_val_28833 === (4))){
var inst_28804 = (state_28832[(7)]);
var inst_28814 = (state_28832[(9)]);
var inst_28808 = (state_28832[(8)]);
var inst_28811 = (state_28832[(2)]);
var inst_28812 = cljs.core.__destructure_map(inst_28811);
var inst_28813 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28812,cljs.core.cst$kw$status);
var inst_28814__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28812,cljs.core.cst$kw$body);
var inst_28815 = (function (){var polling_interval = inst_28804;
var export_url = inst_28808;
var map__28806 = inst_28812;
var status = inst_28813;
var body = inst_28814__$1;
return (function (p1__28802_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__28802_SHARP_),milia.api.async_export.export_pending_status_msg);
});
})();
var inst_28816 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28815,inst_28814__$1);
var inst_28817 = cljs.core.vec(inst_28816);
var inst_28818 = cljs.core.empty_QMARK_(inst_28817);
var state_28832__$1 = (function (){var statearr_28837 = state_28832;
(statearr_28837[(9)] = inst_28814__$1);

return statearr_28837;
})();
if(inst_28818){
var statearr_28838_28850 = state_28832__$1;
(statearr_28838_28850[(1)] = (5));

} else {
var statearr_28839_28851 = state_28832__$1;
(statearr_28839_28851[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28833 === (5))){
var inst_28814 = (state_28832[(9)]);
var inst_28820 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_28814) : callback.call(null,inst_28814));
var state_28832__$1 = state_28832;
var statearr_28840_28852 = state_28832__$1;
(statearr_28840_28852[(2)] = inst_28820);

(statearr_28840_28852[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28833 === (6))){
var inst_28804 = (state_28832[(7)]);
var inst_28822 = cljs.core.async.timeout(inst_28804);
var state_28832__$1 = state_28832;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28832__$1,(8),inst_28822);
} else {
if((state_val_28833 === (7))){
var inst_28828 = (state_28832[(2)]);
var state_28832__$1 = state_28832;
var statearr_28841_28853 = state_28832__$1;
(statearr_28841_28853[(2)] = inst_28828);

(statearr_28841_28853[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28833 === (8))){
var inst_28804 = (state_28832[(7)]);
var inst_28824 = (state_28832[(2)]);
var inst_28825 = (inst_28804 * (2));
var inst_28804__$1 = inst_28825;
var state_28832__$1 = (function (){var statearr_28842 = state_28832;
(statearr_28842[(7)] = inst_28804__$1);

(statearr_28842[(10)] = inst_28824);

return statearr_28842;
})();
var statearr_28843_28854 = state_28832__$1;
(statearr_28843_28854[(2)] = null);

(statearr_28843_28854[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto____0 = (function (){
var statearr_28844 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28844[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto__);

(statearr_28844[(1)] = (1));

return statearr_28844;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto____1 = (function (state_28832){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_28832);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e28845){var ex__24179__auto__ = e28845;
var statearr_28846_28855 = state_28832;
(statearr_28846_28855[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_28832[(4)]))){
var statearr_28847_28856 = state_28832;
(statearr_28847_28856[(1)] = cljs.core.first((state_28832[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__28857 = state_28832;
state_28832 = G__28857;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto__ = function(state_28832){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto____1.call(this,state_28832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_28848 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_28848[(6)] = c__24250__auto__);

return statearr_28848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri","binary_select_multiples","value_select_multiples","show_choice_labels","include_reviews","language"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri,cljs.core.cst$kw$binary_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$value_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$show_DASH_choice_DASH_labels_QMARK_,cljs.core.cst$kw$include_DASH_reviews_QMARK_,cljs.core.cst$kw$language], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return ["&",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__4253__auto__ = value;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28866 = arguments.length;
var i__4865__auto___28867 = (0);
while(true){
if((i__4865__auto___28867 < len__4864__auto___28866)){
args__4870__auto__.push((arguments[i__4865__auto___28867]));

var G__28868 = (i__4865__auto___28867 + (1));
i__4865__auto___28867 = G__28868;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__28861){
var vec__28862 = p__28861;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28862,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,(function (){var fexpr__28865 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values);
return (fexpr__28865.cljs$core$IFn$_invoke$arity$1 ? fexpr__28865.cljs$core$IFn$_invoke$arity$1(export_options) : fexpr__28865.call(null,export_options));
})())));
}));

(milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq28858){
var G__28859 = cljs.core.first(seq28858);
var seq28858__$1 = cljs.core.next(seq28858);
var G__28860 = cljs.core.first(seq28858__$1);
var seq28858__$2 = cljs.core.next(seq28858__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28859,G__28860,seq28858__$2);
}));

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28915 = arguments.length;
var i__4865__auto___28916 = (0);
while(true){
if((i__4865__auto___28916 < len__4864__auto___28915)){
args__4870__auto__.push((arguments[i__4865__auto___28916]));

var G__28917 = (i__4865__auto___28916 + (1));
i__4865__auto___28916 = G__28917;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__28871){
var vec__28872 = p__28871;
var map__28875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28872,(0),null);
var map__28875__$1 = cljs.core.__destructure_map(map__28875);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28875__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28875__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28875__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28875__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28875__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28875__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28875__$1,cljs.core.cst$kw$on_DASH_done);
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_28897){
var state_val_28898 = (state_28897[(1)]);
if((state_val_28898 === (1))){
var inst_28876 = (state_28897[(7)]);
var inst_28878 = (state_28897[(8)]);
var inst_28876__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([export_options], 0));
var inst_28877 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_28878__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28877,dataset_id,inst_28876__$1], 0));
var inst_28879 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_28878__$1);
var state_28897__$1 = (function (){var statearr_28899 = state_28897;
(statearr_28899[(7)] = inst_28876__$1);

(statearr_28899[(8)] = inst_28878__$1);

return statearr_28899;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28897__$1,(2),inst_28879);
} else {
if((state_val_28898 === (2))){
var inst_28881 = (state_28897[(9)]);
var inst_28876 = (state_28897[(7)]);
var inst_28878 = (state_28897[(8)]);
var inst_28881__$1 = (state_28897[(2)]);
var inst_28882 = (function (){var export_suffix = inst_28876;
var export_url = inst_28878;
var response = inst_28881__$1;
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
})();
var state_28897__$1 = (function (){var statearr_28900 = state_28897;
(statearr_28900[(9)] = inst_28881__$1);

(statearr_28900[(10)] = inst_28882);

return statearr_28900;
})();
if(cljs.core.truth_(on_done)){
var statearr_28901_28918 = state_28897__$1;
(statearr_28901_28918[(1)] = (3));

} else {
var statearr_28902_28919 = state_28897__$1;
(statearr_28902_28919[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28898 === (3))){
var inst_28881 = (state_28897[(9)]);
var inst_28884 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_28881) : on_done.call(null,inst_28881));
var state_28897__$1 = state_28897;
var statearr_28903_28920 = state_28897__$1;
(statearr_28903_28920[(2)] = inst_28884);

(statearr_28903_28920[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28898 === (4))){
var state_28897__$1 = state_28897;
var statearr_28904_28921 = state_28897__$1;
(statearr_28904_28921[(2)] = null);

(statearr_28904_28921[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28898 === (5))){
var inst_28887 = (state_28897[(2)]);
var inst_28888 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_28897__$1 = (function (){var statearr_28905 = state_28897;
(statearr_28905[(11)] = inst_28888);

(statearr_28905[(12)] = inst_28887);

return statearr_28905;
})();
if(cljs.core.truth_(on_done)){
var statearr_28906_28922 = state_28897__$1;
(statearr_28906_28922[(1)] = (6));

} else {
var statearr_28907_28923 = state_28897__$1;
(statearr_28907_28923[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28898 === (6))){
var state_28897__$1 = state_28897;
var statearr_28908_28924 = state_28897__$1;
(statearr_28908_28924[(2)] = on_job_id);

(statearr_28908_28924[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28898 === (7))){
var inst_28882 = (state_28897[(10)]);
var state_28897__$1 = state_28897;
var statearr_28909_28925 = state_28897__$1;
(statearr_28909_28925[(2)] = inst_28882);

(statearr_28909_28925[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28898 === (8))){
var inst_28888 = (state_28897[(11)]);
var inst_28881 = (state_28897[(9)]);
var inst_28892 = (state_28897[(2)]);
var inst_28893 = [on_error,inst_28892,on_export_url];
var inst_28894 = cljs.core.PersistentHashMap.fromArrays(inst_28888,inst_28893);
var inst_28895 = milia.api.async_export.handle_response(inst_28881,inst_28894);
var state_28897__$1 = state_28897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28897__$1,inst_28895);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var milia$api$async_export$state_machine__24176__auto__ = null;
var milia$api$async_export$state_machine__24176__auto____0 = (function (){
var statearr_28910 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28910[(0)] = milia$api$async_export$state_machine__24176__auto__);

(statearr_28910[(1)] = (1));

return statearr_28910;
});
var milia$api$async_export$state_machine__24176__auto____1 = (function (state_28897){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_28897);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e28911){var ex__24179__auto__ = e28911;
var statearr_28912_28926 = state_28897;
(statearr_28912_28926[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_28897[(4)]))){
var statearr_28913_28927 = state_28897;
(statearr_28913_28927[(1)] = cljs.core.first((state_28897[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__28928 = state_28897;
state_28897 = G__28928;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
milia$api$async_export$state_machine__24176__auto__ = function(state_28897){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__24176__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__24176__auto____1.call(this,state_28897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__24176__auto____0;
milia$api$async_export$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__24176__auto____1;
return milia$api$async_export$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_28914 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_28914[(6)] = c__24250__auto__);

return statearr_28914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
}));

(milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq28869){
var G__28870 = cljs.core.first(seq28869);
var seq28869__$1 = cljs.core.next(seq28869);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28870,seq28869__$1);
}));

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,(function (p1__28929_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__28929_SHARP_);
})], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28952 = arguments.length;
var i__4865__auto___28953 = (0);
while(true){
if((i__4865__auto___28953 < len__4864__auto___28952)){
args__4870__auto__.push((arguments[i__4865__auto___28953]));

var G__28954 = (i__4865__auto___28953 + (1));
i__4865__auto___28953 = G__28954;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_28945){
var state_val_28946 = (state_28945[(1)]);
if((state_val_28946 === (1))){
var inst_28934 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_28945__$1 = state_28945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28945__$1,(2),inst_28934);
} else {
if((state_val_28946 === (2))){
var inst_28936 = (state_28945[(2)]);
var inst_28937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28938 = [http_method,inst_28936];
var inst_28939 = (new cljs.core.PersistentVector(null,2,(5),inst_28937,inst_28938,null));
var inst_28940 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28939,args);
var inst_28941 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_28940);
var state_28945__$1 = state_28945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28945__$1,(3),inst_28941);
} else {
if((state_val_28946 === (3))){
var inst_28943 = (state_28945[(2)]);
var state_28945__$1 = state_28945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28945__$1,inst_28943);
} else {
return null;
}
}
}
});
return (function() {
var milia$api$async_export$state_machine__24176__auto__ = null;
var milia$api$async_export$state_machine__24176__auto____0 = (function (){
var statearr_28947 = [null,null,null,null,null,null,null];
(statearr_28947[(0)] = milia$api$async_export$state_machine__24176__auto__);

(statearr_28947[(1)] = (1));

return statearr_28947;
});
var milia$api$async_export$state_machine__24176__auto____1 = (function (state_28945){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_28945);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e28948){var ex__24179__auto__ = e28948;
var statearr_28949_28955 = state_28945;
(statearr_28949_28955[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_28945[(4)]))){
var statearr_28950_28956 = state_28945;
(statearr_28950_28956[(1)] = cljs.core.first((state_28945[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__28957 = state_28945;
state_28945 = G__28957;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
milia$api$async_export$state_machine__24176__auto__ = function(state_28945){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__24176__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__24176__auto____1.call(this,state_28945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__24176__auto____0;
milia$api$async_export$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__24176__auto____1;
return milia$api$async_export$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_28951 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_28951[(6)] = c__24250__auto__);

return statearr_28951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
}));

(milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq28930){
var G__28931 = cljs.core.first(seq28930);
var seq28930__$1 = cljs.core.next(seq28930);
var G__28932 = cljs.core.first(seq28930__$1);
var seq28930__$2 = cljs.core.next(seq28930__$1);
var G__28933 = cljs.core.first(seq28930__$2);
var seq28930__$3 = cljs.core.next(seq28930__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28931,G__28932,G__28933,seq28930__$3);
}));

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["export.json?xform=",dataset_id,"&"], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([export_id,"?"], 0))], 0)));
});
