// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.organization');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('cljs.core.async');
milia.api.organization.internal_members_team_name = "members";
milia.api.organization.owners_team_name = "Owners";
milia.api.organization.editor_role = "editor";
/**
 * List all the organizations belonging to the account making the request.
 * When a username is provided, return only those organizations shared by both
 * the account making the request and the user associated with the username.
 */
milia.api.organization.all = (function milia$api$organization$all(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28435 = arguments.length;
var i__4865__auto___28436 = (0);
while(true){
if((i__4865__auto___28436 < len__4864__auto___28435)){
args__4870__auto__.push((arguments[i__4865__auto___28436]));

var G__28437 = (i__4865__auto___28436 + (1));
i__4865__auto___28436 = G__28437;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic = (function (p__28431){
var vec__28432 = p__28431;
var username = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28432,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(cljs.core.truth_(username)?["orgs.json?shared_with=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(username)].join(''):"orgs.json")], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
}));

(milia.api.organization.all.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.organization.all.cljs$lang$applyTo = (function (seq28430){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28430));
}));

milia.api.organization.create = (function milia$api$organization$create(data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["orgs.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
milia.api.organization.profile = (function milia$api$organization$profile(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28442 = arguments.length;
var i__4865__auto___28443 = (0);
while(true){
if((i__4865__auto___28443 < len__4864__auto___28442)){
args__4870__auto__.push((arguments[i__4865__auto___28443]));

var G__28444 = (i__4865__auto___28443 + (1));
i__4865__auto___28443 = G__28444;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic = (function (org_name,p__28440){
var map__28441 = p__28440;
var map__28441__$1 = cljs.core.__destructure_map(map__28441);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28441__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["orgs",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(org_name),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

(milia.api.organization.profile.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.organization.profile.cljs$lang$applyTo = (function (seq28438){
var G__28439 = cljs.core.first(seq28438);
var seq28438__$1 = cljs.core.next(seq28438);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28439,seq28438__$1);
}));

milia.api.organization.retrieve_org_metadata = (function milia$api$organization$retrieve_org_metadata(username){
return cljs.core.cst$kw$metadata.cljs$core$IFn$_invoke$arity$1(milia.api.organization.profile(username));
});
/**
 * Return whether a user can create projects within an organization
 */
milia.api.organization.can_user_create_project_under_organization_QMARK_ = (function milia$api$organization$can_user_create_project_under_organization_QMARK_(username_to_check,organization){
var role = cljs.core.cst$kw$role.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28445_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$user.cljs$core$IFn$_invoke$arity$1(p1__28445_SHARP_),username_to_check);
}),cljs.core.cst$kw$users.cljs$core$IFn$_invoke$arity$1(organization))));
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(role,"manager")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(role,"owner")));
});
milia.api.organization.get_organizations_where_user_can_create_projects = (function milia$api$organization$get_organizations_where_user_can_create_projects(username_to_check){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28446_SHARP_){
return milia.api.organization.can_user_create_project_under_organization_QMARK_(username_to_check,p1__28446_SHARP_);
}),milia.api.organization.all());
});
/**
 * Return all the teams for an organization.
 */
milia.api.organization.teams_all = (function milia$api$organization$teams_all(var_args){
var G__28448 = arguments.length;
switch (G__28448) {
case 0:
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1(null);
}));

(milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1 = (function (organization_name){
var base_url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["teams.json"], 0));
var url = (cljs.core.truth_(organization_name)?[base_url,"?org=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(organization_name)].join(''):base_url);
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
}));

(milia.api.organization.teams_all.cljs$lang$maxFixedArity = 1);

/**
 * Return the teams for an organization, removing 'members' team that is used
 * internall by the API to store non-team based org members.
 */
milia.api.organization.teams = (function milia$api$organization$teams(org_name){
var teams = milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0();
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__28450_SHARP_){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.internal_members_team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__28450_SHARP_))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(org_name,cljs.core.cst$kw$organization.cljs$core$IFn$_invoke$arity$1(p1__28450_SHARP_))));
}),teams);
});
milia.api.organization.team_info = (function milia$api$organization$team_info(org_name,team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["teams",org_name,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(team_id),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.organization.team_members = (function milia$api$organization$team_members(team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["teams",team_id,"members.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add a team to an organization
 */
milia.api.organization.create_team = (function milia$api$organization$create_team(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["teams.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Add a user to a team
 */
milia.api.organization.add_team_member = (function milia$api$organization$add_team_member(org_name,team_id,user){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["teams",org_name,team_id,"members.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,user], null)], 0));
});
milia.api.organization.members = (function milia$api$organization$members(org_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["orgs",org_name,"members.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add a user to an organization
 */
milia.api.organization.add_member = (function milia$api$organization$add_member(var_args){
var G__28452 = arguments.length;
switch (G__28452) {
case 2:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
}));

(milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["orgs",org_name,"members.json"], 0));
var assigned_role = (function (){var or__4253__auto__ = role;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return milia.api.organization.editor_role;
}
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,member,cljs.core.cst$kw$role,assigned_role], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
}));

(milia.api.organization.add_member.cljs$lang$maxFixedArity = 3);

/**
 * Change the role of an organization member
 */
milia.api.organization.change_org_member_role = (function milia$api$organization$change_org_member_role(member,org_name,event_chan){
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,cljs.core.cst$kw$username.cljs$core$IFn$_invoke$arity$1(member),cljs.core.cst$kw$role,cljs.core.cst$kw$role.cljs$core$IFn$_invoke$arity$1(member)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["orgs",org_name,"members.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$callback,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$updated_DASH_member,member], null));
}),cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Remove a user from an organization or organization team
 */
milia.api.organization.remove_member = (function milia$api$organization$remove_member(var_args){
var G__28455 = arguments.length;
switch (G__28455) {
case 2:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
}));

(milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,team_id){
var url = (cljs.core.truth_(team_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["teams",org_name,team_id,"members.json"], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["orgs",org_name,"members.json"], 0)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,member], null)], null)], 0));
}));

(milia.api.organization.remove_member.cljs$lang$maxFixedArity = 3);

/**
 * Is the user the only member of the Owners team.
 */
milia.api.organization.single_owner_QMARK_ = (function milia$api$organization$single_owner_QMARK_(team,members){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.owners_team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(team))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(members))));
});
/**
 * Is user only members in org with owner role?
 */
milia.api.organization.single_owner_member_QMARK_ = (function milia$api$organization$single_owner_member_QMARK_(org_name){
var org = milia.api.organization.profile(org_name);
var users = cljs.core.cst$kw$users.cljs$core$IFn$_invoke$arity$1(org);
var owner_roles = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28457_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("owner",p1__28457_SHARP_);
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$role,users));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(owner_roles),(1));
});
/**
 * update organization profile
 */
milia.api.organization.update = (function milia$api$organization$update(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["orgs",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$org.cljs$core$IFn$_invoke$arity$1(params)),".json"].join('')], 0));
var params__$1 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(params,cljs.core.cst$kw$org);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,params__$1], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Returns an Organizaion team given the team name.
 */
milia.api.organization.get_team = (function milia$api$organization$get_team(org_name,team_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["teams.json?org=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(org_name)].join('')], 0));
var teams = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
return cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__28458_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__28458_SHARP_));
}),teams));
});
/**
 * Changes default_role permissions on a project for a team
 */
milia.api.organization.share_team = (function milia$api$organization$share_team(team_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["teams",team_id,"share.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
