// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__24310 = arguments.length;
switch (G__24310) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24311 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24311 = (function (f,blockable,meta24312){
this.f = f;
this.blockable = blockable;
this.meta24312 = meta24312;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24311.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24313,meta24312__$1){
var self__ = this;
var _24313__$1 = this;
return (new cljs.core.async.t_cljs$core$async24311(self__.f,self__.blockable,meta24312__$1));
}));

(cljs.core.async.t_cljs$core$async24311.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24313){
var self__ = this;
var _24313__$1 = this;
return self__.meta24312;
}));

(cljs.core.async.t_cljs$core$async24311.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24311.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async24311.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async24311.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async24311.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta24312], null);
}));

(cljs.core.async.t_cljs$core$async24311.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24311.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24311");

(cljs.core.async.t_cljs$core$async24311.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async24311");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24311.
 */
cljs.core.async.__GT_t_cljs$core$async24311 = (function cljs$core$async$__GT_t_cljs$core$async24311(f__$1,blockable__$1,meta24312){
return (new cljs.core.async.t_cljs$core$async24311(f__$1,blockable__$1,meta24312));
});

}

return (new cljs.core.async.t_cljs$core$async24311(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__24317 = arguments.length;
switch (G__24317) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__24320 = arguments.length;
switch (G__24320) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__24323 = arguments.length;
switch (G__24323) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_24325 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_24325) : fn1.call(null,val_24325));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_24325) : fn1.call(null,val_24325));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__24327 = arguments.length;
switch (G__24327) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___24329 = n;
var x_24330 = (0);
while(true){
if((x_24330 < n__4741__auto___24329)){
(a[x_24330] = x_24330);

var G__24331 = (x_24330 + (1));
x_24330 = G__24331;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24332 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24332 = (function (flag,meta24333){
this.flag = flag;
this.meta24333 = meta24333;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24332.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24334,meta24333__$1){
var self__ = this;
var _24334__$1 = this;
return (new cljs.core.async.t_cljs$core$async24332(self__.flag,meta24333__$1));
}));

(cljs.core.async.t_cljs$core$async24332.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24334){
var self__ = this;
var _24334__$1 = this;
return self__.meta24333;
}));

(cljs.core.async.t_cljs$core$async24332.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24332.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async24332.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async24332.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async24332.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta24333], null);
}));

(cljs.core.async.t_cljs$core$async24332.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24332.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24332");

(cljs.core.async.t_cljs$core$async24332.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async24332");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24332.
 */
cljs.core.async.__GT_t_cljs$core$async24332 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async24332(flag__$1,meta24333){
return (new cljs.core.async.t_cljs$core$async24332(flag__$1,meta24333));
});

}

return (new cljs.core.async.t_cljs$core$async24332(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24335 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24335 = (function (flag,cb,meta24336){
this.flag = flag;
this.cb = cb;
this.meta24336 = meta24336;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24335.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24337,meta24336__$1){
var self__ = this;
var _24337__$1 = this;
return (new cljs.core.async.t_cljs$core$async24335(self__.flag,self__.cb,meta24336__$1));
}));

(cljs.core.async.t_cljs$core$async24335.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24337){
var self__ = this;
var _24337__$1 = this;
return self__.meta24336;
}));

(cljs.core.async.t_cljs$core$async24335.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24335.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async24335.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async24335.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async24335.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta24336], null);
}));

(cljs.core.async.t_cljs$core$async24335.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24335.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24335");

(cljs.core.async.t_cljs$core$async24335.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async24335");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24335.
 */
cljs.core.async.__GT_t_cljs$core$async24335 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async24335(flag__$1,cb__$1,meta24336){
return (new cljs.core.async.t_cljs$core$async24335(flag__$1,cb__$1,meta24336));
});

}

return (new cljs.core.async.t_cljs$core$async24335(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__24338_SHARP_){
var G__24340 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24338_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__24340) : fret.call(null,G__24340));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__24339_SHARP_){
var G__24341 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24339_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__24341) : fret.call(null,G__24341));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__24342 = (i + (1));
i = G__24342;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___24347 = arguments.length;
var i__4865__auto___24348 = (0);
while(true){
if((i__4865__auto___24348 < len__4864__auto___24347)){
args__4870__auto__.push((arguments[i__4865__auto___24348]));

var G__24349 = (i__4865__auto___24348 + (1));
i__4865__auto___24348 = G__24349;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__24345){
var map__24346 = p__24345;
var map__24346__$1 = cljs.core.__destructure_map(map__24346);
var opts = map__24346__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq24343){
var G__24344 = cljs.core.first(seq24343);
var seq24343__$1 = cljs.core.next(seq24343);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__24344,seq24343__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__24351 = arguments.length;
switch (G__24351) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__24250__auto___24398 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_24375){
var state_val_24376 = (state_24375[(1)]);
if((state_val_24376 === (7))){
var inst_24371 = (state_24375[(2)]);
var state_24375__$1 = state_24375;
var statearr_24377_24399 = state_24375__$1;
(statearr_24377_24399[(2)] = inst_24371);

(statearr_24377_24399[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (1))){
var state_24375__$1 = state_24375;
var statearr_24378_24400 = state_24375__$1;
(statearr_24378_24400[(2)] = null);

(statearr_24378_24400[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (4))){
var inst_24354 = (state_24375[(7)]);
var inst_24354__$1 = (state_24375[(2)]);
var inst_24355 = (inst_24354__$1 == null);
var state_24375__$1 = (function (){var statearr_24379 = state_24375;
(statearr_24379[(7)] = inst_24354__$1);

return statearr_24379;
})();
if(cljs.core.truth_(inst_24355)){
var statearr_24380_24401 = state_24375__$1;
(statearr_24380_24401[(1)] = (5));

} else {
var statearr_24381_24402 = state_24375__$1;
(statearr_24381_24402[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (13))){
var state_24375__$1 = state_24375;
var statearr_24382_24403 = state_24375__$1;
(statearr_24382_24403[(2)] = null);

(statearr_24382_24403[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (6))){
var inst_24354 = (state_24375[(7)]);
var state_24375__$1 = state_24375;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24375__$1,(11),to,inst_24354);
} else {
if((state_val_24376 === (3))){
var inst_24373 = (state_24375[(2)]);
var state_24375__$1 = state_24375;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24375__$1,inst_24373);
} else {
if((state_val_24376 === (12))){
var state_24375__$1 = state_24375;
var statearr_24383_24404 = state_24375__$1;
(statearr_24383_24404[(2)] = null);

(statearr_24383_24404[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (2))){
var state_24375__$1 = state_24375;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24375__$1,(4),from);
} else {
if((state_val_24376 === (11))){
var inst_24364 = (state_24375[(2)]);
var state_24375__$1 = state_24375;
if(cljs.core.truth_(inst_24364)){
var statearr_24384_24405 = state_24375__$1;
(statearr_24384_24405[(1)] = (12));

} else {
var statearr_24385_24406 = state_24375__$1;
(statearr_24385_24406[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (9))){
var state_24375__$1 = state_24375;
var statearr_24386_24407 = state_24375__$1;
(statearr_24386_24407[(2)] = null);

(statearr_24386_24407[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (5))){
var state_24375__$1 = state_24375;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24387_24408 = state_24375__$1;
(statearr_24387_24408[(1)] = (8));

} else {
var statearr_24388_24409 = state_24375__$1;
(statearr_24388_24409[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (14))){
var inst_24369 = (state_24375[(2)]);
var state_24375__$1 = state_24375;
var statearr_24389_24410 = state_24375__$1;
(statearr_24389_24410[(2)] = inst_24369);

(statearr_24389_24410[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (10))){
var inst_24361 = (state_24375[(2)]);
var state_24375__$1 = state_24375;
var statearr_24390_24411 = state_24375__$1;
(statearr_24390_24411[(2)] = inst_24361);

(statearr_24390_24411[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24376 === (8))){
var inst_24358 = cljs.core.async.close_BANG_(to);
var state_24375__$1 = state_24375;
var statearr_24391_24412 = state_24375__$1;
(statearr_24391_24412[(2)] = inst_24358);

(statearr_24391_24412[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_24392 = [null,null,null,null,null,null,null,null];
(statearr_24392[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_24392[(1)] = (1));

return statearr_24392;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_24375){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24375);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24393){var ex__24179__auto__ = e24393;
var statearr_24394_24413 = state_24375;
(statearr_24394_24413[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24375[(4)]))){
var statearr_24395_24414 = state_24375;
(statearr_24395_24414[(1)] = cljs.core.first((state_24375[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24415 = state_24375;
state_24375 = G__24415;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_24375){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_24375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_24396 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24396[(6)] = c__24250__auto___24398);

return statearr_24396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__24416){
var vec__24417 = p__24416;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24417,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24417,(1),null);
var job = vec__24417;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__24250__auto___24593 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_24424){
var state_val_24425 = (state_24424[(1)]);
if((state_val_24425 === (1))){
var state_24424__$1 = state_24424;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24424__$1,(2),res,v);
} else {
if((state_val_24425 === (2))){
var inst_24421 = (state_24424[(2)]);
var inst_24422 = cljs.core.async.close_BANG_(res);
var state_24424__$1 = (function (){var statearr_24426 = state_24424;
(statearr_24426[(7)] = inst_24421);

return statearr_24426;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24424__$1,inst_24422);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0 = (function (){
var statearr_24427 = [null,null,null,null,null,null,null,null];
(statearr_24427[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__);

(statearr_24427[(1)] = (1));

return statearr_24427;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1 = (function (state_24424){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24424);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24428){var ex__24179__auto__ = e24428;
var statearr_24429_24594 = state_24424;
(statearr_24429_24594[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24424[(4)]))){
var statearr_24430_24595 = state_24424;
(statearr_24430_24595[(1)] = cljs.core.first((state_24424[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24596 = state_24424;
state_24424 = G__24596;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = function(state_24424){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1.call(this,state_24424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_24431 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24431[(6)] = c__24250__auto___24593);

return statearr_24431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__24432){
var vec__24433 = p__24432;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24433,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24433,(1),null);
var job = vec__24433;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___24597 = n;
var __24598 = (0);
while(true){
if((__24598 < n__4741__auto___24597)){
var G__24436_24599 = type;
var G__24436_24600__$1 = (((G__24436_24599 instanceof cljs.core.Keyword))?G__24436_24599.fqn:null);
switch (G__24436_24600__$1) {
case "compute":
var c__24250__auto___24602 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__24598,c__24250__auto___24602,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async){
return (function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = ((function (__24598,c__24250__auto___24602,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async){
return (function (state_24449){
var state_val_24450 = (state_24449[(1)]);
if((state_val_24450 === (1))){
var state_24449__$1 = state_24449;
var statearr_24451_24603 = state_24449__$1;
(statearr_24451_24603[(2)] = null);

(statearr_24451_24603[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24450 === (2))){
var state_24449__$1 = state_24449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24449__$1,(4),jobs);
} else {
if((state_val_24450 === (3))){
var inst_24447 = (state_24449[(2)]);
var state_24449__$1 = state_24449;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24449__$1,inst_24447);
} else {
if((state_val_24450 === (4))){
var inst_24439 = (state_24449[(2)]);
var inst_24440 = process(inst_24439);
var state_24449__$1 = state_24449;
if(cljs.core.truth_(inst_24440)){
var statearr_24452_24604 = state_24449__$1;
(statearr_24452_24604[(1)] = (5));

} else {
var statearr_24453_24605 = state_24449__$1;
(statearr_24453_24605[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24450 === (5))){
var state_24449__$1 = state_24449;
var statearr_24454_24606 = state_24449__$1;
(statearr_24454_24606[(2)] = null);

(statearr_24454_24606[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24450 === (6))){
var state_24449__$1 = state_24449;
var statearr_24455_24607 = state_24449__$1;
(statearr_24455_24607[(2)] = null);

(statearr_24455_24607[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24450 === (7))){
var inst_24445 = (state_24449[(2)]);
var state_24449__$1 = state_24449;
var statearr_24456_24608 = state_24449__$1;
(statearr_24456_24608[(2)] = inst_24445);

(statearr_24456_24608[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__24598,c__24250__auto___24602,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async))
;
return ((function (__24598,switch__24175__auto__,c__24250__auto___24602,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0 = (function (){
var statearr_24457 = [null,null,null,null,null,null,null];
(statearr_24457[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__);

(statearr_24457[(1)] = (1));

return statearr_24457;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1 = (function (state_24449){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24449);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24458){var ex__24179__auto__ = e24458;
var statearr_24459_24609 = state_24449;
(statearr_24459_24609[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24449[(4)]))){
var statearr_24460_24610 = state_24449;
(statearr_24460_24610[(1)] = cljs.core.first((state_24449[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24611 = state_24449;
state_24449 = G__24611;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = function(state_24449){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1.call(this,state_24449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__;
})()
;})(__24598,switch__24175__auto__,c__24250__auto___24602,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async))
})();
var state__24252__auto__ = (function (){var statearr_24461 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24461[(6)] = c__24250__auto___24602);

return statearr_24461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
});})(__24598,c__24250__auto___24602,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async))
);


break;
case "async":
var c__24250__auto___24612 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__24598,c__24250__auto___24612,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async){
return (function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = ((function (__24598,c__24250__auto___24612,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async){
return (function (state_24474){
var state_val_24475 = (state_24474[(1)]);
if((state_val_24475 === (1))){
var state_24474__$1 = state_24474;
var statearr_24476_24613 = state_24474__$1;
(statearr_24476_24613[(2)] = null);

(statearr_24476_24613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24475 === (2))){
var state_24474__$1 = state_24474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24474__$1,(4),jobs);
} else {
if((state_val_24475 === (3))){
var inst_24472 = (state_24474[(2)]);
var state_24474__$1 = state_24474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24474__$1,inst_24472);
} else {
if((state_val_24475 === (4))){
var inst_24464 = (state_24474[(2)]);
var inst_24465 = async(inst_24464);
var state_24474__$1 = state_24474;
if(cljs.core.truth_(inst_24465)){
var statearr_24477_24614 = state_24474__$1;
(statearr_24477_24614[(1)] = (5));

} else {
var statearr_24478_24615 = state_24474__$1;
(statearr_24478_24615[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24475 === (5))){
var state_24474__$1 = state_24474;
var statearr_24479_24616 = state_24474__$1;
(statearr_24479_24616[(2)] = null);

(statearr_24479_24616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24475 === (6))){
var state_24474__$1 = state_24474;
var statearr_24480_24617 = state_24474__$1;
(statearr_24480_24617[(2)] = null);

(statearr_24480_24617[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24475 === (7))){
var inst_24470 = (state_24474[(2)]);
var state_24474__$1 = state_24474;
var statearr_24481_24618 = state_24474__$1;
(statearr_24481_24618[(2)] = inst_24470);

(statearr_24481_24618[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__24598,c__24250__auto___24612,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async))
;
return ((function (__24598,switch__24175__auto__,c__24250__auto___24612,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0 = (function (){
var statearr_24482 = [null,null,null,null,null,null,null];
(statearr_24482[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__);

(statearr_24482[(1)] = (1));

return statearr_24482;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1 = (function (state_24474){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24474);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24483){var ex__24179__auto__ = e24483;
var statearr_24484_24619 = state_24474;
(statearr_24484_24619[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24474[(4)]))){
var statearr_24485_24620 = state_24474;
(statearr_24485_24620[(1)] = cljs.core.first((state_24474[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24621 = state_24474;
state_24474 = G__24621;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = function(state_24474){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1.call(this,state_24474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__;
})()
;})(__24598,switch__24175__auto__,c__24250__auto___24612,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async))
})();
var state__24252__auto__ = (function (){var statearr_24486 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24486[(6)] = c__24250__auto___24612);

return statearr_24486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
});})(__24598,c__24250__auto___24612,G__24436_24599,G__24436_24600__$1,n__4741__auto___24597,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24436_24600__$1)].join('')));

}

var G__24622 = (__24598 + (1));
__24598 = G__24622;
continue;
} else {
}
break;
}

var c__24250__auto___24623 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_24508){
var state_val_24509 = (state_24508[(1)]);
if((state_val_24509 === (7))){
var inst_24504 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
var statearr_24510_24624 = state_24508__$1;
(statearr_24510_24624[(2)] = inst_24504);

(statearr_24510_24624[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24509 === (1))){
var state_24508__$1 = state_24508;
var statearr_24511_24625 = state_24508__$1;
(statearr_24511_24625[(2)] = null);

(statearr_24511_24625[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24509 === (4))){
var inst_24489 = (state_24508[(7)]);
var inst_24489__$1 = (state_24508[(2)]);
var inst_24490 = (inst_24489__$1 == null);
var state_24508__$1 = (function (){var statearr_24512 = state_24508;
(statearr_24512[(7)] = inst_24489__$1);

return statearr_24512;
})();
if(cljs.core.truth_(inst_24490)){
var statearr_24513_24626 = state_24508__$1;
(statearr_24513_24626[(1)] = (5));

} else {
var statearr_24514_24627 = state_24508__$1;
(statearr_24514_24627[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24509 === (6))){
var inst_24494 = (state_24508[(8)]);
var inst_24489 = (state_24508[(7)]);
var inst_24494__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_24495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24496 = [inst_24489,inst_24494__$1];
var inst_24497 = (new cljs.core.PersistentVector(null,2,(5),inst_24495,inst_24496,null));
var state_24508__$1 = (function (){var statearr_24515 = state_24508;
(statearr_24515[(8)] = inst_24494__$1);

return statearr_24515;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24508__$1,(8),jobs,inst_24497);
} else {
if((state_val_24509 === (3))){
var inst_24506 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24508__$1,inst_24506);
} else {
if((state_val_24509 === (2))){
var state_24508__$1 = state_24508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24508__$1,(4),from);
} else {
if((state_val_24509 === (9))){
var inst_24501 = (state_24508[(2)]);
var state_24508__$1 = (function (){var statearr_24516 = state_24508;
(statearr_24516[(9)] = inst_24501);

return statearr_24516;
})();
var statearr_24517_24628 = state_24508__$1;
(statearr_24517_24628[(2)] = null);

(statearr_24517_24628[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24509 === (5))){
var inst_24492 = cljs.core.async.close_BANG_(jobs);
var state_24508__$1 = state_24508;
var statearr_24518_24629 = state_24508__$1;
(statearr_24518_24629[(2)] = inst_24492);

(statearr_24518_24629[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24509 === (8))){
var inst_24494 = (state_24508[(8)]);
var inst_24499 = (state_24508[(2)]);
var state_24508__$1 = (function (){var statearr_24519 = state_24508;
(statearr_24519[(10)] = inst_24499);

return statearr_24519;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24508__$1,(9),results,inst_24494);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0 = (function (){
var statearr_24520 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24520[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__);

(statearr_24520[(1)] = (1));

return statearr_24520;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1 = (function (state_24508){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24508);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24521){var ex__24179__auto__ = e24521;
var statearr_24522_24630 = state_24508;
(statearr_24522_24630[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24508[(4)]))){
var statearr_24523_24631 = state_24508;
(statearr_24523_24631[(1)] = cljs.core.first((state_24508[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24632 = state_24508;
state_24508 = G__24632;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = function(state_24508){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1.call(this,state_24508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_24524 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24524[(6)] = c__24250__auto___24623);

return statearr_24524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_24562){
var state_val_24563 = (state_24562[(1)]);
if((state_val_24563 === (7))){
var inst_24558 = (state_24562[(2)]);
var state_24562__$1 = state_24562;
var statearr_24564_24633 = state_24562__$1;
(statearr_24564_24633[(2)] = inst_24558);

(statearr_24564_24633[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (20))){
var state_24562__$1 = state_24562;
var statearr_24565_24634 = state_24562__$1;
(statearr_24565_24634[(2)] = null);

(statearr_24565_24634[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (1))){
var state_24562__$1 = state_24562;
var statearr_24566_24635 = state_24562__$1;
(statearr_24566_24635[(2)] = null);

(statearr_24566_24635[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (4))){
var inst_24527 = (state_24562[(7)]);
var inst_24527__$1 = (state_24562[(2)]);
var inst_24528 = (inst_24527__$1 == null);
var state_24562__$1 = (function (){var statearr_24567 = state_24562;
(statearr_24567[(7)] = inst_24527__$1);

return statearr_24567;
})();
if(cljs.core.truth_(inst_24528)){
var statearr_24568_24636 = state_24562__$1;
(statearr_24568_24636[(1)] = (5));

} else {
var statearr_24569_24637 = state_24562__$1;
(statearr_24569_24637[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (15))){
var inst_24540 = (state_24562[(8)]);
var state_24562__$1 = state_24562;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24562__$1,(18),to,inst_24540);
} else {
if((state_val_24563 === (21))){
var inst_24553 = (state_24562[(2)]);
var state_24562__$1 = state_24562;
var statearr_24570_24638 = state_24562__$1;
(statearr_24570_24638[(2)] = inst_24553);

(statearr_24570_24638[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (13))){
var inst_24555 = (state_24562[(2)]);
var state_24562__$1 = (function (){var statearr_24571 = state_24562;
(statearr_24571[(9)] = inst_24555);

return statearr_24571;
})();
var statearr_24572_24639 = state_24562__$1;
(statearr_24572_24639[(2)] = null);

(statearr_24572_24639[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (6))){
var inst_24527 = (state_24562[(7)]);
var state_24562__$1 = state_24562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24562__$1,(11),inst_24527);
} else {
if((state_val_24563 === (17))){
var inst_24548 = (state_24562[(2)]);
var state_24562__$1 = state_24562;
if(cljs.core.truth_(inst_24548)){
var statearr_24573_24640 = state_24562__$1;
(statearr_24573_24640[(1)] = (19));

} else {
var statearr_24574_24641 = state_24562__$1;
(statearr_24574_24641[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (3))){
var inst_24560 = (state_24562[(2)]);
var state_24562__$1 = state_24562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24562__$1,inst_24560);
} else {
if((state_val_24563 === (12))){
var inst_24537 = (state_24562[(10)]);
var state_24562__$1 = state_24562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24562__$1,(14),inst_24537);
} else {
if((state_val_24563 === (2))){
var state_24562__$1 = state_24562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24562__$1,(4),results);
} else {
if((state_val_24563 === (19))){
var state_24562__$1 = state_24562;
var statearr_24575_24642 = state_24562__$1;
(statearr_24575_24642[(2)] = null);

(statearr_24575_24642[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (11))){
var inst_24537 = (state_24562[(2)]);
var state_24562__$1 = (function (){var statearr_24576 = state_24562;
(statearr_24576[(10)] = inst_24537);

return statearr_24576;
})();
var statearr_24577_24643 = state_24562__$1;
(statearr_24577_24643[(2)] = null);

(statearr_24577_24643[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (9))){
var state_24562__$1 = state_24562;
var statearr_24578_24644 = state_24562__$1;
(statearr_24578_24644[(2)] = null);

(statearr_24578_24644[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (5))){
var state_24562__$1 = state_24562;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24579_24645 = state_24562__$1;
(statearr_24579_24645[(1)] = (8));

} else {
var statearr_24580_24646 = state_24562__$1;
(statearr_24580_24646[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (14))){
var inst_24540 = (state_24562[(8)]);
var inst_24542 = (state_24562[(11)]);
var inst_24540__$1 = (state_24562[(2)]);
var inst_24541 = (inst_24540__$1 == null);
var inst_24542__$1 = cljs.core.not(inst_24541);
var state_24562__$1 = (function (){var statearr_24581 = state_24562;
(statearr_24581[(8)] = inst_24540__$1);

(statearr_24581[(11)] = inst_24542__$1);

return statearr_24581;
})();
if(inst_24542__$1){
var statearr_24582_24647 = state_24562__$1;
(statearr_24582_24647[(1)] = (15));

} else {
var statearr_24583_24648 = state_24562__$1;
(statearr_24583_24648[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (16))){
var inst_24542 = (state_24562[(11)]);
var state_24562__$1 = state_24562;
var statearr_24584_24649 = state_24562__$1;
(statearr_24584_24649[(2)] = inst_24542);

(statearr_24584_24649[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (10))){
var inst_24534 = (state_24562[(2)]);
var state_24562__$1 = state_24562;
var statearr_24585_24650 = state_24562__$1;
(statearr_24585_24650[(2)] = inst_24534);

(statearr_24585_24650[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (18))){
var inst_24545 = (state_24562[(2)]);
var state_24562__$1 = state_24562;
var statearr_24586_24651 = state_24562__$1;
(statearr_24586_24651[(2)] = inst_24545);

(statearr_24586_24651[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24563 === (8))){
var inst_24531 = cljs.core.async.close_BANG_(to);
var state_24562__$1 = state_24562;
var statearr_24587_24652 = state_24562__$1;
(statearr_24587_24652[(2)] = inst_24531);

(statearr_24587_24652[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0 = (function (){
var statearr_24588 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24588[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__);

(statearr_24588[(1)] = (1));

return statearr_24588;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1 = (function (state_24562){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24562);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24589){var ex__24179__auto__ = e24589;
var statearr_24590_24653 = state_24562;
(statearr_24590_24653[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24562[(4)]))){
var statearr_24591_24654 = state_24562;
(statearr_24591_24654[(1)] = cljs.core.first((state_24562[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24655 = state_24562;
state_24562 = G__24655;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__ = function(state_24562){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1.call(this,state_24562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24176__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_24592 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24592[(6)] = c__24250__auto__);

return statearr_24592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__24657 = arguments.length;
switch (G__24657) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__24660 = arguments.length;
switch (G__24660) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__24663 = arguments.length;
switch (G__24663) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__24250__auto___24713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_24689){
var state_val_24690 = (state_24689[(1)]);
if((state_val_24690 === (7))){
var inst_24685 = (state_24689[(2)]);
var state_24689__$1 = state_24689;
var statearr_24691_24714 = state_24689__$1;
(statearr_24691_24714[(2)] = inst_24685);

(statearr_24691_24714[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (1))){
var state_24689__$1 = state_24689;
var statearr_24692_24715 = state_24689__$1;
(statearr_24692_24715[(2)] = null);

(statearr_24692_24715[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (4))){
var inst_24666 = (state_24689[(7)]);
var inst_24666__$1 = (state_24689[(2)]);
var inst_24667 = (inst_24666__$1 == null);
var state_24689__$1 = (function (){var statearr_24693 = state_24689;
(statearr_24693[(7)] = inst_24666__$1);

return statearr_24693;
})();
if(cljs.core.truth_(inst_24667)){
var statearr_24694_24716 = state_24689__$1;
(statearr_24694_24716[(1)] = (5));

} else {
var statearr_24695_24717 = state_24689__$1;
(statearr_24695_24717[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (13))){
var state_24689__$1 = state_24689;
var statearr_24696_24718 = state_24689__$1;
(statearr_24696_24718[(2)] = null);

(statearr_24696_24718[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (6))){
var inst_24666 = (state_24689[(7)]);
var inst_24672 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_24666) : p.call(null,inst_24666));
var state_24689__$1 = state_24689;
if(cljs.core.truth_(inst_24672)){
var statearr_24697_24719 = state_24689__$1;
(statearr_24697_24719[(1)] = (9));

} else {
var statearr_24698_24720 = state_24689__$1;
(statearr_24698_24720[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (3))){
var inst_24687 = (state_24689[(2)]);
var state_24689__$1 = state_24689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24689__$1,inst_24687);
} else {
if((state_val_24690 === (12))){
var state_24689__$1 = state_24689;
var statearr_24699_24721 = state_24689__$1;
(statearr_24699_24721[(2)] = null);

(statearr_24699_24721[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (2))){
var state_24689__$1 = state_24689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24689__$1,(4),ch);
} else {
if((state_val_24690 === (11))){
var inst_24666 = (state_24689[(7)]);
var inst_24676 = (state_24689[(2)]);
var state_24689__$1 = state_24689;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24689__$1,(8),inst_24676,inst_24666);
} else {
if((state_val_24690 === (9))){
var state_24689__$1 = state_24689;
var statearr_24700_24722 = state_24689__$1;
(statearr_24700_24722[(2)] = tc);

(statearr_24700_24722[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (5))){
var inst_24669 = cljs.core.async.close_BANG_(tc);
var inst_24670 = cljs.core.async.close_BANG_(fc);
var state_24689__$1 = (function (){var statearr_24701 = state_24689;
(statearr_24701[(8)] = inst_24669);

return statearr_24701;
})();
var statearr_24702_24723 = state_24689__$1;
(statearr_24702_24723[(2)] = inst_24670);

(statearr_24702_24723[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (14))){
var inst_24683 = (state_24689[(2)]);
var state_24689__$1 = state_24689;
var statearr_24703_24724 = state_24689__$1;
(statearr_24703_24724[(2)] = inst_24683);

(statearr_24703_24724[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (10))){
var state_24689__$1 = state_24689;
var statearr_24704_24725 = state_24689__$1;
(statearr_24704_24725[(2)] = fc);

(statearr_24704_24725[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24690 === (8))){
var inst_24678 = (state_24689[(2)]);
var state_24689__$1 = state_24689;
if(cljs.core.truth_(inst_24678)){
var statearr_24705_24726 = state_24689__$1;
(statearr_24705_24726[(1)] = (12));

} else {
var statearr_24706_24727 = state_24689__$1;
(statearr_24706_24727[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_24707 = [null,null,null,null,null,null,null,null,null];
(statearr_24707[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_24707[(1)] = (1));

return statearr_24707;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_24689){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24689);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24708){var ex__24179__auto__ = e24708;
var statearr_24709_24728 = state_24689;
(statearr_24709_24728[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24689[(4)]))){
var statearr_24710_24729 = state_24689;
(statearr_24710_24729[(1)] = cljs.core.first((state_24689[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24730 = state_24689;
state_24689 = G__24730;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_24689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_24689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_24711 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24711[(6)] = c__24250__auto___24713);

return statearr_24711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_24752){
var state_val_24753 = (state_24752[(1)]);
if((state_val_24753 === (7))){
var inst_24748 = (state_24752[(2)]);
var state_24752__$1 = state_24752;
var statearr_24754_24773 = state_24752__$1;
(statearr_24754_24773[(2)] = inst_24748);

(statearr_24754_24773[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24753 === (1))){
var inst_24731 = init;
var inst_24732 = inst_24731;
var state_24752__$1 = (function (){var statearr_24755 = state_24752;
(statearr_24755[(7)] = inst_24732);

return statearr_24755;
})();
var statearr_24756_24774 = state_24752__$1;
(statearr_24756_24774[(2)] = null);

(statearr_24756_24774[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24753 === (4))){
var inst_24735 = (state_24752[(8)]);
var inst_24735__$1 = (state_24752[(2)]);
var inst_24736 = (inst_24735__$1 == null);
var state_24752__$1 = (function (){var statearr_24757 = state_24752;
(statearr_24757[(8)] = inst_24735__$1);

return statearr_24757;
})();
if(cljs.core.truth_(inst_24736)){
var statearr_24758_24775 = state_24752__$1;
(statearr_24758_24775[(1)] = (5));

} else {
var statearr_24759_24776 = state_24752__$1;
(statearr_24759_24776[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24753 === (6))){
var inst_24735 = (state_24752[(8)]);
var inst_24732 = (state_24752[(7)]);
var inst_24739 = (state_24752[(9)]);
var inst_24739__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_24732,inst_24735) : f.call(null,inst_24732,inst_24735));
var inst_24740 = cljs.core.reduced_QMARK_(inst_24739__$1);
var state_24752__$1 = (function (){var statearr_24760 = state_24752;
(statearr_24760[(9)] = inst_24739__$1);

return statearr_24760;
})();
if(inst_24740){
var statearr_24761_24777 = state_24752__$1;
(statearr_24761_24777[(1)] = (8));

} else {
var statearr_24762_24778 = state_24752__$1;
(statearr_24762_24778[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24753 === (3))){
var inst_24750 = (state_24752[(2)]);
var state_24752__$1 = state_24752;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24752__$1,inst_24750);
} else {
if((state_val_24753 === (2))){
var state_24752__$1 = state_24752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24752__$1,(4),ch);
} else {
if((state_val_24753 === (9))){
var inst_24739 = (state_24752[(9)]);
var inst_24732 = inst_24739;
var state_24752__$1 = (function (){var statearr_24763 = state_24752;
(statearr_24763[(7)] = inst_24732);

return statearr_24763;
})();
var statearr_24764_24779 = state_24752__$1;
(statearr_24764_24779[(2)] = null);

(statearr_24764_24779[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24753 === (5))){
var inst_24732 = (state_24752[(7)]);
var state_24752__$1 = state_24752;
var statearr_24765_24780 = state_24752__$1;
(statearr_24765_24780[(2)] = inst_24732);

(statearr_24765_24780[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24753 === (10))){
var inst_24746 = (state_24752[(2)]);
var state_24752__$1 = state_24752;
var statearr_24766_24781 = state_24752__$1;
(statearr_24766_24781[(2)] = inst_24746);

(statearr_24766_24781[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24753 === (8))){
var inst_24739 = (state_24752[(9)]);
var inst_24742 = cljs.core.deref(inst_24739);
var state_24752__$1 = state_24752;
var statearr_24767_24782 = state_24752__$1;
(statearr_24767_24782[(2)] = inst_24742);

(statearr_24767_24782[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__24176__auto__ = null;
var cljs$core$async$reduce_$_state_machine__24176__auto____0 = (function (){
var statearr_24768 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24768[(0)] = cljs$core$async$reduce_$_state_machine__24176__auto__);

(statearr_24768[(1)] = (1));

return statearr_24768;
});
var cljs$core$async$reduce_$_state_machine__24176__auto____1 = (function (state_24752){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24752);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24769){var ex__24179__auto__ = e24769;
var statearr_24770_24783 = state_24752;
(statearr_24770_24783[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24752[(4)]))){
var statearr_24771_24784 = state_24752;
(statearr_24771_24784[(1)] = cljs.core.first((state_24752[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24785 = state_24752;
state_24752 = G__24785;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__24176__auto__ = function(state_24752){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__24176__auto____1.call(this,state_24752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__24176__auto____0;
cljs$core$async$reduce_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__24176__auto____1;
return cljs$core$async$reduce_$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_24772 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24772[(6)] = c__24250__auto__);

return statearr_24772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_24791){
var state_val_24792 = (state_24791[(1)]);
if((state_val_24792 === (1))){
var inst_24786 = cljs.core.async.reduce(f__$1,init,ch);
var state_24791__$1 = state_24791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24791__$1,(2),inst_24786);
} else {
if((state_val_24792 === (2))){
var inst_24788 = (state_24791[(2)]);
var inst_24789 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_24788) : f__$1.call(null,inst_24788));
var state_24791__$1 = state_24791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24791__$1,inst_24789);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__24176__auto__ = null;
var cljs$core$async$transduce_$_state_machine__24176__auto____0 = (function (){
var statearr_24793 = [null,null,null,null,null,null,null];
(statearr_24793[(0)] = cljs$core$async$transduce_$_state_machine__24176__auto__);

(statearr_24793[(1)] = (1));

return statearr_24793;
});
var cljs$core$async$transduce_$_state_machine__24176__auto____1 = (function (state_24791){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24791);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24794){var ex__24179__auto__ = e24794;
var statearr_24795_24798 = state_24791;
(statearr_24795_24798[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24791[(4)]))){
var statearr_24796_24799 = state_24791;
(statearr_24796_24799[(1)] = cljs.core.first((state_24791[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24800 = state_24791;
state_24791 = G__24800;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__24176__auto__ = function(state_24791){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__24176__auto____1.call(this,state_24791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__24176__auto____0;
cljs$core$async$transduce_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__24176__auto____1;
return cljs$core$async$transduce_$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_24797 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24797[(6)] = c__24250__auto__);

return statearr_24797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__24802 = arguments.length;
switch (G__24802) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_24827){
var state_val_24828 = (state_24827[(1)]);
if((state_val_24828 === (7))){
var inst_24809 = (state_24827[(2)]);
var state_24827__$1 = state_24827;
var statearr_24829_24851 = state_24827__$1;
(statearr_24829_24851[(2)] = inst_24809);

(statearr_24829_24851[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (1))){
var inst_24803 = cljs.core.seq(coll);
var inst_24804 = inst_24803;
var state_24827__$1 = (function (){var statearr_24830 = state_24827;
(statearr_24830[(7)] = inst_24804);

return statearr_24830;
})();
var statearr_24831_24852 = state_24827__$1;
(statearr_24831_24852[(2)] = null);

(statearr_24831_24852[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (4))){
var inst_24804 = (state_24827[(7)]);
var inst_24807 = cljs.core.first(inst_24804);
var state_24827__$1 = state_24827;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24827__$1,(7),ch,inst_24807);
} else {
if((state_val_24828 === (13))){
var inst_24821 = (state_24827[(2)]);
var state_24827__$1 = state_24827;
var statearr_24832_24853 = state_24827__$1;
(statearr_24832_24853[(2)] = inst_24821);

(statearr_24832_24853[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (6))){
var inst_24812 = (state_24827[(2)]);
var state_24827__$1 = state_24827;
if(cljs.core.truth_(inst_24812)){
var statearr_24833_24854 = state_24827__$1;
(statearr_24833_24854[(1)] = (8));

} else {
var statearr_24834_24855 = state_24827__$1;
(statearr_24834_24855[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (3))){
var inst_24825 = (state_24827[(2)]);
var state_24827__$1 = state_24827;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24827__$1,inst_24825);
} else {
if((state_val_24828 === (12))){
var state_24827__$1 = state_24827;
var statearr_24835_24856 = state_24827__$1;
(statearr_24835_24856[(2)] = null);

(statearr_24835_24856[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (2))){
var inst_24804 = (state_24827[(7)]);
var state_24827__$1 = state_24827;
if(cljs.core.truth_(inst_24804)){
var statearr_24836_24857 = state_24827__$1;
(statearr_24836_24857[(1)] = (4));

} else {
var statearr_24837_24858 = state_24827__$1;
(statearr_24837_24858[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (11))){
var inst_24818 = cljs.core.async.close_BANG_(ch);
var state_24827__$1 = state_24827;
var statearr_24838_24859 = state_24827__$1;
(statearr_24838_24859[(2)] = inst_24818);

(statearr_24838_24859[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (9))){
var state_24827__$1 = state_24827;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24839_24860 = state_24827__$1;
(statearr_24839_24860[(1)] = (11));

} else {
var statearr_24840_24861 = state_24827__$1;
(statearr_24840_24861[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (5))){
var inst_24804 = (state_24827[(7)]);
var state_24827__$1 = state_24827;
var statearr_24841_24862 = state_24827__$1;
(statearr_24841_24862[(2)] = inst_24804);

(statearr_24841_24862[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (10))){
var inst_24823 = (state_24827[(2)]);
var state_24827__$1 = state_24827;
var statearr_24842_24863 = state_24827__$1;
(statearr_24842_24863[(2)] = inst_24823);

(statearr_24842_24863[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24828 === (8))){
var inst_24804 = (state_24827[(7)]);
var inst_24814 = cljs.core.next(inst_24804);
var inst_24804__$1 = inst_24814;
var state_24827__$1 = (function (){var statearr_24843 = state_24827;
(statearr_24843[(7)] = inst_24804__$1);

return statearr_24843;
})();
var statearr_24844_24864 = state_24827__$1;
(statearr_24844_24864[(2)] = null);

(statearr_24844_24864[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_24845 = [null,null,null,null,null,null,null,null];
(statearr_24845[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_24845[(1)] = (1));

return statearr_24845;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_24827){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_24827);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e24846){var ex__24179__auto__ = e24846;
var statearr_24847_24865 = state_24827;
(statearr_24847_24865[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_24827[(4)]))){
var statearr_24848_24866 = state_24827;
(statearr_24848_24866[(1)] = cljs.core.first((state_24827[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__24867 = state_24827;
state_24827 = G__24867;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_24827){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_24827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_24849 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_24849[(6)] = c__24250__auto__);

return statearr_24849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__24869 = arguments.length;
switch (G__24869) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_24871 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_24871(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_24872 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_24872(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_24873 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_24873(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_24874 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_24874(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24875 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24875 = (function (ch,cs,meta24876){
this.ch = ch;
this.cs = cs;
this.meta24876 = meta24876;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24875.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24877,meta24876__$1){
var self__ = this;
var _24877__$1 = this;
return (new cljs.core.async.t_cljs$core$async24875(self__.ch,self__.cs,meta24876__$1));
}));

(cljs.core.async.t_cljs$core$async24875.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24877){
var self__ = this;
var _24877__$1 = this;
return self__.meta24876;
}));

(cljs.core.async.t_cljs$core$async24875.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24875.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async24875.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24875.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async24875.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async24875.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async24875.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta24876], null);
}));

(cljs.core.async.t_cljs$core$async24875.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24875.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24875");

(cljs.core.async.t_cljs$core$async24875.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async24875");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24875.
 */
cljs.core.async.__GT_t_cljs$core$async24875 = (function cljs$core$async$mult_$___GT_t_cljs$core$async24875(ch__$1,cs__$1,meta24876){
return (new cljs.core.async.t_cljs$core$async24875(ch__$1,cs__$1,meta24876));
});

}

return (new cljs.core.async.t_cljs$core$async24875(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__24250__auto___25094 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25010){
var state_val_25011 = (state_25010[(1)]);
if((state_val_25011 === (7))){
var inst_25006 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25012_25095 = state_25010__$1;
(statearr_25012_25095[(2)] = inst_25006);

(statearr_25012_25095[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (20))){
var inst_24911 = (state_25010[(7)]);
var inst_24923 = cljs.core.first(inst_24911);
var inst_24924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24923,(0),null);
var inst_24925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24923,(1),null);
var state_25010__$1 = (function (){var statearr_25013 = state_25010;
(statearr_25013[(8)] = inst_24924);

return statearr_25013;
})();
if(cljs.core.truth_(inst_24925)){
var statearr_25014_25096 = state_25010__$1;
(statearr_25014_25096[(1)] = (22));

} else {
var statearr_25015_25097 = state_25010__$1;
(statearr_25015_25097[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (27))){
var inst_24955 = (state_25010[(9)]);
var inst_24880 = (state_25010[(10)]);
var inst_24960 = (state_25010[(11)]);
var inst_24953 = (state_25010[(12)]);
var inst_24960__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_24953,inst_24955);
var inst_24961 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_24960__$1,inst_24880,done);
var state_25010__$1 = (function (){var statearr_25016 = state_25010;
(statearr_25016[(11)] = inst_24960__$1);

return statearr_25016;
})();
if(cljs.core.truth_(inst_24961)){
var statearr_25017_25098 = state_25010__$1;
(statearr_25017_25098[(1)] = (30));

} else {
var statearr_25018_25099 = state_25010__$1;
(statearr_25018_25099[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (1))){
var state_25010__$1 = state_25010;
var statearr_25019_25100 = state_25010__$1;
(statearr_25019_25100[(2)] = null);

(statearr_25019_25100[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (24))){
var inst_24911 = (state_25010[(7)]);
var inst_24930 = (state_25010[(2)]);
var inst_24931 = cljs.core.next(inst_24911);
var inst_24889 = inst_24931;
var inst_24890 = null;
var inst_24891 = (0);
var inst_24892 = (0);
var state_25010__$1 = (function (){var statearr_25020 = state_25010;
(statearr_25020[(13)] = inst_24889);

(statearr_25020[(14)] = inst_24890);

(statearr_25020[(15)] = inst_24930);

(statearr_25020[(16)] = inst_24891);

(statearr_25020[(17)] = inst_24892);

return statearr_25020;
})();
var statearr_25021_25101 = state_25010__$1;
(statearr_25021_25101[(2)] = null);

(statearr_25021_25101[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (39))){
var state_25010__$1 = state_25010;
var statearr_25025_25102 = state_25010__$1;
(statearr_25025_25102[(2)] = null);

(statearr_25025_25102[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (4))){
var inst_24880 = (state_25010[(10)]);
var inst_24880__$1 = (state_25010[(2)]);
var inst_24881 = (inst_24880__$1 == null);
var state_25010__$1 = (function (){var statearr_25026 = state_25010;
(statearr_25026[(10)] = inst_24880__$1);

return statearr_25026;
})();
if(cljs.core.truth_(inst_24881)){
var statearr_25027_25103 = state_25010__$1;
(statearr_25027_25103[(1)] = (5));

} else {
var statearr_25028_25104 = state_25010__$1;
(statearr_25028_25104[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (15))){
var inst_24889 = (state_25010[(13)]);
var inst_24890 = (state_25010[(14)]);
var inst_24891 = (state_25010[(16)]);
var inst_24892 = (state_25010[(17)]);
var inst_24907 = (state_25010[(2)]);
var inst_24908 = (inst_24892 + (1));
var tmp25022 = inst_24889;
var tmp25023 = inst_24890;
var tmp25024 = inst_24891;
var inst_24889__$1 = tmp25022;
var inst_24890__$1 = tmp25023;
var inst_24891__$1 = tmp25024;
var inst_24892__$1 = inst_24908;
var state_25010__$1 = (function (){var statearr_25029 = state_25010;
(statearr_25029[(13)] = inst_24889__$1);

(statearr_25029[(14)] = inst_24890__$1);

(statearr_25029[(16)] = inst_24891__$1);

(statearr_25029[(17)] = inst_24892__$1);

(statearr_25029[(18)] = inst_24907);

return statearr_25029;
})();
var statearr_25030_25105 = state_25010__$1;
(statearr_25030_25105[(2)] = null);

(statearr_25030_25105[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (21))){
var inst_24934 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25034_25106 = state_25010__$1;
(statearr_25034_25106[(2)] = inst_24934);

(statearr_25034_25106[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (31))){
var inst_24960 = (state_25010[(11)]);
var inst_24964 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_24960);
var state_25010__$1 = state_25010;
var statearr_25035_25107 = state_25010__$1;
(statearr_25035_25107[(2)] = inst_24964);

(statearr_25035_25107[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (32))){
var inst_24955 = (state_25010[(9)]);
var inst_24952 = (state_25010[(19)]);
var inst_24953 = (state_25010[(12)]);
var inst_24954 = (state_25010[(20)]);
var inst_24966 = (state_25010[(2)]);
var inst_24967 = (inst_24955 + (1));
var tmp25031 = inst_24952;
var tmp25032 = inst_24953;
var tmp25033 = inst_24954;
var inst_24952__$1 = tmp25031;
var inst_24953__$1 = tmp25032;
var inst_24954__$1 = tmp25033;
var inst_24955__$1 = inst_24967;
var state_25010__$1 = (function (){var statearr_25036 = state_25010;
(statearr_25036[(9)] = inst_24955__$1);

(statearr_25036[(21)] = inst_24966);

(statearr_25036[(19)] = inst_24952__$1);

(statearr_25036[(12)] = inst_24953__$1);

(statearr_25036[(20)] = inst_24954__$1);

return statearr_25036;
})();
var statearr_25037_25108 = state_25010__$1;
(statearr_25037_25108[(2)] = null);

(statearr_25037_25108[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (40))){
var inst_24979 = (state_25010[(22)]);
var inst_24983 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_24979);
var state_25010__$1 = state_25010;
var statearr_25038_25109 = state_25010__$1;
(statearr_25038_25109[(2)] = inst_24983);

(statearr_25038_25109[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (33))){
var inst_24970 = (state_25010[(23)]);
var inst_24972 = cljs.core.chunked_seq_QMARK_(inst_24970);
var state_25010__$1 = state_25010;
if(inst_24972){
var statearr_25039_25110 = state_25010__$1;
(statearr_25039_25110[(1)] = (36));

} else {
var statearr_25040_25111 = state_25010__$1;
(statearr_25040_25111[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (13))){
var inst_24901 = (state_25010[(24)]);
var inst_24904 = cljs.core.async.close_BANG_(inst_24901);
var state_25010__$1 = state_25010;
var statearr_25041_25112 = state_25010__$1;
(statearr_25041_25112[(2)] = inst_24904);

(statearr_25041_25112[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (22))){
var inst_24924 = (state_25010[(8)]);
var inst_24927 = cljs.core.async.close_BANG_(inst_24924);
var state_25010__$1 = state_25010;
var statearr_25042_25113 = state_25010__$1;
(statearr_25042_25113[(2)] = inst_24927);

(statearr_25042_25113[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (36))){
var inst_24970 = (state_25010[(23)]);
var inst_24974 = cljs.core.chunk_first(inst_24970);
var inst_24975 = cljs.core.chunk_rest(inst_24970);
var inst_24976 = cljs.core.count(inst_24974);
var inst_24952 = inst_24975;
var inst_24953 = inst_24974;
var inst_24954 = inst_24976;
var inst_24955 = (0);
var state_25010__$1 = (function (){var statearr_25043 = state_25010;
(statearr_25043[(9)] = inst_24955);

(statearr_25043[(19)] = inst_24952);

(statearr_25043[(12)] = inst_24953);

(statearr_25043[(20)] = inst_24954);

return statearr_25043;
})();
var statearr_25044_25114 = state_25010__$1;
(statearr_25044_25114[(2)] = null);

(statearr_25044_25114[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (41))){
var inst_24970 = (state_25010[(23)]);
var inst_24985 = (state_25010[(2)]);
var inst_24986 = cljs.core.next(inst_24970);
var inst_24952 = inst_24986;
var inst_24953 = null;
var inst_24954 = (0);
var inst_24955 = (0);
var state_25010__$1 = (function (){var statearr_25045 = state_25010;
(statearr_25045[(9)] = inst_24955);

(statearr_25045[(19)] = inst_24952);

(statearr_25045[(12)] = inst_24953);

(statearr_25045[(20)] = inst_24954);

(statearr_25045[(25)] = inst_24985);

return statearr_25045;
})();
var statearr_25046_25115 = state_25010__$1;
(statearr_25046_25115[(2)] = null);

(statearr_25046_25115[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (43))){
var state_25010__$1 = state_25010;
var statearr_25047_25116 = state_25010__$1;
(statearr_25047_25116[(2)] = null);

(statearr_25047_25116[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (29))){
var inst_24994 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25048_25117 = state_25010__$1;
(statearr_25048_25117[(2)] = inst_24994);

(statearr_25048_25117[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (44))){
var inst_25003 = (state_25010[(2)]);
var state_25010__$1 = (function (){var statearr_25049 = state_25010;
(statearr_25049[(26)] = inst_25003);

return statearr_25049;
})();
var statearr_25050_25118 = state_25010__$1;
(statearr_25050_25118[(2)] = null);

(statearr_25050_25118[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (6))){
var inst_24944 = (state_25010[(27)]);
var inst_24943 = cljs.core.deref(cs);
var inst_24944__$1 = cljs.core.keys(inst_24943);
var inst_24945 = cljs.core.count(inst_24944__$1);
var inst_24946 = cljs.core.reset_BANG_(dctr,inst_24945);
var inst_24951 = cljs.core.seq(inst_24944__$1);
var inst_24952 = inst_24951;
var inst_24953 = null;
var inst_24954 = (0);
var inst_24955 = (0);
var state_25010__$1 = (function (){var statearr_25051 = state_25010;
(statearr_25051[(28)] = inst_24946);

(statearr_25051[(9)] = inst_24955);

(statearr_25051[(27)] = inst_24944__$1);

(statearr_25051[(19)] = inst_24952);

(statearr_25051[(12)] = inst_24953);

(statearr_25051[(20)] = inst_24954);

return statearr_25051;
})();
var statearr_25052_25119 = state_25010__$1;
(statearr_25052_25119[(2)] = null);

(statearr_25052_25119[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (28))){
var inst_24952 = (state_25010[(19)]);
var inst_24970 = (state_25010[(23)]);
var inst_24970__$1 = cljs.core.seq(inst_24952);
var state_25010__$1 = (function (){var statearr_25053 = state_25010;
(statearr_25053[(23)] = inst_24970__$1);

return statearr_25053;
})();
if(inst_24970__$1){
var statearr_25054_25120 = state_25010__$1;
(statearr_25054_25120[(1)] = (33));

} else {
var statearr_25055_25121 = state_25010__$1;
(statearr_25055_25121[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (25))){
var inst_24955 = (state_25010[(9)]);
var inst_24954 = (state_25010[(20)]);
var inst_24957 = (inst_24955 < inst_24954);
var inst_24958 = inst_24957;
var state_25010__$1 = state_25010;
if(cljs.core.truth_(inst_24958)){
var statearr_25056_25122 = state_25010__$1;
(statearr_25056_25122[(1)] = (27));

} else {
var statearr_25057_25123 = state_25010__$1;
(statearr_25057_25123[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (34))){
var state_25010__$1 = state_25010;
var statearr_25058_25124 = state_25010__$1;
(statearr_25058_25124[(2)] = null);

(statearr_25058_25124[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (17))){
var state_25010__$1 = state_25010;
var statearr_25059_25125 = state_25010__$1;
(statearr_25059_25125[(2)] = null);

(statearr_25059_25125[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (3))){
var inst_25008 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25010__$1,inst_25008);
} else {
if((state_val_25011 === (12))){
var inst_24939 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25060_25126 = state_25010__$1;
(statearr_25060_25126[(2)] = inst_24939);

(statearr_25060_25126[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (2))){
var state_25010__$1 = state_25010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25010__$1,(4),ch);
} else {
if((state_val_25011 === (23))){
var state_25010__$1 = state_25010;
var statearr_25061_25127 = state_25010__$1;
(statearr_25061_25127[(2)] = null);

(statearr_25061_25127[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (35))){
var inst_24992 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25062_25128 = state_25010__$1;
(statearr_25062_25128[(2)] = inst_24992);

(statearr_25062_25128[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (19))){
var inst_24911 = (state_25010[(7)]);
var inst_24915 = cljs.core.chunk_first(inst_24911);
var inst_24916 = cljs.core.chunk_rest(inst_24911);
var inst_24917 = cljs.core.count(inst_24915);
var inst_24889 = inst_24916;
var inst_24890 = inst_24915;
var inst_24891 = inst_24917;
var inst_24892 = (0);
var state_25010__$1 = (function (){var statearr_25063 = state_25010;
(statearr_25063[(13)] = inst_24889);

(statearr_25063[(14)] = inst_24890);

(statearr_25063[(16)] = inst_24891);

(statearr_25063[(17)] = inst_24892);

return statearr_25063;
})();
var statearr_25064_25129 = state_25010__$1;
(statearr_25064_25129[(2)] = null);

(statearr_25064_25129[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (11))){
var inst_24889 = (state_25010[(13)]);
var inst_24911 = (state_25010[(7)]);
var inst_24911__$1 = cljs.core.seq(inst_24889);
var state_25010__$1 = (function (){var statearr_25065 = state_25010;
(statearr_25065[(7)] = inst_24911__$1);

return statearr_25065;
})();
if(inst_24911__$1){
var statearr_25066_25130 = state_25010__$1;
(statearr_25066_25130[(1)] = (16));

} else {
var statearr_25067_25131 = state_25010__$1;
(statearr_25067_25131[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (9))){
var inst_24941 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25068_25132 = state_25010__$1;
(statearr_25068_25132[(2)] = inst_24941);

(statearr_25068_25132[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (5))){
var inst_24887 = cljs.core.deref(cs);
var inst_24888 = cljs.core.seq(inst_24887);
var inst_24889 = inst_24888;
var inst_24890 = null;
var inst_24891 = (0);
var inst_24892 = (0);
var state_25010__$1 = (function (){var statearr_25069 = state_25010;
(statearr_25069[(13)] = inst_24889);

(statearr_25069[(14)] = inst_24890);

(statearr_25069[(16)] = inst_24891);

(statearr_25069[(17)] = inst_24892);

return statearr_25069;
})();
var statearr_25070_25133 = state_25010__$1;
(statearr_25070_25133[(2)] = null);

(statearr_25070_25133[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (14))){
var state_25010__$1 = state_25010;
var statearr_25071_25134 = state_25010__$1;
(statearr_25071_25134[(2)] = null);

(statearr_25071_25134[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (45))){
var inst_25000 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25072_25135 = state_25010__$1;
(statearr_25072_25135[(2)] = inst_25000);

(statearr_25072_25135[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (26))){
var inst_24944 = (state_25010[(27)]);
var inst_24996 = (state_25010[(2)]);
var inst_24997 = cljs.core.seq(inst_24944);
var state_25010__$1 = (function (){var statearr_25073 = state_25010;
(statearr_25073[(29)] = inst_24996);

return statearr_25073;
})();
if(inst_24997){
var statearr_25074_25136 = state_25010__$1;
(statearr_25074_25136[(1)] = (42));

} else {
var statearr_25075_25137 = state_25010__$1;
(statearr_25075_25137[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (16))){
var inst_24911 = (state_25010[(7)]);
var inst_24913 = cljs.core.chunked_seq_QMARK_(inst_24911);
var state_25010__$1 = state_25010;
if(inst_24913){
var statearr_25076_25138 = state_25010__$1;
(statearr_25076_25138[(1)] = (19));

} else {
var statearr_25077_25139 = state_25010__$1;
(statearr_25077_25139[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (38))){
var inst_24989 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25078_25140 = state_25010__$1;
(statearr_25078_25140[(2)] = inst_24989);

(statearr_25078_25140[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (30))){
var state_25010__$1 = state_25010;
var statearr_25079_25141 = state_25010__$1;
(statearr_25079_25141[(2)] = null);

(statearr_25079_25141[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (10))){
var inst_24890 = (state_25010[(14)]);
var inst_24892 = (state_25010[(17)]);
var inst_24900 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_24890,inst_24892);
var inst_24901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24900,(0),null);
var inst_24902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24900,(1),null);
var state_25010__$1 = (function (){var statearr_25080 = state_25010;
(statearr_25080[(24)] = inst_24901);

return statearr_25080;
})();
if(cljs.core.truth_(inst_24902)){
var statearr_25081_25142 = state_25010__$1;
(statearr_25081_25142[(1)] = (13));

} else {
var statearr_25082_25143 = state_25010__$1;
(statearr_25082_25143[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (18))){
var inst_24937 = (state_25010[(2)]);
var state_25010__$1 = state_25010;
var statearr_25083_25144 = state_25010__$1;
(statearr_25083_25144[(2)] = inst_24937);

(statearr_25083_25144[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (42))){
var state_25010__$1 = state_25010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25010__$1,(45),dchan);
} else {
if((state_val_25011 === (37))){
var inst_24979 = (state_25010[(22)]);
var inst_24880 = (state_25010[(10)]);
var inst_24970 = (state_25010[(23)]);
var inst_24979__$1 = cljs.core.first(inst_24970);
var inst_24980 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_24979__$1,inst_24880,done);
var state_25010__$1 = (function (){var statearr_25084 = state_25010;
(statearr_25084[(22)] = inst_24979__$1);

return statearr_25084;
})();
if(cljs.core.truth_(inst_24980)){
var statearr_25085_25145 = state_25010__$1;
(statearr_25085_25145[(1)] = (39));

} else {
var statearr_25086_25146 = state_25010__$1;
(statearr_25086_25146[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25011 === (8))){
var inst_24891 = (state_25010[(16)]);
var inst_24892 = (state_25010[(17)]);
var inst_24894 = (inst_24892 < inst_24891);
var inst_24895 = inst_24894;
var state_25010__$1 = state_25010;
if(cljs.core.truth_(inst_24895)){
var statearr_25087_25147 = state_25010__$1;
(statearr_25087_25147[(1)] = (10));

} else {
var statearr_25088_25148 = state_25010__$1;
(statearr_25088_25148[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__24176__auto__ = null;
var cljs$core$async$mult_$_state_machine__24176__auto____0 = (function (){
var statearr_25089 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25089[(0)] = cljs$core$async$mult_$_state_machine__24176__auto__);

(statearr_25089[(1)] = (1));

return statearr_25089;
});
var cljs$core$async$mult_$_state_machine__24176__auto____1 = (function (state_25010){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25010);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25090){var ex__24179__auto__ = e25090;
var statearr_25091_25149 = state_25010;
(statearr_25091_25149[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25010[(4)]))){
var statearr_25092_25150 = state_25010;
(statearr_25092_25150[(1)] = cljs.core.first((state_25010[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25151 = state_25010;
state_25010 = G__25151;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__24176__auto__ = function(state_25010){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__24176__auto____1.call(this,state_25010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__24176__auto____0;
cljs$core$async$mult_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__24176__auto____1;
return cljs$core$async$mult_$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25093 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25093[(6)] = c__24250__auto___25094);

return statearr_25093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__25153 = arguments.length;
switch (G__25153) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_25155 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_25155(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_25156 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_25156(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_25157 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_25157(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_25158 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_25158(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_25159 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_25159(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___25169 = arguments.length;
var i__4865__auto___25170 = (0);
while(true){
if((i__4865__auto___25170 < len__4864__auto___25169)){
args__4870__auto__.push((arguments[i__4865__auto___25170]));

var G__25171 = (i__4865__auto___25170 + (1));
i__4865__auto___25170 = G__25171;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__25164){
var map__25165 = p__25164;
var map__25165__$1 = cljs.core.__destructure_map(map__25165);
var opts = map__25165__$1;
var statearr_25166_25172 = state;
(statearr_25166_25172[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_25167_25173 = state;
(statearr_25167_25173[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_25168_25174 = state;
(statearr_25168_25174[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq25160){
var G__25161 = cljs.core.first(seq25160);
var seq25160__$1 = cljs.core.next(seq25160);
var G__25162 = cljs.core.first(seq25160__$1);
var seq25160__$2 = cljs.core.next(seq25160__$1);
var G__25163 = cljs.core.first(seq25160__$2);
var seq25160__$3 = cljs.core.next(seq25160__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__25161,G__25162,G__25163,seq25160__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25175 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25175 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta25176){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta25176 = meta25176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25177,meta25176__$1){
var self__ = this;
var _25177__$1 = this;
return (new cljs.core.async.t_cljs$core$async25175(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta25176__$1));
}));

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25177){
var self__ = this;
var _25177__$1 = this;
return self__.meta25176;
}));

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async25175.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async25175.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta25176], null);
}));

(cljs.core.async.t_cljs$core$async25175.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25175.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25175");

(cljs.core.async.t_cljs$core$async25175.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async25175");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25175.
 */
cljs.core.async.__GT_t_cljs$core$async25175 = (function cljs$core$async$mix_$___GT_t_cljs$core$async25175(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta25176){
return (new cljs.core.async.t_cljs$core$async25175(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta25176));
});

}

return (new cljs.core.async.t_cljs$core$async25175(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24250__auto___25290 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25245){
var state_val_25246 = (state_25245[(1)]);
if((state_val_25246 === (7))){
var inst_25205 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
if(cljs.core.truth_(inst_25205)){
var statearr_25247_25291 = state_25245__$1;
(statearr_25247_25291[(1)] = (8));

} else {
var statearr_25248_25292 = state_25245__$1;
(statearr_25248_25292[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (20))){
var inst_25198 = (state_25245[(7)]);
var state_25245__$1 = state_25245;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25245__$1,(23),out,inst_25198);
} else {
if((state_val_25246 === (1))){
var inst_25181 = calc_state();
var inst_25182 = cljs.core.__destructure_map(inst_25181);
var inst_25183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25182,cljs.core.cst$kw$solos);
var inst_25184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25182,cljs.core.cst$kw$mutes);
var inst_25185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25182,cljs.core.cst$kw$reads);
var inst_25186 = inst_25181;
var state_25245__$1 = (function (){var statearr_25249 = state_25245;
(statearr_25249[(8)] = inst_25186);

(statearr_25249[(9)] = inst_25184);

(statearr_25249[(10)] = inst_25183);

(statearr_25249[(11)] = inst_25185);

return statearr_25249;
})();
var statearr_25250_25293 = state_25245__$1;
(statearr_25250_25293[(2)] = null);

(statearr_25250_25293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (24))){
var inst_25189 = (state_25245[(12)]);
var inst_25186 = inst_25189;
var state_25245__$1 = (function (){var statearr_25251 = state_25245;
(statearr_25251[(8)] = inst_25186);

return statearr_25251;
})();
var statearr_25252_25294 = state_25245__$1;
(statearr_25252_25294[(2)] = null);

(statearr_25252_25294[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (4))){
var inst_25198 = (state_25245[(7)]);
var inst_25200 = (state_25245[(13)]);
var inst_25197 = (state_25245[(2)]);
var inst_25198__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25197,(0),null);
var inst_25199 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25197,(1),null);
var inst_25200__$1 = (inst_25198__$1 == null);
var state_25245__$1 = (function (){var statearr_25253 = state_25245;
(statearr_25253[(14)] = inst_25199);

(statearr_25253[(7)] = inst_25198__$1);

(statearr_25253[(13)] = inst_25200__$1);

return statearr_25253;
})();
if(cljs.core.truth_(inst_25200__$1)){
var statearr_25254_25295 = state_25245__$1;
(statearr_25254_25295[(1)] = (5));

} else {
var statearr_25255_25296 = state_25245__$1;
(statearr_25255_25296[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (15))){
var inst_25190 = (state_25245[(15)]);
var inst_25219 = (state_25245[(16)]);
var inst_25219__$1 = cljs.core.empty_QMARK_(inst_25190);
var state_25245__$1 = (function (){var statearr_25256 = state_25245;
(statearr_25256[(16)] = inst_25219__$1);

return statearr_25256;
})();
if(inst_25219__$1){
var statearr_25257_25297 = state_25245__$1;
(statearr_25257_25297[(1)] = (17));

} else {
var statearr_25258_25298 = state_25245__$1;
(statearr_25258_25298[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (21))){
var inst_25189 = (state_25245[(12)]);
var inst_25186 = inst_25189;
var state_25245__$1 = (function (){var statearr_25259 = state_25245;
(statearr_25259[(8)] = inst_25186);

return statearr_25259;
})();
var statearr_25260_25299 = state_25245__$1;
(statearr_25260_25299[(2)] = null);

(statearr_25260_25299[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (13))){
var inst_25212 = (state_25245[(2)]);
var inst_25213 = calc_state();
var inst_25186 = inst_25213;
var state_25245__$1 = (function (){var statearr_25261 = state_25245;
(statearr_25261[(8)] = inst_25186);

(statearr_25261[(17)] = inst_25212);

return statearr_25261;
})();
var statearr_25262_25300 = state_25245__$1;
(statearr_25262_25300[(2)] = null);

(statearr_25262_25300[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (22))){
var inst_25239 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
var statearr_25263_25301 = state_25245__$1;
(statearr_25263_25301[(2)] = inst_25239);

(statearr_25263_25301[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (6))){
var inst_25199 = (state_25245[(14)]);
var inst_25203 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25199,change);
var state_25245__$1 = state_25245;
var statearr_25264_25302 = state_25245__$1;
(statearr_25264_25302[(2)] = inst_25203);

(statearr_25264_25302[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (25))){
var state_25245__$1 = state_25245;
var statearr_25265_25303 = state_25245__$1;
(statearr_25265_25303[(2)] = null);

(statearr_25265_25303[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (17))){
var inst_25199 = (state_25245[(14)]);
var inst_25191 = (state_25245[(18)]);
var inst_25221 = (inst_25191.cljs$core$IFn$_invoke$arity$1 ? inst_25191.cljs$core$IFn$_invoke$arity$1(inst_25199) : inst_25191.call(null,inst_25199));
var inst_25222 = cljs.core.not(inst_25221);
var state_25245__$1 = state_25245;
var statearr_25266_25304 = state_25245__$1;
(statearr_25266_25304[(2)] = inst_25222);

(statearr_25266_25304[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (3))){
var inst_25243 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25245__$1,inst_25243);
} else {
if((state_val_25246 === (12))){
var state_25245__$1 = state_25245;
var statearr_25267_25305 = state_25245__$1;
(statearr_25267_25305[(2)] = null);

(statearr_25267_25305[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (2))){
var inst_25186 = (state_25245[(8)]);
var inst_25189 = (state_25245[(12)]);
var inst_25189__$1 = cljs.core.__destructure_map(inst_25186);
var inst_25190 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25189__$1,cljs.core.cst$kw$solos);
var inst_25191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25189__$1,cljs.core.cst$kw$mutes);
var inst_25192 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25189__$1,cljs.core.cst$kw$reads);
var state_25245__$1 = (function (){var statearr_25268 = state_25245;
(statearr_25268[(15)] = inst_25190);

(statearr_25268[(12)] = inst_25189__$1);

(statearr_25268[(18)] = inst_25191);

return statearr_25268;
})();
return cljs.core.async.ioc_alts_BANG_(state_25245__$1,(4),inst_25192);
} else {
if((state_val_25246 === (23))){
var inst_25230 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
if(cljs.core.truth_(inst_25230)){
var statearr_25269_25306 = state_25245__$1;
(statearr_25269_25306[(1)] = (24));

} else {
var statearr_25270_25307 = state_25245__$1;
(statearr_25270_25307[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (19))){
var inst_25225 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
var statearr_25271_25308 = state_25245__$1;
(statearr_25271_25308[(2)] = inst_25225);

(statearr_25271_25308[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (11))){
var inst_25199 = (state_25245[(14)]);
var inst_25209 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_25199);
var state_25245__$1 = state_25245;
var statearr_25272_25309 = state_25245__$1;
(statearr_25272_25309[(2)] = inst_25209);

(statearr_25272_25309[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (9))){
var inst_25216 = (state_25245[(19)]);
var inst_25190 = (state_25245[(15)]);
var inst_25199 = (state_25245[(14)]);
var inst_25216__$1 = (inst_25190.cljs$core$IFn$_invoke$arity$1 ? inst_25190.cljs$core$IFn$_invoke$arity$1(inst_25199) : inst_25190.call(null,inst_25199));
var state_25245__$1 = (function (){var statearr_25273 = state_25245;
(statearr_25273[(19)] = inst_25216__$1);

return statearr_25273;
})();
if(cljs.core.truth_(inst_25216__$1)){
var statearr_25274_25310 = state_25245__$1;
(statearr_25274_25310[(1)] = (14));

} else {
var statearr_25275_25311 = state_25245__$1;
(statearr_25275_25311[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (5))){
var inst_25200 = (state_25245[(13)]);
var state_25245__$1 = state_25245;
var statearr_25276_25312 = state_25245__$1;
(statearr_25276_25312[(2)] = inst_25200);

(statearr_25276_25312[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (14))){
var inst_25216 = (state_25245[(19)]);
var state_25245__$1 = state_25245;
var statearr_25277_25313 = state_25245__$1;
(statearr_25277_25313[(2)] = inst_25216);

(statearr_25277_25313[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (26))){
var inst_25235 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
var statearr_25278_25314 = state_25245__$1;
(statearr_25278_25314[(2)] = inst_25235);

(statearr_25278_25314[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (16))){
var inst_25227 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
if(cljs.core.truth_(inst_25227)){
var statearr_25279_25315 = state_25245__$1;
(statearr_25279_25315[(1)] = (20));

} else {
var statearr_25280_25316 = state_25245__$1;
(statearr_25280_25316[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (10))){
var inst_25241 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
var statearr_25281_25317 = state_25245__$1;
(statearr_25281_25317[(2)] = inst_25241);

(statearr_25281_25317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (18))){
var inst_25219 = (state_25245[(16)]);
var state_25245__$1 = state_25245;
var statearr_25282_25318 = state_25245__$1;
(statearr_25282_25318[(2)] = inst_25219);

(statearr_25282_25318[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25246 === (8))){
var inst_25198 = (state_25245[(7)]);
var inst_25207 = (inst_25198 == null);
var state_25245__$1 = state_25245;
if(cljs.core.truth_(inst_25207)){
var statearr_25283_25319 = state_25245__$1;
(statearr_25283_25319[(1)] = (11));

} else {
var statearr_25284_25320 = state_25245__$1;
(statearr_25284_25320[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__24176__auto__ = null;
var cljs$core$async$mix_$_state_machine__24176__auto____0 = (function (){
var statearr_25285 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25285[(0)] = cljs$core$async$mix_$_state_machine__24176__auto__);

(statearr_25285[(1)] = (1));

return statearr_25285;
});
var cljs$core$async$mix_$_state_machine__24176__auto____1 = (function (state_25245){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25245);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25286){var ex__24179__auto__ = e25286;
var statearr_25287_25321 = state_25245;
(statearr_25287_25321[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25245[(4)]))){
var statearr_25288_25322 = state_25245;
(statearr_25288_25322[(1)] = cljs.core.first((state_25245[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25323 = state_25245;
state_25245 = G__25323;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__24176__auto__ = function(state_25245){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__24176__auto____1.call(this,state_25245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__24176__auto____0;
cljs$core$async$mix_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__24176__auto____1;
return cljs$core$async$mix_$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25289 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25289[(6)] = c__24250__auto___25290);

return statearr_25289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_25326 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_25326(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_25327 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_25327(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_25328 = (function() {
var G__25329 = null;
var G__25329__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__25329__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__25329 = function(p,v){
switch(arguments.length){
case 1:
return G__25329__1.call(this,p);
case 2:
return G__25329__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__25329.cljs$core$IFn$_invoke$arity$1 = G__25329__1;
G__25329.cljs$core$IFn$_invoke$arity$2 = G__25329__2;
return G__25329;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__25325 = arguments.length;
switch (G__25325) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_25328.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_25328.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__25333 = arguments.length;
switch (G__25333) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__25331_SHARP_){
if(cljs.core.truth_((p1__25331_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__25331_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__25331_SHARP_.call(null,topic)))){
return p1__25331_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__25331_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25334 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25334 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta25335){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta25335 = meta25335;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25336,meta25335__$1){
var self__ = this;
var _25336__$1 = this;
return (new cljs.core.async.t_cljs$core$async25334(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta25335__$1));
}));

(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25336){
var self__ = this;
var _25336__$1 = this;
return self__.meta25335;
}));

(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async25334.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async25334.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta25335], null);
}));

(cljs.core.async.t_cljs$core$async25334.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25334.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25334");

(cljs.core.async.t_cljs$core$async25334.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async25334");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25334.
 */
cljs.core.async.__GT_t_cljs$core$async25334 = (function cljs$core$async$__GT_t_cljs$core$async25334(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25335){
return (new cljs.core.async.t_cljs$core$async25334(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25335));
});

}

return (new cljs.core.async.t_cljs$core$async25334(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24250__auto___25455 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25408){
var state_val_25409 = (state_25408[(1)]);
if((state_val_25409 === (7))){
var inst_25404 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25410_25456 = state_25408__$1;
(statearr_25410_25456[(2)] = inst_25404);

(statearr_25410_25456[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (20))){
var state_25408__$1 = state_25408;
var statearr_25411_25457 = state_25408__$1;
(statearr_25411_25457[(2)] = null);

(statearr_25411_25457[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (1))){
var state_25408__$1 = state_25408;
var statearr_25412_25458 = state_25408__$1;
(statearr_25412_25458[(2)] = null);

(statearr_25412_25458[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (24))){
var inst_25387 = (state_25408[(7)]);
var inst_25396 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_25387);
var state_25408__$1 = state_25408;
var statearr_25413_25459 = state_25408__$1;
(statearr_25413_25459[(2)] = inst_25396);

(statearr_25413_25459[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (4))){
var inst_25339 = (state_25408[(8)]);
var inst_25339__$1 = (state_25408[(2)]);
var inst_25340 = (inst_25339__$1 == null);
var state_25408__$1 = (function (){var statearr_25414 = state_25408;
(statearr_25414[(8)] = inst_25339__$1);

return statearr_25414;
})();
if(cljs.core.truth_(inst_25340)){
var statearr_25415_25460 = state_25408__$1;
(statearr_25415_25460[(1)] = (5));

} else {
var statearr_25416_25461 = state_25408__$1;
(statearr_25416_25461[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (15))){
var inst_25381 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25417_25462 = state_25408__$1;
(statearr_25417_25462[(2)] = inst_25381);

(statearr_25417_25462[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (21))){
var inst_25401 = (state_25408[(2)]);
var state_25408__$1 = (function (){var statearr_25418 = state_25408;
(statearr_25418[(9)] = inst_25401);

return statearr_25418;
})();
var statearr_25419_25463 = state_25408__$1;
(statearr_25419_25463[(2)] = null);

(statearr_25419_25463[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (13))){
var inst_25363 = (state_25408[(10)]);
var inst_25365 = cljs.core.chunked_seq_QMARK_(inst_25363);
var state_25408__$1 = state_25408;
if(inst_25365){
var statearr_25420_25464 = state_25408__$1;
(statearr_25420_25464[(1)] = (16));

} else {
var statearr_25421_25465 = state_25408__$1;
(statearr_25421_25465[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (22))){
var inst_25393 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
if(cljs.core.truth_(inst_25393)){
var statearr_25422_25466 = state_25408__$1;
(statearr_25422_25466[(1)] = (23));

} else {
var statearr_25423_25467 = state_25408__$1;
(statearr_25423_25467[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (6))){
var inst_25339 = (state_25408[(8)]);
var inst_25389 = (state_25408[(11)]);
var inst_25387 = (state_25408[(7)]);
var inst_25387__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_25339) : topic_fn.call(null,inst_25339));
var inst_25388 = cljs.core.deref(mults);
var inst_25389__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25388,inst_25387__$1);
var state_25408__$1 = (function (){var statearr_25424 = state_25408;
(statearr_25424[(11)] = inst_25389__$1);

(statearr_25424[(7)] = inst_25387__$1);

return statearr_25424;
})();
if(cljs.core.truth_(inst_25389__$1)){
var statearr_25425_25468 = state_25408__$1;
(statearr_25425_25468[(1)] = (19));

} else {
var statearr_25426_25469 = state_25408__$1;
(statearr_25426_25469[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (25))){
var inst_25398 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25427_25470 = state_25408__$1;
(statearr_25427_25470[(2)] = inst_25398);

(statearr_25427_25470[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (17))){
var inst_25363 = (state_25408[(10)]);
var inst_25372 = cljs.core.first(inst_25363);
var inst_25373 = cljs.core.async.muxch_STAR_(inst_25372);
var inst_25374 = cljs.core.async.close_BANG_(inst_25373);
var inst_25375 = cljs.core.next(inst_25363);
var inst_25349 = inst_25375;
var inst_25350 = null;
var inst_25351 = (0);
var inst_25352 = (0);
var state_25408__$1 = (function (){var statearr_25428 = state_25408;
(statearr_25428[(12)] = inst_25374);

(statearr_25428[(13)] = inst_25349);

(statearr_25428[(14)] = inst_25350);

(statearr_25428[(15)] = inst_25351);

(statearr_25428[(16)] = inst_25352);

return statearr_25428;
})();
var statearr_25429_25471 = state_25408__$1;
(statearr_25429_25471[(2)] = null);

(statearr_25429_25471[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (3))){
var inst_25406 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25408__$1,inst_25406);
} else {
if((state_val_25409 === (12))){
var inst_25383 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25430_25472 = state_25408__$1;
(statearr_25430_25472[(2)] = inst_25383);

(statearr_25430_25472[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (2))){
var state_25408__$1 = state_25408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25408__$1,(4),ch);
} else {
if((state_val_25409 === (23))){
var state_25408__$1 = state_25408;
var statearr_25431_25473 = state_25408__$1;
(statearr_25431_25473[(2)] = null);

(statearr_25431_25473[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (19))){
var inst_25339 = (state_25408[(8)]);
var inst_25389 = (state_25408[(11)]);
var inst_25391 = cljs.core.async.muxch_STAR_(inst_25389);
var state_25408__$1 = state_25408;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25408__$1,(22),inst_25391,inst_25339);
} else {
if((state_val_25409 === (11))){
var inst_25363 = (state_25408[(10)]);
var inst_25349 = (state_25408[(13)]);
var inst_25363__$1 = cljs.core.seq(inst_25349);
var state_25408__$1 = (function (){var statearr_25432 = state_25408;
(statearr_25432[(10)] = inst_25363__$1);

return statearr_25432;
})();
if(inst_25363__$1){
var statearr_25433_25474 = state_25408__$1;
(statearr_25433_25474[(1)] = (13));

} else {
var statearr_25434_25475 = state_25408__$1;
(statearr_25434_25475[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (9))){
var inst_25385 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25435_25476 = state_25408__$1;
(statearr_25435_25476[(2)] = inst_25385);

(statearr_25435_25476[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (5))){
var inst_25346 = cljs.core.deref(mults);
var inst_25347 = cljs.core.vals(inst_25346);
var inst_25348 = cljs.core.seq(inst_25347);
var inst_25349 = inst_25348;
var inst_25350 = null;
var inst_25351 = (0);
var inst_25352 = (0);
var state_25408__$1 = (function (){var statearr_25436 = state_25408;
(statearr_25436[(13)] = inst_25349);

(statearr_25436[(14)] = inst_25350);

(statearr_25436[(15)] = inst_25351);

(statearr_25436[(16)] = inst_25352);

return statearr_25436;
})();
var statearr_25437_25477 = state_25408__$1;
(statearr_25437_25477[(2)] = null);

(statearr_25437_25477[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (14))){
var state_25408__$1 = state_25408;
var statearr_25441_25478 = state_25408__$1;
(statearr_25441_25478[(2)] = null);

(statearr_25441_25478[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (16))){
var inst_25363 = (state_25408[(10)]);
var inst_25367 = cljs.core.chunk_first(inst_25363);
var inst_25368 = cljs.core.chunk_rest(inst_25363);
var inst_25369 = cljs.core.count(inst_25367);
var inst_25349 = inst_25368;
var inst_25350 = inst_25367;
var inst_25351 = inst_25369;
var inst_25352 = (0);
var state_25408__$1 = (function (){var statearr_25442 = state_25408;
(statearr_25442[(13)] = inst_25349);

(statearr_25442[(14)] = inst_25350);

(statearr_25442[(15)] = inst_25351);

(statearr_25442[(16)] = inst_25352);

return statearr_25442;
})();
var statearr_25443_25479 = state_25408__$1;
(statearr_25443_25479[(2)] = null);

(statearr_25443_25479[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (10))){
var inst_25349 = (state_25408[(13)]);
var inst_25350 = (state_25408[(14)]);
var inst_25351 = (state_25408[(15)]);
var inst_25352 = (state_25408[(16)]);
var inst_25357 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_25350,inst_25352);
var inst_25358 = cljs.core.async.muxch_STAR_(inst_25357);
var inst_25359 = cljs.core.async.close_BANG_(inst_25358);
var inst_25360 = (inst_25352 + (1));
var tmp25438 = inst_25349;
var tmp25439 = inst_25350;
var tmp25440 = inst_25351;
var inst_25349__$1 = tmp25438;
var inst_25350__$1 = tmp25439;
var inst_25351__$1 = tmp25440;
var inst_25352__$1 = inst_25360;
var state_25408__$1 = (function (){var statearr_25444 = state_25408;
(statearr_25444[(13)] = inst_25349__$1);

(statearr_25444[(14)] = inst_25350__$1);

(statearr_25444[(17)] = inst_25359);

(statearr_25444[(15)] = inst_25351__$1);

(statearr_25444[(16)] = inst_25352__$1);

return statearr_25444;
})();
var statearr_25445_25480 = state_25408__$1;
(statearr_25445_25480[(2)] = null);

(statearr_25445_25480[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (18))){
var inst_25378 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25446_25481 = state_25408__$1;
(statearr_25446_25481[(2)] = inst_25378);

(statearr_25446_25481[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25409 === (8))){
var inst_25351 = (state_25408[(15)]);
var inst_25352 = (state_25408[(16)]);
var inst_25354 = (inst_25352 < inst_25351);
var inst_25355 = inst_25354;
var state_25408__$1 = state_25408;
if(cljs.core.truth_(inst_25355)){
var statearr_25447_25482 = state_25408__$1;
(statearr_25447_25482[(1)] = (10));

} else {
var statearr_25448_25483 = state_25408__$1;
(statearr_25448_25483[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_25449 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25449[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_25449[(1)] = (1));

return statearr_25449;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_25408){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25408);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25450){var ex__24179__auto__ = e25450;
var statearr_25451_25484 = state_25408;
(statearr_25451_25484[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25408[(4)]))){
var statearr_25452_25485 = state_25408;
(statearr_25452_25485[(1)] = cljs.core.first((state_25408[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25486 = state_25408;
state_25408 = G__25486;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_25408){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_25408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25453 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25453[(6)] = c__24250__auto___25455);

return statearr_25453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__25488 = arguments.length;
switch (G__25488) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__25491 = arguments.length;
switch (G__25491) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__25494 = arguments.length;
switch (G__25494) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__24250__auto___25572 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25537){
var state_val_25538 = (state_25537[(1)]);
if((state_val_25538 === (7))){
var state_25537__$1 = state_25537;
var statearr_25539_25573 = state_25537__$1;
(statearr_25539_25573[(2)] = null);

(statearr_25539_25573[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (1))){
var state_25537__$1 = state_25537;
var statearr_25540_25574 = state_25537__$1;
(statearr_25540_25574[(2)] = null);

(statearr_25540_25574[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (4))){
var inst_25498 = (state_25537[(7)]);
var inst_25497 = (state_25537[(8)]);
var inst_25500 = (inst_25498 < inst_25497);
var state_25537__$1 = state_25537;
if(cljs.core.truth_(inst_25500)){
var statearr_25541_25575 = state_25537__$1;
(statearr_25541_25575[(1)] = (6));

} else {
var statearr_25542_25576 = state_25537__$1;
(statearr_25542_25576[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (15))){
var inst_25523 = (state_25537[(9)]);
var inst_25528 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_25523);
var state_25537__$1 = state_25537;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25537__$1,(17),out,inst_25528);
} else {
if((state_val_25538 === (13))){
var inst_25523 = (state_25537[(9)]);
var inst_25523__$1 = (state_25537[(2)]);
var inst_25524 = cljs.core.some(cljs.core.nil_QMARK_,inst_25523__$1);
var state_25537__$1 = (function (){var statearr_25543 = state_25537;
(statearr_25543[(9)] = inst_25523__$1);

return statearr_25543;
})();
if(cljs.core.truth_(inst_25524)){
var statearr_25544_25577 = state_25537__$1;
(statearr_25544_25577[(1)] = (14));

} else {
var statearr_25545_25578 = state_25537__$1;
(statearr_25545_25578[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (6))){
var state_25537__$1 = state_25537;
var statearr_25546_25579 = state_25537__$1;
(statearr_25546_25579[(2)] = null);

(statearr_25546_25579[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (17))){
var inst_25530 = (state_25537[(2)]);
var state_25537__$1 = (function (){var statearr_25548 = state_25537;
(statearr_25548[(10)] = inst_25530);

return statearr_25548;
})();
var statearr_25549_25580 = state_25537__$1;
(statearr_25549_25580[(2)] = null);

(statearr_25549_25580[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (3))){
var inst_25535 = (state_25537[(2)]);
var state_25537__$1 = state_25537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25537__$1,inst_25535);
} else {
if((state_val_25538 === (12))){
var _ = (function (){var statearr_25550 = state_25537;
(statearr_25550[(4)] = cljs.core.rest((state_25537[(4)])));

return statearr_25550;
})();
var state_25537__$1 = state_25537;
var ex25547 = (state_25537__$1[(2)]);
var statearr_25551_25581 = state_25537__$1;
(statearr_25551_25581[(5)] = ex25547);


if((ex25547 instanceof Object)){
var statearr_25552_25582 = state_25537__$1;
(statearr_25552_25582[(1)] = (11));

(statearr_25552_25582[(5)] = null);

} else {
throw ex25547;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (2))){
var inst_25496 = cljs.core.reset_BANG_(dctr,cnt);
var inst_25497 = cnt;
var inst_25498 = (0);
var state_25537__$1 = (function (){var statearr_25553 = state_25537;
(statearr_25553[(7)] = inst_25498);

(statearr_25553[(8)] = inst_25497);

(statearr_25553[(11)] = inst_25496);

return statearr_25553;
})();
var statearr_25554_25583 = state_25537__$1;
(statearr_25554_25583[(2)] = null);

(statearr_25554_25583[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (11))){
var inst_25502 = (state_25537[(2)]);
var inst_25503 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_25537__$1 = (function (){var statearr_25555 = state_25537;
(statearr_25555[(12)] = inst_25502);

return statearr_25555;
})();
var statearr_25556_25584 = state_25537__$1;
(statearr_25556_25584[(2)] = inst_25503);

(statearr_25556_25584[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (9))){
var inst_25498 = (state_25537[(7)]);
var _ = (function (){var statearr_25557 = state_25537;
(statearr_25557[(4)] = cljs.core.cons((12),(state_25537[(4)])));

return statearr_25557;
})();
var inst_25509 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_25498) : chs__$1.call(null,inst_25498));
var inst_25510 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_25498) : done.call(null,inst_25498));
var inst_25511 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25509,inst_25510);
var ___$1 = (function (){var statearr_25558 = state_25537;
(statearr_25558[(4)] = cljs.core.rest((state_25537[(4)])));

return statearr_25558;
})();
var state_25537__$1 = state_25537;
var statearr_25559_25585 = state_25537__$1;
(statearr_25559_25585[(2)] = inst_25511);

(statearr_25559_25585[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (5))){
var inst_25521 = (state_25537[(2)]);
var state_25537__$1 = (function (){var statearr_25560 = state_25537;
(statearr_25560[(13)] = inst_25521);

return statearr_25560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25537__$1,(13),dchan);
} else {
if((state_val_25538 === (14))){
var inst_25526 = cljs.core.async.close_BANG_(out);
var state_25537__$1 = state_25537;
var statearr_25561_25586 = state_25537__$1;
(statearr_25561_25586[(2)] = inst_25526);

(statearr_25561_25586[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (16))){
var inst_25533 = (state_25537[(2)]);
var state_25537__$1 = state_25537;
var statearr_25562_25587 = state_25537__$1;
(statearr_25562_25587[(2)] = inst_25533);

(statearr_25562_25587[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (10))){
var inst_25498 = (state_25537[(7)]);
var inst_25514 = (state_25537[(2)]);
var inst_25515 = (inst_25498 + (1));
var inst_25498__$1 = inst_25515;
var state_25537__$1 = (function (){var statearr_25563 = state_25537;
(statearr_25563[(14)] = inst_25514);

(statearr_25563[(7)] = inst_25498__$1);

return statearr_25563;
})();
var statearr_25564_25588 = state_25537__$1;
(statearr_25564_25588[(2)] = null);

(statearr_25564_25588[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25538 === (8))){
var inst_25519 = (state_25537[(2)]);
var state_25537__$1 = state_25537;
var statearr_25565_25589 = state_25537__$1;
(statearr_25565_25589[(2)] = inst_25519);

(statearr_25565_25589[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_25566 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25566[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_25566[(1)] = (1));

return statearr_25566;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_25537){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25537);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25567){var ex__24179__auto__ = e25567;
var statearr_25568_25590 = state_25537;
(statearr_25568_25590[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25537[(4)]))){
var statearr_25569_25591 = state_25537;
(statearr_25569_25591[(1)] = cljs.core.first((state_25537[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25592 = state_25537;
state_25537 = G__25592;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_25537){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_25537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25570 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25570[(6)] = c__24250__auto___25572);

return statearr_25570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__25595 = arguments.length;
switch (G__25595) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24250__auto___25650 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25627){
var state_val_25628 = (state_25627[(1)]);
if((state_val_25628 === (7))){
var inst_25607 = (state_25627[(7)]);
var inst_25606 = (state_25627[(8)]);
var inst_25606__$1 = (state_25627[(2)]);
var inst_25607__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25606__$1,(0),null);
var inst_25608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25606__$1,(1),null);
var inst_25609 = (inst_25607__$1 == null);
var state_25627__$1 = (function (){var statearr_25629 = state_25627;
(statearr_25629[(9)] = inst_25608);

(statearr_25629[(7)] = inst_25607__$1);

(statearr_25629[(8)] = inst_25606__$1);

return statearr_25629;
})();
if(cljs.core.truth_(inst_25609)){
var statearr_25630_25651 = state_25627__$1;
(statearr_25630_25651[(1)] = (8));

} else {
var statearr_25631_25652 = state_25627__$1;
(statearr_25631_25652[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25628 === (1))){
var inst_25596 = cljs.core.vec(chs);
var inst_25597 = inst_25596;
var state_25627__$1 = (function (){var statearr_25632 = state_25627;
(statearr_25632[(10)] = inst_25597);

return statearr_25632;
})();
var statearr_25633_25653 = state_25627__$1;
(statearr_25633_25653[(2)] = null);

(statearr_25633_25653[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25628 === (4))){
var inst_25597 = (state_25627[(10)]);
var state_25627__$1 = state_25627;
return cljs.core.async.ioc_alts_BANG_(state_25627__$1,(7),inst_25597);
} else {
if((state_val_25628 === (6))){
var inst_25623 = (state_25627[(2)]);
var state_25627__$1 = state_25627;
var statearr_25634_25654 = state_25627__$1;
(statearr_25634_25654[(2)] = inst_25623);

(statearr_25634_25654[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25628 === (3))){
var inst_25625 = (state_25627[(2)]);
var state_25627__$1 = state_25627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25627__$1,inst_25625);
} else {
if((state_val_25628 === (2))){
var inst_25597 = (state_25627[(10)]);
var inst_25599 = cljs.core.count(inst_25597);
var inst_25600 = (inst_25599 > (0));
var state_25627__$1 = state_25627;
if(cljs.core.truth_(inst_25600)){
var statearr_25636_25655 = state_25627__$1;
(statearr_25636_25655[(1)] = (4));

} else {
var statearr_25637_25656 = state_25627__$1;
(statearr_25637_25656[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25628 === (11))){
var inst_25597 = (state_25627[(10)]);
var inst_25616 = (state_25627[(2)]);
var tmp25635 = inst_25597;
var inst_25597__$1 = tmp25635;
var state_25627__$1 = (function (){var statearr_25638 = state_25627;
(statearr_25638[(11)] = inst_25616);

(statearr_25638[(10)] = inst_25597__$1);

return statearr_25638;
})();
var statearr_25639_25657 = state_25627__$1;
(statearr_25639_25657[(2)] = null);

(statearr_25639_25657[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25628 === (9))){
var inst_25607 = (state_25627[(7)]);
var state_25627__$1 = state_25627;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25627__$1,(11),out,inst_25607);
} else {
if((state_val_25628 === (5))){
var inst_25621 = cljs.core.async.close_BANG_(out);
var state_25627__$1 = state_25627;
var statearr_25640_25658 = state_25627__$1;
(statearr_25640_25658[(2)] = inst_25621);

(statearr_25640_25658[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25628 === (10))){
var inst_25619 = (state_25627[(2)]);
var state_25627__$1 = state_25627;
var statearr_25641_25659 = state_25627__$1;
(statearr_25641_25659[(2)] = inst_25619);

(statearr_25641_25659[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25628 === (8))){
var inst_25597 = (state_25627[(10)]);
var inst_25608 = (state_25627[(9)]);
var inst_25607 = (state_25627[(7)]);
var inst_25606 = (state_25627[(8)]);
var inst_25611 = (function (){var cs = inst_25597;
var vec__25602 = inst_25606;
var v = inst_25607;
var c = inst_25608;
return (function (p1__25593_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__25593_SHARP_);
});
})();
var inst_25612 = cljs.core.filterv(inst_25611,inst_25597);
var inst_25597__$1 = inst_25612;
var state_25627__$1 = (function (){var statearr_25642 = state_25627;
(statearr_25642[(10)] = inst_25597__$1);

return statearr_25642;
})();
var statearr_25643_25660 = state_25627__$1;
(statearr_25643_25660[(2)] = null);

(statearr_25643_25660[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_25644 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25644[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_25644[(1)] = (1));

return statearr_25644;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_25627){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25627);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25645){var ex__24179__auto__ = e25645;
var statearr_25646_25661 = state_25627;
(statearr_25646_25661[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25627[(4)]))){
var statearr_25647_25662 = state_25627;
(statearr_25647_25662[(1)] = cljs.core.first((state_25627[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25663 = state_25627;
state_25627 = G__25663;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_25627){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_25627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25648 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25648[(6)] = c__24250__auto___25650);

return statearr_25648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__25665 = arguments.length;
switch (G__25665) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24250__auto___25711 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25689){
var state_val_25690 = (state_25689[(1)]);
if((state_val_25690 === (7))){
var inst_25671 = (state_25689[(7)]);
var inst_25671__$1 = (state_25689[(2)]);
var inst_25672 = (inst_25671__$1 == null);
var inst_25673 = cljs.core.not(inst_25672);
var state_25689__$1 = (function (){var statearr_25691 = state_25689;
(statearr_25691[(7)] = inst_25671__$1);

return statearr_25691;
})();
if(inst_25673){
var statearr_25692_25712 = state_25689__$1;
(statearr_25692_25712[(1)] = (8));

} else {
var statearr_25693_25713 = state_25689__$1;
(statearr_25693_25713[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25690 === (1))){
var inst_25666 = (0);
var state_25689__$1 = (function (){var statearr_25694 = state_25689;
(statearr_25694[(8)] = inst_25666);

return statearr_25694;
})();
var statearr_25695_25714 = state_25689__$1;
(statearr_25695_25714[(2)] = null);

(statearr_25695_25714[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25690 === (4))){
var state_25689__$1 = state_25689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25689__$1,(7),ch);
} else {
if((state_val_25690 === (6))){
var inst_25684 = (state_25689[(2)]);
var state_25689__$1 = state_25689;
var statearr_25696_25715 = state_25689__$1;
(statearr_25696_25715[(2)] = inst_25684);

(statearr_25696_25715[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25690 === (3))){
var inst_25686 = (state_25689[(2)]);
var inst_25687 = cljs.core.async.close_BANG_(out);
var state_25689__$1 = (function (){var statearr_25697 = state_25689;
(statearr_25697[(9)] = inst_25686);

return statearr_25697;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_25689__$1,inst_25687);
} else {
if((state_val_25690 === (2))){
var inst_25666 = (state_25689[(8)]);
var inst_25668 = (inst_25666 < n);
var state_25689__$1 = state_25689;
if(cljs.core.truth_(inst_25668)){
var statearr_25698_25716 = state_25689__$1;
(statearr_25698_25716[(1)] = (4));

} else {
var statearr_25699_25717 = state_25689__$1;
(statearr_25699_25717[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25690 === (11))){
var inst_25666 = (state_25689[(8)]);
var inst_25676 = (state_25689[(2)]);
var inst_25677 = (inst_25666 + (1));
var inst_25666__$1 = inst_25677;
var state_25689__$1 = (function (){var statearr_25700 = state_25689;
(statearr_25700[(10)] = inst_25676);

(statearr_25700[(8)] = inst_25666__$1);

return statearr_25700;
})();
var statearr_25701_25718 = state_25689__$1;
(statearr_25701_25718[(2)] = null);

(statearr_25701_25718[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25690 === (9))){
var state_25689__$1 = state_25689;
var statearr_25702_25719 = state_25689__$1;
(statearr_25702_25719[(2)] = null);

(statearr_25702_25719[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25690 === (5))){
var state_25689__$1 = state_25689;
var statearr_25703_25720 = state_25689__$1;
(statearr_25703_25720[(2)] = null);

(statearr_25703_25720[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25690 === (10))){
var inst_25681 = (state_25689[(2)]);
var state_25689__$1 = state_25689;
var statearr_25704_25721 = state_25689__$1;
(statearr_25704_25721[(2)] = inst_25681);

(statearr_25704_25721[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25690 === (8))){
var inst_25671 = (state_25689[(7)]);
var state_25689__$1 = state_25689;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25689__$1,(11),out,inst_25671);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_25705 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25705[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_25705[(1)] = (1));

return statearr_25705;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_25689){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25689);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25706){var ex__24179__auto__ = e25706;
var statearr_25707_25722 = state_25689;
(statearr_25707_25722[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25689[(4)]))){
var statearr_25708_25723 = state_25689;
(statearr_25708_25723[(1)] = cljs.core.first((state_25689[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25724 = state_25689;
state_25689 = G__25724;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_25689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_25689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25709 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25709[(6)] = c__24250__auto___25711);

return statearr_25709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25726 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25726 = (function (f,ch,meta25727){
this.f = f;
this.ch = ch;
this.meta25727 = meta25727;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25728,meta25727__$1){
var self__ = this;
var _25728__$1 = this;
return (new cljs.core.async.t_cljs$core$async25726(self__.f,self__.ch,meta25727__$1));
}));

(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25728){
var self__ = this;
var _25728__$1 = this;
return self__.meta25727;
}));

(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25729 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25729 = (function (f,ch,meta25727,_,fn1,meta25730){
this.f = f;
this.ch = ch;
this.meta25727 = meta25727;
this._ = _;
this.fn1 = fn1;
this.meta25730 = meta25730;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25729.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25731,meta25730__$1){
var self__ = this;
var _25731__$1 = this;
return (new cljs.core.async.t_cljs$core$async25729(self__.f,self__.ch,self__.meta25727,self__._,self__.fn1,meta25730__$1));
}));

(cljs.core.async.t_cljs$core$async25729.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25731){
var self__ = this;
var _25731__$1 = this;
return self__.meta25730;
}));

(cljs.core.async.t_cljs$core$async25729.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25729.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async25729.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async25729.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__25725_SHARP_){
var G__25732 = (((p1__25725_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__25725_SHARP_) : self__.f.call(null,p1__25725_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__25732) : f1.call(null,G__25732));
});
}));

(cljs.core.async.t_cljs$core$async25729.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta25727,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async25726], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta25730], null);
}));

(cljs.core.async.t_cljs$core$async25729.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25729.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25729");

(cljs.core.async.t_cljs$core$async25729.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async25729");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25729.
 */
cljs.core.async.__GT_t_cljs$core$async25729 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25729(f__$1,ch__$1,meta25727__$1,___$2,fn1__$1,meta25730){
return (new cljs.core.async.t_cljs$core$async25729(f__$1,ch__$1,meta25727__$1,___$2,fn1__$1,meta25730));
});

}

return (new cljs.core.async.t_cljs$core$async25729(self__.f,self__.ch,self__.meta25727,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__25733 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__25733) : self__.f.call(null,G__25733));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25726.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async25726.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta25727], null);
}));

(cljs.core.async.t_cljs$core$async25726.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25726.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25726");

(cljs.core.async.t_cljs$core$async25726.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async25726");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25726.
 */
cljs.core.async.__GT_t_cljs$core$async25726 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25726(f__$1,ch__$1,meta25727){
return (new cljs.core.async.t_cljs$core$async25726(f__$1,ch__$1,meta25727));
});

}

return (new cljs.core.async.t_cljs$core$async25726(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25734 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25734 = (function (f,ch,meta25735){
this.f = f;
this.ch = ch;
this.meta25735 = meta25735;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25734.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25736,meta25735__$1){
var self__ = this;
var _25736__$1 = this;
return (new cljs.core.async.t_cljs$core$async25734(self__.f,self__.ch,meta25735__$1));
}));

(cljs.core.async.t_cljs$core$async25734.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25736){
var self__ = this;
var _25736__$1 = this;
return self__.meta25735;
}));

(cljs.core.async.t_cljs$core$async25734.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25734.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async25734.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25734.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async25734.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25734.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async25734.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta25735], null);
}));

(cljs.core.async.t_cljs$core$async25734.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25734.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25734");

(cljs.core.async.t_cljs$core$async25734.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async25734");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25734.
 */
cljs.core.async.__GT_t_cljs$core$async25734 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async25734(f__$1,ch__$1,meta25735){
return (new cljs.core.async.t_cljs$core$async25734(f__$1,ch__$1,meta25735));
});

}

return (new cljs.core.async.t_cljs$core$async25734(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25737 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25737 = (function (p,ch,meta25738){
this.p = p;
this.ch = ch;
this.meta25738 = meta25738;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25739,meta25738__$1){
var self__ = this;
var _25739__$1 = this;
return (new cljs.core.async.t_cljs$core$async25737(self__.p,self__.ch,meta25738__$1));
}));

(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25739){
var self__ = this;
var _25739__$1 = this;
return self__.meta25738;
}));

(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25737.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async25737.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta25738], null);
}));

(cljs.core.async.t_cljs$core$async25737.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25737.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25737");

(cljs.core.async.t_cljs$core$async25737.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async25737");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25737.
 */
cljs.core.async.__GT_t_cljs$core$async25737 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async25737(p__$1,ch__$1,meta25738){
return (new cljs.core.async.t_cljs$core$async25737(p__$1,ch__$1,meta25738));
});

}

return (new cljs.core.async.t_cljs$core$async25737(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__25741 = arguments.length;
switch (G__25741) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24250__auto___25782 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25762){
var state_val_25763 = (state_25762[(1)]);
if((state_val_25763 === (7))){
var inst_25758 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25764_25783 = state_25762__$1;
(statearr_25764_25783[(2)] = inst_25758);

(statearr_25764_25783[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (1))){
var state_25762__$1 = state_25762;
var statearr_25765_25784 = state_25762__$1;
(statearr_25765_25784[(2)] = null);

(statearr_25765_25784[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (4))){
var inst_25744 = (state_25762[(7)]);
var inst_25744__$1 = (state_25762[(2)]);
var inst_25745 = (inst_25744__$1 == null);
var state_25762__$1 = (function (){var statearr_25766 = state_25762;
(statearr_25766[(7)] = inst_25744__$1);

return statearr_25766;
})();
if(cljs.core.truth_(inst_25745)){
var statearr_25767_25785 = state_25762__$1;
(statearr_25767_25785[(1)] = (5));

} else {
var statearr_25768_25786 = state_25762__$1;
(statearr_25768_25786[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (6))){
var inst_25744 = (state_25762[(7)]);
var inst_25749 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_25744) : p.call(null,inst_25744));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25749)){
var statearr_25769_25787 = state_25762__$1;
(statearr_25769_25787[(1)] = (8));

} else {
var statearr_25770_25788 = state_25762__$1;
(statearr_25770_25788[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (3))){
var inst_25760 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25762__$1,inst_25760);
} else {
if((state_val_25763 === (2))){
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25762__$1,(4),ch);
} else {
if((state_val_25763 === (11))){
var inst_25752 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25771_25789 = state_25762__$1;
(statearr_25771_25789[(2)] = inst_25752);

(statearr_25771_25789[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (9))){
var state_25762__$1 = state_25762;
var statearr_25772_25790 = state_25762__$1;
(statearr_25772_25790[(2)] = null);

(statearr_25772_25790[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (5))){
var inst_25747 = cljs.core.async.close_BANG_(out);
var state_25762__$1 = state_25762;
var statearr_25773_25791 = state_25762__$1;
(statearr_25773_25791[(2)] = inst_25747);

(statearr_25773_25791[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (10))){
var inst_25755 = (state_25762[(2)]);
var state_25762__$1 = (function (){var statearr_25774 = state_25762;
(statearr_25774[(8)] = inst_25755);

return statearr_25774;
})();
var statearr_25775_25792 = state_25762__$1;
(statearr_25775_25792[(2)] = null);

(statearr_25775_25792[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (8))){
var inst_25744 = (state_25762[(7)]);
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25762__$1,(11),out,inst_25744);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_25776 = [null,null,null,null,null,null,null,null,null];
(statearr_25776[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_25776[(1)] = (1));

return statearr_25776;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_25762){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25762);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25777){var ex__24179__auto__ = e25777;
var statearr_25778_25793 = state_25762;
(statearr_25778_25793[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25762[(4)]))){
var statearr_25779_25794 = state_25762;
(statearr_25779_25794[(1)] = cljs.core.first((state_25762[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25795 = state_25762;
state_25762 = G__25795;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_25762){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_25762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25780 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25780[(6)] = c__24250__auto___25782);

return statearr_25780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__25797 = arguments.length;
switch (G__25797) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25860){
var state_val_25861 = (state_25860[(1)]);
if((state_val_25861 === (7))){
var inst_25856 = (state_25860[(2)]);
var state_25860__$1 = state_25860;
var statearr_25862_25901 = state_25860__$1;
(statearr_25862_25901[(2)] = inst_25856);

(statearr_25862_25901[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (20))){
var inst_25826 = (state_25860[(7)]);
var inst_25837 = (state_25860[(2)]);
var inst_25838 = cljs.core.next(inst_25826);
var inst_25812 = inst_25838;
var inst_25813 = null;
var inst_25814 = (0);
var inst_25815 = (0);
var state_25860__$1 = (function (){var statearr_25863 = state_25860;
(statearr_25863[(8)] = inst_25812);

(statearr_25863[(9)] = inst_25814);

(statearr_25863[(10)] = inst_25813);

(statearr_25863[(11)] = inst_25837);

(statearr_25863[(12)] = inst_25815);

return statearr_25863;
})();
var statearr_25864_25902 = state_25860__$1;
(statearr_25864_25902[(2)] = null);

(statearr_25864_25902[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (1))){
var state_25860__$1 = state_25860;
var statearr_25865_25903 = state_25860__$1;
(statearr_25865_25903[(2)] = null);

(statearr_25865_25903[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (4))){
var inst_25801 = (state_25860[(13)]);
var inst_25801__$1 = (state_25860[(2)]);
var inst_25802 = (inst_25801__$1 == null);
var state_25860__$1 = (function (){var statearr_25866 = state_25860;
(statearr_25866[(13)] = inst_25801__$1);

return statearr_25866;
})();
if(cljs.core.truth_(inst_25802)){
var statearr_25867_25904 = state_25860__$1;
(statearr_25867_25904[(1)] = (5));

} else {
var statearr_25868_25905 = state_25860__$1;
(statearr_25868_25905[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (15))){
var state_25860__$1 = state_25860;
var statearr_25872_25906 = state_25860__$1;
(statearr_25872_25906[(2)] = null);

(statearr_25872_25906[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (21))){
var state_25860__$1 = state_25860;
var statearr_25873_25907 = state_25860__$1;
(statearr_25873_25907[(2)] = null);

(statearr_25873_25907[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (13))){
var inst_25812 = (state_25860[(8)]);
var inst_25814 = (state_25860[(9)]);
var inst_25813 = (state_25860[(10)]);
var inst_25815 = (state_25860[(12)]);
var inst_25822 = (state_25860[(2)]);
var inst_25823 = (inst_25815 + (1));
var tmp25869 = inst_25812;
var tmp25870 = inst_25814;
var tmp25871 = inst_25813;
var inst_25812__$1 = tmp25869;
var inst_25813__$1 = tmp25871;
var inst_25814__$1 = tmp25870;
var inst_25815__$1 = inst_25823;
var state_25860__$1 = (function (){var statearr_25874 = state_25860;
(statearr_25874[(8)] = inst_25812__$1);

(statearr_25874[(14)] = inst_25822);

(statearr_25874[(9)] = inst_25814__$1);

(statearr_25874[(10)] = inst_25813__$1);

(statearr_25874[(12)] = inst_25815__$1);

return statearr_25874;
})();
var statearr_25875_25908 = state_25860__$1;
(statearr_25875_25908[(2)] = null);

(statearr_25875_25908[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (22))){
var state_25860__$1 = state_25860;
var statearr_25876_25909 = state_25860__$1;
(statearr_25876_25909[(2)] = null);

(statearr_25876_25909[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (6))){
var inst_25801 = (state_25860[(13)]);
var inst_25810 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_25801) : f.call(null,inst_25801));
var inst_25811 = cljs.core.seq(inst_25810);
var inst_25812 = inst_25811;
var inst_25813 = null;
var inst_25814 = (0);
var inst_25815 = (0);
var state_25860__$1 = (function (){var statearr_25877 = state_25860;
(statearr_25877[(8)] = inst_25812);

(statearr_25877[(9)] = inst_25814);

(statearr_25877[(10)] = inst_25813);

(statearr_25877[(12)] = inst_25815);

return statearr_25877;
})();
var statearr_25878_25910 = state_25860__$1;
(statearr_25878_25910[(2)] = null);

(statearr_25878_25910[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (17))){
var inst_25826 = (state_25860[(7)]);
var inst_25830 = cljs.core.chunk_first(inst_25826);
var inst_25831 = cljs.core.chunk_rest(inst_25826);
var inst_25832 = cljs.core.count(inst_25830);
var inst_25812 = inst_25831;
var inst_25813 = inst_25830;
var inst_25814 = inst_25832;
var inst_25815 = (0);
var state_25860__$1 = (function (){var statearr_25879 = state_25860;
(statearr_25879[(8)] = inst_25812);

(statearr_25879[(9)] = inst_25814);

(statearr_25879[(10)] = inst_25813);

(statearr_25879[(12)] = inst_25815);

return statearr_25879;
})();
var statearr_25880_25911 = state_25860__$1;
(statearr_25880_25911[(2)] = null);

(statearr_25880_25911[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (3))){
var inst_25858 = (state_25860[(2)]);
var state_25860__$1 = state_25860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25860__$1,inst_25858);
} else {
if((state_val_25861 === (12))){
var inst_25846 = (state_25860[(2)]);
var state_25860__$1 = state_25860;
var statearr_25881_25912 = state_25860__$1;
(statearr_25881_25912[(2)] = inst_25846);

(statearr_25881_25912[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (2))){
var state_25860__$1 = state_25860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25860__$1,(4),in$);
} else {
if((state_val_25861 === (23))){
var inst_25854 = (state_25860[(2)]);
var state_25860__$1 = state_25860;
var statearr_25882_25913 = state_25860__$1;
(statearr_25882_25913[(2)] = inst_25854);

(statearr_25882_25913[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (19))){
var inst_25841 = (state_25860[(2)]);
var state_25860__$1 = state_25860;
var statearr_25883_25914 = state_25860__$1;
(statearr_25883_25914[(2)] = inst_25841);

(statearr_25883_25914[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (11))){
var inst_25812 = (state_25860[(8)]);
var inst_25826 = (state_25860[(7)]);
var inst_25826__$1 = cljs.core.seq(inst_25812);
var state_25860__$1 = (function (){var statearr_25884 = state_25860;
(statearr_25884[(7)] = inst_25826__$1);

return statearr_25884;
})();
if(inst_25826__$1){
var statearr_25885_25915 = state_25860__$1;
(statearr_25885_25915[(1)] = (14));

} else {
var statearr_25886_25916 = state_25860__$1;
(statearr_25886_25916[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (9))){
var inst_25848 = (state_25860[(2)]);
var inst_25849 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_25860__$1 = (function (){var statearr_25887 = state_25860;
(statearr_25887[(15)] = inst_25848);

return statearr_25887;
})();
if(cljs.core.truth_(inst_25849)){
var statearr_25888_25917 = state_25860__$1;
(statearr_25888_25917[(1)] = (21));

} else {
var statearr_25889_25918 = state_25860__$1;
(statearr_25889_25918[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (5))){
var inst_25804 = cljs.core.async.close_BANG_(out);
var state_25860__$1 = state_25860;
var statearr_25890_25919 = state_25860__$1;
(statearr_25890_25919[(2)] = inst_25804);

(statearr_25890_25919[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (14))){
var inst_25826 = (state_25860[(7)]);
var inst_25828 = cljs.core.chunked_seq_QMARK_(inst_25826);
var state_25860__$1 = state_25860;
if(inst_25828){
var statearr_25891_25920 = state_25860__$1;
(statearr_25891_25920[(1)] = (17));

} else {
var statearr_25892_25921 = state_25860__$1;
(statearr_25892_25921[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (16))){
var inst_25844 = (state_25860[(2)]);
var state_25860__$1 = state_25860;
var statearr_25893_25922 = state_25860__$1;
(statearr_25893_25922[(2)] = inst_25844);

(statearr_25893_25922[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25861 === (10))){
var inst_25813 = (state_25860[(10)]);
var inst_25815 = (state_25860[(12)]);
var inst_25820 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_25813,inst_25815);
var state_25860__$1 = state_25860;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25860__$1,(13),out,inst_25820);
} else {
if((state_val_25861 === (18))){
var inst_25826 = (state_25860[(7)]);
var inst_25835 = cljs.core.first(inst_25826);
var state_25860__$1 = state_25860;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25860__$1,(20),out,inst_25835);
} else {
if((state_val_25861 === (8))){
var inst_25814 = (state_25860[(9)]);
var inst_25815 = (state_25860[(12)]);
var inst_25817 = (inst_25815 < inst_25814);
var inst_25818 = inst_25817;
var state_25860__$1 = state_25860;
if(cljs.core.truth_(inst_25818)){
var statearr_25894_25923 = state_25860__$1;
(statearr_25894_25923[(1)] = (10));

} else {
var statearr_25895_25924 = state_25860__$1;
(statearr_25895_25924[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__24176__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__24176__auto____0 = (function (){
var statearr_25896 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25896[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__24176__auto__);

(statearr_25896[(1)] = (1));

return statearr_25896;
});
var cljs$core$async$mapcat_STAR__$_state_machine__24176__auto____1 = (function (state_25860){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25860);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25897){var ex__24179__auto__ = e25897;
var statearr_25898_25925 = state_25860;
(statearr_25898_25925[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25860[(4)]))){
var statearr_25899_25926 = state_25860;
(statearr_25899_25926[(1)] = cljs.core.first((state_25860[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25927 = state_25860;
state_25860 = G__25927;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__24176__auto__ = function(state_25860){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__24176__auto____1.call(this,state_25860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__24176__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__24176__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25900 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25900[(6)] = c__24250__auto__);

return statearr_25900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__25929 = arguments.length;
switch (G__25929) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__25932 = arguments.length;
switch (G__25932) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__25935 = arguments.length;
switch (G__25935) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24250__auto___25983 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_25959){
var state_val_25960 = (state_25959[(1)]);
if((state_val_25960 === (7))){
var inst_25954 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_25961_25984 = state_25959__$1;
(statearr_25961_25984[(2)] = inst_25954);

(statearr_25961_25984[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25960 === (1))){
var inst_25936 = null;
var state_25959__$1 = (function (){var statearr_25962 = state_25959;
(statearr_25962[(7)] = inst_25936);

return statearr_25962;
})();
var statearr_25963_25985 = state_25959__$1;
(statearr_25963_25985[(2)] = null);

(statearr_25963_25985[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25960 === (4))){
var inst_25939 = (state_25959[(8)]);
var inst_25939__$1 = (state_25959[(2)]);
var inst_25940 = (inst_25939__$1 == null);
var inst_25941 = cljs.core.not(inst_25940);
var state_25959__$1 = (function (){var statearr_25964 = state_25959;
(statearr_25964[(8)] = inst_25939__$1);

return statearr_25964;
})();
if(inst_25941){
var statearr_25965_25986 = state_25959__$1;
(statearr_25965_25986[(1)] = (5));

} else {
var statearr_25966_25987 = state_25959__$1;
(statearr_25966_25987[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25960 === (6))){
var state_25959__$1 = state_25959;
var statearr_25967_25988 = state_25959__$1;
(statearr_25967_25988[(2)] = null);

(statearr_25967_25988[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25960 === (3))){
var inst_25956 = (state_25959[(2)]);
var inst_25957 = cljs.core.async.close_BANG_(out);
var state_25959__$1 = (function (){var statearr_25968 = state_25959;
(statearr_25968[(9)] = inst_25956);

return statearr_25968;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_25959__$1,inst_25957);
} else {
if((state_val_25960 === (2))){
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(4),ch);
} else {
if((state_val_25960 === (11))){
var inst_25939 = (state_25959[(8)]);
var inst_25948 = (state_25959[(2)]);
var inst_25936 = inst_25939;
var state_25959__$1 = (function (){var statearr_25969 = state_25959;
(statearr_25969[(7)] = inst_25936);

(statearr_25969[(10)] = inst_25948);

return statearr_25969;
})();
var statearr_25970_25989 = state_25959__$1;
(statearr_25970_25989[(2)] = null);

(statearr_25970_25989[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25960 === (9))){
var inst_25939 = (state_25959[(8)]);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25959__$1,(11),out,inst_25939);
} else {
if((state_val_25960 === (5))){
var inst_25936 = (state_25959[(7)]);
var inst_25939 = (state_25959[(8)]);
var inst_25943 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25939,inst_25936);
var state_25959__$1 = state_25959;
if(inst_25943){
var statearr_25972_25990 = state_25959__$1;
(statearr_25972_25990[(1)] = (8));

} else {
var statearr_25973_25991 = state_25959__$1;
(statearr_25973_25991[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25960 === (10))){
var inst_25951 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_25974_25992 = state_25959__$1;
(statearr_25974_25992[(2)] = inst_25951);

(statearr_25974_25992[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25960 === (8))){
var inst_25936 = (state_25959[(7)]);
var tmp25971 = inst_25936;
var inst_25936__$1 = tmp25971;
var state_25959__$1 = (function (){var statearr_25975 = state_25959;
(statearr_25975[(7)] = inst_25936__$1);

return statearr_25975;
})();
var statearr_25976_25993 = state_25959__$1;
(statearr_25976_25993[(2)] = null);

(statearr_25976_25993[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_25977 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25977[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_25977[(1)] = (1));

return statearr_25977;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_25959){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_25959);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e25978){var ex__24179__auto__ = e25978;
var statearr_25979_25994 = state_25959;
(statearr_25979_25994[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_25959[(4)]))){
var statearr_25980_25995 = state_25959;
(statearr_25980_25995[(1)] = cljs.core.first((state_25959[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__25996 = state_25959;
state_25959 = G__25996;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_25959){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_25959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_25981 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_25981[(6)] = c__24250__auto___25983);

return statearr_25981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__25998 = arguments.length;
switch (G__25998) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24250__auto___26065 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_26036){
var state_val_26037 = (state_26036[(1)]);
if((state_val_26037 === (7))){
var inst_26032 = (state_26036[(2)]);
var state_26036__$1 = state_26036;
var statearr_26038_26066 = state_26036__$1;
(statearr_26038_26066[(2)] = inst_26032);

(statearr_26038_26066[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (1))){
var inst_25999 = (new Array(n));
var inst_26000 = inst_25999;
var inst_26001 = (0);
var state_26036__$1 = (function (){var statearr_26039 = state_26036;
(statearr_26039[(7)] = inst_26001);

(statearr_26039[(8)] = inst_26000);

return statearr_26039;
})();
var statearr_26040_26067 = state_26036__$1;
(statearr_26040_26067[(2)] = null);

(statearr_26040_26067[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (4))){
var inst_26004 = (state_26036[(9)]);
var inst_26004__$1 = (state_26036[(2)]);
var inst_26005 = (inst_26004__$1 == null);
var inst_26006 = cljs.core.not(inst_26005);
var state_26036__$1 = (function (){var statearr_26041 = state_26036;
(statearr_26041[(9)] = inst_26004__$1);

return statearr_26041;
})();
if(inst_26006){
var statearr_26042_26068 = state_26036__$1;
(statearr_26042_26068[(1)] = (5));

} else {
var statearr_26043_26069 = state_26036__$1;
(statearr_26043_26069[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (15))){
var inst_26026 = (state_26036[(2)]);
var state_26036__$1 = state_26036;
var statearr_26044_26070 = state_26036__$1;
(statearr_26044_26070[(2)] = inst_26026);

(statearr_26044_26070[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (13))){
var state_26036__$1 = state_26036;
var statearr_26045_26071 = state_26036__$1;
(statearr_26045_26071[(2)] = null);

(statearr_26045_26071[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (6))){
var inst_26001 = (state_26036[(7)]);
var inst_26022 = (inst_26001 > (0));
var state_26036__$1 = state_26036;
if(cljs.core.truth_(inst_26022)){
var statearr_26046_26072 = state_26036__$1;
(statearr_26046_26072[(1)] = (12));

} else {
var statearr_26047_26073 = state_26036__$1;
(statearr_26047_26073[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (3))){
var inst_26034 = (state_26036[(2)]);
var state_26036__$1 = state_26036;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26036__$1,inst_26034);
} else {
if((state_val_26037 === (12))){
var inst_26000 = (state_26036[(8)]);
var inst_26024 = cljs.core.vec(inst_26000);
var state_26036__$1 = state_26036;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26036__$1,(15),out,inst_26024);
} else {
if((state_val_26037 === (2))){
var state_26036__$1 = state_26036;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26036__$1,(4),ch);
} else {
if((state_val_26037 === (11))){
var inst_26016 = (state_26036[(2)]);
var inst_26017 = (new Array(n));
var inst_26000 = inst_26017;
var inst_26001 = (0);
var state_26036__$1 = (function (){var statearr_26048 = state_26036;
(statearr_26048[(7)] = inst_26001);

(statearr_26048[(8)] = inst_26000);

(statearr_26048[(10)] = inst_26016);

return statearr_26048;
})();
var statearr_26049_26074 = state_26036__$1;
(statearr_26049_26074[(2)] = null);

(statearr_26049_26074[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (9))){
var inst_26000 = (state_26036[(8)]);
var inst_26014 = cljs.core.vec(inst_26000);
var state_26036__$1 = state_26036;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26036__$1,(11),out,inst_26014);
} else {
if((state_val_26037 === (5))){
var inst_26001 = (state_26036[(7)]);
var inst_26000 = (state_26036[(8)]);
var inst_26009 = (state_26036[(11)]);
var inst_26004 = (state_26036[(9)]);
var inst_26008 = (inst_26000[inst_26001] = inst_26004);
var inst_26009__$1 = (inst_26001 + (1));
var inst_26010 = (inst_26009__$1 < n);
var state_26036__$1 = (function (){var statearr_26050 = state_26036;
(statearr_26050[(11)] = inst_26009__$1);

(statearr_26050[(12)] = inst_26008);

return statearr_26050;
})();
if(cljs.core.truth_(inst_26010)){
var statearr_26051_26075 = state_26036__$1;
(statearr_26051_26075[(1)] = (8));

} else {
var statearr_26052_26076 = state_26036__$1;
(statearr_26052_26076[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (14))){
var inst_26029 = (state_26036[(2)]);
var inst_26030 = cljs.core.async.close_BANG_(out);
var state_26036__$1 = (function (){var statearr_26054 = state_26036;
(statearr_26054[(13)] = inst_26029);

return statearr_26054;
})();
var statearr_26055_26077 = state_26036__$1;
(statearr_26055_26077[(2)] = inst_26030);

(statearr_26055_26077[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (10))){
var inst_26020 = (state_26036[(2)]);
var state_26036__$1 = state_26036;
var statearr_26056_26078 = state_26036__$1;
(statearr_26056_26078[(2)] = inst_26020);

(statearr_26056_26078[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26037 === (8))){
var inst_26000 = (state_26036[(8)]);
var inst_26009 = (state_26036[(11)]);
var tmp26053 = inst_26000;
var inst_26000__$1 = tmp26053;
var inst_26001 = inst_26009;
var state_26036__$1 = (function (){var statearr_26057 = state_26036;
(statearr_26057[(7)] = inst_26001);

(statearr_26057[(8)] = inst_26000__$1);

return statearr_26057;
})();
var statearr_26058_26079 = state_26036__$1;
(statearr_26058_26079[(2)] = null);

(statearr_26058_26079[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_26059 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26059[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_26059[(1)] = (1));

return statearr_26059;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_26036){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_26036);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e26060){var ex__24179__auto__ = e26060;
var statearr_26061_26080 = state_26036;
(statearr_26061_26080[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_26036[(4)]))){
var statearr_26062_26081 = state_26036;
(statearr_26062_26081[(1)] = cljs.core.first((state_26036[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__26082 = state_26036;
state_26036 = G__26082;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_26036){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_26036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_26063 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_26063[(6)] = c__24250__auto___26065);

return statearr_26063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__26084 = arguments.length;
switch (G__26084) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24250__auto___26162 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_26129){
var state_val_26130 = (state_26129[(1)]);
if((state_val_26130 === (7))){
var inst_26125 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
var statearr_26131_26163 = state_26129__$1;
(statearr_26131_26163[(2)] = inst_26125);

(statearr_26131_26163[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (1))){
var inst_26085 = [];
var inst_26086 = inst_26085;
var inst_26087 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_26129__$1 = (function (){var statearr_26132 = state_26129;
(statearr_26132[(7)] = inst_26086);

(statearr_26132[(8)] = inst_26087);

return statearr_26132;
})();
var statearr_26133_26164 = state_26129__$1;
(statearr_26133_26164[(2)] = null);

(statearr_26133_26164[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (4))){
var inst_26090 = (state_26129[(9)]);
var inst_26090__$1 = (state_26129[(2)]);
var inst_26091 = (inst_26090__$1 == null);
var inst_26092 = cljs.core.not(inst_26091);
var state_26129__$1 = (function (){var statearr_26134 = state_26129;
(statearr_26134[(9)] = inst_26090__$1);

return statearr_26134;
})();
if(inst_26092){
var statearr_26135_26165 = state_26129__$1;
(statearr_26135_26165[(1)] = (5));

} else {
var statearr_26136_26166 = state_26129__$1;
(statearr_26136_26166[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (15))){
var inst_26086 = (state_26129[(7)]);
var inst_26117 = cljs.core.vec(inst_26086);
var state_26129__$1 = state_26129;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26129__$1,(18),out,inst_26117);
} else {
if((state_val_26130 === (13))){
var inst_26112 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
var statearr_26137_26167 = state_26129__$1;
(statearr_26137_26167[(2)] = inst_26112);

(statearr_26137_26167[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (6))){
var inst_26086 = (state_26129[(7)]);
var inst_26114 = inst_26086.length;
var inst_26115 = (inst_26114 > (0));
var state_26129__$1 = state_26129;
if(cljs.core.truth_(inst_26115)){
var statearr_26138_26168 = state_26129__$1;
(statearr_26138_26168[(1)] = (15));

} else {
var statearr_26139_26169 = state_26129__$1;
(statearr_26139_26169[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (17))){
var inst_26122 = (state_26129[(2)]);
var inst_26123 = cljs.core.async.close_BANG_(out);
var state_26129__$1 = (function (){var statearr_26140 = state_26129;
(statearr_26140[(10)] = inst_26122);

return statearr_26140;
})();
var statearr_26141_26170 = state_26129__$1;
(statearr_26141_26170[(2)] = inst_26123);

(statearr_26141_26170[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (3))){
var inst_26127 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26129__$1,inst_26127);
} else {
if((state_val_26130 === (12))){
var inst_26086 = (state_26129[(7)]);
var inst_26105 = cljs.core.vec(inst_26086);
var state_26129__$1 = state_26129;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26129__$1,(14),out,inst_26105);
} else {
if((state_val_26130 === (2))){
var state_26129__$1 = state_26129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26129__$1,(4),ch);
} else {
if((state_val_26130 === (11))){
var inst_26090 = (state_26129[(9)]);
var inst_26094 = (state_26129[(11)]);
var inst_26086 = (state_26129[(7)]);
var inst_26102 = inst_26086.push(inst_26090);
var tmp26142 = inst_26086;
var inst_26086__$1 = tmp26142;
var inst_26087 = inst_26094;
var state_26129__$1 = (function (){var statearr_26143 = state_26129;
(statearr_26143[(7)] = inst_26086__$1);

(statearr_26143[(12)] = inst_26102);

(statearr_26143[(8)] = inst_26087);

return statearr_26143;
})();
var statearr_26144_26171 = state_26129__$1;
(statearr_26144_26171[(2)] = null);

(statearr_26144_26171[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (9))){
var inst_26087 = (state_26129[(8)]);
var inst_26098 = cljs.core.keyword_identical_QMARK_(inst_26087,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_26129__$1 = state_26129;
var statearr_26145_26172 = state_26129__$1;
(statearr_26145_26172[(2)] = inst_26098);

(statearr_26145_26172[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (5))){
var inst_26090 = (state_26129[(9)]);
var inst_26095 = (state_26129[(13)]);
var inst_26094 = (state_26129[(11)]);
var inst_26087 = (state_26129[(8)]);
var inst_26094__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_26090) : f.call(null,inst_26090));
var inst_26095__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26094__$1,inst_26087);
var state_26129__$1 = (function (){var statearr_26146 = state_26129;
(statearr_26146[(13)] = inst_26095__$1);

(statearr_26146[(11)] = inst_26094__$1);

return statearr_26146;
})();
if(inst_26095__$1){
var statearr_26147_26173 = state_26129__$1;
(statearr_26147_26173[(1)] = (8));

} else {
var statearr_26148_26174 = state_26129__$1;
(statearr_26148_26174[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (14))){
var inst_26090 = (state_26129[(9)]);
var inst_26094 = (state_26129[(11)]);
var inst_26107 = (state_26129[(2)]);
var inst_26108 = [];
var inst_26109 = inst_26108.push(inst_26090);
var inst_26086 = inst_26108;
var inst_26087 = inst_26094;
var state_26129__$1 = (function (){var statearr_26149 = state_26129;
(statearr_26149[(7)] = inst_26086);

(statearr_26149[(14)] = inst_26107);

(statearr_26149[(15)] = inst_26109);

(statearr_26149[(8)] = inst_26087);

return statearr_26149;
})();
var statearr_26150_26175 = state_26129__$1;
(statearr_26150_26175[(2)] = null);

(statearr_26150_26175[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (16))){
var state_26129__$1 = state_26129;
var statearr_26151_26176 = state_26129__$1;
(statearr_26151_26176[(2)] = null);

(statearr_26151_26176[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (10))){
var inst_26100 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
if(cljs.core.truth_(inst_26100)){
var statearr_26152_26177 = state_26129__$1;
(statearr_26152_26177[(1)] = (11));

} else {
var statearr_26153_26178 = state_26129__$1;
(statearr_26153_26178[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (18))){
var inst_26119 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
var statearr_26154_26179 = state_26129__$1;
(statearr_26154_26179[(2)] = inst_26119);

(statearr_26154_26179[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26130 === (8))){
var inst_26095 = (state_26129[(13)]);
var state_26129__$1 = state_26129;
var statearr_26155_26180 = state_26129__$1;
(statearr_26155_26180[(2)] = inst_26095);

(statearr_26155_26180[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24176__auto__ = null;
var cljs$core$async$state_machine__24176__auto____0 = (function (){
var statearr_26156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26156[(0)] = cljs$core$async$state_machine__24176__auto__);

(statearr_26156[(1)] = (1));

return statearr_26156;
});
var cljs$core$async$state_machine__24176__auto____1 = (function (state_26129){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_26129);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e26157){var ex__24179__auto__ = e26157;
var statearr_26158_26181 = state_26129;
(statearr_26158_26181[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_26129[(4)]))){
var statearr_26159_26182 = state_26129;
(statearr_26159_26182[(1)] = cljs.core.first((state_26129[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__26183 = state_26129;
state_26129 = G__26183;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs$core$async$state_machine__24176__auto__ = function(state_26129){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24176__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24176__auto____1.call(this,state_26129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24176__auto____0;
cljs$core$async$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24176__auto____1;
return cljs$core$async$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_26160 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_26160[(6)] = c__24250__auto___26162);

return statearr_26160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

