// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('goog.net.IframeIo');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('cljs.core.async');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs_http.core');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = ((stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__28194 = http_options__$1;
if(cljs.core.truth_((function (){var and__4251__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return ((cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && ((!(stateful_method_QMARK_))));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.assoc_in(G__28194,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__28195 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(Date.now());
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__28195) : cljs_hash.md5.md5.call(null,G__28195));
})());
} else {
return G__28194;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28199 = arguments.length;
var i__4865__auto___28200 = (0);
while(true){
if((i__4865__auto___28200 < len__4864__auto___28199)){
args__4870__auto__.push((arguments[i__4865__auto___28200]));

var G__28201 = (i__4865__auto___28200 + (1));
i__4865__auto___28200 = G__28201;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__28197){
var map__28198 = p__28197;
var map__28198__$1 = cljs.core.__destructure_map(map__28198);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",["Token ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__4251__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",["TempToken ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__5753__auto__ = (function (){var and__4251__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var crsf_token = temp__5753__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__4253__auto__ = accept_header;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "application/json";
}
})()], null)], null));
}));

(milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq28196){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28196));
}));

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28210 = arguments.length;
var i__4865__auto___28211 = (0);
while(true){
if((i__4865__auto___28211 < len__4864__auto___28210)){
args__4870__auto__.push((arguments[i__4865__auto___28211]));

var G__28212 = (i__4865__auto___28211 + (1));
i__4865__auto___28211 = G__28212;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__28204){
var vec__28205 = p__28204;
var map__28208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28205,(0),null);
var map__28208__$1 = cljs.core.__destructure_map(map__28208);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28208__$1,cljs.core.cst$kw$require_DASH_json_QMARK_,false);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e28209){if((e28209 instanceof Error)){
var _ = e28209;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e28209;

}
}} else {
return io_obj.getResponseText();
}
}));

(milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq28202){
var G__28203 = cljs.core.first(seq28202);
var seq28202__$1 = cljs.core.next(seq28202);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28203,seq28202__$1);
}));

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
goog.events.listen(io_obj,goog.net.EventType.SUCCESS,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
}));

goog.events.listen(io_obj,goog.net.EventType.ERROR,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
}));

return io_obj.sendFromForm(form,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_api),"?legacy=true"].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://developers.google.com/closure/library/docs/xhrio
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28219 = arguments.length;
var i__4865__auto___28220 = (0);
while(true){
if((i__4865__auto___28220 < len__4864__auto___28219)){
args__4870__auto__.push((arguments[i__4865__auto___28220]));

var G__28221 = (i__4865__auto___28220 + (1));
i__4865__auto___28220 = G__28221;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__28217){
var map__28218 = p__28217;
var map__28218__$1 = cljs.core.__destructure_map(map__28218);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28218__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28218__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28218__$1,cljs.core.cst$kw$require_DASH_json_QMARK_,false);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

goog.events.listen(io_obj,goog.net.EventType.COMPLETE,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([require_json_QMARK_], 0))));
}));

goog.events.listen(io_obj,goog.net.EventType.SUCCESS,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([require_json_QMARK_], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$success_QMARK_,true], 0)));
}));

goog.events.listen(io_obj,goog.net.EventType.ERROR,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([require_json_QMARK_], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$success_QMARK_,false], 0)));
}));

goog.events.listen(io_obj,goog.net.EventType.PROGRESS,(function (p1__28213_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__28213_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__28213_SHARP_.loaded,cljs.core.cst$kw$total,p1__28213_SHARP_.total], null)));
}));

io_obj.send(url,"POST",form,headers);

return io_obj;
}));

(milia.api.io.upload_file.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.io.upload_file.cljs$lang$applyTo = (function (seq28214){
var G__28215 = cljs.core.first(seq28214);
var seq28214__$1 = cljs.core.next(seq28214);
var G__28216 = cljs.core.first(seq28214__$1);
var seq28214__$2 = cljs.core.next(seq28214__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28215,G__28216,seq28214__$2);
}));

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28251 = arguments.length;
var i__4865__auto___28252 = (0);
while(true){
if((i__4865__auto___28252 < len__4864__auto___28251)){
args__4870__auto__.push((arguments[i__4865__auto___28252]));

var G__28253 = (i__4865__auto___28252 + (1));
i__4865__auto___28252 = G__28253;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__24250__auto___28254 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_28239){
var state_val_28240 = (state_28239[(1)]);
if((state_val_28240 === (1))){
var inst_28225 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_28239__$1 = state_28239;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28239__$1,(2),inst_28225);
} else {
if((state_val_28240 === (2))){
var inst_28228 = (state_28239[(7)]);
var inst_28227 = (state_28239[(2)]);
var inst_28228__$1 = cljs.core.__destructure_map(inst_28227);
var inst_28229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28228__$1,cljs.core.cst$kw$status);
var inst_28230 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28229,(401));
var state_28239__$1 = (function (){var statearr_28241 = state_28239;
(statearr_28241[(7)] = inst_28228__$1);

return statearr_28241;
})();
if(inst_28230){
var statearr_28242_28255 = state_28239__$1;
(statearr_28242_28255[(1)] = (3));

} else {
var statearr_28243_28256 = state_28239__$1;
(statearr_28243_28256[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28240 === (3))){
var inst_28232 = window.location.href;
var inst_28233 = (window.location = inst_28232);
var state_28239__$1 = state_28239;
var statearr_28244_28257 = state_28239__$1;
(statearr_28244_28257[(2)] = inst_28233);

(statearr_28244_28257[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28240 === (4))){
var inst_28228 = (state_28239[(7)]);
var inst_28235 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_28228);
var state_28239__$1 = state_28239;
var statearr_28245_28258 = state_28239__$1;
(statearr_28245_28258[(2)] = inst_28235);

(statearr_28245_28258[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28240 === (5))){
var inst_28237 = (state_28239[(2)]);
var state_28239__$1 = state_28239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28239__$1,inst_28237);
} else {
return null;
}
}
}
}
}
});
return (function() {
var milia$api$io$state_machine__24176__auto__ = null;
var milia$api$io$state_machine__24176__auto____0 = (function (){
var statearr_28246 = [null,null,null,null,null,null,null,null];
(statearr_28246[(0)] = milia$api$io$state_machine__24176__auto__);

(statearr_28246[(1)] = (1));

return statearr_28246;
});
var milia$api$io$state_machine__24176__auto____1 = (function (state_28239){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_28239);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e28247){var ex__24179__auto__ = e28247;
var statearr_28248_28259 = state_28239;
(statearr_28248_28259[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_28239[(4)]))){
var statearr_28249_28260 = state_28239;
(statearr_28249_28260[(1)] = cljs.core.first((state_28239[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__28261 = state_28239;
state_28239 = G__28261;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
milia$api$io$state_machine__24176__auto__ = function(state_28239){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__24176__auto____0.call(this);
case 1:
return milia$api$io$state_machine__24176__auto____1.call(this,state_28239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__24176__auto____0;
milia$api$io$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__24176__auto____1;
return milia$api$io$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_28250 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_28250[(6)] = c__24250__auto___28254);

return statearr_28250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));


return response_channel;
}));

(milia.api.io.http_request.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.io.http_request.cljs$lang$applyTo = (function (seq28222){
var G__28223 = cljs.core.first(seq28222);
var seq28222__$1 = cljs.core.next(seq28222);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28223,seq28222__$1);
}));

