// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.dataview');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create new dataview from existing dataset
 */
milia.api.dataview.create = (function milia$api$dataview$create(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves dataview object using dataview id
 */
milia.api.dataview.get = (function milia$api$dataview$get(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28343 = arguments.length;
var i__4865__auto___28344 = (0);
while(true){
if((i__4865__auto___28344 < len__4864__auto___28343)){
args__4870__auto__.push((arguments[i__4865__auto___28344]));

var G__28345 = (i__4865__auto___28344 + (1));
i__4865__auto___28344 = G__28345;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.dataview.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.dataview.get.cljs$core$IFn$_invoke$arity$variadic = (function (dataview_id,p__28341){
var map__28342 = p__28341;
var map__28342__$1 = cljs.core.__destructure_map(map__28342);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28342__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataview_id),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
}));

(milia.api.dataview.get.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.dataview.get.cljs$lang$applyTo = (function (seq28339){
var G__28340 = cljs.core.first(seq28339);
var seq28339__$1 = cljs.core.next(seq28339);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28340,seq28339__$1);
}));

/**
 * Retrieves dataview data by ID and with the optional parameters.
 */
milia.api.dataview.data = (function milia$api$dataview$data(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28350 = arguments.length;
var i__4865__auto___28351 = (0);
while(true){
if((i__4865__auto___28351 < len__4864__auto___28350)){
args__4870__auto__.push((arguments[i__4865__auto___28351]));

var G__28352 = (i__4865__auto___28351 + (1));
i__4865__auto___28351 = G__28352;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.dataview.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.dataview.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataview_id,p__28348){
var map__28349 = p__28348;
var map__28349__$1 = cljs.core.__destructure_map(map__28349);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28349__$1,cljs.core.cst$kw$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28349__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28349__$1,cljs.core.cst$kw$query_DASH_params);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",dataview_id,"data.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,query_params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
}));

(milia.api.dataview.data.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.dataview.data.cljs$lang$applyTo = (function (seq28346){
var G__28347 = cljs.core.first(seq28346);
var seq28346__$1 = cljs.core.next(seq28346);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28347,seq28346__$1);
}));

/**
 * Retrieves form used to create dataview
 */
milia.api.dataview.form = (function milia$api$dataview$form(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",dataview_id,"form.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves details of form used to create dataview
 */
milia.api.dataview.form_details = (function milia$api$dataview$form_details(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",dataview_id,"form_details.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Counts data instances returned by dataview object
 */
milia.api.dataview.count_data = (function milia$api$dataview$count_data(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",dataview_id,"data.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$count,true], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves all dataview objects
 */
milia.api.dataview.all = (function milia$api$dataview$all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Updates dataview object
 */
milia.api.dataview.update = (function milia$api$dataview$update(dataview_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataview_id),".json"].join('')], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Deletes dataview object
 */
milia.api.dataview.delete$ = (function milia$api$dataview$delete(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataview_id),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataview.download_xls_report = (function milia$api$dataview$download_xls_report(dataset_id,meta_id,filename,data_id){
var suffix = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),"/xls_export.json?","meta=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(meta_id),"&data_id=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_id)].join('');
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$filename,filename], 0));
});
