// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
if(typeof project_data === 'string'){
return null;
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,chimera.urls.last_url_param(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
}
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"forms.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28494 = arguments.length;
var i__4865__auto___28495 = (0);
while(true){
if((i__4865__auto___28495 < len__4864__auto___28494)){
args__4870__auto__.push((arguments[i__4865__auto___28495]));

var G__28496 = (i__4865__auto___28495 + (1));
i__4865__auto___28495 = G__28496;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__28492){
var map__28493 = p__28492;
var map__28493__$1 = cljs.core.__destructure_map(map__28493);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28493__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0));
var data = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
return data;
}));

(milia.api.project.get_project.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.project.get_project.cljs$lang$applyTo = (function (seq28490){
var G__28491 = cljs.core.first(seq28490);
var seq28490__$1 = cljs.core.next(seq28490);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28491,seq28490__$1);
}));

/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(var_args){
var G__28502 = arguments.length;
switch (G__28502) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___28510 = arguments.length;
var i__4865__auto___28511 = (0);
while(true){
if((i__4865__auto___28511 < len__4864__auto___28510)){
args_arr__4885__auto__.push((arguments[i__4865__auto___28511]));

var G__28512 = (i__4865__auto___28511 + (1));
i__4865__auto___28511 = G__28512;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((1)),(0),null));
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4886__auto__);

}
});

(milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all(null);
}));

(milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic = (function (owner,p__28503){
var map__28504 = p__28503;
var map__28504__$1 = cljs.core.__destructure_map(map__28504);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28504__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var logged_in_username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28504__$1,cljs.core.cst$kw$logged_DASH_in_DASH_username);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects.json"], 0));
var options = (function (){var G__28506 = (function (){var G__28508 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,null], null);
var fexpr__28507 = (function (p1__28497_SHARP_){
if(cljs.core.truth_(owner)){
return cljs.core.assoc_in(p1__28497_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$owner], null),owner);
} else {
return p1__28497_SHARP_;
}
});
return fexpr__28507(G__28508);
})();
var fexpr__28505 = (function (p1__28498_SHARP_){
if(cljs.core.truth_(logged_in_username)){
return cljs.core.assoc_in(p1__28498_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$u], null),logged_in_username);
} else {
return p1__28498_SHARP_;
}
});
return fexpr__28505(G__28506);
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

/** @this {Function} */
(milia.api.project.all.cljs$lang$applyTo = (function (seq28500){
var G__28501 = cljs.core.first(seq28500);
var seq28500__$1 = cljs.core.next(seq28500);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28501,seq28500__$1);
}));

(milia.api.project.all.cljs$lang$maxFixedArity = (1));

/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(owner),".json"].join('')], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects.json"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,form_params], null)], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(project_id),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28521 = arguments.length;
var i__4865__auto___28522 = (0);
while(true){
if((i__4865__auto___28522 < len__4864__auto___28521)){
args__4870__auto__.push((arguments[i__4865__auto___28522]));

var G__28523 = (i__4865__auto___28522 + (1));
i__4865__auto___28522 = G__28523;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,username,role,p__28517){
var vec__28518 = p__28517;
var remove_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28518,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",project_id,"share.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
}));

(milia.api.project.share.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(milia.api.project.share.cljs$lang$applyTo = (function (seq28513){
var G__28514 = cljs.core.first(seq28513);
var seq28513__$1 = cljs.core.next(seq28513);
var G__28515 = cljs.core.first(seq28513__$1);
var seq28513__$2 = cljs.core.next(seq28513__$1);
var G__28516 = cljs.core.first(seq28513__$2);
var seq28513__$3 = cljs.core.next(seq28513__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28514,G__28515,G__28516,seq28513__$3);
}));

/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"labels.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28528 = arguments.length;
var i__4865__auto___28529 = (0);
while(true){
if((i__4865__auto___28529 < len__4864__auto___28528)){
args__4870__auto__.push((arguments[i__4865__auto___28529]));

var G__28530 = (i__4865__auto___28529 + (1));
i__4865__auto___28529 = G__28530;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__28526){
var map__28527 = p__28526;
var map__28527__$1 = cljs.core.__destructure_map(map__28527);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28527__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"star.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$callback,callback], 0));
}));

(milia.api.project.add_star.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.project.add_star.cljs$lang$applyTo = (function (seq28524){
var G__28525 = cljs.core.first(seq28524);
var seq28524__$1 = cljs.core.next(seq28524);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28525,seq28524__$1);
}));

/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28535 = arguments.length;
var i__4865__auto___28536 = (0);
while(true){
if((i__4865__auto___28536 < len__4864__auto___28535)){
args__4870__auto__.push((arguments[i__4865__auto___28536]));

var G__28537 = (i__4865__auto___28536 + (1));
i__4865__auto___28536 = G__28537;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__28533){
var map__28534 = p__28533;
var map__28534__$1 = cljs.core.__destructure_map(map__28534);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28534__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"star.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$callback,callback], 0));
}));

(milia.api.project.remove_star.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.project.remove_star.cljs$lang$applyTo = (function (seq28531){
var G__28532 = cljs.core.first(seq28531);
var seq28531__$1 = cljs.core.next(seq28531);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28532,seq28531__$1);
}));

/**
 * Toggle between starred and unstarred for a user's project
 */
milia.api.project.toggle_star = (function milia$api$project$toggle_star(id,star_QMARK_,callback){
var G__28539 = id;
var G__28540 = cljs.core.cst$kw$callback;
var G__28541 = callback;
var fexpr__28538 = (cljs.core.truth_(star_QMARK_)?milia.api.project.add_star:milia.api.project.remove_star);
return (fexpr__28538.cljs$core$IFn$_invoke$arity$3 ? fexpr__28538.cljs$core$IFn$_invoke$arity$3(G__28539,G__28540,G__28541) : fexpr__28538.call(null,G__28539,G__28540,G__28541));
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user",username,"starred.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"star.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new_owner),".json"].join('')], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,form_params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,public$){
return milia.api.project.update(projectid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$public,public$], null));
});
milia.api.project.files = (function milia$api$project$files(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28546 = arguments.length;
var i__4865__auto___28547 = (0);
while(true){
if((i__4865__auto___28547 < len__4864__auto___28546)){
args__4870__auto__.push((arguments[i__4865__auto___28547]));

var G__28548 = (i__4865__auto___28547 + (1));
i__4865__auto___28547 = G__28548;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,p__28544){
var map__28545 = p__28544;
var map__28545__$1 = cljs.core.__destructure_map(map__28545);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28545__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.utils.metadata.metadata_files(cljs.core.cst$kw$project,project_id,no_cache_QMARK_);
}));

(milia.api.project.files.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.project.files.cljs$lang$applyTo = (function (seq28542){
var G__28543 = cljs.core.first(seq28542);
var seq28542__$1 = cljs.core.next(seq28542);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28543,seq28542__$1);
}));

