// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.charts');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.charts.format = goog.string.format;
milia.api.charts.suffix = (function milia$api$charts$suffix(var_args){
var G__29719 = arguments.length;
switch (G__29719) {
case 1:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json"].join('');
}));

(milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var field_s = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_name,"all"))?"fields":"field_name");
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json?",field_s,"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(field_name)].join('');
}));

(milia.api.charts.suffix.cljs$lang$maxFixedArity = 2);

/**
 * Get list of chart fields for a specific dataset
 */
milia.api.charts.fields = (function milia$api$charts$fields(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1(dataset_id)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get chart for a specific field in a dataset
 */
milia.api.charts.chart = (function milia$api$charts$chart(var_args){
var G__29722 = arguments.length;
switch (G__29722) {
case 1:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2(dataset_id,"all");
}));

(milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2(dataset_id,field_name)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
}));

(milia.api.charts.chart.cljs$lang$maxFixedArity = 2);

/**
 * Given a field name, return chart data associated with a dataset or dataview
 */
milia.api.charts.get = (function milia$api$charts$get(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29732 = arguments.length;
var i__5770__auto___29733 = (0);
while(true){
if((i__5770__auto___29733 < len__5769__auto___29732)){
args__5775__auto__.push((arguments[i__5770__auto___29733]));

var G__29734 = (i__5770__auto___29733 + (1));
i__5770__auto___29733 = G__29734;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic = (function (field_name,p__29726){
var map__29727 = p__29726;
var map__29727__$1 = cljs.core.__destructure_map(map__29727);
var dataview_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29727__$1,cljs.core.cst$kw$dataview_DASH_id);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29727__$1,cljs.core.cst$kw$dataset_DASH_id);
var group_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29727__$1,cljs.core.cst$kw$group_DASH_by);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29727__$1,cljs.core.cst$kw$field_DASH_xpath);
var id = (function (){var or__5045__auto__ = dataview_id;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return dataset_id;
}
})();
var base_url_template = (cljs.core.truth_(dataview_id)?"dataviews/%s/charts.json?field_name=%s":(cljs.core.truth_(field_xpath)?"charts/%s.json?field_xpath=%s":"charts/%s.json?field_name=%s"
));
var url_template = [base_url_template,(cljs.core.truth_(group_by)?"&group_by=%s":null)].join('');
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (){var G__29728 = url_template;
var G__29729 = id;
var G__29730 = (function (){var or__5045__auto__ = field_xpath;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return field_name;
}
})();
var G__29731 = group_by;
return (milia.api.charts.format.cljs$core$IFn$_invoke$arity$4 ? milia.api.charts.format.cljs$core$IFn$_invoke$arity$4(G__29728,G__29729,G__29730,G__29731) : milia.api.charts.format.call(null,G__29728,G__29729,G__29730,G__29731));
})()], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
}));

(milia.api.charts.get.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.charts.get.cljs$lang$applyTo = (function (seq29724){
var G__29725 = cljs.core.first(seq29724);
var seq29724__$1 = cljs.core.next(seq29724);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29725,seq29724__$1);
}));

