// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('goog.net.IframeIo');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('cljs.core.async');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs_http.core');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = ((stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__29311 = http_options__$1;
if(cljs.core.truth_((function (){var and__5043__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return ((cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && ((!(stateful_method_QMARK_))));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.assoc_in(G__29311,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__29312 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(Date.now());
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__29312) : cljs_hash.md5.md5.call(null,G__29312));
})());
} else {
return G__29311;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29316 = arguments.length;
var i__5770__auto___29317 = (0);
while(true){
if((i__5770__auto___29317 < len__5769__auto___29316)){
args__5775__auto__.push((arguments[i__5770__auto___29317]));

var G__29318 = (i__5770__auto___29317 + (1));
i__5770__auto___29317 = G__29318;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__29314){
var map__29315 = p__29314;
var map__29315__$1 = cljs.core.__destructure_map(map__29315);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29315__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29315__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29315__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29315__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",["Token ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__5043__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",["TempToken ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__5804__auto__ = (function (){var and__5043__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var crsf_token = temp__5804__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__5045__auto__ = accept_header;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "application/json";
}
})()], null)], null));
}));

(milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq29313){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29313));
}));

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29327 = arguments.length;
var i__5770__auto___29328 = (0);
while(true){
if((i__5770__auto___29328 < len__5769__auto___29327)){
args__5775__auto__.push((arguments[i__5770__auto___29328]));

var G__29329 = (i__5770__auto___29328 + (1));
i__5770__auto___29328 = G__29329;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__29321){
var vec__29322 = p__29321;
var map__29325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29322,(0),null);
var map__29325__$1 = cljs.core.__destructure_map(map__29325);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29325__$1,cljs.core.cst$kw$require_DASH_json_QMARK_,false);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e29326){if((e29326 instanceof Error)){
var _ = e29326;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e29326;

}
}} else {
return io_obj.getResponseText();
}
}));

(milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq29319){
var G__29320 = cljs.core.first(seq29319);
var seq29319__$1 = cljs.core.next(seq29319);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29320,seq29319__$1);
}));

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
goog.events.listen(io_obj,goog.net.EventType.SUCCESS,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
}));

goog.events.listen(io_obj,goog.net.EventType.ERROR,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
}));

return io_obj.sendFromForm(form,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_api),"?legacy=true"].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://developers.google.com/closure/library/docs/xhrio
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29336 = arguments.length;
var i__5770__auto___29337 = (0);
while(true){
if((i__5770__auto___29337 < len__5769__auto___29336)){
args__5775__auto__.push((arguments[i__5770__auto___29337]));

var G__29338 = (i__5770__auto___29337 + (1));
i__5770__auto___29337 = G__29338;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__29334){
var map__29335 = p__29334;
var map__29335__$1 = cljs.core.__destructure_map(map__29335);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29335__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29335__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29335__$1,cljs.core.cst$kw$require_DASH_json_QMARK_,false);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

goog.events.listen(io_obj,goog.net.EventType.COMPLETE,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([require_json_QMARK_], 0))));
}));

goog.events.listen(io_obj,goog.net.EventType.SUCCESS,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([require_json_QMARK_], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$success_QMARK_,true], 0)));
}));

goog.events.listen(io_obj,goog.net.EventType.ERROR,(function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([require_json_QMARK_], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$success_QMARK_,false], 0)));
}));

goog.events.listen(io_obj,goog.net.EventType.PROGRESS,(function (p1__29330_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__29330_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__29330_SHARP_.loaded,cljs.core.cst$kw$total,p1__29330_SHARP_.total], null)));
}));

io_obj.send(url,"POST",form,headers);

return io_obj;
}));

(milia.api.io.upload_file.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.io.upload_file.cljs$lang$applyTo = (function (seq29331){
var G__29332 = cljs.core.first(seq29331);
var seq29331__$1 = cljs.core.next(seq29331);
var G__29333 = cljs.core.first(seq29331__$1);
var seq29331__$2 = cljs.core.next(seq29331__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29332,G__29333,seq29331__$2);
}));

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29368 = arguments.length;
var i__5770__auto___29369 = (0);
while(true){
if((i__5770__auto___29369 < len__5769__auto___29368)){
args__5775__auto__.push((arguments[i__5770__auto___29369]));

var G__29370 = (i__5770__auto___29369 + (1));
i__5770__auto___29369 = G__29370;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__25371__auto___29371 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_29356){
var state_val_29357 = (state_29356[(1)]);
if((state_val_29357 === (1))){
var inst_29342 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_29356__$1 = state_29356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29356__$1,(2),inst_29342);
} else {
if((state_val_29357 === (2))){
var inst_29345 = (state_29356[(7)]);
var inst_29344 = (state_29356[(2)]);
var inst_29345__$1 = cljs.core.__destructure_map(inst_29344);
var inst_29346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29345__$1,cljs.core.cst$kw$status);
var inst_29347 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29346,(401));
var state_29356__$1 = (function (){var statearr_29358 = state_29356;
(statearr_29358[(7)] = inst_29345__$1);

return statearr_29358;
})();
if(inst_29347){
var statearr_29359_29372 = state_29356__$1;
(statearr_29359_29372[(1)] = (3));

} else {
var statearr_29360_29373 = state_29356__$1;
(statearr_29360_29373[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29357 === (3))){
var inst_29349 = window.location.href;
var inst_29350 = (window.location = inst_29349);
var state_29356__$1 = state_29356;
var statearr_29361_29374 = state_29356__$1;
(statearr_29361_29374[(2)] = inst_29350);

(statearr_29361_29374[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29357 === (4))){
var inst_29345 = (state_29356[(7)]);
var inst_29352 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_29345);
var state_29356__$1 = state_29356;
var statearr_29362_29375 = state_29356__$1;
(statearr_29362_29375[(2)] = inst_29352);

(statearr_29362_29375[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29357 === (5))){
var inst_29354 = (state_29356[(2)]);
var state_29356__$1 = state_29356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29356__$1,inst_29354);
} else {
return null;
}
}
}
}
}
});
return (function() {
var milia$api$io$state_machine__25297__auto__ = null;
var milia$api$io$state_machine__25297__auto____0 = (function (){
var statearr_29363 = [null,null,null,null,null,null,null,null];
(statearr_29363[(0)] = milia$api$io$state_machine__25297__auto__);

(statearr_29363[(1)] = (1));

return statearr_29363;
});
var milia$api$io$state_machine__25297__auto____1 = (function (state_29356){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_29356);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e29364){var ex__25300__auto__ = e29364;
var statearr_29365_29376 = state_29356;
(statearr_29365_29376[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_29356[(4)]))){
var statearr_29366_29377 = state_29356;
(statearr_29366_29377[(1)] = cljs.core.first((state_29356[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__29378 = state_29356;
state_29356 = G__29378;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
milia$api$io$state_machine__25297__auto__ = function(state_29356){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__25297__auto____0.call(this);
case 1:
return milia$api$io$state_machine__25297__auto____1.call(this,state_29356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__25297__auto____0;
milia$api$io$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__25297__auto____1;
return milia$api$io$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_29367 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_29367[(6)] = c__25371__auto___29371);

return statearr_29367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return response_channel;
}));

(milia.api.io.http_request.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.io.http_request.cljs$lang$applyTo = (function (seq29339){
var G__29340 = cljs.core.first(seq29339);
var seq29339__$1 = cljs.core.next(seq29339);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29340,seq29339__$1);
}));

