// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.seq');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
if((typeof milia !== 'undefined') && (typeof milia.api !== 'undefined') && (typeof milia.api.dataset !== 'undefined') && (typeof milia.api.dataset.type__GT_endpoint !== 'undefined')){
} else {
milia.api.dataset.type__GT_endpoint = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__29737 = cljs.core.get_global_hierarchy;
return (fexpr__29737.cljs$core$IFn$_invoke$arity$0 ? fexpr__29737.cljs$core$IFn$_invoke$arity$0() : fexpr__29737.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->endpoint"),(function() { 
var G__29738__delegate = function (datatype,_){
return datatype;
};
var G__29738 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__29739__i = 0, G__29739__a = new Array(arguments.length -  1);
while (G__29739__i < G__29739__a.length) {G__29739__a[G__29739__i] = arguments[G__29739__i + 1]; ++G__29739__i;}
  _ = new cljs.core.IndexedSeq(G__29739__a,0,null);
} 
return G__29738__delegate.call(this,datatype,_);};
G__29738.cljs$lang$maxFixedArity = 1;
G__29738.cljs$lang$applyTo = (function (arglist__29740){
var datatype = cljs.core.first(arglist__29740);
var _ = cljs.core.rest(arglist__29740);
return G__29738__delegate(datatype,_);
});
G__29738.cljs$core$IFn$_invoke$arity$variadic = G__29738__delegate;
return G__29738;
})()
,cljs.core.cst$kw$default,hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function() { 
var G__29743__delegate = function (_,p__29741){
var map__29742 = p__29741;
var map__29742__$1 = cljs.core.__destructure_map(map__29742);
var async = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29742__$1,cljs.core.cst$kw$async,true);
if(cljs.core.truth_(async)){
return "forms";
} else {
return "data";
}
};
var G__29743 = function (_,var_args){
var p__29741 = null;
if (arguments.length > 1) {
var G__29744__i = 0, G__29744__a = new Array(arguments.length -  1);
while (G__29744__i < G__29744__a.length) {G__29744__a[G__29744__i] = arguments[G__29744__i + 1]; ++G__29744__i;}
  p__29741 = new cljs.core.IndexedSeq(G__29744__a,0,null);
} 
return G__29743__delegate.call(this,_,p__29741);};
G__29743.cljs$lang$maxFixedArity = 1;
G__29743.cljs$lang$applyTo = (function (arglist__29745){
var _ = cljs.core.first(arglist__29745);
var p__29741 = cljs.core.rest(arglist__29745);
return G__29743__delegate(_,p__29741);
});
G__29743.cljs$core$IFn$_invoke$arity$variadic = G__29743__delegate;
return G__29743;
})()
);
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function() { 
var G__29746__delegate = function (_,___$1){
return "dataviews";
};
var G__29746 = function (_,var_args){
var ___$1 = null;
if (arguments.length > 1) {
var G__29747__i = 0, G__29747__a = new Array(arguments.length -  1);
while (G__29747__i < G__29747__a.length) {G__29747__a[G__29747__i] = arguments[G__29747__i + 1]; ++G__29747__i;}
  ___$1 = new cljs.core.IndexedSeq(G__29747__a,0,null);
} 
return G__29746__delegate.call(this,_,___$1);};
G__29746.cljs$lang$maxFixedArity = 1;
G__29746.cljs$lang$applyTo = (function (arglist__29748){
var _ = cljs.core.first(arglist__29748);
var ___$1 = cljs.core.rest(arglist__29748);
return G__29746__delegate(_,___$1);
});
G__29746.cljs$core$IFn$_invoke$arity$variadic = G__29746__delegate;
return G__29746;
})()
);
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["forms.json?owner=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
if(cljs.core.seq(username)){
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
} else {
return null;
}
});
/**
 * Clone the dataset given by ID into the account with the given username.
 */
milia.api.dataset.clone = (function milia$api$dataset$clone(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29754 = arguments.length;
var i__5770__auto___29755 = (0);
while(true){
if((i__5770__auto___29755 < len__5769__auto___29754)){
args__5775__auto__.push((arguments[i__5770__auto___29755]));

var G__29756 = (i__5770__auto___29755 + (1));
i__5770__auto___29755 = G__29756;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,username,p__29752){
var map__29753 = p__29752;
var map__29753__$1 = cljs.core.__destructure_map(map__29753);
var project_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29753__$1,cljs.core.cst$kw$project_DASH_id);
if(cljs.core.seq(dataset_id)){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"clone.json"], 0));
var data_base = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null)], null);
var data = (cljs.core.truth_(project_id)?cljs.core.assoc_in(data_base,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form_DASH_params,cljs.core.cst$kw$project_id], null),project_id):data_base);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,data,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
} else {
return null;
}
}));

(milia.api.dataset.clone.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.dataset.clone.cljs$lang$applyTo = (function (seq29749){
var G__29750 = cljs.core.first(seq29749);
var seq29749__$1 = cljs.core.next(seq29749);
var G__29751 = cljs.core.first(seq29749__$1);
var seq29749__$2 = cljs.core.next(seq29749__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29750,G__29751,seq29749__$2);
}));

/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(dataset_id,params){
if(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$created_by,cljs.core.cst$kw$description,cljs.core.cst$kw$downloadable,cljs.core.cst$kw$owner,cljs.core.cst$kw$project,cljs.core.cst$kw$public,cljs.core.cst$kw$public_data,cljs.core.cst$kw$title,cljs.core.cst$kw$uuid], null))){
} else {
throw (new Error("Assert failed: (has-keys? params [:created_by :description :downloadable :owner :project :public :public_data :title :uuid])"));
}

if(cljs.core.seq(dataset_id)){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
} else {
return null;
}
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(dataset_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29761 = arguments.length;
var i__5770__auto___29762 = (0);
while(true){
if((i__5770__auto___29762 < len__5769__auto___29761)){
args__5775__auto__.push((arguments[i__5770__auto___29762]));

var G__29763 = (i__5770__auto___29762 + (1));
i__5770__auto___29762 = G__29763;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});
goog.exportSymbol('milia.api.dataset.data', milia.api.dataset.data);

(milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__29759){
var map__29760 = p__29759;
var map__29760__$1 = cljs.core.__destructure_map(map__29760);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29760__$1,cljs.core.cst$kw$format,"json");
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29760__$1,cljs.core.cst$kw$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29760__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29760__$1,cljs.core.cst$kw$accept_DASH_header);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29760__$1,cljs.core.cst$kw$query_DASH_params);
var data_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29760__$1,cljs.core.cst$kw$data_DASH_id);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29760__$1,cljs.core.cst$kw$auth_DASH_token);
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),(cljs.core.truth_(data_id)?["/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_id)].join(''):null),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join(''):dataset_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_suffix], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,query_params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
}));

(milia.api.dataset.data.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.dataset.data.cljs$lang$applyTo = (function (seq29757){
var G__29758 = cljs.core.first(seq29757);
var seq29757__$1 = cljs.core.next(seq29757);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29758,seq29757__$1);
}));

/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(dataset_id,record_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_id,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(record_id),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"labels.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(dataset_id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"labels.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,tags], null)], 0));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx","zip"], null),format)){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
if((typeof milia !== 'undefined') && (typeof milia.api !== 'undefined') && (typeof milia.api.dataset !== 'undefined') && (typeof milia.api.dataset.type__GT_download_path !== 'undefined')){
} else {
milia.api.dataset.type__GT_download_path = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__29764 = cljs.core.get_global_hierarchy;
return (fexpr__29764.cljs$core$IFn$_invoke$arity$0 ? fexpr__29764.cljs$core$IFn$_invoke$arity$0() : fexpr__29764.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->download-path"),(function() { 
var G__29765__delegate = function (datatype,_){
return datatype;
};
var G__29765 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__29766__i = 0, G__29766__a = new Array(arguments.length -  1);
while (G__29766__i < G__29766__a.length) {G__29766__a[G__29766__i] = arguments[G__29766__i + 1]; ++G__29766__i;}
  _ = new cljs.core.IndexedSeq(G__29766__a,0,null);
} 
return G__29765__delegate.call(this,datatype,_);};
G__29765.cljs$lang$maxFixedArity = 1;
G__29765.cljs$lang$applyTo = (function (arglist__29767){
var datatype = cljs.core.first(arglist__29767);
var _ = cljs.core.rest(arglist__29767);
return G__29765__delegate(datatype,_);
});
G__29765.cljs$core$IFn$_invoke$arity$variadic = G__29765__delegate;
return G__29765;
})()
,cljs.core.cst$kw$default,hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format),(cljs.core.truth_(export_options)?["?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",(function (){var iter__5523__auto__ = (function milia$api$dataset$iter__29798(s__29799){
return (new cljs.core.LazySeq(null,(function (){
var s__29799__$1 = s__29799;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__29799__$1);
if(temp__5804__auto__){
var s__29799__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29799__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__29799__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__29801 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__29800 = (0);
while(true){
if((i__29800 < size__5522__auto__)){
var vec__29802 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__29800);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29802,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29802,(1),null);
cljs.core.chunk_append(b__29801,[cljs.core.name(option),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(val)].join(''));

var G__29808 = (i__29800 + (1));
i__29800 = G__29808;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29801),milia$api$dataset$iter__29798(cljs.core.chunk_rest(s__29799__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29801),null);
}
} else {
var vec__29805 = cljs.core.first(s__29799__$2);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29805,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29805,(1),null);
return cljs.core.cons([cljs.core.name(option),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(val)].join(''),milia$api$dataset$iter__29798(cljs.core.rest(s__29799__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(export_options);
})())].join(''):null)].join('')], null);
}));
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dataset_id,["data.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('')], null);
}));
/**
 * Download form data in specified format. The synchronicity here refers to the
 * server side. This will still return a channel, not data, in CLJS.
 * The options map (last parameter) has the following keys:
 * :accept-header Defaults to application/json
 * :submission-id The id of the submission whose data the client requires. The
 *  function returns data for all submissions if this is not provided.
 * :dataview? Boolean flag indicating whether the data belongs to a filtered
 *  dataview
 */
milia.api.dataset.download_synchronously = (function milia$api$dataset$download_synchronously(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29814 = arguments.length;
var i__5770__auto___29815 = (0);
while(true){
if((i__5770__auto___29815 < len__5769__auto___29814)){
args__5775__auto__.push((arguments[i__5770__auto___29815]));

var G__29816 = (i__5770__auto___29815 + (1));
i__5770__auto___29815 = G__29816;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,format,p__29812){
var map__29813 = p__29812;
var map__29813__$1 = cljs.core.__destructure_map(map__29813);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29813__$1,cljs.core.cst$kw$accept_DASH_header);
var submission_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29813__$1,cljs.core.cst$kw$submission_DASH_id);
var dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29813__$1,cljs.core.cst$kw$dataview_QMARK_);
var url = (cljs.core.truth_(dataview_QMARK_)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",dataset_id,["data.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('')], 0)):(cljs.core.truth_(submission_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_id,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(submission_id),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('')], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('')], 0))
));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$http_DASH_options,milia.api.dataset.options_for_format(format)], 0));
}));

(milia.api.dataset.download_synchronously.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.dataset.download_synchronously.cljs$lang$applyTo = (function (seq29809){
var G__29810 = cljs.core.first(seq29809);
var seq29809__$1 = cljs.core.next(seq29809);
var G__29811 = cljs.core.first(seq29809__$1);
var seq29809__$2 = cljs.core.next(seq29809__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29810,G__29811,seq29809__$2);
}));

/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(var_args){
var G__29818 = arguments.length;
switch (G__29818) {
case 1:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"form.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
}));

(milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,format){
var suffix = ["form.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,suffix], 0));
var filename = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),"_",suffix].join('');
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$filename,filename], 0));
}));

(milia.api.dataset.form.cljs$lang$maxFixedArity = 2);

/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29824 = arguments.length;
var i__5770__auto___29825 = (0);
while(true){
if((i__5770__auto___29825 < len__5769__auto___29824)){
args__5775__auto__.push((arguments[i__5770__auto___29825]));

var G__29826 = (i__5770__auto___29825 + (1));
i__5770__auto___29825 = G__29826;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__29822){
var map__29823 = p__29822;
var map__29823__$1 = cljs.core.__destructure_map(map__29823);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29823__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
if(cljs.core.seq(dataset_id)){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
} else {
return null;
}
}));

(milia.api.dataset.metadata.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.dataset.metadata.cljs$lang$applyTo = (function (seq29820){
var G__29821 = cljs.core.first(seq29820);
var seq29820__$1 = cljs.core.next(seq29820);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29821,seq29820__$1);
}));

/**
 * Return link to online data entry.
 */
milia.api.dataset.online_data_entry_link = (function milia$api$dataset$online_data_entry_link(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"enketo.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(username,project_id,dataset_id,instance_id){
var return_url = milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([username,project_id,dataset_id,"submission-editing-complete"], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_id,instance_id,["enketo.json?return_url=",return_url].join('')], 0));
return cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http(cljs.core.cst$kw$get,url));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"delete_async.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(dataset_id,project_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",project_id,"forms.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$formid,dataset_id], null)], null)], 0));
});
/**
 * Set a new form owner
 */
milia.api.dataset.new_form_owner = (function milia$api$dataset$new_form_owner(dataset_id,new_owner){
if(cljs.core.seq(dataset_id)){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json"].join('')], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users",new_owner], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null)], null)], 0));
} else {
return null;
}
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(dataset_id,username,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"share.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Link xform or dataview as media
 */
milia.api.dataset.link_xform_or_dataview_as_media = (function milia$api$dataset$link_xform_or_dataview_as_media(object_type,object_id,media_filename,xform_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["metadata.json"], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"media",cljs.core.cst$kw$data_value,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [object_type,object_id,media_filename], null)),cljs.core.cst$kw$xform,xform_id], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["xls",uuid], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["metadata.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_type,"external_export",cljs.core.cst$kw$data_value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(filename),"|",xls_url].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(var_args){
var G__29828 = arguments.length;
switch (G__29828) {
case 3:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3 = (function (dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4(dataset_id,meta_id,filename,null);
}));

(milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".xls?meta=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(meta_id),"&data_id=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_id)].join(''):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".xls?meta=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(meta_id)].join(''));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$filename,filename], 0));
}));

(milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 4);

milia.api.dataset.file_ext_query_param_map = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$csv,"csv_file",cljs.core.cst$kw$xls,"xls_file",cljs.core.cst$kw$xlsx,"xls_file"], null);
milia.api.dataset.get_media_file_extension = (function milia$api$dataset$get_media_file_extension(filename){
return cljs.core.peek(clojure.string.split.cljs$core$IFn$_invoke$arity$2(filename,/\./));
});
/**
 * Returns a submission's edit history
 */
milia.api.dataset.edit_history = (function milia$api$dataset$edit_history(dataset_id,instance_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_id,instance_id,"history.json"], 0)));
});
milia.api.dataset.files = (function milia$api$dataset$files(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29835 = arguments.length;
var i__5770__auto___29836 = (0);
while(true){
if((i__5770__auto___29836 < len__5769__auto___29835)){
args__5775__auto__.push((arguments[i__5770__auto___29836]));

var G__29837 = (i__5770__auto___29836 + (1));
i__5770__auto___29836 = G__29837;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic = (function (instance_id,project_id,p__29833){
var map__29834 = p__29833;
var map__29834__$1 = cljs.core.__destructure_map(map__29834);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29834__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29834__$1,cljs.core.cst$kw$dataset_DASH_id);
var extra_params = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$project,project_id], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$xform,dataset_id], null));
return milia.utils.metadata.metadata_files.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$instance,instance_id,no_cache_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$extra_DASH_params,extra_params], 0));
}));

(milia.api.dataset.files.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.dataset.files.cljs$lang$applyTo = (function (seq29830){
var G__29831 = cljs.core.first(seq29830);
var seq29830__$1 = cljs.core.next(seq29830);
var G__29832 = cljs.core.first(seq29830__$1);
var seq29830__$2 = cljs.core.next(seq29830__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29831,G__29832,seq29830__$2);
}));

/**
 * Integer Integer String String -> Channel HttpResponse
 */
milia.api.dataset.update_xform_meta_permissions = (function milia$api$dataset$update_xform_meta_permissions(dataset_id,metadata_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["metadata",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(metadata_id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(editor_meta_role),"|",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Integer String String -> Channel HttpResponse
 */
milia.api.dataset.create_xform_meta_permissions = (function milia$api$dataset$create_xform_meta_permissions(dataset_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["metadata.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(editor_meta_role),"|",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Create a submission review
 */
milia.api.dataset.create_submission_review = (function milia$api$dataset$create_submission_review(p__29838){
var map__29839 = p__29838;
var map__29839__$1 = cljs.core.__destructure_map(map__29839);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29839__$1,cljs.core.cst$kw$status);
var instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29839__$1,cljs.core.cst$kw$instance);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29839__$1,cljs.core.cst$kw$note);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,status,cljs.core.cst$kw$instance,instance,cljs.core.cst$kw$note,note], null)], null)], 0));
});
/**
 * Create a submission review
 */
milia.api.dataset.create_multiple_submission_reviews = (function milia$api$dataset$create_multiple_submission_reviews(p__29840){
var map__29841 = p__29840;
var map__29841__$1 = cljs.core.__destructure_map(map__29841);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29841__$1,cljs.core.cst$kw$status);
var instances = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29841__$1,cljs.core.cst$kw$instances);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29841__$1,cljs.core.cst$kw$note);
var json_vec = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (instance){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$status,status,cljs.core.cst$kw$instance,instance], null);
}),instances);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,json_vec], null)], 0));
});
/**
 * Get a submission review
 */
milia.api.dataset.get_submission_review = (function milia$api$dataset$get_submission_review(submission_review_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(submission_review_id),".json"].join('')], 0)));
});
/**
 * List a submission review
 */
milia.api.dataset.list_submission_reviews = (function milia$api$dataset$list_submission_reviews(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview.json"], 0)));
});
/**
 * Update a submission review
 */
milia.api.dataset.update_submission_review = (function milia$api$dataset$update_submission_review(p__29842){
var map__29843 = p__29842;
var map__29843__$1 = cljs.core.__destructure_map(map__29843);
var submission_review_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29843__$1,cljs.core.cst$kw$submission_DASH_review_DASH_id);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29843__$1,cljs.core.cst$kw$status);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29843__$1,cljs.core.cst$kw$note);
if(cljs.core.not_every_QMARK_(cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,note], null))){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(submission_review_id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,(function (){var G__29844 = cljs.core.PersistentArrayMap.EMPTY;
var G__29844__$1 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(status) : chimera.core.not_nil_QMARK_.call(null,status)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29844,cljs.core.cst$kw$status,status):G__29844);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(note) : chimera.core.not_nil_QMARK_.call(null,note)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29844__$1,cljs.core.cst$kw$note,note);
} else {
return G__29844__$1;
}
})()], null)], 0));
} else {
return null;
}
});
milia.api.dataset.filter_submission_review_by_instance = (function milia$api$dataset$filter_submission_review_by_instance(p__29845){
var map__29846 = p__29845;
var map__29846__$1 = cljs.core.__destructure_map(map__29846);
var instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29846__$1,cljs.core.cst$kw$instance);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29846__$1,cljs.core.cst$kw$status);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29846__$1,cljs.core.cst$kw$note);
var query_params_str = chimera.string.get_query_params_str((function (){var G__29847 = cljs.core.PersistentArrayMap.EMPTY;
var G__29847__$1 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(instance) : chimera.core.not_nil_QMARK_.call(null,instance)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29847,cljs.core.cst$kw$instance,instance):G__29847);
var G__29847__$2 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(status) : chimera.core.not_nil_QMARK_.call(null,status)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29847__$1,cljs.core.cst$kw$status,status):G__29847__$1);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(note) : chimera.core.not_nil_QMARK_.call(null,note)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29847__$2,cljs.core.cst$kw$note,note);
} else {
return G__29847__$2;
}
})());
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["submissionreview.json",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_params_str)].join('')], 0)));
});
milia.api.dataset.delete_submission_review = (function milia$api$dataset$delete_submission_review(instance){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance),".json"].join('')], 0)));
});
