// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e29408){if((e29408 instanceof Error)){
var _ = e29408;
return string;
} else {
throw e29408;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(chimera.js_interop.str__GT_json(s),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29411 = arguments.length;
var i__5770__auto___29412 = (0);
while(true){
if((i__5770__auto___29412 < len__5769__auto___29411)){
args__5775__auto__.push((arguments[i__5770__auto___29412]));

var G__29413 = (i__5770__auto___29412 + (1));
i__5770__auto___29412 = G__29413;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
}));

(chimera.js_interop.format.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chimera.js_interop.format.cljs$lang$applyTo = (function (seq29409){
var G__29410 = cljs.core.first(seq29409);
var seq29409__$1 = cljs.core.next(seq29409);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29410,seq29409__$1);
}));

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29418 = arguments.length;
var i__5770__auto___29419 = (0);
while(true){
if((i__5770__auto___29419 < len__5769__auto___29418)){
args__5775__auto__.push((arguments[i__5770__auto___29419]));

var G__29420 = (i__5770__auto___29419 + (1));
i__5770__auto___29419 = G__29420;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__29416){
var map__29417 = p__29416;
var map__29417__$1 = cljs.core.__destructure_map(map__29417);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29417__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
return cljs.core.re_pattern([(cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null),goog.string.regExpEscape(query_string)].join(''));
}));

(chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq29414){
var G__29415 = cljs.core.first(seq29414);
var seq29414__$1 = cljs.core.next(seq29414);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29415,seq29414__$1);
}));

