// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.notes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Returns all notes. Returns notes for a specific submission if
 *   optional instance ID is proviced
 */
milia.api.notes.list = (function milia$api$notes$list(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29581 = arguments.length;
var i__5770__auto___29582 = (0);
while(true){
if((i__5770__auto___29582 < len__5769__auto___29581)){
args__5775__auto__.push((arguments[i__5770__auto___29582]));

var G__29583 = (i__5770__auto___29582 + (1));
i__5770__auto___29582 = G__29583;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic = (function (p__29579){
var map__29580 = p__29579;
var map__29580__$1 = cljs.core.__destructure_map(map__29580);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29580__$1,cljs.core.cst$kw$instance_DASH_id);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29580__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["notes.json",(cljs.core.truth_(instance_id)?["?instance=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_id)].join(''):null)].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

(milia.api.notes.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.notes.list.cljs$lang$applyTo = (function (seq29578){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29578));
}));

/**
 * Creates a note for a submission instance given the note and instance-id.
 * Takes an options instance-field argument if note added for specific field.
 */
milia.api.notes.create = (function milia$api$notes$create(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29591 = arguments.length;
var i__5770__auto___29592 = (0);
while(true){
if((i__5770__auto___29592 < len__5769__auto___29591)){
args__5775__auto__.push((arguments[i__5770__auto___29592]));

var G__29593 = (i__5770__auto___29592 + (1));
i__5770__auto___29592 = G__29593;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic = (function (note,instance_id,p__29587){
var vec__29588 = p__29587;
var instance_field = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29588,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["notes.json"], 0));
var params = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$instance,instance_id], null);
var form_params = (cljs.core.truth_(instance_field)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(params,cljs.core.cst$kw$instance_field,instance_field):params);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
}));

(milia.api.notes.create.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.notes.create.cljs$lang$applyTo = (function (seq29584){
var G__29585 = cljs.core.first(seq29584);
var seq29584__$1 = cljs.core.next(seq29584);
var G__29586 = cljs.core.first(seq29584__$1);
var seq29584__$2 = cljs.core.next(seq29584__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29585,G__29586,seq29584__$2);
}));

/**
 * Returns a note object given a note ID.
 */
milia.api.notes.get = (function milia$api$notes$get(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["notes",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(note_id),".json"].join('')], 0)));
});
/**
 * Deletes a note given a note ID.
 */
milia.api.notes.delete$ = (function milia$api$notes$delete(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["notes",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(note_id),".json"].join('')], 0)));
});
