// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
if(typeof project_data === 'string'){
return null;
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,chimera.urls.last_url_param(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
}
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"forms.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29611 = arguments.length;
var i__5770__auto___29612 = (0);
while(true){
if((i__5770__auto___29612 < len__5769__auto___29611)){
args__5775__auto__.push((arguments[i__5770__auto___29612]));

var G__29613 = (i__5770__auto___29612 + (1));
i__5770__auto___29612 = G__29613;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__29609){
var map__29610 = p__29609;
var map__29610__$1 = cljs.core.__destructure_map(map__29610);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29610__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0));
var data = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
return data;
}));

(milia.api.project.get_project.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.project.get_project.cljs$lang$applyTo = (function (seq29607){
var G__29608 = cljs.core.first(seq29607);
var seq29607__$1 = cljs.core.next(seq29607);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29608,seq29607__$1);
}));

/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(var_args){
var G__29619 = arguments.length;
switch (G__29619) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___29627 = arguments.length;
var i__5770__auto___29628 = (0);
while(true){
if((i__5770__auto___29628 < len__5769__auto___29627)){
args_arr__5794__auto__.push((arguments[i__5770__auto___29628]));

var G__29629 = (i__5770__auto___29628 + (1));
i__5770__auto___29628 = G__29629;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((1)),(0),null));
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5795__auto__);

}
});

(milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all(null);
}));

(milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic = (function (owner,p__29620){
var map__29621 = p__29620;
var map__29621__$1 = cljs.core.__destructure_map(map__29621);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29621__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var logged_in_username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29621__$1,cljs.core.cst$kw$logged_DASH_in_DASH_username);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects.json"], 0));
var options = (function (){var G__29623 = (function (){var G__29625 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,null], null);
var fexpr__29624 = (function (p1__29614_SHARP_){
if(cljs.core.truth_(owner)){
return cljs.core.assoc_in(p1__29614_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$owner], null),owner);
} else {
return p1__29614_SHARP_;
}
});
return fexpr__29624(G__29625);
})();
var fexpr__29622 = (function (p1__29615_SHARP_){
if(cljs.core.truth_(logged_in_username)){
return cljs.core.assoc_in(p1__29615_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$u], null),logged_in_username);
} else {
return p1__29615_SHARP_;
}
});
return fexpr__29622(G__29623);
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

/** @this {Function} */
(milia.api.project.all.cljs$lang$applyTo = (function (seq29617){
var G__29618 = cljs.core.first(seq29617);
var seq29617__$1 = cljs.core.next(seq29617);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29618,seq29617__$1);
}));

(milia.api.project.all.cljs$lang$maxFixedArity = (1));

/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(owner),".json"].join('')], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects.json"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,form_params], null)], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(project_id),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29638 = arguments.length;
var i__5770__auto___29639 = (0);
while(true){
if((i__5770__auto___29639 < len__5769__auto___29638)){
args__5775__auto__.push((arguments[i__5770__auto___29639]));

var G__29640 = (i__5770__auto___29639 + (1));
i__5770__auto___29639 = G__29640;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,username,role,p__29634){
var vec__29635 = p__29634;
var remove_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29635,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",project_id,"share.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
}));

(milia.api.project.share.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(milia.api.project.share.cljs$lang$applyTo = (function (seq29630){
var G__29631 = cljs.core.first(seq29630);
var seq29630__$1 = cljs.core.next(seq29630);
var G__29632 = cljs.core.first(seq29630__$1);
var seq29630__$2 = cljs.core.next(seq29630__$1);
var G__29633 = cljs.core.first(seq29630__$2);
var seq29630__$3 = cljs.core.next(seq29630__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29631,G__29632,G__29633,seq29630__$3);
}));

/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"labels.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29645 = arguments.length;
var i__5770__auto___29646 = (0);
while(true){
if((i__5770__auto___29646 < len__5769__auto___29645)){
args__5775__auto__.push((arguments[i__5770__auto___29646]));

var G__29647 = (i__5770__auto___29646 + (1));
i__5770__auto___29646 = G__29647;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__29643){
var map__29644 = p__29643;
var map__29644__$1 = cljs.core.__destructure_map(map__29644);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29644__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"star.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$callback,callback], 0));
}));

(milia.api.project.add_star.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.project.add_star.cljs$lang$applyTo = (function (seq29641){
var G__29642 = cljs.core.first(seq29641);
var seq29641__$1 = cljs.core.next(seq29641);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29642,seq29641__$1);
}));

/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29652 = arguments.length;
var i__5770__auto___29653 = (0);
while(true){
if((i__5770__auto___29653 < len__5769__auto___29652)){
args__5775__auto__.push((arguments[i__5770__auto___29653]));

var G__29654 = (i__5770__auto___29653 + (1));
i__5770__auto___29653 = G__29654;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__29650){
var map__29651 = p__29650;
var map__29651__$1 = cljs.core.__destructure_map(map__29651);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29651__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"star.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$callback,callback], 0));
}));

(milia.api.project.remove_star.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.project.remove_star.cljs$lang$applyTo = (function (seq29648){
var G__29649 = cljs.core.first(seq29648);
var seq29648__$1 = cljs.core.next(seq29648);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29649,seq29648__$1);
}));

/**
 * Toggle between starred and unstarred for a user's project
 */
milia.api.project.toggle_star = (function milia$api$project$toggle_star(id,star_QMARK_,callback){
var G__29656 = id;
var G__29657 = cljs.core.cst$kw$callback;
var G__29658 = callback;
var fexpr__29655 = (cljs.core.truth_(star_QMARK_)?milia.api.project.add_star:milia.api.project.remove_star);
return (fexpr__29655.cljs$core$IFn$_invoke$arity$3 ? fexpr__29655.cljs$core$IFn$_invoke$arity$3(G__29656,G__29657,G__29658) : fexpr__29655.call(null,G__29656,G__29657,G__29658));
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user",username,"starred.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",id,"star.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new_owner),".json"].join('')], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,form_params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,public$){
return milia.api.project.update(projectid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$public,public$], null));
});
milia.api.project.files = (function milia$api$project$files(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29663 = arguments.length;
var i__5770__auto___29664 = (0);
while(true){
if((i__5770__auto___29664 < len__5769__auto___29663)){
args__5775__auto__.push((arguments[i__5770__auto___29664]));

var G__29665 = (i__5770__auto___29664 + (1));
i__5770__auto___29664 = G__29665;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,p__29661){
var map__29662 = p__29661;
var map__29662__$1 = cljs.core.__destructure_map(map__29662);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29662__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.utils.metadata.metadata_files(cljs.core.cst$kw$project,project_id,no_cache_QMARK_);
}));

(milia.api.project.files.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.project.files.cljs$lang$applyTo = (function (seq29659){
var G__29660 = cljs.core.first(seq29659);
var seq29659__$1 = cljs.core.next(seq29659);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29660,seq29659__$1);
}));

