// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29676 = arguments.length;
var i__5770__auto___29677 = (0);
while(true){
if((i__5770__auto___29677 < len__5769__auto___29676)){
args__5775__auto__.push((arguments[i__5770__auto___29677]));

var G__29678 = (i__5770__auto___29677 + (1));
i__5770__auto___29677 = G__29678;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__29672){
var vec__29673 = p__29672;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29673,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
}));

(milia.api.rest_services.create.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(milia.api.rest_services.create.cljs$lang$applyTo = (function (seq29668){
var G__29669 = cljs.core.first(seq29668);
var seq29668__$1 = cljs.core.next(seq29668);
var G__29670 = cljs.core.first(seq29668__$1);
var seq29668__$2 = cljs.core.next(seq29668__$1);
var G__29671 = cljs.core.first(seq29668__$2);
var seq29668__$3 = cljs.core.next(seq29668__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29669,G__29670,G__29671,seq29668__$3);
}));

/**
 * Updates a rest service.
 */
milia.api.rest_services.update_restservice = (function milia$api$rest_services$update_restservice(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29688 = arguments.length;
var i__5770__auto___29689 = (0);
while(true){
if((i__5770__auto___29689 < len__5769__auto___29688)){
args__5775__auto__.push((arguments[i__5770__auto___29689]));

var G__29690 = (i__5770__auto___29689 + (1));
i__5770__auto___29689 = G__29690;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((4) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((4)),(0),null)):null);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5776__auto__);
});

(milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic = (function (id,xform_id,name,service_url,p__29684){
var vec__29685 = p__29684;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29685,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
}));

(milia.api.rest_services.update_restservice.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(milia.api.rest_services.update_restservice.cljs$lang$applyTo = (function (seq29679){
var G__29680 = cljs.core.first(seq29679);
var seq29679__$1 = cljs.core.next(seq29679);
var G__29681 = cljs.core.first(seq29679__$1);
var seq29679__$2 = cljs.core.next(seq29679__$1);
var G__29682 = cljs.core.first(seq29679__$2);
var seq29679__$3 = cljs.core.next(seq29679__$2);
var G__29683 = cljs.core.first(seq29679__$3);
var seq29679__$4 = cljs.core.next(seq29679__$3);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29680,G__29681,G__29682,G__29683,seq29679__$4);
}));

/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices.json"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29695 = arguments.length;
var i__5770__auto___29696 = (0);
while(true){
if((i__5770__auto___29696 < len__5769__auto___29695)){
args__5775__auto__.push((arguments[i__5770__auto___29696]));

var G__29697 = (i__5770__auto___29696 + (1));
i__5770__auto___29696 = G__29697;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__29693){
var map__29694 = p__29693;
var map__29694__$1 = cljs.core.__destructure_map(map__29694);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29694__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

(milia.api.rest_services.get_by_id.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.rest_services.get_by_id.cljs$lang$applyTo = (function (seq29691){
var G__29692 = cljs.core.first(seq29691);
var seq29691__$1 = cljs.core.next(seq29691);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29692,seq29691__$1);
}));

/**
 * Get rest services for a form
 */
milia.api.rest_services.get_by_form_id = (function milia$api$rest_services$get_by_form_id(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29702 = arguments.length;
var i__5770__auto___29703 = (0);
while(true){
if((i__5770__auto___29703 < len__5769__auto___29702)){
args__5775__auto__.push((arguments[i__5770__auto___29703]));

var G__29704 = (i__5770__auto___29703 + (1));
i__5770__auto___29703 = G__29704;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic = (function (formid,p__29700){
var map__29701 = p__29700;
var map__29701__$1 = cljs.core.__destructure_map(map__29701);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29701__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["restservices.json?xform=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(formid)].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

(milia.api.rest_services.get_by_form_id.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.rest_services.get_by_form_id.cljs$lang$applyTo = (function (seq29698){
var G__29699 = cljs.core.first(seq29698);
var seq29698__$1 = cljs.core.next(seq29698);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29699,seq29698__$1);
}));

