// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29527 = arguments.length;
var i__5770__auto___29528 = (0);
while(true){
if((i__5770__auto___29528 < len__5769__auto___29527)){
args__5775__auto__.push((arguments[i__5770__auto___29528]));

var G__29529 = (i__5770__auto___29528 + (1));
i__5770__auto___29528 = G__29529;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__29475){
var map__29476 = p__29475;
var map__29476__$1 = cljs.core.__destructure_map(map__29476);
var options = map__29476__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29476__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29476__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_29507){
var state_val_29508 = (state_29507[(1)]);
if((state_val_29508 === (7))){
var inst_29493 = (state_29507[(2)]);
var state_29507__$1 = state_29507;
if(cljs.core.truth_(inst_29493)){
var statearr_29509_29530 = state_29507__$1;
(statearr_29509_29530[(1)] = (8));

} else {
var statearr_29510_29531 = state_29507__$1;
(statearr_29510_29531[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29508 === (1))){
var inst_29477 = milia.utils.retry.initial_polling_interval;
var inst_29478 = inst_29477;
var inst_29479 = (0);
var state_29507__$1 = (function (){var statearr_29511 = state_29507;
(statearr_29511[(7)] = inst_29479);

(statearr_29511[(8)] = inst_29478);

return statearr_29511;
})();
var statearr_29512_29532 = state_29507__$1;
(statearr_29512_29532[(2)] = null);

(statearr_29512_29532[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29508 === (4))){
var inst_29486 = (state_29507[(9)]);
var inst_29488 = (state_29507[(10)]);
var inst_29485 = (state_29507[(2)]);
var inst_29486__$1 = cljs.core.__destructure_map(inst_29485);
var inst_29487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29486__$1,cljs.core.cst$kw$status);
var inst_29488__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_29487);
var state_29507__$1 = (function (){var statearr_29513 = state_29507;
(statearr_29513[(9)] = inst_29486__$1);

(statearr_29513[(10)] = inst_29488__$1);

return statearr_29513;
})();
if(inst_29488__$1){
var statearr_29514_29533 = state_29507__$1;
(statearr_29514_29533[(1)] = (5));

} else {
var statearr_29515_29534 = state_29507__$1;
(statearr_29515_29534[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29508 === (6))){
var inst_29488 = (state_29507[(10)]);
var state_29507__$1 = state_29507;
var statearr_29516_29535 = state_29507__$1;
(statearr_29516_29535[(2)] = inst_29488);

(statearr_29516_29535[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29508 === (3))){
var inst_29505 = (state_29507[(2)]);
var state_29507__$1 = state_29507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29507__$1,inst_29505);
} else {
if((state_val_29508 === (2))){
var inst_29482 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_29483 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([method,url,inst_29482], 0));
var state_29507__$1 = state_29507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29507__$1,(4),inst_29483);
} else {
if((state_val_29508 === (11))){
var inst_29479 = (state_29507[(7)]);
var inst_29478 = (state_29507[(8)]);
var inst_29497 = (state_29507[(2)]);
var inst_29498 = (inst_29478 * (2));
var inst_29499 = (inst_29479 + (1));
var inst_29478__$1 = inst_29498;
var inst_29479__$1 = inst_29499;
var state_29507__$1 = (function (){var statearr_29517 = state_29507;
(statearr_29517[(7)] = inst_29479__$1);

(statearr_29517[(11)] = inst_29497);

(statearr_29517[(8)] = inst_29478__$1);

return statearr_29517;
})();
var statearr_29518_29536 = state_29507__$1;
(statearr_29518_29536[(2)] = null);

(statearr_29518_29536[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29508 === (9))){
var inst_29486 = (state_29507[(9)]);
var state_29507__$1 = state_29507;
var statearr_29519_29537 = state_29507__$1;
(statearr_29519_29537[(2)] = inst_29486);

(statearr_29519_29537[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29508 === (5))){
var inst_29479 = (state_29507[(7)]);
var inst_29490 = (inst_29479 < max_retries);
var state_29507__$1 = state_29507;
var statearr_29520_29538 = state_29507__$1;
(statearr_29520_29538[(2)] = inst_29490);

(statearr_29520_29538[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29508 === (10))){
var inst_29503 = (state_29507[(2)]);
var state_29507__$1 = state_29507;
var statearr_29521_29539 = state_29507__$1;
(statearr_29521_29539[(2)] = inst_29503);

(statearr_29521_29539[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29508 === (8))){
var inst_29478 = (state_29507[(8)]);
var inst_29495 = cljs.core.async.timeout(inst_29478);
var state_29507__$1 = state_29507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29507__$1,(11),inst_29495);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var milia$utils$retry$state_machine__25297__auto__ = null;
var milia$utils$retry$state_machine__25297__auto____0 = (function (){
var statearr_29522 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29522[(0)] = milia$utils$retry$state_machine__25297__auto__);

(statearr_29522[(1)] = (1));

return statearr_29522;
});
var milia$utils$retry$state_machine__25297__auto____1 = (function (state_29507){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_29507);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e29523){var ex__25300__auto__ = e29523;
var statearr_29524_29540 = state_29507;
(statearr_29524_29540[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_29507[(4)]))){
var statearr_29525_29541 = state_29507;
(statearr_29525_29541[(1)] = cljs.core.first((state_29507[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__29542 = state_29507;
state_29507 = G__29542;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
milia$utils$retry$state_machine__25297__auto__ = function(state_29507){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__25297__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__25297__auto____1.call(this,state_29507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__25297__auto____0;
milia$utils$retry$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__25297__auto____1;
return milia$utils$retry$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_29526 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_29526[(6)] = c__25371__auto__);

return statearr_29526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
}));

(milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq29472){
var G__29473 = cljs.core.first(seq29472);
var seq29472__$1 = cljs.core.next(seq29472);
var G__29474 = cljs.core.first(seq29472__$1);
var seq29472__$2 = cljs.core.next(seq29472__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29473,G__29474,seq29472__$2);
}));

