"use strict";

module.exports = {
    description: "ignoreUnresolvableReferences - Ignore remote references in schemas",
    options: {
        ignoreUnresolvableReferences: true
    },
    validateSchemaOnly: true,
    tests: [
        {
            schema: {
                "$schema": "http://doesnt-exists.org/draft-04/schema",
            },
            description: "should pass schema validation because link is to http schema",
            valid: true
        },
        {
            schema: {
                "definitions": {
                    "a": {"type": "integer"},
                    "b": {"$ref": "#/definitions/a"},
                    "c": {"$ref": "#/definitions/b"}
                },
                "$ref": "#/definitions/c"
            },
            description: "should pass schema validation because definitions are resolvable",
            valid: true
        },
        {
            schema: {
                "definitions": {
                    "a": {"type": "integer"},
                    "b": {"$ref": "#/definitions/aaa"},
                    "c": {"$ref": "#/definitions/b"}
                },
                "$ref": "#/definitions/c"
            },
            description: "should fail schema validation because definitions are not resolvable",
            valid: false
        }
    ]
};
