// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__20130__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__20129 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__20129,(0),null);
var body = cljs.core.nthnext.call(null,vec__20129,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__20130 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__20131__i = 0, G__20131__a = new Array(arguments.length -  0);
while (G__20131__i < G__20131__a.length) {G__20131__a[G__20131__i] = arguments[G__20131__i + 0]; ++G__20131__i;}
  args = new cljs.core.IndexedSeq(G__20131__a,0);
} 
return G__20130__delegate.call(this,args);};
G__20130.cljs$lang$maxFixedArity = 0;
G__20130.cljs$lang$applyTo = (function (arglist__20132){
var args = cljs.core.seq(arglist__20132);
return G__20130__delegate(args);
});
G__20130.cljs$core$IFn$_invoke$arity$variadic = G__20130__delegate;
return G__20130;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__20137(s__20138){
return (new cljs.core.LazySeq(null,(function (){
var s__20138__$1 = s__20138;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20138__$1);
if(temp__4425__auto__){
var s__20138__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20138__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20138__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20140 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20139 = (0);
while(true){
if((i__20139 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__20139);
cljs.core.chunk_append.call(null,b__20140,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__20141 = (i__20139 + (1));
i__20139 = G__20141;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20140),sablono$core$update_arglists_$_iter__20137.call(null,cljs.core.chunk_rest.call(null,s__20138__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20140),null);
}
} else {
var args = cljs.core.first.call(null,s__20138__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__20137.call(null,cljs.core.rest.call(null,s__20138__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20147 = arguments.length;
var i__5727__auto___20148 = (0);
while(true){
if((i__5727__auto___20148 < len__5726__auto___20147)){
args__5733__auto__.push((arguments[i__5727__auto___20148]));

var G__20149 = (i__5727__auto___20148 + (1));
i__5727__auto___20148 = G__20149;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__20143(s__20144){
return (new cljs.core.LazySeq(null,(function (){
var s__20144__$1 = s__20144;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20144__$1);
if(temp__4425__auto__){
var s__20144__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20144__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20144__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20146 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20145 = (0);
while(true){
if((i__20145 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__20145);
cljs.core.chunk_append.call(null,b__20146,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__20150 = (i__20145 + (1));
i__20145 = G__20150;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20146),sablono$core$iter__20143.call(null,cljs.core.chunk_rest.call(null,s__20144__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20146),null);
}
} else {
var style = cljs.core.first.call(null,s__20144__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__20143.call(null,cljs.core.rest.call(null,s__20144__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq20142){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20142));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to20151 = (function sablono$core$link_to20151(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20154 = arguments.length;
var i__5727__auto___20155 = (0);
while(true){
if((i__5727__auto___20155 < len__5726__auto___20154)){
args__5733__auto__.push((arguments[i__5727__auto___20155]));

var G__20156 = (i__5727__auto___20155 + (1));
i__5727__auto___20155 = G__20156;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to20151.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to20151.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to20151.cljs$lang$maxFixedArity = (1);

sablono.core.link_to20151.cljs$lang$applyTo = (function (seq20152){
var G__20153 = cljs.core.first.call(null,seq20152);
var seq20152__$1 = cljs.core.next.call(null,seq20152);
return sablono.core.link_to20151.cljs$core$IFn$_invoke$arity$variadic(G__20153,seq20152__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to20151);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to20157 = (function sablono$core$mail_to20157(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20162 = arguments.length;
var i__5727__auto___20163 = (0);
while(true){
if((i__5727__auto___20163 < len__5726__auto___20162)){
args__5733__auto__.push((arguments[i__5727__auto___20163]));

var G__20164 = (i__5727__auto___20163 + (1));
i__5727__auto___20163 = G__20164;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to20157.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to20157.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__20160){
var vec__20161 = p__20160;
var content = cljs.core.nth.call(null,vec__20161,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to20157.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to20157.cljs$lang$applyTo = (function (seq20158){
var G__20159 = cljs.core.first.call(null,seq20158);
var seq20158__$1 = cljs.core.next.call(null,seq20158);
return sablono.core.mail_to20157.cljs$core$IFn$_invoke$arity$variadic(G__20159,seq20158__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to20157);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list20165 = (function sablono$core$unordered_list20165(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list20165_$_iter__20170(s__20171){
return (new cljs.core.LazySeq(null,(function (){
var s__20171__$1 = s__20171;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20171__$1);
if(temp__4425__auto__){
var s__20171__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20171__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20171__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20173 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20172 = (0);
while(true){
if((i__20172 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20172);
cljs.core.chunk_append.call(null,b__20173,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20174 = (i__20172 + (1));
i__20172 = G__20174;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20173),sablono$core$unordered_list20165_$_iter__20170.call(null,cljs.core.chunk_rest.call(null,s__20171__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20173),null);
}
} else {
var x = cljs.core.first.call(null,s__20171__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list20165_$_iter__20170.call(null,cljs.core.rest.call(null,s__20171__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list20165);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list20175 = (function sablono$core$ordered_list20175(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list20175_$_iter__20180(s__20181){
return (new cljs.core.LazySeq(null,(function (){
var s__20181__$1 = s__20181;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20181__$1);
if(temp__4425__auto__){
var s__20181__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20181__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20181__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20183 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20182 = (0);
while(true){
if((i__20182 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20182);
cljs.core.chunk_append.call(null,b__20183,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20184 = (i__20182 + (1));
i__20182 = G__20184;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20183),sablono$core$ordered_list20175_$_iter__20180.call(null,cljs.core.chunk_rest.call(null,s__20181__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20183),null);
}
} else {
var x = cljs.core.first.call(null,s__20181__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list20175_$_iter__20180.call(null,cljs.core.rest.call(null,s__20181__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list20175);
/**
 * Create an image element.
 */
sablono.core.image20185 = (function sablono$core$image20185(var_args){
var args20186 = [];
var len__5726__auto___20189 = arguments.length;
var i__5727__auto___20190 = (0);
while(true){
if((i__5727__auto___20190 < len__5726__auto___20189)){
args20186.push((arguments[i__5727__auto___20190]));

var G__20191 = (i__5727__auto___20190 + (1));
i__5727__auto___20190 = G__20191;
continue;
} else {
}
break;
}

var G__20188 = args20186.length;
switch (G__20188) {
case 1:
return sablono.core.image20185.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image20185.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20186.length)].join('')));

}
});

sablono.core.image20185.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image20185.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image20185.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image20185);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__20193_SHARP_,p2__20194_SHARP_){
return [cljs.core.str(p1__20193_SHARP_),cljs.core.str("["),cljs.core.str(p2__20194_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__20195_SHARP_,p2__20196_SHARP_){
return [cljs.core.str(p1__20195_SHARP_),cljs.core.str("-"),cljs.core.str(p2__20196_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field20197 = (function sablono$core$color_field20197(var_args){
var args20198 = [];
var len__5726__auto___20265 = arguments.length;
var i__5727__auto___20266 = (0);
while(true){
if((i__5727__auto___20266 < len__5726__auto___20265)){
args20198.push((arguments[i__5727__auto___20266]));

var G__20267 = (i__5727__auto___20266 + (1));
i__5727__auto___20266 = G__20267;
continue;
} else {
}
break;
}

var G__20200 = args20198.length;
switch (G__20200) {
case 1:
return sablono.core.color_field20197.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field20197.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20198.length)].join('')));

}
});

sablono.core.color_field20197.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.color_field20197.call(null,name__11649__auto__,null);
});

sablono.core.color_field20197.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.color_field20197.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field20197);

/**
 * Creates a date input field.
 */
sablono.core.date_field20201 = (function sablono$core$date_field20201(var_args){
var args20202 = [];
var len__5726__auto___20269 = arguments.length;
var i__5727__auto___20270 = (0);
while(true){
if((i__5727__auto___20270 < len__5726__auto___20269)){
args20202.push((arguments[i__5727__auto___20270]));

var G__20271 = (i__5727__auto___20270 + (1));
i__5727__auto___20270 = G__20271;
continue;
} else {
}
break;
}

var G__20204 = args20202.length;
switch (G__20204) {
case 1:
return sablono.core.date_field20201.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field20201.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20202.length)].join('')));

}
});

sablono.core.date_field20201.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.date_field20201.call(null,name__11649__auto__,null);
});

sablono.core.date_field20201.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.date_field20201.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field20201);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field20205 = (function sablono$core$datetime_field20205(var_args){
var args20206 = [];
var len__5726__auto___20273 = arguments.length;
var i__5727__auto___20274 = (0);
while(true){
if((i__5727__auto___20274 < len__5726__auto___20273)){
args20206.push((arguments[i__5727__auto___20274]));

var G__20275 = (i__5727__auto___20274 + (1));
i__5727__auto___20274 = G__20275;
continue;
} else {
}
break;
}

var G__20208 = args20206.length;
switch (G__20208) {
case 1:
return sablono.core.datetime_field20205.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field20205.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20206.length)].join('')));

}
});

sablono.core.datetime_field20205.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_field20205.call(null,name__11649__auto__,null);
});

sablono.core.datetime_field20205.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_field20205.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field20205);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field20209 = (function sablono$core$datetime_local_field20209(var_args){
var args20210 = [];
var len__5726__auto___20277 = arguments.length;
var i__5727__auto___20278 = (0);
while(true){
if((i__5727__auto___20278 < len__5726__auto___20277)){
args20210.push((arguments[i__5727__auto___20278]));

var G__20279 = (i__5727__auto___20278 + (1));
i__5727__auto___20278 = G__20279;
continue;
} else {
}
break;
}

var G__20212 = args20210.length;
switch (G__20212) {
case 1:
return sablono.core.datetime_local_field20209.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field20209.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20210.length)].join('')));

}
});

sablono.core.datetime_local_field20209.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_local_field20209.call(null,name__11649__auto__,null);
});

sablono.core.datetime_local_field20209.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_local_field20209.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field20209);

/**
 * Creates a email input field.
 */
sablono.core.email_field20213 = (function sablono$core$email_field20213(var_args){
var args20214 = [];
var len__5726__auto___20281 = arguments.length;
var i__5727__auto___20282 = (0);
while(true){
if((i__5727__auto___20282 < len__5726__auto___20281)){
args20214.push((arguments[i__5727__auto___20282]));

var G__20283 = (i__5727__auto___20282 + (1));
i__5727__auto___20282 = G__20283;
continue;
} else {
}
break;
}

var G__20216 = args20214.length;
switch (G__20216) {
case 1:
return sablono.core.email_field20213.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field20213.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20214.length)].join('')));

}
});

sablono.core.email_field20213.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.email_field20213.call(null,name__11649__auto__,null);
});

sablono.core.email_field20213.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.email_field20213.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field20213);

/**
 * Creates a file input field.
 */
sablono.core.file_field20217 = (function sablono$core$file_field20217(var_args){
var args20218 = [];
var len__5726__auto___20285 = arguments.length;
var i__5727__auto___20286 = (0);
while(true){
if((i__5727__auto___20286 < len__5726__auto___20285)){
args20218.push((arguments[i__5727__auto___20286]));

var G__20287 = (i__5727__auto___20286 + (1));
i__5727__auto___20286 = G__20287;
continue;
} else {
}
break;
}

var G__20220 = args20218.length;
switch (G__20220) {
case 1:
return sablono.core.file_field20217.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field20217.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20218.length)].join('')));

}
});

sablono.core.file_field20217.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.file_field20217.call(null,name__11649__auto__,null);
});

sablono.core.file_field20217.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.file_field20217.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field20217);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field20221 = (function sablono$core$hidden_field20221(var_args){
var args20222 = [];
var len__5726__auto___20289 = arguments.length;
var i__5727__auto___20290 = (0);
while(true){
if((i__5727__auto___20290 < len__5726__auto___20289)){
args20222.push((arguments[i__5727__auto___20290]));

var G__20291 = (i__5727__auto___20290 + (1));
i__5727__auto___20290 = G__20291;
continue;
} else {
}
break;
}

var G__20224 = args20222.length;
switch (G__20224) {
case 1:
return sablono.core.hidden_field20221.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field20221.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20222.length)].join('')));

}
});

sablono.core.hidden_field20221.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.hidden_field20221.call(null,name__11649__auto__,null);
});

sablono.core.hidden_field20221.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.hidden_field20221.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field20221);

/**
 * Creates a month input field.
 */
sablono.core.month_field20225 = (function sablono$core$month_field20225(var_args){
var args20226 = [];
var len__5726__auto___20293 = arguments.length;
var i__5727__auto___20294 = (0);
while(true){
if((i__5727__auto___20294 < len__5726__auto___20293)){
args20226.push((arguments[i__5727__auto___20294]));

var G__20295 = (i__5727__auto___20294 + (1));
i__5727__auto___20294 = G__20295;
continue;
} else {
}
break;
}

var G__20228 = args20226.length;
switch (G__20228) {
case 1:
return sablono.core.month_field20225.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field20225.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20226.length)].join('')));

}
});

sablono.core.month_field20225.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.month_field20225.call(null,name__11649__auto__,null);
});

sablono.core.month_field20225.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.month_field20225.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field20225);

/**
 * Creates a number input field.
 */
sablono.core.number_field20229 = (function sablono$core$number_field20229(var_args){
var args20230 = [];
var len__5726__auto___20297 = arguments.length;
var i__5727__auto___20298 = (0);
while(true){
if((i__5727__auto___20298 < len__5726__auto___20297)){
args20230.push((arguments[i__5727__auto___20298]));

var G__20299 = (i__5727__auto___20298 + (1));
i__5727__auto___20298 = G__20299;
continue;
} else {
}
break;
}

var G__20232 = args20230.length;
switch (G__20232) {
case 1:
return sablono.core.number_field20229.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field20229.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20230.length)].join('')));

}
});

sablono.core.number_field20229.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.number_field20229.call(null,name__11649__auto__,null);
});

sablono.core.number_field20229.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.number_field20229.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field20229);

/**
 * Creates a password input field.
 */
sablono.core.password_field20233 = (function sablono$core$password_field20233(var_args){
var args20234 = [];
var len__5726__auto___20301 = arguments.length;
var i__5727__auto___20302 = (0);
while(true){
if((i__5727__auto___20302 < len__5726__auto___20301)){
args20234.push((arguments[i__5727__auto___20302]));

var G__20303 = (i__5727__auto___20302 + (1));
i__5727__auto___20302 = G__20303;
continue;
} else {
}
break;
}

var G__20236 = args20234.length;
switch (G__20236) {
case 1:
return sablono.core.password_field20233.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field20233.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20234.length)].join('')));

}
});

sablono.core.password_field20233.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.password_field20233.call(null,name__11649__auto__,null);
});

sablono.core.password_field20233.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.password_field20233.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field20233);

/**
 * Creates a range input field.
 */
sablono.core.range_field20237 = (function sablono$core$range_field20237(var_args){
var args20238 = [];
var len__5726__auto___20305 = arguments.length;
var i__5727__auto___20306 = (0);
while(true){
if((i__5727__auto___20306 < len__5726__auto___20305)){
args20238.push((arguments[i__5727__auto___20306]));

var G__20307 = (i__5727__auto___20306 + (1));
i__5727__auto___20306 = G__20307;
continue;
} else {
}
break;
}

var G__20240 = args20238.length;
switch (G__20240) {
case 1:
return sablono.core.range_field20237.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field20237.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20238.length)].join('')));

}
});

sablono.core.range_field20237.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.range_field20237.call(null,name__11649__auto__,null);
});

sablono.core.range_field20237.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.range_field20237.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field20237);

/**
 * Creates a search input field.
 */
sablono.core.search_field20241 = (function sablono$core$search_field20241(var_args){
var args20242 = [];
var len__5726__auto___20309 = arguments.length;
var i__5727__auto___20310 = (0);
while(true){
if((i__5727__auto___20310 < len__5726__auto___20309)){
args20242.push((arguments[i__5727__auto___20310]));

var G__20311 = (i__5727__auto___20310 + (1));
i__5727__auto___20310 = G__20311;
continue;
} else {
}
break;
}

var G__20244 = args20242.length;
switch (G__20244) {
case 1:
return sablono.core.search_field20241.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field20241.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20242.length)].join('')));

}
});

sablono.core.search_field20241.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.search_field20241.call(null,name__11649__auto__,null);
});

sablono.core.search_field20241.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.search_field20241.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field20241);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field20245 = (function sablono$core$tel_field20245(var_args){
var args20246 = [];
var len__5726__auto___20313 = arguments.length;
var i__5727__auto___20314 = (0);
while(true){
if((i__5727__auto___20314 < len__5726__auto___20313)){
args20246.push((arguments[i__5727__auto___20314]));

var G__20315 = (i__5727__auto___20314 + (1));
i__5727__auto___20314 = G__20315;
continue;
} else {
}
break;
}

var G__20248 = args20246.length;
switch (G__20248) {
case 1:
return sablono.core.tel_field20245.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field20245.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20246.length)].join('')));

}
});

sablono.core.tel_field20245.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.tel_field20245.call(null,name__11649__auto__,null);
});

sablono.core.tel_field20245.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.tel_field20245.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field20245);

/**
 * Creates a text input field.
 */
sablono.core.text_field20249 = (function sablono$core$text_field20249(var_args){
var args20250 = [];
var len__5726__auto___20317 = arguments.length;
var i__5727__auto___20318 = (0);
while(true){
if((i__5727__auto___20318 < len__5726__auto___20317)){
args20250.push((arguments[i__5727__auto___20318]));

var G__20319 = (i__5727__auto___20318 + (1));
i__5727__auto___20318 = G__20319;
continue;
} else {
}
break;
}

var G__20252 = args20250.length;
switch (G__20252) {
case 1:
return sablono.core.text_field20249.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field20249.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20250.length)].join('')));

}
});

sablono.core.text_field20249.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.text_field20249.call(null,name__11649__auto__,null);
});

sablono.core.text_field20249.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.text_field20249.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field20249);

/**
 * Creates a time input field.
 */
sablono.core.time_field20253 = (function sablono$core$time_field20253(var_args){
var args20254 = [];
var len__5726__auto___20321 = arguments.length;
var i__5727__auto___20322 = (0);
while(true){
if((i__5727__auto___20322 < len__5726__auto___20321)){
args20254.push((arguments[i__5727__auto___20322]));

var G__20323 = (i__5727__auto___20322 + (1));
i__5727__auto___20322 = G__20323;
continue;
} else {
}
break;
}

var G__20256 = args20254.length;
switch (G__20256) {
case 1:
return sablono.core.time_field20253.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field20253.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20254.length)].join('')));

}
});

sablono.core.time_field20253.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.time_field20253.call(null,name__11649__auto__,null);
});

sablono.core.time_field20253.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.time_field20253.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field20253);

/**
 * Creates a url input field.
 */
sablono.core.url_field20257 = (function sablono$core$url_field20257(var_args){
var args20258 = [];
var len__5726__auto___20325 = arguments.length;
var i__5727__auto___20326 = (0);
while(true){
if((i__5727__auto___20326 < len__5726__auto___20325)){
args20258.push((arguments[i__5727__auto___20326]));

var G__20327 = (i__5727__auto___20326 + (1));
i__5727__auto___20326 = G__20327;
continue;
} else {
}
break;
}

var G__20260 = args20258.length;
switch (G__20260) {
case 1:
return sablono.core.url_field20257.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field20257.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20258.length)].join('')));

}
});

sablono.core.url_field20257.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.url_field20257.call(null,name__11649__auto__,null);
});

sablono.core.url_field20257.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.url_field20257.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field20257);

/**
 * Creates a week input field.
 */
sablono.core.week_field20261 = (function sablono$core$week_field20261(var_args){
var args20262 = [];
var len__5726__auto___20329 = arguments.length;
var i__5727__auto___20330 = (0);
while(true){
if((i__5727__auto___20330 < len__5726__auto___20329)){
args20262.push((arguments[i__5727__auto___20330]));

var G__20331 = (i__5727__auto___20330 + (1));
i__5727__auto___20330 = G__20331;
continue;
} else {
}
break;
}

var G__20264 = args20262.length;
switch (G__20264) {
case 1:
return sablono.core.week_field20261.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field20261.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20262.length)].join('')));

}
});

sablono.core.week_field20261.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.week_field20261.call(null,name__11649__auto__,null);
});

sablono.core.week_field20261.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.week_field20261.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field20261);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box20333 = (function sablono$core$check_box20333(var_args){
var args20334 = [];
var len__5726__auto___20337 = arguments.length;
var i__5727__auto___20338 = (0);
while(true){
if((i__5727__auto___20338 < len__5726__auto___20337)){
args20334.push((arguments[i__5727__auto___20338]));

var G__20339 = (i__5727__auto___20338 + (1));
i__5727__auto___20338 = G__20339;
continue;
} else {
}
break;
}

var G__20336 = args20334.length;
switch (G__20336) {
case 1:
return sablono.core.check_box20333.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box20333.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box20333.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20334.length)].join('')));

}
});

sablono.core.check_box20333.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box20333.call(null,name,null);
});

sablono.core.check_box20333.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box20333.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box20333.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20333.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box20333);
/**
 * Creates a radio button.
 */
sablono.core.radio_button20341 = (function sablono$core$radio_button20341(var_args){
var args20342 = [];
var len__5726__auto___20345 = arguments.length;
var i__5727__auto___20346 = (0);
while(true){
if((i__5727__auto___20346 < len__5726__auto___20345)){
args20342.push((arguments[i__5727__auto___20346]));

var G__20347 = (i__5727__auto___20346 + (1));
i__5727__auto___20346 = G__20347;
continue;
} else {
}
break;
}

var G__20344 = args20342.length;
switch (G__20344) {
case 1:
return sablono.core.radio_button20341.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button20341.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button20341.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20342.length)].join('')));

}
});

sablono.core.radio_button20341.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button20341.call(null,group,null);
});

sablono.core.radio_button20341.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button20341.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button20341.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20341.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button20341);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options20349 = (function sablono$core$select_options20349(coll){
var iter__5440__auto__ = (function sablono$core$select_options20349_$_iter__20358(s__20359){
return (new cljs.core.LazySeq(null,(function (){
var s__20359__$1 = s__20359;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20359__$1);
if(temp__4425__auto__){
var s__20359__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20359__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20359__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20361 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20360 = (0);
while(true){
if((i__20360 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20360);
cljs.core.chunk_append.call(null,b__20361,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20364 = x;
var text = cljs.core.nth.call(null,vec__20364,(0),null);
var val = cljs.core.nth.call(null,vec__20364,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20364,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20349.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__20366 = (i__20360 + (1));
i__20360 = G__20366;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20361),sablono$core$select_options20349_$_iter__20358.call(null,cljs.core.chunk_rest.call(null,s__20359__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20361),null);
}
} else {
var x = cljs.core.first.call(null,s__20359__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20365 = x;
var text = cljs.core.nth.call(null,vec__20365,(0),null);
var val = cljs.core.nth.call(null,vec__20365,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20365,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20349.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options20349_$_iter__20358.call(null,cljs.core.rest.call(null,s__20359__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options20349);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down20367 = (function sablono$core$drop_down20367(var_args){
var args20368 = [];
var len__5726__auto___20371 = arguments.length;
var i__5727__auto___20372 = (0);
while(true){
if((i__5727__auto___20372 < len__5726__auto___20371)){
args20368.push((arguments[i__5727__auto___20372]));

var G__20373 = (i__5727__auto___20372 + (1));
i__5727__auto___20372 = G__20373;
continue;
} else {
}
break;
}

var G__20370 = args20368.length;
switch (G__20370) {
case 2:
return sablono.core.drop_down20367.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down20367.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20368.length)].join('')));

}
});

sablono.core.drop_down20367.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down20367.call(null,name,options,null);
});

sablono.core.drop_down20367.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down20367.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down20367);
/**
 * Creates a text area element.
 */
sablono.core.text_area20375 = (function sablono$core$text_area20375(var_args){
var args20376 = [];
var len__5726__auto___20379 = arguments.length;
var i__5727__auto___20380 = (0);
while(true){
if((i__5727__auto___20380 < len__5726__auto___20379)){
args20376.push((arguments[i__5727__auto___20380]));

var G__20381 = (i__5727__auto___20380 + (1));
i__5727__auto___20380 = G__20381;
continue;
} else {
}
break;
}

var G__20378 = args20376.length;
switch (G__20378) {
case 1:
return sablono.core.text_area20375.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area20375.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20376.length)].join('')));

}
});

sablono.core.text_area20375.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area20375.call(null,name,null);
});

sablono.core.text_area20375.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area20375.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area20375);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20383 = (function sablono$core$label20383(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20383);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20384 = (function sablono$core$submit_button20384(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20384);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20385 = (function sablono$core$reset_button20385(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20385);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20386 = (function sablono$core$form_to20386(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20391 = arguments.length;
var i__5727__auto___20392 = (0);
while(true){
if((i__5727__auto___20392 < len__5726__auto___20391)){
args__5733__auto__.push((arguments[i__5727__auto___20392]));

var G__20393 = (i__5727__auto___20392 + (1));
i__5727__auto___20392 = G__20393;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to20386.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to20386.cljs$core$IFn$_invoke$arity$variadic = (function (p__20389,body){
var vec__20390 = p__20389;
var method = cljs.core.nth.call(null,vec__20390,(0),null);
var action = cljs.core.nth.call(null,vec__20390,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to20386.cljs$lang$maxFixedArity = (1);

sablono.core.form_to20386.cljs$lang$applyTo = (function (seq20387){
var G__20388 = cljs.core.first.call(null,seq20387);
var seq20387__$1 = cljs.core.next.call(null,seq20387);
return sablono.core.form_to20386.cljs$core$IFn$_invoke$arity$variadic(G__20388,seq20387__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20386);

//# sourceMappingURL=core.js.map?rel=1453979772332