"use strict";

module.exports = {
    description: "Issue #26 - noTypeless behaviour",
    options: {
        noTypeless: true
    },
    tests: [
        {
            description: "should pass validation",
            schema: {
                "oneOf": [
                    { $ref: "#/definitions/str" },
                    { $ref: "#/definitions/num" }
                ],
                "definitions": {
                    "str": {
                        "type": "string"
                    },
                    "num": {
                        "type": "number"
                    }
                }
            },
            data: "string",
            valid: true
        },
        {
            description: "should fail validation",
            schema: {
                "oneOf": [
                    { $ref: "#/definitions/str" },
                    { $ref: "#/definitions/num" }
                ],
                "definitions": {
                    "str": {
                        "type": "string"
                    },
                    "num": {
                        "type": "number"
                    }
                }
            },
            data: true,
            valid: false
        },
        {
            description: "should fail validation because one of the definitions doesn't have a type",
            schema: {
                "oneOf": [
                    { $ref: "#/definitions/str" },
                    { $ref: "#/definitions/num" }
                ],
                "definitions": {
                    "str": {
                        "type": "string"
                    },
                    "num": {

                    }
                }
            },
            data: "string",
            valid: false,
            after: function (errors) {
                expect(errors[0].code).toBe("KEYWORD_UNDEFINED_STRICT");
            }
        },
        {
            description: "should pass validation because type is defined by parent",
            schema: {
                type: "object",
                properties: {
                    "prop1": { type: "string" },
                    "prop2": { type: "string" }
                },
                anyOf: [
                    { required: ["prop1"] },
                    { required: ["prop2"] }
                ]
            },
            data: {
                prop1: "str"
            },
            valid: true
        }
    ]
};
