// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11106 = [];
var len__5726__auto___11112 = arguments.length;
var i__5727__auto___11113 = (0);
while(true){
if((i__5727__auto___11113 < len__5726__auto___11112)){
args11106.push((arguments[i__5727__auto___11113]));

var G__11114 = (i__5727__auto___11113 + (1));
i__5727__auto___11113 = G__11114;
continue;
} else {
}
break;
}

var G__11108 = args11106.length;
switch (G__11108) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11106.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11109 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11109 = (function (f,blockable,meta11110){
this.f = f;
this.blockable = blockable;
this.meta11110 = meta11110;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11109.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11111,meta11110__$1){
var self__ = this;
var _11111__$1 = this;
return (new cljs.core.async.t_cljs$core$async11109(self__.f,self__.blockable,meta11110__$1));
});

cljs.core.async.t_cljs$core$async11109.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11111){
var self__ = this;
var _11111__$1 = this;
return self__.meta11110;
});

cljs.core.async.t_cljs$core$async11109.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11109.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11109.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11109.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11109.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11110","meta11110",95840792,null)], null);
});

cljs.core.async.t_cljs$core$async11109.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11109.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11109";

cljs.core.async.t_cljs$core$async11109.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11109");
});

cljs.core.async.__GT_t_cljs$core$async11109 = (function cljs$core$async$__GT_t_cljs$core$async11109(f__$1,blockable__$1,meta11110){
return (new cljs.core.async.t_cljs$core$async11109(f__$1,blockable__$1,meta11110));
});

}

return (new cljs.core.async.t_cljs$core$async11109(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11118 = [];
var len__5726__auto___11121 = arguments.length;
var i__5727__auto___11122 = (0);
while(true){
if((i__5727__auto___11122 < len__5726__auto___11121)){
args11118.push((arguments[i__5727__auto___11122]));

var G__11123 = (i__5727__auto___11122 + (1));
i__5727__auto___11122 = G__11123;
continue;
} else {
}
break;
}

var G__11120 = args11118.length;
switch (G__11120) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11118.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11125 = [];
var len__5726__auto___11128 = arguments.length;
var i__5727__auto___11129 = (0);
while(true){
if((i__5727__auto___11129 < len__5726__auto___11128)){
args11125.push((arguments[i__5727__auto___11129]));

var G__11130 = (i__5727__auto___11129 + (1));
i__5727__auto___11129 = G__11130;
continue;
} else {
}
break;
}

var G__11127 = args11125.length;
switch (G__11127) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11125.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11132 = [];
var len__5726__auto___11135 = arguments.length;
var i__5727__auto___11136 = (0);
while(true){
if((i__5727__auto___11136 < len__5726__auto___11135)){
args11132.push((arguments[i__5727__auto___11136]));

var G__11137 = (i__5727__auto___11136 + (1));
i__5727__auto___11136 = G__11137;
continue;
} else {
}
break;
}

var G__11134 = args11132.length;
switch (G__11134) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11132.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11139 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11139);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11139,ret){
return (function (){
return fn1.call(null,val_11139);
});})(val_11139,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11140 = [];
var len__5726__auto___11143 = arguments.length;
var i__5727__auto___11144 = (0);
while(true){
if((i__5727__auto___11144 < len__5726__auto___11143)){
args11140.push((arguments[i__5727__auto___11144]));

var G__11145 = (i__5727__auto___11144 + (1));
i__5727__auto___11144 = G__11145;
continue;
} else {
}
break;
}

var G__11142 = args11140.length;
switch (G__11142) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11140.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___11147 = n;
var x_11148 = (0);
while(true){
if((x_11148 < n__5571__auto___11147)){
(a[x_11148] = (0));

var G__11149 = (x_11148 + (1));
x_11148 = G__11149;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11150 = (i + (1));
i = G__11150;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11154 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11154 = (function (alt_flag,flag,meta11155){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11155 = meta11155;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11154.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11156,meta11155__$1){
var self__ = this;
var _11156__$1 = this;
return (new cljs.core.async.t_cljs$core$async11154(self__.alt_flag,self__.flag,meta11155__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11154.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11156){
var self__ = this;
var _11156__$1 = this;
return self__.meta11155;
});})(flag))
;

cljs.core.async.t_cljs$core$async11154.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11154.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11154.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11154.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11154.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11155","meta11155",2081124379,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11154.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11154.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11154";

cljs.core.async.t_cljs$core$async11154.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11154");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11154 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11154(alt_flag__$1,flag__$1,meta11155){
return (new cljs.core.async.t_cljs$core$async11154(alt_flag__$1,flag__$1,meta11155));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11154(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11160 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11160 = (function (alt_handler,flag,cb,meta11161){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11161 = meta11161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11162,meta11161__$1){
var self__ = this;
var _11162__$1 = this;
return (new cljs.core.async.t_cljs$core$async11160(self__.alt_handler,self__.flag,self__.cb,meta11161__$1));
});

cljs.core.async.t_cljs$core$async11160.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11162){
var self__ = this;
var _11162__$1 = this;
return self__.meta11161;
});

cljs.core.async.t_cljs$core$async11160.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11160.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11160.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11160.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11160.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11161","meta11161",-1706820768,null)], null);
});

cljs.core.async.t_cljs$core$async11160.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11160.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11160";

cljs.core.async.t_cljs$core$async11160.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11160");
});

cljs.core.async.__GT_t_cljs$core$async11160 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11160(alt_handler__$1,flag__$1,cb__$1,meta11161){
return (new cljs.core.async.t_cljs$core$async11160(alt_handler__$1,flag__$1,cb__$1,meta11161));
});

}

return (new cljs.core.async.t_cljs$core$async11160(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11163_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11163_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11164_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11164_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11165 = (i + (1));
i = G__11165;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11171 = arguments.length;
var i__5727__auto___11172 = (0);
while(true){
if((i__5727__auto___11172 < len__5726__auto___11171)){
args__5733__auto__.push((arguments[i__5727__auto___11172]));

var G__11173 = (i__5727__auto___11172 + (1));
i__5727__auto___11172 = G__11173;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11168){
var map__11169 = p__11168;
var map__11169__$1 = ((((!((map__11169 == null)))?((((map__11169.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11169.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11169):map__11169);
var opts = map__11169__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11166){
var G__11167 = cljs.core.first.call(null,seq11166);
var seq11166__$1 = cljs.core.next.call(null,seq11166);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11167,seq11166__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11174 = [];
var len__5726__auto___11224 = arguments.length;
var i__5727__auto___11225 = (0);
while(true){
if((i__5727__auto___11225 < len__5726__auto___11224)){
args11174.push((arguments[i__5727__auto___11225]));

var G__11226 = (i__5727__auto___11225 + (1));
i__5727__auto___11225 = G__11226;
continue;
} else {
}
break;
}

var G__11176 = args11174.length;
switch (G__11176) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11174.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11061__auto___11228 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___11228){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___11228){
return (function (state_11200){
var state_val_11201 = (state_11200[(1)]);
if((state_val_11201 === (7))){
var inst_11196 = (state_11200[(2)]);
var state_11200__$1 = state_11200;
var statearr_11202_11229 = state_11200__$1;
(statearr_11202_11229[(2)] = inst_11196);

(statearr_11202_11229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (1))){
var state_11200__$1 = state_11200;
var statearr_11203_11230 = state_11200__$1;
(statearr_11203_11230[(2)] = null);

(statearr_11203_11230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (4))){
var inst_11179 = (state_11200[(7)]);
var inst_11179__$1 = (state_11200[(2)]);
var inst_11180 = (inst_11179__$1 == null);
var state_11200__$1 = (function (){var statearr_11204 = state_11200;
(statearr_11204[(7)] = inst_11179__$1);

return statearr_11204;
})();
if(cljs.core.truth_(inst_11180)){
var statearr_11205_11231 = state_11200__$1;
(statearr_11205_11231[(1)] = (5));

} else {
var statearr_11206_11232 = state_11200__$1;
(statearr_11206_11232[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (13))){
var state_11200__$1 = state_11200;
var statearr_11207_11233 = state_11200__$1;
(statearr_11207_11233[(2)] = null);

(statearr_11207_11233[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (6))){
var inst_11179 = (state_11200[(7)]);
var state_11200__$1 = state_11200;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11200__$1,(11),to,inst_11179);
} else {
if((state_val_11201 === (3))){
var inst_11198 = (state_11200[(2)]);
var state_11200__$1 = state_11200;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11200__$1,inst_11198);
} else {
if((state_val_11201 === (12))){
var state_11200__$1 = state_11200;
var statearr_11208_11234 = state_11200__$1;
(statearr_11208_11234[(2)] = null);

(statearr_11208_11234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (2))){
var state_11200__$1 = state_11200;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11200__$1,(4),from);
} else {
if((state_val_11201 === (11))){
var inst_11189 = (state_11200[(2)]);
var state_11200__$1 = state_11200;
if(cljs.core.truth_(inst_11189)){
var statearr_11209_11235 = state_11200__$1;
(statearr_11209_11235[(1)] = (12));

} else {
var statearr_11210_11236 = state_11200__$1;
(statearr_11210_11236[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (9))){
var state_11200__$1 = state_11200;
var statearr_11211_11237 = state_11200__$1;
(statearr_11211_11237[(2)] = null);

(statearr_11211_11237[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (5))){
var state_11200__$1 = state_11200;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11212_11238 = state_11200__$1;
(statearr_11212_11238[(1)] = (8));

} else {
var statearr_11213_11239 = state_11200__$1;
(statearr_11213_11239[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (14))){
var inst_11194 = (state_11200[(2)]);
var state_11200__$1 = state_11200;
var statearr_11214_11240 = state_11200__$1;
(statearr_11214_11240[(2)] = inst_11194);

(statearr_11214_11240[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (10))){
var inst_11186 = (state_11200[(2)]);
var state_11200__$1 = state_11200;
var statearr_11215_11241 = state_11200__$1;
(statearr_11215_11241[(2)] = inst_11186);

(statearr_11215_11241[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11201 === (8))){
var inst_11183 = cljs.core.async.close_BANG_.call(null,to);
var state_11200__$1 = state_11200;
var statearr_11216_11242 = state_11200__$1;
(statearr_11216_11242[(2)] = inst_11183);

(statearr_11216_11242[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___11228))
;
return ((function (switch__10949__auto__,c__11061__auto___11228){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_11220 = [null,null,null,null,null,null,null,null];
(statearr_11220[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_11220[(1)] = (1));

return statearr_11220;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_11200){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11200);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11221){if((e11221 instanceof Object)){
var ex__10953__auto__ = e11221;
var statearr_11222_11243 = state_11200;
(statearr_11222_11243[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11200);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11221;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11244 = state_11200;
state_11200 = G__11244;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_11200){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_11200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___11228))
})();
var state__11063__auto__ = (function (){var statearr_11223 = f__11062__auto__.call(null);
(statearr_11223[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___11228);

return statearr_11223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___11228))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11428){
var vec__11429 = p__11428;
var v = cljs.core.nth.call(null,vec__11429,(0),null);
var p = cljs.core.nth.call(null,vec__11429,(1),null);
var job = vec__11429;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11061__auto___11611 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___11611,res,vec__11429,v,p,job,jobs,results){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___11611,res,vec__11429,v,p,job,jobs,results){
return (function (state_11434){
var state_val_11435 = (state_11434[(1)]);
if((state_val_11435 === (1))){
var state_11434__$1 = state_11434;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11434__$1,(2),res,v);
} else {
if((state_val_11435 === (2))){
var inst_11431 = (state_11434[(2)]);
var inst_11432 = cljs.core.async.close_BANG_.call(null,res);
var state_11434__$1 = (function (){var statearr_11436 = state_11434;
(statearr_11436[(7)] = inst_11431);

return statearr_11436;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11434__$1,inst_11432);
} else {
return null;
}
}
});})(c__11061__auto___11611,res,vec__11429,v,p,job,jobs,results))
;
return ((function (switch__10949__auto__,c__11061__auto___11611,res,vec__11429,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_11440 = [null,null,null,null,null,null,null,null];
(statearr_11440[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_11440[(1)] = (1));

return statearr_11440;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_11434){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11434);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11441){if((e11441 instanceof Object)){
var ex__10953__auto__ = e11441;
var statearr_11442_11612 = state_11434;
(statearr_11442_11612[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11434);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11441;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11613 = state_11434;
state_11434 = G__11613;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_11434){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_11434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___11611,res,vec__11429,v,p,job,jobs,results))
})();
var state__11063__auto__ = (function (){var statearr_11443 = f__11062__auto__.call(null);
(statearr_11443[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___11611);

return statearr_11443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___11611,res,vec__11429,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11444){
var vec__11445 = p__11444;
var v = cljs.core.nth.call(null,vec__11445,(0),null);
var p = cljs.core.nth.call(null,vec__11445,(1),null);
var job = vec__11445;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___11614 = n;
var __11615 = (0);
while(true){
if((__11615 < n__5571__auto___11614)){
var G__11446_11616 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11446_11616) {
case "compute":
var c__11061__auto___11618 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11615,c__11061__auto___11618,G__11446_11616,n__5571__auto___11614,jobs,results,process,async){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (__11615,c__11061__auto___11618,G__11446_11616,n__5571__auto___11614,jobs,results,process,async){
return (function (state_11459){
var state_val_11460 = (state_11459[(1)]);
if((state_val_11460 === (1))){
var state_11459__$1 = state_11459;
var statearr_11461_11619 = state_11459__$1;
(statearr_11461_11619[(2)] = null);

(statearr_11461_11619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11460 === (2))){
var state_11459__$1 = state_11459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11459__$1,(4),jobs);
} else {
if((state_val_11460 === (3))){
var inst_11457 = (state_11459[(2)]);
var state_11459__$1 = state_11459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11459__$1,inst_11457);
} else {
if((state_val_11460 === (4))){
var inst_11449 = (state_11459[(2)]);
var inst_11450 = process.call(null,inst_11449);
var state_11459__$1 = state_11459;
if(cljs.core.truth_(inst_11450)){
var statearr_11462_11620 = state_11459__$1;
(statearr_11462_11620[(1)] = (5));

} else {
var statearr_11463_11621 = state_11459__$1;
(statearr_11463_11621[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11460 === (5))){
var state_11459__$1 = state_11459;
var statearr_11464_11622 = state_11459__$1;
(statearr_11464_11622[(2)] = null);

(statearr_11464_11622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11460 === (6))){
var state_11459__$1 = state_11459;
var statearr_11465_11623 = state_11459__$1;
(statearr_11465_11623[(2)] = null);

(statearr_11465_11623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11460 === (7))){
var inst_11455 = (state_11459[(2)]);
var state_11459__$1 = state_11459;
var statearr_11466_11624 = state_11459__$1;
(statearr_11466_11624[(2)] = inst_11455);

(statearr_11466_11624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11615,c__11061__auto___11618,G__11446_11616,n__5571__auto___11614,jobs,results,process,async))
;
return ((function (__11615,switch__10949__auto__,c__11061__auto___11618,G__11446_11616,n__5571__auto___11614,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_11470 = [null,null,null,null,null,null,null];
(statearr_11470[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_11470[(1)] = (1));

return statearr_11470;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_11459){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11471){if((e11471 instanceof Object)){
var ex__10953__auto__ = e11471;
var statearr_11472_11625 = state_11459;
(statearr_11472_11625[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11459);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11471;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11626 = state_11459;
state_11459 = G__11626;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_11459){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_11459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(__11615,switch__10949__auto__,c__11061__auto___11618,G__11446_11616,n__5571__auto___11614,jobs,results,process,async))
})();
var state__11063__auto__ = (function (){var statearr_11473 = f__11062__auto__.call(null);
(statearr_11473[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___11618);

return statearr_11473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(__11615,c__11061__auto___11618,G__11446_11616,n__5571__auto___11614,jobs,results,process,async))
);


break;
case "async":
var c__11061__auto___11627 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11615,c__11061__auto___11627,G__11446_11616,n__5571__auto___11614,jobs,results,process,async){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (__11615,c__11061__auto___11627,G__11446_11616,n__5571__auto___11614,jobs,results,process,async){
return (function (state_11486){
var state_val_11487 = (state_11486[(1)]);
if((state_val_11487 === (1))){
var state_11486__$1 = state_11486;
var statearr_11488_11628 = state_11486__$1;
(statearr_11488_11628[(2)] = null);

(statearr_11488_11628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11487 === (2))){
var state_11486__$1 = state_11486;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11486__$1,(4),jobs);
} else {
if((state_val_11487 === (3))){
var inst_11484 = (state_11486[(2)]);
var state_11486__$1 = state_11486;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11486__$1,inst_11484);
} else {
if((state_val_11487 === (4))){
var inst_11476 = (state_11486[(2)]);
var inst_11477 = async.call(null,inst_11476);
var state_11486__$1 = state_11486;
if(cljs.core.truth_(inst_11477)){
var statearr_11489_11629 = state_11486__$1;
(statearr_11489_11629[(1)] = (5));

} else {
var statearr_11490_11630 = state_11486__$1;
(statearr_11490_11630[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11487 === (5))){
var state_11486__$1 = state_11486;
var statearr_11491_11631 = state_11486__$1;
(statearr_11491_11631[(2)] = null);

(statearr_11491_11631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11487 === (6))){
var state_11486__$1 = state_11486;
var statearr_11492_11632 = state_11486__$1;
(statearr_11492_11632[(2)] = null);

(statearr_11492_11632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11487 === (7))){
var inst_11482 = (state_11486[(2)]);
var state_11486__$1 = state_11486;
var statearr_11493_11633 = state_11486__$1;
(statearr_11493_11633[(2)] = inst_11482);

(statearr_11493_11633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11615,c__11061__auto___11627,G__11446_11616,n__5571__auto___11614,jobs,results,process,async))
;
return ((function (__11615,switch__10949__auto__,c__11061__auto___11627,G__11446_11616,n__5571__auto___11614,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_11497 = [null,null,null,null,null,null,null];
(statearr_11497[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_11497[(1)] = (1));

return statearr_11497;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_11486){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11486);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11498){if((e11498 instanceof Object)){
var ex__10953__auto__ = e11498;
var statearr_11499_11634 = state_11486;
(statearr_11499_11634[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11486);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11498;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11635 = state_11486;
state_11486 = G__11635;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_11486){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_11486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(__11615,switch__10949__auto__,c__11061__auto___11627,G__11446_11616,n__5571__auto___11614,jobs,results,process,async))
})();
var state__11063__auto__ = (function (){var statearr_11500 = f__11062__auto__.call(null);
(statearr_11500[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___11627);

return statearr_11500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(__11615,c__11061__auto___11627,G__11446_11616,n__5571__auto___11614,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11636 = (__11615 + (1));
__11615 = G__11636;
continue;
} else {
}
break;
}

var c__11061__auto___11637 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___11637,jobs,results,process,async){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___11637,jobs,results,process,async){
return (function (state_11522){
var state_val_11523 = (state_11522[(1)]);
if((state_val_11523 === (1))){
var state_11522__$1 = state_11522;
var statearr_11524_11638 = state_11522__$1;
(statearr_11524_11638[(2)] = null);

(statearr_11524_11638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11523 === (2))){
var state_11522__$1 = state_11522;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11522__$1,(4),from);
} else {
if((state_val_11523 === (3))){
var inst_11520 = (state_11522[(2)]);
var state_11522__$1 = state_11522;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11522__$1,inst_11520);
} else {
if((state_val_11523 === (4))){
var inst_11503 = (state_11522[(7)]);
var inst_11503__$1 = (state_11522[(2)]);
var inst_11504 = (inst_11503__$1 == null);
var state_11522__$1 = (function (){var statearr_11525 = state_11522;
(statearr_11525[(7)] = inst_11503__$1);

return statearr_11525;
})();
if(cljs.core.truth_(inst_11504)){
var statearr_11526_11639 = state_11522__$1;
(statearr_11526_11639[(1)] = (5));

} else {
var statearr_11527_11640 = state_11522__$1;
(statearr_11527_11640[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11523 === (5))){
var inst_11506 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11522__$1 = state_11522;
var statearr_11528_11641 = state_11522__$1;
(statearr_11528_11641[(2)] = inst_11506);

(statearr_11528_11641[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11523 === (6))){
var inst_11508 = (state_11522[(8)]);
var inst_11503 = (state_11522[(7)]);
var inst_11508__$1 = cljs.core.async.chan.call(null,(1));
var inst_11509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11510 = [inst_11503,inst_11508__$1];
var inst_11511 = (new cljs.core.PersistentVector(null,2,(5),inst_11509,inst_11510,null));
var state_11522__$1 = (function (){var statearr_11529 = state_11522;
(statearr_11529[(8)] = inst_11508__$1);

return statearr_11529;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11522__$1,(8),jobs,inst_11511);
} else {
if((state_val_11523 === (7))){
var inst_11518 = (state_11522[(2)]);
var state_11522__$1 = state_11522;
var statearr_11530_11642 = state_11522__$1;
(statearr_11530_11642[(2)] = inst_11518);

(statearr_11530_11642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11523 === (8))){
var inst_11508 = (state_11522[(8)]);
var inst_11513 = (state_11522[(2)]);
var state_11522__$1 = (function (){var statearr_11531 = state_11522;
(statearr_11531[(9)] = inst_11513);

return statearr_11531;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11522__$1,(9),results,inst_11508);
} else {
if((state_val_11523 === (9))){
var inst_11515 = (state_11522[(2)]);
var state_11522__$1 = (function (){var statearr_11532 = state_11522;
(statearr_11532[(10)] = inst_11515);

return statearr_11532;
})();
var statearr_11533_11643 = state_11522__$1;
(statearr_11533_11643[(2)] = null);

(statearr_11533_11643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___11637,jobs,results,process,async))
;
return ((function (switch__10949__auto__,c__11061__auto___11637,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_11537 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11537[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_11537[(1)] = (1));

return statearr_11537;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_11522){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11522);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11538){if((e11538 instanceof Object)){
var ex__10953__auto__ = e11538;
var statearr_11539_11644 = state_11522;
(statearr_11539_11644[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11522);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11538;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11645 = state_11522;
state_11522 = G__11645;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_11522){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_11522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___11637,jobs,results,process,async))
})();
var state__11063__auto__ = (function (){var statearr_11540 = f__11062__auto__.call(null);
(statearr_11540[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___11637);

return statearr_11540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___11637,jobs,results,process,async))
);


var c__11061__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto__,jobs,results,process,async){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto__,jobs,results,process,async){
return (function (state_11578){
var state_val_11579 = (state_11578[(1)]);
if((state_val_11579 === (7))){
var inst_11574 = (state_11578[(2)]);
var state_11578__$1 = state_11578;
var statearr_11580_11646 = state_11578__$1;
(statearr_11580_11646[(2)] = inst_11574);

(statearr_11580_11646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (20))){
var state_11578__$1 = state_11578;
var statearr_11581_11647 = state_11578__$1;
(statearr_11581_11647[(2)] = null);

(statearr_11581_11647[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (1))){
var state_11578__$1 = state_11578;
var statearr_11582_11648 = state_11578__$1;
(statearr_11582_11648[(2)] = null);

(statearr_11582_11648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (4))){
var inst_11543 = (state_11578[(7)]);
var inst_11543__$1 = (state_11578[(2)]);
var inst_11544 = (inst_11543__$1 == null);
var state_11578__$1 = (function (){var statearr_11583 = state_11578;
(statearr_11583[(7)] = inst_11543__$1);

return statearr_11583;
})();
if(cljs.core.truth_(inst_11544)){
var statearr_11584_11649 = state_11578__$1;
(statearr_11584_11649[(1)] = (5));

} else {
var statearr_11585_11650 = state_11578__$1;
(statearr_11585_11650[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (15))){
var inst_11556 = (state_11578[(8)]);
var state_11578__$1 = state_11578;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11578__$1,(18),to,inst_11556);
} else {
if((state_val_11579 === (21))){
var inst_11569 = (state_11578[(2)]);
var state_11578__$1 = state_11578;
var statearr_11586_11651 = state_11578__$1;
(statearr_11586_11651[(2)] = inst_11569);

(statearr_11586_11651[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (13))){
var inst_11571 = (state_11578[(2)]);
var state_11578__$1 = (function (){var statearr_11587 = state_11578;
(statearr_11587[(9)] = inst_11571);

return statearr_11587;
})();
var statearr_11588_11652 = state_11578__$1;
(statearr_11588_11652[(2)] = null);

(statearr_11588_11652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (6))){
var inst_11543 = (state_11578[(7)]);
var state_11578__$1 = state_11578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11578__$1,(11),inst_11543);
} else {
if((state_val_11579 === (17))){
var inst_11564 = (state_11578[(2)]);
var state_11578__$1 = state_11578;
if(cljs.core.truth_(inst_11564)){
var statearr_11589_11653 = state_11578__$1;
(statearr_11589_11653[(1)] = (19));

} else {
var statearr_11590_11654 = state_11578__$1;
(statearr_11590_11654[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (3))){
var inst_11576 = (state_11578[(2)]);
var state_11578__$1 = state_11578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11578__$1,inst_11576);
} else {
if((state_val_11579 === (12))){
var inst_11553 = (state_11578[(10)]);
var state_11578__$1 = state_11578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11578__$1,(14),inst_11553);
} else {
if((state_val_11579 === (2))){
var state_11578__$1 = state_11578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11578__$1,(4),results);
} else {
if((state_val_11579 === (19))){
var state_11578__$1 = state_11578;
var statearr_11591_11655 = state_11578__$1;
(statearr_11591_11655[(2)] = null);

(statearr_11591_11655[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (11))){
var inst_11553 = (state_11578[(2)]);
var state_11578__$1 = (function (){var statearr_11592 = state_11578;
(statearr_11592[(10)] = inst_11553);

return statearr_11592;
})();
var statearr_11593_11656 = state_11578__$1;
(statearr_11593_11656[(2)] = null);

(statearr_11593_11656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (9))){
var state_11578__$1 = state_11578;
var statearr_11594_11657 = state_11578__$1;
(statearr_11594_11657[(2)] = null);

(statearr_11594_11657[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (5))){
var state_11578__$1 = state_11578;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11595_11658 = state_11578__$1;
(statearr_11595_11658[(1)] = (8));

} else {
var statearr_11596_11659 = state_11578__$1;
(statearr_11596_11659[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (14))){
var inst_11556 = (state_11578[(8)]);
var inst_11558 = (state_11578[(11)]);
var inst_11556__$1 = (state_11578[(2)]);
var inst_11557 = (inst_11556__$1 == null);
var inst_11558__$1 = cljs.core.not.call(null,inst_11557);
var state_11578__$1 = (function (){var statearr_11597 = state_11578;
(statearr_11597[(8)] = inst_11556__$1);

(statearr_11597[(11)] = inst_11558__$1);

return statearr_11597;
})();
if(inst_11558__$1){
var statearr_11598_11660 = state_11578__$1;
(statearr_11598_11660[(1)] = (15));

} else {
var statearr_11599_11661 = state_11578__$1;
(statearr_11599_11661[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (16))){
var inst_11558 = (state_11578[(11)]);
var state_11578__$1 = state_11578;
var statearr_11600_11662 = state_11578__$1;
(statearr_11600_11662[(2)] = inst_11558);

(statearr_11600_11662[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (10))){
var inst_11550 = (state_11578[(2)]);
var state_11578__$1 = state_11578;
var statearr_11601_11663 = state_11578__$1;
(statearr_11601_11663[(2)] = inst_11550);

(statearr_11601_11663[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (18))){
var inst_11561 = (state_11578[(2)]);
var state_11578__$1 = state_11578;
var statearr_11602_11664 = state_11578__$1;
(statearr_11602_11664[(2)] = inst_11561);

(statearr_11602_11664[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11579 === (8))){
var inst_11547 = cljs.core.async.close_BANG_.call(null,to);
var state_11578__$1 = state_11578;
var statearr_11603_11665 = state_11578__$1;
(statearr_11603_11665[(2)] = inst_11547);

(statearr_11603_11665[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto__,jobs,results,process,async))
;
return ((function (switch__10949__auto__,c__11061__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_11607 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11607[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_11607[(1)] = (1));

return statearr_11607;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_11578){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11608){if((e11608 instanceof Object)){
var ex__10953__auto__ = e11608;
var statearr_11609_11666 = state_11578;
(statearr_11609_11666[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11578);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11608;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11667 = state_11578;
state_11578 = G__11667;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_11578){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_11578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto__,jobs,results,process,async))
})();
var state__11063__auto__ = (function (){var statearr_11610 = f__11062__auto__.call(null);
(statearr_11610[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto__);

return statearr_11610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto__,jobs,results,process,async))
);

return c__11061__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11668 = [];
var len__5726__auto___11671 = arguments.length;
var i__5727__auto___11672 = (0);
while(true){
if((i__5727__auto___11672 < len__5726__auto___11671)){
args11668.push((arguments[i__5727__auto___11672]));

var G__11673 = (i__5727__auto___11672 + (1));
i__5727__auto___11672 = G__11673;
continue;
} else {
}
break;
}

var G__11670 = args11668.length;
switch (G__11670) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11668.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11675 = [];
var len__5726__auto___11678 = arguments.length;
var i__5727__auto___11679 = (0);
while(true){
if((i__5727__auto___11679 < len__5726__auto___11678)){
args11675.push((arguments[i__5727__auto___11679]));

var G__11680 = (i__5727__auto___11679 + (1));
i__5727__auto___11679 = G__11680;
continue;
} else {
}
break;
}

var G__11677 = args11675.length;
switch (G__11677) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11675.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11682 = [];
var len__5726__auto___11735 = arguments.length;
var i__5727__auto___11736 = (0);
while(true){
if((i__5727__auto___11736 < len__5726__auto___11735)){
args11682.push((arguments[i__5727__auto___11736]));

var G__11737 = (i__5727__auto___11736 + (1));
i__5727__auto___11736 = G__11737;
continue;
} else {
}
break;
}

var G__11684 = args11682.length;
switch (G__11684) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11682.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11061__auto___11739 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___11739,tc,fc){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___11739,tc,fc){
return (function (state_11710){
var state_val_11711 = (state_11710[(1)]);
if((state_val_11711 === (7))){
var inst_11706 = (state_11710[(2)]);
var state_11710__$1 = state_11710;
var statearr_11712_11740 = state_11710__$1;
(statearr_11712_11740[(2)] = inst_11706);

(statearr_11712_11740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (1))){
var state_11710__$1 = state_11710;
var statearr_11713_11741 = state_11710__$1;
(statearr_11713_11741[(2)] = null);

(statearr_11713_11741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (4))){
var inst_11687 = (state_11710[(7)]);
var inst_11687__$1 = (state_11710[(2)]);
var inst_11688 = (inst_11687__$1 == null);
var state_11710__$1 = (function (){var statearr_11714 = state_11710;
(statearr_11714[(7)] = inst_11687__$1);

return statearr_11714;
})();
if(cljs.core.truth_(inst_11688)){
var statearr_11715_11742 = state_11710__$1;
(statearr_11715_11742[(1)] = (5));

} else {
var statearr_11716_11743 = state_11710__$1;
(statearr_11716_11743[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (13))){
var state_11710__$1 = state_11710;
var statearr_11717_11744 = state_11710__$1;
(statearr_11717_11744[(2)] = null);

(statearr_11717_11744[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (6))){
var inst_11687 = (state_11710[(7)]);
var inst_11693 = p.call(null,inst_11687);
var state_11710__$1 = state_11710;
if(cljs.core.truth_(inst_11693)){
var statearr_11718_11745 = state_11710__$1;
(statearr_11718_11745[(1)] = (9));

} else {
var statearr_11719_11746 = state_11710__$1;
(statearr_11719_11746[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (3))){
var inst_11708 = (state_11710[(2)]);
var state_11710__$1 = state_11710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11710__$1,inst_11708);
} else {
if((state_val_11711 === (12))){
var state_11710__$1 = state_11710;
var statearr_11720_11747 = state_11710__$1;
(statearr_11720_11747[(2)] = null);

(statearr_11720_11747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (2))){
var state_11710__$1 = state_11710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11710__$1,(4),ch);
} else {
if((state_val_11711 === (11))){
var inst_11687 = (state_11710[(7)]);
var inst_11697 = (state_11710[(2)]);
var state_11710__$1 = state_11710;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11710__$1,(8),inst_11697,inst_11687);
} else {
if((state_val_11711 === (9))){
var state_11710__$1 = state_11710;
var statearr_11721_11748 = state_11710__$1;
(statearr_11721_11748[(2)] = tc);

(statearr_11721_11748[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (5))){
var inst_11690 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11691 = cljs.core.async.close_BANG_.call(null,fc);
var state_11710__$1 = (function (){var statearr_11722 = state_11710;
(statearr_11722[(8)] = inst_11690);

return statearr_11722;
})();
var statearr_11723_11749 = state_11710__$1;
(statearr_11723_11749[(2)] = inst_11691);

(statearr_11723_11749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (14))){
var inst_11704 = (state_11710[(2)]);
var state_11710__$1 = state_11710;
var statearr_11724_11750 = state_11710__$1;
(statearr_11724_11750[(2)] = inst_11704);

(statearr_11724_11750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (10))){
var state_11710__$1 = state_11710;
var statearr_11725_11751 = state_11710__$1;
(statearr_11725_11751[(2)] = fc);

(statearr_11725_11751[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11711 === (8))){
var inst_11699 = (state_11710[(2)]);
var state_11710__$1 = state_11710;
if(cljs.core.truth_(inst_11699)){
var statearr_11726_11752 = state_11710__$1;
(statearr_11726_11752[(1)] = (12));

} else {
var statearr_11727_11753 = state_11710__$1;
(statearr_11727_11753[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___11739,tc,fc))
;
return ((function (switch__10949__auto__,c__11061__auto___11739,tc,fc){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_11731 = [null,null,null,null,null,null,null,null,null];
(statearr_11731[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_11731[(1)] = (1));

return statearr_11731;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_11710){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11732){if((e11732 instanceof Object)){
var ex__10953__auto__ = e11732;
var statearr_11733_11754 = state_11710;
(statearr_11733_11754[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11710);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11732;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11755 = state_11710;
state_11710 = G__11755;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_11710){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_11710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___11739,tc,fc))
})();
var state__11063__auto__ = (function (){var statearr_11734 = f__11062__auto__.call(null);
(statearr_11734[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___11739);

return statearr_11734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___11739,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11061__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto__){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto__){
return (function (state_11819){
var state_val_11820 = (state_11819[(1)]);
if((state_val_11820 === (7))){
var inst_11815 = (state_11819[(2)]);
var state_11819__$1 = state_11819;
var statearr_11821_11842 = state_11819__$1;
(statearr_11821_11842[(2)] = inst_11815);

(statearr_11821_11842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11820 === (1))){
var inst_11799 = init;
var state_11819__$1 = (function (){var statearr_11822 = state_11819;
(statearr_11822[(7)] = inst_11799);

return statearr_11822;
})();
var statearr_11823_11843 = state_11819__$1;
(statearr_11823_11843[(2)] = null);

(statearr_11823_11843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11820 === (4))){
var inst_11802 = (state_11819[(8)]);
var inst_11802__$1 = (state_11819[(2)]);
var inst_11803 = (inst_11802__$1 == null);
var state_11819__$1 = (function (){var statearr_11824 = state_11819;
(statearr_11824[(8)] = inst_11802__$1);

return statearr_11824;
})();
if(cljs.core.truth_(inst_11803)){
var statearr_11825_11844 = state_11819__$1;
(statearr_11825_11844[(1)] = (5));

} else {
var statearr_11826_11845 = state_11819__$1;
(statearr_11826_11845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11820 === (6))){
var inst_11806 = (state_11819[(9)]);
var inst_11802 = (state_11819[(8)]);
var inst_11799 = (state_11819[(7)]);
var inst_11806__$1 = f.call(null,inst_11799,inst_11802);
var inst_11807 = cljs.core.reduced_QMARK_.call(null,inst_11806__$1);
var state_11819__$1 = (function (){var statearr_11827 = state_11819;
(statearr_11827[(9)] = inst_11806__$1);

return statearr_11827;
})();
if(inst_11807){
var statearr_11828_11846 = state_11819__$1;
(statearr_11828_11846[(1)] = (8));

} else {
var statearr_11829_11847 = state_11819__$1;
(statearr_11829_11847[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11820 === (3))){
var inst_11817 = (state_11819[(2)]);
var state_11819__$1 = state_11819;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11819__$1,inst_11817);
} else {
if((state_val_11820 === (2))){
var state_11819__$1 = state_11819;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11819__$1,(4),ch);
} else {
if((state_val_11820 === (9))){
var inst_11806 = (state_11819[(9)]);
var inst_11799 = inst_11806;
var state_11819__$1 = (function (){var statearr_11830 = state_11819;
(statearr_11830[(7)] = inst_11799);

return statearr_11830;
})();
var statearr_11831_11848 = state_11819__$1;
(statearr_11831_11848[(2)] = null);

(statearr_11831_11848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11820 === (5))){
var inst_11799 = (state_11819[(7)]);
var state_11819__$1 = state_11819;
var statearr_11832_11849 = state_11819__$1;
(statearr_11832_11849[(2)] = inst_11799);

(statearr_11832_11849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11820 === (10))){
var inst_11813 = (state_11819[(2)]);
var state_11819__$1 = state_11819;
var statearr_11833_11850 = state_11819__$1;
(statearr_11833_11850[(2)] = inst_11813);

(statearr_11833_11850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11820 === (8))){
var inst_11806 = (state_11819[(9)]);
var inst_11809 = cljs.core.deref.call(null,inst_11806);
var state_11819__$1 = state_11819;
var statearr_11834_11851 = state_11819__$1;
(statearr_11834_11851[(2)] = inst_11809);

(statearr_11834_11851[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto__))
;
return ((function (switch__10949__auto__,c__11061__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10950__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10950__auto____0 = (function (){
var statearr_11838 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11838[(0)] = cljs$core$async$reduce_$_state_machine__10950__auto__);

(statearr_11838[(1)] = (1));

return statearr_11838;
});
var cljs$core$async$reduce_$_state_machine__10950__auto____1 = (function (state_11819){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11819);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11839){if((e11839 instanceof Object)){
var ex__10953__auto__ = e11839;
var statearr_11840_11852 = state_11819;
(statearr_11840_11852[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11819);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11839;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11853 = state_11819;
state_11819 = G__11853;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10950__auto__ = function(state_11819){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10950__auto____1.call(this,state_11819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10950__auto____0;
cljs$core$async$reduce_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10950__auto____1;
return cljs$core$async$reduce_$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto__))
})();
var state__11063__auto__ = (function (){var statearr_11841 = f__11062__auto__.call(null);
(statearr_11841[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto__);

return statearr_11841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto__))
);

return c__11061__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11854 = [];
var len__5726__auto___11906 = arguments.length;
var i__5727__auto___11907 = (0);
while(true){
if((i__5727__auto___11907 < len__5726__auto___11906)){
args11854.push((arguments[i__5727__auto___11907]));

var G__11908 = (i__5727__auto___11907 + (1));
i__5727__auto___11907 = G__11908;
continue;
} else {
}
break;
}

var G__11856 = args11854.length;
switch (G__11856) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11854.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11061__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto__){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto__){
return (function (state_11881){
var state_val_11882 = (state_11881[(1)]);
if((state_val_11882 === (7))){
var inst_11863 = (state_11881[(2)]);
var state_11881__$1 = state_11881;
var statearr_11883_11910 = state_11881__$1;
(statearr_11883_11910[(2)] = inst_11863);

(statearr_11883_11910[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (1))){
var inst_11857 = cljs.core.seq.call(null,coll);
var inst_11858 = inst_11857;
var state_11881__$1 = (function (){var statearr_11884 = state_11881;
(statearr_11884[(7)] = inst_11858);

return statearr_11884;
})();
var statearr_11885_11911 = state_11881__$1;
(statearr_11885_11911[(2)] = null);

(statearr_11885_11911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (4))){
var inst_11858 = (state_11881[(7)]);
var inst_11861 = cljs.core.first.call(null,inst_11858);
var state_11881__$1 = state_11881;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11881__$1,(7),ch,inst_11861);
} else {
if((state_val_11882 === (13))){
var inst_11875 = (state_11881[(2)]);
var state_11881__$1 = state_11881;
var statearr_11886_11912 = state_11881__$1;
(statearr_11886_11912[(2)] = inst_11875);

(statearr_11886_11912[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (6))){
var inst_11866 = (state_11881[(2)]);
var state_11881__$1 = state_11881;
if(cljs.core.truth_(inst_11866)){
var statearr_11887_11913 = state_11881__$1;
(statearr_11887_11913[(1)] = (8));

} else {
var statearr_11888_11914 = state_11881__$1;
(statearr_11888_11914[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (3))){
var inst_11879 = (state_11881[(2)]);
var state_11881__$1 = state_11881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11881__$1,inst_11879);
} else {
if((state_val_11882 === (12))){
var state_11881__$1 = state_11881;
var statearr_11889_11915 = state_11881__$1;
(statearr_11889_11915[(2)] = null);

(statearr_11889_11915[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (2))){
var inst_11858 = (state_11881[(7)]);
var state_11881__$1 = state_11881;
if(cljs.core.truth_(inst_11858)){
var statearr_11890_11916 = state_11881__$1;
(statearr_11890_11916[(1)] = (4));

} else {
var statearr_11891_11917 = state_11881__$1;
(statearr_11891_11917[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (11))){
var inst_11872 = cljs.core.async.close_BANG_.call(null,ch);
var state_11881__$1 = state_11881;
var statearr_11892_11918 = state_11881__$1;
(statearr_11892_11918[(2)] = inst_11872);

(statearr_11892_11918[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (9))){
var state_11881__$1 = state_11881;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11893_11919 = state_11881__$1;
(statearr_11893_11919[(1)] = (11));

} else {
var statearr_11894_11920 = state_11881__$1;
(statearr_11894_11920[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (5))){
var inst_11858 = (state_11881[(7)]);
var state_11881__$1 = state_11881;
var statearr_11895_11921 = state_11881__$1;
(statearr_11895_11921[(2)] = inst_11858);

(statearr_11895_11921[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (10))){
var inst_11877 = (state_11881[(2)]);
var state_11881__$1 = state_11881;
var statearr_11896_11922 = state_11881__$1;
(statearr_11896_11922[(2)] = inst_11877);

(statearr_11896_11922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11882 === (8))){
var inst_11858 = (state_11881[(7)]);
var inst_11868 = cljs.core.next.call(null,inst_11858);
var inst_11858__$1 = inst_11868;
var state_11881__$1 = (function (){var statearr_11897 = state_11881;
(statearr_11897[(7)] = inst_11858__$1);

return statearr_11897;
})();
var statearr_11898_11923 = state_11881__$1;
(statearr_11898_11923[(2)] = null);

(statearr_11898_11923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto__))
;
return ((function (switch__10949__auto__,c__11061__auto__){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_11902 = [null,null,null,null,null,null,null,null];
(statearr_11902[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_11902[(1)] = (1));

return statearr_11902;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_11881){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_11881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e11903){if((e11903 instanceof Object)){
var ex__10953__auto__ = e11903;
var statearr_11904_11924 = state_11881;
(statearr_11904_11924[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11881);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11903;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11925 = state_11881;
state_11881 = G__11925;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_11881){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_11881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto__))
})();
var state__11063__auto__ = (function (){var statearr_11905 = f__11062__auto__.call(null);
(statearr_11905[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto__);

return statearr_11905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto__))
);

return c__11061__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12147 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12147 = (function (mult,ch,cs,meta12148){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12148 = meta12148;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12147.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12149,meta12148__$1){
var self__ = this;
var _12149__$1 = this;
return (new cljs.core.async.t_cljs$core$async12147(self__.mult,self__.ch,self__.cs,meta12148__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12147.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12149){
var self__ = this;
var _12149__$1 = this;
return self__.meta12148;
});})(cs))
;

cljs.core.async.t_cljs$core$async12147.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12147.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12147.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12147.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12147.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12147.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12147.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12148","meta12148",452731512,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12147.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12147.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12147";

cljs.core.async.t_cljs$core$async12147.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12147");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12147 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12147(mult__$1,ch__$1,cs__$1,meta12148){
return (new cljs.core.async.t_cljs$core$async12147(mult__$1,ch__$1,cs__$1,meta12148));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12147(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11061__auto___12368 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___12368,cs,m,dchan,dctr,done){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___12368,cs,m,dchan,dctr,done){
return (function (state_12280){
var state_val_12281 = (state_12280[(1)]);
if((state_val_12281 === (7))){
var inst_12276 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12282_12369 = state_12280__$1;
(statearr_12282_12369[(2)] = inst_12276);

(statearr_12282_12369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (20))){
var inst_12181 = (state_12280[(7)]);
var inst_12191 = cljs.core.first.call(null,inst_12181);
var inst_12192 = cljs.core.nth.call(null,inst_12191,(0),null);
var inst_12193 = cljs.core.nth.call(null,inst_12191,(1),null);
var state_12280__$1 = (function (){var statearr_12283 = state_12280;
(statearr_12283[(8)] = inst_12192);

return statearr_12283;
})();
if(cljs.core.truth_(inst_12193)){
var statearr_12284_12370 = state_12280__$1;
(statearr_12284_12370[(1)] = (22));

} else {
var statearr_12285_12371 = state_12280__$1;
(statearr_12285_12371[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (27))){
var inst_12223 = (state_12280[(9)]);
var inst_12152 = (state_12280[(10)]);
var inst_12221 = (state_12280[(11)]);
var inst_12228 = (state_12280[(12)]);
var inst_12228__$1 = cljs.core._nth.call(null,inst_12221,inst_12223);
var inst_12229 = cljs.core.async.put_BANG_.call(null,inst_12228__$1,inst_12152,done);
var state_12280__$1 = (function (){var statearr_12286 = state_12280;
(statearr_12286[(12)] = inst_12228__$1);

return statearr_12286;
})();
if(cljs.core.truth_(inst_12229)){
var statearr_12287_12372 = state_12280__$1;
(statearr_12287_12372[(1)] = (30));

} else {
var statearr_12288_12373 = state_12280__$1;
(statearr_12288_12373[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (1))){
var state_12280__$1 = state_12280;
var statearr_12289_12374 = state_12280__$1;
(statearr_12289_12374[(2)] = null);

(statearr_12289_12374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (24))){
var inst_12181 = (state_12280[(7)]);
var inst_12198 = (state_12280[(2)]);
var inst_12199 = cljs.core.next.call(null,inst_12181);
var inst_12161 = inst_12199;
var inst_12162 = null;
var inst_12163 = (0);
var inst_12164 = (0);
var state_12280__$1 = (function (){var statearr_12290 = state_12280;
(statearr_12290[(13)] = inst_12164);

(statearr_12290[(14)] = inst_12198);

(statearr_12290[(15)] = inst_12163);

(statearr_12290[(16)] = inst_12161);

(statearr_12290[(17)] = inst_12162);

return statearr_12290;
})();
var statearr_12291_12375 = state_12280__$1;
(statearr_12291_12375[(2)] = null);

(statearr_12291_12375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (39))){
var state_12280__$1 = state_12280;
var statearr_12295_12376 = state_12280__$1;
(statearr_12295_12376[(2)] = null);

(statearr_12295_12376[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (4))){
var inst_12152 = (state_12280[(10)]);
var inst_12152__$1 = (state_12280[(2)]);
var inst_12153 = (inst_12152__$1 == null);
var state_12280__$1 = (function (){var statearr_12296 = state_12280;
(statearr_12296[(10)] = inst_12152__$1);

return statearr_12296;
})();
if(cljs.core.truth_(inst_12153)){
var statearr_12297_12377 = state_12280__$1;
(statearr_12297_12377[(1)] = (5));

} else {
var statearr_12298_12378 = state_12280__$1;
(statearr_12298_12378[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (15))){
var inst_12164 = (state_12280[(13)]);
var inst_12163 = (state_12280[(15)]);
var inst_12161 = (state_12280[(16)]);
var inst_12162 = (state_12280[(17)]);
var inst_12177 = (state_12280[(2)]);
var inst_12178 = (inst_12164 + (1));
var tmp12292 = inst_12163;
var tmp12293 = inst_12161;
var tmp12294 = inst_12162;
var inst_12161__$1 = tmp12293;
var inst_12162__$1 = tmp12294;
var inst_12163__$1 = tmp12292;
var inst_12164__$1 = inst_12178;
var state_12280__$1 = (function (){var statearr_12299 = state_12280;
(statearr_12299[(18)] = inst_12177);

(statearr_12299[(13)] = inst_12164__$1);

(statearr_12299[(15)] = inst_12163__$1);

(statearr_12299[(16)] = inst_12161__$1);

(statearr_12299[(17)] = inst_12162__$1);

return statearr_12299;
})();
var statearr_12300_12379 = state_12280__$1;
(statearr_12300_12379[(2)] = null);

(statearr_12300_12379[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (21))){
var inst_12202 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12304_12380 = state_12280__$1;
(statearr_12304_12380[(2)] = inst_12202);

(statearr_12304_12380[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (31))){
var inst_12228 = (state_12280[(12)]);
var inst_12232 = done.call(null,null);
var inst_12233 = cljs.core.async.untap_STAR_.call(null,m,inst_12228);
var state_12280__$1 = (function (){var statearr_12305 = state_12280;
(statearr_12305[(19)] = inst_12232);

return statearr_12305;
})();
var statearr_12306_12381 = state_12280__$1;
(statearr_12306_12381[(2)] = inst_12233);

(statearr_12306_12381[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (32))){
var inst_12223 = (state_12280[(9)]);
var inst_12220 = (state_12280[(20)]);
var inst_12222 = (state_12280[(21)]);
var inst_12221 = (state_12280[(11)]);
var inst_12235 = (state_12280[(2)]);
var inst_12236 = (inst_12223 + (1));
var tmp12301 = inst_12220;
var tmp12302 = inst_12222;
var tmp12303 = inst_12221;
var inst_12220__$1 = tmp12301;
var inst_12221__$1 = tmp12303;
var inst_12222__$1 = tmp12302;
var inst_12223__$1 = inst_12236;
var state_12280__$1 = (function (){var statearr_12307 = state_12280;
(statearr_12307[(9)] = inst_12223__$1);

(statearr_12307[(20)] = inst_12220__$1);

(statearr_12307[(21)] = inst_12222__$1);

(statearr_12307[(11)] = inst_12221__$1);

(statearr_12307[(22)] = inst_12235);

return statearr_12307;
})();
var statearr_12308_12382 = state_12280__$1;
(statearr_12308_12382[(2)] = null);

(statearr_12308_12382[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (40))){
var inst_12248 = (state_12280[(23)]);
var inst_12252 = done.call(null,null);
var inst_12253 = cljs.core.async.untap_STAR_.call(null,m,inst_12248);
var state_12280__$1 = (function (){var statearr_12309 = state_12280;
(statearr_12309[(24)] = inst_12252);

return statearr_12309;
})();
var statearr_12310_12383 = state_12280__$1;
(statearr_12310_12383[(2)] = inst_12253);

(statearr_12310_12383[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (33))){
var inst_12239 = (state_12280[(25)]);
var inst_12241 = cljs.core.chunked_seq_QMARK_.call(null,inst_12239);
var state_12280__$1 = state_12280;
if(inst_12241){
var statearr_12311_12384 = state_12280__$1;
(statearr_12311_12384[(1)] = (36));

} else {
var statearr_12312_12385 = state_12280__$1;
(statearr_12312_12385[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (13))){
var inst_12171 = (state_12280[(26)]);
var inst_12174 = cljs.core.async.close_BANG_.call(null,inst_12171);
var state_12280__$1 = state_12280;
var statearr_12313_12386 = state_12280__$1;
(statearr_12313_12386[(2)] = inst_12174);

(statearr_12313_12386[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (22))){
var inst_12192 = (state_12280[(8)]);
var inst_12195 = cljs.core.async.close_BANG_.call(null,inst_12192);
var state_12280__$1 = state_12280;
var statearr_12314_12387 = state_12280__$1;
(statearr_12314_12387[(2)] = inst_12195);

(statearr_12314_12387[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (36))){
var inst_12239 = (state_12280[(25)]);
var inst_12243 = cljs.core.chunk_first.call(null,inst_12239);
var inst_12244 = cljs.core.chunk_rest.call(null,inst_12239);
var inst_12245 = cljs.core.count.call(null,inst_12243);
var inst_12220 = inst_12244;
var inst_12221 = inst_12243;
var inst_12222 = inst_12245;
var inst_12223 = (0);
var state_12280__$1 = (function (){var statearr_12315 = state_12280;
(statearr_12315[(9)] = inst_12223);

(statearr_12315[(20)] = inst_12220);

(statearr_12315[(21)] = inst_12222);

(statearr_12315[(11)] = inst_12221);

return statearr_12315;
})();
var statearr_12316_12388 = state_12280__$1;
(statearr_12316_12388[(2)] = null);

(statearr_12316_12388[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (41))){
var inst_12239 = (state_12280[(25)]);
var inst_12255 = (state_12280[(2)]);
var inst_12256 = cljs.core.next.call(null,inst_12239);
var inst_12220 = inst_12256;
var inst_12221 = null;
var inst_12222 = (0);
var inst_12223 = (0);
var state_12280__$1 = (function (){var statearr_12317 = state_12280;
(statearr_12317[(9)] = inst_12223);

(statearr_12317[(20)] = inst_12220);

(statearr_12317[(21)] = inst_12222);

(statearr_12317[(27)] = inst_12255);

(statearr_12317[(11)] = inst_12221);

return statearr_12317;
})();
var statearr_12318_12389 = state_12280__$1;
(statearr_12318_12389[(2)] = null);

(statearr_12318_12389[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (43))){
var state_12280__$1 = state_12280;
var statearr_12319_12390 = state_12280__$1;
(statearr_12319_12390[(2)] = null);

(statearr_12319_12390[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (29))){
var inst_12264 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12320_12391 = state_12280__$1;
(statearr_12320_12391[(2)] = inst_12264);

(statearr_12320_12391[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (44))){
var inst_12273 = (state_12280[(2)]);
var state_12280__$1 = (function (){var statearr_12321 = state_12280;
(statearr_12321[(28)] = inst_12273);

return statearr_12321;
})();
var statearr_12322_12392 = state_12280__$1;
(statearr_12322_12392[(2)] = null);

(statearr_12322_12392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (6))){
var inst_12212 = (state_12280[(29)]);
var inst_12211 = cljs.core.deref.call(null,cs);
var inst_12212__$1 = cljs.core.keys.call(null,inst_12211);
var inst_12213 = cljs.core.count.call(null,inst_12212__$1);
var inst_12214 = cljs.core.reset_BANG_.call(null,dctr,inst_12213);
var inst_12219 = cljs.core.seq.call(null,inst_12212__$1);
var inst_12220 = inst_12219;
var inst_12221 = null;
var inst_12222 = (0);
var inst_12223 = (0);
var state_12280__$1 = (function (){var statearr_12323 = state_12280;
(statearr_12323[(29)] = inst_12212__$1);

(statearr_12323[(30)] = inst_12214);

(statearr_12323[(9)] = inst_12223);

(statearr_12323[(20)] = inst_12220);

(statearr_12323[(21)] = inst_12222);

(statearr_12323[(11)] = inst_12221);

return statearr_12323;
})();
var statearr_12324_12393 = state_12280__$1;
(statearr_12324_12393[(2)] = null);

(statearr_12324_12393[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (28))){
var inst_12220 = (state_12280[(20)]);
var inst_12239 = (state_12280[(25)]);
var inst_12239__$1 = cljs.core.seq.call(null,inst_12220);
var state_12280__$1 = (function (){var statearr_12325 = state_12280;
(statearr_12325[(25)] = inst_12239__$1);

return statearr_12325;
})();
if(inst_12239__$1){
var statearr_12326_12394 = state_12280__$1;
(statearr_12326_12394[(1)] = (33));

} else {
var statearr_12327_12395 = state_12280__$1;
(statearr_12327_12395[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (25))){
var inst_12223 = (state_12280[(9)]);
var inst_12222 = (state_12280[(21)]);
var inst_12225 = (inst_12223 < inst_12222);
var inst_12226 = inst_12225;
var state_12280__$1 = state_12280;
if(cljs.core.truth_(inst_12226)){
var statearr_12328_12396 = state_12280__$1;
(statearr_12328_12396[(1)] = (27));

} else {
var statearr_12329_12397 = state_12280__$1;
(statearr_12329_12397[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (34))){
var state_12280__$1 = state_12280;
var statearr_12330_12398 = state_12280__$1;
(statearr_12330_12398[(2)] = null);

(statearr_12330_12398[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (17))){
var state_12280__$1 = state_12280;
var statearr_12331_12399 = state_12280__$1;
(statearr_12331_12399[(2)] = null);

(statearr_12331_12399[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (3))){
var inst_12278 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12280__$1,inst_12278);
} else {
if((state_val_12281 === (12))){
var inst_12207 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12332_12400 = state_12280__$1;
(statearr_12332_12400[(2)] = inst_12207);

(statearr_12332_12400[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (2))){
var state_12280__$1 = state_12280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12280__$1,(4),ch);
} else {
if((state_val_12281 === (23))){
var state_12280__$1 = state_12280;
var statearr_12333_12401 = state_12280__$1;
(statearr_12333_12401[(2)] = null);

(statearr_12333_12401[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (35))){
var inst_12262 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12334_12402 = state_12280__$1;
(statearr_12334_12402[(2)] = inst_12262);

(statearr_12334_12402[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (19))){
var inst_12181 = (state_12280[(7)]);
var inst_12185 = cljs.core.chunk_first.call(null,inst_12181);
var inst_12186 = cljs.core.chunk_rest.call(null,inst_12181);
var inst_12187 = cljs.core.count.call(null,inst_12185);
var inst_12161 = inst_12186;
var inst_12162 = inst_12185;
var inst_12163 = inst_12187;
var inst_12164 = (0);
var state_12280__$1 = (function (){var statearr_12335 = state_12280;
(statearr_12335[(13)] = inst_12164);

(statearr_12335[(15)] = inst_12163);

(statearr_12335[(16)] = inst_12161);

(statearr_12335[(17)] = inst_12162);

return statearr_12335;
})();
var statearr_12336_12403 = state_12280__$1;
(statearr_12336_12403[(2)] = null);

(statearr_12336_12403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (11))){
var inst_12181 = (state_12280[(7)]);
var inst_12161 = (state_12280[(16)]);
var inst_12181__$1 = cljs.core.seq.call(null,inst_12161);
var state_12280__$1 = (function (){var statearr_12337 = state_12280;
(statearr_12337[(7)] = inst_12181__$1);

return statearr_12337;
})();
if(inst_12181__$1){
var statearr_12338_12404 = state_12280__$1;
(statearr_12338_12404[(1)] = (16));

} else {
var statearr_12339_12405 = state_12280__$1;
(statearr_12339_12405[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (9))){
var inst_12209 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12340_12406 = state_12280__$1;
(statearr_12340_12406[(2)] = inst_12209);

(statearr_12340_12406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (5))){
var inst_12159 = cljs.core.deref.call(null,cs);
var inst_12160 = cljs.core.seq.call(null,inst_12159);
var inst_12161 = inst_12160;
var inst_12162 = null;
var inst_12163 = (0);
var inst_12164 = (0);
var state_12280__$1 = (function (){var statearr_12341 = state_12280;
(statearr_12341[(13)] = inst_12164);

(statearr_12341[(15)] = inst_12163);

(statearr_12341[(16)] = inst_12161);

(statearr_12341[(17)] = inst_12162);

return statearr_12341;
})();
var statearr_12342_12407 = state_12280__$1;
(statearr_12342_12407[(2)] = null);

(statearr_12342_12407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (14))){
var state_12280__$1 = state_12280;
var statearr_12343_12408 = state_12280__$1;
(statearr_12343_12408[(2)] = null);

(statearr_12343_12408[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (45))){
var inst_12270 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12344_12409 = state_12280__$1;
(statearr_12344_12409[(2)] = inst_12270);

(statearr_12344_12409[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (26))){
var inst_12212 = (state_12280[(29)]);
var inst_12266 = (state_12280[(2)]);
var inst_12267 = cljs.core.seq.call(null,inst_12212);
var state_12280__$1 = (function (){var statearr_12345 = state_12280;
(statearr_12345[(31)] = inst_12266);

return statearr_12345;
})();
if(inst_12267){
var statearr_12346_12410 = state_12280__$1;
(statearr_12346_12410[(1)] = (42));

} else {
var statearr_12347_12411 = state_12280__$1;
(statearr_12347_12411[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (16))){
var inst_12181 = (state_12280[(7)]);
var inst_12183 = cljs.core.chunked_seq_QMARK_.call(null,inst_12181);
var state_12280__$1 = state_12280;
if(inst_12183){
var statearr_12348_12412 = state_12280__$1;
(statearr_12348_12412[(1)] = (19));

} else {
var statearr_12349_12413 = state_12280__$1;
(statearr_12349_12413[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (38))){
var inst_12259 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12350_12414 = state_12280__$1;
(statearr_12350_12414[(2)] = inst_12259);

(statearr_12350_12414[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (30))){
var state_12280__$1 = state_12280;
var statearr_12351_12415 = state_12280__$1;
(statearr_12351_12415[(2)] = null);

(statearr_12351_12415[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (10))){
var inst_12164 = (state_12280[(13)]);
var inst_12162 = (state_12280[(17)]);
var inst_12170 = cljs.core._nth.call(null,inst_12162,inst_12164);
var inst_12171 = cljs.core.nth.call(null,inst_12170,(0),null);
var inst_12172 = cljs.core.nth.call(null,inst_12170,(1),null);
var state_12280__$1 = (function (){var statearr_12352 = state_12280;
(statearr_12352[(26)] = inst_12171);

return statearr_12352;
})();
if(cljs.core.truth_(inst_12172)){
var statearr_12353_12416 = state_12280__$1;
(statearr_12353_12416[(1)] = (13));

} else {
var statearr_12354_12417 = state_12280__$1;
(statearr_12354_12417[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (18))){
var inst_12205 = (state_12280[(2)]);
var state_12280__$1 = state_12280;
var statearr_12355_12418 = state_12280__$1;
(statearr_12355_12418[(2)] = inst_12205);

(statearr_12355_12418[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (42))){
var state_12280__$1 = state_12280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12280__$1,(45),dchan);
} else {
if((state_val_12281 === (37))){
var inst_12248 = (state_12280[(23)]);
var inst_12239 = (state_12280[(25)]);
var inst_12152 = (state_12280[(10)]);
var inst_12248__$1 = cljs.core.first.call(null,inst_12239);
var inst_12249 = cljs.core.async.put_BANG_.call(null,inst_12248__$1,inst_12152,done);
var state_12280__$1 = (function (){var statearr_12356 = state_12280;
(statearr_12356[(23)] = inst_12248__$1);

return statearr_12356;
})();
if(cljs.core.truth_(inst_12249)){
var statearr_12357_12419 = state_12280__$1;
(statearr_12357_12419[(1)] = (39));

} else {
var statearr_12358_12420 = state_12280__$1;
(statearr_12358_12420[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12281 === (8))){
var inst_12164 = (state_12280[(13)]);
var inst_12163 = (state_12280[(15)]);
var inst_12166 = (inst_12164 < inst_12163);
var inst_12167 = inst_12166;
var state_12280__$1 = state_12280;
if(cljs.core.truth_(inst_12167)){
var statearr_12359_12421 = state_12280__$1;
(statearr_12359_12421[(1)] = (10));

} else {
var statearr_12360_12422 = state_12280__$1;
(statearr_12360_12422[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___12368,cs,m,dchan,dctr,done))
;
return ((function (switch__10949__auto__,c__11061__auto___12368,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10950__auto__ = null;
var cljs$core$async$mult_$_state_machine__10950__auto____0 = (function (){
var statearr_12364 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12364[(0)] = cljs$core$async$mult_$_state_machine__10950__auto__);

(statearr_12364[(1)] = (1));

return statearr_12364;
});
var cljs$core$async$mult_$_state_machine__10950__auto____1 = (function (state_12280){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_12280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e12365){if((e12365 instanceof Object)){
var ex__10953__auto__ = e12365;
var statearr_12366_12423 = state_12280;
(statearr_12366_12423[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12280);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12365;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12424 = state_12280;
state_12280 = G__12424;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10950__auto__ = function(state_12280){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10950__auto____1.call(this,state_12280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10950__auto____0;
cljs$core$async$mult_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10950__auto____1;
return cljs$core$async$mult_$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___12368,cs,m,dchan,dctr,done))
})();
var state__11063__auto__ = (function (){var statearr_12367 = f__11062__auto__.call(null);
(statearr_12367[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___12368);

return statearr_12367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___12368,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args12425 = [];
var len__5726__auto___12428 = arguments.length;
var i__5727__auto___12429 = (0);
while(true){
if((i__5727__auto___12429 < len__5726__auto___12428)){
args12425.push((arguments[i__5727__auto___12429]));

var G__12430 = (i__5727__auto___12429 + (1));
i__5727__auto___12429 = G__12430;
continue;
} else {
}
break;
}

var G__12427 = args12425.length;
switch (G__12427) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12425.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___12442 = arguments.length;
var i__5727__auto___12443 = (0);
while(true){
if((i__5727__auto___12443 < len__5726__auto___12442)){
args__5733__auto__.push((arguments[i__5727__auto___12443]));

var G__12444 = (i__5727__auto___12443 + (1));
i__5727__auto___12443 = G__12444;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12436){
var map__12437 = p__12436;
var map__12437__$1 = ((((!((map__12437 == null)))?((((map__12437.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12437.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12437):map__12437);
var opts = map__12437__$1;
var statearr_12439_12445 = state;
(statearr_12439_12445[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__12437,map__12437__$1,opts){
return (function (val){
var statearr_12440_12446 = state;
(statearr_12440_12446[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12437,map__12437__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_12441_12447 = state;
(statearr_12441_12447[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12432){
var G__12433 = cljs.core.first.call(null,seq12432);
var seq12432__$1 = cljs.core.next.call(null,seq12432);
var G__12434 = cljs.core.first.call(null,seq12432__$1);
var seq12432__$2 = cljs.core.next.call(null,seq12432__$1);
var G__12435 = cljs.core.first.call(null,seq12432__$2);
var seq12432__$3 = cljs.core.next.call(null,seq12432__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12433,G__12434,G__12435,seq12432__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12611 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12611 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12612){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12612 = meta12612;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12613,meta12612__$1){
var self__ = this;
var _12613__$1 = this;
return (new cljs.core.async.t_cljs$core$async12611(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12612__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12613){
var self__ = this;
var _12613__$1 = this;
return self__.meta12612;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12612","meta12612",914899484,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12611.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12611.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12611";

cljs.core.async.t_cljs$core$async12611.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12611");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12611 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12611(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12612){
return (new cljs.core.async.t_cljs$core$async12611(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12612));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12611(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11061__auto___12774 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___12774,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___12774,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12711){
var state_val_12712 = (state_12711[(1)]);
if((state_val_12712 === (7))){
var inst_12629 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
var statearr_12713_12775 = state_12711__$1;
(statearr_12713_12775[(2)] = inst_12629);

(statearr_12713_12775[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (20))){
var inst_12641 = (state_12711[(7)]);
var state_12711__$1 = state_12711;
var statearr_12714_12776 = state_12711__$1;
(statearr_12714_12776[(2)] = inst_12641);

(statearr_12714_12776[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (27))){
var state_12711__$1 = state_12711;
var statearr_12715_12777 = state_12711__$1;
(statearr_12715_12777[(2)] = null);

(statearr_12715_12777[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (1))){
var inst_12617 = (state_12711[(8)]);
var inst_12617__$1 = calc_state.call(null);
var inst_12619 = (inst_12617__$1 == null);
var inst_12620 = cljs.core.not.call(null,inst_12619);
var state_12711__$1 = (function (){var statearr_12716 = state_12711;
(statearr_12716[(8)] = inst_12617__$1);

return statearr_12716;
})();
if(inst_12620){
var statearr_12717_12778 = state_12711__$1;
(statearr_12717_12778[(1)] = (2));

} else {
var statearr_12718_12779 = state_12711__$1;
(statearr_12718_12779[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (24))){
var inst_12685 = (state_12711[(9)]);
var inst_12671 = (state_12711[(10)]);
var inst_12664 = (state_12711[(11)]);
var inst_12685__$1 = inst_12664.call(null,inst_12671);
var state_12711__$1 = (function (){var statearr_12719 = state_12711;
(statearr_12719[(9)] = inst_12685__$1);

return statearr_12719;
})();
if(cljs.core.truth_(inst_12685__$1)){
var statearr_12720_12780 = state_12711__$1;
(statearr_12720_12780[(1)] = (29));

} else {
var statearr_12721_12781 = state_12711__$1;
(statearr_12721_12781[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (4))){
var inst_12632 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
if(cljs.core.truth_(inst_12632)){
var statearr_12722_12782 = state_12711__$1;
(statearr_12722_12782[(1)] = (8));

} else {
var statearr_12723_12783 = state_12711__$1;
(statearr_12723_12783[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (15))){
var inst_12658 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
if(cljs.core.truth_(inst_12658)){
var statearr_12724_12784 = state_12711__$1;
(statearr_12724_12784[(1)] = (19));

} else {
var statearr_12725_12785 = state_12711__$1;
(statearr_12725_12785[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (21))){
var inst_12663 = (state_12711[(12)]);
var inst_12663__$1 = (state_12711[(2)]);
var inst_12664 = cljs.core.get.call(null,inst_12663__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12665 = cljs.core.get.call(null,inst_12663__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12666 = cljs.core.get.call(null,inst_12663__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12711__$1 = (function (){var statearr_12726 = state_12711;
(statearr_12726[(12)] = inst_12663__$1);

(statearr_12726[(13)] = inst_12665);

(statearr_12726[(11)] = inst_12664);

return statearr_12726;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12711__$1,(22),inst_12666);
} else {
if((state_val_12712 === (31))){
var inst_12693 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
if(cljs.core.truth_(inst_12693)){
var statearr_12727_12786 = state_12711__$1;
(statearr_12727_12786[(1)] = (32));

} else {
var statearr_12728_12787 = state_12711__$1;
(statearr_12728_12787[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (32))){
var inst_12670 = (state_12711[(14)]);
var state_12711__$1 = state_12711;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12711__$1,(35),out,inst_12670);
} else {
if((state_val_12712 === (33))){
var inst_12663 = (state_12711[(12)]);
var inst_12641 = inst_12663;
var state_12711__$1 = (function (){var statearr_12729 = state_12711;
(statearr_12729[(7)] = inst_12641);

return statearr_12729;
})();
var statearr_12730_12788 = state_12711__$1;
(statearr_12730_12788[(2)] = null);

(statearr_12730_12788[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (13))){
var inst_12641 = (state_12711[(7)]);
var inst_12648 = inst_12641.cljs$lang$protocol_mask$partition0$;
var inst_12649 = (inst_12648 & (64));
var inst_12650 = inst_12641.cljs$core$ISeq$;
var inst_12651 = (inst_12649) || (inst_12650);
var state_12711__$1 = state_12711;
if(cljs.core.truth_(inst_12651)){
var statearr_12731_12789 = state_12711__$1;
(statearr_12731_12789[(1)] = (16));

} else {
var statearr_12732_12790 = state_12711__$1;
(statearr_12732_12790[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (22))){
var inst_12670 = (state_12711[(14)]);
var inst_12671 = (state_12711[(10)]);
var inst_12669 = (state_12711[(2)]);
var inst_12670__$1 = cljs.core.nth.call(null,inst_12669,(0),null);
var inst_12671__$1 = cljs.core.nth.call(null,inst_12669,(1),null);
var inst_12672 = (inst_12670__$1 == null);
var inst_12673 = cljs.core._EQ_.call(null,inst_12671__$1,change);
var inst_12674 = (inst_12672) || (inst_12673);
var state_12711__$1 = (function (){var statearr_12733 = state_12711;
(statearr_12733[(14)] = inst_12670__$1);

(statearr_12733[(10)] = inst_12671__$1);

return statearr_12733;
})();
if(cljs.core.truth_(inst_12674)){
var statearr_12734_12791 = state_12711__$1;
(statearr_12734_12791[(1)] = (23));

} else {
var statearr_12735_12792 = state_12711__$1;
(statearr_12735_12792[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (36))){
var inst_12663 = (state_12711[(12)]);
var inst_12641 = inst_12663;
var state_12711__$1 = (function (){var statearr_12736 = state_12711;
(statearr_12736[(7)] = inst_12641);

return statearr_12736;
})();
var statearr_12737_12793 = state_12711__$1;
(statearr_12737_12793[(2)] = null);

(statearr_12737_12793[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (29))){
var inst_12685 = (state_12711[(9)]);
var state_12711__$1 = state_12711;
var statearr_12738_12794 = state_12711__$1;
(statearr_12738_12794[(2)] = inst_12685);

(statearr_12738_12794[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (6))){
var state_12711__$1 = state_12711;
var statearr_12739_12795 = state_12711__$1;
(statearr_12739_12795[(2)] = false);

(statearr_12739_12795[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (28))){
var inst_12681 = (state_12711[(2)]);
var inst_12682 = calc_state.call(null);
var inst_12641 = inst_12682;
var state_12711__$1 = (function (){var statearr_12740 = state_12711;
(statearr_12740[(15)] = inst_12681);

(statearr_12740[(7)] = inst_12641);

return statearr_12740;
})();
var statearr_12741_12796 = state_12711__$1;
(statearr_12741_12796[(2)] = null);

(statearr_12741_12796[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (25))){
var inst_12707 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
var statearr_12742_12797 = state_12711__$1;
(statearr_12742_12797[(2)] = inst_12707);

(statearr_12742_12797[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (34))){
var inst_12705 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
var statearr_12743_12798 = state_12711__$1;
(statearr_12743_12798[(2)] = inst_12705);

(statearr_12743_12798[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (17))){
var state_12711__$1 = state_12711;
var statearr_12744_12799 = state_12711__$1;
(statearr_12744_12799[(2)] = false);

(statearr_12744_12799[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (3))){
var state_12711__$1 = state_12711;
var statearr_12745_12800 = state_12711__$1;
(statearr_12745_12800[(2)] = false);

(statearr_12745_12800[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (12))){
var inst_12709 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12711__$1,inst_12709);
} else {
if((state_val_12712 === (2))){
var inst_12617 = (state_12711[(8)]);
var inst_12622 = inst_12617.cljs$lang$protocol_mask$partition0$;
var inst_12623 = (inst_12622 & (64));
var inst_12624 = inst_12617.cljs$core$ISeq$;
var inst_12625 = (inst_12623) || (inst_12624);
var state_12711__$1 = state_12711;
if(cljs.core.truth_(inst_12625)){
var statearr_12746_12801 = state_12711__$1;
(statearr_12746_12801[(1)] = (5));

} else {
var statearr_12747_12802 = state_12711__$1;
(statearr_12747_12802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (23))){
var inst_12670 = (state_12711[(14)]);
var inst_12676 = (inst_12670 == null);
var state_12711__$1 = state_12711;
if(cljs.core.truth_(inst_12676)){
var statearr_12748_12803 = state_12711__$1;
(statearr_12748_12803[(1)] = (26));

} else {
var statearr_12749_12804 = state_12711__$1;
(statearr_12749_12804[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (35))){
var inst_12696 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
if(cljs.core.truth_(inst_12696)){
var statearr_12750_12805 = state_12711__$1;
(statearr_12750_12805[(1)] = (36));

} else {
var statearr_12751_12806 = state_12711__$1;
(statearr_12751_12806[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (19))){
var inst_12641 = (state_12711[(7)]);
var inst_12660 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12641);
var state_12711__$1 = state_12711;
var statearr_12752_12807 = state_12711__$1;
(statearr_12752_12807[(2)] = inst_12660);

(statearr_12752_12807[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (11))){
var inst_12641 = (state_12711[(7)]);
var inst_12645 = (inst_12641 == null);
var inst_12646 = cljs.core.not.call(null,inst_12645);
var state_12711__$1 = state_12711;
if(inst_12646){
var statearr_12753_12808 = state_12711__$1;
(statearr_12753_12808[(1)] = (13));

} else {
var statearr_12754_12809 = state_12711__$1;
(statearr_12754_12809[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (9))){
var inst_12617 = (state_12711[(8)]);
var state_12711__$1 = state_12711;
var statearr_12755_12810 = state_12711__$1;
(statearr_12755_12810[(2)] = inst_12617);

(statearr_12755_12810[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (5))){
var state_12711__$1 = state_12711;
var statearr_12756_12811 = state_12711__$1;
(statearr_12756_12811[(2)] = true);

(statearr_12756_12811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (14))){
var state_12711__$1 = state_12711;
var statearr_12757_12812 = state_12711__$1;
(statearr_12757_12812[(2)] = false);

(statearr_12757_12812[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (26))){
var inst_12671 = (state_12711[(10)]);
var inst_12678 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12671);
var state_12711__$1 = state_12711;
var statearr_12758_12813 = state_12711__$1;
(statearr_12758_12813[(2)] = inst_12678);

(statearr_12758_12813[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (16))){
var state_12711__$1 = state_12711;
var statearr_12759_12814 = state_12711__$1;
(statearr_12759_12814[(2)] = true);

(statearr_12759_12814[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (38))){
var inst_12701 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
var statearr_12760_12815 = state_12711__$1;
(statearr_12760_12815[(2)] = inst_12701);

(statearr_12760_12815[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (30))){
var inst_12665 = (state_12711[(13)]);
var inst_12671 = (state_12711[(10)]);
var inst_12664 = (state_12711[(11)]);
var inst_12688 = cljs.core.empty_QMARK_.call(null,inst_12664);
var inst_12689 = inst_12665.call(null,inst_12671);
var inst_12690 = cljs.core.not.call(null,inst_12689);
var inst_12691 = (inst_12688) && (inst_12690);
var state_12711__$1 = state_12711;
var statearr_12761_12816 = state_12711__$1;
(statearr_12761_12816[(2)] = inst_12691);

(statearr_12761_12816[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (10))){
var inst_12617 = (state_12711[(8)]);
var inst_12637 = (state_12711[(2)]);
var inst_12638 = cljs.core.get.call(null,inst_12637,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12639 = cljs.core.get.call(null,inst_12637,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12640 = cljs.core.get.call(null,inst_12637,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12641 = inst_12617;
var state_12711__$1 = (function (){var statearr_12762 = state_12711;
(statearr_12762[(16)] = inst_12639);

(statearr_12762[(7)] = inst_12641);

(statearr_12762[(17)] = inst_12638);

(statearr_12762[(18)] = inst_12640);

return statearr_12762;
})();
var statearr_12763_12817 = state_12711__$1;
(statearr_12763_12817[(2)] = null);

(statearr_12763_12817[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (18))){
var inst_12655 = (state_12711[(2)]);
var state_12711__$1 = state_12711;
var statearr_12764_12818 = state_12711__$1;
(statearr_12764_12818[(2)] = inst_12655);

(statearr_12764_12818[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (37))){
var state_12711__$1 = state_12711;
var statearr_12765_12819 = state_12711__$1;
(statearr_12765_12819[(2)] = null);

(statearr_12765_12819[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12712 === (8))){
var inst_12617 = (state_12711[(8)]);
var inst_12634 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12617);
var state_12711__$1 = state_12711;
var statearr_12766_12820 = state_12711__$1;
(statearr_12766_12820[(2)] = inst_12634);

(statearr_12766_12820[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___12774,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10949__auto__,c__11061__auto___12774,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10950__auto__ = null;
var cljs$core$async$mix_$_state_machine__10950__auto____0 = (function (){
var statearr_12770 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12770[(0)] = cljs$core$async$mix_$_state_machine__10950__auto__);

(statearr_12770[(1)] = (1));

return statearr_12770;
});
var cljs$core$async$mix_$_state_machine__10950__auto____1 = (function (state_12711){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_12711);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e12771){if((e12771 instanceof Object)){
var ex__10953__auto__ = e12771;
var statearr_12772_12821 = state_12711;
(statearr_12772_12821[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12711);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12822 = state_12711;
state_12711 = G__12822;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10950__auto__ = function(state_12711){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10950__auto____1.call(this,state_12711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10950__auto____0;
cljs$core$async$mix_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10950__auto____1;
return cljs$core$async$mix_$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___12774,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11063__auto__ = (function (){var statearr_12773 = f__11062__auto__.call(null);
(statearr_12773[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___12774);

return statearr_12773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___12774,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12823 = [];
var len__5726__auto___12826 = arguments.length;
var i__5727__auto___12827 = (0);
while(true){
if((i__5727__auto___12827 < len__5726__auto___12826)){
args12823.push((arguments[i__5727__auto___12827]));

var G__12828 = (i__5727__auto___12827 + (1));
i__5727__auto___12827 = G__12828;
continue;
} else {
}
break;
}

var G__12825 = args12823.length;
switch (G__12825) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12823.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12831 = [];
var len__5726__auto___12956 = arguments.length;
var i__5727__auto___12957 = (0);
while(true){
if((i__5727__auto___12957 < len__5726__auto___12956)){
args12831.push((arguments[i__5727__auto___12957]));

var G__12958 = (i__5727__auto___12957 + (1));
i__5727__auto___12957 = G__12958;
continue;
} else {
}
break;
}

var G__12833 = args12831.length;
switch (G__12833) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12831.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__12830_SHARP_){
if(cljs.core.truth_(p1__12830_SHARP_.call(null,topic))){
return p1__12830_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12830_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12834 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12834 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12835){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12835 = meta12835;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12836,meta12835__$1){
var self__ = this;
var _12836__$1 = this;
return (new cljs.core.async.t_cljs$core$async12834(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12835__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12836){
var self__ = this;
var _12836__$1 = this;
return self__.meta12835;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12834.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12834.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12835","meta12835",1376319253,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12834.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12834.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12834";

cljs.core.async.t_cljs$core$async12834.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12834");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12834 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12834(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12835){
return (new cljs.core.async.t_cljs$core$async12834(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12835));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12834(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11061__auto___12960 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___12960,mults,ensure_mult,p){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___12960,mults,ensure_mult,p){
return (function (state_12908){
var state_val_12909 = (state_12908[(1)]);
if((state_val_12909 === (7))){
var inst_12904 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
var statearr_12910_12961 = state_12908__$1;
(statearr_12910_12961[(2)] = inst_12904);

(statearr_12910_12961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (20))){
var state_12908__$1 = state_12908;
var statearr_12911_12962 = state_12908__$1;
(statearr_12911_12962[(2)] = null);

(statearr_12911_12962[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (1))){
var state_12908__$1 = state_12908;
var statearr_12912_12963 = state_12908__$1;
(statearr_12912_12963[(2)] = null);

(statearr_12912_12963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (24))){
var inst_12887 = (state_12908[(7)]);
var inst_12896 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12887);
var state_12908__$1 = state_12908;
var statearr_12913_12964 = state_12908__$1;
(statearr_12913_12964[(2)] = inst_12896);

(statearr_12913_12964[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (4))){
var inst_12839 = (state_12908[(8)]);
var inst_12839__$1 = (state_12908[(2)]);
var inst_12840 = (inst_12839__$1 == null);
var state_12908__$1 = (function (){var statearr_12914 = state_12908;
(statearr_12914[(8)] = inst_12839__$1);

return statearr_12914;
})();
if(cljs.core.truth_(inst_12840)){
var statearr_12915_12965 = state_12908__$1;
(statearr_12915_12965[(1)] = (5));

} else {
var statearr_12916_12966 = state_12908__$1;
(statearr_12916_12966[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (15))){
var inst_12881 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
var statearr_12917_12967 = state_12908__$1;
(statearr_12917_12967[(2)] = inst_12881);

(statearr_12917_12967[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (21))){
var inst_12901 = (state_12908[(2)]);
var state_12908__$1 = (function (){var statearr_12918 = state_12908;
(statearr_12918[(9)] = inst_12901);

return statearr_12918;
})();
var statearr_12919_12968 = state_12908__$1;
(statearr_12919_12968[(2)] = null);

(statearr_12919_12968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (13))){
var inst_12863 = (state_12908[(10)]);
var inst_12865 = cljs.core.chunked_seq_QMARK_.call(null,inst_12863);
var state_12908__$1 = state_12908;
if(inst_12865){
var statearr_12920_12969 = state_12908__$1;
(statearr_12920_12969[(1)] = (16));

} else {
var statearr_12921_12970 = state_12908__$1;
(statearr_12921_12970[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (22))){
var inst_12893 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
if(cljs.core.truth_(inst_12893)){
var statearr_12922_12971 = state_12908__$1;
(statearr_12922_12971[(1)] = (23));

} else {
var statearr_12923_12972 = state_12908__$1;
(statearr_12923_12972[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (6))){
var inst_12839 = (state_12908[(8)]);
var inst_12887 = (state_12908[(7)]);
var inst_12889 = (state_12908[(11)]);
var inst_12887__$1 = topic_fn.call(null,inst_12839);
var inst_12888 = cljs.core.deref.call(null,mults);
var inst_12889__$1 = cljs.core.get.call(null,inst_12888,inst_12887__$1);
var state_12908__$1 = (function (){var statearr_12924 = state_12908;
(statearr_12924[(7)] = inst_12887__$1);

(statearr_12924[(11)] = inst_12889__$1);

return statearr_12924;
})();
if(cljs.core.truth_(inst_12889__$1)){
var statearr_12925_12973 = state_12908__$1;
(statearr_12925_12973[(1)] = (19));

} else {
var statearr_12926_12974 = state_12908__$1;
(statearr_12926_12974[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (25))){
var inst_12898 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
var statearr_12927_12975 = state_12908__$1;
(statearr_12927_12975[(2)] = inst_12898);

(statearr_12927_12975[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (17))){
var inst_12863 = (state_12908[(10)]);
var inst_12872 = cljs.core.first.call(null,inst_12863);
var inst_12873 = cljs.core.async.muxch_STAR_.call(null,inst_12872);
var inst_12874 = cljs.core.async.close_BANG_.call(null,inst_12873);
var inst_12875 = cljs.core.next.call(null,inst_12863);
var inst_12849 = inst_12875;
var inst_12850 = null;
var inst_12851 = (0);
var inst_12852 = (0);
var state_12908__$1 = (function (){var statearr_12928 = state_12908;
(statearr_12928[(12)] = inst_12849);

(statearr_12928[(13)] = inst_12851);

(statearr_12928[(14)] = inst_12874);

(statearr_12928[(15)] = inst_12852);

(statearr_12928[(16)] = inst_12850);

return statearr_12928;
})();
var statearr_12929_12976 = state_12908__$1;
(statearr_12929_12976[(2)] = null);

(statearr_12929_12976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (3))){
var inst_12906 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12908__$1,inst_12906);
} else {
if((state_val_12909 === (12))){
var inst_12883 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
var statearr_12930_12977 = state_12908__$1;
(statearr_12930_12977[(2)] = inst_12883);

(statearr_12930_12977[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (2))){
var state_12908__$1 = state_12908;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12908__$1,(4),ch);
} else {
if((state_val_12909 === (23))){
var state_12908__$1 = state_12908;
var statearr_12931_12978 = state_12908__$1;
(statearr_12931_12978[(2)] = null);

(statearr_12931_12978[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (19))){
var inst_12839 = (state_12908[(8)]);
var inst_12889 = (state_12908[(11)]);
var inst_12891 = cljs.core.async.muxch_STAR_.call(null,inst_12889);
var state_12908__$1 = state_12908;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12908__$1,(22),inst_12891,inst_12839);
} else {
if((state_val_12909 === (11))){
var inst_12849 = (state_12908[(12)]);
var inst_12863 = (state_12908[(10)]);
var inst_12863__$1 = cljs.core.seq.call(null,inst_12849);
var state_12908__$1 = (function (){var statearr_12932 = state_12908;
(statearr_12932[(10)] = inst_12863__$1);

return statearr_12932;
})();
if(inst_12863__$1){
var statearr_12933_12979 = state_12908__$1;
(statearr_12933_12979[(1)] = (13));

} else {
var statearr_12934_12980 = state_12908__$1;
(statearr_12934_12980[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (9))){
var inst_12885 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
var statearr_12935_12981 = state_12908__$1;
(statearr_12935_12981[(2)] = inst_12885);

(statearr_12935_12981[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (5))){
var inst_12846 = cljs.core.deref.call(null,mults);
var inst_12847 = cljs.core.vals.call(null,inst_12846);
var inst_12848 = cljs.core.seq.call(null,inst_12847);
var inst_12849 = inst_12848;
var inst_12850 = null;
var inst_12851 = (0);
var inst_12852 = (0);
var state_12908__$1 = (function (){var statearr_12936 = state_12908;
(statearr_12936[(12)] = inst_12849);

(statearr_12936[(13)] = inst_12851);

(statearr_12936[(15)] = inst_12852);

(statearr_12936[(16)] = inst_12850);

return statearr_12936;
})();
var statearr_12937_12982 = state_12908__$1;
(statearr_12937_12982[(2)] = null);

(statearr_12937_12982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (14))){
var state_12908__$1 = state_12908;
var statearr_12941_12983 = state_12908__$1;
(statearr_12941_12983[(2)] = null);

(statearr_12941_12983[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (16))){
var inst_12863 = (state_12908[(10)]);
var inst_12867 = cljs.core.chunk_first.call(null,inst_12863);
var inst_12868 = cljs.core.chunk_rest.call(null,inst_12863);
var inst_12869 = cljs.core.count.call(null,inst_12867);
var inst_12849 = inst_12868;
var inst_12850 = inst_12867;
var inst_12851 = inst_12869;
var inst_12852 = (0);
var state_12908__$1 = (function (){var statearr_12942 = state_12908;
(statearr_12942[(12)] = inst_12849);

(statearr_12942[(13)] = inst_12851);

(statearr_12942[(15)] = inst_12852);

(statearr_12942[(16)] = inst_12850);

return statearr_12942;
})();
var statearr_12943_12984 = state_12908__$1;
(statearr_12943_12984[(2)] = null);

(statearr_12943_12984[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (10))){
var inst_12849 = (state_12908[(12)]);
var inst_12851 = (state_12908[(13)]);
var inst_12852 = (state_12908[(15)]);
var inst_12850 = (state_12908[(16)]);
var inst_12857 = cljs.core._nth.call(null,inst_12850,inst_12852);
var inst_12858 = cljs.core.async.muxch_STAR_.call(null,inst_12857);
var inst_12859 = cljs.core.async.close_BANG_.call(null,inst_12858);
var inst_12860 = (inst_12852 + (1));
var tmp12938 = inst_12849;
var tmp12939 = inst_12851;
var tmp12940 = inst_12850;
var inst_12849__$1 = tmp12938;
var inst_12850__$1 = tmp12940;
var inst_12851__$1 = tmp12939;
var inst_12852__$1 = inst_12860;
var state_12908__$1 = (function (){var statearr_12944 = state_12908;
(statearr_12944[(12)] = inst_12849__$1);

(statearr_12944[(13)] = inst_12851__$1);

(statearr_12944[(17)] = inst_12859);

(statearr_12944[(15)] = inst_12852__$1);

(statearr_12944[(16)] = inst_12850__$1);

return statearr_12944;
})();
var statearr_12945_12985 = state_12908__$1;
(statearr_12945_12985[(2)] = null);

(statearr_12945_12985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (18))){
var inst_12878 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
var statearr_12946_12986 = state_12908__$1;
(statearr_12946_12986[(2)] = inst_12878);

(statearr_12946_12986[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (8))){
var inst_12851 = (state_12908[(13)]);
var inst_12852 = (state_12908[(15)]);
var inst_12854 = (inst_12852 < inst_12851);
var inst_12855 = inst_12854;
var state_12908__$1 = state_12908;
if(cljs.core.truth_(inst_12855)){
var statearr_12947_12987 = state_12908__$1;
(statearr_12947_12987[(1)] = (10));

} else {
var statearr_12948_12988 = state_12908__$1;
(statearr_12948_12988[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___12960,mults,ensure_mult,p))
;
return ((function (switch__10949__auto__,c__11061__auto___12960,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_12952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12952[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_12952[(1)] = (1));

return statearr_12952;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_12908){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_12908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e12953){if((e12953 instanceof Object)){
var ex__10953__auto__ = e12953;
var statearr_12954_12989 = state_12908;
(statearr_12954_12989[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12908);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12953;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12990 = state_12908;
state_12908 = G__12990;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_12908){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_12908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___12960,mults,ensure_mult,p))
})();
var state__11063__auto__ = (function (){var statearr_12955 = f__11062__auto__.call(null);
(statearr_12955[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___12960);

return statearr_12955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___12960,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args12991 = [];
var len__5726__auto___12994 = arguments.length;
var i__5727__auto___12995 = (0);
while(true){
if((i__5727__auto___12995 < len__5726__auto___12994)){
args12991.push((arguments[i__5727__auto___12995]));

var G__12996 = (i__5727__auto___12995 + (1));
i__5727__auto___12995 = G__12996;
continue;
} else {
}
break;
}

var G__12993 = args12991.length;
switch (G__12993) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12991.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args12998 = [];
var len__5726__auto___13001 = arguments.length;
var i__5727__auto___13002 = (0);
while(true){
if((i__5727__auto___13002 < len__5726__auto___13001)){
args12998.push((arguments[i__5727__auto___13002]));

var G__13003 = (i__5727__auto___13002 + (1));
i__5727__auto___13002 = G__13003;
continue;
} else {
}
break;
}

var G__13000 = args12998.length;
switch (G__13000) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12998.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13005 = [];
var len__5726__auto___13076 = arguments.length;
var i__5727__auto___13077 = (0);
while(true){
if((i__5727__auto___13077 < len__5726__auto___13076)){
args13005.push((arguments[i__5727__auto___13077]));

var G__13078 = (i__5727__auto___13077 + (1));
i__5727__auto___13077 = G__13078;
continue;
} else {
}
break;
}

var G__13007 = args13005.length;
switch (G__13007) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13005.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11061__auto___13080 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___13080,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___13080,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13046){
var state_val_13047 = (state_13046[(1)]);
if((state_val_13047 === (7))){
var state_13046__$1 = state_13046;
var statearr_13048_13081 = state_13046__$1;
(statearr_13048_13081[(2)] = null);

(statearr_13048_13081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (1))){
var state_13046__$1 = state_13046;
var statearr_13049_13082 = state_13046__$1;
(statearr_13049_13082[(2)] = null);

(statearr_13049_13082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (4))){
var inst_13010 = (state_13046[(7)]);
var inst_13012 = (inst_13010 < cnt);
var state_13046__$1 = state_13046;
if(cljs.core.truth_(inst_13012)){
var statearr_13050_13083 = state_13046__$1;
(statearr_13050_13083[(1)] = (6));

} else {
var statearr_13051_13084 = state_13046__$1;
(statearr_13051_13084[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (15))){
var inst_13042 = (state_13046[(2)]);
var state_13046__$1 = state_13046;
var statearr_13052_13085 = state_13046__$1;
(statearr_13052_13085[(2)] = inst_13042);

(statearr_13052_13085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (13))){
var inst_13035 = cljs.core.async.close_BANG_.call(null,out);
var state_13046__$1 = state_13046;
var statearr_13053_13086 = state_13046__$1;
(statearr_13053_13086[(2)] = inst_13035);

(statearr_13053_13086[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (6))){
var state_13046__$1 = state_13046;
var statearr_13054_13087 = state_13046__$1;
(statearr_13054_13087[(2)] = null);

(statearr_13054_13087[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (3))){
var inst_13044 = (state_13046[(2)]);
var state_13046__$1 = state_13046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13046__$1,inst_13044);
} else {
if((state_val_13047 === (12))){
var inst_13032 = (state_13046[(8)]);
var inst_13032__$1 = (state_13046[(2)]);
var inst_13033 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13032__$1);
var state_13046__$1 = (function (){var statearr_13055 = state_13046;
(statearr_13055[(8)] = inst_13032__$1);

return statearr_13055;
})();
if(cljs.core.truth_(inst_13033)){
var statearr_13056_13088 = state_13046__$1;
(statearr_13056_13088[(1)] = (13));

} else {
var statearr_13057_13089 = state_13046__$1;
(statearr_13057_13089[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (2))){
var inst_13009 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13010 = (0);
var state_13046__$1 = (function (){var statearr_13058 = state_13046;
(statearr_13058[(9)] = inst_13009);

(statearr_13058[(7)] = inst_13010);

return statearr_13058;
})();
var statearr_13059_13090 = state_13046__$1;
(statearr_13059_13090[(2)] = null);

(statearr_13059_13090[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (11))){
var inst_13010 = (state_13046[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13046,(10),Object,null,(9));
var inst_13019 = chs__$1.call(null,inst_13010);
var inst_13020 = done.call(null,inst_13010);
var inst_13021 = cljs.core.async.take_BANG_.call(null,inst_13019,inst_13020);
var state_13046__$1 = state_13046;
var statearr_13060_13091 = state_13046__$1;
(statearr_13060_13091[(2)] = inst_13021);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13046__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (9))){
var inst_13010 = (state_13046[(7)]);
var inst_13023 = (state_13046[(2)]);
var inst_13024 = (inst_13010 + (1));
var inst_13010__$1 = inst_13024;
var state_13046__$1 = (function (){var statearr_13061 = state_13046;
(statearr_13061[(10)] = inst_13023);

(statearr_13061[(7)] = inst_13010__$1);

return statearr_13061;
})();
var statearr_13062_13092 = state_13046__$1;
(statearr_13062_13092[(2)] = null);

(statearr_13062_13092[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (5))){
var inst_13030 = (state_13046[(2)]);
var state_13046__$1 = (function (){var statearr_13063 = state_13046;
(statearr_13063[(11)] = inst_13030);

return statearr_13063;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13046__$1,(12),dchan);
} else {
if((state_val_13047 === (14))){
var inst_13032 = (state_13046[(8)]);
var inst_13037 = cljs.core.apply.call(null,f,inst_13032);
var state_13046__$1 = state_13046;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13046__$1,(16),out,inst_13037);
} else {
if((state_val_13047 === (16))){
var inst_13039 = (state_13046[(2)]);
var state_13046__$1 = (function (){var statearr_13064 = state_13046;
(statearr_13064[(12)] = inst_13039);

return statearr_13064;
})();
var statearr_13065_13093 = state_13046__$1;
(statearr_13065_13093[(2)] = null);

(statearr_13065_13093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (10))){
var inst_13014 = (state_13046[(2)]);
var inst_13015 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13046__$1 = (function (){var statearr_13066 = state_13046;
(statearr_13066[(13)] = inst_13014);

return statearr_13066;
})();
var statearr_13067_13094 = state_13046__$1;
(statearr_13067_13094[(2)] = inst_13015);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13046__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13047 === (8))){
var inst_13028 = (state_13046[(2)]);
var state_13046__$1 = state_13046;
var statearr_13068_13095 = state_13046__$1;
(statearr_13068_13095[(2)] = inst_13028);

(statearr_13068_13095[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___13080,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10949__auto__,c__11061__auto___13080,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_13072 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13072[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_13072[(1)] = (1));

return statearr_13072;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_13046){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_13046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e13073){if((e13073 instanceof Object)){
var ex__10953__auto__ = e13073;
var statearr_13074_13096 = state_13046;
(statearr_13074_13096[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13046);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13073;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13097 = state_13046;
state_13046 = G__13097;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_13046){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_13046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___13080,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11063__auto__ = (function (){var statearr_13075 = f__11062__auto__.call(null);
(statearr_13075[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___13080);

return statearr_13075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___13080,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13099 = [];
var len__5726__auto___13155 = arguments.length;
var i__5727__auto___13156 = (0);
while(true){
if((i__5727__auto___13156 < len__5726__auto___13155)){
args13099.push((arguments[i__5727__auto___13156]));

var G__13157 = (i__5727__auto___13156 + (1));
i__5727__auto___13156 = G__13157;
continue;
} else {
}
break;
}

var G__13101 = args13099.length;
switch (G__13101) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13099.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___13159 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___13159,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___13159,out){
return (function (state_13131){
var state_val_13132 = (state_13131[(1)]);
if((state_val_13132 === (7))){
var inst_13111 = (state_13131[(7)]);
var inst_13110 = (state_13131[(8)]);
var inst_13110__$1 = (state_13131[(2)]);
var inst_13111__$1 = cljs.core.nth.call(null,inst_13110__$1,(0),null);
var inst_13112 = cljs.core.nth.call(null,inst_13110__$1,(1),null);
var inst_13113 = (inst_13111__$1 == null);
var state_13131__$1 = (function (){var statearr_13133 = state_13131;
(statearr_13133[(9)] = inst_13112);

(statearr_13133[(7)] = inst_13111__$1);

(statearr_13133[(8)] = inst_13110__$1);

return statearr_13133;
})();
if(cljs.core.truth_(inst_13113)){
var statearr_13134_13160 = state_13131__$1;
(statearr_13134_13160[(1)] = (8));

} else {
var statearr_13135_13161 = state_13131__$1;
(statearr_13135_13161[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13132 === (1))){
var inst_13102 = cljs.core.vec.call(null,chs);
var inst_13103 = inst_13102;
var state_13131__$1 = (function (){var statearr_13136 = state_13131;
(statearr_13136[(10)] = inst_13103);

return statearr_13136;
})();
var statearr_13137_13162 = state_13131__$1;
(statearr_13137_13162[(2)] = null);

(statearr_13137_13162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13132 === (4))){
var inst_13103 = (state_13131[(10)]);
var state_13131__$1 = state_13131;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13131__$1,(7),inst_13103);
} else {
if((state_val_13132 === (6))){
var inst_13127 = (state_13131[(2)]);
var state_13131__$1 = state_13131;
var statearr_13138_13163 = state_13131__$1;
(statearr_13138_13163[(2)] = inst_13127);

(statearr_13138_13163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13132 === (3))){
var inst_13129 = (state_13131[(2)]);
var state_13131__$1 = state_13131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13131__$1,inst_13129);
} else {
if((state_val_13132 === (2))){
var inst_13103 = (state_13131[(10)]);
var inst_13105 = cljs.core.count.call(null,inst_13103);
var inst_13106 = (inst_13105 > (0));
var state_13131__$1 = state_13131;
if(cljs.core.truth_(inst_13106)){
var statearr_13140_13164 = state_13131__$1;
(statearr_13140_13164[(1)] = (4));

} else {
var statearr_13141_13165 = state_13131__$1;
(statearr_13141_13165[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13132 === (11))){
var inst_13103 = (state_13131[(10)]);
var inst_13120 = (state_13131[(2)]);
var tmp13139 = inst_13103;
var inst_13103__$1 = tmp13139;
var state_13131__$1 = (function (){var statearr_13142 = state_13131;
(statearr_13142[(11)] = inst_13120);

(statearr_13142[(10)] = inst_13103__$1);

return statearr_13142;
})();
var statearr_13143_13166 = state_13131__$1;
(statearr_13143_13166[(2)] = null);

(statearr_13143_13166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13132 === (9))){
var inst_13111 = (state_13131[(7)]);
var state_13131__$1 = state_13131;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13131__$1,(11),out,inst_13111);
} else {
if((state_val_13132 === (5))){
var inst_13125 = cljs.core.async.close_BANG_.call(null,out);
var state_13131__$1 = state_13131;
var statearr_13144_13167 = state_13131__$1;
(statearr_13144_13167[(2)] = inst_13125);

(statearr_13144_13167[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13132 === (10))){
var inst_13123 = (state_13131[(2)]);
var state_13131__$1 = state_13131;
var statearr_13145_13168 = state_13131__$1;
(statearr_13145_13168[(2)] = inst_13123);

(statearr_13145_13168[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13132 === (8))){
var inst_13103 = (state_13131[(10)]);
var inst_13112 = (state_13131[(9)]);
var inst_13111 = (state_13131[(7)]);
var inst_13110 = (state_13131[(8)]);
var inst_13115 = (function (){var cs = inst_13103;
var vec__13108 = inst_13110;
var v = inst_13111;
var c = inst_13112;
return ((function (cs,vec__13108,v,c,inst_13103,inst_13112,inst_13111,inst_13110,state_val_13132,c__11061__auto___13159,out){
return (function (p1__13098_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13098_SHARP_);
});
;})(cs,vec__13108,v,c,inst_13103,inst_13112,inst_13111,inst_13110,state_val_13132,c__11061__auto___13159,out))
})();
var inst_13116 = cljs.core.filterv.call(null,inst_13115,inst_13103);
var inst_13103__$1 = inst_13116;
var state_13131__$1 = (function (){var statearr_13146 = state_13131;
(statearr_13146[(10)] = inst_13103__$1);

return statearr_13146;
})();
var statearr_13147_13169 = state_13131__$1;
(statearr_13147_13169[(2)] = null);

(statearr_13147_13169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___13159,out))
;
return ((function (switch__10949__auto__,c__11061__auto___13159,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_13151 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13151[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_13151[(1)] = (1));

return statearr_13151;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_13131){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_13131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e13152){if((e13152 instanceof Object)){
var ex__10953__auto__ = e13152;
var statearr_13153_13170 = state_13131;
(statearr_13153_13170[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13131);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13152;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13171 = state_13131;
state_13131 = G__13171;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_13131){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_13131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___13159,out))
})();
var state__11063__auto__ = (function (){var statearr_13154 = f__11062__auto__.call(null);
(statearr_13154[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___13159);

return statearr_13154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___13159,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13172 = [];
var len__5726__auto___13221 = arguments.length;
var i__5727__auto___13222 = (0);
while(true){
if((i__5727__auto___13222 < len__5726__auto___13221)){
args13172.push((arguments[i__5727__auto___13222]));

var G__13223 = (i__5727__auto___13222 + (1));
i__5727__auto___13222 = G__13223;
continue;
} else {
}
break;
}

var G__13174 = args13172.length;
switch (G__13174) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13172.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___13225 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___13225,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___13225,out){
return (function (state_13198){
var state_val_13199 = (state_13198[(1)]);
if((state_val_13199 === (7))){
var inst_13180 = (state_13198[(7)]);
var inst_13180__$1 = (state_13198[(2)]);
var inst_13181 = (inst_13180__$1 == null);
var inst_13182 = cljs.core.not.call(null,inst_13181);
var state_13198__$1 = (function (){var statearr_13200 = state_13198;
(statearr_13200[(7)] = inst_13180__$1);

return statearr_13200;
})();
if(inst_13182){
var statearr_13201_13226 = state_13198__$1;
(statearr_13201_13226[(1)] = (8));

} else {
var statearr_13202_13227 = state_13198__$1;
(statearr_13202_13227[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13199 === (1))){
var inst_13175 = (0);
var state_13198__$1 = (function (){var statearr_13203 = state_13198;
(statearr_13203[(8)] = inst_13175);

return statearr_13203;
})();
var statearr_13204_13228 = state_13198__$1;
(statearr_13204_13228[(2)] = null);

(statearr_13204_13228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13199 === (4))){
var state_13198__$1 = state_13198;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13198__$1,(7),ch);
} else {
if((state_val_13199 === (6))){
var inst_13193 = (state_13198[(2)]);
var state_13198__$1 = state_13198;
var statearr_13205_13229 = state_13198__$1;
(statearr_13205_13229[(2)] = inst_13193);

(statearr_13205_13229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13199 === (3))){
var inst_13195 = (state_13198[(2)]);
var inst_13196 = cljs.core.async.close_BANG_.call(null,out);
var state_13198__$1 = (function (){var statearr_13206 = state_13198;
(statearr_13206[(9)] = inst_13195);

return statearr_13206;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13198__$1,inst_13196);
} else {
if((state_val_13199 === (2))){
var inst_13175 = (state_13198[(8)]);
var inst_13177 = (inst_13175 < n);
var state_13198__$1 = state_13198;
if(cljs.core.truth_(inst_13177)){
var statearr_13207_13230 = state_13198__$1;
(statearr_13207_13230[(1)] = (4));

} else {
var statearr_13208_13231 = state_13198__$1;
(statearr_13208_13231[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13199 === (11))){
var inst_13175 = (state_13198[(8)]);
var inst_13185 = (state_13198[(2)]);
var inst_13186 = (inst_13175 + (1));
var inst_13175__$1 = inst_13186;
var state_13198__$1 = (function (){var statearr_13209 = state_13198;
(statearr_13209[(10)] = inst_13185);

(statearr_13209[(8)] = inst_13175__$1);

return statearr_13209;
})();
var statearr_13210_13232 = state_13198__$1;
(statearr_13210_13232[(2)] = null);

(statearr_13210_13232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13199 === (9))){
var state_13198__$1 = state_13198;
var statearr_13211_13233 = state_13198__$1;
(statearr_13211_13233[(2)] = null);

(statearr_13211_13233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13199 === (5))){
var state_13198__$1 = state_13198;
var statearr_13212_13234 = state_13198__$1;
(statearr_13212_13234[(2)] = null);

(statearr_13212_13234[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13199 === (10))){
var inst_13190 = (state_13198[(2)]);
var state_13198__$1 = state_13198;
var statearr_13213_13235 = state_13198__$1;
(statearr_13213_13235[(2)] = inst_13190);

(statearr_13213_13235[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13199 === (8))){
var inst_13180 = (state_13198[(7)]);
var state_13198__$1 = state_13198;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13198__$1,(11),out,inst_13180);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___13225,out))
;
return ((function (switch__10949__auto__,c__11061__auto___13225,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_13217 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13217[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_13217[(1)] = (1));

return statearr_13217;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_13198){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_13198);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e13218){if((e13218 instanceof Object)){
var ex__10953__auto__ = e13218;
var statearr_13219_13236 = state_13198;
(statearr_13219_13236[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13198);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13218;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13237 = state_13198;
state_13198 = G__13237;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_13198){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_13198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___13225,out))
})();
var state__11063__auto__ = (function (){var statearr_13220 = f__11062__auto__.call(null);
(statearr_13220[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___13225);

return statearr_13220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___13225,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13245 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13245 = (function (map_LT_,f,ch,meta13246){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13246 = meta13246;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13247,meta13246__$1){
var self__ = this;
var _13247__$1 = this;
return (new cljs.core.async.t_cljs$core$async13245(self__.map_LT_,self__.f,self__.ch,meta13246__$1));
});

cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13247){
var self__ = this;
var _13247__$1 = this;
return self__.meta13246;
});

cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async13248 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13248 = (function (map_LT_,f,ch,meta13246,_,fn1,meta13249){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13246 = meta13246;
this._ = _;
this.fn1 = fn1;
this.meta13249 = meta13249;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13248.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13250,meta13249__$1){
var self__ = this;
var _13250__$1 = this;
return (new cljs.core.async.t_cljs$core$async13248(self__.map_LT_,self__.f,self__.ch,self__.meta13246,self__._,self__.fn1,meta13249__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async13248.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13250){
var self__ = this;
var _13250__$1 = this;
return self__.meta13249;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13248.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13248.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13248.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13248.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__13238_SHARP_){
return f1.call(null,(((p1__13238_SHARP_ == null))?null:self__.f.call(null,p1__13238_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async13248.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13246","meta13246",-1506668940,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13245","cljs.core.async/t_cljs$core$async13245",929199355,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13249","meta13249",-357855510,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13248.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13248.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13248";

cljs.core.async.t_cljs$core$async13248.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13248");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async13248 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13248(map_LT___$1,f__$1,ch__$1,meta13246__$1,___$2,fn1__$1,meta13249){
return (new cljs.core.async.t_cljs$core$async13248(map_LT___$1,f__$1,ch__$1,meta13246__$1,___$2,fn1__$1,meta13249));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async13248(self__.map_LT_,self__.f,self__.ch,self__.meta13246,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13245.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async13245.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13246","meta13246",-1506668940,null)], null);
});

cljs.core.async.t_cljs$core$async13245.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13245.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13245";

cljs.core.async.t_cljs$core$async13245.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13245");
});

cljs.core.async.__GT_t_cljs$core$async13245 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13245(map_LT___$1,f__$1,ch__$1,meta13246){
return (new cljs.core.async.t_cljs$core$async13245(map_LT___$1,f__$1,ch__$1,meta13246));
});

}

return (new cljs.core.async.t_cljs$core$async13245(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13254 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13254 = (function (map_GT_,f,ch,meta13255){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta13255 = meta13255;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13254.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13256,meta13255__$1){
var self__ = this;
var _13256__$1 = this;
return (new cljs.core.async.t_cljs$core$async13254(self__.map_GT_,self__.f,self__.ch,meta13255__$1));
});

cljs.core.async.t_cljs$core$async13254.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13256){
var self__ = this;
var _13256__$1 = this;
return self__.meta13255;
});

cljs.core.async.t_cljs$core$async13254.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13254.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13254.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13254.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13254.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13254.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async13254.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13255","meta13255",249616257,null)], null);
});

cljs.core.async.t_cljs$core$async13254.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13254.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13254";

cljs.core.async.t_cljs$core$async13254.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13254");
});

cljs.core.async.__GT_t_cljs$core$async13254 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13254(map_GT___$1,f__$1,ch__$1,meta13255){
return (new cljs.core.async.t_cljs$core$async13254(map_GT___$1,f__$1,ch__$1,meta13255));
});

}

return (new cljs.core.async.t_cljs$core$async13254(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async13260 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13260 = (function (filter_GT_,p,ch,meta13261){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13261 = meta13261;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13262,meta13261__$1){
var self__ = this;
var _13262__$1 = this;
return (new cljs.core.async.t_cljs$core$async13260(self__.filter_GT_,self__.p,self__.ch,meta13261__$1));
});

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13262){
var self__ = this;
var _13262__$1 = this;
return self__.meta13261;
});

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async13260.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13261","meta13261",-1189580685,null)], null);
});

cljs.core.async.t_cljs$core$async13260.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13260.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13260";

cljs.core.async.t_cljs$core$async13260.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13260");
});

cljs.core.async.__GT_t_cljs$core$async13260 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13260(filter_GT___$1,p__$1,ch__$1,meta13261){
return (new cljs.core.async.t_cljs$core$async13260(filter_GT___$1,p__$1,ch__$1,meta13261));
});

}

return (new cljs.core.async.t_cljs$core$async13260(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args13263 = [];
var len__5726__auto___13307 = arguments.length;
var i__5727__auto___13308 = (0);
while(true){
if((i__5727__auto___13308 < len__5726__auto___13307)){
args13263.push((arguments[i__5727__auto___13308]));

var G__13309 = (i__5727__auto___13308 + (1));
i__5727__auto___13308 = G__13309;
continue;
} else {
}
break;
}

var G__13265 = args13263.length;
switch (G__13265) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13263.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___13311 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___13311,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___13311,out){
return (function (state_13286){
var state_val_13287 = (state_13286[(1)]);
if((state_val_13287 === (7))){
var inst_13282 = (state_13286[(2)]);
var state_13286__$1 = state_13286;
var statearr_13288_13312 = state_13286__$1;
(statearr_13288_13312[(2)] = inst_13282);

(statearr_13288_13312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13287 === (1))){
var state_13286__$1 = state_13286;
var statearr_13289_13313 = state_13286__$1;
(statearr_13289_13313[(2)] = null);

(statearr_13289_13313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13287 === (4))){
var inst_13268 = (state_13286[(7)]);
var inst_13268__$1 = (state_13286[(2)]);
var inst_13269 = (inst_13268__$1 == null);
var state_13286__$1 = (function (){var statearr_13290 = state_13286;
(statearr_13290[(7)] = inst_13268__$1);

return statearr_13290;
})();
if(cljs.core.truth_(inst_13269)){
var statearr_13291_13314 = state_13286__$1;
(statearr_13291_13314[(1)] = (5));

} else {
var statearr_13292_13315 = state_13286__$1;
(statearr_13292_13315[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13287 === (6))){
var inst_13268 = (state_13286[(7)]);
var inst_13273 = p.call(null,inst_13268);
var state_13286__$1 = state_13286;
if(cljs.core.truth_(inst_13273)){
var statearr_13293_13316 = state_13286__$1;
(statearr_13293_13316[(1)] = (8));

} else {
var statearr_13294_13317 = state_13286__$1;
(statearr_13294_13317[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13287 === (3))){
var inst_13284 = (state_13286[(2)]);
var state_13286__$1 = state_13286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13286__$1,inst_13284);
} else {
if((state_val_13287 === (2))){
var state_13286__$1 = state_13286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13286__$1,(4),ch);
} else {
if((state_val_13287 === (11))){
var inst_13276 = (state_13286[(2)]);
var state_13286__$1 = state_13286;
var statearr_13295_13318 = state_13286__$1;
(statearr_13295_13318[(2)] = inst_13276);

(statearr_13295_13318[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13287 === (9))){
var state_13286__$1 = state_13286;
var statearr_13296_13319 = state_13286__$1;
(statearr_13296_13319[(2)] = null);

(statearr_13296_13319[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13287 === (5))){
var inst_13271 = cljs.core.async.close_BANG_.call(null,out);
var state_13286__$1 = state_13286;
var statearr_13297_13320 = state_13286__$1;
(statearr_13297_13320[(2)] = inst_13271);

(statearr_13297_13320[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13287 === (10))){
var inst_13279 = (state_13286[(2)]);
var state_13286__$1 = (function (){var statearr_13298 = state_13286;
(statearr_13298[(8)] = inst_13279);

return statearr_13298;
})();
var statearr_13299_13321 = state_13286__$1;
(statearr_13299_13321[(2)] = null);

(statearr_13299_13321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13287 === (8))){
var inst_13268 = (state_13286[(7)]);
var state_13286__$1 = state_13286;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13286__$1,(11),out,inst_13268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___13311,out))
;
return ((function (switch__10949__auto__,c__11061__auto___13311,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_13303 = [null,null,null,null,null,null,null,null,null];
(statearr_13303[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_13303[(1)] = (1));

return statearr_13303;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_13286){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_13286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e13304){if((e13304 instanceof Object)){
var ex__10953__auto__ = e13304;
var statearr_13305_13322 = state_13286;
(statearr_13305_13322[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13286);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13304;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13323 = state_13286;
state_13286 = G__13323;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_13286){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_13286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___13311,out))
})();
var state__11063__auto__ = (function (){var statearr_13306 = f__11062__auto__.call(null);
(statearr_13306[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___13311);

return statearr_13306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___13311,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args13324 = [];
var len__5726__auto___13327 = arguments.length;
var i__5727__auto___13328 = (0);
while(true){
if((i__5727__auto___13328 < len__5726__auto___13327)){
args13324.push((arguments[i__5727__auto___13328]));

var G__13329 = (i__5727__auto___13328 + (1));
i__5727__auto___13328 = G__13329;
continue;
} else {
}
break;
}

var G__13326 = args13324.length;
switch (G__13326) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13324.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11061__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto__){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto__){
return (function (state_13496){
var state_val_13497 = (state_13496[(1)]);
if((state_val_13497 === (7))){
var inst_13492 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13498_13539 = state_13496__$1;
(statearr_13498_13539[(2)] = inst_13492);

(statearr_13498_13539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (20))){
var inst_13462 = (state_13496[(7)]);
var inst_13473 = (state_13496[(2)]);
var inst_13474 = cljs.core.next.call(null,inst_13462);
var inst_13448 = inst_13474;
var inst_13449 = null;
var inst_13450 = (0);
var inst_13451 = (0);
var state_13496__$1 = (function (){var statearr_13499 = state_13496;
(statearr_13499[(8)] = inst_13451);

(statearr_13499[(9)] = inst_13450);

(statearr_13499[(10)] = inst_13449);

(statearr_13499[(11)] = inst_13473);

(statearr_13499[(12)] = inst_13448);

return statearr_13499;
})();
var statearr_13500_13540 = state_13496__$1;
(statearr_13500_13540[(2)] = null);

(statearr_13500_13540[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (1))){
var state_13496__$1 = state_13496;
var statearr_13501_13541 = state_13496__$1;
(statearr_13501_13541[(2)] = null);

(statearr_13501_13541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (4))){
var inst_13437 = (state_13496[(13)]);
var inst_13437__$1 = (state_13496[(2)]);
var inst_13438 = (inst_13437__$1 == null);
var state_13496__$1 = (function (){var statearr_13502 = state_13496;
(statearr_13502[(13)] = inst_13437__$1);

return statearr_13502;
})();
if(cljs.core.truth_(inst_13438)){
var statearr_13503_13542 = state_13496__$1;
(statearr_13503_13542[(1)] = (5));

} else {
var statearr_13504_13543 = state_13496__$1;
(statearr_13504_13543[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (15))){
var state_13496__$1 = state_13496;
var statearr_13508_13544 = state_13496__$1;
(statearr_13508_13544[(2)] = null);

(statearr_13508_13544[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (21))){
var state_13496__$1 = state_13496;
var statearr_13509_13545 = state_13496__$1;
(statearr_13509_13545[(2)] = null);

(statearr_13509_13545[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (13))){
var inst_13451 = (state_13496[(8)]);
var inst_13450 = (state_13496[(9)]);
var inst_13449 = (state_13496[(10)]);
var inst_13448 = (state_13496[(12)]);
var inst_13458 = (state_13496[(2)]);
var inst_13459 = (inst_13451 + (1));
var tmp13505 = inst_13450;
var tmp13506 = inst_13449;
var tmp13507 = inst_13448;
var inst_13448__$1 = tmp13507;
var inst_13449__$1 = tmp13506;
var inst_13450__$1 = tmp13505;
var inst_13451__$1 = inst_13459;
var state_13496__$1 = (function (){var statearr_13510 = state_13496;
(statearr_13510[(8)] = inst_13451__$1);

(statearr_13510[(9)] = inst_13450__$1);

(statearr_13510[(10)] = inst_13449__$1);

(statearr_13510[(14)] = inst_13458);

(statearr_13510[(12)] = inst_13448__$1);

return statearr_13510;
})();
var statearr_13511_13546 = state_13496__$1;
(statearr_13511_13546[(2)] = null);

(statearr_13511_13546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (22))){
var state_13496__$1 = state_13496;
var statearr_13512_13547 = state_13496__$1;
(statearr_13512_13547[(2)] = null);

(statearr_13512_13547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (6))){
var inst_13437 = (state_13496[(13)]);
var inst_13446 = f.call(null,inst_13437);
var inst_13447 = cljs.core.seq.call(null,inst_13446);
var inst_13448 = inst_13447;
var inst_13449 = null;
var inst_13450 = (0);
var inst_13451 = (0);
var state_13496__$1 = (function (){var statearr_13513 = state_13496;
(statearr_13513[(8)] = inst_13451);

(statearr_13513[(9)] = inst_13450);

(statearr_13513[(10)] = inst_13449);

(statearr_13513[(12)] = inst_13448);

return statearr_13513;
})();
var statearr_13514_13548 = state_13496__$1;
(statearr_13514_13548[(2)] = null);

(statearr_13514_13548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (17))){
var inst_13462 = (state_13496[(7)]);
var inst_13466 = cljs.core.chunk_first.call(null,inst_13462);
var inst_13467 = cljs.core.chunk_rest.call(null,inst_13462);
var inst_13468 = cljs.core.count.call(null,inst_13466);
var inst_13448 = inst_13467;
var inst_13449 = inst_13466;
var inst_13450 = inst_13468;
var inst_13451 = (0);
var state_13496__$1 = (function (){var statearr_13515 = state_13496;
(statearr_13515[(8)] = inst_13451);

(statearr_13515[(9)] = inst_13450);

(statearr_13515[(10)] = inst_13449);

(statearr_13515[(12)] = inst_13448);

return statearr_13515;
})();
var statearr_13516_13549 = state_13496__$1;
(statearr_13516_13549[(2)] = null);

(statearr_13516_13549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (3))){
var inst_13494 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13496__$1,inst_13494);
} else {
if((state_val_13497 === (12))){
var inst_13482 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13517_13550 = state_13496__$1;
(statearr_13517_13550[(2)] = inst_13482);

(statearr_13517_13550[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (2))){
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13496__$1,(4),in$);
} else {
if((state_val_13497 === (23))){
var inst_13490 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13518_13551 = state_13496__$1;
(statearr_13518_13551[(2)] = inst_13490);

(statearr_13518_13551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (19))){
var inst_13477 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13519_13552 = state_13496__$1;
(statearr_13519_13552[(2)] = inst_13477);

(statearr_13519_13552[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (11))){
var inst_13462 = (state_13496[(7)]);
var inst_13448 = (state_13496[(12)]);
var inst_13462__$1 = cljs.core.seq.call(null,inst_13448);
var state_13496__$1 = (function (){var statearr_13520 = state_13496;
(statearr_13520[(7)] = inst_13462__$1);

return statearr_13520;
})();
if(inst_13462__$1){
var statearr_13521_13553 = state_13496__$1;
(statearr_13521_13553[(1)] = (14));

} else {
var statearr_13522_13554 = state_13496__$1;
(statearr_13522_13554[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (9))){
var inst_13484 = (state_13496[(2)]);
var inst_13485 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13496__$1 = (function (){var statearr_13523 = state_13496;
(statearr_13523[(15)] = inst_13484);

return statearr_13523;
})();
if(cljs.core.truth_(inst_13485)){
var statearr_13524_13555 = state_13496__$1;
(statearr_13524_13555[(1)] = (21));

} else {
var statearr_13525_13556 = state_13496__$1;
(statearr_13525_13556[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (5))){
var inst_13440 = cljs.core.async.close_BANG_.call(null,out);
var state_13496__$1 = state_13496;
var statearr_13526_13557 = state_13496__$1;
(statearr_13526_13557[(2)] = inst_13440);

(statearr_13526_13557[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (14))){
var inst_13462 = (state_13496[(7)]);
var inst_13464 = cljs.core.chunked_seq_QMARK_.call(null,inst_13462);
var state_13496__$1 = state_13496;
if(inst_13464){
var statearr_13527_13558 = state_13496__$1;
(statearr_13527_13558[(1)] = (17));

} else {
var statearr_13528_13559 = state_13496__$1;
(statearr_13528_13559[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (16))){
var inst_13480 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13529_13560 = state_13496__$1;
(statearr_13529_13560[(2)] = inst_13480);

(statearr_13529_13560[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (10))){
var inst_13451 = (state_13496[(8)]);
var inst_13449 = (state_13496[(10)]);
var inst_13456 = cljs.core._nth.call(null,inst_13449,inst_13451);
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13496__$1,(13),out,inst_13456);
} else {
if((state_val_13497 === (18))){
var inst_13462 = (state_13496[(7)]);
var inst_13471 = cljs.core.first.call(null,inst_13462);
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13496__$1,(20),out,inst_13471);
} else {
if((state_val_13497 === (8))){
var inst_13451 = (state_13496[(8)]);
var inst_13450 = (state_13496[(9)]);
var inst_13453 = (inst_13451 < inst_13450);
var inst_13454 = inst_13453;
var state_13496__$1 = state_13496;
if(cljs.core.truth_(inst_13454)){
var statearr_13530_13561 = state_13496__$1;
(statearr_13530_13561[(1)] = (10));

} else {
var statearr_13531_13562 = state_13496__$1;
(statearr_13531_13562[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto__))
;
return ((function (switch__10949__auto__,c__11061__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_13535 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13535[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__);

(statearr_13535[(1)] = (1));

return statearr_13535;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____1 = (function (state_13496){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_13496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e13536){if((e13536 instanceof Object)){
var ex__10953__auto__ = e13536;
var statearr_13537_13563 = state_13496;
(statearr_13537_13563[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13536;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13564 = state_13496;
state_13496 = G__13564;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__ = function(state_13496){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____1.call(this,state_13496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto__))
})();
var state__11063__auto__ = (function (){var statearr_13538 = f__11062__auto__.call(null);
(statearr_13538[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto__);

return statearr_13538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto__))
);

return c__11061__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13565 = [];
var len__5726__auto___13568 = arguments.length;
var i__5727__auto___13569 = (0);
while(true){
if((i__5727__auto___13569 < len__5726__auto___13568)){
args13565.push((arguments[i__5727__auto___13569]));

var G__13570 = (i__5727__auto___13569 + (1));
i__5727__auto___13569 = G__13570;
continue;
} else {
}
break;
}

var G__13567 = args13565.length;
switch (G__13567) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13565.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13572 = [];
var len__5726__auto___13575 = arguments.length;
var i__5727__auto___13576 = (0);
while(true){
if((i__5727__auto___13576 < len__5726__auto___13575)){
args13572.push((arguments[i__5727__auto___13576]));

var G__13577 = (i__5727__auto___13576 + (1));
i__5727__auto___13576 = G__13577;
continue;
} else {
}
break;
}

var G__13574 = args13572.length;
switch (G__13574) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13572.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13579 = [];
var len__5726__auto___13630 = arguments.length;
var i__5727__auto___13631 = (0);
while(true){
if((i__5727__auto___13631 < len__5726__auto___13630)){
args13579.push((arguments[i__5727__auto___13631]));

var G__13632 = (i__5727__auto___13631 + (1));
i__5727__auto___13631 = G__13632;
continue;
} else {
}
break;
}

var G__13581 = args13579.length;
switch (G__13581) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13579.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___13634 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___13634,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___13634,out){
return (function (state_13605){
var state_val_13606 = (state_13605[(1)]);
if((state_val_13606 === (7))){
var inst_13600 = (state_13605[(2)]);
var state_13605__$1 = state_13605;
var statearr_13607_13635 = state_13605__$1;
(statearr_13607_13635[(2)] = inst_13600);

(statearr_13607_13635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13606 === (1))){
var inst_13582 = null;
var state_13605__$1 = (function (){var statearr_13608 = state_13605;
(statearr_13608[(7)] = inst_13582);

return statearr_13608;
})();
var statearr_13609_13636 = state_13605__$1;
(statearr_13609_13636[(2)] = null);

(statearr_13609_13636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13606 === (4))){
var inst_13585 = (state_13605[(8)]);
var inst_13585__$1 = (state_13605[(2)]);
var inst_13586 = (inst_13585__$1 == null);
var inst_13587 = cljs.core.not.call(null,inst_13586);
var state_13605__$1 = (function (){var statearr_13610 = state_13605;
(statearr_13610[(8)] = inst_13585__$1);

return statearr_13610;
})();
if(inst_13587){
var statearr_13611_13637 = state_13605__$1;
(statearr_13611_13637[(1)] = (5));

} else {
var statearr_13612_13638 = state_13605__$1;
(statearr_13612_13638[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13606 === (6))){
var state_13605__$1 = state_13605;
var statearr_13613_13639 = state_13605__$1;
(statearr_13613_13639[(2)] = null);

(statearr_13613_13639[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13606 === (3))){
var inst_13602 = (state_13605[(2)]);
var inst_13603 = cljs.core.async.close_BANG_.call(null,out);
var state_13605__$1 = (function (){var statearr_13614 = state_13605;
(statearr_13614[(9)] = inst_13602);

return statearr_13614;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13605__$1,inst_13603);
} else {
if((state_val_13606 === (2))){
var state_13605__$1 = state_13605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13605__$1,(4),ch);
} else {
if((state_val_13606 === (11))){
var inst_13585 = (state_13605[(8)]);
var inst_13594 = (state_13605[(2)]);
var inst_13582 = inst_13585;
var state_13605__$1 = (function (){var statearr_13615 = state_13605;
(statearr_13615[(7)] = inst_13582);

(statearr_13615[(10)] = inst_13594);

return statearr_13615;
})();
var statearr_13616_13640 = state_13605__$1;
(statearr_13616_13640[(2)] = null);

(statearr_13616_13640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13606 === (9))){
var inst_13585 = (state_13605[(8)]);
var state_13605__$1 = state_13605;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13605__$1,(11),out,inst_13585);
} else {
if((state_val_13606 === (5))){
var inst_13582 = (state_13605[(7)]);
var inst_13585 = (state_13605[(8)]);
var inst_13589 = cljs.core._EQ_.call(null,inst_13585,inst_13582);
var state_13605__$1 = state_13605;
if(inst_13589){
var statearr_13618_13641 = state_13605__$1;
(statearr_13618_13641[(1)] = (8));

} else {
var statearr_13619_13642 = state_13605__$1;
(statearr_13619_13642[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13606 === (10))){
var inst_13597 = (state_13605[(2)]);
var state_13605__$1 = state_13605;
var statearr_13620_13643 = state_13605__$1;
(statearr_13620_13643[(2)] = inst_13597);

(statearr_13620_13643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13606 === (8))){
var inst_13582 = (state_13605[(7)]);
var tmp13617 = inst_13582;
var inst_13582__$1 = tmp13617;
var state_13605__$1 = (function (){var statearr_13621 = state_13605;
(statearr_13621[(7)] = inst_13582__$1);

return statearr_13621;
})();
var statearr_13622_13644 = state_13605__$1;
(statearr_13622_13644[(2)] = null);

(statearr_13622_13644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___13634,out))
;
return ((function (switch__10949__auto__,c__11061__auto___13634,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_13626 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13626[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_13626[(1)] = (1));

return statearr_13626;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_13605){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_13605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e13627){if((e13627 instanceof Object)){
var ex__10953__auto__ = e13627;
var statearr_13628_13645 = state_13605;
(statearr_13628_13645[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13605);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13646 = state_13605;
state_13605 = G__13646;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_13605){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_13605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___13634,out))
})();
var state__11063__auto__ = (function (){var statearr_13629 = f__11062__auto__.call(null);
(statearr_13629[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___13634);

return statearr_13629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___13634,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13647 = [];
var len__5726__auto___13717 = arguments.length;
var i__5727__auto___13718 = (0);
while(true){
if((i__5727__auto___13718 < len__5726__auto___13717)){
args13647.push((arguments[i__5727__auto___13718]));

var G__13719 = (i__5727__auto___13718 + (1));
i__5727__auto___13718 = G__13719;
continue;
} else {
}
break;
}

var G__13649 = args13647.length;
switch (G__13649) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13647.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___13721 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___13721,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___13721,out){
return (function (state_13687){
var state_val_13688 = (state_13687[(1)]);
if((state_val_13688 === (7))){
var inst_13683 = (state_13687[(2)]);
var state_13687__$1 = state_13687;
var statearr_13689_13722 = state_13687__$1;
(statearr_13689_13722[(2)] = inst_13683);

(statearr_13689_13722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (1))){
var inst_13650 = (new Array(n));
var inst_13651 = inst_13650;
var inst_13652 = (0);
var state_13687__$1 = (function (){var statearr_13690 = state_13687;
(statearr_13690[(7)] = inst_13651);

(statearr_13690[(8)] = inst_13652);

return statearr_13690;
})();
var statearr_13691_13723 = state_13687__$1;
(statearr_13691_13723[(2)] = null);

(statearr_13691_13723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (4))){
var inst_13655 = (state_13687[(9)]);
var inst_13655__$1 = (state_13687[(2)]);
var inst_13656 = (inst_13655__$1 == null);
var inst_13657 = cljs.core.not.call(null,inst_13656);
var state_13687__$1 = (function (){var statearr_13692 = state_13687;
(statearr_13692[(9)] = inst_13655__$1);

return statearr_13692;
})();
if(inst_13657){
var statearr_13693_13724 = state_13687__$1;
(statearr_13693_13724[(1)] = (5));

} else {
var statearr_13694_13725 = state_13687__$1;
(statearr_13694_13725[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (15))){
var inst_13677 = (state_13687[(2)]);
var state_13687__$1 = state_13687;
var statearr_13695_13726 = state_13687__$1;
(statearr_13695_13726[(2)] = inst_13677);

(statearr_13695_13726[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (13))){
var state_13687__$1 = state_13687;
var statearr_13696_13727 = state_13687__$1;
(statearr_13696_13727[(2)] = null);

(statearr_13696_13727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (6))){
var inst_13652 = (state_13687[(8)]);
var inst_13673 = (inst_13652 > (0));
var state_13687__$1 = state_13687;
if(cljs.core.truth_(inst_13673)){
var statearr_13697_13728 = state_13687__$1;
(statearr_13697_13728[(1)] = (12));

} else {
var statearr_13698_13729 = state_13687__$1;
(statearr_13698_13729[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (3))){
var inst_13685 = (state_13687[(2)]);
var state_13687__$1 = state_13687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13687__$1,inst_13685);
} else {
if((state_val_13688 === (12))){
var inst_13651 = (state_13687[(7)]);
var inst_13675 = cljs.core.vec.call(null,inst_13651);
var state_13687__$1 = state_13687;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13687__$1,(15),out,inst_13675);
} else {
if((state_val_13688 === (2))){
var state_13687__$1 = state_13687;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13687__$1,(4),ch);
} else {
if((state_val_13688 === (11))){
var inst_13667 = (state_13687[(2)]);
var inst_13668 = (new Array(n));
var inst_13651 = inst_13668;
var inst_13652 = (0);
var state_13687__$1 = (function (){var statearr_13699 = state_13687;
(statearr_13699[(7)] = inst_13651);

(statearr_13699[(10)] = inst_13667);

(statearr_13699[(8)] = inst_13652);

return statearr_13699;
})();
var statearr_13700_13730 = state_13687__$1;
(statearr_13700_13730[(2)] = null);

(statearr_13700_13730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (9))){
var inst_13651 = (state_13687[(7)]);
var inst_13665 = cljs.core.vec.call(null,inst_13651);
var state_13687__$1 = state_13687;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13687__$1,(11),out,inst_13665);
} else {
if((state_val_13688 === (5))){
var inst_13655 = (state_13687[(9)]);
var inst_13651 = (state_13687[(7)]);
var inst_13660 = (state_13687[(11)]);
var inst_13652 = (state_13687[(8)]);
var inst_13659 = (inst_13651[inst_13652] = inst_13655);
var inst_13660__$1 = (inst_13652 + (1));
var inst_13661 = (inst_13660__$1 < n);
var state_13687__$1 = (function (){var statearr_13701 = state_13687;
(statearr_13701[(12)] = inst_13659);

(statearr_13701[(11)] = inst_13660__$1);

return statearr_13701;
})();
if(cljs.core.truth_(inst_13661)){
var statearr_13702_13731 = state_13687__$1;
(statearr_13702_13731[(1)] = (8));

} else {
var statearr_13703_13732 = state_13687__$1;
(statearr_13703_13732[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (14))){
var inst_13680 = (state_13687[(2)]);
var inst_13681 = cljs.core.async.close_BANG_.call(null,out);
var state_13687__$1 = (function (){var statearr_13705 = state_13687;
(statearr_13705[(13)] = inst_13680);

return statearr_13705;
})();
var statearr_13706_13733 = state_13687__$1;
(statearr_13706_13733[(2)] = inst_13681);

(statearr_13706_13733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (10))){
var inst_13671 = (state_13687[(2)]);
var state_13687__$1 = state_13687;
var statearr_13707_13734 = state_13687__$1;
(statearr_13707_13734[(2)] = inst_13671);

(statearr_13707_13734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13688 === (8))){
var inst_13651 = (state_13687[(7)]);
var inst_13660 = (state_13687[(11)]);
var tmp13704 = inst_13651;
var inst_13651__$1 = tmp13704;
var inst_13652 = inst_13660;
var state_13687__$1 = (function (){var statearr_13708 = state_13687;
(statearr_13708[(7)] = inst_13651__$1);

(statearr_13708[(8)] = inst_13652);

return statearr_13708;
})();
var statearr_13709_13735 = state_13687__$1;
(statearr_13709_13735[(2)] = null);

(statearr_13709_13735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___13721,out))
;
return ((function (switch__10949__auto__,c__11061__auto___13721,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_13713 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13713[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_13713[(1)] = (1));

return statearr_13713;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_13687){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_13687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e13714){if((e13714 instanceof Object)){
var ex__10953__auto__ = e13714;
var statearr_13715_13736 = state_13687;
(statearr_13715_13736[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13687);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13714;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13737 = state_13687;
state_13687 = G__13737;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_13687){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_13687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___13721,out))
})();
var state__11063__auto__ = (function (){var statearr_13716 = f__11062__auto__.call(null);
(statearr_13716[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___13721);

return statearr_13716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___13721,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13738 = [];
var len__5726__auto___13812 = arguments.length;
var i__5727__auto___13813 = (0);
while(true){
if((i__5727__auto___13813 < len__5726__auto___13812)){
args13738.push((arguments[i__5727__auto___13813]));

var G__13814 = (i__5727__auto___13813 + (1));
i__5727__auto___13813 = G__13814;
continue;
} else {
}
break;
}

var G__13740 = args13738.length;
switch (G__13740) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13738.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___13816 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___13816,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___13816,out){
return (function (state_13782){
var state_val_13783 = (state_13782[(1)]);
if((state_val_13783 === (7))){
var inst_13778 = (state_13782[(2)]);
var state_13782__$1 = state_13782;
var statearr_13784_13817 = state_13782__$1;
(statearr_13784_13817[(2)] = inst_13778);

(statearr_13784_13817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (1))){
var inst_13741 = [];
var inst_13742 = inst_13741;
var inst_13743 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13782__$1 = (function (){var statearr_13785 = state_13782;
(statearr_13785[(7)] = inst_13742);

(statearr_13785[(8)] = inst_13743);

return statearr_13785;
})();
var statearr_13786_13818 = state_13782__$1;
(statearr_13786_13818[(2)] = null);

(statearr_13786_13818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (4))){
var inst_13746 = (state_13782[(9)]);
var inst_13746__$1 = (state_13782[(2)]);
var inst_13747 = (inst_13746__$1 == null);
var inst_13748 = cljs.core.not.call(null,inst_13747);
var state_13782__$1 = (function (){var statearr_13787 = state_13782;
(statearr_13787[(9)] = inst_13746__$1);

return statearr_13787;
})();
if(inst_13748){
var statearr_13788_13819 = state_13782__$1;
(statearr_13788_13819[(1)] = (5));

} else {
var statearr_13789_13820 = state_13782__$1;
(statearr_13789_13820[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (15))){
var inst_13772 = (state_13782[(2)]);
var state_13782__$1 = state_13782;
var statearr_13790_13821 = state_13782__$1;
(statearr_13790_13821[(2)] = inst_13772);

(statearr_13790_13821[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (13))){
var state_13782__$1 = state_13782;
var statearr_13791_13822 = state_13782__$1;
(statearr_13791_13822[(2)] = null);

(statearr_13791_13822[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (6))){
var inst_13742 = (state_13782[(7)]);
var inst_13767 = inst_13742.length;
var inst_13768 = (inst_13767 > (0));
var state_13782__$1 = state_13782;
if(cljs.core.truth_(inst_13768)){
var statearr_13792_13823 = state_13782__$1;
(statearr_13792_13823[(1)] = (12));

} else {
var statearr_13793_13824 = state_13782__$1;
(statearr_13793_13824[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (3))){
var inst_13780 = (state_13782[(2)]);
var state_13782__$1 = state_13782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13782__$1,inst_13780);
} else {
if((state_val_13783 === (12))){
var inst_13742 = (state_13782[(7)]);
var inst_13770 = cljs.core.vec.call(null,inst_13742);
var state_13782__$1 = state_13782;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13782__$1,(15),out,inst_13770);
} else {
if((state_val_13783 === (2))){
var state_13782__$1 = state_13782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13782__$1,(4),ch);
} else {
if((state_val_13783 === (11))){
var inst_13746 = (state_13782[(9)]);
var inst_13750 = (state_13782[(10)]);
var inst_13760 = (state_13782[(2)]);
var inst_13761 = [];
var inst_13762 = inst_13761.push(inst_13746);
var inst_13742 = inst_13761;
var inst_13743 = inst_13750;
var state_13782__$1 = (function (){var statearr_13794 = state_13782;
(statearr_13794[(11)] = inst_13760);

(statearr_13794[(7)] = inst_13742);

(statearr_13794[(12)] = inst_13762);

(statearr_13794[(8)] = inst_13743);

return statearr_13794;
})();
var statearr_13795_13825 = state_13782__$1;
(statearr_13795_13825[(2)] = null);

(statearr_13795_13825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (9))){
var inst_13742 = (state_13782[(7)]);
var inst_13758 = cljs.core.vec.call(null,inst_13742);
var state_13782__$1 = state_13782;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13782__$1,(11),out,inst_13758);
} else {
if((state_val_13783 === (5))){
var inst_13746 = (state_13782[(9)]);
var inst_13750 = (state_13782[(10)]);
var inst_13743 = (state_13782[(8)]);
var inst_13750__$1 = f.call(null,inst_13746);
var inst_13751 = cljs.core._EQ_.call(null,inst_13750__$1,inst_13743);
var inst_13752 = cljs.core.keyword_identical_QMARK_.call(null,inst_13743,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13753 = (inst_13751) || (inst_13752);
var state_13782__$1 = (function (){var statearr_13796 = state_13782;
(statearr_13796[(10)] = inst_13750__$1);

return statearr_13796;
})();
if(cljs.core.truth_(inst_13753)){
var statearr_13797_13826 = state_13782__$1;
(statearr_13797_13826[(1)] = (8));

} else {
var statearr_13798_13827 = state_13782__$1;
(statearr_13798_13827[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (14))){
var inst_13775 = (state_13782[(2)]);
var inst_13776 = cljs.core.async.close_BANG_.call(null,out);
var state_13782__$1 = (function (){var statearr_13800 = state_13782;
(statearr_13800[(13)] = inst_13775);

return statearr_13800;
})();
var statearr_13801_13828 = state_13782__$1;
(statearr_13801_13828[(2)] = inst_13776);

(statearr_13801_13828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (10))){
var inst_13765 = (state_13782[(2)]);
var state_13782__$1 = state_13782;
var statearr_13802_13829 = state_13782__$1;
(statearr_13802_13829[(2)] = inst_13765);

(statearr_13802_13829[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13783 === (8))){
var inst_13742 = (state_13782[(7)]);
var inst_13746 = (state_13782[(9)]);
var inst_13750 = (state_13782[(10)]);
var inst_13755 = inst_13742.push(inst_13746);
var tmp13799 = inst_13742;
var inst_13742__$1 = tmp13799;
var inst_13743 = inst_13750;
var state_13782__$1 = (function (){var statearr_13803 = state_13782;
(statearr_13803[(7)] = inst_13742__$1);

(statearr_13803[(14)] = inst_13755);

(statearr_13803[(8)] = inst_13743);

return statearr_13803;
})();
var statearr_13804_13830 = state_13782__$1;
(statearr_13804_13830[(2)] = null);

(statearr_13804_13830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___13816,out))
;
return ((function (switch__10949__auto__,c__11061__auto___13816,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_13808 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13808[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_13808[(1)] = (1));

return statearr_13808;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_13782){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_13782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e13809){if((e13809 instanceof Object)){
var ex__10953__auto__ = e13809;
var statearr_13810_13831 = state_13782;
(statearr_13810_13831[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13782);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13809;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13832 = state_13782;
state_13782 = G__13832;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_13782){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_13782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___13816,out))
})();
var state__11063__auto__ = (function (){var statearr_13811 = f__11062__auto__.call(null);
(statearr_13811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___13816);

return statearr_13811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___13816,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1455098327962