// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18924 = [];
var len__5726__auto___18930 = arguments.length;
var i__5727__auto___18931 = (0);
while(true){
if((i__5727__auto___18931 < len__5726__auto___18930)){
args18924.push((arguments[i__5727__auto___18931]));

var G__18932 = (i__5727__auto___18931 + (1));
i__5727__auto___18931 = G__18932;
continue;
} else {
}
break;
}

var G__18926 = args18924.length;
switch (G__18926) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18924.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18927 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18927 = (function (f,blockable,meta18928){
this.f = f;
this.blockable = blockable;
this.meta18928 = meta18928;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18927.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18929,meta18928__$1){
var self__ = this;
var _18929__$1 = this;
return (new cljs.core.async.t_cljs$core$async18927(self__.f,self__.blockable,meta18928__$1));
});

cljs.core.async.t_cljs$core$async18927.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18929){
var self__ = this;
var _18929__$1 = this;
return self__.meta18928;
});

cljs.core.async.t_cljs$core$async18927.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18927.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18927.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18927.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18927.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18928","meta18928",698711978,null)], null);
});

cljs.core.async.t_cljs$core$async18927.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18927.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18927";

cljs.core.async.t_cljs$core$async18927.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18927");
});

cljs.core.async.__GT_t_cljs$core$async18927 = (function cljs$core$async$__GT_t_cljs$core$async18927(f__$1,blockable__$1,meta18928){
return (new cljs.core.async.t_cljs$core$async18927(f__$1,blockable__$1,meta18928));
});

}

return (new cljs.core.async.t_cljs$core$async18927(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args18936 = [];
var len__5726__auto___18939 = arguments.length;
var i__5727__auto___18940 = (0);
while(true){
if((i__5727__auto___18940 < len__5726__auto___18939)){
args18936.push((arguments[i__5727__auto___18940]));

var G__18941 = (i__5727__auto___18940 + (1));
i__5727__auto___18940 = G__18941;
continue;
} else {
}
break;
}

var G__18938 = args18936.length;
switch (G__18938) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18936.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args18943 = [];
var len__5726__auto___18946 = arguments.length;
var i__5727__auto___18947 = (0);
while(true){
if((i__5727__auto___18947 < len__5726__auto___18946)){
args18943.push((arguments[i__5727__auto___18947]));

var G__18948 = (i__5727__auto___18947 + (1));
i__5727__auto___18947 = G__18948;
continue;
} else {
}
break;
}

var G__18945 = args18943.length;
switch (G__18945) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18943.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args18950 = [];
var len__5726__auto___18953 = arguments.length;
var i__5727__auto___18954 = (0);
while(true){
if((i__5727__auto___18954 < len__5726__auto___18953)){
args18950.push((arguments[i__5727__auto___18954]));

var G__18955 = (i__5727__auto___18954 + (1));
i__5727__auto___18954 = G__18955;
continue;
} else {
}
break;
}

var G__18952 = args18950.length;
switch (G__18952) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18950.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_18957 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_18957);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_18957,ret){
return (function (){
return fn1.call(null,val_18957);
});})(val_18957,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args18958 = [];
var len__5726__auto___18961 = arguments.length;
var i__5727__auto___18962 = (0);
while(true){
if((i__5727__auto___18962 < len__5726__auto___18961)){
args18958.push((arguments[i__5727__auto___18962]));

var G__18963 = (i__5727__auto___18962 + (1));
i__5727__auto___18962 = G__18963;
continue;
} else {
}
break;
}

var G__18960 = args18958.length;
switch (G__18960) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18958.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___18965 = n;
var x_18966 = (0);
while(true){
if((x_18966 < n__5571__auto___18965)){
(a[x_18966] = (0));

var G__18967 = (x_18966 + (1));
x_18966 = G__18967;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__18968 = (i + (1));
i = G__18968;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async18972 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18972 = (function (alt_flag,flag,meta18973){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta18973 = meta18973;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18972.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_18974,meta18973__$1){
var self__ = this;
var _18974__$1 = this;
return (new cljs.core.async.t_cljs$core$async18972(self__.alt_flag,self__.flag,meta18973__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async18972.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_18974){
var self__ = this;
var _18974__$1 = this;
return self__.meta18973;
});})(flag))
;

cljs.core.async.t_cljs$core$async18972.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18972.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async18972.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18972.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18972.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta18973","meta18973",-1863518891,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async18972.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18972.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18972";

cljs.core.async.t_cljs$core$async18972.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18972");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async18972 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18972(alt_flag__$1,flag__$1,meta18973){
return (new cljs.core.async.t_cljs$core$async18972(alt_flag__$1,flag__$1,meta18973));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async18972(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async18978 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18978 = (function (alt_handler,flag,cb,meta18979){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta18979 = meta18979;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18978.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18980,meta18979__$1){
var self__ = this;
var _18980__$1 = this;
return (new cljs.core.async.t_cljs$core$async18978(self__.alt_handler,self__.flag,self__.cb,meta18979__$1));
});

cljs.core.async.t_cljs$core$async18978.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18980){
var self__ = this;
var _18980__$1 = this;
return self__.meta18979;
});

cljs.core.async.t_cljs$core$async18978.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18978.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async18978.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18978.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async18978.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta18979","meta18979",1108931746,null)], null);
});

cljs.core.async.t_cljs$core$async18978.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18978.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18978";

cljs.core.async.t_cljs$core$async18978.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18978");
});

cljs.core.async.__GT_t_cljs$core$async18978 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18978(alt_handler__$1,flag__$1,cb__$1,meta18979){
return (new cljs.core.async.t_cljs$core$async18978(alt_handler__$1,flag__$1,cb__$1,meta18979));
});

}

return (new cljs.core.async.t_cljs$core$async18978(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18981_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18981_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18982_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18982_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18983 = (i + (1));
i = G__18983;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18989 = arguments.length;
var i__5727__auto___18990 = (0);
while(true){
if((i__5727__auto___18990 < len__5726__auto___18989)){
args__5733__auto__.push((arguments[i__5727__auto___18990]));

var G__18991 = (i__5727__auto___18990 + (1));
i__5727__auto___18990 = G__18991;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18986){
var map__18987 = p__18986;
var map__18987__$1 = ((((!((map__18987 == null)))?((((map__18987.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18987.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18987):map__18987);
var opts = map__18987__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18984){
var G__18985 = cljs.core.first.call(null,seq18984);
var seq18984__$1 = cljs.core.next.call(null,seq18984);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18985,seq18984__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args18992 = [];
var len__5726__auto___19042 = arguments.length;
var i__5727__auto___19043 = (0);
while(true){
if((i__5727__auto___19043 < len__5726__auto___19042)){
args18992.push((arguments[i__5727__auto___19043]));

var G__19044 = (i__5727__auto___19043 + (1));
i__5727__auto___19043 = G__19044;
continue;
} else {
}
break;
}

var G__18994 = args18992.length;
switch (G__18994) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18992.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11061__auto___19046 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___19046){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___19046){
return (function (state_19018){
var state_val_19019 = (state_19018[(1)]);
if((state_val_19019 === (7))){
var inst_19014 = (state_19018[(2)]);
var state_19018__$1 = state_19018;
var statearr_19020_19047 = state_19018__$1;
(statearr_19020_19047[(2)] = inst_19014);

(statearr_19020_19047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (1))){
var state_19018__$1 = state_19018;
var statearr_19021_19048 = state_19018__$1;
(statearr_19021_19048[(2)] = null);

(statearr_19021_19048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (4))){
var inst_18997 = (state_19018[(7)]);
var inst_18997__$1 = (state_19018[(2)]);
var inst_18998 = (inst_18997__$1 == null);
var state_19018__$1 = (function (){var statearr_19022 = state_19018;
(statearr_19022[(7)] = inst_18997__$1);

return statearr_19022;
})();
if(cljs.core.truth_(inst_18998)){
var statearr_19023_19049 = state_19018__$1;
(statearr_19023_19049[(1)] = (5));

} else {
var statearr_19024_19050 = state_19018__$1;
(statearr_19024_19050[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (13))){
var state_19018__$1 = state_19018;
var statearr_19025_19051 = state_19018__$1;
(statearr_19025_19051[(2)] = null);

(statearr_19025_19051[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (6))){
var inst_18997 = (state_19018[(7)]);
var state_19018__$1 = state_19018;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19018__$1,(11),to,inst_18997);
} else {
if((state_val_19019 === (3))){
var inst_19016 = (state_19018[(2)]);
var state_19018__$1 = state_19018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19018__$1,inst_19016);
} else {
if((state_val_19019 === (12))){
var state_19018__$1 = state_19018;
var statearr_19026_19052 = state_19018__$1;
(statearr_19026_19052[(2)] = null);

(statearr_19026_19052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (2))){
var state_19018__$1 = state_19018;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19018__$1,(4),from);
} else {
if((state_val_19019 === (11))){
var inst_19007 = (state_19018[(2)]);
var state_19018__$1 = state_19018;
if(cljs.core.truth_(inst_19007)){
var statearr_19027_19053 = state_19018__$1;
(statearr_19027_19053[(1)] = (12));

} else {
var statearr_19028_19054 = state_19018__$1;
(statearr_19028_19054[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (9))){
var state_19018__$1 = state_19018;
var statearr_19029_19055 = state_19018__$1;
(statearr_19029_19055[(2)] = null);

(statearr_19029_19055[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (5))){
var state_19018__$1 = state_19018;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19030_19056 = state_19018__$1;
(statearr_19030_19056[(1)] = (8));

} else {
var statearr_19031_19057 = state_19018__$1;
(statearr_19031_19057[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (14))){
var inst_19012 = (state_19018[(2)]);
var state_19018__$1 = state_19018;
var statearr_19032_19058 = state_19018__$1;
(statearr_19032_19058[(2)] = inst_19012);

(statearr_19032_19058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (10))){
var inst_19004 = (state_19018[(2)]);
var state_19018__$1 = state_19018;
var statearr_19033_19059 = state_19018__$1;
(statearr_19033_19059[(2)] = inst_19004);

(statearr_19033_19059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (8))){
var inst_19001 = cljs.core.async.close_BANG_.call(null,to);
var state_19018__$1 = state_19018;
var statearr_19034_19060 = state_19018__$1;
(statearr_19034_19060[(2)] = inst_19001);

(statearr_19034_19060[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___19046))
;
return ((function (switch__10949__auto__,c__11061__auto___19046){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_19038 = [null,null,null,null,null,null,null,null];
(statearr_19038[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_19038[(1)] = (1));

return statearr_19038;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_19018){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19039){if((e19039 instanceof Object)){
var ex__10953__auto__ = e19039;
var statearr_19040_19061 = state_19018;
(statearr_19040_19061[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19018);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19062 = state_19018;
state_19018 = G__19062;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_19018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_19018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___19046))
})();
var state__11063__auto__ = (function (){var statearr_19041 = f__11062__auto__.call(null);
(statearr_19041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___19046);

return statearr_19041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___19046))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19246){
var vec__19247 = p__19246;
var v = cljs.core.nth.call(null,vec__19247,(0),null);
var p = cljs.core.nth.call(null,vec__19247,(1),null);
var job = vec__19247;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11061__auto___19429 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___19429,res,vec__19247,v,p,job,jobs,results){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___19429,res,vec__19247,v,p,job,jobs,results){
return (function (state_19252){
var state_val_19253 = (state_19252[(1)]);
if((state_val_19253 === (1))){
var state_19252__$1 = state_19252;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19252__$1,(2),res,v);
} else {
if((state_val_19253 === (2))){
var inst_19249 = (state_19252[(2)]);
var inst_19250 = cljs.core.async.close_BANG_.call(null,res);
var state_19252__$1 = (function (){var statearr_19254 = state_19252;
(statearr_19254[(7)] = inst_19249);

return statearr_19254;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19252__$1,inst_19250);
} else {
return null;
}
}
});})(c__11061__auto___19429,res,vec__19247,v,p,job,jobs,results))
;
return ((function (switch__10949__auto__,c__11061__auto___19429,res,vec__19247,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_19258 = [null,null,null,null,null,null,null,null];
(statearr_19258[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_19258[(1)] = (1));

return statearr_19258;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_19252){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19252);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19259){if((e19259 instanceof Object)){
var ex__10953__auto__ = e19259;
var statearr_19260_19430 = state_19252;
(statearr_19260_19430[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19252);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19259;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19431 = state_19252;
state_19252 = G__19431;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_19252){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_19252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___19429,res,vec__19247,v,p,job,jobs,results))
})();
var state__11063__auto__ = (function (){var statearr_19261 = f__11062__auto__.call(null);
(statearr_19261[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___19429);

return statearr_19261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___19429,res,vec__19247,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19262){
var vec__19263 = p__19262;
var v = cljs.core.nth.call(null,vec__19263,(0),null);
var p = cljs.core.nth.call(null,vec__19263,(1),null);
var job = vec__19263;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___19432 = n;
var __19433 = (0);
while(true){
if((__19433 < n__5571__auto___19432)){
var G__19264_19434 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19264_19434) {
case "compute":
var c__11061__auto___19436 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19433,c__11061__auto___19436,G__19264_19434,n__5571__auto___19432,jobs,results,process,async){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (__19433,c__11061__auto___19436,G__19264_19434,n__5571__auto___19432,jobs,results,process,async){
return (function (state_19277){
var state_val_19278 = (state_19277[(1)]);
if((state_val_19278 === (1))){
var state_19277__$1 = state_19277;
var statearr_19279_19437 = state_19277__$1;
(statearr_19279_19437[(2)] = null);

(statearr_19279_19437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19278 === (2))){
var state_19277__$1 = state_19277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19277__$1,(4),jobs);
} else {
if((state_val_19278 === (3))){
var inst_19275 = (state_19277[(2)]);
var state_19277__$1 = state_19277;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19277__$1,inst_19275);
} else {
if((state_val_19278 === (4))){
var inst_19267 = (state_19277[(2)]);
var inst_19268 = process.call(null,inst_19267);
var state_19277__$1 = state_19277;
if(cljs.core.truth_(inst_19268)){
var statearr_19280_19438 = state_19277__$1;
(statearr_19280_19438[(1)] = (5));

} else {
var statearr_19281_19439 = state_19277__$1;
(statearr_19281_19439[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19278 === (5))){
var state_19277__$1 = state_19277;
var statearr_19282_19440 = state_19277__$1;
(statearr_19282_19440[(2)] = null);

(statearr_19282_19440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19278 === (6))){
var state_19277__$1 = state_19277;
var statearr_19283_19441 = state_19277__$1;
(statearr_19283_19441[(2)] = null);

(statearr_19283_19441[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19278 === (7))){
var inst_19273 = (state_19277[(2)]);
var state_19277__$1 = state_19277;
var statearr_19284_19442 = state_19277__$1;
(statearr_19284_19442[(2)] = inst_19273);

(statearr_19284_19442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19433,c__11061__auto___19436,G__19264_19434,n__5571__auto___19432,jobs,results,process,async))
;
return ((function (__19433,switch__10949__auto__,c__11061__auto___19436,G__19264_19434,n__5571__auto___19432,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_19288 = [null,null,null,null,null,null,null];
(statearr_19288[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_19288[(1)] = (1));

return statearr_19288;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_19277){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19277);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19289){if((e19289 instanceof Object)){
var ex__10953__auto__ = e19289;
var statearr_19290_19443 = state_19277;
(statearr_19290_19443[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19277);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19289;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19444 = state_19277;
state_19277 = G__19444;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_19277){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_19277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(__19433,switch__10949__auto__,c__11061__auto___19436,G__19264_19434,n__5571__auto___19432,jobs,results,process,async))
})();
var state__11063__auto__ = (function (){var statearr_19291 = f__11062__auto__.call(null);
(statearr_19291[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___19436);

return statearr_19291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(__19433,c__11061__auto___19436,G__19264_19434,n__5571__auto___19432,jobs,results,process,async))
);


break;
case "async":
var c__11061__auto___19445 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19433,c__11061__auto___19445,G__19264_19434,n__5571__auto___19432,jobs,results,process,async){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (__19433,c__11061__auto___19445,G__19264_19434,n__5571__auto___19432,jobs,results,process,async){
return (function (state_19304){
var state_val_19305 = (state_19304[(1)]);
if((state_val_19305 === (1))){
var state_19304__$1 = state_19304;
var statearr_19306_19446 = state_19304__$1;
(statearr_19306_19446[(2)] = null);

(statearr_19306_19446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19305 === (2))){
var state_19304__$1 = state_19304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19304__$1,(4),jobs);
} else {
if((state_val_19305 === (3))){
var inst_19302 = (state_19304[(2)]);
var state_19304__$1 = state_19304;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19304__$1,inst_19302);
} else {
if((state_val_19305 === (4))){
var inst_19294 = (state_19304[(2)]);
var inst_19295 = async.call(null,inst_19294);
var state_19304__$1 = state_19304;
if(cljs.core.truth_(inst_19295)){
var statearr_19307_19447 = state_19304__$1;
(statearr_19307_19447[(1)] = (5));

} else {
var statearr_19308_19448 = state_19304__$1;
(statearr_19308_19448[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19305 === (5))){
var state_19304__$1 = state_19304;
var statearr_19309_19449 = state_19304__$1;
(statearr_19309_19449[(2)] = null);

(statearr_19309_19449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19305 === (6))){
var state_19304__$1 = state_19304;
var statearr_19310_19450 = state_19304__$1;
(statearr_19310_19450[(2)] = null);

(statearr_19310_19450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19305 === (7))){
var inst_19300 = (state_19304[(2)]);
var state_19304__$1 = state_19304;
var statearr_19311_19451 = state_19304__$1;
(statearr_19311_19451[(2)] = inst_19300);

(statearr_19311_19451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19433,c__11061__auto___19445,G__19264_19434,n__5571__auto___19432,jobs,results,process,async))
;
return ((function (__19433,switch__10949__auto__,c__11061__auto___19445,G__19264_19434,n__5571__auto___19432,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_19315 = [null,null,null,null,null,null,null];
(statearr_19315[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_19315[(1)] = (1));

return statearr_19315;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_19304){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19316){if((e19316 instanceof Object)){
var ex__10953__auto__ = e19316;
var statearr_19317_19452 = state_19304;
(statearr_19317_19452[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19304);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19316;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19453 = state_19304;
state_19304 = G__19453;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_19304){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_19304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(__19433,switch__10949__auto__,c__11061__auto___19445,G__19264_19434,n__5571__auto___19432,jobs,results,process,async))
})();
var state__11063__auto__ = (function (){var statearr_19318 = f__11062__auto__.call(null);
(statearr_19318[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___19445);

return statearr_19318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(__19433,c__11061__auto___19445,G__19264_19434,n__5571__auto___19432,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19454 = (__19433 + (1));
__19433 = G__19454;
continue;
} else {
}
break;
}

var c__11061__auto___19455 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___19455,jobs,results,process,async){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___19455,jobs,results,process,async){
return (function (state_19340){
var state_val_19341 = (state_19340[(1)]);
if((state_val_19341 === (1))){
var state_19340__$1 = state_19340;
var statearr_19342_19456 = state_19340__$1;
(statearr_19342_19456[(2)] = null);

(statearr_19342_19456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19341 === (2))){
var state_19340__$1 = state_19340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19340__$1,(4),from);
} else {
if((state_val_19341 === (3))){
var inst_19338 = (state_19340[(2)]);
var state_19340__$1 = state_19340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19340__$1,inst_19338);
} else {
if((state_val_19341 === (4))){
var inst_19321 = (state_19340[(7)]);
var inst_19321__$1 = (state_19340[(2)]);
var inst_19322 = (inst_19321__$1 == null);
var state_19340__$1 = (function (){var statearr_19343 = state_19340;
(statearr_19343[(7)] = inst_19321__$1);

return statearr_19343;
})();
if(cljs.core.truth_(inst_19322)){
var statearr_19344_19457 = state_19340__$1;
(statearr_19344_19457[(1)] = (5));

} else {
var statearr_19345_19458 = state_19340__$1;
(statearr_19345_19458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19341 === (5))){
var inst_19324 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19340__$1 = state_19340;
var statearr_19346_19459 = state_19340__$1;
(statearr_19346_19459[(2)] = inst_19324);

(statearr_19346_19459[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19341 === (6))){
var inst_19321 = (state_19340[(7)]);
var inst_19326 = (state_19340[(8)]);
var inst_19326__$1 = cljs.core.async.chan.call(null,(1));
var inst_19327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19328 = [inst_19321,inst_19326__$1];
var inst_19329 = (new cljs.core.PersistentVector(null,2,(5),inst_19327,inst_19328,null));
var state_19340__$1 = (function (){var statearr_19347 = state_19340;
(statearr_19347[(8)] = inst_19326__$1);

return statearr_19347;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19340__$1,(8),jobs,inst_19329);
} else {
if((state_val_19341 === (7))){
var inst_19336 = (state_19340[(2)]);
var state_19340__$1 = state_19340;
var statearr_19348_19460 = state_19340__$1;
(statearr_19348_19460[(2)] = inst_19336);

(statearr_19348_19460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19341 === (8))){
var inst_19326 = (state_19340[(8)]);
var inst_19331 = (state_19340[(2)]);
var state_19340__$1 = (function (){var statearr_19349 = state_19340;
(statearr_19349[(9)] = inst_19331);

return statearr_19349;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19340__$1,(9),results,inst_19326);
} else {
if((state_val_19341 === (9))){
var inst_19333 = (state_19340[(2)]);
var state_19340__$1 = (function (){var statearr_19350 = state_19340;
(statearr_19350[(10)] = inst_19333);

return statearr_19350;
})();
var statearr_19351_19461 = state_19340__$1;
(statearr_19351_19461[(2)] = null);

(statearr_19351_19461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___19455,jobs,results,process,async))
;
return ((function (switch__10949__auto__,c__11061__auto___19455,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_19355 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19355[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_19355[(1)] = (1));

return statearr_19355;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_19340){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19356){if((e19356 instanceof Object)){
var ex__10953__auto__ = e19356;
var statearr_19357_19462 = state_19340;
(statearr_19357_19462[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19340);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19356;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19463 = state_19340;
state_19340 = G__19463;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_19340){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_19340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___19455,jobs,results,process,async))
})();
var state__11063__auto__ = (function (){var statearr_19358 = f__11062__auto__.call(null);
(statearr_19358[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___19455);

return statearr_19358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___19455,jobs,results,process,async))
);


var c__11061__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto__,jobs,results,process,async){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto__,jobs,results,process,async){
return (function (state_19396){
var state_val_19397 = (state_19396[(1)]);
if((state_val_19397 === (7))){
var inst_19392 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19398_19464 = state_19396__$1;
(statearr_19398_19464[(2)] = inst_19392);

(statearr_19398_19464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (20))){
var state_19396__$1 = state_19396;
var statearr_19399_19465 = state_19396__$1;
(statearr_19399_19465[(2)] = null);

(statearr_19399_19465[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (1))){
var state_19396__$1 = state_19396;
var statearr_19400_19466 = state_19396__$1;
(statearr_19400_19466[(2)] = null);

(statearr_19400_19466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (4))){
var inst_19361 = (state_19396[(7)]);
var inst_19361__$1 = (state_19396[(2)]);
var inst_19362 = (inst_19361__$1 == null);
var state_19396__$1 = (function (){var statearr_19401 = state_19396;
(statearr_19401[(7)] = inst_19361__$1);

return statearr_19401;
})();
if(cljs.core.truth_(inst_19362)){
var statearr_19402_19467 = state_19396__$1;
(statearr_19402_19467[(1)] = (5));

} else {
var statearr_19403_19468 = state_19396__$1;
(statearr_19403_19468[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (15))){
var inst_19374 = (state_19396[(8)]);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19396__$1,(18),to,inst_19374);
} else {
if((state_val_19397 === (21))){
var inst_19387 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19404_19469 = state_19396__$1;
(statearr_19404_19469[(2)] = inst_19387);

(statearr_19404_19469[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (13))){
var inst_19389 = (state_19396[(2)]);
var state_19396__$1 = (function (){var statearr_19405 = state_19396;
(statearr_19405[(9)] = inst_19389);

return statearr_19405;
})();
var statearr_19406_19470 = state_19396__$1;
(statearr_19406_19470[(2)] = null);

(statearr_19406_19470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (6))){
var inst_19361 = (state_19396[(7)]);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19396__$1,(11),inst_19361);
} else {
if((state_val_19397 === (17))){
var inst_19382 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
if(cljs.core.truth_(inst_19382)){
var statearr_19407_19471 = state_19396__$1;
(statearr_19407_19471[(1)] = (19));

} else {
var statearr_19408_19472 = state_19396__$1;
(statearr_19408_19472[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (3))){
var inst_19394 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19396__$1,inst_19394);
} else {
if((state_val_19397 === (12))){
var inst_19371 = (state_19396[(10)]);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19396__$1,(14),inst_19371);
} else {
if((state_val_19397 === (2))){
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19396__$1,(4),results);
} else {
if((state_val_19397 === (19))){
var state_19396__$1 = state_19396;
var statearr_19409_19473 = state_19396__$1;
(statearr_19409_19473[(2)] = null);

(statearr_19409_19473[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (11))){
var inst_19371 = (state_19396[(2)]);
var state_19396__$1 = (function (){var statearr_19410 = state_19396;
(statearr_19410[(10)] = inst_19371);

return statearr_19410;
})();
var statearr_19411_19474 = state_19396__$1;
(statearr_19411_19474[(2)] = null);

(statearr_19411_19474[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (9))){
var state_19396__$1 = state_19396;
var statearr_19412_19475 = state_19396__$1;
(statearr_19412_19475[(2)] = null);

(statearr_19412_19475[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (5))){
var state_19396__$1 = state_19396;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19413_19476 = state_19396__$1;
(statearr_19413_19476[(1)] = (8));

} else {
var statearr_19414_19477 = state_19396__$1;
(statearr_19414_19477[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (14))){
var inst_19376 = (state_19396[(11)]);
var inst_19374 = (state_19396[(8)]);
var inst_19374__$1 = (state_19396[(2)]);
var inst_19375 = (inst_19374__$1 == null);
var inst_19376__$1 = cljs.core.not.call(null,inst_19375);
var state_19396__$1 = (function (){var statearr_19415 = state_19396;
(statearr_19415[(11)] = inst_19376__$1);

(statearr_19415[(8)] = inst_19374__$1);

return statearr_19415;
})();
if(inst_19376__$1){
var statearr_19416_19478 = state_19396__$1;
(statearr_19416_19478[(1)] = (15));

} else {
var statearr_19417_19479 = state_19396__$1;
(statearr_19417_19479[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (16))){
var inst_19376 = (state_19396[(11)]);
var state_19396__$1 = state_19396;
var statearr_19418_19480 = state_19396__$1;
(statearr_19418_19480[(2)] = inst_19376);

(statearr_19418_19480[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (10))){
var inst_19368 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19419_19481 = state_19396__$1;
(statearr_19419_19481[(2)] = inst_19368);

(statearr_19419_19481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (18))){
var inst_19379 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19420_19482 = state_19396__$1;
(statearr_19420_19482[(2)] = inst_19379);

(statearr_19420_19482[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (8))){
var inst_19365 = cljs.core.async.close_BANG_.call(null,to);
var state_19396__$1 = state_19396;
var statearr_19421_19483 = state_19396__$1;
(statearr_19421_19483[(2)] = inst_19365);

(statearr_19421_19483[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto__,jobs,results,process,async))
;
return ((function (switch__10949__auto__,c__11061__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_19425 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19425[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__);

(statearr_19425[(1)] = (1));

return statearr_19425;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1 = (function (state_19396){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19426){if((e19426 instanceof Object)){
var ex__10953__auto__ = e19426;
var statearr_19427_19484 = state_19396;
(statearr_19427_19484[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19426;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19485 = state_19396;
state_19396 = G__19485;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__ = function(state_19396){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1.call(this,state_19396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto__,jobs,results,process,async))
})();
var state__11063__auto__ = (function (){var statearr_19428 = f__11062__auto__.call(null);
(statearr_19428[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto__);

return statearr_19428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto__,jobs,results,process,async))
);

return c__11061__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19486 = [];
var len__5726__auto___19489 = arguments.length;
var i__5727__auto___19490 = (0);
while(true){
if((i__5727__auto___19490 < len__5726__auto___19489)){
args19486.push((arguments[i__5727__auto___19490]));

var G__19491 = (i__5727__auto___19490 + (1));
i__5727__auto___19490 = G__19491;
continue;
} else {
}
break;
}

var G__19488 = args19486.length;
switch (G__19488) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19486.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19493 = [];
var len__5726__auto___19496 = arguments.length;
var i__5727__auto___19497 = (0);
while(true){
if((i__5727__auto___19497 < len__5726__auto___19496)){
args19493.push((arguments[i__5727__auto___19497]));

var G__19498 = (i__5727__auto___19497 + (1));
i__5727__auto___19497 = G__19498;
continue;
} else {
}
break;
}

var G__19495 = args19493.length;
switch (G__19495) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19493.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19500 = [];
var len__5726__auto___19553 = arguments.length;
var i__5727__auto___19554 = (0);
while(true){
if((i__5727__auto___19554 < len__5726__auto___19553)){
args19500.push((arguments[i__5727__auto___19554]));

var G__19555 = (i__5727__auto___19554 + (1));
i__5727__auto___19554 = G__19555;
continue;
} else {
}
break;
}

var G__19502 = args19500.length;
switch (G__19502) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19500.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11061__auto___19557 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___19557,tc,fc){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___19557,tc,fc){
return (function (state_19528){
var state_val_19529 = (state_19528[(1)]);
if((state_val_19529 === (7))){
var inst_19524 = (state_19528[(2)]);
var state_19528__$1 = state_19528;
var statearr_19530_19558 = state_19528__$1;
(statearr_19530_19558[(2)] = inst_19524);

(statearr_19530_19558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (1))){
var state_19528__$1 = state_19528;
var statearr_19531_19559 = state_19528__$1;
(statearr_19531_19559[(2)] = null);

(statearr_19531_19559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (4))){
var inst_19505 = (state_19528[(7)]);
var inst_19505__$1 = (state_19528[(2)]);
var inst_19506 = (inst_19505__$1 == null);
var state_19528__$1 = (function (){var statearr_19532 = state_19528;
(statearr_19532[(7)] = inst_19505__$1);

return statearr_19532;
})();
if(cljs.core.truth_(inst_19506)){
var statearr_19533_19560 = state_19528__$1;
(statearr_19533_19560[(1)] = (5));

} else {
var statearr_19534_19561 = state_19528__$1;
(statearr_19534_19561[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (13))){
var state_19528__$1 = state_19528;
var statearr_19535_19562 = state_19528__$1;
(statearr_19535_19562[(2)] = null);

(statearr_19535_19562[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (6))){
var inst_19505 = (state_19528[(7)]);
var inst_19511 = p.call(null,inst_19505);
var state_19528__$1 = state_19528;
if(cljs.core.truth_(inst_19511)){
var statearr_19536_19563 = state_19528__$1;
(statearr_19536_19563[(1)] = (9));

} else {
var statearr_19537_19564 = state_19528__$1;
(statearr_19537_19564[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (3))){
var inst_19526 = (state_19528[(2)]);
var state_19528__$1 = state_19528;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19528__$1,inst_19526);
} else {
if((state_val_19529 === (12))){
var state_19528__$1 = state_19528;
var statearr_19538_19565 = state_19528__$1;
(statearr_19538_19565[(2)] = null);

(statearr_19538_19565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (2))){
var state_19528__$1 = state_19528;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19528__$1,(4),ch);
} else {
if((state_val_19529 === (11))){
var inst_19505 = (state_19528[(7)]);
var inst_19515 = (state_19528[(2)]);
var state_19528__$1 = state_19528;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19528__$1,(8),inst_19515,inst_19505);
} else {
if((state_val_19529 === (9))){
var state_19528__$1 = state_19528;
var statearr_19539_19566 = state_19528__$1;
(statearr_19539_19566[(2)] = tc);

(statearr_19539_19566[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (5))){
var inst_19508 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19509 = cljs.core.async.close_BANG_.call(null,fc);
var state_19528__$1 = (function (){var statearr_19540 = state_19528;
(statearr_19540[(8)] = inst_19508);

return statearr_19540;
})();
var statearr_19541_19567 = state_19528__$1;
(statearr_19541_19567[(2)] = inst_19509);

(statearr_19541_19567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (14))){
var inst_19522 = (state_19528[(2)]);
var state_19528__$1 = state_19528;
var statearr_19542_19568 = state_19528__$1;
(statearr_19542_19568[(2)] = inst_19522);

(statearr_19542_19568[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (10))){
var state_19528__$1 = state_19528;
var statearr_19543_19569 = state_19528__$1;
(statearr_19543_19569[(2)] = fc);

(statearr_19543_19569[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (8))){
var inst_19517 = (state_19528[(2)]);
var state_19528__$1 = state_19528;
if(cljs.core.truth_(inst_19517)){
var statearr_19544_19570 = state_19528__$1;
(statearr_19544_19570[(1)] = (12));

} else {
var statearr_19545_19571 = state_19528__$1;
(statearr_19545_19571[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___19557,tc,fc))
;
return ((function (switch__10949__auto__,c__11061__auto___19557,tc,fc){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_19549 = [null,null,null,null,null,null,null,null,null];
(statearr_19549[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_19549[(1)] = (1));

return statearr_19549;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_19528){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19550){if((e19550 instanceof Object)){
var ex__10953__auto__ = e19550;
var statearr_19551_19572 = state_19528;
(statearr_19551_19572[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19528);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19550;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19573 = state_19528;
state_19528 = G__19573;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_19528){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_19528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___19557,tc,fc))
})();
var state__11063__auto__ = (function (){var statearr_19552 = f__11062__auto__.call(null);
(statearr_19552[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___19557);

return statearr_19552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___19557,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11061__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto__){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto__){
return (function (state_19637){
var state_val_19638 = (state_19637[(1)]);
if((state_val_19638 === (7))){
var inst_19633 = (state_19637[(2)]);
var state_19637__$1 = state_19637;
var statearr_19639_19660 = state_19637__$1;
(statearr_19639_19660[(2)] = inst_19633);

(statearr_19639_19660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19638 === (1))){
var inst_19617 = init;
var state_19637__$1 = (function (){var statearr_19640 = state_19637;
(statearr_19640[(7)] = inst_19617);

return statearr_19640;
})();
var statearr_19641_19661 = state_19637__$1;
(statearr_19641_19661[(2)] = null);

(statearr_19641_19661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19638 === (4))){
var inst_19620 = (state_19637[(8)]);
var inst_19620__$1 = (state_19637[(2)]);
var inst_19621 = (inst_19620__$1 == null);
var state_19637__$1 = (function (){var statearr_19642 = state_19637;
(statearr_19642[(8)] = inst_19620__$1);

return statearr_19642;
})();
if(cljs.core.truth_(inst_19621)){
var statearr_19643_19662 = state_19637__$1;
(statearr_19643_19662[(1)] = (5));

} else {
var statearr_19644_19663 = state_19637__$1;
(statearr_19644_19663[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19638 === (6))){
var inst_19620 = (state_19637[(8)]);
var inst_19624 = (state_19637[(9)]);
var inst_19617 = (state_19637[(7)]);
var inst_19624__$1 = f.call(null,inst_19617,inst_19620);
var inst_19625 = cljs.core.reduced_QMARK_.call(null,inst_19624__$1);
var state_19637__$1 = (function (){var statearr_19645 = state_19637;
(statearr_19645[(9)] = inst_19624__$1);

return statearr_19645;
})();
if(inst_19625){
var statearr_19646_19664 = state_19637__$1;
(statearr_19646_19664[(1)] = (8));

} else {
var statearr_19647_19665 = state_19637__$1;
(statearr_19647_19665[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19638 === (3))){
var inst_19635 = (state_19637[(2)]);
var state_19637__$1 = state_19637;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19637__$1,inst_19635);
} else {
if((state_val_19638 === (2))){
var state_19637__$1 = state_19637;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19637__$1,(4),ch);
} else {
if((state_val_19638 === (9))){
var inst_19624 = (state_19637[(9)]);
var inst_19617 = inst_19624;
var state_19637__$1 = (function (){var statearr_19648 = state_19637;
(statearr_19648[(7)] = inst_19617);

return statearr_19648;
})();
var statearr_19649_19666 = state_19637__$1;
(statearr_19649_19666[(2)] = null);

(statearr_19649_19666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19638 === (5))){
var inst_19617 = (state_19637[(7)]);
var state_19637__$1 = state_19637;
var statearr_19650_19667 = state_19637__$1;
(statearr_19650_19667[(2)] = inst_19617);

(statearr_19650_19667[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19638 === (10))){
var inst_19631 = (state_19637[(2)]);
var state_19637__$1 = state_19637;
var statearr_19651_19668 = state_19637__$1;
(statearr_19651_19668[(2)] = inst_19631);

(statearr_19651_19668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19638 === (8))){
var inst_19624 = (state_19637[(9)]);
var inst_19627 = cljs.core.deref.call(null,inst_19624);
var state_19637__$1 = state_19637;
var statearr_19652_19669 = state_19637__$1;
(statearr_19652_19669[(2)] = inst_19627);

(statearr_19652_19669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto__))
;
return ((function (switch__10949__auto__,c__11061__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10950__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10950__auto____0 = (function (){
var statearr_19656 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19656[(0)] = cljs$core$async$reduce_$_state_machine__10950__auto__);

(statearr_19656[(1)] = (1));

return statearr_19656;
});
var cljs$core$async$reduce_$_state_machine__10950__auto____1 = (function (state_19637){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19637);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19657){if((e19657 instanceof Object)){
var ex__10953__auto__ = e19657;
var statearr_19658_19670 = state_19637;
(statearr_19658_19670[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19637);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19657;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19671 = state_19637;
state_19637 = G__19671;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10950__auto__ = function(state_19637){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10950__auto____1.call(this,state_19637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10950__auto____0;
cljs$core$async$reduce_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10950__auto____1;
return cljs$core$async$reduce_$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto__))
})();
var state__11063__auto__ = (function (){var statearr_19659 = f__11062__auto__.call(null);
(statearr_19659[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto__);

return statearr_19659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto__))
);

return c__11061__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19672 = [];
var len__5726__auto___19724 = arguments.length;
var i__5727__auto___19725 = (0);
while(true){
if((i__5727__auto___19725 < len__5726__auto___19724)){
args19672.push((arguments[i__5727__auto___19725]));

var G__19726 = (i__5727__auto___19725 + (1));
i__5727__auto___19725 = G__19726;
continue;
} else {
}
break;
}

var G__19674 = args19672.length;
switch (G__19674) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19672.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11061__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto__){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto__){
return (function (state_19699){
var state_val_19700 = (state_19699[(1)]);
if((state_val_19700 === (7))){
var inst_19681 = (state_19699[(2)]);
var state_19699__$1 = state_19699;
var statearr_19701_19728 = state_19699__$1;
(statearr_19701_19728[(2)] = inst_19681);

(statearr_19701_19728[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (1))){
var inst_19675 = cljs.core.seq.call(null,coll);
var inst_19676 = inst_19675;
var state_19699__$1 = (function (){var statearr_19702 = state_19699;
(statearr_19702[(7)] = inst_19676);

return statearr_19702;
})();
var statearr_19703_19729 = state_19699__$1;
(statearr_19703_19729[(2)] = null);

(statearr_19703_19729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (4))){
var inst_19676 = (state_19699[(7)]);
var inst_19679 = cljs.core.first.call(null,inst_19676);
var state_19699__$1 = state_19699;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19699__$1,(7),ch,inst_19679);
} else {
if((state_val_19700 === (13))){
var inst_19693 = (state_19699[(2)]);
var state_19699__$1 = state_19699;
var statearr_19704_19730 = state_19699__$1;
(statearr_19704_19730[(2)] = inst_19693);

(statearr_19704_19730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (6))){
var inst_19684 = (state_19699[(2)]);
var state_19699__$1 = state_19699;
if(cljs.core.truth_(inst_19684)){
var statearr_19705_19731 = state_19699__$1;
(statearr_19705_19731[(1)] = (8));

} else {
var statearr_19706_19732 = state_19699__$1;
(statearr_19706_19732[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (3))){
var inst_19697 = (state_19699[(2)]);
var state_19699__$1 = state_19699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19699__$1,inst_19697);
} else {
if((state_val_19700 === (12))){
var state_19699__$1 = state_19699;
var statearr_19707_19733 = state_19699__$1;
(statearr_19707_19733[(2)] = null);

(statearr_19707_19733[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (2))){
var inst_19676 = (state_19699[(7)]);
var state_19699__$1 = state_19699;
if(cljs.core.truth_(inst_19676)){
var statearr_19708_19734 = state_19699__$1;
(statearr_19708_19734[(1)] = (4));

} else {
var statearr_19709_19735 = state_19699__$1;
(statearr_19709_19735[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (11))){
var inst_19690 = cljs.core.async.close_BANG_.call(null,ch);
var state_19699__$1 = state_19699;
var statearr_19710_19736 = state_19699__$1;
(statearr_19710_19736[(2)] = inst_19690);

(statearr_19710_19736[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (9))){
var state_19699__$1 = state_19699;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19711_19737 = state_19699__$1;
(statearr_19711_19737[(1)] = (11));

} else {
var statearr_19712_19738 = state_19699__$1;
(statearr_19712_19738[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (5))){
var inst_19676 = (state_19699[(7)]);
var state_19699__$1 = state_19699;
var statearr_19713_19739 = state_19699__$1;
(statearr_19713_19739[(2)] = inst_19676);

(statearr_19713_19739[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (10))){
var inst_19695 = (state_19699[(2)]);
var state_19699__$1 = state_19699;
var statearr_19714_19740 = state_19699__$1;
(statearr_19714_19740[(2)] = inst_19695);

(statearr_19714_19740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19700 === (8))){
var inst_19676 = (state_19699[(7)]);
var inst_19686 = cljs.core.next.call(null,inst_19676);
var inst_19676__$1 = inst_19686;
var state_19699__$1 = (function (){var statearr_19715 = state_19699;
(statearr_19715[(7)] = inst_19676__$1);

return statearr_19715;
})();
var statearr_19716_19741 = state_19699__$1;
(statearr_19716_19741[(2)] = null);

(statearr_19716_19741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto__))
;
return ((function (switch__10949__auto__,c__11061__auto__){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_19720 = [null,null,null,null,null,null,null,null];
(statearr_19720[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_19720[(1)] = (1));

return statearr_19720;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_19699){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_19699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e19721){if((e19721 instanceof Object)){
var ex__10953__auto__ = e19721;
var statearr_19722_19742 = state_19699;
(statearr_19722_19742[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19699);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19721;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19743 = state_19699;
state_19699 = G__19743;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_19699){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_19699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto__))
})();
var state__11063__auto__ = (function (){var statearr_19723 = f__11062__auto__.call(null);
(statearr_19723[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto__);

return statearr_19723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto__))
);

return c__11061__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19965 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19965 = (function (mult,ch,cs,meta19966){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta19966 = meta19966;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19965.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_19967,meta19966__$1){
var self__ = this;
var _19967__$1 = this;
return (new cljs.core.async.t_cljs$core$async19965(self__.mult,self__.ch,self__.cs,meta19966__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async19965.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_19967){
var self__ = this;
var _19967__$1 = this;
return self__.meta19966;
});})(cs))
;

cljs.core.async.t_cljs$core$async19965.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19965.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async19965.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async19965.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19965.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19965.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19965.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta19966","meta19966",-58880955,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async19965.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19965.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19965";

cljs.core.async.t_cljs$core$async19965.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19965");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async19965 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async19965(mult__$1,ch__$1,cs__$1,meta19966){
return (new cljs.core.async.t_cljs$core$async19965(mult__$1,ch__$1,cs__$1,meta19966));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async19965(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11061__auto___20186 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___20186,cs,m,dchan,dctr,done){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___20186,cs,m,dchan,dctr,done){
return (function (state_20098){
var state_val_20099 = (state_20098[(1)]);
if((state_val_20099 === (7))){
var inst_20094 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20100_20187 = state_20098__$1;
(statearr_20100_20187[(2)] = inst_20094);

(statearr_20100_20187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (20))){
var inst_19999 = (state_20098[(7)]);
var inst_20009 = cljs.core.first.call(null,inst_19999);
var inst_20010 = cljs.core.nth.call(null,inst_20009,(0),null);
var inst_20011 = cljs.core.nth.call(null,inst_20009,(1),null);
var state_20098__$1 = (function (){var statearr_20101 = state_20098;
(statearr_20101[(8)] = inst_20010);

return statearr_20101;
})();
if(cljs.core.truth_(inst_20011)){
var statearr_20102_20188 = state_20098__$1;
(statearr_20102_20188[(1)] = (22));

} else {
var statearr_20103_20189 = state_20098__$1;
(statearr_20103_20189[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (27))){
var inst_20039 = (state_20098[(9)]);
var inst_20041 = (state_20098[(10)]);
var inst_20046 = (state_20098[(11)]);
var inst_19970 = (state_20098[(12)]);
var inst_20046__$1 = cljs.core._nth.call(null,inst_20039,inst_20041);
var inst_20047 = cljs.core.async.put_BANG_.call(null,inst_20046__$1,inst_19970,done);
var state_20098__$1 = (function (){var statearr_20104 = state_20098;
(statearr_20104[(11)] = inst_20046__$1);

return statearr_20104;
})();
if(cljs.core.truth_(inst_20047)){
var statearr_20105_20190 = state_20098__$1;
(statearr_20105_20190[(1)] = (30));

} else {
var statearr_20106_20191 = state_20098__$1;
(statearr_20106_20191[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (1))){
var state_20098__$1 = state_20098;
var statearr_20107_20192 = state_20098__$1;
(statearr_20107_20192[(2)] = null);

(statearr_20107_20192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (24))){
var inst_19999 = (state_20098[(7)]);
var inst_20016 = (state_20098[(2)]);
var inst_20017 = cljs.core.next.call(null,inst_19999);
var inst_19979 = inst_20017;
var inst_19980 = null;
var inst_19981 = (0);
var inst_19982 = (0);
var state_20098__$1 = (function (){var statearr_20108 = state_20098;
(statearr_20108[(13)] = inst_19979);

(statearr_20108[(14)] = inst_19982);

(statearr_20108[(15)] = inst_20016);

(statearr_20108[(16)] = inst_19980);

(statearr_20108[(17)] = inst_19981);

return statearr_20108;
})();
var statearr_20109_20193 = state_20098__$1;
(statearr_20109_20193[(2)] = null);

(statearr_20109_20193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (39))){
var state_20098__$1 = state_20098;
var statearr_20113_20194 = state_20098__$1;
(statearr_20113_20194[(2)] = null);

(statearr_20113_20194[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (4))){
var inst_19970 = (state_20098[(12)]);
var inst_19970__$1 = (state_20098[(2)]);
var inst_19971 = (inst_19970__$1 == null);
var state_20098__$1 = (function (){var statearr_20114 = state_20098;
(statearr_20114[(12)] = inst_19970__$1);

return statearr_20114;
})();
if(cljs.core.truth_(inst_19971)){
var statearr_20115_20195 = state_20098__$1;
(statearr_20115_20195[(1)] = (5));

} else {
var statearr_20116_20196 = state_20098__$1;
(statearr_20116_20196[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (15))){
var inst_19979 = (state_20098[(13)]);
var inst_19982 = (state_20098[(14)]);
var inst_19980 = (state_20098[(16)]);
var inst_19981 = (state_20098[(17)]);
var inst_19995 = (state_20098[(2)]);
var inst_19996 = (inst_19982 + (1));
var tmp20110 = inst_19979;
var tmp20111 = inst_19980;
var tmp20112 = inst_19981;
var inst_19979__$1 = tmp20110;
var inst_19980__$1 = tmp20111;
var inst_19981__$1 = tmp20112;
var inst_19982__$1 = inst_19996;
var state_20098__$1 = (function (){var statearr_20117 = state_20098;
(statearr_20117[(13)] = inst_19979__$1);

(statearr_20117[(14)] = inst_19982__$1);

(statearr_20117[(18)] = inst_19995);

(statearr_20117[(16)] = inst_19980__$1);

(statearr_20117[(17)] = inst_19981__$1);

return statearr_20117;
})();
var statearr_20118_20197 = state_20098__$1;
(statearr_20118_20197[(2)] = null);

(statearr_20118_20197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (21))){
var inst_20020 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20122_20198 = state_20098__$1;
(statearr_20122_20198[(2)] = inst_20020);

(statearr_20122_20198[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (31))){
var inst_20046 = (state_20098[(11)]);
var inst_20050 = done.call(null,null);
var inst_20051 = cljs.core.async.untap_STAR_.call(null,m,inst_20046);
var state_20098__$1 = (function (){var statearr_20123 = state_20098;
(statearr_20123[(19)] = inst_20050);

return statearr_20123;
})();
var statearr_20124_20199 = state_20098__$1;
(statearr_20124_20199[(2)] = inst_20051);

(statearr_20124_20199[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (32))){
var inst_20040 = (state_20098[(20)]);
var inst_20039 = (state_20098[(9)]);
var inst_20041 = (state_20098[(10)]);
var inst_20038 = (state_20098[(21)]);
var inst_20053 = (state_20098[(2)]);
var inst_20054 = (inst_20041 + (1));
var tmp20119 = inst_20040;
var tmp20120 = inst_20039;
var tmp20121 = inst_20038;
var inst_20038__$1 = tmp20121;
var inst_20039__$1 = tmp20120;
var inst_20040__$1 = tmp20119;
var inst_20041__$1 = inst_20054;
var state_20098__$1 = (function (){var statearr_20125 = state_20098;
(statearr_20125[(20)] = inst_20040__$1);

(statearr_20125[(9)] = inst_20039__$1);

(statearr_20125[(22)] = inst_20053);

(statearr_20125[(10)] = inst_20041__$1);

(statearr_20125[(21)] = inst_20038__$1);

return statearr_20125;
})();
var statearr_20126_20200 = state_20098__$1;
(statearr_20126_20200[(2)] = null);

(statearr_20126_20200[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (40))){
var inst_20066 = (state_20098[(23)]);
var inst_20070 = done.call(null,null);
var inst_20071 = cljs.core.async.untap_STAR_.call(null,m,inst_20066);
var state_20098__$1 = (function (){var statearr_20127 = state_20098;
(statearr_20127[(24)] = inst_20070);

return statearr_20127;
})();
var statearr_20128_20201 = state_20098__$1;
(statearr_20128_20201[(2)] = inst_20071);

(statearr_20128_20201[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (33))){
var inst_20057 = (state_20098[(25)]);
var inst_20059 = cljs.core.chunked_seq_QMARK_.call(null,inst_20057);
var state_20098__$1 = state_20098;
if(inst_20059){
var statearr_20129_20202 = state_20098__$1;
(statearr_20129_20202[(1)] = (36));

} else {
var statearr_20130_20203 = state_20098__$1;
(statearr_20130_20203[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (13))){
var inst_19989 = (state_20098[(26)]);
var inst_19992 = cljs.core.async.close_BANG_.call(null,inst_19989);
var state_20098__$1 = state_20098;
var statearr_20131_20204 = state_20098__$1;
(statearr_20131_20204[(2)] = inst_19992);

(statearr_20131_20204[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (22))){
var inst_20010 = (state_20098[(8)]);
var inst_20013 = cljs.core.async.close_BANG_.call(null,inst_20010);
var state_20098__$1 = state_20098;
var statearr_20132_20205 = state_20098__$1;
(statearr_20132_20205[(2)] = inst_20013);

(statearr_20132_20205[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (36))){
var inst_20057 = (state_20098[(25)]);
var inst_20061 = cljs.core.chunk_first.call(null,inst_20057);
var inst_20062 = cljs.core.chunk_rest.call(null,inst_20057);
var inst_20063 = cljs.core.count.call(null,inst_20061);
var inst_20038 = inst_20062;
var inst_20039 = inst_20061;
var inst_20040 = inst_20063;
var inst_20041 = (0);
var state_20098__$1 = (function (){var statearr_20133 = state_20098;
(statearr_20133[(20)] = inst_20040);

(statearr_20133[(9)] = inst_20039);

(statearr_20133[(10)] = inst_20041);

(statearr_20133[(21)] = inst_20038);

return statearr_20133;
})();
var statearr_20134_20206 = state_20098__$1;
(statearr_20134_20206[(2)] = null);

(statearr_20134_20206[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (41))){
var inst_20057 = (state_20098[(25)]);
var inst_20073 = (state_20098[(2)]);
var inst_20074 = cljs.core.next.call(null,inst_20057);
var inst_20038 = inst_20074;
var inst_20039 = null;
var inst_20040 = (0);
var inst_20041 = (0);
var state_20098__$1 = (function (){var statearr_20135 = state_20098;
(statearr_20135[(27)] = inst_20073);

(statearr_20135[(20)] = inst_20040);

(statearr_20135[(9)] = inst_20039);

(statearr_20135[(10)] = inst_20041);

(statearr_20135[(21)] = inst_20038);

return statearr_20135;
})();
var statearr_20136_20207 = state_20098__$1;
(statearr_20136_20207[(2)] = null);

(statearr_20136_20207[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (43))){
var state_20098__$1 = state_20098;
var statearr_20137_20208 = state_20098__$1;
(statearr_20137_20208[(2)] = null);

(statearr_20137_20208[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (29))){
var inst_20082 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20138_20209 = state_20098__$1;
(statearr_20138_20209[(2)] = inst_20082);

(statearr_20138_20209[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (44))){
var inst_20091 = (state_20098[(2)]);
var state_20098__$1 = (function (){var statearr_20139 = state_20098;
(statearr_20139[(28)] = inst_20091);

return statearr_20139;
})();
var statearr_20140_20210 = state_20098__$1;
(statearr_20140_20210[(2)] = null);

(statearr_20140_20210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (6))){
var inst_20030 = (state_20098[(29)]);
var inst_20029 = cljs.core.deref.call(null,cs);
var inst_20030__$1 = cljs.core.keys.call(null,inst_20029);
var inst_20031 = cljs.core.count.call(null,inst_20030__$1);
var inst_20032 = cljs.core.reset_BANG_.call(null,dctr,inst_20031);
var inst_20037 = cljs.core.seq.call(null,inst_20030__$1);
var inst_20038 = inst_20037;
var inst_20039 = null;
var inst_20040 = (0);
var inst_20041 = (0);
var state_20098__$1 = (function (){var statearr_20141 = state_20098;
(statearr_20141[(30)] = inst_20032);

(statearr_20141[(20)] = inst_20040);

(statearr_20141[(29)] = inst_20030__$1);

(statearr_20141[(9)] = inst_20039);

(statearr_20141[(10)] = inst_20041);

(statearr_20141[(21)] = inst_20038);

return statearr_20141;
})();
var statearr_20142_20211 = state_20098__$1;
(statearr_20142_20211[(2)] = null);

(statearr_20142_20211[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (28))){
var inst_20057 = (state_20098[(25)]);
var inst_20038 = (state_20098[(21)]);
var inst_20057__$1 = cljs.core.seq.call(null,inst_20038);
var state_20098__$1 = (function (){var statearr_20143 = state_20098;
(statearr_20143[(25)] = inst_20057__$1);

return statearr_20143;
})();
if(inst_20057__$1){
var statearr_20144_20212 = state_20098__$1;
(statearr_20144_20212[(1)] = (33));

} else {
var statearr_20145_20213 = state_20098__$1;
(statearr_20145_20213[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (25))){
var inst_20040 = (state_20098[(20)]);
var inst_20041 = (state_20098[(10)]);
var inst_20043 = (inst_20041 < inst_20040);
var inst_20044 = inst_20043;
var state_20098__$1 = state_20098;
if(cljs.core.truth_(inst_20044)){
var statearr_20146_20214 = state_20098__$1;
(statearr_20146_20214[(1)] = (27));

} else {
var statearr_20147_20215 = state_20098__$1;
(statearr_20147_20215[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (34))){
var state_20098__$1 = state_20098;
var statearr_20148_20216 = state_20098__$1;
(statearr_20148_20216[(2)] = null);

(statearr_20148_20216[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (17))){
var state_20098__$1 = state_20098;
var statearr_20149_20217 = state_20098__$1;
(statearr_20149_20217[(2)] = null);

(statearr_20149_20217[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (3))){
var inst_20096 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20098__$1,inst_20096);
} else {
if((state_val_20099 === (12))){
var inst_20025 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20150_20218 = state_20098__$1;
(statearr_20150_20218[(2)] = inst_20025);

(statearr_20150_20218[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (2))){
var state_20098__$1 = state_20098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20098__$1,(4),ch);
} else {
if((state_val_20099 === (23))){
var state_20098__$1 = state_20098;
var statearr_20151_20219 = state_20098__$1;
(statearr_20151_20219[(2)] = null);

(statearr_20151_20219[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (35))){
var inst_20080 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20152_20220 = state_20098__$1;
(statearr_20152_20220[(2)] = inst_20080);

(statearr_20152_20220[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (19))){
var inst_19999 = (state_20098[(7)]);
var inst_20003 = cljs.core.chunk_first.call(null,inst_19999);
var inst_20004 = cljs.core.chunk_rest.call(null,inst_19999);
var inst_20005 = cljs.core.count.call(null,inst_20003);
var inst_19979 = inst_20004;
var inst_19980 = inst_20003;
var inst_19981 = inst_20005;
var inst_19982 = (0);
var state_20098__$1 = (function (){var statearr_20153 = state_20098;
(statearr_20153[(13)] = inst_19979);

(statearr_20153[(14)] = inst_19982);

(statearr_20153[(16)] = inst_19980);

(statearr_20153[(17)] = inst_19981);

return statearr_20153;
})();
var statearr_20154_20221 = state_20098__$1;
(statearr_20154_20221[(2)] = null);

(statearr_20154_20221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (11))){
var inst_19999 = (state_20098[(7)]);
var inst_19979 = (state_20098[(13)]);
var inst_19999__$1 = cljs.core.seq.call(null,inst_19979);
var state_20098__$1 = (function (){var statearr_20155 = state_20098;
(statearr_20155[(7)] = inst_19999__$1);

return statearr_20155;
})();
if(inst_19999__$1){
var statearr_20156_20222 = state_20098__$1;
(statearr_20156_20222[(1)] = (16));

} else {
var statearr_20157_20223 = state_20098__$1;
(statearr_20157_20223[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (9))){
var inst_20027 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20158_20224 = state_20098__$1;
(statearr_20158_20224[(2)] = inst_20027);

(statearr_20158_20224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (5))){
var inst_19977 = cljs.core.deref.call(null,cs);
var inst_19978 = cljs.core.seq.call(null,inst_19977);
var inst_19979 = inst_19978;
var inst_19980 = null;
var inst_19981 = (0);
var inst_19982 = (0);
var state_20098__$1 = (function (){var statearr_20159 = state_20098;
(statearr_20159[(13)] = inst_19979);

(statearr_20159[(14)] = inst_19982);

(statearr_20159[(16)] = inst_19980);

(statearr_20159[(17)] = inst_19981);

return statearr_20159;
})();
var statearr_20160_20225 = state_20098__$1;
(statearr_20160_20225[(2)] = null);

(statearr_20160_20225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (14))){
var state_20098__$1 = state_20098;
var statearr_20161_20226 = state_20098__$1;
(statearr_20161_20226[(2)] = null);

(statearr_20161_20226[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (45))){
var inst_20088 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20162_20227 = state_20098__$1;
(statearr_20162_20227[(2)] = inst_20088);

(statearr_20162_20227[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (26))){
var inst_20030 = (state_20098[(29)]);
var inst_20084 = (state_20098[(2)]);
var inst_20085 = cljs.core.seq.call(null,inst_20030);
var state_20098__$1 = (function (){var statearr_20163 = state_20098;
(statearr_20163[(31)] = inst_20084);

return statearr_20163;
})();
if(inst_20085){
var statearr_20164_20228 = state_20098__$1;
(statearr_20164_20228[(1)] = (42));

} else {
var statearr_20165_20229 = state_20098__$1;
(statearr_20165_20229[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (16))){
var inst_19999 = (state_20098[(7)]);
var inst_20001 = cljs.core.chunked_seq_QMARK_.call(null,inst_19999);
var state_20098__$1 = state_20098;
if(inst_20001){
var statearr_20166_20230 = state_20098__$1;
(statearr_20166_20230[(1)] = (19));

} else {
var statearr_20167_20231 = state_20098__$1;
(statearr_20167_20231[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (38))){
var inst_20077 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20168_20232 = state_20098__$1;
(statearr_20168_20232[(2)] = inst_20077);

(statearr_20168_20232[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (30))){
var state_20098__$1 = state_20098;
var statearr_20169_20233 = state_20098__$1;
(statearr_20169_20233[(2)] = null);

(statearr_20169_20233[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (10))){
var inst_19982 = (state_20098[(14)]);
var inst_19980 = (state_20098[(16)]);
var inst_19988 = cljs.core._nth.call(null,inst_19980,inst_19982);
var inst_19989 = cljs.core.nth.call(null,inst_19988,(0),null);
var inst_19990 = cljs.core.nth.call(null,inst_19988,(1),null);
var state_20098__$1 = (function (){var statearr_20170 = state_20098;
(statearr_20170[(26)] = inst_19989);

return statearr_20170;
})();
if(cljs.core.truth_(inst_19990)){
var statearr_20171_20234 = state_20098__$1;
(statearr_20171_20234[(1)] = (13));

} else {
var statearr_20172_20235 = state_20098__$1;
(statearr_20172_20235[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (18))){
var inst_20023 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20173_20236 = state_20098__$1;
(statearr_20173_20236[(2)] = inst_20023);

(statearr_20173_20236[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (42))){
var state_20098__$1 = state_20098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20098__$1,(45),dchan);
} else {
if((state_val_20099 === (37))){
var inst_20066 = (state_20098[(23)]);
var inst_20057 = (state_20098[(25)]);
var inst_19970 = (state_20098[(12)]);
var inst_20066__$1 = cljs.core.first.call(null,inst_20057);
var inst_20067 = cljs.core.async.put_BANG_.call(null,inst_20066__$1,inst_19970,done);
var state_20098__$1 = (function (){var statearr_20174 = state_20098;
(statearr_20174[(23)] = inst_20066__$1);

return statearr_20174;
})();
if(cljs.core.truth_(inst_20067)){
var statearr_20175_20237 = state_20098__$1;
(statearr_20175_20237[(1)] = (39));

} else {
var statearr_20176_20238 = state_20098__$1;
(statearr_20176_20238[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (8))){
var inst_19982 = (state_20098[(14)]);
var inst_19981 = (state_20098[(17)]);
var inst_19984 = (inst_19982 < inst_19981);
var inst_19985 = inst_19984;
var state_20098__$1 = state_20098;
if(cljs.core.truth_(inst_19985)){
var statearr_20177_20239 = state_20098__$1;
(statearr_20177_20239[(1)] = (10));

} else {
var statearr_20178_20240 = state_20098__$1;
(statearr_20178_20240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___20186,cs,m,dchan,dctr,done))
;
return ((function (switch__10949__auto__,c__11061__auto___20186,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10950__auto__ = null;
var cljs$core$async$mult_$_state_machine__10950__auto____0 = (function (){
var statearr_20182 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20182[(0)] = cljs$core$async$mult_$_state_machine__10950__auto__);

(statearr_20182[(1)] = (1));

return statearr_20182;
});
var cljs$core$async$mult_$_state_machine__10950__auto____1 = (function (state_20098){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_20098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e20183){if((e20183 instanceof Object)){
var ex__10953__auto__ = e20183;
var statearr_20184_20241 = state_20098;
(statearr_20184_20241[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20183;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20242 = state_20098;
state_20098 = G__20242;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10950__auto__ = function(state_20098){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10950__auto____1.call(this,state_20098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10950__auto____0;
cljs$core$async$mult_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10950__auto____1;
return cljs$core$async$mult_$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___20186,cs,m,dchan,dctr,done))
})();
var state__11063__auto__ = (function (){var statearr_20185 = f__11062__auto__.call(null);
(statearr_20185[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___20186);

return statearr_20185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___20186,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20243 = [];
var len__5726__auto___20246 = arguments.length;
var i__5727__auto___20247 = (0);
while(true){
if((i__5727__auto___20247 < len__5726__auto___20246)){
args20243.push((arguments[i__5727__auto___20247]));

var G__20248 = (i__5727__auto___20247 + (1));
i__5727__auto___20247 = G__20248;
continue;
} else {
}
break;
}

var G__20245 = args20243.length;
switch (G__20245) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20243.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20260 = arguments.length;
var i__5727__auto___20261 = (0);
while(true){
if((i__5727__auto___20261 < len__5726__auto___20260)){
args__5733__auto__.push((arguments[i__5727__auto___20261]));

var G__20262 = (i__5727__auto___20261 + (1));
i__5727__auto___20261 = G__20262;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20254){
var map__20255 = p__20254;
var map__20255__$1 = ((((!((map__20255 == null)))?((((map__20255.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20255.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20255):map__20255);
var opts = map__20255__$1;
var statearr_20257_20263 = state;
(statearr_20257_20263[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20255,map__20255__$1,opts){
return (function (val){
var statearr_20258_20264 = state;
(statearr_20258_20264[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20255,map__20255__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20259_20265 = state;
(statearr_20259_20265[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20250){
var G__20251 = cljs.core.first.call(null,seq20250);
var seq20250__$1 = cljs.core.next.call(null,seq20250);
var G__20252 = cljs.core.first.call(null,seq20250__$1);
var seq20250__$2 = cljs.core.next.call(null,seq20250__$1);
var G__20253 = cljs.core.first.call(null,seq20250__$2);
var seq20250__$3 = cljs.core.next.call(null,seq20250__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20251,G__20252,G__20253,seq20250__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20429 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20430){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20430 = meta20430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20431,meta20430__$1){
var self__ = this;
var _20431__$1 = this;
return (new cljs.core.async.t_cljs$core$async20429(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20430__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20431){
var self__ = this;
var _20431__$1 = this;
return self__.meta20430;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20430","meta20430",-585523717,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20429.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20429.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20429";

cljs.core.async.t_cljs$core$async20429.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20429");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20429 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20429(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20430){
return (new cljs.core.async.t_cljs$core$async20429(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20430));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20429(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11061__auto___20592 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___20592,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___20592,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20529){
var state_val_20530 = (state_20529[(1)]);
if((state_val_20530 === (7))){
var inst_20447 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20531_20593 = state_20529__$1;
(statearr_20531_20593[(2)] = inst_20447);

(statearr_20531_20593[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (20))){
var inst_20459 = (state_20529[(7)]);
var state_20529__$1 = state_20529;
var statearr_20532_20594 = state_20529__$1;
(statearr_20532_20594[(2)] = inst_20459);

(statearr_20532_20594[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (27))){
var state_20529__$1 = state_20529;
var statearr_20533_20595 = state_20529__$1;
(statearr_20533_20595[(2)] = null);

(statearr_20533_20595[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (1))){
var inst_20435 = (state_20529[(8)]);
var inst_20435__$1 = calc_state.call(null);
var inst_20437 = (inst_20435__$1 == null);
var inst_20438 = cljs.core.not.call(null,inst_20437);
var state_20529__$1 = (function (){var statearr_20534 = state_20529;
(statearr_20534[(8)] = inst_20435__$1);

return statearr_20534;
})();
if(inst_20438){
var statearr_20535_20596 = state_20529__$1;
(statearr_20535_20596[(1)] = (2));

} else {
var statearr_20536_20597 = state_20529__$1;
(statearr_20536_20597[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (24))){
var inst_20482 = (state_20529[(9)]);
var inst_20503 = (state_20529[(10)]);
var inst_20489 = (state_20529[(11)]);
var inst_20503__$1 = inst_20482.call(null,inst_20489);
var state_20529__$1 = (function (){var statearr_20537 = state_20529;
(statearr_20537[(10)] = inst_20503__$1);

return statearr_20537;
})();
if(cljs.core.truth_(inst_20503__$1)){
var statearr_20538_20598 = state_20529__$1;
(statearr_20538_20598[(1)] = (29));

} else {
var statearr_20539_20599 = state_20529__$1;
(statearr_20539_20599[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (4))){
var inst_20450 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20450)){
var statearr_20540_20600 = state_20529__$1;
(statearr_20540_20600[(1)] = (8));

} else {
var statearr_20541_20601 = state_20529__$1;
(statearr_20541_20601[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (15))){
var inst_20476 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20476)){
var statearr_20542_20602 = state_20529__$1;
(statearr_20542_20602[(1)] = (19));

} else {
var statearr_20543_20603 = state_20529__$1;
(statearr_20543_20603[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (21))){
var inst_20481 = (state_20529[(12)]);
var inst_20481__$1 = (state_20529[(2)]);
var inst_20482 = cljs.core.get.call(null,inst_20481__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20483 = cljs.core.get.call(null,inst_20481__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20484 = cljs.core.get.call(null,inst_20481__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20529__$1 = (function (){var statearr_20544 = state_20529;
(statearr_20544[(13)] = inst_20483);

(statearr_20544[(9)] = inst_20482);

(statearr_20544[(12)] = inst_20481__$1);

return statearr_20544;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20529__$1,(22),inst_20484);
} else {
if((state_val_20530 === (31))){
var inst_20511 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20511)){
var statearr_20545_20604 = state_20529__$1;
(statearr_20545_20604[(1)] = (32));

} else {
var statearr_20546_20605 = state_20529__$1;
(statearr_20546_20605[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (32))){
var inst_20488 = (state_20529[(14)]);
var state_20529__$1 = state_20529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20529__$1,(35),out,inst_20488);
} else {
if((state_val_20530 === (33))){
var inst_20481 = (state_20529[(12)]);
var inst_20459 = inst_20481;
var state_20529__$1 = (function (){var statearr_20547 = state_20529;
(statearr_20547[(7)] = inst_20459);

return statearr_20547;
})();
var statearr_20548_20606 = state_20529__$1;
(statearr_20548_20606[(2)] = null);

(statearr_20548_20606[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (13))){
var inst_20459 = (state_20529[(7)]);
var inst_20466 = inst_20459.cljs$lang$protocol_mask$partition0$;
var inst_20467 = (inst_20466 & (64));
var inst_20468 = inst_20459.cljs$core$ISeq$;
var inst_20469 = (inst_20467) || (inst_20468);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20469)){
var statearr_20549_20607 = state_20529__$1;
(statearr_20549_20607[(1)] = (16));

} else {
var statearr_20550_20608 = state_20529__$1;
(statearr_20550_20608[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (22))){
var inst_20488 = (state_20529[(14)]);
var inst_20489 = (state_20529[(11)]);
var inst_20487 = (state_20529[(2)]);
var inst_20488__$1 = cljs.core.nth.call(null,inst_20487,(0),null);
var inst_20489__$1 = cljs.core.nth.call(null,inst_20487,(1),null);
var inst_20490 = (inst_20488__$1 == null);
var inst_20491 = cljs.core._EQ_.call(null,inst_20489__$1,change);
var inst_20492 = (inst_20490) || (inst_20491);
var state_20529__$1 = (function (){var statearr_20551 = state_20529;
(statearr_20551[(14)] = inst_20488__$1);

(statearr_20551[(11)] = inst_20489__$1);

return statearr_20551;
})();
if(cljs.core.truth_(inst_20492)){
var statearr_20552_20609 = state_20529__$1;
(statearr_20552_20609[(1)] = (23));

} else {
var statearr_20553_20610 = state_20529__$1;
(statearr_20553_20610[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (36))){
var inst_20481 = (state_20529[(12)]);
var inst_20459 = inst_20481;
var state_20529__$1 = (function (){var statearr_20554 = state_20529;
(statearr_20554[(7)] = inst_20459);

return statearr_20554;
})();
var statearr_20555_20611 = state_20529__$1;
(statearr_20555_20611[(2)] = null);

(statearr_20555_20611[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (29))){
var inst_20503 = (state_20529[(10)]);
var state_20529__$1 = state_20529;
var statearr_20556_20612 = state_20529__$1;
(statearr_20556_20612[(2)] = inst_20503);

(statearr_20556_20612[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (6))){
var state_20529__$1 = state_20529;
var statearr_20557_20613 = state_20529__$1;
(statearr_20557_20613[(2)] = false);

(statearr_20557_20613[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (28))){
var inst_20499 = (state_20529[(2)]);
var inst_20500 = calc_state.call(null);
var inst_20459 = inst_20500;
var state_20529__$1 = (function (){var statearr_20558 = state_20529;
(statearr_20558[(15)] = inst_20499);

(statearr_20558[(7)] = inst_20459);

return statearr_20558;
})();
var statearr_20559_20614 = state_20529__$1;
(statearr_20559_20614[(2)] = null);

(statearr_20559_20614[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (25))){
var inst_20525 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20560_20615 = state_20529__$1;
(statearr_20560_20615[(2)] = inst_20525);

(statearr_20560_20615[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (34))){
var inst_20523 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20561_20616 = state_20529__$1;
(statearr_20561_20616[(2)] = inst_20523);

(statearr_20561_20616[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (17))){
var state_20529__$1 = state_20529;
var statearr_20562_20617 = state_20529__$1;
(statearr_20562_20617[(2)] = false);

(statearr_20562_20617[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (3))){
var state_20529__$1 = state_20529;
var statearr_20563_20618 = state_20529__$1;
(statearr_20563_20618[(2)] = false);

(statearr_20563_20618[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (12))){
var inst_20527 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20529__$1,inst_20527);
} else {
if((state_val_20530 === (2))){
var inst_20435 = (state_20529[(8)]);
var inst_20440 = inst_20435.cljs$lang$protocol_mask$partition0$;
var inst_20441 = (inst_20440 & (64));
var inst_20442 = inst_20435.cljs$core$ISeq$;
var inst_20443 = (inst_20441) || (inst_20442);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20443)){
var statearr_20564_20619 = state_20529__$1;
(statearr_20564_20619[(1)] = (5));

} else {
var statearr_20565_20620 = state_20529__$1;
(statearr_20565_20620[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (23))){
var inst_20488 = (state_20529[(14)]);
var inst_20494 = (inst_20488 == null);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20494)){
var statearr_20566_20621 = state_20529__$1;
(statearr_20566_20621[(1)] = (26));

} else {
var statearr_20567_20622 = state_20529__$1;
(statearr_20567_20622[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (35))){
var inst_20514 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20514)){
var statearr_20568_20623 = state_20529__$1;
(statearr_20568_20623[(1)] = (36));

} else {
var statearr_20569_20624 = state_20529__$1;
(statearr_20569_20624[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (19))){
var inst_20459 = (state_20529[(7)]);
var inst_20478 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20459);
var state_20529__$1 = state_20529;
var statearr_20570_20625 = state_20529__$1;
(statearr_20570_20625[(2)] = inst_20478);

(statearr_20570_20625[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (11))){
var inst_20459 = (state_20529[(7)]);
var inst_20463 = (inst_20459 == null);
var inst_20464 = cljs.core.not.call(null,inst_20463);
var state_20529__$1 = state_20529;
if(inst_20464){
var statearr_20571_20626 = state_20529__$1;
(statearr_20571_20626[(1)] = (13));

} else {
var statearr_20572_20627 = state_20529__$1;
(statearr_20572_20627[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (9))){
var inst_20435 = (state_20529[(8)]);
var state_20529__$1 = state_20529;
var statearr_20573_20628 = state_20529__$1;
(statearr_20573_20628[(2)] = inst_20435);

(statearr_20573_20628[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (5))){
var state_20529__$1 = state_20529;
var statearr_20574_20629 = state_20529__$1;
(statearr_20574_20629[(2)] = true);

(statearr_20574_20629[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (14))){
var state_20529__$1 = state_20529;
var statearr_20575_20630 = state_20529__$1;
(statearr_20575_20630[(2)] = false);

(statearr_20575_20630[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (26))){
var inst_20489 = (state_20529[(11)]);
var inst_20496 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20489);
var state_20529__$1 = state_20529;
var statearr_20576_20631 = state_20529__$1;
(statearr_20576_20631[(2)] = inst_20496);

(statearr_20576_20631[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (16))){
var state_20529__$1 = state_20529;
var statearr_20577_20632 = state_20529__$1;
(statearr_20577_20632[(2)] = true);

(statearr_20577_20632[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (38))){
var inst_20519 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20578_20633 = state_20529__$1;
(statearr_20578_20633[(2)] = inst_20519);

(statearr_20578_20633[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (30))){
var inst_20483 = (state_20529[(13)]);
var inst_20482 = (state_20529[(9)]);
var inst_20489 = (state_20529[(11)]);
var inst_20506 = cljs.core.empty_QMARK_.call(null,inst_20482);
var inst_20507 = inst_20483.call(null,inst_20489);
var inst_20508 = cljs.core.not.call(null,inst_20507);
var inst_20509 = (inst_20506) && (inst_20508);
var state_20529__$1 = state_20529;
var statearr_20579_20634 = state_20529__$1;
(statearr_20579_20634[(2)] = inst_20509);

(statearr_20579_20634[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (10))){
var inst_20435 = (state_20529[(8)]);
var inst_20455 = (state_20529[(2)]);
var inst_20456 = cljs.core.get.call(null,inst_20455,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20457 = cljs.core.get.call(null,inst_20455,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20458 = cljs.core.get.call(null,inst_20455,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20459 = inst_20435;
var state_20529__$1 = (function (){var statearr_20580 = state_20529;
(statearr_20580[(7)] = inst_20459);

(statearr_20580[(16)] = inst_20456);

(statearr_20580[(17)] = inst_20458);

(statearr_20580[(18)] = inst_20457);

return statearr_20580;
})();
var statearr_20581_20635 = state_20529__$1;
(statearr_20581_20635[(2)] = null);

(statearr_20581_20635[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (18))){
var inst_20473 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20582_20636 = state_20529__$1;
(statearr_20582_20636[(2)] = inst_20473);

(statearr_20582_20636[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (37))){
var state_20529__$1 = state_20529;
var statearr_20583_20637 = state_20529__$1;
(statearr_20583_20637[(2)] = null);

(statearr_20583_20637[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (8))){
var inst_20435 = (state_20529[(8)]);
var inst_20452 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20435);
var state_20529__$1 = state_20529;
var statearr_20584_20638 = state_20529__$1;
(statearr_20584_20638[(2)] = inst_20452);

(statearr_20584_20638[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___20592,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10949__auto__,c__11061__auto___20592,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10950__auto__ = null;
var cljs$core$async$mix_$_state_machine__10950__auto____0 = (function (){
var statearr_20588 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20588[(0)] = cljs$core$async$mix_$_state_machine__10950__auto__);

(statearr_20588[(1)] = (1));

return statearr_20588;
});
var cljs$core$async$mix_$_state_machine__10950__auto____1 = (function (state_20529){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_20529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e20589){if((e20589 instanceof Object)){
var ex__10953__auto__ = e20589;
var statearr_20590_20639 = state_20529;
(statearr_20590_20639[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20529);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20589;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20640 = state_20529;
state_20529 = G__20640;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10950__auto__ = function(state_20529){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10950__auto____1.call(this,state_20529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10950__auto____0;
cljs$core$async$mix_$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10950__auto____1;
return cljs$core$async$mix_$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___20592,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11063__auto__ = (function (){var statearr_20591 = f__11062__auto__.call(null);
(statearr_20591[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___20592);

return statearr_20591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___20592,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20641 = [];
var len__5726__auto___20644 = arguments.length;
var i__5727__auto___20645 = (0);
while(true){
if((i__5727__auto___20645 < len__5726__auto___20644)){
args20641.push((arguments[i__5727__auto___20645]));

var G__20646 = (i__5727__auto___20645 + (1));
i__5727__auto___20645 = G__20646;
continue;
} else {
}
break;
}

var G__20643 = args20641.length;
switch (G__20643) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20641.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20649 = [];
var len__5726__auto___20774 = arguments.length;
var i__5727__auto___20775 = (0);
while(true){
if((i__5727__auto___20775 < len__5726__auto___20774)){
args20649.push((arguments[i__5727__auto___20775]));

var G__20776 = (i__5727__auto___20775 + (1));
i__5727__auto___20775 = G__20776;
continue;
} else {
}
break;
}

var G__20651 = args20649.length;
switch (G__20651) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20649.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__20648_SHARP_){
if(cljs.core.truth_(p1__20648_SHARP_.call(null,topic))){
return p1__20648_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20648_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20652 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20652 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20653){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20653 = meta20653;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20654,meta20653__$1){
var self__ = this;
var _20654__$1 = this;
return (new cljs.core.async.t_cljs$core$async20652(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20653__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20654){
var self__ = this;
var _20654__$1 = this;
return self__.meta20653;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20652.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20652.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20653","meta20653",-1212950646,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20652.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20652.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20652";

cljs.core.async.t_cljs$core$async20652.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20652");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20652 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20652(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20653){
return (new cljs.core.async.t_cljs$core$async20652(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20653));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20652(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11061__auto___20778 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___20778,mults,ensure_mult,p){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___20778,mults,ensure_mult,p){
return (function (state_20726){
var state_val_20727 = (state_20726[(1)]);
if((state_val_20727 === (7))){
var inst_20722 = (state_20726[(2)]);
var state_20726__$1 = state_20726;
var statearr_20728_20779 = state_20726__$1;
(statearr_20728_20779[(2)] = inst_20722);

(statearr_20728_20779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (20))){
var state_20726__$1 = state_20726;
var statearr_20729_20780 = state_20726__$1;
(statearr_20729_20780[(2)] = null);

(statearr_20729_20780[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (1))){
var state_20726__$1 = state_20726;
var statearr_20730_20781 = state_20726__$1;
(statearr_20730_20781[(2)] = null);

(statearr_20730_20781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (24))){
var inst_20705 = (state_20726[(7)]);
var inst_20714 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20705);
var state_20726__$1 = state_20726;
var statearr_20731_20782 = state_20726__$1;
(statearr_20731_20782[(2)] = inst_20714);

(statearr_20731_20782[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (4))){
var inst_20657 = (state_20726[(8)]);
var inst_20657__$1 = (state_20726[(2)]);
var inst_20658 = (inst_20657__$1 == null);
var state_20726__$1 = (function (){var statearr_20732 = state_20726;
(statearr_20732[(8)] = inst_20657__$1);

return statearr_20732;
})();
if(cljs.core.truth_(inst_20658)){
var statearr_20733_20783 = state_20726__$1;
(statearr_20733_20783[(1)] = (5));

} else {
var statearr_20734_20784 = state_20726__$1;
(statearr_20734_20784[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (15))){
var inst_20699 = (state_20726[(2)]);
var state_20726__$1 = state_20726;
var statearr_20735_20785 = state_20726__$1;
(statearr_20735_20785[(2)] = inst_20699);

(statearr_20735_20785[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (21))){
var inst_20719 = (state_20726[(2)]);
var state_20726__$1 = (function (){var statearr_20736 = state_20726;
(statearr_20736[(9)] = inst_20719);

return statearr_20736;
})();
var statearr_20737_20786 = state_20726__$1;
(statearr_20737_20786[(2)] = null);

(statearr_20737_20786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (13))){
var inst_20681 = (state_20726[(10)]);
var inst_20683 = cljs.core.chunked_seq_QMARK_.call(null,inst_20681);
var state_20726__$1 = state_20726;
if(inst_20683){
var statearr_20738_20787 = state_20726__$1;
(statearr_20738_20787[(1)] = (16));

} else {
var statearr_20739_20788 = state_20726__$1;
(statearr_20739_20788[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (22))){
var inst_20711 = (state_20726[(2)]);
var state_20726__$1 = state_20726;
if(cljs.core.truth_(inst_20711)){
var statearr_20740_20789 = state_20726__$1;
(statearr_20740_20789[(1)] = (23));

} else {
var statearr_20741_20790 = state_20726__$1;
(statearr_20741_20790[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (6))){
var inst_20707 = (state_20726[(11)]);
var inst_20705 = (state_20726[(7)]);
var inst_20657 = (state_20726[(8)]);
var inst_20705__$1 = topic_fn.call(null,inst_20657);
var inst_20706 = cljs.core.deref.call(null,mults);
var inst_20707__$1 = cljs.core.get.call(null,inst_20706,inst_20705__$1);
var state_20726__$1 = (function (){var statearr_20742 = state_20726;
(statearr_20742[(11)] = inst_20707__$1);

(statearr_20742[(7)] = inst_20705__$1);

return statearr_20742;
})();
if(cljs.core.truth_(inst_20707__$1)){
var statearr_20743_20791 = state_20726__$1;
(statearr_20743_20791[(1)] = (19));

} else {
var statearr_20744_20792 = state_20726__$1;
(statearr_20744_20792[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (25))){
var inst_20716 = (state_20726[(2)]);
var state_20726__$1 = state_20726;
var statearr_20745_20793 = state_20726__$1;
(statearr_20745_20793[(2)] = inst_20716);

(statearr_20745_20793[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (17))){
var inst_20681 = (state_20726[(10)]);
var inst_20690 = cljs.core.first.call(null,inst_20681);
var inst_20691 = cljs.core.async.muxch_STAR_.call(null,inst_20690);
var inst_20692 = cljs.core.async.close_BANG_.call(null,inst_20691);
var inst_20693 = cljs.core.next.call(null,inst_20681);
var inst_20667 = inst_20693;
var inst_20668 = null;
var inst_20669 = (0);
var inst_20670 = (0);
var state_20726__$1 = (function (){var statearr_20746 = state_20726;
(statearr_20746[(12)] = inst_20668);

(statearr_20746[(13)] = inst_20670);

(statearr_20746[(14)] = inst_20669);

(statearr_20746[(15)] = inst_20692);

(statearr_20746[(16)] = inst_20667);

return statearr_20746;
})();
var statearr_20747_20794 = state_20726__$1;
(statearr_20747_20794[(2)] = null);

(statearr_20747_20794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (3))){
var inst_20724 = (state_20726[(2)]);
var state_20726__$1 = state_20726;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20726__$1,inst_20724);
} else {
if((state_val_20727 === (12))){
var inst_20701 = (state_20726[(2)]);
var state_20726__$1 = state_20726;
var statearr_20748_20795 = state_20726__$1;
(statearr_20748_20795[(2)] = inst_20701);

(statearr_20748_20795[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (2))){
var state_20726__$1 = state_20726;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20726__$1,(4),ch);
} else {
if((state_val_20727 === (23))){
var state_20726__$1 = state_20726;
var statearr_20749_20796 = state_20726__$1;
(statearr_20749_20796[(2)] = null);

(statearr_20749_20796[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (19))){
var inst_20707 = (state_20726[(11)]);
var inst_20657 = (state_20726[(8)]);
var inst_20709 = cljs.core.async.muxch_STAR_.call(null,inst_20707);
var state_20726__$1 = state_20726;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20726__$1,(22),inst_20709,inst_20657);
} else {
if((state_val_20727 === (11))){
var inst_20681 = (state_20726[(10)]);
var inst_20667 = (state_20726[(16)]);
var inst_20681__$1 = cljs.core.seq.call(null,inst_20667);
var state_20726__$1 = (function (){var statearr_20750 = state_20726;
(statearr_20750[(10)] = inst_20681__$1);

return statearr_20750;
})();
if(inst_20681__$1){
var statearr_20751_20797 = state_20726__$1;
(statearr_20751_20797[(1)] = (13));

} else {
var statearr_20752_20798 = state_20726__$1;
(statearr_20752_20798[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (9))){
var inst_20703 = (state_20726[(2)]);
var state_20726__$1 = state_20726;
var statearr_20753_20799 = state_20726__$1;
(statearr_20753_20799[(2)] = inst_20703);

(statearr_20753_20799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (5))){
var inst_20664 = cljs.core.deref.call(null,mults);
var inst_20665 = cljs.core.vals.call(null,inst_20664);
var inst_20666 = cljs.core.seq.call(null,inst_20665);
var inst_20667 = inst_20666;
var inst_20668 = null;
var inst_20669 = (0);
var inst_20670 = (0);
var state_20726__$1 = (function (){var statearr_20754 = state_20726;
(statearr_20754[(12)] = inst_20668);

(statearr_20754[(13)] = inst_20670);

(statearr_20754[(14)] = inst_20669);

(statearr_20754[(16)] = inst_20667);

return statearr_20754;
})();
var statearr_20755_20800 = state_20726__$1;
(statearr_20755_20800[(2)] = null);

(statearr_20755_20800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (14))){
var state_20726__$1 = state_20726;
var statearr_20759_20801 = state_20726__$1;
(statearr_20759_20801[(2)] = null);

(statearr_20759_20801[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (16))){
var inst_20681 = (state_20726[(10)]);
var inst_20685 = cljs.core.chunk_first.call(null,inst_20681);
var inst_20686 = cljs.core.chunk_rest.call(null,inst_20681);
var inst_20687 = cljs.core.count.call(null,inst_20685);
var inst_20667 = inst_20686;
var inst_20668 = inst_20685;
var inst_20669 = inst_20687;
var inst_20670 = (0);
var state_20726__$1 = (function (){var statearr_20760 = state_20726;
(statearr_20760[(12)] = inst_20668);

(statearr_20760[(13)] = inst_20670);

(statearr_20760[(14)] = inst_20669);

(statearr_20760[(16)] = inst_20667);

return statearr_20760;
})();
var statearr_20761_20802 = state_20726__$1;
(statearr_20761_20802[(2)] = null);

(statearr_20761_20802[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (10))){
var inst_20668 = (state_20726[(12)]);
var inst_20670 = (state_20726[(13)]);
var inst_20669 = (state_20726[(14)]);
var inst_20667 = (state_20726[(16)]);
var inst_20675 = cljs.core._nth.call(null,inst_20668,inst_20670);
var inst_20676 = cljs.core.async.muxch_STAR_.call(null,inst_20675);
var inst_20677 = cljs.core.async.close_BANG_.call(null,inst_20676);
var inst_20678 = (inst_20670 + (1));
var tmp20756 = inst_20668;
var tmp20757 = inst_20669;
var tmp20758 = inst_20667;
var inst_20667__$1 = tmp20758;
var inst_20668__$1 = tmp20756;
var inst_20669__$1 = tmp20757;
var inst_20670__$1 = inst_20678;
var state_20726__$1 = (function (){var statearr_20762 = state_20726;
(statearr_20762[(12)] = inst_20668__$1);

(statearr_20762[(13)] = inst_20670__$1);

(statearr_20762[(14)] = inst_20669__$1);

(statearr_20762[(17)] = inst_20677);

(statearr_20762[(16)] = inst_20667__$1);

return statearr_20762;
})();
var statearr_20763_20803 = state_20726__$1;
(statearr_20763_20803[(2)] = null);

(statearr_20763_20803[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (18))){
var inst_20696 = (state_20726[(2)]);
var state_20726__$1 = state_20726;
var statearr_20764_20804 = state_20726__$1;
(statearr_20764_20804[(2)] = inst_20696);

(statearr_20764_20804[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20727 === (8))){
var inst_20670 = (state_20726[(13)]);
var inst_20669 = (state_20726[(14)]);
var inst_20672 = (inst_20670 < inst_20669);
var inst_20673 = inst_20672;
var state_20726__$1 = state_20726;
if(cljs.core.truth_(inst_20673)){
var statearr_20765_20805 = state_20726__$1;
(statearr_20765_20805[(1)] = (10));

} else {
var statearr_20766_20806 = state_20726__$1;
(statearr_20766_20806[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___20778,mults,ensure_mult,p))
;
return ((function (switch__10949__auto__,c__11061__auto___20778,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_20770 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20770[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_20770[(1)] = (1));

return statearr_20770;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_20726){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_20726);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e20771){if((e20771 instanceof Object)){
var ex__10953__auto__ = e20771;
var statearr_20772_20807 = state_20726;
(statearr_20772_20807[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20726);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20808 = state_20726;
state_20726 = G__20808;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_20726){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_20726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___20778,mults,ensure_mult,p))
})();
var state__11063__auto__ = (function (){var statearr_20773 = f__11062__auto__.call(null);
(statearr_20773[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___20778);

return statearr_20773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___20778,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20809 = [];
var len__5726__auto___20812 = arguments.length;
var i__5727__auto___20813 = (0);
while(true){
if((i__5727__auto___20813 < len__5726__auto___20812)){
args20809.push((arguments[i__5727__auto___20813]));

var G__20814 = (i__5727__auto___20813 + (1));
i__5727__auto___20813 = G__20814;
continue;
} else {
}
break;
}

var G__20811 = args20809.length;
switch (G__20811) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20809.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20816 = [];
var len__5726__auto___20819 = arguments.length;
var i__5727__auto___20820 = (0);
while(true){
if((i__5727__auto___20820 < len__5726__auto___20819)){
args20816.push((arguments[i__5727__auto___20820]));

var G__20821 = (i__5727__auto___20820 + (1));
i__5727__auto___20820 = G__20821;
continue;
} else {
}
break;
}

var G__20818 = args20816.length;
switch (G__20818) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20816.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20823 = [];
var len__5726__auto___20894 = arguments.length;
var i__5727__auto___20895 = (0);
while(true){
if((i__5727__auto___20895 < len__5726__auto___20894)){
args20823.push((arguments[i__5727__auto___20895]));

var G__20896 = (i__5727__auto___20895 + (1));
i__5727__auto___20895 = G__20896;
continue;
} else {
}
break;
}

var G__20825 = args20823.length;
switch (G__20825) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20823.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11061__auto___20898 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___20898,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___20898,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20864){
var state_val_20865 = (state_20864[(1)]);
if((state_val_20865 === (7))){
var state_20864__$1 = state_20864;
var statearr_20866_20899 = state_20864__$1;
(statearr_20866_20899[(2)] = null);

(statearr_20866_20899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (1))){
var state_20864__$1 = state_20864;
var statearr_20867_20900 = state_20864__$1;
(statearr_20867_20900[(2)] = null);

(statearr_20867_20900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (4))){
var inst_20828 = (state_20864[(7)]);
var inst_20830 = (inst_20828 < cnt);
var state_20864__$1 = state_20864;
if(cljs.core.truth_(inst_20830)){
var statearr_20868_20901 = state_20864__$1;
(statearr_20868_20901[(1)] = (6));

} else {
var statearr_20869_20902 = state_20864__$1;
(statearr_20869_20902[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (15))){
var inst_20860 = (state_20864[(2)]);
var state_20864__$1 = state_20864;
var statearr_20870_20903 = state_20864__$1;
(statearr_20870_20903[(2)] = inst_20860);

(statearr_20870_20903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (13))){
var inst_20853 = cljs.core.async.close_BANG_.call(null,out);
var state_20864__$1 = state_20864;
var statearr_20871_20904 = state_20864__$1;
(statearr_20871_20904[(2)] = inst_20853);

(statearr_20871_20904[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (6))){
var state_20864__$1 = state_20864;
var statearr_20872_20905 = state_20864__$1;
(statearr_20872_20905[(2)] = null);

(statearr_20872_20905[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (3))){
var inst_20862 = (state_20864[(2)]);
var state_20864__$1 = state_20864;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20864__$1,inst_20862);
} else {
if((state_val_20865 === (12))){
var inst_20850 = (state_20864[(8)]);
var inst_20850__$1 = (state_20864[(2)]);
var inst_20851 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20850__$1);
var state_20864__$1 = (function (){var statearr_20873 = state_20864;
(statearr_20873[(8)] = inst_20850__$1);

return statearr_20873;
})();
if(cljs.core.truth_(inst_20851)){
var statearr_20874_20906 = state_20864__$1;
(statearr_20874_20906[(1)] = (13));

} else {
var statearr_20875_20907 = state_20864__$1;
(statearr_20875_20907[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (2))){
var inst_20827 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20828 = (0);
var state_20864__$1 = (function (){var statearr_20876 = state_20864;
(statearr_20876[(7)] = inst_20828);

(statearr_20876[(9)] = inst_20827);

return statearr_20876;
})();
var statearr_20877_20908 = state_20864__$1;
(statearr_20877_20908[(2)] = null);

(statearr_20877_20908[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (11))){
var inst_20828 = (state_20864[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20864,(10),Object,null,(9));
var inst_20837 = chs__$1.call(null,inst_20828);
var inst_20838 = done.call(null,inst_20828);
var inst_20839 = cljs.core.async.take_BANG_.call(null,inst_20837,inst_20838);
var state_20864__$1 = state_20864;
var statearr_20878_20909 = state_20864__$1;
(statearr_20878_20909[(2)] = inst_20839);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20864__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (9))){
var inst_20828 = (state_20864[(7)]);
var inst_20841 = (state_20864[(2)]);
var inst_20842 = (inst_20828 + (1));
var inst_20828__$1 = inst_20842;
var state_20864__$1 = (function (){var statearr_20879 = state_20864;
(statearr_20879[(10)] = inst_20841);

(statearr_20879[(7)] = inst_20828__$1);

return statearr_20879;
})();
var statearr_20880_20910 = state_20864__$1;
(statearr_20880_20910[(2)] = null);

(statearr_20880_20910[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (5))){
var inst_20848 = (state_20864[(2)]);
var state_20864__$1 = (function (){var statearr_20881 = state_20864;
(statearr_20881[(11)] = inst_20848);

return statearr_20881;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20864__$1,(12),dchan);
} else {
if((state_val_20865 === (14))){
var inst_20850 = (state_20864[(8)]);
var inst_20855 = cljs.core.apply.call(null,f,inst_20850);
var state_20864__$1 = state_20864;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20864__$1,(16),out,inst_20855);
} else {
if((state_val_20865 === (16))){
var inst_20857 = (state_20864[(2)]);
var state_20864__$1 = (function (){var statearr_20882 = state_20864;
(statearr_20882[(12)] = inst_20857);

return statearr_20882;
})();
var statearr_20883_20911 = state_20864__$1;
(statearr_20883_20911[(2)] = null);

(statearr_20883_20911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (10))){
var inst_20832 = (state_20864[(2)]);
var inst_20833 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20864__$1 = (function (){var statearr_20884 = state_20864;
(statearr_20884[(13)] = inst_20832);

return statearr_20884;
})();
var statearr_20885_20912 = state_20864__$1;
(statearr_20885_20912[(2)] = inst_20833);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20864__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (8))){
var inst_20846 = (state_20864[(2)]);
var state_20864__$1 = state_20864;
var statearr_20886_20913 = state_20864__$1;
(statearr_20886_20913[(2)] = inst_20846);

(statearr_20886_20913[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___20898,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10949__auto__,c__11061__auto___20898,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_20890 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20890[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_20890[(1)] = (1));

return statearr_20890;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_20864){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_20864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e20891){if((e20891 instanceof Object)){
var ex__10953__auto__ = e20891;
var statearr_20892_20914 = state_20864;
(statearr_20892_20914[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20864);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20891;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20915 = state_20864;
state_20864 = G__20915;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_20864){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_20864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___20898,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11063__auto__ = (function (){var statearr_20893 = f__11062__auto__.call(null);
(statearr_20893[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___20898);

return statearr_20893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___20898,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20917 = [];
var len__5726__auto___20973 = arguments.length;
var i__5727__auto___20974 = (0);
while(true){
if((i__5727__auto___20974 < len__5726__auto___20973)){
args20917.push((arguments[i__5727__auto___20974]));

var G__20975 = (i__5727__auto___20974 + (1));
i__5727__auto___20974 = G__20975;
continue;
} else {
}
break;
}

var G__20919 = args20917.length;
switch (G__20919) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20917.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___20977 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___20977,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___20977,out){
return (function (state_20949){
var state_val_20950 = (state_20949[(1)]);
if((state_val_20950 === (7))){
var inst_20929 = (state_20949[(7)]);
var inst_20928 = (state_20949[(8)]);
var inst_20928__$1 = (state_20949[(2)]);
var inst_20929__$1 = cljs.core.nth.call(null,inst_20928__$1,(0),null);
var inst_20930 = cljs.core.nth.call(null,inst_20928__$1,(1),null);
var inst_20931 = (inst_20929__$1 == null);
var state_20949__$1 = (function (){var statearr_20951 = state_20949;
(statearr_20951[(9)] = inst_20930);

(statearr_20951[(7)] = inst_20929__$1);

(statearr_20951[(8)] = inst_20928__$1);

return statearr_20951;
})();
if(cljs.core.truth_(inst_20931)){
var statearr_20952_20978 = state_20949__$1;
(statearr_20952_20978[(1)] = (8));

} else {
var statearr_20953_20979 = state_20949__$1;
(statearr_20953_20979[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (1))){
var inst_20920 = cljs.core.vec.call(null,chs);
var inst_20921 = inst_20920;
var state_20949__$1 = (function (){var statearr_20954 = state_20949;
(statearr_20954[(10)] = inst_20921);

return statearr_20954;
})();
var statearr_20955_20980 = state_20949__$1;
(statearr_20955_20980[(2)] = null);

(statearr_20955_20980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (4))){
var inst_20921 = (state_20949[(10)]);
var state_20949__$1 = state_20949;
return cljs.core.async.ioc_alts_BANG_.call(null,state_20949__$1,(7),inst_20921);
} else {
if((state_val_20950 === (6))){
var inst_20945 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
var statearr_20956_20981 = state_20949__$1;
(statearr_20956_20981[(2)] = inst_20945);

(statearr_20956_20981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (3))){
var inst_20947 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20949__$1,inst_20947);
} else {
if((state_val_20950 === (2))){
var inst_20921 = (state_20949[(10)]);
var inst_20923 = cljs.core.count.call(null,inst_20921);
var inst_20924 = (inst_20923 > (0));
var state_20949__$1 = state_20949;
if(cljs.core.truth_(inst_20924)){
var statearr_20958_20982 = state_20949__$1;
(statearr_20958_20982[(1)] = (4));

} else {
var statearr_20959_20983 = state_20949__$1;
(statearr_20959_20983[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (11))){
var inst_20921 = (state_20949[(10)]);
var inst_20938 = (state_20949[(2)]);
var tmp20957 = inst_20921;
var inst_20921__$1 = tmp20957;
var state_20949__$1 = (function (){var statearr_20960 = state_20949;
(statearr_20960[(10)] = inst_20921__$1);

(statearr_20960[(11)] = inst_20938);

return statearr_20960;
})();
var statearr_20961_20984 = state_20949__$1;
(statearr_20961_20984[(2)] = null);

(statearr_20961_20984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (9))){
var inst_20929 = (state_20949[(7)]);
var state_20949__$1 = state_20949;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20949__$1,(11),out,inst_20929);
} else {
if((state_val_20950 === (5))){
var inst_20943 = cljs.core.async.close_BANG_.call(null,out);
var state_20949__$1 = state_20949;
var statearr_20962_20985 = state_20949__$1;
(statearr_20962_20985[(2)] = inst_20943);

(statearr_20962_20985[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (10))){
var inst_20941 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
var statearr_20963_20986 = state_20949__$1;
(statearr_20963_20986[(2)] = inst_20941);

(statearr_20963_20986[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (8))){
var inst_20930 = (state_20949[(9)]);
var inst_20929 = (state_20949[(7)]);
var inst_20921 = (state_20949[(10)]);
var inst_20928 = (state_20949[(8)]);
var inst_20933 = (function (){var cs = inst_20921;
var vec__20926 = inst_20928;
var v = inst_20929;
var c = inst_20930;
return ((function (cs,vec__20926,v,c,inst_20930,inst_20929,inst_20921,inst_20928,state_val_20950,c__11061__auto___20977,out){
return (function (p1__20916_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20916_SHARP_);
});
;})(cs,vec__20926,v,c,inst_20930,inst_20929,inst_20921,inst_20928,state_val_20950,c__11061__auto___20977,out))
})();
var inst_20934 = cljs.core.filterv.call(null,inst_20933,inst_20921);
var inst_20921__$1 = inst_20934;
var state_20949__$1 = (function (){var statearr_20964 = state_20949;
(statearr_20964[(10)] = inst_20921__$1);

return statearr_20964;
})();
var statearr_20965_20987 = state_20949__$1;
(statearr_20965_20987[(2)] = null);

(statearr_20965_20987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___20977,out))
;
return ((function (switch__10949__auto__,c__11061__auto___20977,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_20969 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20969[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_20969[(1)] = (1));

return statearr_20969;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_20949){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_20949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e20970){if((e20970 instanceof Object)){
var ex__10953__auto__ = e20970;
var statearr_20971_20988 = state_20949;
(statearr_20971_20988[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20949);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20970;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20989 = state_20949;
state_20949 = G__20989;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_20949){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_20949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___20977,out))
})();
var state__11063__auto__ = (function (){var statearr_20972 = f__11062__auto__.call(null);
(statearr_20972[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___20977);

return statearr_20972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___20977,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args20990 = [];
var len__5726__auto___21039 = arguments.length;
var i__5727__auto___21040 = (0);
while(true){
if((i__5727__auto___21040 < len__5726__auto___21039)){
args20990.push((arguments[i__5727__auto___21040]));

var G__21041 = (i__5727__auto___21040 + (1));
i__5727__auto___21040 = G__21041;
continue;
} else {
}
break;
}

var G__20992 = args20990.length;
switch (G__20992) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20990.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___21043 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___21043,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___21043,out){
return (function (state_21016){
var state_val_21017 = (state_21016[(1)]);
if((state_val_21017 === (7))){
var inst_20998 = (state_21016[(7)]);
var inst_20998__$1 = (state_21016[(2)]);
var inst_20999 = (inst_20998__$1 == null);
var inst_21000 = cljs.core.not.call(null,inst_20999);
var state_21016__$1 = (function (){var statearr_21018 = state_21016;
(statearr_21018[(7)] = inst_20998__$1);

return statearr_21018;
})();
if(inst_21000){
var statearr_21019_21044 = state_21016__$1;
(statearr_21019_21044[(1)] = (8));

} else {
var statearr_21020_21045 = state_21016__$1;
(statearr_21020_21045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (1))){
var inst_20993 = (0);
var state_21016__$1 = (function (){var statearr_21021 = state_21016;
(statearr_21021[(8)] = inst_20993);

return statearr_21021;
})();
var statearr_21022_21046 = state_21016__$1;
(statearr_21022_21046[(2)] = null);

(statearr_21022_21046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (4))){
var state_21016__$1 = state_21016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21016__$1,(7),ch);
} else {
if((state_val_21017 === (6))){
var inst_21011 = (state_21016[(2)]);
var state_21016__$1 = state_21016;
var statearr_21023_21047 = state_21016__$1;
(statearr_21023_21047[(2)] = inst_21011);

(statearr_21023_21047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (3))){
var inst_21013 = (state_21016[(2)]);
var inst_21014 = cljs.core.async.close_BANG_.call(null,out);
var state_21016__$1 = (function (){var statearr_21024 = state_21016;
(statearr_21024[(9)] = inst_21013);

return statearr_21024;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21016__$1,inst_21014);
} else {
if((state_val_21017 === (2))){
var inst_20993 = (state_21016[(8)]);
var inst_20995 = (inst_20993 < n);
var state_21016__$1 = state_21016;
if(cljs.core.truth_(inst_20995)){
var statearr_21025_21048 = state_21016__$1;
(statearr_21025_21048[(1)] = (4));

} else {
var statearr_21026_21049 = state_21016__$1;
(statearr_21026_21049[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (11))){
var inst_20993 = (state_21016[(8)]);
var inst_21003 = (state_21016[(2)]);
var inst_21004 = (inst_20993 + (1));
var inst_20993__$1 = inst_21004;
var state_21016__$1 = (function (){var statearr_21027 = state_21016;
(statearr_21027[(10)] = inst_21003);

(statearr_21027[(8)] = inst_20993__$1);

return statearr_21027;
})();
var statearr_21028_21050 = state_21016__$1;
(statearr_21028_21050[(2)] = null);

(statearr_21028_21050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (9))){
var state_21016__$1 = state_21016;
var statearr_21029_21051 = state_21016__$1;
(statearr_21029_21051[(2)] = null);

(statearr_21029_21051[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (5))){
var state_21016__$1 = state_21016;
var statearr_21030_21052 = state_21016__$1;
(statearr_21030_21052[(2)] = null);

(statearr_21030_21052[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (10))){
var inst_21008 = (state_21016[(2)]);
var state_21016__$1 = state_21016;
var statearr_21031_21053 = state_21016__$1;
(statearr_21031_21053[(2)] = inst_21008);

(statearr_21031_21053[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (8))){
var inst_20998 = (state_21016[(7)]);
var state_21016__$1 = state_21016;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21016__$1,(11),out,inst_20998);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___21043,out))
;
return ((function (switch__10949__auto__,c__11061__auto___21043,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_21035 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21035[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_21035[(1)] = (1));

return statearr_21035;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_21016){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_21016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e21036){if((e21036 instanceof Object)){
var ex__10953__auto__ = e21036;
var statearr_21037_21054 = state_21016;
(statearr_21037_21054[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21016);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21036;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21055 = state_21016;
state_21016 = G__21055;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_21016){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_21016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___21043,out))
})();
var state__11063__auto__ = (function (){var statearr_21038 = f__11062__auto__.call(null);
(statearr_21038[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___21043);

return statearr_21038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___21043,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21063 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21063 = (function (map_LT_,f,ch,meta21064){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21064 = meta21064;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21065,meta21064__$1){
var self__ = this;
var _21065__$1 = this;
return (new cljs.core.async.t_cljs$core$async21063(self__.map_LT_,self__.f,self__.ch,meta21064__$1));
});

cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21065){
var self__ = this;
var _21065__$1 = this;
return self__.meta21064;
});

cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21066 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21066 = (function (map_LT_,f,ch,meta21064,_,fn1,meta21067){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21064 = meta21064;
this._ = _;
this.fn1 = fn1;
this.meta21067 = meta21067;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21066.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21068,meta21067__$1){
var self__ = this;
var _21068__$1 = this;
return (new cljs.core.async.t_cljs$core$async21066(self__.map_LT_,self__.f,self__.ch,self__.meta21064,self__._,self__.fn1,meta21067__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21066.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21068){
var self__ = this;
var _21068__$1 = this;
return self__.meta21067;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21066.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21066.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21066.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21066.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21056_SHARP_){
return f1.call(null,(((p1__21056_SHARP_ == null))?null:self__.f.call(null,p1__21056_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21066.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21064","meta21064",-1392488243,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21063","cljs.core.async/t_cljs$core$async21063",-1352264430,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21067","meta21067",-1463762527,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21066.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21066.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21066";

cljs.core.async.t_cljs$core$async21066.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21066");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21066 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21066(map_LT___$1,f__$1,ch__$1,meta21064__$1,___$2,fn1__$1,meta21067){
return (new cljs.core.async.t_cljs$core$async21066(map_LT___$1,f__$1,ch__$1,meta21064__$1,___$2,fn1__$1,meta21067));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21066(self__.map_LT_,self__.f,self__.ch,self__.meta21064,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21063.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21063.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21064","meta21064",-1392488243,null)], null);
});

cljs.core.async.t_cljs$core$async21063.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21063.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21063";

cljs.core.async.t_cljs$core$async21063.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21063");
});

cljs.core.async.__GT_t_cljs$core$async21063 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21063(map_LT___$1,f__$1,ch__$1,meta21064){
return (new cljs.core.async.t_cljs$core$async21063(map_LT___$1,f__$1,ch__$1,meta21064));
});

}

return (new cljs.core.async.t_cljs$core$async21063(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21072 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21072 = (function (map_GT_,f,ch,meta21073){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21073 = meta21073;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21072.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21074,meta21073__$1){
var self__ = this;
var _21074__$1 = this;
return (new cljs.core.async.t_cljs$core$async21072(self__.map_GT_,self__.f,self__.ch,meta21073__$1));
});

cljs.core.async.t_cljs$core$async21072.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21074){
var self__ = this;
var _21074__$1 = this;
return self__.meta21073;
});

cljs.core.async.t_cljs$core$async21072.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21072.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21072.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21072.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21072.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21072.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21072.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21073","meta21073",1859497391,null)], null);
});

cljs.core.async.t_cljs$core$async21072.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21072.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21072";

cljs.core.async.t_cljs$core$async21072.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21072");
});

cljs.core.async.__GT_t_cljs$core$async21072 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21072(map_GT___$1,f__$1,ch__$1,meta21073){
return (new cljs.core.async.t_cljs$core$async21072(map_GT___$1,f__$1,ch__$1,meta21073));
});

}

return (new cljs.core.async.t_cljs$core$async21072(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21078 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21078 = (function (filter_GT_,p,ch,meta21079){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21079 = meta21079;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21080,meta21079__$1){
var self__ = this;
var _21080__$1 = this;
return (new cljs.core.async.t_cljs$core$async21078(self__.filter_GT_,self__.p,self__.ch,meta21079__$1));
});

cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21080){
var self__ = this;
var _21080__$1 = this;
return self__.meta21079;
});

cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21078.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21078.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21079","meta21079",1480758416,null)], null);
});

cljs.core.async.t_cljs$core$async21078.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21078.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21078";

cljs.core.async.t_cljs$core$async21078.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21078");
});

cljs.core.async.__GT_t_cljs$core$async21078 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21078(filter_GT___$1,p__$1,ch__$1,meta21079){
return (new cljs.core.async.t_cljs$core$async21078(filter_GT___$1,p__$1,ch__$1,meta21079));
});

}

return (new cljs.core.async.t_cljs$core$async21078(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21081 = [];
var len__5726__auto___21125 = arguments.length;
var i__5727__auto___21126 = (0);
while(true){
if((i__5727__auto___21126 < len__5726__auto___21125)){
args21081.push((arguments[i__5727__auto___21126]));

var G__21127 = (i__5727__auto___21126 + (1));
i__5727__auto___21126 = G__21127;
continue;
} else {
}
break;
}

var G__21083 = args21081.length;
switch (G__21083) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21081.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___21129 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___21129,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___21129,out){
return (function (state_21104){
var state_val_21105 = (state_21104[(1)]);
if((state_val_21105 === (7))){
var inst_21100 = (state_21104[(2)]);
var state_21104__$1 = state_21104;
var statearr_21106_21130 = state_21104__$1;
(statearr_21106_21130[(2)] = inst_21100);

(statearr_21106_21130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21105 === (1))){
var state_21104__$1 = state_21104;
var statearr_21107_21131 = state_21104__$1;
(statearr_21107_21131[(2)] = null);

(statearr_21107_21131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21105 === (4))){
var inst_21086 = (state_21104[(7)]);
var inst_21086__$1 = (state_21104[(2)]);
var inst_21087 = (inst_21086__$1 == null);
var state_21104__$1 = (function (){var statearr_21108 = state_21104;
(statearr_21108[(7)] = inst_21086__$1);

return statearr_21108;
})();
if(cljs.core.truth_(inst_21087)){
var statearr_21109_21132 = state_21104__$1;
(statearr_21109_21132[(1)] = (5));

} else {
var statearr_21110_21133 = state_21104__$1;
(statearr_21110_21133[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21105 === (6))){
var inst_21086 = (state_21104[(7)]);
var inst_21091 = p.call(null,inst_21086);
var state_21104__$1 = state_21104;
if(cljs.core.truth_(inst_21091)){
var statearr_21111_21134 = state_21104__$1;
(statearr_21111_21134[(1)] = (8));

} else {
var statearr_21112_21135 = state_21104__$1;
(statearr_21112_21135[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21105 === (3))){
var inst_21102 = (state_21104[(2)]);
var state_21104__$1 = state_21104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21104__$1,inst_21102);
} else {
if((state_val_21105 === (2))){
var state_21104__$1 = state_21104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21104__$1,(4),ch);
} else {
if((state_val_21105 === (11))){
var inst_21094 = (state_21104[(2)]);
var state_21104__$1 = state_21104;
var statearr_21113_21136 = state_21104__$1;
(statearr_21113_21136[(2)] = inst_21094);

(statearr_21113_21136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21105 === (9))){
var state_21104__$1 = state_21104;
var statearr_21114_21137 = state_21104__$1;
(statearr_21114_21137[(2)] = null);

(statearr_21114_21137[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21105 === (5))){
var inst_21089 = cljs.core.async.close_BANG_.call(null,out);
var state_21104__$1 = state_21104;
var statearr_21115_21138 = state_21104__$1;
(statearr_21115_21138[(2)] = inst_21089);

(statearr_21115_21138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21105 === (10))){
var inst_21097 = (state_21104[(2)]);
var state_21104__$1 = (function (){var statearr_21116 = state_21104;
(statearr_21116[(8)] = inst_21097);

return statearr_21116;
})();
var statearr_21117_21139 = state_21104__$1;
(statearr_21117_21139[(2)] = null);

(statearr_21117_21139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21105 === (8))){
var inst_21086 = (state_21104[(7)]);
var state_21104__$1 = state_21104;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21104__$1,(11),out,inst_21086);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___21129,out))
;
return ((function (switch__10949__auto__,c__11061__auto___21129,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_21121 = [null,null,null,null,null,null,null,null,null];
(statearr_21121[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_21121[(1)] = (1));

return statearr_21121;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_21104){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_21104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e21122){if((e21122 instanceof Object)){
var ex__10953__auto__ = e21122;
var statearr_21123_21140 = state_21104;
(statearr_21123_21140[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21104);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21122;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21141 = state_21104;
state_21104 = G__21141;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_21104){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_21104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___21129,out))
})();
var state__11063__auto__ = (function (){var statearr_21124 = f__11062__auto__.call(null);
(statearr_21124[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___21129);

return statearr_21124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___21129,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21142 = [];
var len__5726__auto___21145 = arguments.length;
var i__5727__auto___21146 = (0);
while(true){
if((i__5727__auto___21146 < len__5726__auto___21145)){
args21142.push((arguments[i__5727__auto___21146]));

var G__21147 = (i__5727__auto___21146 + (1));
i__5727__auto___21146 = G__21147;
continue;
} else {
}
break;
}

var G__21144 = args21142.length;
switch (G__21144) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21142.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11061__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto__){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto__){
return (function (state_21314){
var state_val_21315 = (state_21314[(1)]);
if((state_val_21315 === (7))){
var inst_21310 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
var statearr_21316_21357 = state_21314__$1;
(statearr_21316_21357[(2)] = inst_21310);

(statearr_21316_21357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (20))){
var inst_21280 = (state_21314[(7)]);
var inst_21291 = (state_21314[(2)]);
var inst_21292 = cljs.core.next.call(null,inst_21280);
var inst_21266 = inst_21292;
var inst_21267 = null;
var inst_21268 = (0);
var inst_21269 = (0);
var state_21314__$1 = (function (){var statearr_21317 = state_21314;
(statearr_21317[(8)] = inst_21268);

(statearr_21317[(9)] = inst_21269);

(statearr_21317[(10)] = inst_21266);

(statearr_21317[(11)] = inst_21291);

(statearr_21317[(12)] = inst_21267);

return statearr_21317;
})();
var statearr_21318_21358 = state_21314__$1;
(statearr_21318_21358[(2)] = null);

(statearr_21318_21358[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (1))){
var state_21314__$1 = state_21314;
var statearr_21319_21359 = state_21314__$1;
(statearr_21319_21359[(2)] = null);

(statearr_21319_21359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (4))){
var inst_21255 = (state_21314[(13)]);
var inst_21255__$1 = (state_21314[(2)]);
var inst_21256 = (inst_21255__$1 == null);
var state_21314__$1 = (function (){var statearr_21320 = state_21314;
(statearr_21320[(13)] = inst_21255__$1);

return statearr_21320;
})();
if(cljs.core.truth_(inst_21256)){
var statearr_21321_21360 = state_21314__$1;
(statearr_21321_21360[(1)] = (5));

} else {
var statearr_21322_21361 = state_21314__$1;
(statearr_21322_21361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (15))){
var state_21314__$1 = state_21314;
var statearr_21326_21362 = state_21314__$1;
(statearr_21326_21362[(2)] = null);

(statearr_21326_21362[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (21))){
var state_21314__$1 = state_21314;
var statearr_21327_21363 = state_21314__$1;
(statearr_21327_21363[(2)] = null);

(statearr_21327_21363[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (13))){
var inst_21268 = (state_21314[(8)]);
var inst_21269 = (state_21314[(9)]);
var inst_21266 = (state_21314[(10)]);
var inst_21267 = (state_21314[(12)]);
var inst_21276 = (state_21314[(2)]);
var inst_21277 = (inst_21269 + (1));
var tmp21323 = inst_21268;
var tmp21324 = inst_21266;
var tmp21325 = inst_21267;
var inst_21266__$1 = tmp21324;
var inst_21267__$1 = tmp21325;
var inst_21268__$1 = tmp21323;
var inst_21269__$1 = inst_21277;
var state_21314__$1 = (function (){var statearr_21328 = state_21314;
(statearr_21328[(8)] = inst_21268__$1);

(statearr_21328[(14)] = inst_21276);

(statearr_21328[(9)] = inst_21269__$1);

(statearr_21328[(10)] = inst_21266__$1);

(statearr_21328[(12)] = inst_21267__$1);

return statearr_21328;
})();
var statearr_21329_21364 = state_21314__$1;
(statearr_21329_21364[(2)] = null);

(statearr_21329_21364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (22))){
var state_21314__$1 = state_21314;
var statearr_21330_21365 = state_21314__$1;
(statearr_21330_21365[(2)] = null);

(statearr_21330_21365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (6))){
var inst_21255 = (state_21314[(13)]);
var inst_21264 = f.call(null,inst_21255);
var inst_21265 = cljs.core.seq.call(null,inst_21264);
var inst_21266 = inst_21265;
var inst_21267 = null;
var inst_21268 = (0);
var inst_21269 = (0);
var state_21314__$1 = (function (){var statearr_21331 = state_21314;
(statearr_21331[(8)] = inst_21268);

(statearr_21331[(9)] = inst_21269);

(statearr_21331[(10)] = inst_21266);

(statearr_21331[(12)] = inst_21267);

return statearr_21331;
})();
var statearr_21332_21366 = state_21314__$1;
(statearr_21332_21366[(2)] = null);

(statearr_21332_21366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (17))){
var inst_21280 = (state_21314[(7)]);
var inst_21284 = cljs.core.chunk_first.call(null,inst_21280);
var inst_21285 = cljs.core.chunk_rest.call(null,inst_21280);
var inst_21286 = cljs.core.count.call(null,inst_21284);
var inst_21266 = inst_21285;
var inst_21267 = inst_21284;
var inst_21268 = inst_21286;
var inst_21269 = (0);
var state_21314__$1 = (function (){var statearr_21333 = state_21314;
(statearr_21333[(8)] = inst_21268);

(statearr_21333[(9)] = inst_21269);

(statearr_21333[(10)] = inst_21266);

(statearr_21333[(12)] = inst_21267);

return statearr_21333;
})();
var statearr_21334_21367 = state_21314__$1;
(statearr_21334_21367[(2)] = null);

(statearr_21334_21367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (3))){
var inst_21312 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21314__$1,inst_21312);
} else {
if((state_val_21315 === (12))){
var inst_21300 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
var statearr_21335_21368 = state_21314__$1;
(statearr_21335_21368[(2)] = inst_21300);

(statearr_21335_21368[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (2))){
var state_21314__$1 = state_21314;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21314__$1,(4),in$);
} else {
if((state_val_21315 === (23))){
var inst_21308 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
var statearr_21336_21369 = state_21314__$1;
(statearr_21336_21369[(2)] = inst_21308);

(statearr_21336_21369[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (19))){
var inst_21295 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
var statearr_21337_21370 = state_21314__$1;
(statearr_21337_21370[(2)] = inst_21295);

(statearr_21337_21370[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (11))){
var inst_21266 = (state_21314[(10)]);
var inst_21280 = (state_21314[(7)]);
var inst_21280__$1 = cljs.core.seq.call(null,inst_21266);
var state_21314__$1 = (function (){var statearr_21338 = state_21314;
(statearr_21338[(7)] = inst_21280__$1);

return statearr_21338;
})();
if(inst_21280__$1){
var statearr_21339_21371 = state_21314__$1;
(statearr_21339_21371[(1)] = (14));

} else {
var statearr_21340_21372 = state_21314__$1;
(statearr_21340_21372[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (9))){
var inst_21302 = (state_21314[(2)]);
var inst_21303 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21314__$1 = (function (){var statearr_21341 = state_21314;
(statearr_21341[(15)] = inst_21302);

return statearr_21341;
})();
if(cljs.core.truth_(inst_21303)){
var statearr_21342_21373 = state_21314__$1;
(statearr_21342_21373[(1)] = (21));

} else {
var statearr_21343_21374 = state_21314__$1;
(statearr_21343_21374[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (5))){
var inst_21258 = cljs.core.async.close_BANG_.call(null,out);
var state_21314__$1 = state_21314;
var statearr_21344_21375 = state_21314__$1;
(statearr_21344_21375[(2)] = inst_21258);

(statearr_21344_21375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (14))){
var inst_21280 = (state_21314[(7)]);
var inst_21282 = cljs.core.chunked_seq_QMARK_.call(null,inst_21280);
var state_21314__$1 = state_21314;
if(inst_21282){
var statearr_21345_21376 = state_21314__$1;
(statearr_21345_21376[(1)] = (17));

} else {
var statearr_21346_21377 = state_21314__$1;
(statearr_21346_21377[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (16))){
var inst_21298 = (state_21314[(2)]);
var state_21314__$1 = state_21314;
var statearr_21347_21378 = state_21314__$1;
(statearr_21347_21378[(2)] = inst_21298);

(statearr_21347_21378[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21315 === (10))){
var inst_21269 = (state_21314[(9)]);
var inst_21267 = (state_21314[(12)]);
var inst_21274 = cljs.core._nth.call(null,inst_21267,inst_21269);
var state_21314__$1 = state_21314;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21314__$1,(13),out,inst_21274);
} else {
if((state_val_21315 === (18))){
var inst_21280 = (state_21314[(7)]);
var inst_21289 = cljs.core.first.call(null,inst_21280);
var state_21314__$1 = state_21314;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21314__$1,(20),out,inst_21289);
} else {
if((state_val_21315 === (8))){
var inst_21268 = (state_21314[(8)]);
var inst_21269 = (state_21314[(9)]);
var inst_21271 = (inst_21269 < inst_21268);
var inst_21272 = inst_21271;
var state_21314__$1 = state_21314;
if(cljs.core.truth_(inst_21272)){
var statearr_21348_21379 = state_21314__$1;
(statearr_21348_21379[(1)] = (10));

} else {
var statearr_21349_21380 = state_21314__$1;
(statearr_21349_21380[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto__))
;
return ((function (switch__10949__auto__,c__11061__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____0 = (function (){
var statearr_21353 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21353[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__);

(statearr_21353[(1)] = (1));

return statearr_21353;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____1 = (function (state_21314){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_21314);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e21354){if((e21354 instanceof Object)){
var ex__10953__auto__ = e21354;
var statearr_21355_21381 = state_21314;
(statearr_21355_21381[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21314);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21354;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21382 = state_21314;
state_21314 = G__21382;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__ = function(state_21314){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____1.call(this,state_21314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10950__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto__))
})();
var state__11063__auto__ = (function (){var statearr_21356 = f__11062__auto__.call(null);
(statearr_21356[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto__);

return statearr_21356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto__))
);

return c__11061__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21383 = [];
var len__5726__auto___21386 = arguments.length;
var i__5727__auto___21387 = (0);
while(true){
if((i__5727__auto___21387 < len__5726__auto___21386)){
args21383.push((arguments[i__5727__auto___21387]));

var G__21388 = (i__5727__auto___21387 + (1));
i__5727__auto___21387 = G__21388;
continue;
} else {
}
break;
}

var G__21385 = args21383.length;
switch (G__21385) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21383.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21390 = [];
var len__5726__auto___21393 = arguments.length;
var i__5727__auto___21394 = (0);
while(true){
if((i__5727__auto___21394 < len__5726__auto___21393)){
args21390.push((arguments[i__5727__auto___21394]));

var G__21395 = (i__5727__auto___21394 + (1));
i__5727__auto___21394 = G__21395;
continue;
} else {
}
break;
}

var G__21392 = args21390.length;
switch (G__21392) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21390.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21397 = [];
var len__5726__auto___21448 = arguments.length;
var i__5727__auto___21449 = (0);
while(true){
if((i__5727__auto___21449 < len__5726__auto___21448)){
args21397.push((arguments[i__5727__auto___21449]));

var G__21450 = (i__5727__auto___21449 + (1));
i__5727__auto___21449 = G__21450;
continue;
} else {
}
break;
}

var G__21399 = args21397.length;
switch (G__21399) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21397.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___21452 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___21452,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___21452,out){
return (function (state_21423){
var state_val_21424 = (state_21423[(1)]);
if((state_val_21424 === (7))){
var inst_21418 = (state_21423[(2)]);
var state_21423__$1 = state_21423;
var statearr_21425_21453 = state_21423__$1;
(statearr_21425_21453[(2)] = inst_21418);

(statearr_21425_21453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21424 === (1))){
var inst_21400 = null;
var state_21423__$1 = (function (){var statearr_21426 = state_21423;
(statearr_21426[(7)] = inst_21400);

return statearr_21426;
})();
var statearr_21427_21454 = state_21423__$1;
(statearr_21427_21454[(2)] = null);

(statearr_21427_21454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21424 === (4))){
var inst_21403 = (state_21423[(8)]);
var inst_21403__$1 = (state_21423[(2)]);
var inst_21404 = (inst_21403__$1 == null);
var inst_21405 = cljs.core.not.call(null,inst_21404);
var state_21423__$1 = (function (){var statearr_21428 = state_21423;
(statearr_21428[(8)] = inst_21403__$1);

return statearr_21428;
})();
if(inst_21405){
var statearr_21429_21455 = state_21423__$1;
(statearr_21429_21455[(1)] = (5));

} else {
var statearr_21430_21456 = state_21423__$1;
(statearr_21430_21456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21424 === (6))){
var state_21423__$1 = state_21423;
var statearr_21431_21457 = state_21423__$1;
(statearr_21431_21457[(2)] = null);

(statearr_21431_21457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21424 === (3))){
var inst_21420 = (state_21423[(2)]);
var inst_21421 = cljs.core.async.close_BANG_.call(null,out);
var state_21423__$1 = (function (){var statearr_21432 = state_21423;
(statearr_21432[(9)] = inst_21420);

return statearr_21432;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21423__$1,inst_21421);
} else {
if((state_val_21424 === (2))){
var state_21423__$1 = state_21423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21423__$1,(4),ch);
} else {
if((state_val_21424 === (11))){
var inst_21403 = (state_21423[(8)]);
var inst_21412 = (state_21423[(2)]);
var inst_21400 = inst_21403;
var state_21423__$1 = (function (){var statearr_21433 = state_21423;
(statearr_21433[(7)] = inst_21400);

(statearr_21433[(10)] = inst_21412);

return statearr_21433;
})();
var statearr_21434_21458 = state_21423__$1;
(statearr_21434_21458[(2)] = null);

(statearr_21434_21458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21424 === (9))){
var inst_21403 = (state_21423[(8)]);
var state_21423__$1 = state_21423;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21423__$1,(11),out,inst_21403);
} else {
if((state_val_21424 === (5))){
var inst_21400 = (state_21423[(7)]);
var inst_21403 = (state_21423[(8)]);
var inst_21407 = cljs.core._EQ_.call(null,inst_21403,inst_21400);
var state_21423__$1 = state_21423;
if(inst_21407){
var statearr_21436_21459 = state_21423__$1;
(statearr_21436_21459[(1)] = (8));

} else {
var statearr_21437_21460 = state_21423__$1;
(statearr_21437_21460[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21424 === (10))){
var inst_21415 = (state_21423[(2)]);
var state_21423__$1 = state_21423;
var statearr_21438_21461 = state_21423__$1;
(statearr_21438_21461[(2)] = inst_21415);

(statearr_21438_21461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21424 === (8))){
var inst_21400 = (state_21423[(7)]);
var tmp21435 = inst_21400;
var inst_21400__$1 = tmp21435;
var state_21423__$1 = (function (){var statearr_21439 = state_21423;
(statearr_21439[(7)] = inst_21400__$1);

return statearr_21439;
})();
var statearr_21440_21462 = state_21423__$1;
(statearr_21440_21462[(2)] = null);

(statearr_21440_21462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___21452,out))
;
return ((function (switch__10949__auto__,c__11061__auto___21452,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_21444 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21444[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_21444[(1)] = (1));

return statearr_21444;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_21423){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_21423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e21445){if((e21445 instanceof Object)){
var ex__10953__auto__ = e21445;
var statearr_21446_21463 = state_21423;
(statearr_21446_21463[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21423);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21445;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21464 = state_21423;
state_21423 = G__21464;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_21423){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_21423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___21452,out))
})();
var state__11063__auto__ = (function (){var statearr_21447 = f__11062__auto__.call(null);
(statearr_21447[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___21452);

return statearr_21447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___21452,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21465 = [];
var len__5726__auto___21535 = arguments.length;
var i__5727__auto___21536 = (0);
while(true){
if((i__5727__auto___21536 < len__5726__auto___21535)){
args21465.push((arguments[i__5727__auto___21536]));

var G__21537 = (i__5727__auto___21536 + (1));
i__5727__auto___21536 = G__21537;
continue;
} else {
}
break;
}

var G__21467 = args21465.length;
switch (G__21467) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21465.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___21539 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___21539,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___21539,out){
return (function (state_21505){
var state_val_21506 = (state_21505[(1)]);
if((state_val_21506 === (7))){
var inst_21501 = (state_21505[(2)]);
var state_21505__$1 = state_21505;
var statearr_21507_21540 = state_21505__$1;
(statearr_21507_21540[(2)] = inst_21501);

(statearr_21507_21540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (1))){
var inst_21468 = (new Array(n));
var inst_21469 = inst_21468;
var inst_21470 = (0);
var state_21505__$1 = (function (){var statearr_21508 = state_21505;
(statearr_21508[(7)] = inst_21469);

(statearr_21508[(8)] = inst_21470);

return statearr_21508;
})();
var statearr_21509_21541 = state_21505__$1;
(statearr_21509_21541[(2)] = null);

(statearr_21509_21541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (4))){
var inst_21473 = (state_21505[(9)]);
var inst_21473__$1 = (state_21505[(2)]);
var inst_21474 = (inst_21473__$1 == null);
var inst_21475 = cljs.core.not.call(null,inst_21474);
var state_21505__$1 = (function (){var statearr_21510 = state_21505;
(statearr_21510[(9)] = inst_21473__$1);

return statearr_21510;
})();
if(inst_21475){
var statearr_21511_21542 = state_21505__$1;
(statearr_21511_21542[(1)] = (5));

} else {
var statearr_21512_21543 = state_21505__$1;
(statearr_21512_21543[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (15))){
var inst_21495 = (state_21505[(2)]);
var state_21505__$1 = state_21505;
var statearr_21513_21544 = state_21505__$1;
(statearr_21513_21544[(2)] = inst_21495);

(statearr_21513_21544[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (13))){
var state_21505__$1 = state_21505;
var statearr_21514_21545 = state_21505__$1;
(statearr_21514_21545[(2)] = null);

(statearr_21514_21545[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (6))){
var inst_21470 = (state_21505[(8)]);
var inst_21491 = (inst_21470 > (0));
var state_21505__$1 = state_21505;
if(cljs.core.truth_(inst_21491)){
var statearr_21515_21546 = state_21505__$1;
(statearr_21515_21546[(1)] = (12));

} else {
var statearr_21516_21547 = state_21505__$1;
(statearr_21516_21547[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (3))){
var inst_21503 = (state_21505[(2)]);
var state_21505__$1 = state_21505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21505__$1,inst_21503);
} else {
if((state_val_21506 === (12))){
var inst_21469 = (state_21505[(7)]);
var inst_21493 = cljs.core.vec.call(null,inst_21469);
var state_21505__$1 = state_21505;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21505__$1,(15),out,inst_21493);
} else {
if((state_val_21506 === (2))){
var state_21505__$1 = state_21505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21505__$1,(4),ch);
} else {
if((state_val_21506 === (11))){
var inst_21485 = (state_21505[(2)]);
var inst_21486 = (new Array(n));
var inst_21469 = inst_21486;
var inst_21470 = (0);
var state_21505__$1 = (function (){var statearr_21517 = state_21505;
(statearr_21517[(7)] = inst_21469);

(statearr_21517[(8)] = inst_21470);

(statearr_21517[(10)] = inst_21485);

return statearr_21517;
})();
var statearr_21518_21548 = state_21505__$1;
(statearr_21518_21548[(2)] = null);

(statearr_21518_21548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (9))){
var inst_21469 = (state_21505[(7)]);
var inst_21483 = cljs.core.vec.call(null,inst_21469);
var state_21505__$1 = state_21505;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21505__$1,(11),out,inst_21483);
} else {
if((state_val_21506 === (5))){
var inst_21473 = (state_21505[(9)]);
var inst_21469 = (state_21505[(7)]);
var inst_21470 = (state_21505[(8)]);
var inst_21478 = (state_21505[(11)]);
var inst_21477 = (inst_21469[inst_21470] = inst_21473);
var inst_21478__$1 = (inst_21470 + (1));
var inst_21479 = (inst_21478__$1 < n);
var state_21505__$1 = (function (){var statearr_21519 = state_21505;
(statearr_21519[(12)] = inst_21477);

(statearr_21519[(11)] = inst_21478__$1);

return statearr_21519;
})();
if(cljs.core.truth_(inst_21479)){
var statearr_21520_21549 = state_21505__$1;
(statearr_21520_21549[(1)] = (8));

} else {
var statearr_21521_21550 = state_21505__$1;
(statearr_21521_21550[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (14))){
var inst_21498 = (state_21505[(2)]);
var inst_21499 = cljs.core.async.close_BANG_.call(null,out);
var state_21505__$1 = (function (){var statearr_21523 = state_21505;
(statearr_21523[(13)] = inst_21498);

return statearr_21523;
})();
var statearr_21524_21551 = state_21505__$1;
(statearr_21524_21551[(2)] = inst_21499);

(statearr_21524_21551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (10))){
var inst_21489 = (state_21505[(2)]);
var state_21505__$1 = state_21505;
var statearr_21525_21552 = state_21505__$1;
(statearr_21525_21552[(2)] = inst_21489);

(statearr_21525_21552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (8))){
var inst_21469 = (state_21505[(7)]);
var inst_21478 = (state_21505[(11)]);
var tmp21522 = inst_21469;
var inst_21469__$1 = tmp21522;
var inst_21470 = inst_21478;
var state_21505__$1 = (function (){var statearr_21526 = state_21505;
(statearr_21526[(7)] = inst_21469__$1);

(statearr_21526[(8)] = inst_21470);

return statearr_21526;
})();
var statearr_21527_21553 = state_21505__$1;
(statearr_21527_21553[(2)] = null);

(statearr_21527_21553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___21539,out))
;
return ((function (switch__10949__auto__,c__11061__auto___21539,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_21531 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21531[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_21531[(1)] = (1));

return statearr_21531;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_21505){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_21505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e21532){if((e21532 instanceof Object)){
var ex__10953__auto__ = e21532;
var statearr_21533_21554 = state_21505;
(statearr_21533_21554[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21505);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21532;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21555 = state_21505;
state_21505 = G__21555;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_21505){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_21505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___21539,out))
})();
var state__11063__auto__ = (function (){var statearr_21534 = f__11062__auto__.call(null);
(statearr_21534[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___21539);

return statearr_21534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___21539,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21556 = [];
var len__5726__auto___21630 = arguments.length;
var i__5727__auto___21631 = (0);
while(true){
if((i__5727__auto___21631 < len__5726__auto___21630)){
args21556.push((arguments[i__5727__auto___21631]));

var G__21632 = (i__5727__auto___21631 + (1));
i__5727__auto___21631 = G__21632;
continue;
} else {
}
break;
}

var G__21558 = args21556.length;
switch (G__21558) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21556.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11061__auto___21634 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11061__auto___21634,out){
return (function (){
var f__11062__auto__ = (function (){var switch__10949__auto__ = ((function (c__11061__auto___21634,out){
return (function (state_21600){
var state_val_21601 = (state_21600[(1)]);
if((state_val_21601 === (7))){
var inst_21596 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21602_21635 = state_21600__$1;
(statearr_21602_21635[(2)] = inst_21596);

(statearr_21602_21635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (1))){
var inst_21559 = [];
var inst_21560 = inst_21559;
var inst_21561 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21600__$1 = (function (){var statearr_21603 = state_21600;
(statearr_21603[(7)] = inst_21560);

(statearr_21603[(8)] = inst_21561);

return statearr_21603;
})();
var statearr_21604_21636 = state_21600__$1;
(statearr_21604_21636[(2)] = null);

(statearr_21604_21636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (4))){
var inst_21564 = (state_21600[(9)]);
var inst_21564__$1 = (state_21600[(2)]);
var inst_21565 = (inst_21564__$1 == null);
var inst_21566 = cljs.core.not.call(null,inst_21565);
var state_21600__$1 = (function (){var statearr_21605 = state_21600;
(statearr_21605[(9)] = inst_21564__$1);

return statearr_21605;
})();
if(inst_21566){
var statearr_21606_21637 = state_21600__$1;
(statearr_21606_21637[(1)] = (5));

} else {
var statearr_21607_21638 = state_21600__$1;
(statearr_21607_21638[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (15))){
var inst_21590 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21608_21639 = state_21600__$1;
(statearr_21608_21639[(2)] = inst_21590);

(statearr_21608_21639[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (13))){
var state_21600__$1 = state_21600;
var statearr_21609_21640 = state_21600__$1;
(statearr_21609_21640[(2)] = null);

(statearr_21609_21640[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (6))){
var inst_21560 = (state_21600[(7)]);
var inst_21585 = inst_21560.length;
var inst_21586 = (inst_21585 > (0));
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21586)){
var statearr_21610_21641 = state_21600__$1;
(statearr_21610_21641[(1)] = (12));

} else {
var statearr_21611_21642 = state_21600__$1;
(statearr_21611_21642[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (3))){
var inst_21598 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21600__$1,inst_21598);
} else {
if((state_val_21601 === (12))){
var inst_21560 = (state_21600[(7)]);
var inst_21588 = cljs.core.vec.call(null,inst_21560);
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21600__$1,(15),out,inst_21588);
} else {
if((state_val_21601 === (2))){
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21600__$1,(4),ch);
} else {
if((state_val_21601 === (11))){
var inst_21568 = (state_21600[(10)]);
var inst_21564 = (state_21600[(9)]);
var inst_21578 = (state_21600[(2)]);
var inst_21579 = [];
var inst_21580 = inst_21579.push(inst_21564);
var inst_21560 = inst_21579;
var inst_21561 = inst_21568;
var state_21600__$1 = (function (){var statearr_21612 = state_21600;
(statearr_21612[(7)] = inst_21560);

(statearr_21612[(11)] = inst_21578);

(statearr_21612[(8)] = inst_21561);

(statearr_21612[(12)] = inst_21580);

return statearr_21612;
})();
var statearr_21613_21643 = state_21600__$1;
(statearr_21613_21643[(2)] = null);

(statearr_21613_21643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (9))){
var inst_21560 = (state_21600[(7)]);
var inst_21576 = cljs.core.vec.call(null,inst_21560);
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21600__$1,(11),out,inst_21576);
} else {
if((state_val_21601 === (5))){
var inst_21568 = (state_21600[(10)]);
var inst_21561 = (state_21600[(8)]);
var inst_21564 = (state_21600[(9)]);
var inst_21568__$1 = f.call(null,inst_21564);
var inst_21569 = cljs.core._EQ_.call(null,inst_21568__$1,inst_21561);
var inst_21570 = cljs.core.keyword_identical_QMARK_.call(null,inst_21561,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21571 = (inst_21569) || (inst_21570);
var state_21600__$1 = (function (){var statearr_21614 = state_21600;
(statearr_21614[(10)] = inst_21568__$1);

return statearr_21614;
})();
if(cljs.core.truth_(inst_21571)){
var statearr_21615_21644 = state_21600__$1;
(statearr_21615_21644[(1)] = (8));

} else {
var statearr_21616_21645 = state_21600__$1;
(statearr_21616_21645[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (14))){
var inst_21593 = (state_21600[(2)]);
var inst_21594 = cljs.core.async.close_BANG_.call(null,out);
var state_21600__$1 = (function (){var statearr_21618 = state_21600;
(statearr_21618[(13)] = inst_21593);

return statearr_21618;
})();
var statearr_21619_21646 = state_21600__$1;
(statearr_21619_21646[(2)] = inst_21594);

(statearr_21619_21646[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (10))){
var inst_21583 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21620_21647 = state_21600__$1;
(statearr_21620_21647[(2)] = inst_21583);

(statearr_21620_21647[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (8))){
var inst_21560 = (state_21600[(7)]);
var inst_21568 = (state_21600[(10)]);
var inst_21564 = (state_21600[(9)]);
var inst_21573 = inst_21560.push(inst_21564);
var tmp21617 = inst_21560;
var inst_21560__$1 = tmp21617;
var inst_21561 = inst_21568;
var state_21600__$1 = (function (){var statearr_21621 = state_21600;
(statearr_21621[(7)] = inst_21560__$1);

(statearr_21621[(14)] = inst_21573);

(statearr_21621[(8)] = inst_21561);

return statearr_21621;
})();
var statearr_21622_21648 = state_21600__$1;
(statearr_21622_21648[(2)] = null);

(statearr_21622_21648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11061__auto___21634,out))
;
return ((function (switch__10949__auto__,c__11061__auto___21634,out){
return (function() {
var cljs$core$async$state_machine__10950__auto__ = null;
var cljs$core$async$state_machine__10950__auto____0 = (function (){
var statearr_21626 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21626[(0)] = cljs$core$async$state_machine__10950__auto__);

(statearr_21626[(1)] = (1));

return statearr_21626;
});
var cljs$core$async$state_machine__10950__auto____1 = (function (state_21600){
while(true){
var ret_value__10951__auto__ = (function (){try{while(true){
var result__10952__auto__ = switch__10949__auto__.call(null,state_21600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10952__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10952__auto__;
}
break;
}
}catch (e21627){if((e21627 instanceof Object)){
var ex__10953__auto__ = e21627;
var statearr_21628_21649 = state_21600;
(statearr_21628_21649[(5)] = ex__10953__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21600);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10951__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21650 = state_21600;
state_21600 = G__21650;
continue;
} else {
return ret_value__10951__auto__;
}
break;
}
});
cljs$core$async$state_machine__10950__auto__ = function(state_21600){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10950__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10950__auto____1.call(this,state_21600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10950__auto____0;
cljs$core$async$state_machine__10950__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10950__auto____1;
return cljs$core$async$state_machine__10950__auto__;
})()
;})(switch__10949__auto__,c__11061__auto___21634,out))
})();
var state__11063__auto__ = (function (){var statearr_21629 = f__11062__auto__.call(null);
(statearr_21629[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11061__auto___21634);

return statearr_21629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11063__auto__);
});})(c__11061__auto___21634,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1455098336476