// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__16204__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__16203 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__16203,(0),null);
var body = cljs.core.nthnext.call(null,vec__16203,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__16204 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16205__i = 0, G__16205__a = new Array(arguments.length -  0);
while (G__16205__i < G__16205__a.length) {G__16205__a[G__16205__i] = arguments[G__16205__i + 0]; ++G__16205__i;}
  args = new cljs.core.IndexedSeq(G__16205__a,0);
} 
return G__16204__delegate.call(this,args);};
G__16204.cljs$lang$maxFixedArity = 0;
G__16204.cljs$lang$applyTo = (function (arglist__16206){
var args = cljs.core.seq(arglist__16206);
return G__16204__delegate(args);
});
G__16204.cljs$core$IFn$_invoke$arity$variadic = G__16204__delegate;
return G__16204;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__16211(s__16212){
return (new cljs.core.LazySeq(null,(function (){
var s__16212__$1 = s__16212;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16212__$1);
if(temp__4425__auto__){
var s__16212__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16212__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16212__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16214 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16213 = (0);
while(true){
if((i__16213 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__16213);
cljs.core.chunk_append.call(null,b__16214,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__16215 = (i__16213 + (1));
i__16213 = G__16215;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16214),sablono$core$update_arglists_$_iter__16211.call(null,cljs.core.chunk_rest.call(null,s__16212__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16214),null);
}
} else {
var args = cljs.core.first.call(null,s__16212__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__16211.call(null,cljs.core.rest.call(null,s__16212__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16221 = arguments.length;
var i__5727__auto___16222 = (0);
while(true){
if((i__5727__auto___16222 < len__5726__auto___16221)){
args__5733__auto__.push((arguments[i__5727__auto___16222]));

var G__16223 = (i__5727__auto___16222 + (1));
i__5727__auto___16222 = G__16223;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__16217(s__16218){
return (new cljs.core.LazySeq(null,(function (){
var s__16218__$1 = s__16218;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16218__$1);
if(temp__4425__auto__){
var s__16218__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16218__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16218__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16220 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16219 = (0);
while(true){
if((i__16219 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__16219);
cljs.core.chunk_append.call(null,b__16220,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__16224 = (i__16219 + (1));
i__16219 = G__16224;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16220),sablono$core$iter__16217.call(null,cljs.core.chunk_rest.call(null,s__16218__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16220),null);
}
} else {
var style = cljs.core.first.call(null,s__16218__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__16217.call(null,cljs.core.rest.call(null,s__16218__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq16216){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16216));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to16225 = (function sablono$core$link_to16225(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16228 = arguments.length;
var i__5727__auto___16229 = (0);
while(true){
if((i__5727__auto___16229 < len__5726__auto___16228)){
args__5733__auto__.push((arguments[i__5727__auto___16229]));

var G__16230 = (i__5727__auto___16229 + (1));
i__5727__auto___16229 = G__16230;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to16225.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to16225.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to16225.cljs$lang$maxFixedArity = (1);

sablono.core.link_to16225.cljs$lang$applyTo = (function (seq16226){
var G__16227 = cljs.core.first.call(null,seq16226);
var seq16226__$1 = cljs.core.next.call(null,seq16226);
return sablono.core.link_to16225.cljs$core$IFn$_invoke$arity$variadic(G__16227,seq16226__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to16225);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to16231 = (function sablono$core$mail_to16231(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16236 = arguments.length;
var i__5727__auto___16237 = (0);
while(true){
if((i__5727__auto___16237 < len__5726__auto___16236)){
args__5733__auto__.push((arguments[i__5727__auto___16237]));

var G__16238 = (i__5727__auto___16237 + (1));
i__5727__auto___16237 = G__16238;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to16231.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to16231.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__16234){
var vec__16235 = p__16234;
var content = cljs.core.nth.call(null,vec__16235,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to16231.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to16231.cljs$lang$applyTo = (function (seq16232){
var G__16233 = cljs.core.first.call(null,seq16232);
var seq16232__$1 = cljs.core.next.call(null,seq16232);
return sablono.core.mail_to16231.cljs$core$IFn$_invoke$arity$variadic(G__16233,seq16232__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to16231);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list16239 = (function sablono$core$unordered_list16239(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list16239_$_iter__16244(s__16245){
return (new cljs.core.LazySeq(null,(function (){
var s__16245__$1 = s__16245;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16245__$1);
if(temp__4425__auto__){
var s__16245__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16245__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16245__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16247 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16246 = (0);
while(true){
if((i__16246 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16246);
cljs.core.chunk_append.call(null,b__16247,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16248 = (i__16246 + (1));
i__16246 = G__16248;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16247),sablono$core$unordered_list16239_$_iter__16244.call(null,cljs.core.chunk_rest.call(null,s__16245__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16247),null);
}
} else {
var x = cljs.core.first.call(null,s__16245__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list16239_$_iter__16244.call(null,cljs.core.rest.call(null,s__16245__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list16239);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list16249 = (function sablono$core$ordered_list16249(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list16249_$_iter__16254(s__16255){
return (new cljs.core.LazySeq(null,(function (){
var s__16255__$1 = s__16255;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16255__$1);
if(temp__4425__auto__){
var s__16255__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16255__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16255__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16257 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16256 = (0);
while(true){
if((i__16256 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16256);
cljs.core.chunk_append.call(null,b__16257,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16258 = (i__16256 + (1));
i__16256 = G__16258;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16257),sablono$core$ordered_list16249_$_iter__16254.call(null,cljs.core.chunk_rest.call(null,s__16255__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16257),null);
}
} else {
var x = cljs.core.first.call(null,s__16255__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list16249_$_iter__16254.call(null,cljs.core.rest.call(null,s__16255__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list16249);
/**
 * Create an image element.
 */
sablono.core.image16259 = (function sablono$core$image16259(var_args){
var args16260 = [];
var len__5726__auto___16263 = arguments.length;
var i__5727__auto___16264 = (0);
while(true){
if((i__5727__auto___16264 < len__5726__auto___16263)){
args16260.push((arguments[i__5727__auto___16264]));

var G__16265 = (i__5727__auto___16264 + (1));
i__5727__auto___16264 = G__16265;
continue;
} else {
}
break;
}

var G__16262 = args16260.length;
switch (G__16262) {
case 1:
return sablono.core.image16259.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image16259.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16260.length)].join('')));

}
});

sablono.core.image16259.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image16259.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image16259.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image16259);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__16267_SHARP_,p2__16268_SHARP_){
return [cljs.core.str(p1__16267_SHARP_),cljs.core.str("["),cljs.core.str(p2__16268_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__16269_SHARP_,p2__16270_SHARP_){
return [cljs.core.str(p1__16269_SHARP_),cljs.core.str("-"),cljs.core.str(p2__16270_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field16271 = (function sablono$core$color_field16271(var_args){
var args16272 = [];
var len__5726__auto___16339 = arguments.length;
var i__5727__auto___16340 = (0);
while(true){
if((i__5727__auto___16340 < len__5726__auto___16339)){
args16272.push((arguments[i__5727__auto___16340]));

var G__16341 = (i__5727__auto___16340 + (1));
i__5727__auto___16340 = G__16341;
continue;
} else {
}
break;
}

var G__16274 = args16272.length;
switch (G__16274) {
case 1:
return sablono.core.color_field16271.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field16271.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16272.length)].join('')));

}
});

sablono.core.color_field16271.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.color_field16271.call(null,name__6340__auto__,null);
});

sablono.core.color_field16271.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.color_field16271.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field16271);

/**
 * Creates a date input field.
 */
sablono.core.date_field16275 = (function sablono$core$date_field16275(var_args){
var args16276 = [];
var len__5726__auto___16343 = arguments.length;
var i__5727__auto___16344 = (0);
while(true){
if((i__5727__auto___16344 < len__5726__auto___16343)){
args16276.push((arguments[i__5727__auto___16344]));

var G__16345 = (i__5727__auto___16344 + (1));
i__5727__auto___16344 = G__16345;
continue;
} else {
}
break;
}

var G__16278 = args16276.length;
switch (G__16278) {
case 1:
return sablono.core.date_field16275.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field16275.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16276.length)].join('')));

}
});

sablono.core.date_field16275.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.date_field16275.call(null,name__6340__auto__,null);
});

sablono.core.date_field16275.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.date_field16275.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field16275);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field16279 = (function sablono$core$datetime_field16279(var_args){
var args16280 = [];
var len__5726__auto___16347 = arguments.length;
var i__5727__auto___16348 = (0);
while(true){
if((i__5727__auto___16348 < len__5726__auto___16347)){
args16280.push((arguments[i__5727__auto___16348]));

var G__16349 = (i__5727__auto___16348 + (1));
i__5727__auto___16348 = G__16349;
continue;
} else {
}
break;
}

var G__16282 = args16280.length;
switch (G__16282) {
case 1:
return sablono.core.datetime_field16279.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field16279.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16280.length)].join('')));

}
});

sablono.core.datetime_field16279.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_field16279.call(null,name__6340__auto__,null);
});

sablono.core.datetime_field16279.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_field16279.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field16279);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field16283 = (function sablono$core$datetime_local_field16283(var_args){
var args16284 = [];
var len__5726__auto___16351 = arguments.length;
var i__5727__auto___16352 = (0);
while(true){
if((i__5727__auto___16352 < len__5726__auto___16351)){
args16284.push((arguments[i__5727__auto___16352]));

var G__16353 = (i__5727__auto___16352 + (1));
i__5727__auto___16352 = G__16353;
continue;
} else {
}
break;
}

var G__16286 = args16284.length;
switch (G__16286) {
case 1:
return sablono.core.datetime_local_field16283.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field16283.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16284.length)].join('')));

}
});

sablono.core.datetime_local_field16283.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_local_field16283.call(null,name__6340__auto__,null);
});

sablono.core.datetime_local_field16283.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_local_field16283.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field16283);

/**
 * Creates a email input field.
 */
sablono.core.email_field16287 = (function sablono$core$email_field16287(var_args){
var args16288 = [];
var len__5726__auto___16355 = arguments.length;
var i__5727__auto___16356 = (0);
while(true){
if((i__5727__auto___16356 < len__5726__auto___16355)){
args16288.push((arguments[i__5727__auto___16356]));

var G__16357 = (i__5727__auto___16356 + (1));
i__5727__auto___16356 = G__16357;
continue;
} else {
}
break;
}

var G__16290 = args16288.length;
switch (G__16290) {
case 1:
return sablono.core.email_field16287.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field16287.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16288.length)].join('')));

}
});

sablono.core.email_field16287.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.email_field16287.call(null,name__6340__auto__,null);
});

sablono.core.email_field16287.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.email_field16287.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field16287);

/**
 * Creates a file input field.
 */
sablono.core.file_field16291 = (function sablono$core$file_field16291(var_args){
var args16292 = [];
var len__5726__auto___16359 = arguments.length;
var i__5727__auto___16360 = (0);
while(true){
if((i__5727__auto___16360 < len__5726__auto___16359)){
args16292.push((arguments[i__5727__auto___16360]));

var G__16361 = (i__5727__auto___16360 + (1));
i__5727__auto___16360 = G__16361;
continue;
} else {
}
break;
}

var G__16294 = args16292.length;
switch (G__16294) {
case 1:
return sablono.core.file_field16291.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field16291.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16292.length)].join('')));

}
});

sablono.core.file_field16291.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.file_field16291.call(null,name__6340__auto__,null);
});

sablono.core.file_field16291.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.file_field16291.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field16291);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field16295 = (function sablono$core$hidden_field16295(var_args){
var args16296 = [];
var len__5726__auto___16363 = arguments.length;
var i__5727__auto___16364 = (0);
while(true){
if((i__5727__auto___16364 < len__5726__auto___16363)){
args16296.push((arguments[i__5727__auto___16364]));

var G__16365 = (i__5727__auto___16364 + (1));
i__5727__auto___16364 = G__16365;
continue;
} else {
}
break;
}

var G__16298 = args16296.length;
switch (G__16298) {
case 1:
return sablono.core.hidden_field16295.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field16295.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16296.length)].join('')));

}
});

sablono.core.hidden_field16295.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.hidden_field16295.call(null,name__6340__auto__,null);
});

sablono.core.hidden_field16295.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.hidden_field16295.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field16295);

/**
 * Creates a month input field.
 */
sablono.core.month_field16299 = (function sablono$core$month_field16299(var_args){
var args16300 = [];
var len__5726__auto___16367 = arguments.length;
var i__5727__auto___16368 = (0);
while(true){
if((i__5727__auto___16368 < len__5726__auto___16367)){
args16300.push((arguments[i__5727__auto___16368]));

var G__16369 = (i__5727__auto___16368 + (1));
i__5727__auto___16368 = G__16369;
continue;
} else {
}
break;
}

var G__16302 = args16300.length;
switch (G__16302) {
case 1:
return sablono.core.month_field16299.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field16299.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16300.length)].join('')));

}
});

sablono.core.month_field16299.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.month_field16299.call(null,name__6340__auto__,null);
});

sablono.core.month_field16299.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.month_field16299.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field16299);

/**
 * Creates a number input field.
 */
sablono.core.number_field16303 = (function sablono$core$number_field16303(var_args){
var args16304 = [];
var len__5726__auto___16371 = arguments.length;
var i__5727__auto___16372 = (0);
while(true){
if((i__5727__auto___16372 < len__5726__auto___16371)){
args16304.push((arguments[i__5727__auto___16372]));

var G__16373 = (i__5727__auto___16372 + (1));
i__5727__auto___16372 = G__16373;
continue;
} else {
}
break;
}

var G__16306 = args16304.length;
switch (G__16306) {
case 1:
return sablono.core.number_field16303.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field16303.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16304.length)].join('')));

}
});

sablono.core.number_field16303.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.number_field16303.call(null,name__6340__auto__,null);
});

sablono.core.number_field16303.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.number_field16303.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field16303);

/**
 * Creates a password input field.
 */
sablono.core.password_field16307 = (function sablono$core$password_field16307(var_args){
var args16308 = [];
var len__5726__auto___16375 = arguments.length;
var i__5727__auto___16376 = (0);
while(true){
if((i__5727__auto___16376 < len__5726__auto___16375)){
args16308.push((arguments[i__5727__auto___16376]));

var G__16377 = (i__5727__auto___16376 + (1));
i__5727__auto___16376 = G__16377;
continue;
} else {
}
break;
}

var G__16310 = args16308.length;
switch (G__16310) {
case 1:
return sablono.core.password_field16307.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field16307.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16308.length)].join('')));

}
});

sablono.core.password_field16307.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.password_field16307.call(null,name__6340__auto__,null);
});

sablono.core.password_field16307.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.password_field16307.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field16307);

/**
 * Creates a range input field.
 */
sablono.core.range_field16311 = (function sablono$core$range_field16311(var_args){
var args16312 = [];
var len__5726__auto___16379 = arguments.length;
var i__5727__auto___16380 = (0);
while(true){
if((i__5727__auto___16380 < len__5726__auto___16379)){
args16312.push((arguments[i__5727__auto___16380]));

var G__16381 = (i__5727__auto___16380 + (1));
i__5727__auto___16380 = G__16381;
continue;
} else {
}
break;
}

var G__16314 = args16312.length;
switch (G__16314) {
case 1:
return sablono.core.range_field16311.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field16311.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16312.length)].join('')));

}
});

sablono.core.range_field16311.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.range_field16311.call(null,name__6340__auto__,null);
});

sablono.core.range_field16311.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.range_field16311.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field16311);

/**
 * Creates a search input field.
 */
sablono.core.search_field16315 = (function sablono$core$search_field16315(var_args){
var args16316 = [];
var len__5726__auto___16383 = arguments.length;
var i__5727__auto___16384 = (0);
while(true){
if((i__5727__auto___16384 < len__5726__auto___16383)){
args16316.push((arguments[i__5727__auto___16384]));

var G__16385 = (i__5727__auto___16384 + (1));
i__5727__auto___16384 = G__16385;
continue;
} else {
}
break;
}

var G__16318 = args16316.length;
switch (G__16318) {
case 1:
return sablono.core.search_field16315.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field16315.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16316.length)].join('')));

}
});

sablono.core.search_field16315.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.search_field16315.call(null,name__6340__auto__,null);
});

sablono.core.search_field16315.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.search_field16315.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field16315);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field16319 = (function sablono$core$tel_field16319(var_args){
var args16320 = [];
var len__5726__auto___16387 = arguments.length;
var i__5727__auto___16388 = (0);
while(true){
if((i__5727__auto___16388 < len__5726__auto___16387)){
args16320.push((arguments[i__5727__auto___16388]));

var G__16389 = (i__5727__auto___16388 + (1));
i__5727__auto___16388 = G__16389;
continue;
} else {
}
break;
}

var G__16322 = args16320.length;
switch (G__16322) {
case 1:
return sablono.core.tel_field16319.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field16319.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16320.length)].join('')));

}
});

sablono.core.tel_field16319.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.tel_field16319.call(null,name__6340__auto__,null);
});

sablono.core.tel_field16319.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.tel_field16319.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field16319);

/**
 * Creates a text input field.
 */
sablono.core.text_field16323 = (function sablono$core$text_field16323(var_args){
var args16324 = [];
var len__5726__auto___16391 = arguments.length;
var i__5727__auto___16392 = (0);
while(true){
if((i__5727__auto___16392 < len__5726__auto___16391)){
args16324.push((arguments[i__5727__auto___16392]));

var G__16393 = (i__5727__auto___16392 + (1));
i__5727__auto___16392 = G__16393;
continue;
} else {
}
break;
}

var G__16326 = args16324.length;
switch (G__16326) {
case 1:
return sablono.core.text_field16323.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field16323.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16324.length)].join('')));

}
});

sablono.core.text_field16323.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.text_field16323.call(null,name__6340__auto__,null);
});

sablono.core.text_field16323.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.text_field16323.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field16323);

/**
 * Creates a time input field.
 */
sablono.core.time_field16327 = (function sablono$core$time_field16327(var_args){
var args16328 = [];
var len__5726__auto___16395 = arguments.length;
var i__5727__auto___16396 = (0);
while(true){
if((i__5727__auto___16396 < len__5726__auto___16395)){
args16328.push((arguments[i__5727__auto___16396]));

var G__16397 = (i__5727__auto___16396 + (1));
i__5727__auto___16396 = G__16397;
continue;
} else {
}
break;
}

var G__16330 = args16328.length;
switch (G__16330) {
case 1:
return sablono.core.time_field16327.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field16327.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16328.length)].join('')));

}
});

sablono.core.time_field16327.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.time_field16327.call(null,name__6340__auto__,null);
});

sablono.core.time_field16327.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.time_field16327.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field16327);

/**
 * Creates a url input field.
 */
sablono.core.url_field16331 = (function sablono$core$url_field16331(var_args){
var args16332 = [];
var len__5726__auto___16399 = arguments.length;
var i__5727__auto___16400 = (0);
while(true){
if((i__5727__auto___16400 < len__5726__auto___16399)){
args16332.push((arguments[i__5727__auto___16400]));

var G__16401 = (i__5727__auto___16400 + (1));
i__5727__auto___16400 = G__16401;
continue;
} else {
}
break;
}

var G__16334 = args16332.length;
switch (G__16334) {
case 1:
return sablono.core.url_field16331.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field16331.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16332.length)].join('')));

}
});

sablono.core.url_field16331.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.url_field16331.call(null,name__6340__auto__,null);
});

sablono.core.url_field16331.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.url_field16331.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field16331);

/**
 * Creates a week input field.
 */
sablono.core.week_field16335 = (function sablono$core$week_field16335(var_args){
var args16336 = [];
var len__5726__auto___16403 = arguments.length;
var i__5727__auto___16404 = (0);
while(true){
if((i__5727__auto___16404 < len__5726__auto___16403)){
args16336.push((arguments[i__5727__auto___16404]));

var G__16405 = (i__5727__auto___16404 + (1));
i__5727__auto___16404 = G__16405;
continue;
} else {
}
break;
}

var G__16338 = args16336.length;
switch (G__16338) {
case 1:
return sablono.core.week_field16335.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field16335.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16336.length)].join('')));

}
});

sablono.core.week_field16335.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.week_field16335.call(null,name__6340__auto__,null);
});

sablono.core.week_field16335.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.week_field16335.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field16335);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box16407 = (function sablono$core$check_box16407(var_args){
var args16408 = [];
var len__5726__auto___16411 = arguments.length;
var i__5727__auto___16412 = (0);
while(true){
if((i__5727__auto___16412 < len__5726__auto___16411)){
args16408.push((arguments[i__5727__auto___16412]));

var G__16413 = (i__5727__auto___16412 + (1));
i__5727__auto___16412 = G__16413;
continue;
} else {
}
break;
}

var G__16410 = args16408.length;
switch (G__16410) {
case 1:
return sablono.core.check_box16407.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box16407.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box16407.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16408.length)].join('')));

}
});

sablono.core.check_box16407.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box16407.call(null,name,null);
});

sablono.core.check_box16407.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box16407.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box16407.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box16407.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box16407);
/**
 * Creates a radio button.
 */
sablono.core.radio_button16415 = (function sablono$core$radio_button16415(var_args){
var args16416 = [];
var len__5726__auto___16419 = arguments.length;
var i__5727__auto___16420 = (0);
while(true){
if((i__5727__auto___16420 < len__5726__auto___16419)){
args16416.push((arguments[i__5727__auto___16420]));

var G__16421 = (i__5727__auto___16420 + (1));
i__5727__auto___16420 = G__16421;
continue;
} else {
}
break;
}

var G__16418 = args16416.length;
switch (G__16418) {
case 1:
return sablono.core.radio_button16415.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button16415.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button16415.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16416.length)].join('')));

}
});

sablono.core.radio_button16415.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button16415.call(null,group,null);
});

sablono.core.radio_button16415.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button16415.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button16415.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button16415.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button16415);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options16423 = (function sablono$core$select_options16423(coll){
var iter__5440__auto__ = (function sablono$core$select_options16423_$_iter__16432(s__16433){
return (new cljs.core.LazySeq(null,(function (){
var s__16433__$1 = s__16433;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16433__$1);
if(temp__4425__auto__){
var s__16433__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16433__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16433__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16435 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16434 = (0);
while(true){
if((i__16434 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16434);
cljs.core.chunk_append.call(null,b__16435,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16438 = x;
var text = cljs.core.nth.call(null,vec__16438,(0),null);
var val = cljs.core.nth.call(null,vec__16438,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16438,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16423.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__16440 = (i__16434 + (1));
i__16434 = G__16440;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16435),sablono$core$select_options16423_$_iter__16432.call(null,cljs.core.chunk_rest.call(null,s__16433__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16435),null);
}
} else {
var x = cljs.core.first.call(null,s__16433__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16439 = x;
var text = cljs.core.nth.call(null,vec__16439,(0),null);
var val = cljs.core.nth.call(null,vec__16439,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16439,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16423.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options16423_$_iter__16432.call(null,cljs.core.rest.call(null,s__16433__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options16423);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down16441 = (function sablono$core$drop_down16441(var_args){
var args16442 = [];
var len__5726__auto___16445 = arguments.length;
var i__5727__auto___16446 = (0);
while(true){
if((i__5727__auto___16446 < len__5726__auto___16445)){
args16442.push((arguments[i__5727__auto___16446]));

var G__16447 = (i__5727__auto___16446 + (1));
i__5727__auto___16446 = G__16447;
continue;
} else {
}
break;
}

var G__16444 = args16442.length;
switch (G__16444) {
case 2:
return sablono.core.drop_down16441.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down16441.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16442.length)].join('')));

}
});

sablono.core.drop_down16441.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down16441.call(null,name,options,null);
});

sablono.core.drop_down16441.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down16441.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down16441);
/**
 * Creates a text area element.
 */
sablono.core.text_area16449 = (function sablono$core$text_area16449(var_args){
var args16450 = [];
var len__5726__auto___16453 = arguments.length;
var i__5727__auto___16454 = (0);
while(true){
if((i__5727__auto___16454 < len__5726__auto___16453)){
args16450.push((arguments[i__5727__auto___16454]));

var G__16455 = (i__5727__auto___16454 + (1));
i__5727__auto___16454 = G__16455;
continue;
} else {
}
break;
}

var G__16452 = args16450.length;
switch (G__16452) {
case 1:
return sablono.core.text_area16449.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area16449.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16450.length)].join('')));

}
});

sablono.core.text_area16449.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area16449.call(null,name,null);
});

sablono.core.text_area16449.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area16449.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area16449);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label16457 = (function sablono$core$label16457(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label16457);
/**
 * Creates a submit button.
 */
sablono.core.submit_button16458 = (function sablono$core$submit_button16458(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button16458);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button16459 = (function sablono$core$reset_button16459(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button16459);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to16460 = (function sablono$core$form_to16460(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16465 = arguments.length;
var i__5727__auto___16466 = (0);
while(true){
if((i__5727__auto___16466 < len__5726__auto___16465)){
args__5733__auto__.push((arguments[i__5727__auto___16466]));

var G__16467 = (i__5727__auto___16466 + (1));
i__5727__auto___16466 = G__16467;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to16460.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to16460.cljs$core$IFn$_invoke$arity$variadic = (function (p__16463,body){
var vec__16464 = p__16463;
var method = cljs.core.nth.call(null,vec__16464,(0),null);
var action = cljs.core.nth.call(null,vec__16464,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to16460.cljs$lang$maxFixedArity = (1);

sablono.core.form_to16460.cljs$lang$applyTo = (function (seq16461){
var G__16462 = cljs.core.first.call(null,seq16461);
var seq16461__$1 = cljs.core.next.call(null,seq16461);
return sablono.core.form_to16460.cljs$core$IFn$_invoke$arity$variadic(G__16462,seq16461__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to16460);

//# sourceMappingURL=core.js.map?rel=1455098332067