// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__11661__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__11660 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__11660,(0),null);
var body = cljs.core.nthnext.call(null,vec__11660,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__11661 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11662__i = 0, G__11662__a = new Array(arguments.length -  0);
while (G__11662__i < G__11662__a.length) {G__11662__a[G__11662__i] = arguments[G__11662__i + 0]; ++G__11662__i;}
  args = new cljs.core.IndexedSeq(G__11662__a,0);
} 
return G__11661__delegate.call(this,args);};
G__11661.cljs$lang$maxFixedArity = 0;
G__11661.cljs$lang$applyTo = (function (arglist__11663){
var args = cljs.core.seq(arglist__11663);
return G__11661__delegate(args);
});
G__11661.cljs$core$IFn$_invoke$arity$variadic = G__11661__delegate;
return G__11661;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__11668(s__11669){
return (new cljs.core.LazySeq(null,(function (){
var s__11669__$1 = s__11669;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11669__$1);
if(temp__4425__auto__){
var s__11669__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11669__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__11669__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__11671 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__11670 = (0);
while(true){
if((i__11670 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__11670);
cljs.core.chunk_append.call(null,b__11671,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__11672 = (i__11670 + (1));
i__11670 = G__11672;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11671),sablono$core$update_arglists_$_iter__11668.call(null,cljs.core.chunk_rest.call(null,s__11669__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11671),null);
}
} else {
var args = cljs.core.first.call(null,s__11669__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__11668.call(null,cljs.core.rest.call(null,s__11669__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11678 = arguments.length;
var i__5727__auto___11679 = (0);
while(true){
if((i__5727__auto___11679 < len__5726__auto___11678)){
args__5733__auto__.push((arguments[i__5727__auto___11679]));

var G__11680 = (i__5727__auto___11679 + (1));
i__5727__auto___11679 = G__11680;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__11674(s__11675){
return (new cljs.core.LazySeq(null,(function (){
var s__11675__$1 = s__11675;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11675__$1);
if(temp__4425__auto__){
var s__11675__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11675__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__11675__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__11677 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__11676 = (0);
while(true){
if((i__11676 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__11676);
cljs.core.chunk_append.call(null,b__11677,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__11681 = (i__11676 + (1));
i__11676 = G__11681;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11677),sablono$core$iter__11674.call(null,cljs.core.chunk_rest.call(null,s__11675__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11677),null);
}
} else {
var style = cljs.core.first.call(null,s__11675__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__11674.call(null,cljs.core.rest.call(null,s__11675__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq11673){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11673));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to11682 = (function sablono$core$link_to11682(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11685 = arguments.length;
var i__5727__auto___11686 = (0);
while(true){
if((i__5727__auto___11686 < len__5726__auto___11685)){
args__5733__auto__.push((arguments[i__5727__auto___11686]));

var G__11687 = (i__5727__auto___11686 + (1));
i__5727__auto___11686 = G__11687;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to11682.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to11682.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to11682.cljs$lang$maxFixedArity = (1);

sablono.core.link_to11682.cljs$lang$applyTo = (function (seq11683){
var G__11684 = cljs.core.first.call(null,seq11683);
var seq11683__$1 = cljs.core.next.call(null,seq11683);
return sablono.core.link_to11682.cljs$core$IFn$_invoke$arity$variadic(G__11684,seq11683__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to11682);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to11688 = (function sablono$core$mail_to11688(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11693 = arguments.length;
var i__5727__auto___11694 = (0);
while(true){
if((i__5727__auto___11694 < len__5726__auto___11693)){
args__5733__auto__.push((arguments[i__5727__auto___11694]));

var G__11695 = (i__5727__auto___11694 + (1));
i__5727__auto___11694 = G__11695;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to11688.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to11688.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__11691){
var vec__11692 = p__11691;
var content = cljs.core.nth.call(null,vec__11692,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to11688.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to11688.cljs$lang$applyTo = (function (seq11689){
var G__11690 = cljs.core.first.call(null,seq11689);
var seq11689__$1 = cljs.core.next.call(null,seq11689);
return sablono.core.mail_to11688.cljs$core$IFn$_invoke$arity$variadic(G__11690,seq11689__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to11688);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list11696 = (function sablono$core$unordered_list11696(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list11696_$_iter__11701(s__11702){
return (new cljs.core.LazySeq(null,(function (){
var s__11702__$1 = s__11702;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11702__$1);
if(temp__4425__auto__){
var s__11702__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11702__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__11702__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__11704 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__11703 = (0);
while(true){
if((i__11703 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__11703);
cljs.core.chunk_append.call(null,b__11704,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__11705 = (i__11703 + (1));
i__11703 = G__11705;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11704),sablono$core$unordered_list11696_$_iter__11701.call(null,cljs.core.chunk_rest.call(null,s__11702__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11704),null);
}
} else {
var x = cljs.core.first.call(null,s__11702__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list11696_$_iter__11701.call(null,cljs.core.rest.call(null,s__11702__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list11696);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list11706 = (function sablono$core$ordered_list11706(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list11706_$_iter__11711(s__11712){
return (new cljs.core.LazySeq(null,(function (){
var s__11712__$1 = s__11712;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11712__$1);
if(temp__4425__auto__){
var s__11712__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11712__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__11712__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__11714 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__11713 = (0);
while(true){
if((i__11713 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__11713);
cljs.core.chunk_append.call(null,b__11714,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__11715 = (i__11713 + (1));
i__11713 = G__11715;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11714),sablono$core$ordered_list11706_$_iter__11711.call(null,cljs.core.chunk_rest.call(null,s__11712__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11714),null);
}
} else {
var x = cljs.core.first.call(null,s__11712__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list11706_$_iter__11711.call(null,cljs.core.rest.call(null,s__11712__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list11706);
/**
 * Create an image element.
 */
sablono.core.image11716 = (function sablono$core$image11716(var_args){
var args11717 = [];
var len__5726__auto___11720 = arguments.length;
var i__5727__auto___11721 = (0);
while(true){
if((i__5727__auto___11721 < len__5726__auto___11720)){
args11717.push((arguments[i__5727__auto___11721]));

var G__11722 = (i__5727__auto___11721 + (1));
i__5727__auto___11721 = G__11722;
continue;
} else {
}
break;
}

var G__11719 = args11717.length;
switch (G__11719) {
case 1:
return sablono.core.image11716.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image11716.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11717.length)].join('')));

}
});

sablono.core.image11716.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image11716.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image11716.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image11716);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__11724_SHARP_,p2__11725_SHARP_){
return [cljs.core.str(p1__11724_SHARP_),cljs.core.str("["),cljs.core.str(p2__11725_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__11726_SHARP_,p2__11727_SHARP_){
return [cljs.core.str(p1__11726_SHARP_),cljs.core.str("-"),cljs.core.str(p2__11727_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field11728 = (function sablono$core$color_field11728(var_args){
var args11729 = [];
var len__5726__auto___11796 = arguments.length;
var i__5727__auto___11797 = (0);
while(true){
if((i__5727__auto___11797 < len__5726__auto___11796)){
args11729.push((arguments[i__5727__auto___11797]));

var G__11798 = (i__5727__auto___11797 + (1));
i__5727__auto___11797 = G__11798;
continue;
} else {
}
break;
}

var G__11731 = args11729.length;
switch (G__11731) {
case 1:
return sablono.core.color_field11728.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field11728.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11729.length)].join('')));

}
});

sablono.core.color_field11728.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.color_field11728.call(null,name__11649__auto__,null);
});

sablono.core.color_field11728.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.color_field11728.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field11728);

/**
 * Creates a date input field.
 */
sablono.core.date_field11732 = (function sablono$core$date_field11732(var_args){
var args11733 = [];
var len__5726__auto___11800 = arguments.length;
var i__5727__auto___11801 = (0);
while(true){
if((i__5727__auto___11801 < len__5726__auto___11800)){
args11733.push((arguments[i__5727__auto___11801]));

var G__11802 = (i__5727__auto___11801 + (1));
i__5727__auto___11801 = G__11802;
continue;
} else {
}
break;
}

var G__11735 = args11733.length;
switch (G__11735) {
case 1:
return sablono.core.date_field11732.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field11732.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11733.length)].join('')));

}
});

sablono.core.date_field11732.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.date_field11732.call(null,name__11649__auto__,null);
});

sablono.core.date_field11732.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.date_field11732.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field11732);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field11736 = (function sablono$core$datetime_field11736(var_args){
var args11737 = [];
var len__5726__auto___11804 = arguments.length;
var i__5727__auto___11805 = (0);
while(true){
if((i__5727__auto___11805 < len__5726__auto___11804)){
args11737.push((arguments[i__5727__auto___11805]));

var G__11806 = (i__5727__auto___11805 + (1));
i__5727__auto___11805 = G__11806;
continue;
} else {
}
break;
}

var G__11739 = args11737.length;
switch (G__11739) {
case 1:
return sablono.core.datetime_field11736.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field11736.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11737.length)].join('')));

}
});

sablono.core.datetime_field11736.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_field11736.call(null,name__11649__auto__,null);
});

sablono.core.datetime_field11736.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_field11736.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field11736);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field11740 = (function sablono$core$datetime_local_field11740(var_args){
var args11741 = [];
var len__5726__auto___11808 = arguments.length;
var i__5727__auto___11809 = (0);
while(true){
if((i__5727__auto___11809 < len__5726__auto___11808)){
args11741.push((arguments[i__5727__auto___11809]));

var G__11810 = (i__5727__auto___11809 + (1));
i__5727__auto___11809 = G__11810;
continue;
} else {
}
break;
}

var G__11743 = args11741.length;
switch (G__11743) {
case 1:
return sablono.core.datetime_local_field11740.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field11740.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11741.length)].join('')));

}
});

sablono.core.datetime_local_field11740.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_local_field11740.call(null,name__11649__auto__,null);
});

sablono.core.datetime_local_field11740.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_local_field11740.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field11740);

/**
 * Creates a email input field.
 */
sablono.core.email_field11744 = (function sablono$core$email_field11744(var_args){
var args11745 = [];
var len__5726__auto___11812 = arguments.length;
var i__5727__auto___11813 = (0);
while(true){
if((i__5727__auto___11813 < len__5726__auto___11812)){
args11745.push((arguments[i__5727__auto___11813]));

var G__11814 = (i__5727__auto___11813 + (1));
i__5727__auto___11813 = G__11814;
continue;
} else {
}
break;
}

var G__11747 = args11745.length;
switch (G__11747) {
case 1:
return sablono.core.email_field11744.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field11744.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11745.length)].join('')));

}
});

sablono.core.email_field11744.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.email_field11744.call(null,name__11649__auto__,null);
});

sablono.core.email_field11744.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.email_field11744.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field11744);

/**
 * Creates a file input field.
 */
sablono.core.file_field11748 = (function sablono$core$file_field11748(var_args){
var args11749 = [];
var len__5726__auto___11816 = arguments.length;
var i__5727__auto___11817 = (0);
while(true){
if((i__5727__auto___11817 < len__5726__auto___11816)){
args11749.push((arguments[i__5727__auto___11817]));

var G__11818 = (i__5727__auto___11817 + (1));
i__5727__auto___11817 = G__11818;
continue;
} else {
}
break;
}

var G__11751 = args11749.length;
switch (G__11751) {
case 1:
return sablono.core.file_field11748.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field11748.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11749.length)].join('')));

}
});

sablono.core.file_field11748.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.file_field11748.call(null,name__11649__auto__,null);
});

sablono.core.file_field11748.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.file_field11748.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field11748);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field11752 = (function sablono$core$hidden_field11752(var_args){
var args11753 = [];
var len__5726__auto___11820 = arguments.length;
var i__5727__auto___11821 = (0);
while(true){
if((i__5727__auto___11821 < len__5726__auto___11820)){
args11753.push((arguments[i__5727__auto___11821]));

var G__11822 = (i__5727__auto___11821 + (1));
i__5727__auto___11821 = G__11822;
continue;
} else {
}
break;
}

var G__11755 = args11753.length;
switch (G__11755) {
case 1:
return sablono.core.hidden_field11752.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field11752.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11753.length)].join('')));

}
});

sablono.core.hidden_field11752.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.hidden_field11752.call(null,name__11649__auto__,null);
});

sablono.core.hidden_field11752.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.hidden_field11752.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field11752);

/**
 * Creates a month input field.
 */
sablono.core.month_field11756 = (function sablono$core$month_field11756(var_args){
var args11757 = [];
var len__5726__auto___11824 = arguments.length;
var i__5727__auto___11825 = (0);
while(true){
if((i__5727__auto___11825 < len__5726__auto___11824)){
args11757.push((arguments[i__5727__auto___11825]));

var G__11826 = (i__5727__auto___11825 + (1));
i__5727__auto___11825 = G__11826;
continue;
} else {
}
break;
}

var G__11759 = args11757.length;
switch (G__11759) {
case 1:
return sablono.core.month_field11756.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field11756.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11757.length)].join('')));

}
});

sablono.core.month_field11756.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.month_field11756.call(null,name__11649__auto__,null);
});

sablono.core.month_field11756.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.month_field11756.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field11756);

/**
 * Creates a number input field.
 */
sablono.core.number_field11760 = (function sablono$core$number_field11760(var_args){
var args11761 = [];
var len__5726__auto___11828 = arguments.length;
var i__5727__auto___11829 = (0);
while(true){
if((i__5727__auto___11829 < len__5726__auto___11828)){
args11761.push((arguments[i__5727__auto___11829]));

var G__11830 = (i__5727__auto___11829 + (1));
i__5727__auto___11829 = G__11830;
continue;
} else {
}
break;
}

var G__11763 = args11761.length;
switch (G__11763) {
case 1:
return sablono.core.number_field11760.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field11760.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11761.length)].join('')));

}
});

sablono.core.number_field11760.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.number_field11760.call(null,name__11649__auto__,null);
});

sablono.core.number_field11760.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.number_field11760.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field11760);

/**
 * Creates a password input field.
 */
sablono.core.password_field11764 = (function sablono$core$password_field11764(var_args){
var args11765 = [];
var len__5726__auto___11832 = arguments.length;
var i__5727__auto___11833 = (0);
while(true){
if((i__5727__auto___11833 < len__5726__auto___11832)){
args11765.push((arguments[i__5727__auto___11833]));

var G__11834 = (i__5727__auto___11833 + (1));
i__5727__auto___11833 = G__11834;
continue;
} else {
}
break;
}

var G__11767 = args11765.length;
switch (G__11767) {
case 1:
return sablono.core.password_field11764.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field11764.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11765.length)].join('')));

}
});

sablono.core.password_field11764.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.password_field11764.call(null,name__11649__auto__,null);
});

sablono.core.password_field11764.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.password_field11764.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field11764);

/**
 * Creates a range input field.
 */
sablono.core.range_field11768 = (function sablono$core$range_field11768(var_args){
var args11769 = [];
var len__5726__auto___11836 = arguments.length;
var i__5727__auto___11837 = (0);
while(true){
if((i__5727__auto___11837 < len__5726__auto___11836)){
args11769.push((arguments[i__5727__auto___11837]));

var G__11838 = (i__5727__auto___11837 + (1));
i__5727__auto___11837 = G__11838;
continue;
} else {
}
break;
}

var G__11771 = args11769.length;
switch (G__11771) {
case 1:
return sablono.core.range_field11768.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field11768.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11769.length)].join('')));

}
});

sablono.core.range_field11768.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.range_field11768.call(null,name__11649__auto__,null);
});

sablono.core.range_field11768.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.range_field11768.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field11768);

/**
 * Creates a search input field.
 */
sablono.core.search_field11772 = (function sablono$core$search_field11772(var_args){
var args11773 = [];
var len__5726__auto___11840 = arguments.length;
var i__5727__auto___11841 = (0);
while(true){
if((i__5727__auto___11841 < len__5726__auto___11840)){
args11773.push((arguments[i__5727__auto___11841]));

var G__11842 = (i__5727__auto___11841 + (1));
i__5727__auto___11841 = G__11842;
continue;
} else {
}
break;
}

var G__11775 = args11773.length;
switch (G__11775) {
case 1:
return sablono.core.search_field11772.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field11772.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11773.length)].join('')));

}
});

sablono.core.search_field11772.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.search_field11772.call(null,name__11649__auto__,null);
});

sablono.core.search_field11772.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.search_field11772.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field11772);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field11776 = (function sablono$core$tel_field11776(var_args){
var args11777 = [];
var len__5726__auto___11844 = arguments.length;
var i__5727__auto___11845 = (0);
while(true){
if((i__5727__auto___11845 < len__5726__auto___11844)){
args11777.push((arguments[i__5727__auto___11845]));

var G__11846 = (i__5727__auto___11845 + (1));
i__5727__auto___11845 = G__11846;
continue;
} else {
}
break;
}

var G__11779 = args11777.length;
switch (G__11779) {
case 1:
return sablono.core.tel_field11776.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field11776.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11777.length)].join('')));

}
});

sablono.core.tel_field11776.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.tel_field11776.call(null,name__11649__auto__,null);
});

sablono.core.tel_field11776.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.tel_field11776.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field11776);

/**
 * Creates a text input field.
 */
sablono.core.text_field11780 = (function sablono$core$text_field11780(var_args){
var args11781 = [];
var len__5726__auto___11848 = arguments.length;
var i__5727__auto___11849 = (0);
while(true){
if((i__5727__auto___11849 < len__5726__auto___11848)){
args11781.push((arguments[i__5727__auto___11849]));

var G__11850 = (i__5727__auto___11849 + (1));
i__5727__auto___11849 = G__11850;
continue;
} else {
}
break;
}

var G__11783 = args11781.length;
switch (G__11783) {
case 1:
return sablono.core.text_field11780.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field11780.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11781.length)].join('')));

}
});

sablono.core.text_field11780.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.text_field11780.call(null,name__11649__auto__,null);
});

sablono.core.text_field11780.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.text_field11780.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field11780);

/**
 * Creates a time input field.
 */
sablono.core.time_field11784 = (function sablono$core$time_field11784(var_args){
var args11785 = [];
var len__5726__auto___11852 = arguments.length;
var i__5727__auto___11853 = (0);
while(true){
if((i__5727__auto___11853 < len__5726__auto___11852)){
args11785.push((arguments[i__5727__auto___11853]));

var G__11854 = (i__5727__auto___11853 + (1));
i__5727__auto___11853 = G__11854;
continue;
} else {
}
break;
}

var G__11787 = args11785.length;
switch (G__11787) {
case 1:
return sablono.core.time_field11784.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field11784.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11785.length)].join('')));

}
});

sablono.core.time_field11784.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.time_field11784.call(null,name__11649__auto__,null);
});

sablono.core.time_field11784.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.time_field11784.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field11784);

/**
 * Creates a url input field.
 */
sablono.core.url_field11788 = (function sablono$core$url_field11788(var_args){
var args11789 = [];
var len__5726__auto___11856 = arguments.length;
var i__5727__auto___11857 = (0);
while(true){
if((i__5727__auto___11857 < len__5726__auto___11856)){
args11789.push((arguments[i__5727__auto___11857]));

var G__11858 = (i__5727__auto___11857 + (1));
i__5727__auto___11857 = G__11858;
continue;
} else {
}
break;
}

var G__11791 = args11789.length;
switch (G__11791) {
case 1:
return sablono.core.url_field11788.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field11788.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11789.length)].join('')));

}
});

sablono.core.url_field11788.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.url_field11788.call(null,name__11649__auto__,null);
});

sablono.core.url_field11788.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.url_field11788.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field11788);

/**
 * Creates a week input field.
 */
sablono.core.week_field11792 = (function sablono$core$week_field11792(var_args){
var args11793 = [];
var len__5726__auto___11860 = arguments.length;
var i__5727__auto___11861 = (0);
while(true){
if((i__5727__auto___11861 < len__5726__auto___11860)){
args11793.push((arguments[i__5727__auto___11861]));

var G__11862 = (i__5727__auto___11861 + (1));
i__5727__auto___11861 = G__11862;
continue;
} else {
}
break;
}

var G__11795 = args11793.length;
switch (G__11795) {
case 1:
return sablono.core.week_field11792.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field11792.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11793.length)].join('')));

}
});

sablono.core.week_field11792.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.week_field11792.call(null,name__11649__auto__,null);
});

sablono.core.week_field11792.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.week_field11792.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field11792);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box11864 = (function sablono$core$check_box11864(var_args){
var args11865 = [];
var len__5726__auto___11868 = arguments.length;
var i__5727__auto___11869 = (0);
while(true){
if((i__5727__auto___11869 < len__5726__auto___11868)){
args11865.push((arguments[i__5727__auto___11869]));

var G__11870 = (i__5727__auto___11869 + (1));
i__5727__auto___11869 = G__11870;
continue;
} else {
}
break;
}

var G__11867 = args11865.length;
switch (G__11867) {
case 1:
return sablono.core.check_box11864.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box11864.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box11864.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11865.length)].join('')));

}
});

sablono.core.check_box11864.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box11864.call(null,name,null);
});

sablono.core.check_box11864.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box11864.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box11864.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box11864.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box11864);
/**
 * Creates a radio button.
 */
sablono.core.radio_button11872 = (function sablono$core$radio_button11872(var_args){
var args11873 = [];
var len__5726__auto___11876 = arguments.length;
var i__5727__auto___11877 = (0);
while(true){
if((i__5727__auto___11877 < len__5726__auto___11876)){
args11873.push((arguments[i__5727__auto___11877]));

var G__11878 = (i__5727__auto___11877 + (1));
i__5727__auto___11877 = G__11878;
continue;
} else {
}
break;
}

var G__11875 = args11873.length;
switch (G__11875) {
case 1:
return sablono.core.radio_button11872.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button11872.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button11872.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11873.length)].join('')));

}
});

sablono.core.radio_button11872.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button11872.call(null,group,null);
});

sablono.core.radio_button11872.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button11872.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button11872.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button11872.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button11872);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options11880 = (function sablono$core$select_options11880(coll){
var iter__5440__auto__ = (function sablono$core$select_options11880_$_iter__11889(s__11890){
return (new cljs.core.LazySeq(null,(function (){
var s__11890__$1 = s__11890;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11890__$1);
if(temp__4425__auto__){
var s__11890__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11890__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__11890__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__11892 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__11891 = (0);
while(true){
if((i__11891 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__11891);
cljs.core.chunk_append.call(null,b__11892,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__11895 = x;
var text = cljs.core.nth.call(null,vec__11895,(0),null);
var val = cljs.core.nth.call(null,vec__11895,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__11895,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options11880.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__11897 = (i__11891 + (1));
i__11891 = G__11897;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11892),sablono$core$select_options11880_$_iter__11889.call(null,cljs.core.chunk_rest.call(null,s__11890__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11892),null);
}
} else {
var x = cljs.core.first.call(null,s__11890__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__11896 = x;
var text = cljs.core.nth.call(null,vec__11896,(0),null);
var val = cljs.core.nth.call(null,vec__11896,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__11896,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options11880.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options11880_$_iter__11889.call(null,cljs.core.rest.call(null,s__11890__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options11880);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down11898 = (function sablono$core$drop_down11898(var_args){
var args11899 = [];
var len__5726__auto___11902 = arguments.length;
var i__5727__auto___11903 = (0);
while(true){
if((i__5727__auto___11903 < len__5726__auto___11902)){
args11899.push((arguments[i__5727__auto___11903]));

var G__11904 = (i__5727__auto___11903 + (1));
i__5727__auto___11903 = G__11904;
continue;
} else {
}
break;
}

var G__11901 = args11899.length;
switch (G__11901) {
case 2:
return sablono.core.drop_down11898.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down11898.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11899.length)].join('')));

}
});

sablono.core.drop_down11898.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down11898.call(null,name,options,null);
});

sablono.core.drop_down11898.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down11898.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down11898);
/**
 * Creates a text area element.
 */
sablono.core.text_area11906 = (function sablono$core$text_area11906(var_args){
var args11907 = [];
var len__5726__auto___11910 = arguments.length;
var i__5727__auto___11911 = (0);
while(true){
if((i__5727__auto___11911 < len__5726__auto___11910)){
args11907.push((arguments[i__5727__auto___11911]));

var G__11912 = (i__5727__auto___11911 + (1));
i__5727__auto___11911 = G__11912;
continue;
} else {
}
break;
}

var G__11909 = args11907.length;
switch (G__11909) {
case 1:
return sablono.core.text_area11906.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area11906.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11907.length)].join('')));

}
});

sablono.core.text_area11906.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area11906.call(null,name,null);
});

sablono.core.text_area11906.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area11906.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area11906);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label11914 = (function sablono$core$label11914(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label11914);
/**
 * Creates a submit button.
 */
sablono.core.submit_button11915 = (function sablono$core$submit_button11915(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button11915);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button11916 = (function sablono$core$reset_button11916(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button11916);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to11917 = (function sablono$core$form_to11917(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11922 = arguments.length;
var i__5727__auto___11923 = (0);
while(true){
if((i__5727__auto___11923 < len__5726__auto___11922)){
args__5733__auto__.push((arguments[i__5727__auto___11923]));

var G__11924 = (i__5727__auto___11923 + (1));
i__5727__auto___11923 = G__11924;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to11917.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to11917.cljs$core$IFn$_invoke$arity$variadic = (function (p__11920,body){
var vec__11921 = p__11920;
var method = cljs.core.nth.call(null,vec__11921,(0),null);
var action = cljs.core.nth.call(null,vec__11921,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to11917.cljs$lang$maxFixedArity = (1);

sablono.core.form_to11917.cljs$lang$applyTo = (function (seq11918){
var G__11919 = cljs.core.first.call(null,seq11918);
var seq11918__$1 = cljs.core.next.call(null,seq11918);
return sablono.core.form_to11917.cljs$core$IFn$_invoke$arity$variadic(G__11919,seq11918__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to11917);

//# sourceMappingURL=core.js.map?rel=1458825527141