// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17348 = [];
var len__5726__auto___17354 = arguments.length;
var i__5727__auto___17355 = (0);
while(true){
if((i__5727__auto___17355 < len__5726__auto___17354)){
args17348.push((arguments[i__5727__auto___17355]));

var G__17356 = (i__5727__auto___17355 + (1));
i__5727__auto___17355 = G__17356;
continue;
} else {
}
break;
}

var G__17350 = args17348.length;
switch (G__17350) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17348.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17351 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17351 = (function (f,blockable,meta17352){
this.f = f;
this.blockable = blockable;
this.meta17352 = meta17352;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17351.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17353,meta17352__$1){
var self__ = this;
var _17353__$1 = this;
return (new cljs.core.async.t_cljs$core$async17351(self__.f,self__.blockable,meta17352__$1));
});

cljs.core.async.t_cljs$core$async17351.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17353){
var self__ = this;
var _17353__$1 = this;
return self__.meta17352;
});

cljs.core.async.t_cljs$core$async17351.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17351.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17351.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17351.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17351.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17352","meta17352",1395390071,null)], null);
});

cljs.core.async.t_cljs$core$async17351.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17351.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17351";

cljs.core.async.t_cljs$core$async17351.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17351");
});

cljs.core.async.__GT_t_cljs$core$async17351 = (function cljs$core$async$__GT_t_cljs$core$async17351(f__$1,blockable__$1,meta17352){
return (new cljs.core.async.t_cljs$core$async17351(f__$1,blockable__$1,meta17352));
});

}

return (new cljs.core.async.t_cljs$core$async17351(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17360 = [];
var len__5726__auto___17363 = arguments.length;
var i__5727__auto___17364 = (0);
while(true){
if((i__5727__auto___17364 < len__5726__auto___17363)){
args17360.push((arguments[i__5727__auto___17364]));

var G__17365 = (i__5727__auto___17364 + (1));
i__5727__auto___17364 = G__17365;
continue;
} else {
}
break;
}

var G__17362 = args17360.length;
switch (G__17362) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17360.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17367 = [];
var len__5726__auto___17370 = arguments.length;
var i__5727__auto___17371 = (0);
while(true){
if((i__5727__auto___17371 < len__5726__auto___17370)){
args17367.push((arguments[i__5727__auto___17371]));

var G__17372 = (i__5727__auto___17371 + (1));
i__5727__auto___17371 = G__17372;
continue;
} else {
}
break;
}

var G__17369 = args17367.length;
switch (G__17369) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17367.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17374 = [];
var len__5726__auto___17377 = arguments.length;
var i__5727__auto___17378 = (0);
while(true){
if((i__5727__auto___17378 < len__5726__auto___17377)){
args17374.push((arguments[i__5727__auto___17378]));

var G__17379 = (i__5727__auto___17378 + (1));
i__5727__auto___17378 = G__17379;
continue;
} else {
}
break;
}

var G__17376 = args17374.length;
switch (G__17376) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17374.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17381 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17381);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17381,ret){
return (function (){
return fn1.call(null,val_17381);
});})(val_17381,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17382 = [];
var len__5726__auto___17385 = arguments.length;
var i__5727__auto___17386 = (0);
while(true){
if((i__5727__auto___17386 < len__5726__auto___17385)){
args17382.push((arguments[i__5727__auto___17386]));

var G__17387 = (i__5727__auto___17386 + (1));
i__5727__auto___17386 = G__17387;
continue;
} else {
}
break;
}

var G__17384 = args17382.length;
switch (G__17384) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17382.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17389 = n;
var x_17390 = (0);
while(true){
if((x_17390 < n__5571__auto___17389)){
(a[x_17390] = (0));

var G__17391 = (x_17390 + (1));
x_17390 = G__17391;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17392 = (i + (1));
i = G__17392;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17396 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17396 = (function (alt_flag,flag,meta17397){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17397 = meta17397;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17396.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17398,meta17397__$1){
var self__ = this;
var _17398__$1 = this;
return (new cljs.core.async.t_cljs$core$async17396(self__.alt_flag,self__.flag,meta17397__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17396.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17398){
var self__ = this;
var _17398__$1 = this;
return self__.meta17397;
});})(flag))
;

cljs.core.async.t_cljs$core$async17396.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17396.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17396.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17396.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17396.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17397","meta17397",-1376024316,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17396.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17396.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17396";

cljs.core.async.t_cljs$core$async17396.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17396");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17396 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17396(alt_flag__$1,flag__$1,meta17397){
return (new cljs.core.async.t_cljs$core$async17396(alt_flag__$1,flag__$1,meta17397));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17396(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17402 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17402 = (function (alt_handler,flag,cb,meta17403){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17403 = meta17403;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17402.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17404,meta17403__$1){
var self__ = this;
var _17404__$1 = this;
return (new cljs.core.async.t_cljs$core$async17402(self__.alt_handler,self__.flag,self__.cb,meta17403__$1));
});

cljs.core.async.t_cljs$core$async17402.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17404){
var self__ = this;
var _17404__$1 = this;
return self__.meta17403;
});

cljs.core.async.t_cljs$core$async17402.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17402.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17402.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17402.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17402.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17403","meta17403",-1974728587,null)], null);
});

cljs.core.async.t_cljs$core$async17402.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17402.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17402";

cljs.core.async.t_cljs$core$async17402.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17402");
});

cljs.core.async.__GT_t_cljs$core$async17402 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17402(alt_handler__$1,flag__$1,cb__$1,meta17403){
return (new cljs.core.async.t_cljs$core$async17402(alt_handler__$1,flag__$1,cb__$1,meta17403));
});

}

return (new cljs.core.async.t_cljs$core$async17402(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17405_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17405_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17406_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17406_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17407 = (i + (1));
i = G__17407;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17413 = arguments.length;
var i__5727__auto___17414 = (0);
while(true){
if((i__5727__auto___17414 < len__5726__auto___17413)){
args__5733__auto__.push((arguments[i__5727__auto___17414]));

var G__17415 = (i__5727__auto___17414 + (1));
i__5727__auto___17414 = G__17415;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17410){
var map__17411 = p__17410;
var map__17411__$1 = ((((!((map__17411 == null)))?((((map__17411.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17411.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17411):map__17411);
var opts = map__17411__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17408){
var G__17409 = cljs.core.first.call(null,seq17408);
var seq17408__$1 = cljs.core.next.call(null,seq17408);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17409,seq17408__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17416 = [];
var len__5726__auto___17466 = arguments.length;
var i__5727__auto___17467 = (0);
while(true){
if((i__5727__auto___17467 < len__5726__auto___17466)){
args17416.push((arguments[i__5727__auto___17467]));

var G__17468 = (i__5727__auto___17467 + (1));
i__5727__auto___17467 = G__17468;
continue;
} else {
}
break;
}

var G__17418 = args17416.length;
switch (G__17418) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17416.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17470 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17470){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17470){
return (function (state_17442){
var state_val_17443 = (state_17442[(1)]);
if((state_val_17443 === (7))){
var inst_17438 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
var statearr_17444_17471 = state_17442__$1;
(statearr_17444_17471[(2)] = inst_17438);

(statearr_17444_17471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (1))){
var state_17442__$1 = state_17442;
var statearr_17445_17472 = state_17442__$1;
(statearr_17445_17472[(2)] = null);

(statearr_17445_17472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (4))){
var inst_17421 = (state_17442[(7)]);
var inst_17421__$1 = (state_17442[(2)]);
var inst_17422 = (inst_17421__$1 == null);
var state_17442__$1 = (function (){var statearr_17446 = state_17442;
(statearr_17446[(7)] = inst_17421__$1);

return statearr_17446;
})();
if(cljs.core.truth_(inst_17422)){
var statearr_17447_17473 = state_17442__$1;
(statearr_17447_17473[(1)] = (5));

} else {
var statearr_17448_17474 = state_17442__$1;
(statearr_17448_17474[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (13))){
var state_17442__$1 = state_17442;
var statearr_17449_17475 = state_17442__$1;
(statearr_17449_17475[(2)] = null);

(statearr_17449_17475[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (6))){
var inst_17421 = (state_17442[(7)]);
var state_17442__$1 = state_17442;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17442__$1,(11),to,inst_17421);
} else {
if((state_val_17443 === (3))){
var inst_17440 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17442__$1,inst_17440);
} else {
if((state_val_17443 === (12))){
var state_17442__$1 = state_17442;
var statearr_17450_17476 = state_17442__$1;
(statearr_17450_17476[(2)] = null);

(statearr_17450_17476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (2))){
var state_17442__$1 = state_17442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17442__$1,(4),from);
} else {
if((state_val_17443 === (11))){
var inst_17431 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
if(cljs.core.truth_(inst_17431)){
var statearr_17451_17477 = state_17442__$1;
(statearr_17451_17477[(1)] = (12));

} else {
var statearr_17452_17478 = state_17442__$1;
(statearr_17452_17478[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (9))){
var state_17442__$1 = state_17442;
var statearr_17453_17479 = state_17442__$1;
(statearr_17453_17479[(2)] = null);

(statearr_17453_17479[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (5))){
var state_17442__$1 = state_17442;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17454_17480 = state_17442__$1;
(statearr_17454_17480[(1)] = (8));

} else {
var statearr_17455_17481 = state_17442__$1;
(statearr_17455_17481[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (14))){
var inst_17436 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
var statearr_17456_17482 = state_17442__$1;
(statearr_17456_17482[(2)] = inst_17436);

(statearr_17456_17482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (10))){
var inst_17428 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
var statearr_17457_17483 = state_17442__$1;
(statearr_17457_17483[(2)] = inst_17428);

(statearr_17457_17483[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (8))){
var inst_17425 = cljs.core.async.close_BANG_.call(null,to);
var state_17442__$1 = state_17442;
var statearr_17458_17484 = state_17442__$1;
(statearr_17458_17484[(2)] = inst_17425);

(statearr_17458_17484[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17470))
;
return ((function (switch__8250__auto__,c__8362__auto___17470){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17462 = [null,null,null,null,null,null,null,null];
(statearr_17462[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17462[(1)] = (1));

return statearr_17462;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17442){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17463){if((e17463 instanceof Object)){
var ex__8254__auto__ = e17463;
var statearr_17464_17485 = state_17442;
(statearr_17464_17485[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17442);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17463;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17486 = state_17442;
state_17442 = G__17486;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17442){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17470))
})();
var state__8364__auto__ = (function (){var statearr_17465 = f__8363__auto__.call(null);
(statearr_17465[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17470);

return statearr_17465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17470))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17670){
var vec__17671 = p__17670;
var v = cljs.core.nth.call(null,vec__17671,(0),null);
var p = cljs.core.nth.call(null,vec__17671,(1),null);
var job = vec__17671;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17853 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17853,res,vec__17671,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17853,res,vec__17671,v,p,job,jobs,results){
return (function (state_17676){
var state_val_17677 = (state_17676[(1)]);
if((state_val_17677 === (1))){
var state_17676__$1 = state_17676;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17676__$1,(2),res,v);
} else {
if((state_val_17677 === (2))){
var inst_17673 = (state_17676[(2)]);
var inst_17674 = cljs.core.async.close_BANG_.call(null,res);
var state_17676__$1 = (function (){var statearr_17678 = state_17676;
(statearr_17678[(7)] = inst_17673);

return statearr_17678;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17676__$1,inst_17674);
} else {
return null;
}
}
});})(c__8362__auto___17853,res,vec__17671,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17853,res,vec__17671,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17682 = [null,null,null,null,null,null,null,null];
(statearr_17682[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17682[(1)] = (1));

return statearr_17682;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17676){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17683){if((e17683 instanceof Object)){
var ex__8254__auto__ = e17683;
var statearr_17684_17854 = state_17676;
(statearr_17684_17854[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17676);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17683;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17855 = state_17676;
state_17676 = G__17855;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17676){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17853,res,vec__17671,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17685 = f__8363__auto__.call(null);
(statearr_17685[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17853);

return statearr_17685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17853,res,vec__17671,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17686){
var vec__17687 = p__17686;
var v = cljs.core.nth.call(null,vec__17687,(0),null);
var p = cljs.core.nth.call(null,vec__17687,(1),null);
var job = vec__17687;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17856 = n;
var __17857 = (0);
while(true){
if((__17857 < n__5571__auto___17856)){
var G__17688_17858 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17688_17858) {
case "compute":
var c__8362__auto___17860 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17857,c__8362__auto___17860,G__17688_17858,n__5571__auto___17856,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17857,c__8362__auto___17860,G__17688_17858,n__5571__auto___17856,jobs,results,process,async){
return (function (state_17701){
var state_val_17702 = (state_17701[(1)]);
if((state_val_17702 === (1))){
var state_17701__$1 = state_17701;
var statearr_17703_17861 = state_17701__$1;
(statearr_17703_17861[(2)] = null);

(statearr_17703_17861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17702 === (2))){
var state_17701__$1 = state_17701;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17701__$1,(4),jobs);
} else {
if((state_val_17702 === (3))){
var inst_17699 = (state_17701[(2)]);
var state_17701__$1 = state_17701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17701__$1,inst_17699);
} else {
if((state_val_17702 === (4))){
var inst_17691 = (state_17701[(2)]);
var inst_17692 = process.call(null,inst_17691);
var state_17701__$1 = state_17701;
if(cljs.core.truth_(inst_17692)){
var statearr_17704_17862 = state_17701__$1;
(statearr_17704_17862[(1)] = (5));

} else {
var statearr_17705_17863 = state_17701__$1;
(statearr_17705_17863[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17702 === (5))){
var state_17701__$1 = state_17701;
var statearr_17706_17864 = state_17701__$1;
(statearr_17706_17864[(2)] = null);

(statearr_17706_17864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17702 === (6))){
var state_17701__$1 = state_17701;
var statearr_17707_17865 = state_17701__$1;
(statearr_17707_17865[(2)] = null);

(statearr_17707_17865[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17702 === (7))){
var inst_17697 = (state_17701[(2)]);
var state_17701__$1 = state_17701;
var statearr_17708_17866 = state_17701__$1;
(statearr_17708_17866[(2)] = inst_17697);

(statearr_17708_17866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17857,c__8362__auto___17860,G__17688_17858,n__5571__auto___17856,jobs,results,process,async))
;
return ((function (__17857,switch__8250__auto__,c__8362__auto___17860,G__17688_17858,n__5571__auto___17856,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17712 = [null,null,null,null,null,null,null];
(statearr_17712[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17712[(1)] = (1));

return statearr_17712;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17701){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17713){if((e17713 instanceof Object)){
var ex__8254__auto__ = e17713;
var statearr_17714_17867 = state_17701;
(statearr_17714_17867[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17701);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17868 = state_17701;
state_17701 = G__17868;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17701){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17857,switch__8250__auto__,c__8362__auto___17860,G__17688_17858,n__5571__auto___17856,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17715 = f__8363__auto__.call(null);
(statearr_17715[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17860);

return statearr_17715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17857,c__8362__auto___17860,G__17688_17858,n__5571__auto___17856,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17869 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17857,c__8362__auto___17869,G__17688_17858,n__5571__auto___17856,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17857,c__8362__auto___17869,G__17688_17858,n__5571__auto___17856,jobs,results,process,async){
return (function (state_17728){
var state_val_17729 = (state_17728[(1)]);
if((state_val_17729 === (1))){
var state_17728__$1 = state_17728;
var statearr_17730_17870 = state_17728__$1;
(statearr_17730_17870[(2)] = null);

(statearr_17730_17870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17729 === (2))){
var state_17728__$1 = state_17728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17728__$1,(4),jobs);
} else {
if((state_val_17729 === (3))){
var inst_17726 = (state_17728[(2)]);
var state_17728__$1 = state_17728;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17728__$1,inst_17726);
} else {
if((state_val_17729 === (4))){
var inst_17718 = (state_17728[(2)]);
var inst_17719 = async.call(null,inst_17718);
var state_17728__$1 = state_17728;
if(cljs.core.truth_(inst_17719)){
var statearr_17731_17871 = state_17728__$1;
(statearr_17731_17871[(1)] = (5));

} else {
var statearr_17732_17872 = state_17728__$1;
(statearr_17732_17872[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17729 === (5))){
var state_17728__$1 = state_17728;
var statearr_17733_17873 = state_17728__$1;
(statearr_17733_17873[(2)] = null);

(statearr_17733_17873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17729 === (6))){
var state_17728__$1 = state_17728;
var statearr_17734_17874 = state_17728__$1;
(statearr_17734_17874[(2)] = null);

(statearr_17734_17874[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17729 === (7))){
var inst_17724 = (state_17728[(2)]);
var state_17728__$1 = state_17728;
var statearr_17735_17875 = state_17728__$1;
(statearr_17735_17875[(2)] = inst_17724);

(statearr_17735_17875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17857,c__8362__auto___17869,G__17688_17858,n__5571__auto___17856,jobs,results,process,async))
;
return ((function (__17857,switch__8250__auto__,c__8362__auto___17869,G__17688_17858,n__5571__auto___17856,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17739 = [null,null,null,null,null,null,null];
(statearr_17739[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17739[(1)] = (1));

return statearr_17739;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17728){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17740){if((e17740 instanceof Object)){
var ex__8254__auto__ = e17740;
var statearr_17741_17876 = state_17728;
(statearr_17741_17876[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17728);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17877 = state_17728;
state_17728 = G__17877;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17728){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17857,switch__8250__auto__,c__8362__auto___17869,G__17688_17858,n__5571__auto___17856,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17742 = f__8363__auto__.call(null);
(statearr_17742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17869);

return statearr_17742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17857,c__8362__auto___17869,G__17688_17858,n__5571__auto___17856,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17878 = (__17857 + (1));
__17857 = G__17878;
continue;
} else {
}
break;
}

var c__8362__auto___17879 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17879,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17879,jobs,results,process,async){
return (function (state_17764){
var state_val_17765 = (state_17764[(1)]);
if((state_val_17765 === (1))){
var state_17764__$1 = state_17764;
var statearr_17766_17880 = state_17764__$1;
(statearr_17766_17880[(2)] = null);

(statearr_17766_17880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17765 === (2))){
var state_17764__$1 = state_17764;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17764__$1,(4),from);
} else {
if((state_val_17765 === (3))){
var inst_17762 = (state_17764[(2)]);
var state_17764__$1 = state_17764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17764__$1,inst_17762);
} else {
if((state_val_17765 === (4))){
var inst_17745 = (state_17764[(7)]);
var inst_17745__$1 = (state_17764[(2)]);
var inst_17746 = (inst_17745__$1 == null);
var state_17764__$1 = (function (){var statearr_17767 = state_17764;
(statearr_17767[(7)] = inst_17745__$1);

return statearr_17767;
})();
if(cljs.core.truth_(inst_17746)){
var statearr_17768_17881 = state_17764__$1;
(statearr_17768_17881[(1)] = (5));

} else {
var statearr_17769_17882 = state_17764__$1;
(statearr_17769_17882[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17765 === (5))){
var inst_17748 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17764__$1 = state_17764;
var statearr_17770_17883 = state_17764__$1;
(statearr_17770_17883[(2)] = inst_17748);

(statearr_17770_17883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17765 === (6))){
var inst_17750 = (state_17764[(8)]);
var inst_17745 = (state_17764[(7)]);
var inst_17750__$1 = cljs.core.async.chan.call(null,(1));
var inst_17751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17752 = [inst_17745,inst_17750__$1];
var inst_17753 = (new cljs.core.PersistentVector(null,2,(5),inst_17751,inst_17752,null));
var state_17764__$1 = (function (){var statearr_17771 = state_17764;
(statearr_17771[(8)] = inst_17750__$1);

return statearr_17771;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17764__$1,(8),jobs,inst_17753);
} else {
if((state_val_17765 === (7))){
var inst_17760 = (state_17764[(2)]);
var state_17764__$1 = state_17764;
var statearr_17772_17884 = state_17764__$1;
(statearr_17772_17884[(2)] = inst_17760);

(statearr_17772_17884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17765 === (8))){
var inst_17750 = (state_17764[(8)]);
var inst_17755 = (state_17764[(2)]);
var state_17764__$1 = (function (){var statearr_17773 = state_17764;
(statearr_17773[(9)] = inst_17755);

return statearr_17773;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17764__$1,(9),results,inst_17750);
} else {
if((state_val_17765 === (9))){
var inst_17757 = (state_17764[(2)]);
var state_17764__$1 = (function (){var statearr_17774 = state_17764;
(statearr_17774[(10)] = inst_17757);

return statearr_17774;
})();
var statearr_17775_17885 = state_17764__$1;
(statearr_17775_17885[(2)] = null);

(statearr_17775_17885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17879,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17879,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17779 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17779[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17779[(1)] = (1));

return statearr_17779;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17764){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17780){if((e17780 instanceof Object)){
var ex__8254__auto__ = e17780;
var statearr_17781_17886 = state_17764;
(statearr_17781_17886[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17764);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17780;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17887 = state_17764;
state_17764 = G__17887;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17764){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17879,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17782 = f__8363__auto__.call(null);
(statearr_17782[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17879);

return statearr_17782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17879,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17820){
var state_val_17821 = (state_17820[(1)]);
if((state_val_17821 === (7))){
var inst_17816 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
var statearr_17822_17888 = state_17820__$1;
(statearr_17822_17888[(2)] = inst_17816);

(statearr_17822_17888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (20))){
var state_17820__$1 = state_17820;
var statearr_17823_17889 = state_17820__$1;
(statearr_17823_17889[(2)] = null);

(statearr_17823_17889[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (1))){
var state_17820__$1 = state_17820;
var statearr_17824_17890 = state_17820__$1;
(statearr_17824_17890[(2)] = null);

(statearr_17824_17890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (4))){
var inst_17785 = (state_17820[(7)]);
var inst_17785__$1 = (state_17820[(2)]);
var inst_17786 = (inst_17785__$1 == null);
var state_17820__$1 = (function (){var statearr_17825 = state_17820;
(statearr_17825[(7)] = inst_17785__$1);

return statearr_17825;
})();
if(cljs.core.truth_(inst_17786)){
var statearr_17826_17891 = state_17820__$1;
(statearr_17826_17891[(1)] = (5));

} else {
var statearr_17827_17892 = state_17820__$1;
(statearr_17827_17892[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (15))){
var inst_17798 = (state_17820[(8)]);
var state_17820__$1 = state_17820;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17820__$1,(18),to,inst_17798);
} else {
if((state_val_17821 === (21))){
var inst_17811 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
var statearr_17828_17893 = state_17820__$1;
(statearr_17828_17893[(2)] = inst_17811);

(statearr_17828_17893[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (13))){
var inst_17813 = (state_17820[(2)]);
var state_17820__$1 = (function (){var statearr_17829 = state_17820;
(statearr_17829[(9)] = inst_17813);

return statearr_17829;
})();
var statearr_17830_17894 = state_17820__$1;
(statearr_17830_17894[(2)] = null);

(statearr_17830_17894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (6))){
var inst_17785 = (state_17820[(7)]);
var state_17820__$1 = state_17820;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17820__$1,(11),inst_17785);
} else {
if((state_val_17821 === (17))){
var inst_17806 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
if(cljs.core.truth_(inst_17806)){
var statearr_17831_17895 = state_17820__$1;
(statearr_17831_17895[(1)] = (19));

} else {
var statearr_17832_17896 = state_17820__$1;
(statearr_17832_17896[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (3))){
var inst_17818 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17820__$1,inst_17818);
} else {
if((state_val_17821 === (12))){
var inst_17795 = (state_17820[(10)]);
var state_17820__$1 = state_17820;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17820__$1,(14),inst_17795);
} else {
if((state_val_17821 === (2))){
var state_17820__$1 = state_17820;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17820__$1,(4),results);
} else {
if((state_val_17821 === (19))){
var state_17820__$1 = state_17820;
var statearr_17833_17897 = state_17820__$1;
(statearr_17833_17897[(2)] = null);

(statearr_17833_17897[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (11))){
var inst_17795 = (state_17820[(2)]);
var state_17820__$1 = (function (){var statearr_17834 = state_17820;
(statearr_17834[(10)] = inst_17795);

return statearr_17834;
})();
var statearr_17835_17898 = state_17820__$1;
(statearr_17835_17898[(2)] = null);

(statearr_17835_17898[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (9))){
var state_17820__$1 = state_17820;
var statearr_17836_17899 = state_17820__$1;
(statearr_17836_17899[(2)] = null);

(statearr_17836_17899[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (5))){
var state_17820__$1 = state_17820;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17837_17900 = state_17820__$1;
(statearr_17837_17900[(1)] = (8));

} else {
var statearr_17838_17901 = state_17820__$1;
(statearr_17838_17901[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (14))){
var inst_17800 = (state_17820[(11)]);
var inst_17798 = (state_17820[(8)]);
var inst_17798__$1 = (state_17820[(2)]);
var inst_17799 = (inst_17798__$1 == null);
var inst_17800__$1 = cljs.core.not.call(null,inst_17799);
var state_17820__$1 = (function (){var statearr_17839 = state_17820;
(statearr_17839[(11)] = inst_17800__$1);

(statearr_17839[(8)] = inst_17798__$1);

return statearr_17839;
})();
if(inst_17800__$1){
var statearr_17840_17902 = state_17820__$1;
(statearr_17840_17902[(1)] = (15));

} else {
var statearr_17841_17903 = state_17820__$1;
(statearr_17841_17903[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (16))){
var inst_17800 = (state_17820[(11)]);
var state_17820__$1 = state_17820;
var statearr_17842_17904 = state_17820__$1;
(statearr_17842_17904[(2)] = inst_17800);

(statearr_17842_17904[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (10))){
var inst_17792 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
var statearr_17843_17905 = state_17820__$1;
(statearr_17843_17905[(2)] = inst_17792);

(statearr_17843_17905[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (18))){
var inst_17803 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
var statearr_17844_17906 = state_17820__$1;
(statearr_17844_17906[(2)] = inst_17803);

(statearr_17844_17906[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17821 === (8))){
var inst_17789 = cljs.core.async.close_BANG_.call(null,to);
var state_17820__$1 = state_17820;
var statearr_17845_17907 = state_17820__$1;
(statearr_17845_17907[(2)] = inst_17789);

(statearr_17845_17907[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17849 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17849[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17849[(1)] = (1));

return statearr_17849;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17820){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17850){if((e17850 instanceof Object)){
var ex__8254__auto__ = e17850;
var statearr_17851_17908 = state_17820;
(statearr_17851_17908[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17820);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17850;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17909 = state_17820;
state_17820 = G__17909;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17820){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17852 = f__8363__auto__.call(null);
(statearr_17852[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17910 = [];
var len__5726__auto___17913 = arguments.length;
var i__5727__auto___17914 = (0);
while(true){
if((i__5727__auto___17914 < len__5726__auto___17913)){
args17910.push((arguments[i__5727__auto___17914]));

var G__17915 = (i__5727__auto___17914 + (1));
i__5727__auto___17914 = G__17915;
continue;
} else {
}
break;
}

var G__17912 = args17910.length;
switch (G__17912) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17910.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17917 = [];
var len__5726__auto___17920 = arguments.length;
var i__5727__auto___17921 = (0);
while(true){
if((i__5727__auto___17921 < len__5726__auto___17920)){
args17917.push((arguments[i__5727__auto___17921]));

var G__17922 = (i__5727__auto___17921 + (1));
i__5727__auto___17921 = G__17922;
continue;
} else {
}
break;
}

var G__17919 = args17917.length;
switch (G__17919) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17917.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17924 = [];
var len__5726__auto___17977 = arguments.length;
var i__5727__auto___17978 = (0);
while(true){
if((i__5727__auto___17978 < len__5726__auto___17977)){
args17924.push((arguments[i__5727__auto___17978]));

var G__17979 = (i__5727__auto___17978 + (1));
i__5727__auto___17978 = G__17979;
continue;
} else {
}
break;
}

var G__17926 = args17924.length;
switch (G__17926) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17924.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17981 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17981,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17981,tc,fc){
return (function (state_17952){
var state_val_17953 = (state_17952[(1)]);
if((state_val_17953 === (7))){
var inst_17948 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
var statearr_17954_17982 = state_17952__$1;
(statearr_17954_17982[(2)] = inst_17948);

(statearr_17954_17982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (1))){
var state_17952__$1 = state_17952;
var statearr_17955_17983 = state_17952__$1;
(statearr_17955_17983[(2)] = null);

(statearr_17955_17983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (4))){
var inst_17929 = (state_17952[(7)]);
var inst_17929__$1 = (state_17952[(2)]);
var inst_17930 = (inst_17929__$1 == null);
var state_17952__$1 = (function (){var statearr_17956 = state_17952;
(statearr_17956[(7)] = inst_17929__$1);

return statearr_17956;
})();
if(cljs.core.truth_(inst_17930)){
var statearr_17957_17984 = state_17952__$1;
(statearr_17957_17984[(1)] = (5));

} else {
var statearr_17958_17985 = state_17952__$1;
(statearr_17958_17985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (13))){
var state_17952__$1 = state_17952;
var statearr_17959_17986 = state_17952__$1;
(statearr_17959_17986[(2)] = null);

(statearr_17959_17986[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (6))){
var inst_17929 = (state_17952[(7)]);
var inst_17935 = p.call(null,inst_17929);
var state_17952__$1 = state_17952;
if(cljs.core.truth_(inst_17935)){
var statearr_17960_17987 = state_17952__$1;
(statearr_17960_17987[(1)] = (9));

} else {
var statearr_17961_17988 = state_17952__$1;
(statearr_17961_17988[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (3))){
var inst_17950 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17952__$1,inst_17950);
} else {
if((state_val_17953 === (12))){
var state_17952__$1 = state_17952;
var statearr_17962_17989 = state_17952__$1;
(statearr_17962_17989[(2)] = null);

(statearr_17962_17989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (2))){
var state_17952__$1 = state_17952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17952__$1,(4),ch);
} else {
if((state_val_17953 === (11))){
var inst_17929 = (state_17952[(7)]);
var inst_17939 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17952__$1,(8),inst_17939,inst_17929);
} else {
if((state_val_17953 === (9))){
var state_17952__$1 = state_17952;
var statearr_17963_17990 = state_17952__$1;
(statearr_17963_17990[(2)] = tc);

(statearr_17963_17990[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (5))){
var inst_17932 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17933 = cljs.core.async.close_BANG_.call(null,fc);
var state_17952__$1 = (function (){var statearr_17964 = state_17952;
(statearr_17964[(8)] = inst_17932);

return statearr_17964;
})();
var statearr_17965_17991 = state_17952__$1;
(statearr_17965_17991[(2)] = inst_17933);

(statearr_17965_17991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (14))){
var inst_17946 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
var statearr_17966_17992 = state_17952__$1;
(statearr_17966_17992[(2)] = inst_17946);

(statearr_17966_17992[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (10))){
var state_17952__$1 = state_17952;
var statearr_17967_17993 = state_17952__$1;
(statearr_17967_17993[(2)] = fc);

(statearr_17967_17993[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (8))){
var inst_17941 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
if(cljs.core.truth_(inst_17941)){
var statearr_17968_17994 = state_17952__$1;
(statearr_17968_17994[(1)] = (12));

} else {
var statearr_17969_17995 = state_17952__$1;
(statearr_17969_17995[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17981,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17981,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17973 = [null,null,null,null,null,null,null,null,null];
(statearr_17973[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17973[(1)] = (1));

return statearr_17973;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17952){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17974){if((e17974 instanceof Object)){
var ex__8254__auto__ = e17974;
var statearr_17975_17996 = state_17952;
(statearr_17975_17996[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17952);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17974;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17997 = state_17952;
state_17952 = G__17997;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17952){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17981,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17976 = f__8363__auto__.call(null);
(statearr_17976[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17981);

return statearr_17976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17981,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18061){
var state_val_18062 = (state_18061[(1)]);
if((state_val_18062 === (7))){
var inst_18057 = (state_18061[(2)]);
var state_18061__$1 = state_18061;
var statearr_18063_18084 = state_18061__$1;
(statearr_18063_18084[(2)] = inst_18057);

(statearr_18063_18084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (1))){
var inst_18041 = init;
var state_18061__$1 = (function (){var statearr_18064 = state_18061;
(statearr_18064[(7)] = inst_18041);

return statearr_18064;
})();
var statearr_18065_18085 = state_18061__$1;
(statearr_18065_18085[(2)] = null);

(statearr_18065_18085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (4))){
var inst_18044 = (state_18061[(8)]);
var inst_18044__$1 = (state_18061[(2)]);
var inst_18045 = (inst_18044__$1 == null);
var state_18061__$1 = (function (){var statearr_18066 = state_18061;
(statearr_18066[(8)] = inst_18044__$1);

return statearr_18066;
})();
if(cljs.core.truth_(inst_18045)){
var statearr_18067_18086 = state_18061__$1;
(statearr_18067_18086[(1)] = (5));

} else {
var statearr_18068_18087 = state_18061__$1;
(statearr_18068_18087[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (6))){
var inst_18044 = (state_18061[(8)]);
var inst_18048 = (state_18061[(9)]);
var inst_18041 = (state_18061[(7)]);
var inst_18048__$1 = f.call(null,inst_18041,inst_18044);
var inst_18049 = cljs.core.reduced_QMARK_.call(null,inst_18048__$1);
var state_18061__$1 = (function (){var statearr_18069 = state_18061;
(statearr_18069[(9)] = inst_18048__$1);

return statearr_18069;
})();
if(inst_18049){
var statearr_18070_18088 = state_18061__$1;
(statearr_18070_18088[(1)] = (8));

} else {
var statearr_18071_18089 = state_18061__$1;
(statearr_18071_18089[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (3))){
var inst_18059 = (state_18061[(2)]);
var state_18061__$1 = state_18061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18061__$1,inst_18059);
} else {
if((state_val_18062 === (2))){
var state_18061__$1 = state_18061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18061__$1,(4),ch);
} else {
if((state_val_18062 === (9))){
var inst_18048 = (state_18061[(9)]);
var inst_18041 = inst_18048;
var state_18061__$1 = (function (){var statearr_18072 = state_18061;
(statearr_18072[(7)] = inst_18041);

return statearr_18072;
})();
var statearr_18073_18090 = state_18061__$1;
(statearr_18073_18090[(2)] = null);

(statearr_18073_18090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (5))){
var inst_18041 = (state_18061[(7)]);
var state_18061__$1 = state_18061;
var statearr_18074_18091 = state_18061__$1;
(statearr_18074_18091[(2)] = inst_18041);

(statearr_18074_18091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (10))){
var inst_18055 = (state_18061[(2)]);
var state_18061__$1 = state_18061;
var statearr_18075_18092 = state_18061__$1;
(statearr_18075_18092[(2)] = inst_18055);

(statearr_18075_18092[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (8))){
var inst_18048 = (state_18061[(9)]);
var inst_18051 = cljs.core.deref.call(null,inst_18048);
var state_18061__$1 = state_18061;
var statearr_18076_18093 = state_18061__$1;
(statearr_18076_18093[(2)] = inst_18051);

(statearr_18076_18093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18080 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18080[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18080[(1)] = (1));

return statearr_18080;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18061){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18081){if((e18081 instanceof Object)){
var ex__8254__auto__ = e18081;
var statearr_18082_18094 = state_18061;
(statearr_18082_18094[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18061);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18081;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18095 = state_18061;
state_18061 = G__18095;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18061){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18083 = f__8363__auto__.call(null);
(statearr_18083[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18096 = [];
var len__5726__auto___18148 = arguments.length;
var i__5727__auto___18149 = (0);
while(true){
if((i__5727__auto___18149 < len__5726__auto___18148)){
args18096.push((arguments[i__5727__auto___18149]));

var G__18150 = (i__5727__auto___18149 + (1));
i__5727__auto___18149 = G__18150;
continue;
} else {
}
break;
}

var G__18098 = args18096.length;
switch (G__18098) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18096.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18123){
var state_val_18124 = (state_18123[(1)]);
if((state_val_18124 === (7))){
var inst_18105 = (state_18123[(2)]);
var state_18123__$1 = state_18123;
var statearr_18125_18152 = state_18123__$1;
(statearr_18125_18152[(2)] = inst_18105);

(statearr_18125_18152[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (1))){
var inst_18099 = cljs.core.seq.call(null,coll);
var inst_18100 = inst_18099;
var state_18123__$1 = (function (){var statearr_18126 = state_18123;
(statearr_18126[(7)] = inst_18100);

return statearr_18126;
})();
var statearr_18127_18153 = state_18123__$1;
(statearr_18127_18153[(2)] = null);

(statearr_18127_18153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (4))){
var inst_18100 = (state_18123[(7)]);
var inst_18103 = cljs.core.first.call(null,inst_18100);
var state_18123__$1 = state_18123;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18123__$1,(7),ch,inst_18103);
} else {
if((state_val_18124 === (13))){
var inst_18117 = (state_18123[(2)]);
var state_18123__$1 = state_18123;
var statearr_18128_18154 = state_18123__$1;
(statearr_18128_18154[(2)] = inst_18117);

(statearr_18128_18154[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (6))){
var inst_18108 = (state_18123[(2)]);
var state_18123__$1 = state_18123;
if(cljs.core.truth_(inst_18108)){
var statearr_18129_18155 = state_18123__$1;
(statearr_18129_18155[(1)] = (8));

} else {
var statearr_18130_18156 = state_18123__$1;
(statearr_18130_18156[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (3))){
var inst_18121 = (state_18123[(2)]);
var state_18123__$1 = state_18123;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18123__$1,inst_18121);
} else {
if((state_val_18124 === (12))){
var state_18123__$1 = state_18123;
var statearr_18131_18157 = state_18123__$1;
(statearr_18131_18157[(2)] = null);

(statearr_18131_18157[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (2))){
var inst_18100 = (state_18123[(7)]);
var state_18123__$1 = state_18123;
if(cljs.core.truth_(inst_18100)){
var statearr_18132_18158 = state_18123__$1;
(statearr_18132_18158[(1)] = (4));

} else {
var statearr_18133_18159 = state_18123__$1;
(statearr_18133_18159[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (11))){
var inst_18114 = cljs.core.async.close_BANG_.call(null,ch);
var state_18123__$1 = state_18123;
var statearr_18134_18160 = state_18123__$1;
(statearr_18134_18160[(2)] = inst_18114);

(statearr_18134_18160[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (9))){
var state_18123__$1 = state_18123;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18135_18161 = state_18123__$1;
(statearr_18135_18161[(1)] = (11));

} else {
var statearr_18136_18162 = state_18123__$1;
(statearr_18136_18162[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (5))){
var inst_18100 = (state_18123[(7)]);
var state_18123__$1 = state_18123;
var statearr_18137_18163 = state_18123__$1;
(statearr_18137_18163[(2)] = inst_18100);

(statearr_18137_18163[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (10))){
var inst_18119 = (state_18123[(2)]);
var state_18123__$1 = state_18123;
var statearr_18138_18164 = state_18123__$1;
(statearr_18138_18164[(2)] = inst_18119);

(statearr_18138_18164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18124 === (8))){
var inst_18100 = (state_18123[(7)]);
var inst_18110 = cljs.core.next.call(null,inst_18100);
var inst_18100__$1 = inst_18110;
var state_18123__$1 = (function (){var statearr_18139 = state_18123;
(statearr_18139[(7)] = inst_18100__$1);

return statearr_18139;
})();
var statearr_18140_18165 = state_18123__$1;
(statearr_18140_18165[(2)] = null);

(statearr_18140_18165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18144 = [null,null,null,null,null,null,null,null];
(statearr_18144[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18144[(1)] = (1));

return statearr_18144;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18123){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18123);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18145){if((e18145 instanceof Object)){
var ex__8254__auto__ = e18145;
var statearr_18146_18166 = state_18123;
(statearr_18146_18166[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18123);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18145;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18167 = state_18123;
state_18123 = G__18167;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18123){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18147 = f__8363__auto__.call(null);
(statearr_18147[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18389 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18389 = (function (mult,ch,cs,meta18390){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18390 = meta18390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18391,meta18390__$1){
var self__ = this;
var _18391__$1 = this;
return (new cljs.core.async.t_cljs$core$async18389(self__.mult,self__.ch,self__.cs,meta18390__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18391){
var self__ = this;
var _18391__$1 = this;
return self__.meta18390;
});})(cs))
;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18389.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18389.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18390","meta18390",214656560,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18389.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18389.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18389";

cljs.core.async.t_cljs$core$async18389.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18389");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18389 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18389(mult__$1,ch__$1,cs__$1,meta18390){
return (new cljs.core.async.t_cljs$core$async18389(mult__$1,ch__$1,cs__$1,meta18390));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18389(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18610 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18610,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18610,cs,m,dchan,dctr,done){
return (function (state_18522){
var state_val_18523 = (state_18522[(1)]);
if((state_val_18523 === (7))){
var inst_18518 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18524_18611 = state_18522__$1;
(statearr_18524_18611[(2)] = inst_18518);

(statearr_18524_18611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (20))){
var inst_18423 = (state_18522[(7)]);
var inst_18433 = cljs.core.first.call(null,inst_18423);
var inst_18434 = cljs.core.nth.call(null,inst_18433,(0),null);
var inst_18435 = cljs.core.nth.call(null,inst_18433,(1),null);
var state_18522__$1 = (function (){var statearr_18525 = state_18522;
(statearr_18525[(8)] = inst_18434);

return statearr_18525;
})();
if(cljs.core.truth_(inst_18435)){
var statearr_18526_18612 = state_18522__$1;
(statearr_18526_18612[(1)] = (22));

} else {
var statearr_18527_18613 = state_18522__$1;
(statearr_18527_18613[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (27))){
var inst_18465 = (state_18522[(9)]);
var inst_18463 = (state_18522[(10)]);
var inst_18470 = (state_18522[(11)]);
var inst_18394 = (state_18522[(12)]);
var inst_18470__$1 = cljs.core._nth.call(null,inst_18463,inst_18465);
var inst_18471 = cljs.core.async.put_BANG_.call(null,inst_18470__$1,inst_18394,done);
var state_18522__$1 = (function (){var statearr_18528 = state_18522;
(statearr_18528[(11)] = inst_18470__$1);

return statearr_18528;
})();
if(cljs.core.truth_(inst_18471)){
var statearr_18529_18614 = state_18522__$1;
(statearr_18529_18614[(1)] = (30));

} else {
var statearr_18530_18615 = state_18522__$1;
(statearr_18530_18615[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (1))){
var state_18522__$1 = state_18522;
var statearr_18531_18616 = state_18522__$1;
(statearr_18531_18616[(2)] = null);

(statearr_18531_18616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (24))){
var inst_18423 = (state_18522[(7)]);
var inst_18440 = (state_18522[(2)]);
var inst_18441 = cljs.core.next.call(null,inst_18423);
var inst_18403 = inst_18441;
var inst_18404 = null;
var inst_18405 = (0);
var inst_18406 = (0);
var state_18522__$1 = (function (){var statearr_18532 = state_18522;
(statearr_18532[(13)] = inst_18404);

(statearr_18532[(14)] = inst_18403);

(statearr_18532[(15)] = inst_18406);

(statearr_18532[(16)] = inst_18405);

(statearr_18532[(17)] = inst_18440);

return statearr_18532;
})();
var statearr_18533_18617 = state_18522__$1;
(statearr_18533_18617[(2)] = null);

(statearr_18533_18617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (39))){
var state_18522__$1 = state_18522;
var statearr_18537_18618 = state_18522__$1;
(statearr_18537_18618[(2)] = null);

(statearr_18537_18618[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (4))){
var inst_18394 = (state_18522[(12)]);
var inst_18394__$1 = (state_18522[(2)]);
var inst_18395 = (inst_18394__$1 == null);
var state_18522__$1 = (function (){var statearr_18538 = state_18522;
(statearr_18538[(12)] = inst_18394__$1);

return statearr_18538;
})();
if(cljs.core.truth_(inst_18395)){
var statearr_18539_18619 = state_18522__$1;
(statearr_18539_18619[(1)] = (5));

} else {
var statearr_18540_18620 = state_18522__$1;
(statearr_18540_18620[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (15))){
var inst_18404 = (state_18522[(13)]);
var inst_18403 = (state_18522[(14)]);
var inst_18406 = (state_18522[(15)]);
var inst_18405 = (state_18522[(16)]);
var inst_18419 = (state_18522[(2)]);
var inst_18420 = (inst_18406 + (1));
var tmp18534 = inst_18404;
var tmp18535 = inst_18403;
var tmp18536 = inst_18405;
var inst_18403__$1 = tmp18535;
var inst_18404__$1 = tmp18534;
var inst_18405__$1 = tmp18536;
var inst_18406__$1 = inst_18420;
var state_18522__$1 = (function (){var statearr_18541 = state_18522;
(statearr_18541[(13)] = inst_18404__$1);

(statearr_18541[(14)] = inst_18403__$1);

(statearr_18541[(15)] = inst_18406__$1);

(statearr_18541[(18)] = inst_18419);

(statearr_18541[(16)] = inst_18405__$1);

return statearr_18541;
})();
var statearr_18542_18621 = state_18522__$1;
(statearr_18542_18621[(2)] = null);

(statearr_18542_18621[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (21))){
var inst_18444 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18546_18622 = state_18522__$1;
(statearr_18546_18622[(2)] = inst_18444);

(statearr_18546_18622[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (31))){
var inst_18470 = (state_18522[(11)]);
var inst_18474 = done.call(null,null);
var inst_18475 = cljs.core.async.untap_STAR_.call(null,m,inst_18470);
var state_18522__$1 = (function (){var statearr_18547 = state_18522;
(statearr_18547[(19)] = inst_18474);

return statearr_18547;
})();
var statearr_18548_18623 = state_18522__$1;
(statearr_18548_18623[(2)] = inst_18475);

(statearr_18548_18623[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (32))){
var inst_18462 = (state_18522[(20)]);
var inst_18465 = (state_18522[(9)]);
var inst_18464 = (state_18522[(21)]);
var inst_18463 = (state_18522[(10)]);
var inst_18477 = (state_18522[(2)]);
var inst_18478 = (inst_18465 + (1));
var tmp18543 = inst_18462;
var tmp18544 = inst_18464;
var tmp18545 = inst_18463;
var inst_18462__$1 = tmp18543;
var inst_18463__$1 = tmp18545;
var inst_18464__$1 = tmp18544;
var inst_18465__$1 = inst_18478;
var state_18522__$1 = (function (){var statearr_18549 = state_18522;
(statearr_18549[(20)] = inst_18462__$1);

(statearr_18549[(22)] = inst_18477);

(statearr_18549[(9)] = inst_18465__$1);

(statearr_18549[(21)] = inst_18464__$1);

(statearr_18549[(10)] = inst_18463__$1);

return statearr_18549;
})();
var statearr_18550_18624 = state_18522__$1;
(statearr_18550_18624[(2)] = null);

(statearr_18550_18624[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (40))){
var inst_18490 = (state_18522[(23)]);
var inst_18494 = done.call(null,null);
var inst_18495 = cljs.core.async.untap_STAR_.call(null,m,inst_18490);
var state_18522__$1 = (function (){var statearr_18551 = state_18522;
(statearr_18551[(24)] = inst_18494);

return statearr_18551;
})();
var statearr_18552_18625 = state_18522__$1;
(statearr_18552_18625[(2)] = inst_18495);

(statearr_18552_18625[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (33))){
var inst_18481 = (state_18522[(25)]);
var inst_18483 = cljs.core.chunked_seq_QMARK_.call(null,inst_18481);
var state_18522__$1 = state_18522;
if(inst_18483){
var statearr_18553_18626 = state_18522__$1;
(statearr_18553_18626[(1)] = (36));

} else {
var statearr_18554_18627 = state_18522__$1;
(statearr_18554_18627[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (13))){
var inst_18413 = (state_18522[(26)]);
var inst_18416 = cljs.core.async.close_BANG_.call(null,inst_18413);
var state_18522__$1 = state_18522;
var statearr_18555_18628 = state_18522__$1;
(statearr_18555_18628[(2)] = inst_18416);

(statearr_18555_18628[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (22))){
var inst_18434 = (state_18522[(8)]);
var inst_18437 = cljs.core.async.close_BANG_.call(null,inst_18434);
var state_18522__$1 = state_18522;
var statearr_18556_18629 = state_18522__$1;
(statearr_18556_18629[(2)] = inst_18437);

(statearr_18556_18629[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (36))){
var inst_18481 = (state_18522[(25)]);
var inst_18485 = cljs.core.chunk_first.call(null,inst_18481);
var inst_18486 = cljs.core.chunk_rest.call(null,inst_18481);
var inst_18487 = cljs.core.count.call(null,inst_18485);
var inst_18462 = inst_18486;
var inst_18463 = inst_18485;
var inst_18464 = inst_18487;
var inst_18465 = (0);
var state_18522__$1 = (function (){var statearr_18557 = state_18522;
(statearr_18557[(20)] = inst_18462);

(statearr_18557[(9)] = inst_18465);

(statearr_18557[(21)] = inst_18464);

(statearr_18557[(10)] = inst_18463);

return statearr_18557;
})();
var statearr_18558_18630 = state_18522__$1;
(statearr_18558_18630[(2)] = null);

(statearr_18558_18630[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (41))){
var inst_18481 = (state_18522[(25)]);
var inst_18497 = (state_18522[(2)]);
var inst_18498 = cljs.core.next.call(null,inst_18481);
var inst_18462 = inst_18498;
var inst_18463 = null;
var inst_18464 = (0);
var inst_18465 = (0);
var state_18522__$1 = (function (){var statearr_18559 = state_18522;
(statearr_18559[(20)] = inst_18462);

(statearr_18559[(9)] = inst_18465);

(statearr_18559[(21)] = inst_18464);

(statearr_18559[(27)] = inst_18497);

(statearr_18559[(10)] = inst_18463);

return statearr_18559;
})();
var statearr_18560_18631 = state_18522__$1;
(statearr_18560_18631[(2)] = null);

(statearr_18560_18631[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (43))){
var state_18522__$1 = state_18522;
var statearr_18561_18632 = state_18522__$1;
(statearr_18561_18632[(2)] = null);

(statearr_18561_18632[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (29))){
var inst_18506 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18562_18633 = state_18522__$1;
(statearr_18562_18633[(2)] = inst_18506);

(statearr_18562_18633[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (44))){
var inst_18515 = (state_18522[(2)]);
var state_18522__$1 = (function (){var statearr_18563 = state_18522;
(statearr_18563[(28)] = inst_18515);

return statearr_18563;
})();
var statearr_18564_18634 = state_18522__$1;
(statearr_18564_18634[(2)] = null);

(statearr_18564_18634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (6))){
var inst_18454 = (state_18522[(29)]);
var inst_18453 = cljs.core.deref.call(null,cs);
var inst_18454__$1 = cljs.core.keys.call(null,inst_18453);
var inst_18455 = cljs.core.count.call(null,inst_18454__$1);
var inst_18456 = cljs.core.reset_BANG_.call(null,dctr,inst_18455);
var inst_18461 = cljs.core.seq.call(null,inst_18454__$1);
var inst_18462 = inst_18461;
var inst_18463 = null;
var inst_18464 = (0);
var inst_18465 = (0);
var state_18522__$1 = (function (){var statearr_18565 = state_18522;
(statearr_18565[(20)] = inst_18462);

(statearr_18565[(30)] = inst_18456);

(statearr_18565[(9)] = inst_18465);

(statearr_18565[(21)] = inst_18464);

(statearr_18565[(10)] = inst_18463);

(statearr_18565[(29)] = inst_18454__$1);

return statearr_18565;
})();
var statearr_18566_18635 = state_18522__$1;
(statearr_18566_18635[(2)] = null);

(statearr_18566_18635[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (28))){
var inst_18462 = (state_18522[(20)]);
var inst_18481 = (state_18522[(25)]);
var inst_18481__$1 = cljs.core.seq.call(null,inst_18462);
var state_18522__$1 = (function (){var statearr_18567 = state_18522;
(statearr_18567[(25)] = inst_18481__$1);

return statearr_18567;
})();
if(inst_18481__$1){
var statearr_18568_18636 = state_18522__$1;
(statearr_18568_18636[(1)] = (33));

} else {
var statearr_18569_18637 = state_18522__$1;
(statearr_18569_18637[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (25))){
var inst_18465 = (state_18522[(9)]);
var inst_18464 = (state_18522[(21)]);
var inst_18467 = (inst_18465 < inst_18464);
var inst_18468 = inst_18467;
var state_18522__$1 = state_18522;
if(cljs.core.truth_(inst_18468)){
var statearr_18570_18638 = state_18522__$1;
(statearr_18570_18638[(1)] = (27));

} else {
var statearr_18571_18639 = state_18522__$1;
(statearr_18571_18639[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (34))){
var state_18522__$1 = state_18522;
var statearr_18572_18640 = state_18522__$1;
(statearr_18572_18640[(2)] = null);

(statearr_18572_18640[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (17))){
var state_18522__$1 = state_18522;
var statearr_18573_18641 = state_18522__$1;
(statearr_18573_18641[(2)] = null);

(statearr_18573_18641[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (3))){
var inst_18520 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18522__$1,inst_18520);
} else {
if((state_val_18523 === (12))){
var inst_18449 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18574_18642 = state_18522__$1;
(statearr_18574_18642[(2)] = inst_18449);

(statearr_18574_18642[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (2))){
var state_18522__$1 = state_18522;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18522__$1,(4),ch);
} else {
if((state_val_18523 === (23))){
var state_18522__$1 = state_18522;
var statearr_18575_18643 = state_18522__$1;
(statearr_18575_18643[(2)] = null);

(statearr_18575_18643[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (35))){
var inst_18504 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18576_18644 = state_18522__$1;
(statearr_18576_18644[(2)] = inst_18504);

(statearr_18576_18644[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (19))){
var inst_18423 = (state_18522[(7)]);
var inst_18427 = cljs.core.chunk_first.call(null,inst_18423);
var inst_18428 = cljs.core.chunk_rest.call(null,inst_18423);
var inst_18429 = cljs.core.count.call(null,inst_18427);
var inst_18403 = inst_18428;
var inst_18404 = inst_18427;
var inst_18405 = inst_18429;
var inst_18406 = (0);
var state_18522__$1 = (function (){var statearr_18577 = state_18522;
(statearr_18577[(13)] = inst_18404);

(statearr_18577[(14)] = inst_18403);

(statearr_18577[(15)] = inst_18406);

(statearr_18577[(16)] = inst_18405);

return statearr_18577;
})();
var statearr_18578_18645 = state_18522__$1;
(statearr_18578_18645[(2)] = null);

(statearr_18578_18645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (11))){
var inst_18403 = (state_18522[(14)]);
var inst_18423 = (state_18522[(7)]);
var inst_18423__$1 = cljs.core.seq.call(null,inst_18403);
var state_18522__$1 = (function (){var statearr_18579 = state_18522;
(statearr_18579[(7)] = inst_18423__$1);

return statearr_18579;
})();
if(inst_18423__$1){
var statearr_18580_18646 = state_18522__$1;
(statearr_18580_18646[(1)] = (16));

} else {
var statearr_18581_18647 = state_18522__$1;
(statearr_18581_18647[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (9))){
var inst_18451 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18582_18648 = state_18522__$1;
(statearr_18582_18648[(2)] = inst_18451);

(statearr_18582_18648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (5))){
var inst_18401 = cljs.core.deref.call(null,cs);
var inst_18402 = cljs.core.seq.call(null,inst_18401);
var inst_18403 = inst_18402;
var inst_18404 = null;
var inst_18405 = (0);
var inst_18406 = (0);
var state_18522__$1 = (function (){var statearr_18583 = state_18522;
(statearr_18583[(13)] = inst_18404);

(statearr_18583[(14)] = inst_18403);

(statearr_18583[(15)] = inst_18406);

(statearr_18583[(16)] = inst_18405);

return statearr_18583;
})();
var statearr_18584_18649 = state_18522__$1;
(statearr_18584_18649[(2)] = null);

(statearr_18584_18649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (14))){
var state_18522__$1 = state_18522;
var statearr_18585_18650 = state_18522__$1;
(statearr_18585_18650[(2)] = null);

(statearr_18585_18650[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (45))){
var inst_18512 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18586_18651 = state_18522__$1;
(statearr_18586_18651[(2)] = inst_18512);

(statearr_18586_18651[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (26))){
var inst_18454 = (state_18522[(29)]);
var inst_18508 = (state_18522[(2)]);
var inst_18509 = cljs.core.seq.call(null,inst_18454);
var state_18522__$1 = (function (){var statearr_18587 = state_18522;
(statearr_18587[(31)] = inst_18508);

return statearr_18587;
})();
if(inst_18509){
var statearr_18588_18652 = state_18522__$1;
(statearr_18588_18652[(1)] = (42));

} else {
var statearr_18589_18653 = state_18522__$1;
(statearr_18589_18653[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (16))){
var inst_18423 = (state_18522[(7)]);
var inst_18425 = cljs.core.chunked_seq_QMARK_.call(null,inst_18423);
var state_18522__$1 = state_18522;
if(inst_18425){
var statearr_18590_18654 = state_18522__$1;
(statearr_18590_18654[(1)] = (19));

} else {
var statearr_18591_18655 = state_18522__$1;
(statearr_18591_18655[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (38))){
var inst_18501 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18592_18656 = state_18522__$1;
(statearr_18592_18656[(2)] = inst_18501);

(statearr_18592_18656[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (30))){
var state_18522__$1 = state_18522;
var statearr_18593_18657 = state_18522__$1;
(statearr_18593_18657[(2)] = null);

(statearr_18593_18657[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (10))){
var inst_18404 = (state_18522[(13)]);
var inst_18406 = (state_18522[(15)]);
var inst_18412 = cljs.core._nth.call(null,inst_18404,inst_18406);
var inst_18413 = cljs.core.nth.call(null,inst_18412,(0),null);
var inst_18414 = cljs.core.nth.call(null,inst_18412,(1),null);
var state_18522__$1 = (function (){var statearr_18594 = state_18522;
(statearr_18594[(26)] = inst_18413);

return statearr_18594;
})();
if(cljs.core.truth_(inst_18414)){
var statearr_18595_18658 = state_18522__$1;
(statearr_18595_18658[(1)] = (13));

} else {
var statearr_18596_18659 = state_18522__$1;
(statearr_18596_18659[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (18))){
var inst_18447 = (state_18522[(2)]);
var state_18522__$1 = state_18522;
var statearr_18597_18660 = state_18522__$1;
(statearr_18597_18660[(2)] = inst_18447);

(statearr_18597_18660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (42))){
var state_18522__$1 = state_18522;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18522__$1,(45),dchan);
} else {
if((state_val_18523 === (37))){
var inst_18481 = (state_18522[(25)]);
var inst_18490 = (state_18522[(23)]);
var inst_18394 = (state_18522[(12)]);
var inst_18490__$1 = cljs.core.first.call(null,inst_18481);
var inst_18491 = cljs.core.async.put_BANG_.call(null,inst_18490__$1,inst_18394,done);
var state_18522__$1 = (function (){var statearr_18598 = state_18522;
(statearr_18598[(23)] = inst_18490__$1);

return statearr_18598;
})();
if(cljs.core.truth_(inst_18491)){
var statearr_18599_18661 = state_18522__$1;
(statearr_18599_18661[(1)] = (39));

} else {
var statearr_18600_18662 = state_18522__$1;
(statearr_18600_18662[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18523 === (8))){
var inst_18406 = (state_18522[(15)]);
var inst_18405 = (state_18522[(16)]);
var inst_18408 = (inst_18406 < inst_18405);
var inst_18409 = inst_18408;
var state_18522__$1 = state_18522;
if(cljs.core.truth_(inst_18409)){
var statearr_18601_18663 = state_18522__$1;
(statearr_18601_18663[(1)] = (10));

} else {
var statearr_18602_18664 = state_18522__$1;
(statearr_18602_18664[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18610,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18610,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18606 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18606[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18606[(1)] = (1));

return statearr_18606;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18522){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18522);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18607){if((e18607 instanceof Object)){
var ex__8254__auto__ = e18607;
var statearr_18608_18665 = state_18522;
(statearr_18608_18665[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18522);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18607;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18666 = state_18522;
state_18522 = G__18666;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18522){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18610,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18609 = f__8363__auto__.call(null);
(statearr_18609[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18610);

return statearr_18609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18610,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18667 = [];
var len__5726__auto___18670 = arguments.length;
var i__5727__auto___18671 = (0);
while(true){
if((i__5727__auto___18671 < len__5726__auto___18670)){
args18667.push((arguments[i__5727__auto___18671]));

var G__18672 = (i__5727__auto___18671 + (1));
i__5727__auto___18671 = G__18672;
continue;
} else {
}
break;
}

var G__18669 = args18667.length;
switch (G__18669) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18667.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18684 = arguments.length;
var i__5727__auto___18685 = (0);
while(true){
if((i__5727__auto___18685 < len__5726__auto___18684)){
args__5733__auto__.push((arguments[i__5727__auto___18685]));

var G__18686 = (i__5727__auto___18685 + (1));
i__5727__auto___18685 = G__18686;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18678){
var map__18679 = p__18678;
var map__18679__$1 = ((((!((map__18679 == null)))?((((map__18679.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18679.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18679):map__18679);
var opts = map__18679__$1;
var statearr_18681_18687 = state;
(statearr_18681_18687[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18679,map__18679__$1,opts){
return (function (val){
var statearr_18682_18688 = state;
(statearr_18682_18688[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18679,map__18679__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18683_18689 = state;
(statearr_18683_18689[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18674){
var G__18675 = cljs.core.first.call(null,seq18674);
var seq18674__$1 = cljs.core.next.call(null,seq18674);
var G__18676 = cljs.core.first.call(null,seq18674__$1);
var seq18674__$2 = cljs.core.next.call(null,seq18674__$1);
var G__18677 = cljs.core.first.call(null,seq18674__$2);
var seq18674__$3 = cljs.core.next.call(null,seq18674__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18675,G__18676,G__18677,seq18674__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18853 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18853 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18854){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18854 = meta18854;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18855,meta18854__$1){
var self__ = this;
var _18855__$1 = this;
return (new cljs.core.async.t_cljs$core$async18853(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18854__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18855){
var self__ = this;
var _18855__$1 = this;
return self__.meta18854;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18854","meta18854",1433560378,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18853.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18853.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18853";

cljs.core.async.t_cljs$core$async18853.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18853");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18853 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18853(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18854){
return (new cljs.core.async.t_cljs$core$async18853(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18854));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18853(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19016 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19016,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19016,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18953){
var state_val_18954 = (state_18953[(1)]);
if((state_val_18954 === (7))){
var inst_18871 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
var statearr_18955_19017 = state_18953__$1;
(statearr_18955_19017[(2)] = inst_18871);

(statearr_18955_19017[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (20))){
var inst_18883 = (state_18953[(7)]);
var state_18953__$1 = state_18953;
var statearr_18956_19018 = state_18953__$1;
(statearr_18956_19018[(2)] = inst_18883);

(statearr_18956_19018[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (27))){
var state_18953__$1 = state_18953;
var statearr_18957_19019 = state_18953__$1;
(statearr_18957_19019[(2)] = null);

(statearr_18957_19019[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (1))){
var inst_18859 = (state_18953[(8)]);
var inst_18859__$1 = calc_state.call(null);
var inst_18861 = (inst_18859__$1 == null);
var inst_18862 = cljs.core.not.call(null,inst_18861);
var state_18953__$1 = (function (){var statearr_18958 = state_18953;
(statearr_18958[(8)] = inst_18859__$1);

return statearr_18958;
})();
if(inst_18862){
var statearr_18959_19020 = state_18953__$1;
(statearr_18959_19020[(1)] = (2));

} else {
var statearr_18960_19021 = state_18953__$1;
(statearr_18960_19021[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (24))){
var inst_18906 = (state_18953[(9)]);
var inst_18913 = (state_18953[(10)]);
var inst_18927 = (state_18953[(11)]);
var inst_18927__$1 = inst_18906.call(null,inst_18913);
var state_18953__$1 = (function (){var statearr_18961 = state_18953;
(statearr_18961[(11)] = inst_18927__$1);

return statearr_18961;
})();
if(cljs.core.truth_(inst_18927__$1)){
var statearr_18962_19022 = state_18953__$1;
(statearr_18962_19022[(1)] = (29));

} else {
var statearr_18963_19023 = state_18953__$1;
(statearr_18963_19023[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (4))){
var inst_18874 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
if(cljs.core.truth_(inst_18874)){
var statearr_18964_19024 = state_18953__$1;
(statearr_18964_19024[(1)] = (8));

} else {
var statearr_18965_19025 = state_18953__$1;
(statearr_18965_19025[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (15))){
var inst_18900 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
if(cljs.core.truth_(inst_18900)){
var statearr_18966_19026 = state_18953__$1;
(statearr_18966_19026[(1)] = (19));

} else {
var statearr_18967_19027 = state_18953__$1;
(statearr_18967_19027[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (21))){
var inst_18905 = (state_18953[(12)]);
var inst_18905__$1 = (state_18953[(2)]);
var inst_18906 = cljs.core.get.call(null,inst_18905__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18907 = cljs.core.get.call(null,inst_18905__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18908 = cljs.core.get.call(null,inst_18905__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18953__$1 = (function (){var statearr_18968 = state_18953;
(statearr_18968[(9)] = inst_18906);

(statearr_18968[(12)] = inst_18905__$1);

(statearr_18968[(13)] = inst_18907);

return statearr_18968;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18953__$1,(22),inst_18908);
} else {
if((state_val_18954 === (31))){
var inst_18935 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
if(cljs.core.truth_(inst_18935)){
var statearr_18969_19028 = state_18953__$1;
(statearr_18969_19028[(1)] = (32));

} else {
var statearr_18970_19029 = state_18953__$1;
(statearr_18970_19029[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (32))){
var inst_18912 = (state_18953[(14)]);
var state_18953__$1 = state_18953;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18953__$1,(35),out,inst_18912);
} else {
if((state_val_18954 === (33))){
var inst_18905 = (state_18953[(12)]);
var inst_18883 = inst_18905;
var state_18953__$1 = (function (){var statearr_18971 = state_18953;
(statearr_18971[(7)] = inst_18883);

return statearr_18971;
})();
var statearr_18972_19030 = state_18953__$1;
(statearr_18972_19030[(2)] = null);

(statearr_18972_19030[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (13))){
var inst_18883 = (state_18953[(7)]);
var inst_18890 = inst_18883.cljs$lang$protocol_mask$partition0$;
var inst_18891 = (inst_18890 & (64));
var inst_18892 = inst_18883.cljs$core$ISeq$;
var inst_18893 = (inst_18891) || (inst_18892);
var state_18953__$1 = state_18953;
if(cljs.core.truth_(inst_18893)){
var statearr_18973_19031 = state_18953__$1;
(statearr_18973_19031[(1)] = (16));

} else {
var statearr_18974_19032 = state_18953__$1;
(statearr_18974_19032[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (22))){
var inst_18913 = (state_18953[(10)]);
var inst_18912 = (state_18953[(14)]);
var inst_18911 = (state_18953[(2)]);
var inst_18912__$1 = cljs.core.nth.call(null,inst_18911,(0),null);
var inst_18913__$1 = cljs.core.nth.call(null,inst_18911,(1),null);
var inst_18914 = (inst_18912__$1 == null);
var inst_18915 = cljs.core._EQ_.call(null,inst_18913__$1,change);
var inst_18916 = (inst_18914) || (inst_18915);
var state_18953__$1 = (function (){var statearr_18975 = state_18953;
(statearr_18975[(10)] = inst_18913__$1);

(statearr_18975[(14)] = inst_18912__$1);

return statearr_18975;
})();
if(cljs.core.truth_(inst_18916)){
var statearr_18976_19033 = state_18953__$1;
(statearr_18976_19033[(1)] = (23));

} else {
var statearr_18977_19034 = state_18953__$1;
(statearr_18977_19034[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (36))){
var inst_18905 = (state_18953[(12)]);
var inst_18883 = inst_18905;
var state_18953__$1 = (function (){var statearr_18978 = state_18953;
(statearr_18978[(7)] = inst_18883);

return statearr_18978;
})();
var statearr_18979_19035 = state_18953__$1;
(statearr_18979_19035[(2)] = null);

(statearr_18979_19035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (29))){
var inst_18927 = (state_18953[(11)]);
var state_18953__$1 = state_18953;
var statearr_18980_19036 = state_18953__$1;
(statearr_18980_19036[(2)] = inst_18927);

(statearr_18980_19036[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (6))){
var state_18953__$1 = state_18953;
var statearr_18981_19037 = state_18953__$1;
(statearr_18981_19037[(2)] = false);

(statearr_18981_19037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (28))){
var inst_18923 = (state_18953[(2)]);
var inst_18924 = calc_state.call(null);
var inst_18883 = inst_18924;
var state_18953__$1 = (function (){var statearr_18982 = state_18953;
(statearr_18982[(7)] = inst_18883);

(statearr_18982[(15)] = inst_18923);

return statearr_18982;
})();
var statearr_18983_19038 = state_18953__$1;
(statearr_18983_19038[(2)] = null);

(statearr_18983_19038[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (25))){
var inst_18949 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
var statearr_18984_19039 = state_18953__$1;
(statearr_18984_19039[(2)] = inst_18949);

(statearr_18984_19039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (34))){
var inst_18947 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
var statearr_18985_19040 = state_18953__$1;
(statearr_18985_19040[(2)] = inst_18947);

(statearr_18985_19040[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (17))){
var state_18953__$1 = state_18953;
var statearr_18986_19041 = state_18953__$1;
(statearr_18986_19041[(2)] = false);

(statearr_18986_19041[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (3))){
var state_18953__$1 = state_18953;
var statearr_18987_19042 = state_18953__$1;
(statearr_18987_19042[(2)] = false);

(statearr_18987_19042[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (12))){
var inst_18951 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18953__$1,inst_18951);
} else {
if((state_val_18954 === (2))){
var inst_18859 = (state_18953[(8)]);
var inst_18864 = inst_18859.cljs$lang$protocol_mask$partition0$;
var inst_18865 = (inst_18864 & (64));
var inst_18866 = inst_18859.cljs$core$ISeq$;
var inst_18867 = (inst_18865) || (inst_18866);
var state_18953__$1 = state_18953;
if(cljs.core.truth_(inst_18867)){
var statearr_18988_19043 = state_18953__$1;
(statearr_18988_19043[(1)] = (5));

} else {
var statearr_18989_19044 = state_18953__$1;
(statearr_18989_19044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (23))){
var inst_18912 = (state_18953[(14)]);
var inst_18918 = (inst_18912 == null);
var state_18953__$1 = state_18953;
if(cljs.core.truth_(inst_18918)){
var statearr_18990_19045 = state_18953__$1;
(statearr_18990_19045[(1)] = (26));

} else {
var statearr_18991_19046 = state_18953__$1;
(statearr_18991_19046[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (35))){
var inst_18938 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
if(cljs.core.truth_(inst_18938)){
var statearr_18992_19047 = state_18953__$1;
(statearr_18992_19047[(1)] = (36));

} else {
var statearr_18993_19048 = state_18953__$1;
(statearr_18993_19048[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (19))){
var inst_18883 = (state_18953[(7)]);
var inst_18902 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18883);
var state_18953__$1 = state_18953;
var statearr_18994_19049 = state_18953__$1;
(statearr_18994_19049[(2)] = inst_18902);

(statearr_18994_19049[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (11))){
var inst_18883 = (state_18953[(7)]);
var inst_18887 = (inst_18883 == null);
var inst_18888 = cljs.core.not.call(null,inst_18887);
var state_18953__$1 = state_18953;
if(inst_18888){
var statearr_18995_19050 = state_18953__$1;
(statearr_18995_19050[(1)] = (13));

} else {
var statearr_18996_19051 = state_18953__$1;
(statearr_18996_19051[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (9))){
var inst_18859 = (state_18953[(8)]);
var state_18953__$1 = state_18953;
var statearr_18997_19052 = state_18953__$1;
(statearr_18997_19052[(2)] = inst_18859);

(statearr_18997_19052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (5))){
var state_18953__$1 = state_18953;
var statearr_18998_19053 = state_18953__$1;
(statearr_18998_19053[(2)] = true);

(statearr_18998_19053[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (14))){
var state_18953__$1 = state_18953;
var statearr_18999_19054 = state_18953__$1;
(statearr_18999_19054[(2)] = false);

(statearr_18999_19054[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (26))){
var inst_18913 = (state_18953[(10)]);
var inst_18920 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18913);
var state_18953__$1 = state_18953;
var statearr_19000_19055 = state_18953__$1;
(statearr_19000_19055[(2)] = inst_18920);

(statearr_19000_19055[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (16))){
var state_18953__$1 = state_18953;
var statearr_19001_19056 = state_18953__$1;
(statearr_19001_19056[(2)] = true);

(statearr_19001_19056[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (38))){
var inst_18943 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
var statearr_19002_19057 = state_18953__$1;
(statearr_19002_19057[(2)] = inst_18943);

(statearr_19002_19057[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (30))){
var inst_18906 = (state_18953[(9)]);
var inst_18913 = (state_18953[(10)]);
var inst_18907 = (state_18953[(13)]);
var inst_18930 = cljs.core.empty_QMARK_.call(null,inst_18906);
var inst_18931 = inst_18907.call(null,inst_18913);
var inst_18932 = cljs.core.not.call(null,inst_18931);
var inst_18933 = (inst_18930) && (inst_18932);
var state_18953__$1 = state_18953;
var statearr_19003_19058 = state_18953__$1;
(statearr_19003_19058[(2)] = inst_18933);

(statearr_19003_19058[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (10))){
var inst_18859 = (state_18953[(8)]);
var inst_18879 = (state_18953[(2)]);
var inst_18880 = cljs.core.get.call(null,inst_18879,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18881 = cljs.core.get.call(null,inst_18879,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18882 = cljs.core.get.call(null,inst_18879,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18883 = inst_18859;
var state_18953__$1 = (function (){var statearr_19004 = state_18953;
(statearr_19004[(7)] = inst_18883);

(statearr_19004[(16)] = inst_18882);

(statearr_19004[(17)] = inst_18880);

(statearr_19004[(18)] = inst_18881);

return statearr_19004;
})();
var statearr_19005_19059 = state_18953__$1;
(statearr_19005_19059[(2)] = null);

(statearr_19005_19059[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (18))){
var inst_18897 = (state_18953[(2)]);
var state_18953__$1 = state_18953;
var statearr_19006_19060 = state_18953__$1;
(statearr_19006_19060[(2)] = inst_18897);

(statearr_19006_19060[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (37))){
var state_18953__$1 = state_18953;
var statearr_19007_19061 = state_18953__$1;
(statearr_19007_19061[(2)] = null);

(statearr_19007_19061[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18954 === (8))){
var inst_18859 = (state_18953[(8)]);
var inst_18876 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18859);
var state_18953__$1 = state_18953;
var statearr_19008_19062 = state_18953__$1;
(statearr_19008_19062[(2)] = inst_18876);

(statearr_19008_19062[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19016,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___19016,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_19012 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19012[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_19012[(1)] = (1));

return statearr_19012;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18953){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19013){if((e19013 instanceof Object)){
var ex__8254__auto__ = e19013;
var statearr_19014_19063 = state_18953;
(statearr_19014_19063[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18953);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19064 = state_18953;
state_18953 = G__19064;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18953){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19016,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_19015 = f__8363__auto__.call(null);
(statearr_19015[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19016);

return statearr_19015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19016,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19065 = [];
var len__5726__auto___19068 = arguments.length;
var i__5727__auto___19069 = (0);
while(true){
if((i__5727__auto___19069 < len__5726__auto___19068)){
args19065.push((arguments[i__5727__auto___19069]));

var G__19070 = (i__5727__auto___19069 + (1));
i__5727__auto___19069 = G__19070;
continue;
} else {
}
break;
}

var G__19067 = args19065.length;
switch (G__19067) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19065.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19073 = [];
var len__5726__auto___19198 = arguments.length;
var i__5727__auto___19199 = (0);
while(true){
if((i__5727__auto___19199 < len__5726__auto___19198)){
args19073.push((arguments[i__5727__auto___19199]));

var G__19200 = (i__5727__auto___19199 + (1));
i__5727__auto___19199 = G__19200;
continue;
} else {
}
break;
}

var G__19075 = args19073.length;
switch (G__19075) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19073.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19072_SHARP_){
if(cljs.core.truth_(p1__19072_SHARP_.call(null,topic))){
return p1__19072_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19072_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19076 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19076 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19077){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19077 = meta19077;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19078,meta19077__$1){
var self__ = this;
var _19078__$1 = this;
return (new cljs.core.async.t_cljs$core$async19076(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19077__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19078){
var self__ = this;
var _19078__$1 = this;
return self__.meta19077;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19076.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19076.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19077","meta19077",-1303610983,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19076.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19076.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19076";

cljs.core.async.t_cljs$core$async19076.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19076");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19076 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19076(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19077){
return (new cljs.core.async.t_cljs$core$async19076(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19077));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19076(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19202 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19202,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19202,mults,ensure_mult,p){
return (function (state_19150){
var state_val_19151 = (state_19150[(1)]);
if((state_val_19151 === (7))){
var inst_19146 = (state_19150[(2)]);
var state_19150__$1 = state_19150;
var statearr_19152_19203 = state_19150__$1;
(statearr_19152_19203[(2)] = inst_19146);

(statearr_19152_19203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (20))){
var state_19150__$1 = state_19150;
var statearr_19153_19204 = state_19150__$1;
(statearr_19153_19204[(2)] = null);

(statearr_19153_19204[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (1))){
var state_19150__$1 = state_19150;
var statearr_19154_19205 = state_19150__$1;
(statearr_19154_19205[(2)] = null);

(statearr_19154_19205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (24))){
var inst_19129 = (state_19150[(7)]);
var inst_19138 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19129);
var state_19150__$1 = state_19150;
var statearr_19155_19206 = state_19150__$1;
(statearr_19155_19206[(2)] = inst_19138);

(statearr_19155_19206[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (4))){
var inst_19081 = (state_19150[(8)]);
var inst_19081__$1 = (state_19150[(2)]);
var inst_19082 = (inst_19081__$1 == null);
var state_19150__$1 = (function (){var statearr_19156 = state_19150;
(statearr_19156[(8)] = inst_19081__$1);

return statearr_19156;
})();
if(cljs.core.truth_(inst_19082)){
var statearr_19157_19207 = state_19150__$1;
(statearr_19157_19207[(1)] = (5));

} else {
var statearr_19158_19208 = state_19150__$1;
(statearr_19158_19208[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (15))){
var inst_19123 = (state_19150[(2)]);
var state_19150__$1 = state_19150;
var statearr_19159_19209 = state_19150__$1;
(statearr_19159_19209[(2)] = inst_19123);

(statearr_19159_19209[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (21))){
var inst_19143 = (state_19150[(2)]);
var state_19150__$1 = (function (){var statearr_19160 = state_19150;
(statearr_19160[(9)] = inst_19143);

return statearr_19160;
})();
var statearr_19161_19210 = state_19150__$1;
(statearr_19161_19210[(2)] = null);

(statearr_19161_19210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (13))){
var inst_19105 = (state_19150[(10)]);
var inst_19107 = cljs.core.chunked_seq_QMARK_.call(null,inst_19105);
var state_19150__$1 = state_19150;
if(inst_19107){
var statearr_19162_19211 = state_19150__$1;
(statearr_19162_19211[(1)] = (16));

} else {
var statearr_19163_19212 = state_19150__$1;
(statearr_19163_19212[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (22))){
var inst_19135 = (state_19150[(2)]);
var state_19150__$1 = state_19150;
if(cljs.core.truth_(inst_19135)){
var statearr_19164_19213 = state_19150__$1;
(statearr_19164_19213[(1)] = (23));

} else {
var statearr_19165_19214 = state_19150__$1;
(statearr_19165_19214[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (6))){
var inst_19129 = (state_19150[(7)]);
var inst_19081 = (state_19150[(8)]);
var inst_19131 = (state_19150[(11)]);
var inst_19129__$1 = topic_fn.call(null,inst_19081);
var inst_19130 = cljs.core.deref.call(null,mults);
var inst_19131__$1 = cljs.core.get.call(null,inst_19130,inst_19129__$1);
var state_19150__$1 = (function (){var statearr_19166 = state_19150;
(statearr_19166[(7)] = inst_19129__$1);

(statearr_19166[(11)] = inst_19131__$1);

return statearr_19166;
})();
if(cljs.core.truth_(inst_19131__$1)){
var statearr_19167_19215 = state_19150__$1;
(statearr_19167_19215[(1)] = (19));

} else {
var statearr_19168_19216 = state_19150__$1;
(statearr_19168_19216[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (25))){
var inst_19140 = (state_19150[(2)]);
var state_19150__$1 = state_19150;
var statearr_19169_19217 = state_19150__$1;
(statearr_19169_19217[(2)] = inst_19140);

(statearr_19169_19217[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (17))){
var inst_19105 = (state_19150[(10)]);
var inst_19114 = cljs.core.first.call(null,inst_19105);
var inst_19115 = cljs.core.async.muxch_STAR_.call(null,inst_19114);
var inst_19116 = cljs.core.async.close_BANG_.call(null,inst_19115);
var inst_19117 = cljs.core.next.call(null,inst_19105);
var inst_19091 = inst_19117;
var inst_19092 = null;
var inst_19093 = (0);
var inst_19094 = (0);
var state_19150__$1 = (function (){var statearr_19170 = state_19150;
(statearr_19170[(12)] = inst_19091);

(statearr_19170[(13)] = inst_19092);

(statearr_19170[(14)] = inst_19093);

(statearr_19170[(15)] = inst_19094);

(statearr_19170[(16)] = inst_19116);

return statearr_19170;
})();
var statearr_19171_19218 = state_19150__$1;
(statearr_19171_19218[(2)] = null);

(statearr_19171_19218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (3))){
var inst_19148 = (state_19150[(2)]);
var state_19150__$1 = state_19150;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19150__$1,inst_19148);
} else {
if((state_val_19151 === (12))){
var inst_19125 = (state_19150[(2)]);
var state_19150__$1 = state_19150;
var statearr_19172_19219 = state_19150__$1;
(statearr_19172_19219[(2)] = inst_19125);

(statearr_19172_19219[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (2))){
var state_19150__$1 = state_19150;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19150__$1,(4),ch);
} else {
if((state_val_19151 === (23))){
var state_19150__$1 = state_19150;
var statearr_19173_19220 = state_19150__$1;
(statearr_19173_19220[(2)] = null);

(statearr_19173_19220[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (19))){
var inst_19081 = (state_19150[(8)]);
var inst_19131 = (state_19150[(11)]);
var inst_19133 = cljs.core.async.muxch_STAR_.call(null,inst_19131);
var state_19150__$1 = state_19150;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19150__$1,(22),inst_19133,inst_19081);
} else {
if((state_val_19151 === (11))){
var inst_19091 = (state_19150[(12)]);
var inst_19105 = (state_19150[(10)]);
var inst_19105__$1 = cljs.core.seq.call(null,inst_19091);
var state_19150__$1 = (function (){var statearr_19174 = state_19150;
(statearr_19174[(10)] = inst_19105__$1);

return statearr_19174;
})();
if(inst_19105__$1){
var statearr_19175_19221 = state_19150__$1;
(statearr_19175_19221[(1)] = (13));

} else {
var statearr_19176_19222 = state_19150__$1;
(statearr_19176_19222[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (9))){
var inst_19127 = (state_19150[(2)]);
var state_19150__$1 = state_19150;
var statearr_19177_19223 = state_19150__$1;
(statearr_19177_19223[(2)] = inst_19127);

(statearr_19177_19223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (5))){
var inst_19088 = cljs.core.deref.call(null,mults);
var inst_19089 = cljs.core.vals.call(null,inst_19088);
var inst_19090 = cljs.core.seq.call(null,inst_19089);
var inst_19091 = inst_19090;
var inst_19092 = null;
var inst_19093 = (0);
var inst_19094 = (0);
var state_19150__$1 = (function (){var statearr_19178 = state_19150;
(statearr_19178[(12)] = inst_19091);

(statearr_19178[(13)] = inst_19092);

(statearr_19178[(14)] = inst_19093);

(statearr_19178[(15)] = inst_19094);

return statearr_19178;
})();
var statearr_19179_19224 = state_19150__$1;
(statearr_19179_19224[(2)] = null);

(statearr_19179_19224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (14))){
var state_19150__$1 = state_19150;
var statearr_19183_19225 = state_19150__$1;
(statearr_19183_19225[(2)] = null);

(statearr_19183_19225[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (16))){
var inst_19105 = (state_19150[(10)]);
var inst_19109 = cljs.core.chunk_first.call(null,inst_19105);
var inst_19110 = cljs.core.chunk_rest.call(null,inst_19105);
var inst_19111 = cljs.core.count.call(null,inst_19109);
var inst_19091 = inst_19110;
var inst_19092 = inst_19109;
var inst_19093 = inst_19111;
var inst_19094 = (0);
var state_19150__$1 = (function (){var statearr_19184 = state_19150;
(statearr_19184[(12)] = inst_19091);

(statearr_19184[(13)] = inst_19092);

(statearr_19184[(14)] = inst_19093);

(statearr_19184[(15)] = inst_19094);

return statearr_19184;
})();
var statearr_19185_19226 = state_19150__$1;
(statearr_19185_19226[(2)] = null);

(statearr_19185_19226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (10))){
var inst_19091 = (state_19150[(12)]);
var inst_19092 = (state_19150[(13)]);
var inst_19093 = (state_19150[(14)]);
var inst_19094 = (state_19150[(15)]);
var inst_19099 = cljs.core._nth.call(null,inst_19092,inst_19094);
var inst_19100 = cljs.core.async.muxch_STAR_.call(null,inst_19099);
var inst_19101 = cljs.core.async.close_BANG_.call(null,inst_19100);
var inst_19102 = (inst_19094 + (1));
var tmp19180 = inst_19091;
var tmp19181 = inst_19092;
var tmp19182 = inst_19093;
var inst_19091__$1 = tmp19180;
var inst_19092__$1 = tmp19181;
var inst_19093__$1 = tmp19182;
var inst_19094__$1 = inst_19102;
var state_19150__$1 = (function (){var statearr_19186 = state_19150;
(statearr_19186[(12)] = inst_19091__$1);

(statearr_19186[(13)] = inst_19092__$1);

(statearr_19186[(14)] = inst_19093__$1);

(statearr_19186[(15)] = inst_19094__$1);

(statearr_19186[(17)] = inst_19101);

return statearr_19186;
})();
var statearr_19187_19227 = state_19150__$1;
(statearr_19187_19227[(2)] = null);

(statearr_19187_19227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (18))){
var inst_19120 = (state_19150[(2)]);
var state_19150__$1 = state_19150;
var statearr_19188_19228 = state_19150__$1;
(statearr_19188_19228[(2)] = inst_19120);

(statearr_19188_19228[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19151 === (8))){
var inst_19093 = (state_19150[(14)]);
var inst_19094 = (state_19150[(15)]);
var inst_19096 = (inst_19094 < inst_19093);
var inst_19097 = inst_19096;
var state_19150__$1 = state_19150;
if(cljs.core.truth_(inst_19097)){
var statearr_19189_19229 = state_19150__$1;
(statearr_19189_19229[(1)] = (10));

} else {
var statearr_19190_19230 = state_19150__$1;
(statearr_19190_19230[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19202,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19202,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19194[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19194[(1)] = (1));

return statearr_19194;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19150){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19150);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19195){if((e19195 instanceof Object)){
var ex__8254__auto__ = e19195;
var statearr_19196_19231 = state_19150;
(statearr_19196_19231[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19150);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19195;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19232 = state_19150;
state_19150 = G__19232;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19150){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19202,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19197 = f__8363__auto__.call(null);
(statearr_19197[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19202);

return statearr_19197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19202,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19233 = [];
var len__5726__auto___19236 = arguments.length;
var i__5727__auto___19237 = (0);
while(true){
if((i__5727__auto___19237 < len__5726__auto___19236)){
args19233.push((arguments[i__5727__auto___19237]));

var G__19238 = (i__5727__auto___19237 + (1));
i__5727__auto___19237 = G__19238;
continue;
} else {
}
break;
}

var G__19235 = args19233.length;
switch (G__19235) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19233.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19240 = [];
var len__5726__auto___19243 = arguments.length;
var i__5727__auto___19244 = (0);
while(true){
if((i__5727__auto___19244 < len__5726__auto___19243)){
args19240.push((arguments[i__5727__auto___19244]));

var G__19245 = (i__5727__auto___19244 + (1));
i__5727__auto___19244 = G__19245;
continue;
} else {
}
break;
}

var G__19242 = args19240.length;
switch (G__19242) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19240.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19247 = [];
var len__5726__auto___19318 = arguments.length;
var i__5727__auto___19319 = (0);
while(true){
if((i__5727__auto___19319 < len__5726__auto___19318)){
args19247.push((arguments[i__5727__auto___19319]));

var G__19320 = (i__5727__auto___19319 + (1));
i__5727__auto___19319 = G__19320;
continue;
} else {
}
break;
}

var G__19249 = args19247.length;
switch (G__19249) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19247.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19322 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19322,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19322,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19288){
var state_val_19289 = (state_19288[(1)]);
if((state_val_19289 === (7))){
var state_19288__$1 = state_19288;
var statearr_19290_19323 = state_19288__$1;
(statearr_19290_19323[(2)] = null);

(statearr_19290_19323[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (1))){
var state_19288__$1 = state_19288;
var statearr_19291_19324 = state_19288__$1;
(statearr_19291_19324[(2)] = null);

(statearr_19291_19324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (4))){
var inst_19252 = (state_19288[(7)]);
var inst_19254 = (inst_19252 < cnt);
var state_19288__$1 = state_19288;
if(cljs.core.truth_(inst_19254)){
var statearr_19292_19325 = state_19288__$1;
(statearr_19292_19325[(1)] = (6));

} else {
var statearr_19293_19326 = state_19288__$1;
(statearr_19293_19326[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (15))){
var inst_19284 = (state_19288[(2)]);
var state_19288__$1 = state_19288;
var statearr_19294_19327 = state_19288__$1;
(statearr_19294_19327[(2)] = inst_19284);

(statearr_19294_19327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (13))){
var inst_19277 = cljs.core.async.close_BANG_.call(null,out);
var state_19288__$1 = state_19288;
var statearr_19295_19328 = state_19288__$1;
(statearr_19295_19328[(2)] = inst_19277);

(statearr_19295_19328[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (6))){
var state_19288__$1 = state_19288;
var statearr_19296_19329 = state_19288__$1;
(statearr_19296_19329[(2)] = null);

(statearr_19296_19329[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (3))){
var inst_19286 = (state_19288[(2)]);
var state_19288__$1 = state_19288;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19288__$1,inst_19286);
} else {
if((state_val_19289 === (12))){
var inst_19274 = (state_19288[(8)]);
var inst_19274__$1 = (state_19288[(2)]);
var inst_19275 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19274__$1);
var state_19288__$1 = (function (){var statearr_19297 = state_19288;
(statearr_19297[(8)] = inst_19274__$1);

return statearr_19297;
})();
if(cljs.core.truth_(inst_19275)){
var statearr_19298_19330 = state_19288__$1;
(statearr_19298_19330[(1)] = (13));

} else {
var statearr_19299_19331 = state_19288__$1;
(statearr_19299_19331[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (2))){
var inst_19251 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19252 = (0);
var state_19288__$1 = (function (){var statearr_19300 = state_19288;
(statearr_19300[(7)] = inst_19252);

(statearr_19300[(9)] = inst_19251);

return statearr_19300;
})();
var statearr_19301_19332 = state_19288__$1;
(statearr_19301_19332[(2)] = null);

(statearr_19301_19332[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (11))){
var inst_19252 = (state_19288[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19288,(10),Object,null,(9));
var inst_19261 = chs__$1.call(null,inst_19252);
var inst_19262 = done.call(null,inst_19252);
var inst_19263 = cljs.core.async.take_BANG_.call(null,inst_19261,inst_19262);
var state_19288__$1 = state_19288;
var statearr_19302_19333 = state_19288__$1;
(statearr_19302_19333[(2)] = inst_19263);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19288__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (9))){
var inst_19252 = (state_19288[(7)]);
var inst_19265 = (state_19288[(2)]);
var inst_19266 = (inst_19252 + (1));
var inst_19252__$1 = inst_19266;
var state_19288__$1 = (function (){var statearr_19303 = state_19288;
(statearr_19303[(7)] = inst_19252__$1);

(statearr_19303[(10)] = inst_19265);

return statearr_19303;
})();
var statearr_19304_19334 = state_19288__$1;
(statearr_19304_19334[(2)] = null);

(statearr_19304_19334[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (5))){
var inst_19272 = (state_19288[(2)]);
var state_19288__$1 = (function (){var statearr_19305 = state_19288;
(statearr_19305[(11)] = inst_19272);

return statearr_19305;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19288__$1,(12),dchan);
} else {
if((state_val_19289 === (14))){
var inst_19274 = (state_19288[(8)]);
var inst_19279 = cljs.core.apply.call(null,f,inst_19274);
var state_19288__$1 = state_19288;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19288__$1,(16),out,inst_19279);
} else {
if((state_val_19289 === (16))){
var inst_19281 = (state_19288[(2)]);
var state_19288__$1 = (function (){var statearr_19306 = state_19288;
(statearr_19306[(12)] = inst_19281);

return statearr_19306;
})();
var statearr_19307_19335 = state_19288__$1;
(statearr_19307_19335[(2)] = null);

(statearr_19307_19335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (10))){
var inst_19256 = (state_19288[(2)]);
var inst_19257 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19288__$1 = (function (){var statearr_19308 = state_19288;
(statearr_19308[(13)] = inst_19256);

return statearr_19308;
})();
var statearr_19309_19336 = state_19288__$1;
(statearr_19309_19336[(2)] = inst_19257);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19288__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19289 === (8))){
var inst_19270 = (state_19288[(2)]);
var state_19288__$1 = state_19288;
var statearr_19310_19337 = state_19288__$1;
(statearr_19310_19337[(2)] = inst_19270);

(statearr_19310_19337[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19322,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19322,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19314 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19314[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19314[(1)] = (1));

return statearr_19314;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19288){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19288);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19315){if((e19315 instanceof Object)){
var ex__8254__auto__ = e19315;
var statearr_19316_19338 = state_19288;
(statearr_19316_19338[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19288);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19315;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19339 = state_19288;
state_19288 = G__19339;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19288){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19322,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19317 = f__8363__auto__.call(null);
(statearr_19317[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19322);

return statearr_19317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19322,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19341 = [];
var len__5726__auto___19397 = arguments.length;
var i__5727__auto___19398 = (0);
while(true){
if((i__5727__auto___19398 < len__5726__auto___19397)){
args19341.push((arguments[i__5727__auto___19398]));

var G__19399 = (i__5727__auto___19398 + (1));
i__5727__auto___19398 = G__19399;
continue;
} else {
}
break;
}

var G__19343 = args19341.length;
switch (G__19343) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19341.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19401,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19401,out){
return (function (state_19373){
var state_val_19374 = (state_19373[(1)]);
if((state_val_19374 === (7))){
var inst_19353 = (state_19373[(7)]);
var inst_19352 = (state_19373[(8)]);
var inst_19352__$1 = (state_19373[(2)]);
var inst_19353__$1 = cljs.core.nth.call(null,inst_19352__$1,(0),null);
var inst_19354 = cljs.core.nth.call(null,inst_19352__$1,(1),null);
var inst_19355 = (inst_19353__$1 == null);
var state_19373__$1 = (function (){var statearr_19375 = state_19373;
(statearr_19375[(7)] = inst_19353__$1);

(statearr_19375[(9)] = inst_19354);

(statearr_19375[(8)] = inst_19352__$1);

return statearr_19375;
})();
if(cljs.core.truth_(inst_19355)){
var statearr_19376_19402 = state_19373__$1;
(statearr_19376_19402[(1)] = (8));

} else {
var statearr_19377_19403 = state_19373__$1;
(statearr_19377_19403[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19374 === (1))){
var inst_19344 = cljs.core.vec.call(null,chs);
var inst_19345 = inst_19344;
var state_19373__$1 = (function (){var statearr_19378 = state_19373;
(statearr_19378[(10)] = inst_19345);

return statearr_19378;
})();
var statearr_19379_19404 = state_19373__$1;
(statearr_19379_19404[(2)] = null);

(statearr_19379_19404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19374 === (4))){
var inst_19345 = (state_19373[(10)]);
var state_19373__$1 = state_19373;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19373__$1,(7),inst_19345);
} else {
if((state_val_19374 === (6))){
var inst_19369 = (state_19373[(2)]);
var state_19373__$1 = state_19373;
var statearr_19380_19405 = state_19373__$1;
(statearr_19380_19405[(2)] = inst_19369);

(statearr_19380_19405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19374 === (3))){
var inst_19371 = (state_19373[(2)]);
var state_19373__$1 = state_19373;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19373__$1,inst_19371);
} else {
if((state_val_19374 === (2))){
var inst_19345 = (state_19373[(10)]);
var inst_19347 = cljs.core.count.call(null,inst_19345);
var inst_19348 = (inst_19347 > (0));
var state_19373__$1 = state_19373;
if(cljs.core.truth_(inst_19348)){
var statearr_19382_19406 = state_19373__$1;
(statearr_19382_19406[(1)] = (4));

} else {
var statearr_19383_19407 = state_19373__$1;
(statearr_19383_19407[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19374 === (11))){
var inst_19345 = (state_19373[(10)]);
var inst_19362 = (state_19373[(2)]);
var tmp19381 = inst_19345;
var inst_19345__$1 = tmp19381;
var state_19373__$1 = (function (){var statearr_19384 = state_19373;
(statearr_19384[(10)] = inst_19345__$1);

(statearr_19384[(11)] = inst_19362);

return statearr_19384;
})();
var statearr_19385_19408 = state_19373__$1;
(statearr_19385_19408[(2)] = null);

(statearr_19385_19408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19374 === (9))){
var inst_19353 = (state_19373[(7)]);
var state_19373__$1 = state_19373;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19373__$1,(11),out,inst_19353);
} else {
if((state_val_19374 === (5))){
var inst_19367 = cljs.core.async.close_BANG_.call(null,out);
var state_19373__$1 = state_19373;
var statearr_19386_19409 = state_19373__$1;
(statearr_19386_19409[(2)] = inst_19367);

(statearr_19386_19409[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19374 === (10))){
var inst_19365 = (state_19373[(2)]);
var state_19373__$1 = state_19373;
var statearr_19387_19410 = state_19373__$1;
(statearr_19387_19410[(2)] = inst_19365);

(statearr_19387_19410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19374 === (8))){
var inst_19353 = (state_19373[(7)]);
var inst_19345 = (state_19373[(10)]);
var inst_19354 = (state_19373[(9)]);
var inst_19352 = (state_19373[(8)]);
var inst_19357 = (function (){var cs = inst_19345;
var vec__19350 = inst_19352;
var v = inst_19353;
var c = inst_19354;
return ((function (cs,vec__19350,v,c,inst_19353,inst_19345,inst_19354,inst_19352,state_val_19374,c__8362__auto___19401,out){
return (function (p1__19340_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19340_SHARP_);
});
;})(cs,vec__19350,v,c,inst_19353,inst_19345,inst_19354,inst_19352,state_val_19374,c__8362__auto___19401,out))
})();
var inst_19358 = cljs.core.filterv.call(null,inst_19357,inst_19345);
var inst_19345__$1 = inst_19358;
var state_19373__$1 = (function (){var statearr_19388 = state_19373;
(statearr_19388[(10)] = inst_19345__$1);

return statearr_19388;
})();
var statearr_19389_19411 = state_19373__$1;
(statearr_19389_19411[(2)] = null);

(statearr_19389_19411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19401,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19401,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19393 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19393[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19393[(1)] = (1));

return statearr_19393;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19373){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19373);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19394){if((e19394 instanceof Object)){
var ex__8254__auto__ = e19394;
var statearr_19395_19412 = state_19373;
(statearr_19395_19412[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19373);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19413 = state_19373;
state_19373 = G__19413;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19373){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19401,out))
})();
var state__8364__auto__ = (function (){var statearr_19396 = f__8363__auto__.call(null);
(statearr_19396[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19401);

return statearr_19396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19401,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19414 = [];
var len__5726__auto___19463 = arguments.length;
var i__5727__auto___19464 = (0);
while(true){
if((i__5727__auto___19464 < len__5726__auto___19463)){
args19414.push((arguments[i__5727__auto___19464]));

var G__19465 = (i__5727__auto___19464 + (1));
i__5727__auto___19464 = G__19465;
continue;
} else {
}
break;
}

var G__19416 = args19414.length;
switch (G__19416) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19414.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19467 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19467,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19467,out){
return (function (state_19440){
var state_val_19441 = (state_19440[(1)]);
if((state_val_19441 === (7))){
var inst_19422 = (state_19440[(7)]);
var inst_19422__$1 = (state_19440[(2)]);
var inst_19423 = (inst_19422__$1 == null);
var inst_19424 = cljs.core.not.call(null,inst_19423);
var state_19440__$1 = (function (){var statearr_19442 = state_19440;
(statearr_19442[(7)] = inst_19422__$1);

return statearr_19442;
})();
if(inst_19424){
var statearr_19443_19468 = state_19440__$1;
(statearr_19443_19468[(1)] = (8));

} else {
var statearr_19444_19469 = state_19440__$1;
(statearr_19444_19469[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19441 === (1))){
var inst_19417 = (0);
var state_19440__$1 = (function (){var statearr_19445 = state_19440;
(statearr_19445[(8)] = inst_19417);

return statearr_19445;
})();
var statearr_19446_19470 = state_19440__$1;
(statearr_19446_19470[(2)] = null);

(statearr_19446_19470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19441 === (4))){
var state_19440__$1 = state_19440;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19440__$1,(7),ch);
} else {
if((state_val_19441 === (6))){
var inst_19435 = (state_19440[(2)]);
var state_19440__$1 = state_19440;
var statearr_19447_19471 = state_19440__$1;
(statearr_19447_19471[(2)] = inst_19435);

(statearr_19447_19471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19441 === (3))){
var inst_19437 = (state_19440[(2)]);
var inst_19438 = cljs.core.async.close_BANG_.call(null,out);
var state_19440__$1 = (function (){var statearr_19448 = state_19440;
(statearr_19448[(9)] = inst_19437);

return statearr_19448;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19440__$1,inst_19438);
} else {
if((state_val_19441 === (2))){
var inst_19417 = (state_19440[(8)]);
var inst_19419 = (inst_19417 < n);
var state_19440__$1 = state_19440;
if(cljs.core.truth_(inst_19419)){
var statearr_19449_19472 = state_19440__$1;
(statearr_19449_19472[(1)] = (4));

} else {
var statearr_19450_19473 = state_19440__$1;
(statearr_19450_19473[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19441 === (11))){
var inst_19417 = (state_19440[(8)]);
var inst_19427 = (state_19440[(2)]);
var inst_19428 = (inst_19417 + (1));
var inst_19417__$1 = inst_19428;
var state_19440__$1 = (function (){var statearr_19451 = state_19440;
(statearr_19451[(8)] = inst_19417__$1);

(statearr_19451[(10)] = inst_19427);

return statearr_19451;
})();
var statearr_19452_19474 = state_19440__$1;
(statearr_19452_19474[(2)] = null);

(statearr_19452_19474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19441 === (9))){
var state_19440__$1 = state_19440;
var statearr_19453_19475 = state_19440__$1;
(statearr_19453_19475[(2)] = null);

(statearr_19453_19475[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19441 === (5))){
var state_19440__$1 = state_19440;
var statearr_19454_19476 = state_19440__$1;
(statearr_19454_19476[(2)] = null);

(statearr_19454_19476[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19441 === (10))){
var inst_19432 = (state_19440[(2)]);
var state_19440__$1 = state_19440;
var statearr_19455_19477 = state_19440__$1;
(statearr_19455_19477[(2)] = inst_19432);

(statearr_19455_19477[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19441 === (8))){
var inst_19422 = (state_19440[(7)]);
var state_19440__$1 = state_19440;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19440__$1,(11),out,inst_19422);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19467,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19467,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19459 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19459[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19459[(1)] = (1));

return statearr_19459;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19440){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19440);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19460){if((e19460 instanceof Object)){
var ex__8254__auto__ = e19460;
var statearr_19461_19478 = state_19440;
(statearr_19461_19478[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19440);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19460;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19479 = state_19440;
state_19440 = G__19479;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19440){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19467,out))
})();
var state__8364__auto__ = (function (){var statearr_19462 = f__8363__auto__.call(null);
(statearr_19462[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19467);

return statearr_19462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19467,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19487 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19487 = (function (map_LT_,f,ch,meta19488){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19488 = meta19488;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19489,meta19488__$1){
var self__ = this;
var _19489__$1 = this;
return (new cljs.core.async.t_cljs$core$async19487(self__.map_LT_,self__.f,self__.ch,meta19488__$1));
});

cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19489){
var self__ = this;
var _19489__$1 = this;
return self__.meta19488;
});

cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19490 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19490 = (function (map_LT_,f,ch,meta19488,_,fn1,meta19491){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19488 = meta19488;
this._ = _;
this.fn1 = fn1;
this.meta19491 = meta19491;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19490.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19492,meta19491__$1){
var self__ = this;
var _19492__$1 = this;
return (new cljs.core.async.t_cljs$core$async19490(self__.map_LT_,self__.f,self__.ch,self__.meta19488,self__._,self__.fn1,meta19491__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19490.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19492){
var self__ = this;
var _19492__$1 = this;
return self__.meta19491;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19490.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19490.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19490.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19490.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19480_SHARP_){
return f1.call(null,(((p1__19480_SHARP_ == null))?null:self__.f.call(null,p1__19480_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19490.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19488","meta19488",1812344244,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19487","cljs.core.async/t_cljs$core$async19487",1883033422,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19491","meta19491",-1925228554,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19490.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19490.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19490";

cljs.core.async.t_cljs$core$async19490.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19490");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19490 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19490(map_LT___$1,f__$1,ch__$1,meta19488__$1,___$2,fn1__$1,meta19491){
return (new cljs.core.async.t_cljs$core$async19490(map_LT___$1,f__$1,ch__$1,meta19488__$1,___$2,fn1__$1,meta19491));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19490(self__.map_LT_,self__.f,self__.ch,self__.meta19488,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19487.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19487.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19488","meta19488",1812344244,null)], null);
});

cljs.core.async.t_cljs$core$async19487.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19487.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19487";

cljs.core.async.t_cljs$core$async19487.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19487");
});

cljs.core.async.__GT_t_cljs$core$async19487 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19487(map_LT___$1,f__$1,ch__$1,meta19488){
return (new cljs.core.async.t_cljs$core$async19487(map_LT___$1,f__$1,ch__$1,meta19488));
});

}

return (new cljs.core.async.t_cljs$core$async19487(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19496 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19496 = (function (map_GT_,f,ch,meta19497){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19497 = meta19497;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19496.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19498,meta19497__$1){
var self__ = this;
var _19498__$1 = this;
return (new cljs.core.async.t_cljs$core$async19496(self__.map_GT_,self__.f,self__.ch,meta19497__$1));
});

cljs.core.async.t_cljs$core$async19496.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19498){
var self__ = this;
var _19498__$1 = this;
return self__.meta19497;
});

cljs.core.async.t_cljs$core$async19496.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19496.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19496.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19496.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19496.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19496.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19496.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19497","meta19497",1050893631,null)], null);
});

cljs.core.async.t_cljs$core$async19496.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19496.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19496";

cljs.core.async.t_cljs$core$async19496.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19496");
});

cljs.core.async.__GT_t_cljs$core$async19496 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19496(map_GT___$1,f__$1,ch__$1,meta19497){
return (new cljs.core.async.t_cljs$core$async19496(map_GT___$1,f__$1,ch__$1,meta19497));
});

}

return (new cljs.core.async.t_cljs$core$async19496(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19502 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19502 = (function (filter_GT_,p,ch,meta19503){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19503 = meta19503;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19504,meta19503__$1){
var self__ = this;
var _19504__$1 = this;
return (new cljs.core.async.t_cljs$core$async19502(self__.filter_GT_,self__.p,self__.ch,meta19503__$1));
});

cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19504){
var self__ = this;
var _19504__$1 = this;
return self__.meta19503;
});

cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19502.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19502.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19503","meta19503",1427786810,null)], null);
});

cljs.core.async.t_cljs$core$async19502.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19502.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19502";

cljs.core.async.t_cljs$core$async19502.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19502");
});

cljs.core.async.__GT_t_cljs$core$async19502 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19502(filter_GT___$1,p__$1,ch__$1,meta19503){
return (new cljs.core.async.t_cljs$core$async19502(filter_GT___$1,p__$1,ch__$1,meta19503));
});

}

return (new cljs.core.async.t_cljs$core$async19502(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19505 = [];
var len__5726__auto___19549 = arguments.length;
var i__5727__auto___19550 = (0);
while(true){
if((i__5727__auto___19550 < len__5726__auto___19549)){
args19505.push((arguments[i__5727__auto___19550]));

var G__19551 = (i__5727__auto___19550 + (1));
i__5727__auto___19550 = G__19551;
continue;
} else {
}
break;
}

var G__19507 = args19505.length;
switch (G__19507) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19505.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19553,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19553,out){
return (function (state_19528){
var state_val_19529 = (state_19528[(1)]);
if((state_val_19529 === (7))){
var inst_19524 = (state_19528[(2)]);
var state_19528__$1 = state_19528;
var statearr_19530_19554 = state_19528__$1;
(statearr_19530_19554[(2)] = inst_19524);

(statearr_19530_19554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (1))){
var state_19528__$1 = state_19528;
var statearr_19531_19555 = state_19528__$1;
(statearr_19531_19555[(2)] = null);

(statearr_19531_19555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (4))){
var inst_19510 = (state_19528[(7)]);
var inst_19510__$1 = (state_19528[(2)]);
var inst_19511 = (inst_19510__$1 == null);
var state_19528__$1 = (function (){var statearr_19532 = state_19528;
(statearr_19532[(7)] = inst_19510__$1);

return statearr_19532;
})();
if(cljs.core.truth_(inst_19511)){
var statearr_19533_19556 = state_19528__$1;
(statearr_19533_19556[(1)] = (5));

} else {
var statearr_19534_19557 = state_19528__$1;
(statearr_19534_19557[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (6))){
var inst_19510 = (state_19528[(7)]);
var inst_19515 = p.call(null,inst_19510);
var state_19528__$1 = state_19528;
if(cljs.core.truth_(inst_19515)){
var statearr_19535_19558 = state_19528__$1;
(statearr_19535_19558[(1)] = (8));

} else {
var statearr_19536_19559 = state_19528__$1;
(statearr_19536_19559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (3))){
var inst_19526 = (state_19528[(2)]);
var state_19528__$1 = state_19528;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19528__$1,inst_19526);
} else {
if((state_val_19529 === (2))){
var state_19528__$1 = state_19528;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19528__$1,(4),ch);
} else {
if((state_val_19529 === (11))){
var inst_19518 = (state_19528[(2)]);
var state_19528__$1 = state_19528;
var statearr_19537_19560 = state_19528__$1;
(statearr_19537_19560[(2)] = inst_19518);

(statearr_19537_19560[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (9))){
var state_19528__$1 = state_19528;
var statearr_19538_19561 = state_19528__$1;
(statearr_19538_19561[(2)] = null);

(statearr_19538_19561[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (5))){
var inst_19513 = cljs.core.async.close_BANG_.call(null,out);
var state_19528__$1 = state_19528;
var statearr_19539_19562 = state_19528__$1;
(statearr_19539_19562[(2)] = inst_19513);

(statearr_19539_19562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (10))){
var inst_19521 = (state_19528[(2)]);
var state_19528__$1 = (function (){var statearr_19540 = state_19528;
(statearr_19540[(8)] = inst_19521);

return statearr_19540;
})();
var statearr_19541_19563 = state_19528__$1;
(statearr_19541_19563[(2)] = null);

(statearr_19541_19563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19529 === (8))){
var inst_19510 = (state_19528[(7)]);
var state_19528__$1 = state_19528;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19528__$1,(11),out,inst_19510);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19553,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19553,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19545 = [null,null,null,null,null,null,null,null,null];
(statearr_19545[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19545[(1)] = (1));

return statearr_19545;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19528){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19546){if((e19546 instanceof Object)){
var ex__8254__auto__ = e19546;
var statearr_19547_19564 = state_19528;
(statearr_19547_19564[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19528);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19546;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19565 = state_19528;
state_19528 = G__19565;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19528){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19553,out))
})();
var state__8364__auto__ = (function (){var statearr_19548 = f__8363__auto__.call(null);
(statearr_19548[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19553);

return statearr_19548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19553,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19566 = [];
var len__5726__auto___19569 = arguments.length;
var i__5727__auto___19570 = (0);
while(true){
if((i__5727__auto___19570 < len__5726__auto___19569)){
args19566.push((arguments[i__5727__auto___19570]));

var G__19571 = (i__5727__auto___19570 + (1));
i__5727__auto___19570 = G__19571;
continue;
} else {
}
break;
}

var G__19568 = args19566.length;
switch (G__19568) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19566.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19738){
var state_val_19739 = (state_19738[(1)]);
if((state_val_19739 === (7))){
var inst_19734 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
var statearr_19740_19781 = state_19738__$1;
(statearr_19740_19781[(2)] = inst_19734);

(statearr_19740_19781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (20))){
var inst_19704 = (state_19738[(7)]);
var inst_19715 = (state_19738[(2)]);
var inst_19716 = cljs.core.next.call(null,inst_19704);
var inst_19690 = inst_19716;
var inst_19691 = null;
var inst_19692 = (0);
var inst_19693 = (0);
var state_19738__$1 = (function (){var statearr_19741 = state_19738;
(statearr_19741[(8)] = inst_19715);

(statearr_19741[(9)] = inst_19692);

(statearr_19741[(10)] = inst_19691);

(statearr_19741[(11)] = inst_19693);

(statearr_19741[(12)] = inst_19690);

return statearr_19741;
})();
var statearr_19742_19782 = state_19738__$1;
(statearr_19742_19782[(2)] = null);

(statearr_19742_19782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (1))){
var state_19738__$1 = state_19738;
var statearr_19743_19783 = state_19738__$1;
(statearr_19743_19783[(2)] = null);

(statearr_19743_19783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (4))){
var inst_19679 = (state_19738[(13)]);
var inst_19679__$1 = (state_19738[(2)]);
var inst_19680 = (inst_19679__$1 == null);
var state_19738__$1 = (function (){var statearr_19744 = state_19738;
(statearr_19744[(13)] = inst_19679__$1);

return statearr_19744;
})();
if(cljs.core.truth_(inst_19680)){
var statearr_19745_19784 = state_19738__$1;
(statearr_19745_19784[(1)] = (5));

} else {
var statearr_19746_19785 = state_19738__$1;
(statearr_19746_19785[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (15))){
var state_19738__$1 = state_19738;
var statearr_19750_19786 = state_19738__$1;
(statearr_19750_19786[(2)] = null);

(statearr_19750_19786[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (21))){
var state_19738__$1 = state_19738;
var statearr_19751_19787 = state_19738__$1;
(statearr_19751_19787[(2)] = null);

(statearr_19751_19787[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (13))){
var inst_19692 = (state_19738[(9)]);
var inst_19691 = (state_19738[(10)]);
var inst_19693 = (state_19738[(11)]);
var inst_19690 = (state_19738[(12)]);
var inst_19700 = (state_19738[(2)]);
var inst_19701 = (inst_19693 + (1));
var tmp19747 = inst_19692;
var tmp19748 = inst_19691;
var tmp19749 = inst_19690;
var inst_19690__$1 = tmp19749;
var inst_19691__$1 = tmp19748;
var inst_19692__$1 = tmp19747;
var inst_19693__$1 = inst_19701;
var state_19738__$1 = (function (){var statearr_19752 = state_19738;
(statearr_19752[(9)] = inst_19692__$1);

(statearr_19752[(14)] = inst_19700);

(statearr_19752[(10)] = inst_19691__$1);

(statearr_19752[(11)] = inst_19693__$1);

(statearr_19752[(12)] = inst_19690__$1);

return statearr_19752;
})();
var statearr_19753_19788 = state_19738__$1;
(statearr_19753_19788[(2)] = null);

(statearr_19753_19788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (22))){
var state_19738__$1 = state_19738;
var statearr_19754_19789 = state_19738__$1;
(statearr_19754_19789[(2)] = null);

(statearr_19754_19789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (6))){
var inst_19679 = (state_19738[(13)]);
var inst_19688 = f.call(null,inst_19679);
var inst_19689 = cljs.core.seq.call(null,inst_19688);
var inst_19690 = inst_19689;
var inst_19691 = null;
var inst_19692 = (0);
var inst_19693 = (0);
var state_19738__$1 = (function (){var statearr_19755 = state_19738;
(statearr_19755[(9)] = inst_19692);

(statearr_19755[(10)] = inst_19691);

(statearr_19755[(11)] = inst_19693);

(statearr_19755[(12)] = inst_19690);

return statearr_19755;
})();
var statearr_19756_19790 = state_19738__$1;
(statearr_19756_19790[(2)] = null);

(statearr_19756_19790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (17))){
var inst_19704 = (state_19738[(7)]);
var inst_19708 = cljs.core.chunk_first.call(null,inst_19704);
var inst_19709 = cljs.core.chunk_rest.call(null,inst_19704);
var inst_19710 = cljs.core.count.call(null,inst_19708);
var inst_19690 = inst_19709;
var inst_19691 = inst_19708;
var inst_19692 = inst_19710;
var inst_19693 = (0);
var state_19738__$1 = (function (){var statearr_19757 = state_19738;
(statearr_19757[(9)] = inst_19692);

(statearr_19757[(10)] = inst_19691);

(statearr_19757[(11)] = inst_19693);

(statearr_19757[(12)] = inst_19690);

return statearr_19757;
})();
var statearr_19758_19791 = state_19738__$1;
(statearr_19758_19791[(2)] = null);

(statearr_19758_19791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (3))){
var inst_19736 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19738__$1,inst_19736);
} else {
if((state_val_19739 === (12))){
var inst_19724 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
var statearr_19759_19792 = state_19738__$1;
(statearr_19759_19792[(2)] = inst_19724);

(statearr_19759_19792[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (2))){
var state_19738__$1 = state_19738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19738__$1,(4),in$);
} else {
if((state_val_19739 === (23))){
var inst_19732 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
var statearr_19760_19793 = state_19738__$1;
(statearr_19760_19793[(2)] = inst_19732);

(statearr_19760_19793[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (19))){
var inst_19719 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
var statearr_19761_19794 = state_19738__$1;
(statearr_19761_19794[(2)] = inst_19719);

(statearr_19761_19794[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (11))){
var inst_19704 = (state_19738[(7)]);
var inst_19690 = (state_19738[(12)]);
var inst_19704__$1 = cljs.core.seq.call(null,inst_19690);
var state_19738__$1 = (function (){var statearr_19762 = state_19738;
(statearr_19762[(7)] = inst_19704__$1);

return statearr_19762;
})();
if(inst_19704__$1){
var statearr_19763_19795 = state_19738__$1;
(statearr_19763_19795[(1)] = (14));

} else {
var statearr_19764_19796 = state_19738__$1;
(statearr_19764_19796[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (9))){
var inst_19726 = (state_19738[(2)]);
var inst_19727 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19738__$1 = (function (){var statearr_19765 = state_19738;
(statearr_19765[(15)] = inst_19726);

return statearr_19765;
})();
if(cljs.core.truth_(inst_19727)){
var statearr_19766_19797 = state_19738__$1;
(statearr_19766_19797[(1)] = (21));

} else {
var statearr_19767_19798 = state_19738__$1;
(statearr_19767_19798[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (5))){
var inst_19682 = cljs.core.async.close_BANG_.call(null,out);
var state_19738__$1 = state_19738;
var statearr_19768_19799 = state_19738__$1;
(statearr_19768_19799[(2)] = inst_19682);

(statearr_19768_19799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (14))){
var inst_19704 = (state_19738[(7)]);
var inst_19706 = cljs.core.chunked_seq_QMARK_.call(null,inst_19704);
var state_19738__$1 = state_19738;
if(inst_19706){
var statearr_19769_19800 = state_19738__$1;
(statearr_19769_19800[(1)] = (17));

} else {
var statearr_19770_19801 = state_19738__$1;
(statearr_19770_19801[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (16))){
var inst_19722 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
var statearr_19771_19802 = state_19738__$1;
(statearr_19771_19802[(2)] = inst_19722);

(statearr_19771_19802[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19739 === (10))){
var inst_19691 = (state_19738[(10)]);
var inst_19693 = (state_19738[(11)]);
var inst_19698 = cljs.core._nth.call(null,inst_19691,inst_19693);
var state_19738__$1 = state_19738;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19738__$1,(13),out,inst_19698);
} else {
if((state_val_19739 === (18))){
var inst_19704 = (state_19738[(7)]);
var inst_19713 = cljs.core.first.call(null,inst_19704);
var state_19738__$1 = state_19738;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19738__$1,(20),out,inst_19713);
} else {
if((state_val_19739 === (8))){
var inst_19692 = (state_19738[(9)]);
var inst_19693 = (state_19738[(11)]);
var inst_19695 = (inst_19693 < inst_19692);
var inst_19696 = inst_19695;
var state_19738__$1 = state_19738;
if(cljs.core.truth_(inst_19696)){
var statearr_19772_19803 = state_19738__$1;
(statearr_19772_19803[(1)] = (10));

} else {
var statearr_19773_19804 = state_19738__$1;
(statearr_19773_19804[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19777 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19777[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19777[(1)] = (1));

return statearr_19777;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19738){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19778){if((e19778 instanceof Object)){
var ex__8254__auto__ = e19778;
var statearr_19779_19805 = state_19738;
(statearr_19779_19805[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19738);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19778;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19806 = state_19738;
state_19738 = G__19806;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19738){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19780 = f__8363__auto__.call(null);
(statearr_19780[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19807 = [];
var len__5726__auto___19810 = arguments.length;
var i__5727__auto___19811 = (0);
while(true){
if((i__5727__auto___19811 < len__5726__auto___19810)){
args19807.push((arguments[i__5727__auto___19811]));

var G__19812 = (i__5727__auto___19811 + (1));
i__5727__auto___19811 = G__19812;
continue;
} else {
}
break;
}

var G__19809 = args19807.length;
switch (G__19809) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19807.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19814 = [];
var len__5726__auto___19817 = arguments.length;
var i__5727__auto___19818 = (0);
while(true){
if((i__5727__auto___19818 < len__5726__auto___19817)){
args19814.push((arguments[i__5727__auto___19818]));

var G__19819 = (i__5727__auto___19818 + (1));
i__5727__auto___19818 = G__19819;
continue;
} else {
}
break;
}

var G__19816 = args19814.length;
switch (G__19816) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19814.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19821 = [];
var len__5726__auto___19872 = arguments.length;
var i__5727__auto___19873 = (0);
while(true){
if((i__5727__auto___19873 < len__5726__auto___19872)){
args19821.push((arguments[i__5727__auto___19873]));

var G__19874 = (i__5727__auto___19873 + (1));
i__5727__auto___19873 = G__19874;
continue;
} else {
}
break;
}

var G__19823 = args19821.length;
switch (G__19823) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19821.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19876 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19876,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19876,out){
return (function (state_19847){
var state_val_19848 = (state_19847[(1)]);
if((state_val_19848 === (7))){
var inst_19842 = (state_19847[(2)]);
var state_19847__$1 = state_19847;
var statearr_19849_19877 = state_19847__$1;
(statearr_19849_19877[(2)] = inst_19842);

(statearr_19849_19877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (1))){
var inst_19824 = null;
var state_19847__$1 = (function (){var statearr_19850 = state_19847;
(statearr_19850[(7)] = inst_19824);

return statearr_19850;
})();
var statearr_19851_19878 = state_19847__$1;
(statearr_19851_19878[(2)] = null);

(statearr_19851_19878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (4))){
var inst_19827 = (state_19847[(8)]);
var inst_19827__$1 = (state_19847[(2)]);
var inst_19828 = (inst_19827__$1 == null);
var inst_19829 = cljs.core.not.call(null,inst_19828);
var state_19847__$1 = (function (){var statearr_19852 = state_19847;
(statearr_19852[(8)] = inst_19827__$1);

return statearr_19852;
})();
if(inst_19829){
var statearr_19853_19879 = state_19847__$1;
(statearr_19853_19879[(1)] = (5));

} else {
var statearr_19854_19880 = state_19847__$1;
(statearr_19854_19880[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (6))){
var state_19847__$1 = state_19847;
var statearr_19855_19881 = state_19847__$1;
(statearr_19855_19881[(2)] = null);

(statearr_19855_19881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (3))){
var inst_19844 = (state_19847[(2)]);
var inst_19845 = cljs.core.async.close_BANG_.call(null,out);
var state_19847__$1 = (function (){var statearr_19856 = state_19847;
(statearr_19856[(9)] = inst_19844);

return statearr_19856;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19847__$1,inst_19845);
} else {
if((state_val_19848 === (2))){
var state_19847__$1 = state_19847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19847__$1,(4),ch);
} else {
if((state_val_19848 === (11))){
var inst_19827 = (state_19847[(8)]);
var inst_19836 = (state_19847[(2)]);
var inst_19824 = inst_19827;
var state_19847__$1 = (function (){var statearr_19857 = state_19847;
(statearr_19857[(10)] = inst_19836);

(statearr_19857[(7)] = inst_19824);

return statearr_19857;
})();
var statearr_19858_19882 = state_19847__$1;
(statearr_19858_19882[(2)] = null);

(statearr_19858_19882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (9))){
var inst_19827 = (state_19847[(8)]);
var state_19847__$1 = state_19847;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19847__$1,(11),out,inst_19827);
} else {
if((state_val_19848 === (5))){
var inst_19824 = (state_19847[(7)]);
var inst_19827 = (state_19847[(8)]);
var inst_19831 = cljs.core._EQ_.call(null,inst_19827,inst_19824);
var state_19847__$1 = state_19847;
if(inst_19831){
var statearr_19860_19883 = state_19847__$1;
(statearr_19860_19883[(1)] = (8));

} else {
var statearr_19861_19884 = state_19847__$1;
(statearr_19861_19884[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (10))){
var inst_19839 = (state_19847[(2)]);
var state_19847__$1 = state_19847;
var statearr_19862_19885 = state_19847__$1;
(statearr_19862_19885[(2)] = inst_19839);

(statearr_19862_19885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (8))){
var inst_19824 = (state_19847[(7)]);
var tmp19859 = inst_19824;
var inst_19824__$1 = tmp19859;
var state_19847__$1 = (function (){var statearr_19863 = state_19847;
(statearr_19863[(7)] = inst_19824__$1);

return statearr_19863;
})();
var statearr_19864_19886 = state_19847__$1;
(statearr_19864_19886[(2)] = null);

(statearr_19864_19886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19876,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19876,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19868 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19868[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19868[(1)] = (1));

return statearr_19868;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19847){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19869){if((e19869 instanceof Object)){
var ex__8254__auto__ = e19869;
var statearr_19870_19887 = state_19847;
(statearr_19870_19887[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19888 = state_19847;
state_19847 = G__19888;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19847){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19876,out))
})();
var state__8364__auto__ = (function (){var statearr_19871 = f__8363__auto__.call(null);
(statearr_19871[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19876);

return statearr_19871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19876,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19889 = [];
var len__5726__auto___19959 = arguments.length;
var i__5727__auto___19960 = (0);
while(true){
if((i__5727__auto___19960 < len__5726__auto___19959)){
args19889.push((arguments[i__5727__auto___19960]));

var G__19961 = (i__5727__auto___19960 + (1));
i__5727__auto___19960 = G__19961;
continue;
} else {
}
break;
}

var G__19891 = args19889.length;
switch (G__19891) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19889.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19963 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19963,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19963,out){
return (function (state_19929){
var state_val_19930 = (state_19929[(1)]);
if((state_val_19930 === (7))){
var inst_19925 = (state_19929[(2)]);
var state_19929__$1 = state_19929;
var statearr_19931_19964 = state_19929__$1;
(statearr_19931_19964[(2)] = inst_19925);

(statearr_19931_19964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (1))){
var inst_19892 = (new Array(n));
var inst_19893 = inst_19892;
var inst_19894 = (0);
var state_19929__$1 = (function (){var statearr_19932 = state_19929;
(statearr_19932[(7)] = inst_19893);

(statearr_19932[(8)] = inst_19894);

return statearr_19932;
})();
var statearr_19933_19965 = state_19929__$1;
(statearr_19933_19965[(2)] = null);

(statearr_19933_19965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (4))){
var inst_19897 = (state_19929[(9)]);
var inst_19897__$1 = (state_19929[(2)]);
var inst_19898 = (inst_19897__$1 == null);
var inst_19899 = cljs.core.not.call(null,inst_19898);
var state_19929__$1 = (function (){var statearr_19934 = state_19929;
(statearr_19934[(9)] = inst_19897__$1);

return statearr_19934;
})();
if(inst_19899){
var statearr_19935_19966 = state_19929__$1;
(statearr_19935_19966[(1)] = (5));

} else {
var statearr_19936_19967 = state_19929__$1;
(statearr_19936_19967[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (15))){
var inst_19919 = (state_19929[(2)]);
var state_19929__$1 = state_19929;
var statearr_19937_19968 = state_19929__$1;
(statearr_19937_19968[(2)] = inst_19919);

(statearr_19937_19968[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (13))){
var state_19929__$1 = state_19929;
var statearr_19938_19969 = state_19929__$1;
(statearr_19938_19969[(2)] = null);

(statearr_19938_19969[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (6))){
var inst_19894 = (state_19929[(8)]);
var inst_19915 = (inst_19894 > (0));
var state_19929__$1 = state_19929;
if(cljs.core.truth_(inst_19915)){
var statearr_19939_19970 = state_19929__$1;
(statearr_19939_19970[(1)] = (12));

} else {
var statearr_19940_19971 = state_19929__$1;
(statearr_19940_19971[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (3))){
var inst_19927 = (state_19929[(2)]);
var state_19929__$1 = state_19929;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19929__$1,inst_19927);
} else {
if((state_val_19930 === (12))){
var inst_19893 = (state_19929[(7)]);
var inst_19917 = cljs.core.vec.call(null,inst_19893);
var state_19929__$1 = state_19929;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19929__$1,(15),out,inst_19917);
} else {
if((state_val_19930 === (2))){
var state_19929__$1 = state_19929;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19929__$1,(4),ch);
} else {
if((state_val_19930 === (11))){
var inst_19909 = (state_19929[(2)]);
var inst_19910 = (new Array(n));
var inst_19893 = inst_19910;
var inst_19894 = (0);
var state_19929__$1 = (function (){var statearr_19941 = state_19929;
(statearr_19941[(7)] = inst_19893);

(statearr_19941[(8)] = inst_19894);

(statearr_19941[(10)] = inst_19909);

return statearr_19941;
})();
var statearr_19942_19972 = state_19929__$1;
(statearr_19942_19972[(2)] = null);

(statearr_19942_19972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (9))){
var inst_19893 = (state_19929[(7)]);
var inst_19907 = cljs.core.vec.call(null,inst_19893);
var state_19929__$1 = state_19929;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19929__$1,(11),out,inst_19907);
} else {
if((state_val_19930 === (5))){
var inst_19897 = (state_19929[(9)]);
var inst_19893 = (state_19929[(7)]);
var inst_19894 = (state_19929[(8)]);
var inst_19902 = (state_19929[(11)]);
var inst_19901 = (inst_19893[inst_19894] = inst_19897);
var inst_19902__$1 = (inst_19894 + (1));
var inst_19903 = (inst_19902__$1 < n);
var state_19929__$1 = (function (){var statearr_19943 = state_19929;
(statearr_19943[(12)] = inst_19901);

(statearr_19943[(11)] = inst_19902__$1);

return statearr_19943;
})();
if(cljs.core.truth_(inst_19903)){
var statearr_19944_19973 = state_19929__$1;
(statearr_19944_19973[(1)] = (8));

} else {
var statearr_19945_19974 = state_19929__$1;
(statearr_19945_19974[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (14))){
var inst_19922 = (state_19929[(2)]);
var inst_19923 = cljs.core.async.close_BANG_.call(null,out);
var state_19929__$1 = (function (){var statearr_19947 = state_19929;
(statearr_19947[(13)] = inst_19922);

return statearr_19947;
})();
var statearr_19948_19975 = state_19929__$1;
(statearr_19948_19975[(2)] = inst_19923);

(statearr_19948_19975[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (10))){
var inst_19913 = (state_19929[(2)]);
var state_19929__$1 = state_19929;
var statearr_19949_19976 = state_19929__$1;
(statearr_19949_19976[(2)] = inst_19913);

(statearr_19949_19976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (8))){
var inst_19893 = (state_19929[(7)]);
var inst_19902 = (state_19929[(11)]);
var tmp19946 = inst_19893;
var inst_19893__$1 = tmp19946;
var inst_19894 = inst_19902;
var state_19929__$1 = (function (){var statearr_19950 = state_19929;
(statearr_19950[(7)] = inst_19893__$1);

(statearr_19950[(8)] = inst_19894);

return statearr_19950;
})();
var statearr_19951_19977 = state_19929__$1;
(statearr_19951_19977[(2)] = null);

(statearr_19951_19977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19963,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19963,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19955 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19955[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19955[(1)] = (1));

return statearr_19955;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19929){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19929);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19956){if((e19956 instanceof Object)){
var ex__8254__auto__ = e19956;
var statearr_19957_19978 = state_19929;
(statearr_19957_19978[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19929);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19956;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19979 = state_19929;
state_19929 = G__19979;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19929){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19963,out))
})();
var state__8364__auto__ = (function (){var statearr_19958 = f__8363__auto__.call(null);
(statearr_19958[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19963);

return statearr_19958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19963,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19980 = [];
var len__5726__auto___20054 = arguments.length;
var i__5727__auto___20055 = (0);
while(true){
if((i__5727__auto___20055 < len__5726__auto___20054)){
args19980.push((arguments[i__5727__auto___20055]));

var G__20056 = (i__5727__auto___20055 + (1));
i__5727__auto___20055 = G__20056;
continue;
} else {
}
break;
}

var G__19982 = args19980.length;
switch (G__19982) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19980.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20058 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20058,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20058,out){
return (function (state_20024){
var state_val_20025 = (state_20024[(1)]);
if((state_val_20025 === (7))){
var inst_20020 = (state_20024[(2)]);
var state_20024__$1 = state_20024;
var statearr_20026_20059 = state_20024__$1;
(statearr_20026_20059[(2)] = inst_20020);

(statearr_20026_20059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (1))){
var inst_19983 = [];
var inst_19984 = inst_19983;
var inst_19985 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20024__$1 = (function (){var statearr_20027 = state_20024;
(statearr_20027[(7)] = inst_19985);

(statearr_20027[(8)] = inst_19984);

return statearr_20027;
})();
var statearr_20028_20060 = state_20024__$1;
(statearr_20028_20060[(2)] = null);

(statearr_20028_20060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (4))){
var inst_19988 = (state_20024[(9)]);
var inst_19988__$1 = (state_20024[(2)]);
var inst_19989 = (inst_19988__$1 == null);
var inst_19990 = cljs.core.not.call(null,inst_19989);
var state_20024__$1 = (function (){var statearr_20029 = state_20024;
(statearr_20029[(9)] = inst_19988__$1);

return statearr_20029;
})();
if(inst_19990){
var statearr_20030_20061 = state_20024__$1;
(statearr_20030_20061[(1)] = (5));

} else {
var statearr_20031_20062 = state_20024__$1;
(statearr_20031_20062[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (15))){
var inst_20014 = (state_20024[(2)]);
var state_20024__$1 = state_20024;
var statearr_20032_20063 = state_20024__$1;
(statearr_20032_20063[(2)] = inst_20014);

(statearr_20032_20063[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (13))){
var state_20024__$1 = state_20024;
var statearr_20033_20064 = state_20024__$1;
(statearr_20033_20064[(2)] = null);

(statearr_20033_20064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (6))){
var inst_19984 = (state_20024[(8)]);
var inst_20009 = inst_19984.length;
var inst_20010 = (inst_20009 > (0));
var state_20024__$1 = state_20024;
if(cljs.core.truth_(inst_20010)){
var statearr_20034_20065 = state_20024__$1;
(statearr_20034_20065[(1)] = (12));

} else {
var statearr_20035_20066 = state_20024__$1;
(statearr_20035_20066[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (3))){
var inst_20022 = (state_20024[(2)]);
var state_20024__$1 = state_20024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20024__$1,inst_20022);
} else {
if((state_val_20025 === (12))){
var inst_19984 = (state_20024[(8)]);
var inst_20012 = cljs.core.vec.call(null,inst_19984);
var state_20024__$1 = state_20024;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20024__$1,(15),out,inst_20012);
} else {
if((state_val_20025 === (2))){
var state_20024__$1 = state_20024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20024__$1,(4),ch);
} else {
if((state_val_20025 === (11))){
var inst_19992 = (state_20024[(10)]);
var inst_19988 = (state_20024[(9)]);
var inst_20002 = (state_20024[(2)]);
var inst_20003 = [];
var inst_20004 = inst_20003.push(inst_19988);
var inst_19984 = inst_20003;
var inst_19985 = inst_19992;
var state_20024__$1 = (function (){var statearr_20036 = state_20024;
(statearr_20036[(7)] = inst_19985);

(statearr_20036[(8)] = inst_19984);

(statearr_20036[(11)] = inst_20002);

(statearr_20036[(12)] = inst_20004);

return statearr_20036;
})();
var statearr_20037_20067 = state_20024__$1;
(statearr_20037_20067[(2)] = null);

(statearr_20037_20067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (9))){
var inst_19984 = (state_20024[(8)]);
var inst_20000 = cljs.core.vec.call(null,inst_19984);
var state_20024__$1 = state_20024;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20024__$1,(11),out,inst_20000);
} else {
if((state_val_20025 === (5))){
var inst_19985 = (state_20024[(7)]);
var inst_19992 = (state_20024[(10)]);
var inst_19988 = (state_20024[(9)]);
var inst_19992__$1 = f.call(null,inst_19988);
var inst_19993 = cljs.core._EQ_.call(null,inst_19992__$1,inst_19985);
var inst_19994 = cljs.core.keyword_identical_QMARK_.call(null,inst_19985,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19995 = (inst_19993) || (inst_19994);
var state_20024__$1 = (function (){var statearr_20038 = state_20024;
(statearr_20038[(10)] = inst_19992__$1);

return statearr_20038;
})();
if(cljs.core.truth_(inst_19995)){
var statearr_20039_20068 = state_20024__$1;
(statearr_20039_20068[(1)] = (8));

} else {
var statearr_20040_20069 = state_20024__$1;
(statearr_20040_20069[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (14))){
var inst_20017 = (state_20024[(2)]);
var inst_20018 = cljs.core.async.close_BANG_.call(null,out);
var state_20024__$1 = (function (){var statearr_20042 = state_20024;
(statearr_20042[(13)] = inst_20017);

return statearr_20042;
})();
var statearr_20043_20070 = state_20024__$1;
(statearr_20043_20070[(2)] = inst_20018);

(statearr_20043_20070[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (10))){
var inst_20007 = (state_20024[(2)]);
var state_20024__$1 = state_20024;
var statearr_20044_20071 = state_20024__$1;
(statearr_20044_20071[(2)] = inst_20007);

(statearr_20044_20071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20025 === (8))){
var inst_19992 = (state_20024[(10)]);
var inst_19984 = (state_20024[(8)]);
var inst_19988 = (state_20024[(9)]);
var inst_19997 = inst_19984.push(inst_19988);
var tmp20041 = inst_19984;
var inst_19984__$1 = tmp20041;
var inst_19985 = inst_19992;
var state_20024__$1 = (function (){var statearr_20045 = state_20024;
(statearr_20045[(7)] = inst_19985);

(statearr_20045[(8)] = inst_19984__$1);

(statearr_20045[(14)] = inst_19997);

return statearr_20045;
})();
var statearr_20046_20072 = state_20024__$1;
(statearr_20046_20072[(2)] = null);

(statearr_20046_20072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20058,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20058,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_20050 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20050[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_20050[(1)] = (1));

return statearr_20050;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_20024){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_20024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e20051){if((e20051 instanceof Object)){
var ex__8254__auto__ = e20051;
var statearr_20052_20073 = state_20024;
(statearr_20052_20073[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20024);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20051;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20074 = state_20024;
state_20024 = G__20074;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_20024){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_20024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20058,out))
})();
var state__8364__auto__ = (function (){var statearr_20053 = f__8363__auto__.call(null);
(statearr_20053[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20058);

return statearr_20053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20058,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1458825537340