// Compiled by ClojureScript 1.7.170 {}
goog.provide('vega_viewer.components.vega_viewer');
goog.require('cljs.core');
goog.require('cljsjs.vega');
goog.require('om.core');
goog.require('sablono.core');
vega_viewer.components.vega_viewer.chart_width_proportion = 0.8;
/**
 * Add a window.resize event handler that changes the :container-width state of
 * a vega-viewer instance when the window is resized
 */
vega_viewer.components.vega_viewer.set_resize_handler = (function vega_viewer$components$vega_viewer$set_resize_handler(owner){
var container = om.core.get_node.call(null,owner,"vega-container");
var resize_handler = window.addEventListener("resize",((function (container){
return (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"container-width","container-width",-1461172864),container.clientWidth);
});})(container))
);
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
/**
 * Render a Vega specification in the supplied container
 */
vega_viewer.components.vega_viewer.render_vega_visualization = (function vega_viewer$components$vega_viewer$render_vega_visualization(spec,container,responsive_QMARK_){
var container_width = container.clientWidth;
var spec_as_js = cljs.core.clj__GT_js.call(null,(cljs.core.truth_(responsive_QMARK_)?cljs.core.assoc.call(null,spec,new cljs.core.Keyword(null,"width","width",-384071477),(container_width * vega_viewer.components.vega_viewer.chart_width_proportion)):spec));
return vg.parse.spec(spec_as_js,((function (container_width,spec_as_js){
return (function (chart){
var view = chart.call(null,{"el": container});
return view.update();
});})(container_width,spec_as_js))
);
});
/**
 * Return an Om component that renders a Vega specification
 */
vega_viewer.components.vega_viewer.vega_viewer = (function vega_viewer$components$vega_viewer$vega_viewer(p__22830,owner,p__22831){
var map__22848 = p__22830;
var map__22848__$1 = ((((!((map__22848 == null)))?((((map__22848.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22848.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22848):map__22848);
var vega_spec = map__22848__$1;
var width = cljs.core.get.call(null,map__22848__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var map__22849 = p__22831;
var map__22849__$1 = ((((!((map__22849 == null)))?((((map__22849.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22849.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22849):map__22849);
var responsive_QMARK_ = cljs.core.get.call(null,map__22849__$1,new cljs.core.Keyword(null,"responsive?","responsive?",-683696941));
if(typeof vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {om.core.IDidUpdate}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852 = (function (vega_viewer,p__22830,owner,p__22831,map__22848,vega_spec,width,map__22849,responsive_QMARK_,meta22853){
this.vega_viewer = vega_viewer;
this.p__22830 = p__22830;
this.owner = owner;
this.p__22831 = p__22831;
this.map__22848 = map__22848;
this.vega_spec = vega_spec;
this.width = width;
this.map__22849 = map__22849;
this.responsive_QMARK_ = responsive_QMARK_;
this.meta22853 = meta22853;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function (_22854,meta22853__$1){
var self__ = this;
var _22854__$1 = this;
return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852(self__.vega_viewer,self__.p__22830,self__.owner,self__.p__22831,self__.map__22848,self__.vega_spec,self__.width,self__.map__22849,self__.responsive_QMARK_,meta22853__$1));
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function (_22854){
var self__ = this;
var _22854__$1 = this;
return self__.meta22853;
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.om$core$IWillUnmount$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
var map__22855 = om.core.get_state.call(null,self__.owner);
var map__22855__$1 = ((((!((map__22855 == null)))?((((map__22855.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22855.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22855):map__22855);
var resize_handler = cljs.core.get.call(null,map__22855__$1,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881));
return window.removeEventListener("resize",resize_handler);
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.om$core$IDidUpdate$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.om$core$IDidUpdate$did_update$arity$3 = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function (_,___$1,p__22857){
var self__ = this;
var map__22858 = p__22857;
var map__22858__$1 = ((((!((map__22858 == null)))?((((map__22858.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22858.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22858):map__22858);
var previous_container_width = cljs.core.get.call(null,map__22858__$1,new cljs.core.Keyword(null,"container-width","container-width",-1461172864));
var ___$2 = this;
var map__22860 = om.core.get_state.call(null,self__.owner);
var map__22860__$1 = ((((!((map__22860 == null)))?((((map__22860.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22860.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22860):map__22860);
var container_width = cljs.core.get.call(null,map__22860__$1,new cljs.core.Keyword(null,"container-width","container-width",-1461172864));
if(cljs.core.not_EQ_.call(null,previous_container_width,container_width)){
return vega_viewer.components.vega_viewer.render_vega_visualization.call(null,self__.vega_spec,om.core.get_node.call(null,self__.owner,"vega-container"),self__.responsive_QMARK_);
} else {
return null;
}
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.om$core$IDidMount$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
vega_viewer.components.vega_viewer.set_resize_handler.call(null,self__.owner);

return vega_viewer.components.vega_viewer.render_vega_visualization.call(null,self__.vega_spec,om.core.get_node.call(null,self__.owner,"vega-container"),self__.responsive_QMARK_);
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.om$core$IRender$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.prototype.om$core$IRender$render$arity$1 = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
return React.createElement("div",{"ref": "vega-container", "style": {"width": "100%"}});
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.getBasis = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"vega-viewer","vega-viewer",-1445969313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"width","width",1256460050,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"vega-spec","vega-spec",1334352605,null)], null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"responsive?","responsive?",956834586,null)], null)], null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return an Om component that renders a Vega specification"], null)),new cljs.core.Symbol(null,"p__22830","p__22830",245622787,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22831","p__22831",-592263459,null),new cljs.core.Symbol(null,"map__22848","map__22848",-1941411108,null),new cljs.core.Symbol(null,"vega-spec","vega-spec",1334352605,null),new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"map__22849","map__22849",1270193091,null),new cljs.core.Symbol(null,"responsive?","responsive?",956834586,null),new cljs.core.Symbol(null,"meta22853","meta22853",1574091521,null)], null);
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.cljs$lang$type = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.cljs$lang$ctorStr = "vega-viewer.components.vega-viewer/t_vega_viewer$components$vega_viewer22852";

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852.cljs$lang$ctorPrWriter = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"vega-viewer.components.vega-viewer/t_vega_viewer$components$vega_viewer22852");
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.__GT_t_vega_viewer$components$vega_viewer22852 = ((function (map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_){
return (function vega_viewer$components$vega_viewer$vega_viewer_$___GT_t_vega_viewer$components$vega_viewer22852(vega_viewer__$2,p__22830__$1,owner__$1,p__22831__$1,map__22848__$2,vega_spec__$1,width__$1,map__22849__$2,responsive_QMARK___$1,meta22853){
return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852(vega_viewer__$2,p__22830__$1,owner__$1,p__22831__$1,map__22848__$2,vega_spec__$1,width__$1,map__22849__$2,responsive_QMARK___$1,meta22853));
});})(map__22848,map__22848__$1,vega_spec,width,map__22849,map__22849__$1,responsive_QMARK_))
;

}

return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22852(vega_viewer$components$vega_viewer$vega_viewer,p__22830,owner,p__22831,map__22848__$1,vega_spec,width,map__22849__$1,responsive_QMARK_,cljs.core.PersistentArrayMap.EMPTY));
});

//# sourceMappingURL=vega_viewer.js.map?rel=1458825541050