// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17338 = [];
var len__5726__auto___17344 = arguments.length;
var i__5727__auto___17345 = (0);
while(true){
if((i__5727__auto___17345 < len__5726__auto___17344)){
args17338.push((arguments[i__5727__auto___17345]));

var G__17346 = (i__5727__auto___17345 + (1));
i__5727__auto___17345 = G__17346;
continue;
} else {
}
break;
}

var G__17340 = args17338.length;
switch (G__17340) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17338.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17341 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17341 = (function (f,blockable,meta17342){
this.f = f;
this.blockable = blockable;
this.meta17342 = meta17342;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17341.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17343,meta17342__$1){
var self__ = this;
var _17343__$1 = this;
return (new cljs.core.async.t_cljs$core$async17341(self__.f,self__.blockable,meta17342__$1));
});

cljs.core.async.t_cljs$core$async17341.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17343){
var self__ = this;
var _17343__$1 = this;
return self__.meta17342;
});

cljs.core.async.t_cljs$core$async17341.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17341.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17341.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17341.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17341.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17342","meta17342",838981032,null)], null);
});

cljs.core.async.t_cljs$core$async17341.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17341.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17341";

cljs.core.async.t_cljs$core$async17341.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17341");
});

cljs.core.async.__GT_t_cljs$core$async17341 = (function cljs$core$async$__GT_t_cljs$core$async17341(f__$1,blockable__$1,meta17342){
return (new cljs.core.async.t_cljs$core$async17341(f__$1,blockable__$1,meta17342));
});

}

return (new cljs.core.async.t_cljs$core$async17341(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17350 = [];
var len__5726__auto___17353 = arguments.length;
var i__5727__auto___17354 = (0);
while(true){
if((i__5727__auto___17354 < len__5726__auto___17353)){
args17350.push((arguments[i__5727__auto___17354]));

var G__17355 = (i__5727__auto___17354 + (1));
i__5727__auto___17354 = G__17355;
continue;
} else {
}
break;
}

var G__17352 = args17350.length;
switch (G__17352) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17350.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17357 = [];
var len__5726__auto___17360 = arguments.length;
var i__5727__auto___17361 = (0);
while(true){
if((i__5727__auto___17361 < len__5726__auto___17360)){
args17357.push((arguments[i__5727__auto___17361]));

var G__17362 = (i__5727__auto___17361 + (1));
i__5727__auto___17361 = G__17362;
continue;
} else {
}
break;
}

var G__17359 = args17357.length;
switch (G__17359) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17357.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17364 = [];
var len__5726__auto___17367 = arguments.length;
var i__5727__auto___17368 = (0);
while(true){
if((i__5727__auto___17368 < len__5726__auto___17367)){
args17364.push((arguments[i__5727__auto___17368]));

var G__17369 = (i__5727__auto___17368 + (1));
i__5727__auto___17368 = G__17369;
continue;
} else {
}
break;
}

var G__17366 = args17364.length;
switch (G__17366) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17364.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17371 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17371);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17371,ret){
return (function (){
return fn1.call(null,val_17371);
});})(val_17371,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17372 = [];
var len__5726__auto___17375 = arguments.length;
var i__5727__auto___17376 = (0);
while(true){
if((i__5727__auto___17376 < len__5726__auto___17375)){
args17372.push((arguments[i__5727__auto___17376]));

var G__17377 = (i__5727__auto___17376 + (1));
i__5727__auto___17376 = G__17377;
continue;
} else {
}
break;
}

var G__17374 = args17372.length;
switch (G__17374) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17372.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17379 = n;
var x_17380 = (0);
while(true){
if((x_17380 < n__5571__auto___17379)){
(a[x_17380] = (0));

var G__17381 = (x_17380 + (1));
x_17380 = G__17381;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17382 = (i + (1));
i = G__17382;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17386 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17386 = (function (alt_flag,flag,meta17387){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17387 = meta17387;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17388,meta17387__$1){
var self__ = this;
var _17388__$1 = this;
return (new cljs.core.async.t_cljs$core$async17386(self__.alt_flag,self__.flag,meta17387__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17388){
var self__ = this;
var _17388__$1 = this;
return self__.meta17387;
});})(flag))
;

cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17386.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17387","meta17387",-1340022937,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17386.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17386.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17386";

cljs.core.async.t_cljs$core$async17386.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17386");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17386 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17386(alt_flag__$1,flag__$1,meta17387){
return (new cljs.core.async.t_cljs$core$async17386(alt_flag__$1,flag__$1,meta17387));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17386(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17392 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17392 = (function (alt_handler,flag,cb,meta17393){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17393 = meta17393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17394,meta17393__$1){
var self__ = this;
var _17394__$1 = this;
return (new cljs.core.async.t_cljs$core$async17392(self__.alt_handler,self__.flag,self__.cb,meta17393__$1));
});

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17394){
var self__ = this;
var _17394__$1 = this;
return self__.meta17393;
});

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17392.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17393","meta17393",-1241391408,null)], null);
});

cljs.core.async.t_cljs$core$async17392.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17392.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17392";

cljs.core.async.t_cljs$core$async17392.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17392");
});

cljs.core.async.__GT_t_cljs$core$async17392 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17392(alt_handler__$1,flag__$1,cb__$1,meta17393){
return (new cljs.core.async.t_cljs$core$async17392(alt_handler__$1,flag__$1,cb__$1,meta17393));
});

}

return (new cljs.core.async.t_cljs$core$async17392(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17395_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17395_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17396_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17396_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17397 = (i + (1));
i = G__17397;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17403 = arguments.length;
var i__5727__auto___17404 = (0);
while(true){
if((i__5727__auto___17404 < len__5726__auto___17403)){
args__5733__auto__.push((arguments[i__5727__auto___17404]));

var G__17405 = (i__5727__auto___17404 + (1));
i__5727__auto___17404 = G__17405;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17400){
var map__17401 = p__17400;
var map__17401__$1 = ((((!((map__17401 == null)))?((((map__17401.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17401.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17401):map__17401);
var opts = map__17401__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17398){
var G__17399 = cljs.core.first.call(null,seq17398);
var seq17398__$1 = cljs.core.next.call(null,seq17398);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17399,seq17398__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17406 = [];
var len__5726__auto___17456 = arguments.length;
var i__5727__auto___17457 = (0);
while(true){
if((i__5727__auto___17457 < len__5726__auto___17456)){
args17406.push((arguments[i__5727__auto___17457]));

var G__17458 = (i__5727__auto___17457 + (1));
i__5727__auto___17457 = G__17458;
continue;
} else {
}
break;
}

var G__17408 = args17406.length;
switch (G__17408) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17406.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17460 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17460){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17460){
return (function (state_17432){
var state_val_17433 = (state_17432[(1)]);
if((state_val_17433 === (7))){
var inst_17428 = (state_17432[(2)]);
var state_17432__$1 = state_17432;
var statearr_17434_17461 = state_17432__$1;
(statearr_17434_17461[(2)] = inst_17428);

(statearr_17434_17461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (1))){
var state_17432__$1 = state_17432;
var statearr_17435_17462 = state_17432__$1;
(statearr_17435_17462[(2)] = null);

(statearr_17435_17462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (4))){
var inst_17411 = (state_17432[(7)]);
var inst_17411__$1 = (state_17432[(2)]);
var inst_17412 = (inst_17411__$1 == null);
var state_17432__$1 = (function (){var statearr_17436 = state_17432;
(statearr_17436[(7)] = inst_17411__$1);

return statearr_17436;
})();
if(cljs.core.truth_(inst_17412)){
var statearr_17437_17463 = state_17432__$1;
(statearr_17437_17463[(1)] = (5));

} else {
var statearr_17438_17464 = state_17432__$1;
(statearr_17438_17464[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (13))){
var state_17432__$1 = state_17432;
var statearr_17439_17465 = state_17432__$1;
(statearr_17439_17465[(2)] = null);

(statearr_17439_17465[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (6))){
var inst_17411 = (state_17432[(7)]);
var state_17432__$1 = state_17432;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17432__$1,(11),to,inst_17411);
} else {
if((state_val_17433 === (3))){
var inst_17430 = (state_17432[(2)]);
var state_17432__$1 = state_17432;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17432__$1,inst_17430);
} else {
if((state_val_17433 === (12))){
var state_17432__$1 = state_17432;
var statearr_17440_17466 = state_17432__$1;
(statearr_17440_17466[(2)] = null);

(statearr_17440_17466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (2))){
var state_17432__$1 = state_17432;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17432__$1,(4),from);
} else {
if((state_val_17433 === (11))){
var inst_17421 = (state_17432[(2)]);
var state_17432__$1 = state_17432;
if(cljs.core.truth_(inst_17421)){
var statearr_17441_17467 = state_17432__$1;
(statearr_17441_17467[(1)] = (12));

} else {
var statearr_17442_17468 = state_17432__$1;
(statearr_17442_17468[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (9))){
var state_17432__$1 = state_17432;
var statearr_17443_17469 = state_17432__$1;
(statearr_17443_17469[(2)] = null);

(statearr_17443_17469[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (5))){
var state_17432__$1 = state_17432;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17444_17470 = state_17432__$1;
(statearr_17444_17470[(1)] = (8));

} else {
var statearr_17445_17471 = state_17432__$1;
(statearr_17445_17471[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (14))){
var inst_17426 = (state_17432[(2)]);
var state_17432__$1 = state_17432;
var statearr_17446_17472 = state_17432__$1;
(statearr_17446_17472[(2)] = inst_17426);

(statearr_17446_17472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (10))){
var inst_17418 = (state_17432[(2)]);
var state_17432__$1 = state_17432;
var statearr_17447_17473 = state_17432__$1;
(statearr_17447_17473[(2)] = inst_17418);

(statearr_17447_17473[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17433 === (8))){
var inst_17415 = cljs.core.async.close_BANG_.call(null,to);
var state_17432__$1 = state_17432;
var statearr_17448_17474 = state_17432__$1;
(statearr_17448_17474[(2)] = inst_17415);

(statearr_17448_17474[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17460))
;
return ((function (switch__8250__auto__,c__8362__auto___17460){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17452 = [null,null,null,null,null,null,null,null];
(statearr_17452[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17452[(1)] = (1));

return statearr_17452;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17432){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17432);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17453){if((e17453 instanceof Object)){
var ex__8254__auto__ = e17453;
var statearr_17454_17475 = state_17432;
(statearr_17454_17475[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17432);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17453;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17476 = state_17432;
state_17432 = G__17476;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17432){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17460))
})();
var state__8364__auto__ = (function (){var statearr_17455 = f__8363__auto__.call(null);
(statearr_17455[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17460);

return statearr_17455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17460))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17660){
var vec__17661 = p__17660;
var v = cljs.core.nth.call(null,vec__17661,(0),null);
var p = cljs.core.nth.call(null,vec__17661,(1),null);
var job = vec__17661;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17843 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17843,res,vec__17661,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17843,res,vec__17661,v,p,job,jobs,results){
return (function (state_17666){
var state_val_17667 = (state_17666[(1)]);
if((state_val_17667 === (1))){
var state_17666__$1 = state_17666;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17666__$1,(2),res,v);
} else {
if((state_val_17667 === (2))){
var inst_17663 = (state_17666[(2)]);
var inst_17664 = cljs.core.async.close_BANG_.call(null,res);
var state_17666__$1 = (function (){var statearr_17668 = state_17666;
(statearr_17668[(7)] = inst_17663);

return statearr_17668;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17666__$1,inst_17664);
} else {
return null;
}
}
});})(c__8362__auto___17843,res,vec__17661,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17843,res,vec__17661,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17672 = [null,null,null,null,null,null,null,null];
(statearr_17672[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17672[(1)] = (1));

return statearr_17672;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17666){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17673){if((e17673 instanceof Object)){
var ex__8254__auto__ = e17673;
var statearr_17674_17844 = state_17666;
(statearr_17674_17844[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17666);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17673;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17845 = state_17666;
state_17666 = G__17845;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17666){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17843,res,vec__17661,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17675 = f__8363__auto__.call(null);
(statearr_17675[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17843);

return statearr_17675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17843,res,vec__17661,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17676){
var vec__17677 = p__17676;
var v = cljs.core.nth.call(null,vec__17677,(0),null);
var p = cljs.core.nth.call(null,vec__17677,(1),null);
var job = vec__17677;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17846 = n;
var __17847 = (0);
while(true){
if((__17847 < n__5571__auto___17846)){
var G__17678_17848 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17678_17848) {
case "compute":
var c__8362__auto___17850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17847,c__8362__auto___17850,G__17678_17848,n__5571__auto___17846,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17847,c__8362__auto___17850,G__17678_17848,n__5571__auto___17846,jobs,results,process,async){
return (function (state_17691){
var state_val_17692 = (state_17691[(1)]);
if((state_val_17692 === (1))){
var state_17691__$1 = state_17691;
var statearr_17693_17851 = state_17691__$1;
(statearr_17693_17851[(2)] = null);

(statearr_17693_17851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17692 === (2))){
var state_17691__$1 = state_17691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17691__$1,(4),jobs);
} else {
if((state_val_17692 === (3))){
var inst_17689 = (state_17691[(2)]);
var state_17691__$1 = state_17691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17691__$1,inst_17689);
} else {
if((state_val_17692 === (4))){
var inst_17681 = (state_17691[(2)]);
var inst_17682 = process.call(null,inst_17681);
var state_17691__$1 = state_17691;
if(cljs.core.truth_(inst_17682)){
var statearr_17694_17852 = state_17691__$1;
(statearr_17694_17852[(1)] = (5));

} else {
var statearr_17695_17853 = state_17691__$1;
(statearr_17695_17853[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17692 === (5))){
var state_17691__$1 = state_17691;
var statearr_17696_17854 = state_17691__$1;
(statearr_17696_17854[(2)] = null);

(statearr_17696_17854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17692 === (6))){
var state_17691__$1 = state_17691;
var statearr_17697_17855 = state_17691__$1;
(statearr_17697_17855[(2)] = null);

(statearr_17697_17855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17692 === (7))){
var inst_17687 = (state_17691[(2)]);
var state_17691__$1 = state_17691;
var statearr_17698_17856 = state_17691__$1;
(statearr_17698_17856[(2)] = inst_17687);

(statearr_17698_17856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17847,c__8362__auto___17850,G__17678_17848,n__5571__auto___17846,jobs,results,process,async))
;
return ((function (__17847,switch__8250__auto__,c__8362__auto___17850,G__17678_17848,n__5571__auto___17846,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17702 = [null,null,null,null,null,null,null];
(statearr_17702[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17702[(1)] = (1));

return statearr_17702;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17691){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17703){if((e17703 instanceof Object)){
var ex__8254__auto__ = e17703;
var statearr_17704_17857 = state_17691;
(statearr_17704_17857[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17703;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17858 = state_17691;
state_17691 = G__17858;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17691){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17847,switch__8250__auto__,c__8362__auto___17850,G__17678_17848,n__5571__auto___17846,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17705 = f__8363__auto__.call(null);
(statearr_17705[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17850);

return statearr_17705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17847,c__8362__auto___17850,G__17678_17848,n__5571__auto___17846,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17859 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17847,c__8362__auto___17859,G__17678_17848,n__5571__auto___17846,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17847,c__8362__auto___17859,G__17678_17848,n__5571__auto___17846,jobs,results,process,async){
return (function (state_17718){
var state_val_17719 = (state_17718[(1)]);
if((state_val_17719 === (1))){
var state_17718__$1 = state_17718;
var statearr_17720_17860 = state_17718__$1;
(statearr_17720_17860[(2)] = null);

(statearr_17720_17860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17719 === (2))){
var state_17718__$1 = state_17718;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17718__$1,(4),jobs);
} else {
if((state_val_17719 === (3))){
var inst_17716 = (state_17718[(2)]);
var state_17718__$1 = state_17718;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17718__$1,inst_17716);
} else {
if((state_val_17719 === (4))){
var inst_17708 = (state_17718[(2)]);
var inst_17709 = async.call(null,inst_17708);
var state_17718__$1 = state_17718;
if(cljs.core.truth_(inst_17709)){
var statearr_17721_17861 = state_17718__$1;
(statearr_17721_17861[(1)] = (5));

} else {
var statearr_17722_17862 = state_17718__$1;
(statearr_17722_17862[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17719 === (5))){
var state_17718__$1 = state_17718;
var statearr_17723_17863 = state_17718__$1;
(statearr_17723_17863[(2)] = null);

(statearr_17723_17863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17719 === (6))){
var state_17718__$1 = state_17718;
var statearr_17724_17864 = state_17718__$1;
(statearr_17724_17864[(2)] = null);

(statearr_17724_17864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17719 === (7))){
var inst_17714 = (state_17718[(2)]);
var state_17718__$1 = state_17718;
var statearr_17725_17865 = state_17718__$1;
(statearr_17725_17865[(2)] = inst_17714);

(statearr_17725_17865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17847,c__8362__auto___17859,G__17678_17848,n__5571__auto___17846,jobs,results,process,async))
;
return ((function (__17847,switch__8250__auto__,c__8362__auto___17859,G__17678_17848,n__5571__auto___17846,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17729 = [null,null,null,null,null,null,null];
(statearr_17729[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17729[(1)] = (1));

return statearr_17729;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17718){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17730){if((e17730 instanceof Object)){
var ex__8254__auto__ = e17730;
var statearr_17731_17866 = state_17718;
(statearr_17731_17866[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17718);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17730;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17867 = state_17718;
state_17718 = G__17867;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17718){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17847,switch__8250__auto__,c__8362__auto___17859,G__17678_17848,n__5571__auto___17846,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17732 = f__8363__auto__.call(null);
(statearr_17732[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17859);

return statearr_17732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17847,c__8362__auto___17859,G__17678_17848,n__5571__auto___17846,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17868 = (__17847 + (1));
__17847 = G__17868;
continue;
} else {
}
break;
}

var c__8362__auto___17869 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17869,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17869,jobs,results,process,async){
return (function (state_17754){
var state_val_17755 = (state_17754[(1)]);
if((state_val_17755 === (1))){
var state_17754__$1 = state_17754;
var statearr_17756_17870 = state_17754__$1;
(statearr_17756_17870[(2)] = null);

(statearr_17756_17870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17755 === (2))){
var state_17754__$1 = state_17754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17754__$1,(4),from);
} else {
if((state_val_17755 === (3))){
var inst_17752 = (state_17754[(2)]);
var state_17754__$1 = state_17754;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17754__$1,inst_17752);
} else {
if((state_val_17755 === (4))){
var inst_17735 = (state_17754[(7)]);
var inst_17735__$1 = (state_17754[(2)]);
var inst_17736 = (inst_17735__$1 == null);
var state_17754__$1 = (function (){var statearr_17757 = state_17754;
(statearr_17757[(7)] = inst_17735__$1);

return statearr_17757;
})();
if(cljs.core.truth_(inst_17736)){
var statearr_17758_17871 = state_17754__$1;
(statearr_17758_17871[(1)] = (5));

} else {
var statearr_17759_17872 = state_17754__$1;
(statearr_17759_17872[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17755 === (5))){
var inst_17738 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17754__$1 = state_17754;
var statearr_17760_17873 = state_17754__$1;
(statearr_17760_17873[(2)] = inst_17738);

(statearr_17760_17873[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17755 === (6))){
var inst_17740 = (state_17754[(8)]);
var inst_17735 = (state_17754[(7)]);
var inst_17740__$1 = cljs.core.async.chan.call(null,(1));
var inst_17741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17742 = [inst_17735,inst_17740__$1];
var inst_17743 = (new cljs.core.PersistentVector(null,2,(5),inst_17741,inst_17742,null));
var state_17754__$1 = (function (){var statearr_17761 = state_17754;
(statearr_17761[(8)] = inst_17740__$1);

return statearr_17761;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17754__$1,(8),jobs,inst_17743);
} else {
if((state_val_17755 === (7))){
var inst_17750 = (state_17754[(2)]);
var state_17754__$1 = state_17754;
var statearr_17762_17874 = state_17754__$1;
(statearr_17762_17874[(2)] = inst_17750);

(statearr_17762_17874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17755 === (8))){
var inst_17740 = (state_17754[(8)]);
var inst_17745 = (state_17754[(2)]);
var state_17754__$1 = (function (){var statearr_17763 = state_17754;
(statearr_17763[(9)] = inst_17745);

return statearr_17763;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17754__$1,(9),results,inst_17740);
} else {
if((state_val_17755 === (9))){
var inst_17747 = (state_17754[(2)]);
var state_17754__$1 = (function (){var statearr_17764 = state_17754;
(statearr_17764[(10)] = inst_17747);

return statearr_17764;
})();
var statearr_17765_17875 = state_17754__$1;
(statearr_17765_17875[(2)] = null);

(statearr_17765_17875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17869,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17869,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17769 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17769[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17769[(1)] = (1));

return statearr_17769;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17754){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17770){if((e17770 instanceof Object)){
var ex__8254__auto__ = e17770;
var statearr_17771_17876 = state_17754;
(statearr_17771_17876[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17754);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17770;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17877 = state_17754;
state_17754 = G__17877;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17754){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17869,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17772 = f__8363__auto__.call(null);
(statearr_17772[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17869);

return statearr_17772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17869,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17810){
var state_val_17811 = (state_17810[(1)]);
if((state_val_17811 === (7))){
var inst_17806 = (state_17810[(2)]);
var state_17810__$1 = state_17810;
var statearr_17812_17878 = state_17810__$1;
(statearr_17812_17878[(2)] = inst_17806);

(statearr_17812_17878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (20))){
var state_17810__$1 = state_17810;
var statearr_17813_17879 = state_17810__$1;
(statearr_17813_17879[(2)] = null);

(statearr_17813_17879[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (1))){
var state_17810__$1 = state_17810;
var statearr_17814_17880 = state_17810__$1;
(statearr_17814_17880[(2)] = null);

(statearr_17814_17880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (4))){
var inst_17775 = (state_17810[(7)]);
var inst_17775__$1 = (state_17810[(2)]);
var inst_17776 = (inst_17775__$1 == null);
var state_17810__$1 = (function (){var statearr_17815 = state_17810;
(statearr_17815[(7)] = inst_17775__$1);

return statearr_17815;
})();
if(cljs.core.truth_(inst_17776)){
var statearr_17816_17881 = state_17810__$1;
(statearr_17816_17881[(1)] = (5));

} else {
var statearr_17817_17882 = state_17810__$1;
(statearr_17817_17882[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (15))){
var inst_17788 = (state_17810[(8)]);
var state_17810__$1 = state_17810;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17810__$1,(18),to,inst_17788);
} else {
if((state_val_17811 === (21))){
var inst_17801 = (state_17810[(2)]);
var state_17810__$1 = state_17810;
var statearr_17818_17883 = state_17810__$1;
(statearr_17818_17883[(2)] = inst_17801);

(statearr_17818_17883[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (13))){
var inst_17803 = (state_17810[(2)]);
var state_17810__$1 = (function (){var statearr_17819 = state_17810;
(statearr_17819[(9)] = inst_17803);

return statearr_17819;
})();
var statearr_17820_17884 = state_17810__$1;
(statearr_17820_17884[(2)] = null);

(statearr_17820_17884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (6))){
var inst_17775 = (state_17810[(7)]);
var state_17810__$1 = state_17810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17810__$1,(11),inst_17775);
} else {
if((state_val_17811 === (17))){
var inst_17796 = (state_17810[(2)]);
var state_17810__$1 = state_17810;
if(cljs.core.truth_(inst_17796)){
var statearr_17821_17885 = state_17810__$1;
(statearr_17821_17885[(1)] = (19));

} else {
var statearr_17822_17886 = state_17810__$1;
(statearr_17822_17886[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (3))){
var inst_17808 = (state_17810[(2)]);
var state_17810__$1 = state_17810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17810__$1,inst_17808);
} else {
if((state_val_17811 === (12))){
var inst_17785 = (state_17810[(10)]);
var state_17810__$1 = state_17810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17810__$1,(14),inst_17785);
} else {
if((state_val_17811 === (2))){
var state_17810__$1 = state_17810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17810__$1,(4),results);
} else {
if((state_val_17811 === (19))){
var state_17810__$1 = state_17810;
var statearr_17823_17887 = state_17810__$1;
(statearr_17823_17887[(2)] = null);

(statearr_17823_17887[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (11))){
var inst_17785 = (state_17810[(2)]);
var state_17810__$1 = (function (){var statearr_17824 = state_17810;
(statearr_17824[(10)] = inst_17785);

return statearr_17824;
})();
var statearr_17825_17888 = state_17810__$1;
(statearr_17825_17888[(2)] = null);

(statearr_17825_17888[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (9))){
var state_17810__$1 = state_17810;
var statearr_17826_17889 = state_17810__$1;
(statearr_17826_17889[(2)] = null);

(statearr_17826_17889[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (5))){
var state_17810__$1 = state_17810;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17827_17890 = state_17810__$1;
(statearr_17827_17890[(1)] = (8));

} else {
var statearr_17828_17891 = state_17810__$1;
(statearr_17828_17891[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (14))){
var inst_17790 = (state_17810[(11)]);
var inst_17788 = (state_17810[(8)]);
var inst_17788__$1 = (state_17810[(2)]);
var inst_17789 = (inst_17788__$1 == null);
var inst_17790__$1 = cljs.core.not.call(null,inst_17789);
var state_17810__$1 = (function (){var statearr_17829 = state_17810;
(statearr_17829[(11)] = inst_17790__$1);

(statearr_17829[(8)] = inst_17788__$1);

return statearr_17829;
})();
if(inst_17790__$1){
var statearr_17830_17892 = state_17810__$1;
(statearr_17830_17892[(1)] = (15));

} else {
var statearr_17831_17893 = state_17810__$1;
(statearr_17831_17893[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (16))){
var inst_17790 = (state_17810[(11)]);
var state_17810__$1 = state_17810;
var statearr_17832_17894 = state_17810__$1;
(statearr_17832_17894[(2)] = inst_17790);

(statearr_17832_17894[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (10))){
var inst_17782 = (state_17810[(2)]);
var state_17810__$1 = state_17810;
var statearr_17833_17895 = state_17810__$1;
(statearr_17833_17895[(2)] = inst_17782);

(statearr_17833_17895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (18))){
var inst_17793 = (state_17810[(2)]);
var state_17810__$1 = state_17810;
var statearr_17834_17896 = state_17810__$1;
(statearr_17834_17896[(2)] = inst_17793);

(statearr_17834_17896[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (8))){
var inst_17779 = cljs.core.async.close_BANG_.call(null,to);
var state_17810__$1 = state_17810;
var statearr_17835_17897 = state_17810__$1;
(statearr_17835_17897[(2)] = inst_17779);

(statearr_17835_17897[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17839 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17839[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17839[(1)] = (1));

return statearr_17839;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17810){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17840){if((e17840 instanceof Object)){
var ex__8254__auto__ = e17840;
var statearr_17841_17898 = state_17810;
(statearr_17841_17898[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17810);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17840;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17899 = state_17810;
state_17810 = G__17899;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17810){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17842 = f__8363__auto__.call(null);
(statearr_17842[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17900 = [];
var len__5726__auto___17903 = arguments.length;
var i__5727__auto___17904 = (0);
while(true){
if((i__5727__auto___17904 < len__5726__auto___17903)){
args17900.push((arguments[i__5727__auto___17904]));

var G__17905 = (i__5727__auto___17904 + (1));
i__5727__auto___17904 = G__17905;
continue;
} else {
}
break;
}

var G__17902 = args17900.length;
switch (G__17902) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17900.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17907 = [];
var len__5726__auto___17910 = arguments.length;
var i__5727__auto___17911 = (0);
while(true){
if((i__5727__auto___17911 < len__5726__auto___17910)){
args17907.push((arguments[i__5727__auto___17911]));

var G__17912 = (i__5727__auto___17911 + (1));
i__5727__auto___17911 = G__17912;
continue;
} else {
}
break;
}

var G__17909 = args17907.length;
switch (G__17909) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17907.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17914 = [];
var len__5726__auto___17967 = arguments.length;
var i__5727__auto___17968 = (0);
while(true){
if((i__5727__auto___17968 < len__5726__auto___17967)){
args17914.push((arguments[i__5727__auto___17968]));

var G__17969 = (i__5727__auto___17968 + (1));
i__5727__auto___17968 = G__17969;
continue;
} else {
}
break;
}

var G__17916 = args17914.length;
switch (G__17916) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17914.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17971 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17971,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17971,tc,fc){
return (function (state_17942){
var state_val_17943 = (state_17942[(1)]);
if((state_val_17943 === (7))){
var inst_17938 = (state_17942[(2)]);
var state_17942__$1 = state_17942;
var statearr_17944_17972 = state_17942__$1;
(statearr_17944_17972[(2)] = inst_17938);

(statearr_17944_17972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (1))){
var state_17942__$1 = state_17942;
var statearr_17945_17973 = state_17942__$1;
(statearr_17945_17973[(2)] = null);

(statearr_17945_17973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (4))){
var inst_17919 = (state_17942[(7)]);
var inst_17919__$1 = (state_17942[(2)]);
var inst_17920 = (inst_17919__$1 == null);
var state_17942__$1 = (function (){var statearr_17946 = state_17942;
(statearr_17946[(7)] = inst_17919__$1);

return statearr_17946;
})();
if(cljs.core.truth_(inst_17920)){
var statearr_17947_17974 = state_17942__$1;
(statearr_17947_17974[(1)] = (5));

} else {
var statearr_17948_17975 = state_17942__$1;
(statearr_17948_17975[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (13))){
var state_17942__$1 = state_17942;
var statearr_17949_17976 = state_17942__$1;
(statearr_17949_17976[(2)] = null);

(statearr_17949_17976[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (6))){
var inst_17919 = (state_17942[(7)]);
var inst_17925 = p.call(null,inst_17919);
var state_17942__$1 = state_17942;
if(cljs.core.truth_(inst_17925)){
var statearr_17950_17977 = state_17942__$1;
(statearr_17950_17977[(1)] = (9));

} else {
var statearr_17951_17978 = state_17942__$1;
(statearr_17951_17978[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (3))){
var inst_17940 = (state_17942[(2)]);
var state_17942__$1 = state_17942;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17942__$1,inst_17940);
} else {
if((state_val_17943 === (12))){
var state_17942__$1 = state_17942;
var statearr_17952_17979 = state_17942__$1;
(statearr_17952_17979[(2)] = null);

(statearr_17952_17979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (2))){
var state_17942__$1 = state_17942;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17942__$1,(4),ch);
} else {
if((state_val_17943 === (11))){
var inst_17919 = (state_17942[(7)]);
var inst_17929 = (state_17942[(2)]);
var state_17942__$1 = state_17942;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17942__$1,(8),inst_17929,inst_17919);
} else {
if((state_val_17943 === (9))){
var state_17942__$1 = state_17942;
var statearr_17953_17980 = state_17942__$1;
(statearr_17953_17980[(2)] = tc);

(statearr_17953_17980[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (5))){
var inst_17922 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17923 = cljs.core.async.close_BANG_.call(null,fc);
var state_17942__$1 = (function (){var statearr_17954 = state_17942;
(statearr_17954[(8)] = inst_17922);

return statearr_17954;
})();
var statearr_17955_17981 = state_17942__$1;
(statearr_17955_17981[(2)] = inst_17923);

(statearr_17955_17981[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (14))){
var inst_17936 = (state_17942[(2)]);
var state_17942__$1 = state_17942;
var statearr_17956_17982 = state_17942__$1;
(statearr_17956_17982[(2)] = inst_17936);

(statearr_17956_17982[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (10))){
var state_17942__$1 = state_17942;
var statearr_17957_17983 = state_17942__$1;
(statearr_17957_17983[(2)] = fc);

(statearr_17957_17983[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17943 === (8))){
var inst_17931 = (state_17942[(2)]);
var state_17942__$1 = state_17942;
if(cljs.core.truth_(inst_17931)){
var statearr_17958_17984 = state_17942__$1;
(statearr_17958_17984[(1)] = (12));

} else {
var statearr_17959_17985 = state_17942__$1;
(statearr_17959_17985[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17971,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17971,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17963 = [null,null,null,null,null,null,null,null,null];
(statearr_17963[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17963[(1)] = (1));

return statearr_17963;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17942){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17964){if((e17964 instanceof Object)){
var ex__8254__auto__ = e17964;
var statearr_17965_17986 = state_17942;
(statearr_17965_17986[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17942);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17964;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17987 = state_17942;
state_17942 = G__17987;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17942){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17971,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17966 = f__8363__auto__.call(null);
(statearr_17966[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17971);

return statearr_17966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17971,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18051){
var state_val_18052 = (state_18051[(1)]);
if((state_val_18052 === (7))){
var inst_18047 = (state_18051[(2)]);
var state_18051__$1 = state_18051;
var statearr_18053_18074 = state_18051__$1;
(statearr_18053_18074[(2)] = inst_18047);

(statearr_18053_18074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18052 === (1))){
var inst_18031 = init;
var state_18051__$1 = (function (){var statearr_18054 = state_18051;
(statearr_18054[(7)] = inst_18031);

return statearr_18054;
})();
var statearr_18055_18075 = state_18051__$1;
(statearr_18055_18075[(2)] = null);

(statearr_18055_18075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18052 === (4))){
var inst_18034 = (state_18051[(8)]);
var inst_18034__$1 = (state_18051[(2)]);
var inst_18035 = (inst_18034__$1 == null);
var state_18051__$1 = (function (){var statearr_18056 = state_18051;
(statearr_18056[(8)] = inst_18034__$1);

return statearr_18056;
})();
if(cljs.core.truth_(inst_18035)){
var statearr_18057_18076 = state_18051__$1;
(statearr_18057_18076[(1)] = (5));

} else {
var statearr_18058_18077 = state_18051__$1;
(statearr_18058_18077[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18052 === (6))){
var inst_18031 = (state_18051[(7)]);
var inst_18034 = (state_18051[(8)]);
var inst_18038 = (state_18051[(9)]);
var inst_18038__$1 = f.call(null,inst_18031,inst_18034);
var inst_18039 = cljs.core.reduced_QMARK_.call(null,inst_18038__$1);
var state_18051__$1 = (function (){var statearr_18059 = state_18051;
(statearr_18059[(9)] = inst_18038__$1);

return statearr_18059;
})();
if(inst_18039){
var statearr_18060_18078 = state_18051__$1;
(statearr_18060_18078[(1)] = (8));

} else {
var statearr_18061_18079 = state_18051__$1;
(statearr_18061_18079[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18052 === (3))){
var inst_18049 = (state_18051[(2)]);
var state_18051__$1 = state_18051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18051__$1,inst_18049);
} else {
if((state_val_18052 === (2))){
var state_18051__$1 = state_18051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18051__$1,(4),ch);
} else {
if((state_val_18052 === (9))){
var inst_18038 = (state_18051[(9)]);
var inst_18031 = inst_18038;
var state_18051__$1 = (function (){var statearr_18062 = state_18051;
(statearr_18062[(7)] = inst_18031);

return statearr_18062;
})();
var statearr_18063_18080 = state_18051__$1;
(statearr_18063_18080[(2)] = null);

(statearr_18063_18080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18052 === (5))){
var inst_18031 = (state_18051[(7)]);
var state_18051__$1 = state_18051;
var statearr_18064_18081 = state_18051__$1;
(statearr_18064_18081[(2)] = inst_18031);

(statearr_18064_18081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18052 === (10))){
var inst_18045 = (state_18051[(2)]);
var state_18051__$1 = state_18051;
var statearr_18065_18082 = state_18051__$1;
(statearr_18065_18082[(2)] = inst_18045);

(statearr_18065_18082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18052 === (8))){
var inst_18038 = (state_18051[(9)]);
var inst_18041 = cljs.core.deref.call(null,inst_18038);
var state_18051__$1 = state_18051;
var statearr_18066_18083 = state_18051__$1;
(statearr_18066_18083[(2)] = inst_18041);

(statearr_18066_18083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18070 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18070[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18070[(1)] = (1));

return statearr_18070;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18051){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18071){if((e18071 instanceof Object)){
var ex__8254__auto__ = e18071;
var statearr_18072_18084 = state_18051;
(statearr_18072_18084[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18051);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18071;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18085 = state_18051;
state_18051 = G__18085;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18051){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18073 = f__8363__auto__.call(null);
(statearr_18073[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18086 = [];
var len__5726__auto___18138 = arguments.length;
var i__5727__auto___18139 = (0);
while(true){
if((i__5727__auto___18139 < len__5726__auto___18138)){
args18086.push((arguments[i__5727__auto___18139]));

var G__18140 = (i__5727__auto___18139 + (1));
i__5727__auto___18139 = G__18140;
continue;
} else {
}
break;
}

var G__18088 = args18086.length;
switch (G__18088) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18086.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18113){
var state_val_18114 = (state_18113[(1)]);
if((state_val_18114 === (7))){
var inst_18095 = (state_18113[(2)]);
var state_18113__$1 = state_18113;
var statearr_18115_18142 = state_18113__$1;
(statearr_18115_18142[(2)] = inst_18095);

(statearr_18115_18142[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (1))){
var inst_18089 = cljs.core.seq.call(null,coll);
var inst_18090 = inst_18089;
var state_18113__$1 = (function (){var statearr_18116 = state_18113;
(statearr_18116[(7)] = inst_18090);

return statearr_18116;
})();
var statearr_18117_18143 = state_18113__$1;
(statearr_18117_18143[(2)] = null);

(statearr_18117_18143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (4))){
var inst_18090 = (state_18113[(7)]);
var inst_18093 = cljs.core.first.call(null,inst_18090);
var state_18113__$1 = state_18113;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18113__$1,(7),ch,inst_18093);
} else {
if((state_val_18114 === (13))){
var inst_18107 = (state_18113[(2)]);
var state_18113__$1 = state_18113;
var statearr_18118_18144 = state_18113__$1;
(statearr_18118_18144[(2)] = inst_18107);

(statearr_18118_18144[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (6))){
var inst_18098 = (state_18113[(2)]);
var state_18113__$1 = state_18113;
if(cljs.core.truth_(inst_18098)){
var statearr_18119_18145 = state_18113__$1;
(statearr_18119_18145[(1)] = (8));

} else {
var statearr_18120_18146 = state_18113__$1;
(statearr_18120_18146[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (3))){
var inst_18111 = (state_18113[(2)]);
var state_18113__$1 = state_18113;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18113__$1,inst_18111);
} else {
if((state_val_18114 === (12))){
var state_18113__$1 = state_18113;
var statearr_18121_18147 = state_18113__$1;
(statearr_18121_18147[(2)] = null);

(statearr_18121_18147[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (2))){
var inst_18090 = (state_18113[(7)]);
var state_18113__$1 = state_18113;
if(cljs.core.truth_(inst_18090)){
var statearr_18122_18148 = state_18113__$1;
(statearr_18122_18148[(1)] = (4));

} else {
var statearr_18123_18149 = state_18113__$1;
(statearr_18123_18149[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (11))){
var inst_18104 = cljs.core.async.close_BANG_.call(null,ch);
var state_18113__$1 = state_18113;
var statearr_18124_18150 = state_18113__$1;
(statearr_18124_18150[(2)] = inst_18104);

(statearr_18124_18150[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (9))){
var state_18113__$1 = state_18113;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18125_18151 = state_18113__$1;
(statearr_18125_18151[(1)] = (11));

} else {
var statearr_18126_18152 = state_18113__$1;
(statearr_18126_18152[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (5))){
var inst_18090 = (state_18113[(7)]);
var state_18113__$1 = state_18113;
var statearr_18127_18153 = state_18113__$1;
(statearr_18127_18153[(2)] = inst_18090);

(statearr_18127_18153[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (10))){
var inst_18109 = (state_18113[(2)]);
var state_18113__$1 = state_18113;
var statearr_18128_18154 = state_18113__$1;
(statearr_18128_18154[(2)] = inst_18109);

(statearr_18128_18154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18114 === (8))){
var inst_18090 = (state_18113[(7)]);
var inst_18100 = cljs.core.next.call(null,inst_18090);
var inst_18090__$1 = inst_18100;
var state_18113__$1 = (function (){var statearr_18129 = state_18113;
(statearr_18129[(7)] = inst_18090__$1);

return statearr_18129;
})();
var statearr_18130_18155 = state_18113__$1;
(statearr_18130_18155[(2)] = null);

(statearr_18130_18155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18134 = [null,null,null,null,null,null,null,null];
(statearr_18134[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18134[(1)] = (1));

return statearr_18134;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18113){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18135){if((e18135 instanceof Object)){
var ex__8254__auto__ = e18135;
var statearr_18136_18156 = state_18113;
(statearr_18136_18156[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18113);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18135;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18157 = state_18113;
state_18113 = G__18157;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18113){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18137 = f__8363__auto__.call(null);
(statearr_18137[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18379 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18379 = (function (mult,ch,cs,meta18380){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18380 = meta18380;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18381,meta18380__$1){
var self__ = this;
var _18381__$1 = this;
return (new cljs.core.async.t_cljs$core$async18379(self__.mult,self__.ch,self__.cs,meta18380__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18381){
var self__ = this;
var _18381__$1 = this;
return self__.meta18380;
});})(cs))
;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18379.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18380","meta18380",579179476,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18379.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18379.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18379";

cljs.core.async.t_cljs$core$async18379.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18379");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18379 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18379(mult__$1,ch__$1,cs__$1,meta18380){
return (new cljs.core.async.t_cljs$core$async18379(mult__$1,ch__$1,cs__$1,meta18380));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18379(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18600 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18600,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18600,cs,m,dchan,dctr,done){
return (function (state_18512){
var state_val_18513 = (state_18512[(1)]);
if((state_val_18513 === (7))){
var inst_18508 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18514_18601 = state_18512__$1;
(statearr_18514_18601[(2)] = inst_18508);

(statearr_18514_18601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (20))){
var inst_18413 = (state_18512[(7)]);
var inst_18423 = cljs.core.first.call(null,inst_18413);
var inst_18424 = cljs.core.nth.call(null,inst_18423,(0),null);
var inst_18425 = cljs.core.nth.call(null,inst_18423,(1),null);
var state_18512__$1 = (function (){var statearr_18515 = state_18512;
(statearr_18515[(8)] = inst_18424);

return statearr_18515;
})();
if(cljs.core.truth_(inst_18425)){
var statearr_18516_18602 = state_18512__$1;
(statearr_18516_18602[(1)] = (22));

} else {
var statearr_18517_18603 = state_18512__$1;
(statearr_18517_18603[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (27))){
var inst_18453 = (state_18512[(9)]);
var inst_18455 = (state_18512[(10)]);
var inst_18460 = (state_18512[(11)]);
var inst_18384 = (state_18512[(12)]);
var inst_18460__$1 = cljs.core._nth.call(null,inst_18453,inst_18455);
var inst_18461 = cljs.core.async.put_BANG_.call(null,inst_18460__$1,inst_18384,done);
var state_18512__$1 = (function (){var statearr_18518 = state_18512;
(statearr_18518[(11)] = inst_18460__$1);

return statearr_18518;
})();
if(cljs.core.truth_(inst_18461)){
var statearr_18519_18604 = state_18512__$1;
(statearr_18519_18604[(1)] = (30));

} else {
var statearr_18520_18605 = state_18512__$1;
(statearr_18520_18605[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (1))){
var state_18512__$1 = state_18512;
var statearr_18521_18606 = state_18512__$1;
(statearr_18521_18606[(2)] = null);

(statearr_18521_18606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (24))){
var inst_18413 = (state_18512[(7)]);
var inst_18430 = (state_18512[(2)]);
var inst_18431 = cljs.core.next.call(null,inst_18413);
var inst_18393 = inst_18431;
var inst_18394 = null;
var inst_18395 = (0);
var inst_18396 = (0);
var state_18512__$1 = (function (){var statearr_18522 = state_18512;
(statearr_18522[(13)] = inst_18396);

(statearr_18522[(14)] = inst_18393);

(statearr_18522[(15)] = inst_18430);

(statearr_18522[(16)] = inst_18395);

(statearr_18522[(17)] = inst_18394);

return statearr_18522;
})();
var statearr_18523_18607 = state_18512__$1;
(statearr_18523_18607[(2)] = null);

(statearr_18523_18607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (39))){
var state_18512__$1 = state_18512;
var statearr_18527_18608 = state_18512__$1;
(statearr_18527_18608[(2)] = null);

(statearr_18527_18608[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (4))){
var inst_18384 = (state_18512[(12)]);
var inst_18384__$1 = (state_18512[(2)]);
var inst_18385 = (inst_18384__$1 == null);
var state_18512__$1 = (function (){var statearr_18528 = state_18512;
(statearr_18528[(12)] = inst_18384__$1);

return statearr_18528;
})();
if(cljs.core.truth_(inst_18385)){
var statearr_18529_18609 = state_18512__$1;
(statearr_18529_18609[(1)] = (5));

} else {
var statearr_18530_18610 = state_18512__$1;
(statearr_18530_18610[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (15))){
var inst_18396 = (state_18512[(13)]);
var inst_18393 = (state_18512[(14)]);
var inst_18395 = (state_18512[(16)]);
var inst_18394 = (state_18512[(17)]);
var inst_18409 = (state_18512[(2)]);
var inst_18410 = (inst_18396 + (1));
var tmp18524 = inst_18393;
var tmp18525 = inst_18395;
var tmp18526 = inst_18394;
var inst_18393__$1 = tmp18524;
var inst_18394__$1 = tmp18526;
var inst_18395__$1 = tmp18525;
var inst_18396__$1 = inst_18410;
var state_18512__$1 = (function (){var statearr_18531 = state_18512;
(statearr_18531[(13)] = inst_18396__$1);

(statearr_18531[(14)] = inst_18393__$1);

(statearr_18531[(16)] = inst_18395__$1);

(statearr_18531[(18)] = inst_18409);

(statearr_18531[(17)] = inst_18394__$1);

return statearr_18531;
})();
var statearr_18532_18611 = state_18512__$1;
(statearr_18532_18611[(2)] = null);

(statearr_18532_18611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (21))){
var inst_18434 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18536_18612 = state_18512__$1;
(statearr_18536_18612[(2)] = inst_18434);

(statearr_18536_18612[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (31))){
var inst_18460 = (state_18512[(11)]);
var inst_18464 = done.call(null,null);
var inst_18465 = cljs.core.async.untap_STAR_.call(null,m,inst_18460);
var state_18512__$1 = (function (){var statearr_18537 = state_18512;
(statearr_18537[(19)] = inst_18464);

return statearr_18537;
})();
var statearr_18538_18613 = state_18512__$1;
(statearr_18538_18613[(2)] = inst_18465);

(statearr_18538_18613[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (32))){
var inst_18452 = (state_18512[(20)]);
var inst_18453 = (state_18512[(9)]);
var inst_18455 = (state_18512[(10)]);
var inst_18454 = (state_18512[(21)]);
var inst_18467 = (state_18512[(2)]);
var inst_18468 = (inst_18455 + (1));
var tmp18533 = inst_18452;
var tmp18534 = inst_18453;
var tmp18535 = inst_18454;
var inst_18452__$1 = tmp18533;
var inst_18453__$1 = tmp18534;
var inst_18454__$1 = tmp18535;
var inst_18455__$1 = inst_18468;
var state_18512__$1 = (function (){var statearr_18539 = state_18512;
(statearr_18539[(20)] = inst_18452__$1);

(statearr_18539[(9)] = inst_18453__$1);

(statearr_18539[(10)] = inst_18455__$1);

(statearr_18539[(22)] = inst_18467);

(statearr_18539[(21)] = inst_18454__$1);

return statearr_18539;
})();
var statearr_18540_18614 = state_18512__$1;
(statearr_18540_18614[(2)] = null);

(statearr_18540_18614[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (40))){
var inst_18480 = (state_18512[(23)]);
var inst_18484 = done.call(null,null);
var inst_18485 = cljs.core.async.untap_STAR_.call(null,m,inst_18480);
var state_18512__$1 = (function (){var statearr_18541 = state_18512;
(statearr_18541[(24)] = inst_18484);

return statearr_18541;
})();
var statearr_18542_18615 = state_18512__$1;
(statearr_18542_18615[(2)] = inst_18485);

(statearr_18542_18615[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (33))){
var inst_18471 = (state_18512[(25)]);
var inst_18473 = cljs.core.chunked_seq_QMARK_.call(null,inst_18471);
var state_18512__$1 = state_18512;
if(inst_18473){
var statearr_18543_18616 = state_18512__$1;
(statearr_18543_18616[(1)] = (36));

} else {
var statearr_18544_18617 = state_18512__$1;
(statearr_18544_18617[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (13))){
var inst_18403 = (state_18512[(26)]);
var inst_18406 = cljs.core.async.close_BANG_.call(null,inst_18403);
var state_18512__$1 = state_18512;
var statearr_18545_18618 = state_18512__$1;
(statearr_18545_18618[(2)] = inst_18406);

(statearr_18545_18618[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (22))){
var inst_18424 = (state_18512[(8)]);
var inst_18427 = cljs.core.async.close_BANG_.call(null,inst_18424);
var state_18512__$1 = state_18512;
var statearr_18546_18619 = state_18512__$1;
(statearr_18546_18619[(2)] = inst_18427);

(statearr_18546_18619[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (36))){
var inst_18471 = (state_18512[(25)]);
var inst_18475 = cljs.core.chunk_first.call(null,inst_18471);
var inst_18476 = cljs.core.chunk_rest.call(null,inst_18471);
var inst_18477 = cljs.core.count.call(null,inst_18475);
var inst_18452 = inst_18476;
var inst_18453 = inst_18475;
var inst_18454 = inst_18477;
var inst_18455 = (0);
var state_18512__$1 = (function (){var statearr_18547 = state_18512;
(statearr_18547[(20)] = inst_18452);

(statearr_18547[(9)] = inst_18453);

(statearr_18547[(10)] = inst_18455);

(statearr_18547[(21)] = inst_18454);

return statearr_18547;
})();
var statearr_18548_18620 = state_18512__$1;
(statearr_18548_18620[(2)] = null);

(statearr_18548_18620[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (41))){
var inst_18471 = (state_18512[(25)]);
var inst_18487 = (state_18512[(2)]);
var inst_18488 = cljs.core.next.call(null,inst_18471);
var inst_18452 = inst_18488;
var inst_18453 = null;
var inst_18454 = (0);
var inst_18455 = (0);
var state_18512__$1 = (function (){var statearr_18549 = state_18512;
(statearr_18549[(27)] = inst_18487);

(statearr_18549[(20)] = inst_18452);

(statearr_18549[(9)] = inst_18453);

(statearr_18549[(10)] = inst_18455);

(statearr_18549[(21)] = inst_18454);

return statearr_18549;
})();
var statearr_18550_18621 = state_18512__$1;
(statearr_18550_18621[(2)] = null);

(statearr_18550_18621[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (43))){
var state_18512__$1 = state_18512;
var statearr_18551_18622 = state_18512__$1;
(statearr_18551_18622[(2)] = null);

(statearr_18551_18622[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (29))){
var inst_18496 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18552_18623 = state_18512__$1;
(statearr_18552_18623[(2)] = inst_18496);

(statearr_18552_18623[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (44))){
var inst_18505 = (state_18512[(2)]);
var state_18512__$1 = (function (){var statearr_18553 = state_18512;
(statearr_18553[(28)] = inst_18505);

return statearr_18553;
})();
var statearr_18554_18624 = state_18512__$1;
(statearr_18554_18624[(2)] = null);

(statearr_18554_18624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (6))){
var inst_18444 = (state_18512[(29)]);
var inst_18443 = cljs.core.deref.call(null,cs);
var inst_18444__$1 = cljs.core.keys.call(null,inst_18443);
var inst_18445 = cljs.core.count.call(null,inst_18444__$1);
var inst_18446 = cljs.core.reset_BANG_.call(null,dctr,inst_18445);
var inst_18451 = cljs.core.seq.call(null,inst_18444__$1);
var inst_18452 = inst_18451;
var inst_18453 = null;
var inst_18454 = (0);
var inst_18455 = (0);
var state_18512__$1 = (function (){var statearr_18555 = state_18512;
(statearr_18555[(20)] = inst_18452);

(statearr_18555[(30)] = inst_18446);

(statearr_18555[(9)] = inst_18453);

(statearr_18555[(29)] = inst_18444__$1);

(statearr_18555[(10)] = inst_18455);

(statearr_18555[(21)] = inst_18454);

return statearr_18555;
})();
var statearr_18556_18625 = state_18512__$1;
(statearr_18556_18625[(2)] = null);

(statearr_18556_18625[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (28))){
var inst_18452 = (state_18512[(20)]);
var inst_18471 = (state_18512[(25)]);
var inst_18471__$1 = cljs.core.seq.call(null,inst_18452);
var state_18512__$1 = (function (){var statearr_18557 = state_18512;
(statearr_18557[(25)] = inst_18471__$1);

return statearr_18557;
})();
if(inst_18471__$1){
var statearr_18558_18626 = state_18512__$1;
(statearr_18558_18626[(1)] = (33));

} else {
var statearr_18559_18627 = state_18512__$1;
(statearr_18559_18627[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (25))){
var inst_18455 = (state_18512[(10)]);
var inst_18454 = (state_18512[(21)]);
var inst_18457 = (inst_18455 < inst_18454);
var inst_18458 = inst_18457;
var state_18512__$1 = state_18512;
if(cljs.core.truth_(inst_18458)){
var statearr_18560_18628 = state_18512__$1;
(statearr_18560_18628[(1)] = (27));

} else {
var statearr_18561_18629 = state_18512__$1;
(statearr_18561_18629[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (34))){
var state_18512__$1 = state_18512;
var statearr_18562_18630 = state_18512__$1;
(statearr_18562_18630[(2)] = null);

(statearr_18562_18630[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (17))){
var state_18512__$1 = state_18512;
var statearr_18563_18631 = state_18512__$1;
(statearr_18563_18631[(2)] = null);

(statearr_18563_18631[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (3))){
var inst_18510 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18512__$1,inst_18510);
} else {
if((state_val_18513 === (12))){
var inst_18439 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18564_18632 = state_18512__$1;
(statearr_18564_18632[(2)] = inst_18439);

(statearr_18564_18632[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (2))){
var state_18512__$1 = state_18512;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18512__$1,(4),ch);
} else {
if((state_val_18513 === (23))){
var state_18512__$1 = state_18512;
var statearr_18565_18633 = state_18512__$1;
(statearr_18565_18633[(2)] = null);

(statearr_18565_18633[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (35))){
var inst_18494 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18566_18634 = state_18512__$1;
(statearr_18566_18634[(2)] = inst_18494);

(statearr_18566_18634[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (19))){
var inst_18413 = (state_18512[(7)]);
var inst_18417 = cljs.core.chunk_first.call(null,inst_18413);
var inst_18418 = cljs.core.chunk_rest.call(null,inst_18413);
var inst_18419 = cljs.core.count.call(null,inst_18417);
var inst_18393 = inst_18418;
var inst_18394 = inst_18417;
var inst_18395 = inst_18419;
var inst_18396 = (0);
var state_18512__$1 = (function (){var statearr_18567 = state_18512;
(statearr_18567[(13)] = inst_18396);

(statearr_18567[(14)] = inst_18393);

(statearr_18567[(16)] = inst_18395);

(statearr_18567[(17)] = inst_18394);

return statearr_18567;
})();
var statearr_18568_18635 = state_18512__$1;
(statearr_18568_18635[(2)] = null);

(statearr_18568_18635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (11))){
var inst_18393 = (state_18512[(14)]);
var inst_18413 = (state_18512[(7)]);
var inst_18413__$1 = cljs.core.seq.call(null,inst_18393);
var state_18512__$1 = (function (){var statearr_18569 = state_18512;
(statearr_18569[(7)] = inst_18413__$1);

return statearr_18569;
})();
if(inst_18413__$1){
var statearr_18570_18636 = state_18512__$1;
(statearr_18570_18636[(1)] = (16));

} else {
var statearr_18571_18637 = state_18512__$1;
(statearr_18571_18637[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (9))){
var inst_18441 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18572_18638 = state_18512__$1;
(statearr_18572_18638[(2)] = inst_18441);

(statearr_18572_18638[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (5))){
var inst_18391 = cljs.core.deref.call(null,cs);
var inst_18392 = cljs.core.seq.call(null,inst_18391);
var inst_18393 = inst_18392;
var inst_18394 = null;
var inst_18395 = (0);
var inst_18396 = (0);
var state_18512__$1 = (function (){var statearr_18573 = state_18512;
(statearr_18573[(13)] = inst_18396);

(statearr_18573[(14)] = inst_18393);

(statearr_18573[(16)] = inst_18395);

(statearr_18573[(17)] = inst_18394);

return statearr_18573;
})();
var statearr_18574_18639 = state_18512__$1;
(statearr_18574_18639[(2)] = null);

(statearr_18574_18639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (14))){
var state_18512__$1 = state_18512;
var statearr_18575_18640 = state_18512__$1;
(statearr_18575_18640[(2)] = null);

(statearr_18575_18640[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (45))){
var inst_18502 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18576_18641 = state_18512__$1;
(statearr_18576_18641[(2)] = inst_18502);

(statearr_18576_18641[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (26))){
var inst_18444 = (state_18512[(29)]);
var inst_18498 = (state_18512[(2)]);
var inst_18499 = cljs.core.seq.call(null,inst_18444);
var state_18512__$1 = (function (){var statearr_18577 = state_18512;
(statearr_18577[(31)] = inst_18498);

return statearr_18577;
})();
if(inst_18499){
var statearr_18578_18642 = state_18512__$1;
(statearr_18578_18642[(1)] = (42));

} else {
var statearr_18579_18643 = state_18512__$1;
(statearr_18579_18643[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (16))){
var inst_18413 = (state_18512[(7)]);
var inst_18415 = cljs.core.chunked_seq_QMARK_.call(null,inst_18413);
var state_18512__$1 = state_18512;
if(inst_18415){
var statearr_18580_18644 = state_18512__$1;
(statearr_18580_18644[(1)] = (19));

} else {
var statearr_18581_18645 = state_18512__$1;
(statearr_18581_18645[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (38))){
var inst_18491 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18582_18646 = state_18512__$1;
(statearr_18582_18646[(2)] = inst_18491);

(statearr_18582_18646[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (30))){
var state_18512__$1 = state_18512;
var statearr_18583_18647 = state_18512__$1;
(statearr_18583_18647[(2)] = null);

(statearr_18583_18647[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (10))){
var inst_18396 = (state_18512[(13)]);
var inst_18394 = (state_18512[(17)]);
var inst_18402 = cljs.core._nth.call(null,inst_18394,inst_18396);
var inst_18403 = cljs.core.nth.call(null,inst_18402,(0),null);
var inst_18404 = cljs.core.nth.call(null,inst_18402,(1),null);
var state_18512__$1 = (function (){var statearr_18584 = state_18512;
(statearr_18584[(26)] = inst_18403);

return statearr_18584;
})();
if(cljs.core.truth_(inst_18404)){
var statearr_18585_18648 = state_18512__$1;
(statearr_18585_18648[(1)] = (13));

} else {
var statearr_18586_18649 = state_18512__$1;
(statearr_18586_18649[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (18))){
var inst_18437 = (state_18512[(2)]);
var state_18512__$1 = state_18512;
var statearr_18587_18650 = state_18512__$1;
(statearr_18587_18650[(2)] = inst_18437);

(statearr_18587_18650[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (42))){
var state_18512__$1 = state_18512;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18512__$1,(45),dchan);
} else {
if((state_val_18513 === (37))){
var inst_18471 = (state_18512[(25)]);
var inst_18480 = (state_18512[(23)]);
var inst_18384 = (state_18512[(12)]);
var inst_18480__$1 = cljs.core.first.call(null,inst_18471);
var inst_18481 = cljs.core.async.put_BANG_.call(null,inst_18480__$1,inst_18384,done);
var state_18512__$1 = (function (){var statearr_18588 = state_18512;
(statearr_18588[(23)] = inst_18480__$1);

return statearr_18588;
})();
if(cljs.core.truth_(inst_18481)){
var statearr_18589_18651 = state_18512__$1;
(statearr_18589_18651[(1)] = (39));

} else {
var statearr_18590_18652 = state_18512__$1;
(statearr_18590_18652[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18513 === (8))){
var inst_18396 = (state_18512[(13)]);
var inst_18395 = (state_18512[(16)]);
var inst_18398 = (inst_18396 < inst_18395);
var inst_18399 = inst_18398;
var state_18512__$1 = state_18512;
if(cljs.core.truth_(inst_18399)){
var statearr_18591_18653 = state_18512__$1;
(statearr_18591_18653[(1)] = (10));

} else {
var statearr_18592_18654 = state_18512__$1;
(statearr_18592_18654[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18600,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18600,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18596 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18596[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18596[(1)] = (1));

return statearr_18596;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18512){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18597){if((e18597 instanceof Object)){
var ex__8254__auto__ = e18597;
var statearr_18598_18655 = state_18512;
(statearr_18598_18655[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18512);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18597;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18656 = state_18512;
state_18512 = G__18656;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18512){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18600,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18599 = f__8363__auto__.call(null);
(statearr_18599[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18600);

return statearr_18599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18600,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18657 = [];
var len__5726__auto___18660 = arguments.length;
var i__5727__auto___18661 = (0);
while(true){
if((i__5727__auto___18661 < len__5726__auto___18660)){
args18657.push((arguments[i__5727__auto___18661]));

var G__18662 = (i__5727__auto___18661 + (1));
i__5727__auto___18661 = G__18662;
continue;
} else {
}
break;
}

var G__18659 = args18657.length;
switch (G__18659) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18657.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18674 = arguments.length;
var i__5727__auto___18675 = (0);
while(true){
if((i__5727__auto___18675 < len__5726__auto___18674)){
args__5733__auto__.push((arguments[i__5727__auto___18675]));

var G__18676 = (i__5727__auto___18675 + (1));
i__5727__auto___18675 = G__18676;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18668){
var map__18669 = p__18668;
var map__18669__$1 = ((((!((map__18669 == null)))?((((map__18669.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18669.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18669):map__18669);
var opts = map__18669__$1;
var statearr_18671_18677 = state;
(statearr_18671_18677[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18669,map__18669__$1,opts){
return (function (val){
var statearr_18672_18678 = state;
(statearr_18672_18678[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18669,map__18669__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18673_18679 = state;
(statearr_18673_18679[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18664){
var G__18665 = cljs.core.first.call(null,seq18664);
var seq18664__$1 = cljs.core.next.call(null,seq18664);
var G__18666 = cljs.core.first.call(null,seq18664__$1);
var seq18664__$2 = cljs.core.next.call(null,seq18664__$1);
var G__18667 = cljs.core.first.call(null,seq18664__$2);
var seq18664__$3 = cljs.core.next.call(null,seq18664__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18665,G__18666,G__18667,seq18664__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18843 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18843 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18844){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18844 = meta18844;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18845,meta18844__$1){
var self__ = this;
var _18845__$1 = this;
return (new cljs.core.async.t_cljs$core$async18843(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18844__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18845){
var self__ = this;
var _18845__$1 = this;
return self__.meta18844;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18844","meta18844",-317508697,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18843.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18843.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18843";

cljs.core.async.t_cljs$core$async18843.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18843");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18843 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18843(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18844){
return (new cljs.core.async.t_cljs$core$async18843(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18844));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18843(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19006 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19006,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19006,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18943){
var state_val_18944 = (state_18943[(1)]);
if((state_val_18944 === (7))){
var inst_18861 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
var statearr_18945_19007 = state_18943__$1;
(statearr_18945_19007[(2)] = inst_18861);

(statearr_18945_19007[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (20))){
var inst_18873 = (state_18943[(7)]);
var state_18943__$1 = state_18943;
var statearr_18946_19008 = state_18943__$1;
(statearr_18946_19008[(2)] = inst_18873);

(statearr_18946_19008[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (27))){
var state_18943__$1 = state_18943;
var statearr_18947_19009 = state_18943__$1;
(statearr_18947_19009[(2)] = null);

(statearr_18947_19009[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (1))){
var inst_18849 = (state_18943[(8)]);
var inst_18849__$1 = calc_state.call(null);
var inst_18851 = (inst_18849__$1 == null);
var inst_18852 = cljs.core.not.call(null,inst_18851);
var state_18943__$1 = (function (){var statearr_18948 = state_18943;
(statearr_18948[(8)] = inst_18849__$1);

return statearr_18948;
})();
if(inst_18852){
var statearr_18949_19010 = state_18943__$1;
(statearr_18949_19010[(1)] = (2));

} else {
var statearr_18950_19011 = state_18943__$1;
(statearr_18950_19011[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (24))){
var inst_18896 = (state_18943[(9)]);
var inst_18917 = (state_18943[(10)]);
var inst_18903 = (state_18943[(11)]);
var inst_18917__$1 = inst_18896.call(null,inst_18903);
var state_18943__$1 = (function (){var statearr_18951 = state_18943;
(statearr_18951[(10)] = inst_18917__$1);

return statearr_18951;
})();
if(cljs.core.truth_(inst_18917__$1)){
var statearr_18952_19012 = state_18943__$1;
(statearr_18952_19012[(1)] = (29));

} else {
var statearr_18953_19013 = state_18943__$1;
(statearr_18953_19013[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (4))){
var inst_18864 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
if(cljs.core.truth_(inst_18864)){
var statearr_18954_19014 = state_18943__$1;
(statearr_18954_19014[(1)] = (8));

} else {
var statearr_18955_19015 = state_18943__$1;
(statearr_18955_19015[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (15))){
var inst_18890 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
if(cljs.core.truth_(inst_18890)){
var statearr_18956_19016 = state_18943__$1;
(statearr_18956_19016[(1)] = (19));

} else {
var statearr_18957_19017 = state_18943__$1;
(statearr_18957_19017[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (21))){
var inst_18895 = (state_18943[(12)]);
var inst_18895__$1 = (state_18943[(2)]);
var inst_18896 = cljs.core.get.call(null,inst_18895__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18897 = cljs.core.get.call(null,inst_18895__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18898 = cljs.core.get.call(null,inst_18895__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18943__$1 = (function (){var statearr_18958 = state_18943;
(statearr_18958[(9)] = inst_18896);

(statearr_18958[(13)] = inst_18897);

(statearr_18958[(12)] = inst_18895__$1);

return statearr_18958;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18943__$1,(22),inst_18898);
} else {
if((state_val_18944 === (31))){
var inst_18925 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
if(cljs.core.truth_(inst_18925)){
var statearr_18959_19018 = state_18943__$1;
(statearr_18959_19018[(1)] = (32));

} else {
var statearr_18960_19019 = state_18943__$1;
(statearr_18960_19019[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (32))){
var inst_18902 = (state_18943[(14)]);
var state_18943__$1 = state_18943;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18943__$1,(35),out,inst_18902);
} else {
if((state_val_18944 === (33))){
var inst_18895 = (state_18943[(12)]);
var inst_18873 = inst_18895;
var state_18943__$1 = (function (){var statearr_18961 = state_18943;
(statearr_18961[(7)] = inst_18873);

return statearr_18961;
})();
var statearr_18962_19020 = state_18943__$1;
(statearr_18962_19020[(2)] = null);

(statearr_18962_19020[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (13))){
var inst_18873 = (state_18943[(7)]);
var inst_18880 = inst_18873.cljs$lang$protocol_mask$partition0$;
var inst_18881 = (inst_18880 & (64));
var inst_18882 = inst_18873.cljs$core$ISeq$;
var inst_18883 = (inst_18881) || (inst_18882);
var state_18943__$1 = state_18943;
if(cljs.core.truth_(inst_18883)){
var statearr_18963_19021 = state_18943__$1;
(statearr_18963_19021[(1)] = (16));

} else {
var statearr_18964_19022 = state_18943__$1;
(statearr_18964_19022[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (22))){
var inst_18902 = (state_18943[(14)]);
var inst_18903 = (state_18943[(11)]);
var inst_18901 = (state_18943[(2)]);
var inst_18902__$1 = cljs.core.nth.call(null,inst_18901,(0),null);
var inst_18903__$1 = cljs.core.nth.call(null,inst_18901,(1),null);
var inst_18904 = (inst_18902__$1 == null);
var inst_18905 = cljs.core._EQ_.call(null,inst_18903__$1,change);
var inst_18906 = (inst_18904) || (inst_18905);
var state_18943__$1 = (function (){var statearr_18965 = state_18943;
(statearr_18965[(14)] = inst_18902__$1);

(statearr_18965[(11)] = inst_18903__$1);

return statearr_18965;
})();
if(cljs.core.truth_(inst_18906)){
var statearr_18966_19023 = state_18943__$1;
(statearr_18966_19023[(1)] = (23));

} else {
var statearr_18967_19024 = state_18943__$1;
(statearr_18967_19024[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (36))){
var inst_18895 = (state_18943[(12)]);
var inst_18873 = inst_18895;
var state_18943__$1 = (function (){var statearr_18968 = state_18943;
(statearr_18968[(7)] = inst_18873);

return statearr_18968;
})();
var statearr_18969_19025 = state_18943__$1;
(statearr_18969_19025[(2)] = null);

(statearr_18969_19025[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (29))){
var inst_18917 = (state_18943[(10)]);
var state_18943__$1 = state_18943;
var statearr_18970_19026 = state_18943__$1;
(statearr_18970_19026[(2)] = inst_18917);

(statearr_18970_19026[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (6))){
var state_18943__$1 = state_18943;
var statearr_18971_19027 = state_18943__$1;
(statearr_18971_19027[(2)] = false);

(statearr_18971_19027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (28))){
var inst_18913 = (state_18943[(2)]);
var inst_18914 = calc_state.call(null);
var inst_18873 = inst_18914;
var state_18943__$1 = (function (){var statearr_18972 = state_18943;
(statearr_18972[(7)] = inst_18873);

(statearr_18972[(15)] = inst_18913);

return statearr_18972;
})();
var statearr_18973_19028 = state_18943__$1;
(statearr_18973_19028[(2)] = null);

(statearr_18973_19028[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (25))){
var inst_18939 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
var statearr_18974_19029 = state_18943__$1;
(statearr_18974_19029[(2)] = inst_18939);

(statearr_18974_19029[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (34))){
var inst_18937 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
var statearr_18975_19030 = state_18943__$1;
(statearr_18975_19030[(2)] = inst_18937);

(statearr_18975_19030[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (17))){
var state_18943__$1 = state_18943;
var statearr_18976_19031 = state_18943__$1;
(statearr_18976_19031[(2)] = false);

(statearr_18976_19031[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (3))){
var state_18943__$1 = state_18943;
var statearr_18977_19032 = state_18943__$1;
(statearr_18977_19032[(2)] = false);

(statearr_18977_19032[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (12))){
var inst_18941 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18943__$1,inst_18941);
} else {
if((state_val_18944 === (2))){
var inst_18849 = (state_18943[(8)]);
var inst_18854 = inst_18849.cljs$lang$protocol_mask$partition0$;
var inst_18855 = (inst_18854 & (64));
var inst_18856 = inst_18849.cljs$core$ISeq$;
var inst_18857 = (inst_18855) || (inst_18856);
var state_18943__$1 = state_18943;
if(cljs.core.truth_(inst_18857)){
var statearr_18978_19033 = state_18943__$1;
(statearr_18978_19033[(1)] = (5));

} else {
var statearr_18979_19034 = state_18943__$1;
(statearr_18979_19034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (23))){
var inst_18902 = (state_18943[(14)]);
var inst_18908 = (inst_18902 == null);
var state_18943__$1 = state_18943;
if(cljs.core.truth_(inst_18908)){
var statearr_18980_19035 = state_18943__$1;
(statearr_18980_19035[(1)] = (26));

} else {
var statearr_18981_19036 = state_18943__$1;
(statearr_18981_19036[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (35))){
var inst_18928 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
if(cljs.core.truth_(inst_18928)){
var statearr_18982_19037 = state_18943__$1;
(statearr_18982_19037[(1)] = (36));

} else {
var statearr_18983_19038 = state_18943__$1;
(statearr_18983_19038[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (19))){
var inst_18873 = (state_18943[(7)]);
var inst_18892 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18873);
var state_18943__$1 = state_18943;
var statearr_18984_19039 = state_18943__$1;
(statearr_18984_19039[(2)] = inst_18892);

(statearr_18984_19039[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (11))){
var inst_18873 = (state_18943[(7)]);
var inst_18877 = (inst_18873 == null);
var inst_18878 = cljs.core.not.call(null,inst_18877);
var state_18943__$1 = state_18943;
if(inst_18878){
var statearr_18985_19040 = state_18943__$1;
(statearr_18985_19040[(1)] = (13));

} else {
var statearr_18986_19041 = state_18943__$1;
(statearr_18986_19041[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (9))){
var inst_18849 = (state_18943[(8)]);
var state_18943__$1 = state_18943;
var statearr_18987_19042 = state_18943__$1;
(statearr_18987_19042[(2)] = inst_18849);

(statearr_18987_19042[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (5))){
var state_18943__$1 = state_18943;
var statearr_18988_19043 = state_18943__$1;
(statearr_18988_19043[(2)] = true);

(statearr_18988_19043[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (14))){
var state_18943__$1 = state_18943;
var statearr_18989_19044 = state_18943__$1;
(statearr_18989_19044[(2)] = false);

(statearr_18989_19044[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (26))){
var inst_18903 = (state_18943[(11)]);
var inst_18910 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18903);
var state_18943__$1 = state_18943;
var statearr_18990_19045 = state_18943__$1;
(statearr_18990_19045[(2)] = inst_18910);

(statearr_18990_19045[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (16))){
var state_18943__$1 = state_18943;
var statearr_18991_19046 = state_18943__$1;
(statearr_18991_19046[(2)] = true);

(statearr_18991_19046[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (38))){
var inst_18933 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
var statearr_18992_19047 = state_18943__$1;
(statearr_18992_19047[(2)] = inst_18933);

(statearr_18992_19047[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (30))){
var inst_18896 = (state_18943[(9)]);
var inst_18903 = (state_18943[(11)]);
var inst_18897 = (state_18943[(13)]);
var inst_18920 = cljs.core.empty_QMARK_.call(null,inst_18896);
var inst_18921 = inst_18897.call(null,inst_18903);
var inst_18922 = cljs.core.not.call(null,inst_18921);
var inst_18923 = (inst_18920) && (inst_18922);
var state_18943__$1 = state_18943;
var statearr_18993_19048 = state_18943__$1;
(statearr_18993_19048[(2)] = inst_18923);

(statearr_18993_19048[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (10))){
var inst_18849 = (state_18943[(8)]);
var inst_18869 = (state_18943[(2)]);
var inst_18870 = cljs.core.get.call(null,inst_18869,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18871 = cljs.core.get.call(null,inst_18869,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18872 = cljs.core.get.call(null,inst_18869,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18873 = inst_18849;
var state_18943__$1 = (function (){var statearr_18994 = state_18943;
(statearr_18994[(16)] = inst_18870);

(statearr_18994[(17)] = inst_18872);

(statearr_18994[(18)] = inst_18871);

(statearr_18994[(7)] = inst_18873);

return statearr_18994;
})();
var statearr_18995_19049 = state_18943__$1;
(statearr_18995_19049[(2)] = null);

(statearr_18995_19049[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (18))){
var inst_18887 = (state_18943[(2)]);
var state_18943__$1 = state_18943;
var statearr_18996_19050 = state_18943__$1;
(statearr_18996_19050[(2)] = inst_18887);

(statearr_18996_19050[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (37))){
var state_18943__$1 = state_18943;
var statearr_18997_19051 = state_18943__$1;
(statearr_18997_19051[(2)] = null);

(statearr_18997_19051[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18944 === (8))){
var inst_18849 = (state_18943[(8)]);
var inst_18866 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18849);
var state_18943__$1 = state_18943;
var statearr_18998_19052 = state_18943__$1;
(statearr_18998_19052[(2)] = inst_18866);

(statearr_18998_19052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19006,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___19006,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_19002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19002[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_19002[(1)] = (1));

return statearr_19002;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18943){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18943);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19003){if((e19003 instanceof Object)){
var ex__8254__auto__ = e19003;
var statearr_19004_19053 = state_18943;
(statearr_19004_19053[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18943);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19003;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19054 = state_18943;
state_18943 = G__19054;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18943){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19006,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_19005 = f__8363__auto__.call(null);
(statearr_19005[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19006);

return statearr_19005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19006,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19055 = [];
var len__5726__auto___19058 = arguments.length;
var i__5727__auto___19059 = (0);
while(true){
if((i__5727__auto___19059 < len__5726__auto___19058)){
args19055.push((arguments[i__5727__auto___19059]));

var G__19060 = (i__5727__auto___19059 + (1));
i__5727__auto___19059 = G__19060;
continue;
} else {
}
break;
}

var G__19057 = args19055.length;
switch (G__19057) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19055.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19063 = [];
var len__5726__auto___19188 = arguments.length;
var i__5727__auto___19189 = (0);
while(true){
if((i__5727__auto___19189 < len__5726__auto___19188)){
args19063.push((arguments[i__5727__auto___19189]));

var G__19190 = (i__5727__auto___19189 + (1));
i__5727__auto___19189 = G__19190;
continue;
} else {
}
break;
}

var G__19065 = args19063.length;
switch (G__19065) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19063.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19062_SHARP_){
if(cljs.core.truth_(p1__19062_SHARP_.call(null,topic))){
return p1__19062_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19062_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19066 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19066 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19067){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19067 = meta19067;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19068,meta19067__$1){
var self__ = this;
var _19068__$1 = this;
return (new cljs.core.async.t_cljs$core$async19066(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19067__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19068){
var self__ = this;
var _19068__$1 = this;
return self__.meta19067;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19066.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19066.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19067","meta19067",-1664181558,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19066.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19066.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19066";

cljs.core.async.t_cljs$core$async19066.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19066");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19066 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19066(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19067){
return (new cljs.core.async.t_cljs$core$async19066(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19067));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19066(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19192,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19192,mults,ensure_mult,p){
return (function (state_19140){
var state_val_19141 = (state_19140[(1)]);
if((state_val_19141 === (7))){
var inst_19136 = (state_19140[(2)]);
var state_19140__$1 = state_19140;
var statearr_19142_19193 = state_19140__$1;
(statearr_19142_19193[(2)] = inst_19136);

(statearr_19142_19193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (20))){
var state_19140__$1 = state_19140;
var statearr_19143_19194 = state_19140__$1;
(statearr_19143_19194[(2)] = null);

(statearr_19143_19194[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (1))){
var state_19140__$1 = state_19140;
var statearr_19144_19195 = state_19140__$1;
(statearr_19144_19195[(2)] = null);

(statearr_19144_19195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (24))){
var inst_19119 = (state_19140[(7)]);
var inst_19128 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19119);
var state_19140__$1 = state_19140;
var statearr_19145_19196 = state_19140__$1;
(statearr_19145_19196[(2)] = inst_19128);

(statearr_19145_19196[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (4))){
var inst_19071 = (state_19140[(8)]);
var inst_19071__$1 = (state_19140[(2)]);
var inst_19072 = (inst_19071__$1 == null);
var state_19140__$1 = (function (){var statearr_19146 = state_19140;
(statearr_19146[(8)] = inst_19071__$1);

return statearr_19146;
})();
if(cljs.core.truth_(inst_19072)){
var statearr_19147_19197 = state_19140__$1;
(statearr_19147_19197[(1)] = (5));

} else {
var statearr_19148_19198 = state_19140__$1;
(statearr_19148_19198[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (15))){
var inst_19113 = (state_19140[(2)]);
var state_19140__$1 = state_19140;
var statearr_19149_19199 = state_19140__$1;
(statearr_19149_19199[(2)] = inst_19113);

(statearr_19149_19199[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (21))){
var inst_19133 = (state_19140[(2)]);
var state_19140__$1 = (function (){var statearr_19150 = state_19140;
(statearr_19150[(9)] = inst_19133);

return statearr_19150;
})();
var statearr_19151_19200 = state_19140__$1;
(statearr_19151_19200[(2)] = null);

(statearr_19151_19200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (13))){
var inst_19095 = (state_19140[(10)]);
var inst_19097 = cljs.core.chunked_seq_QMARK_.call(null,inst_19095);
var state_19140__$1 = state_19140;
if(inst_19097){
var statearr_19152_19201 = state_19140__$1;
(statearr_19152_19201[(1)] = (16));

} else {
var statearr_19153_19202 = state_19140__$1;
(statearr_19153_19202[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (22))){
var inst_19125 = (state_19140[(2)]);
var state_19140__$1 = state_19140;
if(cljs.core.truth_(inst_19125)){
var statearr_19154_19203 = state_19140__$1;
(statearr_19154_19203[(1)] = (23));

} else {
var statearr_19155_19204 = state_19140__$1;
(statearr_19155_19204[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (6))){
var inst_19071 = (state_19140[(8)]);
var inst_19121 = (state_19140[(11)]);
var inst_19119 = (state_19140[(7)]);
var inst_19119__$1 = topic_fn.call(null,inst_19071);
var inst_19120 = cljs.core.deref.call(null,mults);
var inst_19121__$1 = cljs.core.get.call(null,inst_19120,inst_19119__$1);
var state_19140__$1 = (function (){var statearr_19156 = state_19140;
(statearr_19156[(11)] = inst_19121__$1);

(statearr_19156[(7)] = inst_19119__$1);

return statearr_19156;
})();
if(cljs.core.truth_(inst_19121__$1)){
var statearr_19157_19205 = state_19140__$1;
(statearr_19157_19205[(1)] = (19));

} else {
var statearr_19158_19206 = state_19140__$1;
(statearr_19158_19206[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (25))){
var inst_19130 = (state_19140[(2)]);
var state_19140__$1 = state_19140;
var statearr_19159_19207 = state_19140__$1;
(statearr_19159_19207[(2)] = inst_19130);

(statearr_19159_19207[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (17))){
var inst_19095 = (state_19140[(10)]);
var inst_19104 = cljs.core.first.call(null,inst_19095);
var inst_19105 = cljs.core.async.muxch_STAR_.call(null,inst_19104);
var inst_19106 = cljs.core.async.close_BANG_.call(null,inst_19105);
var inst_19107 = cljs.core.next.call(null,inst_19095);
var inst_19081 = inst_19107;
var inst_19082 = null;
var inst_19083 = (0);
var inst_19084 = (0);
var state_19140__$1 = (function (){var statearr_19160 = state_19140;
(statearr_19160[(12)] = inst_19084);

(statearr_19160[(13)] = inst_19082);

(statearr_19160[(14)] = inst_19081);

(statearr_19160[(15)] = inst_19083);

(statearr_19160[(16)] = inst_19106);

return statearr_19160;
})();
var statearr_19161_19208 = state_19140__$1;
(statearr_19161_19208[(2)] = null);

(statearr_19161_19208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (3))){
var inst_19138 = (state_19140[(2)]);
var state_19140__$1 = state_19140;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19140__$1,inst_19138);
} else {
if((state_val_19141 === (12))){
var inst_19115 = (state_19140[(2)]);
var state_19140__$1 = state_19140;
var statearr_19162_19209 = state_19140__$1;
(statearr_19162_19209[(2)] = inst_19115);

(statearr_19162_19209[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (2))){
var state_19140__$1 = state_19140;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19140__$1,(4),ch);
} else {
if((state_val_19141 === (23))){
var state_19140__$1 = state_19140;
var statearr_19163_19210 = state_19140__$1;
(statearr_19163_19210[(2)] = null);

(statearr_19163_19210[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (19))){
var inst_19071 = (state_19140[(8)]);
var inst_19121 = (state_19140[(11)]);
var inst_19123 = cljs.core.async.muxch_STAR_.call(null,inst_19121);
var state_19140__$1 = state_19140;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19140__$1,(22),inst_19123,inst_19071);
} else {
if((state_val_19141 === (11))){
var inst_19095 = (state_19140[(10)]);
var inst_19081 = (state_19140[(14)]);
var inst_19095__$1 = cljs.core.seq.call(null,inst_19081);
var state_19140__$1 = (function (){var statearr_19164 = state_19140;
(statearr_19164[(10)] = inst_19095__$1);

return statearr_19164;
})();
if(inst_19095__$1){
var statearr_19165_19211 = state_19140__$1;
(statearr_19165_19211[(1)] = (13));

} else {
var statearr_19166_19212 = state_19140__$1;
(statearr_19166_19212[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (9))){
var inst_19117 = (state_19140[(2)]);
var state_19140__$1 = state_19140;
var statearr_19167_19213 = state_19140__$1;
(statearr_19167_19213[(2)] = inst_19117);

(statearr_19167_19213[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (5))){
var inst_19078 = cljs.core.deref.call(null,mults);
var inst_19079 = cljs.core.vals.call(null,inst_19078);
var inst_19080 = cljs.core.seq.call(null,inst_19079);
var inst_19081 = inst_19080;
var inst_19082 = null;
var inst_19083 = (0);
var inst_19084 = (0);
var state_19140__$1 = (function (){var statearr_19168 = state_19140;
(statearr_19168[(12)] = inst_19084);

(statearr_19168[(13)] = inst_19082);

(statearr_19168[(14)] = inst_19081);

(statearr_19168[(15)] = inst_19083);

return statearr_19168;
})();
var statearr_19169_19214 = state_19140__$1;
(statearr_19169_19214[(2)] = null);

(statearr_19169_19214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (14))){
var state_19140__$1 = state_19140;
var statearr_19173_19215 = state_19140__$1;
(statearr_19173_19215[(2)] = null);

(statearr_19173_19215[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (16))){
var inst_19095 = (state_19140[(10)]);
var inst_19099 = cljs.core.chunk_first.call(null,inst_19095);
var inst_19100 = cljs.core.chunk_rest.call(null,inst_19095);
var inst_19101 = cljs.core.count.call(null,inst_19099);
var inst_19081 = inst_19100;
var inst_19082 = inst_19099;
var inst_19083 = inst_19101;
var inst_19084 = (0);
var state_19140__$1 = (function (){var statearr_19174 = state_19140;
(statearr_19174[(12)] = inst_19084);

(statearr_19174[(13)] = inst_19082);

(statearr_19174[(14)] = inst_19081);

(statearr_19174[(15)] = inst_19083);

return statearr_19174;
})();
var statearr_19175_19216 = state_19140__$1;
(statearr_19175_19216[(2)] = null);

(statearr_19175_19216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (10))){
var inst_19084 = (state_19140[(12)]);
var inst_19082 = (state_19140[(13)]);
var inst_19081 = (state_19140[(14)]);
var inst_19083 = (state_19140[(15)]);
var inst_19089 = cljs.core._nth.call(null,inst_19082,inst_19084);
var inst_19090 = cljs.core.async.muxch_STAR_.call(null,inst_19089);
var inst_19091 = cljs.core.async.close_BANG_.call(null,inst_19090);
var inst_19092 = (inst_19084 + (1));
var tmp19170 = inst_19082;
var tmp19171 = inst_19081;
var tmp19172 = inst_19083;
var inst_19081__$1 = tmp19171;
var inst_19082__$1 = tmp19170;
var inst_19083__$1 = tmp19172;
var inst_19084__$1 = inst_19092;
var state_19140__$1 = (function (){var statearr_19176 = state_19140;
(statearr_19176[(17)] = inst_19091);

(statearr_19176[(12)] = inst_19084__$1);

(statearr_19176[(13)] = inst_19082__$1);

(statearr_19176[(14)] = inst_19081__$1);

(statearr_19176[(15)] = inst_19083__$1);

return statearr_19176;
})();
var statearr_19177_19217 = state_19140__$1;
(statearr_19177_19217[(2)] = null);

(statearr_19177_19217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (18))){
var inst_19110 = (state_19140[(2)]);
var state_19140__$1 = state_19140;
var statearr_19178_19218 = state_19140__$1;
(statearr_19178_19218[(2)] = inst_19110);

(statearr_19178_19218[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19141 === (8))){
var inst_19084 = (state_19140[(12)]);
var inst_19083 = (state_19140[(15)]);
var inst_19086 = (inst_19084 < inst_19083);
var inst_19087 = inst_19086;
var state_19140__$1 = state_19140;
if(cljs.core.truth_(inst_19087)){
var statearr_19179_19219 = state_19140__$1;
(statearr_19179_19219[(1)] = (10));

} else {
var statearr_19180_19220 = state_19140__$1;
(statearr_19180_19220[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19192,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19192,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19184[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19184[(1)] = (1));

return statearr_19184;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19140){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19140);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19185){if((e19185 instanceof Object)){
var ex__8254__auto__ = e19185;
var statearr_19186_19221 = state_19140;
(statearr_19186_19221[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19140);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19185;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19222 = state_19140;
state_19140 = G__19222;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19140){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19192,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19187 = f__8363__auto__.call(null);
(statearr_19187[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19192);

return statearr_19187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19192,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19223 = [];
var len__5726__auto___19226 = arguments.length;
var i__5727__auto___19227 = (0);
while(true){
if((i__5727__auto___19227 < len__5726__auto___19226)){
args19223.push((arguments[i__5727__auto___19227]));

var G__19228 = (i__5727__auto___19227 + (1));
i__5727__auto___19227 = G__19228;
continue;
} else {
}
break;
}

var G__19225 = args19223.length;
switch (G__19225) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19223.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19230 = [];
var len__5726__auto___19233 = arguments.length;
var i__5727__auto___19234 = (0);
while(true){
if((i__5727__auto___19234 < len__5726__auto___19233)){
args19230.push((arguments[i__5727__auto___19234]));

var G__19235 = (i__5727__auto___19234 + (1));
i__5727__auto___19234 = G__19235;
continue;
} else {
}
break;
}

var G__19232 = args19230.length;
switch (G__19232) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19230.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19237 = [];
var len__5726__auto___19308 = arguments.length;
var i__5727__auto___19309 = (0);
while(true){
if((i__5727__auto___19309 < len__5726__auto___19308)){
args19237.push((arguments[i__5727__auto___19309]));

var G__19310 = (i__5727__auto___19309 + (1));
i__5727__auto___19309 = G__19310;
continue;
} else {
}
break;
}

var G__19239 = args19237.length;
switch (G__19239) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19237.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19312 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19312,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19312,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19278){
var state_val_19279 = (state_19278[(1)]);
if((state_val_19279 === (7))){
var state_19278__$1 = state_19278;
var statearr_19280_19313 = state_19278__$1;
(statearr_19280_19313[(2)] = null);

(statearr_19280_19313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (1))){
var state_19278__$1 = state_19278;
var statearr_19281_19314 = state_19278__$1;
(statearr_19281_19314[(2)] = null);

(statearr_19281_19314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (4))){
var inst_19242 = (state_19278[(7)]);
var inst_19244 = (inst_19242 < cnt);
var state_19278__$1 = state_19278;
if(cljs.core.truth_(inst_19244)){
var statearr_19282_19315 = state_19278__$1;
(statearr_19282_19315[(1)] = (6));

} else {
var statearr_19283_19316 = state_19278__$1;
(statearr_19283_19316[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (15))){
var inst_19274 = (state_19278[(2)]);
var state_19278__$1 = state_19278;
var statearr_19284_19317 = state_19278__$1;
(statearr_19284_19317[(2)] = inst_19274);

(statearr_19284_19317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (13))){
var inst_19267 = cljs.core.async.close_BANG_.call(null,out);
var state_19278__$1 = state_19278;
var statearr_19285_19318 = state_19278__$1;
(statearr_19285_19318[(2)] = inst_19267);

(statearr_19285_19318[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (6))){
var state_19278__$1 = state_19278;
var statearr_19286_19319 = state_19278__$1;
(statearr_19286_19319[(2)] = null);

(statearr_19286_19319[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (3))){
var inst_19276 = (state_19278[(2)]);
var state_19278__$1 = state_19278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19278__$1,inst_19276);
} else {
if((state_val_19279 === (12))){
var inst_19264 = (state_19278[(8)]);
var inst_19264__$1 = (state_19278[(2)]);
var inst_19265 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19264__$1);
var state_19278__$1 = (function (){var statearr_19287 = state_19278;
(statearr_19287[(8)] = inst_19264__$1);

return statearr_19287;
})();
if(cljs.core.truth_(inst_19265)){
var statearr_19288_19320 = state_19278__$1;
(statearr_19288_19320[(1)] = (13));

} else {
var statearr_19289_19321 = state_19278__$1;
(statearr_19289_19321[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (2))){
var inst_19241 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19242 = (0);
var state_19278__$1 = (function (){var statearr_19290 = state_19278;
(statearr_19290[(9)] = inst_19241);

(statearr_19290[(7)] = inst_19242);

return statearr_19290;
})();
var statearr_19291_19322 = state_19278__$1;
(statearr_19291_19322[(2)] = null);

(statearr_19291_19322[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (11))){
var inst_19242 = (state_19278[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19278,(10),Object,null,(9));
var inst_19251 = chs__$1.call(null,inst_19242);
var inst_19252 = done.call(null,inst_19242);
var inst_19253 = cljs.core.async.take_BANG_.call(null,inst_19251,inst_19252);
var state_19278__$1 = state_19278;
var statearr_19292_19323 = state_19278__$1;
(statearr_19292_19323[(2)] = inst_19253);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19278__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (9))){
var inst_19242 = (state_19278[(7)]);
var inst_19255 = (state_19278[(2)]);
var inst_19256 = (inst_19242 + (1));
var inst_19242__$1 = inst_19256;
var state_19278__$1 = (function (){var statearr_19293 = state_19278;
(statearr_19293[(10)] = inst_19255);

(statearr_19293[(7)] = inst_19242__$1);

return statearr_19293;
})();
var statearr_19294_19324 = state_19278__$1;
(statearr_19294_19324[(2)] = null);

(statearr_19294_19324[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (5))){
var inst_19262 = (state_19278[(2)]);
var state_19278__$1 = (function (){var statearr_19295 = state_19278;
(statearr_19295[(11)] = inst_19262);

return statearr_19295;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19278__$1,(12),dchan);
} else {
if((state_val_19279 === (14))){
var inst_19264 = (state_19278[(8)]);
var inst_19269 = cljs.core.apply.call(null,f,inst_19264);
var state_19278__$1 = state_19278;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19278__$1,(16),out,inst_19269);
} else {
if((state_val_19279 === (16))){
var inst_19271 = (state_19278[(2)]);
var state_19278__$1 = (function (){var statearr_19296 = state_19278;
(statearr_19296[(12)] = inst_19271);

return statearr_19296;
})();
var statearr_19297_19325 = state_19278__$1;
(statearr_19297_19325[(2)] = null);

(statearr_19297_19325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (10))){
var inst_19246 = (state_19278[(2)]);
var inst_19247 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19278__$1 = (function (){var statearr_19298 = state_19278;
(statearr_19298[(13)] = inst_19246);

return statearr_19298;
})();
var statearr_19299_19326 = state_19278__$1;
(statearr_19299_19326[(2)] = inst_19247);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19278__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19279 === (8))){
var inst_19260 = (state_19278[(2)]);
var state_19278__$1 = state_19278;
var statearr_19300_19327 = state_19278__$1;
(statearr_19300_19327[(2)] = inst_19260);

(statearr_19300_19327[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19312,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19312,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19304 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19304[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19304[(1)] = (1));

return statearr_19304;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19278){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19305){if((e19305 instanceof Object)){
var ex__8254__auto__ = e19305;
var statearr_19306_19328 = state_19278;
(statearr_19306_19328[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19278);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19305;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19329 = state_19278;
state_19278 = G__19329;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19278){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19312,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19307 = f__8363__auto__.call(null);
(statearr_19307[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19312);

return statearr_19307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19312,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19331 = [];
var len__5726__auto___19387 = arguments.length;
var i__5727__auto___19388 = (0);
while(true){
if((i__5727__auto___19388 < len__5726__auto___19387)){
args19331.push((arguments[i__5727__auto___19388]));

var G__19389 = (i__5727__auto___19388 + (1));
i__5727__auto___19388 = G__19389;
continue;
} else {
}
break;
}

var G__19333 = args19331.length;
switch (G__19333) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19331.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19391 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19391,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19391,out){
return (function (state_19363){
var state_val_19364 = (state_19363[(1)]);
if((state_val_19364 === (7))){
var inst_19342 = (state_19363[(7)]);
var inst_19343 = (state_19363[(8)]);
var inst_19342__$1 = (state_19363[(2)]);
var inst_19343__$1 = cljs.core.nth.call(null,inst_19342__$1,(0),null);
var inst_19344 = cljs.core.nth.call(null,inst_19342__$1,(1),null);
var inst_19345 = (inst_19343__$1 == null);
var state_19363__$1 = (function (){var statearr_19365 = state_19363;
(statearr_19365[(7)] = inst_19342__$1);

(statearr_19365[(9)] = inst_19344);

(statearr_19365[(8)] = inst_19343__$1);

return statearr_19365;
})();
if(cljs.core.truth_(inst_19345)){
var statearr_19366_19392 = state_19363__$1;
(statearr_19366_19392[(1)] = (8));

} else {
var statearr_19367_19393 = state_19363__$1;
(statearr_19367_19393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (1))){
var inst_19334 = cljs.core.vec.call(null,chs);
var inst_19335 = inst_19334;
var state_19363__$1 = (function (){var statearr_19368 = state_19363;
(statearr_19368[(10)] = inst_19335);

return statearr_19368;
})();
var statearr_19369_19394 = state_19363__$1;
(statearr_19369_19394[(2)] = null);

(statearr_19369_19394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (4))){
var inst_19335 = (state_19363[(10)]);
var state_19363__$1 = state_19363;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19363__$1,(7),inst_19335);
} else {
if((state_val_19364 === (6))){
var inst_19359 = (state_19363[(2)]);
var state_19363__$1 = state_19363;
var statearr_19370_19395 = state_19363__$1;
(statearr_19370_19395[(2)] = inst_19359);

(statearr_19370_19395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (3))){
var inst_19361 = (state_19363[(2)]);
var state_19363__$1 = state_19363;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19363__$1,inst_19361);
} else {
if((state_val_19364 === (2))){
var inst_19335 = (state_19363[(10)]);
var inst_19337 = cljs.core.count.call(null,inst_19335);
var inst_19338 = (inst_19337 > (0));
var state_19363__$1 = state_19363;
if(cljs.core.truth_(inst_19338)){
var statearr_19372_19396 = state_19363__$1;
(statearr_19372_19396[(1)] = (4));

} else {
var statearr_19373_19397 = state_19363__$1;
(statearr_19373_19397[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (11))){
var inst_19335 = (state_19363[(10)]);
var inst_19352 = (state_19363[(2)]);
var tmp19371 = inst_19335;
var inst_19335__$1 = tmp19371;
var state_19363__$1 = (function (){var statearr_19374 = state_19363;
(statearr_19374[(11)] = inst_19352);

(statearr_19374[(10)] = inst_19335__$1);

return statearr_19374;
})();
var statearr_19375_19398 = state_19363__$1;
(statearr_19375_19398[(2)] = null);

(statearr_19375_19398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (9))){
var inst_19343 = (state_19363[(8)]);
var state_19363__$1 = state_19363;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19363__$1,(11),out,inst_19343);
} else {
if((state_val_19364 === (5))){
var inst_19357 = cljs.core.async.close_BANG_.call(null,out);
var state_19363__$1 = state_19363;
var statearr_19376_19399 = state_19363__$1;
(statearr_19376_19399[(2)] = inst_19357);

(statearr_19376_19399[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (10))){
var inst_19355 = (state_19363[(2)]);
var state_19363__$1 = state_19363;
var statearr_19377_19400 = state_19363__$1;
(statearr_19377_19400[(2)] = inst_19355);

(statearr_19377_19400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (8))){
var inst_19342 = (state_19363[(7)]);
var inst_19344 = (state_19363[(9)]);
var inst_19343 = (state_19363[(8)]);
var inst_19335 = (state_19363[(10)]);
var inst_19347 = (function (){var cs = inst_19335;
var vec__19340 = inst_19342;
var v = inst_19343;
var c = inst_19344;
return ((function (cs,vec__19340,v,c,inst_19342,inst_19344,inst_19343,inst_19335,state_val_19364,c__8362__auto___19391,out){
return (function (p1__19330_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19330_SHARP_);
});
;})(cs,vec__19340,v,c,inst_19342,inst_19344,inst_19343,inst_19335,state_val_19364,c__8362__auto___19391,out))
})();
var inst_19348 = cljs.core.filterv.call(null,inst_19347,inst_19335);
var inst_19335__$1 = inst_19348;
var state_19363__$1 = (function (){var statearr_19378 = state_19363;
(statearr_19378[(10)] = inst_19335__$1);

return statearr_19378;
})();
var statearr_19379_19401 = state_19363__$1;
(statearr_19379_19401[(2)] = null);

(statearr_19379_19401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19391,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19391,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19383 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19383[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19383[(1)] = (1));

return statearr_19383;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19363){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19363);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19384){if((e19384 instanceof Object)){
var ex__8254__auto__ = e19384;
var statearr_19385_19402 = state_19363;
(statearr_19385_19402[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19363);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19384;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19403 = state_19363;
state_19363 = G__19403;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19363){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19391,out))
})();
var state__8364__auto__ = (function (){var statearr_19386 = f__8363__auto__.call(null);
(statearr_19386[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19391);

return statearr_19386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19391,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19404 = [];
var len__5726__auto___19453 = arguments.length;
var i__5727__auto___19454 = (0);
while(true){
if((i__5727__auto___19454 < len__5726__auto___19453)){
args19404.push((arguments[i__5727__auto___19454]));

var G__19455 = (i__5727__auto___19454 + (1));
i__5727__auto___19454 = G__19455;
continue;
} else {
}
break;
}

var G__19406 = args19404.length;
switch (G__19406) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19404.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19457 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19457,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19457,out){
return (function (state_19430){
var state_val_19431 = (state_19430[(1)]);
if((state_val_19431 === (7))){
var inst_19412 = (state_19430[(7)]);
var inst_19412__$1 = (state_19430[(2)]);
var inst_19413 = (inst_19412__$1 == null);
var inst_19414 = cljs.core.not.call(null,inst_19413);
var state_19430__$1 = (function (){var statearr_19432 = state_19430;
(statearr_19432[(7)] = inst_19412__$1);

return statearr_19432;
})();
if(inst_19414){
var statearr_19433_19458 = state_19430__$1;
(statearr_19433_19458[(1)] = (8));

} else {
var statearr_19434_19459 = state_19430__$1;
(statearr_19434_19459[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19431 === (1))){
var inst_19407 = (0);
var state_19430__$1 = (function (){var statearr_19435 = state_19430;
(statearr_19435[(8)] = inst_19407);

return statearr_19435;
})();
var statearr_19436_19460 = state_19430__$1;
(statearr_19436_19460[(2)] = null);

(statearr_19436_19460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19431 === (4))){
var state_19430__$1 = state_19430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19430__$1,(7),ch);
} else {
if((state_val_19431 === (6))){
var inst_19425 = (state_19430[(2)]);
var state_19430__$1 = state_19430;
var statearr_19437_19461 = state_19430__$1;
(statearr_19437_19461[(2)] = inst_19425);

(statearr_19437_19461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19431 === (3))){
var inst_19427 = (state_19430[(2)]);
var inst_19428 = cljs.core.async.close_BANG_.call(null,out);
var state_19430__$1 = (function (){var statearr_19438 = state_19430;
(statearr_19438[(9)] = inst_19427);

return statearr_19438;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19430__$1,inst_19428);
} else {
if((state_val_19431 === (2))){
var inst_19407 = (state_19430[(8)]);
var inst_19409 = (inst_19407 < n);
var state_19430__$1 = state_19430;
if(cljs.core.truth_(inst_19409)){
var statearr_19439_19462 = state_19430__$1;
(statearr_19439_19462[(1)] = (4));

} else {
var statearr_19440_19463 = state_19430__$1;
(statearr_19440_19463[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19431 === (11))){
var inst_19407 = (state_19430[(8)]);
var inst_19417 = (state_19430[(2)]);
var inst_19418 = (inst_19407 + (1));
var inst_19407__$1 = inst_19418;
var state_19430__$1 = (function (){var statearr_19441 = state_19430;
(statearr_19441[(10)] = inst_19417);

(statearr_19441[(8)] = inst_19407__$1);

return statearr_19441;
})();
var statearr_19442_19464 = state_19430__$1;
(statearr_19442_19464[(2)] = null);

(statearr_19442_19464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19431 === (9))){
var state_19430__$1 = state_19430;
var statearr_19443_19465 = state_19430__$1;
(statearr_19443_19465[(2)] = null);

(statearr_19443_19465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19431 === (5))){
var state_19430__$1 = state_19430;
var statearr_19444_19466 = state_19430__$1;
(statearr_19444_19466[(2)] = null);

(statearr_19444_19466[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19431 === (10))){
var inst_19422 = (state_19430[(2)]);
var state_19430__$1 = state_19430;
var statearr_19445_19467 = state_19430__$1;
(statearr_19445_19467[(2)] = inst_19422);

(statearr_19445_19467[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19431 === (8))){
var inst_19412 = (state_19430[(7)]);
var state_19430__$1 = state_19430;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19430__$1,(11),out,inst_19412);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19457,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19457,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19449 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19449[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19449[(1)] = (1));

return statearr_19449;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19430){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19450){if((e19450 instanceof Object)){
var ex__8254__auto__ = e19450;
var statearr_19451_19468 = state_19430;
(statearr_19451_19468[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19430);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19450;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19469 = state_19430;
state_19430 = G__19469;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19430){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19457,out))
})();
var state__8364__auto__ = (function (){var statearr_19452 = f__8363__auto__.call(null);
(statearr_19452[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19457);

return statearr_19452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19457,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19477 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19477 = (function (map_LT_,f,ch,meta19478){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19478 = meta19478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19479,meta19478__$1){
var self__ = this;
var _19479__$1 = this;
return (new cljs.core.async.t_cljs$core$async19477(self__.map_LT_,self__.f,self__.ch,meta19478__$1));
});

cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19479){
var self__ = this;
var _19479__$1 = this;
return self__.meta19478;
});

cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19480 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19480 = (function (map_LT_,f,ch,meta19478,_,fn1,meta19481){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19478 = meta19478;
this._ = _;
this.fn1 = fn1;
this.meta19481 = meta19481;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19480.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19482,meta19481__$1){
var self__ = this;
var _19482__$1 = this;
return (new cljs.core.async.t_cljs$core$async19480(self__.map_LT_,self__.f,self__.ch,self__.meta19478,self__._,self__.fn1,meta19481__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19480.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19482){
var self__ = this;
var _19482__$1 = this;
return self__.meta19481;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19480.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19480.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19480.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19480.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19470_SHARP_){
return f1.call(null,(((p1__19470_SHARP_ == null))?null:self__.f.call(null,p1__19470_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19480.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19478","meta19478",24735181,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19477","cljs.core.async/t_cljs$core$async19477",293348035,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19481","meta19481",-1658186480,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19480.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19480.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19480";

cljs.core.async.t_cljs$core$async19480.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19480");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19480 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19480(map_LT___$1,f__$1,ch__$1,meta19478__$1,___$2,fn1__$1,meta19481){
return (new cljs.core.async.t_cljs$core$async19480(map_LT___$1,f__$1,ch__$1,meta19478__$1,___$2,fn1__$1,meta19481));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19480(self__.map_LT_,self__.f,self__.ch,self__.meta19478,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19477.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19477.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19478","meta19478",24735181,null)], null);
});

cljs.core.async.t_cljs$core$async19477.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19477.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19477";

cljs.core.async.t_cljs$core$async19477.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19477");
});

cljs.core.async.__GT_t_cljs$core$async19477 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19477(map_LT___$1,f__$1,ch__$1,meta19478){
return (new cljs.core.async.t_cljs$core$async19477(map_LT___$1,f__$1,ch__$1,meta19478));
});

}

return (new cljs.core.async.t_cljs$core$async19477(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19486 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19486 = (function (map_GT_,f,ch,meta19487){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19487 = meta19487;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19488,meta19487__$1){
var self__ = this;
var _19488__$1 = this;
return (new cljs.core.async.t_cljs$core$async19486(self__.map_GT_,self__.f,self__.ch,meta19487__$1));
});

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19488){
var self__ = this;
var _19488__$1 = this;
return self__.meta19487;
});

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19486.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19487","meta19487",-466486377,null)], null);
});

cljs.core.async.t_cljs$core$async19486.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19486.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19486";

cljs.core.async.t_cljs$core$async19486.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19486");
});

cljs.core.async.__GT_t_cljs$core$async19486 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19486(map_GT___$1,f__$1,ch__$1,meta19487){
return (new cljs.core.async.t_cljs$core$async19486(map_GT___$1,f__$1,ch__$1,meta19487));
});

}

return (new cljs.core.async.t_cljs$core$async19486(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19492 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19492 = (function (filter_GT_,p,ch,meta19493){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19493 = meta19493;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19494,meta19493__$1){
var self__ = this;
var _19494__$1 = this;
return (new cljs.core.async.t_cljs$core$async19492(self__.filter_GT_,self__.p,self__.ch,meta19493__$1));
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19494){
var self__ = this;
var _19494__$1 = this;
return self__.meta19493;
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19492.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19493","meta19493",1346209505,null)], null);
});

cljs.core.async.t_cljs$core$async19492.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19492.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19492";

cljs.core.async.t_cljs$core$async19492.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19492");
});

cljs.core.async.__GT_t_cljs$core$async19492 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19492(filter_GT___$1,p__$1,ch__$1,meta19493){
return (new cljs.core.async.t_cljs$core$async19492(filter_GT___$1,p__$1,ch__$1,meta19493));
});

}

return (new cljs.core.async.t_cljs$core$async19492(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19495 = [];
var len__5726__auto___19539 = arguments.length;
var i__5727__auto___19540 = (0);
while(true){
if((i__5727__auto___19540 < len__5726__auto___19539)){
args19495.push((arguments[i__5727__auto___19540]));

var G__19541 = (i__5727__auto___19540 + (1));
i__5727__auto___19540 = G__19541;
continue;
} else {
}
break;
}

var G__19497 = args19495.length;
switch (G__19497) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19495.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19543 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19543,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19543,out){
return (function (state_19518){
var state_val_19519 = (state_19518[(1)]);
if((state_val_19519 === (7))){
var inst_19514 = (state_19518[(2)]);
var state_19518__$1 = state_19518;
var statearr_19520_19544 = state_19518__$1;
(statearr_19520_19544[(2)] = inst_19514);

(statearr_19520_19544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19519 === (1))){
var state_19518__$1 = state_19518;
var statearr_19521_19545 = state_19518__$1;
(statearr_19521_19545[(2)] = null);

(statearr_19521_19545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19519 === (4))){
var inst_19500 = (state_19518[(7)]);
var inst_19500__$1 = (state_19518[(2)]);
var inst_19501 = (inst_19500__$1 == null);
var state_19518__$1 = (function (){var statearr_19522 = state_19518;
(statearr_19522[(7)] = inst_19500__$1);

return statearr_19522;
})();
if(cljs.core.truth_(inst_19501)){
var statearr_19523_19546 = state_19518__$1;
(statearr_19523_19546[(1)] = (5));

} else {
var statearr_19524_19547 = state_19518__$1;
(statearr_19524_19547[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19519 === (6))){
var inst_19500 = (state_19518[(7)]);
var inst_19505 = p.call(null,inst_19500);
var state_19518__$1 = state_19518;
if(cljs.core.truth_(inst_19505)){
var statearr_19525_19548 = state_19518__$1;
(statearr_19525_19548[(1)] = (8));

} else {
var statearr_19526_19549 = state_19518__$1;
(statearr_19526_19549[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19519 === (3))){
var inst_19516 = (state_19518[(2)]);
var state_19518__$1 = state_19518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19518__$1,inst_19516);
} else {
if((state_val_19519 === (2))){
var state_19518__$1 = state_19518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19518__$1,(4),ch);
} else {
if((state_val_19519 === (11))){
var inst_19508 = (state_19518[(2)]);
var state_19518__$1 = state_19518;
var statearr_19527_19550 = state_19518__$1;
(statearr_19527_19550[(2)] = inst_19508);

(statearr_19527_19550[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19519 === (9))){
var state_19518__$1 = state_19518;
var statearr_19528_19551 = state_19518__$1;
(statearr_19528_19551[(2)] = null);

(statearr_19528_19551[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19519 === (5))){
var inst_19503 = cljs.core.async.close_BANG_.call(null,out);
var state_19518__$1 = state_19518;
var statearr_19529_19552 = state_19518__$1;
(statearr_19529_19552[(2)] = inst_19503);

(statearr_19529_19552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19519 === (10))){
var inst_19511 = (state_19518[(2)]);
var state_19518__$1 = (function (){var statearr_19530 = state_19518;
(statearr_19530[(8)] = inst_19511);

return statearr_19530;
})();
var statearr_19531_19553 = state_19518__$1;
(statearr_19531_19553[(2)] = null);

(statearr_19531_19553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19519 === (8))){
var inst_19500 = (state_19518[(7)]);
var state_19518__$1 = state_19518;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19518__$1,(11),out,inst_19500);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19543,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19543,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19535 = [null,null,null,null,null,null,null,null,null];
(statearr_19535[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19535[(1)] = (1));

return statearr_19535;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19518){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19536){if((e19536 instanceof Object)){
var ex__8254__auto__ = e19536;
var statearr_19537_19554 = state_19518;
(statearr_19537_19554[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19518);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19536;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19555 = state_19518;
state_19518 = G__19555;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19518){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19543,out))
})();
var state__8364__auto__ = (function (){var statearr_19538 = f__8363__auto__.call(null);
(statearr_19538[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19543);

return statearr_19538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19543,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19556 = [];
var len__5726__auto___19559 = arguments.length;
var i__5727__auto___19560 = (0);
while(true){
if((i__5727__auto___19560 < len__5726__auto___19559)){
args19556.push((arguments[i__5727__auto___19560]));

var G__19561 = (i__5727__auto___19560 + (1));
i__5727__auto___19560 = G__19561;
continue;
} else {
}
break;
}

var G__19558 = args19556.length;
switch (G__19558) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19556.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19728){
var state_val_19729 = (state_19728[(1)]);
if((state_val_19729 === (7))){
var inst_19724 = (state_19728[(2)]);
var state_19728__$1 = state_19728;
var statearr_19730_19771 = state_19728__$1;
(statearr_19730_19771[(2)] = inst_19724);

(statearr_19730_19771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (20))){
var inst_19694 = (state_19728[(7)]);
var inst_19705 = (state_19728[(2)]);
var inst_19706 = cljs.core.next.call(null,inst_19694);
var inst_19680 = inst_19706;
var inst_19681 = null;
var inst_19682 = (0);
var inst_19683 = (0);
var state_19728__$1 = (function (){var statearr_19731 = state_19728;
(statearr_19731[(8)] = inst_19682);

(statearr_19731[(9)] = inst_19705);

(statearr_19731[(10)] = inst_19680);

(statearr_19731[(11)] = inst_19683);

(statearr_19731[(12)] = inst_19681);

return statearr_19731;
})();
var statearr_19732_19772 = state_19728__$1;
(statearr_19732_19772[(2)] = null);

(statearr_19732_19772[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (1))){
var state_19728__$1 = state_19728;
var statearr_19733_19773 = state_19728__$1;
(statearr_19733_19773[(2)] = null);

(statearr_19733_19773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (4))){
var inst_19669 = (state_19728[(13)]);
var inst_19669__$1 = (state_19728[(2)]);
var inst_19670 = (inst_19669__$1 == null);
var state_19728__$1 = (function (){var statearr_19734 = state_19728;
(statearr_19734[(13)] = inst_19669__$1);

return statearr_19734;
})();
if(cljs.core.truth_(inst_19670)){
var statearr_19735_19774 = state_19728__$1;
(statearr_19735_19774[(1)] = (5));

} else {
var statearr_19736_19775 = state_19728__$1;
(statearr_19736_19775[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (15))){
var state_19728__$1 = state_19728;
var statearr_19740_19776 = state_19728__$1;
(statearr_19740_19776[(2)] = null);

(statearr_19740_19776[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (21))){
var state_19728__$1 = state_19728;
var statearr_19741_19777 = state_19728__$1;
(statearr_19741_19777[(2)] = null);

(statearr_19741_19777[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (13))){
var inst_19682 = (state_19728[(8)]);
var inst_19680 = (state_19728[(10)]);
var inst_19683 = (state_19728[(11)]);
var inst_19681 = (state_19728[(12)]);
var inst_19690 = (state_19728[(2)]);
var inst_19691 = (inst_19683 + (1));
var tmp19737 = inst_19682;
var tmp19738 = inst_19680;
var tmp19739 = inst_19681;
var inst_19680__$1 = tmp19738;
var inst_19681__$1 = tmp19739;
var inst_19682__$1 = tmp19737;
var inst_19683__$1 = inst_19691;
var state_19728__$1 = (function (){var statearr_19742 = state_19728;
(statearr_19742[(8)] = inst_19682__$1);

(statearr_19742[(10)] = inst_19680__$1);

(statearr_19742[(11)] = inst_19683__$1);

(statearr_19742[(12)] = inst_19681__$1);

(statearr_19742[(14)] = inst_19690);

return statearr_19742;
})();
var statearr_19743_19778 = state_19728__$1;
(statearr_19743_19778[(2)] = null);

(statearr_19743_19778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (22))){
var state_19728__$1 = state_19728;
var statearr_19744_19779 = state_19728__$1;
(statearr_19744_19779[(2)] = null);

(statearr_19744_19779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (6))){
var inst_19669 = (state_19728[(13)]);
var inst_19678 = f.call(null,inst_19669);
var inst_19679 = cljs.core.seq.call(null,inst_19678);
var inst_19680 = inst_19679;
var inst_19681 = null;
var inst_19682 = (0);
var inst_19683 = (0);
var state_19728__$1 = (function (){var statearr_19745 = state_19728;
(statearr_19745[(8)] = inst_19682);

(statearr_19745[(10)] = inst_19680);

(statearr_19745[(11)] = inst_19683);

(statearr_19745[(12)] = inst_19681);

return statearr_19745;
})();
var statearr_19746_19780 = state_19728__$1;
(statearr_19746_19780[(2)] = null);

(statearr_19746_19780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (17))){
var inst_19694 = (state_19728[(7)]);
var inst_19698 = cljs.core.chunk_first.call(null,inst_19694);
var inst_19699 = cljs.core.chunk_rest.call(null,inst_19694);
var inst_19700 = cljs.core.count.call(null,inst_19698);
var inst_19680 = inst_19699;
var inst_19681 = inst_19698;
var inst_19682 = inst_19700;
var inst_19683 = (0);
var state_19728__$1 = (function (){var statearr_19747 = state_19728;
(statearr_19747[(8)] = inst_19682);

(statearr_19747[(10)] = inst_19680);

(statearr_19747[(11)] = inst_19683);

(statearr_19747[(12)] = inst_19681);

return statearr_19747;
})();
var statearr_19748_19781 = state_19728__$1;
(statearr_19748_19781[(2)] = null);

(statearr_19748_19781[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (3))){
var inst_19726 = (state_19728[(2)]);
var state_19728__$1 = state_19728;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19728__$1,inst_19726);
} else {
if((state_val_19729 === (12))){
var inst_19714 = (state_19728[(2)]);
var state_19728__$1 = state_19728;
var statearr_19749_19782 = state_19728__$1;
(statearr_19749_19782[(2)] = inst_19714);

(statearr_19749_19782[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (2))){
var state_19728__$1 = state_19728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19728__$1,(4),in$);
} else {
if((state_val_19729 === (23))){
var inst_19722 = (state_19728[(2)]);
var state_19728__$1 = state_19728;
var statearr_19750_19783 = state_19728__$1;
(statearr_19750_19783[(2)] = inst_19722);

(statearr_19750_19783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (19))){
var inst_19709 = (state_19728[(2)]);
var state_19728__$1 = state_19728;
var statearr_19751_19784 = state_19728__$1;
(statearr_19751_19784[(2)] = inst_19709);

(statearr_19751_19784[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (11))){
var inst_19680 = (state_19728[(10)]);
var inst_19694 = (state_19728[(7)]);
var inst_19694__$1 = cljs.core.seq.call(null,inst_19680);
var state_19728__$1 = (function (){var statearr_19752 = state_19728;
(statearr_19752[(7)] = inst_19694__$1);

return statearr_19752;
})();
if(inst_19694__$1){
var statearr_19753_19785 = state_19728__$1;
(statearr_19753_19785[(1)] = (14));

} else {
var statearr_19754_19786 = state_19728__$1;
(statearr_19754_19786[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (9))){
var inst_19716 = (state_19728[(2)]);
var inst_19717 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19728__$1 = (function (){var statearr_19755 = state_19728;
(statearr_19755[(15)] = inst_19716);

return statearr_19755;
})();
if(cljs.core.truth_(inst_19717)){
var statearr_19756_19787 = state_19728__$1;
(statearr_19756_19787[(1)] = (21));

} else {
var statearr_19757_19788 = state_19728__$1;
(statearr_19757_19788[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (5))){
var inst_19672 = cljs.core.async.close_BANG_.call(null,out);
var state_19728__$1 = state_19728;
var statearr_19758_19789 = state_19728__$1;
(statearr_19758_19789[(2)] = inst_19672);

(statearr_19758_19789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (14))){
var inst_19694 = (state_19728[(7)]);
var inst_19696 = cljs.core.chunked_seq_QMARK_.call(null,inst_19694);
var state_19728__$1 = state_19728;
if(inst_19696){
var statearr_19759_19790 = state_19728__$1;
(statearr_19759_19790[(1)] = (17));

} else {
var statearr_19760_19791 = state_19728__$1;
(statearr_19760_19791[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (16))){
var inst_19712 = (state_19728[(2)]);
var state_19728__$1 = state_19728;
var statearr_19761_19792 = state_19728__$1;
(statearr_19761_19792[(2)] = inst_19712);

(statearr_19761_19792[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19729 === (10))){
var inst_19683 = (state_19728[(11)]);
var inst_19681 = (state_19728[(12)]);
var inst_19688 = cljs.core._nth.call(null,inst_19681,inst_19683);
var state_19728__$1 = state_19728;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19728__$1,(13),out,inst_19688);
} else {
if((state_val_19729 === (18))){
var inst_19694 = (state_19728[(7)]);
var inst_19703 = cljs.core.first.call(null,inst_19694);
var state_19728__$1 = state_19728;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19728__$1,(20),out,inst_19703);
} else {
if((state_val_19729 === (8))){
var inst_19682 = (state_19728[(8)]);
var inst_19683 = (state_19728[(11)]);
var inst_19685 = (inst_19683 < inst_19682);
var inst_19686 = inst_19685;
var state_19728__$1 = state_19728;
if(cljs.core.truth_(inst_19686)){
var statearr_19762_19793 = state_19728__$1;
(statearr_19762_19793[(1)] = (10));

} else {
var statearr_19763_19794 = state_19728__$1;
(statearr_19763_19794[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19767 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19767[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19767[(1)] = (1));

return statearr_19767;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19728){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19768){if((e19768 instanceof Object)){
var ex__8254__auto__ = e19768;
var statearr_19769_19795 = state_19728;
(statearr_19769_19795[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19728);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19768;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19796 = state_19728;
state_19728 = G__19796;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19728){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19770 = f__8363__auto__.call(null);
(statearr_19770[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19797 = [];
var len__5726__auto___19800 = arguments.length;
var i__5727__auto___19801 = (0);
while(true){
if((i__5727__auto___19801 < len__5726__auto___19800)){
args19797.push((arguments[i__5727__auto___19801]));

var G__19802 = (i__5727__auto___19801 + (1));
i__5727__auto___19801 = G__19802;
continue;
} else {
}
break;
}

var G__19799 = args19797.length;
switch (G__19799) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19797.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19804 = [];
var len__5726__auto___19807 = arguments.length;
var i__5727__auto___19808 = (0);
while(true){
if((i__5727__auto___19808 < len__5726__auto___19807)){
args19804.push((arguments[i__5727__auto___19808]));

var G__19809 = (i__5727__auto___19808 + (1));
i__5727__auto___19808 = G__19809;
continue;
} else {
}
break;
}

var G__19806 = args19804.length;
switch (G__19806) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19804.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19811 = [];
var len__5726__auto___19862 = arguments.length;
var i__5727__auto___19863 = (0);
while(true){
if((i__5727__auto___19863 < len__5726__auto___19862)){
args19811.push((arguments[i__5727__auto___19863]));

var G__19864 = (i__5727__auto___19863 + (1));
i__5727__auto___19863 = G__19864;
continue;
} else {
}
break;
}

var G__19813 = args19811.length;
switch (G__19813) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19811.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19866 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19866,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19866,out){
return (function (state_19837){
var state_val_19838 = (state_19837[(1)]);
if((state_val_19838 === (7))){
var inst_19832 = (state_19837[(2)]);
var state_19837__$1 = state_19837;
var statearr_19839_19867 = state_19837__$1;
(statearr_19839_19867[(2)] = inst_19832);

(statearr_19839_19867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19838 === (1))){
var inst_19814 = null;
var state_19837__$1 = (function (){var statearr_19840 = state_19837;
(statearr_19840[(7)] = inst_19814);

return statearr_19840;
})();
var statearr_19841_19868 = state_19837__$1;
(statearr_19841_19868[(2)] = null);

(statearr_19841_19868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19838 === (4))){
var inst_19817 = (state_19837[(8)]);
var inst_19817__$1 = (state_19837[(2)]);
var inst_19818 = (inst_19817__$1 == null);
var inst_19819 = cljs.core.not.call(null,inst_19818);
var state_19837__$1 = (function (){var statearr_19842 = state_19837;
(statearr_19842[(8)] = inst_19817__$1);

return statearr_19842;
})();
if(inst_19819){
var statearr_19843_19869 = state_19837__$1;
(statearr_19843_19869[(1)] = (5));

} else {
var statearr_19844_19870 = state_19837__$1;
(statearr_19844_19870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19838 === (6))){
var state_19837__$1 = state_19837;
var statearr_19845_19871 = state_19837__$1;
(statearr_19845_19871[(2)] = null);

(statearr_19845_19871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19838 === (3))){
var inst_19834 = (state_19837[(2)]);
var inst_19835 = cljs.core.async.close_BANG_.call(null,out);
var state_19837__$1 = (function (){var statearr_19846 = state_19837;
(statearr_19846[(9)] = inst_19834);

return statearr_19846;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19837__$1,inst_19835);
} else {
if((state_val_19838 === (2))){
var state_19837__$1 = state_19837;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19837__$1,(4),ch);
} else {
if((state_val_19838 === (11))){
var inst_19817 = (state_19837[(8)]);
var inst_19826 = (state_19837[(2)]);
var inst_19814 = inst_19817;
var state_19837__$1 = (function (){var statearr_19847 = state_19837;
(statearr_19847[(10)] = inst_19826);

(statearr_19847[(7)] = inst_19814);

return statearr_19847;
})();
var statearr_19848_19872 = state_19837__$1;
(statearr_19848_19872[(2)] = null);

(statearr_19848_19872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19838 === (9))){
var inst_19817 = (state_19837[(8)]);
var state_19837__$1 = state_19837;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19837__$1,(11),out,inst_19817);
} else {
if((state_val_19838 === (5))){
var inst_19814 = (state_19837[(7)]);
var inst_19817 = (state_19837[(8)]);
var inst_19821 = cljs.core._EQ_.call(null,inst_19817,inst_19814);
var state_19837__$1 = state_19837;
if(inst_19821){
var statearr_19850_19873 = state_19837__$1;
(statearr_19850_19873[(1)] = (8));

} else {
var statearr_19851_19874 = state_19837__$1;
(statearr_19851_19874[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19838 === (10))){
var inst_19829 = (state_19837[(2)]);
var state_19837__$1 = state_19837;
var statearr_19852_19875 = state_19837__$1;
(statearr_19852_19875[(2)] = inst_19829);

(statearr_19852_19875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19838 === (8))){
var inst_19814 = (state_19837[(7)]);
var tmp19849 = inst_19814;
var inst_19814__$1 = tmp19849;
var state_19837__$1 = (function (){var statearr_19853 = state_19837;
(statearr_19853[(7)] = inst_19814__$1);

return statearr_19853;
})();
var statearr_19854_19876 = state_19837__$1;
(statearr_19854_19876[(2)] = null);

(statearr_19854_19876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19866,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19866,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19858 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19858[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19858[(1)] = (1));

return statearr_19858;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19837){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19837);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19859){if((e19859 instanceof Object)){
var ex__8254__auto__ = e19859;
var statearr_19860_19877 = state_19837;
(statearr_19860_19877[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19837);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19859;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19878 = state_19837;
state_19837 = G__19878;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19837){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19866,out))
})();
var state__8364__auto__ = (function (){var statearr_19861 = f__8363__auto__.call(null);
(statearr_19861[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19866);

return statearr_19861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19866,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19879 = [];
var len__5726__auto___19949 = arguments.length;
var i__5727__auto___19950 = (0);
while(true){
if((i__5727__auto___19950 < len__5726__auto___19949)){
args19879.push((arguments[i__5727__auto___19950]));

var G__19951 = (i__5727__auto___19950 + (1));
i__5727__auto___19950 = G__19951;
continue;
} else {
}
break;
}

var G__19881 = args19879.length;
switch (G__19881) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19879.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19953 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19953,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19953,out){
return (function (state_19919){
var state_val_19920 = (state_19919[(1)]);
if((state_val_19920 === (7))){
var inst_19915 = (state_19919[(2)]);
var state_19919__$1 = state_19919;
var statearr_19921_19954 = state_19919__$1;
(statearr_19921_19954[(2)] = inst_19915);

(statearr_19921_19954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (1))){
var inst_19882 = (new Array(n));
var inst_19883 = inst_19882;
var inst_19884 = (0);
var state_19919__$1 = (function (){var statearr_19922 = state_19919;
(statearr_19922[(7)] = inst_19883);

(statearr_19922[(8)] = inst_19884);

return statearr_19922;
})();
var statearr_19923_19955 = state_19919__$1;
(statearr_19923_19955[(2)] = null);

(statearr_19923_19955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (4))){
var inst_19887 = (state_19919[(9)]);
var inst_19887__$1 = (state_19919[(2)]);
var inst_19888 = (inst_19887__$1 == null);
var inst_19889 = cljs.core.not.call(null,inst_19888);
var state_19919__$1 = (function (){var statearr_19924 = state_19919;
(statearr_19924[(9)] = inst_19887__$1);

return statearr_19924;
})();
if(inst_19889){
var statearr_19925_19956 = state_19919__$1;
(statearr_19925_19956[(1)] = (5));

} else {
var statearr_19926_19957 = state_19919__$1;
(statearr_19926_19957[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (15))){
var inst_19909 = (state_19919[(2)]);
var state_19919__$1 = state_19919;
var statearr_19927_19958 = state_19919__$1;
(statearr_19927_19958[(2)] = inst_19909);

(statearr_19927_19958[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (13))){
var state_19919__$1 = state_19919;
var statearr_19928_19959 = state_19919__$1;
(statearr_19928_19959[(2)] = null);

(statearr_19928_19959[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (6))){
var inst_19884 = (state_19919[(8)]);
var inst_19905 = (inst_19884 > (0));
var state_19919__$1 = state_19919;
if(cljs.core.truth_(inst_19905)){
var statearr_19929_19960 = state_19919__$1;
(statearr_19929_19960[(1)] = (12));

} else {
var statearr_19930_19961 = state_19919__$1;
(statearr_19930_19961[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (3))){
var inst_19917 = (state_19919[(2)]);
var state_19919__$1 = state_19919;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19919__$1,inst_19917);
} else {
if((state_val_19920 === (12))){
var inst_19883 = (state_19919[(7)]);
var inst_19907 = cljs.core.vec.call(null,inst_19883);
var state_19919__$1 = state_19919;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19919__$1,(15),out,inst_19907);
} else {
if((state_val_19920 === (2))){
var state_19919__$1 = state_19919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19919__$1,(4),ch);
} else {
if((state_val_19920 === (11))){
var inst_19899 = (state_19919[(2)]);
var inst_19900 = (new Array(n));
var inst_19883 = inst_19900;
var inst_19884 = (0);
var state_19919__$1 = (function (){var statearr_19931 = state_19919;
(statearr_19931[(7)] = inst_19883);

(statearr_19931[(10)] = inst_19899);

(statearr_19931[(8)] = inst_19884);

return statearr_19931;
})();
var statearr_19932_19962 = state_19919__$1;
(statearr_19932_19962[(2)] = null);

(statearr_19932_19962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (9))){
var inst_19883 = (state_19919[(7)]);
var inst_19897 = cljs.core.vec.call(null,inst_19883);
var state_19919__$1 = state_19919;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19919__$1,(11),out,inst_19897);
} else {
if((state_val_19920 === (5))){
var inst_19883 = (state_19919[(7)]);
var inst_19887 = (state_19919[(9)]);
var inst_19892 = (state_19919[(11)]);
var inst_19884 = (state_19919[(8)]);
var inst_19891 = (inst_19883[inst_19884] = inst_19887);
var inst_19892__$1 = (inst_19884 + (1));
var inst_19893 = (inst_19892__$1 < n);
var state_19919__$1 = (function (){var statearr_19933 = state_19919;
(statearr_19933[(11)] = inst_19892__$1);

(statearr_19933[(12)] = inst_19891);

return statearr_19933;
})();
if(cljs.core.truth_(inst_19893)){
var statearr_19934_19963 = state_19919__$1;
(statearr_19934_19963[(1)] = (8));

} else {
var statearr_19935_19964 = state_19919__$1;
(statearr_19935_19964[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (14))){
var inst_19912 = (state_19919[(2)]);
var inst_19913 = cljs.core.async.close_BANG_.call(null,out);
var state_19919__$1 = (function (){var statearr_19937 = state_19919;
(statearr_19937[(13)] = inst_19912);

return statearr_19937;
})();
var statearr_19938_19965 = state_19919__$1;
(statearr_19938_19965[(2)] = inst_19913);

(statearr_19938_19965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (10))){
var inst_19903 = (state_19919[(2)]);
var state_19919__$1 = state_19919;
var statearr_19939_19966 = state_19919__$1;
(statearr_19939_19966[(2)] = inst_19903);

(statearr_19939_19966[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19920 === (8))){
var inst_19883 = (state_19919[(7)]);
var inst_19892 = (state_19919[(11)]);
var tmp19936 = inst_19883;
var inst_19883__$1 = tmp19936;
var inst_19884 = inst_19892;
var state_19919__$1 = (function (){var statearr_19940 = state_19919;
(statearr_19940[(7)] = inst_19883__$1);

(statearr_19940[(8)] = inst_19884);

return statearr_19940;
})();
var statearr_19941_19967 = state_19919__$1;
(statearr_19941_19967[(2)] = null);

(statearr_19941_19967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19953,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19953,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19945 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19945[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19945[(1)] = (1));

return statearr_19945;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19919){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19919);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19946){if((e19946 instanceof Object)){
var ex__8254__auto__ = e19946;
var statearr_19947_19968 = state_19919;
(statearr_19947_19968[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19919);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19946;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19969 = state_19919;
state_19919 = G__19969;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19953,out))
})();
var state__8364__auto__ = (function (){var statearr_19948 = f__8363__auto__.call(null);
(statearr_19948[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19953);

return statearr_19948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19953,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19970 = [];
var len__5726__auto___20044 = arguments.length;
var i__5727__auto___20045 = (0);
while(true){
if((i__5727__auto___20045 < len__5726__auto___20044)){
args19970.push((arguments[i__5727__auto___20045]));

var G__20046 = (i__5727__auto___20045 + (1));
i__5727__auto___20045 = G__20046;
continue;
} else {
}
break;
}

var G__19972 = args19970.length;
switch (G__19972) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19970.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20048 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20048,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20048,out){
return (function (state_20014){
var state_val_20015 = (state_20014[(1)]);
if((state_val_20015 === (7))){
var inst_20010 = (state_20014[(2)]);
var state_20014__$1 = state_20014;
var statearr_20016_20049 = state_20014__$1;
(statearr_20016_20049[(2)] = inst_20010);

(statearr_20016_20049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (1))){
var inst_19973 = [];
var inst_19974 = inst_19973;
var inst_19975 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20014__$1 = (function (){var statearr_20017 = state_20014;
(statearr_20017[(7)] = inst_19975);

(statearr_20017[(8)] = inst_19974);

return statearr_20017;
})();
var statearr_20018_20050 = state_20014__$1;
(statearr_20018_20050[(2)] = null);

(statearr_20018_20050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (4))){
var inst_19978 = (state_20014[(9)]);
var inst_19978__$1 = (state_20014[(2)]);
var inst_19979 = (inst_19978__$1 == null);
var inst_19980 = cljs.core.not.call(null,inst_19979);
var state_20014__$1 = (function (){var statearr_20019 = state_20014;
(statearr_20019[(9)] = inst_19978__$1);

return statearr_20019;
})();
if(inst_19980){
var statearr_20020_20051 = state_20014__$1;
(statearr_20020_20051[(1)] = (5));

} else {
var statearr_20021_20052 = state_20014__$1;
(statearr_20021_20052[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (15))){
var inst_20004 = (state_20014[(2)]);
var state_20014__$1 = state_20014;
var statearr_20022_20053 = state_20014__$1;
(statearr_20022_20053[(2)] = inst_20004);

(statearr_20022_20053[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (13))){
var state_20014__$1 = state_20014;
var statearr_20023_20054 = state_20014__$1;
(statearr_20023_20054[(2)] = null);

(statearr_20023_20054[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (6))){
var inst_19974 = (state_20014[(8)]);
var inst_19999 = inst_19974.length;
var inst_20000 = (inst_19999 > (0));
var state_20014__$1 = state_20014;
if(cljs.core.truth_(inst_20000)){
var statearr_20024_20055 = state_20014__$1;
(statearr_20024_20055[(1)] = (12));

} else {
var statearr_20025_20056 = state_20014__$1;
(statearr_20025_20056[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (3))){
var inst_20012 = (state_20014[(2)]);
var state_20014__$1 = state_20014;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20014__$1,inst_20012);
} else {
if((state_val_20015 === (12))){
var inst_19974 = (state_20014[(8)]);
var inst_20002 = cljs.core.vec.call(null,inst_19974);
var state_20014__$1 = state_20014;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20014__$1,(15),out,inst_20002);
} else {
if((state_val_20015 === (2))){
var state_20014__$1 = state_20014;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20014__$1,(4),ch);
} else {
if((state_val_20015 === (11))){
var inst_19978 = (state_20014[(9)]);
var inst_19982 = (state_20014[(10)]);
var inst_19992 = (state_20014[(2)]);
var inst_19993 = [];
var inst_19994 = inst_19993.push(inst_19978);
var inst_19974 = inst_19993;
var inst_19975 = inst_19982;
var state_20014__$1 = (function (){var statearr_20026 = state_20014;
(statearr_20026[(11)] = inst_19992);

(statearr_20026[(12)] = inst_19994);

(statearr_20026[(7)] = inst_19975);

(statearr_20026[(8)] = inst_19974);

return statearr_20026;
})();
var statearr_20027_20057 = state_20014__$1;
(statearr_20027_20057[(2)] = null);

(statearr_20027_20057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (9))){
var inst_19974 = (state_20014[(8)]);
var inst_19990 = cljs.core.vec.call(null,inst_19974);
var state_20014__$1 = state_20014;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20014__$1,(11),out,inst_19990);
} else {
if((state_val_20015 === (5))){
var inst_19978 = (state_20014[(9)]);
var inst_19982 = (state_20014[(10)]);
var inst_19975 = (state_20014[(7)]);
var inst_19982__$1 = f.call(null,inst_19978);
var inst_19983 = cljs.core._EQ_.call(null,inst_19982__$1,inst_19975);
var inst_19984 = cljs.core.keyword_identical_QMARK_.call(null,inst_19975,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19985 = (inst_19983) || (inst_19984);
var state_20014__$1 = (function (){var statearr_20028 = state_20014;
(statearr_20028[(10)] = inst_19982__$1);

return statearr_20028;
})();
if(cljs.core.truth_(inst_19985)){
var statearr_20029_20058 = state_20014__$1;
(statearr_20029_20058[(1)] = (8));

} else {
var statearr_20030_20059 = state_20014__$1;
(statearr_20030_20059[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (14))){
var inst_20007 = (state_20014[(2)]);
var inst_20008 = cljs.core.async.close_BANG_.call(null,out);
var state_20014__$1 = (function (){var statearr_20032 = state_20014;
(statearr_20032[(13)] = inst_20007);

return statearr_20032;
})();
var statearr_20033_20060 = state_20014__$1;
(statearr_20033_20060[(2)] = inst_20008);

(statearr_20033_20060[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (10))){
var inst_19997 = (state_20014[(2)]);
var state_20014__$1 = state_20014;
var statearr_20034_20061 = state_20014__$1;
(statearr_20034_20061[(2)] = inst_19997);

(statearr_20034_20061[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20015 === (8))){
var inst_19978 = (state_20014[(9)]);
var inst_19982 = (state_20014[(10)]);
var inst_19974 = (state_20014[(8)]);
var inst_19987 = inst_19974.push(inst_19978);
var tmp20031 = inst_19974;
var inst_19974__$1 = tmp20031;
var inst_19975 = inst_19982;
var state_20014__$1 = (function (){var statearr_20035 = state_20014;
(statearr_20035[(14)] = inst_19987);

(statearr_20035[(7)] = inst_19975);

(statearr_20035[(8)] = inst_19974__$1);

return statearr_20035;
})();
var statearr_20036_20062 = state_20014__$1;
(statearr_20036_20062[(2)] = null);

(statearr_20036_20062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20048,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20048,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_20040 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20040[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_20040[(1)] = (1));

return statearr_20040;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_20014){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_20014);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e20041){if((e20041 instanceof Object)){
var ex__8254__auto__ = e20041;
var statearr_20042_20063 = state_20014;
(statearr_20042_20063[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20014);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20064 = state_20014;
state_20014 = G__20064;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_20014){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_20014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20048,out))
})();
var state__8364__auto__ = (function (){var statearr_20043 = f__8363__auto__.call(null);
(statearr_20043[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20048);

return statearr_20043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20048,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1459753782534