// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__20164__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__20163 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__20163,(0),null);
var body = cljs.core.nthnext.call(null,vec__20163,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__20164 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__20165__i = 0, G__20165__a = new Array(arguments.length -  0);
while (G__20165__i < G__20165__a.length) {G__20165__a[G__20165__i] = arguments[G__20165__i + 0]; ++G__20165__i;}
  args = new cljs.core.IndexedSeq(G__20165__a,0);
} 
return G__20164__delegate.call(this,args);};
G__20164.cljs$lang$maxFixedArity = 0;
G__20164.cljs$lang$applyTo = (function (arglist__20166){
var args = cljs.core.seq(arglist__20166);
return G__20164__delegate(args);
});
G__20164.cljs$core$IFn$_invoke$arity$variadic = G__20164__delegate;
return G__20164;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__20171(s__20172){
return (new cljs.core.LazySeq(null,(function (){
var s__20172__$1 = s__20172;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20172__$1);
if(temp__4425__auto__){
var s__20172__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20172__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20172__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20174 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20173 = (0);
while(true){
if((i__20173 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__20173);
cljs.core.chunk_append.call(null,b__20174,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__20175 = (i__20173 + (1));
i__20173 = G__20175;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20174),sablono$core$update_arglists_$_iter__20171.call(null,cljs.core.chunk_rest.call(null,s__20172__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20174),null);
}
} else {
var args = cljs.core.first.call(null,s__20172__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__20171.call(null,cljs.core.rest.call(null,s__20172__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20181 = arguments.length;
var i__5727__auto___20182 = (0);
while(true){
if((i__5727__auto___20182 < len__5726__auto___20181)){
args__5733__auto__.push((arguments[i__5727__auto___20182]));

var G__20183 = (i__5727__auto___20182 + (1));
i__5727__auto___20182 = G__20183;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__20177(s__20178){
return (new cljs.core.LazySeq(null,(function (){
var s__20178__$1 = s__20178;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20178__$1);
if(temp__4425__auto__){
var s__20178__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20178__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20178__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20180 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20179 = (0);
while(true){
if((i__20179 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__20179);
cljs.core.chunk_append.call(null,b__20180,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__20184 = (i__20179 + (1));
i__20179 = G__20184;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20180),sablono$core$iter__20177.call(null,cljs.core.chunk_rest.call(null,s__20178__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20180),null);
}
} else {
var style = cljs.core.first.call(null,s__20178__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__20177.call(null,cljs.core.rest.call(null,s__20178__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq20176){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20176));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to20185 = (function sablono$core$link_to20185(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20188 = arguments.length;
var i__5727__auto___20189 = (0);
while(true){
if((i__5727__auto___20189 < len__5726__auto___20188)){
args__5733__auto__.push((arguments[i__5727__auto___20189]));

var G__20190 = (i__5727__auto___20189 + (1));
i__5727__auto___20189 = G__20190;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to20185.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to20185.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to20185.cljs$lang$maxFixedArity = (1);

sablono.core.link_to20185.cljs$lang$applyTo = (function (seq20186){
var G__20187 = cljs.core.first.call(null,seq20186);
var seq20186__$1 = cljs.core.next.call(null,seq20186);
return sablono.core.link_to20185.cljs$core$IFn$_invoke$arity$variadic(G__20187,seq20186__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to20185);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to20191 = (function sablono$core$mail_to20191(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20196 = arguments.length;
var i__5727__auto___20197 = (0);
while(true){
if((i__5727__auto___20197 < len__5726__auto___20196)){
args__5733__auto__.push((arguments[i__5727__auto___20197]));

var G__20198 = (i__5727__auto___20197 + (1));
i__5727__auto___20197 = G__20198;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to20191.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to20191.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__20194){
var vec__20195 = p__20194;
var content = cljs.core.nth.call(null,vec__20195,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to20191.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to20191.cljs$lang$applyTo = (function (seq20192){
var G__20193 = cljs.core.first.call(null,seq20192);
var seq20192__$1 = cljs.core.next.call(null,seq20192);
return sablono.core.mail_to20191.cljs$core$IFn$_invoke$arity$variadic(G__20193,seq20192__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to20191);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list20199 = (function sablono$core$unordered_list20199(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list20199_$_iter__20204(s__20205){
return (new cljs.core.LazySeq(null,(function (){
var s__20205__$1 = s__20205;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20205__$1);
if(temp__4425__auto__){
var s__20205__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20205__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20205__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20207 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20206 = (0);
while(true){
if((i__20206 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20206);
cljs.core.chunk_append.call(null,b__20207,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20208 = (i__20206 + (1));
i__20206 = G__20208;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20207),sablono$core$unordered_list20199_$_iter__20204.call(null,cljs.core.chunk_rest.call(null,s__20205__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20207),null);
}
} else {
var x = cljs.core.first.call(null,s__20205__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list20199_$_iter__20204.call(null,cljs.core.rest.call(null,s__20205__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list20199);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list20209 = (function sablono$core$ordered_list20209(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list20209_$_iter__20214(s__20215){
return (new cljs.core.LazySeq(null,(function (){
var s__20215__$1 = s__20215;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20215__$1);
if(temp__4425__auto__){
var s__20215__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20215__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20215__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20217 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20216 = (0);
while(true){
if((i__20216 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20216);
cljs.core.chunk_append.call(null,b__20217,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20218 = (i__20216 + (1));
i__20216 = G__20218;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20217),sablono$core$ordered_list20209_$_iter__20214.call(null,cljs.core.chunk_rest.call(null,s__20215__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20217),null);
}
} else {
var x = cljs.core.first.call(null,s__20215__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list20209_$_iter__20214.call(null,cljs.core.rest.call(null,s__20215__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list20209);
/**
 * Create an image element.
 */
sablono.core.image20219 = (function sablono$core$image20219(var_args){
var args20220 = [];
var len__5726__auto___20223 = arguments.length;
var i__5727__auto___20224 = (0);
while(true){
if((i__5727__auto___20224 < len__5726__auto___20223)){
args20220.push((arguments[i__5727__auto___20224]));

var G__20225 = (i__5727__auto___20224 + (1));
i__5727__auto___20224 = G__20225;
continue;
} else {
}
break;
}

var G__20222 = args20220.length;
switch (G__20222) {
case 1:
return sablono.core.image20219.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image20219.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20220.length)].join('')));

}
});

sablono.core.image20219.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image20219.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image20219.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image20219);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__20227_SHARP_,p2__20228_SHARP_){
return [cljs.core.str(p1__20227_SHARP_),cljs.core.str("["),cljs.core.str(p2__20228_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__20229_SHARP_,p2__20230_SHARP_){
return [cljs.core.str(p1__20229_SHARP_),cljs.core.str("-"),cljs.core.str(p2__20230_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field20231 = (function sablono$core$color_field20231(var_args){
var args20232 = [];
var len__5726__auto___20299 = arguments.length;
var i__5727__auto___20300 = (0);
while(true){
if((i__5727__auto___20300 < len__5726__auto___20299)){
args20232.push((arguments[i__5727__auto___20300]));

var G__20301 = (i__5727__auto___20300 + (1));
i__5727__auto___20300 = G__20301;
continue;
} else {
}
break;
}

var G__20234 = args20232.length;
switch (G__20234) {
case 1:
return sablono.core.color_field20231.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field20231.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20232.length)].join('')));

}
});

sablono.core.color_field20231.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.color_field20231.call(null,name__11649__auto__,null);
});

sablono.core.color_field20231.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.color_field20231.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field20231);

/**
 * Creates a date input field.
 */
sablono.core.date_field20235 = (function sablono$core$date_field20235(var_args){
var args20236 = [];
var len__5726__auto___20303 = arguments.length;
var i__5727__auto___20304 = (0);
while(true){
if((i__5727__auto___20304 < len__5726__auto___20303)){
args20236.push((arguments[i__5727__auto___20304]));

var G__20305 = (i__5727__auto___20304 + (1));
i__5727__auto___20304 = G__20305;
continue;
} else {
}
break;
}

var G__20238 = args20236.length;
switch (G__20238) {
case 1:
return sablono.core.date_field20235.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field20235.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20236.length)].join('')));

}
});

sablono.core.date_field20235.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.date_field20235.call(null,name__11649__auto__,null);
});

sablono.core.date_field20235.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.date_field20235.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field20235);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field20239 = (function sablono$core$datetime_field20239(var_args){
var args20240 = [];
var len__5726__auto___20307 = arguments.length;
var i__5727__auto___20308 = (0);
while(true){
if((i__5727__auto___20308 < len__5726__auto___20307)){
args20240.push((arguments[i__5727__auto___20308]));

var G__20309 = (i__5727__auto___20308 + (1));
i__5727__auto___20308 = G__20309;
continue;
} else {
}
break;
}

var G__20242 = args20240.length;
switch (G__20242) {
case 1:
return sablono.core.datetime_field20239.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field20239.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20240.length)].join('')));

}
});

sablono.core.datetime_field20239.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_field20239.call(null,name__11649__auto__,null);
});

sablono.core.datetime_field20239.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_field20239.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field20239);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field20243 = (function sablono$core$datetime_local_field20243(var_args){
var args20244 = [];
var len__5726__auto___20311 = arguments.length;
var i__5727__auto___20312 = (0);
while(true){
if((i__5727__auto___20312 < len__5726__auto___20311)){
args20244.push((arguments[i__5727__auto___20312]));

var G__20313 = (i__5727__auto___20312 + (1));
i__5727__auto___20312 = G__20313;
continue;
} else {
}
break;
}

var G__20246 = args20244.length;
switch (G__20246) {
case 1:
return sablono.core.datetime_local_field20243.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field20243.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20244.length)].join('')));

}
});

sablono.core.datetime_local_field20243.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_local_field20243.call(null,name__11649__auto__,null);
});

sablono.core.datetime_local_field20243.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_local_field20243.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field20243);

/**
 * Creates a email input field.
 */
sablono.core.email_field20247 = (function sablono$core$email_field20247(var_args){
var args20248 = [];
var len__5726__auto___20315 = arguments.length;
var i__5727__auto___20316 = (0);
while(true){
if((i__5727__auto___20316 < len__5726__auto___20315)){
args20248.push((arguments[i__5727__auto___20316]));

var G__20317 = (i__5727__auto___20316 + (1));
i__5727__auto___20316 = G__20317;
continue;
} else {
}
break;
}

var G__20250 = args20248.length;
switch (G__20250) {
case 1:
return sablono.core.email_field20247.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field20247.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20248.length)].join('')));

}
});

sablono.core.email_field20247.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.email_field20247.call(null,name__11649__auto__,null);
});

sablono.core.email_field20247.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.email_field20247.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field20247);

/**
 * Creates a file input field.
 */
sablono.core.file_field20251 = (function sablono$core$file_field20251(var_args){
var args20252 = [];
var len__5726__auto___20319 = arguments.length;
var i__5727__auto___20320 = (0);
while(true){
if((i__5727__auto___20320 < len__5726__auto___20319)){
args20252.push((arguments[i__5727__auto___20320]));

var G__20321 = (i__5727__auto___20320 + (1));
i__5727__auto___20320 = G__20321;
continue;
} else {
}
break;
}

var G__20254 = args20252.length;
switch (G__20254) {
case 1:
return sablono.core.file_field20251.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field20251.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20252.length)].join('')));

}
});

sablono.core.file_field20251.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.file_field20251.call(null,name__11649__auto__,null);
});

sablono.core.file_field20251.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.file_field20251.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field20251);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field20255 = (function sablono$core$hidden_field20255(var_args){
var args20256 = [];
var len__5726__auto___20323 = arguments.length;
var i__5727__auto___20324 = (0);
while(true){
if((i__5727__auto___20324 < len__5726__auto___20323)){
args20256.push((arguments[i__5727__auto___20324]));

var G__20325 = (i__5727__auto___20324 + (1));
i__5727__auto___20324 = G__20325;
continue;
} else {
}
break;
}

var G__20258 = args20256.length;
switch (G__20258) {
case 1:
return sablono.core.hidden_field20255.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field20255.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20256.length)].join('')));

}
});

sablono.core.hidden_field20255.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.hidden_field20255.call(null,name__11649__auto__,null);
});

sablono.core.hidden_field20255.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.hidden_field20255.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field20255);

/**
 * Creates a month input field.
 */
sablono.core.month_field20259 = (function sablono$core$month_field20259(var_args){
var args20260 = [];
var len__5726__auto___20327 = arguments.length;
var i__5727__auto___20328 = (0);
while(true){
if((i__5727__auto___20328 < len__5726__auto___20327)){
args20260.push((arguments[i__5727__auto___20328]));

var G__20329 = (i__5727__auto___20328 + (1));
i__5727__auto___20328 = G__20329;
continue;
} else {
}
break;
}

var G__20262 = args20260.length;
switch (G__20262) {
case 1:
return sablono.core.month_field20259.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field20259.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20260.length)].join('')));

}
});

sablono.core.month_field20259.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.month_field20259.call(null,name__11649__auto__,null);
});

sablono.core.month_field20259.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.month_field20259.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field20259);

/**
 * Creates a number input field.
 */
sablono.core.number_field20263 = (function sablono$core$number_field20263(var_args){
var args20264 = [];
var len__5726__auto___20331 = arguments.length;
var i__5727__auto___20332 = (0);
while(true){
if((i__5727__auto___20332 < len__5726__auto___20331)){
args20264.push((arguments[i__5727__auto___20332]));

var G__20333 = (i__5727__auto___20332 + (1));
i__5727__auto___20332 = G__20333;
continue;
} else {
}
break;
}

var G__20266 = args20264.length;
switch (G__20266) {
case 1:
return sablono.core.number_field20263.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field20263.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20264.length)].join('')));

}
});

sablono.core.number_field20263.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.number_field20263.call(null,name__11649__auto__,null);
});

sablono.core.number_field20263.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.number_field20263.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field20263);

/**
 * Creates a password input field.
 */
sablono.core.password_field20267 = (function sablono$core$password_field20267(var_args){
var args20268 = [];
var len__5726__auto___20335 = arguments.length;
var i__5727__auto___20336 = (0);
while(true){
if((i__5727__auto___20336 < len__5726__auto___20335)){
args20268.push((arguments[i__5727__auto___20336]));

var G__20337 = (i__5727__auto___20336 + (1));
i__5727__auto___20336 = G__20337;
continue;
} else {
}
break;
}

var G__20270 = args20268.length;
switch (G__20270) {
case 1:
return sablono.core.password_field20267.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field20267.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20268.length)].join('')));

}
});

sablono.core.password_field20267.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.password_field20267.call(null,name__11649__auto__,null);
});

sablono.core.password_field20267.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.password_field20267.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field20267);

/**
 * Creates a range input field.
 */
sablono.core.range_field20271 = (function sablono$core$range_field20271(var_args){
var args20272 = [];
var len__5726__auto___20339 = arguments.length;
var i__5727__auto___20340 = (0);
while(true){
if((i__5727__auto___20340 < len__5726__auto___20339)){
args20272.push((arguments[i__5727__auto___20340]));

var G__20341 = (i__5727__auto___20340 + (1));
i__5727__auto___20340 = G__20341;
continue;
} else {
}
break;
}

var G__20274 = args20272.length;
switch (G__20274) {
case 1:
return sablono.core.range_field20271.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field20271.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20272.length)].join('')));

}
});

sablono.core.range_field20271.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.range_field20271.call(null,name__11649__auto__,null);
});

sablono.core.range_field20271.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.range_field20271.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field20271);

/**
 * Creates a search input field.
 */
sablono.core.search_field20275 = (function sablono$core$search_field20275(var_args){
var args20276 = [];
var len__5726__auto___20343 = arguments.length;
var i__5727__auto___20344 = (0);
while(true){
if((i__5727__auto___20344 < len__5726__auto___20343)){
args20276.push((arguments[i__5727__auto___20344]));

var G__20345 = (i__5727__auto___20344 + (1));
i__5727__auto___20344 = G__20345;
continue;
} else {
}
break;
}

var G__20278 = args20276.length;
switch (G__20278) {
case 1:
return sablono.core.search_field20275.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field20275.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20276.length)].join('')));

}
});

sablono.core.search_field20275.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.search_field20275.call(null,name__11649__auto__,null);
});

sablono.core.search_field20275.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.search_field20275.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field20275);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field20279 = (function sablono$core$tel_field20279(var_args){
var args20280 = [];
var len__5726__auto___20347 = arguments.length;
var i__5727__auto___20348 = (0);
while(true){
if((i__5727__auto___20348 < len__5726__auto___20347)){
args20280.push((arguments[i__5727__auto___20348]));

var G__20349 = (i__5727__auto___20348 + (1));
i__5727__auto___20348 = G__20349;
continue;
} else {
}
break;
}

var G__20282 = args20280.length;
switch (G__20282) {
case 1:
return sablono.core.tel_field20279.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field20279.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20280.length)].join('')));

}
});

sablono.core.tel_field20279.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.tel_field20279.call(null,name__11649__auto__,null);
});

sablono.core.tel_field20279.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.tel_field20279.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field20279);

/**
 * Creates a text input field.
 */
sablono.core.text_field20283 = (function sablono$core$text_field20283(var_args){
var args20284 = [];
var len__5726__auto___20351 = arguments.length;
var i__5727__auto___20352 = (0);
while(true){
if((i__5727__auto___20352 < len__5726__auto___20351)){
args20284.push((arguments[i__5727__auto___20352]));

var G__20353 = (i__5727__auto___20352 + (1));
i__5727__auto___20352 = G__20353;
continue;
} else {
}
break;
}

var G__20286 = args20284.length;
switch (G__20286) {
case 1:
return sablono.core.text_field20283.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field20283.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20284.length)].join('')));

}
});

sablono.core.text_field20283.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.text_field20283.call(null,name__11649__auto__,null);
});

sablono.core.text_field20283.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.text_field20283.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field20283);

/**
 * Creates a time input field.
 */
sablono.core.time_field20287 = (function sablono$core$time_field20287(var_args){
var args20288 = [];
var len__5726__auto___20355 = arguments.length;
var i__5727__auto___20356 = (0);
while(true){
if((i__5727__auto___20356 < len__5726__auto___20355)){
args20288.push((arguments[i__5727__auto___20356]));

var G__20357 = (i__5727__auto___20356 + (1));
i__5727__auto___20356 = G__20357;
continue;
} else {
}
break;
}

var G__20290 = args20288.length;
switch (G__20290) {
case 1:
return sablono.core.time_field20287.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field20287.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20288.length)].join('')));

}
});

sablono.core.time_field20287.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.time_field20287.call(null,name__11649__auto__,null);
});

sablono.core.time_field20287.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.time_field20287.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field20287);

/**
 * Creates a url input field.
 */
sablono.core.url_field20291 = (function sablono$core$url_field20291(var_args){
var args20292 = [];
var len__5726__auto___20359 = arguments.length;
var i__5727__auto___20360 = (0);
while(true){
if((i__5727__auto___20360 < len__5726__auto___20359)){
args20292.push((arguments[i__5727__auto___20360]));

var G__20361 = (i__5727__auto___20360 + (1));
i__5727__auto___20360 = G__20361;
continue;
} else {
}
break;
}

var G__20294 = args20292.length;
switch (G__20294) {
case 1:
return sablono.core.url_field20291.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field20291.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20292.length)].join('')));

}
});

sablono.core.url_field20291.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.url_field20291.call(null,name__11649__auto__,null);
});

sablono.core.url_field20291.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.url_field20291.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field20291);

/**
 * Creates a week input field.
 */
sablono.core.week_field20295 = (function sablono$core$week_field20295(var_args){
var args20296 = [];
var len__5726__auto___20363 = arguments.length;
var i__5727__auto___20364 = (0);
while(true){
if((i__5727__auto___20364 < len__5726__auto___20363)){
args20296.push((arguments[i__5727__auto___20364]));

var G__20365 = (i__5727__auto___20364 + (1));
i__5727__auto___20364 = G__20365;
continue;
} else {
}
break;
}

var G__20298 = args20296.length;
switch (G__20298) {
case 1:
return sablono.core.week_field20295.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field20295.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20296.length)].join('')));

}
});

sablono.core.week_field20295.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.week_field20295.call(null,name__11649__auto__,null);
});

sablono.core.week_field20295.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.week_field20295.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field20295);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box20367 = (function sablono$core$check_box20367(var_args){
var args20368 = [];
var len__5726__auto___20371 = arguments.length;
var i__5727__auto___20372 = (0);
while(true){
if((i__5727__auto___20372 < len__5726__auto___20371)){
args20368.push((arguments[i__5727__auto___20372]));

var G__20373 = (i__5727__auto___20372 + (1));
i__5727__auto___20372 = G__20373;
continue;
} else {
}
break;
}

var G__20370 = args20368.length;
switch (G__20370) {
case 1:
return sablono.core.check_box20367.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box20367.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box20367.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20368.length)].join('')));

}
});

sablono.core.check_box20367.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box20367.call(null,name,null);
});

sablono.core.check_box20367.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box20367.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box20367.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20367.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box20367);
/**
 * Creates a radio button.
 */
sablono.core.radio_button20375 = (function sablono$core$radio_button20375(var_args){
var args20376 = [];
var len__5726__auto___20379 = arguments.length;
var i__5727__auto___20380 = (0);
while(true){
if((i__5727__auto___20380 < len__5726__auto___20379)){
args20376.push((arguments[i__5727__auto___20380]));

var G__20381 = (i__5727__auto___20380 + (1));
i__5727__auto___20380 = G__20381;
continue;
} else {
}
break;
}

var G__20378 = args20376.length;
switch (G__20378) {
case 1:
return sablono.core.radio_button20375.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button20375.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button20375.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20376.length)].join('')));

}
});

sablono.core.radio_button20375.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button20375.call(null,group,null);
});

sablono.core.radio_button20375.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button20375.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button20375.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20375.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button20375);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options20383 = (function sablono$core$select_options20383(coll){
var iter__5440__auto__ = (function sablono$core$select_options20383_$_iter__20392(s__20393){
return (new cljs.core.LazySeq(null,(function (){
var s__20393__$1 = s__20393;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20393__$1);
if(temp__4425__auto__){
var s__20393__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20393__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20393__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20395 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20394 = (0);
while(true){
if((i__20394 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20394);
cljs.core.chunk_append.call(null,b__20395,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20398 = x;
var text = cljs.core.nth.call(null,vec__20398,(0),null);
var val = cljs.core.nth.call(null,vec__20398,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20398,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20383.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__20400 = (i__20394 + (1));
i__20394 = G__20400;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20395),sablono$core$select_options20383_$_iter__20392.call(null,cljs.core.chunk_rest.call(null,s__20393__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20395),null);
}
} else {
var x = cljs.core.first.call(null,s__20393__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20399 = x;
var text = cljs.core.nth.call(null,vec__20399,(0),null);
var val = cljs.core.nth.call(null,vec__20399,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20399,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20383.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options20383_$_iter__20392.call(null,cljs.core.rest.call(null,s__20393__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options20383);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down20401 = (function sablono$core$drop_down20401(var_args){
var args20402 = [];
var len__5726__auto___20405 = arguments.length;
var i__5727__auto___20406 = (0);
while(true){
if((i__5727__auto___20406 < len__5726__auto___20405)){
args20402.push((arguments[i__5727__auto___20406]));

var G__20407 = (i__5727__auto___20406 + (1));
i__5727__auto___20406 = G__20407;
continue;
} else {
}
break;
}

var G__20404 = args20402.length;
switch (G__20404) {
case 2:
return sablono.core.drop_down20401.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down20401.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20402.length)].join('')));

}
});

sablono.core.drop_down20401.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down20401.call(null,name,options,null);
});

sablono.core.drop_down20401.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down20401.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down20401);
/**
 * Creates a text area element.
 */
sablono.core.text_area20409 = (function sablono$core$text_area20409(var_args){
var args20410 = [];
var len__5726__auto___20413 = arguments.length;
var i__5727__auto___20414 = (0);
while(true){
if((i__5727__auto___20414 < len__5726__auto___20413)){
args20410.push((arguments[i__5727__auto___20414]));

var G__20415 = (i__5727__auto___20414 + (1));
i__5727__auto___20414 = G__20415;
continue;
} else {
}
break;
}

var G__20412 = args20410.length;
switch (G__20412) {
case 1:
return sablono.core.text_area20409.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area20409.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20410.length)].join('')));

}
});

sablono.core.text_area20409.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area20409.call(null,name,null);
});

sablono.core.text_area20409.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area20409.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area20409);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20417 = (function sablono$core$label20417(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20417);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20418 = (function sablono$core$submit_button20418(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20418);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20419 = (function sablono$core$reset_button20419(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20419);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20420 = (function sablono$core$form_to20420(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20425 = arguments.length;
var i__5727__auto___20426 = (0);
while(true){
if((i__5727__auto___20426 < len__5726__auto___20425)){
args__5733__auto__.push((arguments[i__5727__auto___20426]));

var G__20427 = (i__5727__auto___20426 + (1));
i__5727__auto___20426 = G__20427;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to20420.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to20420.cljs$core$IFn$_invoke$arity$variadic = (function (p__20423,body){
var vec__20424 = p__20423;
var method = cljs.core.nth.call(null,vec__20424,(0),null);
var action = cljs.core.nth.call(null,vec__20424,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to20420.cljs$lang$maxFixedArity = (1);

sablono.core.form_to20420.cljs$lang$applyTo = (function (seq20421){
var G__20422 = cljs.core.first.call(null,seq20421);
var seq20421__$1 = cljs.core.next.call(null,seq20421);
return sablono.core.form_to20420.cljs$core$IFn$_invoke$arity$variadic(G__20422,seq20421__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20420);

//# sourceMappingURL=core.js.map?rel=1459753783164