// Compiled by ClojureScript 1.7.170 {}
goog.provide('vega_viewer.components.vega_viewer');
goog.require('cljs.core');
goog.require('cljsjs.vega');
goog.require('om.core');
goog.require('sablono.core');
vega_viewer.components.vega_viewer.chart_width_proportion = 0.8;
/**
 * Add a window.resize event handler that changes the :container-width state of
 * a vega-viewer instance when the window is resized
 */
vega_viewer.components.vega_viewer.set_resize_handler = (function vega_viewer$components$vega_viewer$set_resize_handler(owner){
var container = om.core.get_node.call(null,owner,"vega-container");
var resize_handler = window.addEventListener("resize",((function (container){
return (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"container-width","container-width",-1461172864),container.clientWidth);
});})(container))
);
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
/**
 * Render a Vega specification in the supplied container
 */
vega_viewer.components.vega_viewer.render_vega_visualization = (function vega_viewer$components$vega_viewer$render_vega_visualization(spec,container,responsive_QMARK_){
var container_width = container.clientWidth;
var spec_as_js = cljs.core.clj__GT_js.call(null,(cljs.core.truth_(responsive_QMARK_)?cljs.core.assoc.call(null,spec,new cljs.core.Keyword(null,"width","width",-384071477),(container_width * vega_viewer.components.vega_viewer.chart_width_proportion)):spec));
return vg.parse.spec(spec_as_js,((function (container_width,spec_as_js){
return (function (chart){
var view = chart.call(null,{"el": container});
return view.update();
});})(container_width,spec_as_js))
);
});
/**
 * Return an Om component that renders a Vega specification
 */
vega_viewer.components.vega_viewer.vega_viewer = (function vega_viewer$components$vega_viewer$vega_viewer(p__22820,owner,p__22821){
var map__22833 = p__22820;
var map__22833__$1 = ((((!((map__22833 == null)))?((((map__22833.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22833.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22833):map__22833);
var vega_spec = map__22833__$1;
var width = cljs.core.get.call(null,map__22833__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var map__22834 = p__22821;
var map__22834__$1 = ((((!((map__22834 == null)))?((((map__22834.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22834.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22834):map__22834);
var responsive_QMARK_ = cljs.core.get.call(null,map__22834__$1,new cljs.core.Keyword(null,"responsive?","responsive?",-683696941));
if(typeof vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {om.core.IDidUpdate}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837 = (function (vega_viewer,p__22820,owner,p__22821,map__22833,vega_spec,width,map__22834,responsive_QMARK_,meta22838){
this.vega_viewer = vega_viewer;
this.p__22820 = p__22820;
this.owner = owner;
this.p__22821 = p__22821;
this.map__22833 = map__22833;
this.vega_spec = vega_spec;
this.width = width;
this.map__22834 = map__22834;
this.responsive_QMARK_ = responsive_QMARK_;
this.meta22838 = meta22838;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function (_22839,meta22838__$1){
var self__ = this;
var _22839__$1 = this;
return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837(self__.vega_viewer,self__.p__22820,self__.owner,self__.p__22821,self__.map__22833,self__.vega_spec,self__.width,self__.map__22834,self__.responsive_QMARK_,meta22838__$1));
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function (_22839){
var self__ = this;
var _22839__$1 = this;
return self__.meta22838;
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.om$core$IWillUnmount$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
var map__22840 = om.core.get_state.call(null,self__.owner);
var map__22840__$1 = ((((!((map__22840 == null)))?((((map__22840.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22840.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22840):map__22840);
var resize_handler = cljs.core.get.call(null,map__22840__$1,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881));
return window.removeEventListener("resize",resize_handler);
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.om$core$IDidUpdate$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.om$core$IDidUpdate$did_update$arity$3 = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function (_,___$1,___$2){
var self__ = this;
var ___$3 = this;
return vega_viewer.components.vega_viewer.render_vega_visualization.call(null,self__.vega_spec,om.core.get_node.call(null,self__.owner,"vega-container"),self__.responsive_QMARK_);
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.om$core$IDidMount$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
vega_viewer.components.vega_viewer.set_resize_handler.call(null,self__.owner);

return vega_viewer.components.vega_viewer.render_vega_visualization.call(null,self__.vega_spec,om.core.get_node.call(null,self__.owner,"vega-container"),self__.responsive_QMARK_);
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.om$core$IRender$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.prototype.om$core$IRender$render$arity$1 = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
return React.createElement("div",{"ref": "vega-container", "style": {"width": "100%"}});
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.getBasis = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"vega-viewer","vega-viewer",-1445969313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"width","width",1256460050,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"vega-spec","vega-spec",1334352605,null)], null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"responsive?","responsive?",956834586,null)], null)], null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return an Om component that renders a Vega specification"], null)),new cljs.core.Symbol(null,"p__22820","p__22820",2110208657,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22821","p__22821",1485703645,null),new cljs.core.Symbol(null,"map__22833","map__22833",911607829,null),new cljs.core.Symbol(null,"vega-spec","vega-spec",1334352605,null),new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"map__22834","map__22834",-1417266807,null),new cljs.core.Symbol(null,"responsive?","responsive?",956834586,null),new cljs.core.Symbol(null,"meta22838","meta22838",-1710309371,null)], null);
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.cljs$lang$type = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.cljs$lang$ctorStr = "vega-viewer.components.vega-viewer/t_vega_viewer$components$vega_viewer22837";

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837.cljs$lang$ctorPrWriter = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"vega-viewer.components.vega-viewer/t_vega_viewer$components$vega_viewer22837");
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.__GT_t_vega_viewer$components$vega_viewer22837 = ((function (map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_){
return (function vega_viewer$components$vega_viewer$vega_viewer_$___GT_t_vega_viewer$components$vega_viewer22837(vega_viewer__$2,p__22820__$1,owner__$1,p__22821__$1,map__22833__$2,vega_spec__$1,width__$1,map__22834__$2,responsive_QMARK___$1,meta22838){
return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837(vega_viewer__$2,p__22820__$1,owner__$1,p__22821__$1,map__22833__$2,vega_spec__$1,width__$1,map__22834__$2,responsive_QMARK___$1,meta22838));
});})(map__22833,map__22833__$1,vega_spec,width,map__22834,map__22834__$1,responsive_QMARK_))
;

}

return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer22837(vega_viewer$components$vega_viewer$vega_viewer,p__22820,owner,p__22821,map__22833__$1,vega_spec,width,map__22834__$1,responsive_QMARK_,cljs.core.PersistentArrayMap.EMPTY));
});

//# sourceMappingURL=vega_viewer.js.map?rel=1459753786034