// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11139 = [];
var len__5726__auto___11145 = arguments.length;
var i__5727__auto___11146 = (0);
while(true){
if((i__5727__auto___11146 < len__5726__auto___11145)){
args11139.push((arguments[i__5727__auto___11146]));

var G__11147 = (i__5727__auto___11146 + (1));
i__5727__auto___11146 = G__11147;
continue;
} else {
}
break;
}

var G__11141 = args11139.length;
switch (G__11141) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11139.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11142 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11142 = (function (f,blockable,meta11143){
this.f = f;
this.blockable = blockable;
this.meta11143 = meta11143;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11142.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11144,meta11143__$1){
var self__ = this;
var _11144__$1 = this;
return (new cljs.core.async.t_cljs$core$async11142(self__.f,self__.blockable,meta11143__$1));
});

cljs.core.async.t_cljs$core$async11142.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11144){
var self__ = this;
var _11144__$1 = this;
return self__.meta11143;
});

cljs.core.async.t_cljs$core$async11142.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11142.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11142.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11142.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11142.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11143","meta11143",-2017576445,null)], null);
});

cljs.core.async.t_cljs$core$async11142.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11142.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11142";

cljs.core.async.t_cljs$core$async11142.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11142");
});

cljs.core.async.__GT_t_cljs$core$async11142 = (function cljs$core$async$__GT_t_cljs$core$async11142(f__$1,blockable__$1,meta11143){
return (new cljs.core.async.t_cljs$core$async11142(f__$1,blockable__$1,meta11143));
});

}

return (new cljs.core.async.t_cljs$core$async11142(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11151 = [];
var len__5726__auto___11154 = arguments.length;
var i__5727__auto___11155 = (0);
while(true){
if((i__5727__auto___11155 < len__5726__auto___11154)){
args11151.push((arguments[i__5727__auto___11155]));

var G__11156 = (i__5727__auto___11155 + (1));
i__5727__auto___11155 = G__11156;
continue;
} else {
}
break;
}

var G__11153 = args11151.length;
switch (G__11153) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11151.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11158 = [];
var len__5726__auto___11161 = arguments.length;
var i__5727__auto___11162 = (0);
while(true){
if((i__5727__auto___11162 < len__5726__auto___11161)){
args11158.push((arguments[i__5727__auto___11162]));

var G__11163 = (i__5727__auto___11162 + (1));
i__5727__auto___11162 = G__11163;
continue;
} else {
}
break;
}

var G__11160 = args11158.length;
switch (G__11160) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11158.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11165 = [];
var len__5726__auto___11168 = arguments.length;
var i__5727__auto___11169 = (0);
while(true){
if((i__5727__auto___11169 < len__5726__auto___11168)){
args11165.push((arguments[i__5727__auto___11169]));

var G__11170 = (i__5727__auto___11169 + (1));
i__5727__auto___11169 = G__11170;
continue;
} else {
}
break;
}

var G__11167 = args11165.length;
switch (G__11167) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11165.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11172 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11172);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11172,ret){
return (function (){
return fn1.call(null,val_11172);
});})(val_11172,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11173 = [];
var len__5726__auto___11176 = arguments.length;
var i__5727__auto___11177 = (0);
while(true){
if((i__5727__auto___11177 < len__5726__auto___11176)){
args11173.push((arguments[i__5727__auto___11177]));

var G__11178 = (i__5727__auto___11177 + (1));
i__5727__auto___11177 = G__11178;
continue;
} else {
}
break;
}

var G__11175 = args11173.length;
switch (G__11175) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11173.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___11180 = n;
var x_11181 = (0);
while(true){
if((x_11181 < n__5571__auto___11180)){
(a[x_11181] = (0));

var G__11182 = (x_11181 + (1));
x_11181 = G__11182;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11183 = (i + (1));
i = G__11183;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11187 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11187 = (function (alt_flag,flag,meta11188){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11188 = meta11188;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11187.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11189,meta11188__$1){
var self__ = this;
var _11189__$1 = this;
return (new cljs.core.async.t_cljs$core$async11187(self__.alt_flag,self__.flag,meta11188__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11187.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11189){
var self__ = this;
var _11189__$1 = this;
return self__.meta11188;
});})(flag))
;

cljs.core.async.t_cljs$core$async11187.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11187.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11187.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11187.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11187.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11188","meta11188",922389789,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11187.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11187.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11187";

cljs.core.async.t_cljs$core$async11187.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11187");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11187 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11187(alt_flag__$1,flag__$1,meta11188){
return (new cljs.core.async.t_cljs$core$async11187(alt_flag__$1,flag__$1,meta11188));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11187(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11193 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11193 = (function (alt_handler,flag,cb,meta11194){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11194 = meta11194;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11193.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11195,meta11194__$1){
var self__ = this;
var _11195__$1 = this;
return (new cljs.core.async.t_cljs$core$async11193(self__.alt_handler,self__.flag,self__.cb,meta11194__$1));
});

cljs.core.async.t_cljs$core$async11193.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11195){
var self__ = this;
var _11195__$1 = this;
return self__.meta11194;
});

cljs.core.async.t_cljs$core$async11193.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11193.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11193.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11193.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11193.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11194","meta11194",-321661887,null)], null);
});

cljs.core.async.t_cljs$core$async11193.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11193.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11193";

cljs.core.async.t_cljs$core$async11193.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11193");
});

cljs.core.async.__GT_t_cljs$core$async11193 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11193(alt_handler__$1,flag__$1,cb__$1,meta11194){
return (new cljs.core.async.t_cljs$core$async11193(alt_handler__$1,flag__$1,cb__$1,meta11194));
});

}

return (new cljs.core.async.t_cljs$core$async11193(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11196_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11196_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11197_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11197_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11198 = (i + (1));
i = G__11198;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11204 = arguments.length;
var i__5727__auto___11205 = (0);
while(true){
if((i__5727__auto___11205 < len__5726__auto___11204)){
args__5733__auto__.push((arguments[i__5727__auto___11205]));

var G__11206 = (i__5727__auto___11205 + (1));
i__5727__auto___11205 = G__11206;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11201){
var map__11202 = p__11201;
var map__11202__$1 = ((((!((map__11202 == null)))?((((map__11202.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11202.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11202):map__11202);
var opts = map__11202__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11199){
var G__11200 = cljs.core.first.call(null,seq11199);
var seq11199__$1 = cljs.core.next.call(null,seq11199);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11200,seq11199__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11207 = [];
var len__5726__auto___11257 = arguments.length;
var i__5727__auto___11258 = (0);
while(true){
if((i__5727__auto___11258 < len__5726__auto___11257)){
args11207.push((arguments[i__5727__auto___11258]));

var G__11259 = (i__5727__auto___11258 + (1));
i__5727__auto___11258 = G__11259;
continue;
} else {
}
break;
}

var G__11209 = args11207.length;
switch (G__11209) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11207.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11094__auto___11261 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___11261){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___11261){
return (function (state_11233){
var state_val_11234 = (state_11233[(1)]);
if((state_val_11234 === (7))){
var inst_11229 = (state_11233[(2)]);
var state_11233__$1 = state_11233;
var statearr_11235_11262 = state_11233__$1;
(statearr_11235_11262[(2)] = inst_11229);

(statearr_11235_11262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (1))){
var state_11233__$1 = state_11233;
var statearr_11236_11263 = state_11233__$1;
(statearr_11236_11263[(2)] = null);

(statearr_11236_11263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (4))){
var inst_11212 = (state_11233[(7)]);
var inst_11212__$1 = (state_11233[(2)]);
var inst_11213 = (inst_11212__$1 == null);
var state_11233__$1 = (function (){var statearr_11237 = state_11233;
(statearr_11237[(7)] = inst_11212__$1);

return statearr_11237;
})();
if(cljs.core.truth_(inst_11213)){
var statearr_11238_11264 = state_11233__$1;
(statearr_11238_11264[(1)] = (5));

} else {
var statearr_11239_11265 = state_11233__$1;
(statearr_11239_11265[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (13))){
var state_11233__$1 = state_11233;
var statearr_11240_11266 = state_11233__$1;
(statearr_11240_11266[(2)] = null);

(statearr_11240_11266[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (6))){
var inst_11212 = (state_11233[(7)]);
var state_11233__$1 = state_11233;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11233__$1,(11),to,inst_11212);
} else {
if((state_val_11234 === (3))){
var inst_11231 = (state_11233[(2)]);
var state_11233__$1 = state_11233;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11233__$1,inst_11231);
} else {
if((state_val_11234 === (12))){
var state_11233__$1 = state_11233;
var statearr_11241_11267 = state_11233__$1;
(statearr_11241_11267[(2)] = null);

(statearr_11241_11267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (2))){
var state_11233__$1 = state_11233;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11233__$1,(4),from);
} else {
if((state_val_11234 === (11))){
var inst_11222 = (state_11233[(2)]);
var state_11233__$1 = state_11233;
if(cljs.core.truth_(inst_11222)){
var statearr_11242_11268 = state_11233__$1;
(statearr_11242_11268[(1)] = (12));

} else {
var statearr_11243_11269 = state_11233__$1;
(statearr_11243_11269[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (9))){
var state_11233__$1 = state_11233;
var statearr_11244_11270 = state_11233__$1;
(statearr_11244_11270[(2)] = null);

(statearr_11244_11270[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (5))){
var state_11233__$1 = state_11233;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11245_11271 = state_11233__$1;
(statearr_11245_11271[(1)] = (8));

} else {
var statearr_11246_11272 = state_11233__$1;
(statearr_11246_11272[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (14))){
var inst_11227 = (state_11233[(2)]);
var state_11233__$1 = state_11233;
var statearr_11247_11273 = state_11233__$1;
(statearr_11247_11273[(2)] = inst_11227);

(statearr_11247_11273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (10))){
var inst_11219 = (state_11233[(2)]);
var state_11233__$1 = state_11233;
var statearr_11248_11274 = state_11233__$1;
(statearr_11248_11274[(2)] = inst_11219);

(statearr_11248_11274[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11234 === (8))){
var inst_11216 = cljs.core.async.close_BANG_.call(null,to);
var state_11233__$1 = state_11233;
var statearr_11249_11275 = state_11233__$1;
(statearr_11249_11275[(2)] = inst_11216);

(statearr_11249_11275[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___11261))
;
return ((function (switch__10982__auto__,c__11094__auto___11261){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_11253 = [null,null,null,null,null,null,null,null];
(statearr_11253[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_11253[(1)] = (1));

return statearr_11253;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_11233){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11233);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11254){if((e11254 instanceof Object)){
var ex__10986__auto__ = e11254;
var statearr_11255_11276 = state_11233;
(statearr_11255_11276[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11233);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11254;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11277 = state_11233;
state_11233 = G__11277;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_11233){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_11233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___11261))
})();
var state__11096__auto__ = (function (){var statearr_11256 = f__11095__auto__.call(null);
(statearr_11256[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___11261);

return statearr_11256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___11261))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11461){
var vec__11462 = p__11461;
var v = cljs.core.nth.call(null,vec__11462,(0),null);
var p = cljs.core.nth.call(null,vec__11462,(1),null);
var job = vec__11462;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11094__auto___11644 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___11644,res,vec__11462,v,p,job,jobs,results){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___11644,res,vec__11462,v,p,job,jobs,results){
return (function (state_11467){
var state_val_11468 = (state_11467[(1)]);
if((state_val_11468 === (1))){
var state_11467__$1 = state_11467;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11467__$1,(2),res,v);
} else {
if((state_val_11468 === (2))){
var inst_11464 = (state_11467[(2)]);
var inst_11465 = cljs.core.async.close_BANG_.call(null,res);
var state_11467__$1 = (function (){var statearr_11469 = state_11467;
(statearr_11469[(7)] = inst_11464);

return statearr_11469;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11467__$1,inst_11465);
} else {
return null;
}
}
});})(c__11094__auto___11644,res,vec__11462,v,p,job,jobs,results))
;
return ((function (switch__10982__auto__,c__11094__auto___11644,res,vec__11462,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_11473 = [null,null,null,null,null,null,null,null];
(statearr_11473[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_11473[(1)] = (1));

return statearr_11473;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_11467){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11467);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11474){if((e11474 instanceof Object)){
var ex__10986__auto__ = e11474;
var statearr_11475_11645 = state_11467;
(statearr_11475_11645[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11467);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11474;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11646 = state_11467;
state_11467 = G__11646;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_11467){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_11467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___11644,res,vec__11462,v,p,job,jobs,results))
})();
var state__11096__auto__ = (function (){var statearr_11476 = f__11095__auto__.call(null);
(statearr_11476[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___11644);

return statearr_11476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___11644,res,vec__11462,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11477){
var vec__11478 = p__11477;
var v = cljs.core.nth.call(null,vec__11478,(0),null);
var p = cljs.core.nth.call(null,vec__11478,(1),null);
var job = vec__11478;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___11647 = n;
var __11648 = (0);
while(true){
if((__11648 < n__5571__auto___11647)){
var G__11479_11649 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11479_11649) {
case "compute":
var c__11094__auto___11651 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11648,c__11094__auto___11651,G__11479_11649,n__5571__auto___11647,jobs,results,process,async){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (__11648,c__11094__auto___11651,G__11479_11649,n__5571__auto___11647,jobs,results,process,async){
return (function (state_11492){
var state_val_11493 = (state_11492[(1)]);
if((state_val_11493 === (1))){
var state_11492__$1 = state_11492;
var statearr_11494_11652 = state_11492__$1;
(statearr_11494_11652[(2)] = null);

(statearr_11494_11652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (2))){
var state_11492__$1 = state_11492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11492__$1,(4),jobs);
} else {
if((state_val_11493 === (3))){
var inst_11490 = (state_11492[(2)]);
var state_11492__$1 = state_11492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11492__$1,inst_11490);
} else {
if((state_val_11493 === (4))){
var inst_11482 = (state_11492[(2)]);
var inst_11483 = process.call(null,inst_11482);
var state_11492__$1 = state_11492;
if(cljs.core.truth_(inst_11483)){
var statearr_11495_11653 = state_11492__$1;
(statearr_11495_11653[(1)] = (5));

} else {
var statearr_11496_11654 = state_11492__$1;
(statearr_11496_11654[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (5))){
var state_11492__$1 = state_11492;
var statearr_11497_11655 = state_11492__$1;
(statearr_11497_11655[(2)] = null);

(statearr_11497_11655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (6))){
var state_11492__$1 = state_11492;
var statearr_11498_11656 = state_11492__$1;
(statearr_11498_11656[(2)] = null);

(statearr_11498_11656[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (7))){
var inst_11488 = (state_11492[(2)]);
var state_11492__$1 = state_11492;
var statearr_11499_11657 = state_11492__$1;
(statearr_11499_11657[(2)] = inst_11488);

(statearr_11499_11657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11648,c__11094__auto___11651,G__11479_11649,n__5571__auto___11647,jobs,results,process,async))
;
return ((function (__11648,switch__10982__auto__,c__11094__auto___11651,G__11479_11649,n__5571__auto___11647,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_11503 = [null,null,null,null,null,null,null];
(statearr_11503[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_11503[(1)] = (1));

return statearr_11503;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_11492){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11504){if((e11504 instanceof Object)){
var ex__10986__auto__ = e11504;
var statearr_11505_11658 = state_11492;
(statearr_11505_11658[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11492);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11504;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11659 = state_11492;
state_11492 = G__11659;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_11492){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_11492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(__11648,switch__10982__auto__,c__11094__auto___11651,G__11479_11649,n__5571__auto___11647,jobs,results,process,async))
})();
var state__11096__auto__ = (function (){var statearr_11506 = f__11095__auto__.call(null);
(statearr_11506[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___11651);

return statearr_11506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(__11648,c__11094__auto___11651,G__11479_11649,n__5571__auto___11647,jobs,results,process,async))
);


break;
case "async":
var c__11094__auto___11660 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11648,c__11094__auto___11660,G__11479_11649,n__5571__auto___11647,jobs,results,process,async){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (__11648,c__11094__auto___11660,G__11479_11649,n__5571__auto___11647,jobs,results,process,async){
return (function (state_11519){
var state_val_11520 = (state_11519[(1)]);
if((state_val_11520 === (1))){
var state_11519__$1 = state_11519;
var statearr_11521_11661 = state_11519__$1;
(statearr_11521_11661[(2)] = null);

(statearr_11521_11661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11520 === (2))){
var state_11519__$1 = state_11519;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11519__$1,(4),jobs);
} else {
if((state_val_11520 === (3))){
var inst_11517 = (state_11519[(2)]);
var state_11519__$1 = state_11519;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11519__$1,inst_11517);
} else {
if((state_val_11520 === (4))){
var inst_11509 = (state_11519[(2)]);
var inst_11510 = async.call(null,inst_11509);
var state_11519__$1 = state_11519;
if(cljs.core.truth_(inst_11510)){
var statearr_11522_11662 = state_11519__$1;
(statearr_11522_11662[(1)] = (5));

} else {
var statearr_11523_11663 = state_11519__$1;
(statearr_11523_11663[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11520 === (5))){
var state_11519__$1 = state_11519;
var statearr_11524_11664 = state_11519__$1;
(statearr_11524_11664[(2)] = null);

(statearr_11524_11664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11520 === (6))){
var state_11519__$1 = state_11519;
var statearr_11525_11665 = state_11519__$1;
(statearr_11525_11665[(2)] = null);

(statearr_11525_11665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11520 === (7))){
var inst_11515 = (state_11519[(2)]);
var state_11519__$1 = state_11519;
var statearr_11526_11666 = state_11519__$1;
(statearr_11526_11666[(2)] = inst_11515);

(statearr_11526_11666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11648,c__11094__auto___11660,G__11479_11649,n__5571__auto___11647,jobs,results,process,async))
;
return ((function (__11648,switch__10982__auto__,c__11094__auto___11660,G__11479_11649,n__5571__auto___11647,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_11530 = [null,null,null,null,null,null,null];
(statearr_11530[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_11530[(1)] = (1));

return statearr_11530;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_11519){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11519);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11531){if((e11531 instanceof Object)){
var ex__10986__auto__ = e11531;
var statearr_11532_11667 = state_11519;
(statearr_11532_11667[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11519);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11531;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11668 = state_11519;
state_11519 = G__11668;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_11519){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_11519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(__11648,switch__10982__auto__,c__11094__auto___11660,G__11479_11649,n__5571__auto___11647,jobs,results,process,async))
})();
var state__11096__auto__ = (function (){var statearr_11533 = f__11095__auto__.call(null);
(statearr_11533[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___11660);

return statearr_11533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(__11648,c__11094__auto___11660,G__11479_11649,n__5571__auto___11647,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11669 = (__11648 + (1));
__11648 = G__11669;
continue;
} else {
}
break;
}

var c__11094__auto___11670 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___11670,jobs,results,process,async){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___11670,jobs,results,process,async){
return (function (state_11555){
var state_val_11556 = (state_11555[(1)]);
if((state_val_11556 === (1))){
var state_11555__$1 = state_11555;
var statearr_11557_11671 = state_11555__$1;
(statearr_11557_11671[(2)] = null);

(statearr_11557_11671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11556 === (2))){
var state_11555__$1 = state_11555;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11555__$1,(4),from);
} else {
if((state_val_11556 === (3))){
var inst_11553 = (state_11555[(2)]);
var state_11555__$1 = state_11555;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11555__$1,inst_11553);
} else {
if((state_val_11556 === (4))){
var inst_11536 = (state_11555[(7)]);
var inst_11536__$1 = (state_11555[(2)]);
var inst_11537 = (inst_11536__$1 == null);
var state_11555__$1 = (function (){var statearr_11558 = state_11555;
(statearr_11558[(7)] = inst_11536__$1);

return statearr_11558;
})();
if(cljs.core.truth_(inst_11537)){
var statearr_11559_11672 = state_11555__$1;
(statearr_11559_11672[(1)] = (5));

} else {
var statearr_11560_11673 = state_11555__$1;
(statearr_11560_11673[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11556 === (5))){
var inst_11539 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11555__$1 = state_11555;
var statearr_11561_11674 = state_11555__$1;
(statearr_11561_11674[(2)] = inst_11539);

(statearr_11561_11674[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11556 === (6))){
var inst_11541 = (state_11555[(8)]);
var inst_11536 = (state_11555[(7)]);
var inst_11541__$1 = cljs.core.async.chan.call(null,(1));
var inst_11542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11543 = [inst_11536,inst_11541__$1];
var inst_11544 = (new cljs.core.PersistentVector(null,2,(5),inst_11542,inst_11543,null));
var state_11555__$1 = (function (){var statearr_11562 = state_11555;
(statearr_11562[(8)] = inst_11541__$1);

return statearr_11562;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11555__$1,(8),jobs,inst_11544);
} else {
if((state_val_11556 === (7))){
var inst_11551 = (state_11555[(2)]);
var state_11555__$1 = state_11555;
var statearr_11563_11675 = state_11555__$1;
(statearr_11563_11675[(2)] = inst_11551);

(statearr_11563_11675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11556 === (8))){
var inst_11541 = (state_11555[(8)]);
var inst_11546 = (state_11555[(2)]);
var state_11555__$1 = (function (){var statearr_11564 = state_11555;
(statearr_11564[(9)] = inst_11546);

return statearr_11564;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11555__$1,(9),results,inst_11541);
} else {
if((state_val_11556 === (9))){
var inst_11548 = (state_11555[(2)]);
var state_11555__$1 = (function (){var statearr_11565 = state_11555;
(statearr_11565[(10)] = inst_11548);

return statearr_11565;
})();
var statearr_11566_11676 = state_11555__$1;
(statearr_11566_11676[(2)] = null);

(statearr_11566_11676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___11670,jobs,results,process,async))
;
return ((function (switch__10982__auto__,c__11094__auto___11670,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_11570 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11570[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_11570[(1)] = (1));

return statearr_11570;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_11555){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11555);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11571){if((e11571 instanceof Object)){
var ex__10986__auto__ = e11571;
var statearr_11572_11677 = state_11555;
(statearr_11572_11677[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11555);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11571;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11678 = state_11555;
state_11555 = G__11678;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_11555){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_11555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___11670,jobs,results,process,async))
})();
var state__11096__auto__ = (function (){var statearr_11573 = f__11095__auto__.call(null);
(statearr_11573[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___11670);

return statearr_11573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___11670,jobs,results,process,async))
);


var c__11094__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto__,jobs,results,process,async){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto__,jobs,results,process,async){
return (function (state_11611){
var state_val_11612 = (state_11611[(1)]);
if((state_val_11612 === (7))){
var inst_11607 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
var statearr_11613_11679 = state_11611__$1;
(statearr_11613_11679[(2)] = inst_11607);

(statearr_11613_11679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (20))){
var state_11611__$1 = state_11611;
var statearr_11614_11680 = state_11611__$1;
(statearr_11614_11680[(2)] = null);

(statearr_11614_11680[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (1))){
var state_11611__$1 = state_11611;
var statearr_11615_11681 = state_11611__$1;
(statearr_11615_11681[(2)] = null);

(statearr_11615_11681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (4))){
var inst_11576 = (state_11611[(7)]);
var inst_11576__$1 = (state_11611[(2)]);
var inst_11577 = (inst_11576__$1 == null);
var state_11611__$1 = (function (){var statearr_11616 = state_11611;
(statearr_11616[(7)] = inst_11576__$1);

return statearr_11616;
})();
if(cljs.core.truth_(inst_11577)){
var statearr_11617_11682 = state_11611__$1;
(statearr_11617_11682[(1)] = (5));

} else {
var statearr_11618_11683 = state_11611__$1;
(statearr_11618_11683[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (15))){
var inst_11589 = (state_11611[(8)]);
var state_11611__$1 = state_11611;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11611__$1,(18),to,inst_11589);
} else {
if((state_val_11612 === (21))){
var inst_11602 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
var statearr_11619_11684 = state_11611__$1;
(statearr_11619_11684[(2)] = inst_11602);

(statearr_11619_11684[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (13))){
var inst_11604 = (state_11611[(2)]);
var state_11611__$1 = (function (){var statearr_11620 = state_11611;
(statearr_11620[(9)] = inst_11604);

return statearr_11620;
})();
var statearr_11621_11685 = state_11611__$1;
(statearr_11621_11685[(2)] = null);

(statearr_11621_11685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (6))){
var inst_11576 = (state_11611[(7)]);
var state_11611__$1 = state_11611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11611__$1,(11),inst_11576);
} else {
if((state_val_11612 === (17))){
var inst_11597 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
if(cljs.core.truth_(inst_11597)){
var statearr_11622_11686 = state_11611__$1;
(statearr_11622_11686[(1)] = (19));

} else {
var statearr_11623_11687 = state_11611__$1;
(statearr_11623_11687[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (3))){
var inst_11609 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11611__$1,inst_11609);
} else {
if((state_val_11612 === (12))){
var inst_11586 = (state_11611[(10)]);
var state_11611__$1 = state_11611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11611__$1,(14),inst_11586);
} else {
if((state_val_11612 === (2))){
var state_11611__$1 = state_11611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11611__$1,(4),results);
} else {
if((state_val_11612 === (19))){
var state_11611__$1 = state_11611;
var statearr_11624_11688 = state_11611__$1;
(statearr_11624_11688[(2)] = null);

(statearr_11624_11688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (11))){
var inst_11586 = (state_11611[(2)]);
var state_11611__$1 = (function (){var statearr_11625 = state_11611;
(statearr_11625[(10)] = inst_11586);

return statearr_11625;
})();
var statearr_11626_11689 = state_11611__$1;
(statearr_11626_11689[(2)] = null);

(statearr_11626_11689[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (9))){
var state_11611__$1 = state_11611;
var statearr_11627_11690 = state_11611__$1;
(statearr_11627_11690[(2)] = null);

(statearr_11627_11690[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (5))){
var state_11611__$1 = state_11611;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11628_11691 = state_11611__$1;
(statearr_11628_11691[(1)] = (8));

} else {
var statearr_11629_11692 = state_11611__$1;
(statearr_11629_11692[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (14))){
var inst_11589 = (state_11611[(8)]);
var inst_11591 = (state_11611[(11)]);
var inst_11589__$1 = (state_11611[(2)]);
var inst_11590 = (inst_11589__$1 == null);
var inst_11591__$1 = cljs.core.not.call(null,inst_11590);
var state_11611__$1 = (function (){var statearr_11630 = state_11611;
(statearr_11630[(8)] = inst_11589__$1);

(statearr_11630[(11)] = inst_11591__$1);

return statearr_11630;
})();
if(inst_11591__$1){
var statearr_11631_11693 = state_11611__$1;
(statearr_11631_11693[(1)] = (15));

} else {
var statearr_11632_11694 = state_11611__$1;
(statearr_11632_11694[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (16))){
var inst_11591 = (state_11611[(11)]);
var state_11611__$1 = state_11611;
var statearr_11633_11695 = state_11611__$1;
(statearr_11633_11695[(2)] = inst_11591);

(statearr_11633_11695[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (10))){
var inst_11583 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
var statearr_11634_11696 = state_11611__$1;
(statearr_11634_11696[(2)] = inst_11583);

(statearr_11634_11696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (18))){
var inst_11594 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
var statearr_11635_11697 = state_11611__$1;
(statearr_11635_11697[(2)] = inst_11594);

(statearr_11635_11697[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (8))){
var inst_11580 = cljs.core.async.close_BANG_.call(null,to);
var state_11611__$1 = state_11611;
var statearr_11636_11698 = state_11611__$1;
(statearr_11636_11698[(2)] = inst_11580);

(statearr_11636_11698[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto__,jobs,results,process,async))
;
return ((function (switch__10982__auto__,c__11094__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_11640 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11640[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_11640[(1)] = (1));

return statearr_11640;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_11611){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11641){if((e11641 instanceof Object)){
var ex__10986__auto__ = e11641;
var statearr_11642_11699 = state_11611;
(statearr_11642_11699[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11611);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11641;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11700 = state_11611;
state_11611 = G__11700;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_11611){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_11611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto__,jobs,results,process,async))
})();
var state__11096__auto__ = (function (){var statearr_11643 = f__11095__auto__.call(null);
(statearr_11643[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto__);

return statearr_11643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto__,jobs,results,process,async))
);

return c__11094__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11701 = [];
var len__5726__auto___11704 = arguments.length;
var i__5727__auto___11705 = (0);
while(true){
if((i__5727__auto___11705 < len__5726__auto___11704)){
args11701.push((arguments[i__5727__auto___11705]));

var G__11706 = (i__5727__auto___11705 + (1));
i__5727__auto___11705 = G__11706;
continue;
} else {
}
break;
}

var G__11703 = args11701.length;
switch (G__11703) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11701.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11708 = [];
var len__5726__auto___11711 = arguments.length;
var i__5727__auto___11712 = (0);
while(true){
if((i__5727__auto___11712 < len__5726__auto___11711)){
args11708.push((arguments[i__5727__auto___11712]));

var G__11713 = (i__5727__auto___11712 + (1));
i__5727__auto___11712 = G__11713;
continue;
} else {
}
break;
}

var G__11710 = args11708.length;
switch (G__11710) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11708.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11715 = [];
var len__5726__auto___11768 = arguments.length;
var i__5727__auto___11769 = (0);
while(true){
if((i__5727__auto___11769 < len__5726__auto___11768)){
args11715.push((arguments[i__5727__auto___11769]));

var G__11770 = (i__5727__auto___11769 + (1));
i__5727__auto___11769 = G__11770;
continue;
} else {
}
break;
}

var G__11717 = args11715.length;
switch (G__11717) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11715.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11094__auto___11772 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___11772,tc,fc){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___11772,tc,fc){
return (function (state_11743){
var state_val_11744 = (state_11743[(1)]);
if((state_val_11744 === (7))){
var inst_11739 = (state_11743[(2)]);
var state_11743__$1 = state_11743;
var statearr_11745_11773 = state_11743__$1;
(statearr_11745_11773[(2)] = inst_11739);

(statearr_11745_11773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (1))){
var state_11743__$1 = state_11743;
var statearr_11746_11774 = state_11743__$1;
(statearr_11746_11774[(2)] = null);

(statearr_11746_11774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (4))){
var inst_11720 = (state_11743[(7)]);
var inst_11720__$1 = (state_11743[(2)]);
var inst_11721 = (inst_11720__$1 == null);
var state_11743__$1 = (function (){var statearr_11747 = state_11743;
(statearr_11747[(7)] = inst_11720__$1);

return statearr_11747;
})();
if(cljs.core.truth_(inst_11721)){
var statearr_11748_11775 = state_11743__$1;
(statearr_11748_11775[(1)] = (5));

} else {
var statearr_11749_11776 = state_11743__$1;
(statearr_11749_11776[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (13))){
var state_11743__$1 = state_11743;
var statearr_11750_11777 = state_11743__$1;
(statearr_11750_11777[(2)] = null);

(statearr_11750_11777[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (6))){
var inst_11720 = (state_11743[(7)]);
var inst_11726 = p.call(null,inst_11720);
var state_11743__$1 = state_11743;
if(cljs.core.truth_(inst_11726)){
var statearr_11751_11778 = state_11743__$1;
(statearr_11751_11778[(1)] = (9));

} else {
var statearr_11752_11779 = state_11743__$1;
(statearr_11752_11779[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (3))){
var inst_11741 = (state_11743[(2)]);
var state_11743__$1 = state_11743;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11743__$1,inst_11741);
} else {
if((state_val_11744 === (12))){
var state_11743__$1 = state_11743;
var statearr_11753_11780 = state_11743__$1;
(statearr_11753_11780[(2)] = null);

(statearr_11753_11780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (2))){
var state_11743__$1 = state_11743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11743__$1,(4),ch);
} else {
if((state_val_11744 === (11))){
var inst_11720 = (state_11743[(7)]);
var inst_11730 = (state_11743[(2)]);
var state_11743__$1 = state_11743;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11743__$1,(8),inst_11730,inst_11720);
} else {
if((state_val_11744 === (9))){
var state_11743__$1 = state_11743;
var statearr_11754_11781 = state_11743__$1;
(statearr_11754_11781[(2)] = tc);

(statearr_11754_11781[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (5))){
var inst_11723 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11724 = cljs.core.async.close_BANG_.call(null,fc);
var state_11743__$1 = (function (){var statearr_11755 = state_11743;
(statearr_11755[(8)] = inst_11723);

return statearr_11755;
})();
var statearr_11756_11782 = state_11743__$1;
(statearr_11756_11782[(2)] = inst_11724);

(statearr_11756_11782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (14))){
var inst_11737 = (state_11743[(2)]);
var state_11743__$1 = state_11743;
var statearr_11757_11783 = state_11743__$1;
(statearr_11757_11783[(2)] = inst_11737);

(statearr_11757_11783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (10))){
var state_11743__$1 = state_11743;
var statearr_11758_11784 = state_11743__$1;
(statearr_11758_11784[(2)] = fc);

(statearr_11758_11784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11744 === (8))){
var inst_11732 = (state_11743[(2)]);
var state_11743__$1 = state_11743;
if(cljs.core.truth_(inst_11732)){
var statearr_11759_11785 = state_11743__$1;
(statearr_11759_11785[(1)] = (12));

} else {
var statearr_11760_11786 = state_11743__$1;
(statearr_11760_11786[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___11772,tc,fc))
;
return ((function (switch__10982__auto__,c__11094__auto___11772,tc,fc){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_11764 = [null,null,null,null,null,null,null,null,null];
(statearr_11764[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_11764[(1)] = (1));

return statearr_11764;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_11743){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11743);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11765){if((e11765 instanceof Object)){
var ex__10986__auto__ = e11765;
var statearr_11766_11787 = state_11743;
(statearr_11766_11787[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11743);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11765;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11788 = state_11743;
state_11743 = G__11788;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_11743){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_11743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___11772,tc,fc))
})();
var state__11096__auto__ = (function (){var statearr_11767 = f__11095__auto__.call(null);
(statearr_11767[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___11772);

return statearr_11767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___11772,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11094__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto__){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto__){
return (function (state_11852){
var state_val_11853 = (state_11852[(1)]);
if((state_val_11853 === (7))){
var inst_11848 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
var statearr_11854_11875 = state_11852__$1;
(statearr_11854_11875[(2)] = inst_11848);

(statearr_11854_11875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (1))){
var inst_11832 = init;
var state_11852__$1 = (function (){var statearr_11855 = state_11852;
(statearr_11855[(7)] = inst_11832);

return statearr_11855;
})();
var statearr_11856_11876 = state_11852__$1;
(statearr_11856_11876[(2)] = null);

(statearr_11856_11876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (4))){
var inst_11835 = (state_11852[(8)]);
var inst_11835__$1 = (state_11852[(2)]);
var inst_11836 = (inst_11835__$1 == null);
var state_11852__$1 = (function (){var statearr_11857 = state_11852;
(statearr_11857[(8)] = inst_11835__$1);

return statearr_11857;
})();
if(cljs.core.truth_(inst_11836)){
var statearr_11858_11877 = state_11852__$1;
(statearr_11858_11877[(1)] = (5));

} else {
var statearr_11859_11878 = state_11852__$1;
(statearr_11859_11878[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (6))){
var inst_11832 = (state_11852[(7)]);
var inst_11835 = (state_11852[(8)]);
var inst_11839 = (state_11852[(9)]);
var inst_11839__$1 = f.call(null,inst_11832,inst_11835);
var inst_11840 = cljs.core.reduced_QMARK_.call(null,inst_11839__$1);
var state_11852__$1 = (function (){var statearr_11860 = state_11852;
(statearr_11860[(9)] = inst_11839__$1);

return statearr_11860;
})();
if(inst_11840){
var statearr_11861_11879 = state_11852__$1;
(statearr_11861_11879[(1)] = (8));

} else {
var statearr_11862_11880 = state_11852__$1;
(statearr_11862_11880[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (3))){
var inst_11850 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11852__$1,inst_11850);
} else {
if((state_val_11853 === (2))){
var state_11852__$1 = state_11852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11852__$1,(4),ch);
} else {
if((state_val_11853 === (9))){
var inst_11839 = (state_11852[(9)]);
var inst_11832 = inst_11839;
var state_11852__$1 = (function (){var statearr_11863 = state_11852;
(statearr_11863[(7)] = inst_11832);

return statearr_11863;
})();
var statearr_11864_11881 = state_11852__$1;
(statearr_11864_11881[(2)] = null);

(statearr_11864_11881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (5))){
var inst_11832 = (state_11852[(7)]);
var state_11852__$1 = state_11852;
var statearr_11865_11882 = state_11852__$1;
(statearr_11865_11882[(2)] = inst_11832);

(statearr_11865_11882[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (10))){
var inst_11846 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
var statearr_11866_11883 = state_11852__$1;
(statearr_11866_11883[(2)] = inst_11846);

(statearr_11866_11883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (8))){
var inst_11839 = (state_11852[(9)]);
var inst_11842 = cljs.core.deref.call(null,inst_11839);
var state_11852__$1 = state_11852;
var statearr_11867_11884 = state_11852__$1;
(statearr_11867_11884[(2)] = inst_11842);

(statearr_11867_11884[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto__))
;
return ((function (switch__10982__auto__,c__11094__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10983__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10983__auto____0 = (function (){
var statearr_11871 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11871[(0)] = cljs$core$async$reduce_$_state_machine__10983__auto__);

(statearr_11871[(1)] = (1));

return statearr_11871;
});
var cljs$core$async$reduce_$_state_machine__10983__auto____1 = (function (state_11852){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11872){if((e11872 instanceof Object)){
var ex__10986__auto__ = e11872;
var statearr_11873_11885 = state_11852;
(statearr_11873_11885[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11852);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11872;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11886 = state_11852;
state_11852 = G__11886;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10983__auto__ = function(state_11852){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10983__auto____1.call(this,state_11852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10983__auto____0;
cljs$core$async$reduce_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10983__auto____1;
return cljs$core$async$reduce_$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto__))
})();
var state__11096__auto__ = (function (){var statearr_11874 = f__11095__auto__.call(null);
(statearr_11874[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto__);

return statearr_11874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto__))
);

return c__11094__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11887 = [];
var len__5726__auto___11939 = arguments.length;
var i__5727__auto___11940 = (0);
while(true){
if((i__5727__auto___11940 < len__5726__auto___11939)){
args11887.push((arguments[i__5727__auto___11940]));

var G__11941 = (i__5727__auto___11940 + (1));
i__5727__auto___11940 = G__11941;
continue;
} else {
}
break;
}

var G__11889 = args11887.length;
switch (G__11889) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11887.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11094__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto__){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto__){
return (function (state_11914){
var state_val_11915 = (state_11914[(1)]);
if((state_val_11915 === (7))){
var inst_11896 = (state_11914[(2)]);
var state_11914__$1 = state_11914;
var statearr_11916_11943 = state_11914__$1;
(statearr_11916_11943[(2)] = inst_11896);

(statearr_11916_11943[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (1))){
var inst_11890 = cljs.core.seq.call(null,coll);
var inst_11891 = inst_11890;
var state_11914__$1 = (function (){var statearr_11917 = state_11914;
(statearr_11917[(7)] = inst_11891);

return statearr_11917;
})();
var statearr_11918_11944 = state_11914__$1;
(statearr_11918_11944[(2)] = null);

(statearr_11918_11944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (4))){
var inst_11891 = (state_11914[(7)]);
var inst_11894 = cljs.core.first.call(null,inst_11891);
var state_11914__$1 = state_11914;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11914__$1,(7),ch,inst_11894);
} else {
if((state_val_11915 === (13))){
var inst_11908 = (state_11914[(2)]);
var state_11914__$1 = state_11914;
var statearr_11919_11945 = state_11914__$1;
(statearr_11919_11945[(2)] = inst_11908);

(statearr_11919_11945[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (6))){
var inst_11899 = (state_11914[(2)]);
var state_11914__$1 = state_11914;
if(cljs.core.truth_(inst_11899)){
var statearr_11920_11946 = state_11914__$1;
(statearr_11920_11946[(1)] = (8));

} else {
var statearr_11921_11947 = state_11914__$1;
(statearr_11921_11947[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (3))){
var inst_11912 = (state_11914[(2)]);
var state_11914__$1 = state_11914;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11914__$1,inst_11912);
} else {
if((state_val_11915 === (12))){
var state_11914__$1 = state_11914;
var statearr_11922_11948 = state_11914__$1;
(statearr_11922_11948[(2)] = null);

(statearr_11922_11948[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (2))){
var inst_11891 = (state_11914[(7)]);
var state_11914__$1 = state_11914;
if(cljs.core.truth_(inst_11891)){
var statearr_11923_11949 = state_11914__$1;
(statearr_11923_11949[(1)] = (4));

} else {
var statearr_11924_11950 = state_11914__$1;
(statearr_11924_11950[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (11))){
var inst_11905 = cljs.core.async.close_BANG_.call(null,ch);
var state_11914__$1 = state_11914;
var statearr_11925_11951 = state_11914__$1;
(statearr_11925_11951[(2)] = inst_11905);

(statearr_11925_11951[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (9))){
var state_11914__$1 = state_11914;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11926_11952 = state_11914__$1;
(statearr_11926_11952[(1)] = (11));

} else {
var statearr_11927_11953 = state_11914__$1;
(statearr_11927_11953[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (5))){
var inst_11891 = (state_11914[(7)]);
var state_11914__$1 = state_11914;
var statearr_11928_11954 = state_11914__$1;
(statearr_11928_11954[(2)] = inst_11891);

(statearr_11928_11954[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (10))){
var inst_11910 = (state_11914[(2)]);
var state_11914__$1 = state_11914;
var statearr_11929_11955 = state_11914__$1;
(statearr_11929_11955[(2)] = inst_11910);

(statearr_11929_11955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11915 === (8))){
var inst_11891 = (state_11914[(7)]);
var inst_11901 = cljs.core.next.call(null,inst_11891);
var inst_11891__$1 = inst_11901;
var state_11914__$1 = (function (){var statearr_11930 = state_11914;
(statearr_11930[(7)] = inst_11891__$1);

return statearr_11930;
})();
var statearr_11931_11956 = state_11914__$1;
(statearr_11931_11956[(2)] = null);

(statearr_11931_11956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto__))
;
return ((function (switch__10982__auto__,c__11094__auto__){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_11935 = [null,null,null,null,null,null,null,null];
(statearr_11935[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_11935[(1)] = (1));

return statearr_11935;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_11914){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_11914);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e11936){if((e11936 instanceof Object)){
var ex__10986__auto__ = e11936;
var statearr_11937_11957 = state_11914;
(statearr_11937_11957[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11914);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11936;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11958 = state_11914;
state_11914 = G__11958;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_11914){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_11914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto__))
})();
var state__11096__auto__ = (function (){var statearr_11938 = f__11095__auto__.call(null);
(statearr_11938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto__);

return statearr_11938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto__))
);

return c__11094__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12180 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12180 = (function (mult,ch,cs,meta12181){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12181 = meta12181;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12180.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12182,meta12181__$1){
var self__ = this;
var _12182__$1 = this;
return (new cljs.core.async.t_cljs$core$async12180(self__.mult,self__.ch,self__.cs,meta12181__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12180.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12182){
var self__ = this;
var _12182__$1 = this;
return self__.meta12181;
});})(cs))
;

cljs.core.async.t_cljs$core$async12180.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12180.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12180.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12180.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12180.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12180.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12180.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12181","meta12181",-1754262649,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12180.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12180.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12180";

cljs.core.async.t_cljs$core$async12180.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12180");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12180 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12180(mult__$1,ch__$1,cs__$1,meta12181){
return (new cljs.core.async.t_cljs$core$async12180(mult__$1,ch__$1,cs__$1,meta12181));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12180(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11094__auto___12401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___12401,cs,m,dchan,dctr,done){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___12401,cs,m,dchan,dctr,done){
return (function (state_12313){
var state_val_12314 = (state_12313[(1)]);
if((state_val_12314 === (7))){
var inst_12309 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12315_12402 = state_12313__$1;
(statearr_12315_12402[(2)] = inst_12309);

(statearr_12315_12402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (20))){
var inst_12214 = (state_12313[(7)]);
var inst_12224 = cljs.core.first.call(null,inst_12214);
var inst_12225 = cljs.core.nth.call(null,inst_12224,(0),null);
var inst_12226 = cljs.core.nth.call(null,inst_12224,(1),null);
var state_12313__$1 = (function (){var statearr_12316 = state_12313;
(statearr_12316[(8)] = inst_12225);

return statearr_12316;
})();
if(cljs.core.truth_(inst_12226)){
var statearr_12317_12403 = state_12313__$1;
(statearr_12317_12403[(1)] = (22));

} else {
var statearr_12318_12404 = state_12313__$1;
(statearr_12318_12404[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (27))){
var inst_12256 = (state_12313[(9)]);
var inst_12261 = (state_12313[(10)]);
var inst_12185 = (state_12313[(11)]);
var inst_12254 = (state_12313[(12)]);
var inst_12261__$1 = cljs.core._nth.call(null,inst_12254,inst_12256);
var inst_12262 = cljs.core.async.put_BANG_.call(null,inst_12261__$1,inst_12185,done);
var state_12313__$1 = (function (){var statearr_12319 = state_12313;
(statearr_12319[(10)] = inst_12261__$1);

return statearr_12319;
})();
if(cljs.core.truth_(inst_12262)){
var statearr_12320_12405 = state_12313__$1;
(statearr_12320_12405[(1)] = (30));

} else {
var statearr_12321_12406 = state_12313__$1;
(statearr_12321_12406[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (1))){
var state_12313__$1 = state_12313;
var statearr_12322_12407 = state_12313__$1;
(statearr_12322_12407[(2)] = null);

(statearr_12322_12407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (24))){
var inst_12214 = (state_12313[(7)]);
var inst_12231 = (state_12313[(2)]);
var inst_12232 = cljs.core.next.call(null,inst_12214);
var inst_12194 = inst_12232;
var inst_12195 = null;
var inst_12196 = (0);
var inst_12197 = (0);
var state_12313__$1 = (function (){var statearr_12323 = state_12313;
(statearr_12323[(13)] = inst_12197);

(statearr_12323[(14)] = inst_12194);

(statearr_12323[(15)] = inst_12195);

(statearr_12323[(16)] = inst_12196);

(statearr_12323[(17)] = inst_12231);

return statearr_12323;
})();
var statearr_12324_12408 = state_12313__$1;
(statearr_12324_12408[(2)] = null);

(statearr_12324_12408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (39))){
var state_12313__$1 = state_12313;
var statearr_12328_12409 = state_12313__$1;
(statearr_12328_12409[(2)] = null);

(statearr_12328_12409[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (4))){
var inst_12185 = (state_12313[(11)]);
var inst_12185__$1 = (state_12313[(2)]);
var inst_12186 = (inst_12185__$1 == null);
var state_12313__$1 = (function (){var statearr_12329 = state_12313;
(statearr_12329[(11)] = inst_12185__$1);

return statearr_12329;
})();
if(cljs.core.truth_(inst_12186)){
var statearr_12330_12410 = state_12313__$1;
(statearr_12330_12410[(1)] = (5));

} else {
var statearr_12331_12411 = state_12313__$1;
(statearr_12331_12411[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (15))){
var inst_12197 = (state_12313[(13)]);
var inst_12194 = (state_12313[(14)]);
var inst_12195 = (state_12313[(15)]);
var inst_12196 = (state_12313[(16)]);
var inst_12210 = (state_12313[(2)]);
var inst_12211 = (inst_12197 + (1));
var tmp12325 = inst_12194;
var tmp12326 = inst_12195;
var tmp12327 = inst_12196;
var inst_12194__$1 = tmp12325;
var inst_12195__$1 = tmp12326;
var inst_12196__$1 = tmp12327;
var inst_12197__$1 = inst_12211;
var state_12313__$1 = (function (){var statearr_12332 = state_12313;
(statearr_12332[(13)] = inst_12197__$1);

(statearr_12332[(14)] = inst_12194__$1);

(statearr_12332[(15)] = inst_12195__$1);

(statearr_12332[(18)] = inst_12210);

(statearr_12332[(16)] = inst_12196__$1);

return statearr_12332;
})();
var statearr_12333_12412 = state_12313__$1;
(statearr_12333_12412[(2)] = null);

(statearr_12333_12412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (21))){
var inst_12235 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12337_12413 = state_12313__$1;
(statearr_12337_12413[(2)] = inst_12235);

(statearr_12337_12413[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (31))){
var inst_12261 = (state_12313[(10)]);
var inst_12265 = done.call(null,null);
var inst_12266 = cljs.core.async.untap_STAR_.call(null,m,inst_12261);
var state_12313__$1 = (function (){var statearr_12338 = state_12313;
(statearr_12338[(19)] = inst_12265);

return statearr_12338;
})();
var statearr_12339_12414 = state_12313__$1;
(statearr_12339_12414[(2)] = inst_12266);

(statearr_12339_12414[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (32))){
var inst_12256 = (state_12313[(9)]);
var inst_12253 = (state_12313[(20)]);
var inst_12255 = (state_12313[(21)]);
var inst_12254 = (state_12313[(12)]);
var inst_12268 = (state_12313[(2)]);
var inst_12269 = (inst_12256 + (1));
var tmp12334 = inst_12253;
var tmp12335 = inst_12255;
var tmp12336 = inst_12254;
var inst_12253__$1 = tmp12334;
var inst_12254__$1 = tmp12336;
var inst_12255__$1 = tmp12335;
var inst_12256__$1 = inst_12269;
var state_12313__$1 = (function (){var statearr_12340 = state_12313;
(statearr_12340[(22)] = inst_12268);

(statearr_12340[(9)] = inst_12256__$1);

(statearr_12340[(20)] = inst_12253__$1);

(statearr_12340[(21)] = inst_12255__$1);

(statearr_12340[(12)] = inst_12254__$1);

return statearr_12340;
})();
var statearr_12341_12415 = state_12313__$1;
(statearr_12341_12415[(2)] = null);

(statearr_12341_12415[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (40))){
var inst_12281 = (state_12313[(23)]);
var inst_12285 = done.call(null,null);
var inst_12286 = cljs.core.async.untap_STAR_.call(null,m,inst_12281);
var state_12313__$1 = (function (){var statearr_12342 = state_12313;
(statearr_12342[(24)] = inst_12285);

return statearr_12342;
})();
var statearr_12343_12416 = state_12313__$1;
(statearr_12343_12416[(2)] = inst_12286);

(statearr_12343_12416[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (33))){
var inst_12272 = (state_12313[(25)]);
var inst_12274 = cljs.core.chunked_seq_QMARK_.call(null,inst_12272);
var state_12313__$1 = state_12313;
if(inst_12274){
var statearr_12344_12417 = state_12313__$1;
(statearr_12344_12417[(1)] = (36));

} else {
var statearr_12345_12418 = state_12313__$1;
(statearr_12345_12418[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (13))){
var inst_12204 = (state_12313[(26)]);
var inst_12207 = cljs.core.async.close_BANG_.call(null,inst_12204);
var state_12313__$1 = state_12313;
var statearr_12346_12419 = state_12313__$1;
(statearr_12346_12419[(2)] = inst_12207);

(statearr_12346_12419[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (22))){
var inst_12225 = (state_12313[(8)]);
var inst_12228 = cljs.core.async.close_BANG_.call(null,inst_12225);
var state_12313__$1 = state_12313;
var statearr_12347_12420 = state_12313__$1;
(statearr_12347_12420[(2)] = inst_12228);

(statearr_12347_12420[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (36))){
var inst_12272 = (state_12313[(25)]);
var inst_12276 = cljs.core.chunk_first.call(null,inst_12272);
var inst_12277 = cljs.core.chunk_rest.call(null,inst_12272);
var inst_12278 = cljs.core.count.call(null,inst_12276);
var inst_12253 = inst_12277;
var inst_12254 = inst_12276;
var inst_12255 = inst_12278;
var inst_12256 = (0);
var state_12313__$1 = (function (){var statearr_12348 = state_12313;
(statearr_12348[(9)] = inst_12256);

(statearr_12348[(20)] = inst_12253);

(statearr_12348[(21)] = inst_12255);

(statearr_12348[(12)] = inst_12254);

return statearr_12348;
})();
var statearr_12349_12421 = state_12313__$1;
(statearr_12349_12421[(2)] = null);

(statearr_12349_12421[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (41))){
var inst_12272 = (state_12313[(25)]);
var inst_12288 = (state_12313[(2)]);
var inst_12289 = cljs.core.next.call(null,inst_12272);
var inst_12253 = inst_12289;
var inst_12254 = null;
var inst_12255 = (0);
var inst_12256 = (0);
var state_12313__$1 = (function (){var statearr_12350 = state_12313;
(statearr_12350[(27)] = inst_12288);

(statearr_12350[(9)] = inst_12256);

(statearr_12350[(20)] = inst_12253);

(statearr_12350[(21)] = inst_12255);

(statearr_12350[(12)] = inst_12254);

return statearr_12350;
})();
var statearr_12351_12422 = state_12313__$1;
(statearr_12351_12422[(2)] = null);

(statearr_12351_12422[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (43))){
var state_12313__$1 = state_12313;
var statearr_12352_12423 = state_12313__$1;
(statearr_12352_12423[(2)] = null);

(statearr_12352_12423[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (29))){
var inst_12297 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12353_12424 = state_12313__$1;
(statearr_12353_12424[(2)] = inst_12297);

(statearr_12353_12424[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (44))){
var inst_12306 = (state_12313[(2)]);
var state_12313__$1 = (function (){var statearr_12354 = state_12313;
(statearr_12354[(28)] = inst_12306);

return statearr_12354;
})();
var statearr_12355_12425 = state_12313__$1;
(statearr_12355_12425[(2)] = null);

(statearr_12355_12425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (6))){
var inst_12245 = (state_12313[(29)]);
var inst_12244 = cljs.core.deref.call(null,cs);
var inst_12245__$1 = cljs.core.keys.call(null,inst_12244);
var inst_12246 = cljs.core.count.call(null,inst_12245__$1);
var inst_12247 = cljs.core.reset_BANG_.call(null,dctr,inst_12246);
var inst_12252 = cljs.core.seq.call(null,inst_12245__$1);
var inst_12253 = inst_12252;
var inst_12254 = null;
var inst_12255 = (0);
var inst_12256 = (0);
var state_12313__$1 = (function (){var statearr_12356 = state_12313;
(statearr_12356[(9)] = inst_12256);

(statearr_12356[(20)] = inst_12253);

(statearr_12356[(30)] = inst_12247);

(statearr_12356[(21)] = inst_12255);

(statearr_12356[(12)] = inst_12254);

(statearr_12356[(29)] = inst_12245__$1);

return statearr_12356;
})();
var statearr_12357_12426 = state_12313__$1;
(statearr_12357_12426[(2)] = null);

(statearr_12357_12426[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (28))){
var inst_12253 = (state_12313[(20)]);
var inst_12272 = (state_12313[(25)]);
var inst_12272__$1 = cljs.core.seq.call(null,inst_12253);
var state_12313__$1 = (function (){var statearr_12358 = state_12313;
(statearr_12358[(25)] = inst_12272__$1);

return statearr_12358;
})();
if(inst_12272__$1){
var statearr_12359_12427 = state_12313__$1;
(statearr_12359_12427[(1)] = (33));

} else {
var statearr_12360_12428 = state_12313__$1;
(statearr_12360_12428[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (25))){
var inst_12256 = (state_12313[(9)]);
var inst_12255 = (state_12313[(21)]);
var inst_12258 = (inst_12256 < inst_12255);
var inst_12259 = inst_12258;
var state_12313__$1 = state_12313;
if(cljs.core.truth_(inst_12259)){
var statearr_12361_12429 = state_12313__$1;
(statearr_12361_12429[(1)] = (27));

} else {
var statearr_12362_12430 = state_12313__$1;
(statearr_12362_12430[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (34))){
var state_12313__$1 = state_12313;
var statearr_12363_12431 = state_12313__$1;
(statearr_12363_12431[(2)] = null);

(statearr_12363_12431[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (17))){
var state_12313__$1 = state_12313;
var statearr_12364_12432 = state_12313__$1;
(statearr_12364_12432[(2)] = null);

(statearr_12364_12432[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (3))){
var inst_12311 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12313__$1,inst_12311);
} else {
if((state_val_12314 === (12))){
var inst_12240 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12365_12433 = state_12313__$1;
(statearr_12365_12433[(2)] = inst_12240);

(statearr_12365_12433[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (2))){
var state_12313__$1 = state_12313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12313__$1,(4),ch);
} else {
if((state_val_12314 === (23))){
var state_12313__$1 = state_12313;
var statearr_12366_12434 = state_12313__$1;
(statearr_12366_12434[(2)] = null);

(statearr_12366_12434[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (35))){
var inst_12295 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12367_12435 = state_12313__$1;
(statearr_12367_12435[(2)] = inst_12295);

(statearr_12367_12435[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (19))){
var inst_12214 = (state_12313[(7)]);
var inst_12218 = cljs.core.chunk_first.call(null,inst_12214);
var inst_12219 = cljs.core.chunk_rest.call(null,inst_12214);
var inst_12220 = cljs.core.count.call(null,inst_12218);
var inst_12194 = inst_12219;
var inst_12195 = inst_12218;
var inst_12196 = inst_12220;
var inst_12197 = (0);
var state_12313__$1 = (function (){var statearr_12368 = state_12313;
(statearr_12368[(13)] = inst_12197);

(statearr_12368[(14)] = inst_12194);

(statearr_12368[(15)] = inst_12195);

(statearr_12368[(16)] = inst_12196);

return statearr_12368;
})();
var statearr_12369_12436 = state_12313__$1;
(statearr_12369_12436[(2)] = null);

(statearr_12369_12436[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (11))){
var inst_12214 = (state_12313[(7)]);
var inst_12194 = (state_12313[(14)]);
var inst_12214__$1 = cljs.core.seq.call(null,inst_12194);
var state_12313__$1 = (function (){var statearr_12370 = state_12313;
(statearr_12370[(7)] = inst_12214__$1);

return statearr_12370;
})();
if(inst_12214__$1){
var statearr_12371_12437 = state_12313__$1;
(statearr_12371_12437[(1)] = (16));

} else {
var statearr_12372_12438 = state_12313__$1;
(statearr_12372_12438[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (9))){
var inst_12242 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12373_12439 = state_12313__$1;
(statearr_12373_12439[(2)] = inst_12242);

(statearr_12373_12439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (5))){
var inst_12192 = cljs.core.deref.call(null,cs);
var inst_12193 = cljs.core.seq.call(null,inst_12192);
var inst_12194 = inst_12193;
var inst_12195 = null;
var inst_12196 = (0);
var inst_12197 = (0);
var state_12313__$1 = (function (){var statearr_12374 = state_12313;
(statearr_12374[(13)] = inst_12197);

(statearr_12374[(14)] = inst_12194);

(statearr_12374[(15)] = inst_12195);

(statearr_12374[(16)] = inst_12196);

return statearr_12374;
})();
var statearr_12375_12440 = state_12313__$1;
(statearr_12375_12440[(2)] = null);

(statearr_12375_12440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (14))){
var state_12313__$1 = state_12313;
var statearr_12376_12441 = state_12313__$1;
(statearr_12376_12441[(2)] = null);

(statearr_12376_12441[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (45))){
var inst_12303 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12377_12442 = state_12313__$1;
(statearr_12377_12442[(2)] = inst_12303);

(statearr_12377_12442[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (26))){
var inst_12245 = (state_12313[(29)]);
var inst_12299 = (state_12313[(2)]);
var inst_12300 = cljs.core.seq.call(null,inst_12245);
var state_12313__$1 = (function (){var statearr_12378 = state_12313;
(statearr_12378[(31)] = inst_12299);

return statearr_12378;
})();
if(inst_12300){
var statearr_12379_12443 = state_12313__$1;
(statearr_12379_12443[(1)] = (42));

} else {
var statearr_12380_12444 = state_12313__$1;
(statearr_12380_12444[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (16))){
var inst_12214 = (state_12313[(7)]);
var inst_12216 = cljs.core.chunked_seq_QMARK_.call(null,inst_12214);
var state_12313__$1 = state_12313;
if(inst_12216){
var statearr_12381_12445 = state_12313__$1;
(statearr_12381_12445[(1)] = (19));

} else {
var statearr_12382_12446 = state_12313__$1;
(statearr_12382_12446[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (38))){
var inst_12292 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12383_12447 = state_12313__$1;
(statearr_12383_12447[(2)] = inst_12292);

(statearr_12383_12447[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (30))){
var state_12313__$1 = state_12313;
var statearr_12384_12448 = state_12313__$1;
(statearr_12384_12448[(2)] = null);

(statearr_12384_12448[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (10))){
var inst_12197 = (state_12313[(13)]);
var inst_12195 = (state_12313[(15)]);
var inst_12203 = cljs.core._nth.call(null,inst_12195,inst_12197);
var inst_12204 = cljs.core.nth.call(null,inst_12203,(0),null);
var inst_12205 = cljs.core.nth.call(null,inst_12203,(1),null);
var state_12313__$1 = (function (){var statearr_12385 = state_12313;
(statearr_12385[(26)] = inst_12204);

return statearr_12385;
})();
if(cljs.core.truth_(inst_12205)){
var statearr_12386_12449 = state_12313__$1;
(statearr_12386_12449[(1)] = (13));

} else {
var statearr_12387_12450 = state_12313__$1;
(statearr_12387_12450[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (18))){
var inst_12238 = (state_12313[(2)]);
var state_12313__$1 = state_12313;
var statearr_12388_12451 = state_12313__$1;
(statearr_12388_12451[(2)] = inst_12238);

(statearr_12388_12451[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (42))){
var state_12313__$1 = state_12313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12313__$1,(45),dchan);
} else {
if((state_val_12314 === (37))){
var inst_12281 = (state_12313[(23)]);
var inst_12185 = (state_12313[(11)]);
var inst_12272 = (state_12313[(25)]);
var inst_12281__$1 = cljs.core.first.call(null,inst_12272);
var inst_12282 = cljs.core.async.put_BANG_.call(null,inst_12281__$1,inst_12185,done);
var state_12313__$1 = (function (){var statearr_12389 = state_12313;
(statearr_12389[(23)] = inst_12281__$1);

return statearr_12389;
})();
if(cljs.core.truth_(inst_12282)){
var statearr_12390_12452 = state_12313__$1;
(statearr_12390_12452[(1)] = (39));

} else {
var statearr_12391_12453 = state_12313__$1;
(statearr_12391_12453[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12314 === (8))){
var inst_12197 = (state_12313[(13)]);
var inst_12196 = (state_12313[(16)]);
var inst_12199 = (inst_12197 < inst_12196);
var inst_12200 = inst_12199;
var state_12313__$1 = state_12313;
if(cljs.core.truth_(inst_12200)){
var statearr_12392_12454 = state_12313__$1;
(statearr_12392_12454[(1)] = (10));

} else {
var statearr_12393_12455 = state_12313__$1;
(statearr_12393_12455[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___12401,cs,m,dchan,dctr,done))
;
return ((function (switch__10982__auto__,c__11094__auto___12401,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10983__auto__ = null;
var cljs$core$async$mult_$_state_machine__10983__auto____0 = (function (){
var statearr_12397 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12397[(0)] = cljs$core$async$mult_$_state_machine__10983__auto__);

(statearr_12397[(1)] = (1));

return statearr_12397;
});
var cljs$core$async$mult_$_state_machine__10983__auto____1 = (function (state_12313){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_12313);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e12398){if((e12398 instanceof Object)){
var ex__10986__auto__ = e12398;
var statearr_12399_12456 = state_12313;
(statearr_12399_12456[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12313);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12398;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12457 = state_12313;
state_12313 = G__12457;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10983__auto__ = function(state_12313){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10983__auto____1.call(this,state_12313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10983__auto____0;
cljs$core$async$mult_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10983__auto____1;
return cljs$core$async$mult_$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___12401,cs,m,dchan,dctr,done))
})();
var state__11096__auto__ = (function (){var statearr_12400 = f__11095__auto__.call(null);
(statearr_12400[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___12401);

return statearr_12400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___12401,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args12458 = [];
var len__5726__auto___12461 = arguments.length;
var i__5727__auto___12462 = (0);
while(true){
if((i__5727__auto___12462 < len__5726__auto___12461)){
args12458.push((arguments[i__5727__auto___12462]));

var G__12463 = (i__5727__auto___12462 + (1));
i__5727__auto___12462 = G__12463;
continue;
} else {
}
break;
}

var G__12460 = args12458.length;
switch (G__12460) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12458.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___12475 = arguments.length;
var i__5727__auto___12476 = (0);
while(true){
if((i__5727__auto___12476 < len__5726__auto___12475)){
args__5733__auto__.push((arguments[i__5727__auto___12476]));

var G__12477 = (i__5727__auto___12476 + (1));
i__5727__auto___12476 = G__12477;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12469){
var map__12470 = p__12469;
var map__12470__$1 = ((((!((map__12470 == null)))?((((map__12470.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12470.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12470):map__12470);
var opts = map__12470__$1;
var statearr_12472_12478 = state;
(statearr_12472_12478[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__12470,map__12470__$1,opts){
return (function (val){
var statearr_12473_12479 = state;
(statearr_12473_12479[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12470,map__12470__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_12474_12480 = state;
(statearr_12474_12480[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12465){
var G__12466 = cljs.core.first.call(null,seq12465);
var seq12465__$1 = cljs.core.next.call(null,seq12465);
var G__12467 = cljs.core.first.call(null,seq12465__$1);
var seq12465__$2 = cljs.core.next.call(null,seq12465__$1);
var G__12468 = cljs.core.first.call(null,seq12465__$2);
var seq12465__$3 = cljs.core.next.call(null,seq12465__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12466,G__12467,G__12468,seq12465__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12644 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12644 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12645){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12645 = meta12645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12646,meta12645__$1){
var self__ = this;
var _12646__$1 = this;
return (new cljs.core.async.t_cljs$core$async12644(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12645__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12646){
var self__ = this;
var _12646__$1 = this;
return self__.meta12645;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12645","meta12645",1670007546,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12644.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12644.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12644";

cljs.core.async.t_cljs$core$async12644.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12644");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12644 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12644(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12645){
return (new cljs.core.async.t_cljs$core$async12644(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12645));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12644(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11094__auto___12807 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___12807,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___12807,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12744){
var state_val_12745 = (state_12744[(1)]);
if((state_val_12745 === (7))){
var inst_12662 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
var statearr_12746_12808 = state_12744__$1;
(statearr_12746_12808[(2)] = inst_12662);

(statearr_12746_12808[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (20))){
var inst_12674 = (state_12744[(7)]);
var state_12744__$1 = state_12744;
var statearr_12747_12809 = state_12744__$1;
(statearr_12747_12809[(2)] = inst_12674);

(statearr_12747_12809[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (27))){
var state_12744__$1 = state_12744;
var statearr_12748_12810 = state_12744__$1;
(statearr_12748_12810[(2)] = null);

(statearr_12748_12810[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (1))){
var inst_12650 = (state_12744[(8)]);
var inst_12650__$1 = calc_state.call(null);
var inst_12652 = (inst_12650__$1 == null);
var inst_12653 = cljs.core.not.call(null,inst_12652);
var state_12744__$1 = (function (){var statearr_12749 = state_12744;
(statearr_12749[(8)] = inst_12650__$1);

return statearr_12749;
})();
if(inst_12653){
var statearr_12750_12811 = state_12744__$1;
(statearr_12750_12811[(1)] = (2));

} else {
var statearr_12751_12812 = state_12744__$1;
(statearr_12751_12812[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (24))){
var inst_12718 = (state_12744[(9)]);
var inst_12704 = (state_12744[(10)]);
var inst_12697 = (state_12744[(11)]);
var inst_12718__$1 = inst_12697.call(null,inst_12704);
var state_12744__$1 = (function (){var statearr_12752 = state_12744;
(statearr_12752[(9)] = inst_12718__$1);

return statearr_12752;
})();
if(cljs.core.truth_(inst_12718__$1)){
var statearr_12753_12813 = state_12744__$1;
(statearr_12753_12813[(1)] = (29));

} else {
var statearr_12754_12814 = state_12744__$1;
(statearr_12754_12814[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (4))){
var inst_12665 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
if(cljs.core.truth_(inst_12665)){
var statearr_12755_12815 = state_12744__$1;
(statearr_12755_12815[(1)] = (8));

} else {
var statearr_12756_12816 = state_12744__$1;
(statearr_12756_12816[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (15))){
var inst_12691 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
if(cljs.core.truth_(inst_12691)){
var statearr_12757_12817 = state_12744__$1;
(statearr_12757_12817[(1)] = (19));

} else {
var statearr_12758_12818 = state_12744__$1;
(statearr_12758_12818[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (21))){
var inst_12696 = (state_12744[(12)]);
var inst_12696__$1 = (state_12744[(2)]);
var inst_12697 = cljs.core.get.call(null,inst_12696__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12698 = cljs.core.get.call(null,inst_12696__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12699 = cljs.core.get.call(null,inst_12696__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12744__$1 = (function (){var statearr_12759 = state_12744;
(statearr_12759[(11)] = inst_12697);

(statearr_12759[(12)] = inst_12696__$1);

(statearr_12759[(13)] = inst_12698);

return statearr_12759;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12744__$1,(22),inst_12699);
} else {
if((state_val_12745 === (31))){
var inst_12726 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
if(cljs.core.truth_(inst_12726)){
var statearr_12760_12819 = state_12744__$1;
(statearr_12760_12819[(1)] = (32));

} else {
var statearr_12761_12820 = state_12744__$1;
(statearr_12761_12820[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (32))){
var inst_12703 = (state_12744[(14)]);
var state_12744__$1 = state_12744;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12744__$1,(35),out,inst_12703);
} else {
if((state_val_12745 === (33))){
var inst_12696 = (state_12744[(12)]);
var inst_12674 = inst_12696;
var state_12744__$1 = (function (){var statearr_12762 = state_12744;
(statearr_12762[(7)] = inst_12674);

return statearr_12762;
})();
var statearr_12763_12821 = state_12744__$1;
(statearr_12763_12821[(2)] = null);

(statearr_12763_12821[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (13))){
var inst_12674 = (state_12744[(7)]);
var inst_12681 = inst_12674.cljs$lang$protocol_mask$partition0$;
var inst_12682 = (inst_12681 & (64));
var inst_12683 = inst_12674.cljs$core$ISeq$;
var inst_12684 = (inst_12682) || (inst_12683);
var state_12744__$1 = state_12744;
if(cljs.core.truth_(inst_12684)){
var statearr_12764_12822 = state_12744__$1;
(statearr_12764_12822[(1)] = (16));

} else {
var statearr_12765_12823 = state_12744__$1;
(statearr_12765_12823[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (22))){
var inst_12704 = (state_12744[(10)]);
var inst_12703 = (state_12744[(14)]);
var inst_12702 = (state_12744[(2)]);
var inst_12703__$1 = cljs.core.nth.call(null,inst_12702,(0),null);
var inst_12704__$1 = cljs.core.nth.call(null,inst_12702,(1),null);
var inst_12705 = (inst_12703__$1 == null);
var inst_12706 = cljs.core._EQ_.call(null,inst_12704__$1,change);
var inst_12707 = (inst_12705) || (inst_12706);
var state_12744__$1 = (function (){var statearr_12766 = state_12744;
(statearr_12766[(10)] = inst_12704__$1);

(statearr_12766[(14)] = inst_12703__$1);

return statearr_12766;
})();
if(cljs.core.truth_(inst_12707)){
var statearr_12767_12824 = state_12744__$1;
(statearr_12767_12824[(1)] = (23));

} else {
var statearr_12768_12825 = state_12744__$1;
(statearr_12768_12825[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (36))){
var inst_12696 = (state_12744[(12)]);
var inst_12674 = inst_12696;
var state_12744__$1 = (function (){var statearr_12769 = state_12744;
(statearr_12769[(7)] = inst_12674);

return statearr_12769;
})();
var statearr_12770_12826 = state_12744__$1;
(statearr_12770_12826[(2)] = null);

(statearr_12770_12826[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (29))){
var inst_12718 = (state_12744[(9)]);
var state_12744__$1 = state_12744;
var statearr_12771_12827 = state_12744__$1;
(statearr_12771_12827[(2)] = inst_12718);

(statearr_12771_12827[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (6))){
var state_12744__$1 = state_12744;
var statearr_12772_12828 = state_12744__$1;
(statearr_12772_12828[(2)] = false);

(statearr_12772_12828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (28))){
var inst_12714 = (state_12744[(2)]);
var inst_12715 = calc_state.call(null);
var inst_12674 = inst_12715;
var state_12744__$1 = (function (){var statearr_12773 = state_12744;
(statearr_12773[(7)] = inst_12674);

(statearr_12773[(15)] = inst_12714);

return statearr_12773;
})();
var statearr_12774_12829 = state_12744__$1;
(statearr_12774_12829[(2)] = null);

(statearr_12774_12829[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (25))){
var inst_12740 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
var statearr_12775_12830 = state_12744__$1;
(statearr_12775_12830[(2)] = inst_12740);

(statearr_12775_12830[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (34))){
var inst_12738 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
var statearr_12776_12831 = state_12744__$1;
(statearr_12776_12831[(2)] = inst_12738);

(statearr_12776_12831[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (17))){
var state_12744__$1 = state_12744;
var statearr_12777_12832 = state_12744__$1;
(statearr_12777_12832[(2)] = false);

(statearr_12777_12832[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (3))){
var state_12744__$1 = state_12744;
var statearr_12778_12833 = state_12744__$1;
(statearr_12778_12833[(2)] = false);

(statearr_12778_12833[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (12))){
var inst_12742 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12744__$1,inst_12742);
} else {
if((state_val_12745 === (2))){
var inst_12650 = (state_12744[(8)]);
var inst_12655 = inst_12650.cljs$lang$protocol_mask$partition0$;
var inst_12656 = (inst_12655 & (64));
var inst_12657 = inst_12650.cljs$core$ISeq$;
var inst_12658 = (inst_12656) || (inst_12657);
var state_12744__$1 = state_12744;
if(cljs.core.truth_(inst_12658)){
var statearr_12779_12834 = state_12744__$1;
(statearr_12779_12834[(1)] = (5));

} else {
var statearr_12780_12835 = state_12744__$1;
(statearr_12780_12835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (23))){
var inst_12703 = (state_12744[(14)]);
var inst_12709 = (inst_12703 == null);
var state_12744__$1 = state_12744;
if(cljs.core.truth_(inst_12709)){
var statearr_12781_12836 = state_12744__$1;
(statearr_12781_12836[(1)] = (26));

} else {
var statearr_12782_12837 = state_12744__$1;
(statearr_12782_12837[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (35))){
var inst_12729 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
if(cljs.core.truth_(inst_12729)){
var statearr_12783_12838 = state_12744__$1;
(statearr_12783_12838[(1)] = (36));

} else {
var statearr_12784_12839 = state_12744__$1;
(statearr_12784_12839[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (19))){
var inst_12674 = (state_12744[(7)]);
var inst_12693 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12674);
var state_12744__$1 = state_12744;
var statearr_12785_12840 = state_12744__$1;
(statearr_12785_12840[(2)] = inst_12693);

(statearr_12785_12840[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (11))){
var inst_12674 = (state_12744[(7)]);
var inst_12678 = (inst_12674 == null);
var inst_12679 = cljs.core.not.call(null,inst_12678);
var state_12744__$1 = state_12744;
if(inst_12679){
var statearr_12786_12841 = state_12744__$1;
(statearr_12786_12841[(1)] = (13));

} else {
var statearr_12787_12842 = state_12744__$1;
(statearr_12787_12842[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (9))){
var inst_12650 = (state_12744[(8)]);
var state_12744__$1 = state_12744;
var statearr_12788_12843 = state_12744__$1;
(statearr_12788_12843[(2)] = inst_12650);

(statearr_12788_12843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (5))){
var state_12744__$1 = state_12744;
var statearr_12789_12844 = state_12744__$1;
(statearr_12789_12844[(2)] = true);

(statearr_12789_12844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (14))){
var state_12744__$1 = state_12744;
var statearr_12790_12845 = state_12744__$1;
(statearr_12790_12845[(2)] = false);

(statearr_12790_12845[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (26))){
var inst_12704 = (state_12744[(10)]);
var inst_12711 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12704);
var state_12744__$1 = state_12744;
var statearr_12791_12846 = state_12744__$1;
(statearr_12791_12846[(2)] = inst_12711);

(statearr_12791_12846[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (16))){
var state_12744__$1 = state_12744;
var statearr_12792_12847 = state_12744__$1;
(statearr_12792_12847[(2)] = true);

(statearr_12792_12847[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (38))){
var inst_12734 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
var statearr_12793_12848 = state_12744__$1;
(statearr_12793_12848[(2)] = inst_12734);

(statearr_12793_12848[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (30))){
var inst_12704 = (state_12744[(10)]);
var inst_12697 = (state_12744[(11)]);
var inst_12698 = (state_12744[(13)]);
var inst_12721 = cljs.core.empty_QMARK_.call(null,inst_12697);
var inst_12722 = inst_12698.call(null,inst_12704);
var inst_12723 = cljs.core.not.call(null,inst_12722);
var inst_12724 = (inst_12721) && (inst_12723);
var state_12744__$1 = state_12744;
var statearr_12794_12849 = state_12744__$1;
(statearr_12794_12849[(2)] = inst_12724);

(statearr_12794_12849[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (10))){
var inst_12650 = (state_12744[(8)]);
var inst_12670 = (state_12744[(2)]);
var inst_12671 = cljs.core.get.call(null,inst_12670,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12672 = cljs.core.get.call(null,inst_12670,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12673 = cljs.core.get.call(null,inst_12670,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12674 = inst_12650;
var state_12744__$1 = (function (){var statearr_12795 = state_12744;
(statearr_12795[(16)] = inst_12672);

(statearr_12795[(17)] = inst_12673);

(statearr_12795[(7)] = inst_12674);

(statearr_12795[(18)] = inst_12671);

return statearr_12795;
})();
var statearr_12796_12850 = state_12744__$1;
(statearr_12796_12850[(2)] = null);

(statearr_12796_12850[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (18))){
var inst_12688 = (state_12744[(2)]);
var state_12744__$1 = state_12744;
var statearr_12797_12851 = state_12744__$1;
(statearr_12797_12851[(2)] = inst_12688);

(statearr_12797_12851[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (37))){
var state_12744__$1 = state_12744;
var statearr_12798_12852 = state_12744__$1;
(statearr_12798_12852[(2)] = null);

(statearr_12798_12852[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12745 === (8))){
var inst_12650 = (state_12744[(8)]);
var inst_12667 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12650);
var state_12744__$1 = state_12744;
var statearr_12799_12853 = state_12744__$1;
(statearr_12799_12853[(2)] = inst_12667);

(statearr_12799_12853[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___12807,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10982__auto__,c__11094__auto___12807,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10983__auto__ = null;
var cljs$core$async$mix_$_state_machine__10983__auto____0 = (function (){
var statearr_12803 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12803[(0)] = cljs$core$async$mix_$_state_machine__10983__auto__);

(statearr_12803[(1)] = (1));

return statearr_12803;
});
var cljs$core$async$mix_$_state_machine__10983__auto____1 = (function (state_12744){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_12744);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e12804){if((e12804 instanceof Object)){
var ex__10986__auto__ = e12804;
var statearr_12805_12854 = state_12744;
(statearr_12805_12854[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12744);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12804;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12855 = state_12744;
state_12744 = G__12855;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10983__auto__ = function(state_12744){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10983__auto____1.call(this,state_12744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10983__auto____0;
cljs$core$async$mix_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10983__auto____1;
return cljs$core$async$mix_$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___12807,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11096__auto__ = (function (){var statearr_12806 = f__11095__auto__.call(null);
(statearr_12806[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___12807);

return statearr_12806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___12807,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12856 = [];
var len__5726__auto___12859 = arguments.length;
var i__5727__auto___12860 = (0);
while(true){
if((i__5727__auto___12860 < len__5726__auto___12859)){
args12856.push((arguments[i__5727__auto___12860]));

var G__12861 = (i__5727__auto___12860 + (1));
i__5727__auto___12860 = G__12861;
continue;
} else {
}
break;
}

var G__12858 = args12856.length;
switch (G__12858) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12856.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12864 = [];
var len__5726__auto___12989 = arguments.length;
var i__5727__auto___12990 = (0);
while(true){
if((i__5727__auto___12990 < len__5726__auto___12989)){
args12864.push((arguments[i__5727__auto___12990]));

var G__12991 = (i__5727__auto___12990 + (1));
i__5727__auto___12990 = G__12991;
continue;
} else {
}
break;
}

var G__12866 = args12864.length;
switch (G__12866) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12864.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__12863_SHARP_){
if(cljs.core.truth_(p1__12863_SHARP_.call(null,topic))){
return p1__12863_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12863_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12867 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12867 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12868){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12868 = meta12868;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12869,meta12868__$1){
var self__ = this;
var _12869__$1 = this;
return (new cljs.core.async.t_cljs$core$async12867(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12868__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12869){
var self__ = this;
var _12869__$1 = this;
return self__.meta12868;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12867.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12867.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12868","meta12868",759689623,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12867.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12867.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12867";

cljs.core.async.t_cljs$core$async12867.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12867");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12867 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12867(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12868){
return (new cljs.core.async.t_cljs$core$async12867(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12868));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12867(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11094__auto___12993 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___12993,mults,ensure_mult,p){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___12993,mults,ensure_mult,p){
return (function (state_12941){
var state_val_12942 = (state_12941[(1)]);
if((state_val_12942 === (7))){
var inst_12937 = (state_12941[(2)]);
var state_12941__$1 = state_12941;
var statearr_12943_12994 = state_12941__$1;
(statearr_12943_12994[(2)] = inst_12937);

(statearr_12943_12994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (20))){
var state_12941__$1 = state_12941;
var statearr_12944_12995 = state_12941__$1;
(statearr_12944_12995[(2)] = null);

(statearr_12944_12995[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (1))){
var state_12941__$1 = state_12941;
var statearr_12945_12996 = state_12941__$1;
(statearr_12945_12996[(2)] = null);

(statearr_12945_12996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (24))){
var inst_12920 = (state_12941[(7)]);
var inst_12929 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12920);
var state_12941__$1 = state_12941;
var statearr_12946_12997 = state_12941__$1;
(statearr_12946_12997[(2)] = inst_12929);

(statearr_12946_12997[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (4))){
var inst_12872 = (state_12941[(8)]);
var inst_12872__$1 = (state_12941[(2)]);
var inst_12873 = (inst_12872__$1 == null);
var state_12941__$1 = (function (){var statearr_12947 = state_12941;
(statearr_12947[(8)] = inst_12872__$1);

return statearr_12947;
})();
if(cljs.core.truth_(inst_12873)){
var statearr_12948_12998 = state_12941__$1;
(statearr_12948_12998[(1)] = (5));

} else {
var statearr_12949_12999 = state_12941__$1;
(statearr_12949_12999[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (15))){
var inst_12914 = (state_12941[(2)]);
var state_12941__$1 = state_12941;
var statearr_12950_13000 = state_12941__$1;
(statearr_12950_13000[(2)] = inst_12914);

(statearr_12950_13000[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (21))){
var inst_12934 = (state_12941[(2)]);
var state_12941__$1 = (function (){var statearr_12951 = state_12941;
(statearr_12951[(9)] = inst_12934);

return statearr_12951;
})();
var statearr_12952_13001 = state_12941__$1;
(statearr_12952_13001[(2)] = null);

(statearr_12952_13001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (13))){
var inst_12896 = (state_12941[(10)]);
var inst_12898 = cljs.core.chunked_seq_QMARK_.call(null,inst_12896);
var state_12941__$1 = state_12941;
if(inst_12898){
var statearr_12953_13002 = state_12941__$1;
(statearr_12953_13002[(1)] = (16));

} else {
var statearr_12954_13003 = state_12941__$1;
(statearr_12954_13003[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (22))){
var inst_12926 = (state_12941[(2)]);
var state_12941__$1 = state_12941;
if(cljs.core.truth_(inst_12926)){
var statearr_12955_13004 = state_12941__$1;
(statearr_12955_13004[(1)] = (23));

} else {
var statearr_12956_13005 = state_12941__$1;
(statearr_12956_13005[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (6))){
var inst_12922 = (state_12941[(11)]);
var inst_12872 = (state_12941[(8)]);
var inst_12920 = (state_12941[(7)]);
var inst_12920__$1 = topic_fn.call(null,inst_12872);
var inst_12921 = cljs.core.deref.call(null,mults);
var inst_12922__$1 = cljs.core.get.call(null,inst_12921,inst_12920__$1);
var state_12941__$1 = (function (){var statearr_12957 = state_12941;
(statearr_12957[(11)] = inst_12922__$1);

(statearr_12957[(7)] = inst_12920__$1);

return statearr_12957;
})();
if(cljs.core.truth_(inst_12922__$1)){
var statearr_12958_13006 = state_12941__$1;
(statearr_12958_13006[(1)] = (19));

} else {
var statearr_12959_13007 = state_12941__$1;
(statearr_12959_13007[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (25))){
var inst_12931 = (state_12941[(2)]);
var state_12941__$1 = state_12941;
var statearr_12960_13008 = state_12941__$1;
(statearr_12960_13008[(2)] = inst_12931);

(statearr_12960_13008[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (17))){
var inst_12896 = (state_12941[(10)]);
var inst_12905 = cljs.core.first.call(null,inst_12896);
var inst_12906 = cljs.core.async.muxch_STAR_.call(null,inst_12905);
var inst_12907 = cljs.core.async.close_BANG_.call(null,inst_12906);
var inst_12908 = cljs.core.next.call(null,inst_12896);
var inst_12882 = inst_12908;
var inst_12883 = null;
var inst_12884 = (0);
var inst_12885 = (0);
var state_12941__$1 = (function (){var statearr_12961 = state_12941;
(statearr_12961[(12)] = inst_12882);

(statearr_12961[(13)] = inst_12907);

(statearr_12961[(14)] = inst_12883);

(statearr_12961[(15)] = inst_12884);

(statearr_12961[(16)] = inst_12885);

return statearr_12961;
})();
var statearr_12962_13009 = state_12941__$1;
(statearr_12962_13009[(2)] = null);

(statearr_12962_13009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (3))){
var inst_12939 = (state_12941[(2)]);
var state_12941__$1 = state_12941;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12941__$1,inst_12939);
} else {
if((state_val_12942 === (12))){
var inst_12916 = (state_12941[(2)]);
var state_12941__$1 = state_12941;
var statearr_12963_13010 = state_12941__$1;
(statearr_12963_13010[(2)] = inst_12916);

(statearr_12963_13010[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (2))){
var state_12941__$1 = state_12941;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12941__$1,(4),ch);
} else {
if((state_val_12942 === (23))){
var state_12941__$1 = state_12941;
var statearr_12964_13011 = state_12941__$1;
(statearr_12964_13011[(2)] = null);

(statearr_12964_13011[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (19))){
var inst_12922 = (state_12941[(11)]);
var inst_12872 = (state_12941[(8)]);
var inst_12924 = cljs.core.async.muxch_STAR_.call(null,inst_12922);
var state_12941__$1 = state_12941;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12941__$1,(22),inst_12924,inst_12872);
} else {
if((state_val_12942 === (11))){
var inst_12882 = (state_12941[(12)]);
var inst_12896 = (state_12941[(10)]);
var inst_12896__$1 = cljs.core.seq.call(null,inst_12882);
var state_12941__$1 = (function (){var statearr_12965 = state_12941;
(statearr_12965[(10)] = inst_12896__$1);

return statearr_12965;
})();
if(inst_12896__$1){
var statearr_12966_13012 = state_12941__$1;
(statearr_12966_13012[(1)] = (13));

} else {
var statearr_12967_13013 = state_12941__$1;
(statearr_12967_13013[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (9))){
var inst_12918 = (state_12941[(2)]);
var state_12941__$1 = state_12941;
var statearr_12968_13014 = state_12941__$1;
(statearr_12968_13014[(2)] = inst_12918);

(statearr_12968_13014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (5))){
var inst_12879 = cljs.core.deref.call(null,mults);
var inst_12880 = cljs.core.vals.call(null,inst_12879);
var inst_12881 = cljs.core.seq.call(null,inst_12880);
var inst_12882 = inst_12881;
var inst_12883 = null;
var inst_12884 = (0);
var inst_12885 = (0);
var state_12941__$1 = (function (){var statearr_12969 = state_12941;
(statearr_12969[(12)] = inst_12882);

(statearr_12969[(14)] = inst_12883);

(statearr_12969[(15)] = inst_12884);

(statearr_12969[(16)] = inst_12885);

return statearr_12969;
})();
var statearr_12970_13015 = state_12941__$1;
(statearr_12970_13015[(2)] = null);

(statearr_12970_13015[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (14))){
var state_12941__$1 = state_12941;
var statearr_12974_13016 = state_12941__$1;
(statearr_12974_13016[(2)] = null);

(statearr_12974_13016[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (16))){
var inst_12896 = (state_12941[(10)]);
var inst_12900 = cljs.core.chunk_first.call(null,inst_12896);
var inst_12901 = cljs.core.chunk_rest.call(null,inst_12896);
var inst_12902 = cljs.core.count.call(null,inst_12900);
var inst_12882 = inst_12901;
var inst_12883 = inst_12900;
var inst_12884 = inst_12902;
var inst_12885 = (0);
var state_12941__$1 = (function (){var statearr_12975 = state_12941;
(statearr_12975[(12)] = inst_12882);

(statearr_12975[(14)] = inst_12883);

(statearr_12975[(15)] = inst_12884);

(statearr_12975[(16)] = inst_12885);

return statearr_12975;
})();
var statearr_12976_13017 = state_12941__$1;
(statearr_12976_13017[(2)] = null);

(statearr_12976_13017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (10))){
var inst_12882 = (state_12941[(12)]);
var inst_12883 = (state_12941[(14)]);
var inst_12884 = (state_12941[(15)]);
var inst_12885 = (state_12941[(16)]);
var inst_12890 = cljs.core._nth.call(null,inst_12883,inst_12885);
var inst_12891 = cljs.core.async.muxch_STAR_.call(null,inst_12890);
var inst_12892 = cljs.core.async.close_BANG_.call(null,inst_12891);
var inst_12893 = (inst_12885 + (1));
var tmp12971 = inst_12882;
var tmp12972 = inst_12883;
var tmp12973 = inst_12884;
var inst_12882__$1 = tmp12971;
var inst_12883__$1 = tmp12972;
var inst_12884__$1 = tmp12973;
var inst_12885__$1 = inst_12893;
var state_12941__$1 = (function (){var statearr_12977 = state_12941;
(statearr_12977[(17)] = inst_12892);

(statearr_12977[(12)] = inst_12882__$1);

(statearr_12977[(14)] = inst_12883__$1);

(statearr_12977[(15)] = inst_12884__$1);

(statearr_12977[(16)] = inst_12885__$1);

return statearr_12977;
})();
var statearr_12978_13018 = state_12941__$1;
(statearr_12978_13018[(2)] = null);

(statearr_12978_13018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (18))){
var inst_12911 = (state_12941[(2)]);
var state_12941__$1 = state_12941;
var statearr_12979_13019 = state_12941__$1;
(statearr_12979_13019[(2)] = inst_12911);

(statearr_12979_13019[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12942 === (8))){
var inst_12884 = (state_12941[(15)]);
var inst_12885 = (state_12941[(16)]);
var inst_12887 = (inst_12885 < inst_12884);
var inst_12888 = inst_12887;
var state_12941__$1 = state_12941;
if(cljs.core.truth_(inst_12888)){
var statearr_12980_13020 = state_12941__$1;
(statearr_12980_13020[(1)] = (10));

} else {
var statearr_12981_13021 = state_12941__$1;
(statearr_12981_13021[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___12993,mults,ensure_mult,p))
;
return ((function (switch__10982__auto__,c__11094__auto___12993,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_12985 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12985[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_12985[(1)] = (1));

return statearr_12985;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_12941){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_12941);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e12986){if((e12986 instanceof Object)){
var ex__10986__auto__ = e12986;
var statearr_12987_13022 = state_12941;
(statearr_12987_13022[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12941);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13023 = state_12941;
state_12941 = G__13023;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_12941){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_12941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___12993,mults,ensure_mult,p))
})();
var state__11096__auto__ = (function (){var statearr_12988 = f__11095__auto__.call(null);
(statearr_12988[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___12993);

return statearr_12988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___12993,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args13024 = [];
var len__5726__auto___13027 = arguments.length;
var i__5727__auto___13028 = (0);
while(true){
if((i__5727__auto___13028 < len__5726__auto___13027)){
args13024.push((arguments[i__5727__auto___13028]));

var G__13029 = (i__5727__auto___13028 + (1));
i__5727__auto___13028 = G__13029;
continue;
} else {
}
break;
}

var G__13026 = args13024.length;
switch (G__13026) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13024.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args13031 = [];
var len__5726__auto___13034 = arguments.length;
var i__5727__auto___13035 = (0);
while(true){
if((i__5727__auto___13035 < len__5726__auto___13034)){
args13031.push((arguments[i__5727__auto___13035]));

var G__13036 = (i__5727__auto___13035 + (1));
i__5727__auto___13035 = G__13036;
continue;
} else {
}
break;
}

var G__13033 = args13031.length;
switch (G__13033) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13031.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13038 = [];
var len__5726__auto___13109 = arguments.length;
var i__5727__auto___13110 = (0);
while(true){
if((i__5727__auto___13110 < len__5726__auto___13109)){
args13038.push((arguments[i__5727__auto___13110]));

var G__13111 = (i__5727__auto___13110 + (1));
i__5727__auto___13110 = G__13111;
continue;
} else {
}
break;
}

var G__13040 = args13038.length;
switch (G__13040) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13038.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11094__auto___13113 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___13113,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___13113,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13079){
var state_val_13080 = (state_13079[(1)]);
if((state_val_13080 === (7))){
var state_13079__$1 = state_13079;
var statearr_13081_13114 = state_13079__$1;
(statearr_13081_13114[(2)] = null);

(statearr_13081_13114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (1))){
var state_13079__$1 = state_13079;
var statearr_13082_13115 = state_13079__$1;
(statearr_13082_13115[(2)] = null);

(statearr_13082_13115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (4))){
var inst_13043 = (state_13079[(7)]);
var inst_13045 = (inst_13043 < cnt);
var state_13079__$1 = state_13079;
if(cljs.core.truth_(inst_13045)){
var statearr_13083_13116 = state_13079__$1;
(statearr_13083_13116[(1)] = (6));

} else {
var statearr_13084_13117 = state_13079__$1;
(statearr_13084_13117[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (15))){
var inst_13075 = (state_13079[(2)]);
var state_13079__$1 = state_13079;
var statearr_13085_13118 = state_13079__$1;
(statearr_13085_13118[(2)] = inst_13075);

(statearr_13085_13118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (13))){
var inst_13068 = cljs.core.async.close_BANG_.call(null,out);
var state_13079__$1 = state_13079;
var statearr_13086_13119 = state_13079__$1;
(statearr_13086_13119[(2)] = inst_13068);

(statearr_13086_13119[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (6))){
var state_13079__$1 = state_13079;
var statearr_13087_13120 = state_13079__$1;
(statearr_13087_13120[(2)] = null);

(statearr_13087_13120[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (3))){
var inst_13077 = (state_13079[(2)]);
var state_13079__$1 = state_13079;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13079__$1,inst_13077);
} else {
if((state_val_13080 === (12))){
var inst_13065 = (state_13079[(8)]);
var inst_13065__$1 = (state_13079[(2)]);
var inst_13066 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13065__$1);
var state_13079__$1 = (function (){var statearr_13088 = state_13079;
(statearr_13088[(8)] = inst_13065__$1);

return statearr_13088;
})();
if(cljs.core.truth_(inst_13066)){
var statearr_13089_13121 = state_13079__$1;
(statearr_13089_13121[(1)] = (13));

} else {
var statearr_13090_13122 = state_13079__$1;
(statearr_13090_13122[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (2))){
var inst_13042 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13043 = (0);
var state_13079__$1 = (function (){var statearr_13091 = state_13079;
(statearr_13091[(9)] = inst_13042);

(statearr_13091[(7)] = inst_13043);

return statearr_13091;
})();
var statearr_13092_13123 = state_13079__$1;
(statearr_13092_13123[(2)] = null);

(statearr_13092_13123[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (11))){
var inst_13043 = (state_13079[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13079,(10),Object,null,(9));
var inst_13052 = chs__$1.call(null,inst_13043);
var inst_13053 = done.call(null,inst_13043);
var inst_13054 = cljs.core.async.take_BANG_.call(null,inst_13052,inst_13053);
var state_13079__$1 = state_13079;
var statearr_13093_13124 = state_13079__$1;
(statearr_13093_13124[(2)] = inst_13054);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13079__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (9))){
var inst_13043 = (state_13079[(7)]);
var inst_13056 = (state_13079[(2)]);
var inst_13057 = (inst_13043 + (1));
var inst_13043__$1 = inst_13057;
var state_13079__$1 = (function (){var statearr_13094 = state_13079;
(statearr_13094[(7)] = inst_13043__$1);

(statearr_13094[(10)] = inst_13056);

return statearr_13094;
})();
var statearr_13095_13125 = state_13079__$1;
(statearr_13095_13125[(2)] = null);

(statearr_13095_13125[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (5))){
var inst_13063 = (state_13079[(2)]);
var state_13079__$1 = (function (){var statearr_13096 = state_13079;
(statearr_13096[(11)] = inst_13063);

return statearr_13096;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13079__$1,(12),dchan);
} else {
if((state_val_13080 === (14))){
var inst_13065 = (state_13079[(8)]);
var inst_13070 = cljs.core.apply.call(null,f,inst_13065);
var state_13079__$1 = state_13079;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13079__$1,(16),out,inst_13070);
} else {
if((state_val_13080 === (16))){
var inst_13072 = (state_13079[(2)]);
var state_13079__$1 = (function (){var statearr_13097 = state_13079;
(statearr_13097[(12)] = inst_13072);

return statearr_13097;
})();
var statearr_13098_13126 = state_13079__$1;
(statearr_13098_13126[(2)] = null);

(statearr_13098_13126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (10))){
var inst_13047 = (state_13079[(2)]);
var inst_13048 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13079__$1 = (function (){var statearr_13099 = state_13079;
(statearr_13099[(13)] = inst_13047);

return statearr_13099;
})();
var statearr_13100_13127 = state_13079__$1;
(statearr_13100_13127[(2)] = inst_13048);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13079__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (8))){
var inst_13061 = (state_13079[(2)]);
var state_13079__$1 = state_13079;
var statearr_13101_13128 = state_13079__$1;
(statearr_13101_13128[(2)] = inst_13061);

(statearr_13101_13128[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___13113,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10982__auto__,c__11094__auto___13113,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_13105 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13105[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_13105[(1)] = (1));

return statearr_13105;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_13079){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_13079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e13106){if((e13106 instanceof Object)){
var ex__10986__auto__ = e13106;
var statearr_13107_13129 = state_13079;
(statearr_13107_13129[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13079);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13106;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13130 = state_13079;
state_13079 = G__13130;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_13079){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_13079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___13113,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11096__auto__ = (function (){var statearr_13108 = f__11095__auto__.call(null);
(statearr_13108[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___13113);

return statearr_13108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___13113,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13132 = [];
var len__5726__auto___13188 = arguments.length;
var i__5727__auto___13189 = (0);
while(true){
if((i__5727__auto___13189 < len__5726__auto___13188)){
args13132.push((arguments[i__5727__auto___13189]));

var G__13190 = (i__5727__auto___13189 + (1));
i__5727__auto___13189 = G__13190;
continue;
} else {
}
break;
}

var G__13134 = args13132.length;
switch (G__13134) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13132.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___13192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___13192,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___13192,out){
return (function (state_13164){
var state_val_13165 = (state_13164[(1)]);
if((state_val_13165 === (7))){
var inst_13144 = (state_13164[(7)]);
var inst_13143 = (state_13164[(8)]);
var inst_13143__$1 = (state_13164[(2)]);
var inst_13144__$1 = cljs.core.nth.call(null,inst_13143__$1,(0),null);
var inst_13145 = cljs.core.nth.call(null,inst_13143__$1,(1),null);
var inst_13146 = (inst_13144__$1 == null);
var state_13164__$1 = (function (){var statearr_13166 = state_13164;
(statearr_13166[(9)] = inst_13145);

(statearr_13166[(7)] = inst_13144__$1);

(statearr_13166[(8)] = inst_13143__$1);

return statearr_13166;
})();
if(cljs.core.truth_(inst_13146)){
var statearr_13167_13193 = state_13164__$1;
(statearr_13167_13193[(1)] = (8));

} else {
var statearr_13168_13194 = state_13164__$1;
(statearr_13168_13194[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13165 === (1))){
var inst_13135 = cljs.core.vec.call(null,chs);
var inst_13136 = inst_13135;
var state_13164__$1 = (function (){var statearr_13169 = state_13164;
(statearr_13169[(10)] = inst_13136);

return statearr_13169;
})();
var statearr_13170_13195 = state_13164__$1;
(statearr_13170_13195[(2)] = null);

(statearr_13170_13195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13165 === (4))){
var inst_13136 = (state_13164[(10)]);
var state_13164__$1 = state_13164;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13164__$1,(7),inst_13136);
} else {
if((state_val_13165 === (6))){
var inst_13160 = (state_13164[(2)]);
var state_13164__$1 = state_13164;
var statearr_13171_13196 = state_13164__$1;
(statearr_13171_13196[(2)] = inst_13160);

(statearr_13171_13196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13165 === (3))){
var inst_13162 = (state_13164[(2)]);
var state_13164__$1 = state_13164;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13164__$1,inst_13162);
} else {
if((state_val_13165 === (2))){
var inst_13136 = (state_13164[(10)]);
var inst_13138 = cljs.core.count.call(null,inst_13136);
var inst_13139 = (inst_13138 > (0));
var state_13164__$1 = state_13164;
if(cljs.core.truth_(inst_13139)){
var statearr_13173_13197 = state_13164__$1;
(statearr_13173_13197[(1)] = (4));

} else {
var statearr_13174_13198 = state_13164__$1;
(statearr_13174_13198[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13165 === (11))){
var inst_13136 = (state_13164[(10)]);
var inst_13153 = (state_13164[(2)]);
var tmp13172 = inst_13136;
var inst_13136__$1 = tmp13172;
var state_13164__$1 = (function (){var statearr_13175 = state_13164;
(statearr_13175[(10)] = inst_13136__$1);

(statearr_13175[(11)] = inst_13153);

return statearr_13175;
})();
var statearr_13176_13199 = state_13164__$1;
(statearr_13176_13199[(2)] = null);

(statearr_13176_13199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13165 === (9))){
var inst_13144 = (state_13164[(7)]);
var state_13164__$1 = state_13164;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13164__$1,(11),out,inst_13144);
} else {
if((state_val_13165 === (5))){
var inst_13158 = cljs.core.async.close_BANG_.call(null,out);
var state_13164__$1 = state_13164;
var statearr_13177_13200 = state_13164__$1;
(statearr_13177_13200[(2)] = inst_13158);

(statearr_13177_13200[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13165 === (10))){
var inst_13156 = (state_13164[(2)]);
var state_13164__$1 = state_13164;
var statearr_13178_13201 = state_13164__$1;
(statearr_13178_13201[(2)] = inst_13156);

(statearr_13178_13201[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13165 === (8))){
var inst_13136 = (state_13164[(10)]);
var inst_13145 = (state_13164[(9)]);
var inst_13144 = (state_13164[(7)]);
var inst_13143 = (state_13164[(8)]);
var inst_13148 = (function (){var cs = inst_13136;
var vec__13141 = inst_13143;
var v = inst_13144;
var c = inst_13145;
return ((function (cs,vec__13141,v,c,inst_13136,inst_13145,inst_13144,inst_13143,state_val_13165,c__11094__auto___13192,out){
return (function (p1__13131_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13131_SHARP_);
});
;})(cs,vec__13141,v,c,inst_13136,inst_13145,inst_13144,inst_13143,state_val_13165,c__11094__auto___13192,out))
})();
var inst_13149 = cljs.core.filterv.call(null,inst_13148,inst_13136);
var inst_13136__$1 = inst_13149;
var state_13164__$1 = (function (){var statearr_13179 = state_13164;
(statearr_13179[(10)] = inst_13136__$1);

return statearr_13179;
})();
var statearr_13180_13202 = state_13164__$1;
(statearr_13180_13202[(2)] = null);

(statearr_13180_13202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___13192,out))
;
return ((function (switch__10982__auto__,c__11094__auto___13192,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_13184 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13184[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_13184[(1)] = (1));

return statearr_13184;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_13164){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_13164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e13185){if((e13185 instanceof Object)){
var ex__10986__auto__ = e13185;
var statearr_13186_13203 = state_13164;
(statearr_13186_13203[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13164);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13185;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13204 = state_13164;
state_13164 = G__13204;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_13164){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_13164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___13192,out))
})();
var state__11096__auto__ = (function (){var statearr_13187 = f__11095__auto__.call(null);
(statearr_13187[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___13192);

return statearr_13187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___13192,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13205 = [];
var len__5726__auto___13254 = arguments.length;
var i__5727__auto___13255 = (0);
while(true){
if((i__5727__auto___13255 < len__5726__auto___13254)){
args13205.push((arguments[i__5727__auto___13255]));

var G__13256 = (i__5727__auto___13255 + (1));
i__5727__auto___13255 = G__13256;
continue;
} else {
}
break;
}

var G__13207 = args13205.length;
switch (G__13207) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13205.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___13258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___13258,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___13258,out){
return (function (state_13231){
var state_val_13232 = (state_13231[(1)]);
if((state_val_13232 === (7))){
var inst_13213 = (state_13231[(7)]);
var inst_13213__$1 = (state_13231[(2)]);
var inst_13214 = (inst_13213__$1 == null);
var inst_13215 = cljs.core.not.call(null,inst_13214);
var state_13231__$1 = (function (){var statearr_13233 = state_13231;
(statearr_13233[(7)] = inst_13213__$1);

return statearr_13233;
})();
if(inst_13215){
var statearr_13234_13259 = state_13231__$1;
(statearr_13234_13259[(1)] = (8));

} else {
var statearr_13235_13260 = state_13231__$1;
(statearr_13235_13260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13232 === (1))){
var inst_13208 = (0);
var state_13231__$1 = (function (){var statearr_13236 = state_13231;
(statearr_13236[(8)] = inst_13208);

return statearr_13236;
})();
var statearr_13237_13261 = state_13231__$1;
(statearr_13237_13261[(2)] = null);

(statearr_13237_13261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13232 === (4))){
var state_13231__$1 = state_13231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13231__$1,(7),ch);
} else {
if((state_val_13232 === (6))){
var inst_13226 = (state_13231[(2)]);
var state_13231__$1 = state_13231;
var statearr_13238_13262 = state_13231__$1;
(statearr_13238_13262[(2)] = inst_13226);

(statearr_13238_13262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13232 === (3))){
var inst_13228 = (state_13231[(2)]);
var inst_13229 = cljs.core.async.close_BANG_.call(null,out);
var state_13231__$1 = (function (){var statearr_13239 = state_13231;
(statearr_13239[(9)] = inst_13228);

return statearr_13239;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13231__$1,inst_13229);
} else {
if((state_val_13232 === (2))){
var inst_13208 = (state_13231[(8)]);
var inst_13210 = (inst_13208 < n);
var state_13231__$1 = state_13231;
if(cljs.core.truth_(inst_13210)){
var statearr_13240_13263 = state_13231__$1;
(statearr_13240_13263[(1)] = (4));

} else {
var statearr_13241_13264 = state_13231__$1;
(statearr_13241_13264[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13232 === (11))){
var inst_13208 = (state_13231[(8)]);
var inst_13218 = (state_13231[(2)]);
var inst_13219 = (inst_13208 + (1));
var inst_13208__$1 = inst_13219;
var state_13231__$1 = (function (){var statearr_13242 = state_13231;
(statearr_13242[(8)] = inst_13208__$1);

(statearr_13242[(10)] = inst_13218);

return statearr_13242;
})();
var statearr_13243_13265 = state_13231__$1;
(statearr_13243_13265[(2)] = null);

(statearr_13243_13265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13232 === (9))){
var state_13231__$1 = state_13231;
var statearr_13244_13266 = state_13231__$1;
(statearr_13244_13266[(2)] = null);

(statearr_13244_13266[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13232 === (5))){
var state_13231__$1 = state_13231;
var statearr_13245_13267 = state_13231__$1;
(statearr_13245_13267[(2)] = null);

(statearr_13245_13267[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13232 === (10))){
var inst_13223 = (state_13231[(2)]);
var state_13231__$1 = state_13231;
var statearr_13246_13268 = state_13231__$1;
(statearr_13246_13268[(2)] = inst_13223);

(statearr_13246_13268[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13232 === (8))){
var inst_13213 = (state_13231[(7)]);
var state_13231__$1 = state_13231;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13231__$1,(11),out,inst_13213);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___13258,out))
;
return ((function (switch__10982__auto__,c__11094__auto___13258,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_13250 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13250[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_13250[(1)] = (1));

return statearr_13250;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_13231){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_13231);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e13251){if((e13251 instanceof Object)){
var ex__10986__auto__ = e13251;
var statearr_13252_13269 = state_13231;
(statearr_13252_13269[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13231);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13251;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13270 = state_13231;
state_13231 = G__13270;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_13231){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_13231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___13258,out))
})();
var state__11096__auto__ = (function (){var statearr_13253 = f__11095__auto__.call(null);
(statearr_13253[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___13258);

return statearr_13253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___13258,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13278 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13278 = (function (map_LT_,f,ch,meta13279){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13279 = meta13279;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13280,meta13279__$1){
var self__ = this;
var _13280__$1 = this;
return (new cljs.core.async.t_cljs$core$async13278(self__.map_LT_,self__.f,self__.ch,meta13279__$1));
});

cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13280){
var self__ = this;
var _13280__$1 = this;
return self__.meta13279;
});

cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async13281 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13281 = (function (map_LT_,f,ch,meta13279,_,fn1,meta13282){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13279 = meta13279;
this._ = _;
this.fn1 = fn1;
this.meta13282 = meta13282;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13281.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13283,meta13282__$1){
var self__ = this;
var _13283__$1 = this;
return (new cljs.core.async.t_cljs$core$async13281(self__.map_LT_,self__.f,self__.ch,self__.meta13279,self__._,self__.fn1,meta13282__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async13281.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13283){
var self__ = this;
var _13283__$1 = this;
return self__.meta13282;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13281.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13281.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13281.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13281.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__13271_SHARP_){
return f1.call(null,(((p1__13271_SHARP_ == null))?null:self__.f.call(null,p1__13271_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async13281.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13279","meta13279",1468282606,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13278","cljs.core.async/t_cljs$core$async13278",-2081550698,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13282","meta13282",-2085851488,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13281.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13281.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13281";

cljs.core.async.t_cljs$core$async13281.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13281");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async13281 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13281(map_LT___$1,f__$1,ch__$1,meta13279__$1,___$2,fn1__$1,meta13282){
return (new cljs.core.async.t_cljs$core$async13281(map_LT___$1,f__$1,ch__$1,meta13279__$1,___$2,fn1__$1,meta13282));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async13281(self__.map_LT_,self__.f,self__.ch,self__.meta13279,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13278.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async13278.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13279","meta13279",1468282606,null)], null);
});

cljs.core.async.t_cljs$core$async13278.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13278.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13278";

cljs.core.async.t_cljs$core$async13278.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13278");
});

cljs.core.async.__GT_t_cljs$core$async13278 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13278(map_LT___$1,f__$1,ch__$1,meta13279){
return (new cljs.core.async.t_cljs$core$async13278(map_LT___$1,f__$1,ch__$1,meta13279));
});

}

return (new cljs.core.async.t_cljs$core$async13278(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13287 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13287 = (function (map_GT_,f,ch,meta13288){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta13288 = meta13288;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13287.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13289,meta13288__$1){
var self__ = this;
var _13289__$1 = this;
return (new cljs.core.async.t_cljs$core$async13287(self__.map_GT_,self__.f,self__.ch,meta13288__$1));
});

cljs.core.async.t_cljs$core$async13287.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13289){
var self__ = this;
var _13289__$1 = this;
return self__.meta13288;
});

cljs.core.async.t_cljs$core$async13287.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13287.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13287.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13287.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13287.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13287.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async13287.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13288","meta13288",434406706,null)], null);
});

cljs.core.async.t_cljs$core$async13287.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13287.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13287";

cljs.core.async.t_cljs$core$async13287.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13287");
});

cljs.core.async.__GT_t_cljs$core$async13287 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13287(map_GT___$1,f__$1,ch__$1,meta13288){
return (new cljs.core.async.t_cljs$core$async13287(map_GT___$1,f__$1,ch__$1,meta13288));
});

}

return (new cljs.core.async.t_cljs$core$async13287(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async13293 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13293 = (function (filter_GT_,p,ch,meta13294){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13294 = meta13294;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13295,meta13294__$1){
var self__ = this;
var _13295__$1 = this;
return (new cljs.core.async.t_cljs$core$async13293(self__.filter_GT_,self__.p,self__.ch,meta13294__$1));
});

cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13295){
var self__ = this;
var _13295__$1 = this;
return self__.meta13294;
});

cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13293.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async13293.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13294","meta13294",615102301,null)], null);
});

cljs.core.async.t_cljs$core$async13293.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13293.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13293";

cljs.core.async.t_cljs$core$async13293.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13293");
});

cljs.core.async.__GT_t_cljs$core$async13293 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13293(filter_GT___$1,p__$1,ch__$1,meta13294){
return (new cljs.core.async.t_cljs$core$async13293(filter_GT___$1,p__$1,ch__$1,meta13294));
});

}

return (new cljs.core.async.t_cljs$core$async13293(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args13296 = [];
var len__5726__auto___13340 = arguments.length;
var i__5727__auto___13341 = (0);
while(true){
if((i__5727__auto___13341 < len__5726__auto___13340)){
args13296.push((arguments[i__5727__auto___13341]));

var G__13342 = (i__5727__auto___13341 + (1));
i__5727__auto___13341 = G__13342;
continue;
} else {
}
break;
}

var G__13298 = args13296.length;
switch (G__13298) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13296.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___13344 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___13344,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___13344,out){
return (function (state_13319){
var state_val_13320 = (state_13319[(1)]);
if((state_val_13320 === (7))){
var inst_13315 = (state_13319[(2)]);
var state_13319__$1 = state_13319;
var statearr_13321_13345 = state_13319__$1;
(statearr_13321_13345[(2)] = inst_13315);

(statearr_13321_13345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13320 === (1))){
var state_13319__$1 = state_13319;
var statearr_13322_13346 = state_13319__$1;
(statearr_13322_13346[(2)] = null);

(statearr_13322_13346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13320 === (4))){
var inst_13301 = (state_13319[(7)]);
var inst_13301__$1 = (state_13319[(2)]);
var inst_13302 = (inst_13301__$1 == null);
var state_13319__$1 = (function (){var statearr_13323 = state_13319;
(statearr_13323[(7)] = inst_13301__$1);

return statearr_13323;
})();
if(cljs.core.truth_(inst_13302)){
var statearr_13324_13347 = state_13319__$1;
(statearr_13324_13347[(1)] = (5));

} else {
var statearr_13325_13348 = state_13319__$1;
(statearr_13325_13348[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13320 === (6))){
var inst_13301 = (state_13319[(7)]);
var inst_13306 = p.call(null,inst_13301);
var state_13319__$1 = state_13319;
if(cljs.core.truth_(inst_13306)){
var statearr_13326_13349 = state_13319__$1;
(statearr_13326_13349[(1)] = (8));

} else {
var statearr_13327_13350 = state_13319__$1;
(statearr_13327_13350[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13320 === (3))){
var inst_13317 = (state_13319[(2)]);
var state_13319__$1 = state_13319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13319__$1,inst_13317);
} else {
if((state_val_13320 === (2))){
var state_13319__$1 = state_13319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13319__$1,(4),ch);
} else {
if((state_val_13320 === (11))){
var inst_13309 = (state_13319[(2)]);
var state_13319__$1 = state_13319;
var statearr_13328_13351 = state_13319__$1;
(statearr_13328_13351[(2)] = inst_13309);

(statearr_13328_13351[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13320 === (9))){
var state_13319__$1 = state_13319;
var statearr_13329_13352 = state_13319__$1;
(statearr_13329_13352[(2)] = null);

(statearr_13329_13352[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13320 === (5))){
var inst_13304 = cljs.core.async.close_BANG_.call(null,out);
var state_13319__$1 = state_13319;
var statearr_13330_13353 = state_13319__$1;
(statearr_13330_13353[(2)] = inst_13304);

(statearr_13330_13353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13320 === (10))){
var inst_13312 = (state_13319[(2)]);
var state_13319__$1 = (function (){var statearr_13331 = state_13319;
(statearr_13331[(8)] = inst_13312);

return statearr_13331;
})();
var statearr_13332_13354 = state_13319__$1;
(statearr_13332_13354[(2)] = null);

(statearr_13332_13354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13320 === (8))){
var inst_13301 = (state_13319[(7)]);
var state_13319__$1 = state_13319;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13319__$1,(11),out,inst_13301);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___13344,out))
;
return ((function (switch__10982__auto__,c__11094__auto___13344,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_13336 = [null,null,null,null,null,null,null,null,null];
(statearr_13336[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_13336[(1)] = (1));

return statearr_13336;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_13319){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_13319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e13337){if((e13337 instanceof Object)){
var ex__10986__auto__ = e13337;
var statearr_13338_13355 = state_13319;
(statearr_13338_13355[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13337;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13356 = state_13319;
state_13319 = G__13356;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_13319){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_13319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___13344,out))
})();
var state__11096__auto__ = (function (){var statearr_13339 = f__11095__auto__.call(null);
(statearr_13339[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___13344);

return statearr_13339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___13344,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args13357 = [];
var len__5726__auto___13360 = arguments.length;
var i__5727__auto___13361 = (0);
while(true){
if((i__5727__auto___13361 < len__5726__auto___13360)){
args13357.push((arguments[i__5727__auto___13361]));

var G__13362 = (i__5727__auto___13361 + (1));
i__5727__auto___13361 = G__13362;
continue;
} else {
}
break;
}

var G__13359 = args13357.length;
switch (G__13359) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13357.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11094__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto__){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto__){
return (function (state_13529){
var state_val_13530 = (state_13529[(1)]);
if((state_val_13530 === (7))){
var inst_13525 = (state_13529[(2)]);
var state_13529__$1 = state_13529;
var statearr_13531_13572 = state_13529__$1;
(statearr_13531_13572[(2)] = inst_13525);

(statearr_13531_13572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (20))){
var inst_13495 = (state_13529[(7)]);
var inst_13506 = (state_13529[(2)]);
var inst_13507 = cljs.core.next.call(null,inst_13495);
var inst_13481 = inst_13507;
var inst_13482 = null;
var inst_13483 = (0);
var inst_13484 = (0);
var state_13529__$1 = (function (){var statearr_13532 = state_13529;
(statearr_13532[(8)] = inst_13484);

(statearr_13532[(9)] = inst_13506);

(statearr_13532[(10)] = inst_13483);

(statearr_13532[(11)] = inst_13482);

(statearr_13532[(12)] = inst_13481);

return statearr_13532;
})();
var statearr_13533_13573 = state_13529__$1;
(statearr_13533_13573[(2)] = null);

(statearr_13533_13573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (1))){
var state_13529__$1 = state_13529;
var statearr_13534_13574 = state_13529__$1;
(statearr_13534_13574[(2)] = null);

(statearr_13534_13574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (4))){
var inst_13470 = (state_13529[(13)]);
var inst_13470__$1 = (state_13529[(2)]);
var inst_13471 = (inst_13470__$1 == null);
var state_13529__$1 = (function (){var statearr_13535 = state_13529;
(statearr_13535[(13)] = inst_13470__$1);

return statearr_13535;
})();
if(cljs.core.truth_(inst_13471)){
var statearr_13536_13575 = state_13529__$1;
(statearr_13536_13575[(1)] = (5));

} else {
var statearr_13537_13576 = state_13529__$1;
(statearr_13537_13576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (15))){
var state_13529__$1 = state_13529;
var statearr_13541_13577 = state_13529__$1;
(statearr_13541_13577[(2)] = null);

(statearr_13541_13577[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (21))){
var state_13529__$1 = state_13529;
var statearr_13542_13578 = state_13529__$1;
(statearr_13542_13578[(2)] = null);

(statearr_13542_13578[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (13))){
var inst_13484 = (state_13529[(8)]);
var inst_13483 = (state_13529[(10)]);
var inst_13482 = (state_13529[(11)]);
var inst_13481 = (state_13529[(12)]);
var inst_13491 = (state_13529[(2)]);
var inst_13492 = (inst_13484 + (1));
var tmp13538 = inst_13483;
var tmp13539 = inst_13482;
var tmp13540 = inst_13481;
var inst_13481__$1 = tmp13540;
var inst_13482__$1 = tmp13539;
var inst_13483__$1 = tmp13538;
var inst_13484__$1 = inst_13492;
var state_13529__$1 = (function (){var statearr_13543 = state_13529;
(statearr_13543[(8)] = inst_13484__$1);

(statearr_13543[(10)] = inst_13483__$1);

(statearr_13543[(11)] = inst_13482__$1);

(statearr_13543[(12)] = inst_13481__$1);

(statearr_13543[(14)] = inst_13491);

return statearr_13543;
})();
var statearr_13544_13579 = state_13529__$1;
(statearr_13544_13579[(2)] = null);

(statearr_13544_13579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (22))){
var state_13529__$1 = state_13529;
var statearr_13545_13580 = state_13529__$1;
(statearr_13545_13580[(2)] = null);

(statearr_13545_13580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (6))){
var inst_13470 = (state_13529[(13)]);
var inst_13479 = f.call(null,inst_13470);
var inst_13480 = cljs.core.seq.call(null,inst_13479);
var inst_13481 = inst_13480;
var inst_13482 = null;
var inst_13483 = (0);
var inst_13484 = (0);
var state_13529__$1 = (function (){var statearr_13546 = state_13529;
(statearr_13546[(8)] = inst_13484);

(statearr_13546[(10)] = inst_13483);

(statearr_13546[(11)] = inst_13482);

(statearr_13546[(12)] = inst_13481);

return statearr_13546;
})();
var statearr_13547_13581 = state_13529__$1;
(statearr_13547_13581[(2)] = null);

(statearr_13547_13581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (17))){
var inst_13495 = (state_13529[(7)]);
var inst_13499 = cljs.core.chunk_first.call(null,inst_13495);
var inst_13500 = cljs.core.chunk_rest.call(null,inst_13495);
var inst_13501 = cljs.core.count.call(null,inst_13499);
var inst_13481 = inst_13500;
var inst_13482 = inst_13499;
var inst_13483 = inst_13501;
var inst_13484 = (0);
var state_13529__$1 = (function (){var statearr_13548 = state_13529;
(statearr_13548[(8)] = inst_13484);

(statearr_13548[(10)] = inst_13483);

(statearr_13548[(11)] = inst_13482);

(statearr_13548[(12)] = inst_13481);

return statearr_13548;
})();
var statearr_13549_13582 = state_13529__$1;
(statearr_13549_13582[(2)] = null);

(statearr_13549_13582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (3))){
var inst_13527 = (state_13529[(2)]);
var state_13529__$1 = state_13529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13529__$1,inst_13527);
} else {
if((state_val_13530 === (12))){
var inst_13515 = (state_13529[(2)]);
var state_13529__$1 = state_13529;
var statearr_13550_13583 = state_13529__$1;
(statearr_13550_13583[(2)] = inst_13515);

(statearr_13550_13583[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (2))){
var state_13529__$1 = state_13529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13529__$1,(4),in$);
} else {
if((state_val_13530 === (23))){
var inst_13523 = (state_13529[(2)]);
var state_13529__$1 = state_13529;
var statearr_13551_13584 = state_13529__$1;
(statearr_13551_13584[(2)] = inst_13523);

(statearr_13551_13584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (19))){
var inst_13510 = (state_13529[(2)]);
var state_13529__$1 = state_13529;
var statearr_13552_13585 = state_13529__$1;
(statearr_13552_13585[(2)] = inst_13510);

(statearr_13552_13585[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (11))){
var inst_13495 = (state_13529[(7)]);
var inst_13481 = (state_13529[(12)]);
var inst_13495__$1 = cljs.core.seq.call(null,inst_13481);
var state_13529__$1 = (function (){var statearr_13553 = state_13529;
(statearr_13553[(7)] = inst_13495__$1);

return statearr_13553;
})();
if(inst_13495__$1){
var statearr_13554_13586 = state_13529__$1;
(statearr_13554_13586[(1)] = (14));

} else {
var statearr_13555_13587 = state_13529__$1;
(statearr_13555_13587[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (9))){
var inst_13517 = (state_13529[(2)]);
var inst_13518 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13529__$1 = (function (){var statearr_13556 = state_13529;
(statearr_13556[(15)] = inst_13517);

return statearr_13556;
})();
if(cljs.core.truth_(inst_13518)){
var statearr_13557_13588 = state_13529__$1;
(statearr_13557_13588[(1)] = (21));

} else {
var statearr_13558_13589 = state_13529__$1;
(statearr_13558_13589[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (5))){
var inst_13473 = cljs.core.async.close_BANG_.call(null,out);
var state_13529__$1 = state_13529;
var statearr_13559_13590 = state_13529__$1;
(statearr_13559_13590[(2)] = inst_13473);

(statearr_13559_13590[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (14))){
var inst_13495 = (state_13529[(7)]);
var inst_13497 = cljs.core.chunked_seq_QMARK_.call(null,inst_13495);
var state_13529__$1 = state_13529;
if(inst_13497){
var statearr_13560_13591 = state_13529__$1;
(statearr_13560_13591[(1)] = (17));

} else {
var statearr_13561_13592 = state_13529__$1;
(statearr_13561_13592[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (16))){
var inst_13513 = (state_13529[(2)]);
var state_13529__$1 = state_13529;
var statearr_13562_13593 = state_13529__$1;
(statearr_13562_13593[(2)] = inst_13513);

(statearr_13562_13593[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13530 === (10))){
var inst_13484 = (state_13529[(8)]);
var inst_13482 = (state_13529[(11)]);
var inst_13489 = cljs.core._nth.call(null,inst_13482,inst_13484);
var state_13529__$1 = state_13529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13529__$1,(13),out,inst_13489);
} else {
if((state_val_13530 === (18))){
var inst_13495 = (state_13529[(7)]);
var inst_13504 = cljs.core.first.call(null,inst_13495);
var state_13529__$1 = state_13529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13529__$1,(20),out,inst_13504);
} else {
if((state_val_13530 === (8))){
var inst_13484 = (state_13529[(8)]);
var inst_13483 = (state_13529[(10)]);
var inst_13486 = (inst_13484 < inst_13483);
var inst_13487 = inst_13486;
var state_13529__$1 = state_13529;
if(cljs.core.truth_(inst_13487)){
var statearr_13563_13594 = state_13529__$1;
(statearr_13563_13594[(1)] = (10));

} else {
var statearr_13564_13595 = state_13529__$1;
(statearr_13564_13595[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto__))
;
return ((function (switch__10982__auto__,c__11094__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_13568 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13568[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__);

(statearr_13568[(1)] = (1));

return statearr_13568;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____1 = (function (state_13529){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_13529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e13569){if((e13569 instanceof Object)){
var ex__10986__auto__ = e13569;
var statearr_13570_13596 = state_13529;
(statearr_13570_13596[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13529);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13597 = state_13529;
state_13529 = G__13597;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__ = function(state_13529){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____1.call(this,state_13529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto__))
})();
var state__11096__auto__ = (function (){var statearr_13571 = f__11095__auto__.call(null);
(statearr_13571[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto__);

return statearr_13571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto__))
);

return c__11094__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13598 = [];
var len__5726__auto___13601 = arguments.length;
var i__5727__auto___13602 = (0);
while(true){
if((i__5727__auto___13602 < len__5726__auto___13601)){
args13598.push((arguments[i__5727__auto___13602]));

var G__13603 = (i__5727__auto___13602 + (1));
i__5727__auto___13602 = G__13603;
continue;
} else {
}
break;
}

var G__13600 = args13598.length;
switch (G__13600) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13598.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13605 = [];
var len__5726__auto___13608 = arguments.length;
var i__5727__auto___13609 = (0);
while(true){
if((i__5727__auto___13609 < len__5726__auto___13608)){
args13605.push((arguments[i__5727__auto___13609]));

var G__13610 = (i__5727__auto___13609 + (1));
i__5727__auto___13609 = G__13610;
continue;
} else {
}
break;
}

var G__13607 = args13605.length;
switch (G__13607) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13605.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13612 = [];
var len__5726__auto___13663 = arguments.length;
var i__5727__auto___13664 = (0);
while(true){
if((i__5727__auto___13664 < len__5726__auto___13663)){
args13612.push((arguments[i__5727__auto___13664]));

var G__13665 = (i__5727__auto___13664 + (1));
i__5727__auto___13664 = G__13665;
continue;
} else {
}
break;
}

var G__13614 = args13612.length;
switch (G__13614) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13612.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___13667 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___13667,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___13667,out){
return (function (state_13638){
var state_val_13639 = (state_13638[(1)]);
if((state_val_13639 === (7))){
var inst_13633 = (state_13638[(2)]);
var state_13638__$1 = state_13638;
var statearr_13640_13668 = state_13638__$1;
(statearr_13640_13668[(2)] = inst_13633);

(statearr_13640_13668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13639 === (1))){
var inst_13615 = null;
var state_13638__$1 = (function (){var statearr_13641 = state_13638;
(statearr_13641[(7)] = inst_13615);

return statearr_13641;
})();
var statearr_13642_13669 = state_13638__$1;
(statearr_13642_13669[(2)] = null);

(statearr_13642_13669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13639 === (4))){
var inst_13618 = (state_13638[(8)]);
var inst_13618__$1 = (state_13638[(2)]);
var inst_13619 = (inst_13618__$1 == null);
var inst_13620 = cljs.core.not.call(null,inst_13619);
var state_13638__$1 = (function (){var statearr_13643 = state_13638;
(statearr_13643[(8)] = inst_13618__$1);

return statearr_13643;
})();
if(inst_13620){
var statearr_13644_13670 = state_13638__$1;
(statearr_13644_13670[(1)] = (5));

} else {
var statearr_13645_13671 = state_13638__$1;
(statearr_13645_13671[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13639 === (6))){
var state_13638__$1 = state_13638;
var statearr_13646_13672 = state_13638__$1;
(statearr_13646_13672[(2)] = null);

(statearr_13646_13672[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13639 === (3))){
var inst_13635 = (state_13638[(2)]);
var inst_13636 = cljs.core.async.close_BANG_.call(null,out);
var state_13638__$1 = (function (){var statearr_13647 = state_13638;
(statearr_13647[(9)] = inst_13635);

return statearr_13647;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13638__$1,inst_13636);
} else {
if((state_val_13639 === (2))){
var state_13638__$1 = state_13638;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13638__$1,(4),ch);
} else {
if((state_val_13639 === (11))){
var inst_13618 = (state_13638[(8)]);
var inst_13627 = (state_13638[(2)]);
var inst_13615 = inst_13618;
var state_13638__$1 = (function (){var statearr_13648 = state_13638;
(statearr_13648[(7)] = inst_13615);

(statearr_13648[(10)] = inst_13627);

return statearr_13648;
})();
var statearr_13649_13673 = state_13638__$1;
(statearr_13649_13673[(2)] = null);

(statearr_13649_13673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13639 === (9))){
var inst_13618 = (state_13638[(8)]);
var state_13638__$1 = state_13638;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13638__$1,(11),out,inst_13618);
} else {
if((state_val_13639 === (5))){
var inst_13615 = (state_13638[(7)]);
var inst_13618 = (state_13638[(8)]);
var inst_13622 = cljs.core._EQ_.call(null,inst_13618,inst_13615);
var state_13638__$1 = state_13638;
if(inst_13622){
var statearr_13651_13674 = state_13638__$1;
(statearr_13651_13674[(1)] = (8));

} else {
var statearr_13652_13675 = state_13638__$1;
(statearr_13652_13675[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13639 === (10))){
var inst_13630 = (state_13638[(2)]);
var state_13638__$1 = state_13638;
var statearr_13653_13676 = state_13638__$1;
(statearr_13653_13676[(2)] = inst_13630);

(statearr_13653_13676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13639 === (8))){
var inst_13615 = (state_13638[(7)]);
var tmp13650 = inst_13615;
var inst_13615__$1 = tmp13650;
var state_13638__$1 = (function (){var statearr_13654 = state_13638;
(statearr_13654[(7)] = inst_13615__$1);

return statearr_13654;
})();
var statearr_13655_13677 = state_13638__$1;
(statearr_13655_13677[(2)] = null);

(statearr_13655_13677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___13667,out))
;
return ((function (switch__10982__auto__,c__11094__auto___13667,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_13659 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13659[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_13659[(1)] = (1));

return statearr_13659;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_13638){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_13638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e13660){if((e13660 instanceof Object)){
var ex__10986__auto__ = e13660;
var statearr_13661_13678 = state_13638;
(statearr_13661_13678[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13638);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13660;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13679 = state_13638;
state_13638 = G__13679;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_13638){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_13638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___13667,out))
})();
var state__11096__auto__ = (function (){var statearr_13662 = f__11095__auto__.call(null);
(statearr_13662[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___13667);

return statearr_13662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___13667,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13680 = [];
var len__5726__auto___13750 = arguments.length;
var i__5727__auto___13751 = (0);
while(true){
if((i__5727__auto___13751 < len__5726__auto___13750)){
args13680.push((arguments[i__5727__auto___13751]));

var G__13752 = (i__5727__auto___13751 + (1));
i__5727__auto___13751 = G__13752;
continue;
} else {
}
break;
}

var G__13682 = args13680.length;
switch (G__13682) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13680.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___13754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___13754,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___13754,out){
return (function (state_13720){
var state_val_13721 = (state_13720[(1)]);
if((state_val_13721 === (7))){
var inst_13716 = (state_13720[(2)]);
var state_13720__$1 = state_13720;
var statearr_13722_13755 = state_13720__$1;
(statearr_13722_13755[(2)] = inst_13716);

(statearr_13722_13755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (1))){
var inst_13683 = (new Array(n));
var inst_13684 = inst_13683;
var inst_13685 = (0);
var state_13720__$1 = (function (){var statearr_13723 = state_13720;
(statearr_13723[(7)] = inst_13684);

(statearr_13723[(8)] = inst_13685);

return statearr_13723;
})();
var statearr_13724_13756 = state_13720__$1;
(statearr_13724_13756[(2)] = null);

(statearr_13724_13756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (4))){
var inst_13688 = (state_13720[(9)]);
var inst_13688__$1 = (state_13720[(2)]);
var inst_13689 = (inst_13688__$1 == null);
var inst_13690 = cljs.core.not.call(null,inst_13689);
var state_13720__$1 = (function (){var statearr_13725 = state_13720;
(statearr_13725[(9)] = inst_13688__$1);

return statearr_13725;
})();
if(inst_13690){
var statearr_13726_13757 = state_13720__$1;
(statearr_13726_13757[(1)] = (5));

} else {
var statearr_13727_13758 = state_13720__$1;
(statearr_13727_13758[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (15))){
var inst_13710 = (state_13720[(2)]);
var state_13720__$1 = state_13720;
var statearr_13728_13759 = state_13720__$1;
(statearr_13728_13759[(2)] = inst_13710);

(statearr_13728_13759[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (13))){
var state_13720__$1 = state_13720;
var statearr_13729_13760 = state_13720__$1;
(statearr_13729_13760[(2)] = null);

(statearr_13729_13760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (6))){
var inst_13685 = (state_13720[(8)]);
var inst_13706 = (inst_13685 > (0));
var state_13720__$1 = state_13720;
if(cljs.core.truth_(inst_13706)){
var statearr_13730_13761 = state_13720__$1;
(statearr_13730_13761[(1)] = (12));

} else {
var statearr_13731_13762 = state_13720__$1;
(statearr_13731_13762[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (3))){
var inst_13718 = (state_13720[(2)]);
var state_13720__$1 = state_13720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13720__$1,inst_13718);
} else {
if((state_val_13721 === (12))){
var inst_13684 = (state_13720[(7)]);
var inst_13708 = cljs.core.vec.call(null,inst_13684);
var state_13720__$1 = state_13720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13720__$1,(15),out,inst_13708);
} else {
if((state_val_13721 === (2))){
var state_13720__$1 = state_13720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13720__$1,(4),ch);
} else {
if((state_val_13721 === (11))){
var inst_13700 = (state_13720[(2)]);
var inst_13701 = (new Array(n));
var inst_13684 = inst_13701;
var inst_13685 = (0);
var state_13720__$1 = (function (){var statearr_13732 = state_13720;
(statearr_13732[(7)] = inst_13684);

(statearr_13732[(10)] = inst_13700);

(statearr_13732[(8)] = inst_13685);

return statearr_13732;
})();
var statearr_13733_13763 = state_13720__$1;
(statearr_13733_13763[(2)] = null);

(statearr_13733_13763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (9))){
var inst_13684 = (state_13720[(7)]);
var inst_13698 = cljs.core.vec.call(null,inst_13684);
var state_13720__$1 = state_13720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13720__$1,(11),out,inst_13698);
} else {
if((state_val_13721 === (5))){
var inst_13688 = (state_13720[(9)]);
var inst_13684 = (state_13720[(7)]);
var inst_13693 = (state_13720[(11)]);
var inst_13685 = (state_13720[(8)]);
var inst_13692 = (inst_13684[inst_13685] = inst_13688);
var inst_13693__$1 = (inst_13685 + (1));
var inst_13694 = (inst_13693__$1 < n);
var state_13720__$1 = (function (){var statearr_13734 = state_13720;
(statearr_13734[(11)] = inst_13693__$1);

(statearr_13734[(12)] = inst_13692);

return statearr_13734;
})();
if(cljs.core.truth_(inst_13694)){
var statearr_13735_13764 = state_13720__$1;
(statearr_13735_13764[(1)] = (8));

} else {
var statearr_13736_13765 = state_13720__$1;
(statearr_13736_13765[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (14))){
var inst_13713 = (state_13720[(2)]);
var inst_13714 = cljs.core.async.close_BANG_.call(null,out);
var state_13720__$1 = (function (){var statearr_13738 = state_13720;
(statearr_13738[(13)] = inst_13713);

return statearr_13738;
})();
var statearr_13739_13766 = state_13720__$1;
(statearr_13739_13766[(2)] = inst_13714);

(statearr_13739_13766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (10))){
var inst_13704 = (state_13720[(2)]);
var state_13720__$1 = state_13720;
var statearr_13740_13767 = state_13720__$1;
(statearr_13740_13767[(2)] = inst_13704);

(statearr_13740_13767[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13721 === (8))){
var inst_13684 = (state_13720[(7)]);
var inst_13693 = (state_13720[(11)]);
var tmp13737 = inst_13684;
var inst_13684__$1 = tmp13737;
var inst_13685 = inst_13693;
var state_13720__$1 = (function (){var statearr_13741 = state_13720;
(statearr_13741[(7)] = inst_13684__$1);

(statearr_13741[(8)] = inst_13685);

return statearr_13741;
})();
var statearr_13742_13768 = state_13720__$1;
(statearr_13742_13768[(2)] = null);

(statearr_13742_13768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___13754,out))
;
return ((function (switch__10982__auto__,c__11094__auto___13754,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_13746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13746[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_13746[(1)] = (1));

return statearr_13746;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_13720){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_13720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e13747){if((e13747 instanceof Object)){
var ex__10986__auto__ = e13747;
var statearr_13748_13769 = state_13720;
(statearr_13748_13769[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13720);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13770 = state_13720;
state_13720 = G__13770;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_13720){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_13720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___13754,out))
})();
var state__11096__auto__ = (function (){var statearr_13749 = f__11095__auto__.call(null);
(statearr_13749[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___13754);

return statearr_13749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___13754,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13771 = [];
var len__5726__auto___13845 = arguments.length;
var i__5727__auto___13846 = (0);
while(true){
if((i__5727__auto___13846 < len__5726__auto___13845)){
args13771.push((arguments[i__5727__auto___13846]));

var G__13847 = (i__5727__auto___13846 + (1));
i__5727__auto___13846 = G__13847;
continue;
} else {
}
break;
}

var G__13773 = args13771.length;
switch (G__13773) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13771.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___13849 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___13849,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___13849,out){
return (function (state_13815){
var state_val_13816 = (state_13815[(1)]);
if((state_val_13816 === (7))){
var inst_13811 = (state_13815[(2)]);
var state_13815__$1 = state_13815;
var statearr_13817_13850 = state_13815__$1;
(statearr_13817_13850[(2)] = inst_13811);

(statearr_13817_13850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (1))){
var inst_13774 = [];
var inst_13775 = inst_13774;
var inst_13776 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13815__$1 = (function (){var statearr_13818 = state_13815;
(statearr_13818[(7)] = inst_13776);

(statearr_13818[(8)] = inst_13775);

return statearr_13818;
})();
var statearr_13819_13851 = state_13815__$1;
(statearr_13819_13851[(2)] = null);

(statearr_13819_13851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (4))){
var inst_13779 = (state_13815[(9)]);
var inst_13779__$1 = (state_13815[(2)]);
var inst_13780 = (inst_13779__$1 == null);
var inst_13781 = cljs.core.not.call(null,inst_13780);
var state_13815__$1 = (function (){var statearr_13820 = state_13815;
(statearr_13820[(9)] = inst_13779__$1);

return statearr_13820;
})();
if(inst_13781){
var statearr_13821_13852 = state_13815__$1;
(statearr_13821_13852[(1)] = (5));

} else {
var statearr_13822_13853 = state_13815__$1;
(statearr_13822_13853[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (15))){
var inst_13805 = (state_13815[(2)]);
var state_13815__$1 = state_13815;
var statearr_13823_13854 = state_13815__$1;
(statearr_13823_13854[(2)] = inst_13805);

(statearr_13823_13854[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (13))){
var state_13815__$1 = state_13815;
var statearr_13824_13855 = state_13815__$1;
(statearr_13824_13855[(2)] = null);

(statearr_13824_13855[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (6))){
var inst_13775 = (state_13815[(8)]);
var inst_13800 = inst_13775.length;
var inst_13801 = (inst_13800 > (0));
var state_13815__$1 = state_13815;
if(cljs.core.truth_(inst_13801)){
var statearr_13825_13856 = state_13815__$1;
(statearr_13825_13856[(1)] = (12));

} else {
var statearr_13826_13857 = state_13815__$1;
(statearr_13826_13857[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (3))){
var inst_13813 = (state_13815[(2)]);
var state_13815__$1 = state_13815;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13815__$1,inst_13813);
} else {
if((state_val_13816 === (12))){
var inst_13775 = (state_13815[(8)]);
var inst_13803 = cljs.core.vec.call(null,inst_13775);
var state_13815__$1 = state_13815;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13815__$1,(15),out,inst_13803);
} else {
if((state_val_13816 === (2))){
var state_13815__$1 = state_13815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13815__$1,(4),ch);
} else {
if((state_val_13816 === (11))){
var inst_13779 = (state_13815[(9)]);
var inst_13783 = (state_13815[(10)]);
var inst_13793 = (state_13815[(2)]);
var inst_13794 = [];
var inst_13795 = inst_13794.push(inst_13779);
var inst_13775 = inst_13794;
var inst_13776 = inst_13783;
var state_13815__$1 = (function (){var statearr_13827 = state_13815;
(statearr_13827[(7)] = inst_13776);

(statearr_13827[(11)] = inst_13795);

(statearr_13827[(12)] = inst_13793);

(statearr_13827[(8)] = inst_13775);

return statearr_13827;
})();
var statearr_13828_13858 = state_13815__$1;
(statearr_13828_13858[(2)] = null);

(statearr_13828_13858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (9))){
var inst_13775 = (state_13815[(8)]);
var inst_13791 = cljs.core.vec.call(null,inst_13775);
var state_13815__$1 = state_13815;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13815__$1,(11),out,inst_13791);
} else {
if((state_val_13816 === (5))){
var inst_13776 = (state_13815[(7)]);
var inst_13779 = (state_13815[(9)]);
var inst_13783 = (state_13815[(10)]);
var inst_13783__$1 = f.call(null,inst_13779);
var inst_13784 = cljs.core._EQ_.call(null,inst_13783__$1,inst_13776);
var inst_13785 = cljs.core.keyword_identical_QMARK_.call(null,inst_13776,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13786 = (inst_13784) || (inst_13785);
var state_13815__$1 = (function (){var statearr_13829 = state_13815;
(statearr_13829[(10)] = inst_13783__$1);

return statearr_13829;
})();
if(cljs.core.truth_(inst_13786)){
var statearr_13830_13859 = state_13815__$1;
(statearr_13830_13859[(1)] = (8));

} else {
var statearr_13831_13860 = state_13815__$1;
(statearr_13831_13860[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (14))){
var inst_13808 = (state_13815[(2)]);
var inst_13809 = cljs.core.async.close_BANG_.call(null,out);
var state_13815__$1 = (function (){var statearr_13833 = state_13815;
(statearr_13833[(13)] = inst_13808);

return statearr_13833;
})();
var statearr_13834_13861 = state_13815__$1;
(statearr_13834_13861[(2)] = inst_13809);

(statearr_13834_13861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (10))){
var inst_13798 = (state_13815[(2)]);
var state_13815__$1 = state_13815;
var statearr_13835_13862 = state_13815__$1;
(statearr_13835_13862[(2)] = inst_13798);

(statearr_13835_13862[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13816 === (8))){
var inst_13775 = (state_13815[(8)]);
var inst_13779 = (state_13815[(9)]);
var inst_13783 = (state_13815[(10)]);
var inst_13788 = inst_13775.push(inst_13779);
var tmp13832 = inst_13775;
var inst_13775__$1 = tmp13832;
var inst_13776 = inst_13783;
var state_13815__$1 = (function (){var statearr_13836 = state_13815;
(statearr_13836[(7)] = inst_13776);

(statearr_13836[(8)] = inst_13775__$1);

(statearr_13836[(14)] = inst_13788);

return statearr_13836;
})();
var statearr_13837_13863 = state_13815__$1;
(statearr_13837_13863[(2)] = null);

(statearr_13837_13863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___13849,out))
;
return ((function (switch__10982__auto__,c__11094__auto___13849,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_13841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13841[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_13841[(1)] = (1));

return statearr_13841;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_13815){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_13815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e13842){if((e13842 instanceof Object)){
var ex__10986__auto__ = e13842;
var statearr_13843_13864 = state_13815;
(statearr_13843_13864[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13815);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13842;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13865 = state_13815;
state_13815 = G__13865;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_13815){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_13815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___13849,out))
})();
var state__11096__auto__ = (function (){var statearr_13844 = f__11095__auto__.call(null);
(statearr_13844[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___13849);

return statearr_13844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___13849,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1460120393276