// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__16242__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__16241 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__16241,(0),null);
var body = cljs.core.nthnext.call(null,vec__16241,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__16242 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16243__i = 0, G__16243__a = new Array(arguments.length -  0);
while (G__16243__i < G__16243__a.length) {G__16243__a[G__16243__i] = arguments[G__16243__i + 0]; ++G__16243__i;}
  args = new cljs.core.IndexedSeq(G__16243__a,0);
} 
return G__16242__delegate.call(this,args);};
G__16242.cljs$lang$maxFixedArity = 0;
G__16242.cljs$lang$applyTo = (function (arglist__16244){
var args = cljs.core.seq(arglist__16244);
return G__16242__delegate(args);
});
G__16242.cljs$core$IFn$_invoke$arity$variadic = G__16242__delegate;
return G__16242;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__16249(s__16250){
return (new cljs.core.LazySeq(null,(function (){
var s__16250__$1 = s__16250;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16250__$1);
if(temp__4425__auto__){
var s__16250__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16250__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16250__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16252 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16251 = (0);
while(true){
if((i__16251 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__16251);
cljs.core.chunk_append.call(null,b__16252,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__16253 = (i__16251 + (1));
i__16251 = G__16253;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16252),sablono$core$update_arglists_$_iter__16249.call(null,cljs.core.chunk_rest.call(null,s__16250__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16252),null);
}
} else {
var args = cljs.core.first.call(null,s__16250__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__16249.call(null,cljs.core.rest.call(null,s__16250__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16259 = arguments.length;
var i__5727__auto___16260 = (0);
while(true){
if((i__5727__auto___16260 < len__5726__auto___16259)){
args__5733__auto__.push((arguments[i__5727__auto___16260]));

var G__16261 = (i__5727__auto___16260 + (1));
i__5727__auto___16260 = G__16261;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__16255(s__16256){
return (new cljs.core.LazySeq(null,(function (){
var s__16256__$1 = s__16256;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16256__$1);
if(temp__4425__auto__){
var s__16256__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16256__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16256__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16258 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16257 = (0);
while(true){
if((i__16257 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__16257);
cljs.core.chunk_append.call(null,b__16258,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__16262 = (i__16257 + (1));
i__16257 = G__16262;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16258),sablono$core$iter__16255.call(null,cljs.core.chunk_rest.call(null,s__16256__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16258),null);
}
} else {
var style = cljs.core.first.call(null,s__16256__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__16255.call(null,cljs.core.rest.call(null,s__16256__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq16254){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16254));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to16263 = (function sablono$core$link_to16263(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16266 = arguments.length;
var i__5727__auto___16267 = (0);
while(true){
if((i__5727__auto___16267 < len__5726__auto___16266)){
args__5733__auto__.push((arguments[i__5727__auto___16267]));

var G__16268 = (i__5727__auto___16267 + (1));
i__5727__auto___16267 = G__16268;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to16263.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to16263.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to16263.cljs$lang$maxFixedArity = (1);

sablono.core.link_to16263.cljs$lang$applyTo = (function (seq16264){
var G__16265 = cljs.core.first.call(null,seq16264);
var seq16264__$1 = cljs.core.next.call(null,seq16264);
return sablono.core.link_to16263.cljs$core$IFn$_invoke$arity$variadic(G__16265,seq16264__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to16263);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to16269 = (function sablono$core$mail_to16269(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16274 = arguments.length;
var i__5727__auto___16275 = (0);
while(true){
if((i__5727__auto___16275 < len__5726__auto___16274)){
args__5733__auto__.push((arguments[i__5727__auto___16275]));

var G__16276 = (i__5727__auto___16275 + (1));
i__5727__auto___16275 = G__16276;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to16269.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to16269.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__16272){
var vec__16273 = p__16272;
var content = cljs.core.nth.call(null,vec__16273,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to16269.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to16269.cljs$lang$applyTo = (function (seq16270){
var G__16271 = cljs.core.first.call(null,seq16270);
var seq16270__$1 = cljs.core.next.call(null,seq16270);
return sablono.core.mail_to16269.cljs$core$IFn$_invoke$arity$variadic(G__16271,seq16270__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to16269);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list16277 = (function sablono$core$unordered_list16277(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list16277_$_iter__16282(s__16283){
return (new cljs.core.LazySeq(null,(function (){
var s__16283__$1 = s__16283;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16283__$1);
if(temp__4425__auto__){
var s__16283__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16283__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16283__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16285 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16284 = (0);
while(true){
if((i__16284 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16284);
cljs.core.chunk_append.call(null,b__16285,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16286 = (i__16284 + (1));
i__16284 = G__16286;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16285),sablono$core$unordered_list16277_$_iter__16282.call(null,cljs.core.chunk_rest.call(null,s__16283__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16285),null);
}
} else {
var x = cljs.core.first.call(null,s__16283__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list16277_$_iter__16282.call(null,cljs.core.rest.call(null,s__16283__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list16277);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list16287 = (function sablono$core$ordered_list16287(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list16287_$_iter__16292(s__16293){
return (new cljs.core.LazySeq(null,(function (){
var s__16293__$1 = s__16293;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16293__$1);
if(temp__4425__auto__){
var s__16293__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16293__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16293__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16295 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16294 = (0);
while(true){
if((i__16294 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16294);
cljs.core.chunk_append.call(null,b__16295,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16296 = (i__16294 + (1));
i__16294 = G__16296;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16295),sablono$core$ordered_list16287_$_iter__16292.call(null,cljs.core.chunk_rest.call(null,s__16293__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16295),null);
}
} else {
var x = cljs.core.first.call(null,s__16293__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list16287_$_iter__16292.call(null,cljs.core.rest.call(null,s__16293__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list16287);
/**
 * Create an image element.
 */
sablono.core.image16297 = (function sablono$core$image16297(var_args){
var args16298 = [];
var len__5726__auto___16301 = arguments.length;
var i__5727__auto___16302 = (0);
while(true){
if((i__5727__auto___16302 < len__5726__auto___16301)){
args16298.push((arguments[i__5727__auto___16302]));

var G__16303 = (i__5727__auto___16302 + (1));
i__5727__auto___16302 = G__16303;
continue;
} else {
}
break;
}

var G__16300 = args16298.length;
switch (G__16300) {
case 1:
return sablono.core.image16297.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image16297.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16298.length)].join('')));

}
});

sablono.core.image16297.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image16297.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image16297.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image16297);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__16305_SHARP_,p2__16306_SHARP_){
return [cljs.core.str(p1__16305_SHARP_),cljs.core.str("["),cljs.core.str(p2__16306_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__16307_SHARP_,p2__16308_SHARP_){
return [cljs.core.str(p1__16307_SHARP_),cljs.core.str("-"),cljs.core.str(p2__16308_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field16309 = (function sablono$core$color_field16309(var_args){
var args16310 = [];
var len__5726__auto___16377 = arguments.length;
var i__5727__auto___16378 = (0);
while(true){
if((i__5727__auto___16378 < len__5726__auto___16377)){
args16310.push((arguments[i__5727__auto___16378]));

var G__16379 = (i__5727__auto___16378 + (1));
i__5727__auto___16378 = G__16379;
continue;
} else {
}
break;
}

var G__16312 = args16310.length;
switch (G__16312) {
case 1:
return sablono.core.color_field16309.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field16309.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16310.length)].join('')));

}
});

sablono.core.color_field16309.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.color_field16309.call(null,name__6340__auto__,null);
});

sablono.core.color_field16309.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.color_field16309.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field16309);

/**
 * Creates a date input field.
 */
sablono.core.date_field16313 = (function sablono$core$date_field16313(var_args){
var args16314 = [];
var len__5726__auto___16381 = arguments.length;
var i__5727__auto___16382 = (0);
while(true){
if((i__5727__auto___16382 < len__5726__auto___16381)){
args16314.push((arguments[i__5727__auto___16382]));

var G__16383 = (i__5727__auto___16382 + (1));
i__5727__auto___16382 = G__16383;
continue;
} else {
}
break;
}

var G__16316 = args16314.length;
switch (G__16316) {
case 1:
return sablono.core.date_field16313.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field16313.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16314.length)].join('')));

}
});

sablono.core.date_field16313.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.date_field16313.call(null,name__6340__auto__,null);
});

sablono.core.date_field16313.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.date_field16313.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field16313);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field16317 = (function sablono$core$datetime_field16317(var_args){
var args16318 = [];
var len__5726__auto___16385 = arguments.length;
var i__5727__auto___16386 = (0);
while(true){
if((i__5727__auto___16386 < len__5726__auto___16385)){
args16318.push((arguments[i__5727__auto___16386]));

var G__16387 = (i__5727__auto___16386 + (1));
i__5727__auto___16386 = G__16387;
continue;
} else {
}
break;
}

var G__16320 = args16318.length;
switch (G__16320) {
case 1:
return sablono.core.datetime_field16317.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field16317.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16318.length)].join('')));

}
});

sablono.core.datetime_field16317.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_field16317.call(null,name__6340__auto__,null);
});

sablono.core.datetime_field16317.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_field16317.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field16317);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field16321 = (function sablono$core$datetime_local_field16321(var_args){
var args16322 = [];
var len__5726__auto___16389 = arguments.length;
var i__5727__auto___16390 = (0);
while(true){
if((i__5727__auto___16390 < len__5726__auto___16389)){
args16322.push((arguments[i__5727__auto___16390]));

var G__16391 = (i__5727__auto___16390 + (1));
i__5727__auto___16390 = G__16391;
continue;
} else {
}
break;
}

var G__16324 = args16322.length;
switch (G__16324) {
case 1:
return sablono.core.datetime_local_field16321.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field16321.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16322.length)].join('')));

}
});

sablono.core.datetime_local_field16321.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_local_field16321.call(null,name__6340__auto__,null);
});

sablono.core.datetime_local_field16321.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_local_field16321.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field16321);

/**
 * Creates a email input field.
 */
sablono.core.email_field16325 = (function sablono$core$email_field16325(var_args){
var args16326 = [];
var len__5726__auto___16393 = arguments.length;
var i__5727__auto___16394 = (0);
while(true){
if((i__5727__auto___16394 < len__5726__auto___16393)){
args16326.push((arguments[i__5727__auto___16394]));

var G__16395 = (i__5727__auto___16394 + (1));
i__5727__auto___16394 = G__16395;
continue;
} else {
}
break;
}

var G__16328 = args16326.length;
switch (G__16328) {
case 1:
return sablono.core.email_field16325.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field16325.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16326.length)].join('')));

}
});

sablono.core.email_field16325.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.email_field16325.call(null,name__6340__auto__,null);
});

sablono.core.email_field16325.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.email_field16325.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field16325);

/**
 * Creates a file input field.
 */
sablono.core.file_field16329 = (function sablono$core$file_field16329(var_args){
var args16330 = [];
var len__5726__auto___16397 = arguments.length;
var i__5727__auto___16398 = (0);
while(true){
if((i__5727__auto___16398 < len__5726__auto___16397)){
args16330.push((arguments[i__5727__auto___16398]));

var G__16399 = (i__5727__auto___16398 + (1));
i__5727__auto___16398 = G__16399;
continue;
} else {
}
break;
}

var G__16332 = args16330.length;
switch (G__16332) {
case 1:
return sablono.core.file_field16329.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field16329.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16330.length)].join('')));

}
});

sablono.core.file_field16329.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.file_field16329.call(null,name__6340__auto__,null);
});

sablono.core.file_field16329.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.file_field16329.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field16329);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field16333 = (function sablono$core$hidden_field16333(var_args){
var args16334 = [];
var len__5726__auto___16401 = arguments.length;
var i__5727__auto___16402 = (0);
while(true){
if((i__5727__auto___16402 < len__5726__auto___16401)){
args16334.push((arguments[i__5727__auto___16402]));

var G__16403 = (i__5727__auto___16402 + (1));
i__5727__auto___16402 = G__16403;
continue;
} else {
}
break;
}

var G__16336 = args16334.length;
switch (G__16336) {
case 1:
return sablono.core.hidden_field16333.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field16333.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16334.length)].join('')));

}
});

sablono.core.hidden_field16333.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.hidden_field16333.call(null,name__6340__auto__,null);
});

sablono.core.hidden_field16333.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.hidden_field16333.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field16333);

/**
 * Creates a month input field.
 */
sablono.core.month_field16337 = (function sablono$core$month_field16337(var_args){
var args16338 = [];
var len__5726__auto___16405 = arguments.length;
var i__5727__auto___16406 = (0);
while(true){
if((i__5727__auto___16406 < len__5726__auto___16405)){
args16338.push((arguments[i__5727__auto___16406]));

var G__16407 = (i__5727__auto___16406 + (1));
i__5727__auto___16406 = G__16407;
continue;
} else {
}
break;
}

var G__16340 = args16338.length;
switch (G__16340) {
case 1:
return sablono.core.month_field16337.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field16337.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16338.length)].join('')));

}
});

sablono.core.month_field16337.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.month_field16337.call(null,name__6340__auto__,null);
});

sablono.core.month_field16337.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.month_field16337.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field16337);

/**
 * Creates a number input field.
 */
sablono.core.number_field16341 = (function sablono$core$number_field16341(var_args){
var args16342 = [];
var len__5726__auto___16409 = arguments.length;
var i__5727__auto___16410 = (0);
while(true){
if((i__5727__auto___16410 < len__5726__auto___16409)){
args16342.push((arguments[i__5727__auto___16410]));

var G__16411 = (i__5727__auto___16410 + (1));
i__5727__auto___16410 = G__16411;
continue;
} else {
}
break;
}

var G__16344 = args16342.length;
switch (G__16344) {
case 1:
return sablono.core.number_field16341.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field16341.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16342.length)].join('')));

}
});

sablono.core.number_field16341.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.number_field16341.call(null,name__6340__auto__,null);
});

sablono.core.number_field16341.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.number_field16341.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field16341);

/**
 * Creates a password input field.
 */
sablono.core.password_field16345 = (function sablono$core$password_field16345(var_args){
var args16346 = [];
var len__5726__auto___16413 = arguments.length;
var i__5727__auto___16414 = (0);
while(true){
if((i__5727__auto___16414 < len__5726__auto___16413)){
args16346.push((arguments[i__5727__auto___16414]));

var G__16415 = (i__5727__auto___16414 + (1));
i__5727__auto___16414 = G__16415;
continue;
} else {
}
break;
}

var G__16348 = args16346.length;
switch (G__16348) {
case 1:
return sablono.core.password_field16345.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field16345.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16346.length)].join('')));

}
});

sablono.core.password_field16345.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.password_field16345.call(null,name__6340__auto__,null);
});

sablono.core.password_field16345.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.password_field16345.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field16345);

/**
 * Creates a range input field.
 */
sablono.core.range_field16349 = (function sablono$core$range_field16349(var_args){
var args16350 = [];
var len__5726__auto___16417 = arguments.length;
var i__5727__auto___16418 = (0);
while(true){
if((i__5727__auto___16418 < len__5726__auto___16417)){
args16350.push((arguments[i__5727__auto___16418]));

var G__16419 = (i__5727__auto___16418 + (1));
i__5727__auto___16418 = G__16419;
continue;
} else {
}
break;
}

var G__16352 = args16350.length;
switch (G__16352) {
case 1:
return sablono.core.range_field16349.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field16349.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16350.length)].join('')));

}
});

sablono.core.range_field16349.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.range_field16349.call(null,name__6340__auto__,null);
});

sablono.core.range_field16349.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.range_field16349.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field16349);

/**
 * Creates a search input field.
 */
sablono.core.search_field16353 = (function sablono$core$search_field16353(var_args){
var args16354 = [];
var len__5726__auto___16421 = arguments.length;
var i__5727__auto___16422 = (0);
while(true){
if((i__5727__auto___16422 < len__5726__auto___16421)){
args16354.push((arguments[i__5727__auto___16422]));

var G__16423 = (i__5727__auto___16422 + (1));
i__5727__auto___16422 = G__16423;
continue;
} else {
}
break;
}

var G__16356 = args16354.length;
switch (G__16356) {
case 1:
return sablono.core.search_field16353.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field16353.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16354.length)].join('')));

}
});

sablono.core.search_field16353.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.search_field16353.call(null,name__6340__auto__,null);
});

sablono.core.search_field16353.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.search_field16353.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field16353);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field16357 = (function sablono$core$tel_field16357(var_args){
var args16358 = [];
var len__5726__auto___16425 = arguments.length;
var i__5727__auto___16426 = (0);
while(true){
if((i__5727__auto___16426 < len__5726__auto___16425)){
args16358.push((arguments[i__5727__auto___16426]));

var G__16427 = (i__5727__auto___16426 + (1));
i__5727__auto___16426 = G__16427;
continue;
} else {
}
break;
}

var G__16360 = args16358.length;
switch (G__16360) {
case 1:
return sablono.core.tel_field16357.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field16357.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16358.length)].join('')));

}
});

sablono.core.tel_field16357.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.tel_field16357.call(null,name__6340__auto__,null);
});

sablono.core.tel_field16357.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.tel_field16357.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field16357);

/**
 * Creates a text input field.
 */
sablono.core.text_field16361 = (function sablono$core$text_field16361(var_args){
var args16362 = [];
var len__5726__auto___16429 = arguments.length;
var i__5727__auto___16430 = (0);
while(true){
if((i__5727__auto___16430 < len__5726__auto___16429)){
args16362.push((arguments[i__5727__auto___16430]));

var G__16431 = (i__5727__auto___16430 + (1));
i__5727__auto___16430 = G__16431;
continue;
} else {
}
break;
}

var G__16364 = args16362.length;
switch (G__16364) {
case 1:
return sablono.core.text_field16361.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field16361.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16362.length)].join('')));

}
});

sablono.core.text_field16361.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.text_field16361.call(null,name__6340__auto__,null);
});

sablono.core.text_field16361.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.text_field16361.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field16361);

/**
 * Creates a time input field.
 */
sablono.core.time_field16365 = (function sablono$core$time_field16365(var_args){
var args16366 = [];
var len__5726__auto___16433 = arguments.length;
var i__5727__auto___16434 = (0);
while(true){
if((i__5727__auto___16434 < len__5726__auto___16433)){
args16366.push((arguments[i__5727__auto___16434]));

var G__16435 = (i__5727__auto___16434 + (1));
i__5727__auto___16434 = G__16435;
continue;
} else {
}
break;
}

var G__16368 = args16366.length;
switch (G__16368) {
case 1:
return sablono.core.time_field16365.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field16365.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16366.length)].join('')));

}
});

sablono.core.time_field16365.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.time_field16365.call(null,name__6340__auto__,null);
});

sablono.core.time_field16365.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.time_field16365.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field16365);

/**
 * Creates a url input field.
 */
sablono.core.url_field16369 = (function sablono$core$url_field16369(var_args){
var args16370 = [];
var len__5726__auto___16437 = arguments.length;
var i__5727__auto___16438 = (0);
while(true){
if((i__5727__auto___16438 < len__5726__auto___16437)){
args16370.push((arguments[i__5727__auto___16438]));

var G__16439 = (i__5727__auto___16438 + (1));
i__5727__auto___16438 = G__16439;
continue;
} else {
}
break;
}

var G__16372 = args16370.length;
switch (G__16372) {
case 1:
return sablono.core.url_field16369.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field16369.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16370.length)].join('')));

}
});

sablono.core.url_field16369.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.url_field16369.call(null,name__6340__auto__,null);
});

sablono.core.url_field16369.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.url_field16369.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field16369);

/**
 * Creates a week input field.
 */
sablono.core.week_field16373 = (function sablono$core$week_field16373(var_args){
var args16374 = [];
var len__5726__auto___16441 = arguments.length;
var i__5727__auto___16442 = (0);
while(true){
if((i__5727__auto___16442 < len__5726__auto___16441)){
args16374.push((arguments[i__5727__auto___16442]));

var G__16443 = (i__5727__auto___16442 + (1));
i__5727__auto___16442 = G__16443;
continue;
} else {
}
break;
}

var G__16376 = args16374.length;
switch (G__16376) {
case 1:
return sablono.core.week_field16373.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field16373.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16374.length)].join('')));

}
});

sablono.core.week_field16373.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.week_field16373.call(null,name__6340__auto__,null);
});

sablono.core.week_field16373.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.week_field16373.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field16373);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box16445 = (function sablono$core$check_box16445(var_args){
var args16446 = [];
var len__5726__auto___16449 = arguments.length;
var i__5727__auto___16450 = (0);
while(true){
if((i__5727__auto___16450 < len__5726__auto___16449)){
args16446.push((arguments[i__5727__auto___16450]));

var G__16451 = (i__5727__auto___16450 + (1));
i__5727__auto___16450 = G__16451;
continue;
} else {
}
break;
}

var G__16448 = args16446.length;
switch (G__16448) {
case 1:
return sablono.core.check_box16445.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box16445.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box16445.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16446.length)].join('')));

}
});

sablono.core.check_box16445.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box16445.call(null,name,null);
});

sablono.core.check_box16445.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box16445.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box16445.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box16445.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box16445);
/**
 * Creates a radio button.
 */
sablono.core.radio_button16453 = (function sablono$core$radio_button16453(var_args){
var args16454 = [];
var len__5726__auto___16457 = arguments.length;
var i__5727__auto___16458 = (0);
while(true){
if((i__5727__auto___16458 < len__5726__auto___16457)){
args16454.push((arguments[i__5727__auto___16458]));

var G__16459 = (i__5727__auto___16458 + (1));
i__5727__auto___16458 = G__16459;
continue;
} else {
}
break;
}

var G__16456 = args16454.length;
switch (G__16456) {
case 1:
return sablono.core.radio_button16453.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button16453.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button16453.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16454.length)].join('')));

}
});

sablono.core.radio_button16453.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button16453.call(null,group,null);
});

sablono.core.radio_button16453.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button16453.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button16453.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button16453.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button16453);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options16461 = (function sablono$core$select_options16461(coll){
var iter__5440__auto__ = (function sablono$core$select_options16461_$_iter__16470(s__16471){
return (new cljs.core.LazySeq(null,(function (){
var s__16471__$1 = s__16471;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16471__$1);
if(temp__4425__auto__){
var s__16471__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16471__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16471__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16473 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16472 = (0);
while(true){
if((i__16472 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16472);
cljs.core.chunk_append.call(null,b__16473,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16476 = x;
var text = cljs.core.nth.call(null,vec__16476,(0),null);
var val = cljs.core.nth.call(null,vec__16476,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16476,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16461.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__16478 = (i__16472 + (1));
i__16472 = G__16478;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16473),sablono$core$select_options16461_$_iter__16470.call(null,cljs.core.chunk_rest.call(null,s__16471__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16473),null);
}
} else {
var x = cljs.core.first.call(null,s__16471__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16477 = x;
var text = cljs.core.nth.call(null,vec__16477,(0),null);
var val = cljs.core.nth.call(null,vec__16477,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16477,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16461.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options16461_$_iter__16470.call(null,cljs.core.rest.call(null,s__16471__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options16461);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down16479 = (function sablono$core$drop_down16479(var_args){
var args16480 = [];
var len__5726__auto___16483 = arguments.length;
var i__5727__auto___16484 = (0);
while(true){
if((i__5727__auto___16484 < len__5726__auto___16483)){
args16480.push((arguments[i__5727__auto___16484]));

var G__16485 = (i__5727__auto___16484 + (1));
i__5727__auto___16484 = G__16485;
continue;
} else {
}
break;
}

var G__16482 = args16480.length;
switch (G__16482) {
case 2:
return sablono.core.drop_down16479.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down16479.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16480.length)].join('')));

}
});

sablono.core.drop_down16479.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down16479.call(null,name,options,null);
});

sablono.core.drop_down16479.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down16479.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down16479);
/**
 * Creates a text area element.
 */
sablono.core.text_area16487 = (function sablono$core$text_area16487(var_args){
var args16488 = [];
var len__5726__auto___16491 = arguments.length;
var i__5727__auto___16492 = (0);
while(true){
if((i__5727__auto___16492 < len__5726__auto___16491)){
args16488.push((arguments[i__5727__auto___16492]));

var G__16493 = (i__5727__auto___16492 + (1));
i__5727__auto___16492 = G__16493;
continue;
} else {
}
break;
}

var G__16490 = args16488.length;
switch (G__16490) {
case 1:
return sablono.core.text_area16487.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area16487.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16488.length)].join('')));

}
});

sablono.core.text_area16487.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area16487.call(null,name,null);
});

sablono.core.text_area16487.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area16487.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area16487);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label16495 = (function sablono$core$label16495(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label16495);
/**
 * Creates a submit button.
 */
sablono.core.submit_button16496 = (function sablono$core$submit_button16496(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button16496);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button16497 = (function sablono$core$reset_button16497(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button16497);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to16498 = (function sablono$core$form_to16498(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16503 = arguments.length;
var i__5727__auto___16504 = (0);
while(true){
if((i__5727__auto___16504 < len__5726__auto___16503)){
args__5733__auto__.push((arguments[i__5727__auto___16504]));

var G__16505 = (i__5727__auto___16504 + (1));
i__5727__auto___16504 = G__16505;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to16498.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to16498.cljs$core$IFn$_invoke$arity$variadic = (function (p__16501,body){
var vec__16502 = p__16501;
var method = cljs.core.nth.call(null,vec__16502,(0),null);
var action = cljs.core.nth.call(null,vec__16502,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to16498.cljs$lang$maxFixedArity = (1);

sablono.core.form_to16498.cljs$lang$applyTo = (function (seq16499){
var G__16500 = cljs.core.first.call(null,seq16499);
var seq16499__$1 = cljs.core.next.call(null,seq16499);
return sablono.core.form_to16498.cljs$core$IFn$_invoke$arity$variadic(G__16500,seq16499__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to16498);

//# sourceMappingURL=core.js.map?rel=1460120401040