// Compiled by ClojureScript 1.7.170 {}
goog.provide('vega_viewer.components.vega_viewer');
goog.require('cljs.core');
goog.require('cljsjs.vega');
goog.require('om.core');
goog.require('sablono.core');
vega_viewer.components.vega_viewer.chart_width_proportion = 0.8;
/**
 * Add a window.resize event handler that changes the :container-width state of
 * a vega-viewer instance when the window is resized
 */
vega_viewer.components.vega_viewer.set_resize_handler = (function vega_viewer$components$vega_viewer$set_resize_handler(owner){
var container = om.core.get_node.call(null,owner,"vega-container");
var resize_handler = window.addEventListener("resize",((function (container){
return (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"container-width","container-width",-1461172864),container.clientWidth);
});})(container))
);
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
/**
 * Render a Vega specification in the supplied container
 */
vega_viewer.components.vega_viewer.render_vega_visualization = (function vega_viewer$components$vega_viewer$render_vega_visualization(spec,container,responsive_QMARK_){
var container_width = container.clientWidth;
var spec_as_js = cljs.core.clj__GT_js.call(null,(cljs.core.truth_(responsive_QMARK_)?cljs.core.assoc.call(null,spec,new cljs.core.Keyword(null,"width","width",-384071477),(container_width * vega_viewer.components.vega_viewer.chart_width_proportion)):spec));
return vg.parse.spec(spec_as_js,((function (container_width,spec_as_js){
return (function (chart){
var view = chart.call(null,{"el": container});
return view.update();
});})(container_width,spec_as_js))
);
});
/**
 * Return an Om component that renders a Vega specification
 */
vega_viewer.components.vega_viewer.vega_viewer = (function vega_viewer$components$vega_viewer$vega_viewer(p__17725,owner,p__17726){
var map__17738 = p__17725;
var map__17738__$1 = ((((!((map__17738 == null)))?((((map__17738.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17738.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17738):map__17738);
var vega_spec = map__17738__$1;
var width = cljs.core.get.call(null,map__17738__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var map__17739 = p__17726;
var map__17739__$1 = ((((!((map__17739 == null)))?((((map__17739.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17739.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17739):map__17739);
var responsive_QMARK_ = cljs.core.get.call(null,map__17739__$1,new cljs.core.Keyword(null,"responsive?","responsive?",-683696941));
if(typeof vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {om.core.IDidUpdate}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742 = (function (vega_viewer,p__17725,owner,p__17726,map__17738,vega_spec,width,map__17739,responsive_QMARK_,meta17743){
this.vega_viewer = vega_viewer;
this.p__17725 = p__17725;
this.owner = owner;
this.p__17726 = p__17726;
this.map__17738 = map__17738;
this.vega_spec = vega_spec;
this.width = width;
this.map__17739 = map__17739;
this.responsive_QMARK_ = responsive_QMARK_;
this.meta17743 = meta17743;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function (_17744,meta17743__$1){
var self__ = this;
var _17744__$1 = this;
return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742(self__.vega_viewer,self__.p__17725,self__.owner,self__.p__17726,self__.map__17738,self__.vega_spec,self__.width,self__.map__17739,self__.responsive_QMARK_,meta17743__$1));
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function (_17744){
var self__ = this;
var _17744__$1 = this;
return self__.meta17743;
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.om$core$IWillUnmount$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
var map__17745 = om.core.get_state.call(null,self__.owner);
var map__17745__$1 = ((((!((map__17745 == null)))?((((map__17745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17745):map__17745);
var resize_handler = cljs.core.get.call(null,map__17745__$1,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881));
return window.removeEventListener("resize",resize_handler);
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.om$core$IDidUpdate$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.om$core$IDidUpdate$did_update$arity$3 = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function (_,___$1,___$2){
var self__ = this;
var ___$3 = this;
return vega_viewer.components.vega_viewer.render_vega_visualization.call(null,self__.vega_spec,om.core.get_node.call(null,self__.owner,"vega-container"),self__.responsive_QMARK_);
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.om$core$IDidMount$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
vega_viewer.components.vega_viewer.set_resize_handler.call(null,self__.owner);

return vega_viewer.components.vega_viewer.render_vega_visualization.call(null,self__.vega_spec,om.core.get_node.call(null,self__.owner,"vega-container"),self__.responsive_QMARK_);
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.om$core$IRender$ = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.prototype.om$core$IRender$render$arity$1 = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
return React.createElement("div",{"ref": "vega-container", "style": {"width": "100%"}});
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.getBasis = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"vega-viewer","vega-viewer",-1445969313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"width","width",1256460050,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"vega-spec","vega-spec",1334352605,null)], null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"responsive?","responsive?",956834586,null)], null)], null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return an Om component that renders a Vega specification"], null)),new cljs.core.Symbol(null,"p__17725","p__17725",-1523781552,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__17726","p__17726",-340391102,null),new cljs.core.Symbol(null,"map__17738","map__17738",-1904772910,null),new cljs.core.Symbol(null,"vega-spec","vega-spec",1334352605,null),new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"map__17739","map__17739",1723922051,null),new cljs.core.Symbol(null,"responsive?","responsive?",956834586,null),new cljs.core.Symbol(null,"meta17743","meta17743",-1327015013,null)], null);
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.cljs$lang$type = true;

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.cljs$lang$ctorStr = "vega-viewer.components.vega-viewer/t_vega_viewer$components$vega_viewer17742";

vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742.cljs$lang$ctorPrWriter = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"vega-viewer.components.vega-viewer/t_vega_viewer$components$vega_viewer17742");
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

vega_viewer.components.vega_viewer.__GT_t_vega_viewer$components$vega_viewer17742 = ((function (map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_){
return (function vega_viewer$components$vega_viewer$vega_viewer_$___GT_t_vega_viewer$components$vega_viewer17742(vega_viewer__$2,p__17725__$1,owner__$1,p__17726__$1,map__17738__$2,vega_spec__$1,width__$1,map__17739__$2,responsive_QMARK___$1,meta17743){
return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742(vega_viewer__$2,p__17725__$1,owner__$1,p__17726__$1,map__17738__$2,vega_spec__$1,width__$1,map__17739__$2,responsive_QMARK___$1,meta17743));
});})(map__17738,map__17738__$1,vega_spec,width,map__17739,map__17739__$1,responsive_QMARK_))
;

}

return (new vega_viewer.components.vega_viewer.t_vega_viewer$components$vega_viewer17742(vega_viewer$components$vega_viewer$vega_viewer,p__17725,owner,p__17726,map__17738__$1,vega_spec,width,map__17739__$1,responsive_QMARK_,cljs.core.PersistentArrayMap.EMPTY));
});

//# sourceMappingURL=vega_viewer.js.map?rel=1460120403667