// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18982 = [];
var len__5726__auto___18988 = arguments.length;
var i__5727__auto___18989 = (0);
while(true){
if((i__5727__auto___18989 < len__5726__auto___18988)){
args18982.push((arguments[i__5727__auto___18989]));

var G__18990 = (i__5727__auto___18989 + (1));
i__5727__auto___18989 = G__18990;
continue;
} else {
}
break;
}

var G__18984 = args18982.length;
switch (G__18984) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18982.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18985 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18985 = (function (f,blockable,meta18986){
this.f = f;
this.blockable = blockable;
this.meta18986 = meta18986;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18985.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18987,meta18986__$1){
var self__ = this;
var _18987__$1 = this;
return (new cljs.core.async.t_cljs$core$async18985(self__.f,self__.blockable,meta18986__$1));
});

cljs.core.async.t_cljs$core$async18985.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18987){
var self__ = this;
var _18987__$1 = this;
return self__.meta18986;
});

cljs.core.async.t_cljs$core$async18985.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18985.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18985.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18985.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18985.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18986","meta18986",1525569556,null)], null);
});

cljs.core.async.t_cljs$core$async18985.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18985.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18985";

cljs.core.async.t_cljs$core$async18985.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18985");
});

cljs.core.async.__GT_t_cljs$core$async18985 = (function cljs$core$async$__GT_t_cljs$core$async18985(f__$1,blockable__$1,meta18986){
return (new cljs.core.async.t_cljs$core$async18985(f__$1,blockable__$1,meta18986));
});

}

return (new cljs.core.async.t_cljs$core$async18985(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args18994 = [];
var len__5726__auto___18997 = arguments.length;
var i__5727__auto___18998 = (0);
while(true){
if((i__5727__auto___18998 < len__5726__auto___18997)){
args18994.push((arguments[i__5727__auto___18998]));

var G__18999 = (i__5727__auto___18998 + (1));
i__5727__auto___18998 = G__18999;
continue;
} else {
}
break;
}

var G__18996 = args18994.length;
switch (G__18996) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18994.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args19001 = [];
var len__5726__auto___19004 = arguments.length;
var i__5727__auto___19005 = (0);
while(true){
if((i__5727__auto___19005 < len__5726__auto___19004)){
args19001.push((arguments[i__5727__auto___19005]));

var G__19006 = (i__5727__auto___19005 + (1));
i__5727__auto___19005 = G__19006;
continue;
} else {
}
break;
}

var G__19003 = args19001.length;
switch (G__19003) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19001.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args19008 = [];
var len__5726__auto___19011 = arguments.length;
var i__5727__auto___19012 = (0);
while(true){
if((i__5727__auto___19012 < len__5726__auto___19011)){
args19008.push((arguments[i__5727__auto___19012]));

var G__19013 = (i__5727__auto___19012 + (1));
i__5727__auto___19012 = G__19013;
continue;
} else {
}
break;
}

var G__19010 = args19008.length;
switch (G__19010) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19008.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_19015 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_19015);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_19015,ret){
return (function (){
return fn1.call(null,val_19015);
});})(val_19015,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args19016 = [];
var len__5726__auto___19019 = arguments.length;
var i__5727__auto___19020 = (0);
while(true){
if((i__5727__auto___19020 < len__5726__auto___19019)){
args19016.push((arguments[i__5727__auto___19020]));

var G__19021 = (i__5727__auto___19020 + (1));
i__5727__auto___19020 = G__19021;
continue;
} else {
}
break;
}

var G__19018 = args19016.length;
switch (G__19018) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19016.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___19023 = n;
var x_19024 = (0);
while(true){
if((x_19024 < n__5571__auto___19023)){
(a[x_19024] = (0));

var G__19025 = (x_19024 + (1));
x_19024 = G__19025;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__19026 = (i + (1));
i = G__19026;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async19030 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19030 = (function (alt_flag,flag,meta19031){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta19031 = meta19031;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19030.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_19032,meta19031__$1){
var self__ = this;
var _19032__$1 = this;
return (new cljs.core.async.t_cljs$core$async19030(self__.alt_flag,self__.flag,meta19031__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async19030.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_19032){
var self__ = this;
var _19032__$1 = this;
return self__.meta19031;
});})(flag))
;

cljs.core.async.t_cljs$core$async19030.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19030.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async19030.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19030.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19030.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19031","meta19031",874053221,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async19030.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19030.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19030";

cljs.core.async.t_cljs$core$async19030.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19030");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async19030 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19030(alt_flag__$1,flag__$1,meta19031){
return (new cljs.core.async.t_cljs$core$async19030(alt_flag__$1,flag__$1,meta19031));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async19030(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async19036 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19036 = (function (alt_handler,flag,cb,meta19037){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta19037 = meta19037;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19036.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19038,meta19037__$1){
var self__ = this;
var _19038__$1 = this;
return (new cljs.core.async.t_cljs$core$async19036(self__.alt_handler,self__.flag,self__.cb,meta19037__$1));
});

cljs.core.async.t_cljs$core$async19036.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19038){
var self__ = this;
var _19038__$1 = this;
return self__.meta19037;
});

cljs.core.async.t_cljs$core$async19036.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19036.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async19036.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19036.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async19036.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19037","meta19037",-1466931837,null)], null);
});

cljs.core.async.t_cljs$core$async19036.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19036.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19036";

cljs.core.async.t_cljs$core$async19036.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19036");
});

cljs.core.async.__GT_t_cljs$core$async19036 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19036(alt_handler__$1,flag__$1,cb__$1,meta19037){
return (new cljs.core.async.t_cljs$core$async19036(alt_handler__$1,flag__$1,cb__$1,meta19037));
});

}

return (new cljs.core.async.t_cljs$core$async19036(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19039_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19039_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19040_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19040_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19041 = (i + (1));
i = G__19041;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___19047 = arguments.length;
var i__5727__auto___19048 = (0);
while(true){
if((i__5727__auto___19048 < len__5726__auto___19047)){
args__5733__auto__.push((arguments[i__5727__auto___19048]));

var G__19049 = (i__5727__auto___19048 + (1));
i__5727__auto___19048 = G__19049;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19044){
var map__19045 = p__19044;
var map__19045__$1 = ((((!((map__19045 == null)))?((((map__19045.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19045.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19045):map__19045);
var opts = map__19045__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19042){
var G__19043 = cljs.core.first.call(null,seq19042);
var seq19042__$1 = cljs.core.next.call(null,seq19042);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19043,seq19042__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args19050 = [];
var len__5726__auto___19100 = arguments.length;
var i__5727__auto___19101 = (0);
while(true){
if((i__5727__auto___19101 < len__5726__auto___19100)){
args19050.push((arguments[i__5727__auto___19101]));

var G__19102 = (i__5727__auto___19101 + (1));
i__5727__auto___19101 = G__19102;
continue;
} else {
}
break;
}

var G__19052 = args19050.length;
switch (G__19052) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19050.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11073__auto___19104 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___19104){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___19104){
return (function (state_19076){
var state_val_19077 = (state_19076[(1)]);
if((state_val_19077 === (7))){
var inst_19072 = (state_19076[(2)]);
var state_19076__$1 = state_19076;
var statearr_19078_19105 = state_19076__$1;
(statearr_19078_19105[(2)] = inst_19072);

(statearr_19078_19105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (1))){
var state_19076__$1 = state_19076;
var statearr_19079_19106 = state_19076__$1;
(statearr_19079_19106[(2)] = null);

(statearr_19079_19106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (4))){
var inst_19055 = (state_19076[(7)]);
var inst_19055__$1 = (state_19076[(2)]);
var inst_19056 = (inst_19055__$1 == null);
var state_19076__$1 = (function (){var statearr_19080 = state_19076;
(statearr_19080[(7)] = inst_19055__$1);

return statearr_19080;
})();
if(cljs.core.truth_(inst_19056)){
var statearr_19081_19107 = state_19076__$1;
(statearr_19081_19107[(1)] = (5));

} else {
var statearr_19082_19108 = state_19076__$1;
(statearr_19082_19108[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (13))){
var state_19076__$1 = state_19076;
var statearr_19083_19109 = state_19076__$1;
(statearr_19083_19109[(2)] = null);

(statearr_19083_19109[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (6))){
var inst_19055 = (state_19076[(7)]);
var state_19076__$1 = state_19076;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19076__$1,(11),to,inst_19055);
} else {
if((state_val_19077 === (3))){
var inst_19074 = (state_19076[(2)]);
var state_19076__$1 = state_19076;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19076__$1,inst_19074);
} else {
if((state_val_19077 === (12))){
var state_19076__$1 = state_19076;
var statearr_19084_19110 = state_19076__$1;
(statearr_19084_19110[(2)] = null);

(statearr_19084_19110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (2))){
var state_19076__$1 = state_19076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19076__$1,(4),from);
} else {
if((state_val_19077 === (11))){
var inst_19065 = (state_19076[(2)]);
var state_19076__$1 = state_19076;
if(cljs.core.truth_(inst_19065)){
var statearr_19085_19111 = state_19076__$1;
(statearr_19085_19111[(1)] = (12));

} else {
var statearr_19086_19112 = state_19076__$1;
(statearr_19086_19112[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (9))){
var state_19076__$1 = state_19076;
var statearr_19087_19113 = state_19076__$1;
(statearr_19087_19113[(2)] = null);

(statearr_19087_19113[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (5))){
var state_19076__$1 = state_19076;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19088_19114 = state_19076__$1;
(statearr_19088_19114[(1)] = (8));

} else {
var statearr_19089_19115 = state_19076__$1;
(statearr_19089_19115[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (14))){
var inst_19070 = (state_19076[(2)]);
var state_19076__$1 = state_19076;
var statearr_19090_19116 = state_19076__$1;
(statearr_19090_19116[(2)] = inst_19070);

(statearr_19090_19116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (10))){
var inst_19062 = (state_19076[(2)]);
var state_19076__$1 = state_19076;
var statearr_19091_19117 = state_19076__$1;
(statearr_19091_19117[(2)] = inst_19062);

(statearr_19091_19117[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19077 === (8))){
var inst_19059 = cljs.core.async.close_BANG_.call(null,to);
var state_19076__$1 = state_19076;
var statearr_19092_19118 = state_19076__$1;
(statearr_19092_19118[(2)] = inst_19059);

(statearr_19092_19118[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___19104))
;
return ((function (switch__10961__auto__,c__11073__auto___19104){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_19096 = [null,null,null,null,null,null,null,null];
(statearr_19096[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_19096[(1)] = (1));

return statearr_19096;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_19076){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19076);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19097){if((e19097 instanceof Object)){
var ex__10965__auto__ = e19097;
var statearr_19098_19119 = state_19076;
(statearr_19098_19119[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19076);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19097;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19120 = state_19076;
state_19076 = G__19120;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_19076){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_19076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___19104))
})();
var state__11075__auto__ = (function (){var statearr_19099 = f__11074__auto__.call(null);
(statearr_19099[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___19104);

return statearr_19099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___19104))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19304){
var vec__19305 = p__19304;
var v = cljs.core.nth.call(null,vec__19305,(0),null);
var p = cljs.core.nth.call(null,vec__19305,(1),null);
var job = vec__19305;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11073__auto___19487 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___19487,res,vec__19305,v,p,job,jobs,results){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___19487,res,vec__19305,v,p,job,jobs,results){
return (function (state_19310){
var state_val_19311 = (state_19310[(1)]);
if((state_val_19311 === (1))){
var state_19310__$1 = state_19310;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19310__$1,(2),res,v);
} else {
if((state_val_19311 === (2))){
var inst_19307 = (state_19310[(2)]);
var inst_19308 = cljs.core.async.close_BANG_.call(null,res);
var state_19310__$1 = (function (){var statearr_19312 = state_19310;
(statearr_19312[(7)] = inst_19307);

return statearr_19312;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19310__$1,inst_19308);
} else {
return null;
}
}
});})(c__11073__auto___19487,res,vec__19305,v,p,job,jobs,results))
;
return ((function (switch__10961__auto__,c__11073__auto___19487,res,vec__19305,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_19316 = [null,null,null,null,null,null,null,null];
(statearr_19316[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_19316[(1)] = (1));

return statearr_19316;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_19310){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19317){if((e19317 instanceof Object)){
var ex__10965__auto__ = e19317;
var statearr_19318_19488 = state_19310;
(statearr_19318_19488[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19310);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19317;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19489 = state_19310;
state_19310 = G__19489;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_19310){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_19310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___19487,res,vec__19305,v,p,job,jobs,results))
})();
var state__11075__auto__ = (function (){var statearr_19319 = f__11074__auto__.call(null);
(statearr_19319[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___19487);

return statearr_19319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___19487,res,vec__19305,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19320){
var vec__19321 = p__19320;
var v = cljs.core.nth.call(null,vec__19321,(0),null);
var p = cljs.core.nth.call(null,vec__19321,(1),null);
var job = vec__19321;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___19490 = n;
var __19491 = (0);
while(true){
if((__19491 < n__5571__auto___19490)){
var G__19322_19492 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19322_19492) {
case "compute":
var c__11073__auto___19494 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19491,c__11073__auto___19494,G__19322_19492,n__5571__auto___19490,jobs,results,process,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (__19491,c__11073__auto___19494,G__19322_19492,n__5571__auto___19490,jobs,results,process,async){
return (function (state_19335){
var state_val_19336 = (state_19335[(1)]);
if((state_val_19336 === (1))){
var state_19335__$1 = state_19335;
var statearr_19337_19495 = state_19335__$1;
(statearr_19337_19495[(2)] = null);

(statearr_19337_19495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19336 === (2))){
var state_19335__$1 = state_19335;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19335__$1,(4),jobs);
} else {
if((state_val_19336 === (3))){
var inst_19333 = (state_19335[(2)]);
var state_19335__$1 = state_19335;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19335__$1,inst_19333);
} else {
if((state_val_19336 === (4))){
var inst_19325 = (state_19335[(2)]);
var inst_19326 = process.call(null,inst_19325);
var state_19335__$1 = state_19335;
if(cljs.core.truth_(inst_19326)){
var statearr_19338_19496 = state_19335__$1;
(statearr_19338_19496[(1)] = (5));

} else {
var statearr_19339_19497 = state_19335__$1;
(statearr_19339_19497[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19336 === (5))){
var state_19335__$1 = state_19335;
var statearr_19340_19498 = state_19335__$1;
(statearr_19340_19498[(2)] = null);

(statearr_19340_19498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19336 === (6))){
var state_19335__$1 = state_19335;
var statearr_19341_19499 = state_19335__$1;
(statearr_19341_19499[(2)] = null);

(statearr_19341_19499[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19336 === (7))){
var inst_19331 = (state_19335[(2)]);
var state_19335__$1 = state_19335;
var statearr_19342_19500 = state_19335__$1;
(statearr_19342_19500[(2)] = inst_19331);

(statearr_19342_19500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19491,c__11073__auto___19494,G__19322_19492,n__5571__auto___19490,jobs,results,process,async))
;
return ((function (__19491,switch__10961__auto__,c__11073__auto___19494,G__19322_19492,n__5571__auto___19490,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_19346 = [null,null,null,null,null,null,null];
(statearr_19346[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_19346[(1)] = (1));

return statearr_19346;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_19335){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19335);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19347){if((e19347 instanceof Object)){
var ex__10965__auto__ = e19347;
var statearr_19348_19501 = state_19335;
(statearr_19348_19501[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19335);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19347;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19502 = state_19335;
state_19335 = G__19502;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_19335){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_19335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(__19491,switch__10961__auto__,c__11073__auto___19494,G__19322_19492,n__5571__auto___19490,jobs,results,process,async))
})();
var state__11075__auto__ = (function (){var statearr_19349 = f__11074__auto__.call(null);
(statearr_19349[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___19494);

return statearr_19349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(__19491,c__11073__auto___19494,G__19322_19492,n__5571__auto___19490,jobs,results,process,async))
);


break;
case "async":
var c__11073__auto___19503 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19491,c__11073__auto___19503,G__19322_19492,n__5571__auto___19490,jobs,results,process,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (__19491,c__11073__auto___19503,G__19322_19492,n__5571__auto___19490,jobs,results,process,async){
return (function (state_19362){
var state_val_19363 = (state_19362[(1)]);
if((state_val_19363 === (1))){
var state_19362__$1 = state_19362;
var statearr_19364_19504 = state_19362__$1;
(statearr_19364_19504[(2)] = null);

(statearr_19364_19504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (2))){
var state_19362__$1 = state_19362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19362__$1,(4),jobs);
} else {
if((state_val_19363 === (3))){
var inst_19360 = (state_19362[(2)]);
var state_19362__$1 = state_19362;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19362__$1,inst_19360);
} else {
if((state_val_19363 === (4))){
var inst_19352 = (state_19362[(2)]);
var inst_19353 = async.call(null,inst_19352);
var state_19362__$1 = state_19362;
if(cljs.core.truth_(inst_19353)){
var statearr_19365_19505 = state_19362__$1;
(statearr_19365_19505[(1)] = (5));

} else {
var statearr_19366_19506 = state_19362__$1;
(statearr_19366_19506[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (5))){
var state_19362__$1 = state_19362;
var statearr_19367_19507 = state_19362__$1;
(statearr_19367_19507[(2)] = null);

(statearr_19367_19507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (6))){
var state_19362__$1 = state_19362;
var statearr_19368_19508 = state_19362__$1;
(statearr_19368_19508[(2)] = null);

(statearr_19368_19508[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (7))){
var inst_19358 = (state_19362[(2)]);
var state_19362__$1 = state_19362;
var statearr_19369_19509 = state_19362__$1;
(statearr_19369_19509[(2)] = inst_19358);

(statearr_19369_19509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19491,c__11073__auto___19503,G__19322_19492,n__5571__auto___19490,jobs,results,process,async))
;
return ((function (__19491,switch__10961__auto__,c__11073__auto___19503,G__19322_19492,n__5571__auto___19490,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_19373 = [null,null,null,null,null,null,null];
(statearr_19373[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_19373[(1)] = (1));

return statearr_19373;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_19362){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19374){if((e19374 instanceof Object)){
var ex__10965__auto__ = e19374;
var statearr_19375_19510 = state_19362;
(statearr_19375_19510[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19374;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19511 = state_19362;
state_19362 = G__19511;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_19362){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_19362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(__19491,switch__10961__auto__,c__11073__auto___19503,G__19322_19492,n__5571__auto___19490,jobs,results,process,async))
})();
var state__11075__auto__ = (function (){var statearr_19376 = f__11074__auto__.call(null);
(statearr_19376[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___19503);

return statearr_19376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(__19491,c__11073__auto___19503,G__19322_19492,n__5571__auto___19490,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19512 = (__19491 + (1));
__19491 = G__19512;
continue;
} else {
}
break;
}

var c__11073__auto___19513 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___19513,jobs,results,process,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___19513,jobs,results,process,async){
return (function (state_19398){
var state_val_19399 = (state_19398[(1)]);
if((state_val_19399 === (1))){
var state_19398__$1 = state_19398;
var statearr_19400_19514 = state_19398__$1;
(statearr_19400_19514[(2)] = null);

(statearr_19400_19514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (2))){
var state_19398__$1 = state_19398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19398__$1,(4),from);
} else {
if((state_val_19399 === (3))){
var inst_19396 = (state_19398[(2)]);
var state_19398__$1 = state_19398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19398__$1,inst_19396);
} else {
if((state_val_19399 === (4))){
var inst_19379 = (state_19398[(7)]);
var inst_19379__$1 = (state_19398[(2)]);
var inst_19380 = (inst_19379__$1 == null);
var state_19398__$1 = (function (){var statearr_19401 = state_19398;
(statearr_19401[(7)] = inst_19379__$1);

return statearr_19401;
})();
if(cljs.core.truth_(inst_19380)){
var statearr_19402_19515 = state_19398__$1;
(statearr_19402_19515[(1)] = (5));

} else {
var statearr_19403_19516 = state_19398__$1;
(statearr_19403_19516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (5))){
var inst_19382 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19398__$1 = state_19398;
var statearr_19404_19517 = state_19398__$1;
(statearr_19404_19517[(2)] = inst_19382);

(statearr_19404_19517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (6))){
var inst_19379 = (state_19398[(7)]);
var inst_19384 = (state_19398[(8)]);
var inst_19384__$1 = cljs.core.async.chan.call(null,(1));
var inst_19385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19386 = [inst_19379,inst_19384__$1];
var inst_19387 = (new cljs.core.PersistentVector(null,2,(5),inst_19385,inst_19386,null));
var state_19398__$1 = (function (){var statearr_19405 = state_19398;
(statearr_19405[(8)] = inst_19384__$1);

return statearr_19405;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19398__$1,(8),jobs,inst_19387);
} else {
if((state_val_19399 === (7))){
var inst_19394 = (state_19398[(2)]);
var state_19398__$1 = state_19398;
var statearr_19406_19518 = state_19398__$1;
(statearr_19406_19518[(2)] = inst_19394);

(statearr_19406_19518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (8))){
var inst_19384 = (state_19398[(8)]);
var inst_19389 = (state_19398[(2)]);
var state_19398__$1 = (function (){var statearr_19407 = state_19398;
(statearr_19407[(9)] = inst_19389);

return statearr_19407;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19398__$1,(9),results,inst_19384);
} else {
if((state_val_19399 === (9))){
var inst_19391 = (state_19398[(2)]);
var state_19398__$1 = (function (){var statearr_19408 = state_19398;
(statearr_19408[(10)] = inst_19391);

return statearr_19408;
})();
var statearr_19409_19519 = state_19398__$1;
(statearr_19409_19519[(2)] = null);

(statearr_19409_19519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___19513,jobs,results,process,async))
;
return ((function (switch__10961__auto__,c__11073__auto___19513,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_19413 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19413[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_19413[(1)] = (1));

return statearr_19413;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_19398){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19414){if((e19414 instanceof Object)){
var ex__10965__auto__ = e19414;
var statearr_19415_19520 = state_19398;
(statearr_19415_19520[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19398);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19414;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19521 = state_19398;
state_19398 = G__19521;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_19398){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_19398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___19513,jobs,results,process,async))
})();
var state__11075__auto__ = (function (){var statearr_19416 = f__11074__auto__.call(null);
(statearr_19416[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___19513);

return statearr_19416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___19513,jobs,results,process,async))
);


var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto__,jobs,results,process,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto__,jobs,results,process,async){
return (function (state_19454){
var state_val_19455 = (state_19454[(1)]);
if((state_val_19455 === (7))){
var inst_19450 = (state_19454[(2)]);
var state_19454__$1 = state_19454;
var statearr_19456_19522 = state_19454__$1;
(statearr_19456_19522[(2)] = inst_19450);

(statearr_19456_19522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (20))){
var state_19454__$1 = state_19454;
var statearr_19457_19523 = state_19454__$1;
(statearr_19457_19523[(2)] = null);

(statearr_19457_19523[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (1))){
var state_19454__$1 = state_19454;
var statearr_19458_19524 = state_19454__$1;
(statearr_19458_19524[(2)] = null);

(statearr_19458_19524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (4))){
var inst_19419 = (state_19454[(7)]);
var inst_19419__$1 = (state_19454[(2)]);
var inst_19420 = (inst_19419__$1 == null);
var state_19454__$1 = (function (){var statearr_19459 = state_19454;
(statearr_19459[(7)] = inst_19419__$1);

return statearr_19459;
})();
if(cljs.core.truth_(inst_19420)){
var statearr_19460_19525 = state_19454__$1;
(statearr_19460_19525[(1)] = (5));

} else {
var statearr_19461_19526 = state_19454__$1;
(statearr_19461_19526[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (15))){
var inst_19432 = (state_19454[(8)]);
var state_19454__$1 = state_19454;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19454__$1,(18),to,inst_19432);
} else {
if((state_val_19455 === (21))){
var inst_19445 = (state_19454[(2)]);
var state_19454__$1 = state_19454;
var statearr_19462_19527 = state_19454__$1;
(statearr_19462_19527[(2)] = inst_19445);

(statearr_19462_19527[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (13))){
var inst_19447 = (state_19454[(2)]);
var state_19454__$1 = (function (){var statearr_19463 = state_19454;
(statearr_19463[(9)] = inst_19447);

return statearr_19463;
})();
var statearr_19464_19528 = state_19454__$1;
(statearr_19464_19528[(2)] = null);

(statearr_19464_19528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (6))){
var inst_19419 = (state_19454[(7)]);
var state_19454__$1 = state_19454;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19454__$1,(11),inst_19419);
} else {
if((state_val_19455 === (17))){
var inst_19440 = (state_19454[(2)]);
var state_19454__$1 = state_19454;
if(cljs.core.truth_(inst_19440)){
var statearr_19465_19529 = state_19454__$1;
(statearr_19465_19529[(1)] = (19));

} else {
var statearr_19466_19530 = state_19454__$1;
(statearr_19466_19530[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (3))){
var inst_19452 = (state_19454[(2)]);
var state_19454__$1 = state_19454;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19454__$1,inst_19452);
} else {
if((state_val_19455 === (12))){
var inst_19429 = (state_19454[(10)]);
var state_19454__$1 = state_19454;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19454__$1,(14),inst_19429);
} else {
if((state_val_19455 === (2))){
var state_19454__$1 = state_19454;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19454__$1,(4),results);
} else {
if((state_val_19455 === (19))){
var state_19454__$1 = state_19454;
var statearr_19467_19531 = state_19454__$1;
(statearr_19467_19531[(2)] = null);

(statearr_19467_19531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (11))){
var inst_19429 = (state_19454[(2)]);
var state_19454__$1 = (function (){var statearr_19468 = state_19454;
(statearr_19468[(10)] = inst_19429);

return statearr_19468;
})();
var statearr_19469_19532 = state_19454__$1;
(statearr_19469_19532[(2)] = null);

(statearr_19469_19532[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (9))){
var state_19454__$1 = state_19454;
var statearr_19470_19533 = state_19454__$1;
(statearr_19470_19533[(2)] = null);

(statearr_19470_19533[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (5))){
var state_19454__$1 = state_19454;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19471_19534 = state_19454__$1;
(statearr_19471_19534[(1)] = (8));

} else {
var statearr_19472_19535 = state_19454__$1;
(statearr_19472_19535[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (14))){
var inst_19432 = (state_19454[(8)]);
var inst_19434 = (state_19454[(11)]);
var inst_19432__$1 = (state_19454[(2)]);
var inst_19433 = (inst_19432__$1 == null);
var inst_19434__$1 = cljs.core.not.call(null,inst_19433);
var state_19454__$1 = (function (){var statearr_19473 = state_19454;
(statearr_19473[(8)] = inst_19432__$1);

(statearr_19473[(11)] = inst_19434__$1);

return statearr_19473;
})();
if(inst_19434__$1){
var statearr_19474_19536 = state_19454__$1;
(statearr_19474_19536[(1)] = (15));

} else {
var statearr_19475_19537 = state_19454__$1;
(statearr_19475_19537[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (16))){
var inst_19434 = (state_19454[(11)]);
var state_19454__$1 = state_19454;
var statearr_19476_19538 = state_19454__$1;
(statearr_19476_19538[(2)] = inst_19434);

(statearr_19476_19538[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (10))){
var inst_19426 = (state_19454[(2)]);
var state_19454__$1 = state_19454;
var statearr_19477_19539 = state_19454__$1;
(statearr_19477_19539[(2)] = inst_19426);

(statearr_19477_19539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (18))){
var inst_19437 = (state_19454[(2)]);
var state_19454__$1 = state_19454;
var statearr_19478_19540 = state_19454__$1;
(statearr_19478_19540[(2)] = inst_19437);

(statearr_19478_19540[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19455 === (8))){
var inst_19423 = cljs.core.async.close_BANG_.call(null,to);
var state_19454__$1 = state_19454;
var statearr_19479_19541 = state_19454__$1;
(statearr_19479_19541[(2)] = inst_19423);

(statearr_19479_19541[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto__,jobs,results,process,async))
;
return ((function (switch__10961__auto__,c__11073__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_19483 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19483[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_19483[(1)] = (1));

return statearr_19483;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_19454){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19454);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19484){if((e19484 instanceof Object)){
var ex__10965__auto__ = e19484;
var statearr_19485_19542 = state_19454;
(statearr_19485_19542[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19484;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19543 = state_19454;
state_19454 = G__19543;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_19454){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_19454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto__,jobs,results,process,async))
})();
var state__11075__auto__ = (function (){var statearr_19486 = f__11074__auto__.call(null);
(statearr_19486[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto__);

return statearr_19486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto__,jobs,results,process,async))
);

return c__11073__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19544 = [];
var len__5726__auto___19547 = arguments.length;
var i__5727__auto___19548 = (0);
while(true){
if((i__5727__auto___19548 < len__5726__auto___19547)){
args19544.push((arguments[i__5727__auto___19548]));

var G__19549 = (i__5727__auto___19548 + (1));
i__5727__auto___19548 = G__19549;
continue;
} else {
}
break;
}

var G__19546 = args19544.length;
switch (G__19546) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19544.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19551 = [];
var len__5726__auto___19554 = arguments.length;
var i__5727__auto___19555 = (0);
while(true){
if((i__5727__auto___19555 < len__5726__auto___19554)){
args19551.push((arguments[i__5727__auto___19555]));

var G__19556 = (i__5727__auto___19555 + (1));
i__5727__auto___19555 = G__19556;
continue;
} else {
}
break;
}

var G__19553 = args19551.length;
switch (G__19553) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19551.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19558 = [];
var len__5726__auto___19611 = arguments.length;
var i__5727__auto___19612 = (0);
while(true){
if((i__5727__auto___19612 < len__5726__auto___19611)){
args19558.push((arguments[i__5727__auto___19612]));

var G__19613 = (i__5727__auto___19612 + (1));
i__5727__auto___19612 = G__19613;
continue;
} else {
}
break;
}

var G__19560 = args19558.length;
switch (G__19560) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19558.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11073__auto___19615 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___19615,tc,fc){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___19615,tc,fc){
return (function (state_19586){
var state_val_19587 = (state_19586[(1)]);
if((state_val_19587 === (7))){
var inst_19582 = (state_19586[(2)]);
var state_19586__$1 = state_19586;
var statearr_19588_19616 = state_19586__$1;
(statearr_19588_19616[(2)] = inst_19582);

(statearr_19588_19616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (1))){
var state_19586__$1 = state_19586;
var statearr_19589_19617 = state_19586__$1;
(statearr_19589_19617[(2)] = null);

(statearr_19589_19617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (4))){
var inst_19563 = (state_19586[(7)]);
var inst_19563__$1 = (state_19586[(2)]);
var inst_19564 = (inst_19563__$1 == null);
var state_19586__$1 = (function (){var statearr_19590 = state_19586;
(statearr_19590[(7)] = inst_19563__$1);

return statearr_19590;
})();
if(cljs.core.truth_(inst_19564)){
var statearr_19591_19618 = state_19586__$1;
(statearr_19591_19618[(1)] = (5));

} else {
var statearr_19592_19619 = state_19586__$1;
(statearr_19592_19619[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (13))){
var state_19586__$1 = state_19586;
var statearr_19593_19620 = state_19586__$1;
(statearr_19593_19620[(2)] = null);

(statearr_19593_19620[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (6))){
var inst_19563 = (state_19586[(7)]);
var inst_19569 = p.call(null,inst_19563);
var state_19586__$1 = state_19586;
if(cljs.core.truth_(inst_19569)){
var statearr_19594_19621 = state_19586__$1;
(statearr_19594_19621[(1)] = (9));

} else {
var statearr_19595_19622 = state_19586__$1;
(statearr_19595_19622[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (3))){
var inst_19584 = (state_19586[(2)]);
var state_19586__$1 = state_19586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19586__$1,inst_19584);
} else {
if((state_val_19587 === (12))){
var state_19586__$1 = state_19586;
var statearr_19596_19623 = state_19586__$1;
(statearr_19596_19623[(2)] = null);

(statearr_19596_19623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (2))){
var state_19586__$1 = state_19586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19586__$1,(4),ch);
} else {
if((state_val_19587 === (11))){
var inst_19563 = (state_19586[(7)]);
var inst_19573 = (state_19586[(2)]);
var state_19586__$1 = state_19586;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19586__$1,(8),inst_19573,inst_19563);
} else {
if((state_val_19587 === (9))){
var state_19586__$1 = state_19586;
var statearr_19597_19624 = state_19586__$1;
(statearr_19597_19624[(2)] = tc);

(statearr_19597_19624[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (5))){
var inst_19566 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19567 = cljs.core.async.close_BANG_.call(null,fc);
var state_19586__$1 = (function (){var statearr_19598 = state_19586;
(statearr_19598[(8)] = inst_19566);

return statearr_19598;
})();
var statearr_19599_19625 = state_19586__$1;
(statearr_19599_19625[(2)] = inst_19567);

(statearr_19599_19625[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (14))){
var inst_19580 = (state_19586[(2)]);
var state_19586__$1 = state_19586;
var statearr_19600_19626 = state_19586__$1;
(statearr_19600_19626[(2)] = inst_19580);

(statearr_19600_19626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (10))){
var state_19586__$1 = state_19586;
var statearr_19601_19627 = state_19586__$1;
(statearr_19601_19627[(2)] = fc);

(statearr_19601_19627[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19587 === (8))){
var inst_19575 = (state_19586[(2)]);
var state_19586__$1 = state_19586;
if(cljs.core.truth_(inst_19575)){
var statearr_19602_19628 = state_19586__$1;
(statearr_19602_19628[(1)] = (12));

} else {
var statearr_19603_19629 = state_19586__$1;
(statearr_19603_19629[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___19615,tc,fc))
;
return ((function (switch__10961__auto__,c__11073__auto___19615,tc,fc){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_19607 = [null,null,null,null,null,null,null,null,null];
(statearr_19607[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_19607[(1)] = (1));

return statearr_19607;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_19586){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19608){if((e19608 instanceof Object)){
var ex__10965__auto__ = e19608;
var statearr_19609_19630 = state_19586;
(statearr_19609_19630[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19608;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19631 = state_19586;
state_19586 = G__19631;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_19586){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_19586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___19615,tc,fc))
})();
var state__11075__auto__ = (function (){var statearr_19610 = f__11074__auto__.call(null);
(statearr_19610[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___19615);

return statearr_19610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___19615,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto__){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto__){
return (function (state_19695){
var state_val_19696 = (state_19695[(1)]);
if((state_val_19696 === (7))){
var inst_19691 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
var statearr_19697_19718 = state_19695__$1;
(statearr_19697_19718[(2)] = inst_19691);

(statearr_19697_19718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (1))){
var inst_19675 = init;
var state_19695__$1 = (function (){var statearr_19698 = state_19695;
(statearr_19698[(7)] = inst_19675);

return statearr_19698;
})();
var statearr_19699_19719 = state_19695__$1;
(statearr_19699_19719[(2)] = null);

(statearr_19699_19719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (4))){
var inst_19678 = (state_19695[(8)]);
var inst_19678__$1 = (state_19695[(2)]);
var inst_19679 = (inst_19678__$1 == null);
var state_19695__$1 = (function (){var statearr_19700 = state_19695;
(statearr_19700[(8)] = inst_19678__$1);

return statearr_19700;
})();
if(cljs.core.truth_(inst_19679)){
var statearr_19701_19720 = state_19695__$1;
(statearr_19701_19720[(1)] = (5));

} else {
var statearr_19702_19721 = state_19695__$1;
(statearr_19702_19721[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (6))){
var inst_19682 = (state_19695[(9)]);
var inst_19675 = (state_19695[(7)]);
var inst_19678 = (state_19695[(8)]);
var inst_19682__$1 = f.call(null,inst_19675,inst_19678);
var inst_19683 = cljs.core.reduced_QMARK_.call(null,inst_19682__$1);
var state_19695__$1 = (function (){var statearr_19703 = state_19695;
(statearr_19703[(9)] = inst_19682__$1);

return statearr_19703;
})();
if(inst_19683){
var statearr_19704_19722 = state_19695__$1;
(statearr_19704_19722[(1)] = (8));

} else {
var statearr_19705_19723 = state_19695__$1;
(statearr_19705_19723[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (3))){
var inst_19693 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19695__$1,inst_19693);
} else {
if((state_val_19696 === (2))){
var state_19695__$1 = state_19695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19695__$1,(4),ch);
} else {
if((state_val_19696 === (9))){
var inst_19682 = (state_19695[(9)]);
var inst_19675 = inst_19682;
var state_19695__$1 = (function (){var statearr_19706 = state_19695;
(statearr_19706[(7)] = inst_19675);

return statearr_19706;
})();
var statearr_19707_19724 = state_19695__$1;
(statearr_19707_19724[(2)] = null);

(statearr_19707_19724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (5))){
var inst_19675 = (state_19695[(7)]);
var state_19695__$1 = state_19695;
var statearr_19708_19725 = state_19695__$1;
(statearr_19708_19725[(2)] = inst_19675);

(statearr_19708_19725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (10))){
var inst_19689 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
var statearr_19709_19726 = state_19695__$1;
(statearr_19709_19726[(2)] = inst_19689);

(statearr_19709_19726[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (8))){
var inst_19682 = (state_19695[(9)]);
var inst_19685 = cljs.core.deref.call(null,inst_19682);
var state_19695__$1 = state_19695;
var statearr_19710_19727 = state_19695__$1;
(statearr_19710_19727[(2)] = inst_19685);

(statearr_19710_19727[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto__))
;
return ((function (switch__10961__auto__,c__11073__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10962__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10962__auto____0 = (function (){
var statearr_19714 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19714[(0)] = cljs$core$async$reduce_$_state_machine__10962__auto__);

(statearr_19714[(1)] = (1));

return statearr_19714;
});
var cljs$core$async$reduce_$_state_machine__10962__auto____1 = (function (state_19695){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19715){if((e19715 instanceof Object)){
var ex__10965__auto__ = e19715;
var statearr_19716_19728 = state_19695;
(statearr_19716_19728[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19715;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19729 = state_19695;
state_19695 = G__19729;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10962__auto__ = function(state_19695){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10962__auto____1.call(this,state_19695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10962__auto____0;
cljs$core$async$reduce_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10962__auto____1;
return cljs$core$async$reduce_$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto__))
})();
var state__11075__auto__ = (function (){var statearr_19717 = f__11074__auto__.call(null);
(statearr_19717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto__);

return statearr_19717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto__))
);

return c__11073__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19730 = [];
var len__5726__auto___19782 = arguments.length;
var i__5727__auto___19783 = (0);
while(true){
if((i__5727__auto___19783 < len__5726__auto___19782)){
args19730.push((arguments[i__5727__auto___19783]));

var G__19784 = (i__5727__auto___19783 + (1));
i__5727__auto___19783 = G__19784;
continue;
} else {
}
break;
}

var G__19732 = args19730.length;
switch (G__19732) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19730.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto__){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto__){
return (function (state_19757){
var state_val_19758 = (state_19757[(1)]);
if((state_val_19758 === (7))){
var inst_19739 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
var statearr_19759_19786 = state_19757__$1;
(statearr_19759_19786[(2)] = inst_19739);

(statearr_19759_19786[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (1))){
var inst_19733 = cljs.core.seq.call(null,coll);
var inst_19734 = inst_19733;
var state_19757__$1 = (function (){var statearr_19760 = state_19757;
(statearr_19760[(7)] = inst_19734);

return statearr_19760;
})();
var statearr_19761_19787 = state_19757__$1;
(statearr_19761_19787[(2)] = null);

(statearr_19761_19787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (4))){
var inst_19734 = (state_19757[(7)]);
var inst_19737 = cljs.core.first.call(null,inst_19734);
var state_19757__$1 = state_19757;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19757__$1,(7),ch,inst_19737);
} else {
if((state_val_19758 === (13))){
var inst_19751 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
var statearr_19762_19788 = state_19757__$1;
(statearr_19762_19788[(2)] = inst_19751);

(statearr_19762_19788[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (6))){
var inst_19742 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
if(cljs.core.truth_(inst_19742)){
var statearr_19763_19789 = state_19757__$1;
(statearr_19763_19789[(1)] = (8));

} else {
var statearr_19764_19790 = state_19757__$1;
(statearr_19764_19790[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (3))){
var inst_19755 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19757__$1,inst_19755);
} else {
if((state_val_19758 === (12))){
var state_19757__$1 = state_19757;
var statearr_19765_19791 = state_19757__$1;
(statearr_19765_19791[(2)] = null);

(statearr_19765_19791[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (2))){
var inst_19734 = (state_19757[(7)]);
var state_19757__$1 = state_19757;
if(cljs.core.truth_(inst_19734)){
var statearr_19766_19792 = state_19757__$1;
(statearr_19766_19792[(1)] = (4));

} else {
var statearr_19767_19793 = state_19757__$1;
(statearr_19767_19793[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (11))){
var inst_19748 = cljs.core.async.close_BANG_.call(null,ch);
var state_19757__$1 = state_19757;
var statearr_19768_19794 = state_19757__$1;
(statearr_19768_19794[(2)] = inst_19748);

(statearr_19768_19794[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (9))){
var state_19757__$1 = state_19757;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19769_19795 = state_19757__$1;
(statearr_19769_19795[(1)] = (11));

} else {
var statearr_19770_19796 = state_19757__$1;
(statearr_19770_19796[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (5))){
var inst_19734 = (state_19757[(7)]);
var state_19757__$1 = state_19757;
var statearr_19771_19797 = state_19757__$1;
(statearr_19771_19797[(2)] = inst_19734);

(statearr_19771_19797[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (10))){
var inst_19753 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
var statearr_19772_19798 = state_19757__$1;
(statearr_19772_19798[(2)] = inst_19753);

(statearr_19772_19798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (8))){
var inst_19734 = (state_19757[(7)]);
var inst_19744 = cljs.core.next.call(null,inst_19734);
var inst_19734__$1 = inst_19744;
var state_19757__$1 = (function (){var statearr_19773 = state_19757;
(statearr_19773[(7)] = inst_19734__$1);

return statearr_19773;
})();
var statearr_19774_19799 = state_19757__$1;
(statearr_19774_19799[(2)] = null);

(statearr_19774_19799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto__))
;
return ((function (switch__10961__auto__,c__11073__auto__){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_19778 = [null,null,null,null,null,null,null,null];
(statearr_19778[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_19778[(1)] = (1));

return statearr_19778;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_19757){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_19757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e19779){if((e19779 instanceof Object)){
var ex__10965__auto__ = e19779;
var statearr_19780_19800 = state_19757;
(statearr_19780_19800[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19757);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19779;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19801 = state_19757;
state_19757 = G__19801;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_19757){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_19757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto__))
})();
var state__11075__auto__ = (function (){var statearr_19781 = f__11074__auto__.call(null);
(statearr_19781[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto__);

return statearr_19781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto__))
);

return c__11073__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20023 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20023 = (function (mult,ch,cs,meta20024){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta20024 = meta20024;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20023.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_20025,meta20024__$1){
var self__ = this;
var _20025__$1 = this;
return (new cljs.core.async.t_cljs$core$async20023(self__.mult,self__.ch,self__.cs,meta20024__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async20023.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_20025){
var self__ = this;
var _20025__$1 = this;
return self__.meta20024;
});})(cs))
;

cljs.core.async.t_cljs$core$async20023.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20023.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async20023.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async20023.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20023.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20023.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20023.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20024","meta20024",-1266819153,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async20023.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20023.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20023";

cljs.core.async.t_cljs$core$async20023.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20023");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async20023 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async20023(mult__$1,ch__$1,cs__$1,meta20024){
return (new cljs.core.async.t_cljs$core$async20023(mult__$1,ch__$1,cs__$1,meta20024));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async20023(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11073__auto___20244 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___20244,cs,m,dchan,dctr,done){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___20244,cs,m,dchan,dctr,done){
return (function (state_20156){
var state_val_20157 = (state_20156[(1)]);
if((state_val_20157 === (7))){
var inst_20152 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20158_20245 = state_20156__$1;
(statearr_20158_20245[(2)] = inst_20152);

(statearr_20158_20245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (20))){
var inst_20057 = (state_20156[(7)]);
var inst_20067 = cljs.core.first.call(null,inst_20057);
var inst_20068 = cljs.core.nth.call(null,inst_20067,(0),null);
var inst_20069 = cljs.core.nth.call(null,inst_20067,(1),null);
var state_20156__$1 = (function (){var statearr_20159 = state_20156;
(statearr_20159[(8)] = inst_20068);

return statearr_20159;
})();
if(cljs.core.truth_(inst_20069)){
var statearr_20160_20246 = state_20156__$1;
(statearr_20160_20246[(1)] = (22));

} else {
var statearr_20161_20247 = state_20156__$1;
(statearr_20161_20247[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (27))){
var inst_20028 = (state_20156[(9)]);
var inst_20097 = (state_20156[(10)]);
var inst_20104 = (state_20156[(11)]);
var inst_20099 = (state_20156[(12)]);
var inst_20104__$1 = cljs.core._nth.call(null,inst_20097,inst_20099);
var inst_20105 = cljs.core.async.put_BANG_.call(null,inst_20104__$1,inst_20028,done);
var state_20156__$1 = (function (){var statearr_20162 = state_20156;
(statearr_20162[(11)] = inst_20104__$1);

return statearr_20162;
})();
if(cljs.core.truth_(inst_20105)){
var statearr_20163_20248 = state_20156__$1;
(statearr_20163_20248[(1)] = (30));

} else {
var statearr_20164_20249 = state_20156__$1;
(statearr_20164_20249[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (1))){
var state_20156__$1 = state_20156;
var statearr_20165_20250 = state_20156__$1;
(statearr_20165_20250[(2)] = null);

(statearr_20165_20250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (24))){
var inst_20057 = (state_20156[(7)]);
var inst_20074 = (state_20156[(2)]);
var inst_20075 = cljs.core.next.call(null,inst_20057);
var inst_20037 = inst_20075;
var inst_20038 = null;
var inst_20039 = (0);
var inst_20040 = (0);
var state_20156__$1 = (function (){var statearr_20166 = state_20156;
(statearr_20166[(13)] = inst_20037);

(statearr_20166[(14)] = inst_20040);

(statearr_20166[(15)] = inst_20074);

(statearr_20166[(16)] = inst_20039);

(statearr_20166[(17)] = inst_20038);

return statearr_20166;
})();
var statearr_20167_20251 = state_20156__$1;
(statearr_20167_20251[(2)] = null);

(statearr_20167_20251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (39))){
var state_20156__$1 = state_20156;
var statearr_20171_20252 = state_20156__$1;
(statearr_20171_20252[(2)] = null);

(statearr_20171_20252[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (4))){
var inst_20028 = (state_20156[(9)]);
var inst_20028__$1 = (state_20156[(2)]);
var inst_20029 = (inst_20028__$1 == null);
var state_20156__$1 = (function (){var statearr_20172 = state_20156;
(statearr_20172[(9)] = inst_20028__$1);

return statearr_20172;
})();
if(cljs.core.truth_(inst_20029)){
var statearr_20173_20253 = state_20156__$1;
(statearr_20173_20253[(1)] = (5));

} else {
var statearr_20174_20254 = state_20156__$1;
(statearr_20174_20254[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (15))){
var inst_20037 = (state_20156[(13)]);
var inst_20040 = (state_20156[(14)]);
var inst_20039 = (state_20156[(16)]);
var inst_20038 = (state_20156[(17)]);
var inst_20053 = (state_20156[(2)]);
var inst_20054 = (inst_20040 + (1));
var tmp20168 = inst_20037;
var tmp20169 = inst_20039;
var tmp20170 = inst_20038;
var inst_20037__$1 = tmp20168;
var inst_20038__$1 = tmp20170;
var inst_20039__$1 = tmp20169;
var inst_20040__$1 = inst_20054;
var state_20156__$1 = (function (){var statearr_20175 = state_20156;
(statearr_20175[(13)] = inst_20037__$1);

(statearr_20175[(14)] = inst_20040__$1);

(statearr_20175[(16)] = inst_20039__$1);

(statearr_20175[(18)] = inst_20053);

(statearr_20175[(17)] = inst_20038__$1);

return statearr_20175;
})();
var statearr_20176_20255 = state_20156__$1;
(statearr_20176_20255[(2)] = null);

(statearr_20176_20255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (21))){
var inst_20078 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20180_20256 = state_20156__$1;
(statearr_20180_20256[(2)] = inst_20078);

(statearr_20180_20256[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (31))){
var inst_20104 = (state_20156[(11)]);
var inst_20108 = done.call(null,null);
var inst_20109 = cljs.core.async.untap_STAR_.call(null,m,inst_20104);
var state_20156__$1 = (function (){var statearr_20181 = state_20156;
(statearr_20181[(19)] = inst_20108);

return statearr_20181;
})();
var statearr_20182_20257 = state_20156__$1;
(statearr_20182_20257[(2)] = inst_20109);

(statearr_20182_20257[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (32))){
var inst_20097 = (state_20156[(10)]);
var inst_20096 = (state_20156[(20)]);
var inst_20098 = (state_20156[(21)]);
var inst_20099 = (state_20156[(12)]);
var inst_20111 = (state_20156[(2)]);
var inst_20112 = (inst_20099 + (1));
var tmp20177 = inst_20097;
var tmp20178 = inst_20096;
var tmp20179 = inst_20098;
var inst_20096__$1 = tmp20178;
var inst_20097__$1 = tmp20177;
var inst_20098__$1 = tmp20179;
var inst_20099__$1 = inst_20112;
var state_20156__$1 = (function (){var statearr_20183 = state_20156;
(statearr_20183[(22)] = inst_20111);

(statearr_20183[(10)] = inst_20097__$1);

(statearr_20183[(20)] = inst_20096__$1);

(statearr_20183[(21)] = inst_20098__$1);

(statearr_20183[(12)] = inst_20099__$1);

return statearr_20183;
})();
var statearr_20184_20258 = state_20156__$1;
(statearr_20184_20258[(2)] = null);

(statearr_20184_20258[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (40))){
var inst_20124 = (state_20156[(23)]);
var inst_20128 = done.call(null,null);
var inst_20129 = cljs.core.async.untap_STAR_.call(null,m,inst_20124);
var state_20156__$1 = (function (){var statearr_20185 = state_20156;
(statearr_20185[(24)] = inst_20128);

return statearr_20185;
})();
var statearr_20186_20259 = state_20156__$1;
(statearr_20186_20259[(2)] = inst_20129);

(statearr_20186_20259[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (33))){
var inst_20115 = (state_20156[(25)]);
var inst_20117 = cljs.core.chunked_seq_QMARK_.call(null,inst_20115);
var state_20156__$1 = state_20156;
if(inst_20117){
var statearr_20187_20260 = state_20156__$1;
(statearr_20187_20260[(1)] = (36));

} else {
var statearr_20188_20261 = state_20156__$1;
(statearr_20188_20261[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (13))){
var inst_20047 = (state_20156[(26)]);
var inst_20050 = cljs.core.async.close_BANG_.call(null,inst_20047);
var state_20156__$1 = state_20156;
var statearr_20189_20262 = state_20156__$1;
(statearr_20189_20262[(2)] = inst_20050);

(statearr_20189_20262[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (22))){
var inst_20068 = (state_20156[(8)]);
var inst_20071 = cljs.core.async.close_BANG_.call(null,inst_20068);
var state_20156__$1 = state_20156;
var statearr_20190_20263 = state_20156__$1;
(statearr_20190_20263[(2)] = inst_20071);

(statearr_20190_20263[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (36))){
var inst_20115 = (state_20156[(25)]);
var inst_20119 = cljs.core.chunk_first.call(null,inst_20115);
var inst_20120 = cljs.core.chunk_rest.call(null,inst_20115);
var inst_20121 = cljs.core.count.call(null,inst_20119);
var inst_20096 = inst_20120;
var inst_20097 = inst_20119;
var inst_20098 = inst_20121;
var inst_20099 = (0);
var state_20156__$1 = (function (){var statearr_20191 = state_20156;
(statearr_20191[(10)] = inst_20097);

(statearr_20191[(20)] = inst_20096);

(statearr_20191[(21)] = inst_20098);

(statearr_20191[(12)] = inst_20099);

return statearr_20191;
})();
var statearr_20192_20264 = state_20156__$1;
(statearr_20192_20264[(2)] = null);

(statearr_20192_20264[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (41))){
var inst_20115 = (state_20156[(25)]);
var inst_20131 = (state_20156[(2)]);
var inst_20132 = cljs.core.next.call(null,inst_20115);
var inst_20096 = inst_20132;
var inst_20097 = null;
var inst_20098 = (0);
var inst_20099 = (0);
var state_20156__$1 = (function (){var statearr_20193 = state_20156;
(statearr_20193[(10)] = inst_20097);

(statearr_20193[(20)] = inst_20096);

(statearr_20193[(21)] = inst_20098);

(statearr_20193[(27)] = inst_20131);

(statearr_20193[(12)] = inst_20099);

return statearr_20193;
})();
var statearr_20194_20265 = state_20156__$1;
(statearr_20194_20265[(2)] = null);

(statearr_20194_20265[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (43))){
var state_20156__$1 = state_20156;
var statearr_20195_20266 = state_20156__$1;
(statearr_20195_20266[(2)] = null);

(statearr_20195_20266[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (29))){
var inst_20140 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20196_20267 = state_20156__$1;
(statearr_20196_20267[(2)] = inst_20140);

(statearr_20196_20267[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (44))){
var inst_20149 = (state_20156[(2)]);
var state_20156__$1 = (function (){var statearr_20197 = state_20156;
(statearr_20197[(28)] = inst_20149);

return statearr_20197;
})();
var statearr_20198_20268 = state_20156__$1;
(statearr_20198_20268[(2)] = null);

(statearr_20198_20268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (6))){
var inst_20088 = (state_20156[(29)]);
var inst_20087 = cljs.core.deref.call(null,cs);
var inst_20088__$1 = cljs.core.keys.call(null,inst_20087);
var inst_20089 = cljs.core.count.call(null,inst_20088__$1);
var inst_20090 = cljs.core.reset_BANG_.call(null,dctr,inst_20089);
var inst_20095 = cljs.core.seq.call(null,inst_20088__$1);
var inst_20096 = inst_20095;
var inst_20097 = null;
var inst_20098 = (0);
var inst_20099 = (0);
var state_20156__$1 = (function (){var statearr_20199 = state_20156;
(statearr_20199[(30)] = inst_20090);

(statearr_20199[(29)] = inst_20088__$1);

(statearr_20199[(10)] = inst_20097);

(statearr_20199[(20)] = inst_20096);

(statearr_20199[(21)] = inst_20098);

(statearr_20199[(12)] = inst_20099);

return statearr_20199;
})();
var statearr_20200_20269 = state_20156__$1;
(statearr_20200_20269[(2)] = null);

(statearr_20200_20269[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (28))){
var inst_20115 = (state_20156[(25)]);
var inst_20096 = (state_20156[(20)]);
var inst_20115__$1 = cljs.core.seq.call(null,inst_20096);
var state_20156__$1 = (function (){var statearr_20201 = state_20156;
(statearr_20201[(25)] = inst_20115__$1);

return statearr_20201;
})();
if(inst_20115__$1){
var statearr_20202_20270 = state_20156__$1;
(statearr_20202_20270[(1)] = (33));

} else {
var statearr_20203_20271 = state_20156__$1;
(statearr_20203_20271[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (25))){
var inst_20098 = (state_20156[(21)]);
var inst_20099 = (state_20156[(12)]);
var inst_20101 = (inst_20099 < inst_20098);
var inst_20102 = inst_20101;
var state_20156__$1 = state_20156;
if(cljs.core.truth_(inst_20102)){
var statearr_20204_20272 = state_20156__$1;
(statearr_20204_20272[(1)] = (27));

} else {
var statearr_20205_20273 = state_20156__$1;
(statearr_20205_20273[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (34))){
var state_20156__$1 = state_20156;
var statearr_20206_20274 = state_20156__$1;
(statearr_20206_20274[(2)] = null);

(statearr_20206_20274[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (17))){
var state_20156__$1 = state_20156;
var statearr_20207_20275 = state_20156__$1;
(statearr_20207_20275[(2)] = null);

(statearr_20207_20275[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (3))){
var inst_20154 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20156__$1,inst_20154);
} else {
if((state_val_20157 === (12))){
var inst_20083 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20208_20276 = state_20156__$1;
(statearr_20208_20276[(2)] = inst_20083);

(statearr_20208_20276[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (2))){
var state_20156__$1 = state_20156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20156__$1,(4),ch);
} else {
if((state_val_20157 === (23))){
var state_20156__$1 = state_20156;
var statearr_20209_20277 = state_20156__$1;
(statearr_20209_20277[(2)] = null);

(statearr_20209_20277[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (35))){
var inst_20138 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20210_20278 = state_20156__$1;
(statearr_20210_20278[(2)] = inst_20138);

(statearr_20210_20278[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (19))){
var inst_20057 = (state_20156[(7)]);
var inst_20061 = cljs.core.chunk_first.call(null,inst_20057);
var inst_20062 = cljs.core.chunk_rest.call(null,inst_20057);
var inst_20063 = cljs.core.count.call(null,inst_20061);
var inst_20037 = inst_20062;
var inst_20038 = inst_20061;
var inst_20039 = inst_20063;
var inst_20040 = (0);
var state_20156__$1 = (function (){var statearr_20211 = state_20156;
(statearr_20211[(13)] = inst_20037);

(statearr_20211[(14)] = inst_20040);

(statearr_20211[(16)] = inst_20039);

(statearr_20211[(17)] = inst_20038);

return statearr_20211;
})();
var statearr_20212_20279 = state_20156__$1;
(statearr_20212_20279[(2)] = null);

(statearr_20212_20279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (11))){
var inst_20037 = (state_20156[(13)]);
var inst_20057 = (state_20156[(7)]);
var inst_20057__$1 = cljs.core.seq.call(null,inst_20037);
var state_20156__$1 = (function (){var statearr_20213 = state_20156;
(statearr_20213[(7)] = inst_20057__$1);

return statearr_20213;
})();
if(inst_20057__$1){
var statearr_20214_20280 = state_20156__$1;
(statearr_20214_20280[(1)] = (16));

} else {
var statearr_20215_20281 = state_20156__$1;
(statearr_20215_20281[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (9))){
var inst_20085 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20216_20282 = state_20156__$1;
(statearr_20216_20282[(2)] = inst_20085);

(statearr_20216_20282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (5))){
var inst_20035 = cljs.core.deref.call(null,cs);
var inst_20036 = cljs.core.seq.call(null,inst_20035);
var inst_20037 = inst_20036;
var inst_20038 = null;
var inst_20039 = (0);
var inst_20040 = (0);
var state_20156__$1 = (function (){var statearr_20217 = state_20156;
(statearr_20217[(13)] = inst_20037);

(statearr_20217[(14)] = inst_20040);

(statearr_20217[(16)] = inst_20039);

(statearr_20217[(17)] = inst_20038);

return statearr_20217;
})();
var statearr_20218_20283 = state_20156__$1;
(statearr_20218_20283[(2)] = null);

(statearr_20218_20283[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (14))){
var state_20156__$1 = state_20156;
var statearr_20219_20284 = state_20156__$1;
(statearr_20219_20284[(2)] = null);

(statearr_20219_20284[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (45))){
var inst_20146 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20220_20285 = state_20156__$1;
(statearr_20220_20285[(2)] = inst_20146);

(statearr_20220_20285[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (26))){
var inst_20088 = (state_20156[(29)]);
var inst_20142 = (state_20156[(2)]);
var inst_20143 = cljs.core.seq.call(null,inst_20088);
var state_20156__$1 = (function (){var statearr_20221 = state_20156;
(statearr_20221[(31)] = inst_20142);

return statearr_20221;
})();
if(inst_20143){
var statearr_20222_20286 = state_20156__$1;
(statearr_20222_20286[(1)] = (42));

} else {
var statearr_20223_20287 = state_20156__$1;
(statearr_20223_20287[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (16))){
var inst_20057 = (state_20156[(7)]);
var inst_20059 = cljs.core.chunked_seq_QMARK_.call(null,inst_20057);
var state_20156__$1 = state_20156;
if(inst_20059){
var statearr_20224_20288 = state_20156__$1;
(statearr_20224_20288[(1)] = (19));

} else {
var statearr_20225_20289 = state_20156__$1;
(statearr_20225_20289[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (38))){
var inst_20135 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20226_20290 = state_20156__$1;
(statearr_20226_20290[(2)] = inst_20135);

(statearr_20226_20290[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (30))){
var state_20156__$1 = state_20156;
var statearr_20227_20291 = state_20156__$1;
(statearr_20227_20291[(2)] = null);

(statearr_20227_20291[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (10))){
var inst_20040 = (state_20156[(14)]);
var inst_20038 = (state_20156[(17)]);
var inst_20046 = cljs.core._nth.call(null,inst_20038,inst_20040);
var inst_20047 = cljs.core.nth.call(null,inst_20046,(0),null);
var inst_20048 = cljs.core.nth.call(null,inst_20046,(1),null);
var state_20156__$1 = (function (){var statearr_20228 = state_20156;
(statearr_20228[(26)] = inst_20047);

return statearr_20228;
})();
if(cljs.core.truth_(inst_20048)){
var statearr_20229_20292 = state_20156__$1;
(statearr_20229_20292[(1)] = (13));

} else {
var statearr_20230_20293 = state_20156__$1;
(statearr_20230_20293[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (18))){
var inst_20081 = (state_20156[(2)]);
var state_20156__$1 = state_20156;
var statearr_20231_20294 = state_20156__$1;
(statearr_20231_20294[(2)] = inst_20081);

(statearr_20231_20294[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (42))){
var state_20156__$1 = state_20156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20156__$1,(45),dchan);
} else {
if((state_val_20157 === (37))){
var inst_20028 = (state_20156[(9)]);
var inst_20115 = (state_20156[(25)]);
var inst_20124 = (state_20156[(23)]);
var inst_20124__$1 = cljs.core.first.call(null,inst_20115);
var inst_20125 = cljs.core.async.put_BANG_.call(null,inst_20124__$1,inst_20028,done);
var state_20156__$1 = (function (){var statearr_20232 = state_20156;
(statearr_20232[(23)] = inst_20124__$1);

return statearr_20232;
})();
if(cljs.core.truth_(inst_20125)){
var statearr_20233_20295 = state_20156__$1;
(statearr_20233_20295[(1)] = (39));

} else {
var statearr_20234_20296 = state_20156__$1;
(statearr_20234_20296[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20157 === (8))){
var inst_20040 = (state_20156[(14)]);
var inst_20039 = (state_20156[(16)]);
var inst_20042 = (inst_20040 < inst_20039);
var inst_20043 = inst_20042;
var state_20156__$1 = state_20156;
if(cljs.core.truth_(inst_20043)){
var statearr_20235_20297 = state_20156__$1;
(statearr_20235_20297[(1)] = (10));

} else {
var statearr_20236_20298 = state_20156__$1;
(statearr_20236_20298[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___20244,cs,m,dchan,dctr,done))
;
return ((function (switch__10961__auto__,c__11073__auto___20244,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10962__auto__ = null;
var cljs$core$async$mult_$_state_machine__10962__auto____0 = (function (){
var statearr_20240 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20240[(0)] = cljs$core$async$mult_$_state_machine__10962__auto__);

(statearr_20240[(1)] = (1));

return statearr_20240;
});
var cljs$core$async$mult_$_state_machine__10962__auto____1 = (function (state_20156){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_20156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e20241){if((e20241 instanceof Object)){
var ex__10965__auto__ = e20241;
var statearr_20242_20299 = state_20156;
(statearr_20242_20299[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20241;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20300 = state_20156;
state_20156 = G__20300;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10962__auto__ = function(state_20156){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10962__auto____1.call(this,state_20156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10962__auto____0;
cljs$core$async$mult_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10962__auto____1;
return cljs$core$async$mult_$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___20244,cs,m,dchan,dctr,done))
})();
var state__11075__auto__ = (function (){var statearr_20243 = f__11074__auto__.call(null);
(statearr_20243[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___20244);

return statearr_20243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___20244,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20301 = [];
var len__5726__auto___20304 = arguments.length;
var i__5727__auto___20305 = (0);
while(true){
if((i__5727__auto___20305 < len__5726__auto___20304)){
args20301.push((arguments[i__5727__auto___20305]));

var G__20306 = (i__5727__auto___20305 + (1));
i__5727__auto___20305 = G__20306;
continue;
} else {
}
break;
}

var G__20303 = args20301.length;
switch (G__20303) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20301.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20318 = arguments.length;
var i__5727__auto___20319 = (0);
while(true){
if((i__5727__auto___20319 < len__5726__auto___20318)){
args__5733__auto__.push((arguments[i__5727__auto___20319]));

var G__20320 = (i__5727__auto___20319 + (1));
i__5727__auto___20319 = G__20320;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20312){
var map__20313 = p__20312;
var map__20313__$1 = ((((!((map__20313 == null)))?((((map__20313.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20313.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20313):map__20313);
var opts = map__20313__$1;
var statearr_20315_20321 = state;
(statearr_20315_20321[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20313,map__20313__$1,opts){
return (function (val){
var statearr_20316_20322 = state;
(statearr_20316_20322[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20313,map__20313__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20317_20323 = state;
(statearr_20317_20323[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20308){
var G__20309 = cljs.core.first.call(null,seq20308);
var seq20308__$1 = cljs.core.next.call(null,seq20308);
var G__20310 = cljs.core.first.call(null,seq20308__$1);
var seq20308__$2 = cljs.core.next.call(null,seq20308__$1);
var G__20311 = cljs.core.first.call(null,seq20308__$2);
var seq20308__$3 = cljs.core.next.call(null,seq20308__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20309,G__20310,G__20311,seq20308__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20487 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20487 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20488){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20488 = meta20488;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20489,meta20488__$1){
var self__ = this;
var _20489__$1 = this;
return (new cljs.core.async.t_cljs$core$async20487(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20488__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20489){
var self__ = this;
var _20489__$1 = this;
return self__.meta20488;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20488","meta20488",-495966977,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20487.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20487.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20487";

cljs.core.async.t_cljs$core$async20487.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20487");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20487 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20487(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20488){
return (new cljs.core.async.t_cljs$core$async20487(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20488));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20487(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11073__auto___20650 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___20650,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___20650,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20587){
var state_val_20588 = (state_20587[(1)]);
if((state_val_20588 === (7))){
var inst_20505 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
var statearr_20589_20651 = state_20587__$1;
(statearr_20589_20651[(2)] = inst_20505);

(statearr_20589_20651[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (20))){
var inst_20517 = (state_20587[(7)]);
var state_20587__$1 = state_20587;
var statearr_20590_20652 = state_20587__$1;
(statearr_20590_20652[(2)] = inst_20517);

(statearr_20590_20652[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (27))){
var state_20587__$1 = state_20587;
var statearr_20591_20653 = state_20587__$1;
(statearr_20591_20653[(2)] = null);

(statearr_20591_20653[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (1))){
var inst_20493 = (state_20587[(8)]);
var inst_20493__$1 = calc_state.call(null);
var inst_20495 = (inst_20493__$1 == null);
var inst_20496 = cljs.core.not.call(null,inst_20495);
var state_20587__$1 = (function (){var statearr_20592 = state_20587;
(statearr_20592[(8)] = inst_20493__$1);

return statearr_20592;
})();
if(inst_20496){
var statearr_20593_20654 = state_20587__$1;
(statearr_20593_20654[(1)] = (2));

} else {
var statearr_20594_20655 = state_20587__$1;
(statearr_20594_20655[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (24))){
var inst_20561 = (state_20587[(9)]);
var inst_20540 = (state_20587[(10)]);
var inst_20547 = (state_20587[(11)]);
var inst_20561__$1 = inst_20540.call(null,inst_20547);
var state_20587__$1 = (function (){var statearr_20595 = state_20587;
(statearr_20595[(9)] = inst_20561__$1);

return statearr_20595;
})();
if(cljs.core.truth_(inst_20561__$1)){
var statearr_20596_20656 = state_20587__$1;
(statearr_20596_20656[(1)] = (29));

} else {
var statearr_20597_20657 = state_20587__$1;
(statearr_20597_20657[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (4))){
var inst_20508 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
if(cljs.core.truth_(inst_20508)){
var statearr_20598_20658 = state_20587__$1;
(statearr_20598_20658[(1)] = (8));

} else {
var statearr_20599_20659 = state_20587__$1;
(statearr_20599_20659[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (15))){
var inst_20534 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
if(cljs.core.truth_(inst_20534)){
var statearr_20600_20660 = state_20587__$1;
(statearr_20600_20660[(1)] = (19));

} else {
var statearr_20601_20661 = state_20587__$1;
(statearr_20601_20661[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (21))){
var inst_20539 = (state_20587[(12)]);
var inst_20539__$1 = (state_20587[(2)]);
var inst_20540 = cljs.core.get.call(null,inst_20539__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20541 = cljs.core.get.call(null,inst_20539__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20542 = cljs.core.get.call(null,inst_20539__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20587__$1 = (function (){var statearr_20602 = state_20587;
(statearr_20602[(12)] = inst_20539__$1);

(statearr_20602[(10)] = inst_20540);

(statearr_20602[(13)] = inst_20541);

return statearr_20602;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20587__$1,(22),inst_20542);
} else {
if((state_val_20588 === (31))){
var inst_20569 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
if(cljs.core.truth_(inst_20569)){
var statearr_20603_20662 = state_20587__$1;
(statearr_20603_20662[(1)] = (32));

} else {
var statearr_20604_20663 = state_20587__$1;
(statearr_20604_20663[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (32))){
var inst_20546 = (state_20587[(14)]);
var state_20587__$1 = state_20587;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20587__$1,(35),out,inst_20546);
} else {
if((state_val_20588 === (33))){
var inst_20539 = (state_20587[(12)]);
var inst_20517 = inst_20539;
var state_20587__$1 = (function (){var statearr_20605 = state_20587;
(statearr_20605[(7)] = inst_20517);

return statearr_20605;
})();
var statearr_20606_20664 = state_20587__$1;
(statearr_20606_20664[(2)] = null);

(statearr_20606_20664[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (13))){
var inst_20517 = (state_20587[(7)]);
var inst_20524 = inst_20517.cljs$lang$protocol_mask$partition0$;
var inst_20525 = (inst_20524 & (64));
var inst_20526 = inst_20517.cljs$core$ISeq$;
var inst_20527 = (inst_20525) || (inst_20526);
var state_20587__$1 = state_20587;
if(cljs.core.truth_(inst_20527)){
var statearr_20607_20665 = state_20587__$1;
(statearr_20607_20665[(1)] = (16));

} else {
var statearr_20608_20666 = state_20587__$1;
(statearr_20608_20666[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (22))){
var inst_20546 = (state_20587[(14)]);
var inst_20547 = (state_20587[(11)]);
var inst_20545 = (state_20587[(2)]);
var inst_20546__$1 = cljs.core.nth.call(null,inst_20545,(0),null);
var inst_20547__$1 = cljs.core.nth.call(null,inst_20545,(1),null);
var inst_20548 = (inst_20546__$1 == null);
var inst_20549 = cljs.core._EQ_.call(null,inst_20547__$1,change);
var inst_20550 = (inst_20548) || (inst_20549);
var state_20587__$1 = (function (){var statearr_20609 = state_20587;
(statearr_20609[(14)] = inst_20546__$1);

(statearr_20609[(11)] = inst_20547__$1);

return statearr_20609;
})();
if(cljs.core.truth_(inst_20550)){
var statearr_20610_20667 = state_20587__$1;
(statearr_20610_20667[(1)] = (23));

} else {
var statearr_20611_20668 = state_20587__$1;
(statearr_20611_20668[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (36))){
var inst_20539 = (state_20587[(12)]);
var inst_20517 = inst_20539;
var state_20587__$1 = (function (){var statearr_20612 = state_20587;
(statearr_20612[(7)] = inst_20517);

return statearr_20612;
})();
var statearr_20613_20669 = state_20587__$1;
(statearr_20613_20669[(2)] = null);

(statearr_20613_20669[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (29))){
var inst_20561 = (state_20587[(9)]);
var state_20587__$1 = state_20587;
var statearr_20614_20670 = state_20587__$1;
(statearr_20614_20670[(2)] = inst_20561);

(statearr_20614_20670[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (6))){
var state_20587__$1 = state_20587;
var statearr_20615_20671 = state_20587__$1;
(statearr_20615_20671[(2)] = false);

(statearr_20615_20671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (28))){
var inst_20557 = (state_20587[(2)]);
var inst_20558 = calc_state.call(null);
var inst_20517 = inst_20558;
var state_20587__$1 = (function (){var statearr_20616 = state_20587;
(statearr_20616[(7)] = inst_20517);

(statearr_20616[(15)] = inst_20557);

return statearr_20616;
})();
var statearr_20617_20672 = state_20587__$1;
(statearr_20617_20672[(2)] = null);

(statearr_20617_20672[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (25))){
var inst_20583 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
var statearr_20618_20673 = state_20587__$1;
(statearr_20618_20673[(2)] = inst_20583);

(statearr_20618_20673[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (34))){
var inst_20581 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
var statearr_20619_20674 = state_20587__$1;
(statearr_20619_20674[(2)] = inst_20581);

(statearr_20619_20674[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (17))){
var state_20587__$1 = state_20587;
var statearr_20620_20675 = state_20587__$1;
(statearr_20620_20675[(2)] = false);

(statearr_20620_20675[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (3))){
var state_20587__$1 = state_20587;
var statearr_20621_20676 = state_20587__$1;
(statearr_20621_20676[(2)] = false);

(statearr_20621_20676[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (12))){
var inst_20585 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20587__$1,inst_20585);
} else {
if((state_val_20588 === (2))){
var inst_20493 = (state_20587[(8)]);
var inst_20498 = inst_20493.cljs$lang$protocol_mask$partition0$;
var inst_20499 = (inst_20498 & (64));
var inst_20500 = inst_20493.cljs$core$ISeq$;
var inst_20501 = (inst_20499) || (inst_20500);
var state_20587__$1 = state_20587;
if(cljs.core.truth_(inst_20501)){
var statearr_20622_20677 = state_20587__$1;
(statearr_20622_20677[(1)] = (5));

} else {
var statearr_20623_20678 = state_20587__$1;
(statearr_20623_20678[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (23))){
var inst_20546 = (state_20587[(14)]);
var inst_20552 = (inst_20546 == null);
var state_20587__$1 = state_20587;
if(cljs.core.truth_(inst_20552)){
var statearr_20624_20679 = state_20587__$1;
(statearr_20624_20679[(1)] = (26));

} else {
var statearr_20625_20680 = state_20587__$1;
(statearr_20625_20680[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (35))){
var inst_20572 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
if(cljs.core.truth_(inst_20572)){
var statearr_20626_20681 = state_20587__$1;
(statearr_20626_20681[(1)] = (36));

} else {
var statearr_20627_20682 = state_20587__$1;
(statearr_20627_20682[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (19))){
var inst_20517 = (state_20587[(7)]);
var inst_20536 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20517);
var state_20587__$1 = state_20587;
var statearr_20628_20683 = state_20587__$1;
(statearr_20628_20683[(2)] = inst_20536);

(statearr_20628_20683[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (11))){
var inst_20517 = (state_20587[(7)]);
var inst_20521 = (inst_20517 == null);
var inst_20522 = cljs.core.not.call(null,inst_20521);
var state_20587__$1 = state_20587;
if(inst_20522){
var statearr_20629_20684 = state_20587__$1;
(statearr_20629_20684[(1)] = (13));

} else {
var statearr_20630_20685 = state_20587__$1;
(statearr_20630_20685[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (9))){
var inst_20493 = (state_20587[(8)]);
var state_20587__$1 = state_20587;
var statearr_20631_20686 = state_20587__$1;
(statearr_20631_20686[(2)] = inst_20493);

(statearr_20631_20686[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (5))){
var state_20587__$1 = state_20587;
var statearr_20632_20687 = state_20587__$1;
(statearr_20632_20687[(2)] = true);

(statearr_20632_20687[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (14))){
var state_20587__$1 = state_20587;
var statearr_20633_20688 = state_20587__$1;
(statearr_20633_20688[(2)] = false);

(statearr_20633_20688[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (26))){
var inst_20547 = (state_20587[(11)]);
var inst_20554 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20547);
var state_20587__$1 = state_20587;
var statearr_20634_20689 = state_20587__$1;
(statearr_20634_20689[(2)] = inst_20554);

(statearr_20634_20689[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (16))){
var state_20587__$1 = state_20587;
var statearr_20635_20690 = state_20587__$1;
(statearr_20635_20690[(2)] = true);

(statearr_20635_20690[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (38))){
var inst_20577 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
var statearr_20636_20691 = state_20587__$1;
(statearr_20636_20691[(2)] = inst_20577);

(statearr_20636_20691[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (30))){
var inst_20540 = (state_20587[(10)]);
var inst_20547 = (state_20587[(11)]);
var inst_20541 = (state_20587[(13)]);
var inst_20564 = cljs.core.empty_QMARK_.call(null,inst_20540);
var inst_20565 = inst_20541.call(null,inst_20547);
var inst_20566 = cljs.core.not.call(null,inst_20565);
var inst_20567 = (inst_20564) && (inst_20566);
var state_20587__$1 = state_20587;
var statearr_20637_20692 = state_20587__$1;
(statearr_20637_20692[(2)] = inst_20567);

(statearr_20637_20692[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (10))){
var inst_20493 = (state_20587[(8)]);
var inst_20513 = (state_20587[(2)]);
var inst_20514 = cljs.core.get.call(null,inst_20513,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20515 = cljs.core.get.call(null,inst_20513,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20516 = cljs.core.get.call(null,inst_20513,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20517 = inst_20493;
var state_20587__$1 = (function (){var statearr_20638 = state_20587;
(statearr_20638[(16)] = inst_20514);

(statearr_20638[(17)] = inst_20515);

(statearr_20638[(18)] = inst_20516);

(statearr_20638[(7)] = inst_20517);

return statearr_20638;
})();
var statearr_20639_20693 = state_20587__$1;
(statearr_20639_20693[(2)] = null);

(statearr_20639_20693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (18))){
var inst_20531 = (state_20587[(2)]);
var state_20587__$1 = state_20587;
var statearr_20640_20694 = state_20587__$1;
(statearr_20640_20694[(2)] = inst_20531);

(statearr_20640_20694[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (37))){
var state_20587__$1 = state_20587;
var statearr_20641_20695 = state_20587__$1;
(statearr_20641_20695[(2)] = null);

(statearr_20641_20695[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20588 === (8))){
var inst_20493 = (state_20587[(8)]);
var inst_20510 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20493);
var state_20587__$1 = state_20587;
var statearr_20642_20696 = state_20587__$1;
(statearr_20642_20696[(2)] = inst_20510);

(statearr_20642_20696[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___20650,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10961__auto__,c__11073__auto___20650,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10962__auto__ = null;
var cljs$core$async$mix_$_state_machine__10962__auto____0 = (function (){
var statearr_20646 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20646[(0)] = cljs$core$async$mix_$_state_machine__10962__auto__);

(statearr_20646[(1)] = (1));

return statearr_20646;
});
var cljs$core$async$mix_$_state_machine__10962__auto____1 = (function (state_20587){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_20587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e20647){if((e20647 instanceof Object)){
var ex__10965__auto__ = e20647;
var statearr_20648_20697 = state_20587;
(statearr_20648_20697[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20587);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20647;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20698 = state_20587;
state_20587 = G__20698;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10962__auto__ = function(state_20587){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10962__auto____1.call(this,state_20587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10962__auto____0;
cljs$core$async$mix_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10962__auto____1;
return cljs$core$async$mix_$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___20650,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11075__auto__ = (function (){var statearr_20649 = f__11074__auto__.call(null);
(statearr_20649[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___20650);

return statearr_20649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___20650,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20699 = [];
var len__5726__auto___20702 = arguments.length;
var i__5727__auto___20703 = (0);
while(true){
if((i__5727__auto___20703 < len__5726__auto___20702)){
args20699.push((arguments[i__5727__auto___20703]));

var G__20704 = (i__5727__auto___20703 + (1));
i__5727__auto___20703 = G__20704;
continue;
} else {
}
break;
}

var G__20701 = args20699.length;
switch (G__20701) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20699.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20707 = [];
var len__5726__auto___20832 = arguments.length;
var i__5727__auto___20833 = (0);
while(true){
if((i__5727__auto___20833 < len__5726__auto___20832)){
args20707.push((arguments[i__5727__auto___20833]));

var G__20834 = (i__5727__auto___20833 + (1));
i__5727__auto___20833 = G__20834;
continue;
} else {
}
break;
}

var G__20709 = args20707.length;
switch (G__20709) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20707.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__20706_SHARP_){
if(cljs.core.truth_(p1__20706_SHARP_.call(null,topic))){
return p1__20706_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20706_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20710 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20710 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20711){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20711 = meta20711;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20712,meta20711__$1){
var self__ = this;
var _20712__$1 = this;
return (new cljs.core.async.t_cljs$core$async20710(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20711__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20712){
var self__ = this;
var _20712__$1 = this;
return self__.meta20711;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20710.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20711","meta20711",2100872266,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20710.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20710.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20710";

cljs.core.async.t_cljs$core$async20710.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20710");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20710 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20710(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20711){
return (new cljs.core.async.t_cljs$core$async20710(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20711));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20710(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11073__auto___20836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___20836,mults,ensure_mult,p){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___20836,mults,ensure_mult,p){
return (function (state_20784){
var state_val_20785 = (state_20784[(1)]);
if((state_val_20785 === (7))){
var inst_20780 = (state_20784[(2)]);
var state_20784__$1 = state_20784;
var statearr_20786_20837 = state_20784__$1;
(statearr_20786_20837[(2)] = inst_20780);

(statearr_20786_20837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (20))){
var state_20784__$1 = state_20784;
var statearr_20787_20838 = state_20784__$1;
(statearr_20787_20838[(2)] = null);

(statearr_20787_20838[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (1))){
var state_20784__$1 = state_20784;
var statearr_20788_20839 = state_20784__$1;
(statearr_20788_20839[(2)] = null);

(statearr_20788_20839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (24))){
var inst_20763 = (state_20784[(7)]);
var inst_20772 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20763);
var state_20784__$1 = state_20784;
var statearr_20789_20840 = state_20784__$1;
(statearr_20789_20840[(2)] = inst_20772);

(statearr_20789_20840[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (4))){
var inst_20715 = (state_20784[(8)]);
var inst_20715__$1 = (state_20784[(2)]);
var inst_20716 = (inst_20715__$1 == null);
var state_20784__$1 = (function (){var statearr_20790 = state_20784;
(statearr_20790[(8)] = inst_20715__$1);

return statearr_20790;
})();
if(cljs.core.truth_(inst_20716)){
var statearr_20791_20841 = state_20784__$1;
(statearr_20791_20841[(1)] = (5));

} else {
var statearr_20792_20842 = state_20784__$1;
(statearr_20792_20842[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (15))){
var inst_20757 = (state_20784[(2)]);
var state_20784__$1 = state_20784;
var statearr_20793_20843 = state_20784__$1;
(statearr_20793_20843[(2)] = inst_20757);

(statearr_20793_20843[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (21))){
var inst_20777 = (state_20784[(2)]);
var state_20784__$1 = (function (){var statearr_20794 = state_20784;
(statearr_20794[(9)] = inst_20777);

return statearr_20794;
})();
var statearr_20795_20844 = state_20784__$1;
(statearr_20795_20844[(2)] = null);

(statearr_20795_20844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (13))){
var inst_20739 = (state_20784[(10)]);
var inst_20741 = cljs.core.chunked_seq_QMARK_.call(null,inst_20739);
var state_20784__$1 = state_20784;
if(inst_20741){
var statearr_20796_20845 = state_20784__$1;
(statearr_20796_20845[(1)] = (16));

} else {
var statearr_20797_20846 = state_20784__$1;
(statearr_20797_20846[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (22))){
var inst_20769 = (state_20784[(2)]);
var state_20784__$1 = state_20784;
if(cljs.core.truth_(inst_20769)){
var statearr_20798_20847 = state_20784__$1;
(statearr_20798_20847[(1)] = (23));

} else {
var statearr_20799_20848 = state_20784__$1;
(statearr_20799_20848[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (6))){
var inst_20765 = (state_20784[(11)]);
var inst_20715 = (state_20784[(8)]);
var inst_20763 = (state_20784[(7)]);
var inst_20763__$1 = topic_fn.call(null,inst_20715);
var inst_20764 = cljs.core.deref.call(null,mults);
var inst_20765__$1 = cljs.core.get.call(null,inst_20764,inst_20763__$1);
var state_20784__$1 = (function (){var statearr_20800 = state_20784;
(statearr_20800[(11)] = inst_20765__$1);

(statearr_20800[(7)] = inst_20763__$1);

return statearr_20800;
})();
if(cljs.core.truth_(inst_20765__$1)){
var statearr_20801_20849 = state_20784__$1;
(statearr_20801_20849[(1)] = (19));

} else {
var statearr_20802_20850 = state_20784__$1;
(statearr_20802_20850[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (25))){
var inst_20774 = (state_20784[(2)]);
var state_20784__$1 = state_20784;
var statearr_20803_20851 = state_20784__$1;
(statearr_20803_20851[(2)] = inst_20774);

(statearr_20803_20851[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (17))){
var inst_20739 = (state_20784[(10)]);
var inst_20748 = cljs.core.first.call(null,inst_20739);
var inst_20749 = cljs.core.async.muxch_STAR_.call(null,inst_20748);
var inst_20750 = cljs.core.async.close_BANG_.call(null,inst_20749);
var inst_20751 = cljs.core.next.call(null,inst_20739);
var inst_20725 = inst_20751;
var inst_20726 = null;
var inst_20727 = (0);
var inst_20728 = (0);
var state_20784__$1 = (function (){var statearr_20804 = state_20784;
(statearr_20804[(12)] = inst_20728);

(statearr_20804[(13)] = inst_20726);

(statearr_20804[(14)] = inst_20727);

(statearr_20804[(15)] = inst_20750);

(statearr_20804[(16)] = inst_20725);

return statearr_20804;
})();
var statearr_20805_20852 = state_20784__$1;
(statearr_20805_20852[(2)] = null);

(statearr_20805_20852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (3))){
var inst_20782 = (state_20784[(2)]);
var state_20784__$1 = state_20784;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20784__$1,inst_20782);
} else {
if((state_val_20785 === (12))){
var inst_20759 = (state_20784[(2)]);
var state_20784__$1 = state_20784;
var statearr_20806_20853 = state_20784__$1;
(statearr_20806_20853[(2)] = inst_20759);

(statearr_20806_20853[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (2))){
var state_20784__$1 = state_20784;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20784__$1,(4),ch);
} else {
if((state_val_20785 === (23))){
var state_20784__$1 = state_20784;
var statearr_20807_20854 = state_20784__$1;
(statearr_20807_20854[(2)] = null);

(statearr_20807_20854[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (19))){
var inst_20765 = (state_20784[(11)]);
var inst_20715 = (state_20784[(8)]);
var inst_20767 = cljs.core.async.muxch_STAR_.call(null,inst_20765);
var state_20784__$1 = state_20784;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20784__$1,(22),inst_20767,inst_20715);
} else {
if((state_val_20785 === (11))){
var inst_20739 = (state_20784[(10)]);
var inst_20725 = (state_20784[(16)]);
var inst_20739__$1 = cljs.core.seq.call(null,inst_20725);
var state_20784__$1 = (function (){var statearr_20808 = state_20784;
(statearr_20808[(10)] = inst_20739__$1);

return statearr_20808;
})();
if(inst_20739__$1){
var statearr_20809_20855 = state_20784__$1;
(statearr_20809_20855[(1)] = (13));

} else {
var statearr_20810_20856 = state_20784__$1;
(statearr_20810_20856[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (9))){
var inst_20761 = (state_20784[(2)]);
var state_20784__$1 = state_20784;
var statearr_20811_20857 = state_20784__$1;
(statearr_20811_20857[(2)] = inst_20761);

(statearr_20811_20857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (5))){
var inst_20722 = cljs.core.deref.call(null,mults);
var inst_20723 = cljs.core.vals.call(null,inst_20722);
var inst_20724 = cljs.core.seq.call(null,inst_20723);
var inst_20725 = inst_20724;
var inst_20726 = null;
var inst_20727 = (0);
var inst_20728 = (0);
var state_20784__$1 = (function (){var statearr_20812 = state_20784;
(statearr_20812[(12)] = inst_20728);

(statearr_20812[(13)] = inst_20726);

(statearr_20812[(14)] = inst_20727);

(statearr_20812[(16)] = inst_20725);

return statearr_20812;
})();
var statearr_20813_20858 = state_20784__$1;
(statearr_20813_20858[(2)] = null);

(statearr_20813_20858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (14))){
var state_20784__$1 = state_20784;
var statearr_20817_20859 = state_20784__$1;
(statearr_20817_20859[(2)] = null);

(statearr_20817_20859[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (16))){
var inst_20739 = (state_20784[(10)]);
var inst_20743 = cljs.core.chunk_first.call(null,inst_20739);
var inst_20744 = cljs.core.chunk_rest.call(null,inst_20739);
var inst_20745 = cljs.core.count.call(null,inst_20743);
var inst_20725 = inst_20744;
var inst_20726 = inst_20743;
var inst_20727 = inst_20745;
var inst_20728 = (0);
var state_20784__$1 = (function (){var statearr_20818 = state_20784;
(statearr_20818[(12)] = inst_20728);

(statearr_20818[(13)] = inst_20726);

(statearr_20818[(14)] = inst_20727);

(statearr_20818[(16)] = inst_20725);

return statearr_20818;
})();
var statearr_20819_20860 = state_20784__$1;
(statearr_20819_20860[(2)] = null);

(statearr_20819_20860[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (10))){
var inst_20728 = (state_20784[(12)]);
var inst_20726 = (state_20784[(13)]);
var inst_20727 = (state_20784[(14)]);
var inst_20725 = (state_20784[(16)]);
var inst_20733 = cljs.core._nth.call(null,inst_20726,inst_20728);
var inst_20734 = cljs.core.async.muxch_STAR_.call(null,inst_20733);
var inst_20735 = cljs.core.async.close_BANG_.call(null,inst_20734);
var inst_20736 = (inst_20728 + (1));
var tmp20814 = inst_20726;
var tmp20815 = inst_20727;
var tmp20816 = inst_20725;
var inst_20725__$1 = tmp20816;
var inst_20726__$1 = tmp20814;
var inst_20727__$1 = tmp20815;
var inst_20728__$1 = inst_20736;
var state_20784__$1 = (function (){var statearr_20820 = state_20784;
(statearr_20820[(12)] = inst_20728__$1);

(statearr_20820[(13)] = inst_20726__$1);

(statearr_20820[(14)] = inst_20727__$1);

(statearr_20820[(17)] = inst_20735);

(statearr_20820[(16)] = inst_20725__$1);

return statearr_20820;
})();
var statearr_20821_20861 = state_20784__$1;
(statearr_20821_20861[(2)] = null);

(statearr_20821_20861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (18))){
var inst_20754 = (state_20784[(2)]);
var state_20784__$1 = state_20784;
var statearr_20822_20862 = state_20784__$1;
(statearr_20822_20862[(2)] = inst_20754);

(statearr_20822_20862[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20785 === (8))){
var inst_20728 = (state_20784[(12)]);
var inst_20727 = (state_20784[(14)]);
var inst_20730 = (inst_20728 < inst_20727);
var inst_20731 = inst_20730;
var state_20784__$1 = state_20784;
if(cljs.core.truth_(inst_20731)){
var statearr_20823_20863 = state_20784__$1;
(statearr_20823_20863[(1)] = (10));

} else {
var statearr_20824_20864 = state_20784__$1;
(statearr_20824_20864[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___20836,mults,ensure_mult,p))
;
return ((function (switch__10961__auto__,c__11073__auto___20836,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_20828 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20828[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_20828[(1)] = (1));

return statearr_20828;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_20784){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_20784);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e20829){if((e20829 instanceof Object)){
var ex__10965__auto__ = e20829;
var statearr_20830_20865 = state_20784;
(statearr_20830_20865[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20784);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20829;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20866 = state_20784;
state_20784 = G__20866;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_20784){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_20784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___20836,mults,ensure_mult,p))
})();
var state__11075__auto__ = (function (){var statearr_20831 = f__11074__auto__.call(null);
(statearr_20831[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___20836);

return statearr_20831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___20836,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20867 = [];
var len__5726__auto___20870 = arguments.length;
var i__5727__auto___20871 = (0);
while(true){
if((i__5727__auto___20871 < len__5726__auto___20870)){
args20867.push((arguments[i__5727__auto___20871]));

var G__20872 = (i__5727__auto___20871 + (1));
i__5727__auto___20871 = G__20872;
continue;
} else {
}
break;
}

var G__20869 = args20867.length;
switch (G__20869) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20867.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20874 = [];
var len__5726__auto___20877 = arguments.length;
var i__5727__auto___20878 = (0);
while(true){
if((i__5727__auto___20878 < len__5726__auto___20877)){
args20874.push((arguments[i__5727__auto___20878]));

var G__20879 = (i__5727__auto___20878 + (1));
i__5727__auto___20878 = G__20879;
continue;
} else {
}
break;
}

var G__20876 = args20874.length;
switch (G__20876) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20874.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20881 = [];
var len__5726__auto___20952 = arguments.length;
var i__5727__auto___20953 = (0);
while(true){
if((i__5727__auto___20953 < len__5726__auto___20952)){
args20881.push((arguments[i__5727__auto___20953]));

var G__20954 = (i__5727__auto___20953 + (1));
i__5727__auto___20953 = G__20954;
continue;
} else {
}
break;
}

var G__20883 = args20881.length;
switch (G__20883) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20881.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11073__auto___20956 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___20956,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___20956,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20922){
var state_val_20923 = (state_20922[(1)]);
if((state_val_20923 === (7))){
var state_20922__$1 = state_20922;
var statearr_20924_20957 = state_20922__$1;
(statearr_20924_20957[(2)] = null);

(statearr_20924_20957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (1))){
var state_20922__$1 = state_20922;
var statearr_20925_20958 = state_20922__$1;
(statearr_20925_20958[(2)] = null);

(statearr_20925_20958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (4))){
var inst_20886 = (state_20922[(7)]);
var inst_20888 = (inst_20886 < cnt);
var state_20922__$1 = state_20922;
if(cljs.core.truth_(inst_20888)){
var statearr_20926_20959 = state_20922__$1;
(statearr_20926_20959[(1)] = (6));

} else {
var statearr_20927_20960 = state_20922__$1;
(statearr_20927_20960[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (15))){
var inst_20918 = (state_20922[(2)]);
var state_20922__$1 = state_20922;
var statearr_20928_20961 = state_20922__$1;
(statearr_20928_20961[(2)] = inst_20918);

(statearr_20928_20961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (13))){
var inst_20911 = cljs.core.async.close_BANG_.call(null,out);
var state_20922__$1 = state_20922;
var statearr_20929_20962 = state_20922__$1;
(statearr_20929_20962[(2)] = inst_20911);

(statearr_20929_20962[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (6))){
var state_20922__$1 = state_20922;
var statearr_20930_20963 = state_20922__$1;
(statearr_20930_20963[(2)] = null);

(statearr_20930_20963[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (3))){
var inst_20920 = (state_20922[(2)]);
var state_20922__$1 = state_20922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20922__$1,inst_20920);
} else {
if((state_val_20923 === (12))){
var inst_20908 = (state_20922[(8)]);
var inst_20908__$1 = (state_20922[(2)]);
var inst_20909 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20908__$1);
var state_20922__$1 = (function (){var statearr_20931 = state_20922;
(statearr_20931[(8)] = inst_20908__$1);

return statearr_20931;
})();
if(cljs.core.truth_(inst_20909)){
var statearr_20932_20964 = state_20922__$1;
(statearr_20932_20964[(1)] = (13));

} else {
var statearr_20933_20965 = state_20922__$1;
(statearr_20933_20965[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (2))){
var inst_20885 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20886 = (0);
var state_20922__$1 = (function (){var statearr_20934 = state_20922;
(statearr_20934[(7)] = inst_20886);

(statearr_20934[(9)] = inst_20885);

return statearr_20934;
})();
var statearr_20935_20966 = state_20922__$1;
(statearr_20935_20966[(2)] = null);

(statearr_20935_20966[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (11))){
var inst_20886 = (state_20922[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20922,(10),Object,null,(9));
var inst_20895 = chs__$1.call(null,inst_20886);
var inst_20896 = done.call(null,inst_20886);
var inst_20897 = cljs.core.async.take_BANG_.call(null,inst_20895,inst_20896);
var state_20922__$1 = state_20922;
var statearr_20936_20967 = state_20922__$1;
(statearr_20936_20967[(2)] = inst_20897);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20922__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (9))){
var inst_20886 = (state_20922[(7)]);
var inst_20899 = (state_20922[(2)]);
var inst_20900 = (inst_20886 + (1));
var inst_20886__$1 = inst_20900;
var state_20922__$1 = (function (){var statearr_20937 = state_20922;
(statearr_20937[(7)] = inst_20886__$1);

(statearr_20937[(10)] = inst_20899);

return statearr_20937;
})();
var statearr_20938_20968 = state_20922__$1;
(statearr_20938_20968[(2)] = null);

(statearr_20938_20968[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (5))){
var inst_20906 = (state_20922[(2)]);
var state_20922__$1 = (function (){var statearr_20939 = state_20922;
(statearr_20939[(11)] = inst_20906);

return statearr_20939;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20922__$1,(12),dchan);
} else {
if((state_val_20923 === (14))){
var inst_20908 = (state_20922[(8)]);
var inst_20913 = cljs.core.apply.call(null,f,inst_20908);
var state_20922__$1 = state_20922;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20922__$1,(16),out,inst_20913);
} else {
if((state_val_20923 === (16))){
var inst_20915 = (state_20922[(2)]);
var state_20922__$1 = (function (){var statearr_20940 = state_20922;
(statearr_20940[(12)] = inst_20915);

return statearr_20940;
})();
var statearr_20941_20969 = state_20922__$1;
(statearr_20941_20969[(2)] = null);

(statearr_20941_20969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (10))){
var inst_20890 = (state_20922[(2)]);
var inst_20891 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20922__$1 = (function (){var statearr_20942 = state_20922;
(statearr_20942[(13)] = inst_20890);

return statearr_20942;
})();
var statearr_20943_20970 = state_20922__$1;
(statearr_20943_20970[(2)] = inst_20891);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20922__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (8))){
var inst_20904 = (state_20922[(2)]);
var state_20922__$1 = state_20922;
var statearr_20944_20971 = state_20922__$1;
(statearr_20944_20971[(2)] = inst_20904);

(statearr_20944_20971[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___20956,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10961__auto__,c__11073__auto___20956,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_20948 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20948[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_20948[(1)] = (1));

return statearr_20948;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_20922){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_20922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e20949){if((e20949 instanceof Object)){
var ex__10965__auto__ = e20949;
var statearr_20950_20972 = state_20922;
(statearr_20950_20972[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20922);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20949;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20973 = state_20922;
state_20922 = G__20973;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_20922){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_20922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___20956,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11075__auto__ = (function (){var statearr_20951 = f__11074__auto__.call(null);
(statearr_20951[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___20956);

return statearr_20951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___20956,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20975 = [];
var len__5726__auto___21031 = arguments.length;
var i__5727__auto___21032 = (0);
while(true){
if((i__5727__auto___21032 < len__5726__auto___21031)){
args20975.push((arguments[i__5727__auto___21032]));

var G__21033 = (i__5727__auto___21032 + (1));
i__5727__auto___21032 = G__21033;
continue;
} else {
}
break;
}

var G__20977 = args20975.length;
switch (G__20977) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20975.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___21035 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___21035,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___21035,out){
return (function (state_21007){
var state_val_21008 = (state_21007[(1)]);
if((state_val_21008 === (7))){
var inst_20986 = (state_21007[(7)]);
var inst_20987 = (state_21007[(8)]);
var inst_20986__$1 = (state_21007[(2)]);
var inst_20987__$1 = cljs.core.nth.call(null,inst_20986__$1,(0),null);
var inst_20988 = cljs.core.nth.call(null,inst_20986__$1,(1),null);
var inst_20989 = (inst_20987__$1 == null);
var state_21007__$1 = (function (){var statearr_21009 = state_21007;
(statearr_21009[(9)] = inst_20988);

(statearr_21009[(7)] = inst_20986__$1);

(statearr_21009[(8)] = inst_20987__$1);

return statearr_21009;
})();
if(cljs.core.truth_(inst_20989)){
var statearr_21010_21036 = state_21007__$1;
(statearr_21010_21036[(1)] = (8));

} else {
var statearr_21011_21037 = state_21007__$1;
(statearr_21011_21037[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21008 === (1))){
var inst_20978 = cljs.core.vec.call(null,chs);
var inst_20979 = inst_20978;
var state_21007__$1 = (function (){var statearr_21012 = state_21007;
(statearr_21012[(10)] = inst_20979);

return statearr_21012;
})();
var statearr_21013_21038 = state_21007__$1;
(statearr_21013_21038[(2)] = null);

(statearr_21013_21038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21008 === (4))){
var inst_20979 = (state_21007[(10)]);
var state_21007__$1 = state_21007;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21007__$1,(7),inst_20979);
} else {
if((state_val_21008 === (6))){
var inst_21003 = (state_21007[(2)]);
var state_21007__$1 = state_21007;
var statearr_21014_21039 = state_21007__$1;
(statearr_21014_21039[(2)] = inst_21003);

(statearr_21014_21039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21008 === (3))){
var inst_21005 = (state_21007[(2)]);
var state_21007__$1 = state_21007;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21007__$1,inst_21005);
} else {
if((state_val_21008 === (2))){
var inst_20979 = (state_21007[(10)]);
var inst_20981 = cljs.core.count.call(null,inst_20979);
var inst_20982 = (inst_20981 > (0));
var state_21007__$1 = state_21007;
if(cljs.core.truth_(inst_20982)){
var statearr_21016_21040 = state_21007__$1;
(statearr_21016_21040[(1)] = (4));

} else {
var statearr_21017_21041 = state_21007__$1;
(statearr_21017_21041[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21008 === (11))){
var inst_20979 = (state_21007[(10)]);
var inst_20996 = (state_21007[(2)]);
var tmp21015 = inst_20979;
var inst_20979__$1 = tmp21015;
var state_21007__$1 = (function (){var statearr_21018 = state_21007;
(statearr_21018[(10)] = inst_20979__$1);

(statearr_21018[(11)] = inst_20996);

return statearr_21018;
})();
var statearr_21019_21042 = state_21007__$1;
(statearr_21019_21042[(2)] = null);

(statearr_21019_21042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21008 === (9))){
var inst_20987 = (state_21007[(8)]);
var state_21007__$1 = state_21007;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21007__$1,(11),out,inst_20987);
} else {
if((state_val_21008 === (5))){
var inst_21001 = cljs.core.async.close_BANG_.call(null,out);
var state_21007__$1 = state_21007;
var statearr_21020_21043 = state_21007__$1;
(statearr_21020_21043[(2)] = inst_21001);

(statearr_21020_21043[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21008 === (10))){
var inst_20999 = (state_21007[(2)]);
var state_21007__$1 = state_21007;
var statearr_21021_21044 = state_21007__$1;
(statearr_21021_21044[(2)] = inst_20999);

(statearr_21021_21044[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21008 === (8))){
var inst_20988 = (state_21007[(9)]);
var inst_20979 = (state_21007[(10)]);
var inst_20986 = (state_21007[(7)]);
var inst_20987 = (state_21007[(8)]);
var inst_20991 = (function (){var cs = inst_20979;
var vec__20984 = inst_20986;
var v = inst_20987;
var c = inst_20988;
return ((function (cs,vec__20984,v,c,inst_20988,inst_20979,inst_20986,inst_20987,state_val_21008,c__11073__auto___21035,out){
return (function (p1__20974_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20974_SHARP_);
});
;})(cs,vec__20984,v,c,inst_20988,inst_20979,inst_20986,inst_20987,state_val_21008,c__11073__auto___21035,out))
})();
var inst_20992 = cljs.core.filterv.call(null,inst_20991,inst_20979);
var inst_20979__$1 = inst_20992;
var state_21007__$1 = (function (){var statearr_21022 = state_21007;
(statearr_21022[(10)] = inst_20979__$1);

return statearr_21022;
})();
var statearr_21023_21045 = state_21007__$1;
(statearr_21023_21045[(2)] = null);

(statearr_21023_21045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___21035,out))
;
return ((function (switch__10961__auto__,c__11073__auto___21035,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_21027 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21027[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_21027[(1)] = (1));

return statearr_21027;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_21007){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_21007);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e21028){if((e21028 instanceof Object)){
var ex__10965__auto__ = e21028;
var statearr_21029_21046 = state_21007;
(statearr_21029_21046[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21007);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21028;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21047 = state_21007;
state_21007 = G__21047;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_21007){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_21007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___21035,out))
})();
var state__11075__auto__ = (function (){var statearr_21030 = f__11074__auto__.call(null);
(statearr_21030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___21035);

return statearr_21030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___21035,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args21048 = [];
var len__5726__auto___21097 = arguments.length;
var i__5727__auto___21098 = (0);
while(true){
if((i__5727__auto___21098 < len__5726__auto___21097)){
args21048.push((arguments[i__5727__auto___21098]));

var G__21099 = (i__5727__auto___21098 + (1));
i__5727__auto___21098 = G__21099;
continue;
} else {
}
break;
}

var G__21050 = args21048.length;
switch (G__21050) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21048.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___21101 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___21101,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___21101,out){
return (function (state_21074){
var state_val_21075 = (state_21074[(1)]);
if((state_val_21075 === (7))){
var inst_21056 = (state_21074[(7)]);
var inst_21056__$1 = (state_21074[(2)]);
var inst_21057 = (inst_21056__$1 == null);
var inst_21058 = cljs.core.not.call(null,inst_21057);
var state_21074__$1 = (function (){var statearr_21076 = state_21074;
(statearr_21076[(7)] = inst_21056__$1);

return statearr_21076;
})();
if(inst_21058){
var statearr_21077_21102 = state_21074__$1;
(statearr_21077_21102[(1)] = (8));

} else {
var statearr_21078_21103 = state_21074__$1;
(statearr_21078_21103[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (1))){
var inst_21051 = (0);
var state_21074__$1 = (function (){var statearr_21079 = state_21074;
(statearr_21079[(8)] = inst_21051);

return statearr_21079;
})();
var statearr_21080_21104 = state_21074__$1;
(statearr_21080_21104[(2)] = null);

(statearr_21080_21104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (4))){
var state_21074__$1 = state_21074;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21074__$1,(7),ch);
} else {
if((state_val_21075 === (6))){
var inst_21069 = (state_21074[(2)]);
var state_21074__$1 = state_21074;
var statearr_21081_21105 = state_21074__$1;
(statearr_21081_21105[(2)] = inst_21069);

(statearr_21081_21105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (3))){
var inst_21071 = (state_21074[(2)]);
var inst_21072 = cljs.core.async.close_BANG_.call(null,out);
var state_21074__$1 = (function (){var statearr_21082 = state_21074;
(statearr_21082[(9)] = inst_21071);

return statearr_21082;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21074__$1,inst_21072);
} else {
if((state_val_21075 === (2))){
var inst_21051 = (state_21074[(8)]);
var inst_21053 = (inst_21051 < n);
var state_21074__$1 = state_21074;
if(cljs.core.truth_(inst_21053)){
var statearr_21083_21106 = state_21074__$1;
(statearr_21083_21106[(1)] = (4));

} else {
var statearr_21084_21107 = state_21074__$1;
(statearr_21084_21107[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (11))){
var inst_21051 = (state_21074[(8)]);
var inst_21061 = (state_21074[(2)]);
var inst_21062 = (inst_21051 + (1));
var inst_21051__$1 = inst_21062;
var state_21074__$1 = (function (){var statearr_21085 = state_21074;
(statearr_21085[(10)] = inst_21061);

(statearr_21085[(8)] = inst_21051__$1);

return statearr_21085;
})();
var statearr_21086_21108 = state_21074__$1;
(statearr_21086_21108[(2)] = null);

(statearr_21086_21108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (9))){
var state_21074__$1 = state_21074;
var statearr_21087_21109 = state_21074__$1;
(statearr_21087_21109[(2)] = null);

(statearr_21087_21109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (5))){
var state_21074__$1 = state_21074;
var statearr_21088_21110 = state_21074__$1;
(statearr_21088_21110[(2)] = null);

(statearr_21088_21110[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (10))){
var inst_21066 = (state_21074[(2)]);
var state_21074__$1 = state_21074;
var statearr_21089_21111 = state_21074__$1;
(statearr_21089_21111[(2)] = inst_21066);

(statearr_21089_21111[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (8))){
var inst_21056 = (state_21074[(7)]);
var state_21074__$1 = state_21074;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21074__$1,(11),out,inst_21056);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___21101,out))
;
return ((function (switch__10961__auto__,c__11073__auto___21101,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_21093 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21093[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_21093[(1)] = (1));

return statearr_21093;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_21074){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_21074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e21094){if((e21094 instanceof Object)){
var ex__10965__auto__ = e21094;
var statearr_21095_21112 = state_21074;
(statearr_21095_21112[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21074);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21094;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21113 = state_21074;
state_21074 = G__21113;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_21074){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_21074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___21101,out))
})();
var state__11075__auto__ = (function (){var statearr_21096 = f__11074__auto__.call(null);
(statearr_21096[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___21101);

return statearr_21096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___21101,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21121 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21121 = (function (map_LT_,f,ch,meta21122){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21122 = meta21122;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21123,meta21122__$1){
var self__ = this;
var _21123__$1 = this;
return (new cljs.core.async.t_cljs$core$async21121(self__.map_LT_,self__.f,self__.ch,meta21122__$1));
});

cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21123){
var self__ = this;
var _21123__$1 = this;
return self__.meta21122;
});

cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21124 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21124 = (function (map_LT_,f,ch,meta21122,_,fn1,meta21125){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21122 = meta21122;
this._ = _;
this.fn1 = fn1;
this.meta21125 = meta21125;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21124.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21126,meta21125__$1){
var self__ = this;
var _21126__$1 = this;
return (new cljs.core.async.t_cljs$core$async21124(self__.map_LT_,self__.f,self__.ch,self__.meta21122,self__._,self__.fn1,meta21125__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21124.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21126){
var self__ = this;
var _21126__$1 = this;
return self__.meta21125;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21124.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21124.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21124.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21124.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21114_SHARP_){
return f1.call(null,(((p1__21114_SHARP_ == null))?null:self__.f.call(null,p1__21114_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21124.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21122","meta21122",530865012,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21121","cljs.core.async/t_cljs$core$async21121",-1655684945,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21125","meta21125",-1093625186,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21124.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21124.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21124";

cljs.core.async.t_cljs$core$async21124.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21124");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21124 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21124(map_LT___$1,f__$1,ch__$1,meta21122__$1,___$2,fn1__$1,meta21125){
return (new cljs.core.async.t_cljs$core$async21124(map_LT___$1,f__$1,ch__$1,meta21122__$1,___$2,fn1__$1,meta21125));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21124(self__.map_LT_,self__.f,self__.ch,self__.meta21122,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21121.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21121.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21122","meta21122",530865012,null)], null);
});

cljs.core.async.t_cljs$core$async21121.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21121.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21121";

cljs.core.async.t_cljs$core$async21121.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21121");
});

cljs.core.async.__GT_t_cljs$core$async21121 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21121(map_LT___$1,f__$1,ch__$1,meta21122){
return (new cljs.core.async.t_cljs$core$async21121(map_LT___$1,f__$1,ch__$1,meta21122));
});

}

return (new cljs.core.async.t_cljs$core$async21121(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21130 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21130 = (function (map_GT_,f,ch,meta21131){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21131 = meta21131;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21130.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21132,meta21131__$1){
var self__ = this;
var _21132__$1 = this;
return (new cljs.core.async.t_cljs$core$async21130(self__.map_GT_,self__.f,self__.ch,meta21131__$1));
});

cljs.core.async.t_cljs$core$async21130.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21132){
var self__ = this;
var _21132__$1 = this;
return self__.meta21131;
});

cljs.core.async.t_cljs$core$async21130.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21130.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21130.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21130.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21130.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21130.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21130.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21131","meta21131",-1775622888,null)], null);
});

cljs.core.async.t_cljs$core$async21130.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21130.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21130";

cljs.core.async.t_cljs$core$async21130.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21130");
});

cljs.core.async.__GT_t_cljs$core$async21130 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21130(map_GT___$1,f__$1,ch__$1,meta21131){
return (new cljs.core.async.t_cljs$core$async21130(map_GT___$1,f__$1,ch__$1,meta21131));
});

}

return (new cljs.core.async.t_cljs$core$async21130(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21136 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21136 = (function (filter_GT_,p,ch,meta21137){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21137 = meta21137;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21138,meta21137__$1){
var self__ = this;
var _21138__$1 = this;
return (new cljs.core.async.t_cljs$core$async21136(self__.filter_GT_,self__.p,self__.ch,meta21137__$1));
});

cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21138){
var self__ = this;
var _21138__$1 = this;
return self__.meta21137;
});

cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21136.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21136.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21137","meta21137",1741562251,null)], null);
});

cljs.core.async.t_cljs$core$async21136.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21136.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21136";

cljs.core.async.t_cljs$core$async21136.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21136");
});

cljs.core.async.__GT_t_cljs$core$async21136 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21136(filter_GT___$1,p__$1,ch__$1,meta21137){
return (new cljs.core.async.t_cljs$core$async21136(filter_GT___$1,p__$1,ch__$1,meta21137));
});

}

return (new cljs.core.async.t_cljs$core$async21136(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21139 = [];
var len__5726__auto___21183 = arguments.length;
var i__5727__auto___21184 = (0);
while(true){
if((i__5727__auto___21184 < len__5726__auto___21183)){
args21139.push((arguments[i__5727__auto___21184]));

var G__21185 = (i__5727__auto___21184 + (1));
i__5727__auto___21184 = G__21185;
continue;
} else {
}
break;
}

var G__21141 = args21139.length;
switch (G__21141) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21139.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___21187 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___21187,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___21187,out){
return (function (state_21162){
var state_val_21163 = (state_21162[(1)]);
if((state_val_21163 === (7))){
var inst_21158 = (state_21162[(2)]);
var state_21162__$1 = state_21162;
var statearr_21164_21188 = state_21162__$1;
(statearr_21164_21188[(2)] = inst_21158);

(statearr_21164_21188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21163 === (1))){
var state_21162__$1 = state_21162;
var statearr_21165_21189 = state_21162__$1;
(statearr_21165_21189[(2)] = null);

(statearr_21165_21189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21163 === (4))){
var inst_21144 = (state_21162[(7)]);
var inst_21144__$1 = (state_21162[(2)]);
var inst_21145 = (inst_21144__$1 == null);
var state_21162__$1 = (function (){var statearr_21166 = state_21162;
(statearr_21166[(7)] = inst_21144__$1);

return statearr_21166;
})();
if(cljs.core.truth_(inst_21145)){
var statearr_21167_21190 = state_21162__$1;
(statearr_21167_21190[(1)] = (5));

} else {
var statearr_21168_21191 = state_21162__$1;
(statearr_21168_21191[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21163 === (6))){
var inst_21144 = (state_21162[(7)]);
var inst_21149 = p.call(null,inst_21144);
var state_21162__$1 = state_21162;
if(cljs.core.truth_(inst_21149)){
var statearr_21169_21192 = state_21162__$1;
(statearr_21169_21192[(1)] = (8));

} else {
var statearr_21170_21193 = state_21162__$1;
(statearr_21170_21193[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21163 === (3))){
var inst_21160 = (state_21162[(2)]);
var state_21162__$1 = state_21162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21162__$1,inst_21160);
} else {
if((state_val_21163 === (2))){
var state_21162__$1 = state_21162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21162__$1,(4),ch);
} else {
if((state_val_21163 === (11))){
var inst_21152 = (state_21162[(2)]);
var state_21162__$1 = state_21162;
var statearr_21171_21194 = state_21162__$1;
(statearr_21171_21194[(2)] = inst_21152);

(statearr_21171_21194[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21163 === (9))){
var state_21162__$1 = state_21162;
var statearr_21172_21195 = state_21162__$1;
(statearr_21172_21195[(2)] = null);

(statearr_21172_21195[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21163 === (5))){
var inst_21147 = cljs.core.async.close_BANG_.call(null,out);
var state_21162__$1 = state_21162;
var statearr_21173_21196 = state_21162__$1;
(statearr_21173_21196[(2)] = inst_21147);

(statearr_21173_21196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21163 === (10))){
var inst_21155 = (state_21162[(2)]);
var state_21162__$1 = (function (){var statearr_21174 = state_21162;
(statearr_21174[(8)] = inst_21155);

return statearr_21174;
})();
var statearr_21175_21197 = state_21162__$1;
(statearr_21175_21197[(2)] = null);

(statearr_21175_21197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21163 === (8))){
var inst_21144 = (state_21162[(7)]);
var state_21162__$1 = state_21162;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21162__$1,(11),out,inst_21144);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___21187,out))
;
return ((function (switch__10961__auto__,c__11073__auto___21187,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_21179 = [null,null,null,null,null,null,null,null,null];
(statearr_21179[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_21179[(1)] = (1));

return statearr_21179;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_21162){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_21162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e21180){if((e21180 instanceof Object)){
var ex__10965__auto__ = e21180;
var statearr_21181_21198 = state_21162;
(statearr_21181_21198[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21162);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21180;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21199 = state_21162;
state_21162 = G__21199;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_21162){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_21162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___21187,out))
})();
var state__11075__auto__ = (function (){var statearr_21182 = f__11074__auto__.call(null);
(statearr_21182[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___21187);

return statearr_21182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___21187,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21200 = [];
var len__5726__auto___21203 = arguments.length;
var i__5727__auto___21204 = (0);
while(true){
if((i__5727__auto___21204 < len__5726__auto___21203)){
args21200.push((arguments[i__5727__auto___21204]));

var G__21205 = (i__5727__auto___21204 + (1));
i__5727__auto___21204 = G__21205;
continue;
} else {
}
break;
}

var G__21202 = args21200.length;
switch (G__21202) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21200.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto__){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto__){
return (function (state_21372){
var state_val_21373 = (state_21372[(1)]);
if((state_val_21373 === (7))){
var inst_21368 = (state_21372[(2)]);
var state_21372__$1 = state_21372;
var statearr_21374_21415 = state_21372__$1;
(statearr_21374_21415[(2)] = inst_21368);

(statearr_21374_21415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (20))){
var inst_21338 = (state_21372[(7)]);
var inst_21349 = (state_21372[(2)]);
var inst_21350 = cljs.core.next.call(null,inst_21338);
var inst_21324 = inst_21350;
var inst_21325 = null;
var inst_21326 = (0);
var inst_21327 = (0);
var state_21372__$1 = (function (){var statearr_21375 = state_21372;
(statearr_21375[(8)] = inst_21349);

(statearr_21375[(9)] = inst_21326);

(statearr_21375[(10)] = inst_21327);

(statearr_21375[(11)] = inst_21325);

(statearr_21375[(12)] = inst_21324);

return statearr_21375;
})();
var statearr_21376_21416 = state_21372__$1;
(statearr_21376_21416[(2)] = null);

(statearr_21376_21416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (1))){
var state_21372__$1 = state_21372;
var statearr_21377_21417 = state_21372__$1;
(statearr_21377_21417[(2)] = null);

(statearr_21377_21417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (4))){
var inst_21313 = (state_21372[(13)]);
var inst_21313__$1 = (state_21372[(2)]);
var inst_21314 = (inst_21313__$1 == null);
var state_21372__$1 = (function (){var statearr_21378 = state_21372;
(statearr_21378[(13)] = inst_21313__$1);

return statearr_21378;
})();
if(cljs.core.truth_(inst_21314)){
var statearr_21379_21418 = state_21372__$1;
(statearr_21379_21418[(1)] = (5));

} else {
var statearr_21380_21419 = state_21372__$1;
(statearr_21380_21419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (15))){
var state_21372__$1 = state_21372;
var statearr_21384_21420 = state_21372__$1;
(statearr_21384_21420[(2)] = null);

(statearr_21384_21420[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (21))){
var state_21372__$1 = state_21372;
var statearr_21385_21421 = state_21372__$1;
(statearr_21385_21421[(2)] = null);

(statearr_21385_21421[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (13))){
var inst_21326 = (state_21372[(9)]);
var inst_21327 = (state_21372[(10)]);
var inst_21325 = (state_21372[(11)]);
var inst_21324 = (state_21372[(12)]);
var inst_21334 = (state_21372[(2)]);
var inst_21335 = (inst_21327 + (1));
var tmp21381 = inst_21326;
var tmp21382 = inst_21325;
var tmp21383 = inst_21324;
var inst_21324__$1 = tmp21383;
var inst_21325__$1 = tmp21382;
var inst_21326__$1 = tmp21381;
var inst_21327__$1 = inst_21335;
var state_21372__$1 = (function (){var statearr_21386 = state_21372;
(statearr_21386[(9)] = inst_21326__$1);

(statearr_21386[(10)] = inst_21327__$1);

(statearr_21386[(11)] = inst_21325__$1);

(statearr_21386[(12)] = inst_21324__$1);

(statearr_21386[(14)] = inst_21334);

return statearr_21386;
})();
var statearr_21387_21422 = state_21372__$1;
(statearr_21387_21422[(2)] = null);

(statearr_21387_21422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (22))){
var state_21372__$1 = state_21372;
var statearr_21388_21423 = state_21372__$1;
(statearr_21388_21423[(2)] = null);

(statearr_21388_21423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (6))){
var inst_21313 = (state_21372[(13)]);
var inst_21322 = f.call(null,inst_21313);
var inst_21323 = cljs.core.seq.call(null,inst_21322);
var inst_21324 = inst_21323;
var inst_21325 = null;
var inst_21326 = (0);
var inst_21327 = (0);
var state_21372__$1 = (function (){var statearr_21389 = state_21372;
(statearr_21389[(9)] = inst_21326);

(statearr_21389[(10)] = inst_21327);

(statearr_21389[(11)] = inst_21325);

(statearr_21389[(12)] = inst_21324);

return statearr_21389;
})();
var statearr_21390_21424 = state_21372__$1;
(statearr_21390_21424[(2)] = null);

(statearr_21390_21424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (17))){
var inst_21338 = (state_21372[(7)]);
var inst_21342 = cljs.core.chunk_first.call(null,inst_21338);
var inst_21343 = cljs.core.chunk_rest.call(null,inst_21338);
var inst_21344 = cljs.core.count.call(null,inst_21342);
var inst_21324 = inst_21343;
var inst_21325 = inst_21342;
var inst_21326 = inst_21344;
var inst_21327 = (0);
var state_21372__$1 = (function (){var statearr_21391 = state_21372;
(statearr_21391[(9)] = inst_21326);

(statearr_21391[(10)] = inst_21327);

(statearr_21391[(11)] = inst_21325);

(statearr_21391[(12)] = inst_21324);

return statearr_21391;
})();
var statearr_21392_21425 = state_21372__$1;
(statearr_21392_21425[(2)] = null);

(statearr_21392_21425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (3))){
var inst_21370 = (state_21372[(2)]);
var state_21372__$1 = state_21372;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21372__$1,inst_21370);
} else {
if((state_val_21373 === (12))){
var inst_21358 = (state_21372[(2)]);
var state_21372__$1 = state_21372;
var statearr_21393_21426 = state_21372__$1;
(statearr_21393_21426[(2)] = inst_21358);

(statearr_21393_21426[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (2))){
var state_21372__$1 = state_21372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21372__$1,(4),in$);
} else {
if((state_val_21373 === (23))){
var inst_21366 = (state_21372[(2)]);
var state_21372__$1 = state_21372;
var statearr_21394_21427 = state_21372__$1;
(statearr_21394_21427[(2)] = inst_21366);

(statearr_21394_21427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (19))){
var inst_21353 = (state_21372[(2)]);
var state_21372__$1 = state_21372;
var statearr_21395_21428 = state_21372__$1;
(statearr_21395_21428[(2)] = inst_21353);

(statearr_21395_21428[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (11))){
var inst_21338 = (state_21372[(7)]);
var inst_21324 = (state_21372[(12)]);
var inst_21338__$1 = cljs.core.seq.call(null,inst_21324);
var state_21372__$1 = (function (){var statearr_21396 = state_21372;
(statearr_21396[(7)] = inst_21338__$1);

return statearr_21396;
})();
if(inst_21338__$1){
var statearr_21397_21429 = state_21372__$1;
(statearr_21397_21429[(1)] = (14));

} else {
var statearr_21398_21430 = state_21372__$1;
(statearr_21398_21430[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (9))){
var inst_21360 = (state_21372[(2)]);
var inst_21361 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21372__$1 = (function (){var statearr_21399 = state_21372;
(statearr_21399[(15)] = inst_21360);

return statearr_21399;
})();
if(cljs.core.truth_(inst_21361)){
var statearr_21400_21431 = state_21372__$1;
(statearr_21400_21431[(1)] = (21));

} else {
var statearr_21401_21432 = state_21372__$1;
(statearr_21401_21432[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (5))){
var inst_21316 = cljs.core.async.close_BANG_.call(null,out);
var state_21372__$1 = state_21372;
var statearr_21402_21433 = state_21372__$1;
(statearr_21402_21433[(2)] = inst_21316);

(statearr_21402_21433[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (14))){
var inst_21338 = (state_21372[(7)]);
var inst_21340 = cljs.core.chunked_seq_QMARK_.call(null,inst_21338);
var state_21372__$1 = state_21372;
if(inst_21340){
var statearr_21403_21434 = state_21372__$1;
(statearr_21403_21434[(1)] = (17));

} else {
var statearr_21404_21435 = state_21372__$1;
(statearr_21404_21435[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (16))){
var inst_21356 = (state_21372[(2)]);
var state_21372__$1 = state_21372;
var statearr_21405_21436 = state_21372__$1;
(statearr_21405_21436[(2)] = inst_21356);

(statearr_21405_21436[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21373 === (10))){
var inst_21327 = (state_21372[(10)]);
var inst_21325 = (state_21372[(11)]);
var inst_21332 = cljs.core._nth.call(null,inst_21325,inst_21327);
var state_21372__$1 = state_21372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21372__$1,(13),out,inst_21332);
} else {
if((state_val_21373 === (18))){
var inst_21338 = (state_21372[(7)]);
var inst_21347 = cljs.core.first.call(null,inst_21338);
var state_21372__$1 = state_21372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21372__$1,(20),out,inst_21347);
} else {
if((state_val_21373 === (8))){
var inst_21326 = (state_21372[(9)]);
var inst_21327 = (state_21372[(10)]);
var inst_21329 = (inst_21327 < inst_21326);
var inst_21330 = inst_21329;
var state_21372__$1 = state_21372;
if(cljs.core.truth_(inst_21330)){
var statearr_21406_21437 = state_21372__$1;
(statearr_21406_21437[(1)] = (10));

} else {
var statearr_21407_21438 = state_21372__$1;
(statearr_21407_21438[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto__))
;
return ((function (switch__10961__auto__,c__11073__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_21411 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21411[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__);

(statearr_21411[(1)] = (1));

return statearr_21411;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____1 = (function (state_21372){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_21372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e21412){if((e21412 instanceof Object)){
var ex__10965__auto__ = e21412;
var statearr_21413_21439 = state_21372;
(statearr_21413_21439[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21412;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21440 = state_21372;
state_21372 = G__21440;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__ = function(state_21372){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____1.call(this,state_21372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto__))
})();
var state__11075__auto__ = (function (){var statearr_21414 = f__11074__auto__.call(null);
(statearr_21414[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto__);

return statearr_21414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto__))
);

return c__11073__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21441 = [];
var len__5726__auto___21444 = arguments.length;
var i__5727__auto___21445 = (0);
while(true){
if((i__5727__auto___21445 < len__5726__auto___21444)){
args21441.push((arguments[i__5727__auto___21445]));

var G__21446 = (i__5727__auto___21445 + (1));
i__5727__auto___21445 = G__21446;
continue;
} else {
}
break;
}

var G__21443 = args21441.length;
switch (G__21443) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21441.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21448 = [];
var len__5726__auto___21451 = arguments.length;
var i__5727__auto___21452 = (0);
while(true){
if((i__5727__auto___21452 < len__5726__auto___21451)){
args21448.push((arguments[i__5727__auto___21452]));

var G__21453 = (i__5727__auto___21452 + (1));
i__5727__auto___21452 = G__21453;
continue;
} else {
}
break;
}

var G__21450 = args21448.length;
switch (G__21450) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21448.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21455 = [];
var len__5726__auto___21506 = arguments.length;
var i__5727__auto___21507 = (0);
while(true){
if((i__5727__auto___21507 < len__5726__auto___21506)){
args21455.push((arguments[i__5727__auto___21507]));

var G__21508 = (i__5727__auto___21507 + (1));
i__5727__auto___21507 = G__21508;
continue;
} else {
}
break;
}

var G__21457 = args21455.length;
switch (G__21457) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21455.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___21510 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___21510,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___21510,out){
return (function (state_21481){
var state_val_21482 = (state_21481[(1)]);
if((state_val_21482 === (7))){
var inst_21476 = (state_21481[(2)]);
var state_21481__$1 = state_21481;
var statearr_21483_21511 = state_21481__$1;
(statearr_21483_21511[(2)] = inst_21476);

(statearr_21483_21511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21482 === (1))){
var inst_21458 = null;
var state_21481__$1 = (function (){var statearr_21484 = state_21481;
(statearr_21484[(7)] = inst_21458);

return statearr_21484;
})();
var statearr_21485_21512 = state_21481__$1;
(statearr_21485_21512[(2)] = null);

(statearr_21485_21512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21482 === (4))){
var inst_21461 = (state_21481[(8)]);
var inst_21461__$1 = (state_21481[(2)]);
var inst_21462 = (inst_21461__$1 == null);
var inst_21463 = cljs.core.not.call(null,inst_21462);
var state_21481__$1 = (function (){var statearr_21486 = state_21481;
(statearr_21486[(8)] = inst_21461__$1);

return statearr_21486;
})();
if(inst_21463){
var statearr_21487_21513 = state_21481__$1;
(statearr_21487_21513[(1)] = (5));

} else {
var statearr_21488_21514 = state_21481__$1;
(statearr_21488_21514[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21482 === (6))){
var state_21481__$1 = state_21481;
var statearr_21489_21515 = state_21481__$1;
(statearr_21489_21515[(2)] = null);

(statearr_21489_21515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21482 === (3))){
var inst_21478 = (state_21481[(2)]);
var inst_21479 = cljs.core.async.close_BANG_.call(null,out);
var state_21481__$1 = (function (){var statearr_21490 = state_21481;
(statearr_21490[(9)] = inst_21478);

return statearr_21490;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21481__$1,inst_21479);
} else {
if((state_val_21482 === (2))){
var state_21481__$1 = state_21481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21481__$1,(4),ch);
} else {
if((state_val_21482 === (11))){
var inst_21461 = (state_21481[(8)]);
var inst_21470 = (state_21481[(2)]);
var inst_21458 = inst_21461;
var state_21481__$1 = (function (){var statearr_21491 = state_21481;
(statearr_21491[(7)] = inst_21458);

(statearr_21491[(10)] = inst_21470);

return statearr_21491;
})();
var statearr_21492_21516 = state_21481__$1;
(statearr_21492_21516[(2)] = null);

(statearr_21492_21516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21482 === (9))){
var inst_21461 = (state_21481[(8)]);
var state_21481__$1 = state_21481;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21481__$1,(11),out,inst_21461);
} else {
if((state_val_21482 === (5))){
var inst_21458 = (state_21481[(7)]);
var inst_21461 = (state_21481[(8)]);
var inst_21465 = cljs.core._EQ_.call(null,inst_21461,inst_21458);
var state_21481__$1 = state_21481;
if(inst_21465){
var statearr_21494_21517 = state_21481__$1;
(statearr_21494_21517[(1)] = (8));

} else {
var statearr_21495_21518 = state_21481__$1;
(statearr_21495_21518[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21482 === (10))){
var inst_21473 = (state_21481[(2)]);
var state_21481__$1 = state_21481;
var statearr_21496_21519 = state_21481__$1;
(statearr_21496_21519[(2)] = inst_21473);

(statearr_21496_21519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21482 === (8))){
var inst_21458 = (state_21481[(7)]);
var tmp21493 = inst_21458;
var inst_21458__$1 = tmp21493;
var state_21481__$1 = (function (){var statearr_21497 = state_21481;
(statearr_21497[(7)] = inst_21458__$1);

return statearr_21497;
})();
var statearr_21498_21520 = state_21481__$1;
(statearr_21498_21520[(2)] = null);

(statearr_21498_21520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___21510,out))
;
return ((function (switch__10961__auto__,c__11073__auto___21510,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_21502 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21502[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_21502[(1)] = (1));

return statearr_21502;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_21481){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_21481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e21503){if((e21503 instanceof Object)){
var ex__10965__auto__ = e21503;
var statearr_21504_21521 = state_21481;
(statearr_21504_21521[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21481);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21503;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21522 = state_21481;
state_21481 = G__21522;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_21481){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_21481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___21510,out))
})();
var state__11075__auto__ = (function (){var statearr_21505 = f__11074__auto__.call(null);
(statearr_21505[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___21510);

return statearr_21505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___21510,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21523 = [];
var len__5726__auto___21593 = arguments.length;
var i__5727__auto___21594 = (0);
while(true){
if((i__5727__auto___21594 < len__5726__auto___21593)){
args21523.push((arguments[i__5727__auto___21594]));

var G__21595 = (i__5727__auto___21594 + (1));
i__5727__auto___21594 = G__21595;
continue;
} else {
}
break;
}

var G__21525 = args21523.length;
switch (G__21525) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21523.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___21597 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___21597,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___21597,out){
return (function (state_21563){
var state_val_21564 = (state_21563[(1)]);
if((state_val_21564 === (7))){
var inst_21559 = (state_21563[(2)]);
var state_21563__$1 = state_21563;
var statearr_21565_21598 = state_21563__$1;
(statearr_21565_21598[(2)] = inst_21559);

(statearr_21565_21598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (1))){
var inst_21526 = (new Array(n));
var inst_21527 = inst_21526;
var inst_21528 = (0);
var state_21563__$1 = (function (){var statearr_21566 = state_21563;
(statearr_21566[(7)] = inst_21527);

(statearr_21566[(8)] = inst_21528);

return statearr_21566;
})();
var statearr_21567_21599 = state_21563__$1;
(statearr_21567_21599[(2)] = null);

(statearr_21567_21599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (4))){
var inst_21531 = (state_21563[(9)]);
var inst_21531__$1 = (state_21563[(2)]);
var inst_21532 = (inst_21531__$1 == null);
var inst_21533 = cljs.core.not.call(null,inst_21532);
var state_21563__$1 = (function (){var statearr_21568 = state_21563;
(statearr_21568[(9)] = inst_21531__$1);

return statearr_21568;
})();
if(inst_21533){
var statearr_21569_21600 = state_21563__$1;
(statearr_21569_21600[(1)] = (5));

} else {
var statearr_21570_21601 = state_21563__$1;
(statearr_21570_21601[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (15))){
var inst_21553 = (state_21563[(2)]);
var state_21563__$1 = state_21563;
var statearr_21571_21602 = state_21563__$1;
(statearr_21571_21602[(2)] = inst_21553);

(statearr_21571_21602[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (13))){
var state_21563__$1 = state_21563;
var statearr_21572_21603 = state_21563__$1;
(statearr_21572_21603[(2)] = null);

(statearr_21572_21603[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (6))){
var inst_21528 = (state_21563[(8)]);
var inst_21549 = (inst_21528 > (0));
var state_21563__$1 = state_21563;
if(cljs.core.truth_(inst_21549)){
var statearr_21573_21604 = state_21563__$1;
(statearr_21573_21604[(1)] = (12));

} else {
var statearr_21574_21605 = state_21563__$1;
(statearr_21574_21605[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (3))){
var inst_21561 = (state_21563[(2)]);
var state_21563__$1 = state_21563;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21563__$1,inst_21561);
} else {
if((state_val_21564 === (12))){
var inst_21527 = (state_21563[(7)]);
var inst_21551 = cljs.core.vec.call(null,inst_21527);
var state_21563__$1 = state_21563;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21563__$1,(15),out,inst_21551);
} else {
if((state_val_21564 === (2))){
var state_21563__$1 = state_21563;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21563__$1,(4),ch);
} else {
if((state_val_21564 === (11))){
var inst_21543 = (state_21563[(2)]);
var inst_21544 = (new Array(n));
var inst_21527 = inst_21544;
var inst_21528 = (0);
var state_21563__$1 = (function (){var statearr_21575 = state_21563;
(statearr_21575[(7)] = inst_21527);

(statearr_21575[(10)] = inst_21543);

(statearr_21575[(8)] = inst_21528);

return statearr_21575;
})();
var statearr_21576_21606 = state_21563__$1;
(statearr_21576_21606[(2)] = null);

(statearr_21576_21606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (9))){
var inst_21527 = (state_21563[(7)]);
var inst_21541 = cljs.core.vec.call(null,inst_21527);
var state_21563__$1 = state_21563;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21563__$1,(11),out,inst_21541);
} else {
if((state_val_21564 === (5))){
var inst_21531 = (state_21563[(9)]);
var inst_21527 = (state_21563[(7)]);
var inst_21536 = (state_21563[(11)]);
var inst_21528 = (state_21563[(8)]);
var inst_21535 = (inst_21527[inst_21528] = inst_21531);
var inst_21536__$1 = (inst_21528 + (1));
var inst_21537 = (inst_21536__$1 < n);
var state_21563__$1 = (function (){var statearr_21577 = state_21563;
(statearr_21577[(11)] = inst_21536__$1);

(statearr_21577[(12)] = inst_21535);

return statearr_21577;
})();
if(cljs.core.truth_(inst_21537)){
var statearr_21578_21607 = state_21563__$1;
(statearr_21578_21607[(1)] = (8));

} else {
var statearr_21579_21608 = state_21563__$1;
(statearr_21579_21608[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (14))){
var inst_21556 = (state_21563[(2)]);
var inst_21557 = cljs.core.async.close_BANG_.call(null,out);
var state_21563__$1 = (function (){var statearr_21581 = state_21563;
(statearr_21581[(13)] = inst_21556);

return statearr_21581;
})();
var statearr_21582_21609 = state_21563__$1;
(statearr_21582_21609[(2)] = inst_21557);

(statearr_21582_21609[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (10))){
var inst_21547 = (state_21563[(2)]);
var state_21563__$1 = state_21563;
var statearr_21583_21610 = state_21563__$1;
(statearr_21583_21610[(2)] = inst_21547);

(statearr_21583_21610[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21564 === (8))){
var inst_21527 = (state_21563[(7)]);
var inst_21536 = (state_21563[(11)]);
var tmp21580 = inst_21527;
var inst_21527__$1 = tmp21580;
var inst_21528 = inst_21536;
var state_21563__$1 = (function (){var statearr_21584 = state_21563;
(statearr_21584[(7)] = inst_21527__$1);

(statearr_21584[(8)] = inst_21528);

return statearr_21584;
})();
var statearr_21585_21611 = state_21563__$1;
(statearr_21585_21611[(2)] = null);

(statearr_21585_21611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___21597,out))
;
return ((function (switch__10961__auto__,c__11073__auto___21597,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_21589 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21589[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_21589[(1)] = (1));

return statearr_21589;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_21563){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_21563);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e21590){if((e21590 instanceof Object)){
var ex__10965__auto__ = e21590;
var statearr_21591_21612 = state_21563;
(statearr_21591_21612[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21563);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21590;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21613 = state_21563;
state_21563 = G__21613;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_21563){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_21563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___21597,out))
})();
var state__11075__auto__ = (function (){var statearr_21592 = f__11074__auto__.call(null);
(statearr_21592[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___21597);

return statearr_21592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___21597,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21614 = [];
var len__5726__auto___21688 = arguments.length;
var i__5727__auto___21689 = (0);
while(true){
if((i__5727__auto___21689 < len__5726__auto___21688)){
args21614.push((arguments[i__5727__auto___21689]));

var G__21690 = (i__5727__auto___21689 + (1));
i__5727__auto___21689 = G__21690;
continue;
} else {
}
break;
}

var G__21616 = args21614.length;
switch (G__21616) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21614.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___21692 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___21692,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___21692,out){
return (function (state_21658){
var state_val_21659 = (state_21658[(1)]);
if((state_val_21659 === (7))){
var inst_21654 = (state_21658[(2)]);
var state_21658__$1 = state_21658;
var statearr_21660_21693 = state_21658__$1;
(statearr_21660_21693[(2)] = inst_21654);

(statearr_21660_21693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (1))){
var inst_21617 = [];
var inst_21618 = inst_21617;
var inst_21619 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21658__$1 = (function (){var statearr_21661 = state_21658;
(statearr_21661[(7)] = inst_21618);

(statearr_21661[(8)] = inst_21619);

return statearr_21661;
})();
var statearr_21662_21694 = state_21658__$1;
(statearr_21662_21694[(2)] = null);

(statearr_21662_21694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (4))){
var inst_21622 = (state_21658[(9)]);
var inst_21622__$1 = (state_21658[(2)]);
var inst_21623 = (inst_21622__$1 == null);
var inst_21624 = cljs.core.not.call(null,inst_21623);
var state_21658__$1 = (function (){var statearr_21663 = state_21658;
(statearr_21663[(9)] = inst_21622__$1);

return statearr_21663;
})();
if(inst_21624){
var statearr_21664_21695 = state_21658__$1;
(statearr_21664_21695[(1)] = (5));

} else {
var statearr_21665_21696 = state_21658__$1;
(statearr_21665_21696[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (15))){
var inst_21648 = (state_21658[(2)]);
var state_21658__$1 = state_21658;
var statearr_21666_21697 = state_21658__$1;
(statearr_21666_21697[(2)] = inst_21648);

(statearr_21666_21697[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (13))){
var state_21658__$1 = state_21658;
var statearr_21667_21698 = state_21658__$1;
(statearr_21667_21698[(2)] = null);

(statearr_21667_21698[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (6))){
var inst_21618 = (state_21658[(7)]);
var inst_21643 = inst_21618.length;
var inst_21644 = (inst_21643 > (0));
var state_21658__$1 = state_21658;
if(cljs.core.truth_(inst_21644)){
var statearr_21668_21699 = state_21658__$1;
(statearr_21668_21699[(1)] = (12));

} else {
var statearr_21669_21700 = state_21658__$1;
(statearr_21669_21700[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (3))){
var inst_21656 = (state_21658[(2)]);
var state_21658__$1 = state_21658;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21658__$1,inst_21656);
} else {
if((state_val_21659 === (12))){
var inst_21618 = (state_21658[(7)]);
var inst_21646 = cljs.core.vec.call(null,inst_21618);
var state_21658__$1 = state_21658;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21658__$1,(15),out,inst_21646);
} else {
if((state_val_21659 === (2))){
var state_21658__$1 = state_21658;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21658__$1,(4),ch);
} else {
if((state_val_21659 === (11))){
var inst_21622 = (state_21658[(9)]);
var inst_21626 = (state_21658[(10)]);
var inst_21636 = (state_21658[(2)]);
var inst_21637 = [];
var inst_21638 = inst_21637.push(inst_21622);
var inst_21618 = inst_21637;
var inst_21619 = inst_21626;
var state_21658__$1 = (function (){var statearr_21670 = state_21658;
(statearr_21670[(11)] = inst_21636);

(statearr_21670[(7)] = inst_21618);

(statearr_21670[(12)] = inst_21638);

(statearr_21670[(8)] = inst_21619);

return statearr_21670;
})();
var statearr_21671_21701 = state_21658__$1;
(statearr_21671_21701[(2)] = null);

(statearr_21671_21701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (9))){
var inst_21618 = (state_21658[(7)]);
var inst_21634 = cljs.core.vec.call(null,inst_21618);
var state_21658__$1 = state_21658;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21658__$1,(11),out,inst_21634);
} else {
if((state_val_21659 === (5))){
var inst_21619 = (state_21658[(8)]);
var inst_21622 = (state_21658[(9)]);
var inst_21626 = (state_21658[(10)]);
var inst_21626__$1 = f.call(null,inst_21622);
var inst_21627 = cljs.core._EQ_.call(null,inst_21626__$1,inst_21619);
var inst_21628 = cljs.core.keyword_identical_QMARK_.call(null,inst_21619,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21629 = (inst_21627) || (inst_21628);
var state_21658__$1 = (function (){var statearr_21672 = state_21658;
(statearr_21672[(10)] = inst_21626__$1);

return statearr_21672;
})();
if(cljs.core.truth_(inst_21629)){
var statearr_21673_21702 = state_21658__$1;
(statearr_21673_21702[(1)] = (8));

} else {
var statearr_21674_21703 = state_21658__$1;
(statearr_21674_21703[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (14))){
var inst_21651 = (state_21658[(2)]);
var inst_21652 = cljs.core.async.close_BANG_.call(null,out);
var state_21658__$1 = (function (){var statearr_21676 = state_21658;
(statearr_21676[(13)] = inst_21651);

return statearr_21676;
})();
var statearr_21677_21704 = state_21658__$1;
(statearr_21677_21704[(2)] = inst_21652);

(statearr_21677_21704[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (10))){
var inst_21641 = (state_21658[(2)]);
var state_21658__$1 = state_21658;
var statearr_21678_21705 = state_21658__$1;
(statearr_21678_21705[(2)] = inst_21641);

(statearr_21678_21705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21659 === (8))){
var inst_21618 = (state_21658[(7)]);
var inst_21622 = (state_21658[(9)]);
var inst_21626 = (state_21658[(10)]);
var inst_21631 = inst_21618.push(inst_21622);
var tmp21675 = inst_21618;
var inst_21618__$1 = tmp21675;
var inst_21619 = inst_21626;
var state_21658__$1 = (function (){var statearr_21679 = state_21658;
(statearr_21679[(14)] = inst_21631);

(statearr_21679[(7)] = inst_21618__$1);

(statearr_21679[(8)] = inst_21619);

return statearr_21679;
})();
var statearr_21680_21706 = state_21658__$1;
(statearr_21680_21706[(2)] = null);

(statearr_21680_21706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___21692,out))
;
return ((function (switch__10961__auto__,c__11073__auto___21692,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_21684 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21684[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_21684[(1)] = (1));

return statearr_21684;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_21658){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_21658);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e21685){if((e21685 instanceof Object)){
var ex__10965__auto__ = e21685;
var statearr_21686_21707 = state_21658;
(statearr_21686_21707[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21658);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21685;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21708 = state_21658;
state_21658 = G__21708;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_21658){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_21658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___21692,out))
})();
var state__11075__auto__ = (function (){var statearr_21687 = f__11074__auto__.call(null);
(statearr_21687[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___21692);

return statearr_21687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___21692,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1461071313700