// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17343 = [];
var len__5726__auto___17349 = arguments.length;
var i__5727__auto___17350 = (0);
while(true){
if((i__5727__auto___17350 < len__5726__auto___17349)){
args17343.push((arguments[i__5727__auto___17350]));

var G__17351 = (i__5727__auto___17350 + (1));
i__5727__auto___17350 = G__17351;
continue;
} else {
}
break;
}

var G__17345 = args17343.length;
switch (G__17345) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17343.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17346 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17346 = (function (f,blockable,meta17347){
this.f = f;
this.blockable = blockable;
this.meta17347 = meta17347;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17346.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17348,meta17347__$1){
var self__ = this;
var _17348__$1 = this;
return (new cljs.core.async.t_cljs$core$async17346(self__.f,self__.blockable,meta17347__$1));
});

cljs.core.async.t_cljs$core$async17346.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17348){
var self__ = this;
var _17348__$1 = this;
return self__.meta17347;
});

cljs.core.async.t_cljs$core$async17346.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17346.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17346.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17346.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17346.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17347","meta17347",-1714160821,null)], null);
});

cljs.core.async.t_cljs$core$async17346.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17346.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17346";

cljs.core.async.t_cljs$core$async17346.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17346");
});

cljs.core.async.__GT_t_cljs$core$async17346 = (function cljs$core$async$__GT_t_cljs$core$async17346(f__$1,blockable__$1,meta17347){
return (new cljs.core.async.t_cljs$core$async17346(f__$1,blockable__$1,meta17347));
});

}

return (new cljs.core.async.t_cljs$core$async17346(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17355 = [];
var len__5726__auto___17358 = arguments.length;
var i__5727__auto___17359 = (0);
while(true){
if((i__5727__auto___17359 < len__5726__auto___17358)){
args17355.push((arguments[i__5727__auto___17359]));

var G__17360 = (i__5727__auto___17359 + (1));
i__5727__auto___17359 = G__17360;
continue;
} else {
}
break;
}

var G__17357 = args17355.length;
switch (G__17357) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17355.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17362 = [];
var len__5726__auto___17365 = arguments.length;
var i__5727__auto___17366 = (0);
while(true){
if((i__5727__auto___17366 < len__5726__auto___17365)){
args17362.push((arguments[i__5727__auto___17366]));

var G__17367 = (i__5727__auto___17366 + (1));
i__5727__auto___17366 = G__17367;
continue;
} else {
}
break;
}

var G__17364 = args17362.length;
switch (G__17364) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17362.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17369 = [];
var len__5726__auto___17372 = arguments.length;
var i__5727__auto___17373 = (0);
while(true){
if((i__5727__auto___17373 < len__5726__auto___17372)){
args17369.push((arguments[i__5727__auto___17373]));

var G__17374 = (i__5727__auto___17373 + (1));
i__5727__auto___17373 = G__17374;
continue;
} else {
}
break;
}

var G__17371 = args17369.length;
switch (G__17371) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17369.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17376 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17376);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17376,ret){
return (function (){
return fn1.call(null,val_17376);
});})(val_17376,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17377 = [];
var len__5726__auto___17380 = arguments.length;
var i__5727__auto___17381 = (0);
while(true){
if((i__5727__auto___17381 < len__5726__auto___17380)){
args17377.push((arguments[i__5727__auto___17381]));

var G__17382 = (i__5727__auto___17381 + (1));
i__5727__auto___17381 = G__17382;
continue;
} else {
}
break;
}

var G__17379 = args17377.length;
switch (G__17379) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17377.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17384 = n;
var x_17385 = (0);
while(true){
if((x_17385 < n__5571__auto___17384)){
(a[x_17385] = (0));

var G__17386 = (x_17385 + (1));
x_17385 = G__17386;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17387 = (i + (1));
i = G__17387;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17391 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17391 = (function (alt_flag,flag,meta17392){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17392 = meta17392;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17391.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17393,meta17392__$1){
var self__ = this;
var _17393__$1 = this;
return (new cljs.core.async.t_cljs$core$async17391(self__.alt_flag,self__.flag,meta17392__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17391.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17393){
var self__ = this;
var _17393__$1 = this;
return self__.meta17392;
});})(flag))
;

cljs.core.async.t_cljs$core$async17391.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17391.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17391.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17391.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17391.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17392","meta17392",-1407053245,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17391.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17391.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17391";

cljs.core.async.t_cljs$core$async17391.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17391");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17391 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17391(alt_flag__$1,flag__$1,meta17392){
return (new cljs.core.async.t_cljs$core$async17391(alt_flag__$1,flag__$1,meta17392));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17391(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17397 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17397 = (function (alt_handler,flag,cb,meta17398){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17398 = meta17398;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17397.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17399,meta17398__$1){
var self__ = this;
var _17399__$1 = this;
return (new cljs.core.async.t_cljs$core$async17397(self__.alt_handler,self__.flag,self__.cb,meta17398__$1));
});

cljs.core.async.t_cljs$core$async17397.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17399){
var self__ = this;
var _17399__$1 = this;
return self__.meta17398;
});

cljs.core.async.t_cljs$core$async17397.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17397.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17397.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17397.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17397.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17398","meta17398",716243007,null)], null);
});

cljs.core.async.t_cljs$core$async17397.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17397.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17397";

cljs.core.async.t_cljs$core$async17397.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17397");
});

cljs.core.async.__GT_t_cljs$core$async17397 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17397(alt_handler__$1,flag__$1,cb__$1,meta17398){
return (new cljs.core.async.t_cljs$core$async17397(alt_handler__$1,flag__$1,cb__$1,meta17398));
});

}

return (new cljs.core.async.t_cljs$core$async17397(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17400_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17400_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17401_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17401_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17402 = (i + (1));
i = G__17402;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17408 = arguments.length;
var i__5727__auto___17409 = (0);
while(true){
if((i__5727__auto___17409 < len__5726__auto___17408)){
args__5733__auto__.push((arguments[i__5727__auto___17409]));

var G__17410 = (i__5727__auto___17409 + (1));
i__5727__auto___17409 = G__17410;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17405){
var map__17406 = p__17405;
var map__17406__$1 = ((((!((map__17406 == null)))?((((map__17406.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17406.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17406):map__17406);
var opts = map__17406__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17403){
var G__17404 = cljs.core.first.call(null,seq17403);
var seq17403__$1 = cljs.core.next.call(null,seq17403);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17404,seq17403__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17411 = [];
var len__5726__auto___17461 = arguments.length;
var i__5727__auto___17462 = (0);
while(true){
if((i__5727__auto___17462 < len__5726__auto___17461)){
args17411.push((arguments[i__5727__auto___17462]));

var G__17463 = (i__5727__auto___17462 + (1));
i__5727__auto___17462 = G__17463;
continue;
} else {
}
break;
}

var G__17413 = args17411.length;
switch (G__17413) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17411.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17465 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17465){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17465){
return (function (state_17437){
var state_val_17438 = (state_17437[(1)]);
if((state_val_17438 === (7))){
var inst_17433 = (state_17437[(2)]);
var state_17437__$1 = state_17437;
var statearr_17439_17466 = state_17437__$1;
(statearr_17439_17466[(2)] = inst_17433);

(statearr_17439_17466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (1))){
var state_17437__$1 = state_17437;
var statearr_17440_17467 = state_17437__$1;
(statearr_17440_17467[(2)] = null);

(statearr_17440_17467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (4))){
var inst_17416 = (state_17437[(7)]);
var inst_17416__$1 = (state_17437[(2)]);
var inst_17417 = (inst_17416__$1 == null);
var state_17437__$1 = (function (){var statearr_17441 = state_17437;
(statearr_17441[(7)] = inst_17416__$1);

return statearr_17441;
})();
if(cljs.core.truth_(inst_17417)){
var statearr_17442_17468 = state_17437__$1;
(statearr_17442_17468[(1)] = (5));

} else {
var statearr_17443_17469 = state_17437__$1;
(statearr_17443_17469[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (13))){
var state_17437__$1 = state_17437;
var statearr_17444_17470 = state_17437__$1;
(statearr_17444_17470[(2)] = null);

(statearr_17444_17470[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (6))){
var inst_17416 = (state_17437[(7)]);
var state_17437__$1 = state_17437;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17437__$1,(11),to,inst_17416);
} else {
if((state_val_17438 === (3))){
var inst_17435 = (state_17437[(2)]);
var state_17437__$1 = state_17437;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17437__$1,inst_17435);
} else {
if((state_val_17438 === (12))){
var state_17437__$1 = state_17437;
var statearr_17445_17471 = state_17437__$1;
(statearr_17445_17471[(2)] = null);

(statearr_17445_17471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (2))){
var state_17437__$1 = state_17437;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17437__$1,(4),from);
} else {
if((state_val_17438 === (11))){
var inst_17426 = (state_17437[(2)]);
var state_17437__$1 = state_17437;
if(cljs.core.truth_(inst_17426)){
var statearr_17446_17472 = state_17437__$1;
(statearr_17446_17472[(1)] = (12));

} else {
var statearr_17447_17473 = state_17437__$1;
(statearr_17447_17473[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (9))){
var state_17437__$1 = state_17437;
var statearr_17448_17474 = state_17437__$1;
(statearr_17448_17474[(2)] = null);

(statearr_17448_17474[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (5))){
var state_17437__$1 = state_17437;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17449_17475 = state_17437__$1;
(statearr_17449_17475[(1)] = (8));

} else {
var statearr_17450_17476 = state_17437__$1;
(statearr_17450_17476[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (14))){
var inst_17431 = (state_17437[(2)]);
var state_17437__$1 = state_17437;
var statearr_17451_17477 = state_17437__$1;
(statearr_17451_17477[(2)] = inst_17431);

(statearr_17451_17477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (10))){
var inst_17423 = (state_17437[(2)]);
var state_17437__$1 = state_17437;
var statearr_17452_17478 = state_17437__$1;
(statearr_17452_17478[(2)] = inst_17423);

(statearr_17452_17478[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (8))){
var inst_17420 = cljs.core.async.close_BANG_.call(null,to);
var state_17437__$1 = state_17437;
var statearr_17453_17479 = state_17437__$1;
(statearr_17453_17479[(2)] = inst_17420);

(statearr_17453_17479[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17465))
;
return ((function (switch__8250__auto__,c__8362__auto___17465){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17457 = [null,null,null,null,null,null,null,null];
(statearr_17457[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17457[(1)] = (1));

return statearr_17457;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17437){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17437);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17458){if((e17458 instanceof Object)){
var ex__8254__auto__ = e17458;
var statearr_17459_17480 = state_17437;
(statearr_17459_17480[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17437);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17458;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17481 = state_17437;
state_17437 = G__17481;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17437){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17465))
})();
var state__8364__auto__ = (function (){var statearr_17460 = f__8363__auto__.call(null);
(statearr_17460[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17465);

return statearr_17460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17465))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17665){
var vec__17666 = p__17665;
var v = cljs.core.nth.call(null,vec__17666,(0),null);
var p = cljs.core.nth.call(null,vec__17666,(1),null);
var job = vec__17666;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17848 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17848,res,vec__17666,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17848,res,vec__17666,v,p,job,jobs,results){
return (function (state_17671){
var state_val_17672 = (state_17671[(1)]);
if((state_val_17672 === (1))){
var state_17671__$1 = state_17671;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17671__$1,(2),res,v);
} else {
if((state_val_17672 === (2))){
var inst_17668 = (state_17671[(2)]);
var inst_17669 = cljs.core.async.close_BANG_.call(null,res);
var state_17671__$1 = (function (){var statearr_17673 = state_17671;
(statearr_17673[(7)] = inst_17668);

return statearr_17673;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17671__$1,inst_17669);
} else {
return null;
}
}
});})(c__8362__auto___17848,res,vec__17666,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17848,res,vec__17666,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17677 = [null,null,null,null,null,null,null,null];
(statearr_17677[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17677[(1)] = (1));

return statearr_17677;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17671){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17678){if((e17678 instanceof Object)){
var ex__8254__auto__ = e17678;
var statearr_17679_17849 = state_17671;
(statearr_17679_17849[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17671);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17678;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17850 = state_17671;
state_17671 = G__17850;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17671){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17848,res,vec__17666,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17680 = f__8363__auto__.call(null);
(statearr_17680[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17848);

return statearr_17680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17848,res,vec__17666,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17681){
var vec__17682 = p__17681;
var v = cljs.core.nth.call(null,vec__17682,(0),null);
var p = cljs.core.nth.call(null,vec__17682,(1),null);
var job = vec__17682;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17851 = n;
var __17852 = (0);
while(true){
if((__17852 < n__5571__auto___17851)){
var G__17683_17853 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17683_17853) {
case "compute":
var c__8362__auto___17855 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17852,c__8362__auto___17855,G__17683_17853,n__5571__auto___17851,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17852,c__8362__auto___17855,G__17683_17853,n__5571__auto___17851,jobs,results,process,async){
return (function (state_17696){
var state_val_17697 = (state_17696[(1)]);
if((state_val_17697 === (1))){
var state_17696__$1 = state_17696;
var statearr_17698_17856 = state_17696__$1;
(statearr_17698_17856[(2)] = null);

(statearr_17698_17856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (2))){
var state_17696__$1 = state_17696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17696__$1,(4),jobs);
} else {
if((state_val_17697 === (3))){
var inst_17694 = (state_17696[(2)]);
var state_17696__$1 = state_17696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17696__$1,inst_17694);
} else {
if((state_val_17697 === (4))){
var inst_17686 = (state_17696[(2)]);
var inst_17687 = process.call(null,inst_17686);
var state_17696__$1 = state_17696;
if(cljs.core.truth_(inst_17687)){
var statearr_17699_17857 = state_17696__$1;
(statearr_17699_17857[(1)] = (5));

} else {
var statearr_17700_17858 = state_17696__$1;
(statearr_17700_17858[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (5))){
var state_17696__$1 = state_17696;
var statearr_17701_17859 = state_17696__$1;
(statearr_17701_17859[(2)] = null);

(statearr_17701_17859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (6))){
var state_17696__$1 = state_17696;
var statearr_17702_17860 = state_17696__$1;
(statearr_17702_17860[(2)] = null);

(statearr_17702_17860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (7))){
var inst_17692 = (state_17696[(2)]);
var state_17696__$1 = state_17696;
var statearr_17703_17861 = state_17696__$1;
(statearr_17703_17861[(2)] = inst_17692);

(statearr_17703_17861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17852,c__8362__auto___17855,G__17683_17853,n__5571__auto___17851,jobs,results,process,async))
;
return ((function (__17852,switch__8250__auto__,c__8362__auto___17855,G__17683_17853,n__5571__auto___17851,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17707 = [null,null,null,null,null,null,null];
(statearr_17707[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17707[(1)] = (1));

return statearr_17707;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17696){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17708){if((e17708 instanceof Object)){
var ex__8254__auto__ = e17708;
var statearr_17709_17862 = state_17696;
(statearr_17709_17862[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17696);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17863 = state_17696;
state_17696 = G__17863;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17696){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17852,switch__8250__auto__,c__8362__auto___17855,G__17683_17853,n__5571__auto___17851,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17710 = f__8363__auto__.call(null);
(statearr_17710[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17855);

return statearr_17710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17852,c__8362__auto___17855,G__17683_17853,n__5571__auto___17851,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17864 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17852,c__8362__auto___17864,G__17683_17853,n__5571__auto___17851,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17852,c__8362__auto___17864,G__17683_17853,n__5571__auto___17851,jobs,results,process,async){
return (function (state_17723){
var state_val_17724 = (state_17723[(1)]);
if((state_val_17724 === (1))){
var state_17723__$1 = state_17723;
var statearr_17725_17865 = state_17723__$1;
(statearr_17725_17865[(2)] = null);

(statearr_17725_17865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17724 === (2))){
var state_17723__$1 = state_17723;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17723__$1,(4),jobs);
} else {
if((state_val_17724 === (3))){
var inst_17721 = (state_17723[(2)]);
var state_17723__$1 = state_17723;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17723__$1,inst_17721);
} else {
if((state_val_17724 === (4))){
var inst_17713 = (state_17723[(2)]);
var inst_17714 = async.call(null,inst_17713);
var state_17723__$1 = state_17723;
if(cljs.core.truth_(inst_17714)){
var statearr_17726_17866 = state_17723__$1;
(statearr_17726_17866[(1)] = (5));

} else {
var statearr_17727_17867 = state_17723__$1;
(statearr_17727_17867[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17724 === (5))){
var state_17723__$1 = state_17723;
var statearr_17728_17868 = state_17723__$1;
(statearr_17728_17868[(2)] = null);

(statearr_17728_17868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17724 === (6))){
var state_17723__$1 = state_17723;
var statearr_17729_17869 = state_17723__$1;
(statearr_17729_17869[(2)] = null);

(statearr_17729_17869[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17724 === (7))){
var inst_17719 = (state_17723[(2)]);
var state_17723__$1 = state_17723;
var statearr_17730_17870 = state_17723__$1;
(statearr_17730_17870[(2)] = inst_17719);

(statearr_17730_17870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17852,c__8362__auto___17864,G__17683_17853,n__5571__auto___17851,jobs,results,process,async))
;
return ((function (__17852,switch__8250__auto__,c__8362__auto___17864,G__17683_17853,n__5571__auto___17851,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17734 = [null,null,null,null,null,null,null];
(statearr_17734[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17734[(1)] = (1));

return statearr_17734;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17723){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17735){if((e17735 instanceof Object)){
var ex__8254__auto__ = e17735;
var statearr_17736_17871 = state_17723;
(statearr_17736_17871[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17723);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17735;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17872 = state_17723;
state_17723 = G__17872;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17723){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17852,switch__8250__auto__,c__8362__auto___17864,G__17683_17853,n__5571__auto___17851,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17737 = f__8363__auto__.call(null);
(statearr_17737[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17864);

return statearr_17737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17852,c__8362__auto___17864,G__17683_17853,n__5571__auto___17851,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17873 = (__17852 + (1));
__17852 = G__17873;
continue;
} else {
}
break;
}

var c__8362__auto___17874 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17874,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17874,jobs,results,process,async){
return (function (state_17759){
var state_val_17760 = (state_17759[(1)]);
if((state_val_17760 === (1))){
var state_17759__$1 = state_17759;
var statearr_17761_17875 = state_17759__$1;
(statearr_17761_17875[(2)] = null);

(statearr_17761_17875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17760 === (2))){
var state_17759__$1 = state_17759;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17759__$1,(4),from);
} else {
if((state_val_17760 === (3))){
var inst_17757 = (state_17759[(2)]);
var state_17759__$1 = state_17759;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17759__$1,inst_17757);
} else {
if((state_val_17760 === (4))){
var inst_17740 = (state_17759[(7)]);
var inst_17740__$1 = (state_17759[(2)]);
var inst_17741 = (inst_17740__$1 == null);
var state_17759__$1 = (function (){var statearr_17762 = state_17759;
(statearr_17762[(7)] = inst_17740__$1);

return statearr_17762;
})();
if(cljs.core.truth_(inst_17741)){
var statearr_17763_17876 = state_17759__$1;
(statearr_17763_17876[(1)] = (5));

} else {
var statearr_17764_17877 = state_17759__$1;
(statearr_17764_17877[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17760 === (5))){
var inst_17743 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17759__$1 = state_17759;
var statearr_17765_17878 = state_17759__$1;
(statearr_17765_17878[(2)] = inst_17743);

(statearr_17765_17878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17760 === (6))){
var inst_17745 = (state_17759[(8)]);
var inst_17740 = (state_17759[(7)]);
var inst_17745__$1 = cljs.core.async.chan.call(null,(1));
var inst_17746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17747 = [inst_17740,inst_17745__$1];
var inst_17748 = (new cljs.core.PersistentVector(null,2,(5),inst_17746,inst_17747,null));
var state_17759__$1 = (function (){var statearr_17766 = state_17759;
(statearr_17766[(8)] = inst_17745__$1);

return statearr_17766;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17759__$1,(8),jobs,inst_17748);
} else {
if((state_val_17760 === (7))){
var inst_17755 = (state_17759[(2)]);
var state_17759__$1 = state_17759;
var statearr_17767_17879 = state_17759__$1;
(statearr_17767_17879[(2)] = inst_17755);

(statearr_17767_17879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17760 === (8))){
var inst_17745 = (state_17759[(8)]);
var inst_17750 = (state_17759[(2)]);
var state_17759__$1 = (function (){var statearr_17768 = state_17759;
(statearr_17768[(9)] = inst_17750);

return statearr_17768;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17759__$1,(9),results,inst_17745);
} else {
if((state_val_17760 === (9))){
var inst_17752 = (state_17759[(2)]);
var state_17759__$1 = (function (){var statearr_17769 = state_17759;
(statearr_17769[(10)] = inst_17752);

return statearr_17769;
})();
var statearr_17770_17880 = state_17759__$1;
(statearr_17770_17880[(2)] = null);

(statearr_17770_17880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17874,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17874,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17774 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17774[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17774[(1)] = (1));

return statearr_17774;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17759){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17759);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17775){if((e17775 instanceof Object)){
var ex__8254__auto__ = e17775;
var statearr_17776_17881 = state_17759;
(statearr_17776_17881[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17759);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17775;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17882 = state_17759;
state_17759 = G__17882;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17759){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17874,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17777 = f__8363__auto__.call(null);
(statearr_17777[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17874);

return statearr_17777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17874,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17815){
var state_val_17816 = (state_17815[(1)]);
if((state_val_17816 === (7))){
var inst_17811 = (state_17815[(2)]);
var state_17815__$1 = state_17815;
var statearr_17817_17883 = state_17815__$1;
(statearr_17817_17883[(2)] = inst_17811);

(statearr_17817_17883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (20))){
var state_17815__$1 = state_17815;
var statearr_17818_17884 = state_17815__$1;
(statearr_17818_17884[(2)] = null);

(statearr_17818_17884[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (1))){
var state_17815__$1 = state_17815;
var statearr_17819_17885 = state_17815__$1;
(statearr_17819_17885[(2)] = null);

(statearr_17819_17885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (4))){
var inst_17780 = (state_17815[(7)]);
var inst_17780__$1 = (state_17815[(2)]);
var inst_17781 = (inst_17780__$1 == null);
var state_17815__$1 = (function (){var statearr_17820 = state_17815;
(statearr_17820[(7)] = inst_17780__$1);

return statearr_17820;
})();
if(cljs.core.truth_(inst_17781)){
var statearr_17821_17886 = state_17815__$1;
(statearr_17821_17886[(1)] = (5));

} else {
var statearr_17822_17887 = state_17815__$1;
(statearr_17822_17887[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (15))){
var inst_17793 = (state_17815[(8)]);
var state_17815__$1 = state_17815;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17815__$1,(18),to,inst_17793);
} else {
if((state_val_17816 === (21))){
var inst_17806 = (state_17815[(2)]);
var state_17815__$1 = state_17815;
var statearr_17823_17888 = state_17815__$1;
(statearr_17823_17888[(2)] = inst_17806);

(statearr_17823_17888[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (13))){
var inst_17808 = (state_17815[(2)]);
var state_17815__$1 = (function (){var statearr_17824 = state_17815;
(statearr_17824[(9)] = inst_17808);

return statearr_17824;
})();
var statearr_17825_17889 = state_17815__$1;
(statearr_17825_17889[(2)] = null);

(statearr_17825_17889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (6))){
var inst_17780 = (state_17815[(7)]);
var state_17815__$1 = state_17815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17815__$1,(11),inst_17780);
} else {
if((state_val_17816 === (17))){
var inst_17801 = (state_17815[(2)]);
var state_17815__$1 = state_17815;
if(cljs.core.truth_(inst_17801)){
var statearr_17826_17890 = state_17815__$1;
(statearr_17826_17890[(1)] = (19));

} else {
var statearr_17827_17891 = state_17815__$1;
(statearr_17827_17891[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (3))){
var inst_17813 = (state_17815[(2)]);
var state_17815__$1 = state_17815;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17815__$1,inst_17813);
} else {
if((state_val_17816 === (12))){
var inst_17790 = (state_17815[(10)]);
var state_17815__$1 = state_17815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17815__$1,(14),inst_17790);
} else {
if((state_val_17816 === (2))){
var state_17815__$1 = state_17815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17815__$1,(4),results);
} else {
if((state_val_17816 === (19))){
var state_17815__$1 = state_17815;
var statearr_17828_17892 = state_17815__$1;
(statearr_17828_17892[(2)] = null);

(statearr_17828_17892[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (11))){
var inst_17790 = (state_17815[(2)]);
var state_17815__$1 = (function (){var statearr_17829 = state_17815;
(statearr_17829[(10)] = inst_17790);

return statearr_17829;
})();
var statearr_17830_17893 = state_17815__$1;
(statearr_17830_17893[(2)] = null);

(statearr_17830_17893[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (9))){
var state_17815__$1 = state_17815;
var statearr_17831_17894 = state_17815__$1;
(statearr_17831_17894[(2)] = null);

(statearr_17831_17894[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (5))){
var state_17815__$1 = state_17815;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17832_17895 = state_17815__$1;
(statearr_17832_17895[(1)] = (8));

} else {
var statearr_17833_17896 = state_17815__$1;
(statearr_17833_17896[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (14))){
var inst_17793 = (state_17815[(8)]);
var inst_17795 = (state_17815[(11)]);
var inst_17793__$1 = (state_17815[(2)]);
var inst_17794 = (inst_17793__$1 == null);
var inst_17795__$1 = cljs.core.not.call(null,inst_17794);
var state_17815__$1 = (function (){var statearr_17834 = state_17815;
(statearr_17834[(8)] = inst_17793__$1);

(statearr_17834[(11)] = inst_17795__$1);

return statearr_17834;
})();
if(inst_17795__$1){
var statearr_17835_17897 = state_17815__$1;
(statearr_17835_17897[(1)] = (15));

} else {
var statearr_17836_17898 = state_17815__$1;
(statearr_17836_17898[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (16))){
var inst_17795 = (state_17815[(11)]);
var state_17815__$1 = state_17815;
var statearr_17837_17899 = state_17815__$1;
(statearr_17837_17899[(2)] = inst_17795);

(statearr_17837_17899[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (10))){
var inst_17787 = (state_17815[(2)]);
var state_17815__$1 = state_17815;
var statearr_17838_17900 = state_17815__$1;
(statearr_17838_17900[(2)] = inst_17787);

(statearr_17838_17900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (18))){
var inst_17798 = (state_17815[(2)]);
var state_17815__$1 = state_17815;
var statearr_17839_17901 = state_17815__$1;
(statearr_17839_17901[(2)] = inst_17798);

(statearr_17839_17901[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17816 === (8))){
var inst_17784 = cljs.core.async.close_BANG_.call(null,to);
var state_17815__$1 = state_17815;
var statearr_17840_17902 = state_17815__$1;
(statearr_17840_17902[(2)] = inst_17784);

(statearr_17840_17902[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17844 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17844[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17844[(1)] = (1));

return statearr_17844;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17815){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17845){if((e17845 instanceof Object)){
var ex__8254__auto__ = e17845;
var statearr_17846_17903 = state_17815;
(statearr_17846_17903[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17815);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17845;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17904 = state_17815;
state_17815 = G__17904;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17815){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17847 = f__8363__auto__.call(null);
(statearr_17847[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17905 = [];
var len__5726__auto___17908 = arguments.length;
var i__5727__auto___17909 = (0);
while(true){
if((i__5727__auto___17909 < len__5726__auto___17908)){
args17905.push((arguments[i__5727__auto___17909]));

var G__17910 = (i__5727__auto___17909 + (1));
i__5727__auto___17909 = G__17910;
continue;
} else {
}
break;
}

var G__17907 = args17905.length;
switch (G__17907) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17905.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17912 = [];
var len__5726__auto___17915 = arguments.length;
var i__5727__auto___17916 = (0);
while(true){
if((i__5727__auto___17916 < len__5726__auto___17915)){
args17912.push((arguments[i__5727__auto___17916]));

var G__17917 = (i__5727__auto___17916 + (1));
i__5727__auto___17916 = G__17917;
continue;
} else {
}
break;
}

var G__17914 = args17912.length;
switch (G__17914) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17912.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17919 = [];
var len__5726__auto___17972 = arguments.length;
var i__5727__auto___17973 = (0);
while(true){
if((i__5727__auto___17973 < len__5726__auto___17972)){
args17919.push((arguments[i__5727__auto___17973]));

var G__17974 = (i__5727__auto___17973 + (1));
i__5727__auto___17973 = G__17974;
continue;
} else {
}
break;
}

var G__17921 = args17919.length;
switch (G__17921) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17919.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17976 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17976,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17976,tc,fc){
return (function (state_17947){
var state_val_17948 = (state_17947[(1)]);
if((state_val_17948 === (7))){
var inst_17943 = (state_17947[(2)]);
var state_17947__$1 = state_17947;
var statearr_17949_17977 = state_17947__$1;
(statearr_17949_17977[(2)] = inst_17943);

(statearr_17949_17977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (1))){
var state_17947__$1 = state_17947;
var statearr_17950_17978 = state_17947__$1;
(statearr_17950_17978[(2)] = null);

(statearr_17950_17978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (4))){
var inst_17924 = (state_17947[(7)]);
var inst_17924__$1 = (state_17947[(2)]);
var inst_17925 = (inst_17924__$1 == null);
var state_17947__$1 = (function (){var statearr_17951 = state_17947;
(statearr_17951[(7)] = inst_17924__$1);

return statearr_17951;
})();
if(cljs.core.truth_(inst_17925)){
var statearr_17952_17979 = state_17947__$1;
(statearr_17952_17979[(1)] = (5));

} else {
var statearr_17953_17980 = state_17947__$1;
(statearr_17953_17980[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (13))){
var state_17947__$1 = state_17947;
var statearr_17954_17981 = state_17947__$1;
(statearr_17954_17981[(2)] = null);

(statearr_17954_17981[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (6))){
var inst_17924 = (state_17947[(7)]);
var inst_17930 = p.call(null,inst_17924);
var state_17947__$1 = state_17947;
if(cljs.core.truth_(inst_17930)){
var statearr_17955_17982 = state_17947__$1;
(statearr_17955_17982[(1)] = (9));

} else {
var statearr_17956_17983 = state_17947__$1;
(statearr_17956_17983[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (3))){
var inst_17945 = (state_17947[(2)]);
var state_17947__$1 = state_17947;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17947__$1,inst_17945);
} else {
if((state_val_17948 === (12))){
var state_17947__$1 = state_17947;
var statearr_17957_17984 = state_17947__$1;
(statearr_17957_17984[(2)] = null);

(statearr_17957_17984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (2))){
var state_17947__$1 = state_17947;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17947__$1,(4),ch);
} else {
if((state_val_17948 === (11))){
var inst_17924 = (state_17947[(7)]);
var inst_17934 = (state_17947[(2)]);
var state_17947__$1 = state_17947;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17947__$1,(8),inst_17934,inst_17924);
} else {
if((state_val_17948 === (9))){
var state_17947__$1 = state_17947;
var statearr_17958_17985 = state_17947__$1;
(statearr_17958_17985[(2)] = tc);

(statearr_17958_17985[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (5))){
var inst_17927 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17928 = cljs.core.async.close_BANG_.call(null,fc);
var state_17947__$1 = (function (){var statearr_17959 = state_17947;
(statearr_17959[(8)] = inst_17927);

return statearr_17959;
})();
var statearr_17960_17986 = state_17947__$1;
(statearr_17960_17986[(2)] = inst_17928);

(statearr_17960_17986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (14))){
var inst_17941 = (state_17947[(2)]);
var state_17947__$1 = state_17947;
var statearr_17961_17987 = state_17947__$1;
(statearr_17961_17987[(2)] = inst_17941);

(statearr_17961_17987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (10))){
var state_17947__$1 = state_17947;
var statearr_17962_17988 = state_17947__$1;
(statearr_17962_17988[(2)] = fc);

(statearr_17962_17988[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17948 === (8))){
var inst_17936 = (state_17947[(2)]);
var state_17947__$1 = state_17947;
if(cljs.core.truth_(inst_17936)){
var statearr_17963_17989 = state_17947__$1;
(statearr_17963_17989[(1)] = (12));

} else {
var statearr_17964_17990 = state_17947__$1;
(statearr_17964_17990[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17976,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17976,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17968 = [null,null,null,null,null,null,null,null,null];
(statearr_17968[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17968[(1)] = (1));

return statearr_17968;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17947){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17947);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17969){if((e17969 instanceof Object)){
var ex__8254__auto__ = e17969;
var statearr_17970_17991 = state_17947;
(statearr_17970_17991[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17947);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17969;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17992 = state_17947;
state_17947 = G__17992;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17947){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17976,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17971 = f__8363__auto__.call(null);
(statearr_17971[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17976);

return statearr_17971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17976,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18056){
var state_val_18057 = (state_18056[(1)]);
if((state_val_18057 === (7))){
var inst_18052 = (state_18056[(2)]);
var state_18056__$1 = state_18056;
var statearr_18058_18079 = state_18056__$1;
(statearr_18058_18079[(2)] = inst_18052);

(statearr_18058_18079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18057 === (1))){
var inst_18036 = init;
var state_18056__$1 = (function (){var statearr_18059 = state_18056;
(statearr_18059[(7)] = inst_18036);

return statearr_18059;
})();
var statearr_18060_18080 = state_18056__$1;
(statearr_18060_18080[(2)] = null);

(statearr_18060_18080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18057 === (4))){
var inst_18039 = (state_18056[(8)]);
var inst_18039__$1 = (state_18056[(2)]);
var inst_18040 = (inst_18039__$1 == null);
var state_18056__$1 = (function (){var statearr_18061 = state_18056;
(statearr_18061[(8)] = inst_18039__$1);

return statearr_18061;
})();
if(cljs.core.truth_(inst_18040)){
var statearr_18062_18081 = state_18056__$1;
(statearr_18062_18081[(1)] = (5));

} else {
var statearr_18063_18082 = state_18056__$1;
(statearr_18063_18082[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18057 === (6))){
var inst_18043 = (state_18056[(9)]);
var inst_18039 = (state_18056[(8)]);
var inst_18036 = (state_18056[(7)]);
var inst_18043__$1 = f.call(null,inst_18036,inst_18039);
var inst_18044 = cljs.core.reduced_QMARK_.call(null,inst_18043__$1);
var state_18056__$1 = (function (){var statearr_18064 = state_18056;
(statearr_18064[(9)] = inst_18043__$1);

return statearr_18064;
})();
if(inst_18044){
var statearr_18065_18083 = state_18056__$1;
(statearr_18065_18083[(1)] = (8));

} else {
var statearr_18066_18084 = state_18056__$1;
(statearr_18066_18084[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18057 === (3))){
var inst_18054 = (state_18056[(2)]);
var state_18056__$1 = state_18056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18056__$1,inst_18054);
} else {
if((state_val_18057 === (2))){
var state_18056__$1 = state_18056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18056__$1,(4),ch);
} else {
if((state_val_18057 === (9))){
var inst_18043 = (state_18056[(9)]);
var inst_18036 = inst_18043;
var state_18056__$1 = (function (){var statearr_18067 = state_18056;
(statearr_18067[(7)] = inst_18036);

return statearr_18067;
})();
var statearr_18068_18085 = state_18056__$1;
(statearr_18068_18085[(2)] = null);

(statearr_18068_18085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18057 === (5))){
var inst_18036 = (state_18056[(7)]);
var state_18056__$1 = state_18056;
var statearr_18069_18086 = state_18056__$1;
(statearr_18069_18086[(2)] = inst_18036);

(statearr_18069_18086[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18057 === (10))){
var inst_18050 = (state_18056[(2)]);
var state_18056__$1 = state_18056;
var statearr_18070_18087 = state_18056__$1;
(statearr_18070_18087[(2)] = inst_18050);

(statearr_18070_18087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18057 === (8))){
var inst_18043 = (state_18056[(9)]);
var inst_18046 = cljs.core.deref.call(null,inst_18043);
var state_18056__$1 = state_18056;
var statearr_18071_18088 = state_18056__$1;
(statearr_18071_18088[(2)] = inst_18046);

(statearr_18071_18088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18075 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18075[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18075[(1)] = (1));

return statearr_18075;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18056){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18076){if((e18076 instanceof Object)){
var ex__8254__auto__ = e18076;
var statearr_18077_18089 = state_18056;
(statearr_18077_18089[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18056);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18076;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18090 = state_18056;
state_18056 = G__18090;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18056){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18078 = f__8363__auto__.call(null);
(statearr_18078[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18091 = [];
var len__5726__auto___18143 = arguments.length;
var i__5727__auto___18144 = (0);
while(true){
if((i__5727__auto___18144 < len__5726__auto___18143)){
args18091.push((arguments[i__5727__auto___18144]));

var G__18145 = (i__5727__auto___18144 + (1));
i__5727__auto___18144 = G__18145;
continue;
} else {
}
break;
}

var G__18093 = args18091.length;
switch (G__18093) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18091.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18118){
var state_val_18119 = (state_18118[(1)]);
if((state_val_18119 === (7))){
var inst_18100 = (state_18118[(2)]);
var state_18118__$1 = state_18118;
var statearr_18120_18147 = state_18118__$1;
(statearr_18120_18147[(2)] = inst_18100);

(statearr_18120_18147[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (1))){
var inst_18094 = cljs.core.seq.call(null,coll);
var inst_18095 = inst_18094;
var state_18118__$1 = (function (){var statearr_18121 = state_18118;
(statearr_18121[(7)] = inst_18095);

return statearr_18121;
})();
var statearr_18122_18148 = state_18118__$1;
(statearr_18122_18148[(2)] = null);

(statearr_18122_18148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (4))){
var inst_18095 = (state_18118[(7)]);
var inst_18098 = cljs.core.first.call(null,inst_18095);
var state_18118__$1 = state_18118;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18118__$1,(7),ch,inst_18098);
} else {
if((state_val_18119 === (13))){
var inst_18112 = (state_18118[(2)]);
var state_18118__$1 = state_18118;
var statearr_18123_18149 = state_18118__$1;
(statearr_18123_18149[(2)] = inst_18112);

(statearr_18123_18149[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (6))){
var inst_18103 = (state_18118[(2)]);
var state_18118__$1 = state_18118;
if(cljs.core.truth_(inst_18103)){
var statearr_18124_18150 = state_18118__$1;
(statearr_18124_18150[(1)] = (8));

} else {
var statearr_18125_18151 = state_18118__$1;
(statearr_18125_18151[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (3))){
var inst_18116 = (state_18118[(2)]);
var state_18118__$1 = state_18118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18118__$1,inst_18116);
} else {
if((state_val_18119 === (12))){
var state_18118__$1 = state_18118;
var statearr_18126_18152 = state_18118__$1;
(statearr_18126_18152[(2)] = null);

(statearr_18126_18152[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (2))){
var inst_18095 = (state_18118[(7)]);
var state_18118__$1 = state_18118;
if(cljs.core.truth_(inst_18095)){
var statearr_18127_18153 = state_18118__$1;
(statearr_18127_18153[(1)] = (4));

} else {
var statearr_18128_18154 = state_18118__$1;
(statearr_18128_18154[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (11))){
var inst_18109 = cljs.core.async.close_BANG_.call(null,ch);
var state_18118__$1 = state_18118;
var statearr_18129_18155 = state_18118__$1;
(statearr_18129_18155[(2)] = inst_18109);

(statearr_18129_18155[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (9))){
var state_18118__$1 = state_18118;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18130_18156 = state_18118__$1;
(statearr_18130_18156[(1)] = (11));

} else {
var statearr_18131_18157 = state_18118__$1;
(statearr_18131_18157[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (5))){
var inst_18095 = (state_18118[(7)]);
var state_18118__$1 = state_18118;
var statearr_18132_18158 = state_18118__$1;
(statearr_18132_18158[(2)] = inst_18095);

(statearr_18132_18158[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (10))){
var inst_18114 = (state_18118[(2)]);
var state_18118__$1 = state_18118;
var statearr_18133_18159 = state_18118__$1;
(statearr_18133_18159[(2)] = inst_18114);

(statearr_18133_18159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (8))){
var inst_18095 = (state_18118[(7)]);
var inst_18105 = cljs.core.next.call(null,inst_18095);
var inst_18095__$1 = inst_18105;
var state_18118__$1 = (function (){var statearr_18134 = state_18118;
(statearr_18134[(7)] = inst_18095__$1);

return statearr_18134;
})();
var statearr_18135_18160 = state_18118__$1;
(statearr_18135_18160[(2)] = null);

(statearr_18135_18160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18139 = [null,null,null,null,null,null,null,null];
(statearr_18139[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18139[(1)] = (1));

return statearr_18139;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18118){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18140){if((e18140 instanceof Object)){
var ex__8254__auto__ = e18140;
var statearr_18141_18161 = state_18118;
(statearr_18141_18161[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18118);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18140;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18162 = state_18118;
state_18118 = G__18162;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18118){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18142 = f__8363__auto__.call(null);
(statearr_18142[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18384 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18384 = (function (mult,ch,cs,meta18385){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18385 = meta18385;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18386,meta18385__$1){
var self__ = this;
var _18386__$1 = this;
return (new cljs.core.async.t_cljs$core$async18384(self__.mult,self__.ch,self__.cs,meta18385__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18386){
var self__ = this;
var _18386__$1 = this;
return self__.meta18385;
});})(cs))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18384.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18385","meta18385",1815232207,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18384.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18384.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18384";

cljs.core.async.t_cljs$core$async18384.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18384");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18384 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18384(mult__$1,ch__$1,cs__$1,meta18385){
return (new cljs.core.async.t_cljs$core$async18384(mult__$1,ch__$1,cs__$1,meta18385));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18384(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18605 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18605,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18605,cs,m,dchan,dctr,done){
return (function (state_18517){
var state_val_18518 = (state_18517[(1)]);
if((state_val_18518 === (7))){
var inst_18513 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18519_18606 = state_18517__$1;
(statearr_18519_18606[(2)] = inst_18513);

(statearr_18519_18606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (20))){
var inst_18418 = (state_18517[(7)]);
var inst_18428 = cljs.core.first.call(null,inst_18418);
var inst_18429 = cljs.core.nth.call(null,inst_18428,(0),null);
var inst_18430 = cljs.core.nth.call(null,inst_18428,(1),null);
var state_18517__$1 = (function (){var statearr_18520 = state_18517;
(statearr_18520[(8)] = inst_18429);

return statearr_18520;
})();
if(cljs.core.truth_(inst_18430)){
var statearr_18521_18607 = state_18517__$1;
(statearr_18521_18607[(1)] = (22));

} else {
var statearr_18522_18608 = state_18517__$1;
(statearr_18522_18608[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (27))){
var inst_18389 = (state_18517[(9)]);
var inst_18465 = (state_18517[(10)]);
var inst_18458 = (state_18517[(11)]);
var inst_18460 = (state_18517[(12)]);
var inst_18465__$1 = cljs.core._nth.call(null,inst_18458,inst_18460);
var inst_18466 = cljs.core.async.put_BANG_.call(null,inst_18465__$1,inst_18389,done);
var state_18517__$1 = (function (){var statearr_18523 = state_18517;
(statearr_18523[(10)] = inst_18465__$1);

return statearr_18523;
})();
if(cljs.core.truth_(inst_18466)){
var statearr_18524_18609 = state_18517__$1;
(statearr_18524_18609[(1)] = (30));

} else {
var statearr_18525_18610 = state_18517__$1;
(statearr_18525_18610[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (1))){
var state_18517__$1 = state_18517;
var statearr_18526_18611 = state_18517__$1;
(statearr_18526_18611[(2)] = null);

(statearr_18526_18611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (24))){
var inst_18418 = (state_18517[(7)]);
var inst_18435 = (state_18517[(2)]);
var inst_18436 = cljs.core.next.call(null,inst_18418);
var inst_18398 = inst_18436;
var inst_18399 = null;
var inst_18400 = (0);
var inst_18401 = (0);
var state_18517__$1 = (function (){var statearr_18527 = state_18517;
(statearr_18527[(13)] = inst_18401);

(statearr_18527[(14)] = inst_18398);

(statearr_18527[(15)] = inst_18400);

(statearr_18527[(16)] = inst_18435);

(statearr_18527[(17)] = inst_18399);

return statearr_18527;
})();
var statearr_18528_18612 = state_18517__$1;
(statearr_18528_18612[(2)] = null);

(statearr_18528_18612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (39))){
var state_18517__$1 = state_18517;
var statearr_18532_18613 = state_18517__$1;
(statearr_18532_18613[(2)] = null);

(statearr_18532_18613[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (4))){
var inst_18389 = (state_18517[(9)]);
var inst_18389__$1 = (state_18517[(2)]);
var inst_18390 = (inst_18389__$1 == null);
var state_18517__$1 = (function (){var statearr_18533 = state_18517;
(statearr_18533[(9)] = inst_18389__$1);

return statearr_18533;
})();
if(cljs.core.truth_(inst_18390)){
var statearr_18534_18614 = state_18517__$1;
(statearr_18534_18614[(1)] = (5));

} else {
var statearr_18535_18615 = state_18517__$1;
(statearr_18535_18615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (15))){
var inst_18401 = (state_18517[(13)]);
var inst_18398 = (state_18517[(14)]);
var inst_18400 = (state_18517[(15)]);
var inst_18399 = (state_18517[(17)]);
var inst_18414 = (state_18517[(2)]);
var inst_18415 = (inst_18401 + (1));
var tmp18529 = inst_18398;
var tmp18530 = inst_18400;
var tmp18531 = inst_18399;
var inst_18398__$1 = tmp18529;
var inst_18399__$1 = tmp18531;
var inst_18400__$1 = tmp18530;
var inst_18401__$1 = inst_18415;
var state_18517__$1 = (function (){var statearr_18536 = state_18517;
(statearr_18536[(13)] = inst_18401__$1);

(statearr_18536[(14)] = inst_18398__$1);

(statearr_18536[(18)] = inst_18414);

(statearr_18536[(15)] = inst_18400__$1);

(statearr_18536[(17)] = inst_18399__$1);

return statearr_18536;
})();
var statearr_18537_18616 = state_18517__$1;
(statearr_18537_18616[(2)] = null);

(statearr_18537_18616[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (21))){
var inst_18439 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18541_18617 = state_18517__$1;
(statearr_18541_18617[(2)] = inst_18439);

(statearr_18541_18617[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (31))){
var inst_18465 = (state_18517[(10)]);
var inst_18469 = done.call(null,null);
var inst_18470 = cljs.core.async.untap_STAR_.call(null,m,inst_18465);
var state_18517__$1 = (function (){var statearr_18542 = state_18517;
(statearr_18542[(19)] = inst_18469);

return statearr_18542;
})();
var statearr_18543_18618 = state_18517__$1;
(statearr_18543_18618[(2)] = inst_18470);

(statearr_18543_18618[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (32))){
var inst_18458 = (state_18517[(11)]);
var inst_18457 = (state_18517[(20)]);
var inst_18459 = (state_18517[(21)]);
var inst_18460 = (state_18517[(12)]);
var inst_18472 = (state_18517[(2)]);
var inst_18473 = (inst_18460 + (1));
var tmp18538 = inst_18458;
var tmp18539 = inst_18457;
var tmp18540 = inst_18459;
var inst_18457__$1 = tmp18539;
var inst_18458__$1 = tmp18538;
var inst_18459__$1 = tmp18540;
var inst_18460__$1 = inst_18473;
var state_18517__$1 = (function (){var statearr_18544 = state_18517;
(statearr_18544[(22)] = inst_18472);

(statearr_18544[(11)] = inst_18458__$1);

(statearr_18544[(20)] = inst_18457__$1);

(statearr_18544[(21)] = inst_18459__$1);

(statearr_18544[(12)] = inst_18460__$1);

return statearr_18544;
})();
var statearr_18545_18619 = state_18517__$1;
(statearr_18545_18619[(2)] = null);

(statearr_18545_18619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (40))){
var inst_18485 = (state_18517[(23)]);
var inst_18489 = done.call(null,null);
var inst_18490 = cljs.core.async.untap_STAR_.call(null,m,inst_18485);
var state_18517__$1 = (function (){var statearr_18546 = state_18517;
(statearr_18546[(24)] = inst_18489);

return statearr_18546;
})();
var statearr_18547_18620 = state_18517__$1;
(statearr_18547_18620[(2)] = inst_18490);

(statearr_18547_18620[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (33))){
var inst_18476 = (state_18517[(25)]);
var inst_18478 = cljs.core.chunked_seq_QMARK_.call(null,inst_18476);
var state_18517__$1 = state_18517;
if(inst_18478){
var statearr_18548_18621 = state_18517__$1;
(statearr_18548_18621[(1)] = (36));

} else {
var statearr_18549_18622 = state_18517__$1;
(statearr_18549_18622[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (13))){
var inst_18408 = (state_18517[(26)]);
var inst_18411 = cljs.core.async.close_BANG_.call(null,inst_18408);
var state_18517__$1 = state_18517;
var statearr_18550_18623 = state_18517__$1;
(statearr_18550_18623[(2)] = inst_18411);

(statearr_18550_18623[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (22))){
var inst_18429 = (state_18517[(8)]);
var inst_18432 = cljs.core.async.close_BANG_.call(null,inst_18429);
var state_18517__$1 = state_18517;
var statearr_18551_18624 = state_18517__$1;
(statearr_18551_18624[(2)] = inst_18432);

(statearr_18551_18624[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (36))){
var inst_18476 = (state_18517[(25)]);
var inst_18480 = cljs.core.chunk_first.call(null,inst_18476);
var inst_18481 = cljs.core.chunk_rest.call(null,inst_18476);
var inst_18482 = cljs.core.count.call(null,inst_18480);
var inst_18457 = inst_18481;
var inst_18458 = inst_18480;
var inst_18459 = inst_18482;
var inst_18460 = (0);
var state_18517__$1 = (function (){var statearr_18552 = state_18517;
(statearr_18552[(11)] = inst_18458);

(statearr_18552[(20)] = inst_18457);

(statearr_18552[(21)] = inst_18459);

(statearr_18552[(12)] = inst_18460);

return statearr_18552;
})();
var statearr_18553_18625 = state_18517__$1;
(statearr_18553_18625[(2)] = null);

(statearr_18553_18625[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (41))){
var inst_18476 = (state_18517[(25)]);
var inst_18492 = (state_18517[(2)]);
var inst_18493 = cljs.core.next.call(null,inst_18476);
var inst_18457 = inst_18493;
var inst_18458 = null;
var inst_18459 = (0);
var inst_18460 = (0);
var state_18517__$1 = (function (){var statearr_18554 = state_18517;
(statearr_18554[(27)] = inst_18492);

(statearr_18554[(11)] = inst_18458);

(statearr_18554[(20)] = inst_18457);

(statearr_18554[(21)] = inst_18459);

(statearr_18554[(12)] = inst_18460);

return statearr_18554;
})();
var statearr_18555_18626 = state_18517__$1;
(statearr_18555_18626[(2)] = null);

(statearr_18555_18626[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (43))){
var state_18517__$1 = state_18517;
var statearr_18556_18627 = state_18517__$1;
(statearr_18556_18627[(2)] = null);

(statearr_18556_18627[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (29))){
var inst_18501 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18557_18628 = state_18517__$1;
(statearr_18557_18628[(2)] = inst_18501);

(statearr_18557_18628[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (44))){
var inst_18510 = (state_18517[(2)]);
var state_18517__$1 = (function (){var statearr_18558 = state_18517;
(statearr_18558[(28)] = inst_18510);

return statearr_18558;
})();
var statearr_18559_18629 = state_18517__$1;
(statearr_18559_18629[(2)] = null);

(statearr_18559_18629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (6))){
var inst_18449 = (state_18517[(29)]);
var inst_18448 = cljs.core.deref.call(null,cs);
var inst_18449__$1 = cljs.core.keys.call(null,inst_18448);
var inst_18450 = cljs.core.count.call(null,inst_18449__$1);
var inst_18451 = cljs.core.reset_BANG_.call(null,dctr,inst_18450);
var inst_18456 = cljs.core.seq.call(null,inst_18449__$1);
var inst_18457 = inst_18456;
var inst_18458 = null;
var inst_18459 = (0);
var inst_18460 = (0);
var state_18517__$1 = (function (){var statearr_18560 = state_18517;
(statearr_18560[(29)] = inst_18449__$1);

(statearr_18560[(11)] = inst_18458);

(statearr_18560[(30)] = inst_18451);

(statearr_18560[(20)] = inst_18457);

(statearr_18560[(21)] = inst_18459);

(statearr_18560[(12)] = inst_18460);

return statearr_18560;
})();
var statearr_18561_18630 = state_18517__$1;
(statearr_18561_18630[(2)] = null);

(statearr_18561_18630[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (28))){
var inst_18476 = (state_18517[(25)]);
var inst_18457 = (state_18517[(20)]);
var inst_18476__$1 = cljs.core.seq.call(null,inst_18457);
var state_18517__$1 = (function (){var statearr_18562 = state_18517;
(statearr_18562[(25)] = inst_18476__$1);

return statearr_18562;
})();
if(inst_18476__$1){
var statearr_18563_18631 = state_18517__$1;
(statearr_18563_18631[(1)] = (33));

} else {
var statearr_18564_18632 = state_18517__$1;
(statearr_18564_18632[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (25))){
var inst_18459 = (state_18517[(21)]);
var inst_18460 = (state_18517[(12)]);
var inst_18462 = (inst_18460 < inst_18459);
var inst_18463 = inst_18462;
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18463)){
var statearr_18565_18633 = state_18517__$1;
(statearr_18565_18633[(1)] = (27));

} else {
var statearr_18566_18634 = state_18517__$1;
(statearr_18566_18634[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (34))){
var state_18517__$1 = state_18517;
var statearr_18567_18635 = state_18517__$1;
(statearr_18567_18635[(2)] = null);

(statearr_18567_18635[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (17))){
var state_18517__$1 = state_18517;
var statearr_18568_18636 = state_18517__$1;
(statearr_18568_18636[(2)] = null);

(statearr_18568_18636[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (3))){
var inst_18515 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18517__$1,inst_18515);
} else {
if((state_val_18518 === (12))){
var inst_18444 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18569_18637 = state_18517__$1;
(statearr_18569_18637[(2)] = inst_18444);

(statearr_18569_18637[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (2))){
var state_18517__$1 = state_18517;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18517__$1,(4),ch);
} else {
if((state_val_18518 === (23))){
var state_18517__$1 = state_18517;
var statearr_18570_18638 = state_18517__$1;
(statearr_18570_18638[(2)] = null);

(statearr_18570_18638[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (35))){
var inst_18499 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18571_18639 = state_18517__$1;
(statearr_18571_18639[(2)] = inst_18499);

(statearr_18571_18639[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (19))){
var inst_18418 = (state_18517[(7)]);
var inst_18422 = cljs.core.chunk_first.call(null,inst_18418);
var inst_18423 = cljs.core.chunk_rest.call(null,inst_18418);
var inst_18424 = cljs.core.count.call(null,inst_18422);
var inst_18398 = inst_18423;
var inst_18399 = inst_18422;
var inst_18400 = inst_18424;
var inst_18401 = (0);
var state_18517__$1 = (function (){var statearr_18572 = state_18517;
(statearr_18572[(13)] = inst_18401);

(statearr_18572[(14)] = inst_18398);

(statearr_18572[(15)] = inst_18400);

(statearr_18572[(17)] = inst_18399);

return statearr_18572;
})();
var statearr_18573_18640 = state_18517__$1;
(statearr_18573_18640[(2)] = null);

(statearr_18573_18640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (11))){
var inst_18398 = (state_18517[(14)]);
var inst_18418 = (state_18517[(7)]);
var inst_18418__$1 = cljs.core.seq.call(null,inst_18398);
var state_18517__$1 = (function (){var statearr_18574 = state_18517;
(statearr_18574[(7)] = inst_18418__$1);

return statearr_18574;
})();
if(inst_18418__$1){
var statearr_18575_18641 = state_18517__$1;
(statearr_18575_18641[(1)] = (16));

} else {
var statearr_18576_18642 = state_18517__$1;
(statearr_18576_18642[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (9))){
var inst_18446 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18577_18643 = state_18517__$1;
(statearr_18577_18643[(2)] = inst_18446);

(statearr_18577_18643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (5))){
var inst_18396 = cljs.core.deref.call(null,cs);
var inst_18397 = cljs.core.seq.call(null,inst_18396);
var inst_18398 = inst_18397;
var inst_18399 = null;
var inst_18400 = (0);
var inst_18401 = (0);
var state_18517__$1 = (function (){var statearr_18578 = state_18517;
(statearr_18578[(13)] = inst_18401);

(statearr_18578[(14)] = inst_18398);

(statearr_18578[(15)] = inst_18400);

(statearr_18578[(17)] = inst_18399);

return statearr_18578;
})();
var statearr_18579_18644 = state_18517__$1;
(statearr_18579_18644[(2)] = null);

(statearr_18579_18644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (14))){
var state_18517__$1 = state_18517;
var statearr_18580_18645 = state_18517__$1;
(statearr_18580_18645[(2)] = null);

(statearr_18580_18645[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (45))){
var inst_18507 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18581_18646 = state_18517__$1;
(statearr_18581_18646[(2)] = inst_18507);

(statearr_18581_18646[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (26))){
var inst_18449 = (state_18517[(29)]);
var inst_18503 = (state_18517[(2)]);
var inst_18504 = cljs.core.seq.call(null,inst_18449);
var state_18517__$1 = (function (){var statearr_18582 = state_18517;
(statearr_18582[(31)] = inst_18503);

return statearr_18582;
})();
if(inst_18504){
var statearr_18583_18647 = state_18517__$1;
(statearr_18583_18647[(1)] = (42));

} else {
var statearr_18584_18648 = state_18517__$1;
(statearr_18584_18648[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (16))){
var inst_18418 = (state_18517[(7)]);
var inst_18420 = cljs.core.chunked_seq_QMARK_.call(null,inst_18418);
var state_18517__$1 = state_18517;
if(inst_18420){
var statearr_18585_18649 = state_18517__$1;
(statearr_18585_18649[(1)] = (19));

} else {
var statearr_18586_18650 = state_18517__$1;
(statearr_18586_18650[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (38))){
var inst_18496 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18587_18651 = state_18517__$1;
(statearr_18587_18651[(2)] = inst_18496);

(statearr_18587_18651[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (30))){
var state_18517__$1 = state_18517;
var statearr_18588_18652 = state_18517__$1;
(statearr_18588_18652[(2)] = null);

(statearr_18588_18652[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (10))){
var inst_18401 = (state_18517[(13)]);
var inst_18399 = (state_18517[(17)]);
var inst_18407 = cljs.core._nth.call(null,inst_18399,inst_18401);
var inst_18408 = cljs.core.nth.call(null,inst_18407,(0),null);
var inst_18409 = cljs.core.nth.call(null,inst_18407,(1),null);
var state_18517__$1 = (function (){var statearr_18589 = state_18517;
(statearr_18589[(26)] = inst_18408);

return statearr_18589;
})();
if(cljs.core.truth_(inst_18409)){
var statearr_18590_18653 = state_18517__$1;
(statearr_18590_18653[(1)] = (13));

} else {
var statearr_18591_18654 = state_18517__$1;
(statearr_18591_18654[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (18))){
var inst_18442 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18592_18655 = state_18517__$1;
(statearr_18592_18655[(2)] = inst_18442);

(statearr_18592_18655[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (42))){
var state_18517__$1 = state_18517;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18517__$1,(45),dchan);
} else {
if((state_val_18518 === (37))){
var inst_18389 = (state_18517[(9)]);
var inst_18485 = (state_18517[(23)]);
var inst_18476 = (state_18517[(25)]);
var inst_18485__$1 = cljs.core.first.call(null,inst_18476);
var inst_18486 = cljs.core.async.put_BANG_.call(null,inst_18485__$1,inst_18389,done);
var state_18517__$1 = (function (){var statearr_18593 = state_18517;
(statearr_18593[(23)] = inst_18485__$1);

return statearr_18593;
})();
if(cljs.core.truth_(inst_18486)){
var statearr_18594_18656 = state_18517__$1;
(statearr_18594_18656[(1)] = (39));

} else {
var statearr_18595_18657 = state_18517__$1;
(statearr_18595_18657[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (8))){
var inst_18401 = (state_18517[(13)]);
var inst_18400 = (state_18517[(15)]);
var inst_18403 = (inst_18401 < inst_18400);
var inst_18404 = inst_18403;
var state_18517__$1 = state_18517;
if(cljs.core.truth_(inst_18404)){
var statearr_18596_18658 = state_18517__$1;
(statearr_18596_18658[(1)] = (10));

} else {
var statearr_18597_18659 = state_18517__$1;
(statearr_18597_18659[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18605,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18605,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18601 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18601[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18601[(1)] = (1));

return statearr_18601;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18517){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18602){if((e18602 instanceof Object)){
var ex__8254__auto__ = e18602;
var statearr_18603_18660 = state_18517;
(statearr_18603_18660[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18517);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18602;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18661 = state_18517;
state_18517 = G__18661;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18517){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18605,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18604 = f__8363__auto__.call(null);
(statearr_18604[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18605);

return statearr_18604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18605,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18662 = [];
var len__5726__auto___18665 = arguments.length;
var i__5727__auto___18666 = (0);
while(true){
if((i__5727__auto___18666 < len__5726__auto___18665)){
args18662.push((arguments[i__5727__auto___18666]));

var G__18667 = (i__5727__auto___18666 + (1));
i__5727__auto___18666 = G__18667;
continue;
} else {
}
break;
}

var G__18664 = args18662.length;
switch (G__18664) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18662.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18679 = arguments.length;
var i__5727__auto___18680 = (0);
while(true){
if((i__5727__auto___18680 < len__5726__auto___18679)){
args__5733__auto__.push((arguments[i__5727__auto___18680]));

var G__18681 = (i__5727__auto___18680 + (1));
i__5727__auto___18680 = G__18681;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18673){
var map__18674 = p__18673;
var map__18674__$1 = ((((!((map__18674 == null)))?((((map__18674.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18674.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18674):map__18674);
var opts = map__18674__$1;
var statearr_18676_18682 = state;
(statearr_18676_18682[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18674,map__18674__$1,opts){
return (function (val){
var statearr_18677_18683 = state;
(statearr_18677_18683[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18674,map__18674__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18678_18684 = state;
(statearr_18678_18684[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18669){
var G__18670 = cljs.core.first.call(null,seq18669);
var seq18669__$1 = cljs.core.next.call(null,seq18669);
var G__18671 = cljs.core.first.call(null,seq18669__$1);
var seq18669__$2 = cljs.core.next.call(null,seq18669__$1);
var G__18672 = cljs.core.first.call(null,seq18669__$2);
var seq18669__$3 = cljs.core.next.call(null,seq18669__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18670,G__18671,G__18672,seq18669__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18848 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18848 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18849){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18849 = meta18849;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18850,meta18849__$1){
var self__ = this;
var _18850__$1 = this;
return (new cljs.core.async.t_cljs$core$async18848(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18849__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18850){
var self__ = this;
var _18850__$1 = this;
return self__.meta18849;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18849","meta18849",816823056,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18848.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18848.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18848";

cljs.core.async.t_cljs$core$async18848.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18848");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18848 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18848(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18849){
return (new cljs.core.async.t_cljs$core$async18848(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18849));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18848(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19011 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19011,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19011,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18948){
var state_val_18949 = (state_18948[(1)]);
if((state_val_18949 === (7))){
var inst_18866 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
var statearr_18950_19012 = state_18948__$1;
(statearr_18950_19012[(2)] = inst_18866);

(statearr_18950_19012[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (20))){
var inst_18878 = (state_18948[(7)]);
var state_18948__$1 = state_18948;
var statearr_18951_19013 = state_18948__$1;
(statearr_18951_19013[(2)] = inst_18878);

(statearr_18951_19013[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (27))){
var state_18948__$1 = state_18948;
var statearr_18952_19014 = state_18948__$1;
(statearr_18952_19014[(2)] = null);

(statearr_18952_19014[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (1))){
var inst_18854 = (state_18948[(8)]);
var inst_18854__$1 = calc_state.call(null);
var inst_18856 = (inst_18854__$1 == null);
var inst_18857 = cljs.core.not.call(null,inst_18856);
var state_18948__$1 = (function (){var statearr_18953 = state_18948;
(statearr_18953[(8)] = inst_18854__$1);

return statearr_18953;
})();
if(inst_18857){
var statearr_18954_19015 = state_18948__$1;
(statearr_18954_19015[(1)] = (2));

} else {
var statearr_18955_19016 = state_18948__$1;
(statearr_18955_19016[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (24))){
var inst_18922 = (state_18948[(9)]);
var inst_18901 = (state_18948[(10)]);
var inst_18908 = (state_18948[(11)]);
var inst_18922__$1 = inst_18901.call(null,inst_18908);
var state_18948__$1 = (function (){var statearr_18956 = state_18948;
(statearr_18956[(9)] = inst_18922__$1);

return statearr_18956;
})();
if(cljs.core.truth_(inst_18922__$1)){
var statearr_18957_19017 = state_18948__$1;
(statearr_18957_19017[(1)] = (29));

} else {
var statearr_18958_19018 = state_18948__$1;
(statearr_18958_19018[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (4))){
var inst_18869 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
if(cljs.core.truth_(inst_18869)){
var statearr_18959_19019 = state_18948__$1;
(statearr_18959_19019[(1)] = (8));

} else {
var statearr_18960_19020 = state_18948__$1;
(statearr_18960_19020[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (15))){
var inst_18895 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
if(cljs.core.truth_(inst_18895)){
var statearr_18961_19021 = state_18948__$1;
(statearr_18961_19021[(1)] = (19));

} else {
var statearr_18962_19022 = state_18948__$1;
(statearr_18962_19022[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (21))){
var inst_18900 = (state_18948[(12)]);
var inst_18900__$1 = (state_18948[(2)]);
var inst_18901 = cljs.core.get.call(null,inst_18900__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18902 = cljs.core.get.call(null,inst_18900__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18903 = cljs.core.get.call(null,inst_18900__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18948__$1 = (function (){var statearr_18963 = state_18948;
(statearr_18963[(12)] = inst_18900__$1);

(statearr_18963[(13)] = inst_18902);

(statearr_18963[(10)] = inst_18901);

return statearr_18963;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18948__$1,(22),inst_18903);
} else {
if((state_val_18949 === (31))){
var inst_18930 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
if(cljs.core.truth_(inst_18930)){
var statearr_18964_19023 = state_18948__$1;
(statearr_18964_19023[(1)] = (32));

} else {
var statearr_18965_19024 = state_18948__$1;
(statearr_18965_19024[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (32))){
var inst_18907 = (state_18948[(14)]);
var state_18948__$1 = state_18948;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18948__$1,(35),out,inst_18907);
} else {
if((state_val_18949 === (33))){
var inst_18900 = (state_18948[(12)]);
var inst_18878 = inst_18900;
var state_18948__$1 = (function (){var statearr_18966 = state_18948;
(statearr_18966[(7)] = inst_18878);

return statearr_18966;
})();
var statearr_18967_19025 = state_18948__$1;
(statearr_18967_19025[(2)] = null);

(statearr_18967_19025[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (13))){
var inst_18878 = (state_18948[(7)]);
var inst_18885 = inst_18878.cljs$lang$protocol_mask$partition0$;
var inst_18886 = (inst_18885 & (64));
var inst_18887 = inst_18878.cljs$core$ISeq$;
var inst_18888 = (inst_18886) || (inst_18887);
var state_18948__$1 = state_18948;
if(cljs.core.truth_(inst_18888)){
var statearr_18968_19026 = state_18948__$1;
(statearr_18968_19026[(1)] = (16));

} else {
var statearr_18969_19027 = state_18948__$1;
(statearr_18969_19027[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (22))){
var inst_18907 = (state_18948[(14)]);
var inst_18908 = (state_18948[(11)]);
var inst_18906 = (state_18948[(2)]);
var inst_18907__$1 = cljs.core.nth.call(null,inst_18906,(0),null);
var inst_18908__$1 = cljs.core.nth.call(null,inst_18906,(1),null);
var inst_18909 = (inst_18907__$1 == null);
var inst_18910 = cljs.core._EQ_.call(null,inst_18908__$1,change);
var inst_18911 = (inst_18909) || (inst_18910);
var state_18948__$1 = (function (){var statearr_18970 = state_18948;
(statearr_18970[(14)] = inst_18907__$1);

(statearr_18970[(11)] = inst_18908__$1);

return statearr_18970;
})();
if(cljs.core.truth_(inst_18911)){
var statearr_18971_19028 = state_18948__$1;
(statearr_18971_19028[(1)] = (23));

} else {
var statearr_18972_19029 = state_18948__$1;
(statearr_18972_19029[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (36))){
var inst_18900 = (state_18948[(12)]);
var inst_18878 = inst_18900;
var state_18948__$1 = (function (){var statearr_18973 = state_18948;
(statearr_18973[(7)] = inst_18878);

return statearr_18973;
})();
var statearr_18974_19030 = state_18948__$1;
(statearr_18974_19030[(2)] = null);

(statearr_18974_19030[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (29))){
var inst_18922 = (state_18948[(9)]);
var state_18948__$1 = state_18948;
var statearr_18975_19031 = state_18948__$1;
(statearr_18975_19031[(2)] = inst_18922);

(statearr_18975_19031[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (6))){
var state_18948__$1 = state_18948;
var statearr_18976_19032 = state_18948__$1;
(statearr_18976_19032[(2)] = false);

(statearr_18976_19032[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (28))){
var inst_18918 = (state_18948[(2)]);
var inst_18919 = calc_state.call(null);
var inst_18878 = inst_18919;
var state_18948__$1 = (function (){var statearr_18977 = state_18948;
(statearr_18977[(7)] = inst_18878);

(statearr_18977[(15)] = inst_18918);

return statearr_18977;
})();
var statearr_18978_19033 = state_18948__$1;
(statearr_18978_19033[(2)] = null);

(statearr_18978_19033[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (25))){
var inst_18944 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
var statearr_18979_19034 = state_18948__$1;
(statearr_18979_19034[(2)] = inst_18944);

(statearr_18979_19034[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (34))){
var inst_18942 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
var statearr_18980_19035 = state_18948__$1;
(statearr_18980_19035[(2)] = inst_18942);

(statearr_18980_19035[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (17))){
var state_18948__$1 = state_18948;
var statearr_18981_19036 = state_18948__$1;
(statearr_18981_19036[(2)] = false);

(statearr_18981_19036[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (3))){
var state_18948__$1 = state_18948;
var statearr_18982_19037 = state_18948__$1;
(statearr_18982_19037[(2)] = false);

(statearr_18982_19037[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (12))){
var inst_18946 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18948__$1,inst_18946);
} else {
if((state_val_18949 === (2))){
var inst_18854 = (state_18948[(8)]);
var inst_18859 = inst_18854.cljs$lang$protocol_mask$partition0$;
var inst_18860 = (inst_18859 & (64));
var inst_18861 = inst_18854.cljs$core$ISeq$;
var inst_18862 = (inst_18860) || (inst_18861);
var state_18948__$1 = state_18948;
if(cljs.core.truth_(inst_18862)){
var statearr_18983_19038 = state_18948__$1;
(statearr_18983_19038[(1)] = (5));

} else {
var statearr_18984_19039 = state_18948__$1;
(statearr_18984_19039[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (23))){
var inst_18907 = (state_18948[(14)]);
var inst_18913 = (inst_18907 == null);
var state_18948__$1 = state_18948;
if(cljs.core.truth_(inst_18913)){
var statearr_18985_19040 = state_18948__$1;
(statearr_18985_19040[(1)] = (26));

} else {
var statearr_18986_19041 = state_18948__$1;
(statearr_18986_19041[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (35))){
var inst_18933 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
if(cljs.core.truth_(inst_18933)){
var statearr_18987_19042 = state_18948__$1;
(statearr_18987_19042[(1)] = (36));

} else {
var statearr_18988_19043 = state_18948__$1;
(statearr_18988_19043[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (19))){
var inst_18878 = (state_18948[(7)]);
var inst_18897 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18878);
var state_18948__$1 = state_18948;
var statearr_18989_19044 = state_18948__$1;
(statearr_18989_19044[(2)] = inst_18897);

(statearr_18989_19044[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (11))){
var inst_18878 = (state_18948[(7)]);
var inst_18882 = (inst_18878 == null);
var inst_18883 = cljs.core.not.call(null,inst_18882);
var state_18948__$1 = state_18948;
if(inst_18883){
var statearr_18990_19045 = state_18948__$1;
(statearr_18990_19045[(1)] = (13));

} else {
var statearr_18991_19046 = state_18948__$1;
(statearr_18991_19046[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (9))){
var inst_18854 = (state_18948[(8)]);
var state_18948__$1 = state_18948;
var statearr_18992_19047 = state_18948__$1;
(statearr_18992_19047[(2)] = inst_18854);

(statearr_18992_19047[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (5))){
var state_18948__$1 = state_18948;
var statearr_18993_19048 = state_18948__$1;
(statearr_18993_19048[(2)] = true);

(statearr_18993_19048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (14))){
var state_18948__$1 = state_18948;
var statearr_18994_19049 = state_18948__$1;
(statearr_18994_19049[(2)] = false);

(statearr_18994_19049[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (26))){
var inst_18908 = (state_18948[(11)]);
var inst_18915 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18908);
var state_18948__$1 = state_18948;
var statearr_18995_19050 = state_18948__$1;
(statearr_18995_19050[(2)] = inst_18915);

(statearr_18995_19050[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (16))){
var state_18948__$1 = state_18948;
var statearr_18996_19051 = state_18948__$1;
(statearr_18996_19051[(2)] = true);

(statearr_18996_19051[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (38))){
var inst_18938 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
var statearr_18997_19052 = state_18948__$1;
(statearr_18997_19052[(2)] = inst_18938);

(statearr_18997_19052[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (30))){
var inst_18902 = (state_18948[(13)]);
var inst_18901 = (state_18948[(10)]);
var inst_18908 = (state_18948[(11)]);
var inst_18925 = cljs.core.empty_QMARK_.call(null,inst_18901);
var inst_18926 = inst_18902.call(null,inst_18908);
var inst_18927 = cljs.core.not.call(null,inst_18926);
var inst_18928 = (inst_18925) && (inst_18927);
var state_18948__$1 = state_18948;
var statearr_18998_19053 = state_18948__$1;
(statearr_18998_19053[(2)] = inst_18928);

(statearr_18998_19053[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (10))){
var inst_18854 = (state_18948[(8)]);
var inst_18874 = (state_18948[(2)]);
var inst_18875 = cljs.core.get.call(null,inst_18874,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18876 = cljs.core.get.call(null,inst_18874,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18877 = cljs.core.get.call(null,inst_18874,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18878 = inst_18854;
var state_18948__$1 = (function (){var statearr_18999 = state_18948;
(statearr_18999[(7)] = inst_18878);

(statearr_18999[(16)] = inst_18875);

(statearr_18999[(17)] = inst_18876);

(statearr_18999[(18)] = inst_18877);

return statearr_18999;
})();
var statearr_19000_19054 = state_18948__$1;
(statearr_19000_19054[(2)] = null);

(statearr_19000_19054[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (18))){
var inst_18892 = (state_18948[(2)]);
var state_18948__$1 = state_18948;
var statearr_19001_19055 = state_18948__$1;
(statearr_19001_19055[(2)] = inst_18892);

(statearr_19001_19055[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (37))){
var state_18948__$1 = state_18948;
var statearr_19002_19056 = state_18948__$1;
(statearr_19002_19056[(2)] = null);

(statearr_19002_19056[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18949 === (8))){
var inst_18854 = (state_18948[(8)]);
var inst_18871 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18854);
var state_18948__$1 = state_18948;
var statearr_19003_19057 = state_18948__$1;
(statearr_19003_19057[(2)] = inst_18871);

(statearr_19003_19057[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19011,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___19011,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_19007 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19007[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_19007[(1)] = (1));

return statearr_19007;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18948){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18948);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19008){if((e19008 instanceof Object)){
var ex__8254__auto__ = e19008;
var statearr_19009_19058 = state_18948;
(statearr_19009_19058[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18948);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19059 = state_18948;
state_18948 = G__19059;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18948){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19011,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_19010 = f__8363__auto__.call(null);
(statearr_19010[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19011);

return statearr_19010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19011,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19060 = [];
var len__5726__auto___19063 = arguments.length;
var i__5727__auto___19064 = (0);
while(true){
if((i__5727__auto___19064 < len__5726__auto___19063)){
args19060.push((arguments[i__5727__auto___19064]));

var G__19065 = (i__5727__auto___19064 + (1));
i__5727__auto___19064 = G__19065;
continue;
} else {
}
break;
}

var G__19062 = args19060.length;
switch (G__19062) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19060.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19068 = [];
var len__5726__auto___19193 = arguments.length;
var i__5727__auto___19194 = (0);
while(true){
if((i__5727__auto___19194 < len__5726__auto___19193)){
args19068.push((arguments[i__5727__auto___19194]));

var G__19195 = (i__5727__auto___19194 + (1));
i__5727__auto___19194 = G__19195;
continue;
} else {
}
break;
}

var G__19070 = args19068.length;
switch (G__19070) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19068.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19067_SHARP_){
if(cljs.core.truth_(p1__19067_SHARP_.call(null,topic))){
return p1__19067_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19067_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19071 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19071 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19072){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19072 = meta19072;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19073,meta19072__$1){
var self__ = this;
var _19073__$1 = this;
return (new cljs.core.async.t_cljs$core$async19071(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19072__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19073){
var self__ = this;
var _19073__$1 = this;
return self__.meta19072;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19071.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19071.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19072","meta19072",2010548643,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19071.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19071.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19071";

cljs.core.async.t_cljs$core$async19071.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19071");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19071 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19071(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19072){
return (new cljs.core.async.t_cljs$core$async19071(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19072));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19071(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19197 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19197,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19197,mults,ensure_mult,p){
return (function (state_19145){
var state_val_19146 = (state_19145[(1)]);
if((state_val_19146 === (7))){
var inst_19141 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19147_19198 = state_19145__$1;
(statearr_19147_19198[(2)] = inst_19141);

(statearr_19147_19198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (20))){
var state_19145__$1 = state_19145;
var statearr_19148_19199 = state_19145__$1;
(statearr_19148_19199[(2)] = null);

(statearr_19148_19199[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (1))){
var state_19145__$1 = state_19145;
var statearr_19149_19200 = state_19145__$1;
(statearr_19149_19200[(2)] = null);

(statearr_19149_19200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (24))){
var inst_19124 = (state_19145[(7)]);
var inst_19133 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19124);
var state_19145__$1 = state_19145;
var statearr_19150_19201 = state_19145__$1;
(statearr_19150_19201[(2)] = inst_19133);

(statearr_19150_19201[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (4))){
var inst_19076 = (state_19145[(8)]);
var inst_19076__$1 = (state_19145[(2)]);
var inst_19077 = (inst_19076__$1 == null);
var state_19145__$1 = (function (){var statearr_19151 = state_19145;
(statearr_19151[(8)] = inst_19076__$1);

return statearr_19151;
})();
if(cljs.core.truth_(inst_19077)){
var statearr_19152_19202 = state_19145__$1;
(statearr_19152_19202[(1)] = (5));

} else {
var statearr_19153_19203 = state_19145__$1;
(statearr_19153_19203[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (15))){
var inst_19118 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19154_19204 = state_19145__$1;
(statearr_19154_19204[(2)] = inst_19118);

(statearr_19154_19204[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (21))){
var inst_19138 = (state_19145[(2)]);
var state_19145__$1 = (function (){var statearr_19155 = state_19145;
(statearr_19155[(9)] = inst_19138);

return statearr_19155;
})();
var statearr_19156_19205 = state_19145__$1;
(statearr_19156_19205[(2)] = null);

(statearr_19156_19205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (13))){
var inst_19100 = (state_19145[(10)]);
var inst_19102 = cljs.core.chunked_seq_QMARK_.call(null,inst_19100);
var state_19145__$1 = state_19145;
if(inst_19102){
var statearr_19157_19206 = state_19145__$1;
(statearr_19157_19206[(1)] = (16));

} else {
var statearr_19158_19207 = state_19145__$1;
(statearr_19158_19207[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (22))){
var inst_19130 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19130)){
var statearr_19159_19208 = state_19145__$1;
(statearr_19159_19208[(1)] = (23));

} else {
var statearr_19160_19209 = state_19145__$1;
(statearr_19160_19209[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (6))){
var inst_19126 = (state_19145[(11)]);
var inst_19124 = (state_19145[(7)]);
var inst_19076 = (state_19145[(8)]);
var inst_19124__$1 = topic_fn.call(null,inst_19076);
var inst_19125 = cljs.core.deref.call(null,mults);
var inst_19126__$1 = cljs.core.get.call(null,inst_19125,inst_19124__$1);
var state_19145__$1 = (function (){var statearr_19161 = state_19145;
(statearr_19161[(11)] = inst_19126__$1);

(statearr_19161[(7)] = inst_19124__$1);

return statearr_19161;
})();
if(cljs.core.truth_(inst_19126__$1)){
var statearr_19162_19210 = state_19145__$1;
(statearr_19162_19210[(1)] = (19));

} else {
var statearr_19163_19211 = state_19145__$1;
(statearr_19163_19211[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (25))){
var inst_19135 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19164_19212 = state_19145__$1;
(statearr_19164_19212[(2)] = inst_19135);

(statearr_19164_19212[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (17))){
var inst_19100 = (state_19145[(10)]);
var inst_19109 = cljs.core.first.call(null,inst_19100);
var inst_19110 = cljs.core.async.muxch_STAR_.call(null,inst_19109);
var inst_19111 = cljs.core.async.close_BANG_.call(null,inst_19110);
var inst_19112 = cljs.core.next.call(null,inst_19100);
var inst_19086 = inst_19112;
var inst_19087 = null;
var inst_19088 = (0);
var inst_19089 = (0);
var state_19145__$1 = (function (){var statearr_19165 = state_19145;
(statearr_19165[(12)] = inst_19087);

(statearr_19165[(13)] = inst_19111);

(statearr_19165[(14)] = inst_19086);

(statearr_19165[(15)] = inst_19088);

(statearr_19165[(16)] = inst_19089);

return statearr_19165;
})();
var statearr_19166_19213 = state_19145__$1;
(statearr_19166_19213[(2)] = null);

(statearr_19166_19213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (3))){
var inst_19143 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19145__$1,inst_19143);
} else {
if((state_val_19146 === (12))){
var inst_19120 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19167_19214 = state_19145__$1;
(statearr_19167_19214[(2)] = inst_19120);

(statearr_19167_19214[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (2))){
var state_19145__$1 = state_19145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19145__$1,(4),ch);
} else {
if((state_val_19146 === (23))){
var state_19145__$1 = state_19145;
var statearr_19168_19215 = state_19145__$1;
(statearr_19168_19215[(2)] = null);

(statearr_19168_19215[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (19))){
var inst_19126 = (state_19145[(11)]);
var inst_19076 = (state_19145[(8)]);
var inst_19128 = cljs.core.async.muxch_STAR_.call(null,inst_19126);
var state_19145__$1 = state_19145;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19145__$1,(22),inst_19128,inst_19076);
} else {
if((state_val_19146 === (11))){
var inst_19100 = (state_19145[(10)]);
var inst_19086 = (state_19145[(14)]);
var inst_19100__$1 = cljs.core.seq.call(null,inst_19086);
var state_19145__$1 = (function (){var statearr_19169 = state_19145;
(statearr_19169[(10)] = inst_19100__$1);

return statearr_19169;
})();
if(inst_19100__$1){
var statearr_19170_19216 = state_19145__$1;
(statearr_19170_19216[(1)] = (13));

} else {
var statearr_19171_19217 = state_19145__$1;
(statearr_19171_19217[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (9))){
var inst_19122 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19172_19218 = state_19145__$1;
(statearr_19172_19218[(2)] = inst_19122);

(statearr_19172_19218[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (5))){
var inst_19083 = cljs.core.deref.call(null,mults);
var inst_19084 = cljs.core.vals.call(null,inst_19083);
var inst_19085 = cljs.core.seq.call(null,inst_19084);
var inst_19086 = inst_19085;
var inst_19087 = null;
var inst_19088 = (0);
var inst_19089 = (0);
var state_19145__$1 = (function (){var statearr_19173 = state_19145;
(statearr_19173[(12)] = inst_19087);

(statearr_19173[(14)] = inst_19086);

(statearr_19173[(15)] = inst_19088);

(statearr_19173[(16)] = inst_19089);

return statearr_19173;
})();
var statearr_19174_19219 = state_19145__$1;
(statearr_19174_19219[(2)] = null);

(statearr_19174_19219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (14))){
var state_19145__$1 = state_19145;
var statearr_19178_19220 = state_19145__$1;
(statearr_19178_19220[(2)] = null);

(statearr_19178_19220[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (16))){
var inst_19100 = (state_19145[(10)]);
var inst_19104 = cljs.core.chunk_first.call(null,inst_19100);
var inst_19105 = cljs.core.chunk_rest.call(null,inst_19100);
var inst_19106 = cljs.core.count.call(null,inst_19104);
var inst_19086 = inst_19105;
var inst_19087 = inst_19104;
var inst_19088 = inst_19106;
var inst_19089 = (0);
var state_19145__$1 = (function (){var statearr_19179 = state_19145;
(statearr_19179[(12)] = inst_19087);

(statearr_19179[(14)] = inst_19086);

(statearr_19179[(15)] = inst_19088);

(statearr_19179[(16)] = inst_19089);

return statearr_19179;
})();
var statearr_19180_19221 = state_19145__$1;
(statearr_19180_19221[(2)] = null);

(statearr_19180_19221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (10))){
var inst_19087 = (state_19145[(12)]);
var inst_19086 = (state_19145[(14)]);
var inst_19088 = (state_19145[(15)]);
var inst_19089 = (state_19145[(16)]);
var inst_19094 = cljs.core._nth.call(null,inst_19087,inst_19089);
var inst_19095 = cljs.core.async.muxch_STAR_.call(null,inst_19094);
var inst_19096 = cljs.core.async.close_BANG_.call(null,inst_19095);
var inst_19097 = (inst_19089 + (1));
var tmp19175 = inst_19087;
var tmp19176 = inst_19086;
var tmp19177 = inst_19088;
var inst_19086__$1 = tmp19176;
var inst_19087__$1 = tmp19175;
var inst_19088__$1 = tmp19177;
var inst_19089__$1 = inst_19097;
var state_19145__$1 = (function (){var statearr_19181 = state_19145;
(statearr_19181[(17)] = inst_19096);

(statearr_19181[(12)] = inst_19087__$1);

(statearr_19181[(14)] = inst_19086__$1);

(statearr_19181[(15)] = inst_19088__$1);

(statearr_19181[(16)] = inst_19089__$1);

return statearr_19181;
})();
var statearr_19182_19222 = state_19145__$1;
(statearr_19182_19222[(2)] = null);

(statearr_19182_19222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (18))){
var inst_19115 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19183_19223 = state_19145__$1;
(statearr_19183_19223[(2)] = inst_19115);

(statearr_19183_19223[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (8))){
var inst_19088 = (state_19145[(15)]);
var inst_19089 = (state_19145[(16)]);
var inst_19091 = (inst_19089 < inst_19088);
var inst_19092 = inst_19091;
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19092)){
var statearr_19184_19224 = state_19145__$1;
(statearr_19184_19224[(1)] = (10));

} else {
var statearr_19185_19225 = state_19145__$1;
(statearr_19185_19225[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19197,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19197,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19189[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19189[(1)] = (1));

return statearr_19189;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19145){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19190){if((e19190 instanceof Object)){
var ex__8254__auto__ = e19190;
var statearr_19191_19226 = state_19145;
(statearr_19191_19226[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19145);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19190;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19227 = state_19145;
state_19145 = G__19227;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19145){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19197,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19192 = f__8363__auto__.call(null);
(statearr_19192[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19197);

return statearr_19192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19197,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19228 = [];
var len__5726__auto___19231 = arguments.length;
var i__5727__auto___19232 = (0);
while(true){
if((i__5727__auto___19232 < len__5726__auto___19231)){
args19228.push((arguments[i__5727__auto___19232]));

var G__19233 = (i__5727__auto___19232 + (1));
i__5727__auto___19232 = G__19233;
continue;
} else {
}
break;
}

var G__19230 = args19228.length;
switch (G__19230) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19228.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19235 = [];
var len__5726__auto___19238 = arguments.length;
var i__5727__auto___19239 = (0);
while(true){
if((i__5727__auto___19239 < len__5726__auto___19238)){
args19235.push((arguments[i__5727__auto___19239]));

var G__19240 = (i__5727__auto___19239 + (1));
i__5727__auto___19239 = G__19240;
continue;
} else {
}
break;
}

var G__19237 = args19235.length;
switch (G__19237) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19235.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19242 = [];
var len__5726__auto___19313 = arguments.length;
var i__5727__auto___19314 = (0);
while(true){
if((i__5727__auto___19314 < len__5726__auto___19313)){
args19242.push((arguments[i__5727__auto___19314]));

var G__19315 = (i__5727__auto___19314 + (1));
i__5727__auto___19314 = G__19315;
continue;
} else {
}
break;
}

var G__19244 = args19242.length;
switch (G__19244) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19242.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19317 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19317,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19317,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19283){
var state_val_19284 = (state_19283[(1)]);
if((state_val_19284 === (7))){
var state_19283__$1 = state_19283;
var statearr_19285_19318 = state_19283__$1;
(statearr_19285_19318[(2)] = null);

(statearr_19285_19318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (1))){
var state_19283__$1 = state_19283;
var statearr_19286_19319 = state_19283__$1;
(statearr_19286_19319[(2)] = null);

(statearr_19286_19319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (4))){
var inst_19247 = (state_19283[(7)]);
var inst_19249 = (inst_19247 < cnt);
var state_19283__$1 = state_19283;
if(cljs.core.truth_(inst_19249)){
var statearr_19287_19320 = state_19283__$1;
(statearr_19287_19320[(1)] = (6));

} else {
var statearr_19288_19321 = state_19283__$1;
(statearr_19288_19321[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (15))){
var inst_19279 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19289_19322 = state_19283__$1;
(statearr_19289_19322[(2)] = inst_19279);

(statearr_19289_19322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (13))){
var inst_19272 = cljs.core.async.close_BANG_.call(null,out);
var state_19283__$1 = state_19283;
var statearr_19290_19323 = state_19283__$1;
(statearr_19290_19323[(2)] = inst_19272);

(statearr_19290_19323[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (6))){
var state_19283__$1 = state_19283;
var statearr_19291_19324 = state_19283__$1;
(statearr_19291_19324[(2)] = null);

(statearr_19291_19324[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (3))){
var inst_19281 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19283__$1,inst_19281);
} else {
if((state_val_19284 === (12))){
var inst_19269 = (state_19283[(8)]);
var inst_19269__$1 = (state_19283[(2)]);
var inst_19270 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19269__$1);
var state_19283__$1 = (function (){var statearr_19292 = state_19283;
(statearr_19292[(8)] = inst_19269__$1);

return statearr_19292;
})();
if(cljs.core.truth_(inst_19270)){
var statearr_19293_19325 = state_19283__$1;
(statearr_19293_19325[(1)] = (13));

} else {
var statearr_19294_19326 = state_19283__$1;
(statearr_19294_19326[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (2))){
var inst_19246 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19247 = (0);
var state_19283__$1 = (function (){var statearr_19295 = state_19283;
(statearr_19295[(9)] = inst_19246);

(statearr_19295[(7)] = inst_19247);

return statearr_19295;
})();
var statearr_19296_19327 = state_19283__$1;
(statearr_19296_19327[(2)] = null);

(statearr_19296_19327[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (11))){
var inst_19247 = (state_19283[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19283,(10),Object,null,(9));
var inst_19256 = chs__$1.call(null,inst_19247);
var inst_19257 = done.call(null,inst_19247);
var inst_19258 = cljs.core.async.take_BANG_.call(null,inst_19256,inst_19257);
var state_19283__$1 = state_19283;
var statearr_19297_19328 = state_19283__$1;
(statearr_19297_19328[(2)] = inst_19258);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19283__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (9))){
var inst_19247 = (state_19283[(7)]);
var inst_19260 = (state_19283[(2)]);
var inst_19261 = (inst_19247 + (1));
var inst_19247__$1 = inst_19261;
var state_19283__$1 = (function (){var statearr_19298 = state_19283;
(statearr_19298[(10)] = inst_19260);

(statearr_19298[(7)] = inst_19247__$1);

return statearr_19298;
})();
var statearr_19299_19329 = state_19283__$1;
(statearr_19299_19329[(2)] = null);

(statearr_19299_19329[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (5))){
var inst_19267 = (state_19283[(2)]);
var state_19283__$1 = (function (){var statearr_19300 = state_19283;
(statearr_19300[(11)] = inst_19267);

return statearr_19300;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19283__$1,(12),dchan);
} else {
if((state_val_19284 === (14))){
var inst_19269 = (state_19283[(8)]);
var inst_19274 = cljs.core.apply.call(null,f,inst_19269);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19283__$1,(16),out,inst_19274);
} else {
if((state_val_19284 === (16))){
var inst_19276 = (state_19283[(2)]);
var state_19283__$1 = (function (){var statearr_19301 = state_19283;
(statearr_19301[(12)] = inst_19276);

return statearr_19301;
})();
var statearr_19302_19330 = state_19283__$1;
(statearr_19302_19330[(2)] = null);

(statearr_19302_19330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (10))){
var inst_19251 = (state_19283[(2)]);
var inst_19252 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19283__$1 = (function (){var statearr_19303 = state_19283;
(statearr_19303[(13)] = inst_19251);

return statearr_19303;
})();
var statearr_19304_19331 = state_19283__$1;
(statearr_19304_19331[(2)] = inst_19252);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19283__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (8))){
var inst_19265 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19305_19332 = state_19283__$1;
(statearr_19305_19332[(2)] = inst_19265);

(statearr_19305_19332[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19317,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19317,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19309[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19309[(1)] = (1));

return statearr_19309;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19283){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19310){if((e19310 instanceof Object)){
var ex__8254__auto__ = e19310;
var statearr_19311_19333 = state_19283;
(statearr_19311_19333[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19283);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19334 = state_19283;
state_19283 = G__19334;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19283){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19317,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19312 = f__8363__auto__.call(null);
(statearr_19312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19317);

return statearr_19312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19317,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19336 = [];
var len__5726__auto___19392 = arguments.length;
var i__5727__auto___19393 = (0);
while(true){
if((i__5727__auto___19393 < len__5726__auto___19392)){
args19336.push((arguments[i__5727__auto___19393]));

var G__19394 = (i__5727__auto___19393 + (1));
i__5727__auto___19393 = G__19394;
continue;
} else {
}
break;
}

var G__19338 = args19336.length;
switch (G__19338) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19336.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19396 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19396,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19396,out){
return (function (state_19368){
var state_val_19369 = (state_19368[(1)]);
if((state_val_19369 === (7))){
var inst_19348 = (state_19368[(7)]);
var inst_19347 = (state_19368[(8)]);
var inst_19347__$1 = (state_19368[(2)]);
var inst_19348__$1 = cljs.core.nth.call(null,inst_19347__$1,(0),null);
var inst_19349 = cljs.core.nth.call(null,inst_19347__$1,(1),null);
var inst_19350 = (inst_19348__$1 == null);
var state_19368__$1 = (function (){var statearr_19370 = state_19368;
(statearr_19370[(7)] = inst_19348__$1);

(statearr_19370[(9)] = inst_19349);

(statearr_19370[(8)] = inst_19347__$1);

return statearr_19370;
})();
if(cljs.core.truth_(inst_19350)){
var statearr_19371_19397 = state_19368__$1;
(statearr_19371_19397[(1)] = (8));

} else {
var statearr_19372_19398 = state_19368__$1;
(statearr_19372_19398[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19369 === (1))){
var inst_19339 = cljs.core.vec.call(null,chs);
var inst_19340 = inst_19339;
var state_19368__$1 = (function (){var statearr_19373 = state_19368;
(statearr_19373[(10)] = inst_19340);

return statearr_19373;
})();
var statearr_19374_19399 = state_19368__$1;
(statearr_19374_19399[(2)] = null);

(statearr_19374_19399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19369 === (4))){
var inst_19340 = (state_19368[(10)]);
var state_19368__$1 = state_19368;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19368__$1,(7),inst_19340);
} else {
if((state_val_19369 === (6))){
var inst_19364 = (state_19368[(2)]);
var state_19368__$1 = state_19368;
var statearr_19375_19400 = state_19368__$1;
(statearr_19375_19400[(2)] = inst_19364);

(statearr_19375_19400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19369 === (3))){
var inst_19366 = (state_19368[(2)]);
var state_19368__$1 = state_19368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19368__$1,inst_19366);
} else {
if((state_val_19369 === (2))){
var inst_19340 = (state_19368[(10)]);
var inst_19342 = cljs.core.count.call(null,inst_19340);
var inst_19343 = (inst_19342 > (0));
var state_19368__$1 = state_19368;
if(cljs.core.truth_(inst_19343)){
var statearr_19377_19401 = state_19368__$1;
(statearr_19377_19401[(1)] = (4));

} else {
var statearr_19378_19402 = state_19368__$1;
(statearr_19378_19402[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19369 === (11))){
var inst_19340 = (state_19368[(10)]);
var inst_19357 = (state_19368[(2)]);
var tmp19376 = inst_19340;
var inst_19340__$1 = tmp19376;
var state_19368__$1 = (function (){var statearr_19379 = state_19368;
(statearr_19379[(10)] = inst_19340__$1);

(statearr_19379[(11)] = inst_19357);

return statearr_19379;
})();
var statearr_19380_19403 = state_19368__$1;
(statearr_19380_19403[(2)] = null);

(statearr_19380_19403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19369 === (9))){
var inst_19348 = (state_19368[(7)]);
var state_19368__$1 = state_19368;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19368__$1,(11),out,inst_19348);
} else {
if((state_val_19369 === (5))){
var inst_19362 = cljs.core.async.close_BANG_.call(null,out);
var state_19368__$1 = state_19368;
var statearr_19381_19404 = state_19368__$1;
(statearr_19381_19404[(2)] = inst_19362);

(statearr_19381_19404[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19369 === (10))){
var inst_19360 = (state_19368[(2)]);
var state_19368__$1 = state_19368;
var statearr_19382_19405 = state_19368__$1;
(statearr_19382_19405[(2)] = inst_19360);

(statearr_19382_19405[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19369 === (8))){
var inst_19348 = (state_19368[(7)]);
var inst_19340 = (state_19368[(10)]);
var inst_19349 = (state_19368[(9)]);
var inst_19347 = (state_19368[(8)]);
var inst_19352 = (function (){var cs = inst_19340;
var vec__19345 = inst_19347;
var v = inst_19348;
var c = inst_19349;
return ((function (cs,vec__19345,v,c,inst_19348,inst_19340,inst_19349,inst_19347,state_val_19369,c__8362__auto___19396,out){
return (function (p1__19335_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19335_SHARP_);
});
;})(cs,vec__19345,v,c,inst_19348,inst_19340,inst_19349,inst_19347,state_val_19369,c__8362__auto___19396,out))
})();
var inst_19353 = cljs.core.filterv.call(null,inst_19352,inst_19340);
var inst_19340__$1 = inst_19353;
var state_19368__$1 = (function (){var statearr_19383 = state_19368;
(statearr_19383[(10)] = inst_19340__$1);

return statearr_19383;
})();
var statearr_19384_19406 = state_19368__$1;
(statearr_19384_19406[(2)] = null);

(statearr_19384_19406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19396,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19396,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19388 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19388[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19388[(1)] = (1));

return statearr_19388;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19368){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19389){if((e19389 instanceof Object)){
var ex__8254__auto__ = e19389;
var statearr_19390_19407 = state_19368;
(statearr_19390_19407[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19368);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19389;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19408 = state_19368;
state_19368 = G__19408;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19368){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19396,out))
})();
var state__8364__auto__ = (function (){var statearr_19391 = f__8363__auto__.call(null);
(statearr_19391[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19396);

return statearr_19391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19396,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19409 = [];
var len__5726__auto___19458 = arguments.length;
var i__5727__auto___19459 = (0);
while(true){
if((i__5727__auto___19459 < len__5726__auto___19458)){
args19409.push((arguments[i__5727__auto___19459]));

var G__19460 = (i__5727__auto___19459 + (1));
i__5727__auto___19459 = G__19460;
continue;
} else {
}
break;
}

var G__19411 = args19409.length;
switch (G__19411) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19409.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19462 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19462,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19462,out){
return (function (state_19435){
var state_val_19436 = (state_19435[(1)]);
if((state_val_19436 === (7))){
var inst_19417 = (state_19435[(7)]);
var inst_19417__$1 = (state_19435[(2)]);
var inst_19418 = (inst_19417__$1 == null);
var inst_19419 = cljs.core.not.call(null,inst_19418);
var state_19435__$1 = (function (){var statearr_19437 = state_19435;
(statearr_19437[(7)] = inst_19417__$1);

return statearr_19437;
})();
if(inst_19419){
var statearr_19438_19463 = state_19435__$1;
(statearr_19438_19463[(1)] = (8));

} else {
var statearr_19439_19464 = state_19435__$1;
(statearr_19439_19464[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (1))){
var inst_19412 = (0);
var state_19435__$1 = (function (){var statearr_19440 = state_19435;
(statearr_19440[(8)] = inst_19412);

return statearr_19440;
})();
var statearr_19441_19465 = state_19435__$1;
(statearr_19441_19465[(2)] = null);

(statearr_19441_19465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (4))){
var state_19435__$1 = state_19435;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19435__$1,(7),ch);
} else {
if((state_val_19436 === (6))){
var inst_19430 = (state_19435[(2)]);
var state_19435__$1 = state_19435;
var statearr_19442_19466 = state_19435__$1;
(statearr_19442_19466[(2)] = inst_19430);

(statearr_19442_19466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (3))){
var inst_19432 = (state_19435[(2)]);
var inst_19433 = cljs.core.async.close_BANG_.call(null,out);
var state_19435__$1 = (function (){var statearr_19443 = state_19435;
(statearr_19443[(9)] = inst_19432);

return statearr_19443;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19435__$1,inst_19433);
} else {
if((state_val_19436 === (2))){
var inst_19412 = (state_19435[(8)]);
var inst_19414 = (inst_19412 < n);
var state_19435__$1 = state_19435;
if(cljs.core.truth_(inst_19414)){
var statearr_19444_19467 = state_19435__$1;
(statearr_19444_19467[(1)] = (4));

} else {
var statearr_19445_19468 = state_19435__$1;
(statearr_19445_19468[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (11))){
var inst_19412 = (state_19435[(8)]);
var inst_19422 = (state_19435[(2)]);
var inst_19423 = (inst_19412 + (1));
var inst_19412__$1 = inst_19423;
var state_19435__$1 = (function (){var statearr_19446 = state_19435;
(statearr_19446[(10)] = inst_19422);

(statearr_19446[(8)] = inst_19412__$1);

return statearr_19446;
})();
var statearr_19447_19469 = state_19435__$1;
(statearr_19447_19469[(2)] = null);

(statearr_19447_19469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (9))){
var state_19435__$1 = state_19435;
var statearr_19448_19470 = state_19435__$1;
(statearr_19448_19470[(2)] = null);

(statearr_19448_19470[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (5))){
var state_19435__$1 = state_19435;
var statearr_19449_19471 = state_19435__$1;
(statearr_19449_19471[(2)] = null);

(statearr_19449_19471[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (10))){
var inst_19427 = (state_19435[(2)]);
var state_19435__$1 = state_19435;
var statearr_19450_19472 = state_19435__$1;
(statearr_19450_19472[(2)] = inst_19427);

(statearr_19450_19472[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (8))){
var inst_19417 = (state_19435[(7)]);
var state_19435__$1 = state_19435;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19435__$1,(11),out,inst_19417);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19462,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19462,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19454 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19454[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19454[(1)] = (1));

return statearr_19454;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19435){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19435);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19455){if((e19455 instanceof Object)){
var ex__8254__auto__ = e19455;
var statearr_19456_19473 = state_19435;
(statearr_19456_19473[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19435);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19455;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19474 = state_19435;
state_19435 = G__19474;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19435){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19462,out))
})();
var state__8364__auto__ = (function (){var statearr_19457 = f__8363__auto__.call(null);
(statearr_19457[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19462);

return statearr_19457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19462,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19482 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19482 = (function (map_LT_,f,ch,meta19483){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19483 = meta19483;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19484,meta19483__$1){
var self__ = this;
var _19484__$1 = this;
return (new cljs.core.async.t_cljs$core$async19482(self__.map_LT_,self__.f,self__.ch,meta19483__$1));
});

cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19484){
var self__ = this;
var _19484__$1 = this;
return self__.meta19483;
});

cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19485 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19485 = (function (map_LT_,f,ch,meta19483,_,fn1,meta19486){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19483 = meta19483;
this._ = _;
this.fn1 = fn1;
this.meta19486 = meta19486;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19485.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19487,meta19486__$1){
var self__ = this;
var _19487__$1 = this;
return (new cljs.core.async.t_cljs$core$async19485(self__.map_LT_,self__.f,self__.ch,self__.meta19483,self__._,self__.fn1,meta19486__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19485.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19487){
var self__ = this;
var _19487__$1 = this;
return self__.meta19486;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19485.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19485.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19485.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19485.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19475_SHARP_){
return f1.call(null,(((p1__19475_SHARP_ == null))?null:self__.f.call(null,p1__19475_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19485.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19483","meta19483",-1082780467,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19482","cljs.core.async/t_cljs$core$async19482",-465652337,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19486","meta19486",-1239531958,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19485.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19485.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19485";

cljs.core.async.t_cljs$core$async19485.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19485");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19485 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19485(map_LT___$1,f__$1,ch__$1,meta19483__$1,___$2,fn1__$1,meta19486){
return (new cljs.core.async.t_cljs$core$async19485(map_LT___$1,f__$1,ch__$1,meta19483__$1,___$2,fn1__$1,meta19486));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19485(self__.map_LT_,self__.f,self__.ch,self__.meta19483,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19482.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19482.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19483","meta19483",-1082780467,null)], null);
});

cljs.core.async.t_cljs$core$async19482.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19482.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19482";

cljs.core.async.t_cljs$core$async19482.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19482");
});

cljs.core.async.__GT_t_cljs$core$async19482 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19482(map_LT___$1,f__$1,ch__$1,meta19483){
return (new cljs.core.async.t_cljs$core$async19482(map_LT___$1,f__$1,ch__$1,meta19483));
});

}

return (new cljs.core.async.t_cljs$core$async19482(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19491 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19491 = (function (map_GT_,f,ch,meta19492){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19492 = meta19492;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19491.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19493,meta19492__$1){
var self__ = this;
var _19493__$1 = this;
return (new cljs.core.async.t_cljs$core$async19491(self__.map_GT_,self__.f,self__.ch,meta19492__$1));
});

cljs.core.async.t_cljs$core$async19491.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19493){
var self__ = this;
var _19493__$1 = this;
return self__.meta19492;
});

cljs.core.async.t_cljs$core$async19491.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19491.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19491.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19491.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19491.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19491.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19491.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19492","meta19492",-520794714,null)], null);
});

cljs.core.async.t_cljs$core$async19491.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19491.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19491";

cljs.core.async.t_cljs$core$async19491.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19491");
});

cljs.core.async.__GT_t_cljs$core$async19491 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19491(map_GT___$1,f__$1,ch__$1,meta19492){
return (new cljs.core.async.t_cljs$core$async19491(map_GT___$1,f__$1,ch__$1,meta19492));
});

}

return (new cljs.core.async.t_cljs$core$async19491(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19497 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19497 = (function (filter_GT_,p,ch,meta19498){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19498 = meta19498;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19499,meta19498__$1){
var self__ = this;
var _19499__$1 = this;
return (new cljs.core.async.t_cljs$core$async19497(self__.filter_GT_,self__.p,self__.ch,meta19498__$1));
});

cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19499){
var self__ = this;
var _19499__$1 = this;
return self__.meta19498;
});

cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19497.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19497.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19498","meta19498",-50737062,null)], null);
});

cljs.core.async.t_cljs$core$async19497.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19497.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19497";

cljs.core.async.t_cljs$core$async19497.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19497");
});

cljs.core.async.__GT_t_cljs$core$async19497 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19497(filter_GT___$1,p__$1,ch__$1,meta19498){
return (new cljs.core.async.t_cljs$core$async19497(filter_GT___$1,p__$1,ch__$1,meta19498));
});

}

return (new cljs.core.async.t_cljs$core$async19497(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19500 = [];
var len__5726__auto___19544 = arguments.length;
var i__5727__auto___19545 = (0);
while(true){
if((i__5727__auto___19545 < len__5726__auto___19544)){
args19500.push((arguments[i__5727__auto___19545]));

var G__19546 = (i__5727__auto___19545 + (1));
i__5727__auto___19545 = G__19546;
continue;
} else {
}
break;
}

var G__19502 = args19500.length;
switch (G__19502) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19500.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19548 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19548,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19548,out){
return (function (state_19523){
var state_val_19524 = (state_19523[(1)]);
if((state_val_19524 === (7))){
var inst_19519 = (state_19523[(2)]);
var state_19523__$1 = state_19523;
var statearr_19525_19549 = state_19523__$1;
(statearr_19525_19549[(2)] = inst_19519);

(statearr_19525_19549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19524 === (1))){
var state_19523__$1 = state_19523;
var statearr_19526_19550 = state_19523__$1;
(statearr_19526_19550[(2)] = null);

(statearr_19526_19550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19524 === (4))){
var inst_19505 = (state_19523[(7)]);
var inst_19505__$1 = (state_19523[(2)]);
var inst_19506 = (inst_19505__$1 == null);
var state_19523__$1 = (function (){var statearr_19527 = state_19523;
(statearr_19527[(7)] = inst_19505__$1);

return statearr_19527;
})();
if(cljs.core.truth_(inst_19506)){
var statearr_19528_19551 = state_19523__$1;
(statearr_19528_19551[(1)] = (5));

} else {
var statearr_19529_19552 = state_19523__$1;
(statearr_19529_19552[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19524 === (6))){
var inst_19505 = (state_19523[(7)]);
var inst_19510 = p.call(null,inst_19505);
var state_19523__$1 = state_19523;
if(cljs.core.truth_(inst_19510)){
var statearr_19530_19553 = state_19523__$1;
(statearr_19530_19553[(1)] = (8));

} else {
var statearr_19531_19554 = state_19523__$1;
(statearr_19531_19554[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19524 === (3))){
var inst_19521 = (state_19523[(2)]);
var state_19523__$1 = state_19523;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19523__$1,inst_19521);
} else {
if((state_val_19524 === (2))){
var state_19523__$1 = state_19523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19523__$1,(4),ch);
} else {
if((state_val_19524 === (11))){
var inst_19513 = (state_19523[(2)]);
var state_19523__$1 = state_19523;
var statearr_19532_19555 = state_19523__$1;
(statearr_19532_19555[(2)] = inst_19513);

(statearr_19532_19555[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19524 === (9))){
var state_19523__$1 = state_19523;
var statearr_19533_19556 = state_19523__$1;
(statearr_19533_19556[(2)] = null);

(statearr_19533_19556[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19524 === (5))){
var inst_19508 = cljs.core.async.close_BANG_.call(null,out);
var state_19523__$1 = state_19523;
var statearr_19534_19557 = state_19523__$1;
(statearr_19534_19557[(2)] = inst_19508);

(statearr_19534_19557[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19524 === (10))){
var inst_19516 = (state_19523[(2)]);
var state_19523__$1 = (function (){var statearr_19535 = state_19523;
(statearr_19535[(8)] = inst_19516);

return statearr_19535;
})();
var statearr_19536_19558 = state_19523__$1;
(statearr_19536_19558[(2)] = null);

(statearr_19536_19558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19524 === (8))){
var inst_19505 = (state_19523[(7)]);
var state_19523__$1 = state_19523;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19523__$1,(11),out,inst_19505);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19548,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19548,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19540 = [null,null,null,null,null,null,null,null,null];
(statearr_19540[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19540[(1)] = (1));

return statearr_19540;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19523){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19541){if((e19541 instanceof Object)){
var ex__8254__auto__ = e19541;
var statearr_19542_19559 = state_19523;
(statearr_19542_19559[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19523);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19541;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19560 = state_19523;
state_19523 = G__19560;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19523){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19548,out))
})();
var state__8364__auto__ = (function (){var statearr_19543 = f__8363__auto__.call(null);
(statearr_19543[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19548);

return statearr_19543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19548,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19561 = [];
var len__5726__auto___19564 = arguments.length;
var i__5727__auto___19565 = (0);
while(true){
if((i__5727__auto___19565 < len__5726__auto___19564)){
args19561.push((arguments[i__5727__auto___19565]));

var G__19566 = (i__5727__auto___19565 + (1));
i__5727__auto___19565 = G__19566;
continue;
} else {
}
break;
}

var G__19563 = args19561.length;
switch (G__19563) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19561.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19733){
var state_val_19734 = (state_19733[(1)]);
if((state_val_19734 === (7))){
var inst_19729 = (state_19733[(2)]);
var state_19733__$1 = state_19733;
var statearr_19735_19776 = state_19733__$1;
(statearr_19735_19776[(2)] = inst_19729);

(statearr_19735_19776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (20))){
var inst_19699 = (state_19733[(7)]);
var inst_19710 = (state_19733[(2)]);
var inst_19711 = cljs.core.next.call(null,inst_19699);
var inst_19685 = inst_19711;
var inst_19686 = null;
var inst_19687 = (0);
var inst_19688 = (0);
var state_19733__$1 = (function (){var statearr_19736 = state_19733;
(statearr_19736[(8)] = inst_19688);

(statearr_19736[(9)] = inst_19685);

(statearr_19736[(10)] = inst_19686);

(statearr_19736[(11)] = inst_19687);

(statearr_19736[(12)] = inst_19710);

return statearr_19736;
})();
var statearr_19737_19777 = state_19733__$1;
(statearr_19737_19777[(2)] = null);

(statearr_19737_19777[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (1))){
var state_19733__$1 = state_19733;
var statearr_19738_19778 = state_19733__$1;
(statearr_19738_19778[(2)] = null);

(statearr_19738_19778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (4))){
var inst_19674 = (state_19733[(13)]);
var inst_19674__$1 = (state_19733[(2)]);
var inst_19675 = (inst_19674__$1 == null);
var state_19733__$1 = (function (){var statearr_19739 = state_19733;
(statearr_19739[(13)] = inst_19674__$1);

return statearr_19739;
})();
if(cljs.core.truth_(inst_19675)){
var statearr_19740_19779 = state_19733__$1;
(statearr_19740_19779[(1)] = (5));

} else {
var statearr_19741_19780 = state_19733__$1;
(statearr_19741_19780[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (15))){
var state_19733__$1 = state_19733;
var statearr_19745_19781 = state_19733__$1;
(statearr_19745_19781[(2)] = null);

(statearr_19745_19781[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (21))){
var state_19733__$1 = state_19733;
var statearr_19746_19782 = state_19733__$1;
(statearr_19746_19782[(2)] = null);

(statearr_19746_19782[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (13))){
var inst_19688 = (state_19733[(8)]);
var inst_19685 = (state_19733[(9)]);
var inst_19686 = (state_19733[(10)]);
var inst_19687 = (state_19733[(11)]);
var inst_19695 = (state_19733[(2)]);
var inst_19696 = (inst_19688 + (1));
var tmp19742 = inst_19685;
var tmp19743 = inst_19686;
var tmp19744 = inst_19687;
var inst_19685__$1 = tmp19742;
var inst_19686__$1 = tmp19743;
var inst_19687__$1 = tmp19744;
var inst_19688__$1 = inst_19696;
var state_19733__$1 = (function (){var statearr_19747 = state_19733;
(statearr_19747[(8)] = inst_19688__$1);

(statearr_19747[(9)] = inst_19685__$1);

(statearr_19747[(14)] = inst_19695);

(statearr_19747[(10)] = inst_19686__$1);

(statearr_19747[(11)] = inst_19687__$1);

return statearr_19747;
})();
var statearr_19748_19783 = state_19733__$1;
(statearr_19748_19783[(2)] = null);

(statearr_19748_19783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (22))){
var state_19733__$1 = state_19733;
var statearr_19749_19784 = state_19733__$1;
(statearr_19749_19784[(2)] = null);

(statearr_19749_19784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (6))){
var inst_19674 = (state_19733[(13)]);
var inst_19683 = f.call(null,inst_19674);
var inst_19684 = cljs.core.seq.call(null,inst_19683);
var inst_19685 = inst_19684;
var inst_19686 = null;
var inst_19687 = (0);
var inst_19688 = (0);
var state_19733__$1 = (function (){var statearr_19750 = state_19733;
(statearr_19750[(8)] = inst_19688);

(statearr_19750[(9)] = inst_19685);

(statearr_19750[(10)] = inst_19686);

(statearr_19750[(11)] = inst_19687);

return statearr_19750;
})();
var statearr_19751_19785 = state_19733__$1;
(statearr_19751_19785[(2)] = null);

(statearr_19751_19785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (17))){
var inst_19699 = (state_19733[(7)]);
var inst_19703 = cljs.core.chunk_first.call(null,inst_19699);
var inst_19704 = cljs.core.chunk_rest.call(null,inst_19699);
var inst_19705 = cljs.core.count.call(null,inst_19703);
var inst_19685 = inst_19704;
var inst_19686 = inst_19703;
var inst_19687 = inst_19705;
var inst_19688 = (0);
var state_19733__$1 = (function (){var statearr_19752 = state_19733;
(statearr_19752[(8)] = inst_19688);

(statearr_19752[(9)] = inst_19685);

(statearr_19752[(10)] = inst_19686);

(statearr_19752[(11)] = inst_19687);

return statearr_19752;
})();
var statearr_19753_19786 = state_19733__$1;
(statearr_19753_19786[(2)] = null);

(statearr_19753_19786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (3))){
var inst_19731 = (state_19733[(2)]);
var state_19733__$1 = state_19733;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19733__$1,inst_19731);
} else {
if((state_val_19734 === (12))){
var inst_19719 = (state_19733[(2)]);
var state_19733__$1 = state_19733;
var statearr_19754_19787 = state_19733__$1;
(statearr_19754_19787[(2)] = inst_19719);

(statearr_19754_19787[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (2))){
var state_19733__$1 = state_19733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19733__$1,(4),in$);
} else {
if((state_val_19734 === (23))){
var inst_19727 = (state_19733[(2)]);
var state_19733__$1 = state_19733;
var statearr_19755_19788 = state_19733__$1;
(statearr_19755_19788[(2)] = inst_19727);

(statearr_19755_19788[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (19))){
var inst_19714 = (state_19733[(2)]);
var state_19733__$1 = state_19733;
var statearr_19756_19789 = state_19733__$1;
(statearr_19756_19789[(2)] = inst_19714);

(statearr_19756_19789[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (11))){
var inst_19685 = (state_19733[(9)]);
var inst_19699 = (state_19733[(7)]);
var inst_19699__$1 = cljs.core.seq.call(null,inst_19685);
var state_19733__$1 = (function (){var statearr_19757 = state_19733;
(statearr_19757[(7)] = inst_19699__$1);

return statearr_19757;
})();
if(inst_19699__$1){
var statearr_19758_19790 = state_19733__$1;
(statearr_19758_19790[(1)] = (14));

} else {
var statearr_19759_19791 = state_19733__$1;
(statearr_19759_19791[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (9))){
var inst_19721 = (state_19733[(2)]);
var inst_19722 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19733__$1 = (function (){var statearr_19760 = state_19733;
(statearr_19760[(15)] = inst_19721);

return statearr_19760;
})();
if(cljs.core.truth_(inst_19722)){
var statearr_19761_19792 = state_19733__$1;
(statearr_19761_19792[(1)] = (21));

} else {
var statearr_19762_19793 = state_19733__$1;
(statearr_19762_19793[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (5))){
var inst_19677 = cljs.core.async.close_BANG_.call(null,out);
var state_19733__$1 = state_19733;
var statearr_19763_19794 = state_19733__$1;
(statearr_19763_19794[(2)] = inst_19677);

(statearr_19763_19794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (14))){
var inst_19699 = (state_19733[(7)]);
var inst_19701 = cljs.core.chunked_seq_QMARK_.call(null,inst_19699);
var state_19733__$1 = state_19733;
if(inst_19701){
var statearr_19764_19795 = state_19733__$1;
(statearr_19764_19795[(1)] = (17));

} else {
var statearr_19765_19796 = state_19733__$1;
(statearr_19765_19796[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (16))){
var inst_19717 = (state_19733[(2)]);
var state_19733__$1 = state_19733;
var statearr_19766_19797 = state_19733__$1;
(statearr_19766_19797[(2)] = inst_19717);

(statearr_19766_19797[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19734 === (10))){
var inst_19688 = (state_19733[(8)]);
var inst_19686 = (state_19733[(10)]);
var inst_19693 = cljs.core._nth.call(null,inst_19686,inst_19688);
var state_19733__$1 = state_19733;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19733__$1,(13),out,inst_19693);
} else {
if((state_val_19734 === (18))){
var inst_19699 = (state_19733[(7)]);
var inst_19708 = cljs.core.first.call(null,inst_19699);
var state_19733__$1 = state_19733;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19733__$1,(20),out,inst_19708);
} else {
if((state_val_19734 === (8))){
var inst_19688 = (state_19733[(8)]);
var inst_19687 = (state_19733[(11)]);
var inst_19690 = (inst_19688 < inst_19687);
var inst_19691 = inst_19690;
var state_19733__$1 = state_19733;
if(cljs.core.truth_(inst_19691)){
var statearr_19767_19798 = state_19733__$1;
(statearr_19767_19798[(1)] = (10));

} else {
var statearr_19768_19799 = state_19733__$1;
(statearr_19768_19799[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19772 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19772[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19772[(1)] = (1));

return statearr_19772;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19733){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19733);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19773){if((e19773 instanceof Object)){
var ex__8254__auto__ = e19773;
var statearr_19774_19800 = state_19733;
(statearr_19774_19800[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19733);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19773;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19801 = state_19733;
state_19733 = G__19801;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19733){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19775 = f__8363__auto__.call(null);
(statearr_19775[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19802 = [];
var len__5726__auto___19805 = arguments.length;
var i__5727__auto___19806 = (0);
while(true){
if((i__5727__auto___19806 < len__5726__auto___19805)){
args19802.push((arguments[i__5727__auto___19806]));

var G__19807 = (i__5727__auto___19806 + (1));
i__5727__auto___19806 = G__19807;
continue;
} else {
}
break;
}

var G__19804 = args19802.length;
switch (G__19804) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19802.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19809 = [];
var len__5726__auto___19812 = arguments.length;
var i__5727__auto___19813 = (0);
while(true){
if((i__5727__auto___19813 < len__5726__auto___19812)){
args19809.push((arguments[i__5727__auto___19813]));

var G__19814 = (i__5727__auto___19813 + (1));
i__5727__auto___19813 = G__19814;
continue;
} else {
}
break;
}

var G__19811 = args19809.length;
switch (G__19811) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19809.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19816 = [];
var len__5726__auto___19867 = arguments.length;
var i__5727__auto___19868 = (0);
while(true){
if((i__5727__auto___19868 < len__5726__auto___19867)){
args19816.push((arguments[i__5727__auto___19868]));

var G__19869 = (i__5727__auto___19868 + (1));
i__5727__auto___19868 = G__19869;
continue;
} else {
}
break;
}

var G__19818 = args19816.length;
switch (G__19818) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19816.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19871 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19871,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19871,out){
return (function (state_19842){
var state_val_19843 = (state_19842[(1)]);
if((state_val_19843 === (7))){
var inst_19837 = (state_19842[(2)]);
var state_19842__$1 = state_19842;
var statearr_19844_19872 = state_19842__$1;
(statearr_19844_19872[(2)] = inst_19837);

(statearr_19844_19872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19843 === (1))){
var inst_19819 = null;
var state_19842__$1 = (function (){var statearr_19845 = state_19842;
(statearr_19845[(7)] = inst_19819);

return statearr_19845;
})();
var statearr_19846_19873 = state_19842__$1;
(statearr_19846_19873[(2)] = null);

(statearr_19846_19873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19843 === (4))){
var inst_19822 = (state_19842[(8)]);
var inst_19822__$1 = (state_19842[(2)]);
var inst_19823 = (inst_19822__$1 == null);
var inst_19824 = cljs.core.not.call(null,inst_19823);
var state_19842__$1 = (function (){var statearr_19847 = state_19842;
(statearr_19847[(8)] = inst_19822__$1);

return statearr_19847;
})();
if(inst_19824){
var statearr_19848_19874 = state_19842__$1;
(statearr_19848_19874[(1)] = (5));

} else {
var statearr_19849_19875 = state_19842__$1;
(statearr_19849_19875[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19843 === (6))){
var state_19842__$1 = state_19842;
var statearr_19850_19876 = state_19842__$1;
(statearr_19850_19876[(2)] = null);

(statearr_19850_19876[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19843 === (3))){
var inst_19839 = (state_19842[(2)]);
var inst_19840 = cljs.core.async.close_BANG_.call(null,out);
var state_19842__$1 = (function (){var statearr_19851 = state_19842;
(statearr_19851[(9)] = inst_19839);

return statearr_19851;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19842__$1,inst_19840);
} else {
if((state_val_19843 === (2))){
var state_19842__$1 = state_19842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19842__$1,(4),ch);
} else {
if((state_val_19843 === (11))){
var inst_19822 = (state_19842[(8)]);
var inst_19831 = (state_19842[(2)]);
var inst_19819 = inst_19822;
var state_19842__$1 = (function (){var statearr_19852 = state_19842;
(statearr_19852[(10)] = inst_19831);

(statearr_19852[(7)] = inst_19819);

return statearr_19852;
})();
var statearr_19853_19877 = state_19842__$1;
(statearr_19853_19877[(2)] = null);

(statearr_19853_19877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19843 === (9))){
var inst_19822 = (state_19842[(8)]);
var state_19842__$1 = state_19842;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19842__$1,(11),out,inst_19822);
} else {
if((state_val_19843 === (5))){
var inst_19822 = (state_19842[(8)]);
var inst_19819 = (state_19842[(7)]);
var inst_19826 = cljs.core._EQ_.call(null,inst_19822,inst_19819);
var state_19842__$1 = state_19842;
if(inst_19826){
var statearr_19855_19878 = state_19842__$1;
(statearr_19855_19878[(1)] = (8));

} else {
var statearr_19856_19879 = state_19842__$1;
(statearr_19856_19879[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19843 === (10))){
var inst_19834 = (state_19842[(2)]);
var state_19842__$1 = state_19842;
var statearr_19857_19880 = state_19842__$1;
(statearr_19857_19880[(2)] = inst_19834);

(statearr_19857_19880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19843 === (8))){
var inst_19819 = (state_19842[(7)]);
var tmp19854 = inst_19819;
var inst_19819__$1 = tmp19854;
var state_19842__$1 = (function (){var statearr_19858 = state_19842;
(statearr_19858[(7)] = inst_19819__$1);

return statearr_19858;
})();
var statearr_19859_19881 = state_19842__$1;
(statearr_19859_19881[(2)] = null);

(statearr_19859_19881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19871,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19871,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19863 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19863[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19863[(1)] = (1));

return statearr_19863;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19842){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19864){if((e19864 instanceof Object)){
var ex__8254__auto__ = e19864;
var statearr_19865_19882 = state_19842;
(statearr_19865_19882[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19864;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19883 = state_19842;
state_19842 = G__19883;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19842){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19871,out))
})();
var state__8364__auto__ = (function (){var statearr_19866 = f__8363__auto__.call(null);
(statearr_19866[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19871);

return statearr_19866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19871,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19884 = [];
var len__5726__auto___19954 = arguments.length;
var i__5727__auto___19955 = (0);
while(true){
if((i__5727__auto___19955 < len__5726__auto___19954)){
args19884.push((arguments[i__5727__auto___19955]));

var G__19956 = (i__5727__auto___19955 + (1));
i__5727__auto___19955 = G__19956;
continue;
} else {
}
break;
}

var G__19886 = args19884.length;
switch (G__19886) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19884.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19958 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19958,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19958,out){
return (function (state_19924){
var state_val_19925 = (state_19924[(1)]);
if((state_val_19925 === (7))){
var inst_19920 = (state_19924[(2)]);
var state_19924__$1 = state_19924;
var statearr_19926_19959 = state_19924__$1;
(statearr_19926_19959[(2)] = inst_19920);

(statearr_19926_19959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (1))){
var inst_19887 = (new Array(n));
var inst_19888 = inst_19887;
var inst_19889 = (0);
var state_19924__$1 = (function (){var statearr_19927 = state_19924;
(statearr_19927[(7)] = inst_19889);

(statearr_19927[(8)] = inst_19888);

return statearr_19927;
})();
var statearr_19928_19960 = state_19924__$1;
(statearr_19928_19960[(2)] = null);

(statearr_19928_19960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (4))){
var inst_19892 = (state_19924[(9)]);
var inst_19892__$1 = (state_19924[(2)]);
var inst_19893 = (inst_19892__$1 == null);
var inst_19894 = cljs.core.not.call(null,inst_19893);
var state_19924__$1 = (function (){var statearr_19929 = state_19924;
(statearr_19929[(9)] = inst_19892__$1);

return statearr_19929;
})();
if(inst_19894){
var statearr_19930_19961 = state_19924__$1;
(statearr_19930_19961[(1)] = (5));

} else {
var statearr_19931_19962 = state_19924__$1;
(statearr_19931_19962[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (15))){
var inst_19914 = (state_19924[(2)]);
var state_19924__$1 = state_19924;
var statearr_19932_19963 = state_19924__$1;
(statearr_19932_19963[(2)] = inst_19914);

(statearr_19932_19963[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (13))){
var state_19924__$1 = state_19924;
var statearr_19933_19964 = state_19924__$1;
(statearr_19933_19964[(2)] = null);

(statearr_19933_19964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (6))){
var inst_19889 = (state_19924[(7)]);
var inst_19910 = (inst_19889 > (0));
var state_19924__$1 = state_19924;
if(cljs.core.truth_(inst_19910)){
var statearr_19934_19965 = state_19924__$1;
(statearr_19934_19965[(1)] = (12));

} else {
var statearr_19935_19966 = state_19924__$1;
(statearr_19935_19966[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (3))){
var inst_19922 = (state_19924[(2)]);
var state_19924__$1 = state_19924;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19924__$1,inst_19922);
} else {
if((state_val_19925 === (12))){
var inst_19888 = (state_19924[(8)]);
var inst_19912 = cljs.core.vec.call(null,inst_19888);
var state_19924__$1 = state_19924;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19924__$1,(15),out,inst_19912);
} else {
if((state_val_19925 === (2))){
var state_19924__$1 = state_19924;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19924__$1,(4),ch);
} else {
if((state_val_19925 === (11))){
var inst_19904 = (state_19924[(2)]);
var inst_19905 = (new Array(n));
var inst_19888 = inst_19905;
var inst_19889 = (0);
var state_19924__$1 = (function (){var statearr_19936 = state_19924;
(statearr_19936[(7)] = inst_19889);

(statearr_19936[(8)] = inst_19888);

(statearr_19936[(10)] = inst_19904);

return statearr_19936;
})();
var statearr_19937_19967 = state_19924__$1;
(statearr_19937_19967[(2)] = null);

(statearr_19937_19967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (9))){
var inst_19888 = (state_19924[(8)]);
var inst_19902 = cljs.core.vec.call(null,inst_19888);
var state_19924__$1 = state_19924;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19924__$1,(11),out,inst_19902);
} else {
if((state_val_19925 === (5))){
var inst_19897 = (state_19924[(11)]);
var inst_19889 = (state_19924[(7)]);
var inst_19892 = (state_19924[(9)]);
var inst_19888 = (state_19924[(8)]);
var inst_19896 = (inst_19888[inst_19889] = inst_19892);
var inst_19897__$1 = (inst_19889 + (1));
var inst_19898 = (inst_19897__$1 < n);
var state_19924__$1 = (function (){var statearr_19938 = state_19924;
(statearr_19938[(11)] = inst_19897__$1);

(statearr_19938[(12)] = inst_19896);

return statearr_19938;
})();
if(cljs.core.truth_(inst_19898)){
var statearr_19939_19968 = state_19924__$1;
(statearr_19939_19968[(1)] = (8));

} else {
var statearr_19940_19969 = state_19924__$1;
(statearr_19940_19969[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (14))){
var inst_19917 = (state_19924[(2)]);
var inst_19918 = cljs.core.async.close_BANG_.call(null,out);
var state_19924__$1 = (function (){var statearr_19942 = state_19924;
(statearr_19942[(13)] = inst_19917);

return statearr_19942;
})();
var statearr_19943_19970 = state_19924__$1;
(statearr_19943_19970[(2)] = inst_19918);

(statearr_19943_19970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (10))){
var inst_19908 = (state_19924[(2)]);
var state_19924__$1 = state_19924;
var statearr_19944_19971 = state_19924__$1;
(statearr_19944_19971[(2)] = inst_19908);

(statearr_19944_19971[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19925 === (8))){
var inst_19897 = (state_19924[(11)]);
var inst_19888 = (state_19924[(8)]);
var tmp19941 = inst_19888;
var inst_19888__$1 = tmp19941;
var inst_19889 = inst_19897;
var state_19924__$1 = (function (){var statearr_19945 = state_19924;
(statearr_19945[(7)] = inst_19889);

(statearr_19945[(8)] = inst_19888__$1);

return statearr_19945;
})();
var statearr_19946_19972 = state_19924__$1;
(statearr_19946_19972[(2)] = null);

(statearr_19946_19972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19958,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19958,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19950 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19950[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19950[(1)] = (1));

return statearr_19950;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19924){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19924);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19951){if((e19951 instanceof Object)){
var ex__8254__auto__ = e19951;
var statearr_19952_19973 = state_19924;
(statearr_19952_19973[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19924);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19951;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19974 = state_19924;
state_19924 = G__19974;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19924){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19958,out))
})();
var state__8364__auto__ = (function (){var statearr_19953 = f__8363__auto__.call(null);
(statearr_19953[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19958);

return statearr_19953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19958,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19975 = [];
var len__5726__auto___20049 = arguments.length;
var i__5727__auto___20050 = (0);
while(true){
if((i__5727__auto___20050 < len__5726__auto___20049)){
args19975.push((arguments[i__5727__auto___20050]));

var G__20051 = (i__5727__auto___20050 + (1));
i__5727__auto___20050 = G__20051;
continue;
} else {
}
break;
}

var G__19977 = args19975.length;
switch (G__19977) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19975.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20053 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20053,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20053,out){
return (function (state_20019){
var state_val_20020 = (state_20019[(1)]);
if((state_val_20020 === (7))){
var inst_20015 = (state_20019[(2)]);
var state_20019__$1 = state_20019;
var statearr_20021_20054 = state_20019__$1;
(statearr_20021_20054[(2)] = inst_20015);

(statearr_20021_20054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (1))){
var inst_19978 = [];
var inst_19979 = inst_19978;
var inst_19980 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20019__$1 = (function (){var statearr_20022 = state_20019;
(statearr_20022[(7)] = inst_19979);

(statearr_20022[(8)] = inst_19980);

return statearr_20022;
})();
var statearr_20023_20055 = state_20019__$1;
(statearr_20023_20055[(2)] = null);

(statearr_20023_20055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (4))){
var inst_19983 = (state_20019[(9)]);
var inst_19983__$1 = (state_20019[(2)]);
var inst_19984 = (inst_19983__$1 == null);
var inst_19985 = cljs.core.not.call(null,inst_19984);
var state_20019__$1 = (function (){var statearr_20024 = state_20019;
(statearr_20024[(9)] = inst_19983__$1);

return statearr_20024;
})();
if(inst_19985){
var statearr_20025_20056 = state_20019__$1;
(statearr_20025_20056[(1)] = (5));

} else {
var statearr_20026_20057 = state_20019__$1;
(statearr_20026_20057[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (15))){
var inst_20009 = (state_20019[(2)]);
var state_20019__$1 = state_20019;
var statearr_20027_20058 = state_20019__$1;
(statearr_20027_20058[(2)] = inst_20009);

(statearr_20027_20058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (13))){
var state_20019__$1 = state_20019;
var statearr_20028_20059 = state_20019__$1;
(statearr_20028_20059[(2)] = null);

(statearr_20028_20059[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (6))){
var inst_19979 = (state_20019[(7)]);
var inst_20004 = inst_19979.length;
var inst_20005 = (inst_20004 > (0));
var state_20019__$1 = state_20019;
if(cljs.core.truth_(inst_20005)){
var statearr_20029_20060 = state_20019__$1;
(statearr_20029_20060[(1)] = (12));

} else {
var statearr_20030_20061 = state_20019__$1;
(statearr_20030_20061[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (3))){
var inst_20017 = (state_20019[(2)]);
var state_20019__$1 = state_20019;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20019__$1,inst_20017);
} else {
if((state_val_20020 === (12))){
var inst_19979 = (state_20019[(7)]);
var inst_20007 = cljs.core.vec.call(null,inst_19979);
var state_20019__$1 = state_20019;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20019__$1,(15),out,inst_20007);
} else {
if((state_val_20020 === (2))){
var state_20019__$1 = state_20019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20019__$1,(4),ch);
} else {
if((state_val_20020 === (11))){
var inst_19987 = (state_20019[(10)]);
var inst_19983 = (state_20019[(9)]);
var inst_19997 = (state_20019[(2)]);
var inst_19998 = [];
var inst_19999 = inst_19998.push(inst_19983);
var inst_19979 = inst_19998;
var inst_19980 = inst_19987;
var state_20019__$1 = (function (){var statearr_20031 = state_20019;
(statearr_20031[(11)] = inst_19999);

(statearr_20031[(7)] = inst_19979);

(statearr_20031[(12)] = inst_19997);

(statearr_20031[(8)] = inst_19980);

return statearr_20031;
})();
var statearr_20032_20062 = state_20019__$1;
(statearr_20032_20062[(2)] = null);

(statearr_20032_20062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (9))){
var inst_19979 = (state_20019[(7)]);
var inst_19995 = cljs.core.vec.call(null,inst_19979);
var state_20019__$1 = state_20019;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20019__$1,(11),out,inst_19995);
} else {
if((state_val_20020 === (5))){
var inst_19987 = (state_20019[(10)]);
var inst_19983 = (state_20019[(9)]);
var inst_19980 = (state_20019[(8)]);
var inst_19987__$1 = f.call(null,inst_19983);
var inst_19988 = cljs.core._EQ_.call(null,inst_19987__$1,inst_19980);
var inst_19989 = cljs.core.keyword_identical_QMARK_.call(null,inst_19980,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19990 = (inst_19988) || (inst_19989);
var state_20019__$1 = (function (){var statearr_20033 = state_20019;
(statearr_20033[(10)] = inst_19987__$1);

return statearr_20033;
})();
if(cljs.core.truth_(inst_19990)){
var statearr_20034_20063 = state_20019__$1;
(statearr_20034_20063[(1)] = (8));

} else {
var statearr_20035_20064 = state_20019__$1;
(statearr_20035_20064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (14))){
var inst_20012 = (state_20019[(2)]);
var inst_20013 = cljs.core.async.close_BANG_.call(null,out);
var state_20019__$1 = (function (){var statearr_20037 = state_20019;
(statearr_20037[(13)] = inst_20012);

return statearr_20037;
})();
var statearr_20038_20065 = state_20019__$1;
(statearr_20038_20065[(2)] = inst_20013);

(statearr_20038_20065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (10))){
var inst_20002 = (state_20019[(2)]);
var state_20019__$1 = state_20019;
var statearr_20039_20066 = state_20019__$1;
(statearr_20039_20066[(2)] = inst_20002);

(statearr_20039_20066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20020 === (8))){
var inst_19979 = (state_20019[(7)]);
var inst_19987 = (state_20019[(10)]);
var inst_19983 = (state_20019[(9)]);
var inst_19992 = inst_19979.push(inst_19983);
var tmp20036 = inst_19979;
var inst_19979__$1 = tmp20036;
var inst_19980 = inst_19987;
var state_20019__$1 = (function (){var statearr_20040 = state_20019;
(statearr_20040[(7)] = inst_19979__$1);

(statearr_20040[(14)] = inst_19992);

(statearr_20040[(8)] = inst_19980);

return statearr_20040;
})();
var statearr_20041_20067 = state_20019__$1;
(statearr_20041_20067[(2)] = null);

(statearr_20041_20067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20053,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20053,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_20045 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20045[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_20045[(1)] = (1));

return statearr_20045;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_20019){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_20019);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e20046){if((e20046 instanceof Object)){
var ex__8254__auto__ = e20046;
var statearr_20047_20068 = state_20019;
(statearr_20047_20068[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20019);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20046;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20069 = state_20019;
state_20019 = G__20069;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_20019){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_20019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20053,out))
})();
var state__8364__auto__ = (function (){var statearr_20048 = f__8363__auto__.call(null);
(statearr_20048[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20053);

return statearr_20048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20053,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1459838500689