// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__16268__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__16267 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__16267,(0),null);
var body = cljs.core.nthnext.call(null,vec__16267,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__16268 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16269__i = 0, G__16269__a = new Array(arguments.length -  0);
while (G__16269__i < G__16269__a.length) {G__16269__a[G__16269__i] = arguments[G__16269__i + 0]; ++G__16269__i;}
  args = new cljs.core.IndexedSeq(G__16269__a,0);
} 
return G__16268__delegate.call(this,args);};
G__16268.cljs$lang$maxFixedArity = 0;
G__16268.cljs$lang$applyTo = (function (arglist__16270){
var args = cljs.core.seq(arglist__16270);
return G__16268__delegate(args);
});
G__16268.cljs$core$IFn$_invoke$arity$variadic = G__16268__delegate;
return G__16268;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__16275(s__16276){
return (new cljs.core.LazySeq(null,(function (){
var s__16276__$1 = s__16276;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16276__$1);
if(temp__4425__auto__){
var s__16276__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16276__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16276__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16278 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16277 = (0);
while(true){
if((i__16277 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__16277);
cljs.core.chunk_append.call(null,b__16278,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__16279 = (i__16277 + (1));
i__16277 = G__16279;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16278),sablono$core$update_arglists_$_iter__16275.call(null,cljs.core.chunk_rest.call(null,s__16276__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16278),null);
}
} else {
var args = cljs.core.first.call(null,s__16276__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__16275.call(null,cljs.core.rest.call(null,s__16276__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16285 = arguments.length;
var i__5727__auto___16286 = (0);
while(true){
if((i__5727__auto___16286 < len__5726__auto___16285)){
args__5733__auto__.push((arguments[i__5727__auto___16286]));

var G__16287 = (i__5727__auto___16286 + (1));
i__5727__auto___16286 = G__16287;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__16281(s__16282){
return (new cljs.core.LazySeq(null,(function (){
var s__16282__$1 = s__16282;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16282__$1);
if(temp__4425__auto__){
var s__16282__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16282__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16282__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16284 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16283 = (0);
while(true){
if((i__16283 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__16283);
cljs.core.chunk_append.call(null,b__16284,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__16288 = (i__16283 + (1));
i__16283 = G__16288;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16284),sablono$core$iter__16281.call(null,cljs.core.chunk_rest.call(null,s__16282__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16284),null);
}
} else {
var style = cljs.core.first.call(null,s__16282__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__16281.call(null,cljs.core.rest.call(null,s__16282__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq16280){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16280));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to16289 = (function sablono$core$link_to16289(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16292 = arguments.length;
var i__5727__auto___16293 = (0);
while(true){
if((i__5727__auto___16293 < len__5726__auto___16292)){
args__5733__auto__.push((arguments[i__5727__auto___16293]));

var G__16294 = (i__5727__auto___16293 + (1));
i__5727__auto___16293 = G__16294;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to16289.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to16289.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to16289.cljs$lang$maxFixedArity = (1);

sablono.core.link_to16289.cljs$lang$applyTo = (function (seq16290){
var G__16291 = cljs.core.first.call(null,seq16290);
var seq16290__$1 = cljs.core.next.call(null,seq16290);
return sablono.core.link_to16289.cljs$core$IFn$_invoke$arity$variadic(G__16291,seq16290__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to16289);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to16295 = (function sablono$core$mail_to16295(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16300 = arguments.length;
var i__5727__auto___16301 = (0);
while(true){
if((i__5727__auto___16301 < len__5726__auto___16300)){
args__5733__auto__.push((arguments[i__5727__auto___16301]));

var G__16302 = (i__5727__auto___16301 + (1));
i__5727__auto___16301 = G__16302;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to16295.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to16295.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__16298){
var vec__16299 = p__16298;
var content = cljs.core.nth.call(null,vec__16299,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to16295.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to16295.cljs$lang$applyTo = (function (seq16296){
var G__16297 = cljs.core.first.call(null,seq16296);
var seq16296__$1 = cljs.core.next.call(null,seq16296);
return sablono.core.mail_to16295.cljs$core$IFn$_invoke$arity$variadic(G__16297,seq16296__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to16295);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list16303 = (function sablono$core$unordered_list16303(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list16303_$_iter__16308(s__16309){
return (new cljs.core.LazySeq(null,(function (){
var s__16309__$1 = s__16309;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16309__$1);
if(temp__4425__auto__){
var s__16309__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16309__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16309__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16311 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16310 = (0);
while(true){
if((i__16310 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16310);
cljs.core.chunk_append.call(null,b__16311,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16312 = (i__16310 + (1));
i__16310 = G__16312;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16311),sablono$core$unordered_list16303_$_iter__16308.call(null,cljs.core.chunk_rest.call(null,s__16309__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16311),null);
}
} else {
var x = cljs.core.first.call(null,s__16309__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list16303_$_iter__16308.call(null,cljs.core.rest.call(null,s__16309__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list16303);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list16313 = (function sablono$core$ordered_list16313(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list16313_$_iter__16318(s__16319){
return (new cljs.core.LazySeq(null,(function (){
var s__16319__$1 = s__16319;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16319__$1);
if(temp__4425__auto__){
var s__16319__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16319__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16319__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16321 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16320 = (0);
while(true){
if((i__16320 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16320);
cljs.core.chunk_append.call(null,b__16321,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16322 = (i__16320 + (1));
i__16320 = G__16322;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16321),sablono$core$ordered_list16313_$_iter__16318.call(null,cljs.core.chunk_rest.call(null,s__16319__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16321),null);
}
} else {
var x = cljs.core.first.call(null,s__16319__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list16313_$_iter__16318.call(null,cljs.core.rest.call(null,s__16319__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list16313);
/**
 * Create an image element.
 */
sablono.core.image16323 = (function sablono$core$image16323(var_args){
var args16324 = [];
var len__5726__auto___16327 = arguments.length;
var i__5727__auto___16328 = (0);
while(true){
if((i__5727__auto___16328 < len__5726__auto___16327)){
args16324.push((arguments[i__5727__auto___16328]));

var G__16329 = (i__5727__auto___16328 + (1));
i__5727__auto___16328 = G__16329;
continue;
} else {
}
break;
}

var G__16326 = args16324.length;
switch (G__16326) {
case 1:
return sablono.core.image16323.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image16323.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16324.length)].join('')));

}
});

sablono.core.image16323.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image16323.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image16323.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image16323);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__16331_SHARP_,p2__16332_SHARP_){
return [cljs.core.str(p1__16331_SHARP_),cljs.core.str("["),cljs.core.str(p2__16332_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__16333_SHARP_,p2__16334_SHARP_){
return [cljs.core.str(p1__16333_SHARP_),cljs.core.str("-"),cljs.core.str(p2__16334_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field16335 = (function sablono$core$color_field16335(var_args){
var args16336 = [];
var len__5726__auto___16403 = arguments.length;
var i__5727__auto___16404 = (0);
while(true){
if((i__5727__auto___16404 < len__5726__auto___16403)){
args16336.push((arguments[i__5727__auto___16404]));

var G__16405 = (i__5727__auto___16404 + (1));
i__5727__auto___16404 = G__16405;
continue;
} else {
}
break;
}

var G__16338 = args16336.length;
switch (G__16338) {
case 1:
return sablono.core.color_field16335.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field16335.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16336.length)].join('')));

}
});

sablono.core.color_field16335.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.color_field16335.call(null,name__6340__auto__,null);
});

sablono.core.color_field16335.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.color_field16335.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field16335);

/**
 * Creates a date input field.
 */
sablono.core.date_field16339 = (function sablono$core$date_field16339(var_args){
var args16340 = [];
var len__5726__auto___16407 = arguments.length;
var i__5727__auto___16408 = (0);
while(true){
if((i__5727__auto___16408 < len__5726__auto___16407)){
args16340.push((arguments[i__5727__auto___16408]));

var G__16409 = (i__5727__auto___16408 + (1));
i__5727__auto___16408 = G__16409;
continue;
} else {
}
break;
}

var G__16342 = args16340.length;
switch (G__16342) {
case 1:
return sablono.core.date_field16339.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field16339.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16340.length)].join('')));

}
});

sablono.core.date_field16339.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.date_field16339.call(null,name__6340__auto__,null);
});

sablono.core.date_field16339.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.date_field16339.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field16339);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field16343 = (function sablono$core$datetime_field16343(var_args){
var args16344 = [];
var len__5726__auto___16411 = arguments.length;
var i__5727__auto___16412 = (0);
while(true){
if((i__5727__auto___16412 < len__5726__auto___16411)){
args16344.push((arguments[i__5727__auto___16412]));

var G__16413 = (i__5727__auto___16412 + (1));
i__5727__auto___16412 = G__16413;
continue;
} else {
}
break;
}

var G__16346 = args16344.length;
switch (G__16346) {
case 1:
return sablono.core.datetime_field16343.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field16343.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16344.length)].join('')));

}
});

sablono.core.datetime_field16343.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_field16343.call(null,name__6340__auto__,null);
});

sablono.core.datetime_field16343.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_field16343.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field16343);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field16347 = (function sablono$core$datetime_local_field16347(var_args){
var args16348 = [];
var len__5726__auto___16415 = arguments.length;
var i__5727__auto___16416 = (0);
while(true){
if((i__5727__auto___16416 < len__5726__auto___16415)){
args16348.push((arguments[i__5727__auto___16416]));

var G__16417 = (i__5727__auto___16416 + (1));
i__5727__auto___16416 = G__16417;
continue;
} else {
}
break;
}

var G__16350 = args16348.length;
switch (G__16350) {
case 1:
return sablono.core.datetime_local_field16347.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field16347.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16348.length)].join('')));

}
});

sablono.core.datetime_local_field16347.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_local_field16347.call(null,name__6340__auto__,null);
});

sablono.core.datetime_local_field16347.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_local_field16347.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field16347);

/**
 * Creates a email input field.
 */
sablono.core.email_field16351 = (function sablono$core$email_field16351(var_args){
var args16352 = [];
var len__5726__auto___16419 = arguments.length;
var i__5727__auto___16420 = (0);
while(true){
if((i__5727__auto___16420 < len__5726__auto___16419)){
args16352.push((arguments[i__5727__auto___16420]));

var G__16421 = (i__5727__auto___16420 + (1));
i__5727__auto___16420 = G__16421;
continue;
} else {
}
break;
}

var G__16354 = args16352.length;
switch (G__16354) {
case 1:
return sablono.core.email_field16351.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field16351.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16352.length)].join('')));

}
});

sablono.core.email_field16351.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.email_field16351.call(null,name__6340__auto__,null);
});

sablono.core.email_field16351.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.email_field16351.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field16351);

/**
 * Creates a file input field.
 */
sablono.core.file_field16355 = (function sablono$core$file_field16355(var_args){
var args16356 = [];
var len__5726__auto___16423 = arguments.length;
var i__5727__auto___16424 = (0);
while(true){
if((i__5727__auto___16424 < len__5726__auto___16423)){
args16356.push((arguments[i__5727__auto___16424]));

var G__16425 = (i__5727__auto___16424 + (1));
i__5727__auto___16424 = G__16425;
continue;
} else {
}
break;
}

var G__16358 = args16356.length;
switch (G__16358) {
case 1:
return sablono.core.file_field16355.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field16355.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16356.length)].join('')));

}
});

sablono.core.file_field16355.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.file_field16355.call(null,name__6340__auto__,null);
});

sablono.core.file_field16355.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.file_field16355.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field16355);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field16359 = (function sablono$core$hidden_field16359(var_args){
var args16360 = [];
var len__5726__auto___16427 = arguments.length;
var i__5727__auto___16428 = (0);
while(true){
if((i__5727__auto___16428 < len__5726__auto___16427)){
args16360.push((arguments[i__5727__auto___16428]));

var G__16429 = (i__5727__auto___16428 + (1));
i__5727__auto___16428 = G__16429;
continue;
} else {
}
break;
}

var G__16362 = args16360.length;
switch (G__16362) {
case 1:
return sablono.core.hidden_field16359.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field16359.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16360.length)].join('')));

}
});

sablono.core.hidden_field16359.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.hidden_field16359.call(null,name__6340__auto__,null);
});

sablono.core.hidden_field16359.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.hidden_field16359.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field16359);

/**
 * Creates a month input field.
 */
sablono.core.month_field16363 = (function sablono$core$month_field16363(var_args){
var args16364 = [];
var len__5726__auto___16431 = arguments.length;
var i__5727__auto___16432 = (0);
while(true){
if((i__5727__auto___16432 < len__5726__auto___16431)){
args16364.push((arguments[i__5727__auto___16432]));

var G__16433 = (i__5727__auto___16432 + (1));
i__5727__auto___16432 = G__16433;
continue;
} else {
}
break;
}

var G__16366 = args16364.length;
switch (G__16366) {
case 1:
return sablono.core.month_field16363.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field16363.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16364.length)].join('')));

}
});

sablono.core.month_field16363.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.month_field16363.call(null,name__6340__auto__,null);
});

sablono.core.month_field16363.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.month_field16363.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field16363);

/**
 * Creates a number input field.
 */
sablono.core.number_field16367 = (function sablono$core$number_field16367(var_args){
var args16368 = [];
var len__5726__auto___16435 = arguments.length;
var i__5727__auto___16436 = (0);
while(true){
if((i__5727__auto___16436 < len__5726__auto___16435)){
args16368.push((arguments[i__5727__auto___16436]));

var G__16437 = (i__5727__auto___16436 + (1));
i__5727__auto___16436 = G__16437;
continue;
} else {
}
break;
}

var G__16370 = args16368.length;
switch (G__16370) {
case 1:
return sablono.core.number_field16367.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field16367.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16368.length)].join('')));

}
});

sablono.core.number_field16367.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.number_field16367.call(null,name__6340__auto__,null);
});

sablono.core.number_field16367.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.number_field16367.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field16367);

/**
 * Creates a password input field.
 */
sablono.core.password_field16371 = (function sablono$core$password_field16371(var_args){
var args16372 = [];
var len__5726__auto___16439 = arguments.length;
var i__5727__auto___16440 = (0);
while(true){
if((i__5727__auto___16440 < len__5726__auto___16439)){
args16372.push((arguments[i__5727__auto___16440]));

var G__16441 = (i__5727__auto___16440 + (1));
i__5727__auto___16440 = G__16441;
continue;
} else {
}
break;
}

var G__16374 = args16372.length;
switch (G__16374) {
case 1:
return sablono.core.password_field16371.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field16371.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16372.length)].join('')));

}
});

sablono.core.password_field16371.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.password_field16371.call(null,name__6340__auto__,null);
});

sablono.core.password_field16371.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.password_field16371.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field16371);

/**
 * Creates a range input field.
 */
sablono.core.range_field16375 = (function sablono$core$range_field16375(var_args){
var args16376 = [];
var len__5726__auto___16443 = arguments.length;
var i__5727__auto___16444 = (0);
while(true){
if((i__5727__auto___16444 < len__5726__auto___16443)){
args16376.push((arguments[i__5727__auto___16444]));

var G__16445 = (i__5727__auto___16444 + (1));
i__5727__auto___16444 = G__16445;
continue;
} else {
}
break;
}

var G__16378 = args16376.length;
switch (G__16378) {
case 1:
return sablono.core.range_field16375.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field16375.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16376.length)].join('')));

}
});

sablono.core.range_field16375.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.range_field16375.call(null,name__6340__auto__,null);
});

sablono.core.range_field16375.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.range_field16375.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field16375);

/**
 * Creates a search input field.
 */
sablono.core.search_field16379 = (function sablono$core$search_field16379(var_args){
var args16380 = [];
var len__5726__auto___16447 = arguments.length;
var i__5727__auto___16448 = (0);
while(true){
if((i__5727__auto___16448 < len__5726__auto___16447)){
args16380.push((arguments[i__5727__auto___16448]));

var G__16449 = (i__5727__auto___16448 + (1));
i__5727__auto___16448 = G__16449;
continue;
} else {
}
break;
}

var G__16382 = args16380.length;
switch (G__16382) {
case 1:
return sablono.core.search_field16379.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field16379.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16380.length)].join('')));

}
});

sablono.core.search_field16379.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.search_field16379.call(null,name__6340__auto__,null);
});

sablono.core.search_field16379.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.search_field16379.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field16379);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field16383 = (function sablono$core$tel_field16383(var_args){
var args16384 = [];
var len__5726__auto___16451 = arguments.length;
var i__5727__auto___16452 = (0);
while(true){
if((i__5727__auto___16452 < len__5726__auto___16451)){
args16384.push((arguments[i__5727__auto___16452]));

var G__16453 = (i__5727__auto___16452 + (1));
i__5727__auto___16452 = G__16453;
continue;
} else {
}
break;
}

var G__16386 = args16384.length;
switch (G__16386) {
case 1:
return sablono.core.tel_field16383.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field16383.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16384.length)].join('')));

}
});

sablono.core.tel_field16383.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.tel_field16383.call(null,name__6340__auto__,null);
});

sablono.core.tel_field16383.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.tel_field16383.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field16383);

/**
 * Creates a text input field.
 */
sablono.core.text_field16387 = (function sablono$core$text_field16387(var_args){
var args16388 = [];
var len__5726__auto___16455 = arguments.length;
var i__5727__auto___16456 = (0);
while(true){
if((i__5727__auto___16456 < len__5726__auto___16455)){
args16388.push((arguments[i__5727__auto___16456]));

var G__16457 = (i__5727__auto___16456 + (1));
i__5727__auto___16456 = G__16457;
continue;
} else {
}
break;
}

var G__16390 = args16388.length;
switch (G__16390) {
case 1:
return sablono.core.text_field16387.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field16387.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16388.length)].join('')));

}
});

sablono.core.text_field16387.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.text_field16387.call(null,name__6340__auto__,null);
});

sablono.core.text_field16387.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.text_field16387.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field16387);

/**
 * Creates a time input field.
 */
sablono.core.time_field16391 = (function sablono$core$time_field16391(var_args){
var args16392 = [];
var len__5726__auto___16459 = arguments.length;
var i__5727__auto___16460 = (0);
while(true){
if((i__5727__auto___16460 < len__5726__auto___16459)){
args16392.push((arguments[i__5727__auto___16460]));

var G__16461 = (i__5727__auto___16460 + (1));
i__5727__auto___16460 = G__16461;
continue;
} else {
}
break;
}

var G__16394 = args16392.length;
switch (G__16394) {
case 1:
return sablono.core.time_field16391.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field16391.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16392.length)].join('')));

}
});

sablono.core.time_field16391.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.time_field16391.call(null,name__6340__auto__,null);
});

sablono.core.time_field16391.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.time_field16391.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field16391);

/**
 * Creates a url input field.
 */
sablono.core.url_field16395 = (function sablono$core$url_field16395(var_args){
var args16396 = [];
var len__5726__auto___16463 = arguments.length;
var i__5727__auto___16464 = (0);
while(true){
if((i__5727__auto___16464 < len__5726__auto___16463)){
args16396.push((arguments[i__5727__auto___16464]));

var G__16465 = (i__5727__auto___16464 + (1));
i__5727__auto___16464 = G__16465;
continue;
} else {
}
break;
}

var G__16398 = args16396.length;
switch (G__16398) {
case 1:
return sablono.core.url_field16395.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field16395.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16396.length)].join('')));

}
});

sablono.core.url_field16395.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.url_field16395.call(null,name__6340__auto__,null);
});

sablono.core.url_field16395.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.url_field16395.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field16395);

/**
 * Creates a week input field.
 */
sablono.core.week_field16399 = (function sablono$core$week_field16399(var_args){
var args16400 = [];
var len__5726__auto___16467 = arguments.length;
var i__5727__auto___16468 = (0);
while(true){
if((i__5727__auto___16468 < len__5726__auto___16467)){
args16400.push((arguments[i__5727__auto___16468]));

var G__16469 = (i__5727__auto___16468 + (1));
i__5727__auto___16468 = G__16469;
continue;
} else {
}
break;
}

var G__16402 = args16400.length;
switch (G__16402) {
case 1:
return sablono.core.week_field16399.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field16399.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16400.length)].join('')));

}
});

sablono.core.week_field16399.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.week_field16399.call(null,name__6340__auto__,null);
});

sablono.core.week_field16399.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.week_field16399.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field16399);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box16471 = (function sablono$core$check_box16471(var_args){
var args16472 = [];
var len__5726__auto___16475 = arguments.length;
var i__5727__auto___16476 = (0);
while(true){
if((i__5727__auto___16476 < len__5726__auto___16475)){
args16472.push((arguments[i__5727__auto___16476]));

var G__16477 = (i__5727__auto___16476 + (1));
i__5727__auto___16476 = G__16477;
continue;
} else {
}
break;
}

var G__16474 = args16472.length;
switch (G__16474) {
case 1:
return sablono.core.check_box16471.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box16471.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box16471.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16472.length)].join('')));

}
});

sablono.core.check_box16471.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box16471.call(null,name,null);
});

sablono.core.check_box16471.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box16471.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box16471.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box16471.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box16471);
/**
 * Creates a radio button.
 */
sablono.core.radio_button16479 = (function sablono$core$radio_button16479(var_args){
var args16480 = [];
var len__5726__auto___16483 = arguments.length;
var i__5727__auto___16484 = (0);
while(true){
if((i__5727__auto___16484 < len__5726__auto___16483)){
args16480.push((arguments[i__5727__auto___16484]));

var G__16485 = (i__5727__auto___16484 + (1));
i__5727__auto___16484 = G__16485;
continue;
} else {
}
break;
}

var G__16482 = args16480.length;
switch (G__16482) {
case 1:
return sablono.core.radio_button16479.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button16479.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button16479.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16480.length)].join('')));

}
});

sablono.core.radio_button16479.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button16479.call(null,group,null);
});

sablono.core.radio_button16479.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button16479.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button16479.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button16479.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button16479);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options16487 = (function sablono$core$select_options16487(coll){
var iter__5440__auto__ = (function sablono$core$select_options16487_$_iter__16496(s__16497){
return (new cljs.core.LazySeq(null,(function (){
var s__16497__$1 = s__16497;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16497__$1);
if(temp__4425__auto__){
var s__16497__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16497__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16497__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16499 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16498 = (0);
while(true){
if((i__16498 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16498);
cljs.core.chunk_append.call(null,b__16499,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16502 = x;
var text = cljs.core.nth.call(null,vec__16502,(0),null);
var val = cljs.core.nth.call(null,vec__16502,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16502,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16487.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__16504 = (i__16498 + (1));
i__16498 = G__16504;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16499),sablono$core$select_options16487_$_iter__16496.call(null,cljs.core.chunk_rest.call(null,s__16497__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16499),null);
}
} else {
var x = cljs.core.first.call(null,s__16497__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16503 = x;
var text = cljs.core.nth.call(null,vec__16503,(0),null);
var val = cljs.core.nth.call(null,vec__16503,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16503,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16487.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options16487_$_iter__16496.call(null,cljs.core.rest.call(null,s__16497__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options16487);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down16505 = (function sablono$core$drop_down16505(var_args){
var args16506 = [];
var len__5726__auto___16509 = arguments.length;
var i__5727__auto___16510 = (0);
while(true){
if((i__5727__auto___16510 < len__5726__auto___16509)){
args16506.push((arguments[i__5727__auto___16510]));

var G__16511 = (i__5727__auto___16510 + (1));
i__5727__auto___16510 = G__16511;
continue;
} else {
}
break;
}

var G__16508 = args16506.length;
switch (G__16508) {
case 2:
return sablono.core.drop_down16505.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down16505.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16506.length)].join('')));

}
});

sablono.core.drop_down16505.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down16505.call(null,name,options,null);
});

sablono.core.drop_down16505.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down16505.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down16505);
/**
 * Creates a text area element.
 */
sablono.core.text_area16513 = (function sablono$core$text_area16513(var_args){
var args16514 = [];
var len__5726__auto___16517 = arguments.length;
var i__5727__auto___16518 = (0);
while(true){
if((i__5727__auto___16518 < len__5726__auto___16517)){
args16514.push((arguments[i__5727__auto___16518]));

var G__16519 = (i__5727__auto___16518 + (1));
i__5727__auto___16518 = G__16519;
continue;
} else {
}
break;
}

var G__16516 = args16514.length;
switch (G__16516) {
case 1:
return sablono.core.text_area16513.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area16513.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16514.length)].join('')));

}
});

sablono.core.text_area16513.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area16513.call(null,name,null);
});

sablono.core.text_area16513.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area16513.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area16513);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label16521 = (function sablono$core$label16521(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label16521);
/**
 * Creates a submit button.
 */
sablono.core.submit_button16522 = (function sablono$core$submit_button16522(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button16522);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button16523 = (function sablono$core$reset_button16523(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button16523);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to16524 = (function sablono$core$form_to16524(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16529 = arguments.length;
var i__5727__auto___16530 = (0);
while(true){
if((i__5727__auto___16530 < len__5726__auto___16529)){
args__5733__auto__.push((arguments[i__5727__auto___16530]));

var G__16531 = (i__5727__auto___16530 + (1));
i__5727__auto___16530 = G__16531;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to16524.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to16524.cljs$core$IFn$_invoke$arity$variadic = (function (p__16527,body){
var vec__16528 = p__16527;
var method = cljs.core.nth.call(null,vec__16528,(0),null);
var action = cljs.core.nth.call(null,vec__16528,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to16524.cljs$lang$maxFixedArity = (1);

sablono.core.form_to16524.cljs$lang$applyTo = (function (seq16525){
var G__16526 = cljs.core.first.call(null,seq16525);
var seq16525__$1 = cljs.core.next.call(null,seq16525);
return sablono.core.form_to16524.cljs$core$IFn$_invoke$arity$variadic(G__16526,seq16525__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to16524);

//# sourceMappingURL=core.js.map?rel=1465460147013