// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11134 = [];
var len__5726__auto___11140 = arguments.length;
var i__5727__auto___11141 = (0);
while(true){
if((i__5727__auto___11141 < len__5726__auto___11140)){
args11134.push((arguments[i__5727__auto___11141]));

var G__11142 = (i__5727__auto___11141 + (1));
i__5727__auto___11141 = G__11142;
continue;
} else {
}
break;
}

var G__11136 = args11134.length;
switch (G__11136) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11134.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11137 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11137 = (function (f,blockable,meta11138){
this.f = f;
this.blockable = blockable;
this.meta11138 = meta11138;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11139,meta11138__$1){
var self__ = this;
var _11139__$1 = this;
return (new cljs.core.async.t_cljs$core$async11137(self__.f,self__.blockable,meta11138__$1));
});

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11139){
var self__ = this;
var _11139__$1 = this;
return self__.meta11138;
});

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11137.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11138","meta11138",-580293278,null)], null);
});

cljs.core.async.t_cljs$core$async11137.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11137.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11137";

cljs.core.async.t_cljs$core$async11137.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11137");
});

cljs.core.async.__GT_t_cljs$core$async11137 = (function cljs$core$async$__GT_t_cljs$core$async11137(f__$1,blockable__$1,meta11138){
return (new cljs.core.async.t_cljs$core$async11137(f__$1,blockable__$1,meta11138));
});

}

return (new cljs.core.async.t_cljs$core$async11137(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11146 = [];
var len__5726__auto___11149 = arguments.length;
var i__5727__auto___11150 = (0);
while(true){
if((i__5727__auto___11150 < len__5726__auto___11149)){
args11146.push((arguments[i__5727__auto___11150]));

var G__11151 = (i__5727__auto___11150 + (1));
i__5727__auto___11150 = G__11151;
continue;
} else {
}
break;
}

var G__11148 = args11146.length;
switch (G__11148) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11146.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11153 = [];
var len__5726__auto___11156 = arguments.length;
var i__5727__auto___11157 = (0);
while(true){
if((i__5727__auto___11157 < len__5726__auto___11156)){
args11153.push((arguments[i__5727__auto___11157]));

var G__11158 = (i__5727__auto___11157 + (1));
i__5727__auto___11157 = G__11158;
continue;
} else {
}
break;
}

var G__11155 = args11153.length;
switch (G__11155) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11153.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11160 = [];
var len__5726__auto___11163 = arguments.length;
var i__5727__auto___11164 = (0);
while(true){
if((i__5727__auto___11164 < len__5726__auto___11163)){
args11160.push((arguments[i__5727__auto___11164]));

var G__11165 = (i__5727__auto___11164 + (1));
i__5727__auto___11164 = G__11165;
continue;
} else {
}
break;
}

var G__11162 = args11160.length;
switch (G__11162) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11160.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11167 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11167);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11167,ret){
return (function (){
return fn1.call(null,val_11167);
});})(val_11167,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11168 = [];
var len__5726__auto___11171 = arguments.length;
var i__5727__auto___11172 = (0);
while(true){
if((i__5727__auto___11172 < len__5726__auto___11171)){
args11168.push((arguments[i__5727__auto___11172]));

var G__11173 = (i__5727__auto___11172 + (1));
i__5727__auto___11172 = G__11173;
continue;
} else {
}
break;
}

var G__11170 = args11168.length;
switch (G__11170) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11168.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___11175 = n;
var x_11176 = (0);
while(true){
if((x_11176 < n__5571__auto___11175)){
(a[x_11176] = (0));

var G__11177 = (x_11176 + (1));
x_11176 = G__11177;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11178 = (i + (1));
i = G__11178;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11182 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11182 = (function (alt_flag,flag,meta11183){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11183 = meta11183;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11182.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11184,meta11183__$1){
var self__ = this;
var _11184__$1 = this;
return (new cljs.core.async.t_cljs$core$async11182(self__.alt_flag,self__.flag,meta11183__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11182.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11184){
var self__ = this;
var _11184__$1 = this;
return self__.meta11183;
});})(flag))
;

cljs.core.async.t_cljs$core$async11182.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11182.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11182.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11182.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11182.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11183","meta11183",21016564,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11182.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11182.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11182";

cljs.core.async.t_cljs$core$async11182.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11182");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11182 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11182(alt_flag__$1,flag__$1,meta11183){
return (new cljs.core.async.t_cljs$core$async11182(alt_flag__$1,flag__$1,meta11183));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11182(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11188 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11188 = (function (alt_handler,flag,cb,meta11189){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11189 = meta11189;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11188.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11190,meta11189__$1){
var self__ = this;
var _11190__$1 = this;
return (new cljs.core.async.t_cljs$core$async11188(self__.alt_handler,self__.flag,self__.cb,meta11189__$1));
});

cljs.core.async.t_cljs$core$async11188.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11190){
var self__ = this;
var _11190__$1 = this;
return self__.meta11189;
});

cljs.core.async.t_cljs$core$async11188.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11188.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11188.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11188.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11188.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11189","meta11189",-1276639340,null)], null);
});

cljs.core.async.t_cljs$core$async11188.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11188.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11188";

cljs.core.async.t_cljs$core$async11188.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11188");
});

cljs.core.async.__GT_t_cljs$core$async11188 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11188(alt_handler__$1,flag__$1,cb__$1,meta11189){
return (new cljs.core.async.t_cljs$core$async11188(alt_handler__$1,flag__$1,cb__$1,meta11189));
});

}

return (new cljs.core.async.t_cljs$core$async11188(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11191_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11191_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11192_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11192_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11193 = (i + (1));
i = G__11193;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11199 = arguments.length;
var i__5727__auto___11200 = (0);
while(true){
if((i__5727__auto___11200 < len__5726__auto___11199)){
args__5733__auto__.push((arguments[i__5727__auto___11200]));

var G__11201 = (i__5727__auto___11200 + (1));
i__5727__auto___11200 = G__11201;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11196){
var map__11197 = p__11196;
var map__11197__$1 = ((((!((map__11197 == null)))?((((map__11197.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11197.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11197):map__11197);
var opts = map__11197__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11194){
var G__11195 = cljs.core.first.call(null,seq11194);
var seq11194__$1 = cljs.core.next.call(null,seq11194);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11195,seq11194__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11202 = [];
var len__5726__auto___11252 = arguments.length;
var i__5727__auto___11253 = (0);
while(true){
if((i__5727__auto___11253 < len__5726__auto___11252)){
args11202.push((arguments[i__5727__auto___11253]));

var G__11254 = (i__5727__auto___11253 + (1));
i__5727__auto___11253 = G__11254;
continue;
} else {
}
break;
}

var G__11204 = args11202.length;
switch (G__11204) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11202.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11089__auto___11256 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___11256){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___11256){
return (function (state_11228){
var state_val_11229 = (state_11228[(1)]);
if((state_val_11229 === (7))){
var inst_11224 = (state_11228[(2)]);
var state_11228__$1 = state_11228;
var statearr_11230_11257 = state_11228__$1;
(statearr_11230_11257[(2)] = inst_11224);

(statearr_11230_11257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (1))){
var state_11228__$1 = state_11228;
var statearr_11231_11258 = state_11228__$1;
(statearr_11231_11258[(2)] = null);

(statearr_11231_11258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (4))){
var inst_11207 = (state_11228[(7)]);
var inst_11207__$1 = (state_11228[(2)]);
var inst_11208 = (inst_11207__$1 == null);
var state_11228__$1 = (function (){var statearr_11232 = state_11228;
(statearr_11232[(7)] = inst_11207__$1);

return statearr_11232;
})();
if(cljs.core.truth_(inst_11208)){
var statearr_11233_11259 = state_11228__$1;
(statearr_11233_11259[(1)] = (5));

} else {
var statearr_11234_11260 = state_11228__$1;
(statearr_11234_11260[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (13))){
var state_11228__$1 = state_11228;
var statearr_11235_11261 = state_11228__$1;
(statearr_11235_11261[(2)] = null);

(statearr_11235_11261[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (6))){
var inst_11207 = (state_11228[(7)]);
var state_11228__$1 = state_11228;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11228__$1,(11),to,inst_11207);
} else {
if((state_val_11229 === (3))){
var inst_11226 = (state_11228[(2)]);
var state_11228__$1 = state_11228;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11228__$1,inst_11226);
} else {
if((state_val_11229 === (12))){
var state_11228__$1 = state_11228;
var statearr_11236_11262 = state_11228__$1;
(statearr_11236_11262[(2)] = null);

(statearr_11236_11262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (2))){
var state_11228__$1 = state_11228;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11228__$1,(4),from);
} else {
if((state_val_11229 === (11))){
var inst_11217 = (state_11228[(2)]);
var state_11228__$1 = state_11228;
if(cljs.core.truth_(inst_11217)){
var statearr_11237_11263 = state_11228__$1;
(statearr_11237_11263[(1)] = (12));

} else {
var statearr_11238_11264 = state_11228__$1;
(statearr_11238_11264[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (9))){
var state_11228__$1 = state_11228;
var statearr_11239_11265 = state_11228__$1;
(statearr_11239_11265[(2)] = null);

(statearr_11239_11265[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (5))){
var state_11228__$1 = state_11228;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11240_11266 = state_11228__$1;
(statearr_11240_11266[(1)] = (8));

} else {
var statearr_11241_11267 = state_11228__$1;
(statearr_11241_11267[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (14))){
var inst_11222 = (state_11228[(2)]);
var state_11228__$1 = state_11228;
var statearr_11242_11268 = state_11228__$1;
(statearr_11242_11268[(2)] = inst_11222);

(statearr_11242_11268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (10))){
var inst_11214 = (state_11228[(2)]);
var state_11228__$1 = state_11228;
var statearr_11243_11269 = state_11228__$1;
(statearr_11243_11269[(2)] = inst_11214);

(statearr_11243_11269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (8))){
var inst_11211 = cljs.core.async.close_BANG_.call(null,to);
var state_11228__$1 = state_11228;
var statearr_11244_11270 = state_11228__$1;
(statearr_11244_11270[(2)] = inst_11211);

(statearr_11244_11270[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___11256))
;
return ((function (switch__10977__auto__,c__11089__auto___11256){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_11248 = [null,null,null,null,null,null,null,null];
(statearr_11248[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_11248[(1)] = (1));

return statearr_11248;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_11228){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11228);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11249){if((e11249 instanceof Object)){
var ex__10981__auto__ = e11249;
var statearr_11250_11271 = state_11228;
(statearr_11250_11271[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11228);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11249;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11272 = state_11228;
state_11228 = G__11272;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_11228){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_11228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___11256))
})();
var state__11091__auto__ = (function (){var statearr_11251 = f__11090__auto__.call(null);
(statearr_11251[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___11256);

return statearr_11251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___11256))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11456){
var vec__11457 = p__11456;
var v = cljs.core.nth.call(null,vec__11457,(0),null);
var p = cljs.core.nth.call(null,vec__11457,(1),null);
var job = vec__11457;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11089__auto___11639 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___11639,res,vec__11457,v,p,job,jobs,results){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___11639,res,vec__11457,v,p,job,jobs,results){
return (function (state_11462){
var state_val_11463 = (state_11462[(1)]);
if((state_val_11463 === (1))){
var state_11462__$1 = state_11462;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11462__$1,(2),res,v);
} else {
if((state_val_11463 === (2))){
var inst_11459 = (state_11462[(2)]);
var inst_11460 = cljs.core.async.close_BANG_.call(null,res);
var state_11462__$1 = (function (){var statearr_11464 = state_11462;
(statearr_11464[(7)] = inst_11459);

return statearr_11464;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11462__$1,inst_11460);
} else {
return null;
}
}
});})(c__11089__auto___11639,res,vec__11457,v,p,job,jobs,results))
;
return ((function (switch__10977__auto__,c__11089__auto___11639,res,vec__11457,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_11468 = [null,null,null,null,null,null,null,null];
(statearr_11468[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_11468[(1)] = (1));

return statearr_11468;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_11462){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11462);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11469){if((e11469 instanceof Object)){
var ex__10981__auto__ = e11469;
var statearr_11470_11640 = state_11462;
(statearr_11470_11640[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11462);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11469;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11641 = state_11462;
state_11462 = G__11641;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_11462){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_11462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___11639,res,vec__11457,v,p,job,jobs,results))
})();
var state__11091__auto__ = (function (){var statearr_11471 = f__11090__auto__.call(null);
(statearr_11471[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___11639);

return statearr_11471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___11639,res,vec__11457,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11472){
var vec__11473 = p__11472;
var v = cljs.core.nth.call(null,vec__11473,(0),null);
var p = cljs.core.nth.call(null,vec__11473,(1),null);
var job = vec__11473;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___11642 = n;
var __11643 = (0);
while(true){
if((__11643 < n__5571__auto___11642)){
var G__11474_11644 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11474_11644) {
case "compute":
var c__11089__auto___11646 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11643,c__11089__auto___11646,G__11474_11644,n__5571__auto___11642,jobs,results,process,async){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (__11643,c__11089__auto___11646,G__11474_11644,n__5571__auto___11642,jobs,results,process,async){
return (function (state_11487){
var state_val_11488 = (state_11487[(1)]);
if((state_val_11488 === (1))){
var state_11487__$1 = state_11487;
var statearr_11489_11647 = state_11487__$1;
(statearr_11489_11647[(2)] = null);

(statearr_11489_11647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11488 === (2))){
var state_11487__$1 = state_11487;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11487__$1,(4),jobs);
} else {
if((state_val_11488 === (3))){
var inst_11485 = (state_11487[(2)]);
var state_11487__$1 = state_11487;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11487__$1,inst_11485);
} else {
if((state_val_11488 === (4))){
var inst_11477 = (state_11487[(2)]);
var inst_11478 = process.call(null,inst_11477);
var state_11487__$1 = state_11487;
if(cljs.core.truth_(inst_11478)){
var statearr_11490_11648 = state_11487__$1;
(statearr_11490_11648[(1)] = (5));

} else {
var statearr_11491_11649 = state_11487__$1;
(statearr_11491_11649[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11488 === (5))){
var state_11487__$1 = state_11487;
var statearr_11492_11650 = state_11487__$1;
(statearr_11492_11650[(2)] = null);

(statearr_11492_11650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11488 === (6))){
var state_11487__$1 = state_11487;
var statearr_11493_11651 = state_11487__$1;
(statearr_11493_11651[(2)] = null);

(statearr_11493_11651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11488 === (7))){
var inst_11483 = (state_11487[(2)]);
var state_11487__$1 = state_11487;
var statearr_11494_11652 = state_11487__$1;
(statearr_11494_11652[(2)] = inst_11483);

(statearr_11494_11652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11643,c__11089__auto___11646,G__11474_11644,n__5571__auto___11642,jobs,results,process,async))
;
return ((function (__11643,switch__10977__auto__,c__11089__auto___11646,G__11474_11644,n__5571__auto___11642,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_11498 = [null,null,null,null,null,null,null];
(statearr_11498[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_11498[(1)] = (1));

return statearr_11498;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_11487){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11487);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11499){if((e11499 instanceof Object)){
var ex__10981__auto__ = e11499;
var statearr_11500_11653 = state_11487;
(statearr_11500_11653[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11487);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11499;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11654 = state_11487;
state_11487 = G__11654;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_11487){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_11487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(__11643,switch__10977__auto__,c__11089__auto___11646,G__11474_11644,n__5571__auto___11642,jobs,results,process,async))
})();
var state__11091__auto__ = (function (){var statearr_11501 = f__11090__auto__.call(null);
(statearr_11501[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___11646);

return statearr_11501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(__11643,c__11089__auto___11646,G__11474_11644,n__5571__auto___11642,jobs,results,process,async))
);


break;
case "async":
var c__11089__auto___11655 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11643,c__11089__auto___11655,G__11474_11644,n__5571__auto___11642,jobs,results,process,async){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (__11643,c__11089__auto___11655,G__11474_11644,n__5571__auto___11642,jobs,results,process,async){
return (function (state_11514){
var state_val_11515 = (state_11514[(1)]);
if((state_val_11515 === (1))){
var state_11514__$1 = state_11514;
var statearr_11516_11656 = state_11514__$1;
(statearr_11516_11656[(2)] = null);

(statearr_11516_11656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11515 === (2))){
var state_11514__$1 = state_11514;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11514__$1,(4),jobs);
} else {
if((state_val_11515 === (3))){
var inst_11512 = (state_11514[(2)]);
var state_11514__$1 = state_11514;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11514__$1,inst_11512);
} else {
if((state_val_11515 === (4))){
var inst_11504 = (state_11514[(2)]);
var inst_11505 = async.call(null,inst_11504);
var state_11514__$1 = state_11514;
if(cljs.core.truth_(inst_11505)){
var statearr_11517_11657 = state_11514__$1;
(statearr_11517_11657[(1)] = (5));

} else {
var statearr_11518_11658 = state_11514__$1;
(statearr_11518_11658[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11515 === (5))){
var state_11514__$1 = state_11514;
var statearr_11519_11659 = state_11514__$1;
(statearr_11519_11659[(2)] = null);

(statearr_11519_11659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11515 === (6))){
var state_11514__$1 = state_11514;
var statearr_11520_11660 = state_11514__$1;
(statearr_11520_11660[(2)] = null);

(statearr_11520_11660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11515 === (7))){
var inst_11510 = (state_11514[(2)]);
var state_11514__$1 = state_11514;
var statearr_11521_11661 = state_11514__$1;
(statearr_11521_11661[(2)] = inst_11510);

(statearr_11521_11661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11643,c__11089__auto___11655,G__11474_11644,n__5571__auto___11642,jobs,results,process,async))
;
return ((function (__11643,switch__10977__auto__,c__11089__auto___11655,G__11474_11644,n__5571__auto___11642,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_11525 = [null,null,null,null,null,null,null];
(statearr_11525[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_11525[(1)] = (1));

return statearr_11525;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_11514){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11514);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11526){if((e11526 instanceof Object)){
var ex__10981__auto__ = e11526;
var statearr_11527_11662 = state_11514;
(statearr_11527_11662[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11514);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11526;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11663 = state_11514;
state_11514 = G__11663;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_11514){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_11514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(__11643,switch__10977__auto__,c__11089__auto___11655,G__11474_11644,n__5571__auto___11642,jobs,results,process,async))
})();
var state__11091__auto__ = (function (){var statearr_11528 = f__11090__auto__.call(null);
(statearr_11528[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___11655);

return statearr_11528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(__11643,c__11089__auto___11655,G__11474_11644,n__5571__auto___11642,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11664 = (__11643 + (1));
__11643 = G__11664;
continue;
} else {
}
break;
}

var c__11089__auto___11665 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___11665,jobs,results,process,async){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___11665,jobs,results,process,async){
return (function (state_11550){
var state_val_11551 = (state_11550[(1)]);
if((state_val_11551 === (1))){
var state_11550__$1 = state_11550;
var statearr_11552_11666 = state_11550__$1;
(statearr_11552_11666[(2)] = null);

(statearr_11552_11666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11551 === (2))){
var state_11550__$1 = state_11550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11550__$1,(4),from);
} else {
if((state_val_11551 === (3))){
var inst_11548 = (state_11550[(2)]);
var state_11550__$1 = state_11550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11550__$1,inst_11548);
} else {
if((state_val_11551 === (4))){
var inst_11531 = (state_11550[(7)]);
var inst_11531__$1 = (state_11550[(2)]);
var inst_11532 = (inst_11531__$1 == null);
var state_11550__$1 = (function (){var statearr_11553 = state_11550;
(statearr_11553[(7)] = inst_11531__$1);

return statearr_11553;
})();
if(cljs.core.truth_(inst_11532)){
var statearr_11554_11667 = state_11550__$1;
(statearr_11554_11667[(1)] = (5));

} else {
var statearr_11555_11668 = state_11550__$1;
(statearr_11555_11668[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11551 === (5))){
var inst_11534 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11550__$1 = state_11550;
var statearr_11556_11669 = state_11550__$1;
(statearr_11556_11669[(2)] = inst_11534);

(statearr_11556_11669[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11551 === (6))){
var inst_11531 = (state_11550[(7)]);
var inst_11536 = (state_11550[(8)]);
var inst_11536__$1 = cljs.core.async.chan.call(null,(1));
var inst_11537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11538 = [inst_11531,inst_11536__$1];
var inst_11539 = (new cljs.core.PersistentVector(null,2,(5),inst_11537,inst_11538,null));
var state_11550__$1 = (function (){var statearr_11557 = state_11550;
(statearr_11557[(8)] = inst_11536__$1);

return statearr_11557;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11550__$1,(8),jobs,inst_11539);
} else {
if((state_val_11551 === (7))){
var inst_11546 = (state_11550[(2)]);
var state_11550__$1 = state_11550;
var statearr_11558_11670 = state_11550__$1;
(statearr_11558_11670[(2)] = inst_11546);

(statearr_11558_11670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11551 === (8))){
var inst_11536 = (state_11550[(8)]);
var inst_11541 = (state_11550[(2)]);
var state_11550__$1 = (function (){var statearr_11559 = state_11550;
(statearr_11559[(9)] = inst_11541);

return statearr_11559;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11550__$1,(9),results,inst_11536);
} else {
if((state_val_11551 === (9))){
var inst_11543 = (state_11550[(2)]);
var state_11550__$1 = (function (){var statearr_11560 = state_11550;
(statearr_11560[(10)] = inst_11543);

return statearr_11560;
})();
var statearr_11561_11671 = state_11550__$1;
(statearr_11561_11671[(2)] = null);

(statearr_11561_11671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___11665,jobs,results,process,async))
;
return ((function (switch__10977__auto__,c__11089__auto___11665,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_11565 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11565[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_11565[(1)] = (1));

return statearr_11565;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_11550){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11566){if((e11566 instanceof Object)){
var ex__10981__auto__ = e11566;
var statearr_11567_11672 = state_11550;
(statearr_11567_11672[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11566;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11673 = state_11550;
state_11550 = G__11673;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_11550){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_11550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___11665,jobs,results,process,async))
})();
var state__11091__auto__ = (function (){var statearr_11568 = f__11090__auto__.call(null);
(statearr_11568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___11665);

return statearr_11568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___11665,jobs,results,process,async))
);


var c__11089__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto__,jobs,results,process,async){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto__,jobs,results,process,async){
return (function (state_11606){
var state_val_11607 = (state_11606[(1)]);
if((state_val_11607 === (7))){
var inst_11602 = (state_11606[(2)]);
var state_11606__$1 = state_11606;
var statearr_11608_11674 = state_11606__$1;
(statearr_11608_11674[(2)] = inst_11602);

(statearr_11608_11674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (20))){
var state_11606__$1 = state_11606;
var statearr_11609_11675 = state_11606__$1;
(statearr_11609_11675[(2)] = null);

(statearr_11609_11675[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (1))){
var state_11606__$1 = state_11606;
var statearr_11610_11676 = state_11606__$1;
(statearr_11610_11676[(2)] = null);

(statearr_11610_11676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (4))){
var inst_11571 = (state_11606[(7)]);
var inst_11571__$1 = (state_11606[(2)]);
var inst_11572 = (inst_11571__$1 == null);
var state_11606__$1 = (function (){var statearr_11611 = state_11606;
(statearr_11611[(7)] = inst_11571__$1);

return statearr_11611;
})();
if(cljs.core.truth_(inst_11572)){
var statearr_11612_11677 = state_11606__$1;
(statearr_11612_11677[(1)] = (5));

} else {
var statearr_11613_11678 = state_11606__$1;
(statearr_11613_11678[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (15))){
var inst_11584 = (state_11606[(8)]);
var state_11606__$1 = state_11606;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11606__$1,(18),to,inst_11584);
} else {
if((state_val_11607 === (21))){
var inst_11597 = (state_11606[(2)]);
var state_11606__$1 = state_11606;
var statearr_11614_11679 = state_11606__$1;
(statearr_11614_11679[(2)] = inst_11597);

(statearr_11614_11679[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (13))){
var inst_11599 = (state_11606[(2)]);
var state_11606__$1 = (function (){var statearr_11615 = state_11606;
(statearr_11615[(9)] = inst_11599);

return statearr_11615;
})();
var statearr_11616_11680 = state_11606__$1;
(statearr_11616_11680[(2)] = null);

(statearr_11616_11680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (6))){
var inst_11571 = (state_11606[(7)]);
var state_11606__$1 = state_11606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11606__$1,(11),inst_11571);
} else {
if((state_val_11607 === (17))){
var inst_11592 = (state_11606[(2)]);
var state_11606__$1 = state_11606;
if(cljs.core.truth_(inst_11592)){
var statearr_11617_11681 = state_11606__$1;
(statearr_11617_11681[(1)] = (19));

} else {
var statearr_11618_11682 = state_11606__$1;
(statearr_11618_11682[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (3))){
var inst_11604 = (state_11606[(2)]);
var state_11606__$1 = state_11606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11606__$1,inst_11604);
} else {
if((state_val_11607 === (12))){
var inst_11581 = (state_11606[(10)]);
var state_11606__$1 = state_11606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11606__$1,(14),inst_11581);
} else {
if((state_val_11607 === (2))){
var state_11606__$1 = state_11606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11606__$1,(4),results);
} else {
if((state_val_11607 === (19))){
var state_11606__$1 = state_11606;
var statearr_11619_11683 = state_11606__$1;
(statearr_11619_11683[(2)] = null);

(statearr_11619_11683[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (11))){
var inst_11581 = (state_11606[(2)]);
var state_11606__$1 = (function (){var statearr_11620 = state_11606;
(statearr_11620[(10)] = inst_11581);

return statearr_11620;
})();
var statearr_11621_11684 = state_11606__$1;
(statearr_11621_11684[(2)] = null);

(statearr_11621_11684[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (9))){
var state_11606__$1 = state_11606;
var statearr_11622_11685 = state_11606__$1;
(statearr_11622_11685[(2)] = null);

(statearr_11622_11685[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (5))){
var state_11606__$1 = state_11606;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11623_11686 = state_11606__$1;
(statearr_11623_11686[(1)] = (8));

} else {
var statearr_11624_11687 = state_11606__$1;
(statearr_11624_11687[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (14))){
var inst_11584 = (state_11606[(8)]);
var inst_11586 = (state_11606[(11)]);
var inst_11584__$1 = (state_11606[(2)]);
var inst_11585 = (inst_11584__$1 == null);
var inst_11586__$1 = cljs.core.not.call(null,inst_11585);
var state_11606__$1 = (function (){var statearr_11625 = state_11606;
(statearr_11625[(8)] = inst_11584__$1);

(statearr_11625[(11)] = inst_11586__$1);

return statearr_11625;
})();
if(inst_11586__$1){
var statearr_11626_11688 = state_11606__$1;
(statearr_11626_11688[(1)] = (15));

} else {
var statearr_11627_11689 = state_11606__$1;
(statearr_11627_11689[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (16))){
var inst_11586 = (state_11606[(11)]);
var state_11606__$1 = state_11606;
var statearr_11628_11690 = state_11606__$1;
(statearr_11628_11690[(2)] = inst_11586);

(statearr_11628_11690[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (10))){
var inst_11578 = (state_11606[(2)]);
var state_11606__$1 = state_11606;
var statearr_11629_11691 = state_11606__$1;
(statearr_11629_11691[(2)] = inst_11578);

(statearr_11629_11691[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (18))){
var inst_11589 = (state_11606[(2)]);
var state_11606__$1 = state_11606;
var statearr_11630_11692 = state_11606__$1;
(statearr_11630_11692[(2)] = inst_11589);

(statearr_11630_11692[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11607 === (8))){
var inst_11575 = cljs.core.async.close_BANG_.call(null,to);
var state_11606__$1 = state_11606;
var statearr_11631_11693 = state_11606__$1;
(statearr_11631_11693[(2)] = inst_11575);

(statearr_11631_11693[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto__,jobs,results,process,async))
;
return ((function (switch__10977__auto__,c__11089__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_11635 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11635[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_11635[(1)] = (1));

return statearr_11635;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_11606){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11636){if((e11636 instanceof Object)){
var ex__10981__auto__ = e11636;
var statearr_11637_11694 = state_11606;
(statearr_11637_11694[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11606);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11636;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11695 = state_11606;
state_11606 = G__11695;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_11606){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_11606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto__,jobs,results,process,async))
})();
var state__11091__auto__ = (function (){var statearr_11638 = f__11090__auto__.call(null);
(statearr_11638[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto__);

return statearr_11638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto__,jobs,results,process,async))
);

return c__11089__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11696 = [];
var len__5726__auto___11699 = arguments.length;
var i__5727__auto___11700 = (0);
while(true){
if((i__5727__auto___11700 < len__5726__auto___11699)){
args11696.push((arguments[i__5727__auto___11700]));

var G__11701 = (i__5727__auto___11700 + (1));
i__5727__auto___11700 = G__11701;
continue;
} else {
}
break;
}

var G__11698 = args11696.length;
switch (G__11698) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11696.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11703 = [];
var len__5726__auto___11706 = arguments.length;
var i__5727__auto___11707 = (0);
while(true){
if((i__5727__auto___11707 < len__5726__auto___11706)){
args11703.push((arguments[i__5727__auto___11707]));

var G__11708 = (i__5727__auto___11707 + (1));
i__5727__auto___11707 = G__11708;
continue;
} else {
}
break;
}

var G__11705 = args11703.length;
switch (G__11705) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11703.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11710 = [];
var len__5726__auto___11763 = arguments.length;
var i__5727__auto___11764 = (0);
while(true){
if((i__5727__auto___11764 < len__5726__auto___11763)){
args11710.push((arguments[i__5727__auto___11764]));

var G__11765 = (i__5727__auto___11764 + (1));
i__5727__auto___11764 = G__11765;
continue;
} else {
}
break;
}

var G__11712 = args11710.length;
switch (G__11712) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11710.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11089__auto___11767 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___11767,tc,fc){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___11767,tc,fc){
return (function (state_11738){
var state_val_11739 = (state_11738[(1)]);
if((state_val_11739 === (7))){
var inst_11734 = (state_11738[(2)]);
var state_11738__$1 = state_11738;
var statearr_11740_11768 = state_11738__$1;
(statearr_11740_11768[(2)] = inst_11734);

(statearr_11740_11768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (1))){
var state_11738__$1 = state_11738;
var statearr_11741_11769 = state_11738__$1;
(statearr_11741_11769[(2)] = null);

(statearr_11741_11769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (4))){
var inst_11715 = (state_11738[(7)]);
var inst_11715__$1 = (state_11738[(2)]);
var inst_11716 = (inst_11715__$1 == null);
var state_11738__$1 = (function (){var statearr_11742 = state_11738;
(statearr_11742[(7)] = inst_11715__$1);

return statearr_11742;
})();
if(cljs.core.truth_(inst_11716)){
var statearr_11743_11770 = state_11738__$1;
(statearr_11743_11770[(1)] = (5));

} else {
var statearr_11744_11771 = state_11738__$1;
(statearr_11744_11771[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (13))){
var state_11738__$1 = state_11738;
var statearr_11745_11772 = state_11738__$1;
(statearr_11745_11772[(2)] = null);

(statearr_11745_11772[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (6))){
var inst_11715 = (state_11738[(7)]);
var inst_11721 = p.call(null,inst_11715);
var state_11738__$1 = state_11738;
if(cljs.core.truth_(inst_11721)){
var statearr_11746_11773 = state_11738__$1;
(statearr_11746_11773[(1)] = (9));

} else {
var statearr_11747_11774 = state_11738__$1;
(statearr_11747_11774[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (3))){
var inst_11736 = (state_11738[(2)]);
var state_11738__$1 = state_11738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11738__$1,inst_11736);
} else {
if((state_val_11739 === (12))){
var state_11738__$1 = state_11738;
var statearr_11748_11775 = state_11738__$1;
(statearr_11748_11775[(2)] = null);

(statearr_11748_11775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (2))){
var state_11738__$1 = state_11738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11738__$1,(4),ch);
} else {
if((state_val_11739 === (11))){
var inst_11715 = (state_11738[(7)]);
var inst_11725 = (state_11738[(2)]);
var state_11738__$1 = state_11738;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11738__$1,(8),inst_11725,inst_11715);
} else {
if((state_val_11739 === (9))){
var state_11738__$1 = state_11738;
var statearr_11749_11776 = state_11738__$1;
(statearr_11749_11776[(2)] = tc);

(statearr_11749_11776[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (5))){
var inst_11718 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11719 = cljs.core.async.close_BANG_.call(null,fc);
var state_11738__$1 = (function (){var statearr_11750 = state_11738;
(statearr_11750[(8)] = inst_11718);

return statearr_11750;
})();
var statearr_11751_11777 = state_11738__$1;
(statearr_11751_11777[(2)] = inst_11719);

(statearr_11751_11777[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (14))){
var inst_11732 = (state_11738[(2)]);
var state_11738__$1 = state_11738;
var statearr_11752_11778 = state_11738__$1;
(statearr_11752_11778[(2)] = inst_11732);

(statearr_11752_11778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (10))){
var state_11738__$1 = state_11738;
var statearr_11753_11779 = state_11738__$1;
(statearr_11753_11779[(2)] = fc);

(statearr_11753_11779[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11739 === (8))){
var inst_11727 = (state_11738[(2)]);
var state_11738__$1 = state_11738;
if(cljs.core.truth_(inst_11727)){
var statearr_11754_11780 = state_11738__$1;
(statearr_11754_11780[(1)] = (12));

} else {
var statearr_11755_11781 = state_11738__$1;
(statearr_11755_11781[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___11767,tc,fc))
;
return ((function (switch__10977__auto__,c__11089__auto___11767,tc,fc){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_11759 = [null,null,null,null,null,null,null,null,null];
(statearr_11759[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_11759[(1)] = (1));

return statearr_11759;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_11738){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11760){if((e11760 instanceof Object)){
var ex__10981__auto__ = e11760;
var statearr_11761_11782 = state_11738;
(statearr_11761_11782[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11738);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11760;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11783 = state_11738;
state_11738 = G__11783;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_11738){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_11738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___11767,tc,fc))
})();
var state__11091__auto__ = (function (){var statearr_11762 = f__11090__auto__.call(null);
(statearr_11762[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___11767);

return statearr_11762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___11767,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11089__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto__){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto__){
return (function (state_11847){
var state_val_11848 = (state_11847[(1)]);
if((state_val_11848 === (7))){
var inst_11843 = (state_11847[(2)]);
var state_11847__$1 = state_11847;
var statearr_11849_11870 = state_11847__$1;
(statearr_11849_11870[(2)] = inst_11843);

(statearr_11849_11870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11848 === (1))){
var inst_11827 = init;
var state_11847__$1 = (function (){var statearr_11850 = state_11847;
(statearr_11850[(7)] = inst_11827);

return statearr_11850;
})();
var statearr_11851_11871 = state_11847__$1;
(statearr_11851_11871[(2)] = null);

(statearr_11851_11871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11848 === (4))){
var inst_11830 = (state_11847[(8)]);
var inst_11830__$1 = (state_11847[(2)]);
var inst_11831 = (inst_11830__$1 == null);
var state_11847__$1 = (function (){var statearr_11852 = state_11847;
(statearr_11852[(8)] = inst_11830__$1);

return statearr_11852;
})();
if(cljs.core.truth_(inst_11831)){
var statearr_11853_11872 = state_11847__$1;
(statearr_11853_11872[(1)] = (5));

} else {
var statearr_11854_11873 = state_11847__$1;
(statearr_11854_11873[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11848 === (6))){
var inst_11834 = (state_11847[(9)]);
var inst_11827 = (state_11847[(7)]);
var inst_11830 = (state_11847[(8)]);
var inst_11834__$1 = f.call(null,inst_11827,inst_11830);
var inst_11835 = cljs.core.reduced_QMARK_.call(null,inst_11834__$1);
var state_11847__$1 = (function (){var statearr_11855 = state_11847;
(statearr_11855[(9)] = inst_11834__$1);

return statearr_11855;
})();
if(inst_11835){
var statearr_11856_11874 = state_11847__$1;
(statearr_11856_11874[(1)] = (8));

} else {
var statearr_11857_11875 = state_11847__$1;
(statearr_11857_11875[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11848 === (3))){
var inst_11845 = (state_11847[(2)]);
var state_11847__$1 = state_11847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11847__$1,inst_11845);
} else {
if((state_val_11848 === (2))){
var state_11847__$1 = state_11847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11847__$1,(4),ch);
} else {
if((state_val_11848 === (9))){
var inst_11834 = (state_11847[(9)]);
var inst_11827 = inst_11834;
var state_11847__$1 = (function (){var statearr_11858 = state_11847;
(statearr_11858[(7)] = inst_11827);

return statearr_11858;
})();
var statearr_11859_11876 = state_11847__$1;
(statearr_11859_11876[(2)] = null);

(statearr_11859_11876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11848 === (5))){
var inst_11827 = (state_11847[(7)]);
var state_11847__$1 = state_11847;
var statearr_11860_11877 = state_11847__$1;
(statearr_11860_11877[(2)] = inst_11827);

(statearr_11860_11877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11848 === (10))){
var inst_11841 = (state_11847[(2)]);
var state_11847__$1 = state_11847;
var statearr_11861_11878 = state_11847__$1;
(statearr_11861_11878[(2)] = inst_11841);

(statearr_11861_11878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11848 === (8))){
var inst_11834 = (state_11847[(9)]);
var inst_11837 = cljs.core.deref.call(null,inst_11834);
var state_11847__$1 = state_11847;
var statearr_11862_11879 = state_11847__$1;
(statearr_11862_11879[(2)] = inst_11837);

(statearr_11862_11879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto__))
;
return ((function (switch__10977__auto__,c__11089__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10978__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10978__auto____0 = (function (){
var statearr_11866 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11866[(0)] = cljs$core$async$reduce_$_state_machine__10978__auto__);

(statearr_11866[(1)] = (1));

return statearr_11866;
});
var cljs$core$async$reduce_$_state_machine__10978__auto____1 = (function (state_11847){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11867){if((e11867 instanceof Object)){
var ex__10981__auto__ = e11867;
var statearr_11868_11880 = state_11847;
(statearr_11868_11880[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11867;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11881 = state_11847;
state_11847 = G__11881;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10978__auto__ = function(state_11847){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10978__auto____1.call(this,state_11847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10978__auto____0;
cljs$core$async$reduce_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10978__auto____1;
return cljs$core$async$reduce_$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto__))
})();
var state__11091__auto__ = (function (){var statearr_11869 = f__11090__auto__.call(null);
(statearr_11869[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto__);

return statearr_11869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto__))
);

return c__11089__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11882 = [];
var len__5726__auto___11934 = arguments.length;
var i__5727__auto___11935 = (0);
while(true){
if((i__5727__auto___11935 < len__5726__auto___11934)){
args11882.push((arguments[i__5727__auto___11935]));

var G__11936 = (i__5727__auto___11935 + (1));
i__5727__auto___11935 = G__11936;
continue;
} else {
}
break;
}

var G__11884 = args11882.length;
switch (G__11884) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11882.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11089__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto__){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto__){
return (function (state_11909){
var state_val_11910 = (state_11909[(1)]);
if((state_val_11910 === (7))){
var inst_11891 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
var statearr_11911_11938 = state_11909__$1;
(statearr_11911_11938[(2)] = inst_11891);

(statearr_11911_11938[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (1))){
var inst_11885 = cljs.core.seq.call(null,coll);
var inst_11886 = inst_11885;
var state_11909__$1 = (function (){var statearr_11912 = state_11909;
(statearr_11912[(7)] = inst_11886);

return statearr_11912;
})();
var statearr_11913_11939 = state_11909__$1;
(statearr_11913_11939[(2)] = null);

(statearr_11913_11939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (4))){
var inst_11886 = (state_11909[(7)]);
var inst_11889 = cljs.core.first.call(null,inst_11886);
var state_11909__$1 = state_11909;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11909__$1,(7),ch,inst_11889);
} else {
if((state_val_11910 === (13))){
var inst_11903 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
var statearr_11914_11940 = state_11909__$1;
(statearr_11914_11940[(2)] = inst_11903);

(statearr_11914_11940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (6))){
var inst_11894 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
if(cljs.core.truth_(inst_11894)){
var statearr_11915_11941 = state_11909__$1;
(statearr_11915_11941[(1)] = (8));

} else {
var statearr_11916_11942 = state_11909__$1;
(statearr_11916_11942[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (3))){
var inst_11907 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11909__$1,inst_11907);
} else {
if((state_val_11910 === (12))){
var state_11909__$1 = state_11909;
var statearr_11917_11943 = state_11909__$1;
(statearr_11917_11943[(2)] = null);

(statearr_11917_11943[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (2))){
var inst_11886 = (state_11909[(7)]);
var state_11909__$1 = state_11909;
if(cljs.core.truth_(inst_11886)){
var statearr_11918_11944 = state_11909__$1;
(statearr_11918_11944[(1)] = (4));

} else {
var statearr_11919_11945 = state_11909__$1;
(statearr_11919_11945[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (11))){
var inst_11900 = cljs.core.async.close_BANG_.call(null,ch);
var state_11909__$1 = state_11909;
var statearr_11920_11946 = state_11909__$1;
(statearr_11920_11946[(2)] = inst_11900);

(statearr_11920_11946[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (9))){
var state_11909__$1 = state_11909;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11921_11947 = state_11909__$1;
(statearr_11921_11947[(1)] = (11));

} else {
var statearr_11922_11948 = state_11909__$1;
(statearr_11922_11948[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (5))){
var inst_11886 = (state_11909[(7)]);
var state_11909__$1 = state_11909;
var statearr_11923_11949 = state_11909__$1;
(statearr_11923_11949[(2)] = inst_11886);

(statearr_11923_11949[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (10))){
var inst_11905 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
var statearr_11924_11950 = state_11909__$1;
(statearr_11924_11950[(2)] = inst_11905);

(statearr_11924_11950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (8))){
var inst_11886 = (state_11909[(7)]);
var inst_11896 = cljs.core.next.call(null,inst_11886);
var inst_11886__$1 = inst_11896;
var state_11909__$1 = (function (){var statearr_11925 = state_11909;
(statearr_11925[(7)] = inst_11886__$1);

return statearr_11925;
})();
var statearr_11926_11951 = state_11909__$1;
(statearr_11926_11951[(2)] = null);

(statearr_11926_11951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto__))
;
return ((function (switch__10977__auto__,c__11089__auto__){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_11930 = [null,null,null,null,null,null,null,null];
(statearr_11930[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_11930[(1)] = (1));

return statearr_11930;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_11909){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_11909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e11931){if((e11931 instanceof Object)){
var ex__10981__auto__ = e11931;
var statearr_11932_11952 = state_11909;
(statearr_11932_11952[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11931;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11953 = state_11909;
state_11909 = G__11953;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_11909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_11909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto__))
})();
var state__11091__auto__ = (function (){var statearr_11933 = f__11090__auto__.call(null);
(statearr_11933[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto__);

return statearr_11933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto__))
);

return c__11089__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12175 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12175 = (function (mult,ch,cs,meta12176){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12176 = meta12176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12177,meta12176__$1){
var self__ = this;
var _12177__$1 = this;
return (new cljs.core.async.t_cljs$core$async12175(self__.mult,self__.ch,self__.cs,meta12176__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12175.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12177){
var self__ = this;
var _12177__$1 = this;
return self__.meta12176;
});})(cs))
;

cljs.core.async.t_cljs$core$async12175.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12175.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12175.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12175.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12175.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12175.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12175.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12176","meta12176",-267299103,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12175.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12175.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12175";

cljs.core.async.t_cljs$core$async12175.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12175");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12175 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12175(mult__$1,ch__$1,cs__$1,meta12176){
return (new cljs.core.async.t_cljs$core$async12175(mult__$1,ch__$1,cs__$1,meta12176));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12175(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11089__auto___12396 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___12396,cs,m,dchan,dctr,done){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___12396,cs,m,dchan,dctr,done){
return (function (state_12308){
var state_val_12309 = (state_12308[(1)]);
if((state_val_12309 === (7))){
var inst_12304 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12310_12397 = state_12308__$1;
(statearr_12310_12397[(2)] = inst_12304);

(statearr_12310_12397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (20))){
var inst_12209 = (state_12308[(7)]);
var inst_12219 = cljs.core.first.call(null,inst_12209);
var inst_12220 = cljs.core.nth.call(null,inst_12219,(0),null);
var inst_12221 = cljs.core.nth.call(null,inst_12219,(1),null);
var state_12308__$1 = (function (){var statearr_12311 = state_12308;
(statearr_12311[(8)] = inst_12220);

return statearr_12311;
})();
if(cljs.core.truth_(inst_12221)){
var statearr_12312_12398 = state_12308__$1;
(statearr_12312_12398[(1)] = (22));

} else {
var statearr_12313_12399 = state_12308__$1;
(statearr_12313_12399[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (27))){
var inst_12251 = (state_12308[(9)]);
var inst_12256 = (state_12308[(10)]);
var inst_12249 = (state_12308[(11)]);
var inst_12180 = (state_12308[(12)]);
var inst_12256__$1 = cljs.core._nth.call(null,inst_12249,inst_12251);
var inst_12257 = cljs.core.async.put_BANG_.call(null,inst_12256__$1,inst_12180,done);
var state_12308__$1 = (function (){var statearr_12314 = state_12308;
(statearr_12314[(10)] = inst_12256__$1);

return statearr_12314;
})();
if(cljs.core.truth_(inst_12257)){
var statearr_12315_12400 = state_12308__$1;
(statearr_12315_12400[(1)] = (30));

} else {
var statearr_12316_12401 = state_12308__$1;
(statearr_12316_12401[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (1))){
var state_12308__$1 = state_12308;
var statearr_12317_12402 = state_12308__$1;
(statearr_12317_12402[(2)] = null);

(statearr_12317_12402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (24))){
var inst_12209 = (state_12308[(7)]);
var inst_12226 = (state_12308[(2)]);
var inst_12227 = cljs.core.next.call(null,inst_12209);
var inst_12189 = inst_12227;
var inst_12190 = null;
var inst_12191 = (0);
var inst_12192 = (0);
var state_12308__$1 = (function (){var statearr_12318 = state_12308;
(statearr_12318[(13)] = inst_12192);

(statearr_12318[(14)] = inst_12190);

(statearr_12318[(15)] = inst_12191);

(statearr_12318[(16)] = inst_12226);

(statearr_12318[(17)] = inst_12189);

return statearr_12318;
})();
var statearr_12319_12403 = state_12308__$1;
(statearr_12319_12403[(2)] = null);

(statearr_12319_12403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (39))){
var state_12308__$1 = state_12308;
var statearr_12323_12404 = state_12308__$1;
(statearr_12323_12404[(2)] = null);

(statearr_12323_12404[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (4))){
var inst_12180 = (state_12308[(12)]);
var inst_12180__$1 = (state_12308[(2)]);
var inst_12181 = (inst_12180__$1 == null);
var state_12308__$1 = (function (){var statearr_12324 = state_12308;
(statearr_12324[(12)] = inst_12180__$1);

return statearr_12324;
})();
if(cljs.core.truth_(inst_12181)){
var statearr_12325_12405 = state_12308__$1;
(statearr_12325_12405[(1)] = (5));

} else {
var statearr_12326_12406 = state_12308__$1;
(statearr_12326_12406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (15))){
var inst_12192 = (state_12308[(13)]);
var inst_12190 = (state_12308[(14)]);
var inst_12191 = (state_12308[(15)]);
var inst_12189 = (state_12308[(17)]);
var inst_12205 = (state_12308[(2)]);
var inst_12206 = (inst_12192 + (1));
var tmp12320 = inst_12190;
var tmp12321 = inst_12191;
var tmp12322 = inst_12189;
var inst_12189__$1 = tmp12322;
var inst_12190__$1 = tmp12320;
var inst_12191__$1 = tmp12321;
var inst_12192__$1 = inst_12206;
var state_12308__$1 = (function (){var statearr_12327 = state_12308;
(statearr_12327[(13)] = inst_12192__$1);

(statearr_12327[(14)] = inst_12190__$1);

(statearr_12327[(15)] = inst_12191__$1);

(statearr_12327[(17)] = inst_12189__$1);

(statearr_12327[(18)] = inst_12205);

return statearr_12327;
})();
var statearr_12328_12407 = state_12308__$1;
(statearr_12328_12407[(2)] = null);

(statearr_12328_12407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (21))){
var inst_12230 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12332_12408 = state_12308__$1;
(statearr_12332_12408[(2)] = inst_12230);

(statearr_12332_12408[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (31))){
var inst_12256 = (state_12308[(10)]);
var inst_12260 = done.call(null,null);
var inst_12261 = cljs.core.async.untap_STAR_.call(null,m,inst_12256);
var state_12308__$1 = (function (){var statearr_12333 = state_12308;
(statearr_12333[(19)] = inst_12260);

return statearr_12333;
})();
var statearr_12334_12409 = state_12308__$1;
(statearr_12334_12409[(2)] = inst_12261);

(statearr_12334_12409[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (32))){
var inst_12251 = (state_12308[(9)]);
var inst_12248 = (state_12308[(20)]);
var inst_12249 = (state_12308[(11)]);
var inst_12250 = (state_12308[(21)]);
var inst_12263 = (state_12308[(2)]);
var inst_12264 = (inst_12251 + (1));
var tmp12329 = inst_12248;
var tmp12330 = inst_12249;
var tmp12331 = inst_12250;
var inst_12248__$1 = tmp12329;
var inst_12249__$1 = tmp12330;
var inst_12250__$1 = tmp12331;
var inst_12251__$1 = inst_12264;
var state_12308__$1 = (function (){var statearr_12335 = state_12308;
(statearr_12335[(9)] = inst_12251__$1);

(statearr_12335[(20)] = inst_12248__$1);

(statearr_12335[(11)] = inst_12249__$1);

(statearr_12335[(21)] = inst_12250__$1);

(statearr_12335[(22)] = inst_12263);

return statearr_12335;
})();
var statearr_12336_12410 = state_12308__$1;
(statearr_12336_12410[(2)] = null);

(statearr_12336_12410[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (40))){
var inst_12276 = (state_12308[(23)]);
var inst_12280 = done.call(null,null);
var inst_12281 = cljs.core.async.untap_STAR_.call(null,m,inst_12276);
var state_12308__$1 = (function (){var statearr_12337 = state_12308;
(statearr_12337[(24)] = inst_12280);

return statearr_12337;
})();
var statearr_12338_12411 = state_12308__$1;
(statearr_12338_12411[(2)] = inst_12281);

(statearr_12338_12411[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (33))){
var inst_12267 = (state_12308[(25)]);
var inst_12269 = cljs.core.chunked_seq_QMARK_.call(null,inst_12267);
var state_12308__$1 = state_12308;
if(inst_12269){
var statearr_12339_12412 = state_12308__$1;
(statearr_12339_12412[(1)] = (36));

} else {
var statearr_12340_12413 = state_12308__$1;
(statearr_12340_12413[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (13))){
var inst_12199 = (state_12308[(26)]);
var inst_12202 = cljs.core.async.close_BANG_.call(null,inst_12199);
var state_12308__$1 = state_12308;
var statearr_12341_12414 = state_12308__$1;
(statearr_12341_12414[(2)] = inst_12202);

(statearr_12341_12414[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (22))){
var inst_12220 = (state_12308[(8)]);
var inst_12223 = cljs.core.async.close_BANG_.call(null,inst_12220);
var state_12308__$1 = state_12308;
var statearr_12342_12415 = state_12308__$1;
(statearr_12342_12415[(2)] = inst_12223);

(statearr_12342_12415[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (36))){
var inst_12267 = (state_12308[(25)]);
var inst_12271 = cljs.core.chunk_first.call(null,inst_12267);
var inst_12272 = cljs.core.chunk_rest.call(null,inst_12267);
var inst_12273 = cljs.core.count.call(null,inst_12271);
var inst_12248 = inst_12272;
var inst_12249 = inst_12271;
var inst_12250 = inst_12273;
var inst_12251 = (0);
var state_12308__$1 = (function (){var statearr_12343 = state_12308;
(statearr_12343[(9)] = inst_12251);

(statearr_12343[(20)] = inst_12248);

(statearr_12343[(11)] = inst_12249);

(statearr_12343[(21)] = inst_12250);

return statearr_12343;
})();
var statearr_12344_12416 = state_12308__$1;
(statearr_12344_12416[(2)] = null);

(statearr_12344_12416[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (41))){
var inst_12267 = (state_12308[(25)]);
var inst_12283 = (state_12308[(2)]);
var inst_12284 = cljs.core.next.call(null,inst_12267);
var inst_12248 = inst_12284;
var inst_12249 = null;
var inst_12250 = (0);
var inst_12251 = (0);
var state_12308__$1 = (function (){var statearr_12345 = state_12308;
(statearr_12345[(9)] = inst_12251);

(statearr_12345[(20)] = inst_12248);

(statearr_12345[(11)] = inst_12249);

(statearr_12345[(21)] = inst_12250);

(statearr_12345[(27)] = inst_12283);

return statearr_12345;
})();
var statearr_12346_12417 = state_12308__$1;
(statearr_12346_12417[(2)] = null);

(statearr_12346_12417[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (43))){
var state_12308__$1 = state_12308;
var statearr_12347_12418 = state_12308__$1;
(statearr_12347_12418[(2)] = null);

(statearr_12347_12418[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (29))){
var inst_12292 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12348_12419 = state_12308__$1;
(statearr_12348_12419[(2)] = inst_12292);

(statearr_12348_12419[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (44))){
var inst_12301 = (state_12308[(2)]);
var state_12308__$1 = (function (){var statearr_12349 = state_12308;
(statearr_12349[(28)] = inst_12301);

return statearr_12349;
})();
var statearr_12350_12420 = state_12308__$1;
(statearr_12350_12420[(2)] = null);

(statearr_12350_12420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (6))){
var inst_12240 = (state_12308[(29)]);
var inst_12239 = cljs.core.deref.call(null,cs);
var inst_12240__$1 = cljs.core.keys.call(null,inst_12239);
var inst_12241 = cljs.core.count.call(null,inst_12240__$1);
var inst_12242 = cljs.core.reset_BANG_.call(null,dctr,inst_12241);
var inst_12247 = cljs.core.seq.call(null,inst_12240__$1);
var inst_12248 = inst_12247;
var inst_12249 = null;
var inst_12250 = (0);
var inst_12251 = (0);
var state_12308__$1 = (function (){var statearr_12351 = state_12308;
(statearr_12351[(9)] = inst_12251);

(statearr_12351[(29)] = inst_12240__$1);

(statearr_12351[(30)] = inst_12242);

(statearr_12351[(20)] = inst_12248);

(statearr_12351[(11)] = inst_12249);

(statearr_12351[(21)] = inst_12250);

return statearr_12351;
})();
var statearr_12352_12421 = state_12308__$1;
(statearr_12352_12421[(2)] = null);

(statearr_12352_12421[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (28))){
var inst_12248 = (state_12308[(20)]);
var inst_12267 = (state_12308[(25)]);
var inst_12267__$1 = cljs.core.seq.call(null,inst_12248);
var state_12308__$1 = (function (){var statearr_12353 = state_12308;
(statearr_12353[(25)] = inst_12267__$1);

return statearr_12353;
})();
if(inst_12267__$1){
var statearr_12354_12422 = state_12308__$1;
(statearr_12354_12422[(1)] = (33));

} else {
var statearr_12355_12423 = state_12308__$1;
(statearr_12355_12423[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (25))){
var inst_12251 = (state_12308[(9)]);
var inst_12250 = (state_12308[(21)]);
var inst_12253 = (inst_12251 < inst_12250);
var inst_12254 = inst_12253;
var state_12308__$1 = state_12308;
if(cljs.core.truth_(inst_12254)){
var statearr_12356_12424 = state_12308__$1;
(statearr_12356_12424[(1)] = (27));

} else {
var statearr_12357_12425 = state_12308__$1;
(statearr_12357_12425[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (34))){
var state_12308__$1 = state_12308;
var statearr_12358_12426 = state_12308__$1;
(statearr_12358_12426[(2)] = null);

(statearr_12358_12426[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (17))){
var state_12308__$1 = state_12308;
var statearr_12359_12427 = state_12308__$1;
(statearr_12359_12427[(2)] = null);

(statearr_12359_12427[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (3))){
var inst_12306 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12308__$1,inst_12306);
} else {
if((state_val_12309 === (12))){
var inst_12235 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12360_12428 = state_12308__$1;
(statearr_12360_12428[(2)] = inst_12235);

(statearr_12360_12428[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (2))){
var state_12308__$1 = state_12308;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12308__$1,(4),ch);
} else {
if((state_val_12309 === (23))){
var state_12308__$1 = state_12308;
var statearr_12361_12429 = state_12308__$1;
(statearr_12361_12429[(2)] = null);

(statearr_12361_12429[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (35))){
var inst_12290 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12362_12430 = state_12308__$1;
(statearr_12362_12430[(2)] = inst_12290);

(statearr_12362_12430[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (19))){
var inst_12209 = (state_12308[(7)]);
var inst_12213 = cljs.core.chunk_first.call(null,inst_12209);
var inst_12214 = cljs.core.chunk_rest.call(null,inst_12209);
var inst_12215 = cljs.core.count.call(null,inst_12213);
var inst_12189 = inst_12214;
var inst_12190 = inst_12213;
var inst_12191 = inst_12215;
var inst_12192 = (0);
var state_12308__$1 = (function (){var statearr_12363 = state_12308;
(statearr_12363[(13)] = inst_12192);

(statearr_12363[(14)] = inst_12190);

(statearr_12363[(15)] = inst_12191);

(statearr_12363[(17)] = inst_12189);

return statearr_12363;
})();
var statearr_12364_12431 = state_12308__$1;
(statearr_12364_12431[(2)] = null);

(statearr_12364_12431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (11))){
var inst_12209 = (state_12308[(7)]);
var inst_12189 = (state_12308[(17)]);
var inst_12209__$1 = cljs.core.seq.call(null,inst_12189);
var state_12308__$1 = (function (){var statearr_12365 = state_12308;
(statearr_12365[(7)] = inst_12209__$1);

return statearr_12365;
})();
if(inst_12209__$1){
var statearr_12366_12432 = state_12308__$1;
(statearr_12366_12432[(1)] = (16));

} else {
var statearr_12367_12433 = state_12308__$1;
(statearr_12367_12433[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (9))){
var inst_12237 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12368_12434 = state_12308__$1;
(statearr_12368_12434[(2)] = inst_12237);

(statearr_12368_12434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (5))){
var inst_12187 = cljs.core.deref.call(null,cs);
var inst_12188 = cljs.core.seq.call(null,inst_12187);
var inst_12189 = inst_12188;
var inst_12190 = null;
var inst_12191 = (0);
var inst_12192 = (0);
var state_12308__$1 = (function (){var statearr_12369 = state_12308;
(statearr_12369[(13)] = inst_12192);

(statearr_12369[(14)] = inst_12190);

(statearr_12369[(15)] = inst_12191);

(statearr_12369[(17)] = inst_12189);

return statearr_12369;
})();
var statearr_12370_12435 = state_12308__$1;
(statearr_12370_12435[(2)] = null);

(statearr_12370_12435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (14))){
var state_12308__$1 = state_12308;
var statearr_12371_12436 = state_12308__$1;
(statearr_12371_12436[(2)] = null);

(statearr_12371_12436[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (45))){
var inst_12298 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12372_12437 = state_12308__$1;
(statearr_12372_12437[(2)] = inst_12298);

(statearr_12372_12437[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (26))){
var inst_12240 = (state_12308[(29)]);
var inst_12294 = (state_12308[(2)]);
var inst_12295 = cljs.core.seq.call(null,inst_12240);
var state_12308__$1 = (function (){var statearr_12373 = state_12308;
(statearr_12373[(31)] = inst_12294);

return statearr_12373;
})();
if(inst_12295){
var statearr_12374_12438 = state_12308__$1;
(statearr_12374_12438[(1)] = (42));

} else {
var statearr_12375_12439 = state_12308__$1;
(statearr_12375_12439[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (16))){
var inst_12209 = (state_12308[(7)]);
var inst_12211 = cljs.core.chunked_seq_QMARK_.call(null,inst_12209);
var state_12308__$1 = state_12308;
if(inst_12211){
var statearr_12376_12440 = state_12308__$1;
(statearr_12376_12440[(1)] = (19));

} else {
var statearr_12377_12441 = state_12308__$1;
(statearr_12377_12441[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (38))){
var inst_12287 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12378_12442 = state_12308__$1;
(statearr_12378_12442[(2)] = inst_12287);

(statearr_12378_12442[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (30))){
var state_12308__$1 = state_12308;
var statearr_12379_12443 = state_12308__$1;
(statearr_12379_12443[(2)] = null);

(statearr_12379_12443[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (10))){
var inst_12192 = (state_12308[(13)]);
var inst_12190 = (state_12308[(14)]);
var inst_12198 = cljs.core._nth.call(null,inst_12190,inst_12192);
var inst_12199 = cljs.core.nth.call(null,inst_12198,(0),null);
var inst_12200 = cljs.core.nth.call(null,inst_12198,(1),null);
var state_12308__$1 = (function (){var statearr_12380 = state_12308;
(statearr_12380[(26)] = inst_12199);

return statearr_12380;
})();
if(cljs.core.truth_(inst_12200)){
var statearr_12381_12444 = state_12308__$1;
(statearr_12381_12444[(1)] = (13));

} else {
var statearr_12382_12445 = state_12308__$1;
(statearr_12382_12445[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (18))){
var inst_12233 = (state_12308[(2)]);
var state_12308__$1 = state_12308;
var statearr_12383_12446 = state_12308__$1;
(statearr_12383_12446[(2)] = inst_12233);

(statearr_12383_12446[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (42))){
var state_12308__$1 = state_12308;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12308__$1,(45),dchan);
} else {
if((state_val_12309 === (37))){
var inst_12276 = (state_12308[(23)]);
var inst_12267 = (state_12308[(25)]);
var inst_12180 = (state_12308[(12)]);
var inst_12276__$1 = cljs.core.first.call(null,inst_12267);
var inst_12277 = cljs.core.async.put_BANG_.call(null,inst_12276__$1,inst_12180,done);
var state_12308__$1 = (function (){var statearr_12384 = state_12308;
(statearr_12384[(23)] = inst_12276__$1);

return statearr_12384;
})();
if(cljs.core.truth_(inst_12277)){
var statearr_12385_12447 = state_12308__$1;
(statearr_12385_12447[(1)] = (39));

} else {
var statearr_12386_12448 = state_12308__$1;
(statearr_12386_12448[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12309 === (8))){
var inst_12192 = (state_12308[(13)]);
var inst_12191 = (state_12308[(15)]);
var inst_12194 = (inst_12192 < inst_12191);
var inst_12195 = inst_12194;
var state_12308__$1 = state_12308;
if(cljs.core.truth_(inst_12195)){
var statearr_12387_12449 = state_12308__$1;
(statearr_12387_12449[(1)] = (10));

} else {
var statearr_12388_12450 = state_12308__$1;
(statearr_12388_12450[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___12396,cs,m,dchan,dctr,done))
;
return ((function (switch__10977__auto__,c__11089__auto___12396,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10978__auto__ = null;
var cljs$core$async$mult_$_state_machine__10978__auto____0 = (function (){
var statearr_12392 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12392[(0)] = cljs$core$async$mult_$_state_machine__10978__auto__);

(statearr_12392[(1)] = (1));

return statearr_12392;
});
var cljs$core$async$mult_$_state_machine__10978__auto____1 = (function (state_12308){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_12308);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e12393){if((e12393 instanceof Object)){
var ex__10981__auto__ = e12393;
var statearr_12394_12451 = state_12308;
(statearr_12394_12451[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12308);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12452 = state_12308;
state_12308 = G__12452;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10978__auto__ = function(state_12308){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10978__auto____1.call(this,state_12308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10978__auto____0;
cljs$core$async$mult_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10978__auto____1;
return cljs$core$async$mult_$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___12396,cs,m,dchan,dctr,done))
})();
var state__11091__auto__ = (function (){var statearr_12395 = f__11090__auto__.call(null);
(statearr_12395[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___12396);

return statearr_12395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___12396,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args12453 = [];
var len__5726__auto___12456 = arguments.length;
var i__5727__auto___12457 = (0);
while(true){
if((i__5727__auto___12457 < len__5726__auto___12456)){
args12453.push((arguments[i__5727__auto___12457]));

var G__12458 = (i__5727__auto___12457 + (1));
i__5727__auto___12457 = G__12458;
continue;
} else {
}
break;
}

var G__12455 = args12453.length;
switch (G__12455) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12453.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___12470 = arguments.length;
var i__5727__auto___12471 = (0);
while(true){
if((i__5727__auto___12471 < len__5726__auto___12470)){
args__5733__auto__.push((arguments[i__5727__auto___12471]));

var G__12472 = (i__5727__auto___12471 + (1));
i__5727__auto___12471 = G__12472;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12464){
var map__12465 = p__12464;
var map__12465__$1 = ((((!((map__12465 == null)))?((((map__12465.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12465.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12465):map__12465);
var opts = map__12465__$1;
var statearr_12467_12473 = state;
(statearr_12467_12473[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__12465,map__12465__$1,opts){
return (function (val){
var statearr_12468_12474 = state;
(statearr_12468_12474[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12465,map__12465__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_12469_12475 = state;
(statearr_12469_12475[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12460){
var G__12461 = cljs.core.first.call(null,seq12460);
var seq12460__$1 = cljs.core.next.call(null,seq12460);
var G__12462 = cljs.core.first.call(null,seq12460__$1);
var seq12460__$2 = cljs.core.next.call(null,seq12460__$1);
var G__12463 = cljs.core.first.call(null,seq12460__$2);
var seq12460__$3 = cljs.core.next.call(null,seq12460__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12461,G__12462,G__12463,seq12460__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12639 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12639 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12640){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12640 = meta12640;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12641,meta12640__$1){
var self__ = this;
var _12641__$1 = this;
return (new cljs.core.async.t_cljs$core$async12639(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12640__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12641){
var self__ = this;
var _12641__$1 = this;
return self__.meta12640;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12640","meta12640",-1532402072,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12639.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12639.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12639";

cljs.core.async.t_cljs$core$async12639.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12639");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12639 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12639(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12640){
return (new cljs.core.async.t_cljs$core$async12639(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12640));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12639(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11089__auto___12802 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___12802,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___12802,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12739){
var state_val_12740 = (state_12739[(1)]);
if((state_val_12740 === (7))){
var inst_12657 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
var statearr_12741_12803 = state_12739__$1;
(statearr_12741_12803[(2)] = inst_12657);

(statearr_12741_12803[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (20))){
var inst_12669 = (state_12739[(7)]);
var state_12739__$1 = state_12739;
var statearr_12742_12804 = state_12739__$1;
(statearr_12742_12804[(2)] = inst_12669);

(statearr_12742_12804[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (27))){
var state_12739__$1 = state_12739;
var statearr_12743_12805 = state_12739__$1;
(statearr_12743_12805[(2)] = null);

(statearr_12743_12805[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (1))){
var inst_12645 = (state_12739[(8)]);
var inst_12645__$1 = calc_state.call(null);
var inst_12647 = (inst_12645__$1 == null);
var inst_12648 = cljs.core.not.call(null,inst_12647);
var state_12739__$1 = (function (){var statearr_12744 = state_12739;
(statearr_12744[(8)] = inst_12645__$1);

return statearr_12744;
})();
if(inst_12648){
var statearr_12745_12806 = state_12739__$1;
(statearr_12745_12806[(1)] = (2));

} else {
var statearr_12746_12807 = state_12739__$1;
(statearr_12746_12807[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (24))){
var inst_12699 = (state_12739[(9)]);
var inst_12713 = (state_12739[(10)]);
var inst_12692 = (state_12739[(11)]);
var inst_12713__$1 = inst_12692.call(null,inst_12699);
var state_12739__$1 = (function (){var statearr_12747 = state_12739;
(statearr_12747[(10)] = inst_12713__$1);

return statearr_12747;
})();
if(cljs.core.truth_(inst_12713__$1)){
var statearr_12748_12808 = state_12739__$1;
(statearr_12748_12808[(1)] = (29));

} else {
var statearr_12749_12809 = state_12739__$1;
(statearr_12749_12809[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (4))){
var inst_12660 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
if(cljs.core.truth_(inst_12660)){
var statearr_12750_12810 = state_12739__$1;
(statearr_12750_12810[(1)] = (8));

} else {
var statearr_12751_12811 = state_12739__$1;
(statearr_12751_12811[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (15))){
var inst_12686 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
if(cljs.core.truth_(inst_12686)){
var statearr_12752_12812 = state_12739__$1;
(statearr_12752_12812[(1)] = (19));

} else {
var statearr_12753_12813 = state_12739__$1;
(statearr_12753_12813[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (21))){
var inst_12691 = (state_12739[(12)]);
var inst_12691__$1 = (state_12739[(2)]);
var inst_12692 = cljs.core.get.call(null,inst_12691__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12693 = cljs.core.get.call(null,inst_12691__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12694 = cljs.core.get.call(null,inst_12691__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12739__$1 = (function (){var statearr_12754 = state_12739;
(statearr_12754[(13)] = inst_12693);

(statearr_12754[(12)] = inst_12691__$1);

(statearr_12754[(11)] = inst_12692);

return statearr_12754;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12739__$1,(22),inst_12694);
} else {
if((state_val_12740 === (31))){
var inst_12721 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
if(cljs.core.truth_(inst_12721)){
var statearr_12755_12814 = state_12739__$1;
(statearr_12755_12814[(1)] = (32));

} else {
var statearr_12756_12815 = state_12739__$1;
(statearr_12756_12815[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (32))){
var inst_12698 = (state_12739[(14)]);
var state_12739__$1 = state_12739;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12739__$1,(35),out,inst_12698);
} else {
if((state_val_12740 === (33))){
var inst_12691 = (state_12739[(12)]);
var inst_12669 = inst_12691;
var state_12739__$1 = (function (){var statearr_12757 = state_12739;
(statearr_12757[(7)] = inst_12669);

return statearr_12757;
})();
var statearr_12758_12816 = state_12739__$1;
(statearr_12758_12816[(2)] = null);

(statearr_12758_12816[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (13))){
var inst_12669 = (state_12739[(7)]);
var inst_12676 = inst_12669.cljs$lang$protocol_mask$partition0$;
var inst_12677 = (inst_12676 & (64));
var inst_12678 = inst_12669.cljs$core$ISeq$;
var inst_12679 = (inst_12677) || (inst_12678);
var state_12739__$1 = state_12739;
if(cljs.core.truth_(inst_12679)){
var statearr_12759_12817 = state_12739__$1;
(statearr_12759_12817[(1)] = (16));

} else {
var statearr_12760_12818 = state_12739__$1;
(statearr_12760_12818[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (22))){
var inst_12699 = (state_12739[(9)]);
var inst_12698 = (state_12739[(14)]);
var inst_12697 = (state_12739[(2)]);
var inst_12698__$1 = cljs.core.nth.call(null,inst_12697,(0),null);
var inst_12699__$1 = cljs.core.nth.call(null,inst_12697,(1),null);
var inst_12700 = (inst_12698__$1 == null);
var inst_12701 = cljs.core._EQ_.call(null,inst_12699__$1,change);
var inst_12702 = (inst_12700) || (inst_12701);
var state_12739__$1 = (function (){var statearr_12761 = state_12739;
(statearr_12761[(9)] = inst_12699__$1);

(statearr_12761[(14)] = inst_12698__$1);

return statearr_12761;
})();
if(cljs.core.truth_(inst_12702)){
var statearr_12762_12819 = state_12739__$1;
(statearr_12762_12819[(1)] = (23));

} else {
var statearr_12763_12820 = state_12739__$1;
(statearr_12763_12820[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (36))){
var inst_12691 = (state_12739[(12)]);
var inst_12669 = inst_12691;
var state_12739__$1 = (function (){var statearr_12764 = state_12739;
(statearr_12764[(7)] = inst_12669);

return statearr_12764;
})();
var statearr_12765_12821 = state_12739__$1;
(statearr_12765_12821[(2)] = null);

(statearr_12765_12821[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (29))){
var inst_12713 = (state_12739[(10)]);
var state_12739__$1 = state_12739;
var statearr_12766_12822 = state_12739__$1;
(statearr_12766_12822[(2)] = inst_12713);

(statearr_12766_12822[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (6))){
var state_12739__$1 = state_12739;
var statearr_12767_12823 = state_12739__$1;
(statearr_12767_12823[(2)] = false);

(statearr_12767_12823[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (28))){
var inst_12709 = (state_12739[(2)]);
var inst_12710 = calc_state.call(null);
var inst_12669 = inst_12710;
var state_12739__$1 = (function (){var statearr_12768 = state_12739;
(statearr_12768[(7)] = inst_12669);

(statearr_12768[(15)] = inst_12709);

return statearr_12768;
})();
var statearr_12769_12824 = state_12739__$1;
(statearr_12769_12824[(2)] = null);

(statearr_12769_12824[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (25))){
var inst_12735 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
var statearr_12770_12825 = state_12739__$1;
(statearr_12770_12825[(2)] = inst_12735);

(statearr_12770_12825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (34))){
var inst_12733 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
var statearr_12771_12826 = state_12739__$1;
(statearr_12771_12826[(2)] = inst_12733);

(statearr_12771_12826[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (17))){
var state_12739__$1 = state_12739;
var statearr_12772_12827 = state_12739__$1;
(statearr_12772_12827[(2)] = false);

(statearr_12772_12827[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (3))){
var state_12739__$1 = state_12739;
var statearr_12773_12828 = state_12739__$1;
(statearr_12773_12828[(2)] = false);

(statearr_12773_12828[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (12))){
var inst_12737 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12739__$1,inst_12737);
} else {
if((state_val_12740 === (2))){
var inst_12645 = (state_12739[(8)]);
var inst_12650 = inst_12645.cljs$lang$protocol_mask$partition0$;
var inst_12651 = (inst_12650 & (64));
var inst_12652 = inst_12645.cljs$core$ISeq$;
var inst_12653 = (inst_12651) || (inst_12652);
var state_12739__$1 = state_12739;
if(cljs.core.truth_(inst_12653)){
var statearr_12774_12829 = state_12739__$1;
(statearr_12774_12829[(1)] = (5));

} else {
var statearr_12775_12830 = state_12739__$1;
(statearr_12775_12830[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (23))){
var inst_12698 = (state_12739[(14)]);
var inst_12704 = (inst_12698 == null);
var state_12739__$1 = state_12739;
if(cljs.core.truth_(inst_12704)){
var statearr_12776_12831 = state_12739__$1;
(statearr_12776_12831[(1)] = (26));

} else {
var statearr_12777_12832 = state_12739__$1;
(statearr_12777_12832[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (35))){
var inst_12724 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
if(cljs.core.truth_(inst_12724)){
var statearr_12778_12833 = state_12739__$1;
(statearr_12778_12833[(1)] = (36));

} else {
var statearr_12779_12834 = state_12739__$1;
(statearr_12779_12834[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (19))){
var inst_12669 = (state_12739[(7)]);
var inst_12688 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12669);
var state_12739__$1 = state_12739;
var statearr_12780_12835 = state_12739__$1;
(statearr_12780_12835[(2)] = inst_12688);

(statearr_12780_12835[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (11))){
var inst_12669 = (state_12739[(7)]);
var inst_12673 = (inst_12669 == null);
var inst_12674 = cljs.core.not.call(null,inst_12673);
var state_12739__$1 = state_12739;
if(inst_12674){
var statearr_12781_12836 = state_12739__$1;
(statearr_12781_12836[(1)] = (13));

} else {
var statearr_12782_12837 = state_12739__$1;
(statearr_12782_12837[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (9))){
var inst_12645 = (state_12739[(8)]);
var state_12739__$1 = state_12739;
var statearr_12783_12838 = state_12739__$1;
(statearr_12783_12838[(2)] = inst_12645);

(statearr_12783_12838[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (5))){
var state_12739__$1 = state_12739;
var statearr_12784_12839 = state_12739__$1;
(statearr_12784_12839[(2)] = true);

(statearr_12784_12839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (14))){
var state_12739__$1 = state_12739;
var statearr_12785_12840 = state_12739__$1;
(statearr_12785_12840[(2)] = false);

(statearr_12785_12840[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (26))){
var inst_12699 = (state_12739[(9)]);
var inst_12706 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12699);
var state_12739__$1 = state_12739;
var statearr_12786_12841 = state_12739__$1;
(statearr_12786_12841[(2)] = inst_12706);

(statearr_12786_12841[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (16))){
var state_12739__$1 = state_12739;
var statearr_12787_12842 = state_12739__$1;
(statearr_12787_12842[(2)] = true);

(statearr_12787_12842[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (38))){
var inst_12729 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
var statearr_12788_12843 = state_12739__$1;
(statearr_12788_12843[(2)] = inst_12729);

(statearr_12788_12843[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (30))){
var inst_12693 = (state_12739[(13)]);
var inst_12699 = (state_12739[(9)]);
var inst_12692 = (state_12739[(11)]);
var inst_12716 = cljs.core.empty_QMARK_.call(null,inst_12692);
var inst_12717 = inst_12693.call(null,inst_12699);
var inst_12718 = cljs.core.not.call(null,inst_12717);
var inst_12719 = (inst_12716) && (inst_12718);
var state_12739__$1 = state_12739;
var statearr_12789_12844 = state_12739__$1;
(statearr_12789_12844[(2)] = inst_12719);

(statearr_12789_12844[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (10))){
var inst_12645 = (state_12739[(8)]);
var inst_12665 = (state_12739[(2)]);
var inst_12666 = cljs.core.get.call(null,inst_12665,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12667 = cljs.core.get.call(null,inst_12665,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12668 = cljs.core.get.call(null,inst_12665,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12669 = inst_12645;
var state_12739__$1 = (function (){var statearr_12790 = state_12739;
(statearr_12790[(7)] = inst_12669);

(statearr_12790[(16)] = inst_12667);

(statearr_12790[(17)] = inst_12666);

(statearr_12790[(18)] = inst_12668);

return statearr_12790;
})();
var statearr_12791_12845 = state_12739__$1;
(statearr_12791_12845[(2)] = null);

(statearr_12791_12845[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (18))){
var inst_12683 = (state_12739[(2)]);
var state_12739__$1 = state_12739;
var statearr_12792_12846 = state_12739__$1;
(statearr_12792_12846[(2)] = inst_12683);

(statearr_12792_12846[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (37))){
var state_12739__$1 = state_12739;
var statearr_12793_12847 = state_12739__$1;
(statearr_12793_12847[(2)] = null);

(statearr_12793_12847[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12740 === (8))){
var inst_12645 = (state_12739[(8)]);
var inst_12662 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12645);
var state_12739__$1 = state_12739;
var statearr_12794_12848 = state_12739__$1;
(statearr_12794_12848[(2)] = inst_12662);

(statearr_12794_12848[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___12802,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10977__auto__,c__11089__auto___12802,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10978__auto__ = null;
var cljs$core$async$mix_$_state_machine__10978__auto____0 = (function (){
var statearr_12798 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12798[(0)] = cljs$core$async$mix_$_state_machine__10978__auto__);

(statearr_12798[(1)] = (1));

return statearr_12798;
});
var cljs$core$async$mix_$_state_machine__10978__auto____1 = (function (state_12739){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_12739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e12799){if((e12799 instanceof Object)){
var ex__10981__auto__ = e12799;
var statearr_12800_12849 = state_12739;
(statearr_12800_12849[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12739);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12799;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12850 = state_12739;
state_12739 = G__12850;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10978__auto__ = function(state_12739){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10978__auto____1.call(this,state_12739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10978__auto____0;
cljs$core$async$mix_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10978__auto____1;
return cljs$core$async$mix_$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___12802,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11091__auto__ = (function (){var statearr_12801 = f__11090__auto__.call(null);
(statearr_12801[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___12802);

return statearr_12801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___12802,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12851 = [];
var len__5726__auto___12854 = arguments.length;
var i__5727__auto___12855 = (0);
while(true){
if((i__5727__auto___12855 < len__5726__auto___12854)){
args12851.push((arguments[i__5727__auto___12855]));

var G__12856 = (i__5727__auto___12855 + (1));
i__5727__auto___12855 = G__12856;
continue;
} else {
}
break;
}

var G__12853 = args12851.length;
switch (G__12853) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12851.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12859 = [];
var len__5726__auto___12984 = arguments.length;
var i__5727__auto___12985 = (0);
while(true){
if((i__5727__auto___12985 < len__5726__auto___12984)){
args12859.push((arguments[i__5727__auto___12985]));

var G__12986 = (i__5727__auto___12985 + (1));
i__5727__auto___12985 = G__12986;
continue;
} else {
}
break;
}

var G__12861 = args12859.length;
switch (G__12861) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12859.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__12858_SHARP_){
if(cljs.core.truth_(p1__12858_SHARP_.call(null,topic))){
return p1__12858_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12858_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12862 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12862 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12863){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12863 = meta12863;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12864,meta12863__$1){
var self__ = this;
var _12864__$1 = this;
return (new cljs.core.async.t_cljs$core$async12862(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12863__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12864){
var self__ = this;
var _12864__$1 = this;
return self__.meta12863;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12862.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12862.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12863","meta12863",1828607876,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12862.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12862.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12862";

cljs.core.async.t_cljs$core$async12862.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12862");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12862 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12862(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12863){
return (new cljs.core.async.t_cljs$core$async12862(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12863));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12862(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11089__auto___12988 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___12988,mults,ensure_mult,p){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___12988,mults,ensure_mult,p){
return (function (state_12936){
var state_val_12937 = (state_12936[(1)]);
if((state_val_12937 === (7))){
var inst_12932 = (state_12936[(2)]);
var state_12936__$1 = state_12936;
var statearr_12938_12989 = state_12936__$1;
(statearr_12938_12989[(2)] = inst_12932);

(statearr_12938_12989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (20))){
var state_12936__$1 = state_12936;
var statearr_12939_12990 = state_12936__$1;
(statearr_12939_12990[(2)] = null);

(statearr_12939_12990[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (1))){
var state_12936__$1 = state_12936;
var statearr_12940_12991 = state_12936__$1;
(statearr_12940_12991[(2)] = null);

(statearr_12940_12991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (24))){
var inst_12915 = (state_12936[(7)]);
var inst_12924 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12915);
var state_12936__$1 = state_12936;
var statearr_12941_12992 = state_12936__$1;
(statearr_12941_12992[(2)] = inst_12924);

(statearr_12941_12992[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (4))){
var inst_12867 = (state_12936[(8)]);
var inst_12867__$1 = (state_12936[(2)]);
var inst_12868 = (inst_12867__$1 == null);
var state_12936__$1 = (function (){var statearr_12942 = state_12936;
(statearr_12942[(8)] = inst_12867__$1);

return statearr_12942;
})();
if(cljs.core.truth_(inst_12868)){
var statearr_12943_12993 = state_12936__$1;
(statearr_12943_12993[(1)] = (5));

} else {
var statearr_12944_12994 = state_12936__$1;
(statearr_12944_12994[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (15))){
var inst_12909 = (state_12936[(2)]);
var state_12936__$1 = state_12936;
var statearr_12945_12995 = state_12936__$1;
(statearr_12945_12995[(2)] = inst_12909);

(statearr_12945_12995[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (21))){
var inst_12929 = (state_12936[(2)]);
var state_12936__$1 = (function (){var statearr_12946 = state_12936;
(statearr_12946[(9)] = inst_12929);

return statearr_12946;
})();
var statearr_12947_12996 = state_12936__$1;
(statearr_12947_12996[(2)] = null);

(statearr_12947_12996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (13))){
var inst_12891 = (state_12936[(10)]);
var inst_12893 = cljs.core.chunked_seq_QMARK_.call(null,inst_12891);
var state_12936__$1 = state_12936;
if(inst_12893){
var statearr_12948_12997 = state_12936__$1;
(statearr_12948_12997[(1)] = (16));

} else {
var statearr_12949_12998 = state_12936__$1;
(statearr_12949_12998[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (22))){
var inst_12921 = (state_12936[(2)]);
var state_12936__$1 = state_12936;
if(cljs.core.truth_(inst_12921)){
var statearr_12950_12999 = state_12936__$1;
(statearr_12950_12999[(1)] = (23));

} else {
var statearr_12951_13000 = state_12936__$1;
(statearr_12951_13000[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (6))){
var inst_12915 = (state_12936[(7)]);
var inst_12867 = (state_12936[(8)]);
var inst_12917 = (state_12936[(11)]);
var inst_12915__$1 = topic_fn.call(null,inst_12867);
var inst_12916 = cljs.core.deref.call(null,mults);
var inst_12917__$1 = cljs.core.get.call(null,inst_12916,inst_12915__$1);
var state_12936__$1 = (function (){var statearr_12952 = state_12936;
(statearr_12952[(7)] = inst_12915__$1);

(statearr_12952[(11)] = inst_12917__$1);

return statearr_12952;
})();
if(cljs.core.truth_(inst_12917__$1)){
var statearr_12953_13001 = state_12936__$1;
(statearr_12953_13001[(1)] = (19));

} else {
var statearr_12954_13002 = state_12936__$1;
(statearr_12954_13002[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (25))){
var inst_12926 = (state_12936[(2)]);
var state_12936__$1 = state_12936;
var statearr_12955_13003 = state_12936__$1;
(statearr_12955_13003[(2)] = inst_12926);

(statearr_12955_13003[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (17))){
var inst_12891 = (state_12936[(10)]);
var inst_12900 = cljs.core.first.call(null,inst_12891);
var inst_12901 = cljs.core.async.muxch_STAR_.call(null,inst_12900);
var inst_12902 = cljs.core.async.close_BANG_.call(null,inst_12901);
var inst_12903 = cljs.core.next.call(null,inst_12891);
var inst_12877 = inst_12903;
var inst_12878 = null;
var inst_12879 = (0);
var inst_12880 = (0);
var state_12936__$1 = (function (){var statearr_12956 = state_12936;
(statearr_12956[(12)] = inst_12879);

(statearr_12956[(13)] = inst_12877);

(statearr_12956[(14)] = inst_12880);

(statearr_12956[(15)] = inst_12878);

(statearr_12956[(16)] = inst_12902);

return statearr_12956;
})();
var statearr_12957_13004 = state_12936__$1;
(statearr_12957_13004[(2)] = null);

(statearr_12957_13004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (3))){
var inst_12934 = (state_12936[(2)]);
var state_12936__$1 = state_12936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12936__$1,inst_12934);
} else {
if((state_val_12937 === (12))){
var inst_12911 = (state_12936[(2)]);
var state_12936__$1 = state_12936;
var statearr_12958_13005 = state_12936__$1;
(statearr_12958_13005[(2)] = inst_12911);

(statearr_12958_13005[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (2))){
var state_12936__$1 = state_12936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12936__$1,(4),ch);
} else {
if((state_val_12937 === (23))){
var state_12936__$1 = state_12936;
var statearr_12959_13006 = state_12936__$1;
(statearr_12959_13006[(2)] = null);

(statearr_12959_13006[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (19))){
var inst_12867 = (state_12936[(8)]);
var inst_12917 = (state_12936[(11)]);
var inst_12919 = cljs.core.async.muxch_STAR_.call(null,inst_12917);
var state_12936__$1 = state_12936;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12936__$1,(22),inst_12919,inst_12867);
} else {
if((state_val_12937 === (11))){
var inst_12891 = (state_12936[(10)]);
var inst_12877 = (state_12936[(13)]);
var inst_12891__$1 = cljs.core.seq.call(null,inst_12877);
var state_12936__$1 = (function (){var statearr_12960 = state_12936;
(statearr_12960[(10)] = inst_12891__$1);

return statearr_12960;
})();
if(inst_12891__$1){
var statearr_12961_13007 = state_12936__$1;
(statearr_12961_13007[(1)] = (13));

} else {
var statearr_12962_13008 = state_12936__$1;
(statearr_12962_13008[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (9))){
var inst_12913 = (state_12936[(2)]);
var state_12936__$1 = state_12936;
var statearr_12963_13009 = state_12936__$1;
(statearr_12963_13009[(2)] = inst_12913);

(statearr_12963_13009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (5))){
var inst_12874 = cljs.core.deref.call(null,mults);
var inst_12875 = cljs.core.vals.call(null,inst_12874);
var inst_12876 = cljs.core.seq.call(null,inst_12875);
var inst_12877 = inst_12876;
var inst_12878 = null;
var inst_12879 = (0);
var inst_12880 = (0);
var state_12936__$1 = (function (){var statearr_12964 = state_12936;
(statearr_12964[(12)] = inst_12879);

(statearr_12964[(13)] = inst_12877);

(statearr_12964[(14)] = inst_12880);

(statearr_12964[(15)] = inst_12878);

return statearr_12964;
})();
var statearr_12965_13010 = state_12936__$1;
(statearr_12965_13010[(2)] = null);

(statearr_12965_13010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (14))){
var state_12936__$1 = state_12936;
var statearr_12969_13011 = state_12936__$1;
(statearr_12969_13011[(2)] = null);

(statearr_12969_13011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (16))){
var inst_12891 = (state_12936[(10)]);
var inst_12895 = cljs.core.chunk_first.call(null,inst_12891);
var inst_12896 = cljs.core.chunk_rest.call(null,inst_12891);
var inst_12897 = cljs.core.count.call(null,inst_12895);
var inst_12877 = inst_12896;
var inst_12878 = inst_12895;
var inst_12879 = inst_12897;
var inst_12880 = (0);
var state_12936__$1 = (function (){var statearr_12970 = state_12936;
(statearr_12970[(12)] = inst_12879);

(statearr_12970[(13)] = inst_12877);

(statearr_12970[(14)] = inst_12880);

(statearr_12970[(15)] = inst_12878);

return statearr_12970;
})();
var statearr_12971_13012 = state_12936__$1;
(statearr_12971_13012[(2)] = null);

(statearr_12971_13012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (10))){
var inst_12879 = (state_12936[(12)]);
var inst_12877 = (state_12936[(13)]);
var inst_12880 = (state_12936[(14)]);
var inst_12878 = (state_12936[(15)]);
var inst_12885 = cljs.core._nth.call(null,inst_12878,inst_12880);
var inst_12886 = cljs.core.async.muxch_STAR_.call(null,inst_12885);
var inst_12887 = cljs.core.async.close_BANG_.call(null,inst_12886);
var inst_12888 = (inst_12880 + (1));
var tmp12966 = inst_12879;
var tmp12967 = inst_12877;
var tmp12968 = inst_12878;
var inst_12877__$1 = tmp12967;
var inst_12878__$1 = tmp12968;
var inst_12879__$1 = tmp12966;
var inst_12880__$1 = inst_12888;
var state_12936__$1 = (function (){var statearr_12972 = state_12936;
(statearr_12972[(12)] = inst_12879__$1);

(statearr_12972[(13)] = inst_12877__$1);

(statearr_12972[(14)] = inst_12880__$1);

(statearr_12972[(17)] = inst_12887);

(statearr_12972[(15)] = inst_12878__$1);

return statearr_12972;
})();
var statearr_12973_13013 = state_12936__$1;
(statearr_12973_13013[(2)] = null);

(statearr_12973_13013[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (18))){
var inst_12906 = (state_12936[(2)]);
var state_12936__$1 = state_12936;
var statearr_12974_13014 = state_12936__$1;
(statearr_12974_13014[(2)] = inst_12906);

(statearr_12974_13014[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12937 === (8))){
var inst_12879 = (state_12936[(12)]);
var inst_12880 = (state_12936[(14)]);
var inst_12882 = (inst_12880 < inst_12879);
var inst_12883 = inst_12882;
var state_12936__$1 = state_12936;
if(cljs.core.truth_(inst_12883)){
var statearr_12975_13015 = state_12936__$1;
(statearr_12975_13015[(1)] = (10));

} else {
var statearr_12976_13016 = state_12936__$1;
(statearr_12976_13016[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___12988,mults,ensure_mult,p))
;
return ((function (switch__10977__auto__,c__11089__auto___12988,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_12980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12980[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_12980[(1)] = (1));

return statearr_12980;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_12936){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_12936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e12981){if((e12981 instanceof Object)){
var ex__10981__auto__ = e12981;
var statearr_12982_13017 = state_12936;
(statearr_12982_13017[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12981;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13018 = state_12936;
state_12936 = G__13018;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_12936){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_12936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___12988,mults,ensure_mult,p))
})();
var state__11091__auto__ = (function (){var statearr_12983 = f__11090__auto__.call(null);
(statearr_12983[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___12988);

return statearr_12983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___12988,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args13019 = [];
var len__5726__auto___13022 = arguments.length;
var i__5727__auto___13023 = (0);
while(true){
if((i__5727__auto___13023 < len__5726__auto___13022)){
args13019.push((arguments[i__5727__auto___13023]));

var G__13024 = (i__5727__auto___13023 + (1));
i__5727__auto___13023 = G__13024;
continue;
} else {
}
break;
}

var G__13021 = args13019.length;
switch (G__13021) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13019.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args13026 = [];
var len__5726__auto___13029 = arguments.length;
var i__5727__auto___13030 = (0);
while(true){
if((i__5727__auto___13030 < len__5726__auto___13029)){
args13026.push((arguments[i__5727__auto___13030]));

var G__13031 = (i__5727__auto___13030 + (1));
i__5727__auto___13030 = G__13031;
continue;
} else {
}
break;
}

var G__13028 = args13026.length;
switch (G__13028) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13026.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13033 = [];
var len__5726__auto___13104 = arguments.length;
var i__5727__auto___13105 = (0);
while(true){
if((i__5727__auto___13105 < len__5726__auto___13104)){
args13033.push((arguments[i__5727__auto___13105]));

var G__13106 = (i__5727__auto___13105 + (1));
i__5727__auto___13105 = G__13106;
continue;
} else {
}
break;
}

var G__13035 = args13033.length;
switch (G__13035) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13033.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11089__auto___13108 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___13108,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___13108,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13074){
var state_val_13075 = (state_13074[(1)]);
if((state_val_13075 === (7))){
var state_13074__$1 = state_13074;
var statearr_13076_13109 = state_13074__$1;
(statearr_13076_13109[(2)] = null);

(statearr_13076_13109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (1))){
var state_13074__$1 = state_13074;
var statearr_13077_13110 = state_13074__$1;
(statearr_13077_13110[(2)] = null);

(statearr_13077_13110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (4))){
var inst_13038 = (state_13074[(7)]);
var inst_13040 = (inst_13038 < cnt);
var state_13074__$1 = state_13074;
if(cljs.core.truth_(inst_13040)){
var statearr_13078_13111 = state_13074__$1;
(statearr_13078_13111[(1)] = (6));

} else {
var statearr_13079_13112 = state_13074__$1;
(statearr_13079_13112[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (15))){
var inst_13070 = (state_13074[(2)]);
var state_13074__$1 = state_13074;
var statearr_13080_13113 = state_13074__$1;
(statearr_13080_13113[(2)] = inst_13070);

(statearr_13080_13113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (13))){
var inst_13063 = cljs.core.async.close_BANG_.call(null,out);
var state_13074__$1 = state_13074;
var statearr_13081_13114 = state_13074__$1;
(statearr_13081_13114[(2)] = inst_13063);

(statearr_13081_13114[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (6))){
var state_13074__$1 = state_13074;
var statearr_13082_13115 = state_13074__$1;
(statearr_13082_13115[(2)] = null);

(statearr_13082_13115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (3))){
var inst_13072 = (state_13074[(2)]);
var state_13074__$1 = state_13074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13074__$1,inst_13072);
} else {
if((state_val_13075 === (12))){
var inst_13060 = (state_13074[(8)]);
var inst_13060__$1 = (state_13074[(2)]);
var inst_13061 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13060__$1);
var state_13074__$1 = (function (){var statearr_13083 = state_13074;
(statearr_13083[(8)] = inst_13060__$1);

return statearr_13083;
})();
if(cljs.core.truth_(inst_13061)){
var statearr_13084_13116 = state_13074__$1;
(statearr_13084_13116[(1)] = (13));

} else {
var statearr_13085_13117 = state_13074__$1;
(statearr_13085_13117[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (2))){
var inst_13037 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13038 = (0);
var state_13074__$1 = (function (){var statearr_13086 = state_13074;
(statearr_13086[(7)] = inst_13038);

(statearr_13086[(9)] = inst_13037);

return statearr_13086;
})();
var statearr_13087_13118 = state_13074__$1;
(statearr_13087_13118[(2)] = null);

(statearr_13087_13118[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (11))){
var inst_13038 = (state_13074[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13074,(10),Object,null,(9));
var inst_13047 = chs__$1.call(null,inst_13038);
var inst_13048 = done.call(null,inst_13038);
var inst_13049 = cljs.core.async.take_BANG_.call(null,inst_13047,inst_13048);
var state_13074__$1 = state_13074;
var statearr_13088_13119 = state_13074__$1;
(statearr_13088_13119[(2)] = inst_13049);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13074__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (9))){
var inst_13038 = (state_13074[(7)]);
var inst_13051 = (state_13074[(2)]);
var inst_13052 = (inst_13038 + (1));
var inst_13038__$1 = inst_13052;
var state_13074__$1 = (function (){var statearr_13089 = state_13074;
(statearr_13089[(10)] = inst_13051);

(statearr_13089[(7)] = inst_13038__$1);

return statearr_13089;
})();
var statearr_13090_13120 = state_13074__$1;
(statearr_13090_13120[(2)] = null);

(statearr_13090_13120[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (5))){
var inst_13058 = (state_13074[(2)]);
var state_13074__$1 = (function (){var statearr_13091 = state_13074;
(statearr_13091[(11)] = inst_13058);

return statearr_13091;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13074__$1,(12),dchan);
} else {
if((state_val_13075 === (14))){
var inst_13060 = (state_13074[(8)]);
var inst_13065 = cljs.core.apply.call(null,f,inst_13060);
var state_13074__$1 = state_13074;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13074__$1,(16),out,inst_13065);
} else {
if((state_val_13075 === (16))){
var inst_13067 = (state_13074[(2)]);
var state_13074__$1 = (function (){var statearr_13092 = state_13074;
(statearr_13092[(12)] = inst_13067);

return statearr_13092;
})();
var statearr_13093_13121 = state_13074__$1;
(statearr_13093_13121[(2)] = null);

(statearr_13093_13121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (10))){
var inst_13042 = (state_13074[(2)]);
var inst_13043 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13074__$1 = (function (){var statearr_13094 = state_13074;
(statearr_13094[(13)] = inst_13042);

return statearr_13094;
})();
var statearr_13095_13122 = state_13074__$1;
(statearr_13095_13122[(2)] = inst_13043);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13074__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13075 === (8))){
var inst_13056 = (state_13074[(2)]);
var state_13074__$1 = state_13074;
var statearr_13096_13123 = state_13074__$1;
(statearr_13096_13123[(2)] = inst_13056);

(statearr_13096_13123[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___13108,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10977__auto__,c__11089__auto___13108,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_13100 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13100[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_13100[(1)] = (1));

return statearr_13100;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_13074){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_13074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e13101){if((e13101 instanceof Object)){
var ex__10981__auto__ = e13101;
var statearr_13102_13124 = state_13074;
(statearr_13102_13124[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13074);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13101;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13125 = state_13074;
state_13074 = G__13125;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_13074){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_13074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___13108,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11091__auto__ = (function (){var statearr_13103 = f__11090__auto__.call(null);
(statearr_13103[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___13108);

return statearr_13103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___13108,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13127 = [];
var len__5726__auto___13183 = arguments.length;
var i__5727__auto___13184 = (0);
while(true){
if((i__5727__auto___13184 < len__5726__auto___13183)){
args13127.push((arguments[i__5727__auto___13184]));

var G__13185 = (i__5727__auto___13184 + (1));
i__5727__auto___13184 = G__13185;
continue;
} else {
}
break;
}

var G__13129 = args13127.length;
switch (G__13129) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13127.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___13187 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___13187,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___13187,out){
return (function (state_13159){
var state_val_13160 = (state_13159[(1)]);
if((state_val_13160 === (7))){
var inst_13139 = (state_13159[(7)]);
var inst_13138 = (state_13159[(8)]);
var inst_13138__$1 = (state_13159[(2)]);
var inst_13139__$1 = cljs.core.nth.call(null,inst_13138__$1,(0),null);
var inst_13140 = cljs.core.nth.call(null,inst_13138__$1,(1),null);
var inst_13141 = (inst_13139__$1 == null);
var state_13159__$1 = (function (){var statearr_13161 = state_13159;
(statearr_13161[(7)] = inst_13139__$1);

(statearr_13161[(8)] = inst_13138__$1);

(statearr_13161[(9)] = inst_13140);

return statearr_13161;
})();
if(cljs.core.truth_(inst_13141)){
var statearr_13162_13188 = state_13159__$1;
(statearr_13162_13188[(1)] = (8));

} else {
var statearr_13163_13189 = state_13159__$1;
(statearr_13163_13189[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (1))){
var inst_13130 = cljs.core.vec.call(null,chs);
var inst_13131 = inst_13130;
var state_13159__$1 = (function (){var statearr_13164 = state_13159;
(statearr_13164[(10)] = inst_13131);

return statearr_13164;
})();
var statearr_13165_13190 = state_13159__$1;
(statearr_13165_13190[(2)] = null);

(statearr_13165_13190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (4))){
var inst_13131 = (state_13159[(10)]);
var state_13159__$1 = state_13159;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13159__$1,(7),inst_13131);
} else {
if((state_val_13160 === (6))){
var inst_13155 = (state_13159[(2)]);
var state_13159__$1 = state_13159;
var statearr_13166_13191 = state_13159__$1;
(statearr_13166_13191[(2)] = inst_13155);

(statearr_13166_13191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (3))){
var inst_13157 = (state_13159[(2)]);
var state_13159__$1 = state_13159;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13159__$1,inst_13157);
} else {
if((state_val_13160 === (2))){
var inst_13131 = (state_13159[(10)]);
var inst_13133 = cljs.core.count.call(null,inst_13131);
var inst_13134 = (inst_13133 > (0));
var state_13159__$1 = state_13159;
if(cljs.core.truth_(inst_13134)){
var statearr_13168_13192 = state_13159__$1;
(statearr_13168_13192[(1)] = (4));

} else {
var statearr_13169_13193 = state_13159__$1;
(statearr_13169_13193[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (11))){
var inst_13131 = (state_13159[(10)]);
var inst_13148 = (state_13159[(2)]);
var tmp13167 = inst_13131;
var inst_13131__$1 = tmp13167;
var state_13159__$1 = (function (){var statearr_13170 = state_13159;
(statearr_13170[(10)] = inst_13131__$1);

(statearr_13170[(11)] = inst_13148);

return statearr_13170;
})();
var statearr_13171_13194 = state_13159__$1;
(statearr_13171_13194[(2)] = null);

(statearr_13171_13194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (9))){
var inst_13139 = (state_13159[(7)]);
var state_13159__$1 = state_13159;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13159__$1,(11),out,inst_13139);
} else {
if((state_val_13160 === (5))){
var inst_13153 = cljs.core.async.close_BANG_.call(null,out);
var state_13159__$1 = state_13159;
var statearr_13172_13195 = state_13159__$1;
(statearr_13172_13195[(2)] = inst_13153);

(statearr_13172_13195[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (10))){
var inst_13151 = (state_13159[(2)]);
var state_13159__$1 = state_13159;
var statearr_13173_13196 = state_13159__$1;
(statearr_13173_13196[(2)] = inst_13151);

(statearr_13173_13196[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (8))){
var inst_13131 = (state_13159[(10)]);
var inst_13139 = (state_13159[(7)]);
var inst_13138 = (state_13159[(8)]);
var inst_13140 = (state_13159[(9)]);
var inst_13143 = (function (){var cs = inst_13131;
var vec__13136 = inst_13138;
var v = inst_13139;
var c = inst_13140;
return ((function (cs,vec__13136,v,c,inst_13131,inst_13139,inst_13138,inst_13140,state_val_13160,c__11089__auto___13187,out){
return (function (p1__13126_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13126_SHARP_);
});
;})(cs,vec__13136,v,c,inst_13131,inst_13139,inst_13138,inst_13140,state_val_13160,c__11089__auto___13187,out))
})();
var inst_13144 = cljs.core.filterv.call(null,inst_13143,inst_13131);
var inst_13131__$1 = inst_13144;
var state_13159__$1 = (function (){var statearr_13174 = state_13159;
(statearr_13174[(10)] = inst_13131__$1);

return statearr_13174;
})();
var statearr_13175_13197 = state_13159__$1;
(statearr_13175_13197[(2)] = null);

(statearr_13175_13197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___13187,out))
;
return ((function (switch__10977__auto__,c__11089__auto___13187,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_13179 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13179[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_13179[(1)] = (1));

return statearr_13179;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_13159){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_13159);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e13180){if((e13180 instanceof Object)){
var ex__10981__auto__ = e13180;
var statearr_13181_13198 = state_13159;
(statearr_13181_13198[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13159);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13180;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13199 = state_13159;
state_13159 = G__13199;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_13159){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_13159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___13187,out))
})();
var state__11091__auto__ = (function (){var statearr_13182 = f__11090__auto__.call(null);
(statearr_13182[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___13187);

return statearr_13182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___13187,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13200 = [];
var len__5726__auto___13249 = arguments.length;
var i__5727__auto___13250 = (0);
while(true){
if((i__5727__auto___13250 < len__5726__auto___13249)){
args13200.push((arguments[i__5727__auto___13250]));

var G__13251 = (i__5727__auto___13250 + (1));
i__5727__auto___13250 = G__13251;
continue;
} else {
}
break;
}

var G__13202 = args13200.length;
switch (G__13202) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13200.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___13253 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___13253,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___13253,out){
return (function (state_13226){
var state_val_13227 = (state_13226[(1)]);
if((state_val_13227 === (7))){
var inst_13208 = (state_13226[(7)]);
var inst_13208__$1 = (state_13226[(2)]);
var inst_13209 = (inst_13208__$1 == null);
var inst_13210 = cljs.core.not.call(null,inst_13209);
var state_13226__$1 = (function (){var statearr_13228 = state_13226;
(statearr_13228[(7)] = inst_13208__$1);

return statearr_13228;
})();
if(inst_13210){
var statearr_13229_13254 = state_13226__$1;
(statearr_13229_13254[(1)] = (8));

} else {
var statearr_13230_13255 = state_13226__$1;
(statearr_13230_13255[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13227 === (1))){
var inst_13203 = (0);
var state_13226__$1 = (function (){var statearr_13231 = state_13226;
(statearr_13231[(8)] = inst_13203);

return statearr_13231;
})();
var statearr_13232_13256 = state_13226__$1;
(statearr_13232_13256[(2)] = null);

(statearr_13232_13256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13227 === (4))){
var state_13226__$1 = state_13226;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13226__$1,(7),ch);
} else {
if((state_val_13227 === (6))){
var inst_13221 = (state_13226[(2)]);
var state_13226__$1 = state_13226;
var statearr_13233_13257 = state_13226__$1;
(statearr_13233_13257[(2)] = inst_13221);

(statearr_13233_13257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13227 === (3))){
var inst_13223 = (state_13226[(2)]);
var inst_13224 = cljs.core.async.close_BANG_.call(null,out);
var state_13226__$1 = (function (){var statearr_13234 = state_13226;
(statearr_13234[(9)] = inst_13223);

return statearr_13234;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13226__$1,inst_13224);
} else {
if((state_val_13227 === (2))){
var inst_13203 = (state_13226[(8)]);
var inst_13205 = (inst_13203 < n);
var state_13226__$1 = state_13226;
if(cljs.core.truth_(inst_13205)){
var statearr_13235_13258 = state_13226__$1;
(statearr_13235_13258[(1)] = (4));

} else {
var statearr_13236_13259 = state_13226__$1;
(statearr_13236_13259[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13227 === (11))){
var inst_13203 = (state_13226[(8)]);
var inst_13213 = (state_13226[(2)]);
var inst_13214 = (inst_13203 + (1));
var inst_13203__$1 = inst_13214;
var state_13226__$1 = (function (){var statearr_13237 = state_13226;
(statearr_13237[(10)] = inst_13213);

(statearr_13237[(8)] = inst_13203__$1);

return statearr_13237;
})();
var statearr_13238_13260 = state_13226__$1;
(statearr_13238_13260[(2)] = null);

(statearr_13238_13260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13227 === (9))){
var state_13226__$1 = state_13226;
var statearr_13239_13261 = state_13226__$1;
(statearr_13239_13261[(2)] = null);

(statearr_13239_13261[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13227 === (5))){
var state_13226__$1 = state_13226;
var statearr_13240_13262 = state_13226__$1;
(statearr_13240_13262[(2)] = null);

(statearr_13240_13262[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13227 === (10))){
var inst_13218 = (state_13226[(2)]);
var state_13226__$1 = state_13226;
var statearr_13241_13263 = state_13226__$1;
(statearr_13241_13263[(2)] = inst_13218);

(statearr_13241_13263[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13227 === (8))){
var inst_13208 = (state_13226[(7)]);
var state_13226__$1 = state_13226;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13226__$1,(11),out,inst_13208);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___13253,out))
;
return ((function (switch__10977__auto__,c__11089__auto___13253,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_13245 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13245[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_13245[(1)] = (1));

return statearr_13245;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_13226){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_13226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e13246){if((e13246 instanceof Object)){
var ex__10981__auto__ = e13246;
var statearr_13247_13264 = state_13226;
(statearr_13247_13264[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13226);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13246;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13265 = state_13226;
state_13226 = G__13265;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_13226){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_13226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___13253,out))
})();
var state__11091__auto__ = (function (){var statearr_13248 = f__11090__auto__.call(null);
(statearr_13248[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___13253);

return statearr_13248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___13253,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13273 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13273 = (function (map_LT_,f,ch,meta13274){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13274 = meta13274;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13275,meta13274__$1){
var self__ = this;
var _13275__$1 = this;
return (new cljs.core.async.t_cljs$core$async13273(self__.map_LT_,self__.f,self__.ch,meta13274__$1));
});

cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13275){
var self__ = this;
var _13275__$1 = this;
return self__.meta13274;
});

cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async13276 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13276 = (function (map_LT_,f,ch,meta13274,_,fn1,meta13277){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13274 = meta13274;
this._ = _;
this.fn1 = fn1;
this.meta13277 = meta13277;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13276.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13278,meta13277__$1){
var self__ = this;
var _13278__$1 = this;
return (new cljs.core.async.t_cljs$core$async13276(self__.map_LT_,self__.f,self__.ch,self__.meta13274,self__._,self__.fn1,meta13277__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async13276.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13278){
var self__ = this;
var _13278__$1 = this;
return self__.meta13277;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13276.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13276.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13276.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13276.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__13266_SHARP_){
return f1.call(null,(((p1__13266_SHARP_ == null))?null:self__.f.call(null,p1__13266_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async13276.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13274","meta13274",254813307,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13273","cljs.core.async/t_cljs$core$async13273",1778680686,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13277","meta13277",218277886,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13276.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13276.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13276";

cljs.core.async.t_cljs$core$async13276.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13276");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async13276 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13276(map_LT___$1,f__$1,ch__$1,meta13274__$1,___$2,fn1__$1,meta13277){
return (new cljs.core.async.t_cljs$core$async13276(map_LT___$1,f__$1,ch__$1,meta13274__$1,___$2,fn1__$1,meta13277));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async13276(self__.map_LT_,self__.f,self__.ch,self__.meta13274,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13273.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async13273.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13274","meta13274",254813307,null)], null);
});

cljs.core.async.t_cljs$core$async13273.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13273.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13273";

cljs.core.async.t_cljs$core$async13273.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13273");
});

cljs.core.async.__GT_t_cljs$core$async13273 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13273(map_LT___$1,f__$1,ch__$1,meta13274){
return (new cljs.core.async.t_cljs$core$async13273(map_LT___$1,f__$1,ch__$1,meta13274));
});

}

return (new cljs.core.async.t_cljs$core$async13273(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13282 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13282 = (function (map_GT_,f,ch,meta13283){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta13283 = meta13283;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13282.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13284,meta13283__$1){
var self__ = this;
var _13284__$1 = this;
return (new cljs.core.async.t_cljs$core$async13282(self__.map_GT_,self__.f,self__.ch,meta13283__$1));
});

cljs.core.async.t_cljs$core$async13282.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13284){
var self__ = this;
var _13284__$1 = this;
return self__.meta13283;
});

cljs.core.async.t_cljs$core$async13282.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13282.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13282.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13282.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13282.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13282.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async13282.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13283","meta13283",-142163368,null)], null);
});

cljs.core.async.t_cljs$core$async13282.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13282.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13282";

cljs.core.async.t_cljs$core$async13282.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13282");
});

cljs.core.async.__GT_t_cljs$core$async13282 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13282(map_GT___$1,f__$1,ch__$1,meta13283){
return (new cljs.core.async.t_cljs$core$async13282(map_GT___$1,f__$1,ch__$1,meta13283));
});

}

return (new cljs.core.async.t_cljs$core$async13282(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async13288 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13288 = (function (filter_GT_,p,ch,meta13289){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13289 = meta13289;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13290,meta13289__$1){
var self__ = this;
var _13290__$1 = this;
return (new cljs.core.async.t_cljs$core$async13288(self__.filter_GT_,self__.p,self__.ch,meta13289__$1));
});

cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13290){
var self__ = this;
var _13290__$1 = this;
return self__.meta13289;
});

cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13288.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async13288.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13289","meta13289",-378171654,null)], null);
});

cljs.core.async.t_cljs$core$async13288.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13288.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13288";

cljs.core.async.t_cljs$core$async13288.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13288");
});

cljs.core.async.__GT_t_cljs$core$async13288 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13288(filter_GT___$1,p__$1,ch__$1,meta13289){
return (new cljs.core.async.t_cljs$core$async13288(filter_GT___$1,p__$1,ch__$1,meta13289));
});

}

return (new cljs.core.async.t_cljs$core$async13288(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args13291 = [];
var len__5726__auto___13335 = arguments.length;
var i__5727__auto___13336 = (0);
while(true){
if((i__5727__auto___13336 < len__5726__auto___13335)){
args13291.push((arguments[i__5727__auto___13336]));

var G__13337 = (i__5727__auto___13336 + (1));
i__5727__auto___13336 = G__13337;
continue;
} else {
}
break;
}

var G__13293 = args13291.length;
switch (G__13293) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13291.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___13339 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___13339,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___13339,out){
return (function (state_13314){
var state_val_13315 = (state_13314[(1)]);
if((state_val_13315 === (7))){
var inst_13310 = (state_13314[(2)]);
var state_13314__$1 = state_13314;
var statearr_13316_13340 = state_13314__$1;
(statearr_13316_13340[(2)] = inst_13310);

(statearr_13316_13340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13315 === (1))){
var state_13314__$1 = state_13314;
var statearr_13317_13341 = state_13314__$1;
(statearr_13317_13341[(2)] = null);

(statearr_13317_13341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13315 === (4))){
var inst_13296 = (state_13314[(7)]);
var inst_13296__$1 = (state_13314[(2)]);
var inst_13297 = (inst_13296__$1 == null);
var state_13314__$1 = (function (){var statearr_13318 = state_13314;
(statearr_13318[(7)] = inst_13296__$1);

return statearr_13318;
})();
if(cljs.core.truth_(inst_13297)){
var statearr_13319_13342 = state_13314__$1;
(statearr_13319_13342[(1)] = (5));

} else {
var statearr_13320_13343 = state_13314__$1;
(statearr_13320_13343[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13315 === (6))){
var inst_13296 = (state_13314[(7)]);
var inst_13301 = p.call(null,inst_13296);
var state_13314__$1 = state_13314;
if(cljs.core.truth_(inst_13301)){
var statearr_13321_13344 = state_13314__$1;
(statearr_13321_13344[(1)] = (8));

} else {
var statearr_13322_13345 = state_13314__$1;
(statearr_13322_13345[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13315 === (3))){
var inst_13312 = (state_13314[(2)]);
var state_13314__$1 = state_13314;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13314__$1,inst_13312);
} else {
if((state_val_13315 === (2))){
var state_13314__$1 = state_13314;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13314__$1,(4),ch);
} else {
if((state_val_13315 === (11))){
var inst_13304 = (state_13314[(2)]);
var state_13314__$1 = state_13314;
var statearr_13323_13346 = state_13314__$1;
(statearr_13323_13346[(2)] = inst_13304);

(statearr_13323_13346[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13315 === (9))){
var state_13314__$1 = state_13314;
var statearr_13324_13347 = state_13314__$1;
(statearr_13324_13347[(2)] = null);

(statearr_13324_13347[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13315 === (5))){
var inst_13299 = cljs.core.async.close_BANG_.call(null,out);
var state_13314__$1 = state_13314;
var statearr_13325_13348 = state_13314__$1;
(statearr_13325_13348[(2)] = inst_13299);

(statearr_13325_13348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13315 === (10))){
var inst_13307 = (state_13314[(2)]);
var state_13314__$1 = (function (){var statearr_13326 = state_13314;
(statearr_13326[(8)] = inst_13307);

return statearr_13326;
})();
var statearr_13327_13349 = state_13314__$1;
(statearr_13327_13349[(2)] = null);

(statearr_13327_13349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13315 === (8))){
var inst_13296 = (state_13314[(7)]);
var state_13314__$1 = state_13314;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13314__$1,(11),out,inst_13296);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___13339,out))
;
return ((function (switch__10977__auto__,c__11089__auto___13339,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_13331 = [null,null,null,null,null,null,null,null,null];
(statearr_13331[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_13331[(1)] = (1));

return statearr_13331;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_13314){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_13314);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e13332){if((e13332 instanceof Object)){
var ex__10981__auto__ = e13332;
var statearr_13333_13350 = state_13314;
(statearr_13333_13350[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13314);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13332;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13351 = state_13314;
state_13314 = G__13351;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_13314){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_13314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___13339,out))
})();
var state__11091__auto__ = (function (){var statearr_13334 = f__11090__auto__.call(null);
(statearr_13334[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___13339);

return statearr_13334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___13339,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args13352 = [];
var len__5726__auto___13355 = arguments.length;
var i__5727__auto___13356 = (0);
while(true){
if((i__5727__auto___13356 < len__5726__auto___13355)){
args13352.push((arguments[i__5727__auto___13356]));

var G__13357 = (i__5727__auto___13356 + (1));
i__5727__auto___13356 = G__13357;
continue;
} else {
}
break;
}

var G__13354 = args13352.length;
switch (G__13354) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13352.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11089__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto__){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto__){
return (function (state_13524){
var state_val_13525 = (state_13524[(1)]);
if((state_val_13525 === (7))){
var inst_13520 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13526_13567 = state_13524__$1;
(statearr_13526_13567[(2)] = inst_13520);

(statearr_13526_13567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (20))){
var inst_13490 = (state_13524[(7)]);
var inst_13501 = (state_13524[(2)]);
var inst_13502 = cljs.core.next.call(null,inst_13490);
var inst_13476 = inst_13502;
var inst_13477 = null;
var inst_13478 = (0);
var inst_13479 = (0);
var state_13524__$1 = (function (){var statearr_13527 = state_13524;
(statearr_13527[(8)] = inst_13479);

(statearr_13527[(9)] = inst_13477);

(statearr_13527[(10)] = inst_13501);

(statearr_13527[(11)] = inst_13478);

(statearr_13527[(12)] = inst_13476);

return statearr_13527;
})();
var statearr_13528_13568 = state_13524__$1;
(statearr_13528_13568[(2)] = null);

(statearr_13528_13568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (1))){
var state_13524__$1 = state_13524;
var statearr_13529_13569 = state_13524__$1;
(statearr_13529_13569[(2)] = null);

(statearr_13529_13569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (4))){
var inst_13465 = (state_13524[(13)]);
var inst_13465__$1 = (state_13524[(2)]);
var inst_13466 = (inst_13465__$1 == null);
var state_13524__$1 = (function (){var statearr_13530 = state_13524;
(statearr_13530[(13)] = inst_13465__$1);

return statearr_13530;
})();
if(cljs.core.truth_(inst_13466)){
var statearr_13531_13570 = state_13524__$1;
(statearr_13531_13570[(1)] = (5));

} else {
var statearr_13532_13571 = state_13524__$1;
(statearr_13532_13571[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (15))){
var state_13524__$1 = state_13524;
var statearr_13536_13572 = state_13524__$1;
(statearr_13536_13572[(2)] = null);

(statearr_13536_13572[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (21))){
var state_13524__$1 = state_13524;
var statearr_13537_13573 = state_13524__$1;
(statearr_13537_13573[(2)] = null);

(statearr_13537_13573[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (13))){
var inst_13479 = (state_13524[(8)]);
var inst_13477 = (state_13524[(9)]);
var inst_13478 = (state_13524[(11)]);
var inst_13476 = (state_13524[(12)]);
var inst_13486 = (state_13524[(2)]);
var inst_13487 = (inst_13479 + (1));
var tmp13533 = inst_13477;
var tmp13534 = inst_13478;
var tmp13535 = inst_13476;
var inst_13476__$1 = tmp13535;
var inst_13477__$1 = tmp13533;
var inst_13478__$1 = tmp13534;
var inst_13479__$1 = inst_13487;
var state_13524__$1 = (function (){var statearr_13538 = state_13524;
(statearr_13538[(8)] = inst_13479__$1);

(statearr_13538[(9)] = inst_13477__$1);

(statearr_13538[(14)] = inst_13486);

(statearr_13538[(11)] = inst_13478__$1);

(statearr_13538[(12)] = inst_13476__$1);

return statearr_13538;
})();
var statearr_13539_13574 = state_13524__$1;
(statearr_13539_13574[(2)] = null);

(statearr_13539_13574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (22))){
var state_13524__$1 = state_13524;
var statearr_13540_13575 = state_13524__$1;
(statearr_13540_13575[(2)] = null);

(statearr_13540_13575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (6))){
var inst_13465 = (state_13524[(13)]);
var inst_13474 = f.call(null,inst_13465);
var inst_13475 = cljs.core.seq.call(null,inst_13474);
var inst_13476 = inst_13475;
var inst_13477 = null;
var inst_13478 = (0);
var inst_13479 = (0);
var state_13524__$1 = (function (){var statearr_13541 = state_13524;
(statearr_13541[(8)] = inst_13479);

(statearr_13541[(9)] = inst_13477);

(statearr_13541[(11)] = inst_13478);

(statearr_13541[(12)] = inst_13476);

return statearr_13541;
})();
var statearr_13542_13576 = state_13524__$1;
(statearr_13542_13576[(2)] = null);

(statearr_13542_13576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (17))){
var inst_13490 = (state_13524[(7)]);
var inst_13494 = cljs.core.chunk_first.call(null,inst_13490);
var inst_13495 = cljs.core.chunk_rest.call(null,inst_13490);
var inst_13496 = cljs.core.count.call(null,inst_13494);
var inst_13476 = inst_13495;
var inst_13477 = inst_13494;
var inst_13478 = inst_13496;
var inst_13479 = (0);
var state_13524__$1 = (function (){var statearr_13543 = state_13524;
(statearr_13543[(8)] = inst_13479);

(statearr_13543[(9)] = inst_13477);

(statearr_13543[(11)] = inst_13478);

(statearr_13543[(12)] = inst_13476);

return statearr_13543;
})();
var statearr_13544_13577 = state_13524__$1;
(statearr_13544_13577[(2)] = null);

(statearr_13544_13577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (3))){
var inst_13522 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13524__$1,inst_13522);
} else {
if((state_val_13525 === (12))){
var inst_13510 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13545_13578 = state_13524__$1;
(statearr_13545_13578[(2)] = inst_13510);

(statearr_13545_13578[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (2))){
var state_13524__$1 = state_13524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13524__$1,(4),in$);
} else {
if((state_val_13525 === (23))){
var inst_13518 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13546_13579 = state_13524__$1;
(statearr_13546_13579[(2)] = inst_13518);

(statearr_13546_13579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (19))){
var inst_13505 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13547_13580 = state_13524__$1;
(statearr_13547_13580[(2)] = inst_13505);

(statearr_13547_13580[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (11))){
var inst_13490 = (state_13524[(7)]);
var inst_13476 = (state_13524[(12)]);
var inst_13490__$1 = cljs.core.seq.call(null,inst_13476);
var state_13524__$1 = (function (){var statearr_13548 = state_13524;
(statearr_13548[(7)] = inst_13490__$1);

return statearr_13548;
})();
if(inst_13490__$1){
var statearr_13549_13581 = state_13524__$1;
(statearr_13549_13581[(1)] = (14));

} else {
var statearr_13550_13582 = state_13524__$1;
(statearr_13550_13582[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (9))){
var inst_13512 = (state_13524[(2)]);
var inst_13513 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13524__$1 = (function (){var statearr_13551 = state_13524;
(statearr_13551[(15)] = inst_13512);

return statearr_13551;
})();
if(cljs.core.truth_(inst_13513)){
var statearr_13552_13583 = state_13524__$1;
(statearr_13552_13583[(1)] = (21));

} else {
var statearr_13553_13584 = state_13524__$1;
(statearr_13553_13584[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (5))){
var inst_13468 = cljs.core.async.close_BANG_.call(null,out);
var state_13524__$1 = state_13524;
var statearr_13554_13585 = state_13524__$1;
(statearr_13554_13585[(2)] = inst_13468);

(statearr_13554_13585[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (14))){
var inst_13490 = (state_13524[(7)]);
var inst_13492 = cljs.core.chunked_seq_QMARK_.call(null,inst_13490);
var state_13524__$1 = state_13524;
if(inst_13492){
var statearr_13555_13586 = state_13524__$1;
(statearr_13555_13586[(1)] = (17));

} else {
var statearr_13556_13587 = state_13524__$1;
(statearr_13556_13587[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (16))){
var inst_13508 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13557_13588 = state_13524__$1;
(statearr_13557_13588[(2)] = inst_13508);

(statearr_13557_13588[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (10))){
var inst_13479 = (state_13524[(8)]);
var inst_13477 = (state_13524[(9)]);
var inst_13484 = cljs.core._nth.call(null,inst_13477,inst_13479);
var state_13524__$1 = state_13524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13524__$1,(13),out,inst_13484);
} else {
if((state_val_13525 === (18))){
var inst_13490 = (state_13524[(7)]);
var inst_13499 = cljs.core.first.call(null,inst_13490);
var state_13524__$1 = state_13524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13524__$1,(20),out,inst_13499);
} else {
if((state_val_13525 === (8))){
var inst_13479 = (state_13524[(8)]);
var inst_13478 = (state_13524[(11)]);
var inst_13481 = (inst_13479 < inst_13478);
var inst_13482 = inst_13481;
var state_13524__$1 = state_13524;
if(cljs.core.truth_(inst_13482)){
var statearr_13558_13589 = state_13524__$1;
(statearr_13558_13589[(1)] = (10));

} else {
var statearr_13559_13590 = state_13524__$1;
(statearr_13559_13590[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto__))
;
return ((function (switch__10977__auto__,c__11089__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_13563 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13563[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__);

(statearr_13563[(1)] = (1));

return statearr_13563;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____1 = (function (state_13524){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_13524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e13564){if((e13564 instanceof Object)){
var ex__10981__auto__ = e13564;
var statearr_13565_13591 = state_13524;
(statearr_13565_13591[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13564;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13592 = state_13524;
state_13524 = G__13592;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__ = function(state_13524){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____1.call(this,state_13524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto__))
})();
var state__11091__auto__ = (function (){var statearr_13566 = f__11090__auto__.call(null);
(statearr_13566[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto__);

return statearr_13566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto__))
);

return c__11089__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13593 = [];
var len__5726__auto___13596 = arguments.length;
var i__5727__auto___13597 = (0);
while(true){
if((i__5727__auto___13597 < len__5726__auto___13596)){
args13593.push((arguments[i__5727__auto___13597]));

var G__13598 = (i__5727__auto___13597 + (1));
i__5727__auto___13597 = G__13598;
continue;
} else {
}
break;
}

var G__13595 = args13593.length;
switch (G__13595) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13593.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13600 = [];
var len__5726__auto___13603 = arguments.length;
var i__5727__auto___13604 = (0);
while(true){
if((i__5727__auto___13604 < len__5726__auto___13603)){
args13600.push((arguments[i__5727__auto___13604]));

var G__13605 = (i__5727__auto___13604 + (1));
i__5727__auto___13604 = G__13605;
continue;
} else {
}
break;
}

var G__13602 = args13600.length;
switch (G__13602) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13600.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13607 = [];
var len__5726__auto___13658 = arguments.length;
var i__5727__auto___13659 = (0);
while(true){
if((i__5727__auto___13659 < len__5726__auto___13658)){
args13607.push((arguments[i__5727__auto___13659]));

var G__13660 = (i__5727__auto___13659 + (1));
i__5727__auto___13659 = G__13660;
continue;
} else {
}
break;
}

var G__13609 = args13607.length;
switch (G__13609) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13607.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___13662 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___13662,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___13662,out){
return (function (state_13633){
var state_val_13634 = (state_13633[(1)]);
if((state_val_13634 === (7))){
var inst_13628 = (state_13633[(2)]);
var state_13633__$1 = state_13633;
var statearr_13635_13663 = state_13633__$1;
(statearr_13635_13663[(2)] = inst_13628);

(statearr_13635_13663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13634 === (1))){
var inst_13610 = null;
var state_13633__$1 = (function (){var statearr_13636 = state_13633;
(statearr_13636[(7)] = inst_13610);

return statearr_13636;
})();
var statearr_13637_13664 = state_13633__$1;
(statearr_13637_13664[(2)] = null);

(statearr_13637_13664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13634 === (4))){
var inst_13613 = (state_13633[(8)]);
var inst_13613__$1 = (state_13633[(2)]);
var inst_13614 = (inst_13613__$1 == null);
var inst_13615 = cljs.core.not.call(null,inst_13614);
var state_13633__$1 = (function (){var statearr_13638 = state_13633;
(statearr_13638[(8)] = inst_13613__$1);

return statearr_13638;
})();
if(inst_13615){
var statearr_13639_13665 = state_13633__$1;
(statearr_13639_13665[(1)] = (5));

} else {
var statearr_13640_13666 = state_13633__$1;
(statearr_13640_13666[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13634 === (6))){
var state_13633__$1 = state_13633;
var statearr_13641_13667 = state_13633__$1;
(statearr_13641_13667[(2)] = null);

(statearr_13641_13667[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13634 === (3))){
var inst_13630 = (state_13633[(2)]);
var inst_13631 = cljs.core.async.close_BANG_.call(null,out);
var state_13633__$1 = (function (){var statearr_13642 = state_13633;
(statearr_13642[(9)] = inst_13630);

return statearr_13642;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13633__$1,inst_13631);
} else {
if((state_val_13634 === (2))){
var state_13633__$1 = state_13633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13633__$1,(4),ch);
} else {
if((state_val_13634 === (11))){
var inst_13613 = (state_13633[(8)]);
var inst_13622 = (state_13633[(2)]);
var inst_13610 = inst_13613;
var state_13633__$1 = (function (){var statearr_13643 = state_13633;
(statearr_13643[(7)] = inst_13610);

(statearr_13643[(10)] = inst_13622);

return statearr_13643;
})();
var statearr_13644_13668 = state_13633__$1;
(statearr_13644_13668[(2)] = null);

(statearr_13644_13668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13634 === (9))){
var inst_13613 = (state_13633[(8)]);
var state_13633__$1 = state_13633;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13633__$1,(11),out,inst_13613);
} else {
if((state_val_13634 === (5))){
var inst_13610 = (state_13633[(7)]);
var inst_13613 = (state_13633[(8)]);
var inst_13617 = cljs.core._EQ_.call(null,inst_13613,inst_13610);
var state_13633__$1 = state_13633;
if(inst_13617){
var statearr_13646_13669 = state_13633__$1;
(statearr_13646_13669[(1)] = (8));

} else {
var statearr_13647_13670 = state_13633__$1;
(statearr_13647_13670[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13634 === (10))){
var inst_13625 = (state_13633[(2)]);
var state_13633__$1 = state_13633;
var statearr_13648_13671 = state_13633__$1;
(statearr_13648_13671[(2)] = inst_13625);

(statearr_13648_13671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13634 === (8))){
var inst_13610 = (state_13633[(7)]);
var tmp13645 = inst_13610;
var inst_13610__$1 = tmp13645;
var state_13633__$1 = (function (){var statearr_13649 = state_13633;
(statearr_13649[(7)] = inst_13610__$1);

return statearr_13649;
})();
var statearr_13650_13672 = state_13633__$1;
(statearr_13650_13672[(2)] = null);

(statearr_13650_13672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___13662,out))
;
return ((function (switch__10977__auto__,c__11089__auto___13662,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_13654 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13654[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_13654[(1)] = (1));

return statearr_13654;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_13633){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_13633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e13655){if((e13655 instanceof Object)){
var ex__10981__auto__ = e13655;
var statearr_13656_13673 = state_13633;
(statearr_13656_13673[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13633);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13655;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13674 = state_13633;
state_13633 = G__13674;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_13633){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_13633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___13662,out))
})();
var state__11091__auto__ = (function (){var statearr_13657 = f__11090__auto__.call(null);
(statearr_13657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___13662);

return statearr_13657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___13662,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13675 = [];
var len__5726__auto___13745 = arguments.length;
var i__5727__auto___13746 = (0);
while(true){
if((i__5727__auto___13746 < len__5726__auto___13745)){
args13675.push((arguments[i__5727__auto___13746]));

var G__13747 = (i__5727__auto___13746 + (1));
i__5727__auto___13746 = G__13747;
continue;
} else {
}
break;
}

var G__13677 = args13675.length;
switch (G__13677) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13675.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___13749 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___13749,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___13749,out){
return (function (state_13715){
var state_val_13716 = (state_13715[(1)]);
if((state_val_13716 === (7))){
var inst_13711 = (state_13715[(2)]);
var state_13715__$1 = state_13715;
var statearr_13717_13750 = state_13715__$1;
(statearr_13717_13750[(2)] = inst_13711);

(statearr_13717_13750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (1))){
var inst_13678 = (new Array(n));
var inst_13679 = inst_13678;
var inst_13680 = (0);
var state_13715__$1 = (function (){var statearr_13718 = state_13715;
(statearr_13718[(7)] = inst_13679);

(statearr_13718[(8)] = inst_13680);

return statearr_13718;
})();
var statearr_13719_13751 = state_13715__$1;
(statearr_13719_13751[(2)] = null);

(statearr_13719_13751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (4))){
var inst_13683 = (state_13715[(9)]);
var inst_13683__$1 = (state_13715[(2)]);
var inst_13684 = (inst_13683__$1 == null);
var inst_13685 = cljs.core.not.call(null,inst_13684);
var state_13715__$1 = (function (){var statearr_13720 = state_13715;
(statearr_13720[(9)] = inst_13683__$1);

return statearr_13720;
})();
if(inst_13685){
var statearr_13721_13752 = state_13715__$1;
(statearr_13721_13752[(1)] = (5));

} else {
var statearr_13722_13753 = state_13715__$1;
(statearr_13722_13753[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (15))){
var inst_13705 = (state_13715[(2)]);
var state_13715__$1 = state_13715;
var statearr_13723_13754 = state_13715__$1;
(statearr_13723_13754[(2)] = inst_13705);

(statearr_13723_13754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (13))){
var state_13715__$1 = state_13715;
var statearr_13724_13755 = state_13715__$1;
(statearr_13724_13755[(2)] = null);

(statearr_13724_13755[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (6))){
var inst_13680 = (state_13715[(8)]);
var inst_13701 = (inst_13680 > (0));
var state_13715__$1 = state_13715;
if(cljs.core.truth_(inst_13701)){
var statearr_13725_13756 = state_13715__$1;
(statearr_13725_13756[(1)] = (12));

} else {
var statearr_13726_13757 = state_13715__$1;
(statearr_13726_13757[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (3))){
var inst_13713 = (state_13715[(2)]);
var state_13715__$1 = state_13715;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13715__$1,inst_13713);
} else {
if((state_val_13716 === (12))){
var inst_13679 = (state_13715[(7)]);
var inst_13703 = cljs.core.vec.call(null,inst_13679);
var state_13715__$1 = state_13715;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13715__$1,(15),out,inst_13703);
} else {
if((state_val_13716 === (2))){
var state_13715__$1 = state_13715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13715__$1,(4),ch);
} else {
if((state_val_13716 === (11))){
var inst_13695 = (state_13715[(2)]);
var inst_13696 = (new Array(n));
var inst_13679 = inst_13696;
var inst_13680 = (0);
var state_13715__$1 = (function (){var statearr_13727 = state_13715;
(statearr_13727[(10)] = inst_13695);

(statearr_13727[(7)] = inst_13679);

(statearr_13727[(8)] = inst_13680);

return statearr_13727;
})();
var statearr_13728_13758 = state_13715__$1;
(statearr_13728_13758[(2)] = null);

(statearr_13728_13758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (9))){
var inst_13679 = (state_13715[(7)]);
var inst_13693 = cljs.core.vec.call(null,inst_13679);
var state_13715__$1 = state_13715;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13715__$1,(11),out,inst_13693);
} else {
if((state_val_13716 === (5))){
var inst_13688 = (state_13715[(11)]);
var inst_13679 = (state_13715[(7)]);
var inst_13683 = (state_13715[(9)]);
var inst_13680 = (state_13715[(8)]);
var inst_13687 = (inst_13679[inst_13680] = inst_13683);
var inst_13688__$1 = (inst_13680 + (1));
var inst_13689 = (inst_13688__$1 < n);
var state_13715__$1 = (function (){var statearr_13729 = state_13715;
(statearr_13729[(11)] = inst_13688__$1);

(statearr_13729[(12)] = inst_13687);

return statearr_13729;
})();
if(cljs.core.truth_(inst_13689)){
var statearr_13730_13759 = state_13715__$1;
(statearr_13730_13759[(1)] = (8));

} else {
var statearr_13731_13760 = state_13715__$1;
(statearr_13731_13760[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (14))){
var inst_13708 = (state_13715[(2)]);
var inst_13709 = cljs.core.async.close_BANG_.call(null,out);
var state_13715__$1 = (function (){var statearr_13733 = state_13715;
(statearr_13733[(13)] = inst_13708);

return statearr_13733;
})();
var statearr_13734_13761 = state_13715__$1;
(statearr_13734_13761[(2)] = inst_13709);

(statearr_13734_13761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (10))){
var inst_13699 = (state_13715[(2)]);
var state_13715__$1 = state_13715;
var statearr_13735_13762 = state_13715__$1;
(statearr_13735_13762[(2)] = inst_13699);

(statearr_13735_13762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13716 === (8))){
var inst_13688 = (state_13715[(11)]);
var inst_13679 = (state_13715[(7)]);
var tmp13732 = inst_13679;
var inst_13679__$1 = tmp13732;
var inst_13680 = inst_13688;
var state_13715__$1 = (function (){var statearr_13736 = state_13715;
(statearr_13736[(7)] = inst_13679__$1);

(statearr_13736[(8)] = inst_13680);

return statearr_13736;
})();
var statearr_13737_13763 = state_13715__$1;
(statearr_13737_13763[(2)] = null);

(statearr_13737_13763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___13749,out))
;
return ((function (switch__10977__auto__,c__11089__auto___13749,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_13741 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13741[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_13741[(1)] = (1));

return statearr_13741;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_13715){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_13715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e13742){if((e13742 instanceof Object)){
var ex__10981__auto__ = e13742;
var statearr_13743_13764 = state_13715;
(statearr_13743_13764[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13715);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13742;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13765 = state_13715;
state_13715 = G__13765;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_13715){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_13715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___13749,out))
})();
var state__11091__auto__ = (function (){var statearr_13744 = f__11090__auto__.call(null);
(statearr_13744[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___13749);

return statearr_13744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___13749,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13766 = [];
var len__5726__auto___13840 = arguments.length;
var i__5727__auto___13841 = (0);
while(true){
if((i__5727__auto___13841 < len__5726__auto___13840)){
args13766.push((arguments[i__5727__auto___13841]));

var G__13842 = (i__5727__auto___13841 + (1));
i__5727__auto___13841 = G__13842;
continue;
} else {
}
break;
}

var G__13768 = args13766.length;
switch (G__13768) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13766.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___13844 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___13844,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___13844,out){
return (function (state_13810){
var state_val_13811 = (state_13810[(1)]);
if((state_val_13811 === (7))){
var inst_13806 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
var statearr_13812_13845 = state_13810__$1;
(statearr_13812_13845[(2)] = inst_13806);

(statearr_13812_13845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (1))){
var inst_13769 = [];
var inst_13770 = inst_13769;
var inst_13771 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13810__$1 = (function (){var statearr_13813 = state_13810;
(statearr_13813[(7)] = inst_13770);

(statearr_13813[(8)] = inst_13771);

return statearr_13813;
})();
var statearr_13814_13846 = state_13810__$1;
(statearr_13814_13846[(2)] = null);

(statearr_13814_13846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (4))){
var inst_13774 = (state_13810[(9)]);
var inst_13774__$1 = (state_13810[(2)]);
var inst_13775 = (inst_13774__$1 == null);
var inst_13776 = cljs.core.not.call(null,inst_13775);
var state_13810__$1 = (function (){var statearr_13815 = state_13810;
(statearr_13815[(9)] = inst_13774__$1);

return statearr_13815;
})();
if(inst_13776){
var statearr_13816_13847 = state_13810__$1;
(statearr_13816_13847[(1)] = (5));

} else {
var statearr_13817_13848 = state_13810__$1;
(statearr_13817_13848[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (15))){
var inst_13800 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
var statearr_13818_13849 = state_13810__$1;
(statearr_13818_13849[(2)] = inst_13800);

(statearr_13818_13849[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (13))){
var state_13810__$1 = state_13810;
var statearr_13819_13850 = state_13810__$1;
(statearr_13819_13850[(2)] = null);

(statearr_13819_13850[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (6))){
var inst_13770 = (state_13810[(7)]);
var inst_13795 = inst_13770.length;
var inst_13796 = (inst_13795 > (0));
var state_13810__$1 = state_13810;
if(cljs.core.truth_(inst_13796)){
var statearr_13820_13851 = state_13810__$1;
(statearr_13820_13851[(1)] = (12));

} else {
var statearr_13821_13852 = state_13810__$1;
(statearr_13821_13852[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (3))){
var inst_13808 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13810__$1,inst_13808);
} else {
if((state_val_13811 === (12))){
var inst_13770 = (state_13810[(7)]);
var inst_13798 = cljs.core.vec.call(null,inst_13770);
var state_13810__$1 = state_13810;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13810__$1,(15),out,inst_13798);
} else {
if((state_val_13811 === (2))){
var state_13810__$1 = state_13810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13810__$1,(4),ch);
} else {
if((state_val_13811 === (11))){
var inst_13778 = (state_13810[(10)]);
var inst_13774 = (state_13810[(9)]);
var inst_13788 = (state_13810[(2)]);
var inst_13789 = [];
var inst_13790 = inst_13789.push(inst_13774);
var inst_13770 = inst_13789;
var inst_13771 = inst_13778;
var state_13810__$1 = (function (){var statearr_13822 = state_13810;
(statearr_13822[(7)] = inst_13770);

(statearr_13822[(11)] = inst_13790);

(statearr_13822[(8)] = inst_13771);

(statearr_13822[(12)] = inst_13788);

return statearr_13822;
})();
var statearr_13823_13853 = state_13810__$1;
(statearr_13823_13853[(2)] = null);

(statearr_13823_13853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (9))){
var inst_13770 = (state_13810[(7)]);
var inst_13786 = cljs.core.vec.call(null,inst_13770);
var state_13810__$1 = state_13810;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13810__$1,(11),out,inst_13786);
} else {
if((state_val_13811 === (5))){
var inst_13778 = (state_13810[(10)]);
var inst_13774 = (state_13810[(9)]);
var inst_13771 = (state_13810[(8)]);
var inst_13778__$1 = f.call(null,inst_13774);
var inst_13779 = cljs.core._EQ_.call(null,inst_13778__$1,inst_13771);
var inst_13780 = cljs.core.keyword_identical_QMARK_.call(null,inst_13771,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13781 = (inst_13779) || (inst_13780);
var state_13810__$1 = (function (){var statearr_13824 = state_13810;
(statearr_13824[(10)] = inst_13778__$1);

return statearr_13824;
})();
if(cljs.core.truth_(inst_13781)){
var statearr_13825_13854 = state_13810__$1;
(statearr_13825_13854[(1)] = (8));

} else {
var statearr_13826_13855 = state_13810__$1;
(statearr_13826_13855[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (14))){
var inst_13803 = (state_13810[(2)]);
var inst_13804 = cljs.core.async.close_BANG_.call(null,out);
var state_13810__$1 = (function (){var statearr_13828 = state_13810;
(statearr_13828[(13)] = inst_13803);

return statearr_13828;
})();
var statearr_13829_13856 = state_13810__$1;
(statearr_13829_13856[(2)] = inst_13804);

(statearr_13829_13856[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (10))){
var inst_13793 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
var statearr_13830_13857 = state_13810__$1;
(statearr_13830_13857[(2)] = inst_13793);

(statearr_13830_13857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (8))){
var inst_13778 = (state_13810[(10)]);
var inst_13774 = (state_13810[(9)]);
var inst_13770 = (state_13810[(7)]);
var inst_13783 = inst_13770.push(inst_13774);
var tmp13827 = inst_13770;
var inst_13770__$1 = tmp13827;
var inst_13771 = inst_13778;
var state_13810__$1 = (function (){var statearr_13831 = state_13810;
(statearr_13831[(14)] = inst_13783);

(statearr_13831[(7)] = inst_13770__$1);

(statearr_13831[(8)] = inst_13771);

return statearr_13831;
})();
var statearr_13832_13858 = state_13810__$1;
(statearr_13832_13858[(2)] = null);

(statearr_13832_13858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___13844,out))
;
return ((function (switch__10977__auto__,c__11089__auto___13844,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_13836 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13836[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_13836[(1)] = (1));

return statearr_13836;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_13810){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_13810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e13837){if((e13837 instanceof Object)){
var ex__10981__auto__ = e13837;
var statearr_13838_13859 = state_13810;
(statearr_13838_13859[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13810);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13837;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13860 = state_13810;
state_13810 = G__13860;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_13810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_13810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___13844,out))
})();
var state__11091__auto__ = (function (){var statearr_13839 = f__11090__auto__.call(null);
(statearr_13839[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___13844);

return statearr_13839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___13844,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1465546856494