// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__13952__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__13949 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__13950 = cljs.core.seq.call(null,vec__13949);
var first__13951 = cljs.core.first.call(null,seq__13950);
var seq__13950__$1 = cljs.core.next.call(null,seq__13950);
var tag = first__13951;
var body = seq__13950__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__13952 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__13953__i = 0, G__13953__a = new Array(arguments.length -  0);
while (G__13953__i < G__13953__a.length) {G__13953__a[G__13953__i] = arguments[G__13953__i + 0]; ++G__13953__i;}
  args = new cljs.core.IndexedSeq(G__13953__a,0);
} 
return G__13952__delegate.call(this,args);};
G__13952.cljs$lang$maxFixedArity = 0;
G__13952.cljs$lang$applyTo = (function (arglist__13954){
var args = cljs.core.seq(arglist__13954);
return G__13952__delegate(args);
});
G__13952.cljs$core$IFn$_invoke$arity$variadic = G__13952__delegate;
return G__13952;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__13959(s__13960){
return (new cljs.core.LazySeq(null,(function (){
var s__13960__$1 = s__13960;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__13960__$1);
if(temp__4657__auto__){
var s__13960__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13960__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__13960__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__13962 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__13961 = (0);
while(true){
if((i__13961 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__13961);
cljs.core.chunk_append.call(null,b__13962,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__13963 = (i__13961 + (1));
i__13961 = G__13963;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13962),sablono$core$update_arglists_$_iter__13959.call(null,cljs.core.chunk_rest.call(null,s__13960__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13962),null);
}
} else {
var args = cljs.core.first.call(null,s__13960__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__13959.call(null,cljs.core.rest.call(null,s__13960__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13969 = arguments.length;
var i__7485__auto___13970 = (0);
while(true){
if((i__7485__auto___13970 < len__7484__auto___13969)){
args__7491__auto__.push((arguments[i__7485__auto___13970]));

var G__13971 = (i__7485__auto___13970 + (1));
i__7485__auto___13970 = G__13971;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__13965(s__13966){
return (new cljs.core.LazySeq(null,(function (){
var s__13966__$1 = s__13966;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__13966__$1);
if(temp__4657__auto__){
var s__13966__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13966__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__13966__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__13968 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__13967 = (0);
while(true){
if((i__13967 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__13967);
cljs.core.chunk_append.call(null,b__13968,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__13972 = (i__13967 + (1));
i__13967 = G__13972;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13968),sablono$core$iter__13965.call(null,cljs.core.chunk_rest.call(null,s__13966__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13968),null);
}
} else {
var style = cljs.core.first.call(null,s__13966__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__13965.call(null,cljs.core.rest.call(null,s__13966__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq13964){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq13964));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to13973 = (function sablono$core$link_to13973(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13976 = arguments.length;
var i__7485__auto___13977 = (0);
while(true){
if((i__7485__auto___13977 < len__7484__auto___13976)){
args__7491__auto__.push((arguments[i__7485__auto___13977]));

var G__13978 = (i__7485__auto___13977 + (1));
i__7485__auto___13977 = G__13978;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to13973.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to13973.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to13973.cljs$lang$maxFixedArity = (1);

sablono.core.link_to13973.cljs$lang$applyTo = (function (seq13974){
var G__13975 = cljs.core.first.call(null,seq13974);
var seq13974__$1 = cljs.core.next.call(null,seq13974);
return sablono.core.link_to13973.cljs$core$IFn$_invoke$arity$variadic(G__13975,seq13974__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to13973);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to13979 = (function sablono$core$mail_to13979(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13986 = arguments.length;
var i__7485__auto___13987 = (0);
while(true){
if((i__7485__auto___13987 < len__7484__auto___13986)){
args__7491__auto__.push((arguments[i__7485__auto___13987]));

var G__13988 = (i__7485__auto___13987 + (1));
i__7485__auto___13987 = G__13988;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to13979.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to13979.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__13982){
var vec__13983 = p__13982;
var content = cljs.core.nth.call(null,vec__13983,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to13979.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to13979.cljs$lang$applyTo = (function (seq13980){
var G__13981 = cljs.core.first.call(null,seq13980);
var seq13980__$1 = cljs.core.next.call(null,seq13980);
return sablono.core.mail_to13979.cljs$core$IFn$_invoke$arity$variadic(G__13981,seq13980__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to13979);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list13989 = (function sablono$core$unordered_list13989(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list13989_$_iter__13994(s__13995){
return (new cljs.core.LazySeq(null,(function (){
var s__13995__$1 = s__13995;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__13995__$1);
if(temp__4657__auto__){
var s__13995__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13995__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__13995__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__13997 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__13996 = (0);
while(true){
if((i__13996 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__13996);
cljs.core.chunk_append.call(null,b__13997,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__13998 = (i__13996 + (1));
i__13996 = G__13998;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13997),sablono$core$unordered_list13989_$_iter__13994.call(null,cljs.core.chunk_rest.call(null,s__13995__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13997),null);
}
} else {
var x = cljs.core.first.call(null,s__13995__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list13989_$_iter__13994.call(null,cljs.core.rest.call(null,s__13995__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list13989);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list13999 = (function sablono$core$ordered_list13999(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list13999_$_iter__14004(s__14005){
return (new cljs.core.LazySeq(null,(function (){
var s__14005__$1 = s__14005;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__14005__$1);
if(temp__4657__auto__){
var s__14005__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14005__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__14005__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__14007 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__14006 = (0);
while(true){
if((i__14006 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__14006);
cljs.core.chunk_append.call(null,b__14007,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__14008 = (i__14006 + (1));
i__14006 = G__14008;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14007),sablono$core$ordered_list13999_$_iter__14004.call(null,cljs.core.chunk_rest.call(null,s__14005__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14007),null);
}
} else {
var x = cljs.core.first.call(null,s__14005__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list13999_$_iter__14004.call(null,cljs.core.rest.call(null,s__14005__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list13999);
/**
 * Create an image element.
 */
sablono.core.image14009 = (function sablono$core$image14009(var_args){
var args14010 = [];
var len__7484__auto___14013 = arguments.length;
var i__7485__auto___14014 = (0);
while(true){
if((i__7485__auto___14014 < len__7484__auto___14013)){
args14010.push((arguments[i__7485__auto___14014]));

var G__14015 = (i__7485__auto___14014 + (1));
i__7485__auto___14014 = G__14015;
continue;
} else {
}
break;
}

var G__14012 = args14010.length;
switch (G__14012) {
case 1:
return sablono.core.image14009.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image14009.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14010.length)].join('')));

}
});

sablono.core.image14009.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image14009.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image14009.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image14009);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__14017_SHARP_,p2__14018_SHARP_){
return [cljs.core.str(p1__14017_SHARP_),cljs.core.str("["),cljs.core.str(p2__14018_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__14019_SHARP_,p2__14020_SHARP_){
return [cljs.core.str(p1__14019_SHARP_),cljs.core.str("-"),cljs.core.str(p2__14020_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field14021 = (function sablono$core$color_field14021(var_args){
var args14022 = [];
var len__7484__auto___14089 = arguments.length;
var i__7485__auto___14090 = (0);
while(true){
if((i__7485__auto___14090 < len__7484__auto___14089)){
args14022.push((arguments[i__7485__auto___14090]));

var G__14091 = (i__7485__auto___14090 + (1));
i__7485__auto___14090 = G__14091;
continue;
} else {
}
break;
}

var G__14024 = args14022.length;
switch (G__14024) {
case 1:
return sablono.core.color_field14021.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field14021.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14022.length)].join('')));

}
});

sablono.core.color_field14021.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.color_field14021.call(null,name__13936__auto__,null);
});

sablono.core.color_field14021.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.color_field14021.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field14021);

/**
 * Creates a date input field.
 */
sablono.core.date_field14025 = (function sablono$core$date_field14025(var_args){
var args14026 = [];
var len__7484__auto___14093 = arguments.length;
var i__7485__auto___14094 = (0);
while(true){
if((i__7485__auto___14094 < len__7484__auto___14093)){
args14026.push((arguments[i__7485__auto___14094]));

var G__14095 = (i__7485__auto___14094 + (1));
i__7485__auto___14094 = G__14095;
continue;
} else {
}
break;
}

var G__14028 = args14026.length;
switch (G__14028) {
case 1:
return sablono.core.date_field14025.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field14025.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14026.length)].join('')));

}
});

sablono.core.date_field14025.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.date_field14025.call(null,name__13936__auto__,null);
});

sablono.core.date_field14025.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.date_field14025.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field14025);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field14029 = (function sablono$core$datetime_field14029(var_args){
var args14030 = [];
var len__7484__auto___14097 = arguments.length;
var i__7485__auto___14098 = (0);
while(true){
if((i__7485__auto___14098 < len__7484__auto___14097)){
args14030.push((arguments[i__7485__auto___14098]));

var G__14099 = (i__7485__auto___14098 + (1));
i__7485__auto___14098 = G__14099;
continue;
} else {
}
break;
}

var G__14032 = args14030.length;
switch (G__14032) {
case 1:
return sablono.core.datetime_field14029.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field14029.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14030.length)].join('')));

}
});

sablono.core.datetime_field14029.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.datetime_field14029.call(null,name__13936__auto__,null);
});

sablono.core.datetime_field14029.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.datetime_field14029.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field14029);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field14033 = (function sablono$core$datetime_local_field14033(var_args){
var args14034 = [];
var len__7484__auto___14101 = arguments.length;
var i__7485__auto___14102 = (0);
while(true){
if((i__7485__auto___14102 < len__7484__auto___14101)){
args14034.push((arguments[i__7485__auto___14102]));

var G__14103 = (i__7485__auto___14102 + (1));
i__7485__auto___14102 = G__14103;
continue;
} else {
}
break;
}

var G__14036 = args14034.length;
switch (G__14036) {
case 1:
return sablono.core.datetime_local_field14033.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field14033.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14034.length)].join('')));

}
});

sablono.core.datetime_local_field14033.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.datetime_local_field14033.call(null,name__13936__auto__,null);
});

sablono.core.datetime_local_field14033.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.datetime_local_field14033.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field14033);

/**
 * Creates a email input field.
 */
sablono.core.email_field14037 = (function sablono$core$email_field14037(var_args){
var args14038 = [];
var len__7484__auto___14105 = arguments.length;
var i__7485__auto___14106 = (0);
while(true){
if((i__7485__auto___14106 < len__7484__auto___14105)){
args14038.push((arguments[i__7485__auto___14106]));

var G__14107 = (i__7485__auto___14106 + (1));
i__7485__auto___14106 = G__14107;
continue;
} else {
}
break;
}

var G__14040 = args14038.length;
switch (G__14040) {
case 1:
return sablono.core.email_field14037.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field14037.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14038.length)].join('')));

}
});

sablono.core.email_field14037.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.email_field14037.call(null,name__13936__auto__,null);
});

sablono.core.email_field14037.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.email_field14037.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field14037);

/**
 * Creates a file input field.
 */
sablono.core.file_field14041 = (function sablono$core$file_field14041(var_args){
var args14042 = [];
var len__7484__auto___14109 = arguments.length;
var i__7485__auto___14110 = (0);
while(true){
if((i__7485__auto___14110 < len__7484__auto___14109)){
args14042.push((arguments[i__7485__auto___14110]));

var G__14111 = (i__7485__auto___14110 + (1));
i__7485__auto___14110 = G__14111;
continue;
} else {
}
break;
}

var G__14044 = args14042.length;
switch (G__14044) {
case 1:
return sablono.core.file_field14041.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field14041.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14042.length)].join('')));

}
});

sablono.core.file_field14041.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.file_field14041.call(null,name__13936__auto__,null);
});

sablono.core.file_field14041.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.file_field14041.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field14041);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field14045 = (function sablono$core$hidden_field14045(var_args){
var args14046 = [];
var len__7484__auto___14113 = arguments.length;
var i__7485__auto___14114 = (0);
while(true){
if((i__7485__auto___14114 < len__7484__auto___14113)){
args14046.push((arguments[i__7485__auto___14114]));

var G__14115 = (i__7485__auto___14114 + (1));
i__7485__auto___14114 = G__14115;
continue;
} else {
}
break;
}

var G__14048 = args14046.length;
switch (G__14048) {
case 1:
return sablono.core.hidden_field14045.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field14045.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14046.length)].join('')));

}
});

sablono.core.hidden_field14045.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.hidden_field14045.call(null,name__13936__auto__,null);
});

sablono.core.hidden_field14045.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.hidden_field14045.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field14045);

/**
 * Creates a month input field.
 */
sablono.core.month_field14049 = (function sablono$core$month_field14049(var_args){
var args14050 = [];
var len__7484__auto___14117 = arguments.length;
var i__7485__auto___14118 = (0);
while(true){
if((i__7485__auto___14118 < len__7484__auto___14117)){
args14050.push((arguments[i__7485__auto___14118]));

var G__14119 = (i__7485__auto___14118 + (1));
i__7485__auto___14118 = G__14119;
continue;
} else {
}
break;
}

var G__14052 = args14050.length;
switch (G__14052) {
case 1:
return sablono.core.month_field14049.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field14049.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14050.length)].join('')));

}
});

sablono.core.month_field14049.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.month_field14049.call(null,name__13936__auto__,null);
});

sablono.core.month_field14049.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.month_field14049.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field14049);

/**
 * Creates a number input field.
 */
sablono.core.number_field14053 = (function sablono$core$number_field14053(var_args){
var args14054 = [];
var len__7484__auto___14121 = arguments.length;
var i__7485__auto___14122 = (0);
while(true){
if((i__7485__auto___14122 < len__7484__auto___14121)){
args14054.push((arguments[i__7485__auto___14122]));

var G__14123 = (i__7485__auto___14122 + (1));
i__7485__auto___14122 = G__14123;
continue;
} else {
}
break;
}

var G__14056 = args14054.length;
switch (G__14056) {
case 1:
return sablono.core.number_field14053.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field14053.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14054.length)].join('')));

}
});

sablono.core.number_field14053.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.number_field14053.call(null,name__13936__auto__,null);
});

sablono.core.number_field14053.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.number_field14053.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field14053);

/**
 * Creates a password input field.
 */
sablono.core.password_field14057 = (function sablono$core$password_field14057(var_args){
var args14058 = [];
var len__7484__auto___14125 = arguments.length;
var i__7485__auto___14126 = (0);
while(true){
if((i__7485__auto___14126 < len__7484__auto___14125)){
args14058.push((arguments[i__7485__auto___14126]));

var G__14127 = (i__7485__auto___14126 + (1));
i__7485__auto___14126 = G__14127;
continue;
} else {
}
break;
}

var G__14060 = args14058.length;
switch (G__14060) {
case 1:
return sablono.core.password_field14057.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field14057.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14058.length)].join('')));

}
});

sablono.core.password_field14057.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.password_field14057.call(null,name__13936__auto__,null);
});

sablono.core.password_field14057.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.password_field14057.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field14057);

/**
 * Creates a range input field.
 */
sablono.core.range_field14061 = (function sablono$core$range_field14061(var_args){
var args14062 = [];
var len__7484__auto___14129 = arguments.length;
var i__7485__auto___14130 = (0);
while(true){
if((i__7485__auto___14130 < len__7484__auto___14129)){
args14062.push((arguments[i__7485__auto___14130]));

var G__14131 = (i__7485__auto___14130 + (1));
i__7485__auto___14130 = G__14131;
continue;
} else {
}
break;
}

var G__14064 = args14062.length;
switch (G__14064) {
case 1:
return sablono.core.range_field14061.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field14061.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14062.length)].join('')));

}
});

sablono.core.range_field14061.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.range_field14061.call(null,name__13936__auto__,null);
});

sablono.core.range_field14061.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.range_field14061.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field14061);

/**
 * Creates a search input field.
 */
sablono.core.search_field14065 = (function sablono$core$search_field14065(var_args){
var args14066 = [];
var len__7484__auto___14133 = arguments.length;
var i__7485__auto___14134 = (0);
while(true){
if((i__7485__auto___14134 < len__7484__auto___14133)){
args14066.push((arguments[i__7485__auto___14134]));

var G__14135 = (i__7485__auto___14134 + (1));
i__7485__auto___14134 = G__14135;
continue;
} else {
}
break;
}

var G__14068 = args14066.length;
switch (G__14068) {
case 1:
return sablono.core.search_field14065.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field14065.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14066.length)].join('')));

}
});

sablono.core.search_field14065.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.search_field14065.call(null,name__13936__auto__,null);
});

sablono.core.search_field14065.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.search_field14065.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field14065);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field14069 = (function sablono$core$tel_field14069(var_args){
var args14070 = [];
var len__7484__auto___14137 = arguments.length;
var i__7485__auto___14138 = (0);
while(true){
if((i__7485__auto___14138 < len__7484__auto___14137)){
args14070.push((arguments[i__7485__auto___14138]));

var G__14139 = (i__7485__auto___14138 + (1));
i__7485__auto___14138 = G__14139;
continue;
} else {
}
break;
}

var G__14072 = args14070.length;
switch (G__14072) {
case 1:
return sablono.core.tel_field14069.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field14069.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14070.length)].join('')));

}
});

sablono.core.tel_field14069.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.tel_field14069.call(null,name__13936__auto__,null);
});

sablono.core.tel_field14069.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.tel_field14069.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field14069);

/**
 * Creates a text input field.
 */
sablono.core.text_field14073 = (function sablono$core$text_field14073(var_args){
var args14074 = [];
var len__7484__auto___14141 = arguments.length;
var i__7485__auto___14142 = (0);
while(true){
if((i__7485__auto___14142 < len__7484__auto___14141)){
args14074.push((arguments[i__7485__auto___14142]));

var G__14143 = (i__7485__auto___14142 + (1));
i__7485__auto___14142 = G__14143;
continue;
} else {
}
break;
}

var G__14076 = args14074.length;
switch (G__14076) {
case 1:
return sablono.core.text_field14073.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field14073.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14074.length)].join('')));

}
});

sablono.core.text_field14073.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.text_field14073.call(null,name__13936__auto__,null);
});

sablono.core.text_field14073.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.text_field14073.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field14073);

/**
 * Creates a time input field.
 */
sablono.core.time_field14077 = (function sablono$core$time_field14077(var_args){
var args14078 = [];
var len__7484__auto___14145 = arguments.length;
var i__7485__auto___14146 = (0);
while(true){
if((i__7485__auto___14146 < len__7484__auto___14145)){
args14078.push((arguments[i__7485__auto___14146]));

var G__14147 = (i__7485__auto___14146 + (1));
i__7485__auto___14146 = G__14147;
continue;
} else {
}
break;
}

var G__14080 = args14078.length;
switch (G__14080) {
case 1:
return sablono.core.time_field14077.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field14077.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14078.length)].join('')));

}
});

sablono.core.time_field14077.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.time_field14077.call(null,name__13936__auto__,null);
});

sablono.core.time_field14077.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.time_field14077.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field14077);

/**
 * Creates a url input field.
 */
sablono.core.url_field14081 = (function sablono$core$url_field14081(var_args){
var args14082 = [];
var len__7484__auto___14149 = arguments.length;
var i__7485__auto___14150 = (0);
while(true){
if((i__7485__auto___14150 < len__7484__auto___14149)){
args14082.push((arguments[i__7485__auto___14150]));

var G__14151 = (i__7485__auto___14150 + (1));
i__7485__auto___14150 = G__14151;
continue;
} else {
}
break;
}

var G__14084 = args14082.length;
switch (G__14084) {
case 1:
return sablono.core.url_field14081.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field14081.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14082.length)].join('')));

}
});

sablono.core.url_field14081.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.url_field14081.call(null,name__13936__auto__,null);
});

sablono.core.url_field14081.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.url_field14081.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field14081);

/**
 * Creates a week input field.
 */
sablono.core.week_field14085 = (function sablono$core$week_field14085(var_args){
var args14086 = [];
var len__7484__auto___14153 = arguments.length;
var i__7485__auto___14154 = (0);
while(true){
if((i__7485__auto___14154 < len__7484__auto___14153)){
args14086.push((arguments[i__7485__auto___14154]));

var G__14155 = (i__7485__auto___14154 + (1));
i__7485__auto___14154 = G__14155;
continue;
} else {
}
break;
}

var G__14088 = args14086.length;
switch (G__14088) {
case 1:
return sablono.core.week_field14085.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field14085.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14086.length)].join('')));

}
});

sablono.core.week_field14085.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.week_field14085.call(null,name__13936__auto__,null);
});

sablono.core.week_field14085.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.week_field14085.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field14085);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box14157 = (function sablono$core$check_box14157(var_args){
var args14158 = [];
var len__7484__auto___14161 = arguments.length;
var i__7485__auto___14162 = (0);
while(true){
if((i__7485__auto___14162 < len__7484__auto___14161)){
args14158.push((arguments[i__7485__auto___14162]));

var G__14163 = (i__7485__auto___14162 + (1));
i__7485__auto___14162 = G__14163;
continue;
} else {
}
break;
}

var G__14160 = args14158.length;
switch (G__14160) {
case 1:
return sablono.core.check_box14157.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box14157.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box14157.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14158.length)].join('')));

}
});

sablono.core.check_box14157.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box14157.call(null,name,null);
});

sablono.core.check_box14157.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box14157.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box14157.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box14157.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box14157);
/**
 * Creates a radio button.
 */
sablono.core.radio_button14165 = (function sablono$core$radio_button14165(var_args){
var args14166 = [];
var len__7484__auto___14169 = arguments.length;
var i__7485__auto___14170 = (0);
while(true){
if((i__7485__auto___14170 < len__7484__auto___14169)){
args14166.push((arguments[i__7485__auto___14170]));

var G__14171 = (i__7485__auto___14170 + (1));
i__7485__auto___14170 = G__14171;
continue;
} else {
}
break;
}

var G__14168 = args14166.length;
switch (G__14168) {
case 1:
return sablono.core.radio_button14165.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button14165.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button14165.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14166.length)].join('')));

}
});

sablono.core.radio_button14165.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button14165.call(null,group,null);
});

sablono.core.radio_button14165.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button14165.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button14165.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button14165.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button14165);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options14173 = (function sablono$core$select_options14173(coll){
var iter__7189__auto__ = (function sablono$core$select_options14173_$_iter__14190(s__14191){
return (new cljs.core.LazySeq(null,(function (){
var s__14191__$1 = s__14191;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__14191__$1);
if(temp__4657__auto__){
var s__14191__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14191__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__14191__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__14193 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__14192 = (0);
while(true){
if((i__14192 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__14192);
cljs.core.chunk_append.call(null,b__14193,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__14200 = x;
var text = cljs.core.nth.call(null,vec__14200,(0),null);
var val = cljs.core.nth.call(null,vec__14200,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__14200,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options14173.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__14206 = (i__14192 + (1));
i__14192 = G__14206;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14193),sablono$core$select_options14173_$_iter__14190.call(null,cljs.core.chunk_rest.call(null,s__14191__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14193),null);
}
} else {
var x = cljs.core.first.call(null,s__14191__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__14203 = x;
var text = cljs.core.nth.call(null,vec__14203,(0),null);
var val = cljs.core.nth.call(null,vec__14203,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__14203,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options14173.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options14173_$_iter__14190.call(null,cljs.core.rest.call(null,s__14191__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options14173);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down14207 = (function sablono$core$drop_down14207(var_args){
var args14208 = [];
var len__7484__auto___14211 = arguments.length;
var i__7485__auto___14212 = (0);
while(true){
if((i__7485__auto___14212 < len__7484__auto___14211)){
args14208.push((arguments[i__7485__auto___14212]));

var G__14213 = (i__7485__auto___14212 + (1));
i__7485__auto___14212 = G__14213;
continue;
} else {
}
break;
}

var G__14210 = args14208.length;
switch (G__14210) {
case 2:
return sablono.core.drop_down14207.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down14207.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14208.length)].join('')));

}
});

sablono.core.drop_down14207.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down14207.call(null,name,options,null);
});

sablono.core.drop_down14207.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down14207.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down14207);
/**
 * Creates a text area element.
 */
sablono.core.text_area14215 = (function sablono$core$text_area14215(var_args){
var args14216 = [];
var len__7484__auto___14219 = arguments.length;
var i__7485__auto___14220 = (0);
while(true){
if((i__7485__auto___14220 < len__7484__auto___14219)){
args14216.push((arguments[i__7485__auto___14220]));

var G__14221 = (i__7485__auto___14220 + (1));
i__7485__auto___14220 = G__14221;
continue;
} else {
}
break;
}

var G__14218 = args14216.length;
switch (G__14218) {
case 1:
return sablono.core.text_area14215.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area14215.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14216.length)].join('')));

}
});

sablono.core.text_area14215.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area14215.call(null,name,null);
});

sablono.core.text_area14215.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area14215.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area14215);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label14223 = (function sablono$core$label14223(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label14223);
/**
 * Creates a submit button.
 */
sablono.core.submit_button14224 = (function sablono$core$submit_button14224(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button14224);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button14225 = (function sablono$core$reset_button14225(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button14225);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to14226 = (function sablono$core$form_to14226(var_args){
var args__7491__auto__ = [];
var len__7484__auto___14233 = arguments.length;
var i__7485__auto___14234 = (0);
while(true){
if((i__7485__auto___14234 < len__7484__auto___14233)){
args__7491__auto__.push((arguments[i__7485__auto___14234]));

var G__14235 = (i__7485__auto___14234 + (1));
i__7485__auto___14234 = G__14235;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to14226.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to14226.cljs$core$IFn$_invoke$arity$variadic = (function (p__14229,body){
var vec__14230 = p__14229;
var method = cljs.core.nth.call(null,vec__14230,(0),null);
var action = cljs.core.nth.call(null,vec__14230,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to14226.cljs$lang$maxFixedArity = (1);

sablono.core.form_to14226.cljs$lang$applyTo = (function (seq14227){
var G__14228 = cljs.core.first.call(null,seq14227);
var seq14227__$1 = cljs.core.next.call(null,seq14227);
return sablono.core.form_to14226.cljs$core$IFn$_invoke$arity$variadic(G__14228,seq14227__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to14226);

//# sourceMappingURL=core.js.map?rel=1476624436167