// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args20253 = [];
var len__7484__auto___20259 = arguments.length;
var i__7485__auto___20260 = (0);
while(true){
if((i__7485__auto___20260 < len__7484__auto___20259)){
args20253.push((arguments[i__7485__auto___20260]));

var G__20261 = (i__7485__auto___20260 + (1));
i__7485__auto___20260 = G__20261;
continue;
} else {
}
break;
}

var G__20255 = args20253.length;
switch (G__20255) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20253.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async20256 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20256 = (function (f,blockable,meta20257){
this.f = f;
this.blockable = blockable;
this.meta20257 = meta20257;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20256.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20258,meta20257__$1){
var self__ = this;
var _20258__$1 = this;
return (new cljs.core.async.t_cljs$core$async20256(self__.f,self__.blockable,meta20257__$1));
});

cljs.core.async.t_cljs$core$async20256.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20258){
var self__ = this;
var _20258__$1 = this;
return self__.meta20257;
});

cljs.core.async.t_cljs$core$async20256.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20256.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20256.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async20256.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async20256.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta20257","meta20257",1927747577,null)], null);
});

cljs.core.async.t_cljs$core$async20256.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20256.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20256";

cljs.core.async.t_cljs$core$async20256.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async20256");
});

cljs.core.async.__GT_t_cljs$core$async20256 = (function cljs$core$async$__GT_t_cljs$core$async20256(f__$1,blockable__$1,meta20257){
return (new cljs.core.async.t_cljs$core$async20256(f__$1,blockable__$1,meta20257));
});

}

return (new cljs.core.async.t_cljs$core$async20256(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args20265 = [];
var len__7484__auto___20268 = arguments.length;
var i__7485__auto___20269 = (0);
while(true){
if((i__7485__auto___20269 < len__7484__auto___20268)){
args20265.push((arguments[i__7485__auto___20269]));

var G__20270 = (i__7485__auto___20269 + (1));
i__7485__auto___20269 = G__20270;
continue;
} else {
}
break;
}

var G__20267 = args20265.length;
switch (G__20267) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20265.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args20272 = [];
var len__7484__auto___20275 = arguments.length;
var i__7485__auto___20276 = (0);
while(true){
if((i__7485__auto___20276 < len__7484__auto___20275)){
args20272.push((arguments[i__7485__auto___20276]));

var G__20277 = (i__7485__auto___20276 + (1));
i__7485__auto___20276 = G__20277;
continue;
} else {
}
break;
}

var G__20274 = args20272.length;
switch (G__20274) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20272.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args20279 = [];
var len__7484__auto___20282 = arguments.length;
var i__7485__auto___20283 = (0);
while(true){
if((i__7485__auto___20283 < len__7484__auto___20282)){
args20279.push((arguments[i__7485__auto___20283]));

var G__20284 = (i__7485__auto___20283 + (1));
i__7485__auto___20283 = G__20284;
continue;
} else {
}
break;
}

var G__20281 = args20279.length;
switch (G__20281) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20279.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_20286 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_20286);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_20286,ret){
return (function (){
return fn1.call(null,val_20286);
});})(val_20286,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args20287 = [];
var len__7484__auto___20290 = arguments.length;
var i__7485__auto___20291 = (0);
while(true){
if((i__7485__auto___20291 < len__7484__auto___20290)){
args20287.push((arguments[i__7485__auto___20291]));

var G__20292 = (i__7485__auto___20291 + (1));
i__7485__auto___20291 = G__20292;
continue;
} else {
}
break;
}

var G__20289 = args20287.length;
switch (G__20289) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20287.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___20294 = n;
var x_20295 = (0);
while(true){
if((x_20295 < n__7324__auto___20294)){
(a[x_20295] = (0));

var G__20296 = (x_20295 + (1));
x_20295 = G__20296;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__20297 = (i + (1));
i = G__20297;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async20301 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20301 = (function (alt_flag,flag,meta20302){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta20302 = meta20302;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20301.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_20303,meta20302__$1){
var self__ = this;
var _20303__$1 = this;
return (new cljs.core.async.t_cljs$core$async20301(self__.alt_flag,self__.flag,meta20302__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async20301.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_20303){
var self__ = this;
var _20303__$1 = this;
return self__.meta20302;
});})(flag))
;

cljs.core.async.t_cljs$core$async20301.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20301.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async20301.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20301.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20301.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta20302","meta20302",-1345022344,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async20301.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20301.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20301";

cljs.core.async.t_cljs$core$async20301.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async20301");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async20301 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20301(alt_flag__$1,flag__$1,meta20302){
return (new cljs.core.async.t_cljs$core$async20301(alt_flag__$1,flag__$1,meta20302));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async20301(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async20307 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20307 = (function (alt_handler,flag,cb,meta20308){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta20308 = meta20308;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20307.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20309,meta20308__$1){
var self__ = this;
var _20309__$1 = this;
return (new cljs.core.async.t_cljs$core$async20307(self__.alt_handler,self__.flag,self__.cb,meta20308__$1));
});

cljs.core.async.t_cljs$core$async20307.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20309){
var self__ = this;
var _20309__$1 = this;
return self__.meta20308;
});

cljs.core.async.t_cljs$core$async20307.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20307.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async20307.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20307.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async20307.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta20308","meta20308",-399327625,null)], null);
});

cljs.core.async.t_cljs$core$async20307.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20307.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20307";

cljs.core.async.t_cljs$core$async20307.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async20307");
});

cljs.core.async.__GT_t_cljs$core$async20307 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20307(alt_handler__$1,flag__$1,cb__$1,meta20308){
return (new cljs.core.async.t_cljs$core$async20307(alt_handler__$1,flag__$1,cb__$1,meta20308));
});

}

return (new cljs.core.async.t_cljs$core$async20307(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20310_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20310_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20311_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20311_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__20312 = (i + (1));
i = G__20312;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20318 = arguments.length;
var i__7485__auto___20319 = (0);
while(true){
if((i__7485__auto___20319 < len__7484__auto___20318)){
args__7491__auto__.push((arguments[i__7485__auto___20319]));

var G__20320 = (i__7485__auto___20319 + (1));
i__7485__auto___20319 = G__20320;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20315){
var map__20316 = p__20315;
var map__20316__$1 = ((((!((map__20316 == null)))?((((map__20316.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20316.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20316):map__20316);
var opts = map__20316__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20313){
var G__20314 = cljs.core.first.call(null,seq20313);
var seq20313__$1 = cljs.core.next.call(null,seq20313);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20314,seq20313__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args20321 = [];
var len__7484__auto___20371 = arguments.length;
var i__7485__auto___20372 = (0);
while(true){
if((i__7485__auto___20372 < len__7484__auto___20371)){
args20321.push((arguments[i__7485__auto___20372]));

var G__20373 = (i__7485__auto___20372 + (1));
i__7485__auto___20372 = G__20373;
continue;
} else {
}
break;
}

var G__20323 = args20321.length;
switch (G__20323) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20321.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__10595__auto___20375 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___20375){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___20375){
return (function (state_20347){
var state_val_20348 = (state_20347[(1)]);
if((state_val_20348 === (7))){
var inst_20343 = (state_20347[(2)]);
var state_20347__$1 = state_20347;
var statearr_20349_20376 = state_20347__$1;
(statearr_20349_20376[(2)] = inst_20343);

(statearr_20349_20376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (1))){
var state_20347__$1 = state_20347;
var statearr_20350_20377 = state_20347__$1;
(statearr_20350_20377[(2)] = null);

(statearr_20350_20377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (4))){
var inst_20326 = (state_20347[(7)]);
var inst_20326__$1 = (state_20347[(2)]);
var inst_20327 = (inst_20326__$1 == null);
var state_20347__$1 = (function (){var statearr_20351 = state_20347;
(statearr_20351[(7)] = inst_20326__$1);

return statearr_20351;
})();
if(cljs.core.truth_(inst_20327)){
var statearr_20352_20378 = state_20347__$1;
(statearr_20352_20378[(1)] = (5));

} else {
var statearr_20353_20379 = state_20347__$1;
(statearr_20353_20379[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (13))){
var state_20347__$1 = state_20347;
var statearr_20354_20380 = state_20347__$1;
(statearr_20354_20380[(2)] = null);

(statearr_20354_20380[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (6))){
var inst_20326 = (state_20347[(7)]);
var state_20347__$1 = state_20347;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20347__$1,(11),to,inst_20326);
} else {
if((state_val_20348 === (3))){
var inst_20345 = (state_20347[(2)]);
var state_20347__$1 = state_20347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20347__$1,inst_20345);
} else {
if((state_val_20348 === (12))){
var state_20347__$1 = state_20347;
var statearr_20355_20381 = state_20347__$1;
(statearr_20355_20381[(2)] = null);

(statearr_20355_20381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (2))){
var state_20347__$1 = state_20347;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20347__$1,(4),from);
} else {
if((state_val_20348 === (11))){
var inst_20336 = (state_20347[(2)]);
var state_20347__$1 = state_20347;
if(cljs.core.truth_(inst_20336)){
var statearr_20356_20382 = state_20347__$1;
(statearr_20356_20382[(1)] = (12));

} else {
var statearr_20357_20383 = state_20347__$1;
(statearr_20357_20383[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (9))){
var state_20347__$1 = state_20347;
var statearr_20358_20384 = state_20347__$1;
(statearr_20358_20384[(2)] = null);

(statearr_20358_20384[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (5))){
var state_20347__$1 = state_20347;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20359_20385 = state_20347__$1;
(statearr_20359_20385[(1)] = (8));

} else {
var statearr_20360_20386 = state_20347__$1;
(statearr_20360_20386[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (14))){
var inst_20341 = (state_20347[(2)]);
var state_20347__$1 = state_20347;
var statearr_20361_20387 = state_20347__$1;
(statearr_20361_20387[(2)] = inst_20341);

(statearr_20361_20387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (10))){
var inst_20333 = (state_20347[(2)]);
var state_20347__$1 = state_20347;
var statearr_20362_20388 = state_20347__$1;
(statearr_20362_20388[(2)] = inst_20333);

(statearr_20362_20388[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20348 === (8))){
var inst_20330 = cljs.core.async.close_BANG_.call(null,to);
var state_20347__$1 = state_20347;
var statearr_20363_20389 = state_20347__$1;
(statearr_20363_20389[(2)] = inst_20330);

(statearr_20363_20389[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___20375))
;
return ((function (switch__10483__auto__,c__10595__auto___20375){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_20367 = [null,null,null,null,null,null,null,null];
(statearr_20367[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_20367[(1)] = (1));

return statearr_20367;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_20347){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_20347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e20368){if((e20368 instanceof Object)){
var ex__10487__auto__ = e20368;
var statearr_20369_20390 = state_20347;
(statearr_20369_20390[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20347);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20368;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20391 = state_20347;
state_20347 = G__20391;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_20347){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_20347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___20375))
})();
var state__10597__auto__ = (function (){var statearr_20370 = f__10596__auto__.call(null);
(statearr_20370[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___20375);

return statearr_20370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___20375))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__20579){
var vec__20580 = p__20579;
var v = cljs.core.nth.call(null,vec__20580,(0),null);
var p = cljs.core.nth.call(null,vec__20580,(1),null);
var job = vec__20580;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__10595__auto___20766 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___20766,res,vec__20580,v,p,job,jobs,results){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___20766,res,vec__20580,v,p,job,jobs,results){
return (function (state_20587){
var state_val_20588 = (state_20587[(1)]);
if((state_val_20588 === (1))){
var state_20587__$1 = state_20587;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20587__$1,(2),res,v);
} else {
if((state_val_20588 === (2))){
var inst_20584 = (state_20587[(2)]);
var inst_20585 = cljs.core.async.close_BANG_.call(null,res);
var state_20587__$1 = (function (){var statearr_20589 = state_20587;
(statearr_20589[(7)] = inst_20584);

return statearr_20589;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20587__$1,inst_20585);
} else {
return null;
}
}
});})(c__10595__auto___20766,res,vec__20580,v,p,job,jobs,results))
;
return ((function (switch__10483__auto__,c__10595__auto___20766,res,vec__20580,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_20593 = [null,null,null,null,null,null,null,null];
(statearr_20593[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_20593[(1)] = (1));

return statearr_20593;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_20587){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_20587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e20594){if((e20594 instanceof Object)){
var ex__10487__auto__ = e20594;
var statearr_20595_20767 = state_20587;
(statearr_20595_20767[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20587);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20594;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20768 = state_20587;
state_20587 = G__20768;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_20587){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_20587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___20766,res,vec__20580,v,p,job,jobs,results))
})();
var state__10597__auto__ = (function (){var statearr_20596 = f__10596__auto__.call(null);
(statearr_20596[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___20766);

return statearr_20596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___20766,res,vec__20580,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__20597){
var vec__20598 = p__20597;
var v = cljs.core.nth.call(null,vec__20598,(0),null);
var p = cljs.core.nth.call(null,vec__20598,(1),null);
var job = vec__20598;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___20769 = n;
var __20770 = (0);
while(true){
if((__20770 < n__7324__auto___20769)){
var G__20601_20771 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__20601_20771) {
case "compute":
var c__10595__auto___20773 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20770,c__10595__auto___20773,G__20601_20771,n__7324__auto___20769,jobs,results,process,async){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (__20770,c__10595__auto___20773,G__20601_20771,n__7324__auto___20769,jobs,results,process,async){
return (function (state_20614){
var state_val_20615 = (state_20614[(1)]);
if((state_val_20615 === (1))){
var state_20614__$1 = state_20614;
var statearr_20616_20774 = state_20614__$1;
(statearr_20616_20774[(2)] = null);

(statearr_20616_20774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20615 === (2))){
var state_20614__$1 = state_20614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20614__$1,(4),jobs);
} else {
if((state_val_20615 === (3))){
var inst_20612 = (state_20614[(2)]);
var state_20614__$1 = state_20614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20614__$1,inst_20612);
} else {
if((state_val_20615 === (4))){
var inst_20604 = (state_20614[(2)]);
var inst_20605 = process.call(null,inst_20604);
var state_20614__$1 = state_20614;
if(cljs.core.truth_(inst_20605)){
var statearr_20617_20775 = state_20614__$1;
(statearr_20617_20775[(1)] = (5));

} else {
var statearr_20618_20776 = state_20614__$1;
(statearr_20618_20776[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20615 === (5))){
var state_20614__$1 = state_20614;
var statearr_20619_20777 = state_20614__$1;
(statearr_20619_20777[(2)] = null);

(statearr_20619_20777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20615 === (6))){
var state_20614__$1 = state_20614;
var statearr_20620_20778 = state_20614__$1;
(statearr_20620_20778[(2)] = null);

(statearr_20620_20778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20615 === (7))){
var inst_20610 = (state_20614[(2)]);
var state_20614__$1 = state_20614;
var statearr_20621_20779 = state_20614__$1;
(statearr_20621_20779[(2)] = inst_20610);

(statearr_20621_20779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20770,c__10595__auto___20773,G__20601_20771,n__7324__auto___20769,jobs,results,process,async))
;
return ((function (__20770,switch__10483__auto__,c__10595__auto___20773,G__20601_20771,n__7324__auto___20769,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_20625 = [null,null,null,null,null,null,null];
(statearr_20625[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_20625[(1)] = (1));

return statearr_20625;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_20614){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_20614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e20626){if((e20626 instanceof Object)){
var ex__10487__auto__ = e20626;
var statearr_20627_20780 = state_20614;
(statearr_20627_20780[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20614);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20626;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20781 = state_20614;
state_20614 = G__20781;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_20614){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_20614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(__20770,switch__10483__auto__,c__10595__auto___20773,G__20601_20771,n__7324__auto___20769,jobs,results,process,async))
})();
var state__10597__auto__ = (function (){var statearr_20628 = f__10596__auto__.call(null);
(statearr_20628[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___20773);

return statearr_20628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(__20770,c__10595__auto___20773,G__20601_20771,n__7324__auto___20769,jobs,results,process,async))
);


break;
case "async":
var c__10595__auto___20782 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20770,c__10595__auto___20782,G__20601_20771,n__7324__auto___20769,jobs,results,process,async){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (__20770,c__10595__auto___20782,G__20601_20771,n__7324__auto___20769,jobs,results,process,async){
return (function (state_20641){
var state_val_20642 = (state_20641[(1)]);
if((state_val_20642 === (1))){
var state_20641__$1 = state_20641;
var statearr_20643_20783 = state_20641__$1;
(statearr_20643_20783[(2)] = null);

(statearr_20643_20783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (2))){
var state_20641__$1 = state_20641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20641__$1,(4),jobs);
} else {
if((state_val_20642 === (3))){
var inst_20639 = (state_20641[(2)]);
var state_20641__$1 = state_20641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20641__$1,inst_20639);
} else {
if((state_val_20642 === (4))){
var inst_20631 = (state_20641[(2)]);
var inst_20632 = async.call(null,inst_20631);
var state_20641__$1 = state_20641;
if(cljs.core.truth_(inst_20632)){
var statearr_20644_20784 = state_20641__$1;
(statearr_20644_20784[(1)] = (5));

} else {
var statearr_20645_20785 = state_20641__$1;
(statearr_20645_20785[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (5))){
var state_20641__$1 = state_20641;
var statearr_20646_20786 = state_20641__$1;
(statearr_20646_20786[(2)] = null);

(statearr_20646_20786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (6))){
var state_20641__$1 = state_20641;
var statearr_20647_20787 = state_20641__$1;
(statearr_20647_20787[(2)] = null);

(statearr_20647_20787[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20642 === (7))){
var inst_20637 = (state_20641[(2)]);
var state_20641__$1 = state_20641;
var statearr_20648_20788 = state_20641__$1;
(statearr_20648_20788[(2)] = inst_20637);

(statearr_20648_20788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20770,c__10595__auto___20782,G__20601_20771,n__7324__auto___20769,jobs,results,process,async))
;
return ((function (__20770,switch__10483__auto__,c__10595__auto___20782,G__20601_20771,n__7324__auto___20769,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_20652 = [null,null,null,null,null,null,null];
(statearr_20652[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_20652[(1)] = (1));

return statearr_20652;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_20641){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_20641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e20653){if((e20653 instanceof Object)){
var ex__10487__auto__ = e20653;
var statearr_20654_20789 = state_20641;
(statearr_20654_20789[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20641);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20653;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20790 = state_20641;
state_20641 = G__20790;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_20641){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_20641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(__20770,switch__10483__auto__,c__10595__auto___20782,G__20601_20771,n__7324__auto___20769,jobs,results,process,async))
})();
var state__10597__auto__ = (function (){var statearr_20655 = f__10596__auto__.call(null);
(statearr_20655[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___20782);

return statearr_20655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(__20770,c__10595__auto___20782,G__20601_20771,n__7324__auto___20769,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__20791 = (__20770 + (1));
__20770 = G__20791;
continue;
} else {
}
break;
}

var c__10595__auto___20792 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___20792,jobs,results,process,async){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___20792,jobs,results,process,async){
return (function (state_20677){
var state_val_20678 = (state_20677[(1)]);
if((state_val_20678 === (1))){
var state_20677__$1 = state_20677;
var statearr_20679_20793 = state_20677__$1;
(statearr_20679_20793[(2)] = null);

(statearr_20679_20793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20678 === (2))){
var state_20677__$1 = state_20677;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20677__$1,(4),from);
} else {
if((state_val_20678 === (3))){
var inst_20675 = (state_20677[(2)]);
var state_20677__$1 = state_20677;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20677__$1,inst_20675);
} else {
if((state_val_20678 === (4))){
var inst_20658 = (state_20677[(7)]);
var inst_20658__$1 = (state_20677[(2)]);
var inst_20659 = (inst_20658__$1 == null);
var state_20677__$1 = (function (){var statearr_20680 = state_20677;
(statearr_20680[(7)] = inst_20658__$1);

return statearr_20680;
})();
if(cljs.core.truth_(inst_20659)){
var statearr_20681_20794 = state_20677__$1;
(statearr_20681_20794[(1)] = (5));

} else {
var statearr_20682_20795 = state_20677__$1;
(statearr_20682_20795[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20678 === (5))){
var inst_20661 = cljs.core.async.close_BANG_.call(null,jobs);
var state_20677__$1 = state_20677;
var statearr_20683_20796 = state_20677__$1;
(statearr_20683_20796[(2)] = inst_20661);

(statearr_20683_20796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20678 === (6))){
var inst_20658 = (state_20677[(7)]);
var inst_20663 = (state_20677[(8)]);
var inst_20663__$1 = cljs.core.async.chan.call(null,(1));
var inst_20664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20665 = [inst_20658,inst_20663__$1];
var inst_20666 = (new cljs.core.PersistentVector(null,2,(5),inst_20664,inst_20665,null));
var state_20677__$1 = (function (){var statearr_20684 = state_20677;
(statearr_20684[(8)] = inst_20663__$1);

return statearr_20684;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20677__$1,(8),jobs,inst_20666);
} else {
if((state_val_20678 === (7))){
var inst_20673 = (state_20677[(2)]);
var state_20677__$1 = state_20677;
var statearr_20685_20797 = state_20677__$1;
(statearr_20685_20797[(2)] = inst_20673);

(statearr_20685_20797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20678 === (8))){
var inst_20663 = (state_20677[(8)]);
var inst_20668 = (state_20677[(2)]);
var state_20677__$1 = (function (){var statearr_20686 = state_20677;
(statearr_20686[(9)] = inst_20668);

return statearr_20686;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20677__$1,(9),results,inst_20663);
} else {
if((state_val_20678 === (9))){
var inst_20670 = (state_20677[(2)]);
var state_20677__$1 = (function (){var statearr_20687 = state_20677;
(statearr_20687[(10)] = inst_20670);

return statearr_20687;
})();
var statearr_20688_20798 = state_20677__$1;
(statearr_20688_20798[(2)] = null);

(statearr_20688_20798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___20792,jobs,results,process,async))
;
return ((function (switch__10483__auto__,c__10595__auto___20792,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_20692 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20692[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_20692[(1)] = (1));

return statearr_20692;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_20677){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_20677);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e20693){if((e20693 instanceof Object)){
var ex__10487__auto__ = e20693;
var statearr_20694_20799 = state_20677;
(statearr_20694_20799[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20677);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20693;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20800 = state_20677;
state_20677 = G__20800;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_20677){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_20677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___20792,jobs,results,process,async))
})();
var state__10597__auto__ = (function (){var statearr_20695 = f__10596__auto__.call(null);
(statearr_20695[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___20792);

return statearr_20695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___20792,jobs,results,process,async))
);


var c__10595__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto__,jobs,results,process,async){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto__,jobs,results,process,async){
return (function (state_20733){
var state_val_20734 = (state_20733[(1)]);
if((state_val_20734 === (7))){
var inst_20729 = (state_20733[(2)]);
var state_20733__$1 = state_20733;
var statearr_20735_20801 = state_20733__$1;
(statearr_20735_20801[(2)] = inst_20729);

(statearr_20735_20801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (20))){
var state_20733__$1 = state_20733;
var statearr_20736_20802 = state_20733__$1;
(statearr_20736_20802[(2)] = null);

(statearr_20736_20802[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (1))){
var state_20733__$1 = state_20733;
var statearr_20737_20803 = state_20733__$1;
(statearr_20737_20803[(2)] = null);

(statearr_20737_20803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (4))){
var inst_20698 = (state_20733[(7)]);
var inst_20698__$1 = (state_20733[(2)]);
var inst_20699 = (inst_20698__$1 == null);
var state_20733__$1 = (function (){var statearr_20738 = state_20733;
(statearr_20738[(7)] = inst_20698__$1);

return statearr_20738;
})();
if(cljs.core.truth_(inst_20699)){
var statearr_20739_20804 = state_20733__$1;
(statearr_20739_20804[(1)] = (5));

} else {
var statearr_20740_20805 = state_20733__$1;
(statearr_20740_20805[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (15))){
var inst_20711 = (state_20733[(8)]);
var state_20733__$1 = state_20733;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20733__$1,(18),to,inst_20711);
} else {
if((state_val_20734 === (21))){
var inst_20724 = (state_20733[(2)]);
var state_20733__$1 = state_20733;
var statearr_20741_20806 = state_20733__$1;
(statearr_20741_20806[(2)] = inst_20724);

(statearr_20741_20806[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (13))){
var inst_20726 = (state_20733[(2)]);
var state_20733__$1 = (function (){var statearr_20742 = state_20733;
(statearr_20742[(9)] = inst_20726);

return statearr_20742;
})();
var statearr_20743_20807 = state_20733__$1;
(statearr_20743_20807[(2)] = null);

(statearr_20743_20807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (6))){
var inst_20698 = (state_20733[(7)]);
var state_20733__$1 = state_20733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20733__$1,(11),inst_20698);
} else {
if((state_val_20734 === (17))){
var inst_20719 = (state_20733[(2)]);
var state_20733__$1 = state_20733;
if(cljs.core.truth_(inst_20719)){
var statearr_20744_20808 = state_20733__$1;
(statearr_20744_20808[(1)] = (19));

} else {
var statearr_20745_20809 = state_20733__$1;
(statearr_20745_20809[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (3))){
var inst_20731 = (state_20733[(2)]);
var state_20733__$1 = state_20733;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20733__$1,inst_20731);
} else {
if((state_val_20734 === (12))){
var inst_20708 = (state_20733[(10)]);
var state_20733__$1 = state_20733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20733__$1,(14),inst_20708);
} else {
if((state_val_20734 === (2))){
var state_20733__$1 = state_20733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20733__$1,(4),results);
} else {
if((state_val_20734 === (19))){
var state_20733__$1 = state_20733;
var statearr_20746_20810 = state_20733__$1;
(statearr_20746_20810[(2)] = null);

(statearr_20746_20810[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (11))){
var inst_20708 = (state_20733[(2)]);
var state_20733__$1 = (function (){var statearr_20747 = state_20733;
(statearr_20747[(10)] = inst_20708);

return statearr_20747;
})();
var statearr_20748_20811 = state_20733__$1;
(statearr_20748_20811[(2)] = null);

(statearr_20748_20811[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (9))){
var state_20733__$1 = state_20733;
var statearr_20749_20812 = state_20733__$1;
(statearr_20749_20812[(2)] = null);

(statearr_20749_20812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (5))){
var state_20733__$1 = state_20733;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20750_20813 = state_20733__$1;
(statearr_20750_20813[(1)] = (8));

} else {
var statearr_20751_20814 = state_20733__$1;
(statearr_20751_20814[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (14))){
var inst_20713 = (state_20733[(11)]);
var inst_20711 = (state_20733[(8)]);
var inst_20711__$1 = (state_20733[(2)]);
var inst_20712 = (inst_20711__$1 == null);
var inst_20713__$1 = cljs.core.not.call(null,inst_20712);
var state_20733__$1 = (function (){var statearr_20752 = state_20733;
(statearr_20752[(11)] = inst_20713__$1);

(statearr_20752[(8)] = inst_20711__$1);

return statearr_20752;
})();
if(inst_20713__$1){
var statearr_20753_20815 = state_20733__$1;
(statearr_20753_20815[(1)] = (15));

} else {
var statearr_20754_20816 = state_20733__$1;
(statearr_20754_20816[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (16))){
var inst_20713 = (state_20733[(11)]);
var state_20733__$1 = state_20733;
var statearr_20755_20817 = state_20733__$1;
(statearr_20755_20817[(2)] = inst_20713);

(statearr_20755_20817[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (10))){
var inst_20705 = (state_20733[(2)]);
var state_20733__$1 = state_20733;
var statearr_20756_20818 = state_20733__$1;
(statearr_20756_20818[(2)] = inst_20705);

(statearr_20756_20818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (18))){
var inst_20716 = (state_20733[(2)]);
var state_20733__$1 = state_20733;
var statearr_20757_20819 = state_20733__$1;
(statearr_20757_20819[(2)] = inst_20716);

(statearr_20757_20819[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20734 === (8))){
var inst_20702 = cljs.core.async.close_BANG_.call(null,to);
var state_20733__$1 = state_20733;
var statearr_20758_20820 = state_20733__$1;
(statearr_20758_20820[(2)] = inst_20702);

(statearr_20758_20820[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto__,jobs,results,process,async))
;
return ((function (switch__10483__auto__,c__10595__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_20762 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20762[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_20762[(1)] = (1));

return statearr_20762;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_20733){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_20733);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e20763){if((e20763 instanceof Object)){
var ex__10487__auto__ = e20763;
var statearr_20764_20821 = state_20733;
(statearr_20764_20821[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20733);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20763;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20822 = state_20733;
state_20733 = G__20822;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_20733){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_20733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto__,jobs,results,process,async))
})();
var state__10597__auto__ = (function (){var statearr_20765 = f__10596__auto__.call(null);
(statearr_20765[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto__);

return statearr_20765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto__,jobs,results,process,async))
);

return c__10595__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args20823 = [];
var len__7484__auto___20826 = arguments.length;
var i__7485__auto___20827 = (0);
while(true){
if((i__7485__auto___20827 < len__7484__auto___20826)){
args20823.push((arguments[i__7485__auto___20827]));

var G__20828 = (i__7485__auto___20827 + (1));
i__7485__auto___20827 = G__20828;
continue;
} else {
}
break;
}

var G__20825 = args20823.length;
switch (G__20825) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20823.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args20830 = [];
var len__7484__auto___20833 = arguments.length;
var i__7485__auto___20834 = (0);
while(true){
if((i__7485__auto___20834 < len__7484__auto___20833)){
args20830.push((arguments[i__7485__auto___20834]));

var G__20835 = (i__7485__auto___20834 + (1));
i__7485__auto___20834 = G__20835;
continue;
} else {
}
break;
}

var G__20832 = args20830.length;
switch (G__20832) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20830.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args20837 = [];
var len__7484__auto___20890 = arguments.length;
var i__7485__auto___20891 = (0);
while(true){
if((i__7485__auto___20891 < len__7484__auto___20890)){
args20837.push((arguments[i__7485__auto___20891]));

var G__20892 = (i__7485__auto___20891 + (1));
i__7485__auto___20891 = G__20892;
continue;
} else {
}
break;
}

var G__20839 = args20837.length;
switch (G__20839) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20837.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__10595__auto___20894 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___20894,tc,fc){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___20894,tc,fc){
return (function (state_20865){
var state_val_20866 = (state_20865[(1)]);
if((state_val_20866 === (7))){
var inst_20861 = (state_20865[(2)]);
var state_20865__$1 = state_20865;
var statearr_20867_20895 = state_20865__$1;
(statearr_20867_20895[(2)] = inst_20861);

(statearr_20867_20895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (1))){
var state_20865__$1 = state_20865;
var statearr_20868_20896 = state_20865__$1;
(statearr_20868_20896[(2)] = null);

(statearr_20868_20896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (4))){
var inst_20842 = (state_20865[(7)]);
var inst_20842__$1 = (state_20865[(2)]);
var inst_20843 = (inst_20842__$1 == null);
var state_20865__$1 = (function (){var statearr_20869 = state_20865;
(statearr_20869[(7)] = inst_20842__$1);

return statearr_20869;
})();
if(cljs.core.truth_(inst_20843)){
var statearr_20870_20897 = state_20865__$1;
(statearr_20870_20897[(1)] = (5));

} else {
var statearr_20871_20898 = state_20865__$1;
(statearr_20871_20898[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (13))){
var state_20865__$1 = state_20865;
var statearr_20872_20899 = state_20865__$1;
(statearr_20872_20899[(2)] = null);

(statearr_20872_20899[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (6))){
var inst_20842 = (state_20865[(7)]);
var inst_20848 = p.call(null,inst_20842);
var state_20865__$1 = state_20865;
if(cljs.core.truth_(inst_20848)){
var statearr_20873_20900 = state_20865__$1;
(statearr_20873_20900[(1)] = (9));

} else {
var statearr_20874_20901 = state_20865__$1;
(statearr_20874_20901[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (3))){
var inst_20863 = (state_20865[(2)]);
var state_20865__$1 = state_20865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20865__$1,inst_20863);
} else {
if((state_val_20866 === (12))){
var state_20865__$1 = state_20865;
var statearr_20875_20902 = state_20865__$1;
(statearr_20875_20902[(2)] = null);

(statearr_20875_20902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (2))){
var state_20865__$1 = state_20865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20865__$1,(4),ch);
} else {
if((state_val_20866 === (11))){
var inst_20842 = (state_20865[(7)]);
var inst_20852 = (state_20865[(2)]);
var state_20865__$1 = state_20865;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20865__$1,(8),inst_20852,inst_20842);
} else {
if((state_val_20866 === (9))){
var state_20865__$1 = state_20865;
var statearr_20876_20903 = state_20865__$1;
(statearr_20876_20903[(2)] = tc);

(statearr_20876_20903[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (5))){
var inst_20845 = cljs.core.async.close_BANG_.call(null,tc);
var inst_20846 = cljs.core.async.close_BANG_.call(null,fc);
var state_20865__$1 = (function (){var statearr_20877 = state_20865;
(statearr_20877[(8)] = inst_20845);

return statearr_20877;
})();
var statearr_20878_20904 = state_20865__$1;
(statearr_20878_20904[(2)] = inst_20846);

(statearr_20878_20904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (14))){
var inst_20859 = (state_20865[(2)]);
var state_20865__$1 = state_20865;
var statearr_20879_20905 = state_20865__$1;
(statearr_20879_20905[(2)] = inst_20859);

(statearr_20879_20905[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (10))){
var state_20865__$1 = state_20865;
var statearr_20880_20906 = state_20865__$1;
(statearr_20880_20906[(2)] = fc);

(statearr_20880_20906[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20866 === (8))){
var inst_20854 = (state_20865[(2)]);
var state_20865__$1 = state_20865;
if(cljs.core.truth_(inst_20854)){
var statearr_20881_20907 = state_20865__$1;
(statearr_20881_20907[(1)] = (12));

} else {
var statearr_20882_20908 = state_20865__$1;
(statearr_20882_20908[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___20894,tc,fc))
;
return ((function (switch__10483__auto__,c__10595__auto___20894,tc,fc){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_20886 = [null,null,null,null,null,null,null,null,null];
(statearr_20886[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_20886[(1)] = (1));

return statearr_20886;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_20865){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_20865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e20887){if((e20887 instanceof Object)){
var ex__10487__auto__ = e20887;
var statearr_20888_20909 = state_20865;
(statearr_20888_20909[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20865);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20887;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20910 = state_20865;
state_20865 = G__20910;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_20865){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_20865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___20894,tc,fc))
})();
var state__10597__auto__ = (function (){var statearr_20889 = f__10596__auto__.call(null);
(statearr_20889[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___20894);

return statearr_20889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___20894,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__10595__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto__){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto__){
return (function (state_20974){
var state_val_20975 = (state_20974[(1)]);
if((state_val_20975 === (7))){
var inst_20970 = (state_20974[(2)]);
var state_20974__$1 = state_20974;
var statearr_20976_20997 = state_20974__$1;
(statearr_20976_20997[(2)] = inst_20970);

(statearr_20976_20997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (1))){
var inst_20954 = init;
var state_20974__$1 = (function (){var statearr_20977 = state_20974;
(statearr_20977[(7)] = inst_20954);

return statearr_20977;
})();
var statearr_20978_20998 = state_20974__$1;
(statearr_20978_20998[(2)] = null);

(statearr_20978_20998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (4))){
var inst_20957 = (state_20974[(8)]);
var inst_20957__$1 = (state_20974[(2)]);
var inst_20958 = (inst_20957__$1 == null);
var state_20974__$1 = (function (){var statearr_20979 = state_20974;
(statearr_20979[(8)] = inst_20957__$1);

return statearr_20979;
})();
if(cljs.core.truth_(inst_20958)){
var statearr_20980_20999 = state_20974__$1;
(statearr_20980_20999[(1)] = (5));

} else {
var statearr_20981_21000 = state_20974__$1;
(statearr_20981_21000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (6))){
var inst_20961 = (state_20974[(9)]);
var inst_20957 = (state_20974[(8)]);
var inst_20954 = (state_20974[(7)]);
var inst_20961__$1 = f.call(null,inst_20954,inst_20957);
var inst_20962 = cljs.core.reduced_QMARK_.call(null,inst_20961__$1);
var state_20974__$1 = (function (){var statearr_20982 = state_20974;
(statearr_20982[(9)] = inst_20961__$1);

return statearr_20982;
})();
if(inst_20962){
var statearr_20983_21001 = state_20974__$1;
(statearr_20983_21001[(1)] = (8));

} else {
var statearr_20984_21002 = state_20974__$1;
(statearr_20984_21002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (3))){
var inst_20972 = (state_20974[(2)]);
var state_20974__$1 = state_20974;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20974__$1,inst_20972);
} else {
if((state_val_20975 === (2))){
var state_20974__$1 = state_20974;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20974__$1,(4),ch);
} else {
if((state_val_20975 === (9))){
var inst_20961 = (state_20974[(9)]);
var inst_20954 = inst_20961;
var state_20974__$1 = (function (){var statearr_20985 = state_20974;
(statearr_20985[(7)] = inst_20954);

return statearr_20985;
})();
var statearr_20986_21003 = state_20974__$1;
(statearr_20986_21003[(2)] = null);

(statearr_20986_21003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (5))){
var inst_20954 = (state_20974[(7)]);
var state_20974__$1 = state_20974;
var statearr_20987_21004 = state_20974__$1;
(statearr_20987_21004[(2)] = inst_20954);

(statearr_20987_21004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (10))){
var inst_20968 = (state_20974[(2)]);
var state_20974__$1 = state_20974;
var statearr_20988_21005 = state_20974__$1;
(statearr_20988_21005[(2)] = inst_20968);

(statearr_20988_21005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (8))){
var inst_20961 = (state_20974[(9)]);
var inst_20964 = cljs.core.deref.call(null,inst_20961);
var state_20974__$1 = state_20974;
var statearr_20989_21006 = state_20974__$1;
(statearr_20989_21006[(2)] = inst_20964);

(statearr_20989_21006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto__))
;
return ((function (switch__10483__auto__,c__10595__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10484__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10484__auto____0 = (function (){
var statearr_20993 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20993[(0)] = cljs$core$async$reduce_$_state_machine__10484__auto__);

(statearr_20993[(1)] = (1));

return statearr_20993;
});
var cljs$core$async$reduce_$_state_machine__10484__auto____1 = (function (state_20974){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_20974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e20994){if((e20994 instanceof Object)){
var ex__10487__auto__ = e20994;
var statearr_20995_21007 = state_20974;
(statearr_20995_21007[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20974);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20994;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21008 = state_20974;
state_20974 = G__21008;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10484__auto__ = function(state_20974){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10484__auto____1.call(this,state_20974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10484__auto____0;
cljs$core$async$reduce_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10484__auto____1;
return cljs$core$async$reduce_$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto__))
})();
var state__10597__auto__ = (function (){var statearr_20996 = f__10596__auto__.call(null);
(statearr_20996[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto__);

return statearr_20996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto__))
);

return c__10595__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args21009 = [];
var len__7484__auto___21061 = arguments.length;
var i__7485__auto___21062 = (0);
while(true){
if((i__7485__auto___21062 < len__7484__auto___21061)){
args21009.push((arguments[i__7485__auto___21062]));

var G__21063 = (i__7485__auto___21062 + (1));
i__7485__auto___21062 = G__21063;
continue;
} else {
}
break;
}

var G__21011 = args21009.length;
switch (G__21011) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21009.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__10595__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto__){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto__){
return (function (state_21036){
var state_val_21037 = (state_21036[(1)]);
if((state_val_21037 === (7))){
var inst_21018 = (state_21036[(2)]);
var state_21036__$1 = state_21036;
var statearr_21038_21065 = state_21036__$1;
(statearr_21038_21065[(2)] = inst_21018);

(statearr_21038_21065[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (1))){
var inst_21012 = cljs.core.seq.call(null,coll);
var inst_21013 = inst_21012;
var state_21036__$1 = (function (){var statearr_21039 = state_21036;
(statearr_21039[(7)] = inst_21013);

return statearr_21039;
})();
var statearr_21040_21066 = state_21036__$1;
(statearr_21040_21066[(2)] = null);

(statearr_21040_21066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (4))){
var inst_21013 = (state_21036[(7)]);
var inst_21016 = cljs.core.first.call(null,inst_21013);
var state_21036__$1 = state_21036;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21036__$1,(7),ch,inst_21016);
} else {
if((state_val_21037 === (13))){
var inst_21030 = (state_21036[(2)]);
var state_21036__$1 = state_21036;
var statearr_21041_21067 = state_21036__$1;
(statearr_21041_21067[(2)] = inst_21030);

(statearr_21041_21067[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (6))){
var inst_21021 = (state_21036[(2)]);
var state_21036__$1 = state_21036;
if(cljs.core.truth_(inst_21021)){
var statearr_21042_21068 = state_21036__$1;
(statearr_21042_21068[(1)] = (8));

} else {
var statearr_21043_21069 = state_21036__$1;
(statearr_21043_21069[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (3))){
var inst_21034 = (state_21036[(2)]);
var state_21036__$1 = state_21036;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21036__$1,inst_21034);
} else {
if((state_val_21037 === (12))){
var state_21036__$1 = state_21036;
var statearr_21044_21070 = state_21036__$1;
(statearr_21044_21070[(2)] = null);

(statearr_21044_21070[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (2))){
var inst_21013 = (state_21036[(7)]);
var state_21036__$1 = state_21036;
if(cljs.core.truth_(inst_21013)){
var statearr_21045_21071 = state_21036__$1;
(statearr_21045_21071[(1)] = (4));

} else {
var statearr_21046_21072 = state_21036__$1;
(statearr_21046_21072[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (11))){
var inst_21027 = cljs.core.async.close_BANG_.call(null,ch);
var state_21036__$1 = state_21036;
var statearr_21047_21073 = state_21036__$1;
(statearr_21047_21073[(2)] = inst_21027);

(statearr_21047_21073[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (9))){
var state_21036__$1 = state_21036;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21048_21074 = state_21036__$1;
(statearr_21048_21074[(1)] = (11));

} else {
var statearr_21049_21075 = state_21036__$1;
(statearr_21049_21075[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (5))){
var inst_21013 = (state_21036[(7)]);
var state_21036__$1 = state_21036;
var statearr_21050_21076 = state_21036__$1;
(statearr_21050_21076[(2)] = inst_21013);

(statearr_21050_21076[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (10))){
var inst_21032 = (state_21036[(2)]);
var state_21036__$1 = state_21036;
var statearr_21051_21077 = state_21036__$1;
(statearr_21051_21077[(2)] = inst_21032);

(statearr_21051_21077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21037 === (8))){
var inst_21013 = (state_21036[(7)]);
var inst_21023 = cljs.core.next.call(null,inst_21013);
var inst_21013__$1 = inst_21023;
var state_21036__$1 = (function (){var statearr_21052 = state_21036;
(statearr_21052[(7)] = inst_21013__$1);

return statearr_21052;
})();
var statearr_21053_21078 = state_21036__$1;
(statearr_21053_21078[(2)] = null);

(statearr_21053_21078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto__))
;
return ((function (switch__10483__auto__,c__10595__auto__){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_21057 = [null,null,null,null,null,null,null,null];
(statearr_21057[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_21057[(1)] = (1));

return statearr_21057;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_21036){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_21036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e21058){if((e21058 instanceof Object)){
var ex__10487__auto__ = e21058;
var statearr_21059_21079 = state_21036;
(statearr_21059_21079[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21036);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21058;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21080 = state_21036;
state_21036 = G__21080;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_21036){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_21036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto__))
})();
var state__10597__auto__ = (function (){var statearr_21060 = f__10596__auto__.call(null);
(statearr_21060[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto__);

return statearr_21060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto__))
);

return c__10595__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21306 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21306 = (function (mult,ch,cs,meta21307){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta21307 = meta21307;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21306.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_21308,meta21307__$1){
var self__ = this;
var _21308__$1 = this;
return (new cljs.core.async.t_cljs$core$async21306(self__.mult,self__.ch,self__.cs,meta21307__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async21306.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_21308){
var self__ = this;
var _21308__$1 = this;
return self__.meta21307;
});})(cs))
;

cljs.core.async.t_cljs$core$async21306.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21306.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async21306.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async21306.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21306.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21306.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21306.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta21307","meta21307",2035601947,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async21306.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21306.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21306";

cljs.core.async.t_cljs$core$async21306.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async21306");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async21306 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async21306(mult__$1,ch__$1,cs__$1,meta21307){
return (new cljs.core.async.t_cljs$core$async21306(mult__$1,ch__$1,cs__$1,meta21307));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async21306(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__10595__auto___21531 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___21531,cs,m,dchan,dctr,done){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___21531,cs,m,dchan,dctr,done){
return (function (state_21443){
var state_val_21444 = (state_21443[(1)]);
if((state_val_21444 === (7))){
var inst_21439 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21445_21532 = state_21443__$1;
(statearr_21445_21532[(2)] = inst_21439);

(statearr_21445_21532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (20))){
var inst_21342 = (state_21443[(7)]);
var inst_21354 = cljs.core.first.call(null,inst_21342);
var inst_21355 = cljs.core.nth.call(null,inst_21354,(0),null);
var inst_21356 = cljs.core.nth.call(null,inst_21354,(1),null);
var state_21443__$1 = (function (){var statearr_21446 = state_21443;
(statearr_21446[(8)] = inst_21355);

return statearr_21446;
})();
if(cljs.core.truth_(inst_21356)){
var statearr_21447_21533 = state_21443__$1;
(statearr_21447_21533[(1)] = (22));

} else {
var statearr_21448_21534 = state_21443__$1;
(statearr_21448_21534[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (27))){
var inst_21386 = (state_21443[(9)]);
var inst_21391 = (state_21443[(10)]);
var inst_21311 = (state_21443[(11)]);
var inst_21384 = (state_21443[(12)]);
var inst_21391__$1 = cljs.core._nth.call(null,inst_21384,inst_21386);
var inst_21392 = cljs.core.async.put_BANG_.call(null,inst_21391__$1,inst_21311,done);
var state_21443__$1 = (function (){var statearr_21449 = state_21443;
(statearr_21449[(10)] = inst_21391__$1);

return statearr_21449;
})();
if(cljs.core.truth_(inst_21392)){
var statearr_21450_21535 = state_21443__$1;
(statearr_21450_21535[(1)] = (30));

} else {
var statearr_21451_21536 = state_21443__$1;
(statearr_21451_21536[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (1))){
var state_21443__$1 = state_21443;
var statearr_21452_21537 = state_21443__$1;
(statearr_21452_21537[(2)] = null);

(statearr_21452_21537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (24))){
var inst_21342 = (state_21443[(7)]);
var inst_21361 = (state_21443[(2)]);
var inst_21362 = cljs.core.next.call(null,inst_21342);
var inst_21320 = inst_21362;
var inst_21321 = null;
var inst_21322 = (0);
var inst_21323 = (0);
var state_21443__$1 = (function (){var statearr_21453 = state_21443;
(statearr_21453[(13)] = inst_21321);

(statearr_21453[(14)] = inst_21320);

(statearr_21453[(15)] = inst_21322);

(statearr_21453[(16)] = inst_21323);

(statearr_21453[(17)] = inst_21361);

return statearr_21453;
})();
var statearr_21454_21538 = state_21443__$1;
(statearr_21454_21538[(2)] = null);

(statearr_21454_21538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (39))){
var state_21443__$1 = state_21443;
var statearr_21458_21539 = state_21443__$1;
(statearr_21458_21539[(2)] = null);

(statearr_21458_21539[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (4))){
var inst_21311 = (state_21443[(11)]);
var inst_21311__$1 = (state_21443[(2)]);
var inst_21312 = (inst_21311__$1 == null);
var state_21443__$1 = (function (){var statearr_21459 = state_21443;
(statearr_21459[(11)] = inst_21311__$1);

return statearr_21459;
})();
if(cljs.core.truth_(inst_21312)){
var statearr_21460_21540 = state_21443__$1;
(statearr_21460_21540[(1)] = (5));

} else {
var statearr_21461_21541 = state_21443__$1;
(statearr_21461_21541[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (15))){
var inst_21321 = (state_21443[(13)]);
var inst_21320 = (state_21443[(14)]);
var inst_21322 = (state_21443[(15)]);
var inst_21323 = (state_21443[(16)]);
var inst_21338 = (state_21443[(2)]);
var inst_21339 = (inst_21323 + (1));
var tmp21455 = inst_21321;
var tmp21456 = inst_21320;
var tmp21457 = inst_21322;
var inst_21320__$1 = tmp21456;
var inst_21321__$1 = tmp21455;
var inst_21322__$1 = tmp21457;
var inst_21323__$1 = inst_21339;
var state_21443__$1 = (function (){var statearr_21462 = state_21443;
(statearr_21462[(13)] = inst_21321__$1);

(statearr_21462[(14)] = inst_21320__$1);

(statearr_21462[(15)] = inst_21322__$1);

(statearr_21462[(16)] = inst_21323__$1);

(statearr_21462[(18)] = inst_21338);

return statearr_21462;
})();
var statearr_21463_21542 = state_21443__$1;
(statearr_21463_21542[(2)] = null);

(statearr_21463_21542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (21))){
var inst_21365 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21467_21543 = state_21443__$1;
(statearr_21467_21543[(2)] = inst_21365);

(statearr_21467_21543[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (31))){
var inst_21391 = (state_21443[(10)]);
var inst_21395 = done.call(null,null);
var inst_21396 = cljs.core.async.untap_STAR_.call(null,m,inst_21391);
var state_21443__$1 = (function (){var statearr_21468 = state_21443;
(statearr_21468[(19)] = inst_21395);

return statearr_21468;
})();
var statearr_21469_21544 = state_21443__$1;
(statearr_21469_21544[(2)] = inst_21396);

(statearr_21469_21544[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (32))){
var inst_21386 = (state_21443[(9)]);
var inst_21385 = (state_21443[(20)]);
var inst_21383 = (state_21443[(21)]);
var inst_21384 = (state_21443[(12)]);
var inst_21398 = (state_21443[(2)]);
var inst_21399 = (inst_21386 + (1));
var tmp21464 = inst_21385;
var tmp21465 = inst_21383;
var tmp21466 = inst_21384;
var inst_21383__$1 = tmp21465;
var inst_21384__$1 = tmp21466;
var inst_21385__$1 = tmp21464;
var inst_21386__$1 = inst_21399;
var state_21443__$1 = (function (){var statearr_21470 = state_21443;
(statearr_21470[(22)] = inst_21398);

(statearr_21470[(9)] = inst_21386__$1);

(statearr_21470[(20)] = inst_21385__$1);

(statearr_21470[(21)] = inst_21383__$1);

(statearr_21470[(12)] = inst_21384__$1);

return statearr_21470;
})();
var statearr_21471_21545 = state_21443__$1;
(statearr_21471_21545[(2)] = null);

(statearr_21471_21545[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (40))){
var inst_21411 = (state_21443[(23)]);
var inst_21415 = done.call(null,null);
var inst_21416 = cljs.core.async.untap_STAR_.call(null,m,inst_21411);
var state_21443__$1 = (function (){var statearr_21472 = state_21443;
(statearr_21472[(24)] = inst_21415);

return statearr_21472;
})();
var statearr_21473_21546 = state_21443__$1;
(statearr_21473_21546[(2)] = inst_21416);

(statearr_21473_21546[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (33))){
var inst_21402 = (state_21443[(25)]);
var inst_21404 = cljs.core.chunked_seq_QMARK_.call(null,inst_21402);
var state_21443__$1 = state_21443;
if(inst_21404){
var statearr_21474_21547 = state_21443__$1;
(statearr_21474_21547[(1)] = (36));

} else {
var statearr_21475_21548 = state_21443__$1;
(statearr_21475_21548[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (13))){
var inst_21332 = (state_21443[(26)]);
var inst_21335 = cljs.core.async.close_BANG_.call(null,inst_21332);
var state_21443__$1 = state_21443;
var statearr_21476_21549 = state_21443__$1;
(statearr_21476_21549[(2)] = inst_21335);

(statearr_21476_21549[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (22))){
var inst_21355 = (state_21443[(8)]);
var inst_21358 = cljs.core.async.close_BANG_.call(null,inst_21355);
var state_21443__$1 = state_21443;
var statearr_21477_21550 = state_21443__$1;
(statearr_21477_21550[(2)] = inst_21358);

(statearr_21477_21550[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (36))){
var inst_21402 = (state_21443[(25)]);
var inst_21406 = cljs.core.chunk_first.call(null,inst_21402);
var inst_21407 = cljs.core.chunk_rest.call(null,inst_21402);
var inst_21408 = cljs.core.count.call(null,inst_21406);
var inst_21383 = inst_21407;
var inst_21384 = inst_21406;
var inst_21385 = inst_21408;
var inst_21386 = (0);
var state_21443__$1 = (function (){var statearr_21478 = state_21443;
(statearr_21478[(9)] = inst_21386);

(statearr_21478[(20)] = inst_21385);

(statearr_21478[(21)] = inst_21383);

(statearr_21478[(12)] = inst_21384);

return statearr_21478;
})();
var statearr_21479_21551 = state_21443__$1;
(statearr_21479_21551[(2)] = null);

(statearr_21479_21551[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (41))){
var inst_21402 = (state_21443[(25)]);
var inst_21418 = (state_21443[(2)]);
var inst_21419 = cljs.core.next.call(null,inst_21402);
var inst_21383 = inst_21419;
var inst_21384 = null;
var inst_21385 = (0);
var inst_21386 = (0);
var state_21443__$1 = (function (){var statearr_21480 = state_21443;
(statearr_21480[(27)] = inst_21418);

(statearr_21480[(9)] = inst_21386);

(statearr_21480[(20)] = inst_21385);

(statearr_21480[(21)] = inst_21383);

(statearr_21480[(12)] = inst_21384);

return statearr_21480;
})();
var statearr_21481_21552 = state_21443__$1;
(statearr_21481_21552[(2)] = null);

(statearr_21481_21552[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (43))){
var state_21443__$1 = state_21443;
var statearr_21482_21553 = state_21443__$1;
(statearr_21482_21553[(2)] = null);

(statearr_21482_21553[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (29))){
var inst_21427 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21483_21554 = state_21443__$1;
(statearr_21483_21554[(2)] = inst_21427);

(statearr_21483_21554[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (44))){
var inst_21436 = (state_21443[(2)]);
var state_21443__$1 = (function (){var statearr_21484 = state_21443;
(statearr_21484[(28)] = inst_21436);

return statearr_21484;
})();
var statearr_21485_21555 = state_21443__$1;
(statearr_21485_21555[(2)] = null);

(statearr_21485_21555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (6))){
var inst_21375 = (state_21443[(29)]);
var inst_21374 = cljs.core.deref.call(null,cs);
var inst_21375__$1 = cljs.core.keys.call(null,inst_21374);
var inst_21376 = cljs.core.count.call(null,inst_21375__$1);
var inst_21377 = cljs.core.reset_BANG_.call(null,dctr,inst_21376);
var inst_21382 = cljs.core.seq.call(null,inst_21375__$1);
var inst_21383 = inst_21382;
var inst_21384 = null;
var inst_21385 = (0);
var inst_21386 = (0);
var state_21443__$1 = (function (){var statearr_21486 = state_21443;
(statearr_21486[(9)] = inst_21386);

(statearr_21486[(20)] = inst_21385);

(statearr_21486[(29)] = inst_21375__$1);

(statearr_21486[(21)] = inst_21383);

(statearr_21486[(12)] = inst_21384);

(statearr_21486[(30)] = inst_21377);

return statearr_21486;
})();
var statearr_21487_21556 = state_21443__$1;
(statearr_21487_21556[(2)] = null);

(statearr_21487_21556[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (28))){
var inst_21402 = (state_21443[(25)]);
var inst_21383 = (state_21443[(21)]);
var inst_21402__$1 = cljs.core.seq.call(null,inst_21383);
var state_21443__$1 = (function (){var statearr_21488 = state_21443;
(statearr_21488[(25)] = inst_21402__$1);

return statearr_21488;
})();
if(inst_21402__$1){
var statearr_21489_21557 = state_21443__$1;
(statearr_21489_21557[(1)] = (33));

} else {
var statearr_21490_21558 = state_21443__$1;
(statearr_21490_21558[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (25))){
var inst_21386 = (state_21443[(9)]);
var inst_21385 = (state_21443[(20)]);
var inst_21388 = (inst_21386 < inst_21385);
var inst_21389 = inst_21388;
var state_21443__$1 = state_21443;
if(cljs.core.truth_(inst_21389)){
var statearr_21491_21559 = state_21443__$1;
(statearr_21491_21559[(1)] = (27));

} else {
var statearr_21492_21560 = state_21443__$1;
(statearr_21492_21560[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (34))){
var state_21443__$1 = state_21443;
var statearr_21493_21561 = state_21443__$1;
(statearr_21493_21561[(2)] = null);

(statearr_21493_21561[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (17))){
var state_21443__$1 = state_21443;
var statearr_21494_21562 = state_21443__$1;
(statearr_21494_21562[(2)] = null);

(statearr_21494_21562[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (3))){
var inst_21441 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21443__$1,inst_21441);
} else {
if((state_val_21444 === (12))){
var inst_21370 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21495_21563 = state_21443__$1;
(statearr_21495_21563[(2)] = inst_21370);

(statearr_21495_21563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (2))){
var state_21443__$1 = state_21443;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21443__$1,(4),ch);
} else {
if((state_val_21444 === (23))){
var state_21443__$1 = state_21443;
var statearr_21496_21564 = state_21443__$1;
(statearr_21496_21564[(2)] = null);

(statearr_21496_21564[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (35))){
var inst_21425 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21497_21565 = state_21443__$1;
(statearr_21497_21565[(2)] = inst_21425);

(statearr_21497_21565[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (19))){
var inst_21342 = (state_21443[(7)]);
var inst_21346 = cljs.core.chunk_first.call(null,inst_21342);
var inst_21347 = cljs.core.chunk_rest.call(null,inst_21342);
var inst_21348 = cljs.core.count.call(null,inst_21346);
var inst_21320 = inst_21347;
var inst_21321 = inst_21346;
var inst_21322 = inst_21348;
var inst_21323 = (0);
var state_21443__$1 = (function (){var statearr_21498 = state_21443;
(statearr_21498[(13)] = inst_21321);

(statearr_21498[(14)] = inst_21320);

(statearr_21498[(15)] = inst_21322);

(statearr_21498[(16)] = inst_21323);

return statearr_21498;
})();
var statearr_21499_21566 = state_21443__$1;
(statearr_21499_21566[(2)] = null);

(statearr_21499_21566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (11))){
var inst_21320 = (state_21443[(14)]);
var inst_21342 = (state_21443[(7)]);
var inst_21342__$1 = cljs.core.seq.call(null,inst_21320);
var state_21443__$1 = (function (){var statearr_21500 = state_21443;
(statearr_21500[(7)] = inst_21342__$1);

return statearr_21500;
})();
if(inst_21342__$1){
var statearr_21501_21567 = state_21443__$1;
(statearr_21501_21567[(1)] = (16));

} else {
var statearr_21502_21568 = state_21443__$1;
(statearr_21502_21568[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (9))){
var inst_21372 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21503_21569 = state_21443__$1;
(statearr_21503_21569[(2)] = inst_21372);

(statearr_21503_21569[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (5))){
var inst_21318 = cljs.core.deref.call(null,cs);
var inst_21319 = cljs.core.seq.call(null,inst_21318);
var inst_21320 = inst_21319;
var inst_21321 = null;
var inst_21322 = (0);
var inst_21323 = (0);
var state_21443__$1 = (function (){var statearr_21504 = state_21443;
(statearr_21504[(13)] = inst_21321);

(statearr_21504[(14)] = inst_21320);

(statearr_21504[(15)] = inst_21322);

(statearr_21504[(16)] = inst_21323);

return statearr_21504;
})();
var statearr_21505_21570 = state_21443__$1;
(statearr_21505_21570[(2)] = null);

(statearr_21505_21570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (14))){
var state_21443__$1 = state_21443;
var statearr_21506_21571 = state_21443__$1;
(statearr_21506_21571[(2)] = null);

(statearr_21506_21571[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (45))){
var inst_21433 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21507_21572 = state_21443__$1;
(statearr_21507_21572[(2)] = inst_21433);

(statearr_21507_21572[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (26))){
var inst_21375 = (state_21443[(29)]);
var inst_21429 = (state_21443[(2)]);
var inst_21430 = cljs.core.seq.call(null,inst_21375);
var state_21443__$1 = (function (){var statearr_21508 = state_21443;
(statearr_21508[(31)] = inst_21429);

return statearr_21508;
})();
if(inst_21430){
var statearr_21509_21573 = state_21443__$1;
(statearr_21509_21573[(1)] = (42));

} else {
var statearr_21510_21574 = state_21443__$1;
(statearr_21510_21574[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (16))){
var inst_21342 = (state_21443[(7)]);
var inst_21344 = cljs.core.chunked_seq_QMARK_.call(null,inst_21342);
var state_21443__$1 = state_21443;
if(inst_21344){
var statearr_21511_21575 = state_21443__$1;
(statearr_21511_21575[(1)] = (19));

} else {
var statearr_21512_21576 = state_21443__$1;
(statearr_21512_21576[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (38))){
var inst_21422 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21513_21577 = state_21443__$1;
(statearr_21513_21577[(2)] = inst_21422);

(statearr_21513_21577[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (30))){
var state_21443__$1 = state_21443;
var statearr_21514_21578 = state_21443__$1;
(statearr_21514_21578[(2)] = null);

(statearr_21514_21578[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (10))){
var inst_21321 = (state_21443[(13)]);
var inst_21323 = (state_21443[(16)]);
var inst_21331 = cljs.core._nth.call(null,inst_21321,inst_21323);
var inst_21332 = cljs.core.nth.call(null,inst_21331,(0),null);
var inst_21333 = cljs.core.nth.call(null,inst_21331,(1),null);
var state_21443__$1 = (function (){var statearr_21515 = state_21443;
(statearr_21515[(26)] = inst_21332);

return statearr_21515;
})();
if(cljs.core.truth_(inst_21333)){
var statearr_21516_21579 = state_21443__$1;
(statearr_21516_21579[(1)] = (13));

} else {
var statearr_21517_21580 = state_21443__$1;
(statearr_21517_21580[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (18))){
var inst_21368 = (state_21443[(2)]);
var state_21443__$1 = state_21443;
var statearr_21518_21581 = state_21443__$1;
(statearr_21518_21581[(2)] = inst_21368);

(statearr_21518_21581[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (42))){
var state_21443__$1 = state_21443;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21443__$1,(45),dchan);
} else {
if((state_val_21444 === (37))){
var inst_21411 = (state_21443[(23)]);
var inst_21402 = (state_21443[(25)]);
var inst_21311 = (state_21443[(11)]);
var inst_21411__$1 = cljs.core.first.call(null,inst_21402);
var inst_21412 = cljs.core.async.put_BANG_.call(null,inst_21411__$1,inst_21311,done);
var state_21443__$1 = (function (){var statearr_21519 = state_21443;
(statearr_21519[(23)] = inst_21411__$1);

return statearr_21519;
})();
if(cljs.core.truth_(inst_21412)){
var statearr_21520_21582 = state_21443__$1;
(statearr_21520_21582[(1)] = (39));

} else {
var statearr_21521_21583 = state_21443__$1;
(statearr_21521_21583[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21444 === (8))){
var inst_21322 = (state_21443[(15)]);
var inst_21323 = (state_21443[(16)]);
var inst_21325 = (inst_21323 < inst_21322);
var inst_21326 = inst_21325;
var state_21443__$1 = state_21443;
if(cljs.core.truth_(inst_21326)){
var statearr_21522_21584 = state_21443__$1;
(statearr_21522_21584[(1)] = (10));

} else {
var statearr_21523_21585 = state_21443__$1;
(statearr_21523_21585[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___21531,cs,m,dchan,dctr,done))
;
return ((function (switch__10483__auto__,c__10595__auto___21531,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10484__auto__ = null;
var cljs$core$async$mult_$_state_machine__10484__auto____0 = (function (){
var statearr_21527 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21527[(0)] = cljs$core$async$mult_$_state_machine__10484__auto__);

(statearr_21527[(1)] = (1));

return statearr_21527;
});
var cljs$core$async$mult_$_state_machine__10484__auto____1 = (function (state_21443){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_21443);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e21528){if((e21528 instanceof Object)){
var ex__10487__auto__ = e21528;
var statearr_21529_21586 = state_21443;
(statearr_21529_21586[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21443);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21528;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21587 = state_21443;
state_21443 = G__21587;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10484__auto__ = function(state_21443){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10484__auto____1.call(this,state_21443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10484__auto____0;
cljs$core$async$mult_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10484__auto____1;
return cljs$core$async$mult_$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___21531,cs,m,dchan,dctr,done))
})();
var state__10597__auto__ = (function (){var statearr_21530 = f__10596__auto__.call(null);
(statearr_21530[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___21531);

return statearr_21530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___21531,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args21588 = [];
var len__7484__auto___21591 = arguments.length;
var i__7485__auto___21592 = (0);
while(true){
if((i__7485__auto___21592 < len__7484__auto___21591)){
args21588.push((arguments[i__7485__auto___21592]));

var G__21593 = (i__7485__auto___21592 + (1));
i__7485__auto___21592 = G__21593;
continue;
} else {
}
break;
}

var G__21590 = args21588.length;
switch (G__21590) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21588.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___21605 = arguments.length;
var i__7485__auto___21606 = (0);
while(true){
if((i__7485__auto___21606 < len__7484__auto___21605)){
args__7491__auto__.push((arguments[i__7485__auto___21606]));

var G__21607 = (i__7485__auto___21606 + (1));
i__7485__auto___21606 = G__21607;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21599){
var map__21600 = p__21599;
var map__21600__$1 = ((((!((map__21600 == null)))?((((map__21600.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21600.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21600):map__21600);
var opts = map__21600__$1;
var statearr_21602_21608 = state;
(statearr_21602_21608[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__21600,map__21600__$1,opts){
return (function (val){
var statearr_21603_21609 = state;
(statearr_21603_21609[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__21600,map__21600__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_21604_21610 = state;
(statearr_21604_21610[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21595){
var G__21596 = cljs.core.first.call(null,seq21595);
var seq21595__$1 = cljs.core.next.call(null,seq21595);
var G__21597 = cljs.core.first.call(null,seq21595__$1);
var seq21595__$2 = cljs.core.next.call(null,seq21595__$1);
var G__21598 = cljs.core.first.call(null,seq21595__$2);
var seq21595__$3 = cljs.core.next.call(null,seq21595__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21596,G__21597,G__21598,seq21595__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21776 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21776 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta21777){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta21777 = meta21777;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21778,meta21777__$1){
var self__ = this;
var _21778__$1 = this;
return (new cljs.core.async.t_cljs$core$async21776(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta21777__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21778){
var self__ = this;
var _21778__$1 = this;
return self__.meta21777;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta21777","meta21777",-1380777300,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21776.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21776.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21776";

cljs.core.async.t_cljs$core$async21776.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async21776");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async21776 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async21776(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21777){
return (new cljs.core.async.t_cljs$core$async21776(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21777));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async21776(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10595__auto___21941 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_21878){
var state_val_21879 = (state_21878[(1)]);
if((state_val_21879 === (7))){
var inst_21794 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
var statearr_21880_21942 = state_21878__$1;
(statearr_21880_21942[(2)] = inst_21794);

(statearr_21880_21942[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (20))){
var inst_21806 = (state_21878[(7)]);
var state_21878__$1 = state_21878;
var statearr_21881_21943 = state_21878__$1;
(statearr_21881_21943[(2)] = inst_21806);

(statearr_21881_21943[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (27))){
var state_21878__$1 = state_21878;
var statearr_21882_21944 = state_21878__$1;
(statearr_21882_21944[(2)] = null);

(statearr_21882_21944[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (1))){
var inst_21782 = (state_21878[(8)]);
var inst_21782__$1 = calc_state.call(null);
var inst_21784 = (inst_21782__$1 == null);
var inst_21785 = cljs.core.not.call(null,inst_21784);
var state_21878__$1 = (function (){var statearr_21883 = state_21878;
(statearr_21883[(8)] = inst_21782__$1);

return statearr_21883;
})();
if(inst_21785){
var statearr_21884_21945 = state_21878__$1;
(statearr_21884_21945[(1)] = (2));

} else {
var statearr_21885_21946 = state_21878__$1;
(statearr_21885_21946[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (24))){
var inst_21838 = (state_21878[(9)]);
var inst_21829 = (state_21878[(10)]);
var inst_21852 = (state_21878[(11)]);
var inst_21852__$1 = inst_21829.call(null,inst_21838);
var state_21878__$1 = (function (){var statearr_21886 = state_21878;
(statearr_21886[(11)] = inst_21852__$1);

return statearr_21886;
})();
if(cljs.core.truth_(inst_21852__$1)){
var statearr_21887_21947 = state_21878__$1;
(statearr_21887_21947[(1)] = (29));

} else {
var statearr_21888_21948 = state_21878__$1;
(statearr_21888_21948[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (4))){
var inst_21797 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
if(cljs.core.truth_(inst_21797)){
var statearr_21889_21949 = state_21878__$1;
(statearr_21889_21949[(1)] = (8));

} else {
var statearr_21890_21950 = state_21878__$1;
(statearr_21890_21950[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (15))){
var inst_21823 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
if(cljs.core.truth_(inst_21823)){
var statearr_21891_21951 = state_21878__$1;
(statearr_21891_21951[(1)] = (19));

} else {
var statearr_21892_21952 = state_21878__$1;
(statearr_21892_21952[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (21))){
var inst_21828 = (state_21878[(12)]);
var inst_21828__$1 = (state_21878[(2)]);
var inst_21829 = cljs.core.get.call(null,inst_21828__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21830 = cljs.core.get.call(null,inst_21828__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21831 = cljs.core.get.call(null,inst_21828__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_21878__$1 = (function (){var statearr_21893 = state_21878;
(statearr_21893[(13)] = inst_21830);

(statearr_21893[(12)] = inst_21828__$1);

(statearr_21893[(10)] = inst_21829);

return statearr_21893;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_21878__$1,(22),inst_21831);
} else {
if((state_val_21879 === (31))){
var inst_21860 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
if(cljs.core.truth_(inst_21860)){
var statearr_21894_21953 = state_21878__$1;
(statearr_21894_21953[(1)] = (32));

} else {
var statearr_21895_21954 = state_21878__$1;
(statearr_21895_21954[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (32))){
var inst_21837 = (state_21878[(14)]);
var state_21878__$1 = state_21878;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21878__$1,(35),out,inst_21837);
} else {
if((state_val_21879 === (33))){
var inst_21828 = (state_21878[(12)]);
var inst_21806 = inst_21828;
var state_21878__$1 = (function (){var statearr_21896 = state_21878;
(statearr_21896[(7)] = inst_21806);

return statearr_21896;
})();
var statearr_21897_21955 = state_21878__$1;
(statearr_21897_21955[(2)] = null);

(statearr_21897_21955[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (13))){
var inst_21806 = (state_21878[(7)]);
var inst_21813 = inst_21806.cljs$lang$protocol_mask$partition0$;
var inst_21814 = (inst_21813 & (64));
var inst_21815 = inst_21806.cljs$core$ISeq$;
var inst_21816 = (inst_21814) || (inst_21815);
var state_21878__$1 = state_21878;
if(cljs.core.truth_(inst_21816)){
var statearr_21898_21956 = state_21878__$1;
(statearr_21898_21956[(1)] = (16));

} else {
var statearr_21899_21957 = state_21878__$1;
(statearr_21899_21957[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (22))){
var inst_21837 = (state_21878[(14)]);
var inst_21838 = (state_21878[(9)]);
var inst_21836 = (state_21878[(2)]);
var inst_21837__$1 = cljs.core.nth.call(null,inst_21836,(0),null);
var inst_21838__$1 = cljs.core.nth.call(null,inst_21836,(1),null);
var inst_21839 = (inst_21837__$1 == null);
var inst_21840 = cljs.core._EQ_.call(null,inst_21838__$1,change);
var inst_21841 = (inst_21839) || (inst_21840);
var state_21878__$1 = (function (){var statearr_21900 = state_21878;
(statearr_21900[(14)] = inst_21837__$1);

(statearr_21900[(9)] = inst_21838__$1);

return statearr_21900;
})();
if(cljs.core.truth_(inst_21841)){
var statearr_21901_21958 = state_21878__$1;
(statearr_21901_21958[(1)] = (23));

} else {
var statearr_21902_21959 = state_21878__$1;
(statearr_21902_21959[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (36))){
var inst_21828 = (state_21878[(12)]);
var inst_21806 = inst_21828;
var state_21878__$1 = (function (){var statearr_21903 = state_21878;
(statearr_21903[(7)] = inst_21806);

return statearr_21903;
})();
var statearr_21904_21960 = state_21878__$1;
(statearr_21904_21960[(2)] = null);

(statearr_21904_21960[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (29))){
var inst_21852 = (state_21878[(11)]);
var state_21878__$1 = state_21878;
var statearr_21905_21961 = state_21878__$1;
(statearr_21905_21961[(2)] = inst_21852);

(statearr_21905_21961[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (6))){
var state_21878__$1 = state_21878;
var statearr_21906_21962 = state_21878__$1;
(statearr_21906_21962[(2)] = false);

(statearr_21906_21962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (28))){
var inst_21848 = (state_21878[(2)]);
var inst_21849 = calc_state.call(null);
var inst_21806 = inst_21849;
var state_21878__$1 = (function (){var statearr_21907 = state_21878;
(statearr_21907[(15)] = inst_21848);

(statearr_21907[(7)] = inst_21806);

return statearr_21907;
})();
var statearr_21908_21963 = state_21878__$1;
(statearr_21908_21963[(2)] = null);

(statearr_21908_21963[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (25))){
var inst_21874 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
var statearr_21909_21964 = state_21878__$1;
(statearr_21909_21964[(2)] = inst_21874);

(statearr_21909_21964[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (34))){
var inst_21872 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
var statearr_21910_21965 = state_21878__$1;
(statearr_21910_21965[(2)] = inst_21872);

(statearr_21910_21965[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (17))){
var state_21878__$1 = state_21878;
var statearr_21911_21966 = state_21878__$1;
(statearr_21911_21966[(2)] = false);

(statearr_21911_21966[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (3))){
var state_21878__$1 = state_21878;
var statearr_21912_21967 = state_21878__$1;
(statearr_21912_21967[(2)] = false);

(statearr_21912_21967[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (12))){
var inst_21876 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21878__$1,inst_21876);
} else {
if((state_val_21879 === (2))){
var inst_21782 = (state_21878[(8)]);
var inst_21787 = inst_21782.cljs$lang$protocol_mask$partition0$;
var inst_21788 = (inst_21787 & (64));
var inst_21789 = inst_21782.cljs$core$ISeq$;
var inst_21790 = (inst_21788) || (inst_21789);
var state_21878__$1 = state_21878;
if(cljs.core.truth_(inst_21790)){
var statearr_21913_21968 = state_21878__$1;
(statearr_21913_21968[(1)] = (5));

} else {
var statearr_21914_21969 = state_21878__$1;
(statearr_21914_21969[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (23))){
var inst_21837 = (state_21878[(14)]);
var inst_21843 = (inst_21837 == null);
var state_21878__$1 = state_21878;
if(cljs.core.truth_(inst_21843)){
var statearr_21915_21970 = state_21878__$1;
(statearr_21915_21970[(1)] = (26));

} else {
var statearr_21916_21971 = state_21878__$1;
(statearr_21916_21971[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (35))){
var inst_21863 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
if(cljs.core.truth_(inst_21863)){
var statearr_21917_21972 = state_21878__$1;
(statearr_21917_21972[(1)] = (36));

} else {
var statearr_21918_21973 = state_21878__$1;
(statearr_21918_21973[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (19))){
var inst_21806 = (state_21878[(7)]);
var inst_21825 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21806);
var state_21878__$1 = state_21878;
var statearr_21919_21974 = state_21878__$1;
(statearr_21919_21974[(2)] = inst_21825);

(statearr_21919_21974[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (11))){
var inst_21806 = (state_21878[(7)]);
var inst_21810 = (inst_21806 == null);
var inst_21811 = cljs.core.not.call(null,inst_21810);
var state_21878__$1 = state_21878;
if(inst_21811){
var statearr_21920_21975 = state_21878__$1;
(statearr_21920_21975[(1)] = (13));

} else {
var statearr_21921_21976 = state_21878__$1;
(statearr_21921_21976[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (9))){
var inst_21782 = (state_21878[(8)]);
var state_21878__$1 = state_21878;
var statearr_21922_21977 = state_21878__$1;
(statearr_21922_21977[(2)] = inst_21782);

(statearr_21922_21977[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (5))){
var state_21878__$1 = state_21878;
var statearr_21923_21978 = state_21878__$1;
(statearr_21923_21978[(2)] = true);

(statearr_21923_21978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (14))){
var state_21878__$1 = state_21878;
var statearr_21924_21979 = state_21878__$1;
(statearr_21924_21979[(2)] = false);

(statearr_21924_21979[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (26))){
var inst_21838 = (state_21878[(9)]);
var inst_21845 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_21838);
var state_21878__$1 = state_21878;
var statearr_21925_21980 = state_21878__$1;
(statearr_21925_21980[(2)] = inst_21845);

(statearr_21925_21980[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (16))){
var state_21878__$1 = state_21878;
var statearr_21926_21981 = state_21878__$1;
(statearr_21926_21981[(2)] = true);

(statearr_21926_21981[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (38))){
var inst_21868 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
var statearr_21927_21982 = state_21878__$1;
(statearr_21927_21982[(2)] = inst_21868);

(statearr_21927_21982[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (30))){
var inst_21830 = (state_21878[(13)]);
var inst_21838 = (state_21878[(9)]);
var inst_21829 = (state_21878[(10)]);
var inst_21855 = cljs.core.empty_QMARK_.call(null,inst_21829);
var inst_21856 = inst_21830.call(null,inst_21838);
var inst_21857 = cljs.core.not.call(null,inst_21856);
var inst_21858 = (inst_21855) && (inst_21857);
var state_21878__$1 = state_21878;
var statearr_21928_21983 = state_21878__$1;
(statearr_21928_21983[(2)] = inst_21858);

(statearr_21928_21983[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (10))){
var inst_21782 = (state_21878[(8)]);
var inst_21802 = (state_21878[(2)]);
var inst_21803 = cljs.core.get.call(null,inst_21802,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21804 = cljs.core.get.call(null,inst_21802,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21805 = cljs.core.get.call(null,inst_21802,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_21806 = inst_21782;
var state_21878__$1 = (function (){var statearr_21929 = state_21878;
(statearr_21929[(16)] = inst_21805);

(statearr_21929[(17)] = inst_21803);

(statearr_21929[(7)] = inst_21806);

(statearr_21929[(18)] = inst_21804);

return statearr_21929;
})();
var statearr_21930_21984 = state_21878__$1;
(statearr_21930_21984[(2)] = null);

(statearr_21930_21984[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (18))){
var inst_21820 = (state_21878[(2)]);
var state_21878__$1 = state_21878;
var statearr_21931_21985 = state_21878__$1;
(statearr_21931_21985[(2)] = inst_21820);

(statearr_21931_21985[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (37))){
var state_21878__$1 = state_21878;
var statearr_21932_21986 = state_21878__$1;
(statearr_21932_21986[(2)] = null);

(statearr_21932_21986[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21879 === (8))){
var inst_21782 = (state_21878[(8)]);
var inst_21799 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21782);
var state_21878__$1 = state_21878;
var statearr_21933_21987 = state_21878__$1;
(statearr_21933_21987[(2)] = inst_21799);

(statearr_21933_21987[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10483__auto__,c__10595__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10484__auto__ = null;
var cljs$core$async$mix_$_state_machine__10484__auto____0 = (function (){
var statearr_21937 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21937[(0)] = cljs$core$async$mix_$_state_machine__10484__auto__);

(statearr_21937[(1)] = (1));

return statearr_21937;
});
var cljs$core$async$mix_$_state_machine__10484__auto____1 = (function (state_21878){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_21878);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e21938){if((e21938 instanceof Object)){
var ex__10487__auto__ = e21938;
var statearr_21939_21988 = state_21878;
(statearr_21939_21988[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21878);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21938;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21989 = state_21878;
state_21878 = G__21989;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10484__auto__ = function(state_21878){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10484__auto____1.call(this,state_21878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10484__auto____0;
cljs$core$async$mix_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10484__auto____1;
return cljs$core$async$mix_$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__10597__auto__ = (function (){var statearr_21940 = f__10596__auto__.call(null);
(statearr_21940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___21941);

return statearr_21940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args21990 = [];
var len__7484__auto___21993 = arguments.length;
var i__7485__auto___21994 = (0);
while(true){
if((i__7485__auto___21994 < len__7484__auto___21993)){
args21990.push((arguments[i__7485__auto___21994]));

var G__21995 = (i__7485__auto___21994 + (1));
i__7485__auto___21994 = G__21995;
continue;
} else {
}
break;
}

var G__21992 = args21990.length;
switch (G__21992) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21990.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args21998 = [];
var len__7484__auto___22123 = arguments.length;
var i__7485__auto___22124 = (0);
while(true){
if((i__7485__auto___22124 < len__7484__auto___22123)){
args21998.push((arguments[i__7485__auto___22124]));

var G__22125 = (i__7485__auto___22124 + (1));
i__7485__auto___22124 = G__22125;
continue;
} else {
}
break;
}

var G__22000 = args21998.length;
switch (G__22000) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21998.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__21997_SHARP_){
if(cljs.core.truth_(p1__21997_SHARP_.call(null,topic))){
return p1__21997_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__21997_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async22001 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22001 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta22002){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta22002 = meta22002;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_22003,meta22002__$1){
var self__ = this;
var _22003__$1 = this;
return (new cljs.core.async.t_cljs$core$async22001(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta22002__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_22003){
var self__ = this;
var _22003__$1 = this;
return self__.meta22002;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22001.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22001.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta22002","meta22002",1376912038,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22001.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22001.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22001";

cljs.core.async.t_cljs$core$async22001.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async22001");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async22001 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async22001(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22002){
return (new cljs.core.async.t_cljs$core$async22001(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22002));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async22001(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10595__auto___22127 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___22127,mults,ensure_mult,p){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___22127,mults,ensure_mult,p){
return (function (state_22075){
var state_val_22076 = (state_22075[(1)]);
if((state_val_22076 === (7))){
var inst_22071 = (state_22075[(2)]);
var state_22075__$1 = state_22075;
var statearr_22077_22128 = state_22075__$1;
(statearr_22077_22128[(2)] = inst_22071);

(statearr_22077_22128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (20))){
var state_22075__$1 = state_22075;
var statearr_22078_22129 = state_22075__$1;
(statearr_22078_22129[(2)] = null);

(statearr_22078_22129[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (1))){
var state_22075__$1 = state_22075;
var statearr_22079_22130 = state_22075__$1;
(statearr_22079_22130[(2)] = null);

(statearr_22079_22130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (24))){
var inst_22054 = (state_22075[(7)]);
var inst_22063 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_22054);
var state_22075__$1 = state_22075;
var statearr_22080_22131 = state_22075__$1;
(statearr_22080_22131[(2)] = inst_22063);

(statearr_22080_22131[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (4))){
var inst_22006 = (state_22075[(8)]);
var inst_22006__$1 = (state_22075[(2)]);
var inst_22007 = (inst_22006__$1 == null);
var state_22075__$1 = (function (){var statearr_22081 = state_22075;
(statearr_22081[(8)] = inst_22006__$1);

return statearr_22081;
})();
if(cljs.core.truth_(inst_22007)){
var statearr_22082_22132 = state_22075__$1;
(statearr_22082_22132[(1)] = (5));

} else {
var statearr_22083_22133 = state_22075__$1;
(statearr_22083_22133[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (15))){
var inst_22048 = (state_22075[(2)]);
var state_22075__$1 = state_22075;
var statearr_22084_22134 = state_22075__$1;
(statearr_22084_22134[(2)] = inst_22048);

(statearr_22084_22134[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (21))){
var inst_22068 = (state_22075[(2)]);
var state_22075__$1 = (function (){var statearr_22085 = state_22075;
(statearr_22085[(9)] = inst_22068);

return statearr_22085;
})();
var statearr_22086_22135 = state_22075__$1;
(statearr_22086_22135[(2)] = null);

(statearr_22086_22135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (13))){
var inst_22030 = (state_22075[(10)]);
var inst_22032 = cljs.core.chunked_seq_QMARK_.call(null,inst_22030);
var state_22075__$1 = state_22075;
if(inst_22032){
var statearr_22087_22136 = state_22075__$1;
(statearr_22087_22136[(1)] = (16));

} else {
var statearr_22088_22137 = state_22075__$1;
(statearr_22088_22137[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (22))){
var inst_22060 = (state_22075[(2)]);
var state_22075__$1 = state_22075;
if(cljs.core.truth_(inst_22060)){
var statearr_22089_22138 = state_22075__$1;
(statearr_22089_22138[(1)] = (23));

} else {
var statearr_22090_22139 = state_22075__$1;
(statearr_22090_22139[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (6))){
var inst_22056 = (state_22075[(11)]);
var inst_22006 = (state_22075[(8)]);
var inst_22054 = (state_22075[(7)]);
var inst_22054__$1 = topic_fn.call(null,inst_22006);
var inst_22055 = cljs.core.deref.call(null,mults);
var inst_22056__$1 = cljs.core.get.call(null,inst_22055,inst_22054__$1);
var state_22075__$1 = (function (){var statearr_22091 = state_22075;
(statearr_22091[(11)] = inst_22056__$1);

(statearr_22091[(7)] = inst_22054__$1);

return statearr_22091;
})();
if(cljs.core.truth_(inst_22056__$1)){
var statearr_22092_22140 = state_22075__$1;
(statearr_22092_22140[(1)] = (19));

} else {
var statearr_22093_22141 = state_22075__$1;
(statearr_22093_22141[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (25))){
var inst_22065 = (state_22075[(2)]);
var state_22075__$1 = state_22075;
var statearr_22094_22142 = state_22075__$1;
(statearr_22094_22142[(2)] = inst_22065);

(statearr_22094_22142[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (17))){
var inst_22030 = (state_22075[(10)]);
var inst_22039 = cljs.core.first.call(null,inst_22030);
var inst_22040 = cljs.core.async.muxch_STAR_.call(null,inst_22039);
var inst_22041 = cljs.core.async.close_BANG_.call(null,inst_22040);
var inst_22042 = cljs.core.next.call(null,inst_22030);
var inst_22016 = inst_22042;
var inst_22017 = null;
var inst_22018 = (0);
var inst_22019 = (0);
var state_22075__$1 = (function (){var statearr_22095 = state_22075;
(statearr_22095[(12)] = inst_22041);

(statearr_22095[(13)] = inst_22019);

(statearr_22095[(14)] = inst_22017);

(statearr_22095[(15)] = inst_22018);

(statearr_22095[(16)] = inst_22016);

return statearr_22095;
})();
var statearr_22096_22143 = state_22075__$1;
(statearr_22096_22143[(2)] = null);

(statearr_22096_22143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (3))){
var inst_22073 = (state_22075[(2)]);
var state_22075__$1 = state_22075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22075__$1,inst_22073);
} else {
if((state_val_22076 === (12))){
var inst_22050 = (state_22075[(2)]);
var state_22075__$1 = state_22075;
var statearr_22097_22144 = state_22075__$1;
(statearr_22097_22144[(2)] = inst_22050);

(statearr_22097_22144[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (2))){
var state_22075__$1 = state_22075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22075__$1,(4),ch);
} else {
if((state_val_22076 === (23))){
var state_22075__$1 = state_22075;
var statearr_22098_22145 = state_22075__$1;
(statearr_22098_22145[(2)] = null);

(statearr_22098_22145[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (19))){
var inst_22056 = (state_22075[(11)]);
var inst_22006 = (state_22075[(8)]);
var inst_22058 = cljs.core.async.muxch_STAR_.call(null,inst_22056);
var state_22075__$1 = state_22075;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22075__$1,(22),inst_22058,inst_22006);
} else {
if((state_val_22076 === (11))){
var inst_22030 = (state_22075[(10)]);
var inst_22016 = (state_22075[(16)]);
var inst_22030__$1 = cljs.core.seq.call(null,inst_22016);
var state_22075__$1 = (function (){var statearr_22099 = state_22075;
(statearr_22099[(10)] = inst_22030__$1);

return statearr_22099;
})();
if(inst_22030__$1){
var statearr_22100_22146 = state_22075__$1;
(statearr_22100_22146[(1)] = (13));

} else {
var statearr_22101_22147 = state_22075__$1;
(statearr_22101_22147[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (9))){
var inst_22052 = (state_22075[(2)]);
var state_22075__$1 = state_22075;
var statearr_22102_22148 = state_22075__$1;
(statearr_22102_22148[(2)] = inst_22052);

(statearr_22102_22148[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (5))){
var inst_22013 = cljs.core.deref.call(null,mults);
var inst_22014 = cljs.core.vals.call(null,inst_22013);
var inst_22015 = cljs.core.seq.call(null,inst_22014);
var inst_22016 = inst_22015;
var inst_22017 = null;
var inst_22018 = (0);
var inst_22019 = (0);
var state_22075__$1 = (function (){var statearr_22103 = state_22075;
(statearr_22103[(13)] = inst_22019);

(statearr_22103[(14)] = inst_22017);

(statearr_22103[(15)] = inst_22018);

(statearr_22103[(16)] = inst_22016);

return statearr_22103;
})();
var statearr_22104_22149 = state_22075__$1;
(statearr_22104_22149[(2)] = null);

(statearr_22104_22149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (14))){
var state_22075__$1 = state_22075;
var statearr_22108_22150 = state_22075__$1;
(statearr_22108_22150[(2)] = null);

(statearr_22108_22150[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (16))){
var inst_22030 = (state_22075[(10)]);
var inst_22034 = cljs.core.chunk_first.call(null,inst_22030);
var inst_22035 = cljs.core.chunk_rest.call(null,inst_22030);
var inst_22036 = cljs.core.count.call(null,inst_22034);
var inst_22016 = inst_22035;
var inst_22017 = inst_22034;
var inst_22018 = inst_22036;
var inst_22019 = (0);
var state_22075__$1 = (function (){var statearr_22109 = state_22075;
(statearr_22109[(13)] = inst_22019);

(statearr_22109[(14)] = inst_22017);

(statearr_22109[(15)] = inst_22018);

(statearr_22109[(16)] = inst_22016);

return statearr_22109;
})();
var statearr_22110_22151 = state_22075__$1;
(statearr_22110_22151[(2)] = null);

(statearr_22110_22151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (10))){
var inst_22019 = (state_22075[(13)]);
var inst_22017 = (state_22075[(14)]);
var inst_22018 = (state_22075[(15)]);
var inst_22016 = (state_22075[(16)]);
var inst_22024 = cljs.core._nth.call(null,inst_22017,inst_22019);
var inst_22025 = cljs.core.async.muxch_STAR_.call(null,inst_22024);
var inst_22026 = cljs.core.async.close_BANG_.call(null,inst_22025);
var inst_22027 = (inst_22019 + (1));
var tmp22105 = inst_22017;
var tmp22106 = inst_22018;
var tmp22107 = inst_22016;
var inst_22016__$1 = tmp22107;
var inst_22017__$1 = tmp22105;
var inst_22018__$1 = tmp22106;
var inst_22019__$1 = inst_22027;
var state_22075__$1 = (function (){var statearr_22111 = state_22075;
(statearr_22111[(13)] = inst_22019__$1);

(statearr_22111[(14)] = inst_22017__$1);

(statearr_22111[(15)] = inst_22018__$1);

(statearr_22111[(17)] = inst_22026);

(statearr_22111[(16)] = inst_22016__$1);

return statearr_22111;
})();
var statearr_22112_22152 = state_22075__$1;
(statearr_22112_22152[(2)] = null);

(statearr_22112_22152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (18))){
var inst_22045 = (state_22075[(2)]);
var state_22075__$1 = state_22075;
var statearr_22113_22153 = state_22075__$1;
(statearr_22113_22153[(2)] = inst_22045);

(statearr_22113_22153[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22076 === (8))){
var inst_22019 = (state_22075[(13)]);
var inst_22018 = (state_22075[(15)]);
var inst_22021 = (inst_22019 < inst_22018);
var inst_22022 = inst_22021;
var state_22075__$1 = state_22075;
if(cljs.core.truth_(inst_22022)){
var statearr_22114_22154 = state_22075__$1;
(statearr_22114_22154[(1)] = (10));

} else {
var statearr_22115_22155 = state_22075__$1;
(statearr_22115_22155[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___22127,mults,ensure_mult,p))
;
return ((function (switch__10483__auto__,c__10595__auto___22127,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_22119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22119[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_22119[(1)] = (1));

return statearr_22119;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_22075){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22120){if((e22120 instanceof Object)){
var ex__10487__auto__ = e22120;
var statearr_22121_22156 = state_22075;
(statearr_22121_22156[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22075);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22157 = state_22075;
state_22075 = G__22157;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_22075){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_22075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___22127,mults,ensure_mult,p))
})();
var state__10597__auto__ = (function (){var statearr_22122 = f__10596__auto__.call(null);
(statearr_22122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___22127);

return statearr_22122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___22127,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args22158 = [];
var len__7484__auto___22161 = arguments.length;
var i__7485__auto___22162 = (0);
while(true){
if((i__7485__auto___22162 < len__7484__auto___22161)){
args22158.push((arguments[i__7485__auto___22162]));

var G__22163 = (i__7485__auto___22162 + (1));
i__7485__auto___22162 = G__22163;
continue;
} else {
}
break;
}

var G__22160 = args22158.length;
switch (G__22160) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22158.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args22165 = [];
var len__7484__auto___22168 = arguments.length;
var i__7485__auto___22169 = (0);
while(true){
if((i__7485__auto___22169 < len__7484__auto___22168)){
args22165.push((arguments[i__7485__auto___22169]));

var G__22170 = (i__7485__auto___22169 + (1));
i__7485__auto___22169 = G__22170;
continue;
} else {
}
break;
}

var G__22167 = args22165.length;
switch (G__22167) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22165.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args22172 = [];
var len__7484__auto___22243 = arguments.length;
var i__7485__auto___22244 = (0);
while(true){
if((i__7485__auto___22244 < len__7484__auto___22243)){
args22172.push((arguments[i__7485__auto___22244]));

var G__22245 = (i__7485__auto___22244 + (1));
i__7485__auto___22244 = G__22245;
continue;
} else {
}
break;
}

var G__22174 = args22172.length;
switch (G__22174) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22172.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__10595__auto___22247 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___22247,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___22247,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_22213){
var state_val_22214 = (state_22213[(1)]);
if((state_val_22214 === (7))){
var state_22213__$1 = state_22213;
var statearr_22215_22248 = state_22213__$1;
(statearr_22215_22248[(2)] = null);

(statearr_22215_22248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (1))){
var state_22213__$1 = state_22213;
var statearr_22216_22249 = state_22213__$1;
(statearr_22216_22249[(2)] = null);

(statearr_22216_22249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (4))){
var inst_22177 = (state_22213[(7)]);
var inst_22179 = (inst_22177 < cnt);
var state_22213__$1 = state_22213;
if(cljs.core.truth_(inst_22179)){
var statearr_22217_22250 = state_22213__$1;
(statearr_22217_22250[(1)] = (6));

} else {
var statearr_22218_22251 = state_22213__$1;
(statearr_22218_22251[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (15))){
var inst_22209 = (state_22213[(2)]);
var state_22213__$1 = state_22213;
var statearr_22219_22252 = state_22213__$1;
(statearr_22219_22252[(2)] = inst_22209);

(statearr_22219_22252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (13))){
var inst_22202 = cljs.core.async.close_BANG_.call(null,out);
var state_22213__$1 = state_22213;
var statearr_22220_22253 = state_22213__$1;
(statearr_22220_22253[(2)] = inst_22202);

(statearr_22220_22253[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (6))){
var state_22213__$1 = state_22213;
var statearr_22221_22254 = state_22213__$1;
(statearr_22221_22254[(2)] = null);

(statearr_22221_22254[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (3))){
var inst_22211 = (state_22213[(2)]);
var state_22213__$1 = state_22213;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22213__$1,inst_22211);
} else {
if((state_val_22214 === (12))){
var inst_22199 = (state_22213[(8)]);
var inst_22199__$1 = (state_22213[(2)]);
var inst_22200 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_22199__$1);
var state_22213__$1 = (function (){var statearr_22222 = state_22213;
(statearr_22222[(8)] = inst_22199__$1);

return statearr_22222;
})();
if(cljs.core.truth_(inst_22200)){
var statearr_22223_22255 = state_22213__$1;
(statearr_22223_22255[(1)] = (13));

} else {
var statearr_22224_22256 = state_22213__$1;
(statearr_22224_22256[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (2))){
var inst_22176 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_22177 = (0);
var state_22213__$1 = (function (){var statearr_22225 = state_22213;
(statearr_22225[(9)] = inst_22176);

(statearr_22225[(7)] = inst_22177);

return statearr_22225;
})();
var statearr_22226_22257 = state_22213__$1;
(statearr_22226_22257[(2)] = null);

(statearr_22226_22257[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (11))){
var inst_22177 = (state_22213[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22213,(10),Object,null,(9));
var inst_22186 = chs__$1.call(null,inst_22177);
var inst_22187 = done.call(null,inst_22177);
var inst_22188 = cljs.core.async.take_BANG_.call(null,inst_22186,inst_22187);
var state_22213__$1 = state_22213;
var statearr_22227_22258 = state_22213__$1;
(statearr_22227_22258[(2)] = inst_22188);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22213__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (9))){
var inst_22177 = (state_22213[(7)]);
var inst_22190 = (state_22213[(2)]);
var inst_22191 = (inst_22177 + (1));
var inst_22177__$1 = inst_22191;
var state_22213__$1 = (function (){var statearr_22228 = state_22213;
(statearr_22228[(10)] = inst_22190);

(statearr_22228[(7)] = inst_22177__$1);

return statearr_22228;
})();
var statearr_22229_22259 = state_22213__$1;
(statearr_22229_22259[(2)] = null);

(statearr_22229_22259[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (5))){
var inst_22197 = (state_22213[(2)]);
var state_22213__$1 = (function (){var statearr_22230 = state_22213;
(statearr_22230[(11)] = inst_22197);

return statearr_22230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22213__$1,(12),dchan);
} else {
if((state_val_22214 === (14))){
var inst_22199 = (state_22213[(8)]);
var inst_22204 = cljs.core.apply.call(null,f,inst_22199);
var state_22213__$1 = state_22213;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22213__$1,(16),out,inst_22204);
} else {
if((state_val_22214 === (16))){
var inst_22206 = (state_22213[(2)]);
var state_22213__$1 = (function (){var statearr_22231 = state_22213;
(statearr_22231[(12)] = inst_22206);

return statearr_22231;
})();
var statearr_22232_22260 = state_22213__$1;
(statearr_22232_22260[(2)] = null);

(statearr_22232_22260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (10))){
var inst_22181 = (state_22213[(2)]);
var inst_22182 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_22213__$1 = (function (){var statearr_22233 = state_22213;
(statearr_22233[(13)] = inst_22181);

return statearr_22233;
})();
var statearr_22234_22261 = state_22213__$1;
(statearr_22234_22261[(2)] = inst_22182);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22213__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22214 === (8))){
var inst_22195 = (state_22213[(2)]);
var state_22213__$1 = state_22213;
var statearr_22235_22262 = state_22213__$1;
(statearr_22235_22262[(2)] = inst_22195);

(statearr_22235_22262[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___22247,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10483__auto__,c__10595__auto___22247,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_22239 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22239[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_22239[(1)] = (1));

return statearr_22239;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_22213){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22213);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22240){if((e22240 instanceof Object)){
var ex__10487__auto__ = e22240;
var statearr_22241_22263 = state_22213;
(statearr_22241_22263[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22213);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22240;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22264 = state_22213;
state_22213 = G__22264;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_22213){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_22213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___22247,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__10597__auto__ = (function (){var statearr_22242 = f__10596__auto__.call(null);
(statearr_22242[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___22247);

return statearr_22242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___22247,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args22266 = [];
var len__7484__auto___22324 = arguments.length;
var i__7485__auto___22325 = (0);
while(true){
if((i__7485__auto___22325 < len__7484__auto___22324)){
args22266.push((arguments[i__7485__auto___22325]));

var G__22326 = (i__7485__auto___22325 + (1));
i__7485__auto___22325 = G__22326;
continue;
} else {
}
break;
}

var G__22268 = args22266.length;
switch (G__22268) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22266.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___22328 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___22328,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___22328,out){
return (function (state_22300){
var state_val_22301 = (state_22300[(1)]);
if((state_val_22301 === (7))){
var inst_22279 = (state_22300[(7)]);
var inst_22280 = (state_22300[(8)]);
var inst_22279__$1 = (state_22300[(2)]);
var inst_22280__$1 = cljs.core.nth.call(null,inst_22279__$1,(0),null);
var inst_22281 = cljs.core.nth.call(null,inst_22279__$1,(1),null);
var inst_22282 = (inst_22280__$1 == null);
var state_22300__$1 = (function (){var statearr_22302 = state_22300;
(statearr_22302[(7)] = inst_22279__$1);

(statearr_22302[(9)] = inst_22281);

(statearr_22302[(8)] = inst_22280__$1);

return statearr_22302;
})();
if(cljs.core.truth_(inst_22282)){
var statearr_22303_22329 = state_22300__$1;
(statearr_22303_22329[(1)] = (8));

} else {
var statearr_22304_22330 = state_22300__$1;
(statearr_22304_22330[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22301 === (1))){
var inst_22269 = cljs.core.vec.call(null,chs);
var inst_22270 = inst_22269;
var state_22300__$1 = (function (){var statearr_22305 = state_22300;
(statearr_22305[(10)] = inst_22270);

return statearr_22305;
})();
var statearr_22306_22331 = state_22300__$1;
(statearr_22306_22331[(2)] = null);

(statearr_22306_22331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22301 === (4))){
var inst_22270 = (state_22300[(10)]);
var state_22300__$1 = state_22300;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22300__$1,(7),inst_22270);
} else {
if((state_val_22301 === (6))){
var inst_22296 = (state_22300[(2)]);
var state_22300__$1 = state_22300;
var statearr_22307_22332 = state_22300__$1;
(statearr_22307_22332[(2)] = inst_22296);

(statearr_22307_22332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22301 === (3))){
var inst_22298 = (state_22300[(2)]);
var state_22300__$1 = state_22300;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22300__$1,inst_22298);
} else {
if((state_val_22301 === (2))){
var inst_22270 = (state_22300[(10)]);
var inst_22272 = cljs.core.count.call(null,inst_22270);
var inst_22273 = (inst_22272 > (0));
var state_22300__$1 = state_22300;
if(cljs.core.truth_(inst_22273)){
var statearr_22309_22333 = state_22300__$1;
(statearr_22309_22333[(1)] = (4));

} else {
var statearr_22310_22334 = state_22300__$1;
(statearr_22310_22334[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22301 === (11))){
var inst_22270 = (state_22300[(10)]);
var inst_22289 = (state_22300[(2)]);
var tmp22308 = inst_22270;
var inst_22270__$1 = tmp22308;
var state_22300__$1 = (function (){var statearr_22311 = state_22300;
(statearr_22311[(10)] = inst_22270__$1);

(statearr_22311[(11)] = inst_22289);

return statearr_22311;
})();
var statearr_22312_22335 = state_22300__$1;
(statearr_22312_22335[(2)] = null);

(statearr_22312_22335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22301 === (9))){
var inst_22280 = (state_22300[(8)]);
var state_22300__$1 = state_22300;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22300__$1,(11),out,inst_22280);
} else {
if((state_val_22301 === (5))){
var inst_22294 = cljs.core.async.close_BANG_.call(null,out);
var state_22300__$1 = state_22300;
var statearr_22313_22336 = state_22300__$1;
(statearr_22313_22336[(2)] = inst_22294);

(statearr_22313_22336[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22301 === (10))){
var inst_22292 = (state_22300[(2)]);
var state_22300__$1 = state_22300;
var statearr_22314_22337 = state_22300__$1;
(statearr_22314_22337[(2)] = inst_22292);

(statearr_22314_22337[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22301 === (8))){
var inst_22279 = (state_22300[(7)]);
var inst_22270 = (state_22300[(10)]);
var inst_22281 = (state_22300[(9)]);
var inst_22280 = (state_22300[(8)]);
var inst_22284 = (function (){var cs = inst_22270;
var vec__22275 = inst_22279;
var v = inst_22280;
var c = inst_22281;
return ((function (cs,vec__22275,v,c,inst_22279,inst_22270,inst_22281,inst_22280,state_val_22301,c__10595__auto___22328,out){
return (function (p1__22265_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__22265_SHARP_);
});
;})(cs,vec__22275,v,c,inst_22279,inst_22270,inst_22281,inst_22280,state_val_22301,c__10595__auto___22328,out))
})();
var inst_22285 = cljs.core.filterv.call(null,inst_22284,inst_22270);
var inst_22270__$1 = inst_22285;
var state_22300__$1 = (function (){var statearr_22315 = state_22300;
(statearr_22315[(10)] = inst_22270__$1);

return statearr_22315;
})();
var statearr_22316_22338 = state_22300__$1;
(statearr_22316_22338[(2)] = null);

(statearr_22316_22338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___22328,out))
;
return ((function (switch__10483__auto__,c__10595__auto___22328,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_22320 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22320[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_22320[(1)] = (1));

return statearr_22320;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_22300){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22300);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22321){if((e22321 instanceof Object)){
var ex__10487__auto__ = e22321;
var statearr_22322_22339 = state_22300;
(statearr_22322_22339[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22300);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22321;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22340 = state_22300;
state_22300 = G__22340;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_22300){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_22300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___22328,out))
})();
var state__10597__auto__ = (function (){var statearr_22323 = f__10596__auto__.call(null);
(statearr_22323[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___22328);

return statearr_22323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___22328,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args22341 = [];
var len__7484__auto___22390 = arguments.length;
var i__7485__auto___22391 = (0);
while(true){
if((i__7485__auto___22391 < len__7484__auto___22390)){
args22341.push((arguments[i__7485__auto___22391]));

var G__22392 = (i__7485__auto___22391 + (1));
i__7485__auto___22391 = G__22392;
continue;
} else {
}
break;
}

var G__22343 = args22341.length;
switch (G__22343) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22341.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___22394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___22394,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___22394,out){
return (function (state_22367){
var state_val_22368 = (state_22367[(1)]);
if((state_val_22368 === (7))){
var inst_22349 = (state_22367[(7)]);
var inst_22349__$1 = (state_22367[(2)]);
var inst_22350 = (inst_22349__$1 == null);
var inst_22351 = cljs.core.not.call(null,inst_22350);
var state_22367__$1 = (function (){var statearr_22369 = state_22367;
(statearr_22369[(7)] = inst_22349__$1);

return statearr_22369;
})();
if(inst_22351){
var statearr_22370_22395 = state_22367__$1;
(statearr_22370_22395[(1)] = (8));

} else {
var statearr_22371_22396 = state_22367__$1;
(statearr_22371_22396[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22368 === (1))){
var inst_22344 = (0);
var state_22367__$1 = (function (){var statearr_22372 = state_22367;
(statearr_22372[(8)] = inst_22344);

return statearr_22372;
})();
var statearr_22373_22397 = state_22367__$1;
(statearr_22373_22397[(2)] = null);

(statearr_22373_22397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22368 === (4))){
var state_22367__$1 = state_22367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22367__$1,(7),ch);
} else {
if((state_val_22368 === (6))){
var inst_22362 = (state_22367[(2)]);
var state_22367__$1 = state_22367;
var statearr_22374_22398 = state_22367__$1;
(statearr_22374_22398[(2)] = inst_22362);

(statearr_22374_22398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22368 === (3))){
var inst_22364 = (state_22367[(2)]);
var inst_22365 = cljs.core.async.close_BANG_.call(null,out);
var state_22367__$1 = (function (){var statearr_22375 = state_22367;
(statearr_22375[(9)] = inst_22364);

return statearr_22375;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22367__$1,inst_22365);
} else {
if((state_val_22368 === (2))){
var inst_22344 = (state_22367[(8)]);
var inst_22346 = (inst_22344 < n);
var state_22367__$1 = state_22367;
if(cljs.core.truth_(inst_22346)){
var statearr_22376_22399 = state_22367__$1;
(statearr_22376_22399[(1)] = (4));

} else {
var statearr_22377_22400 = state_22367__$1;
(statearr_22377_22400[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22368 === (11))){
var inst_22344 = (state_22367[(8)]);
var inst_22354 = (state_22367[(2)]);
var inst_22355 = (inst_22344 + (1));
var inst_22344__$1 = inst_22355;
var state_22367__$1 = (function (){var statearr_22378 = state_22367;
(statearr_22378[(8)] = inst_22344__$1);

(statearr_22378[(10)] = inst_22354);

return statearr_22378;
})();
var statearr_22379_22401 = state_22367__$1;
(statearr_22379_22401[(2)] = null);

(statearr_22379_22401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22368 === (9))){
var state_22367__$1 = state_22367;
var statearr_22380_22402 = state_22367__$1;
(statearr_22380_22402[(2)] = null);

(statearr_22380_22402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22368 === (5))){
var state_22367__$1 = state_22367;
var statearr_22381_22403 = state_22367__$1;
(statearr_22381_22403[(2)] = null);

(statearr_22381_22403[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22368 === (10))){
var inst_22359 = (state_22367[(2)]);
var state_22367__$1 = state_22367;
var statearr_22382_22404 = state_22367__$1;
(statearr_22382_22404[(2)] = inst_22359);

(statearr_22382_22404[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22368 === (8))){
var inst_22349 = (state_22367[(7)]);
var state_22367__$1 = state_22367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22367__$1,(11),out,inst_22349);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___22394,out))
;
return ((function (switch__10483__auto__,c__10595__auto___22394,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_22386 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22386[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_22386[(1)] = (1));

return statearr_22386;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_22367){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22387){if((e22387 instanceof Object)){
var ex__10487__auto__ = e22387;
var statearr_22388_22405 = state_22367;
(statearr_22388_22405[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22367);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22387;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22406 = state_22367;
state_22367 = G__22406;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_22367){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_22367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___22394,out))
})();
var state__10597__auto__ = (function (){var statearr_22389 = f__10596__auto__.call(null);
(statearr_22389[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___22394);

return statearr_22389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___22394,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22414 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22414 = (function (map_LT_,f,ch,meta22415){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22415 = meta22415;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22416,meta22415__$1){
var self__ = this;
var _22416__$1 = this;
return (new cljs.core.async.t_cljs$core$async22414(self__.map_LT_,self__.f,self__.ch,meta22415__$1));
});

cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22416){
var self__ = this;
var _22416__$1 = this;
return self__.meta22415;
});

cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async22417 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22417 = (function (map_LT_,f,ch,meta22415,_,fn1,meta22418){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22415 = meta22415;
this._ = _;
this.fn1 = fn1;
this.meta22418 = meta22418;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_22419,meta22418__$1){
var self__ = this;
var _22419__$1 = this;
return (new cljs.core.async.t_cljs$core$async22417(self__.map_LT_,self__.f,self__.ch,self__.meta22415,self__._,self__.fn1,meta22418__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_22419){
var self__ = this;
var _22419__$1 = this;
return self__.meta22418;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__22407_SHARP_){
return f1.call(null,(((p1__22407_SHARP_ == null))?null:self__.f.call(null,p1__22407_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async22417.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22415","meta22415",1290709913,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async22414","cljs.core.async/t_cljs$core$async22414",2029190463,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta22418","meta22418",-1177801220,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22417.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22417.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22417";

cljs.core.async.t_cljs$core$async22417.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async22417");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async22417 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22417(map_LT___$1,f__$1,ch__$1,meta22415__$1,___$2,fn1__$1,meta22418){
return (new cljs.core.async.t_cljs$core$async22417(map_LT___$1,f__$1,ch__$1,meta22415__$1,___$2,fn1__$1,meta22418));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async22417(self__.map_LT_,self__.f,self__.ch,self__.meta22415,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22414.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async22414.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22415","meta22415",1290709913,null)], null);
});

cljs.core.async.t_cljs$core$async22414.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22414.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22414";

cljs.core.async.t_cljs$core$async22414.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async22414");
});

cljs.core.async.__GT_t_cljs$core$async22414 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22414(map_LT___$1,f__$1,ch__$1,meta22415){
return (new cljs.core.async.t_cljs$core$async22414(map_LT___$1,f__$1,ch__$1,meta22415));
});

}

return (new cljs.core.async.t_cljs$core$async22414(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22423 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22423 = (function (map_GT_,f,ch,meta22424){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta22424 = meta22424;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22423.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22425,meta22424__$1){
var self__ = this;
var _22425__$1 = this;
return (new cljs.core.async.t_cljs$core$async22423(self__.map_GT_,self__.f,self__.ch,meta22424__$1));
});

cljs.core.async.t_cljs$core$async22423.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22425){
var self__ = this;
var _22425__$1 = this;
return self__.meta22424;
});

cljs.core.async.t_cljs$core$async22423.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22423.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22423.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22423.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22423.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22423.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async22423.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22424","meta22424",385030617,null)], null);
});

cljs.core.async.t_cljs$core$async22423.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22423.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22423";

cljs.core.async.t_cljs$core$async22423.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async22423");
});

cljs.core.async.__GT_t_cljs$core$async22423 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async22423(map_GT___$1,f__$1,ch__$1,meta22424){
return (new cljs.core.async.t_cljs$core$async22423(map_GT___$1,f__$1,ch__$1,meta22424));
});

}

return (new cljs.core.async.t_cljs$core$async22423(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async22429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22429 = (function (filter_GT_,p,ch,meta22430){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta22430 = meta22430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22431,meta22430__$1){
var self__ = this;
var _22431__$1 = this;
return (new cljs.core.async.t_cljs$core$async22429(self__.filter_GT_,self__.p,self__.ch,meta22430__$1));
});

cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22431){
var self__ = this;
var _22431__$1 = this;
return self__.meta22430;
});

cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22429.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async22429.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22430","meta22430",1263682190,null)], null);
});

cljs.core.async.t_cljs$core$async22429.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22429.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22429";

cljs.core.async.t_cljs$core$async22429.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async22429");
});

cljs.core.async.__GT_t_cljs$core$async22429 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async22429(filter_GT___$1,p__$1,ch__$1,meta22430){
return (new cljs.core.async.t_cljs$core$async22429(filter_GT___$1,p__$1,ch__$1,meta22430));
});

}

return (new cljs.core.async.t_cljs$core$async22429(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args22432 = [];
var len__7484__auto___22476 = arguments.length;
var i__7485__auto___22477 = (0);
while(true){
if((i__7485__auto___22477 < len__7484__auto___22476)){
args22432.push((arguments[i__7485__auto___22477]));

var G__22478 = (i__7485__auto___22477 + (1));
i__7485__auto___22477 = G__22478;
continue;
} else {
}
break;
}

var G__22434 = args22432.length;
switch (G__22434) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22432.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___22480 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___22480,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___22480,out){
return (function (state_22455){
var state_val_22456 = (state_22455[(1)]);
if((state_val_22456 === (7))){
var inst_22451 = (state_22455[(2)]);
var state_22455__$1 = state_22455;
var statearr_22457_22481 = state_22455__$1;
(statearr_22457_22481[(2)] = inst_22451);

(statearr_22457_22481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (1))){
var state_22455__$1 = state_22455;
var statearr_22458_22482 = state_22455__$1;
(statearr_22458_22482[(2)] = null);

(statearr_22458_22482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (4))){
var inst_22437 = (state_22455[(7)]);
var inst_22437__$1 = (state_22455[(2)]);
var inst_22438 = (inst_22437__$1 == null);
var state_22455__$1 = (function (){var statearr_22459 = state_22455;
(statearr_22459[(7)] = inst_22437__$1);

return statearr_22459;
})();
if(cljs.core.truth_(inst_22438)){
var statearr_22460_22483 = state_22455__$1;
(statearr_22460_22483[(1)] = (5));

} else {
var statearr_22461_22484 = state_22455__$1;
(statearr_22461_22484[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (6))){
var inst_22437 = (state_22455[(7)]);
var inst_22442 = p.call(null,inst_22437);
var state_22455__$1 = state_22455;
if(cljs.core.truth_(inst_22442)){
var statearr_22462_22485 = state_22455__$1;
(statearr_22462_22485[(1)] = (8));

} else {
var statearr_22463_22486 = state_22455__$1;
(statearr_22463_22486[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (3))){
var inst_22453 = (state_22455[(2)]);
var state_22455__$1 = state_22455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22455__$1,inst_22453);
} else {
if((state_val_22456 === (2))){
var state_22455__$1 = state_22455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22455__$1,(4),ch);
} else {
if((state_val_22456 === (11))){
var inst_22445 = (state_22455[(2)]);
var state_22455__$1 = state_22455;
var statearr_22464_22487 = state_22455__$1;
(statearr_22464_22487[(2)] = inst_22445);

(statearr_22464_22487[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (9))){
var state_22455__$1 = state_22455;
var statearr_22465_22488 = state_22455__$1;
(statearr_22465_22488[(2)] = null);

(statearr_22465_22488[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (5))){
var inst_22440 = cljs.core.async.close_BANG_.call(null,out);
var state_22455__$1 = state_22455;
var statearr_22466_22489 = state_22455__$1;
(statearr_22466_22489[(2)] = inst_22440);

(statearr_22466_22489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (10))){
var inst_22448 = (state_22455[(2)]);
var state_22455__$1 = (function (){var statearr_22467 = state_22455;
(statearr_22467[(8)] = inst_22448);

return statearr_22467;
})();
var statearr_22468_22490 = state_22455__$1;
(statearr_22468_22490[(2)] = null);

(statearr_22468_22490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (8))){
var inst_22437 = (state_22455[(7)]);
var state_22455__$1 = state_22455;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22455__$1,(11),out,inst_22437);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___22480,out))
;
return ((function (switch__10483__auto__,c__10595__auto___22480,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_22472 = [null,null,null,null,null,null,null,null,null];
(statearr_22472[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_22472[(1)] = (1));

return statearr_22472;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_22455){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22473){if((e22473 instanceof Object)){
var ex__10487__auto__ = e22473;
var statearr_22474_22491 = state_22455;
(statearr_22474_22491[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22455);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22473;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22492 = state_22455;
state_22455 = G__22492;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_22455){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_22455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___22480,out))
})();
var state__10597__auto__ = (function (){var statearr_22475 = f__10596__auto__.call(null);
(statearr_22475[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___22480);

return statearr_22475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___22480,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args22493 = [];
var len__7484__auto___22496 = arguments.length;
var i__7485__auto___22497 = (0);
while(true){
if((i__7485__auto___22497 < len__7484__auto___22496)){
args22493.push((arguments[i__7485__auto___22497]));

var G__22498 = (i__7485__auto___22497 + (1));
i__7485__auto___22497 = G__22498;
continue;
} else {
}
break;
}

var G__22495 = args22493.length;
switch (G__22495) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22493.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__10595__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto__){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto__){
return (function (state_22665){
var state_val_22666 = (state_22665[(1)]);
if((state_val_22666 === (7))){
var inst_22661 = (state_22665[(2)]);
var state_22665__$1 = state_22665;
var statearr_22667_22708 = state_22665__$1;
(statearr_22667_22708[(2)] = inst_22661);

(statearr_22667_22708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (20))){
var inst_22631 = (state_22665[(7)]);
var inst_22642 = (state_22665[(2)]);
var inst_22643 = cljs.core.next.call(null,inst_22631);
var inst_22617 = inst_22643;
var inst_22618 = null;
var inst_22619 = (0);
var inst_22620 = (0);
var state_22665__$1 = (function (){var statearr_22668 = state_22665;
(statearr_22668[(8)] = inst_22617);

(statearr_22668[(9)] = inst_22642);

(statearr_22668[(10)] = inst_22618);

(statearr_22668[(11)] = inst_22619);

(statearr_22668[(12)] = inst_22620);

return statearr_22668;
})();
var statearr_22669_22709 = state_22665__$1;
(statearr_22669_22709[(2)] = null);

(statearr_22669_22709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (1))){
var state_22665__$1 = state_22665;
var statearr_22670_22710 = state_22665__$1;
(statearr_22670_22710[(2)] = null);

(statearr_22670_22710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (4))){
var inst_22606 = (state_22665[(13)]);
var inst_22606__$1 = (state_22665[(2)]);
var inst_22607 = (inst_22606__$1 == null);
var state_22665__$1 = (function (){var statearr_22671 = state_22665;
(statearr_22671[(13)] = inst_22606__$1);

return statearr_22671;
})();
if(cljs.core.truth_(inst_22607)){
var statearr_22672_22711 = state_22665__$1;
(statearr_22672_22711[(1)] = (5));

} else {
var statearr_22673_22712 = state_22665__$1;
(statearr_22673_22712[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (15))){
var state_22665__$1 = state_22665;
var statearr_22677_22713 = state_22665__$1;
(statearr_22677_22713[(2)] = null);

(statearr_22677_22713[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (21))){
var state_22665__$1 = state_22665;
var statearr_22678_22714 = state_22665__$1;
(statearr_22678_22714[(2)] = null);

(statearr_22678_22714[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (13))){
var inst_22617 = (state_22665[(8)]);
var inst_22618 = (state_22665[(10)]);
var inst_22619 = (state_22665[(11)]);
var inst_22620 = (state_22665[(12)]);
var inst_22627 = (state_22665[(2)]);
var inst_22628 = (inst_22620 + (1));
var tmp22674 = inst_22617;
var tmp22675 = inst_22618;
var tmp22676 = inst_22619;
var inst_22617__$1 = tmp22674;
var inst_22618__$1 = tmp22675;
var inst_22619__$1 = tmp22676;
var inst_22620__$1 = inst_22628;
var state_22665__$1 = (function (){var statearr_22679 = state_22665;
(statearr_22679[(8)] = inst_22617__$1);

(statearr_22679[(10)] = inst_22618__$1);

(statearr_22679[(11)] = inst_22619__$1);

(statearr_22679[(14)] = inst_22627);

(statearr_22679[(12)] = inst_22620__$1);

return statearr_22679;
})();
var statearr_22680_22715 = state_22665__$1;
(statearr_22680_22715[(2)] = null);

(statearr_22680_22715[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (22))){
var state_22665__$1 = state_22665;
var statearr_22681_22716 = state_22665__$1;
(statearr_22681_22716[(2)] = null);

(statearr_22681_22716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (6))){
var inst_22606 = (state_22665[(13)]);
var inst_22615 = f.call(null,inst_22606);
var inst_22616 = cljs.core.seq.call(null,inst_22615);
var inst_22617 = inst_22616;
var inst_22618 = null;
var inst_22619 = (0);
var inst_22620 = (0);
var state_22665__$1 = (function (){var statearr_22682 = state_22665;
(statearr_22682[(8)] = inst_22617);

(statearr_22682[(10)] = inst_22618);

(statearr_22682[(11)] = inst_22619);

(statearr_22682[(12)] = inst_22620);

return statearr_22682;
})();
var statearr_22683_22717 = state_22665__$1;
(statearr_22683_22717[(2)] = null);

(statearr_22683_22717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (17))){
var inst_22631 = (state_22665[(7)]);
var inst_22635 = cljs.core.chunk_first.call(null,inst_22631);
var inst_22636 = cljs.core.chunk_rest.call(null,inst_22631);
var inst_22637 = cljs.core.count.call(null,inst_22635);
var inst_22617 = inst_22636;
var inst_22618 = inst_22635;
var inst_22619 = inst_22637;
var inst_22620 = (0);
var state_22665__$1 = (function (){var statearr_22684 = state_22665;
(statearr_22684[(8)] = inst_22617);

(statearr_22684[(10)] = inst_22618);

(statearr_22684[(11)] = inst_22619);

(statearr_22684[(12)] = inst_22620);

return statearr_22684;
})();
var statearr_22685_22718 = state_22665__$1;
(statearr_22685_22718[(2)] = null);

(statearr_22685_22718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (3))){
var inst_22663 = (state_22665[(2)]);
var state_22665__$1 = state_22665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22665__$1,inst_22663);
} else {
if((state_val_22666 === (12))){
var inst_22651 = (state_22665[(2)]);
var state_22665__$1 = state_22665;
var statearr_22686_22719 = state_22665__$1;
(statearr_22686_22719[(2)] = inst_22651);

(statearr_22686_22719[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (2))){
var state_22665__$1 = state_22665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22665__$1,(4),in$);
} else {
if((state_val_22666 === (23))){
var inst_22659 = (state_22665[(2)]);
var state_22665__$1 = state_22665;
var statearr_22687_22720 = state_22665__$1;
(statearr_22687_22720[(2)] = inst_22659);

(statearr_22687_22720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (19))){
var inst_22646 = (state_22665[(2)]);
var state_22665__$1 = state_22665;
var statearr_22688_22721 = state_22665__$1;
(statearr_22688_22721[(2)] = inst_22646);

(statearr_22688_22721[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (11))){
var inst_22617 = (state_22665[(8)]);
var inst_22631 = (state_22665[(7)]);
var inst_22631__$1 = cljs.core.seq.call(null,inst_22617);
var state_22665__$1 = (function (){var statearr_22689 = state_22665;
(statearr_22689[(7)] = inst_22631__$1);

return statearr_22689;
})();
if(inst_22631__$1){
var statearr_22690_22722 = state_22665__$1;
(statearr_22690_22722[(1)] = (14));

} else {
var statearr_22691_22723 = state_22665__$1;
(statearr_22691_22723[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (9))){
var inst_22653 = (state_22665[(2)]);
var inst_22654 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_22665__$1 = (function (){var statearr_22692 = state_22665;
(statearr_22692[(15)] = inst_22653);

return statearr_22692;
})();
if(cljs.core.truth_(inst_22654)){
var statearr_22693_22724 = state_22665__$1;
(statearr_22693_22724[(1)] = (21));

} else {
var statearr_22694_22725 = state_22665__$1;
(statearr_22694_22725[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (5))){
var inst_22609 = cljs.core.async.close_BANG_.call(null,out);
var state_22665__$1 = state_22665;
var statearr_22695_22726 = state_22665__$1;
(statearr_22695_22726[(2)] = inst_22609);

(statearr_22695_22726[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (14))){
var inst_22631 = (state_22665[(7)]);
var inst_22633 = cljs.core.chunked_seq_QMARK_.call(null,inst_22631);
var state_22665__$1 = state_22665;
if(inst_22633){
var statearr_22696_22727 = state_22665__$1;
(statearr_22696_22727[(1)] = (17));

} else {
var statearr_22697_22728 = state_22665__$1;
(statearr_22697_22728[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (16))){
var inst_22649 = (state_22665[(2)]);
var state_22665__$1 = state_22665;
var statearr_22698_22729 = state_22665__$1;
(statearr_22698_22729[(2)] = inst_22649);

(statearr_22698_22729[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22666 === (10))){
var inst_22618 = (state_22665[(10)]);
var inst_22620 = (state_22665[(12)]);
var inst_22625 = cljs.core._nth.call(null,inst_22618,inst_22620);
var state_22665__$1 = state_22665;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22665__$1,(13),out,inst_22625);
} else {
if((state_val_22666 === (18))){
var inst_22631 = (state_22665[(7)]);
var inst_22640 = cljs.core.first.call(null,inst_22631);
var state_22665__$1 = state_22665;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22665__$1,(20),out,inst_22640);
} else {
if((state_val_22666 === (8))){
var inst_22619 = (state_22665[(11)]);
var inst_22620 = (state_22665[(12)]);
var inst_22622 = (inst_22620 < inst_22619);
var inst_22623 = inst_22622;
var state_22665__$1 = state_22665;
if(cljs.core.truth_(inst_22623)){
var statearr_22699_22730 = state_22665__$1;
(statearr_22699_22730[(1)] = (10));

} else {
var statearr_22700_22731 = state_22665__$1;
(statearr_22700_22731[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto__))
;
return ((function (switch__10483__auto__,c__10595__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_22704 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22704[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__);

(statearr_22704[(1)] = (1));

return statearr_22704;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____1 = (function (state_22665){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22705){if((e22705 instanceof Object)){
var ex__10487__auto__ = e22705;
var statearr_22706_22732 = state_22665;
(statearr_22706_22732[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22665);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22705;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22733 = state_22665;
state_22665 = G__22733;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__ = function(state_22665){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____1.call(this,state_22665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto__))
})();
var state__10597__auto__ = (function (){var statearr_22707 = f__10596__auto__.call(null);
(statearr_22707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto__);

return statearr_22707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto__))
);

return c__10595__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args22734 = [];
var len__7484__auto___22737 = arguments.length;
var i__7485__auto___22738 = (0);
while(true){
if((i__7485__auto___22738 < len__7484__auto___22737)){
args22734.push((arguments[i__7485__auto___22738]));

var G__22739 = (i__7485__auto___22738 + (1));
i__7485__auto___22738 = G__22739;
continue;
} else {
}
break;
}

var G__22736 = args22734.length;
switch (G__22736) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22734.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args22741 = [];
var len__7484__auto___22744 = arguments.length;
var i__7485__auto___22745 = (0);
while(true){
if((i__7485__auto___22745 < len__7484__auto___22744)){
args22741.push((arguments[i__7485__auto___22745]));

var G__22746 = (i__7485__auto___22745 + (1));
i__7485__auto___22745 = G__22746;
continue;
} else {
}
break;
}

var G__22743 = args22741.length;
switch (G__22743) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22741.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args22748 = [];
var len__7484__auto___22799 = arguments.length;
var i__7485__auto___22800 = (0);
while(true){
if((i__7485__auto___22800 < len__7484__auto___22799)){
args22748.push((arguments[i__7485__auto___22800]));

var G__22801 = (i__7485__auto___22800 + (1));
i__7485__auto___22800 = G__22801;
continue;
} else {
}
break;
}

var G__22750 = args22748.length;
switch (G__22750) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22748.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___22803 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___22803,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___22803,out){
return (function (state_22774){
var state_val_22775 = (state_22774[(1)]);
if((state_val_22775 === (7))){
var inst_22769 = (state_22774[(2)]);
var state_22774__$1 = state_22774;
var statearr_22776_22804 = state_22774__$1;
(statearr_22776_22804[(2)] = inst_22769);

(statearr_22776_22804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22775 === (1))){
var inst_22751 = null;
var state_22774__$1 = (function (){var statearr_22777 = state_22774;
(statearr_22777[(7)] = inst_22751);

return statearr_22777;
})();
var statearr_22778_22805 = state_22774__$1;
(statearr_22778_22805[(2)] = null);

(statearr_22778_22805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22775 === (4))){
var inst_22754 = (state_22774[(8)]);
var inst_22754__$1 = (state_22774[(2)]);
var inst_22755 = (inst_22754__$1 == null);
var inst_22756 = cljs.core.not.call(null,inst_22755);
var state_22774__$1 = (function (){var statearr_22779 = state_22774;
(statearr_22779[(8)] = inst_22754__$1);

return statearr_22779;
})();
if(inst_22756){
var statearr_22780_22806 = state_22774__$1;
(statearr_22780_22806[(1)] = (5));

} else {
var statearr_22781_22807 = state_22774__$1;
(statearr_22781_22807[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22775 === (6))){
var state_22774__$1 = state_22774;
var statearr_22782_22808 = state_22774__$1;
(statearr_22782_22808[(2)] = null);

(statearr_22782_22808[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22775 === (3))){
var inst_22771 = (state_22774[(2)]);
var inst_22772 = cljs.core.async.close_BANG_.call(null,out);
var state_22774__$1 = (function (){var statearr_22783 = state_22774;
(statearr_22783[(9)] = inst_22771);

return statearr_22783;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22774__$1,inst_22772);
} else {
if((state_val_22775 === (2))){
var state_22774__$1 = state_22774;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22774__$1,(4),ch);
} else {
if((state_val_22775 === (11))){
var inst_22754 = (state_22774[(8)]);
var inst_22763 = (state_22774[(2)]);
var inst_22751 = inst_22754;
var state_22774__$1 = (function (){var statearr_22784 = state_22774;
(statearr_22784[(10)] = inst_22763);

(statearr_22784[(7)] = inst_22751);

return statearr_22784;
})();
var statearr_22785_22809 = state_22774__$1;
(statearr_22785_22809[(2)] = null);

(statearr_22785_22809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22775 === (9))){
var inst_22754 = (state_22774[(8)]);
var state_22774__$1 = state_22774;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22774__$1,(11),out,inst_22754);
} else {
if((state_val_22775 === (5))){
var inst_22754 = (state_22774[(8)]);
var inst_22751 = (state_22774[(7)]);
var inst_22758 = cljs.core._EQ_.call(null,inst_22754,inst_22751);
var state_22774__$1 = state_22774;
if(inst_22758){
var statearr_22787_22810 = state_22774__$1;
(statearr_22787_22810[(1)] = (8));

} else {
var statearr_22788_22811 = state_22774__$1;
(statearr_22788_22811[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22775 === (10))){
var inst_22766 = (state_22774[(2)]);
var state_22774__$1 = state_22774;
var statearr_22789_22812 = state_22774__$1;
(statearr_22789_22812[(2)] = inst_22766);

(statearr_22789_22812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22775 === (8))){
var inst_22751 = (state_22774[(7)]);
var tmp22786 = inst_22751;
var inst_22751__$1 = tmp22786;
var state_22774__$1 = (function (){var statearr_22790 = state_22774;
(statearr_22790[(7)] = inst_22751__$1);

return statearr_22790;
})();
var statearr_22791_22813 = state_22774__$1;
(statearr_22791_22813[(2)] = null);

(statearr_22791_22813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___22803,out))
;
return ((function (switch__10483__auto__,c__10595__auto___22803,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_22795 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22795[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_22795[(1)] = (1));

return statearr_22795;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_22774){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22774);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22796){if((e22796 instanceof Object)){
var ex__10487__auto__ = e22796;
var statearr_22797_22814 = state_22774;
(statearr_22797_22814[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22774);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22796;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22815 = state_22774;
state_22774 = G__22815;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_22774){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_22774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___22803,out))
})();
var state__10597__auto__ = (function (){var statearr_22798 = f__10596__auto__.call(null);
(statearr_22798[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___22803);

return statearr_22798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___22803,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args22816 = [];
var len__7484__auto___22886 = arguments.length;
var i__7485__auto___22887 = (0);
while(true){
if((i__7485__auto___22887 < len__7484__auto___22886)){
args22816.push((arguments[i__7485__auto___22887]));

var G__22888 = (i__7485__auto___22887 + (1));
i__7485__auto___22887 = G__22888;
continue;
} else {
}
break;
}

var G__22818 = args22816.length;
switch (G__22818) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22816.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___22890 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___22890,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___22890,out){
return (function (state_22856){
var state_val_22857 = (state_22856[(1)]);
if((state_val_22857 === (7))){
var inst_22852 = (state_22856[(2)]);
var state_22856__$1 = state_22856;
var statearr_22858_22891 = state_22856__$1;
(statearr_22858_22891[(2)] = inst_22852);

(statearr_22858_22891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (1))){
var inst_22819 = (new Array(n));
var inst_22820 = inst_22819;
var inst_22821 = (0);
var state_22856__$1 = (function (){var statearr_22859 = state_22856;
(statearr_22859[(7)] = inst_22821);

(statearr_22859[(8)] = inst_22820);

return statearr_22859;
})();
var statearr_22860_22892 = state_22856__$1;
(statearr_22860_22892[(2)] = null);

(statearr_22860_22892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (4))){
var inst_22824 = (state_22856[(9)]);
var inst_22824__$1 = (state_22856[(2)]);
var inst_22825 = (inst_22824__$1 == null);
var inst_22826 = cljs.core.not.call(null,inst_22825);
var state_22856__$1 = (function (){var statearr_22861 = state_22856;
(statearr_22861[(9)] = inst_22824__$1);

return statearr_22861;
})();
if(inst_22826){
var statearr_22862_22893 = state_22856__$1;
(statearr_22862_22893[(1)] = (5));

} else {
var statearr_22863_22894 = state_22856__$1;
(statearr_22863_22894[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (15))){
var inst_22846 = (state_22856[(2)]);
var state_22856__$1 = state_22856;
var statearr_22864_22895 = state_22856__$1;
(statearr_22864_22895[(2)] = inst_22846);

(statearr_22864_22895[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (13))){
var state_22856__$1 = state_22856;
var statearr_22865_22896 = state_22856__$1;
(statearr_22865_22896[(2)] = null);

(statearr_22865_22896[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (6))){
var inst_22821 = (state_22856[(7)]);
var inst_22842 = (inst_22821 > (0));
var state_22856__$1 = state_22856;
if(cljs.core.truth_(inst_22842)){
var statearr_22866_22897 = state_22856__$1;
(statearr_22866_22897[(1)] = (12));

} else {
var statearr_22867_22898 = state_22856__$1;
(statearr_22867_22898[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (3))){
var inst_22854 = (state_22856[(2)]);
var state_22856__$1 = state_22856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22856__$1,inst_22854);
} else {
if((state_val_22857 === (12))){
var inst_22820 = (state_22856[(8)]);
var inst_22844 = cljs.core.vec.call(null,inst_22820);
var state_22856__$1 = state_22856;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22856__$1,(15),out,inst_22844);
} else {
if((state_val_22857 === (2))){
var state_22856__$1 = state_22856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22856__$1,(4),ch);
} else {
if((state_val_22857 === (11))){
var inst_22836 = (state_22856[(2)]);
var inst_22837 = (new Array(n));
var inst_22820 = inst_22837;
var inst_22821 = (0);
var state_22856__$1 = (function (){var statearr_22868 = state_22856;
(statearr_22868[(10)] = inst_22836);

(statearr_22868[(7)] = inst_22821);

(statearr_22868[(8)] = inst_22820);

return statearr_22868;
})();
var statearr_22869_22899 = state_22856__$1;
(statearr_22869_22899[(2)] = null);

(statearr_22869_22899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (9))){
var inst_22820 = (state_22856[(8)]);
var inst_22834 = cljs.core.vec.call(null,inst_22820);
var state_22856__$1 = state_22856;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22856__$1,(11),out,inst_22834);
} else {
if((state_val_22857 === (5))){
var inst_22824 = (state_22856[(9)]);
var inst_22821 = (state_22856[(7)]);
var inst_22829 = (state_22856[(11)]);
var inst_22820 = (state_22856[(8)]);
var inst_22828 = (inst_22820[inst_22821] = inst_22824);
var inst_22829__$1 = (inst_22821 + (1));
var inst_22830 = (inst_22829__$1 < n);
var state_22856__$1 = (function (){var statearr_22870 = state_22856;
(statearr_22870[(12)] = inst_22828);

(statearr_22870[(11)] = inst_22829__$1);

return statearr_22870;
})();
if(cljs.core.truth_(inst_22830)){
var statearr_22871_22900 = state_22856__$1;
(statearr_22871_22900[(1)] = (8));

} else {
var statearr_22872_22901 = state_22856__$1;
(statearr_22872_22901[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (14))){
var inst_22849 = (state_22856[(2)]);
var inst_22850 = cljs.core.async.close_BANG_.call(null,out);
var state_22856__$1 = (function (){var statearr_22874 = state_22856;
(statearr_22874[(13)] = inst_22849);

return statearr_22874;
})();
var statearr_22875_22902 = state_22856__$1;
(statearr_22875_22902[(2)] = inst_22850);

(statearr_22875_22902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (10))){
var inst_22840 = (state_22856[(2)]);
var state_22856__$1 = state_22856;
var statearr_22876_22903 = state_22856__$1;
(statearr_22876_22903[(2)] = inst_22840);

(statearr_22876_22903[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22857 === (8))){
var inst_22829 = (state_22856[(11)]);
var inst_22820 = (state_22856[(8)]);
var tmp22873 = inst_22820;
var inst_22820__$1 = tmp22873;
var inst_22821 = inst_22829;
var state_22856__$1 = (function (){var statearr_22877 = state_22856;
(statearr_22877[(7)] = inst_22821);

(statearr_22877[(8)] = inst_22820__$1);

return statearr_22877;
})();
var statearr_22878_22904 = state_22856__$1;
(statearr_22878_22904[(2)] = null);

(statearr_22878_22904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___22890,out))
;
return ((function (switch__10483__auto__,c__10595__auto___22890,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_22882 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22882[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_22882[(1)] = (1));

return statearr_22882;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_22856){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22883){if((e22883 instanceof Object)){
var ex__10487__auto__ = e22883;
var statearr_22884_22905 = state_22856;
(statearr_22884_22905[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22856);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22883;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22906 = state_22856;
state_22856 = G__22906;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_22856){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_22856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___22890,out))
})();
var state__10597__auto__ = (function (){var statearr_22885 = f__10596__auto__.call(null);
(statearr_22885[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___22890);

return statearr_22885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___22890,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args22907 = [];
var len__7484__auto___22981 = arguments.length;
var i__7485__auto___22982 = (0);
while(true){
if((i__7485__auto___22982 < len__7484__auto___22981)){
args22907.push((arguments[i__7485__auto___22982]));

var G__22983 = (i__7485__auto___22982 + (1));
i__7485__auto___22982 = G__22983;
continue;
} else {
}
break;
}

var G__22909 = args22907.length;
switch (G__22909) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22907.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___22985 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___22985,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___22985,out){
return (function (state_22951){
var state_val_22952 = (state_22951[(1)]);
if((state_val_22952 === (7))){
var inst_22947 = (state_22951[(2)]);
var state_22951__$1 = state_22951;
var statearr_22953_22986 = state_22951__$1;
(statearr_22953_22986[(2)] = inst_22947);

(statearr_22953_22986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (1))){
var inst_22910 = [];
var inst_22911 = inst_22910;
var inst_22912 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_22951__$1 = (function (){var statearr_22954 = state_22951;
(statearr_22954[(7)] = inst_22912);

(statearr_22954[(8)] = inst_22911);

return statearr_22954;
})();
var statearr_22955_22987 = state_22951__$1;
(statearr_22955_22987[(2)] = null);

(statearr_22955_22987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (4))){
var inst_22915 = (state_22951[(9)]);
var inst_22915__$1 = (state_22951[(2)]);
var inst_22916 = (inst_22915__$1 == null);
var inst_22917 = cljs.core.not.call(null,inst_22916);
var state_22951__$1 = (function (){var statearr_22956 = state_22951;
(statearr_22956[(9)] = inst_22915__$1);

return statearr_22956;
})();
if(inst_22917){
var statearr_22957_22988 = state_22951__$1;
(statearr_22957_22988[(1)] = (5));

} else {
var statearr_22958_22989 = state_22951__$1;
(statearr_22958_22989[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (15))){
var inst_22941 = (state_22951[(2)]);
var state_22951__$1 = state_22951;
var statearr_22959_22990 = state_22951__$1;
(statearr_22959_22990[(2)] = inst_22941);

(statearr_22959_22990[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (13))){
var state_22951__$1 = state_22951;
var statearr_22960_22991 = state_22951__$1;
(statearr_22960_22991[(2)] = null);

(statearr_22960_22991[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (6))){
var inst_22911 = (state_22951[(8)]);
var inst_22936 = inst_22911.length;
var inst_22937 = (inst_22936 > (0));
var state_22951__$1 = state_22951;
if(cljs.core.truth_(inst_22937)){
var statearr_22961_22992 = state_22951__$1;
(statearr_22961_22992[(1)] = (12));

} else {
var statearr_22962_22993 = state_22951__$1;
(statearr_22962_22993[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (3))){
var inst_22949 = (state_22951[(2)]);
var state_22951__$1 = state_22951;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22951__$1,inst_22949);
} else {
if((state_val_22952 === (12))){
var inst_22911 = (state_22951[(8)]);
var inst_22939 = cljs.core.vec.call(null,inst_22911);
var state_22951__$1 = state_22951;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22951__$1,(15),out,inst_22939);
} else {
if((state_val_22952 === (2))){
var state_22951__$1 = state_22951;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22951__$1,(4),ch);
} else {
if((state_val_22952 === (11))){
var inst_22919 = (state_22951[(10)]);
var inst_22915 = (state_22951[(9)]);
var inst_22929 = (state_22951[(2)]);
var inst_22930 = [];
var inst_22931 = inst_22930.push(inst_22915);
var inst_22911 = inst_22930;
var inst_22912 = inst_22919;
var state_22951__$1 = (function (){var statearr_22963 = state_22951;
(statearr_22963[(7)] = inst_22912);

(statearr_22963[(11)] = inst_22929);

(statearr_22963[(12)] = inst_22931);

(statearr_22963[(8)] = inst_22911);

return statearr_22963;
})();
var statearr_22964_22994 = state_22951__$1;
(statearr_22964_22994[(2)] = null);

(statearr_22964_22994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (9))){
var inst_22911 = (state_22951[(8)]);
var inst_22927 = cljs.core.vec.call(null,inst_22911);
var state_22951__$1 = state_22951;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22951__$1,(11),out,inst_22927);
} else {
if((state_val_22952 === (5))){
var inst_22912 = (state_22951[(7)]);
var inst_22919 = (state_22951[(10)]);
var inst_22915 = (state_22951[(9)]);
var inst_22919__$1 = f.call(null,inst_22915);
var inst_22920 = cljs.core._EQ_.call(null,inst_22919__$1,inst_22912);
var inst_22921 = cljs.core.keyword_identical_QMARK_.call(null,inst_22912,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_22922 = (inst_22920) || (inst_22921);
var state_22951__$1 = (function (){var statearr_22965 = state_22951;
(statearr_22965[(10)] = inst_22919__$1);

return statearr_22965;
})();
if(cljs.core.truth_(inst_22922)){
var statearr_22966_22995 = state_22951__$1;
(statearr_22966_22995[(1)] = (8));

} else {
var statearr_22967_22996 = state_22951__$1;
(statearr_22967_22996[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (14))){
var inst_22944 = (state_22951[(2)]);
var inst_22945 = cljs.core.async.close_BANG_.call(null,out);
var state_22951__$1 = (function (){var statearr_22969 = state_22951;
(statearr_22969[(13)] = inst_22944);

return statearr_22969;
})();
var statearr_22970_22997 = state_22951__$1;
(statearr_22970_22997[(2)] = inst_22945);

(statearr_22970_22997[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (10))){
var inst_22934 = (state_22951[(2)]);
var state_22951__$1 = state_22951;
var statearr_22971_22998 = state_22951__$1;
(statearr_22971_22998[(2)] = inst_22934);

(statearr_22971_22998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22952 === (8))){
var inst_22919 = (state_22951[(10)]);
var inst_22915 = (state_22951[(9)]);
var inst_22911 = (state_22951[(8)]);
var inst_22924 = inst_22911.push(inst_22915);
var tmp22968 = inst_22911;
var inst_22911__$1 = tmp22968;
var inst_22912 = inst_22919;
var state_22951__$1 = (function (){var statearr_22972 = state_22951;
(statearr_22972[(7)] = inst_22912);

(statearr_22972[(14)] = inst_22924);

(statearr_22972[(8)] = inst_22911__$1);

return statearr_22972;
})();
var statearr_22973_22999 = state_22951__$1;
(statearr_22973_22999[(2)] = null);

(statearr_22973_22999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___22985,out))
;
return ((function (switch__10483__auto__,c__10595__auto___22985,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_22977 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22977[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_22977[(1)] = (1));

return statearr_22977;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_22951){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_22951);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e22978){if((e22978 instanceof Object)){
var ex__10487__auto__ = e22978;
var statearr_22979_23000 = state_22951;
(statearr_22979_23000[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22951);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22978;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23001 = state_22951;
state_22951 = G__23001;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_22951){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_22951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___22985,out))
})();
var state__10597__auto__ = (function (){var statearr_22980 = f__10596__auto__.call(null);
(statearr_22980[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___22985);

return statearr_22980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___22985,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1476624447015