// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__23137__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__23134 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__23135 = cljs.core.seq.call(null,vec__23134);
var first__23136 = cljs.core.first.call(null,seq__23135);
var seq__23135__$1 = cljs.core.next.call(null,seq__23135);
var tag = first__23136;
var body = seq__23135__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__23137 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23138__i = 0, G__23138__a = new Array(arguments.length -  0);
while (G__23138__i < G__23138__a.length) {G__23138__a[G__23138__i] = arguments[G__23138__i + 0]; ++G__23138__i;}
  args = new cljs.core.IndexedSeq(G__23138__a,0);
} 
return G__23137__delegate.call(this,args);};
G__23137.cljs$lang$maxFixedArity = 0;
G__23137.cljs$lang$applyTo = (function (arglist__23139){
var args = cljs.core.seq(arglist__23139);
return G__23137__delegate(args);
});
G__23137.cljs$core$IFn$_invoke$arity$variadic = G__23137__delegate;
return G__23137;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__23144(s__23145){
return (new cljs.core.LazySeq(null,(function (){
var s__23145__$1 = s__23145;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23145__$1);
if(temp__4657__auto__){
var s__23145__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23145__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23145__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23147 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23146 = (0);
while(true){
if((i__23146 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__23146);
cljs.core.chunk_append.call(null,b__23147,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__23148 = (i__23146 + (1));
i__23146 = G__23148;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23147),sablono$core$update_arglists_$_iter__23144.call(null,cljs.core.chunk_rest.call(null,s__23145__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23147),null);
}
} else {
var args = cljs.core.first.call(null,s__23145__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__23144.call(null,cljs.core.rest.call(null,s__23145__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___23154 = arguments.length;
var i__7485__auto___23155 = (0);
while(true){
if((i__7485__auto___23155 < len__7484__auto___23154)){
args__7491__auto__.push((arguments[i__7485__auto___23155]));

var G__23156 = (i__7485__auto___23155 + (1));
i__7485__auto___23155 = G__23156;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__23150(s__23151){
return (new cljs.core.LazySeq(null,(function (){
var s__23151__$1 = s__23151;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23151__$1);
if(temp__4657__auto__){
var s__23151__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23151__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23151__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23153 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23152 = (0);
while(true){
if((i__23152 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__23152);
cljs.core.chunk_append.call(null,b__23153,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__23157 = (i__23152 + (1));
i__23152 = G__23157;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23153),sablono$core$iter__23150.call(null,cljs.core.chunk_rest.call(null,s__23151__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23153),null);
}
} else {
var style = cljs.core.first.call(null,s__23151__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__23150.call(null,cljs.core.rest.call(null,s__23151__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq23149){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23149));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to23158 = (function sablono$core$link_to23158(var_args){
var args__7491__auto__ = [];
var len__7484__auto___23161 = arguments.length;
var i__7485__auto___23162 = (0);
while(true){
if((i__7485__auto___23162 < len__7484__auto___23161)){
args__7491__auto__.push((arguments[i__7485__auto___23162]));

var G__23163 = (i__7485__auto___23162 + (1));
i__7485__auto___23162 = G__23163;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to23158.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to23158.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to23158.cljs$lang$maxFixedArity = (1);

sablono.core.link_to23158.cljs$lang$applyTo = (function (seq23159){
var G__23160 = cljs.core.first.call(null,seq23159);
var seq23159__$1 = cljs.core.next.call(null,seq23159);
return sablono.core.link_to23158.cljs$core$IFn$_invoke$arity$variadic(G__23160,seq23159__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to23158);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to23164 = (function sablono$core$mail_to23164(var_args){
var args__7491__auto__ = [];
var len__7484__auto___23171 = arguments.length;
var i__7485__auto___23172 = (0);
while(true){
if((i__7485__auto___23172 < len__7484__auto___23171)){
args__7491__auto__.push((arguments[i__7485__auto___23172]));

var G__23173 = (i__7485__auto___23172 + (1));
i__7485__auto___23172 = G__23173;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to23164.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to23164.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__23167){
var vec__23168 = p__23167;
var content = cljs.core.nth.call(null,vec__23168,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to23164.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to23164.cljs$lang$applyTo = (function (seq23165){
var G__23166 = cljs.core.first.call(null,seq23165);
var seq23165__$1 = cljs.core.next.call(null,seq23165);
return sablono.core.mail_to23164.cljs$core$IFn$_invoke$arity$variadic(G__23166,seq23165__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to23164);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list23174 = (function sablono$core$unordered_list23174(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list23174_$_iter__23179(s__23180){
return (new cljs.core.LazySeq(null,(function (){
var s__23180__$1 = s__23180;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23180__$1);
if(temp__4657__auto__){
var s__23180__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23180__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23180__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23182 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23181 = (0);
while(true){
if((i__23181 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__23181);
cljs.core.chunk_append.call(null,b__23182,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__23183 = (i__23181 + (1));
i__23181 = G__23183;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23182),sablono$core$unordered_list23174_$_iter__23179.call(null,cljs.core.chunk_rest.call(null,s__23180__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23182),null);
}
} else {
var x = cljs.core.first.call(null,s__23180__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list23174_$_iter__23179.call(null,cljs.core.rest.call(null,s__23180__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list23174);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list23184 = (function sablono$core$ordered_list23184(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list23184_$_iter__23189(s__23190){
return (new cljs.core.LazySeq(null,(function (){
var s__23190__$1 = s__23190;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23190__$1);
if(temp__4657__auto__){
var s__23190__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23190__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23190__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23192 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23191 = (0);
while(true){
if((i__23191 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__23191);
cljs.core.chunk_append.call(null,b__23192,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__23193 = (i__23191 + (1));
i__23191 = G__23193;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23192),sablono$core$ordered_list23184_$_iter__23189.call(null,cljs.core.chunk_rest.call(null,s__23190__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23192),null);
}
} else {
var x = cljs.core.first.call(null,s__23190__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list23184_$_iter__23189.call(null,cljs.core.rest.call(null,s__23190__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list23184);
/**
 * Create an image element.
 */
sablono.core.image23194 = (function sablono$core$image23194(var_args){
var args23195 = [];
var len__7484__auto___23198 = arguments.length;
var i__7485__auto___23199 = (0);
while(true){
if((i__7485__auto___23199 < len__7484__auto___23198)){
args23195.push((arguments[i__7485__auto___23199]));

var G__23200 = (i__7485__auto___23199 + (1));
i__7485__auto___23199 = G__23200;
continue;
} else {
}
break;
}

var G__23197 = args23195.length;
switch (G__23197) {
case 1:
return sablono.core.image23194.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image23194.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23195.length)].join('')));

}
});

sablono.core.image23194.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image23194.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image23194.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image23194);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__23202_SHARP_,p2__23203_SHARP_){
return [cljs.core.str(p1__23202_SHARP_),cljs.core.str("["),cljs.core.str(p2__23203_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__23204_SHARP_,p2__23205_SHARP_){
return [cljs.core.str(p1__23204_SHARP_),cljs.core.str("-"),cljs.core.str(p2__23205_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field23206 = (function sablono$core$color_field23206(var_args){
var args23207 = [];
var len__7484__auto___23274 = arguments.length;
var i__7485__auto___23275 = (0);
while(true){
if((i__7485__auto___23275 < len__7484__auto___23274)){
args23207.push((arguments[i__7485__auto___23275]));

var G__23276 = (i__7485__auto___23275 + (1));
i__7485__auto___23275 = G__23276;
continue;
} else {
}
break;
}

var G__23209 = args23207.length;
switch (G__23209) {
case 1:
return sablono.core.color_field23206.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field23206.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23207.length)].join('')));

}
});

sablono.core.color_field23206.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.color_field23206.call(null,name__13936__auto__,null);
});

sablono.core.color_field23206.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.color_field23206.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field23206);

/**
 * Creates a date input field.
 */
sablono.core.date_field23210 = (function sablono$core$date_field23210(var_args){
var args23211 = [];
var len__7484__auto___23278 = arguments.length;
var i__7485__auto___23279 = (0);
while(true){
if((i__7485__auto___23279 < len__7484__auto___23278)){
args23211.push((arguments[i__7485__auto___23279]));

var G__23280 = (i__7485__auto___23279 + (1));
i__7485__auto___23279 = G__23280;
continue;
} else {
}
break;
}

var G__23213 = args23211.length;
switch (G__23213) {
case 1:
return sablono.core.date_field23210.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field23210.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23211.length)].join('')));

}
});

sablono.core.date_field23210.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.date_field23210.call(null,name__13936__auto__,null);
});

sablono.core.date_field23210.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.date_field23210.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field23210);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field23214 = (function sablono$core$datetime_field23214(var_args){
var args23215 = [];
var len__7484__auto___23282 = arguments.length;
var i__7485__auto___23283 = (0);
while(true){
if((i__7485__auto___23283 < len__7484__auto___23282)){
args23215.push((arguments[i__7485__auto___23283]));

var G__23284 = (i__7485__auto___23283 + (1));
i__7485__auto___23283 = G__23284;
continue;
} else {
}
break;
}

var G__23217 = args23215.length;
switch (G__23217) {
case 1:
return sablono.core.datetime_field23214.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field23214.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23215.length)].join('')));

}
});

sablono.core.datetime_field23214.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.datetime_field23214.call(null,name__13936__auto__,null);
});

sablono.core.datetime_field23214.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.datetime_field23214.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field23214);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field23218 = (function sablono$core$datetime_local_field23218(var_args){
var args23219 = [];
var len__7484__auto___23286 = arguments.length;
var i__7485__auto___23287 = (0);
while(true){
if((i__7485__auto___23287 < len__7484__auto___23286)){
args23219.push((arguments[i__7485__auto___23287]));

var G__23288 = (i__7485__auto___23287 + (1));
i__7485__auto___23287 = G__23288;
continue;
} else {
}
break;
}

var G__23221 = args23219.length;
switch (G__23221) {
case 1:
return sablono.core.datetime_local_field23218.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field23218.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23219.length)].join('')));

}
});

sablono.core.datetime_local_field23218.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.datetime_local_field23218.call(null,name__13936__auto__,null);
});

sablono.core.datetime_local_field23218.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.datetime_local_field23218.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field23218);

/**
 * Creates a email input field.
 */
sablono.core.email_field23222 = (function sablono$core$email_field23222(var_args){
var args23223 = [];
var len__7484__auto___23290 = arguments.length;
var i__7485__auto___23291 = (0);
while(true){
if((i__7485__auto___23291 < len__7484__auto___23290)){
args23223.push((arguments[i__7485__auto___23291]));

var G__23292 = (i__7485__auto___23291 + (1));
i__7485__auto___23291 = G__23292;
continue;
} else {
}
break;
}

var G__23225 = args23223.length;
switch (G__23225) {
case 1:
return sablono.core.email_field23222.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field23222.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23223.length)].join('')));

}
});

sablono.core.email_field23222.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.email_field23222.call(null,name__13936__auto__,null);
});

sablono.core.email_field23222.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.email_field23222.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field23222);

/**
 * Creates a file input field.
 */
sablono.core.file_field23226 = (function sablono$core$file_field23226(var_args){
var args23227 = [];
var len__7484__auto___23294 = arguments.length;
var i__7485__auto___23295 = (0);
while(true){
if((i__7485__auto___23295 < len__7484__auto___23294)){
args23227.push((arguments[i__7485__auto___23295]));

var G__23296 = (i__7485__auto___23295 + (1));
i__7485__auto___23295 = G__23296;
continue;
} else {
}
break;
}

var G__23229 = args23227.length;
switch (G__23229) {
case 1:
return sablono.core.file_field23226.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field23226.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23227.length)].join('')));

}
});

sablono.core.file_field23226.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.file_field23226.call(null,name__13936__auto__,null);
});

sablono.core.file_field23226.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.file_field23226.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field23226);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field23230 = (function sablono$core$hidden_field23230(var_args){
var args23231 = [];
var len__7484__auto___23298 = arguments.length;
var i__7485__auto___23299 = (0);
while(true){
if((i__7485__auto___23299 < len__7484__auto___23298)){
args23231.push((arguments[i__7485__auto___23299]));

var G__23300 = (i__7485__auto___23299 + (1));
i__7485__auto___23299 = G__23300;
continue;
} else {
}
break;
}

var G__23233 = args23231.length;
switch (G__23233) {
case 1:
return sablono.core.hidden_field23230.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field23230.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23231.length)].join('')));

}
});

sablono.core.hidden_field23230.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.hidden_field23230.call(null,name__13936__auto__,null);
});

sablono.core.hidden_field23230.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.hidden_field23230.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field23230);

/**
 * Creates a month input field.
 */
sablono.core.month_field23234 = (function sablono$core$month_field23234(var_args){
var args23235 = [];
var len__7484__auto___23302 = arguments.length;
var i__7485__auto___23303 = (0);
while(true){
if((i__7485__auto___23303 < len__7484__auto___23302)){
args23235.push((arguments[i__7485__auto___23303]));

var G__23304 = (i__7485__auto___23303 + (1));
i__7485__auto___23303 = G__23304;
continue;
} else {
}
break;
}

var G__23237 = args23235.length;
switch (G__23237) {
case 1:
return sablono.core.month_field23234.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field23234.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23235.length)].join('')));

}
});

sablono.core.month_field23234.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.month_field23234.call(null,name__13936__auto__,null);
});

sablono.core.month_field23234.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.month_field23234.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field23234);

/**
 * Creates a number input field.
 */
sablono.core.number_field23238 = (function sablono$core$number_field23238(var_args){
var args23239 = [];
var len__7484__auto___23306 = arguments.length;
var i__7485__auto___23307 = (0);
while(true){
if((i__7485__auto___23307 < len__7484__auto___23306)){
args23239.push((arguments[i__7485__auto___23307]));

var G__23308 = (i__7485__auto___23307 + (1));
i__7485__auto___23307 = G__23308;
continue;
} else {
}
break;
}

var G__23241 = args23239.length;
switch (G__23241) {
case 1:
return sablono.core.number_field23238.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field23238.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23239.length)].join('')));

}
});

sablono.core.number_field23238.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.number_field23238.call(null,name__13936__auto__,null);
});

sablono.core.number_field23238.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.number_field23238.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field23238);

/**
 * Creates a password input field.
 */
sablono.core.password_field23242 = (function sablono$core$password_field23242(var_args){
var args23243 = [];
var len__7484__auto___23310 = arguments.length;
var i__7485__auto___23311 = (0);
while(true){
if((i__7485__auto___23311 < len__7484__auto___23310)){
args23243.push((arguments[i__7485__auto___23311]));

var G__23312 = (i__7485__auto___23311 + (1));
i__7485__auto___23311 = G__23312;
continue;
} else {
}
break;
}

var G__23245 = args23243.length;
switch (G__23245) {
case 1:
return sablono.core.password_field23242.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field23242.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23243.length)].join('')));

}
});

sablono.core.password_field23242.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.password_field23242.call(null,name__13936__auto__,null);
});

sablono.core.password_field23242.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.password_field23242.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field23242);

/**
 * Creates a range input field.
 */
sablono.core.range_field23246 = (function sablono$core$range_field23246(var_args){
var args23247 = [];
var len__7484__auto___23314 = arguments.length;
var i__7485__auto___23315 = (0);
while(true){
if((i__7485__auto___23315 < len__7484__auto___23314)){
args23247.push((arguments[i__7485__auto___23315]));

var G__23316 = (i__7485__auto___23315 + (1));
i__7485__auto___23315 = G__23316;
continue;
} else {
}
break;
}

var G__23249 = args23247.length;
switch (G__23249) {
case 1:
return sablono.core.range_field23246.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field23246.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23247.length)].join('')));

}
});

sablono.core.range_field23246.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.range_field23246.call(null,name__13936__auto__,null);
});

sablono.core.range_field23246.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.range_field23246.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field23246);

/**
 * Creates a search input field.
 */
sablono.core.search_field23250 = (function sablono$core$search_field23250(var_args){
var args23251 = [];
var len__7484__auto___23318 = arguments.length;
var i__7485__auto___23319 = (0);
while(true){
if((i__7485__auto___23319 < len__7484__auto___23318)){
args23251.push((arguments[i__7485__auto___23319]));

var G__23320 = (i__7485__auto___23319 + (1));
i__7485__auto___23319 = G__23320;
continue;
} else {
}
break;
}

var G__23253 = args23251.length;
switch (G__23253) {
case 1:
return sablono.core.search_field23250.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field23250.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23251.length)].join('')));

}
});

sablono.core.search_field23250.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.search_field23250.call(null,name__13936__auto__,null);
});

sablono.core.search_field23250.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.search_field23250.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field23250);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field23254 = (function sablono$core$tel_field23254(var_args){
var args23255 = [];
var len__7484__auto___23322 = arguments.length;
var i__7485__auto___23323 = (0);
while(true){
if((i__7485__auto___23323 < len__7484__auto___23322)){
args23255.push((arguments[i__7485__auto___23323]));

var G__23324 = (i__7485__auto___23323 + (1));
i__7485__auto___23323 = G__23324;
continue;
} else {
}
break;
}

var G__23257 = args23255.length;
switch (G__23257) {
case 1:
return sablono.core.tel_field23254.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field23254.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23255.length)].join('')));

}
});

sablono.core.tel_field23254.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.tel_field23254.call(null,name__13936__auto__,null);
});

sablono.core.tel_field23254.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.tel_field23254.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field23254);

/**
 * Creates a text input field.
 */
sablono.core.text_field23258 = (function sablono$core$text_field23258(var_args){
var args23259 = [];
var len__7484__auto___23326 = arguments.length;
var i__7485__auto___23327 = (0);
while(true){
if((i__7485__auto___23327 < len__7484__auto___23326)){
args23259.push((arguments[i__7485__auto___23327]));

var G__23328 = (i__7485__auto___23327 + (1));
i__7485__auto___23327 = G__23328;
continue;
} else {
}
break;
}

var G__23261 = args23259.length;
switch (G__23261) {
case 1:
return sablono.core.text_field23258.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field23258.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23259.length)].join('')));

}
});

sablono.core.text_field23258.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.text_field23258.call(null,name__13936__auto__,null);
});

sablono.core.text_field23258.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.text_field23258.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field23258);

/**
 * Creates a time input field.
 */
sablono.core.time_field23262 = (function sablono$core$time_field23262(var_args){
var args23263 = [];
var len__7484__auto___23330 = arguments.length;
var i__7485__auto___23331 = (0);
while(true){
if((i__7485__auto___23331 < len__7484__auto___23330)){
args23263.push((arguments[i__7485__auto___23331]));

var G__23332 = (i__7485__auto___23331 + (1));
i__7485__auto___23331 = G__23332;
continue;
} else {
}
break;
}

var G__23265 = args23263.length;
switch (G__23265) {
case 1:
return sablono.core.time_field23262.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field23262.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23263.length)].join('')));

}
});

sablono.core.time_field23262.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.time_field23262.call(null,name__13936__auto__,null);
});

sablono.core.time_field23262.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.time_field23262.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field23262);

/**
 * Creates a url input field.
 */
sablono.core.url_field23266 = (function sablono$core$url_field23266(var_args){
var args23267 = [];
var len__7484__auto___23334 = arguments.length;
var i__7485__auto___23335 = (0);
while(true){
if((i__7485__auto___23335 < len__7484__auto___23334)){
args23267.push((arguments[i__7485__auto___23335]));

var G__23336 = (i__7485__auto___23335 + (1));
i__7485__auto___23335 = G__23336;
continue;
} else {
}
break;
}

var G__23269 = args23267.length;
switch (G__23269) {
case 1:
return sablono.core.url_field23266.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field23266.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23267.length)].join('')));

}
});

sablono.core.url_field23266.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.url_field23266.call(null,name__13936__auto__,null);
});

sablono.core.url_field23266.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.url_field23266.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field23266);

/**
 * Creates a week input field.
 */
sablono.core.week_field23270 = (function sablono$core$week_field23270(var_args){
var args23271 = [];
var len__7484__auto___23338 = arguments.length;
var i__7485__auto___23339 = (0);
while(true){
if((i__7485__auto___23339 < len__7484__auto___23338)){
args23271.push((arguments[i__7485__auto___23339]));

var G__23340 = (i__7485__auto___23339 + (1));
i__7485__auto___23339 = G__23340;
continue;
} else {
}
break;
}

var G__23273 = args23271.length;
switch (G__23273) {
case 1:
return sablono.core.week_field23270.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field23270.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23271.length)].join('')));

}
});

sablono.core.week_field23270.cljs$core$IFn$_invoke$arity$1 = (function (name__13936__auto__){
return sablono.core.week_field23270.call(null,name__13936__auto__,null);
});

sablono.core.week_field23270.cljs$core$IFn$_invoke$arity$2 = (function (name__13936__auto__,value__13937__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__13936__auto__,value__13937__auto__);
});

sablono.core.week_field23270.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field23270);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box23342 = (function sablono$core$check_box23342(var_args){
var args23343 = [];
var len__7484__auto___23346 = arguments.length;
var i__7485__auto___23347 = (0);
while(true){
if((i__7485__auto___23347 < len__7484__auto___23346)){
args23343.push((arguments[i__7485__auto___23347]));

var G__23348 = (i__7485__auto___23347 + (1));
i__7485__auto___23347 = G__23348;
continue;
} else {
}
break;
}

var G__23345 = args23343.length;
switch (G__23345) {
case 1:
return sablono.core.check_box23342.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box23342.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box23342.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23343.length)].join('')));

}
});

sablono.core.check_box23342.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box23342.call(null,name,null);
});

sablono.core.check_box23342.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box23342.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box23342.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box23342.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box23342);
/**
 * Creates a radio button.
 */
sablono.core.radio_button23350 = (function sablono$core$radio_button23350(var_args){
var args23351 = [];
var len__7484__auto___23354 = arguments.length;
var i__7485__auto___23355 = (0);
while(true){
if((i__7485__auto___23355 < len__7484__auto___23354)){
args23351.push((arguments[i__7485__auto___23355]));

var G__23356 = (i__7485__auto___23355 + (1));
i__7485__auto___23355 = G__23356;
continue;
} else {
}
break;
}

var G__23353 = args23351.length;
switch (G__23353) {
case 1:
return sablono.core.radio_button23350.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button23350.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button23350.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23351.length)].join('')));

}
});

sablono.core.radio_button23350.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button23350.call(null,group,null);
});

sablono.core.radio_button23350.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button23350.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button23350.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button23350.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button23350);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options23358 = (function sablono$core$select_options23358(coll){
var iter__7189__auto__ = (function sablono$core$select_options23358_$_iter__23375(s__23376){
return (new cljs.core.LazySeq(null,(function (){
var s__23376__$1 = s__23376;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23376__$1);
if(temp__4657__auto__){
var s__23376__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23376__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23376__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23378 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23377 = (0);
while(true){
if((i__23377 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__23377);
cljs.core.chunk_append.call(null,b__23378,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__23385 = x;
var text = cljs.core.nth.call(null,vec__23385,(0),null);
var val = cljs.core.nth.call(null,vec__23385,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__23385,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options23358.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__23391 = (i__23377 + (1));
i__23377 = G__23391;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23378),sablono$core$select_options23358_$_iter__23375.call(null,cljs.core.chunk_rest.call(null,s__23376__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23378),null);
}
} else {
var x = cljs.core.first.call(null,s__23376__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__23388 = x;
var text = cljs.core.nth.call(null,vec__23388,(0),null);
var val = cljs.core.nth.call(null,vec__23388,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__23388,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options23358.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options23358_$_iter__23375.call(null,cljs.core.rest.call(null,s__23376__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options23358);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down23392 = (function sablono$core$drop_down23392(var_args){
var args23393 = [];
var len__7484__auto___23396 = arguments.length;
var i__7485__auto___23397 = (0);
while(true){
if((i__7485__auto___23397 < len__7484__auto___23396)){
args23393.push((arguments[i__7485__auto___23397]));

var G__23398 = (i__7485__auto___23397 + (1));
i__7485__auto___23397 = G__23398;
continue;
} else {
}
break;
}

var G__23395 = args23393.length;
switch (G__23395) {
case 2:
return sablono.core.drop_down23392.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down23392.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23393.length)].join('')));

}
});

sablono.core.drop_down23392.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down23392.call(null,name,options,null);
});

sablono.core.drop_down23392.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down23392.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down23392);
/**
 * Creates a text area element.
 */
sablono.core.text_area23400 = (function sablono$core$text_area23400(var_args){
var args23401 = [];
var len__7484__auto___23404 = arguments.length;
var i__7485__auto___23405 = (0);
while(true){
if((i__7485__auto___23405 < len__7484__auto___23404)){
args23401.push((arguments[i__7485__auto___23405]));

var G__23406 = (i__7485__auto___23405 + (1));
i__7485__auto___23405 = G__23406;
continue;
} else {
}
break;
}

var G__23403 = args23401.length;
switch (G__23403) {
case 1:
return sablono.core.text_area23400.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area23400.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23401.length)].join('')));

}
});

sablono.core.text_area23400.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area23400.call(null,name,null);
});

sablono.core.text_area23400.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area23400.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area23400);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label23408 = (function sablono$core$label23408(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label23408);
/**
 * Creates a submit button.
 */
sablono.core.submit_button23409 = (function sablono$core$submit_button23409(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button23409);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button23410 = (function sablono$core$reset_button23410(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button23410);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to23411 = (function sablono$core$form_to23411(var_args){
var args__7491__auto__ = [];
var len__7484__auto___23418 = arguments.length;
var i__7485__auto___23419 = (0);
while(true){
if((i__7485__auto___23419 < len__7484__auto___23418)){
args__7491__auto__.push((arguments[i__7485__auto___23419]));

var G__23420 = (i__7485__auto___23419 + (1));
i__7485__auto___23419 = G__23420;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to23411.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to23411.cljs$core$IFn$_invoke$arity$variadic = (function (p__23414,body){
var vec__23415 = p__23414;
var method = cljs.core.nth.call(null,vec__23415,(0),null);
var action = cljs.core.nth.call(null,vec__23415,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to23411.cljs$lang$maxFixedArity = (1);

sablono.core.form_to23411.cljs$lang$applyTo = (function (seq23412){
var G__23413 = cljs.core.first.call(null,seq23412);
var seq23412__$1 = cljs.core.next.call(null,seq23412);
return sablono.core.form_to23411.cljs$core$IFn$_invoke$arity$variadic(G__23413,seq23412__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to23411);

//# sourceMappingURL=core.js.map?rel=1476624447904