(ns ^:no-doc unReasoner.preprocessing
 (:require [clojure.java.io :as io][clojure.string :as str]
           [unReasoner.model :as mdl]
           [ontology.normalize :as norm][ontology.axioms :as ax][ontology.expressions :as ex][ontology.components :as co]
           [util.msc :as msc]))

(defn unfold [model axiom]
(prn axiom)
 (let [nnf (norm/getNNF axiom)
       csnf (norm/getCSNF axiom)
       dsnf (norm/getDSNF axiom)
       _ (if (seq? nnf)
          (do 
           (msc/strToFile "NNF.txt" (str "Original " axiom "\nNNF      " (str/join "\n         " nnf) "\n"))
           (msc/strToFile "CSNF.txt" (str "Original " axiom "\nCSNF     " (str/join "\n         " csnf) "\n"))
           (msc/strToFile "DSNF.txt" (str "Original " axiom "\nDSNF     " (str/join "\n         " dsnf) "\n")))
          (do 
           (msc/strToFile "NNF.txt" (str "Original " axiom "\nNNF      "  nnf "\n"))
           (msc/strToFile "CSNF.txt" (str "Original " axiom "\nCSNF     "  csnf "\n"))
           (msc/strToFile "DSNF.txt" (str "Original " axiom "\nDSNF     "  dsnf "\n"))))
       ]
 [model axiom]))

(defn process
 ([axioms](reduce process (mdl/init) axioms))
 ([model axiom]
  (let [;_ (println axiom "\n" model)
     [model axiom] (unfold model axiom)]
   model)))
