(ns ^:no-doc unReasoner.model
 (:require [clojure.java.io :as io]
           [unReasoner.boolean :as bool]
           [ontology.core :as ont]
           [util.core :as msc]))

(def ^:no-doc init
  {:classNames #{}
   :roleNames #{}
   :dataRoleNames #{}
   :classAxiomsUnfoldable {}
   :classAxiomsGeneral {} 
   :roleDefinitions {}
   :classHierarchy {ont/Top ont/Bot} 
   :roleHierarchy {ont/TopRole ont/BotRole}
   :facts {}
   :cyclic false
   :satisfiable true
   ; TODO
  })

(defn- updateNames
 [model names]
 model)

(defn- updateClassDefinitions
 [model axiom]
 model)

(defn- unfold
 [model axiom]
 model)

(defn- updateClassHierarchy
 [model]
 model)

(defn- updateRoleHierarchy
 [model]
 model)

(defn updateModel
 ([model axiom](prn axiom)
 (-> model
    (updateNames (ont/getNames axiom))
    (updateClassDefinitions axiom)
    (update :satisfiable (constantly (bool/satExpressions (:classDefinitions model))))
    (unfold axiom)
    updateClassHierarchy
    updateRoleHierarchy
    ))
 ([model axiom & args]
 (-> model
    (updateNames (ont/getNames axiom))
    (updateClassDefinitions axiom)
    (update :satisfiable (constantly (bool/satExpressions (:classDefinitions model))))
    (unfold class)
    updateClassHierarchy
    updateRoleHierarchy
    )))