(ns ^:no-doc unReasoner.preprocessing
 (:require [clojure.java.io :as io][clojure.string :as s]
           [unReasoner.model :as mdl]
           [ontology.normalize :as norm][ontology.core :as ont]
           [util.core :as msc]))

(defn addIndividualToSet 
 [set individual] 
 (if (not set) 
  [#{individual} #{}] 
  (let [[y n] set] [(conj y individual) n])))

(defn preProcess 
 [[ontology model] axiom]
 [(ont/addAxiom ontology axiom) (mdl/updateModel model (norm/getCSNF axiom))])

(defn process
 ([ontology](reduce process [(update ontology :axioms #{}) mdl/init] (ont/getAxioms ontology)))
 ([[ontology model] axiom]
  (case (:innerType axiom)
   :classImplication (preProcess [ontology model] axiom)
   :=classes (preProcess [ontology model] axiom)
   :classFact [(ont/addAxiom ontology axiom) (update-in model [:facts (:class axiom)] addIndividualToSet (:individual axiom))]
   :roleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:role axiom)] addIndividualToSet [(:fromIndividual axiom) (:toIndividual axiom)])]
   )))
