(ns ^:no-doc unReasoner.preprocessing
 (:require [clojure.java.io :as io][clojure.string :as s]
           [unReasoner.model :as mdl]
           [ontology.normalize :as norm][ontology.core :as ont][ontology.axioms :as ax]
           [util.core :as msc]))

(defn addThingToYesSet 
 [set thing] 
 (if (not set) 
  [#{thing} #{}] 
  (let [[y n] set] [(conj y thing) n])))

(defn dropThingFromYesSet 
 [[y n] thing]
 [(disj y thing) n])

(defn addThingToNoSet 
 [set thing]
 (if (not set) 
  [#{} #{thing}] 
  (let [[y n] set] [y (conj n thing)])))

(defn dropThingFromNoSet 
 [[y n] thing]
 [y (disj n thing)])

(defn- unfold
 [model class]
 (if (empty? (:classAxiomsUnfolded model))
  class
 (loop [class class
        classes (ont/getClassNames class)]
        (prn "unfoldStart" (first classes))
  (cond 
   (empty? classes)
    class
   (get (:classAxiomsUnfolded model) (first classes))
    (do (prn "unfolding" model)
    (recur (update class (first classes) #(partial ont/and ((first classes) (:classAxiomsUnfolded model))))(rest classes))
    )
   :else
    (recur class (rest classes))))))

(defn- finishUnfold
 [model class yOrN yOrNFun]
 (loop [definitions (get (get (:classAxiomsUnfolded model) class) yOrN)
        model model]
  (prn definitions model)
  (cond
   (empty? definitions)
    model
   (get (:classAxiomsUnfolded model) (first definitions))
    (recur (rest definitions) (update-in model [:classAxiomsUnfolded class] yOrNFun (first definitions)))
   :else
    (recur (rest definitions) model))))

(defn- unfoldPrimitiveDefinition ;;; TODO refactor into (update ... )s
 [model axiom](prn "primitiveTest" axiom)
 (case (:innerType axiom)
  :=classes (cond 
              (= :className (:innerType (first (:classes axiom))))
                (let [unfolded (unfold model (norm/getCSNF (first (rest (:classes axiom)))))]
                 (update-in (update-in model [:classAxiomsUnfolded (first (:classes axiom))] addThingToYesSet unfolded) [:classAxiomsUnfolded (ont/negate (first (:classes axiom)))] addThingToNoSet (ont/negate unfolded)))
              (= :className (:innerType (first (rest (:classes axiom)))))
               (let [unfolded (unfold model (norm/getCSNF (first (:classes axiom))))]
                (update-in (update-in model [:classAxiomsUnfolded (first (rest (:classes axiom)))] addThingToYesSet unfolded) [:classAxiomsUnfolded (ont/negate (first (rest (:classes axiom))))] addThingToNoSet (ont/negate unfolded)))
              (= :not (:innerType (first (:classes axiom))))
               (if (= (:innerType (:class (first (:classes axiom)))) :className)
                (let [unfolded (unfold model (norm/getCSNF (first (rest (:classes axiom)))))]
                 (update-in (update-in model [:classAxiomsUnfolded (first (:classes axiom))] addThingToNoSet unfolded) [:classAxiomsUnfolded (ont/negate (first (:classes axiom)))] addThingToYesSet (ont/negate unfolded))))              
              (= :not (:innerType (first (rest (:classes axiom)))))
               (if (= (:innerType (:class (first (:classes axiom)))) :className) 
                (let [unfolded (unfold model (norm/getCSNF (first (:classes axiom))))]
                 (update-in (update-in model [:classAxiomsUnfolded (first (rest (:classes axiom)))] addThingToNoSet unfolded) [:classAxiomsUnfolded (ont/negate (first (rest (:classes axiom))))] addThingToYesSet (ont/negate unfolded))))
              (= :or (:innerType (first (:classes axiom))))
               (loop [classes (:classes (first (:classes axiom)))
                      model model]
                (if (empty? classes)
                 model
                 (if-let [model (unfoldPrimitiveDefinition model (update (disj axiom (first (:classes axiom))) :classes conj (first classes)))] (recur (rest classes) model) nil)))
              :else 
               nil)
  :classImplication (case (:innerType (:antecedent axiom))
                     :className (finishUnfold (update-in model [:classAxiomsUnfolded (:antecedent axiom)] addThingToYesSet (unfold model (norm/getCSNF (:consequent axiom)))) (:antecedent axiom) 0 dropThingFromYesSet)
                     :not (if (= (:innerType (:class (:antecedent axiom))) :className) (finishUnfold  (update-in model [:classAxiomsUnfolded (:class (:antecedent axiom))] addThingToNoSet (unfold model (norm/getCSNF (:consequent axiom)))) (:antecedent axiom) 1 dropThingFromNoSet))
                     :or (loop [classes (:classes (:antecedent axiom))
                                model model]
                          (if (empty? classes)
                           model
                           (if-let [model (unfoldPrimitiveDefinition model (assoc axiom :antecedent (first classes)))] (recur (rest classes) model))))
                     nil)
  nil))

(defn- tryToAbsorb
 "(i) Initialise a set G = {¬D, C}, representing the axiom in the form T ⊑ ¬⊓{¬D, C} (i.e. T ⊑ D ⊔ ¬C).

  (ii) If for some A ∈ G there is a primitive definition axiom (A ⊑ C) ∈ T u , then absorb the general axiom into the primitive definition axiom so that it becomes
        
        A ⊑ ⊓{C, ¬⊓(G \\ {A})},

  and exit.

  (iii) If for some A ∈ G there is an axiom (A ≡ D) ∈ Tu , then substitute A ∈ G with D

       G → {D} ∪ G \\ {A},

  and return to step (ii).

  (iv) If for some ¬A ∈ G there is an axiom (A ≡ D) ∈ Tu , then substitute ¬A ∈ G with ¬D

       G → {¬D} ∪ G \\ {¬A},

  and return to step (ii).

  (v) If there is some C ∈ G such that C is of the form ⊓S, then use associativity to simplify G
      
      G → S ∪ G \\ {⊓S},

  and return to step (ii).

  (vi) If there is some C ∈ G such that C is of the form ¬uS, then for every D ∈ S try to absorb (recursively)
     
     {¬D} ∪ G \\ {¬⊓S},

  and exit.

  (vii) Otherwise, the axiom could not be absorbed, so add ¬⊓G to Tg'

      Tg' → Tg' ∪ ¬⊓G,

  and exit."
 [model axiom](prn "absorbStart" axiom)
 (loop [csnfAxiom (norm/getCSNF axiom)
        classSet (disj (ont/getClasses csnfAxiom) csnfAxiom (:class csnfAxiom))
        Tg (:classAxiomsGeneral model)
        Tu (:classAxiomsUnfolded model)]
  nil)
 model)

(defn- tryToUnfoldOrAbsorbAxiom
 [model axiom]
 (if-let [unfoldedInModel (unfoldPrimitiveDefinition model axiom)] 
  unfoldedInModel 
  (tryToAbsorb model axiom)))

(defn process
 ([ontology]
  (reduce process [(update ontology :axioms #{}) mdl/init] (ont/getAxiomsNoAnnotations ontology)))
 ([ontology model axiom]
  (println axiom "\n" model "\n" );(-> (mdl/updateModelForAxiom model axiom) (tryToUnfoldOrAbsorbAxiom axiom)) "\n")
  [(ont/addAxiom ontology axiom) (-> (mdl/updateModelForAxiom model axiom) (tryToUnfoldOrAbsorbAxiom axiom))])
 ([[ontology model] axiom]
  (case (:innerType axiom)
   
   ;regular class axiom
   :classImplication (process ontology model axiom)

   ;syntactically equivalent to regular class axiom
   :roleDomain (process ontology model (norm/toSyntacticEquivalent axiom))
   :roleRange (process ontology model (norm/toSyntacticEquivalent axiom))
   :functionalRole (process ontology model (norm/toSyntacticEquivalent axiom))
   :functionalInverseRole (process ontology model (norm/toSyntacticEquivalent axiom))
   :reflexiveRole (process ontology model (norm/toSyntacticEquivalent axiom))
   :irreflexiveRole (process ontology model (norm/toSyntacticEquivalent axiom))
   :dataRoleDomain (process ontology model (norm/toSyntacticEquivalent axiom))
   :dataRoleRange (process ontology model (norm/toSyntacticEquivalent axiom))
   :functionalDataRole (process ontology model (norm/toSyntacticEquivalent axiom))

   ;syntactically equivalent to sets of class axioms
   :=classes (let [classes (into [] (:classes axiom))
                   classes (cons (cons (peek classes) (cons (first classes) nil)) (if (> (count classes) 2) (partition 2 1 classes) nil))]
              (loop [parts (for [pair classes](ax/=classes pair));(reduce #(conj %1 (ax/classImplication (first %2) (first (rest %2))) (ax/classImplication (ont/not (first %2)) (ont/not (first (rest %2))))) #{} classes)
                     [ontology model] [ontology model]]
              (if (empty? parts) 
               [ontology model]
               (recur (rest parts) (process ontology model (first parts))))))
   :disjClasses (loop [parts (ont/toSyntacticEquivalent axiom) 
                       [ontology model] [ontology model]]
                (if (empty? parts) 
                 [ontology model] 
                 (recur (rest parts) (process [ontology model] (first parts)))))
   :disjOr (loop [parts (ont/toSyntacticEquivalent axiom) 
                  [ontology model] [ontology model]]
           (if (empty? parts) 
            [ontology model]
            (recur (rest parts) (process [ontology model] (first parts)))))

   ;TODO role axioms
   :roleImplication (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :=roles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq set
   :disjRoles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :inverseRoles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq set
   :symmetricRole (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq
   :transitiveRole (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq
   :asymmetricRole (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   
   ;TODO data role axioms
   :dataRoleImplication (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :=dataRoles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq set
   :disjDataRoles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   
   ;facts
   :classFact (let [norm (norm/getCSNF (:class axiom))]
               (if (= (:innerType norm) :and)
                (loop [classes (:classes norm)
                       om [ontology model]]
                 (if (empty? classes)
                  om
                  (recur (rest classes) (process om (assoc axiom :class (first classes))))))
                (if (= (:innerType norm) :not)
                 [(ont/addAxiom ontology axiom) (update-in model [:facts norm] addThingToNoSet (:individual axiom))]
                 [(ont/addAxiom ontology axiom) (update-in model [:facts norm] addThingToYesSet (:individual axiom))])))
   :roleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:role axiom)] addThingToYesSet [(:fromIndividual axiom) (:toIndividual axiom)])]
   :notRoleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:role axiom)] addThingToNoSet [(:fromIndividual axiom) (:toIndividual axiom)])]
   :dataRoleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:dataRole axiom)] addThingToYesSet [(:fromIndividual axiom) (:toLiteral axiom)])]
   :notDataRoleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:dataRole axiom)] addThingToNoSet [(:fromIndividual axiom) (:toLiteral axiom)])]
   :=individuals [(ont/addAxiom ontology axiom) (update-in model [:facts :=] addThingToYesSet (:individuals axiom))]
   :!=individuals [(ont/addAxiom ontology axiom) (update-in model [:facts :=] addThingToNoSet (:individuals axiom))]

   ;TODO weird guys
   :declaration (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :newDataType (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :hasKey (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :annotationAxiom (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :dgRule (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :dlSafeRule (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :dgAxiom (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))))))
