/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.awt;

import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTAdapter;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.nativewindow.awt.AWTWindowClosingProtocol;
import javax.swing.MenuSelectionManager;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.newt.Debug;
import jogamp.newt.awt.event.AWTParentWindowAdapter;
import jogamp.newt.awt.event.NewtFactoryAWT;

public class NewtCanvasAWT
extends Canvas
implements WindowClosingProtocol {
    public static final boolean DEBUG = Debug.debug("Window");
    NativeWindow nativeWindow = null;
    Window newtChild = null;
    int newtChildCloseOp;
    AWTAdapter awtAdapter = null;
    private AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            NewtCanvasAWT.this.destroy();
        }
    });
    FocusAction focusAction = new FocusAction();
    WindowListener clearAWTMenusOnNewtFocus = new WindowAdapter(){

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    };
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public NewtCanvasAWT() {
    }

    public NewtCanvasAWT(Window window) {
        this.setNEWTChild(window);
    }

    NewtCanvasAWT setNEWTChild(Window window) {
        if (this.newtChild != window) {
            this.newtChild = window;
            if (null != this.nativeWindow) {
                Container container = AWTMisc.getContainer(this);
                this.reparentWindow(null != window, container);
            }
        }
        return this;
    }

    public Window getNEWTChild() {
        return this.newtChild;
    }

    public NativeWindow getNativeWindow() {
        return this.nativeWindow;
    }

    @Override
    public int getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public int setDefaultCloseOperation(int n) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(n);
    }

    void configureNewtChild(boolean bl) {
        if (null != this.awtAdapter) {
            this.awtAdapter.removeFrom(this);
            this.awtAdapter = null;
        }
        if (null != this.newtChild) {
            if (bl) {
                this.awtAdapter = new AWTParentWindowAdapter(this.newtChild).addTo(this);
                this.newtChild.addWindowListener(this.clearAWTMenusOnNewtFocus);
                this.newtChild.setFocusAction(this.focusAction);
                this.newtChildCloseOp = this.newtChild.setDefaultCloseOperation(0);
                this.awtWindowClosingProtocol.addClosingListenerOneShot();
            } else {
                this.newtChild.removeWindowListener(this.clearAWTMenusOnNewtFocus);
                this.newtChild.setFocusAction(null);
                this.newtChild.setDefaultCloseOperation(this.newtChildCloseOp);
                this.awtWindowClosingProtocol.removeClosingListener();
            }
        }
    }

    @Override
    public void addNotify() {
        this.disableBackgroundErase();
        super.addNotify();
        this.disableBackgroundErase();
        Container container = AWTMisc.getContainer(this);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.addNotify: " + this.newtChild + ", " + this + ", visible " + this.isVisible() + ", showing " + this.isShowing() + ", displayable " + this.isDisplayable() + " -> " + container);
        }
        this.reparentWindow(true, container);
    }

    @Override
    public void removeNotify() {
        Container container = AWTMisc.getContainer(this);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.removeNotify: " + this.newtChild + ", from " + container);
        }
        this.reparentWindow(false, container);
        super.removeNotify();
    }

    void reparentWindow(boolean bl, Container container) {
        if (null == this.newtChild) {
            return;
        }
        this.newtChild.setFocusAction(null);
        if (bl) {
            this.nativeWindow = NewtFactoryAWT.getNativeWindow(this, this.newtChild.getRequestedCapabilities());
            if (null != this.nativeWindow) {
                if (DEBUG) {
                    System.err.println("NewtCanvasAWT.reparentWindow: " + this.newtChild);
                }
                int n = container.getWidth();
                int n2 = container.getHeight();
                this.setSize(n, n2);
                this.newtChild.setSize(n, n2);
                this.newtChild.reparentWindow(this.nativeWindow);
                this.newtChild.setVisible(true);
                this.configureNewtChild(true);
                this.newtChild.sendWindowEvent(100);
                this.newtChild.windowRepaint(0, 0, n, n2);
            }
        } else {
            this.configureNewtChild(false);
            this.nativeWindow = null;
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null);
        }
    }

    public final void destroy() {
        if (null != this.newtChild) {
            Container container = AWTMisc.getContainer(this);
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.destroy(): " + this.newtChild + ", from " + container);
            }
            this.configureNewtChild(false);
            this.nativeWindow = null;
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null);
            this.newtChild.destroy();
            this.newtChild = null;
            if (null != container) {
                container.remove(this);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.awtWindowClosingProtocol.addClosingListenerOneShot();
        if (null != this.newtChild) {
            this.newtChild.windowRepaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.awtWindowClosingProtocol.addClosingListenerOneShot();
        if (null != this.newtChild) {
            this.newtChild.windowRepaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    final void requestFocusAWTParent() {
        super.requestFocusInWindow();
    }

    final void requestFocusNEWTChild() {
        if (null != this.newtChild) {
            this.newtChild.setFocusAction(null);
            this.newtChild.requestFocus();
            this.newtChild.setFocusAction(this.focusAction);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.requestFocusNEWTChild();
    }

    @Override
    public boolean requestFocus(boolean bl) {
        boolean bl2 = super.requestFocus(bl);
        if (bl2) {
            this.requestFocusNEWTChild();
        }
        return bl2;
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (bl) {
            this.requestFocusNEWTChild();
        }
        return bl;
    }

    @Override
    public boolean requestFocusInWindow(boolean bl) {
        boolean bl2 = super.requestFocusInWindow(bl);
        if (bl2) {
            this.requestFocusNEWTChild();
        }
        return bl2;
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = NewtCanvasAWT.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", Canvas.class);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (DEBUG) {
                System.err.println("NewtCanvasAWT: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (DEBUG) {
                System.err.println("NewtCanvasAWT: TK disableBackgroundErase error: " + exception);
            }
        }
    }

    class FocusAction
    implements Window.FocusRunnable {
        FocusActionImpl focusActionImpl = new FocusActionImpl();

        FocusAction() {
        }

        @Override
        public boolean run() {
            if (EventQueue.isDispatchThread()) {
                this.focusActionImpl.run();
            } else {
                try {
                    EventQueue.invokeAndWait(this.focusActionImpl);
                }
                catch (Exception exception) {
                    throw new NativeWindowException(exception);
                }
            }
            return this.focusActionImpl.result;
        }

        class FocusActionImpl
        implements Runnable {
            public final boolean result = false;

            FocusActionImpl() {
            }

            @Override
            public void run() {
                if (DEBUG) {
                    System.err.println("FocusActionImpl.run() " + Display.getThreadName());
                }
                NewtCanvasAWT.this.requestFocusAWTParent();
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.clearGlobalFocusOwner();
            }
        }
    }
}

