/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.util.AnimatorBase;
import javax.media.opengl.GLAutoDrawable;

public class Animator
extends AnimatorBase {
    protected ThreadGroup threadGroup;
    private Runnable runnable;
    private boolean runAsFastAsPossible;
    protected boolean isAnimating;
    protected boolean pauseIssued;
    protected volatile boolean stopIssued;
    Condition waitForStartedCondition = new WaitForStartedCondition();
    Condition waitForStoppedCondition = new WaitForStoppedCondition();
    Condition waitForPausedCondition = new WaitForPausedCondition();
    Condition waitForResumeCondition = new WaitForResumeCondition();

    public Animator() {
        if (DEBUG) {
            System.err.println("Animator created");
        }
    }

    public Animator(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        if (DEBUG) {
            System.err.println("Animator created, ThreadGroup: " + this.threadGroup);
        }
    }

    public Animator(GLAutoDrawable gLAutoDrawable) {
        this.add(gLAutoDrawable);
    }

    public Animator(ThreadGroup threadGroup, GLAutoDrawable gLAutoDrawable) {
        this(threadGroup);
        this.add(gLAutoDrawable);
    }

    @Override
    protected String getBaseName(String string) {
        return string + "Animator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRunAsFastAsPossible(boolean bl) {
        this.stateSync.lock();
        try {
            this.runAsFastAsPossible = bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setIsAnimatingSynced(boolean bl) {
        this.stateSync.lock();
        try {
            this.isAnimating = bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    private final boolean isStartedImpl() {
        return this.animThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isStarted() {
        this.stateSync.lock();
        try {
            boolean bl = this.animThread != null;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    private final boolean isAnimatingImpl() {
        return this.animThread != null && this.isAnimating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isAnimating() {
        this.stateSync.lock();
        try {
            boolean bl = this.animThread != null && this.isAnimating;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    private final boolean isPausedImpl() {
        return this.animThread != null && this.pauseIssued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isPaused() {
        this.stateSync.lock();
        try {
            boolean bl = this.animThread != null && this.pauseIssued;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    private synchronized void finishLifecycleAction(Condition condition) {
        boolean bl;
        boolean bl2 = bl = !this.impl.skipWaitForCompletion(this.animThread);
        if (bl) {
            while (condition.result()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (DEBUG) {
            System.err.println("finishLifecycleAction(" + condition.getClass().getName() + "): finished - waited " + bl + ", started: " + this.isStartedImpl() + ", animating: " + this.isAnimatingImpl() + ", paused: " + this.isPausedImpl() + ", drawables " + this.drawables.size());
        }
    }

    @Override
    public synchronized boolean start() {
        if (this.isStartedImpl()) {
            return false;
        }
        if (this.runnable == null) {
            this.runnable = new MainLoop();
        }
        this.fpsCounter.resetFPSCounter();
        String string = Thread.currentThread().getName() + "-" + this.baseName;
        Thread thread = null == this.threadGroup ? new Thread(this.runnable, string) : new Thread(this.threadGroup, this.runnable, string);
        thread.start();
        this.finishLifecycleAction(this.waitForStartedCondition);
        return true;
    }

    @Override
    public synchronized boolean stop() {
        if (!this.isStartedImpl()) {
            return false;
        }
        this.stopIssued = true;
        this.notifyAll();
        this.finishLifecycleAction(this.waitForStoppedCondition);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean pause() {
        if (!this.isStartedImpl() || this.pauseIssued) {
            return false;
        }
        this.stateSync.lock();
        try {
            this.pauseIssued = true;
        }
        finally {
            this.stateSync.unlock();
        }
        this.notifyAll();
        this.finishLifecycleAction(this.waitForPausedCondition);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean resume() {
        if (!this.isStartedImpl() || !this.pauseIssued) {
            return false;
        }
        this.stateSync.lock();
        try {
            this.pauseIssued = false;
        }
        finally {
            this.stateSync.unlock();
        }
        this.notifyAll();
        this.finishLifecycleAction(this.waitForResumeCondition);
        return true;
    }

    static interface Condition {
        public boolean result();
    }

    class MainLoop
    implements Runnable {
        MainLoop() {
        }

        public String toString() {
            return "[started " + Animator.this.isStartedImpl() + ", animating " + Animator.this.isAnimatingImpl() + ", paused " + Animator.this.isPausedImpl() + ", drawable " + Animator.this.drawables.size() + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Animator animator;
            try {
                animator = Animator.this;
                synchronized (animator) {
                    if (AnimatorBase.DEBUG) {
                        System.err.println("Animator start:" + Thread.currentThread() + ": " + this.toString());
                    }
                    Animator.this.fpsCounter.resetFPSCounter();
                    Animator.this.animThread = Thread.currentThread();
                    Animator.this.setIsAnimatingSynced(false);
                    Animator.this.notifyAll();
                }
                while (!Animator.this.stopIssued) {
                    animator = Animator.this;
                    synchronized (animator) {
                        while (!Animator.this.stopIssued && (Animator.this.pauseIssued || Animator.this.drawablesEmpty)) {
                            boolean bl = Animator.this.pauseIssued;
                            if (AnimatorBase.DEBUG) {
                                System.err.println("Animator pause:" + Thread.currentThread() + ": " + this.toString());
                            }
                            Animator.this.setIsAnimatingSynced(false);
                            Animator.this.notifyAll();
                            try {
                                Animator.this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!bl) continue;
                            Animator.this.fpsCounter.resetFPSCounter();
                            if (!AnimatorBase.DEBUG) continue;
                            System.err.println("Animator resume:" + Thread.currentThread() + ": " + this.toString());
                        }
                        if (!Animator.this.stopIssued && !Animator.this.isAnimating) {
                            Animator.this.setIsAnimatingSynced(true);
                            Animator.this.notifyAll();
                        }
                    }
                    if (!Animator.this.stopIssued) {
                        Animator.this.display();
                    }
                    if (Animator.this.stopIssued || Animator.this.runAsFastAsPossible) continue;
                    Thread.yield();
                }
            }
            finally {
                animator = Animator.this;
                synchronized (animator) {
                    if (AnimatorBase.DEBUG) {
                        System.err.println("Animator stop " + Thread.currentThread() + ": " + this.toString());
                    }
                    Animator.this.stopIssued = false;
                    Animator.this.pauseIssued = false;
                    Animator.this.animThread = null;
                    Animator.this.setIsAnimatingSynced(false);
                    Animator.this.notifyAll();
                }
            }
        }
    }

    private class WaitForPausedCondition
    implements Condition {
        private WaitForPausedCondition() {
        }

        @Override
        public boolean result() {
            return Animator.this.isAnimating && Animator.this.isStartedImpl();
        }
    }

    private class WaitForResumeCondition
    implements Condition {
        private WaitForResumeCondition() {
        }

        @Override
        public boolean result() {
            return !Animator.this.drawablesEmpty && !Animator.this.isAnimating && Animator.this.isStartedImpl();
        }
    }

    private class WaitForStartedCondition
    implements Condition {
        private WaitForStartedCondition() {
        }

        @Override
        public boolean result() {
            return !Animator.this.isStartedImpl() || !Animator.this.drawablesEmpty && !Animator.this.isAnimating;
        }
    }

    private class WaitForStoppedCondition
    implements Condition {
        private WaitForStoppedCondition() {
        }

        @Override
        public boolean result() {
            return Animator.this.isStartedImpl();
        }
    }
}

